# Presidential Debate at Hofstra University in Hempstead, New York

**Date:** September 26, 2016
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-hofstra-university-hempstead-new-york-0

---

PARTICIPANTS:Former Secretary of State Hillary Clinton (D); andBusinessman Donald Trump (R) MODERATOR:Lester Holt (NBC News) HOLT: Good evening from Hofstra University in Hempstead, New York. I'm Lester Holt, anchor of "NBC Nightly News." I want to welcome you to the first presidential debate. The participants tonight are Donald Trump and Hillary Clinton. This debate is sponsored by the Commission on Presidential Debates, a nonpartisan, nonprofit organization. The commission drafted tonight's format, and the rules have been agreed to by the campaigns. The 90-minute debate is divided into six segments, each 15 minutes long. We'll explore three topic areas tonight: Achieving prosperity; America's direction; and securing America. At the start of each segment, I will ask the same lead-off question to both candidates, and they will each have up to two minutes to respond. From that point until the end of the segment, we'll have an open discussion. The questions are mine and have not been shared with the commission or the campaigns. The audience here in the room has agreed to remain silent so that we can focus on what the candidates are saying. I will invite you to applaud, however, at this moment, as we welcome the candidates: Democratic nominee for president of the United States, Hillary Clinton, and Republican nominee for president of the United States, Donald J. Trump. [applause] CLINTON: How are you, Donald? [applause] HOLT: Good luck to you. [applause] Well, I don't expect us to cover all the issues of this campaign tonight, but I remind everyone, there are two more presidential debates scheduled. We are going to focus on many of the issues that voters tell us are most important, and we're going to press for specifics. I am honored to have this role, but this evening belongs to the candidates and, just as important, to the American people. Candidates, we look forward to hearing you articulate your policies and your positions, as well as your visions and your values. So, let's begin. We're calling this opening segment "Achieving Prosperity." And central to that is jobs. There are two economic realities in America today. There's been a record six straight years of job growth, and new census numbers show incomes have increased at a record rate after years of stagnation. However, income inequality remains significant, and nearly half of Americans are living paycheck to paycheck. Beginning with you, Secretary Clinton, why are you a better choice than your opponent to create the kinds of jobs that will put more money into the pockets of American works? CLINTON: Well, thank you, Lester, and thanks to Hofstra for hosting us. The central question in this election is really what kind of country we want to be and what kind of future we'll build together. Today is my granddaughter's second birthday, so I think about this a lot. First, we have to build an economy that works for everyone, not just those at the top. That means we need new jobs, good jobs, with rising incomes. I want us to invest in you. I want us to invest in your future. That means jobs in infrastructure, in advanced manufacturing, innovation and technology, clean, renewable energy, and small business, because most of the new jobs will come from small business. We also have to make the economy fairer. That starts with raising the national minimum wage and also guarantee, finally, equal pay for women's work. I also want to see more companies do profit-sharing. If you help create the profits, you should be able to share in them, not just the executives at the top. And I want us to do more to support people who are struggling to balance family and work. I've heard from so many of you about the difficult choices you face and the stresses that you're under. So let's have paid family leave, earned sick days. Let's be sure we have affordable child care and debt-free college. How are we going to do it? We're going to do it by having the wealthy pay their fair share and close the corporate loopholes. Finally, we tonight are on the stage together, Donald Trump and I. Donald, it's good to be with you. We're going to have a debate where we are talking about the important issues facing our country. You have to judge us, who can shoulder the immense, awesome responsibilities of the presidency, who can put into action the plans that will make your life better. I hope that I will be able to earn your vote on November 8th. HOLT: Secretary Clinton, thank you. Mr. Trump, the same question to you. It's about putting money—more money into the pockets of American workers. You have up to two minutes. TRUMP: Thank you, Lester. Our jobs are fleeing the country. They're going to Mexico. They're going to many other countries. You look at what China is doing to our country in terms of making our product. They're devaluing their currency, and there's nobody in our government to fight them. And we have a very good fight. And we have a winning fight. Because they're using our country as a piggy bank to rebuild China, and many other countries are doing the same thing. So we're losing our good jobs, so many of them. When you look at what's happening in Mexico, a friend of mine who builds plants said it's the eighth wonder of the world. They're building some of the biggest plants anywhere in the world, some of the most sophisticated, some of the best plants. With the United States, as he said, not so much. So Ford is leaving. You see that, their small car division leaving. Thousands of jobs leaving Michigan, leaving Ohio. They're all leaving. And we can't allow it to happen anymore. As far as child care is concerned and so many other things, I think Hillary and I agree on that. We probably disagree a little bit as to numbers and amounts and what we're going to do, but perhaps we'll be talking about that later. But we have to stop our jobs from being stolen from us. We have to stop our companies from leaving the United States and, with it, firing all of their people. All you have to do is take a look at Carrier air conditioning in Indianapolis. They left—fired 1,400 people. They're going to Mexico. So many hundreds and hundreds of companies are doing this. We cannot let it happen. Under my plan, I'll be reducing taxes tremendously, from 35 percent to 15 percent for companies, small and big businesses. That's going to be a job creator like we haven't seen since Ronald Reagan. It's going to be a beautiful thing to watch. Companies will come. They will build. They will expand. New companies will start. And I look very, very much forward to doing it. We have to renegotiate our trade deals, and we have to stop these countries from stealing our companies and our jobs. HOLT: Secretary Clinton, would you like to respond? CLINTON: Well, I think that trade is an important issue. Of course, we are 5 percent of the world's population; we have to trade with the other 95 percent. And we need to have smart, fair trade deals. We also, though, need to have a tax system that rewards work and not just financial transactions. And the kind of plan that Donald has put forth would be trickle-down economics all over again. In fact, it would be the most extreme version, the biggest tax cuts for the top percent of the people in this country than we've ever had. I call it trumped-up trickle-down, because that's exactly what it would be. That is not how we grow the economy. We just have a different view about what's best for growing the economy, how we make investments that will actually produce jobs and rising incomes. I think we come at it from somewhat different perspectives. I understand that. You know, Donald was very fortunate in his life, and that's all to his benefit. He started his business with $14 million, borrowed from his father, and he really believes that the more you help wealthy people, the better off we'll be and that everything will work out from there. I don't buy that. I have a different experience. My father was a small-businessman. He worked really hard. He printed drapery fabrics on long tables, where he pulled out those fabrics and he went down with a silkscreen and dumped the paint in and took the squeegee and kept going. And so what I believe is the more we can do for the middle class, the more we can invest in you, your education, your skills, your future, the better we will be off and the better we'll grow. That's the kind of economy I want us to see again. HOLT: Let me follow up with Mr. Trump, if you can. You've talked about creating 25 million jobs, and you've promised to bring back millions of jobs for Americans. How are you going to bring back the industries that have left this country for cheaper labor overseas? How, specifically, are you going to tell American manufacturers that you have to come back? TRUMP: Well, for one thing—and before we start on that—my father gave me a very small loan in 1975, and I built it into a company that's worth many, many billions of dollars, with some of the greatest assets in the world, and I say that only because that's the kind of thinking that our country needs. Our country's in deep trouble. We don't know what we're doing when it comes to devaluations and all of these countries all over the world, especially China. They're the best, the best ever at it. What they're doing to us is a very, very sad thing. So we have to do that. We have to renegotiate our trade deals. And, Lester, they're taking our jobs, they're giving incentives, they're doing things that, frankly, we don't do. Let me give you the example of Mexico. They have a VAT tax. We're on a different system. When we sell into Mexico, there's a tax. When they sell in—automatic, 16 percent, approximately. When they sell into us, there's no tax. It's a defective agreement. It's been defective for a long time, many years, but the politicians haven't done anything about it. Now, in all fairness to Secretary Clinton—yes, is that OK? Good. I want you to be very happy. It's very important to me. But in all fairness to Secretary Clinton, when she started talking about this, it was really very recently. She's been doing this for 30 years. And why hasn't she made the agreements better? The NAFTA agreement is defective. Just because of the tax and many other reasons, but just because of the fact... HOLT: Let me interrupt just a moment, but... TRUMP: Secretary Clinton and others, politicians, should have been doing this for years, not right now, because of the fact that we've created a movement. They should have been doing this for years. What's happened to our jobs and our country and our economy generally is—look, we owe $20 trillion. We cannot do it any longer, Lester. HOLT: Back to the question, though. How do you bring back—specifically bring back jobs, American manufacturers? How do you make them bring the jobs back? TRUMP: Well, the first thing you do is don't let the jobs leave. The companies are leaving. I could name, I mean, there are thousands of them. They're leaving, and they're leaving in bigger numbers than ever. And what you do is you say, fine, you want to go to Mexico or some other country, good luck. We wish you a lot of luck. But if you think you're going to make your air conditioners or your cars or your cookies or whatever you make and bring them into our country without a tax, you're wrong. And once you say you're going to have to tax them coming in, and our politicians never do this, because they have special interests and the special interests want those companies to leave, because in many cases, they own the companies. So what I'm saying is, we can stop them from leaving. We have to stop them from leaving. And that's a big, big factor. HOLT: Let me let Secretary Clinton get in here. CLINTON: Well, let's stop for a second and remember where we were eight years ago. We had the worst financial crisis, the Great Recession, the worst since the 1930s. That was in large part because of tax policies that slashed taxes on the wealthy, failed to invest in the middle class, took their eyes off of Wall Street, and created a perfect storm. In fact, Donald was one of the people who rooted for the housing crisis. He said, back in 2006, "Gee, I hope it does collapse, because then I can go in and buy some and make some money." Well, it did collapse. TRUMP: That's called business, by the way. CLINTON: Nine million people—nine million people lost their jobs. Five million people lost their homes. And $13 trillion in family wealth was wiped out. Now, we have come back from that abyss. And it has not been easy. So we're now on the precipice of having a potentially much better economy, but the last thing we need to do is to go back to the policies that failed us in the first place. Independent experts have looked at what I've proposed and looked at what Donald's proposed, and basically they've said this, that if his tax plan, which would blow up the debt by over $5 trillion and would in some instances disadvantage middle-class families compared to the wealthy, were to go into effect, we would lose 3.5 million jobs and maybe have another recession. They've looked at my plans and they've said, OK, if we can do this, and I intend to get it done, we will have 10 million more new jobs, because we will be making investments where we can grow the economy. Take clean energy. Some country is going to be the clean- energy superpower of the 21st century. Donald thinks that climate change is a hoax perpetrated by the Chinese. I think it's real. TRUMP: I did not. I did not. I do not say that. CLINTON: I think science is real. TRUMP: I do not say that. CLINTON: And I think it's important that we grip this and deal with it, both at home and abroad. And here's what we can do. We can deploy a half a billion more solar panels. We can have enough clean energy to power every home. We can build a new modern electric grid. That's a lot of jobs; that's a lot of new economic activity. So I've tried to be very specific about what we can and should do, and I am determined that we're going to get the economy really moving again, building on the progress we've made over the last eight years, but never going back to what got us in trouble in the first place. HOLT: Mr. Trump? TRUMP: She talks about solar panels. We invested in a solar company, our country. That was a disaster. They lost plenty of money on that one. Now, look, I'm a great believer in all forms of energy, but we're putting a lot of people out of work. Our energy policies are a disaster. Our country is losing so much in terms of energy, in terms of paying off our debt. You can't do what you're looking to do with $20 trillion in debt. The Obama administration, from the time they've come in, is over 230 years' worth of debt, and he's topped it. He's doubled it in a course of almost eight years, seven-and-a-half years, to be semi- exact. So I will tell you this. We have to do a much better job at keeping our jobs. And we have to do a much better job at giving companies incentives to build new companies or to expand, because they're not doing it. And all you have to do is look at Michigan and look at Ohio and look at all of these places where so many of their jobs and their companies are just leaving, they're gone. And, Hillary, I'd just ask you this. You've been doing this for 30 years. Why are you just thinking about these solutions right now? For 30 years, you've been doing it, and now you're just starting to think of solutions. CLINTON: Well, actually... TRUMP: I will bring—excuse me. I will bring back jobs. You can't bring back jobs. CLINTON: Well, actually, I have thought about this quite a bit. TRUMP: Yeah, for 30 years. CLINTON: And I have—well, not quite that long. I think my husband did a pretty good job in the 1990s. I think a lot about what worked and how we can make it work again... TRUMP: Well, he approved NAFTA... [crosstalk] CLINTON: ... million new jobs, a balanced budget... TRUMP: He approved NAFTA, which is the single worst trade deal ever approved in this country. CLINTON: Incomes went up for everybody. Manufacturing jobs went up also in the 1990s, if we're actually going to look at the facts. When I was in the Senate, I had a number of trade deals that came before me, and I held them all to the same test. Will they create jobs in America? Will they raise incomes in America? And are they good for our national security? Some of them I voted for. The biggest one, a multinational one known as CAFTA, I voted against. And because I hold the same standards as I look at all of these trade deals. But let's not assume that trade is the only challenge we have in the economy. I think it is a part of it, and I've said what I'm going to do. I'm going to have a special prosecutor. We're going to enforce the trade deals we have, and we're going to hold people accountable. When I was secretary of state, we actually increased American exports globally 30 percent. We increased them to China 50 percent. So I know how to really work to get new jobs and to get exports that helped to create more new jobs. HOLT: Very quickly... TRUMP: But you haven't done it in 30 years or 26 years or any number you want to... CLINTON: Well, I've been a senator, Donald... TRUMP: You haven't done it. You haven't done it. CLINTON: And I have been a secretary of state... TRUMP: Excuse me. CLINTON: And I have done a lot... TRUMP: Your husband signed NAFTA, which was one of the worst things that ever happened to the manufacturing industry. CLINTON: Well, that's your opinion. That is your opinion. TRUMP: You go to New England, you go to Ohio, Pennsylvania, you go anywhere you want, Secretary Clinton, and you will see devastation where manufacture is down 30, 40, sometimes 50 percent. NAFTA is the worst trade deal maybe ever signed anywhere, but certainly ever signed in this country. And now you want to approve Trans-Pacific Partnership. You were totally in favor of it. Then you heard what I was saying, how bad it is, and you said, I can't win that debate. But you know that if you did win, you would approve that, and that will be almost as bad as NAFTA. Nothing will ever top NAFTA. CLINTON: Well, that is just not accurate. I was against it once it was finally negotiated and the terms were laid out. I wrote about that in... TRUMP: You called it the gold standard. [crosstalk] TRUMP: You called it the gold standard of trade deals. You said it's the finest deal you've ever seen. CLINTON: No. TRUMP: And then you heard what I said about it, and all of a sudden you were against it. CLINTON: Well, Donald, I know you live in your own reality, but that is not the facts. The facts are—I did say I hoped it would be a good deal, but when it was negotiated... TRUMP: Not. CLINTON: ... which I was not responsible for, I concluded it wasn't. I wrote about that in my book... TRUMP: So is it President Obama's fault? CLINTON: ... before you even announced. TRUMP: Is it President Obama's fault? CLINTON: Look, there are differences... TRUMP: Secretary, is it President Obama's fault? CLINTON: There are... TRUMP: Because he's pushing it. CLINTON: There are different views about what's good for our country, our economy, and our leadership in the world. And I think it's important to look at what we need to do to get the economy going again. That's why I said new jobs with rising incomes, investments, not in more tax cuts that would add $5 trillion to the debt. TRUMP: But you have no plan. CLINTON: But in—oh, but I do. TRUMP: Secretary, you have no plan. CLINTON: In fact, I have written a book about it. It's called "Stronger Together." You can pick it up tomorrow at a bookstore... TRUMP: That's about all you've... [crosstalk] HOLT: Folks, we're going to... CLINTON: ... or at an airport near you. HOLT: We're going to move to... CLINTON: But it's because I see this—we need to have strong growth, fair growth, sustained growth. We also have to look at how we help families balance the responsibilities at home and the responsibilities at business. So we have a very robust set of plans. And people have looked at both of our plans, have concluded that mine would create 10 million jobs and yours would lose us 3.5 million jobs, and explode the debt which would have a recession. TRUMP: You are going to approve one of the biggest tax cuts in history. You are going to approve one of the biggest tax increases in history. You are going to drive business out. Your regulations are a disaster, and you're going to increase regulations all over the place. And by the way, my tax cut is the biggest since Ronald Reagan. I'm very proud of it. It will create tremendous numbers of new jobs. But regulations, you are going to regulate these businesses out of existence. When I go around—Lester, I tell you this, I've been all over. And when I go around, despite the tax cut, the thing—the things that business as in people like the most is the fact that I'm cutting regulation. You have regulations on top of regulations, and new companies cannot form and old companies are going out of business. And you want to increase the regulations and make them even worse. I'm going to cut regulations. I'm going to cut taxes big league, and you're going to raise taxes big league, end of story. HOLT: Let me get you to pause right there, because we're going to move into—we're going to move into the next segment. We're going to talk taxes... CLINTON: That can't—that can't be left to stand. HOLT: Please just take 30 seconds and then we're going to go on. CLINTON: I kind of assumed that there would be a lot of these charges and claims, and so... TRUMP: Facts. CLINTON: So we have taken the home page of my website, HillaryClinton.com, and we've turned it into a fact-checker. So if you want to see in real-time what the facts are, please go and take a look. Because what I have proposed... TRUMP: And take a look at mine, also, and you'll see. CLINTON: ... would not add a penny to the debt, and your plans would add $5 trillion to the debt. What I have proposed would cut regulations and streamline them for small businesses. What I have proposed would be paid for by raising taxes on the wealthy, because they have made all the gains in the economy. And I think it's time that the wealthy and corporations paid their fair share to support this country. HOLT: Well, you just opened the next segment. TRUMP: Well, could I just finish—I think I... [crosstalk] HOLT: I'm going to give you a chance right here... TRUMP: I think I should—you go to her website, and you take a look at her website. HOLT: ... with a new 15-minute segment... TRUMP: She's going to raise taxes $1.3 trillion. HOLT: Mr. Trump, I'm going to... TRUMP: And look at her website. You know what? It's no difference than this. She's telling us how to fight ISIS. Just go to her website. She tells you how to fight ISIS on her website. I don't think General Douglas MacArthur would like that too much. HOLT: The next segment, we're continuing... CLINTON: Well, at least I have a plan to fight ISIS. HOLT: ... achieving prosperity... TRUMP: No, no, you're telling the enemy everything you want to do. CLINTON: No, we're not. No, we're not. TRUMP: See, you're telling the enemy everything you want to do. No wonder you've been fighting—no wonder you've been fighting ISIS your entire adult life. CLINTON: That's a—that's—go to the—please, fact checkers, get to work. HOLT: OK, you are unpacking a lot here. And we're still on the issue of achieving prosperity. And I want to talk about taxes. The fundamental difference between the two of you concerns the wealthy. Secretary Clinton, you're calling for a tax increase on the wealthiest Americans. I'd like you to further defend that. And, Mr. Trump, you're calling for tax cuts for the wealthy. I'd like you to defend that. And this next two-minute answer goes to you, Mr. Trump. TRUMP: Well, I'm really calling for major jobs, because the wealthy are going create tremendous jobs. They're going to expand their companies. They're going to do a tremendous job. I'm getting rid of the carried interest provision. And if you really look, it's not a tax—it's really not a great thing for the wealthy. It's a great thing for the middle class. It's a great thing for companies to expand. And when these people are going to put billions and billions of dollars into companies, and when they're going to bring $2.5 trillion back from overseas, where they can't bring the money back, because politicians like Secretary Clinton won't allow them to bring the money back, because the taxes are so onerous, and the bureaucratic red tape, so what—is so bad. So what they're doing is they're leaving our country, and they're, believe it or not, leaving because taxes are too high and because some of them have lots of money outside of our country. And instead of bringing it back and putting the money to work, because they can't work out a deal to—and everybody agrees it should be brought back. Instead of that, they're leaving our country to get their money, because they can't bring their money back into our country, because of bureaucratic red tape, because they can't get together. Because we have—we have a president that can't sit them around a table and get them to approve something. And here's the thing. Republicans and Democrats agree that this should be done, $2.5 trillion. I happen to think it's double that. It's probably $5 trillion that we can't bring into our country, Lester. And with a little leadership, you'd get it in here very quickly, and it could be put to use on the inner cities and lots of other things, and it would be beautiful. But we have no leadership. And honestly, that starts with Secretary Clinton. HOLT: All right. You have two minutes of the same question to defend tax increases on the wealthiest Americans, Secretary Clinton. CLINTON: I have a feeling that by, the end of this evening, I'm going to be blamed for everything that's ever happened. TRUMP: Why not? CLINTON: Why not? Yeah, why not? [laughter] You know, just join the debate by saying more crazy things. Now, let me say this, it is absolutely the case... TRUMP: There's nothing crazy about not letting our companies bring their money back into their country. HOLT: This is—this is Secretary Clinton's two minutes, please. TRUMP: Yes. CLINTON: Yeah, well, let's start the clock again, Lester. We've looked at your tax proposals. I don't see changes in the corporate tax rates or the kinds of proposals you're referring to that would cause the repatriation, bringing back of money that's stranded overseas. I happen to support that. TRUMP: Then you didn't read it. CLINTON: I happen to—I happen to support that in a way that will actually work to our benefit. But when I look at what you have proposed, you have what is called now the Trump loophole, because it would so advantage you and the business you do. You've proposed an approach that has a... TRUMP: Who gave it that name? The first I've—who gave it that name? [crosstalk] HOLT: Mr. Trump, this is Secretary Clinton's two minutes. CLINTON: ... $4 billion tax benefit for your family. And when you look at what you are proposing... TRUMP: How much? How much for my family? CLINTON: ... it is... TRUMP: Lester, how much? CLINTON: ... as I said, trumped-up trickle-down. Trickle-down did not work. It got us into the mess we were in, in 2008 and 2009. Slashing taxes on the wealthy hasn't worked. And a lot of really smart, wealthy people know that. And they are saying, hey, we need to do more to make the contributions we should be making to rebuild the middle class. I don't think top-down works in America. I think building the middle class, investing in the middle class, making college debt-free so more young people can get their education, helping people refinance their—their debt from college at a lower rate. Those are the kinds of things that will really boost the economy. Broad-based, inclusive growth is what we need in America, not more advantages for people at the very top. HOLT: Mr. Trump, we're... TRUMP: Typical politician. All talk, no action. Sounds good, doesn't work. Never going to happen. Our country is suffering because people like Secretary Clinton have made such bad decisions in terms of our jobs and in terms of what's going on. Now, look, we have the worst revival of an economy since the Great Depression. And believe me: We're in a bubble right now. And the only thing that looks good is the stock market, but if you raise interest rates even a little bit, that's going to come crashing down. We are in a big, fat, ugly bubble. And we better be awfully careful. And we have a Fed that's doing political things. This Janet Yellen of the Fed. The Fed is doing political—by keeping the interest rates at this level. And believe me: The day Obama goes off, and he leaves, and goes out to the golf course for the rest of his life to play golf, when they raise interest rates, you're going to see some very bad things happen, because the Fed is not doing their job. The Fed is being more political than Secretary Clinton. HOLT: Mr. Trump, we're talking about the burden that Americans have to pay, yet you have not released your tax returns. And the reason nominees have released their returns for decades is so that voters will know if their potential president owes money to—who he owes it to and any business conflicts. Don't Americans have a right to know if there are any conflicts of interest? TRUMP: I don't mind releasing—I'm under a routine audit. And it'll be released. And—as soon as the audit's finished, it will be released. But you will learn more about Donald Trump by going down to the federal elections, where I filed a 104-page essentially financial statement of sorts, the forms that they have. It shows income—in fact, the income—I just looked today—the income is filed at $694 million for this past year, $694 million. If you would have told me I was going to make that 15 or 20 years ago, I would have been very surprised. But that's the kind of thinking that our country needs. When we have a country that's doing so badly, that's being ripped off by every single country in the world, it's the kind of thinking that our country needs, because everybody—Lester, we have a trade deficit with all of the countries that we do business with, of almost $800 billion a year. You know what that is? That means, who's negotiating these trade deals? We have people that are political hacks negotiating our trade deals. HOLT: The IRS says an audit... TRUMP: Excuse me. HOLT: ... of your taxes—you're perfectly free to release your taxes during an audit. And so the question, does the public's right to know outweigh your personal... TRUMP: Well, I told you, I will release them as soon as the audit. Look, I've been under audit almost for 15 years. I know a lot of wealthy people that have never been audited. I said, do you get audited? I get audited almost every year. And in a way, I should be complaining. I'm not even complaining. I don't mind it. It's almost become a way of life. I get audited by the IRS. But other people don't. I will say this. We have a situation in this country that has to be taken care of. I will release my tax returns—against my lawyer's wishes—when she releases her 33,000 e-mails that have been deleted. As soon as she releases them, I will release. [applause] I will release my tax returns. And that's against—my lawyers, they say, "Don't do it." I will tell you this. No—in fact, watching shows, they're reading the papers. Almost every lawyer says, you don't release your returns until the audit's complete. When the audit's complete, I'll do it. But I would go against them if she releases her e-mails. HOLT: So it's negotiable? TRUMP: It's not negotiable, no. Let her release the e-mails. Why did she delete 33,000... HOLT: Well, I'll let her answer that. But let me just admonish the audience one more time. There was an agreement. We did ask you to be silent, so it would be helpful for us. Secretary Clinton? CLINTON: Well, I think you've seen another example of bait-and- switch here. For 40 years, everyone running for president has released their tax returns. You can go and see nearly, I think, 39, 40 years of our tax returns, but everyone has done it. We know the IRS has made clear there is no prohibition on releasing it when you're under audit. So you've got to ask yourself, why won't he release his tax returns? And I think there may be a couple of reasons. First, maybe he's not as rich as he says he is. Second, maybe he's not as charitable as he claims to be. Third, we don't know all of his business dealings, but we have been told through investigative reporting that he owes about $650 million to Wall Street and foreign banks. Or maybe he doesn't want the American people, all of you watching tonight, to know that he's paid nothing in federal taxes, because the only years that anybody's ever seen were a couple of years when he had to turn them over to state authorities when he was trying to get a casino license, and they showed he didn't pay any federal income tax. TRUMP: That makes me smart. CLINTON: So if he's paid zero, that means zero for troops, zero for vets, zero for schools or health. And I think probably he's not all that enthusiastic about having the rest of our country see what the real reasons are, because it must be something really important, even terrible, that he's trying to hide. And the financial disclosure statements, they don't give you the tax rate. They don't give you all the details that tax returns would. And it just seems to me that this is something that the American people deserve to see. And I have no reason to believe that he's ever going to release his tax returns, because there's something he's hiding. And we'll guess. We'll keep guessing at what it might be that he's hiding. But I think the question is, were he ever to get near the White House, what would be those conflicts? Who does he owe money to? Well, he owes you the answers to that, and he should provide them. HOLT: He also—he also raised the issue of your e-mails. Do you want to respond to that? CLINTON: I do. You know, I made a mistake using a private e- mail. TRUMP: That's for sure. CLINTON: And if I had to do it over again, I would, obviously, do it differently. But I'm not going to make any excuses. It was a mistake, and I take responsibility for that. HOLT: Mr. Trump? TRUMP: That was more than a mistake. That was done purposely. OK? That was not a mistake. That was done purposely. When you have your staff taking the Fifth Amendment, taking the Fifth so they're not prosecuted, when you have the man that set up the illegal server taking the Fifth, I think it's disgraceful. And believe me, this country thinks it's—really thinks it's disgraceful, also. As far as my tax returns, you don't learn that much from tax returns. That I can tell you. You learn a lot from financial disclosure. And you should go down and take a look at that. The other thing, I'm extremely underleveraged. The report that said $650—which, by the way, a lot of friends of mine that know my business say, boy, that's really not a lot of money. It's not a lot of money relative to what I had. The buildings that were in question, they said in the same report, which was—actually, it wasn't even a bad story, to be honest with you, but the buildings are worth $3.9 billion. And the $650 isn't even on that. But it's not $650. It's much less than that. But I could give you a list of banks, I would—if that would help you, I would give you a list of banks. These are very fine institutions, very fine banks. I could do that very quickly. I am very underleveraged. I have a great company. I have a tremendous income. And the reason I say that is not in a braggadocios way. It's because it's about time that this country had somebody running it that has an idea about money. When we have $20 trillion in debt, and our country's a mess, you know, it's one thing to have $20 trillion in debt and our roads are good and our bridges are good and everything's in great shape, our airports. Our airports are like from a third world country. You land at LaGuardia, you land at Kennedy, you land at LAX, you land at Newark, and you come in from Dubai and Qatar and you see these incredible—you come in from China, you see these incredible airports, and you land—we've become a third world country. So the worst of all things has happened. We owe $20 trillion, and we're a mess. We haven't even started. And we've spent $6 trillion in the Middle East, according to a report that I just saw. Whether it's 6 or 5, but it looks like it's 6, $6 trillion in the Middle East, we could have rebuilt our country twice. And it's really a shame. And it's politicians like Secretary Clinton that have caused this problem. Our country has tremendous problems. We're a debtor nation. We're a serious debtor nation. And we have a country that needs new roads, new tunnels, new bridges, new airports, new schools, new hospitals. And we don't have the money, because it's been squandered on so many of your ideas. HOLT: We'll let you respond and we'll move on to the next segment. CLINTON: And maybe because you haven't paid any federal income tax for a lot of years. [applause] And the other thing I think is important... TRUMP: It would be squandered, too, believe me. CLINTON: ... is if your—if your main claim to be president of the United States is your business, then I think we should talk about that. You know, your campaign manager said that you built a lot of businesses on the backs of little guys. And, indeed, I have met a lot of the people who were stiffed by you and your businesses, Donald. I've met dishwashers, painters, architects, glass installers, marble installers, drapery installers, like my dad was, who you refused to pay when they finished the work that you asked them to do. We have an architect in the audience who designed one of your clubhouses at one of your golf courses. It's a beautiful facility. It immediately was put to use. And you wouldn't pay what the man needed to be paid, what he was charging you to do... TRUMP: Maybe he didn't do a good job and I was unsatisfied with his work... CLINTON: Well, to... TRUMP: Which our country should do, too. CLINTON: Do the thousands of people that you have stiffed over the course of your business not deserve some kind of apology from someone who has taken their labor, taken the goods that they produced, and then refused to pay them? I can only say that I'm certainly relieved that my late father never did business with you. He provided a good middle-class life for us, but the people he worked for, he expected the bargain to be kept on both sides. And when we talk about your business, you've taken business bankruptcy six times. There are a lot of great businesspeople that have never taken bankruptcy once. You call yourself the King of Debt. You talk about leverage. You even at one time suggested that you would try to negotiate down the national debt of the United States. TRUMP: Wrong. Wrong. CLINTON: Well, sometimes there's not a direct transfer of skills from business to government, but sometimes what happened in business would be really bad for government. HOLT: Let's let Mr. Trump... CLINTON: And we need to be very clear about that. TRUMP: So, yeah, I think—I do think it's time. Look, it's all words, it's all sound bites. I built an unbelievable company. Some of the greatest assets anywhere in the world, real estate assets anywhere in the world, beyond the United States, in Europe, lots of different places. It's an unbelievable company. But on occasion, four times, we used certain laws that are there. And when Secretary Clinton talks about people that didn't get paid, first of all, they did get paid a lot, but taken advantage of the laws of the nation. Now, if you want to change the laws, you've been there a long time, change the laws. But I take advantage of the laws of the nation because I'm running a company. My obligation right now is to do well for myself, my family, my employees, for my companies. And that's what I do. But what she doesn't say is that tens of thousands of people that are unbelievably happy and that love me. I'll give you an example. We're just opening up on Pennsylvania Avenue right next to the White House, so if I don't get there one way, I'm going to get to Pennsylvania Avenue another. But we're opening the Old Post Office. Under budget, ahead of schedule, saved tremendous money. I'm a year ahead of schedule. And that's what this country should be doing. We build roads and they cost two and three and four times what they're supposed to cost. We buy products for our military and they come in at costs that are so far above what they were supposed to be, because we don't have people that know what they're doing. When we look at the budget, the budget is bad to a large extent because we have people that have no idea as to what to do and how to buy. The Trump International is way under budget and way ahead of schedule. And we should be able to do that for our country. HOLT: Well, we're well behind schedule, so I want to move to our next segment. We move into our next segment talking about America's direction. And let's start by talking about race. The share of Americans who say race relations are bad in this country is the highest it's been in decades, much of it amplified by shootings of African-Americans by police, as we've seen recently in Charlotte and Tulsa. Race has been a big issue in this campaign, and one of you is going to have to bridge a very wide and bitter gap. So how do you heal the divide? Secretary Clinton, you get two minutes on this. CLINTON: Well, you're right. Race remains a significant challenge in our country. Unfortunately, race still determines too much, often determines where people live, determines what kind of education in their public schools they can get, and, yes, it determines how they're treated in the criminal justice system. We've just seen those two tragic examples in both Tulsa and Charlotte. And we've got to do several things at the same time. We have to restore trust between communities and the police. We have to work to make sure that our police are using the best training, the best techniques, that they're well prepared to use force only when necessary. Everyone should be respected by the law, and everyone should respect the law. Right now, that's not the case in a lot of our neighborhoods. So I have, ever since the first day of my campaign, called for criminal justice reform. I've laid out a platform that I think would begin to remedy some of the problems we have in the criminal justice system. But we also have to recognize, in addition to the challenges that we face with policing, there are so many good, brave police officers who equally want reform. So we have to bring communities together in order to begin working on that as a mutual goal. And we've got to get guns out of the hands of people who should not have them. The gun epidemic is the leading cause of death of young African- American men, more than the next nine causes put together. So we have to do two things, as I said. We have to restore trust. We have to work with the police. We have to make sure they respect the communities and the communities respect them. And we have to tackle the plague of gun violence, which is a big contributor to a lot of the problems that we're seeing today. HOLT: All right, Mr. Trump, you have two minutes. How do you heal the divide? TRUMP: Well, first of all, Secretary Clinton doesn't want to use a couple of words, and that's law and order. And we need law and order. If we don't have it, we're not going to have a country. And when I look at what's going on in Charlotte, a city I love, a city where I have investments, when I look at what's going on throughout various parts of our country, whether it's—I mean, I can just keep naming them all day long—we need law and order in our country. I just got today the, as you know, the endorsement of the Fraternal Order of Police, we just—just came in. We have endorsements from, I think, almost every police group, very—I mean, a large percentage of them in the United States. We have a situation where we have our inner cities, African- Americans, Hispanics are living in he'll because it's so dangerous. You walk down the street, you get shot. In Chicago, they've had thousands of shootings, thousands since January 1st. Thousands of shootings. And I'm saying, where is this? Is this a war-torn country? What are we doing? And we have to stop the violence. We have to bring back law and order. In a place like Chicago, where thousands of people have been killed, thousands over the last number of years, in fact, almost 4,000 have been killed since Barack Obama became president, over—almost 4,000 people in Chicago have been killed. We have to bring back law and order. Now, whether or not in a place like Chicago you do stop and frisk, which worked very well, Mayor Giuliani is here, worked very well in New York. It brought the crime rate way down. But you take the gun away from criminals that shouldn't be having it. We have gangs roaming the street. And in many cases, they're illegally here, illegal immigrants. And they have guns. And they shoot people. And we have to be very strong. And we have to be very vigilant. We have to be—we have to know what we're doing. Right now, our police, in many cases, are afraid to do anything. We have to protect our inner cities, because African-American communities are being decimated by crime, decimated. HOLT: Your two—your two minutes expired, but I do want to follow up. Stop-and-frisk was ruled unconstitutional in New York, because it largely singled out black and Hispanic young men. TRUMP: No, you're wrong. It went before a judge, who was a very against-police judge. It was taken away from her. And our mayor, our new mayor, refused to go forward with the case. They would have won an appeal. If you look at it, throughout the country, there are many places where it's allowed. HOLT: The argument is that it's a form of racial profiling. TRUMP: No, the argument is that we have to take the guns away from these people that have them and they are bad people that shouldn't have them. These are felons. These are people that are bad people that shouldn't be—when you have 3,000 shootings in Chicago from January 1st, when you have 4,000 people killed in Chicago by guns, from the beginning of the presidency of Barack Obama, his hometown, you have to have stop-and-frisk. You need more police. You need a better community, you know, relation. You don't have good community relations in Chicago. It's terrible. I have property there. It's terrible what's going on in Chicago. But when you look—and Chicago's not the only—you go to Ferguson, you go to so many different places. You need better relationships. I agree with Secretary Clinton on this. You need better relationships between the communities and the police, because in some cases, it's not good. But you look at Dallas, where the relationships were really studied, the relationships were really a beautiful thing, and then five police officers were killed one night very violently. So there's some bad things going on. Some really bad things. HOLT: Secretary Clinton... TRUMP: But we need—Lester, we need law and order. And we need law and order in the inner cities, because the people that are most affected by what's happening are African-American and Hispanic people. And it's very unfair to them what our politicians are allowing to happen. HOLT: Secretary Clinton? CLINTON: Well, I've heard—I've heard Donald say this at his rallies, and it's really unfortunate that he paints such a dire negative picture of black communities in our country. TRUMP: Ugh. CLINTON: You know, the vibrancy of the black church, the black businesses that employ so many people, the opportunities that so many families are working to provide for their kids. There's a lot that we should be proud of and we should be supporting and lifting up. But we do always have to make sure we keep people safe. There are the right ways of doing it, and then there are ways that are ineffective. Stop-and-frisk was found to be unconstitutional and, in part, because it was ineffective. It did not do what it needed to do. Now, I believe in community policing. And, in fact, violent crime is one-half of what it was in 1991. Property crime is down 40 percent. We just don't want to see it creep back up. We've had 25 years of very good cooperation. But there were some problems, some unintended consequences. Too many young African-American and Latino men ended up in jail for nonviolent offenses. And it's just a fact that if you're a young African-American man and you do the same thing as a young white man, you are more likely to be arrested, charged, convicted, and incarcerated. So we've got to address the systemic racism in our criminal justice system. We cannot just say law and order. We have to say—we have to come forward with a plan that is going to divert people from the criminal justice system, deal with mandatory minimum sentences, which have put too many people away for too long for doing too little. We need to have more second chance programs. I'm glad that we're ending private prisons in the federal system; I want to see them ended in the state system. You shouldn't have a profit motivation to fill prison cells with young Americans. So there are some positive ways we can work on this. And I believe strongly that commonsense gun safety measures would assist us. Right now—and this is something Donald has supported, along with the gun lobby—right now, we've got too many military- style weapons on the streets. In a lot of places, our police are outgunned. We need comprehensive background checks, and we need to keep guns out of the hands of those who will do harm. And we finally need to pass a prohibition on anyone who's on the terrorist watch list from being able to buy a gun in our country. If you're too dangerous to fly, you are too dangerous to buy a gun. So there are things we can do, and we ought to do it in a bipartisan way. HOLT: Secretary Clinton, last week, you said we've got to do everything possible to improve policing, to go right at implicit bias. Do you believe that police are implicitly biased against black people? CLINTON: Lester, I think implicit bias is a problem for everyone, not just police. I think, unfortunately, too many of us in our great country jump to conclusions about each other. And therefore, I think we need all of us to be asking hard questions about, you know, why am I feeling this way? But when it comes to policing, since it can have literally fatal consequences, I have said, in my first budget, we would put money into that budget to help us deal with implicit bias by retraining a lot of our police officers. I've met with a group of very distinguished, experienced police chiefs a few weeks ago. They admit it's an issue. They've got a lot of concerns. Mental health is one of the biggest concerns, because now police are having to handle a lot of really difficult mental health problems on the street. They want support, they want more training, they want more assistance. And I think the federal government could be in a position where we would offer and provide that. HOLT: Mr. Trump... TRUMP: I'd like to respond to that. HOLT: Please. TRUMP: First of all, I agree, and a lot of people even within my own party want to give certain rights to people on watch lists and no- fly lists. I agree with you. When a person is on a watch list or a no-fly list, and I have the endorsement of the NRA, which I'm very proud of. These are very, very good people, and they're protecting the Second Amendment. But I think we have to look very strongly at no-fly lists and watch lists. And when people are on there, even if they shouldn't be on there, we'll help them, we'll help them legally, we'll help them get off. But I tend to agree with that quite strongly. I do want to bring up the fact that you were the one that brought up the words super-predator about young black youth. And that's a term that I think was a—it's—it's been horribly met, as you know. I think you've apologized for it. But I think it was a terrible thing to say. And when it comes to stop-and-frisk, you know, you're talking about takes guns away. Well, I'm talking about taking guns away from gangs and people that use them. And I don't think—I really don't think you disagree with me on this, if you want to know the truth. I think maybe there's a political reason why you can't say it, but I really don't believe—in New York City, stop-and-frisk, we had 2,200 murders, and stop-and-frisk brought it down to 500 murders. Five hundred murders is a lot of murders. It's hard to believe, 500 is like supposed to be good? But we went from 2,200 to 500. And it was continued on by Mayor Bloomberg. And it was terminated by current mayor. But stop-and- frisk had a tremendous impact on the safety of New York City. Tremendous beyond belief. So when you say it has no impact, it really did. It had a very, very big impact. CLINTON: Well, it's also fair to say, if we're going to talk about mayors, that under the current mayor, crime has continued to drop, including murders. So there is... TRUMP: No, you're wrong. You're wrong. CLINTON: No, I'm not. TRUMP: Murders are up. All right. You check it. CLINTON: New York—New York has done an excellent job. And I give credit—I give credit across the board going back two mayors, two police chiefs, because it has worked. And other communities need to come together to do what will work, as well. Look, one murder is too many. But it is important that we learn about what has been effective. And not go to things that sound good that really did not have the kind of impact that we would want. Who disagrees with keeping neighborhoods safe? But let's also add, no one should disagree about respecting the rights of young men who live in those neighborhoods. And so we need to do a better job of working, again, with the communities, faith communities, business communities, as well as the police to try to deal with this problem. HOLT: This conversation is about race. And so, Mr. Trump, I have to ask you for five... TRUMP: I'd like to just respond, if I might. HOLT: Please—20 seconds. TRUMP: I'd just like to respond. HOLT: Please respond, then I've got a quick follow-up for you. TRUMP: I will. Look, the African-American community has been let down by our politicians. They talk good around election time, like right now, and after the election, they said, see ya later, I'll see you in four years. The African-American community—because—look, the community within the inner cities has been so badly treated. They've been abused and used in order to get votes by Democrat politicians, because that's what it is. They've controlled these communities for up to 100 years. HOLT: Mr. Trump, let me... [crosstalk] CLINTON: Well, I—I do think... TRUMP: And I will tell you, you look at the inner cities—and I just left Detroit, and I just left Philadelphia, and I just—you know, you've seen me, I've been all over the place. You decided to stay home, and that's OK. But I will tell you, I've been all over. And I've met some of the greatest people I'll ever meet within these communities. And they are very, very upset with what their politicians have told them and what their politicians have done. HOLT: Mr. Trump, I... CLINTON: I think—I think—I think Donald just criticized me for preparing for this debate. And, yes, I did. And you know what else I prepared for? I prepared to be president. And I think that's a good thing. [applause] HOLT: Mr. Trump, for five years, you perpetuated a false claim that the nation's first black president was not a natural-born citizen. You questioned his legitimacy. In the last couple of weeks, you acknowledged what most Americans have accepted for years: The president was born in the United States. Can you tell us what took you so long? TRUMP: I'll tell you very—well, just very simple to say. Sidney Blumenthal works for the campaign and close—very close friend of Secretary Clinton. And her campaign manager, Patti Doyle, went to—during the campaign, her campaign against President Obama, fought very hard. And you can go look it up, and you can check it out. And if you look at CNN this past week, Patti Solis Doyle was on Wolf Blitzer saying that this happened. Blumenthal sent McClatchy, highly respected reporter at McClatchy, to Kenya to find out about it. They were pressing it very hard. She failed to get the birth certificate. When I got involved, I didn't fail. I got him to give the birth certificate. So I'm satisfied with it. And I'll tell you why I'm satisfied with it. HOLT: That was... [crosstalk] TRUMP: Because I want to get on to defeating ISIS, because I want to get on to creating jobs, because I want to get on to having a strong border, because I want to get on to things that are very important to me and that are very important to the country. HOLT: I will let you respond. It's important. But I just want to get the answer here. The birth certificate was produced in 2011. You've continued to tell the story and question the president's legitimacy in 2012, '13, '14, '15... TRUMP: Yeah. HOLT: .... as recently as January. So the question is, what changed your mind? TRUMP: Well, nobody was pressing it, nobody was caring much about it. I figured you'd ask the question tonight, of course. But nobody was caring much about it. But I was the one that got him to produce the birth certificate. And I think I did a good job. Secretary Clinton also fought it. I mean, you know—now, everybody in mainstream is going to say, oh, that's not true. Look, it's true. Sidney Blumenthal sent a reporter—you just have to take a look at CNN, the last week, the interview with your former campaign manager. And she was involved. But just like she can't bring back jobs, she can't produce. HOLT: I'm sorry. I'm just going to follow up—and I will let you respond to that, because there's a lot there. But we're talking about racial healing in this segment. What do you say to Americans, people of color who... [crosstalk] TRUMP: Well, it was very—I say nothing. I say nothing, because I was able to get him to produce it. He should have produced it a long time before. I say nothing. But let me just tell you. When you talk about healing, I think that I've developed very, very good relationships over the last little while with the African-American community. I think you can see that. And I feel that they really wanted me to come to that conclusion. And I think I did a great job and a great service not only for the country, but even for the president, in getting him to produce his birth certificate. HOLT: Secretary Clinton? CLINTON: Well, just listen to what you heard. [laughter] And clearly, as Donald just admitted, he knew he was going to stand on this debate stage, and Lester Holt was going to be asking us questions, so he tried to put the whole racist birther lie to bed. But it can't be dismissed that easily. He has really started his political activity based on this racist lie that our first black president was not an American citizen. There was absolutely no evidence for it, but he persisted, he persisted year after year, because some of his supporters, people that he was trying to bring into his fold, apparently believed it or wanted to believe it. But, remember, Donald started his career back in 1973 being sued by the Justice Department for racial discrimination because he would not rent apartments in one of his developments to African-Americans, and he made sure that the people who worked for him understood that was the policy. He actually was sued twice by the Justice Department. So he has a long record of engaging in racist behavior. And the birther lie was a very hurtful one. You know, Barack Obama is a man of great dignity. And I could tell how much it bothered him and annoyed him that this was being touted and used against him. But I like to remember what Michelle Obama said in her amazing speech at our Democratic National Convention: When they go low, we go high. And Barack Obama went high, despite Donald Trump's best efforts to bring him down. HOLT: Mr. Trump, you can respond and we're going to move on to the next segment. TRUMP: I would love to respond. First of all, I got to watch in preparing for this some of your debates against Barack Obama. You treated him with terrible disrespect. And I watched the way you talk now about how lovely everything is and how wonderful you are. It doesn't work that way. You were after him, you were trying to—you even sent out or your campaign sent out pictures of him in a certain garb, very famous pictures. I don't think you can deny that. But just last week, your campaign manager said it was true. So when you tried to act holier than thou, it really doesn't work. It really doesn't. Now, as far as the lawsuit, yes, when I was very young, I went into my father's company, had a real estate company in Brooklyn and Queens, and we, along with many, many other companies throughout the country—it was a federal lawsuit—were sued. We settled the suit with zero—with no admission of guilt. It was very easy to do. I notice you bring that up a lot. And, you know, I also notice the very nasty commercials that you do on me in so many different ways, which I don't do on you. Maybe I'm trying to save the money. But, frankly, I look—I look at that, and I say, isn't that amazing? Because I settled that lawsuit with no admission of guilt, but that was a lawsuit brought against many real estate firms, and it's just one of those things. I'll go one step further. In Palm Beach, Florida, tough community, a brilliant community, a wealthy community, probably the wealthiest community there is in the world, I opened a club, and really got great credit for it. No discrimination against African- Americans, against Muslims, against anybody. And it's a tremendously successful club. And I'm so glad I did it. And I have been given great credit for what I did. And I'm very, very proud of it. And that's the way I feel. That is the true way I feel. HOLT: Our next segment is called "Securing America." We want to start with a 21st century war happening every day in this country. Our institutions are under cyber attack, and our secrets are being stolen. So my question is, who's behind it? And how do we fight it? Secretary Clinton, this answer goes to you. CLINTON: Well, I think cyber security, cyber warfare will be one of the biggest challenges facing the next president, because clearly we're facing at this point two different kinds of adversaries. There are the independent hacking groups that do it mostly for commercial reasons to try to steal information that they can use to make money. But increasingly, we are seeing cyber attacks coming from states, organs of states. The most recent and troubling of these has been Russia. There's no doubt now that Russia has used cyber attacks against all kinds of organizations in our country, and I am deeply concerned about this. I know Donald's very praiseworthy of Vladimir Putin, but Putin is playing a really... [crosstalk] ...tough, long game here. And one of the things he's done is to let loose cyber attackers to hack into government files, to hack into personal files, hack into the Democratic National Committee. And we recently have learned that, you know, that this is one of their preferred methods of trying to wreak havoc and collect information. We need to make it very clear—whether it's Russia, China, Iran or anybody else—the United States has much greater capacity. And we are not going to sit idly by and permit state actors to go after our information, our private-sector information or our public-sector information. And we're going to have to make it clear that we don't want to use the kinds of tools that we have. We don't want to engage in a different kind of warfare. But we will defend the citizens of this country. And the Russians need to understand that. I think they've been treating it as almost a probing, how far would we go, how much would we do. And that's why I was so—I was so shocked when Donald publicly invited Putin to hack into Americans. That is just unacceptable. It's one of the reasons why 50 national security officials who served in Republican information—in administrations... HOLT: Your two minutes have expired. CLINTON: ... have said that Donald is unfit to be the commander- in-chief. It's comments like that that really worry people who understand the threats that we face. HOLT: Mr. Trump, you have two minutes and the same question. Who's behind it? And how do we fight it? TRUMP: I do want to say that I was just endorsed—and more are coming next week—it will be over 200 admirals, many of them here—admirals and generals endorsed me to lead this country. That just happened, and many more are coming. And I'm very proud of it. In addition, I was just endorsed by ICE. They've never endorsed anybody before on immigration. I was just endorsed by ICE. I was just recently endorsed—16,500 Border Patrol agents. So when Secretary Clinton talks about this, I mean, I'll take the admirals and I'll take the generals any day over the political hacks that I see that have led our country so brilliantly over the last 10 years with their knowledge. OK? Because look at the mess that we're in. Look at the mess that we're in. As far as the cyber, I agree to parts of what Secretary Clinton said. We should be better than anybody else, and perhaps we're not. I don't think anybody knows it was Russia that broke into the DNC. She's saying Russia, Russia, Russia, but I don't—maybe it was. I mean, it could be Russia, but it could also be China. It could also be lots of other people. It also could be somebody sitting on their bed that weighs 400 pounds, OK? You don't know who broke in to DNC. But what did we learn with DNC? We learned that Bernie Sanders was taken advantage of by your people, by Debbie Wasserman Schultz. Look what happened to her. But Bernie Sanders was taken advantage of. That's what we learned. Now, whether that was Russia, whether that was China, whether it was another country, we don't know, because the truth is, under President Obama we've lost control of things that we used to have control over. We came in with the Internet, we came up with the Internet, and I think Secretary Clinton and myself would agree very much, when you look at what ISIS is doing with the Internet, they're beating us at our own game. ISIS. So we have to get very, very tough on cyber and cyber warfare. It is—it is a huge problem. I have a son. He's 10 years old. He has computers. He is so good with these computers, it's unbelievable. The security aspect of cyber is very, very tough. And maybe it's hardly doable. But I will say, we are not doing the job we should be doing. But that's true throughout our whole governmental society. We have so many things that we have to do better, Lester, and certainly cyber is one of them. HOLT: Secretary Clinton? CLINTON: Well, I think there are a number of issues that we should be addressing. I have put forth a plan to defeat ISIS. It does involve going after them online. I think we need to do much more with our tech companies to prevent ISIS and their operatives from being able to use the Internet to radicalize, even direct people in our country and Europe and elsewhere. But we also have to intensify our air strikes against ISIS and eventually support our Arab and Kurdish partners to be able to actually take out ISIS in Raqqa, end their claim of being a Caliphate. We're making progress. Our military is assisting in Iraq. And we're hoping that within the year we'll be able to push ISIS out of Iraq and then, you know, really squeeze them in Syria. But we have to be cognizant of the fact that they've had foreign fighters coming to volunteer for them, foreign money, foreign weapons, so we have to make this the top priority. And I would also do everything possible to take out their leadership. I was involved in a number of efforts to take out Al Qaida leadership when I was secretary of state, including, of course, taking out bin Laden. And I think we need to go after Baghdadi, as well, make that one of our organizing principles. Because we've got to defeat ISIS, and we've got to do everything we can to disrupt their propaganda efforts online. HOLT: You mention ISIS, and we think of ISIS certainly as over there, but there are American citizens who have been inspired to commit acts of terror on American soil, the latest incident, of course, the bombings we just saw in New York and New Jersey, the knife attack at a mall in Minnesota, in the last year, deadly attacks in San Bernardino and Orlando. I'll ask this to both of you. Tell us specifically how you would prevent homegrown attacks by American citizens, Mr. Trump? TRUMP: Well, first I have to say one thing, very important. Secretary Clinton is talking about taking out ISIS. "We will take out ISIS." Well, President Obama and Secretary Clinton created a vacuum the way they got out of Iraq, because they got out—what, they shouldn't have been in, but once they got in, the way they got out was a disaster. And ISIS was formed. So she talks about taking them out. She's been doing it a long time. She's been trying to take them out for a long time. But they wouldn't have even been formed if they left some troops behind, like 10,000 or maybe something more than that. And then you wouldn't have had them. Or, as I've been saying for a long time, and I think you'll agree, because I said it to you once, had we taken the oil—and we should have taken the oil—ISIS would not have been able to form either, because the oil was their primary source of income. And now they have the oil all over the place, including the oil—a lot of the oil in Libya, which was another one of her disasters. HOLT: Secretary Clinton? CLINTON: Well, I hope the fact-checkers are turning up the volume and really working hard. Donald supported the invasion of Iraq. TRUMP: Wrong. CLINTON: That is absolutely proved over and over again. TRUMP: Wrong. Wrong. CLINTON: He actually advocated for the actions we took in Libya and urged that Gadhafi be taken out, after actually doing some business with him one time. But the larger point—and he says this constantly—is George W. Bush made the agreement about when American troops would leave Iraq, not Barack Obama. And the only way that American troops could have stayed in Iraq is to get an agreement from the then-Iraqi government that would have protected our troops, and the Iraqi government would not give that. But let's talk about the question you asked, Lester. The question you asked is, what do we do here in the United States? That's the most important part of this. How do we prevent attacks? How do we protect our people? And I think we've got to have an intelligence surge, where we are looking for every scrap of information. I was so proud of law enforcement in New York, in Minnesota, in New Jersey. You know, they responded so quickly, so professionally to the attacks that occurred by Rahami. And they brought him down. And we may find out more information because he is still alive, which may prove to be an intelligence benefit. So we've got to do everything we can to vacuum up intelligence from Europe, from the Middle East. That means we've got to work more closely with our allies, and that's something that Donald has been very dismissive of. We're working with NATO, the longest military alliance in the history of the world, to really turn our attention to terrorism. We're working with our friends in the Middle East, many of which, as you know, are Muslim majority nations. Donald has consistently insulted Muslims abroad, Muslims at home, when we need to be cooperating with Muslim nations and with the American Muslim community. They're on the front lines. They can provide information to us that we might not get anywhere else. They need to have close working cooperation with law enforcement in these communities, not be alienated and pushed away as some of Donald's rhetoric, unfortunately, has led to. HOLT: Mr. Trump... TRUMP: Well, I have to respond. HOLT: Please respond. TRUMP: The secretary said very strongly about working with—we've been working with them for many years, and we have the greatest mess anyone's ever seen. You look at the Middle East, it's a total mess. Under your direction, to a large extent. But you look at the Middle East, you started the Iran deal, that's another beauty where you have a country that was ready to fall, I mean, they were doing so badly. They were choking on the sanctions. And now they're going to be actually probably a major power at some point pretty soon, the way they're going. But when you look at NATO, I was asked on a major show, what do you think of NATO? And you have to understand, I'm a businessperson. I did really well. But I have common sense. And I said, well, I'll tell you. I haven't given lots of thought to NATO. But two things. Number one, the 28 countries of NATO, many of them aren't paying their fair share. Number two—and that bothers me, because we should be asking—we're defending them, and they should at least be paying us what they're supposed to be paying by treaty and contract. And, number two, I said, and very strongly, NATO could be obsolete, because—and I was very strong on this, and it was actually covered very accurately in the New York Times, which is unusual for the New York Times, to be honest—but I said, they do not focus on terror. And I was very strong. And I said it numerous times. And about four months ago, I read on the front page of the Wall Street Journal that NATO is opening up a major terror division. And I think that's great. And I think we should get—because we pay approximately 73 percent of the cost of NATO. It's a lot of money to protect other people. But I'm all for NATO. But I said they have to focus on terror, also. And they're going to do that. And that was—believe me—I'm sure I'm not going to get credit for it—but that was largely because of what I was saying and my criticism of NATO. I think we have to get NATO to go into the Middle East with us, in addition to surrounding nations, and we have to knock the hell out of ISIS, and we have to do it fast, when ISIS formed in this vacuum created by Barack Obama and Secretary Clinton. And believe me, you were the ones that took out the troops. Not only that, you named the day. They couldn't believe it. They sat back probably and said, I can't believe it. They said... CLINTON: Lester, we've covered... TRUMP: No, wait a minute. CLINTON: We've covered this ground. TRUMP: When they formed, when they formed, this is something that never should have happened. It should have never happened. Now, you're talking about taking out ISIS. But you were there, and you were secretary of state when it was a little infant. Now it's in over 30 countries. And you're going to stop them? I don't think so. HOLT: Mr. Trump, a lot of these are judgment questions. You had supported the war in Iraq before the invasion. What makes your... TRUMP: I did not support the war in Iraq. HOLT: In 2002... TRUMP: That is a mainstream media nonsense put out by her, because she—frankly, I think the best person in her campaign is mainstream media. HOLT: My question is, since you supported it... TRUMP: Just—would you like to hear... HOLT: ... why is your—why is your judgment... TRUMP: Wait a minute. I was against the war in Iraq. Just so you put it out. HOLT: The record shows otherwise, but why—why was... TRUMP: The record does not show that. HOLT: Why was—is your judgment any... TRUMP: The record shows that I'm right. When I did an interview with Howard Stern, very lightly, first time anyone's asked me that, I said, very lightly, I don't know, maybe, who knows? Essentially. I then did an interview with Neil Cavuto. We talked about the economy is more important. I then spoke to Sean Hannity, which everybody refuses to call Sean Hannity. I had numerous conversations with Sean Hannity at Fox. And Sean Hannity said—and he called me the other day—and I spoke to him about it—he said you were totally against the war, because he was for the war. HOLT: Why is your judgment better than... TRUMP: And when he—excuse me. And that was before the war started. Sean Hannity said very strongly to me and other people—he's willing to say it, but nobody wants to call him. I was against the war. He said, you used to have fights with me, because Sean was in favor of the war. And I understand that side, also, not very much, because we should have never been there. But nobody called Sean Hannity. And then they did an article in a major magazine, shortly after the war started. I think in '04. But they did an article which had me totally against the war in Iraq. And one of your compatriots said, you know, whether it was before or right after, Trump was definitely—because if you read this article, there's no doubt. But if somebody—and I'll ask the press—if somebody would call up Sean Hannity, this was before the war started. He and I used to have arguments about the war. I said, it's a terrible and a stupid thing. It's going to destabilize the Middle East. And that's exactly what it's done. It's been a disaster. HOLT: My reference was to what you had said in 2002, and my question was... TRUMP: No, no. You didn't hear what I said. HOLT: Why is your judgment—why is your judgment any different than Mrs. Clinton's judgment? TRUMP: Well, I have much better judgment than she does. There's no question about that. I also have a much better temperament than she has, you know? [laughter] I have a much better—she spent—let me tell you—she spent hundreds of millions of dollars on an advertising—you know, they get Madison Avenue into a room, they put names—oh, temperament, let's go after—I think my strongest asset, maybe by far, is my temperament. I have a winning temperament. I know how to win. She does not have a... HOLT: Secretary Clinton? TRUMP: Wait. The AFL-CIO the other day, behind the blue screen, I don't know who you were talking to, Secretary Clinton, but you were totally out of control. I said, there's a person with a temperament that's got a problem. HOLT: Secretary Clinton? CLINTON: Whew, OK. [laughter] Let's talk about two important issues that were briefly mentioned by Donald, first, NATO. You know, NATO as a military alliance has something called Article 5, and basically it says this: An attack on one is an attack on all. And you know the only time it's ever been invoked? After 9/11, when the 28 nations of NATO said that they would go to Afghanistan with us to fight terrorism, something that they still are doing by our side. With respect to Iran, when I became secretary of state, Iran was weeks away from having enough nuclear material to form a bomb. They had mastered the nuclear fuel cycle under the Bush administration. They had built covert facilities. They had stocked them with centrifuges that were whirling away. And we had sanctioned them. I voted for every sanction against Iran when I was in the Senate, but it wasn't enough. So I spent a year-and-a-half putting together a coalition that included Russia and China to impose the toughest sanctions on Iran. And we did drive them to the negotiating table. And my successor, John Kerry, and President Obama got a deal that put a lid on Iran's nuclear program without firing a single shot. That's diplomacy. That's coalition-building. That's working with other nations. The other day, I saw Donald saying that there were some Iranian sailors on a ship in the waters off of Iran, and they were taunting American sailors who were on a nearby ship. He said, you know, if they taunted our sailors, I'd blow them out of the water and start another war. That's not good judgment. TRUMP: That would not start a war. CLINTON: That is not the right temperament to be commander-in- chief, to be taunted. And the worst part... TRUMP: No, they were taunting us. CLINTON: ... of what we heard Donald say has been about nuclear weapons. He has said repeatedly that he didn't care if other nations got nuclear weapons, Japan, South Korea, even Saudi Arabia. It has been the policy of the United States, Democrats and Republicans, to do everything we could to reduce the proliferation of nuclear weapons. He even said, well, you know, if there were nuclear war in East Asia, well, you know, that's fine... TRUMP: Wrong. CLINTON: ... have a good time, folks. TRUMP: It's lies. CLINTON: And, in fact, his cavalier attitude about nuclear weapons is so deeply troubling. That is the number-one threat we face in the world. And it becomes particularly threatening if terrorists ever get their hands on any nuclear material. So a man who can be provoked by a tweet should not have his fingers anywhere near the nuclear codes, as far as I think anyone with any sense about this should be concerned. TRUMP: That line's getting a little bit old, I must say. I would like to... CLINTON: It's a good one, though. It well describes the problem. [laughter] TRUMP: It's not an accurate one at all. It's not an accurate one. So I just want to give a lot of things—and just to respond. I agree with her on one thing. The single greatest problem the world has is nuclear armament, nuclear weapons, not global warming, like you think and your—your president thinks. Nuclear is the single greatest threat. Just to go down the list, we defend Japan, we defend Germany, we defend South Korea, we defend Saudi Arabia, we defend countries. They do not pay us. But they should be paying us, because we are providing tremendous service and we're losing a fortune. That's why we're losing—we're losing—we lose on everything. I say, who makes these—we lose on everything. All I said, that it's very possible that if they don't pay a fair share, because this isn't 40 years ago where we could do what we're doing. We can't defend Japan, a behemoth, selling us cars by the million... HOLT: We need to move on. TRUMP: Well, wait, but it's very important. All I said was, they may have to defend themselves or they have to help us out. We're a country that owes $20 trillion. They have to help us out. HOLT: Our last... TRUMP: As far as the nuclear is concerned, I agree. It is the single greatest threat that this country has. HOLT: Which leads to my next question, as we enter our last segment here on the, still on the subject of securing America. On nuclear weapons, President Obama reportedly considered changing the nation's longstanding policy on first use. Do you support the current policy? Mr. Trump, you have two minutes on that. TRUMP: Well, I have to say that, you know, for what Secretary Clinton was saying about nuclear with Russia, she's very cavalier in the way she talks about various countries. But Russia has been expanding their—they have a much newer capability than we do. We have not been updating from the new standpoint. I looked the other night. I was seeing B-52s, they're old enough that your father, your grandfather could be flying them. We are not—we are not keeping up with other countries. I would like everybody to end it, just get rid of it. But I would certainly not do first strike. I think that once the nuclear alternative happens, it's over. At the same time, we have to be prepared. I can't take anything off the table. Because you look at some of these countries, you look at North Korea, we're doing nothing there. China should solve that problem for us. China should go into North Korea. China is totally powerful as it relates to North Korea. And by the way, another one powerful is the worst deal I think I've ever seen negotiated that you started is the Iran deal. Iran is one of their biggest trading partners. Iran has power over North Korea. And when they made that horrible deal with Iran, they should have included the fact that they do something with respect to North Korea. And they should have done something with respect to Yemen and all these other places. And when asked to Secretary Kerry, why didn't you do that? Why didn't you add other things into the deal? One of the great giveaways of all time, of all time, including $400 million in cash. Nobody's ever seen that before. That turned out to be wrong. It was actually $1.7 billion in cash, obviously, I guess for the hostages. It certainly looks that way. So you say to yourself, why didn't they make the right deal? This is one of the worst deals ever made by any country in history. The deal with Iran will lead to nuclear problems. All they have to do is sit back 10 years, and they don't have to do much. HOLT: Your two minutes is expired. TRUMP: And they're going to end up getting nuclear. I met with Bibi Netanyahu the other day. Believe me, he's not a happy camper. HOLT: All right. Mrs. Clinton, Secretary Clinton, you have two minutes. CLINTON: Well, let me—let me start by saying, words matter. Words matter when you run for president. And they really matter when you are president. And I want to reassure our allies in Japan and South Korea and elsewhere that we have mutual defense treaties and we will honor them. It is essential that America's word be good. And so I know that this campaign has caused some questioning and worries on the part of many leaders across the globe. I've talked with a number of them. But I want to—on behalf of myself, and I think on behalf of a majority of the American people, say that, you know, our word is good. It's also important that we look at the entire global situation. There's no doubt that we have other problems with Iran. But personally, I'd rather deal with the other problems having put that lid on their nuclear program than still to be facing that. And Donald never tells you what he would do. Would he have started a war? Would he have bombed Iran? If he's going to criticize a deal that has been very successful in giving us access to Iranian facilities that we never had before, then he should tell us what his alternative would be. But it's like his plan to defeat ISIS. He says it's a secret plan, but the only secret is that he has no plan. So we need to be more precise in how we talk about these issues. People around the word follow our presidential campaigns so closely, trying to get hints about what we will do. Can they rely on us? Are we going to lead the world with strength and in accordance with our values? That's what I intend to do. I intend to be a leader of our country that people can count on, both here at home and around the world, to make decisions that will further peace and prosperity, but also stand up to bullies, whether they're abroad or at home. We cannot let those who would try to destabilize the world to interfere with American interests and security... HOLT: Your two minutes is... CLINTON: ... to be given any opportunities at all. HOLT: ... is expired. TRUMP: Lester, one thing I'd like to say. HOLT: Very quickly. Twenty seconds. TRUMP: I will go very quickly. But I will tell you that Hillary will tell you to go to her website and read all about how to defeat ISIS, which she could have defeated by never having it, you know, get going in the first place. Right now, it's getting tougher and tougher to defeat them, because they're in more and more places, more and more states, more and more nations. HOLT: Mr. Trump... TRUMP: And it's a big problem. And as far as Japan is concerned, I want to help all of our allies, but we are losing billions and billions of dollars. We cannot be the policemen of the world. We cannot protect countries all over the world... HOLT: We have just... TRUMP: ... where they're not paying us what we need. HOLT: We have just a few final questions... TRUMP: And she doesn't say that, because she's got no business ability. We need heart. We need a lot of things. But you have to have some basic ability. And sadly, she doesn't have that. All of the things that she's talking about could have been taken care of during the last 10 years, let's say, while she had great power. But they weren't taken care of. And if she ever wins this race, they won't be taken care of. HOLT: Mr. Trump, this year Secretary Clinton became the first woman nominated for president by a major party. Earlier this month, you said she doesn't have, quote, "a presidential look." She's standing here right now. What did you mean by that? TRUMP: She doesn't have the look. She doesn't have the stamina. I said she doesn't have the stamina. And I don't believe she does have the stamina. To be president of this country, you need tremendous stamina. HOLT: The quote was, "I just don't think she has the presidential look." TRUMP: You have—wait a minute. Wait a minute, Lester. You asked me a question. Did you ask me a question? You have to be able to negotiate our trade deals. You have to be able to negotiate, that's right, with Japan, with Saudi Arabia. I mean, can you imagine, we're defending Saudi Arabia? And with all of the money they have, we're defending them, and they're not paying? All you have to do is speak to them. Wait. You have so many different things you have to be able to do, and I don't believe that Hillary has the stamina. HOLT: Let's let her respond. CLINTON: Well, as soon as he travels to 112 countries and negotiates a peace deal, a cease-fire, a release of dissidents, an opening of new opportunities in nations around the world, or even spends 11 hours testifying in front of a congressional committee, he can talk to me about stamina. [applause] TRUMP: The world—let me tell you. Let me tell you. Hillary has experience, but it's bad experience. We have made so many bad deals during the last—so she's got experience, that I agree. [applause] But it's bad, bad experience. Whether it's the Iran deal that you're so in love with, where we gave them $150 billion back, whether it's the Iran deal, whether it's anything you can—name—you almost can't name a good deal. I agree. She's got experience, but it's bad experience. And this country can't afford to have another four years of that kind of experience. HOLT: We are at—we are at the final question. [applause] CLINTON: Well, one thing. One thing, Lester. HOLT: Very quickly, because we're at the final question now. CLINTON: You know, he tried to switch from looks to stamina. But this is a man who has called women pigs, slobs and dogs, and someone who has said pregnancy is an inconvenience to employers, who has said... TRUMP: I never said that. CLINTON: .... women don't deserve equal pay unless they do as good a job as men. TRUMP: I didn't say that. CLINTON: And one of the worst things he said was about a woman in a beauty contest. He loves beauty contests, supporting them and hanging around them. And he called this woman "Miss Piggy." Then he called her "Miss Housekeeping," because she was Latina. Donald, she has a name. TRUMP: Where did you find this? Where did you find this? CLINTON: Her name is Alicia Machado. TRUMP: Where did you find this? CLINTON: And she has become a U.S. citizen, and you can bet... TRUMP: Oh, really? CLINTON: ... she's going to vote this November. TRUMP: OK, good. Let me just tell you... [applause] HOLT: Mr. Trump, could we just take 10 seconds and then we ask the final question... TRUMP: You know, Hillary is hitting me with tremendous commercials. Some of it's said in entertainment. Some of it's said—somebody who's been very vicious to me, Rosie O'Donnell, I said very tough things to her, and I think everybody would agree that she deserves it and nobody feels sorry for her. But you want to know the truth? I was going to say something... HOLT: Please very quickly. TRUMP: ... extremely rough to Hillary, to her family, and I said to myself, "I can't do it. I just can't do it. It's inappropriate. It's not nice." But she spent hundreds of millions of dollars on negative ads on me, many of which are absolutely untrue. They're untrue. And they're misrepresentations. And I will tell you this, Lester: It's not nice. And I don't deserve that. But it's certainly not a nice thing that she's done. It's hundreds of millions of ads. And the only gratifying thing is, I saw the polls come in today, and with all of that money... HOLT: We have to move on to the final question. TRUMP: ... $200 million is spent, and I'm either winning or tied, and I've spent practically nothing. [applause] HOLT: One of you will not win this election. So my final question to you tonight, are you willing to accept the outcome as the will of the voters? Secretary Clinton? CLINTON: Well, I support our democracy. And sometimes you win, sometimes you lose. But I certainly will support the outcome of this election. And I know Donald's trying very hard to plant doubts about it, but I hope the people out there understand: This election's really up to you. It's not about us so much as it is about you and your families and the kind of country and future you want. So I sure hope you will get out and vote as though your future depended on it, because I think it does. HOLT: Mr. Trump, very quickly, same question. Will you accept the outcome as the will of the voters? TRUMP: I want to make America great again. We are a nation that is seriously troubled. We're losing our jobs. People are pouring into our country. The other day, we were deporting 800 people. And perhaps they passed the wrong button, they pressed the wrong button, or perhaps worse than that, it was corruption, but these people that we were going to deport for good reason ended up becoming citizens. Ended up becoming citizens. And it was 800. And now it turns out it might be 1,800, and they don't even know. HOLT: Will you accept the outcome of the election? TRUMP: Look, here's the story. I want to make America great again. I'm going to be able to do it. I don't believe Hillary will. The answer is, if she wins, I will absolutely support her. [applause] HOLT: All right. Well, that is going to do it for us. That concludes our debate for this evening, a spirit one. We covered a lot of ground, not everything as I suspected we would. The next presidential debates are scheduled for October 9th at Washington University in St. Louis and October 19th at the University of Nevada Las Vegas. The conversation will continue. A reminder. The vice presidential debate is scheduled for October 4th at Longwood University in Farmville, Virginia. My thanks to Hillary Clinton and to Donald Trump and to Hofstra University for hosting us tonight. Good night, everyone.
