# Presidential Debate in Oxford, Mississippi

**Date:** September 26, 2008
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-the-university-mississippi-oxford

---

[moderated by Jim Lehrer of PBS] LEHRER: Gentlemen, at this very moment tonight, where do you stand on the financial recovery plan? First response to you, Senator Obama. You have two minutes. OBAMA: Well, thank you very much, Jim, and thanks to the commission and the University of Mississippi, "Ole Miss," for hosting us tonight. I can't think of a more important time for us to talk about the future of the country. You know, we are at a defining moment in our history. Our nation is involved in two wars, and we are going through the worst financial crisis since the Great Depression. And although we've heard a lot about Wall Street, those of you on Main Street I think have been struggling for a while, and you recognize that this could have an impact on all sectors of the economy. And you're wondering, how's it going to affect me? How's it going to affect my job? How's it going to affect my house? How's it going to affect my retirement savings or my ability to send my children to college? So we have to move swiftly, and we have to move wisely. And I've put forward a series of proposals that make sure that we protect taxpayers as we engage in this important rescue effort. No. 1, we've got to make sure that we've got oversight over this whole process; $700 billion, potentially, is a lot of money. No. 2, we've got to make sure that taxpayers, when they are putting their money at risk, have the possibility of getting that money back and gains, if the market -- and when the market returns. No. 3, we've got to make sure that none of that money is going to pad CEO bank accounts or to promote golden parachutes. And, No. 4, we've got to make sure that we're helping homeowners, because the root problem here has to do with the foreclosures that are taking place all across the country. Now, we also have to recognize that this is a final verdict on eight years of failed economic policies promoted by George Bush, supported by Senator McCain, a theory that basically says that we can shred regulations and consumer protections and give more and more to the most, and somehow prosperity will trickle down. It hasn't worked. And I think that the fundamentals of the economy have to be measured by whether or not the middle class is getting a fair shake. That's why I'm running for president, and that's what I hope we're going to be talking about tonight. LEHRER: Senator McCain, two minutes. MCCAIN: Well, thank you, Jim. And thanks to everybody. And I do have a sad note tonight. Senator Kennedy is in the hospital. He's a dear and beloved friend to all of us. Our thoughts and prayers go out to the lion of the Senate. I also want to thank the University of Mississippi for hosting us tonight. And, Jim, I -- I've been not feeling too great about a lot of things lately. So have a lot of Americans who are facing challenges. But I'm feeling a little better tonight, and I'll tell you why. Because as we're here tonight in this debate, we are seeing, for the first time in a long time, Republicans and Democrats together, sitting down, trying to work out a solution to this fiscal crisis that we're in. And have no doubt about the magnitude of this crisis. And we're not talking about failure of institutions on Wall Street. We're talking about failures on Main Street, and people who will lose their jobs, and their credits, and their homes, if we don't fix the greatest fiscal crisis, probably in -- certainly in our time, and I've been around a little while. But the point is -- the point is, we have finally seen Republicans and Democrats sitting down and negotiating together and coming up with a package. This package has transparency in it. It has to have accountability and oversight. It has to have options for loans to failing businesses, rather than the government taking over those loans. We have to -- it has to have a package with a number of other essential elements to it. And, yes, I went back to Washington, and I met with my Republicans in the House of Representatives. And they weren't part of the negotiations, and I understand that. And it was the House Republicans that decided that they would be part of the solution to this problem. But I want to emphasize one point to all Americans tonight. This isn't the beginning of the end of this crisis. This is the end of the beginning, if we come out with a package that will keep these institutions stable. And we've got a lot of work to do. And we've got to create jobs. And one of the areas, of course, is to eliminate our dependence on foreign oil. LEHRER: All right, let's go back to my question. How do you all stand on the recovery plan? And talk to each other about it. We've got five minutes. We can negotiate a deal right here. But, I mean, are you -- do you favor this plan, Senator Obama, and you, Senator McCain? Do you -- are you in favor of this plan? OBAMA: We haven't seen the language yet. And I do think that there's constructive work being done out there. So, for the viewers who are watching, I am optimistic about the capacity of us to come together with a plan. The question, I think, that we have to ask ourselves is, how did we get into this situation in the first place? Two years ago, I warned that, because of the subprime lending mess, because of the lax regulation, that we were potentially going to have a problem and tried to stop some of the abuses in mortgages that were taking place at the time. Last year, I wrote to the secretary of the Treasury to make sure that he understood the magnitude of this problem and to call on him to bring all the stakeholders together to try to deal with it. So -- so the question, I think, that we've got to ask ourselves is, yes, we've got to solve this problem short term. And we are going to have to intervene; there's no doubt about that. But we're also going to have to look at, how is it that we shredded so many regulations? We did not set up a 21st-century regulatory framework to deal with these problems. And that in part has to do with an economic philosophy that says that regulation is always bad. LEHRER: Are you going to vote for the plan, Senator McCain? MCCAIN: I -- I hope so. And I... LEHRER: As a United States senator... MCCAIN: Sure. LEHRER: ... you're going to vote for the plan? MCCAIN: Sure. But -- but let me -- let me point out, I also warned about Fannie Mae and Freddie Mac and warned about corporate greed and excess, and CEO pay, and all that. A lot of us saw this train wreck coming. But there's also the issue of responsibility. You've mentioned President Dwight David Eisenhower. President Eisenhower, on the night before the Normandy invasion, went into his room, and he wrote out two letters. One of them was a letter congratulating the great members of the military and allies that had conducted and succeeded in the greatest invasion in history, still to this day, and forever. And he wrote out another letter, and that was a letter of resignation from the United States Army for the failure of the landings at Normandy. Somehow we've lost that accountability. I've been heavily criticized because I called for the resignation of the chairman of the Securities and Exchange Commission. We've got to start also holding people accountable, and we've got to reward people who succeed. But somehow in Washington today -- and I'm afraid on Wall Street -- greed is rewarded, excess is rewarded, and corruption -- or certainly failure to carry out our responsibility is rewarded. As president of the United States, people are going to be held accountable in my administration. And I promise you that that will happen. LEHRER: Do you have something directly to say, Senator Obama, to Senator McCain about what he just said? OBAMA: Well, I think Senator McCain's absolutely right that we need more responsibility, but we need it not just when there's a crisis. I mean, we've had years in which the reigning economic ideology has been what's good for Wall Street, but not what's good for Main Street. And there are folks out there who've been struggling before this crisis took place. And that's why it's so important, as we solve this short-term problem, that we look at some of the underlying issues that have led to wages and incomes for ordinary Americans to go down, the -- a health care system that is broken, energy policies that are not working, because, you know, 10 days ago, John said that the fundamentals of the economy are sound. LEHRER: Say it directly to him. OBAMA: I do not think that they are. LEHRER: Say it directly to him. OBAMA: Well, the -- John, 10 days ago, you said that the fundamentals of the economy are sound. And... MCCAIN: Are you afraid I couldn't hear him? LEHRER: I'm just determined to get you all to talk to each other. I'm going to try. OBAMA: The -- and I just fundamentally disagree. And unless we are holding ourselves accountable day in, day out, not just when there's a crisis for folks who have power and influence and can hire lobbyists, but for the nurse, the teacher, the police officer, who, frankly, at the end of each month, they've got a little financial crisis going on. They're having to take out extra debt just to make their mortgage payments. We haven't been paying attention to them. And if you look at our tax policies, it's a classic example. LEHRER: So, Senator McCain, do you agree with what Senator Obama just said? And, if you don't, tell him what you disagree with. MCCAIN: No, I -- look, we've got to fix the system. We've got fundamental problems in the system. And Main Street is paying a penalty for the excesses and greed in Washington, D.C., and on Wall Street. So there's no doubt that we have a long way to go. And, obviously, stricter interpretation and consolidation of the various regulatory agencies that weren't doing their job, that has brought on this crisis. But I have a fundamental belief in the goodness and strength of the American worker. And the American worker is the most productive, the most innovative. America is still the greatest producer, exporter and importer. But we've got to get through these times, but I have a fundamental belief in the United States of America. And I still believe, under the right leadership, our best days are ahead of us. LEHRER: All right, let's go to the next lead question, which is essentially following up on this same subject. And you get two minutes to begin with, Senator McCain. And using your word "fundamental," are there fundamental differences between your approach and Senator Obama's approach to what you would do as president to lead this country out of the financial crisis? MCCAIN: Well, the first thing we have to do is get spending under control in Washington. It's completely out of control. It's gone -- we have now presided over the largest increase in the size of government since the Great Society. We Republicans came to power to change government, and government changed us. And the -- the worst symptom on this disease is what my friend, Tom Coburn, calls earmarking as a gateway drug, because it's a gateway. It's a gateway to out-of-control spending and corruption. And we have former members of Congress now residing in federal prison because of the evils of this earmarking and pork-barrel spending. You know, we spent $3 million to study the DNA of bears in Montana. I don't know if that was a criminal issue or a paternal issue, but the fact is that it was $3 million of our taxpayers' money. And it has got to be brought under control. As president of the United States, I want to assure you, I've got a pen. This one's kind of old. I've got a pen, and I'm going to veto every single spending bill that comes across my desk. I will make them famous. You will know their names. Now, Senator Obama, you wanted to know one of the differences. a million dollars for every day that he's been in the United States Senate. I suggest that people go up on the Web site of Citizens Against Government Waste, and they'll look at those projects. That kind of thing is not the way to rein in runaway spending in Washington, D.C. That's one of the fundamental differences that Senator Obama and I have. LEHRER: Senator Obama, two minutes. OBAMA: Well, Senator McCain is absolutely right that the earmarks process has been abused, which is why I suspended any requests for my home state, whether it was for senior centers or what have you, until we cleaned it up. And he's also right that oftentimes lobbyists and special interests are the ones that are introducing these kinds of requests, although that wasn't the case with me. But let's be clear: Earmarks account for $18 billion in last year's budget. Senator McCain is proposing -- and this is a fundamental difference between us -- $300 billion in tax cuts to some of the wealthiest corporations and individuals in the country, $300 billion. Now, $18 billion is important; $300 billion is really important. And in his tax plan, you would have CEOs of Fortune 500 companies getting an average of $700,000 in reduced taxes, while leaving 100 million Americans out. So my attitude is, we've got to grow the economy from the bottom up. What I've called for is a tax cut for 95 percent of working families, 95 percent. And that means that the ordinary American out there who's collecting a paycheck every day, they've got a little extra money to be able to buy a computer for their kid, to fill up on this gas that is killing them. And over time, that, I think, is going to be a better recipe for economic growth than the -- the policies of President Bush that John McCain wants to -- wants to follow. LEHRER: Senator McCain? MCCAIN: Well, again, I don't mean to go back and forth, but he... LEHRER: No, that's fine. MCCAIN: Senator Obama suspended those requests for pork-barrel projects after he was running for president of the United States. He didn't happen to see that light during the first three years as a member of the United States Senate, $932 million in requests. Maybe to Senator Obama it's not a lot of money. But the point is that -- you see, I hear this all the time. "It's only $18 billion." Do you know that it's tripled in the last five years? Do you know that it's gone completely out of control to the point where it corrupts people? It corrupts people. That's why we have, as I said, people under federal indictment and charges. It's a system that's got to be cleaned up. I have fought against it my career. I have fought against it. I was called the sheriff, by the -- one of the senior members of the Appropriations Committee. I didn't win Miss Congeniality in the United States Senate. Now, Senator Obama didn't mention that, along with his tax cuts, he is also proposing some $800 billion in new spending on new programs. Now, that's a fundamental difference between myself and Senator Obama. I want to cut spending. I want to keep taxes low. The worst thing we could do in this economic climate is to raise people's taxes. OBAMA: I -- I don't know where John is getting his figures. Let's just be clear. What I do is I close corporate loopholes, stop providing tax cuts to corporations that are shipping jobs overseas so that we're giving tax breaks to companies that are investing here in the United States. I make sure that we have a health care system that allows for everyone to have basic coverage. I think those are pretty important priorities. And I pay for every dime of it. But let's go back to the original point. John, nobody is denying that $18 billion is important. And, absolutely, we need earmark reform. And when I'm president, I will go line by line to make sure that we are not spending money unwisely. But the fact is that eliminating earmarks alone is not a recipe for how we're going to get the middle class back on track. OBAMA: And when you look at your tax policies that are directed primarily at those who are doing well, and you are neglecting people who are really struggling right now, I think that is a continuation of the last eight years, and we can't afford another four. LEHRER: Respond directly to him about that, to Senator Obama about that, about the -- he's made it twice now, about your tax -- your policies about tax cuts. MCCAIN: Well -- well, let me give you an example of what Senator Obama finds objectionable, the business tax. Right now, the United States of American business pays the second-highest business taxes in the world, 35 percent. Ireland pays 11 percent. Now, if you're a business person, and you can locate any place in the world, then, obviously, if you go to the country where it's 11 percent tax versus 35 percent, you're going to be able to create jobs, increase your business, make more investment, et cetera. I want to cut that business tax. I want to cut it so that businesses will remain in -- in the United States of America and create jobs. But, again, I want to return. It's a lot more than $18 billion in pork-barrel spending. I can tell you, it's rife. It's throughout. The United States Senate will take up a continuing resolution tomorrow or the next day, sometime next week, with 2,000 -- 2,000 -- look at them, my friends. Look at them. You'll be appalled. And Senator Obama is a recent convert, after requesting $932 million worth of pork-barrel spending projects. So the point is, I want people to have tax cuts. I want every family to have a $5,000 refundable tax credit so they can go out and purchase their own health care. I want to double the dividend from $3,500 to $7,000 for every dependent child in America. I know that the worst thing we could possibly do is to raise taxes on anybody, and a lot of people might be interested in Senator Obama's definition of "rich." LEHRER: Senator Obama, you have a question for Senator McCain on that? OBAMA: Well, let me just make a couple of points. LEHRER: All right. OBAMA: My definition -- here's what I can tell the American people: 95 percent of you will get a tax cut. And if you make less than $250,000, less than a quarter-million dollars a year, then you will not see one dime's worth of tax increase. Now, John mentioned the fact that business taxes on paper are high in this country, and he's absolutely right. Here's the problem: There are so many loopholes that have been written into the tax code, oftentimes with support of Senator McCain, that we actually see our businesses pay effectively one of the lowest tax rates in the world. And what that means, then, is that there are people out there who are working every day, who are not getting a tax cut, and you want to give them more. It's not like you want to close the loopholes. You just want to add an additional tax cut over the loopholes. And that's a problem. Just one last point I want to make, since Senator McCain talked about providing a $5,000 health credit. Now, what he doesn't tell you is that he intends to, for the first time in history, tax health benefits. So you may end up getting a $5,000 tax credit. Here's the only problem: Your employer now has to pay taxes on the health care that you're getting from your employer. And if you end up losing your health care from your employer, you've got to go out on the open market and try to buy it. It is not a good deal for the American people. But it's an example of this notion that the market can always solve everything and that the less regulation we have, the better off we're going to be. MCCAIN: Well, you know, let me just... LEHRER: We've got to go to another lead question. MCCAIN: I know we have to, but this is a classic example of walking the walk and talking the talk. We had an energy bill before the United States Senate. It was festooned with Christmas tree ornaments. It had all kinds of breaks for the oil companies, I mean, billions of dollars worth. I voted against it; Senator Obama voted for it. OBAMA: John, you want to give oil companies another $4 billion. MCCAIN: You've got to look at our record. You've got to look at our records. That's the important thing. Who fought against wasteful and earmark spending? Who has been the person who has tried to keep spending under control? Who's the person who has believed that the best thing for America is -- is to have a tax system that is fundamentally fair? And I've fought to simplify it, and I have proposals to simplify it. Let's give every American a choice: two tax brackets, generous dividends, and, two -- and let Americans choose whether they want the -- the existing tax code or they want a new tax code. And so, again, look at the record, particularly the energy bill. But, again, Senator Obama has shifted on a number of occasions. He has voted in the United States Senate to increase taxes on people who make as low as $42,000 a year. OBAMA: That's not true, John. That's not true. MCCAIN: And that's just a fact. Again, you can look it up. OBAMA: Look, it's just not true. And if we want to talk about oil company profits, under your tax plan, John -- this is undeniable -- oil companies would get an additional $4 billion in tax breaks. Now, look, we all would love to lower taxes on everybody. But here's the problem: If we are giving them to oil companies, then that means that there are those who are not going to be getting them. And... MCCAIN: With all due respect, you already gave them to the oil companies. OBAMA: No, but, John, the fact of the matter is, is that I was opposed to those tax breaks, tried to strip them out. We've got an emergency bill on the Senate floor right now that contains some good stuff, some stuff you want, including drilling off-shore, but you're opposed to it because it would strip away those tax breaks that have gone to oil companies. LEHRER: All right. All right, speaking of things that both of you want, another lead question, and it has to do with the rescue -- the financial rescue thing that we started -- started asking about. And what -- and the first answer is to you, Senator Obama. As president, as a result of whatever financial rescue plan comes about and the billion, $700 billion, whatever it is it's going to cost, what are you going to have to give up, in terms of the priorities that you would bring as president of the United States, as a result of having to pay for the financial rescue plan? OBAMA: Well, there are a range of things that are probably going to have to be delayed. We don't yet know what our tax revenues are going to be. The economy is slowing down, so it's hard to anticipate right now what the budget is going to look like next year. But there's no doubt that we're not going to be able to do everything that I think needs to be done. There are some things that I think have to be done. We have to have energy independence, so I've put forward a plan to make sure that, in 10 years' time, we have freed ourselves from dependence on Middle Eastern oil by increasing production at home, but most importantly by starting to invest in alternative energy, solar, wind, biodiesel, making sure that we're developing the fuel-efficient cars of the future right here in the United States, in Ohio and Michigan, instead of Japan and South Korea. We have to fix our health care system, which is putting an enormous burden on families. Just -- a report just came out that the average deductible went up 30 percent on American families. They are getting crushed, and many of them are going bankrupt as a consequence of health care. I'm meeting folks all over the country. We have to do that now, because it will actually make our businesses and our families better off. The third thing we have to do is we've got to make sure that we're competing in education. We've got to invest in science and technology. China had a space launch and a space walk. We've got to make sure that our children are keeping pace in math and in science. And one of the things I think we have to do is make sure that college is affordable for every young person in America. And I also think that we're going to have to rebuild our infrastructure, which is falling behind, our roads, our bridges, but also broadband lines that reach into rural communities. Also, making sure that we have a new electricity grid to get the alternative energy to population centers that are using them. So there are some -- some things that we've got to do structurally to make sure that we can compete in this global economy. We can't shortchange those things. We've got to eliminate programs that don't work, and we've got to make sure that the programs that we do have are more efficient and cost less. LEHRER: Are you -- what priorities would you adjust, as president, Senator McCain, because of the -- because of the financial bailout cost? MCCAIN: Look, we, no matter what, we've got to cut spending. We have -- as I said, we've let government get completely out of control. Senator Obama has the most liberal voting record in the United States Senate. It's hard to reach across the aisle from that far to the left. The point -- the point is -- the point is, we need to examine every agency of government. First of all, by the way, I'd eliminate ethanol subsidies. I oppose ethanol subsidies. I think that we have to return -- particularly in defense spending, which is the largest part of our appropriations -- we have to do away with cost-plus contracts. We now have defense systems that the costs are completely out of control. We tried to build a little ship called the Littoral Combat Ship that was supposed to cost $140 million, ended up costing $400 million, and we still haven't done it. So we need to have fixed-cost contracts. We need very badly to understand that defense spending is very important and vital, particularly in the new challenges we face in the world, but we have to get a lot of the cost overruns under control. I know how to do that. MCCAIN: I saved the taxpayers $6.8 billion by fighting a contract that was negotiated between Boeing and DOD that was completely wrong. And we fixed it and we killed it and the people ended up in federal prison so I know how to do this because I've been involved these issues for many, many years. But I think that we have to examine every agency of government and find out those that are doing their job and keep them and find out those that aren't and eliminate them and we'll have to scrub every agency of government. LEHRER: But if I hear the two of you correctly neither one of you is suggesting any major changes in what you want to do as president as a result of the financial bailout? Is that what you're saying? OBAMA: No. As I said before, Jim, there are going to be things that end up having to be ... LEHRER: Like what? OBAMA: ... deferred and delayed. Well, look, I want to make sure that we are investing in energy in order to free ourselves from the dependence on foreign oil. That is a big project. That is a multi-year project. LEHRER: Not willing to give that up? OBAMA: Not willing to give up the need to do it but there may be individual components that we can't do. But John is right we have to make cuts. We right now give $15 billion every year as subsidies to private insurers under the Medicare system. Doesn't work any better through the private insurers. They just skim off $15 billion. That was a give away and part of the reason is because lobbyists are able to shape how Medicare works. They did it on the Medicaid prescription drug bill and we have to change the culture. Tom -- or John mentioned me being wildly liberal. Mostly that's just me opposing George Bush's wrong headed policies since I've been in Congress but I think it is that it is also important to recognize I work with Tom Coburn, the most conservative, one of the most conservative Republicans who John already mentioned to set up what we call a Google for government saying we'll list every dollar of federal spending to make sure that the taxpayer can take a look and see who, in fact, is promoting some of these spending projects that John's been railing about. LEHRER: What I'm trying to get at this is this. Excuse me if I may, senator. Trying to get at that you all -- one of you is going to be the president of the United States come January. At the -- in the middle of a huge financial crisis that is yet to be resolved. And what I'm trying to get at is how this is going to affect you not in very specific -- small ways but in major ways and the approach to take as to the presidency. MCCAIN: How about a spending freeze on everything but defense, veteran affairs and entitlement programs. LEHRER: Spending freeze? MCCAIN: I think we ought to seriously consider with the exceptions the caring of veterans national defense and several other vital issues. LEHRER: Would you go for that? OBAMA: The problem with a spending freeze is you're using a hatchet where you need a scalpel. There are some programs that are very important that are under funded. I went to increase early childhood education and the notion that we should freeze that when there may be, for example, this Medicare subsidy doesn't make sense. Let me tell you another place to look for some savings. We are currently spending $10 billion a month in Iraq when they have a $79 billion surplus. It seems to me that if we're going to be strong at home as well as strong abroad, that we have to look at bringing that war to a close. MCCAIN: Look, we are sending $700 billion a year overseas to countries that don't like us very much. Some of that money ends up in the hands of terrorist organizations. We have to have wind, tide, solar, natural gas, flex fuel cars and all that but we also have to have offshore drilling and we also have to have nuclear power. Senator Obama opposes both storing and reprocessing of spent nuclear fuel. You can't get there from here and the fact is that we can create 700,000 jobs by building constructing 45 new nuclear power plants by the year 2030. Nuclear power is not only important as far as eliminating our dependence on foreign oil but it's also responsibility as far as climate change is concerned and the issue I have been involved in for many, many years and I'm proud of the work of the work that I've done there along with President Clinton. LEHRER: Before we go to another lead question. Let me figure out a way to ask the same question in a slightly different way here. Are you -- are you willing to acknowledge both of you that this financial crisis is going to affect the way you rule the country as president of the United States beyond the kinds of things that you have already -- I mean, is it a major move? Is it going to have a major affect? OBAMA: There's no doubt it will affect our budgets. There is no doubt about it. Not only -- Even if we get all $700 billion back, let's assume the markets recover, we' holding assets long enough that eventually taxpayers get it back and that happened during the Great Depression when Roosevelt purchased a whole bunch of homes, over time, home values went back up and in fact government made a profit. If we're lucky and do it right, that could potentially happen but in the short term there's an outlay and we may not see that money for a while. And because of the economy's slowing down, I think we can also expect less tax revenue so there's no doubt that as president I'm go doing have to make some tough decision. The only point I want to make is this, that in order to make the tough decisions we have to know what our values are and who we're fighting for and our priorities and if we are spending $300 billion on tax cuts for people who don't need them and weren't even asking for them, and we are leaving out health care which is crushing on people all across the country, then I think we have made a bad decision and I want to make sure we're not shortchanging our long term priorities. MCCAIN: Well, I want to make sure we're not handing the health care system over to the federal government which is basically what would ultimately happen with Senator Obama's health care plan. I want the families to make decisions between themselves and their doctors. Not the federal government. Look. We have to obviously cut spending. I have fought to cut spending. Senator Obama has $800 billion in new spending programs. I would suggest he start by canceling some of those new spending program that he has. We can't I think adjust spending around to take care of the very much needed programs, including taking care of our veterans but I also want to say again a healthy economy with low taxes would not raising anyone's taxes is probably the best recipe for eventually having our economy recover. And spending restraint has got to be a vital part of that. And the reason, one of the major reasons why we're in the difficulties we are in today is because spending got out of control. We owe China $500 billion. And spending, I know, can be brought under control because I have fought against excessive spending my entire career. And I got plans to reduce and eliminate unnecessary and wasteful spending and if there's anybody here who thinks there aren't agencies of government where spending can be cut and their budgets slashed they have not spent a lot of time in Washington. OBAMA: I just want to make this point, Jim. John, it's been your president who you said you agreed with 90 percent of the time who presided over this increase in spending. This orgy of spending and enormous deficits you voted for almost all of his budgets. So to stand here and after eight years and say that you're going to lead on controlling spending and, you know, balancing our tax cuts so that they help middle class families when over the last eight years that hasn't happened I think just is, you know, kind of hard to swallow. LEHRER: Quick response to Senator Obama. MCCAIN: It's well-known that I have not been elected Miss Congeniality in the United States Senate nor with the administration. I have opposed the president on spending, on climate change, on torture of prisoner, on - on Guantanamo Bay. On a -- on the way that the Iraq War was conducted. I have a long record and the American people know me very well and that is independent and a maverick of the Senate and I'm happy to say that I've got a partner that's a good maverick along with me now. LEHRER: All right. Let's go another subject. Lead question, two minutes to you, senator McCain. Much has been said about the lessons of Vietnam. What do you see as the lessons of Iraq? MCCAIN: I think the lessons of Iraq are very clear that you cannot have a failed strategy that will then cause you to nearly lose a conflict. Our initial military success, we went in to Baghdad and everybody celebrated. And then the war was very badly mishandled. I went to Iraq in 2003 and came back and said, we've got to change this strategy. This strategy requires additional troops, it requires a fundamental change in strategy and I fought for it. And finally, we came up with a great general and a strategy that has succeeded. This strategy has succeeded. And we are winning in Iraq. And we will come home with victory and with honor. And that withdrawal is the result of every counterinsurgency that succeeds. MCCAIN: And I want to tell you that now that we will succeed and our troops will come home, and not in defeat, that we will see a stable ally in the region and a fledgling democracy. The consequences of defeat would have been increased Iranian influence. It would have been increase in sectarian violence. It would have been a wider war, which the United States of America might have had to come back. So there was a lot at stake there. And thanks to this great general, David Petraeus, and the troops who serve under him, they have succeeded. And we are winning in Iraq, and we will come home. And we will come home as we have when we have won other wars and not in defeat. LEHRER: Two minutes, how you see the lessons of Iraq, Senator Obama? OBAMA: Well, this is an area where Senator McCain and I have a fundamental difference because I think the first question is whether we should have gone into the war in the first place. Now six years ago, I stood up and opposed this war at a time when it was politically risky to do so because I said that not only did we not know how much it was going to cost, what our exit strategy might be, how it would affect our relationships around the world, and whether our intelligence was sound, but also because we hadn't finished the job in Afghanistan. We hadn't caught bin Laden. We hadn't put al Qaeda to rest, and as a consequence, I thought that it was going to be a distraction. Now Senator McCain and President Bush had a very different judgment. And I wish I had been wrong for the sake of the country and they had been right, but that's not the case. We've spent over $600 billion so far, soon to be $1 trillion. We have lost over 4,000 lives. We have seen 30,000 wounded, and most importantly, from a strategic national security perspective, al Qaeda is resurgent, stronger now than at any time since 2001. We took our eye off the ball. And not to mention that we are still spending $10 billion a month, when they have a $79 billion surplus, at a time when we are in great distress here at home, and we just talked about the fact that our budget is way overstretched and we are borrowing money from overseas to try to finance just some of the basic functions of our government. So I think the lesson to be drawn is that we should never hesitate to use military force, and I will not, as president, in order to keep the American people safe. But we have to use our military wisely. And we did not use our military wisely in Iraq. LEHRER: Do you agree with that, the lesson of Iraq? MCCAIN: The next president of the United States is not going to have to address the issue as to whether we went into Iraq or not. The next president of the United States is going to have to decide how we leave, when we leave, and what we leave behind. That's the decision of the next president of the United States. Senator Obama said the surge could not work, said it would increase sectarian violence, said it was doomed to failure. Recently on a television program, he said it exceed our wildest expectations. But yet, after conceding that, he still says that he would oppose the surge if he had to decide that again today. Incredibly, incredibly Senator Obama didn't go to Iraq for 900 days and never LEHRER: Well, let's go at some of these things... MCCAIN: Senator Obama is the chairperson of a committee that oversights NATO that's in Afghanistan. To this day, he has never had a hearing. LEHRER: What about that point? MCCAIN: I mean, it's remarkable. LEHRER: All right. What about that point? OBAMA: Which point? He raised a whole bunch of them. LEHRER: I know, OK, let's go to the latter point and we'll back up. The point about your not having been... OBAMA: Look, I'm very proud of my vice presidential selection, Joe Biden, who is the chairman of the Senate Foreign Relations Committee, and as he explains, and as John well knows, the issues of Afghanistan, the issues of Iraq, critical issues like that, don't go through my subcommittee because they're done as a committee as a whole. But that's Senate inside baseball. But let's get back to the core issue here. Senator McCain is absolutely right that the violence has been reduced as a consequence of the extraordinary sacrifice of our troops and our military families. They have done a brilliant job, and General Petraeus has done a brilliant job. But understand, that was a tactic designed to contain the damage of the previous four years of mismanagement of this war. And so John likes -- John, you like to pretend like the war started in 2007. You talk about the surge. The war started in 2003, and at the time when the war started, you said it was going to be quick and easy. You said we knew where the weapons of mass destruction were. You were wrong. You said that we were going to be greeted as liberators. You were wrong. You said that there was no history of violence between Shiite and Sunni. And you were wrong. And so my question is... LEHRER: Senator Obama... OBAMA: ... of judgment, of whether or not -- of whether or not -- if the question is who is best-equipped as the next president to make good decisions about how we use our military, how we make sure that we are prepared and ready for the next conflict, then I think we can take a look at our judgment. LEHRER: I have got a lot on the plate here... MCCAIN: I'm afraid Senator Obama doesn't understand the difference between a tactic and a strategy. But the important -- I'd like to tell you, two Fourths of July ago I was in Baghdad. General Petraeus invited Senator Lindsey Graham and me to attend a ceremony where 688 brave young Americans, whose enlistment had expired, were reenlisting to stay and fight for Iraqi freedom and American freedom. I was honored to be there. I was honored to speak to those troops. And you know, afterwards, we spent a lot of time with them. And you know what they said to us? They said, let us win. They said, let us win. We don't want our kids coming back here. And this strategy, and this general, they are winning. Senator Obama refuses to acknowledge that we are winning in Iraq. OBAMA: That's not true. MCCAIN: They just passed an electoral... OBAMA: That's not true. MCCAIN: An election law just in the last few days. There is social, economic progress, and a strategy, a strategy of going into an area, clearing and holding, and the people of the country then become allied with you. They inform on the bad guys. And peace comes to the country, and prosperity. That's what's happening in Iraq, and it wasn't a tactic. LEHRER: Let me see... OBAMA: Jim, Jim, this is a big... MCCAIN: It was a stratagem. And that same strategy will be employed in Afghanistan by this great general. And Senator Obama, who after promising not to vote to cut off funds for the troops, did the incredible thing of voting to cut off the funds for the troops in Iraq and Afghanistan. OBAMA: Jim, there are a whole bunch of things we have got to answer. First of all, let's talk about this troop funding issue because John always brings this up. Senator McCain cut -- Senator McCain opposed funding for troops in legislation that had a timetable, because he didn't believe in a timetable. I opposed funding a mission that had no timetable, and was open- ended, giving a blank check to George Bush. We had a difference on the timetable. We didn't have a difference on whether or not we were going to be funding troops. We had a legitimate difference, and I absolutely understand the difference between tactics and strategy. And the strategic question that the president has to ask is not whether or not we are employing a particular approach in the country once we have made the decision to be there. The question is, was this wise? We have seen Afghanistan worsen, deteriorate. We need more troops there. We need more resources there. Senator McCain, in the rush to go into Iraq, said, you know what? We've been successful in Afghanistan. There is nobody who can pose a threat to us there. This is a time when bin Laden was still out, and now they've reconstituted themselves. Secretary of Defense Robert Gates himself acknowledges the war on terrorism started in Afghanistan and it needs to end there. But we can't do it if we are not willing to give Iraq back its country. Now, what I've said is we should end this war responsibly. We should do it in phases. But in 16 months we should be able to reduce our combat troops, put -- provide some relief to military families and our troops and bolster our efforts in Afghanistan so that we can capture and kill bin Laden and crush al Qaeda. And right now, the commanders in Afghanistan, as well as Admiral Mullen, have acknowledged that we don't have enough troops to deal with Afghanistan because we still have more troops in Iraq than we did before the surge. MCCAIN: Admiral Mullen suggests that Senator Obama's plan is dangerous for America. OBAMA: That's not the case. MCCAIN: That's what ... OBAMA: What he said was a precipitous... MCCAIN: That's what Admiral Mullen said. OBAMA: ... withdrawal would be dangerous. He did not say that. That's not true. MCCAIN: And also General Petraeus said the same thing. Osama bin Laden and General Petraeus have one thing in common that I know of, they both said that Iraq is the central battleground. Now General Petraeus has praised the successes, but he said those successes are fragile and if we set a specific date for withdrawal -- and by the way, Senator Obama's original plan, they would have been out last spring before the surge ever had a chance to succeed. And I'm -- I'm -- understand why Senator Obama was surprised and said that the surge succeeded beyond his wildest expectations. MCCAIN: It didn't exceed beyond mine, because I know that that's a strategy that has worked and can succeed. But if we snatch defeat from the jaws of victory and adopt Senator Obama's plan, then we will have a wider war and it will make things more complicated throughout the region, including in Afghanistan. LEHRER: Afghanistan, lead -- a new -- a new lead question. Now, having resolved Iraq, we'll move to Afghanistan. And it goes to you, Senator Obama, and it's a -- it picks up on a point that's already been made. Do you think more troops -- more U.S. troops should be sent to Afghanistan, how many, and when? OBAMA: Yes, I think we need more troops. I've been saying that for over a year now. And I think that we have to do it as quickly as possible, because it's been acknowledged by the commanders on the ground the situation is getting worse, not better. We had the highest fatalities among U.S. troops this past year than at any time since 2002. And we are seeing a major offensive taking place -- al Qaeda and Taliban crossing the border and attacking our troops in a brazen fashion. They are feeling emboldened. And we cannot separate Afghanistan from Iraq, because what our commanders have said is we don't have the troops right now to deal with Afghanistan. So I would send two to three additional brigades to Afghanistan. Now, keep in mind that we have four times the number of troops in Iraq, where nobody had anything to do with 9/11 before we went in, where, in fact, there was no al Qaeda before we went in, but we have four times more troops there than we do in Afghanistan. And that is a strategic mistake, because every intelligence agency will acknowledge that al Qaeda is the greatest threat against the United States and that Secretary of Defense Gates acknowledged the central front -- that the place where we have to deal with these folks is going to be in Afghanistan and in Pakistan. So here's what we have to do comprehensively, though. It's not just more troops. We have to press the Afghan government to make certain that they are actually working for their people. And I've said this to President Karzai. No. 2, we've got to deal with a growing poppy trade that has exploded over the last several years. No. 3, we've got to deal with Pakistan, because al Qaeda and the Taliban have safe havens in Pakistan, across the border in the northwest regions, and although, you know, under George Bush, with the support of Senator McCain, we've been giving them $10 billion over the last seven years, they have not done what needs to be done to get rid of those safe havens. And until we do, Americans here at home are not going to be safe. LEHRER: Afghanistan, Senator McCain? MCCAIN: First of all, I won't repeat the mistake that I regret enormously, and that is, after we were able to help the Afghan freedom fighters and drive the Russians out of Afghanistan, we basically washed our hands of the region. And the result over time was the Taliban, al Qaeda, and a lot of the difficulties we are facing today. So we can't ignore those lessons of history. Now, on this issue of aiding Pakistan, if you're going to aim a gun at somebody, George Shultz, our great secretary of state, told me once, you'd better be prepared to pull the trigger. I'm not prepared at this time to cut off aid to Pakistan. So I'm not prepared to threaten it, as Senator Obama apparently wants to do, as he has said that he would announce military strikes into Pakistan. We've got to get the support of the people of -- of Pakistan. He said that he would launch military strikes into Pakistan. Now, you don't do that. You don't say that out loud. If you have to do things, you have to do things, and you work with the Pakistani government. Now, the new president of Pakistan, Kardari (sic), has got his hands full. And this area on the border has not been governed since the days of Alexander the Great. I've been to Waziristan. I can see how tough that terrain is. It's ruled by a handful of tribes. And, yes, Senator Obama calls for more troops, but what he doesn't understand, it's got to be a new strategy, the same strategy that he condemned in Iraq. It's going to have to be employed in Afghanistan. And we're going to have to help the Pakistanis go into these areas and obtain the allegiance of the people. And it's going to be tough. They've intermarried with al Qaeda and the Taliban. And it's going to be tough. But we have to get the cooperation of the people in those areas. And the Pakistanis are going to have to understand that that bombing in the Marriott Hotel in Islamabad was a signal from the terrorists that they don't want that government to cooperate with us in combating the Taliban and jihadist elements. So we've got a lot of work to do in Afghanistan. But I'm confident, now that General Petraeus is in the new position of command, that we will employ a strategy which not only means additional troops -- and, by the way, there have been 20,000 additional troops, from 32,000 to 53,000, and there needs to be more. So it's not just the addition of troops that matters. It's a strategy that will succeed. And Pakistan is a very important element in this. And I know how to work with him. And I guarantee you I would not publicly state that I'm going to attack them. OBAMA: Nobody talked about attacking Pakistan. Here's what I said. And if John wants to disagree with this, he can let me know, that, if the United States has al Qaeda, bin Laden, top-level lieutenants in our sights, and Pakistan is unable or unwilling to act, then we should take them out. Now, I think that's the right strategy; I think that's the right policy. And, John, I -- you're absolutely right that presidents have to be prudent in what they say. But, you know, coming from you, who, you know, in the past has threatened extinction for North Korea and, you know, sung songs about bombing Iran, I don't know, you know, how credible that is. I think this is the right strategy. Now, Senator McCain is also right that it's difficult. This is not an easy situation. You've got cross-border attacks against U.S. troops. And we've got a choice. We could allow our troops to just be on the defensive and absorb those blows again and again and again, if Pakistan is unwilling to cooperate, or we have to start making some decisions. And the problem, John, with the strategy that's been pursued was that, for 10 years, we coddled Musharraf, we alienated the Pakistani population, because we were anti-democratic. We had a 20th-century mindset that basically said, "Well, you know, he may be a dictator, but he's our dictator." And as a consequence, we lost legitimacy in Pakistan. We spent $10 billion. And in the meantime, they weren't going after al Qaeda, and they are more powerful now than at any time since we began the war in Afghanistan. That's going to change when I'm president of the United States. MCCAIN: I -- I don't think that Senator Obama understands that there was a failed state in Pakistan when Musharraf came to power. Everybody who was around then, and had been there, and knew about it knew that it was a failed state. But let me tell you, you know, this business about bombing Iran and all that, let me tell you my record. Back in 1983, when I was a brand-new United States congressman, the one -- the person I admired the most and still admire the most, Ronald Reagan, wanted to send Marines into Lebanon. And I saw that, and I saw the situation, and I stood up, and I voted against that, because I was afraid that they couldn't make peace in a place where 300 or 400 or several hundred Marines would make a difference. Tragically, I was right: Nearly 300 Marines lost their lives in the bombing of the barracks. And then we had Somalia -- then we had the first Gulf War. I supported -- I supported that. I supported us going into Bosnia, when a number of my own party and colleagues was against that operation in Bosnia. That was the right thing to do, to stop genocide and to preserve what was necessary inside of Europe. I supported what we did in Kosovo. I supported it because ethnic cleansing and genocide was taking place there. And I have a record -- and Somalia, I opposed that we should turn -- turn the force in Somalia from a peacekeeping force into a peacemaking force, which they were not capable of. So I have a record. I have a record of being involved in these national security issues, which involve the highest responsibility and the toughest decisions that any president can make, and that is to send our young men and women into harm's way. And I'll tell you, I had a town hall meeting in Wolfeboro, New Hampshire, and a woman stood up and she said, "Senator McCain, I want you to do me the honor of wearing a bracelet with my son's name on it." He was 22 years old and he was killed in combat outside of Baghdad, Matthew Stanley, before Christmas last year. This was last August, a year ago. And I said, "I will -- I will wear his bracelet with honor." And this was August, a year ago. And then she said, "But, Senator McCain, I want you to do everything -- promise me one thing, that you'll do everything in your power to make sure that my son's death was not in vain." That means that that mission succeeds, just like those young people who re-enlisted in Baghdad, just like the mother I met at the airport the other day whose son was killed. And they all say to me that we don't want defeat. MCCAIN: A war that I was in, where we had an Army, that it wasn't through any fault of their own, but they were defeated. And I know how hard it is for that -- for an Army and a military to recover from that. And it did and we will win this one and we won't come home in defeat and dishonor and probably have to go back if we fail. OBAMA: Jim, let me just make a point. I've got a bracelet, too, from Sergeant - from the mother of Sergeant Ryan David Jopeck, sure another mother is not going through what I'm going through. No U.S. soldier ever dies in vain because they're carrying out the missions of their commander in chief. And we honor all the service that they've provided. Our troops have performed brilliantly. The question is for the next president, are we making good judgments about how to keep America safe precisely because sending our military into battle is such an enormous step. And the point that I originally made is that we took our eye off Afghanistan, we took our eye off the folks who perpetrated 9/11, they are still sending out videotapes and Senator McCain, nobody is talking about defeat in Iraq, but I have to say we are having enormous problems in Afghanistan because of that decision. And it is not true you have consistently been concerned about what happened in Afghanistan. At one point, while you were focused on Iraq, you said well, we can "muddle through" Afghanistan. You don't muddle through the central front on terror and you don't muddle through going after bin Laden. You don't muddle through stamping out the Taliban. I think that is something we have to take seriously. And when I'm president, I will. LEHRER: New ... MCCAIN: You might think that with that kind of concern that Senator Obama would have gone to Afghanistan, particularly given his responsibilities as a subcommittee chairman. By the way, when I'm subcommittee chairman, we take up the issues under my subcommittee. But the important thing is -- the important thing is I visited Afghanistan and I traveled to Waziristan and I traveled to these places and I know what our security requirements are. I know what our needs are. So the point is that we will prevail in Afghanistan, but we need the new strategy and we need it to succeed. But the important thing is, if we suffer defeat in Iraq, which General Petraeus predicts we will, if we adopted Senator Obama's set date for withdrawal, then that will have a calamitous effect in Afghanistan and American national security interests in the region. Senator Obama doesn't seem to understand there is a connected between the two. LEHRER: I have some good news and bad news for the two of you. You all are even on time, which is remarkable, considering we've been going at it ... OBAMA: A testimony to you, Jim. LEHRER: I don't know about that. But the bad news is all my little five minute things have run over, so, anyhow, we'll adjust as we get there. But the amount of time is even. New lead question. And it goes two minutes to you, Senator McCain, what is your reading on the threat to Iran right now to the security of the United States? MCCAIN: My reading of the threat from Iran is that if Iran acquires nuclear weapons, it is an existential threat to the State of Israel and to other countries in the region because the other countries in the region will feel compelling requirement to acquire nuclear weapons as well. Now we cannot a second Holocaust. Let's just make that very clear. What I have proposed for a long time, and I've had conversation with foreign leaders about forming a league of democracies, let's be clear and let's have some straight talk. The Russians are preventing significant action in the United Nations Security Council. I have proposed a league of democracies, a group of people - a group of countries that share common interests, common values, common ideals, they also control a lot of the world's economic power. We could impose significant meaningful, painful sanctions on the Iranians that I think could have a beneficial effect. The Iranians have a lousy government, so therefore their economy is lousy, even though they have significant oil revenues. So I am convinced that together, we can, with the French, with the British, with the Germans and other countries, democracies around the world, we can affect Iranian behavior. But have no doubt, but have no doubt that the Iranians continue on the path to the acquisition of a nuclear weapon as we speak tonight. And it is a threat not only in this region but around the world. What I'd also like to point out the Iranians are putting the most lethal IEDs into Iraq which are killing young Americans, there are special groups in Iran coming into Iraq and are being trained in Iran. There is the Republican Guard in Iran, which Senator Kyl had an amendment in order to declare them a sponsor of terror. Senator Obama said that would be provocative. So this is a serious threat. This is a serious threat to security in the world, and I believe we can act and we can act with our friends and allies and reduce that threat as quickly as possible, but have no doubt about the ultimate result of them acquiring nuclear weapons. LEHRER: Two minutes on Iran, Senator Obama. OBAMA: Well, let me just correct something very quickly. I believe the Republican Guard of Iran is a terrorist organization. I've consistently said so. What Senator McCain refers to is a measure in the Senate that would try to broaden the mandate inside of Iraq. To deal with Iran. And ironically, the single thing that has strengthened Iran over the last several years has been the war in Iraq. Iraq was Iran's mortal enemy. That was cleared away. And what we've seen over the last several years is Iran's influence grow. They have funded Hezbollah, they have funded Hamas, they have gone from zero centrifuges to 4,000 centrifuges to develop a nuclear weapon. So obviously, our policy over the last eight years has not worked. Senator McCain is absolutely right, we cannot tolerate a nuclear Iran. It would be a game changer. Not only would it threaten Israel, a country that is our stalwart ally, but it would also create an environment in which you could set off an arms race in this Middle East. Now here's what we need to do. We do need tougher sanctions. I do not agree with Senator McCain that we're going to be able to execute the kind of sanctions we need without some cooperation with some countries like Russia and China that are, I think Senator McCain would agree, not democracies, but have extensive trade with Iran but potentially have an interest in making sure Iran doesn't have a nuclear weapon. But we are also going to have to, I believe, engage in tough direct diplomacy with Iran and this is a major difference I have with Senator McCain, this notion by not talking to people we are punishing them has not worked. It has not worked in Iran, it has not worked in North Korea. In each instance, our efforts of isolation have actually accelerated their efforts to get nuclear weapons. That will change when I'm president of the United States. LEHRER: Senator, what about talking? MCCAIN: Senator Obama twice said in debates he would sit down with Ahmadinejad, Chavez and Raul Castro without precondition. Without precondition. Here is Ahmadinenene [mispronunciation], Ahmadinejad, who is, Ahmadinejad, who is now in New York, talking about the extermination of the State of Israel, of wiping Israel off the map, and we're going to sit down, without precondition, across the table, to legitimize and give a propaganda platform to a person that is espousing the extermination of the state of Israel, and therefore then giving them more credence in the world arena and therefore saying, they've probably been doing the right thing, because you will sit down across the table from them and that will legitimize their illegal behavior. The point is that throughout history, whether it be Ronald Reagan, who wouldn't sit down with Brezhnev, Andropov or Chernenko until Gorbachev was ready with glasnost and perestroika. Or whether it be Nixon's trip to China, which was preceded by Henry Kissinger, many times before he went. Look, I'll sit down with anybody, but there's got to be pre-conditions. Those pre-conditions would apply that we wouldn't legitimize with a face to face meeting, a person like Ahmadinejad. Now, Senator Obama said, without preconditions. OBAMA: So let's talk about this. First of all, Ahmadinejad is not the most powerful person in Iran. So he may not be the right person to talk to. But I reserve the right, as president of the United States to meet with anybody at a time and place of my choosing if I think it's going to keep America safe. And I'm glad that Senator McCain brought up the history, the bipartisan history of us engaging in direct diplomacy. Senator McCain mentioned Henry Kissinger, who's one of his advisers, who, along with five recent secretaries of state, just said that we should meet with Iran -- guess what -- without precondition. This is one of your own advisers. Now, understand what this means "without preconditions." It doesn't mean that you invite them over for tea one day. What it means is that we don't do what we've been doing, which is to say, "Until you agree to do exactly what we say, we won't have direct contacts with you." There's a difference between preconditions and preparation. Of course we've got to do preparations, starting with low-level diplomatic talks, and it may not work, because Iran is a rogue regime. But I will point out that I was called naive when I suggested that we need to look at exploring contacts with Iran. And you know what? President Bush recently sent a senior ambassador, Bill Burns, to participate in talks with the Europeans around the issue of nuclear weapons. Again, it may not work, but if it doesn't work, then we have strengthened our ability to form alliances to impose the tough sanctions that Senator McCain just mentioned. And when we haven't done it, as in North Korea -- let me just take one more example -- in North Korea, we cut off talks. They're a member of the axis of evil. We can't deal with them. And you know what happened? They went -- they quadrupled their nuclear capacity. They tested a nuke. They tested missiles. They pulled out of the nonproliferation agreement. And they sent nuclear secrets, potentially, to countries like Syria. When we re-engaged -- because, again, the Bush administration reversed course on this -- then we have at least made some progress, although right now, because of the problems in North Korea, we are seeing it on shaky ground. And -- and I just -- so I just have to make this general point that the Bush administration, some of Senator McCain's own advisers all think this is important, and Senator McCain appears resistant. He even said the other day that he would not meet potentially with the prime minister of Spain, because he -- you know, he wasn't sure whether they were aligned with us. I mean, Spain? Spain is a NATO ally. MCCAIN: Of course. OBAMA: If we can't meet with our friends, I don't know how we're going to lead the world in terms of dealing with critical issues like terrorism. MCCAIN: I'm not going to set the White House visitors schedule before I'm president of the United States. I don't even have a seal yet. Look, Dr. Kissinger did not say that he would approve of face-to- face meetings between the president of the United States and the president -- and Ahmadinejad. He did not say that. OBAMA: Of course not. MCCAIN: He said that there could be secretary-level and lower level meetings. I've always encouraged them. The Iranians have met with Ambassador Crocker in Baghdad. What Senator Obama doesn't seem to understand that if without precondition you sit down across the table from someone who has called Israel a "stinking corpse," and wants to destroy that country and wipe it off the map, you legitimize those comments. This is dangerous. It isn't just naive; it's dangerous. And so we just have a fundamental difference of opinion. As far as North Korea is concerned, our secretary of state, Madeleine Albright, went to North Korea. By the way, North Korea, most repressive and brutal regime probably on Earth. The average South Korean is three inches taller than the average North Korean, a huge gulag. We don't know what the status of the dear leader's health is today, but we know this, that the North Koreans have broken every agreement that they've entered into. And we ought to go back to a little bit of Ronald Reagan's "trust, but verify," and certainly not sit down across the table from -- without precondition, as Senator Obama said he did twice, I mean, it's just dangerous. OBAMA: Look, I mean, Senator McCain keeps on using this example that suddenly the president would just meet with somebody without doing any preparation, without having low-level talks. Nobody's been talking about that, and Senator McCain knows it. This is a mischaracterization of my position. When we talk about preconditions -- and Henry Kissinger did say we should have contacts without preconditions -- the idea is that we do not expect to solve every problem before we initiate talks. And, you know, the Bush administration has come to recognize that it hasn't worked, this notion that we are simply silent when it comes to our enemies. And the notion that we would sit with Ahmadinejad and not say anything while he's spewing his nonsense and his vile comments is ridiculous. Nobody is even talking about that. MCCAIN: So let me get this right. We sit down with Ahmadinejad, and he says, "We're going to wipe Israel off the face of the Earth," and we say, "No, you're not"? Oh, please. OBAMA: No, let me tell... MCCAIN: By the way, my friend, Dr. Kissinger, who's been my friend for 35 years, would be interested to hear this conversation and Senator Obama's depiction of his -- of his positions on the issue. I've known him for 35 years. OBAMA: We will take a look. MCCAIN: And I guarantee you he would not -- he would not say that presidential top level. OBAMA: Nobody's talking about that. MCCAIN: Of course he encourages and other people encourage contacts, and negotiations, and all other things. We do that all the time. LEHRER: We're going to go to a new... MCCAIN: And Senator Obama is parsing words when he says precondition means preparation. OBAMA: I am not parsing words. MCCAIN: He's parsing words, my friends. OBAMA: I'm using the same words that your advisers use. Please, go ahead. LEHRER: New lead question. Russia, goes to you, two minutes, Senator Obama. How do you see the relationship with Russia? Do you see them as a competitor? Do you see them as an enemy? Do you see them as a potential partner? OBAMA: Well, I think that, given what's happened over the last several weeks and months, our entire Russian approach has to be evaluated, because a resurgent and very aggressive Russia is a threat to the peace and stability of the region. Their actions in Georgia were unacceptable. They were unwarranted. And at this point, it is absolutely critical for the next president to make clear that we have to follow through on our six-party -- or the six-point cease-fire. They have to remove themselves from South Ossetia and Abkhazia. It is absolutely important that we have a unified alliance and that we explain to the Russians that you cannot be a 21st-century superpower, or power, and act like a 20th-century dictatorship. And we also have to affirm all the fledgling democracies in that region, you know, the Estonians, the Lithuanians, the Latvians, the Poles, the Czechs, that we are, in fact, going to be supportive and in solidarity with them in their efforts. They are members of NATO. And to countries like Georgia and the Ukraine, I think we have to insist that they are free to join NATO if they meet the requirements, and they should have a membership action plan immediately to start bringing them in. Now, we also can't return to a Cold War posture with respect to Russia. It's important that we recognize there are going to be some areas of common interest. One is nuclear proliferation. They have not only 15,000 nuclear warheads, but they've got enough to make another 40,000, and some of those loose nukes could fall into the hands of al Qaeda. This is an area where I've led on in the Senate, working with a Republican ranking member of the Senate Foreign Relations Committee, Dick Lugar, to deal with the proliferation of loose nuclear weapons. That's an area where we're going to have to work with Russia. But we have to have a president who is clear that you don't deal with Russia based on staring into his eyes and seeing his soul. You deal with Russia based on, what are your -- what are the national security interests of the United States of America? And we have to recognize that the way they've been behaving lately demands a sharp response from the international community and our allies. LEHRER: Two minutes on Russia, Senator McCain. MCCAIN: Well, I was interested in Senator Obama's reaction to the Russian aggression against Georgia. His first statement was, "Both sides ought to show restraint." Again, a little bit of naivete there. He doesn't understand that Russia committed serious aggression against Georgia. And Russia has now become a nation fueled by petro-dollars that is basically a KGB apparatchik-run government. I looked into Mr. Putin's eyes, and I saw three letters, a "K," a "G," and a "B." And their aggression in Georgia is not acceptable behavior. I don't believe we're going to go back to the Cold War. I am sure that that will not happen. But I do believe that we need to bolster our friends and allies. And that wasn't just about a problem between Georgia and Russia. It had everything to do with energy. There's a pipeline that runs from the Caspian through Georgia through Turkey. And, of course, we know that the Russians control other sources of energy into Europe, which they have used from time to time. It's not accidental that the presidents of Latvia, Estonia, Lithuania, Poland, and Ukraine flew to Georgia, flew to Tbilisi, where I have spent significant amount of time with a great young president, Misha Saakashvili. MCCAIN: And they showed solidarity with them, but, also, they are very concerned about the Russian threats to regain their status of the old Russian to regain their status of the old Russian empire. Now, I think the Russians ought to understand that we will support -- we, the United States -- will support the inclusion of Georgia and Ukraine in the natural process, inclusion into NATO. We also ought to make it very clear that the Russians are in violation of their cease-fire agreement. They have stationed additional troops in Abkhazia and South Ossetia. By the way, I went there once, and we went inside and drove in, and there was a huge poster. And this is -- this is Georgian territory. And there was a huge poster of Vladimir Putin, and it said, "Vladimir Putin, our president." It was very clear, the Russian intentions towards Georgia. They were just waiting to seize the opportunity. So, this is a very difficult situation. We want to work with the Russians. But we also have every right to expect the Russians to behave in a fashion and keeping with a -- with a -- with a country who respects international boundaries and the norms of international behavior. And watch Ukraine. This whole thing has got a lot to do with Ukraine, Crimea, the base of the Russian fleet in Sevastopol. And the breakdown of the political process in Ukraine between Tymoshenko and Yushchenko is a very serious problem. So watch Ukraine, and let's make sure that we -- that the Ukrainians understand that we are their friend and ally. LEHRER: You see any -- do you have a major difference with what he just said? OBAMA: No, actually, I think Senator McCain and I agree for the most part on these issues. Obviously, I disagree with this notion that somehow we did not forcefully object to Russians going into Georgia. I immediately said that this was illegal and objectionable. And, absolutely, I wanted a cessation of the violence, because it put an enormous strain on Georgia, and that's why I was the first to say that we have to rebuild the Georgian economy and called for a billion dollars that has now gone in to help them rebuild. Because part of Russia's intentions here was to weaken the economy to the point where President Saakashvili was so weakened that he might be replaced by somebody that Putin favored more. Two points I think are important to think about when it comes to Russia. No. 1 is we have to have foresight and anticipate some of these problems. So back in April, I warned the administration that you had Russian peacekeepers in Georgian territory. That made no sense whatsoever. And what we needed to do was replace them with international peacekeepers and a special envoy to resolve the crisis before it boiled over. That wasn't done. But had it been done, it's possible we could have avoided the issue. The second point I want to make is -- is the issue of energy. Russia is in part resurgent and Putin is feeling powerful because of petro-dollars, as Senator McCain mentioned. That means that we, as one of the biggest consumers of oil -- 25 percent of the world's oil -- have to have an energy strategy not just to deal with Russia, but to deal with many of the rogue states we've talked about, Iran, Venezuela. And that means, yes, increasing domestic production and off-shore drilling, but we only have 3 percent of the world's oil supplies and we use 25 percent of the world's oil. So we can't simply drill our way out of the problem. What we're going to have to do is to approach it through alternative energy, like solar, and wind, and biodiesel, and, yes, nuclear energy, clean-coal technology. And, you know, I've got a plan for us to make a significant investment over the next 10 years to do that. And I have to say, Senator McCain and I, I think agree on the importance of energy, but Senator McCain mentioned earlier the importance of looking at a record. Over 26 years, Senator McCain voted 23 times against alternative energy, like solar, and wind, and biodiesel. And so we -- we -- we've got to walk the walk and not just talk the talk when it comes to energy independence, because this is probably going to be just as vital for our economy and the pain that people are feeling at the pump -- and, you know, winter's coming and home heating oil -- as it is our national security and the issue of climate change that's so important. LEHRER: We've got time for one more lead question segment. We're way out of... LEHRER: Quick response and then... MCCAIN: No one from Arizona is against solar. And Senator Obama says he's for nuclear, but he's against reprocessing and he's against storing. So... OBAMA: That's just not true, John. John, I'm sorry, but that's not true. MCCAIN: ... it's hard to get there from here. And off-shore drilling is also something that is very important and it is a bridge. And we know that, if we drill off-shore and exploit a lot of these reserves, it will help, at temporarily, relieve our energy requirements. And it will have, I think, an important effect on the price of a barrel of oil. OBAMA: I just have to respond very quickly, just to correct -- just to correct the record. MCCAIN: So I want to say that, with the Nunn-Lugar thing... LEHRER: Excuse me, Senator. OBAMA: John? MCCAIN: ... I supported Nunn-Lugar back in the early 1990s when a lot of my colleagues didn't. That was the key legislation at the time and put us on the road to eliminating this issue of nuclear waste and the nuclear fuel that has to be taken care of. OBAMA: I -- I just have to correct the record here. I have never said that I object to nuclear waste. What I've said is that we have to store it safely. And, Senator McCain, he says -- he talks about Arizona. LEHRER: All right. OBAMA: I've got to make this point, Jim. LEHRER: OK. OBAMA: He objects... MCCAIN: I have voted for alternate fuel all of my time... OBAMA: He -- he -- he objects... LEHRER: One at a time, please. OBAMA: He objected... LEHRER: One at a time. MCCAIN: No one can be opposed to alternate energy. OBAMA: All right, fair enough. Let's move on. You've got one more energy -- you've got one more question. LEHRER: This is the last -- last lead question. You have two minutes each. And the question is this, beginning with you, Senator McCain. What do you think the likelihood is that there would be another 9/11-type attack on the continental United States? MCCAIN: I think it's much less than it was the day after 9/11. I think it -- that we have a safer nation, but we are a long way from safe. And I want to tell you that one of the things I'm most proud of, among others, because I have worked across the aisle. I have a long record on that, on a long series of reforms. But after 9/11, Senator Joe Lieberman and I decided that we needed a commission, and that was a commission to investigate 9/11, and find out what happened, and fix it. And we were -- we were opposed by the administration, another area where I differed with this administration. And we were stymied until the families of 9/11 came, and they descended on Washington, and we got that legislation passed. And there were a series of recommendations, as I recall, more than 40. And I'm happy to say that we've gotten written into law most of those reforms recommended by that commission. I'm proud of that work, again, bipartisan, reaching across the aisle, working together, Democrat and Republican alike. So we have a long way to go in our intelligence services. We have to do a better job in human intelligence. And we've got to -- to make sure that we have people who are trained interrogators so that we don't ever torture a prisoner ever again. We have to make sure that our technological and intelligence capabilities are better. We have to work more closely with our allies. I know our allies, and I can work much more closely with them. But I can tell you that I think America is safer today than it was on 9/11. But that doesn't mean that we don't have a long way to go. And I'd like to remind you, also, as a result of those recommendations, we've probably had the largest reorganization of government since we established the Defense Department. And I think that those men and women in those agencies are doing a great job. But we still have a long way to go before we can declare America safe, and that means doing a better job along our borders, as well. LEHRER: Two minutes, Senator Obama. OBAMA: Well, first of all, I think that we are safer in some ways. Obviously, we've poured billions of dollars into airport security. We have done some work in terms of securing potential targets, but we still have a long way to go. We've got to make sure that we're hardening our chemical sites. We haven't done enough in terms of transit; we haven't done enough in terms of ports. And the biggest threat that we face right now is not a nuclear missile coming over the skies. It's in a suitcase. This is why the issue of nuclear proliferation is so important. It is the -- the biggest threat to the United States is a terrorist getting their hands on nuclear weapons. And we -- we are spending billions of dollars on missile defense. And I actually believe that we need missile defense, because of Iran and North Korea and the potential for them to obtain or to launch nuclear weapons, but I also believe that, when we are only spending a few hundred million dollars on nuclear proliferation, then we're making a mistake. The other thing that we have to focus on, though, is al Qaeda. They are now operating in 60 countries. We can't simply be focused on Iraq. We have to go to the root cause, and that is in Afghanistan and Pakistan. That's going to be critical. We are going to need more cooperation with our allies. And one last point I want to make. It is important for us to understand that the way we are perceived in the world is going to make a difference, in terms of our capacity to get cooperation and root out terrorism. And one of the things that I intend to do as president is to restore America's standing in the world. We are less respected now than we were eight years ago or even four years ago. OBAMA: And this is the greatest country on Earth. But because of some of the mistakes that have been made -- and I give Senator McCain great credit on the torture issue, for having identified that as something that undermines our long-term security -- because of those things, we, I think, are going to have a lot of work to do in the next administration to restore that sense that America is that shining beacon on a hill. LEHRER: Do you agree there's much to be done in a new administration to restore... MCCAIN: But in the case of missile defense, Senator Obama said it had to be, quote, "proven." That wasn't proven when Ronald Reagan said we would do SDI, which is missile defense. And it was major -- a major factor in bringing about the end of the Cold War. We seem to come full circle again. Senator Obama still doesn't quite understand -- or doesn't get it -- that if we fail in Iraq, it encourages al Qaeda. They would establish a base in Iraq. The consequences of defeat, which would result from his plan of withdrawal and according to date certain, regardless of conditions, according to our military leaders, according to every expert, would lead to defeat -- possible defeat, loss of all the fragile sacrifice that we've made of American blood and treasure, which grieves us all. All of that would be lost if we followed Senator Obama's plan to have specific dates with withdrawal, regardless of conditions on the ground. And General Petraeus says we have had great success, but it's very fragile. And we can't do what Senator Obama wants to do. That is the central issue of our time. And I think Americans will judge very seriously as to whether that's the right path or the wrong path and who should be the next president of the United States. LEHRER: You see the same connections that Senator McCain does? OBAMA: Oh, there's no doubt. Look, over the last eight years, this administration, along with Senator McCain, have been solely focused on Iraq. That has been their priority. That has been where all our resources have gone. In the meantime, bin Laden is still out there. He is not captured. He is not killed. Al Qaeda is resurgent. In the meantime, we've got challenges, for example, with China, where we are borrowing billions of dollars. They now hold a trillion dollars' worth of our debt. And they are active in countries like -- in regions like Latin America, and Asia, and Africa. They are -- the conspicuousness of their presence is only matched by our absence, because we've been focused on Iraq. We have weakened our capacity to project power around the world because we have viewed everything through this single lens, not to mention, look at our economy. We are now spending $10 billion or more every month. And that means we can't provide health care to people who need it. We can't invest in science and technology, which will determine whether or not we are going to be competitive in the long term. There has never been a country on Earth that saw its economy decline and yet maintained its military superiority. So this is a national security issue. We haven't adequately funded veterans' care. I sit on the Veterans Affairs Committee, and we've got -- I meet veterans all across the country who are trying to figure out, "How can I get disability payments? I've got post-traumatic stress disorder, and yet I can't get treatment." So we have put all chips in, right there, and nobody is talking about losing this war. What we are talking about is recognizing that the next president has to have a broader strategic vision about all the challenges that we face. That's been missing over the last eight years. That sense is something that I want to restore. MCCAIN: I've been involved, as I mentioned to you before, in virtually every major national security challenge we've faced in the last 20-some years. There are some advantages to experience, and knowledge, and judgment. And I -- and I honestly don't believe that Senator Obama has the knowledge or experience and has made the wrong judgments in a number of areas, including his initial reaction to Russian invasion -- aggression in Georgia, to his -- you know, we've seen this stubbornness before in this administration to cling to a belief that somehow the surge has not succeeded and failing to acknowledge that he was wrong about the surge is -- shows to me that we -- that -- that we need more flexibility in a president of the United States than that. As far as our other issues that he brought up are concerned, I know the veterans. I know them well. And I know that they know that I'll take care of them. And I've been proud of their support and their recognition of my service to the veterans. And I love them. And I'll take care of them. And they know that I'll take care of them. And that's going to be my job. But, also, I have the ability, and the knowledge, and the background to make the right judgments, to keep this country safe and secure. Reform, prosperity, and peace, these are major challenges to the United States of America. I don't think I need any on-the-job training. I'm ready to go at it right now. OBAMA: Well, let me just make a closing point. You know, my father came from Kenya. That's where I get my name. And in the '60s, he wrote letter after letter to come to college here in the United States because the notion was that there was no other country on Earth where you could make it if you tried. The ideals and the values of the United States inspired the entire world. I don't think any of us can say that our standing in the world now, the way children around the world look at the United States, is the same. And part of what we need to do, what the next president has to do -- and this is part of our judgment, this is part of how we're going to keep America safe -- is to -- to send a message to the world that we are going to invest in issues like education, we are going to invest in issues that -- that relate to how ordinary people are able to live out their dreams. And that is something that I'm going to be committed to as president of the United States. LEHRER: Few seconds. We're almost finished. MCCAIN: Jim, when I came home from prison, I saw our veterans being very badly treated, and it made me sad. And I embarked on an effort to resolve the POW-MIA issue, which we did in a bipartisan fashion, and then I worked on normalization of relations between our two countries so that our veterans could come all the way home. I guarantee you, as president of the United States, I know how to heal the wounds of war, I know how to deal with our adversaries, and I know how to deal with our friends. LEHRER: And that ends this debate tonight. On October 2, next Thursday, also at 9:00 p.m. Eastern time, the two vice presidential candidates will debate at Washington University in St. Louis. My PBS colleague, Gwen Ifill, will be the moderator. For now, from Oxford, Mississippi, thank you, senators, both. I'm Jim Lehrer. Thank you, and good night.
