# Presidential Campaign Debate in Philadelphia

**Date:** September 23, 1976
**Source:** https://www.presidency.ucsb.edu/documents/presidential-campaign-debate-1

---

THE MODERATOR. I am Edwin Newman, moderator of this first debate of the 1976 campaign between Gerald R. Ford of Michigan, Republican candidate for President, and Jimmy Carter of Georgia, Democratic candidate for President. We thank you, President Ford, and we thank you, Governor Carter, for being with us tonight. There are to be three debates between the Presidential candidates and one between the Vice-Presidential candidates. All are being arranged by the League of Women Voters Education Fund. Tonight's debate, the first between Presidential candidates in 16 years and the first ever in which an incumbent President has participated, is taking place before an audience in the Walnut Street Theatre in Philadelphia, just 3 blocks from Independence Hall. The television audience may reach 100 million in the United States and many millions overseas. Tonight's debate focuses on domestic and economic policy. Questions will be put by Frank Reynolds of ABC News, James Gannon of the Wall Street Journal, and Elizabeth Drew of the New Yorker magazine. Under the agreed rules the first question will go to Governor Carter. That was decided by the toss of a coin. He will have up to 3 minutes to answer. One follow-up question will be permitted with up to 2 minutes to reply. President Ford will then have 2 minutes to respond. The next question will go to President Ford, with the same time arrangements, and questions will continue to be alternated between the candidates. Each man will make a 3-minute statement at the end, Governor Carter to go first. President Ford and Governor Carter do not have any notes or prepared remarks with them this evening. Mr. Reynolds, your question for Governor Carter. MR. REYNOLDS. Mr. President, Governor Carter. Governor, in an interview with the Associated Press last week, you said you believed these debates would alleviate a lot of concern that some voters have about you. Well, one of those concerns-not an uncommon one about candidates in any year-is that many voters say they don't really know where you stand. Now, you have made jobs your number one priority, and you have said you are committed to a drastic reduction in unemployment. Can you say now, Governor, in specific terms what your first step would be next January, if you are elected, to achieve that? MR. CARTER. Yes. First of all it's to recognize the tremendous economic strength of this country and to set the putting back to work of our people as a top priority. This is an effort that ought to be done primarily by strong leadership in the White House, the inspiration of our people, the tapping of business, agriculture, industry, labor, and government at all levels to work on this project. We will never have an end to the inflationary spiral, and we will never have a balanced budget until we get our people back to work. There are several things that can be done specifically that are not now being done: first of all, to channel research and development funds into areas that will provide large numbers of jobs; secondly, we need to have a commitment in the private sector to cooperate with government in matters like housing. Here, a very small investment of taxpayers' money in the housing field can bring large numbers of extra jobs, in the guarantee of mortgage loans, in the putting forward of 202 programs for housing for older people and so forth, to cut down the roughly 20-percent unemployment that now exists in the construction industry. Another thing is to deal with our needs in the central cities where the unemployment rate is extremely high-sometimes among minority groups, those who don't speak English or who are black or young people-a 40-percent unemployment. Here, a CCC [Civilian Conservation Corps]-type program would be appropriate, to channel money into the sharing with private sector and also local and State governments to employ young people who are now out of work. Another very important aspect of our economy would be to increase production in every way possible, to hold down taxes on individuals, and to shift the tax burdens on to those who have avoided paying taxes in the past. These kinds of specific things, none of which are being done now, would be a great help in reducing unemployment. There is an additional factor that needs to be done and covered very succinctly, and that is to make sure that we have a good relationship between management, business on the one hand and labor on the other. In a lot of places where unemployment is very high, we might channel specific, targeted job opportunities by paying part of the salary of unemployed people and also sharing with local governments the payment of salaries, which would let us cut down the unemployment rate much lower before we hit the inflationary level. But I believe that by the end of the first 4 years of the next term, we could have the unemployment rate down to 3 percent-adult unemployment-which is about 4 to 4Â½ percent overall, a controlled inflation rate, and have a balanced growth of about 4 to 6 percent, around 5 percent, which would give us a balanced budget. MR. REYNOLDS. Governor, in the event you are successful and you do achieve a drastic drop in unemployment, that is likely to create additional pressure on prices. How willing are you to consider an incomes policy; in other words, wage and price controls? MR. CARTER. Well, we now have such a low utilization of our productive capacity, about 73 percent-I think it's about the lowest since the Great Depression years-and such a high unemployment rate now-7.9 percent-that we have a long way to go in getting people to work before we have the inflationary pressures. And I think this would be easy to accomplish, to get jobs now without having the strong inflationary pressures that would be necessary. I would not favor the payment of a given fixed income to people unless they are not able to work. But with tax incentives for the low-income groups, we could build up their income levels above the poverty level and not make welfare more profitable than work. THE MODERATOR. Mr. President, your response? THE PRESIDENT. I don't believe that Mr. Carter has been any more specific in this case than he has been on many other instances. I notice particularly that he didn't endorse the Humphrey-Hawkins bill, which he has on occasions and which is included as a part of the Democratic platform. That legislation allegedly would help our unemployment, but we all know that it would have controlled our economy. It would have added $10 to $30 billion each year in additional expenditures by the Federal Government. It would have called for export controls on agricultural products. In my judgment the best way to get jobs is to expand the private sector, where five out of six jobs today exist in our economy. We can do that by reducing Federal taxes, as I proposed about a year ago when I called for a tax reduction of $28 billion, three-quarters of it to go to private taxpayers and one-quarter to the business sector. We could add to jobs in the major metropolitan areas by a proposal that I recommended that would give tax incentives to business to move into the inner city and to expand or to build new plants so that they would take a plant or expand a plant where people are and people are currently unemployed. We could also help our youth with some of the proposals that would give to young people an opportunity to work and learn at the same time, just like we give money to young people who are going to college. Those are the kind of specifics that I think we have to discuss on these debates, and these are the kind of programs that I will talk about on my time. THE MODERATOR. Mr. Gannon, your question to President Ford. MR. GANNON. Mr. President, I would like to continue for a moment on this question of taxes which you have just raised. You have said that you favor more tax cuts for middle-income Americans, even those earning up to $30,000 a year. That presumably would cost the Treasury quite a bit of money in lost revenue. In view of the very large budget deficits that you have accumulated and that are still in prospect, how is it possible to promise further tax cuts and to reach your goal of balancing the budget? THE PRESIDENT. At the time, Mr. Gannon, that I made the recommendation for a $28 billion tax cut-three-quarters of it to go to individual taxpayers and 25 percent to American business-I said at the same time that we had to hold the lid on Federal spending; that for every dollar of a tax reduction, we had to have an equal reduction in Federal expenditures-a one-for-one proposition. And I recommended that to the Congress with a budget ceiling of $395 billion, and that would have permitted us to have a $28 billion tax reduction. In my tax reduction program for middle-income taxpayers, I recommended that the Congress increase personal exemptions from $750 per person to $1,000 per person. That would mean, of course, that for a family of four that that family would have $1,000 more personal exemption, money that they could spend for their own purposes, money that the Government wouldn't have to spend. But if we keep the lid on Federal spending, which I think we can with the help of the Congress, we can justify fully a $28 billion tax reduction. In the budget that I submitted to the Congress in January of this year, I recommended a 50-percent cutback in the rate of growth of Federal spending. For the last 10 years the budget of the United States has grown from about 11 percent per year. We can't afford that kind of growth in Federal spending. And in the budget that I recommended, we cut it in half-a growth rate of 5 to 5 1/2 percent. With that kind of limitation on Federal spending, we can fully justify the tax reductions that I have proposed. And it seems to me, with the stimulant of more money in the hands of the taxpayer and with more money in the hands of business to expand, to modernize, to provide more jobs, our economy will be stimulated so that we will get more revenue, and we will have a more prosperous economy. MR. GANNON. Mr. President, to follow up a moment, the Congress has passed a tax bill which is before you now which did not meet exactly the sort of outline that you requested. What is your intention on that bill since it doesn't meet your requirements? Do you plan to sign that bill? THE PRESIDENT. That tax bill does not entirely meet the criteria that I established. I think the Congress should have added another $10 billion reduction in personal income taxes, including the increase of personal exemptions from $750 to $1,000. And Congress could have done that if the budget committees of the Congress and the Congress as a whole had not increased the spending that I recommended in the budget. I am sure you know that in the resolutions passed by the Congress, they have added about $17 billion in more spending by the Congress over the budget that I recommended. So, I would prefer in that tax bill to have an additional tax cut and a further limitation on Federal spending. Now, this tax bill that hasn't reached the White House yet-but is expected in a day or two-it's about 1,500 pages. It has some good provisions in it; it has left out some that I have recommended, unfortunately. On the other hand, when you have a bill of that magnitude, with those many provisions, a President has to sit and decide if there is more good than bad. And from the analysis that I have made so far, it seems to me that that tax bill does justify my signature and my approval. THE MODERATOR. Governor Carter, your response. MR. CARTER. Well, Mr. Ford is changing considerably his previous philosophy. The present tax structure is a disgrace to this country. It's just a welfare program for the rich. As a matter of fact, 25 percent of the total tax deductions go for only 1 percent of the richest people in this country, and over 50 percent of the tax credits go for the 14 percent of the richest people in this country. When Mr. Ford first became President in August of 1974, the first thing he did in October was to ask for a $4.7 billion increase in taxes on our people in the midst of the heaviest recession since the Great Depression of the 1940's. In January of 1975, he asked for a tax change, a $5.6 billion increase on low and middle-income private individuals, a $6 1/2 billion decrease on the corporations and the special interests. In December of 1975, he vetoed the roughly $18 to $20 billion tax reduction bill that had been passed by the Congress. And then he came back later on in January of this year, and he did advocate a $10 billion tax reduction, but it would be offset by a $6 billion increase this coming January in deductions for social security payments and for unemployment compensation. The whole philosophy of the Republican Party, including my opponent, has been to pile on taxes on low-income people, to take them off on the corporations. As a matter of fact, since the late sixties when Mr. Nixon took office, we've had a reduction in the percentage of taxes paid by corporations from 30 percent down to about 20 percent. We've had an increase in taxes paid by individuals, payroll taxes, from 14 percent up to 20 percent. This is what the Republicans have done to us. This is why tax reform is so important. THE MODERATOR. Mrs. Drew, your question to Governor Carter. MS. DREW. Governor Carter, you've proposed a number of new or enlarged programs, including jobs and health, welfare reform, child care, aid to education, aid to cities, changes in social security and housing subsidies. You've also said that you want to balance the budget by the end of your first term. Now, you haven't put a price tag on those programs, but even if we priced them conservatively, and we count for full employment by the end of your first term, and we count for the economic growth that would occur during that period, there still isn't enough money to pay for those programs and balance the budget by any estimates that I've been able to see. So, in that case, what would give? MR. CARTER. Well, as a matter of fact, there is. If we assume a rate of growth of our economy equivalent to what it was during President Johnson and President Kennedy, even before the Vietnamese war, and if we assume that, at the end of the 4-year period we can cut our unemployment rate down to 4 to 4Â½ percent. Under those circumstances, even assuming no elimination of unnecessary programs and assuming an increase in the allotment of money to finance programs increasing as the inflation rate does, my economic projects, I think confirmed by the House and the Senate committees, have been, with a $60 billion extra amount of money that can be spent in fiscal year '81-which would be the last year of this next term-within that $60 billion increase, there would be fit the programs that I promised the American people. I might say, too, that if we see that these goals cannot be reached-and I believe they are reasonable goals-then I would cut back on the rate of implementation of new programs in order to accommodate a balanced budget by fiscal year '81, which is the last year of the next term. I believe that we ought to have a balanced budget during normal economic circumstances. And these projections have been very carefully made. I stand behind them. And if they should be in error slightly on the down side, then I will phase in the programs that we've advocated more slowly. Ms. DREW. Governor, according to the budget committees of the Congress that you referred to, if we get to full employment, what they project at a 4-percent unemployment and, as you say, even allowing for the inflation in the programs, there would not be anything more than a surplus of $5 billion by 1981. Conservative estimates of your programs would be that they'd be about $85 to $100 billion. So, how do you say that you are going to be able to do these things and balance the budget? MR. CARTER. Well, the assumption that you have described that's different is in the rate of growth of our economy. MS. DREW. No, they took that into account in those figures. MR. CARTER. I believe that it's accurate to say that the committees to whom you refer, with the employment rate that you state and with the 5 to 5 1/2 percent growth rate in our economy, that the projections would be a $60 billion increase in the amount of money that we have to spend in 1981 compared to now. And in that framework would be fit any improvements in the programs. Now, this does not include any extra control over unnecessary spending, the weeding out of obsolete or obsolescent programs. We will have a safety version built in with complete reorganization of the executive branch of Government, which I am pledged to do. The present bureaucratic structure of the Federal Government is a mess. And if I am elected President, that's going to be a top priority of mine-to completely revise the structure of the Federal Government to make it economical, efficient, purposeful, and manageable for a change. And also, I am going to institute zero-base budgeting, which I used 4 years in Georgia, which assesses every program every year and eliminates those programs that are obsolete or obsolescent. But with these projections we will have a balanced budget by fiscal year 1981 if I am elected President, keep my promises to the American people. And it's just predicated on very modest, but I think accurate, projections of employment increases and a growth in our national economy equal to what was experienced under Kennedy, Johnson, before the Vietnam war. THE MODERATOR. President Ford. THE PRESIDENT. If it is true that there will be a $60 billion surplus by fiscal year 1981, rather than spend that money for all the new programs that Governor Carter recommends and endorses and which are included in the Democratic platform, I think the American taxpayer ought to get an additional tax break, a tax reduction of that magnitude. I feel that the taxpayers are the ones that need the relief. I don't think we should add additional programs of the magnitude that Governor Carter talks about. It seems to me that our tax structure today has rates that are too high. But I am very glad to point out has since 1969, during a Republican administration, we have had 10 million people taken off of the tax rolls at the lower end of the taxpayer area. And at the same time, assuming that I sign the tax bill that was mentioned by Mr. Gannon, we will, in the last two tax bills, have increased the minimum tax on all wealthy taxpayers. And I believe that by eliminating 10 million taxpayers in the last 8 years and by putting a heavier tax burden on those in the higher tax brackets, plus the other actions that have been taken, we can give taxpayers adequate tax relief. Now, it seems to me that as we look at the recommendations of the budget committees and our own projections, there isn't going to be any $60 billion dividend. I've heard of those dividends in the past. It always happens. We expected one at the time of the Vietnam war, but it was used up before we ever ended the war, and taxpayers never got the adequate relief they deserved. THE MODERATOR. Mr. Reynolds. MR. REYNOLDS. Mr. President, when you came into office, you spoke very eloquently of the need for a time for healing. And very early in your administration you went out to Chicago and you announced, you proposed a program of case-by-case pardons for draft resisters to restore them to full citizenship. Some 14,000 young men took advantage of your offer, but another 90,000 did not. In granting the pardon to former President Nixon, sir, part of your rationale was to put Watergate behind us, to, if I may quote you again, truly end "our long national nightmare." Why does not the same rationale apply now, today, in our Bicentennial Year to the young men who resisted in Vietnam and many of them still in exile abroad? THE PRESIDENT. The amnesty program that I recommended in Chicago in September of 1974 would give to all draft evaders and military deserters the opportunity to earn their good record back. About 14 to 15,000 did take advantage of that program. We gave them ample time. I am against an across-the-board pardon of draft evaders or military deserters. Now, in the case of Mr. Nixon, the reason the pardon was given was that when I took office this country was in a very, very divided condition. There was hatred: there was divisiveness; people had lost faith in their government in many, many respects. Mr. Nixon resigned, and I became President. It seemed to me that if I was to adequately and effectively handle the problems of high inflation, a growing recession, the involvement of the United States still in Vietnam, that I had to give 100 percent of my time to those two major problems. Mr. Nixon resigned; that is disgrace-the first President out of 38 that ever resigned from public office under pressure. So, when you look at the penalty that he paid, and when you analyze the requirements that I had to spend all of my time working on the economy, which was in trouble, that I inherited, working on our problems in Southeast Asia, which were still plaguing us, it seemed to me that Mr. Nixon had been penalized enough by his resignation in disgrace. And the need and necessity for me to concentrate on the problems of the country fully justified the action that I took. MR. REYNOLDS. I take it, then, sir, that you do not believe that you are going to reconsider and think about those 90,000 who are still abroad? Have they not been penalized enough? Many of them have been there for years. THE PRESIDENT. Well, Mr. Carter has indicated that he would give a blanket pardon to all draft evaders. I do not agree with that point of view. I gave in September of 1974 an opportunity for all draft evaders, all deserters, to come in voluntarily, clear their records by earning an opportunity to restore their good citizenship. I think we gave them a good opportunity. I don't think we should go any further. THE MODERATOR.. Governor Carter. MR. CARTER. Well, I think it's very difficult for President Ford to explain the difference between the pardon of President Nixon and his attitude toward those who violated the draft laws. As a matter of fact now, I don't advocate amnesty; I advocate pardon. There is a difference, in my opinion, and in accordance with the ruling of the Supreme Court and in accordance with the definition in the dictionary. Amnesty means that what you did was right. Pardon means that what you did, whether it's right or wrong, you are forgiven for it. And I do advocate a pardon for draft evaders. I think it's accurate to say that 2 years ago, when Mr. Ford put in this amnesty, that three times as many deserters were excused as were the ones who evaded the draft. But I think that now is the time to heal our country after the Vietnam war. And I think that what the people are concerned about is not the pardon or the amnesty of those who evaded the draft, but whether or not our crime system is fair. We have got a sharp distinction drawn between white collar crime. The big shots who are rich, who are influential, very seldom go to jail. Those who are poor and who have no influence quite often are the ones who are punished. And the whole subject of crime is one that concerns our people very much. And I believe that the fairness of it is what is the major problem that addresses our leader, and this is something that hasn't been addressed adequately by this administration. But I hope to have a complete responsibility on my shoulders to help bring' about a fair criminal justice system and also to bring about an end to the divisiveness that has occurred in our country as a result of the Vietnam war. THE MODERATOR. Mr. Gannon. MR. GANNON. Governor Carter, you have promised a sweeping overhaul of the Federal Government including a reduction in the number of Government agencies you say would go down to about 200 from some 1,900. That sounds indeed like a very deep cut in the Federal Government. But isn't it a fact that you are not really talking about fewer Federal employees or less Government spending, but rather that you are talking about reshaping the Federal Government, not making it smaller? MR. CARTER. Well, I've been through this before, Mr. Gannon, as the Governor of Georgia. When I took over we had a bureaucratic mess like we have in Washington now. And we had 300 agencies, departments, bureaus, commissions-some fully budgeted, some not-but all having responsibility to carry out that was in conflict. And we cut those 300 agencies and so forth down substantially; we eliminated 278 of them. We set up a simple structure of government that could be administered fairly, and it was a tremendous success. It hasn't been undone since I was there. It resulted also in an ability to reshape our court system, our prison system, our education system, our mental health programs, and a clear assignment of responsibility and authority, and also to have our people once again understand and control our Government. I intend to do the same thing if I am elected President. When I get to Washington, coming in as an outsider, one of the major responsibilities that I will have on my shoulder is a complete reorganization of the executive branch of Government. We now have a greatly expanded White House staff. When Mr. Nixon went in office, for instance, we had $3 1/2 million spent on the White House and its staff. That has escalated now to $16Â½ million in the last Republican administration. This needs to be changed. We need to put the responsibilities back on the Cabinet members. We also need to have a great reduction in agencies and programs. For instance, we now have in the health area 302 different programs administered by 11 major departments and agencies. Sixty other advisory commissions are responsible for this. Medicaid is in one agency; Medicare is in a different one; the check on the quality of health care is in a different one. None of them are responsible for health care itself. This makes it almost impossible for us to have a good health program. We have just advocated this past week a consolidation of the responsibilities for energy. Our country now has no comprehensive energy program or policy. We have 20 different agencies in the Federal Government responsible for the production, the regulation, the information about energy, the conservation of energy spread all over Government. This is a gross waste of money. So, tough, competent management of Government, giving us a simple, efficient, purposeful, and manageable Government will be a great step forward. And if I am elected-and I intend to be-then it's going to be done. MR. GANNON. Well, I'd like to press my question on the number of Federal employees-whether you would really plan to reduce the overall number or merely put them in different departments and relabel them? In your energy plan, you consolidate a number of agencies into one, or you would, but does that really change the overall? MR. CARTER. I can't say for sure that we would have fewer Federal employees when I go out of office than when I come in. It took me about 3 years to completely reorganize the Georgia government. The last year I was in office our budget was actually less than it was a year before, which showed a great improvement. Also, we had a 2-percent increase in the number of employees the last year, but it was a tremendous shift from administrative jobs into the delivery of services. For instance, we completely revised our prison system. We established 84 new mental health treatment centers, and we shifted people out of administrative jobs into the field to deliver better services. The same thing will be done at the Federal Government level. I accomplished this with substantial reductions in employees in some departments. For instance, in the Transportation Department we cut back about 25 percent of the total number of employees. In giving our people better mental health care, we increased the number of employees. But the efficiency of it, the simplicity of it, the ability of people to understand their own government and control it was a substantial benefit derived from complete reorganization. We have got to do this at the Federal Government level. If we don't, the bureaucratic mess is going to continue. There is no way for our people now to understand what their Government is; there is no way to get the answer to a question. When you come to Washington to try to-as a Governor-to try to begin a new program for your people, like the treatment of drug addicts, I found there were 13 different Federal agencies that I had to go to to manage the drug treatment program. In the Georgia government we only had one agency responsible for drug treatment. This is the kind of change that would be made. And it would be of tremendous benefit in long-range planning, in tight budgeting, saving the taxpayers' money, making the Government more efficient, cutting down on bureaucratic waste, having a clear delineation of authority and responsibility of employees, and giving our people a better chance to understand and control their Government. THE MODERATOR. President Ford. THE PRESIDENT. I think the record should show, Mr. Newman, that the Bureau of Census-we checked it just yesterday-indicates that in the 4 years that Governor Carter was Governor of the State of Georgia, expenditures by the government went up over 50 percent. Employees of the government in Georgia during his term of office went up over 25 percent. And the figures also show that the bonded indebtedness of the State of Georgia during his Governorship went up over 20 percent. And there was some very interesting testimony given by Governor Carter's successor, Governor Busbee, before a Senate committee a few months ago, on how he found the Medicaid program when he came into office following Governor Carter. He testified, and these are his words, the present Governor of Georgia, he says he found the Medicaid program in Georgia in shambles. Now, let me talk about what we've done in the White House as far as Federal employees are concerned. The first order that I issued after I became President was to cut or eliminate the prospective 40,000 increase in Federal employees that had been scheduled by my predecessor. And in the term that I have been President-some 2 years-we have reduced Federal employment by 11,000. In the White House staff itself, when I became President we had roughly 540 employees. We now have about 485 employees. So, we've made a rather significant reduction in the number of employees on the White House staff working for the President. So, I think our record of cutting back employees, plus the failure on the part of the Governor's program to actually save employment in Georgia, shows which is the better plan. THE MODERATOR. Mrs. Drew. Ms. DREW. Mr. President, at Vail, after the Republican convention, you announced that you would now emphasize five new areas. Among those were jobs and housing and health, improved recreational facilities for Americans, and you also added crime. You also mentioned education. For 2 years you've been telling us that we couldn't do very much in these areas because we couldn't afford it, and in fact, we do have a $50 billion deficit now. In rebuttal to Governor Carter a little bit earlier, you said that if there were to be any surplus in the next few years, you thought it should be turned back to the people in the form of tax relief. So, how are you going to pay for any new initiatives in these areas you announced at Vail you were going to now stress? THE PRESIDENT. Well, in the last 2 years, as I indicated before, we had a very tough time. We were faced with heavy inflation-over 12 percent; we were faced with substantial unemployment. But in the last 24 months we've turned the economy around, and we've brought inflation down to under 6 percent. And we have added employment of about 4 million in the last 17 months to the point where we have 88 million people working in America today, the most in the history of the country. The net result is we are going to have some improvement in our receipts, and I think we will have some decrease in our disbursements. We expect to have a lower deficit in fiscal year 1978. We feel that with this improvement in the economy, we feel with more receipts and fewer disbursements, we can, in a moderate way, increase, as I recommended, over the next 10 years a new parks program that would cost a billion and a half dollars, doubling our national park system. We have recommended that in the housing program we can reduce down payments and moderate monthly payments. But that doesn't cost any more as far as the Federal Treasury is concerned. We believe that we can do a better job in the area of crime, but that requires tougher sentencing-mandatory, certain prison sentences for those who violate our criminal laws. We believe that you can revise the Federal Criminal Code, which has not been revised in a good many years. That doesn't cost any more money. We believe that you can do something more effectively with a moderate increase in money in the drug abuse program. We feel that in education we can have a slight increase, not a major increase. It's my understanding that Governor Carter has indicated that he approves of a $30 billion expenditure by the Federal Government, as far as education is concerned. At the present time we are spending roughly $3,500 million. I don't know where that money would come from. But, as we look at the quality of life programs-jobs, health, education, crime, recreation-we feel that as we move forward with a healthier economy, we can absorb the small, necessary costs that will be required. Ms. DREW. But, sir, in the next few years would you try to reduce the deficit, would you spend money for these programs that you have just outlined, or would you, as you said earlier, return whatever surplus you got to the people in the form of tax relief? THE PRESIDENT. We feel that with the programs that I have recommended, the additional $10 billion tax cut, with the moderate increases in the quality of life area, we can still have a balanced budget, which I will submit to the Congress in January of 1978. We won't wait 1 year or 2 years longer, as Governor Carter indicates. As the economy improves, and it is improving-our gross national product this year will average about 6-percent increase over last year-we will have a lower rate of inflation for the calendar year this year, something slightly under 6 percent; employment will be up; revenues will be up. We will keep the lid on some of these programs that we can hold down, as we have a little extra money to spend for those quality of life programs, which I think are needed and necessary. Now, I cannot and would not endorse the kind of programs that Governor Carter recommends. He endorses the Democratic platform which, as I read it, calls for approximately 60 additional programs. We estimate that those programs would add $100 billion minimum and probably $200 billion maximum each year to the Federal budget. Those programs you cannot afford and give tax relief. We feel that you can hold the line and restrain Federal spending, give a tax reduction, and still have a balanced budget by 1978. THE MODERATOR. Governor Carter. MR. CARTER. Well, Mr. Ford takes the same attitude that the Republicans always take. In the last 3 months before an election, they are always for the programs that they fight the other 3 1/2 years. I remember when Herbert Hoover was against jobs for people. I remember when All Landon was against social security. And later President Nixon-16 years ago-was telling the public that John Kennedy's proposals would bankrupt the country and would double the cost. The best thing to do is to look at the record of Mr. Ford's administration and Mr. Nixon's before his. We had last year a $65 billion deficit, the largest deficit in the history of our country, more of a deficit spending than we had in the entire 8-year period under President Johnson and President Kennedy. We've got 500,000 more Americans out of jobs today than were out of work 3 months ago. And since Mr. Ford has been in office, in 2 years we've had a 50-percent increase in unemployment, from 5 million people out of work to 2 1/2 million more people out of work, or a total of 7 1/2 million. We've also got a comparison between himself and Mr. Nixon. He's got four times the size of the deficits that Mr. Nixon even had himself. This talking about more people at work is distorted because with the 14-percent increase in the cost of living in the last 2 years, it means that women and young people have had to go to work when they didn't want to because their fathers couldn't make enough to pay the increased cost of food and housing and clothing. We have, in this last 2 years alone, $120 billion total deficits under President Ford, and at the same time we've had in the last 8 years a doubling in the number of bankruptcies for small business. We've had a negative growth in our national economy, measured in real dollars. The take-home pay of a worker in this country is actually less now than it was in 1968, measured in real dollars. This is the kind of record that is there, and talk about the future and a drastic change or conversion on the part of Mr. Ford at the last minute is one that just doesn't go. THE MODERATOR. Mr. Reynolds. MR. REYNOLDS. Governor Carter, I'd like to turn to what we used to call the energy crisis. Yesterday a British Government commission on air pollution, but one headed by a nuclear physicist, recommended that any further expansion of nuclear energy be delayed in Britain as long as possible. Now, this is a subject that is quite controversial among our own people, and there seems to be a clear difference between you and the President on the use of nuclear power plants, which you say you would use as a last priority. Why, sir? Are they unsafe? MR. CARTER. Well, among my other experiences in the past I've been a nuclear engineer, and I did graduate work in this field. I think I know the capabilities and limitations of atomic power. But the energy policy of our Nation is one that has not yet been established under this administration. I think almost every other developed nation in the world has an energy policy except us. We have seen the Federal Energy Agency [Administration] established, for instance, in the crisis of 1973. It was supposed to be a temporary agency; now it's permanent. It's enormous; it's growing every day. And I think the Wall Street Journal reported not too long ago they have 112 public relations experts working for the Federal Energy Agency [Administration] to try to justify to the American people its own existence. We've got to have a firm way to handle the energy question. The reorganization proposal that I've put forward is one first step. In addition to that, we need to have a realization that we've got about 35 years worth of oil left in the whole world. We are going to run out of oil. When Mr. Nixon made his famous speech on operation independence, we were importing about 35 percent of our oil. Now we've increased that amount 25 percent. We now import about 44 percent of our oil. We need a shift from oil to coal. We need to concentrate our research and development effort on coal-burning and extraction that's safe for miners, that also is clean burning. We need to shift very strongly toward solar energy and have strict conservation measures and then, as a last resort only, continue to use atomic power. I would certainly not cut out atomic power altogether. We can't afford to give up that opportunity until later. But to the extent that we continue to use atomic power, I would be responsible as President to make sure that the safety precautions were initiated and maintained. For instance, some that have been forgotten: We need to have the reactor core below ground level, the entire powerplant that uses atomic power tightly sealed, and a heavy vacuum maintained. There ought to be a standardized design. There ought to be a full-time atomic energy specialist, independent of the power company, in the control room full-time, 24 hours a day, to shut down a plant if an abnormality develops. These kinds of procedures, along with evacuation procedures, adequate insurance, ought to be initiated. So, shift from oil to coal; emphasize research and development on coal use and also on solar power; strict conservation measures-not yield every time the special interest groups put pressure on the President, like this administration has done; and use atomic energy only as a last resort with the strictest possible safety precautions. That's the best overall energy policy in the brief time we have to discuss it. MR. REYNOLDS. Well, Governor, on the same subject, would you require mandatory conservation efforts to try to conserve fuel? MR. CARTER. Yes, I would. Some of the things that can be done about this is a change in the rate structure of electric power companies. We now encourage people to waste electricity by giving the lowest rates to the biggest users. We don't do anything to cut down on peak load requirements. We don't have an adequate requirement for the insulation of homes, for the efficiency of automobiles. And whenever the automobile manufacturers come forward and say they can't meet the limits that the Congress has put forward, this Republican administration has delayed the implementation dates. In addition to that, we ought to have a shift to the use of coal, particularly in the Appalachian regions where the coal is located-a lot of very high-quality, low-carbon coal-I mean low-sulfur coal is there-it's where our employment is needed. This would help a great deal. So, mandatory conservation measures, yes. Encouragement by the President for people to voluntarily conserve, yes. And also the private sector ought to be encouraged to bring forward to the public the benefits from efficiency. One bank in Washington, for instance, gives lower interest loans for people who adequately insulate their homes or who buy efficient automobiles. And some major manufacturing companies, like Dow Chemical, have, through very effective efficiency mechanisms, cut down the use of energy by as much as 40 percent with the same out-product. These kind of things ought to be done; they ought to be encouraged and supported and even required by the Government, yes. THE MODERATOR. President Ford. THE PRESIDENT. Governor Carter skims over a very serious and a very broad subject. In January of 1975, I submitted to the Congress and to the American people the first comprehensive energy program recommended by any President. It called for an increase in the production of energy in the United States. It called for conservation measures so that we would save the energy that we have. If you are going to increase domestic oil and gas production-and we have to-you have to give to those producers an opportunity to develop their land or their wells. I recommended to the Congress that we should increase coal production in this country from 600 million tons a year to 1,200 million tons by 1985. In order to do that, we have to improve our extraction of coal from the ground; we have to improve our utilization of coal, make it more efficient, make it cleaner. In addition, we have to expand our research and development. In my program for energy independence, we have increased, for example, solar energy research from about $84 million a year to about $120 million a year. We are going as fast as the experts say we should. In nuclear power we have increased the research and development under the Energy Research and Development Agency [Administration] very substantially to ensure that our nuclear power plants are safer, that they are more efficient, and that we have adequate safeguards. I think you have to have greater oil and gas production, more coal production, more nuclear production, and in addition, you have to have energy conservation. THE MODERATOR. Mr. Gannon. MR. GANNON. Mr. President, I'd like to return for a moment to this problem of unemployment. You have vetoed or threatened to veto a number of jobs bills passed or in development in the Democratic-controlled Congress. Yet, at the same time, the Government is paying out, I think it is, $17 billion, perhaps $20 billion, a year in unemployment compensation caused by the high unemployment. Why do you think it is better to pay out unemployment compensation to idle people than to put them to work in public service jobs? THE PRESIDENT. The bills that I've vetoed, the one for an additional $6 billion was not a bill that would have solved our unemployment problems. Even the proponents of it admitted that no more than 400,000 jobs would be made available. Our analysis indicates that something in the magnitude of about 150 to 200,000 jobs would be made available. Each one of those jobs would have cost the taxpayer $25,000. In addition, the jobs would not be available right now; they would not have materialized for about 9 to 18 months. The immediate problem we have is to stimulate our economy now so that we can get rid of unemployment. What we have done is to hold the lid on spending in an effort to reduce the rate of inflation. And we have proven, I think very conclusively, that you can reduce the rate of inflation and increase jobs. For example, as I have said, we have added some 4 million jobs in the last 17 months. We have now employed 88 million people in America-the largest number in the history of the United States. We've added 500,000 jobs in the last 2 months. Inflation is the quickest way to destroy jobs. And by holding the lid on Federal spending, we have been able to do a good job, an affirmative job in inflation and, as a result, have added to the jobs in this country. I think it's also appropriate to point out that through our tax policies we have stimulated added employment throughout the country-the investment tax credit, the tax incentives for expansion and modernization of our industrial capacity. It's my opinion that the private sector, where five out of the six jobs are, where you have permanent jobs with the opportunity for advancement, is a better place than make-work jobs under the program recommended by the Congress. MR. GANNON. Just to follow up, Mr. President, the Congress has just passed a $3.7 billion appropriation bill which would provide money for the public works jobs program that you earlier tried to kill by your veto of the authorization legislation. In light of the fact that unemployment again is rising or has in the past 3 months, I wonder if you have rethought that question at all, whether you would consider allowing this program to be funded, or will you veto that money bill? THE PRESIDENT. Well, that bill has not yet come down to the Oval Office so I am not in a position to make any judgment on it tonight. But that is an extra $4 billion that would add to the deficit, which would add to the inflationary pressures, which would help to destroy jobs in the private sector, not make jobs where the jobs really are. These make-work, temporary jobs, dead end as they are, are not the kind of jobs that we want for our people. I think it's interesting to point out that in the 2 years that I've been President, I've vetoed 56 bills. Congress has sustained 42 vetoes. As a result we have saved over $9 billion in Federal expenditures. And the Congress-by overriding the bills that I did veto-the Congress has added some $13 billion to the Federal expenditures and to the Federal deficit. Now, Governor Carter complains about the deficits that this administration has had, and yet he condemns the vetoes that I have made that have saved the taxpayer $9 billion and could have saved an additional $13 billion. Now, he can't have it both ways. And, therefore, it seems to me that we should hold the lid as we have to the best of our ability so we can stimulate the private economy and get the jobs where the jobs are-five out of six-in this economy. THE MODERATOR. Governor Carter. MR. CARTER. Well, Mr. Ford doesn't seem to put into perspective the fact that when 500,000 more people are out of work then there were 3 months ago, where we have 2Â½ million more people out of work than were when he took office, that this touches human beings. I was in a city in Pennsylvania not too long ago near here, and there were about 4,000 or 5,000 people in the audience-it was on a train trip-and I said, "How many adults here are out of work?" About a thousand raised their hands. Mr. Ford actually has fewer people now in the private sector in nonfarm jobs than when he took office, and still he talks about a success; 7.9 percent unemployment is a terrible tragedy in this country. He says he has learned how to match unemployment with inflation. That's right. We've got the highest inflation we've had in 25 years right now-except under this administration-and that was 50 years ago-and we've got the highest unemployment we've had under Mr. Ford's administration since the Great Depression. This affects human beings. And his insensitivity in providing those people a chance to work has made this a welfare administration and not a work administration. He hasn't saved $9 billion with his vetoes. It has only been a net saving of $4 billion. And the cost in unemployment compensation, welfare compensation, and lost revenues has increased $23 billion in the last 2 years. This is a typical attitude that really causes havoc in people's lives. And then it's covered over by saying that our country has naturally got a 6-percent unemployment rate or 7-percent unemployment rate and a 6-percent inflation. It's a travesty. It shows a lack of leadership. And we've never had a President since the War Between the States that vetoed more bills. Mr. Ford has vetoed four times as many bills as Mr. Nixon, per year, and 11 of them have been overridden. One of his bills that was overridden-he only got one vote in the Senate and seven votes in the House from Republicans. So, this shows a breakdown in leadership. THE MODERATOR. Governor Carter, under the rules I must stop you. Mrs. DREW. MS. DREW. Governor Carter, I'd like to come back to the subject of taxes. You have said that you want to cut taxes for the middle- and lower-income groups. MR. CARTER. Right. MS. DREW. But unless you are willing to do such things as reduce the itemized deductions for charitable contributions or home mortgage payments or interest or taxes or capital gains, you can't really raise sufficient revenue to provide an overall tax cut of any size. So, how are you going to provide that tax relief that you are talking about? MR. CARTER. Now we have such a grossly unbalanced tax system, as I said earlier, that it is a disgrace. Of all the tax benefits now, 25 percent of them go to the 1 percent of the richest people in this country. Over 50 percent-53 to be exact-percent of the tax benefits go to the 14 percent richest people in this country. We've had a 50-percent increase in payroll deductions since Mr. Nixon went in office 8 years ago. Mr. Ford has advocated, since he has been in office, over $5 billion in reductions for corporations, special interest groups, and the very, very wealthy, who derive their income not from labor, but from investments. That has got to be changed. A few things that can be done: We have now a deferral system so that the multinational corporations, who invest overseas, if they make $1 million in profits overseas, they don't have to pay any of their taxes unless they bring their money back into this country. Where they don't pay their taxes, the average American pays their taxes for them. Not only that but it robs this country of jobs because instead of coming back with that million dollars and creating a shoe factory, say, in New Hampshire or Vermont, if the company takes the money down to Italy and builds a shoe factory, they don't have to pay any taxes on the money. Another thing is a system called DISC [Domestic International Sales Corporation[, which was originally designed and proposed by Mr. Nixon, to encourage exports. This permits a company to create a dummy corporation to export their products and then not to pay the full amount of taxes on them. This costs our Government about $1.4 billion a year, and when those rich corporations don't pay that tax, the average American taxpayer pays it for them. Another one that is very important is the business deductions. Jet airplanes, first-class travel, the $50 martini lunch-the average working person can't take advantage of that, but the wealthier people can. Another system is where a dentist can invest money in, say, raising cattle and can put in $100,000 of his own money, borrow $900,000-$900,000, that makes a million-and mark off a great amount of loss through that procedure. There was one example, for instance, where somebody produced pornographic movies. They put in $30,000 of their own money and got $120,000 in tax savings. These special kinds of programs have robbed the average taxpayer and have benefited those who are powerful and who can employ lobbyists and who can have their C.P.A.'s and their lawyers to help them benefit from the roughly 8,000 pages of the tax code. The average American person can't do it. You can't hire a lobbyist out of unemployment compensation checks. MS. DREW. Governor, to follow up on your answer, in order for any kind of tax relief to really be felt by the middle- and lower-income people, according to congressional committees on this, you need about $10 billion. Now, you listed some things. The deferral on foreign income is estimated it would save about $500 million. DISC, you said, was $1.4 billion. The estimate of the outside, if you eliminated all tax shelters, is $5 billion. So, where else would you raise the revenue to provide this tax relief? Would you, in fact, do away with all business deductions, and what other kinds of preferences would you do away with? MR. CARTER. No, I wouldn't do away with all business deductions. I think that would be a very serious mistake. But if you could just do away with the ones that are unfair, you could lower taxes for everyone. I would never do anything that would increase the taxes for those who work for a living or who are presently required to list all their income. What I want to do is not to raise taxes, but to eliminate loopholes. And this is the point of my first statistic that I gave you, that the present tax benefits that have been carved out over a long period of years-50 years-by sharp tax lawyers and by lobbyists, have benefited just the rich. These programs that I described to you earlier-the tax deferrals for overseas, the DISC, and the tax shelters-they only apply to people in the $50,000-a-year bracket or up. And I think this is the best way to approach it, is to make sure that everybody pays taxes on the income that they earn and make sure that you take whatever savings there is from the higher income levels and give it to the lower and middle-income families. THE MODERATOR. President Ford. THE PRESIDENT. Governor Carter's answer tonight does not coincide with the answer that he gave in an interview to the Associated Press a week or so ago. In that interview Governor Carter indicated that he would raise the taxes on those in the medium- or middle-income brackets or higher. Now, if you take the medium- or middle-income taxpayer-that's about $14,000 per person-Governor Carter has indicated, publicly, in an interview, that he would increase the taxes on about 50 percent of the working people of this country. I think the way to get tax equity in this country is to give tax relief to the middle-income people who have an income from roughly $8,000 up to $25 or $30,000. They have been shortchanged as we have taken 10 million taxpayers off the tax rolls in the last 8 years and as we have added to the minimum tax provision to make all people pay more taxes. I believe in tax equity for the middle-income taxpayer-increasing the personal exemption. Mr. Carter wants to increase taxes for roughly half of the taxpayers of this country. Now, the Governor has also played a little fast and loose with the facts about vetoes. The records show that President Roosevelt vetoed on an average of 55 bills a year. President Truman vetoed on the average, while he was President, about 38 bills a year. I understand that Governor Carter, when he was Governor of Georgia, vetoed between 35 and 40 bills a year. My average in 2 years is 26, but in the process of that, we have saved $9 billion. And one final comment. Governor Carter talks about the tax bills and all of the inequities that exist in the present law. I must remind him the Democrats have controlled the Congress for the last 22 years, and they wrote all the tax bills. THE MODERATOR. Mr. Reynolds. MR. REYNOLDS. I suspect that we could continue on this tax argument for some time, but I'd like to move on to another area. Mr. President, everybody seems to be running against Washington this year, and I'd like to raise two coincidental events, then ask you whether you think perhaps this may have a bearing on the attitude throughout the country. The House Ethics Committee has just now ended its investigation of Daniel Schorr, after several months and many thousands of dollars, trying to find out how he obtained and caused to be published a report of the Congress that probably is the property of the American people. At the same time the Senate Select Committee on Standards and Conduct has voted not really to begin an investigation of a United States Senator because of allegations against him that he may have been receiving corporate funds illegally over a period of years. Do you suppose, sir, that events like this contribute to the feeling in the country that maybe there is something wrong in Washington, and I don't mean just in the executive branch, but throughout the whole Government? THE PRESIDENT. There is a considerable anti-Washington feeling throughout the country but I think the feeling is misplaced. In the 2 years we have restored integrity in the White House and we have set high standards in the executive branch of the Government. The anti-Washington feeling, in my opinion, ought to be focused on the Congress of the United States. For example, this Congress very shortly will spend a billion dollars a year for its housekeeping, its salaries, its expenses, and the like. The next Congress will probably be the first billion dollar Congress in the history of the United States. I don't think the American people are getting their money's worth from the majority party that runs this Congress. . We, in addition, see that in the last 4 years the number of employees hired by the Congress has gone up substantially, much more than the gross national product, much more than any other increase throughout our society. Congress is hiring people by the droves, and the cost, as a result, has gone up. And I don't see any improvement in the performance of the Congress under the present leadership. So, it seems to me, instead of the anti-Washington feeling being aimed at everybody in Washington, it seems to me that the focus should be where the problem is, which is the Congress of the United States, and particularly the majority in the Congress. They spend too much money on themselves. They have too many employees. There is some question about their morality. It seems to me that in this election the focus should not be on the executive branch, but the correction should come as the voters for their Members of the House of Representatives or for their United States Senator. That's where the problem is. And I hope there will be some corrective action taken, so we can get some new leadership in the Congress of the United States. MR. REYNOLDS. Mr. President, if I may follow up, I think you have made it plain that you take a dim view of the majority in the Congress. Isn't it quite likely, sir, that you will have a Democratic Congress in the next session if you are elected President, and hasn't the country a right to ask whether you can get along with that Congress or whether we will have continued confrontation? THE PRESIDENT. Well, it seems to me that we have a chance, the Republicans, to get a majority in the House of Representatives. We will make some gains in the United States Senate. So there will be different ratios in the House as well as in the Senate, and as President I will be able to work with that Congress. But let me take the other side of the coin, if I might. Supposing we had had a Democratic Congress for the last 2 years and we had had Governor Carter as President. He has, in effect, said that he would agree with all of-he would disapprove of the vetoes that I have made and would have added significantly to expenditures and the deficit in the Federal Government. I think it would be contrary to one of the basic concepts in our system of government, a system of checks and balances. We have a Democratic Congress today, and fortunately, we've had a Republican President to check their excesses with my vetoes. If we have a Democratic Congress next year and a President who wants to spend an additional $100 billion a year or maybe $200 billion a year, with more programs, we will have, in my judgment, greater deficits with more spending, more dangers of inflation. I think the American people want a Republican President to check on any excesses that come out of the next Congress if it is a Democratic Congress. THE MODERATOR. Governor Carter. MR. CARTER. Well, it's not a matter of Republican and Democrat; it's a matter of leadership or no leadership. President Eisenhower worked with a Democratic Congress very well. Even President Nixon, because he was a strong leader, at least, worked with a Democratic Congress very well. Mr. Ford has vetoed, as I said earlier, four times as many bills per year as Mr. Nixon. Mr. Ford quite often puts forward a program just as a public relations stunt and never tries to put it through the Congress by working with the Congress. I think under President Nixon and Eisenhower-they passed about 60 to 75 percent of their legislation. This year Mr. Ford will not pass more than 26 percent of all the legislative proposals he puts forward. This is government by stalemate. And we've seen almost a complete breakdown in the proper relationship between the President, who represents this country, and the Congress, who, collectively, also represent this country. We've had Republican Presidents before who have tried to run against a Democratic Congress. And I don't think it's-the Congress is Mr. Ford's opponent. But if he insists that I be responsible for the Democratic Congress, of which I have not been a part, then I think it's only fair that he be responsible for the Nixon administration in its entirety, of which he was a part. That, I think, is a good balance. But the point is that a President ought to lead this country. Mr. Ford, so far as I know, except for avoiding another Watergate, has not accomplished one single major program for his country. And there has been a constant squabbling between the President and the Congress, and that's not the way this country ought to be run. I might go back to one other thing. Mr. Ford has misquoted an AP news story that was in error to begin with. That story reported several times that I would lower taxes for lower- and middle-income families, and that correction was delivered to the White House. And I am sure that the President knows about this correction, but he still insists on repeating an erroneous statement. THE MODERATOR. President Ford, Governor Carter, we no longer have enough time for two complete sequences of questions. We have only about 6 minutes left for questions and answers. For that reason we will drop the follow-up questions at this point, but each candidate will still be able to respond to the other's answers. To the extent that you can, gentlemen, please keep your remarks brief. MR. GANNON. Governor Carter, one important part of the Government's economic policy apparatus we haven't talked about is the Federal Reserve Board. I would like to ask you something about what you have said, and that is that you believe that a President ought to have a Chairman of the Federal Reserve Board whose views are compatible with his own. Based on the record of the last few years, would you say that your views are compatible with those of Chairman Arthur Burns, and if not, would you seek his resignation if you are elected? MR. CARTER. What I have said is that the President ought to have a chance to appoint the Chairman of the Federal Reserve Board to have a coterminus term; in other words, both of them serve the same 4 years. The Congress can modify the supply of money by modifying the income tax laws. The President can modify the economic structure of the country by public statements and general attitudes and the budget that he proposes. The Federal Reserve has an independent status that ought to be preserved. I think that Mr. Burns did take a typical erroneous Republican attitude in the 1973 year when inflation was so high. He assumed that the inflation rate was because of excessive demand and, therefore, put into effect tight constraint on the economy, very high interest rates-which is typical, also, of a Republican administration-tried to increase the tax payments by individuals, cut the tax payments by corporations. I would have done it opposite. I think the problem should have been addressed by increasing productivity, by having put people back to work so they could purchase more goods, lower income taxes on individuals, perhaps raise them if necessary on corporations in comparison. But Mr. Burns in that respect made a very serious mistake. I would not want to destroy the independence of the Federal Reserve Board. But I do think we ought to have a cohesive economic policy with at least the Chairman of the Federal Reserve Board and the President's terms being the same and letting the Congress of course be the third entity with independence, subject only to the President's veto. THE MODERATOR. President Ford, your response. THE PRESIDENT. The Chairman of the Federal Reserve Board should be independent. Fortunately, he has been during Democratic as well as Republican administrations. As a result, in the last 2 years we have had a responsible monetary policy. The Federal Reserve Board indicated that the supply of money would be held between 4 to 4 1/2 and 7 and 7 1/2. They have done a good job in integrating the money supply with the fiscal policy of the executive and legislative branches of the Government. It would be catastrophic if the Chairman of the Federal Reserve Board became the tool of the political party that was in power. It's important for our future economic security that that job be nonpolitical and separate from the executive and the legislative branches. THE MODERATOR. Mrs. Drew. Ms. DREW. Mr. President, the real problem with the FBI-in fact, all of the intelligence agencies-is there are no real laws governing them. Such laws as there are tend to be vague and open-ended. Now, you have issued some Executive orders, but we have learned that leaving these agencies to executive discretion and direction can get them and in fact the country in a great deal of trouble. One President may be a decent man, the next one might not be. So, what do you think about trying to write in some more protection by getting some laws governing these agencies? THE PRESIDENT. You are familiar, of course, with the fact that I am the first President in 30 years who has reorganized the intelligence agencies in the Federal Government-the CIA, the Defense Intelligence Agency, the National Security Agency, and the others. We've done that by Executive order. And I think we've tightened it up; we've straightened out their problems that developed over the last few years. It doesn't seem to me that it's needed or necessary to have legislation in this particular regard. I have recommended to the Congress, however-I'm sure you are familiar with this-legislation that would make it very proper and in the right way that the Attorney General could go in and get the right for wiretapping under security cases. This was an effort that was made by the Attorney General and myself working with the Congress. But even in this area where I think new legislation would be justified, the Congress has not responded. So, I feel in that case as well as in the reorganization of the intelligence agencies-as I've done-we have to do it by Executive order. And I'm glad that we have a good Director in George Bush; we have good Executive orders. And the CIA and the DIA and NSA are now doing a good job under proper supervision. THE MODERATOR. Governor Carter. MR. CARTER. Well, one of the very serious things that's happened in our Government in recent years and has continued up until now is a breakdown in the trust among our people in the [ At this point, there was an audio failure which caused a delay in the debate until 11:18 p.m.] THE MODERATOR. Ladies and gentlemen, probably it is not necessary for me to say that we had a technical failure during the debates. It was not a failure in the debate; it was a failure in the broadcasting of the debate. It occurred 27 minutes ago. The fault has been dealt with, and we want to thank President Ford and Governor Carter for being so patient and understanding while this delay went on. We very much regret the technical failure that lost the sound as it was leaving the theatre. It occurred during Governor Carter's response to what would have been and what was the last question put to the candidates. That question went to President Ford. It dealt with the control of Government intelligence agencies. Governor Carter was making his response and had very nearly finished it. He will conclude that response now, after which President Ford and Governor Carter will make their closing statements. MR. CARTER. There has been too much Government secrecy and not enough respect for the personal privacy of American citizens. THE MODERATOR. It is now time for the closing statements which are to be up to 4 minutes long. Governor Carter, by the same toss of the coin that directed the first question to you, you are to go first now. MR. CARTER. Well, tonight, we've bad a chance to talk a lot about the past, but I think it is time to talk about the future. Our Nation in the last 8 years has been divided as never before. It's a time for unity. It is time to draw ourselves together, to have a President and a Congress that can work together with mutual respect for a change, cooperating for a change, in the open for a change, so the people can understand their own Government. It is time for Government, industry and labor, manufacturing, agriculture, education, other entities in our society to cooperate. And it's a time for Government to understand and to cooperate with our people. For a long time our American citizens have been excluded, sometimes misled, sometimes have been lied to. This is not compatible with the purpose of our Nation. I believe in our country. It needs to be competent, the Government needs to be well managed, efficient, economical. We need to have a Government that's sensitive to our people's needs, to those who are poor, who don't have adequate health care, who have been cheated too long by our tax programs, who've been out of jobs, whose families have been torn apart. We need to restore the faith and the trust of the American people in their own Government. In addition to that, we've suffered because we haven't had leadership in this administration. We have got a Government of stalemate. We've lost the vision of what our country can and ought to be. This is not the America that we've known in the past. It's not the America that we have to have in the future. I don't claim to know all the answers, but I've got confidence in my country. Our economic strength is still there. Our system of government, in spite of Vietnam, Cambodia, CIA, Watergate, is still the best system of government on Earth. And the greatest resource of all are the 215 million Americans who still have within us the strength, the character, the intelligence, the experience, the patriotism, the idealism, the compassion, the sense of brotherhood on which we can rely in the future to restore the greatness to our country. We ought not to be excluded from our Government anymore. We need a President that can go in who derives his strength from the people. I owe the special interests nothing. I owe everything to you, the people of this country. And I believe that we can bind our wounds. I believe that we can work together. And I believe that if we can tap the tremendous untapped reservoir of innate strength in this country, that we can once again have a Government as good as our people and let the world know what we still know and hope for-that we still live in the greatest and the strongest and the best country on Earth. THE MODERATOR. President Ford. THE PRESIDENT. On November 2 all of you will make a very, very important decision. One of the major issues in this campaign is trust. A President should never promise more than he can deliver, and a President should always deliver everything that he has promised. A President can't be all things to all people. A President should be the same thing to all people. Another issue in this campaign: Governor Carter has endorsed the Democratic platform, which calls for more spending, bigger deficits, more inflation, or more taxes. Governor Carter has embraced the record of the present Congress, dominated by his political party. It calls for more of the same. Governor Carter in his acceptance speech called for more and more programs, which means more and more Government. I think the real issue in this campaign-and that which you must decide on November 2-is whether you should vote for his promises or my performance in 2 years in the White House. On the Fourth of July, we had a wonderful 200th birthday for our great country. It was a superb occasion. It was a glorious day. In the first century of our Nation's history, our forefathers gave us the finest form of government in the history of mankind. In the second century of our Nation's history, our forefathers developed the most productive industrial nation in the history of the globe. Our third century should be the century of individual freedom for all our 215 million Americans today and all that join us. In the last few years government has gotten bigger and bigger; industry has gotten larger and larger; labor unions have gotten bigger and bigger; and our children have been the victims of mass education. We must make this next century the century of the individual. We should never forget that a government big enough to give us everything we want is a government big enough to take from us everything we have. The individual worker in the plants throughout the United States should not be a small cog in a big machine. The member of a labor union must have his rights strengthened and broadened, and our children in their education should have an opportunity to improve themselves based on their talents and their abilities. My mother and father, during the Depression, worked very hard to give me an opportunity to do better in our great country. Your mothers and fathers did the same thing for you and others. Betty and I have worked very hard to give our children a brighter future in the United States, our beloved country. You and others in this great country have worked hard and done a great deal to give your children and your grandchildren the blessings of a better America. I believe we can all work together to make the individuals in the future have more, and all of us working together can build a better America. THE MODERATOR. Thank you, President Ford. Thank you, Governor Carter. Our thanks also to the questioners and to the audience in this theatre. We much regret the technical failure that caused a 28-minute delay in the broadcast of the debate. We believe, however, that everyone will agree that it did not detract from the effectiveness of the debate or from its fairness. The next Presidential debate is to take place on Wednesday, October 6, in San Francisco, at 9:30 p.m., eastern daylight time. The topics are to be foreign and defense issues. As with all three debates between the Presidential candidates and the one between the Vice-Presidential candidates, it is being arranged by the League of Women Voters Education Fund in the hope of promoting a wider and better informed participation by the American people in the election in November. Now, from the Walnut Street Theatre in Philadelphia, good night.
