# Vice Presidential Debate in St. Petersburg

**Date:** October 9, 1996
**Source:** https://www.presidency.ucsb.edu/documents/vice-presidential-debate-st-petersburg-florida

---

LEHRER: Good evening from the Mahaffey Theater at the Bayfront Center in St. Petersburg, Florida. I'm Jim Lehrer of the "News Hour" on PBS. Welcome to the 1996 Vice Presidential Debate between Vice President Al Gore, the democratic nominee, and Jack Kemp, the republican nominee. This event is sponsored by the Commission on Presidential Debates. The rules and format, as drawn and agreed to by the two campaigns are almost identical to those of the presidential debate last Sunday night in Hartford. It is 90 minutes long. The candidates are not permitted to question each other directly. I will ask the questions with no limitations on the subjects. There will be a 90-second answer, a 60-second rebuttal, and a 30-second response to each question. And with the help of some lights, I will help the candidates abide by those time limits. The order for everything was determined by a coin toss. There will be three-minute closing statements, but no opening statements. So, we go now to the first question and to Mr. Kemp. Some supporters of Senator Dole have expressed disappointment over his unwillingness in Hartford Sunday night to draw personal and ethical differences between him and President Clinton. How do you feel about it? KEMP: Wow, in 90 seconds? I can't clear my throat in 90 seconds. Jim, Bob Dole and myself do not see Al Gore and Bill Clinton as our enemy. We see them as our opponents. This is the greatest democracy in the world. People are watching not only throughout this country, but all over the world as to how this democracy can function with civility and respect, and decency and integrity. Bob Dole, um, is one of those men who served in the United States Senate, his public life is a public record. He fought on the battlefield. He has worked with Democrats and Republicans. In my opinion, it is beneath Bob Dole to go after anyone personally. Clearly, Abraham Lincoln put it best when he said you serve your party best by serving the nation first. And I can't think of a better way of serving this nation in 1996 than by electing Bob Dole as the President of the United States of America. These issues are fully capable of being understood and reflected upon by the American people. This is a democracy in which we have the freest press and the greatest First Amendment rights in the history of mankind. And Bob and I respect that. These issues will be aired, but they'll be aired with dignity and respect, and, ultimately, leave it to the American people to make up their minds about who should be the leader of this country into the 21st Century. LEHRER: Mr. Vice President? GORE: Thank you, Mr. Lehrer. And I would like to thank the people of St. Petersburg for being such wonderful hosts. My family and I are very glad to be here and I would like to thank Jack Kemp for the answer that he just gave. I think we have an opportunity tonight to have a positive debate about this country's future. I'd like to start by offering you a deal, Jack. If you won't use any football stories, I won't tell any of my warm and humorous stories about chlorofluorocarbon abatement. KEMP: It's a deal. I can't even pronounce it. GORE: What I do want to talk about tonight is Bill Clinton's positive plan for America's future. We have a plan to balance the budget while protecting Medicare, Medicaid, education and the environment. Creating millions of new jobs, including one million new jobs in America's inner cities. I'm excited about the chance to talk about this plan and even more excited about the chance to work on it, if you, the people of this country, will give Bill Clinton and me the privilege of doing so for four more years. LEHRER: Mr. Kemp? KEMP: I really only got two differences with Bill Clinton -- Vice President Clinton and Mr. Gore, foreign policy and domestic policy. Our foreign policy is ambivalent, confusing, it is sending strong signals to the wrong people, and we have learned over the years that weakness is provocative, but domestic economy is not doing what it can do. This President believes we are at our capacity. Bob Dole and I believe we can do a lot better. It is about the potential of the American people to lift themselves up and not have their lives controlled by the United States Government and Washington. LEHRER: Mr. Vice President, what do you see as the political philosophy differences in a general way between you and President Clinton on the one hand, Mr. Kemp and Senator Dole on the other? GORE: The differences are very clear. We have a positive plan based on three principles. We want to provide opportunity for all Americans. We insist on responsibility being accepted in turn by everyone, and we want to strengthen our communities and their ability to support families and individuals in our common effort to create a bright future. Here's how we plan to do that: We have a balanced budget plan that has targeted tax cuts for middle-income families. We've already giving tax cuts to 15 million of the hardest pressed working families in America. Our plan for the next four years features a $1,500 tax credit, called a Hope Scholarship, for tuition at community college, junior college or college. A $10,000 tax deduction for college tuition for those who go further, so that, in essence, no American family will ever be taxed on the money they spend for college tuition. Also, tax relief for first-time home buyers, tax encouragement for savings and help in paying health care expenses, and a tax break, actually, the elimination of capital gains taxes on the -- on the profits from the sale of a home. All of this is within a balanced budget plan, which protects Medicare, Medicaid, education and the environment. KEMP: Jim, this economy is overtaxed, overregulated, too many people suing each other, there's too much litigation. Our education is not up to the standards that the American family and the American people want for their children. And, clearly, the welfare system is a disgrace to our Judeo-Christian principles. It is not the values of the poor that should be called into question, it is the values of the welfare system from Washington and uh that prevent people from climbing out of poverty. Our biggest debate with this administration on domestic policy is that they think we're at our fullest capacity, reached our potential and 2.5 is enough growth for America. Frankly, that is not good enough for this country. We can not just run the clock out on the 20th Century. It, clearly, we need to lower the tax rate across the board on working and saving and investing. I know my friend, Al, will suggest that is trickle-down economics. Well, Al, if it's trickle-down economics, ask Van Woods, a young entrepreneur who owns a restaurant in Harlem, if it's trickle down. He said he would hire 60 more people if we cut the Capital Gains Tax. GORE: I talked about the positive agenda for the future a moment ago. Your original answer was about the contrast. The plan from Senator Dole and Mr. Kemp is a risky, $550-billion tax scheme that actually raises taxes on 9 million of the hardest pressed working families. It would blow a hole in the deficit, cause much deeper cuts in Medicare, Medicaid, education and the environment and knock our economy off track, raising interest rates, mortgage rates and car payments. We stopped that plan before. We will stop it again. We want a positive plan for growth and more jobs. LEHRER: Mr. Kemp, back to the philosophy question. Do you think there's a basic philosophy difference between these two tickets, or is it about specifics, which both of you have talked about? KEMP: Well, this is a perfect example. Bob Dole and I want to cut the tax rates across the board on each and every American, working, saving, investing and taking risks in America. All wealth is created, and all growth is generated by risk-taking entrepreneurs. The tax rate on capital in America is way too high. It's too high on the family and it's particularly too high on working men and women. The average family in America, at median level of income, probably is spending 25 to 26 percent of their income sent to the federal government. That's more than shelter, food, clothing, and energy. That's just not right. When I was growing up in Los Angeles, my parents were a one working family, one breadwinner per family was all that was necessary. Now if a woman wants to go to work or a man wants to go to work, it ought to be their choice, not the choice of the Washington, D.C. establishment. Bill Clinton, the President, and Al Gore, suggest that they'll give us a tax cut, but only if we do exactly what they want us to do. That isn't America. That's social engineering. The tax code should reflect our values in a Judeo-Christian sense, that work, honesty and integrity and contracts and property and investment and savings should be rewarded, and Bob Dole and Jack Kemp are not only going to cut the tax rates across the board and lower the Capital Gain Tax. I'll be glad to talk about it a little later, there's not enough time, but we are going to repeal the 83-year-old code and replace the seven and a half million words with a flatter, fairer, simpler code that will take this country roaring in the 21st Century. GORE: This risky tax scheme would blow a hole in the deficit. You don't have to take my word for it. "Time," "Newsweek," "U.S. News & World Report," "Business Week," 83 percent of hundreds of economists in a random survey just recently all said it would blow a hole in the deficit. There's another feature I would like to hear Mr. Kemp speak about. Just before he joined Senator Dole on the ticket, he said that the plan -- the part of the plan that raises taxes on 9 million of the hardest working families in America was unconscionable, that means it's wrong and it shouldn't happen. I agree, it is still part of the plan. We believe that taxes should not be increased on those families. We have a plan to cut taxes on middle income families within a balanced budget plan, eliminating the deficit and protecting Medicare, Medicaid, education and the environment. LEHRER: Mr. Kemp? KEMP: Every time this country in the 20th Century has cut tax rates across the board, revenues went up, the economy grew, and I am surprised at this point in his career that Vice President Gore and the President cannot understand that you get more revenue from a bigger pie, and clearly, creating more jobs reduces the social welfare drain, clearly makes more opportunity for capital to be invested in our inner cities. And frankly, Al, we shouldn't just tinker with the Capital Gain Tax, we should eliminate it in the inner cities of America to put capital to work to make democratic capitalism and jobs available in our inner cities of the United States. LEHRER: Mr. Vice President, should federal government Affirmative Action programs be continued? GORE: Yes. President Clinton addressed this issue when he said, "Mend it, don't end it." Diversity is a great strength in America. Look around the world at other places where they have not paid attention to the necessity of promoting harmony of, between different ethnic, racial and religious, and cultural groups. We ought to be very proud in our country, as most Americans are, that we've made tremendous progress, but we ought to recognize that we have more work to do. Now, the first thing that we are trying to do is to create a million new jobs in the inner cities of this country, with tax credits for employers who hire people who are now unemployed. We are seeking to have vigorous enforcement of the laws that bar discrimination. Now, I want to congratulate Mr. Kemp for being a lonely voice in the Republican party over the years on this question. It is -- it is with some sadness that I refer to the fact that the day after he joined Senator Dole's ticket, he announced that he was changing his position and was hereto, thereafter going to adopt Senator Dole's position to end all affirmative action. That's not good for our country. Bill Clinton and I believe that the United States of America has its brightest days ahead, and we will see them even brighter if we promote diversity and harmony among all our people. LEHRER: Mr. Kemp? KEMP: Jim, my position on Affirmative Action has been clear ever since I left the professional football career for Congress in 1970. Some people think I quit playing a few years earlier, but I retired in 1970. My life has been dedicated to equality of opportunity and our democracy should provide that, not equality of reward. Uh, Affirmative Action should be predicated upon need, not equality of reward, not equality of outcome. Quotas have always been against the American ideal. We should promote diversity and we should do it the way Bob Dole has been talking about, with a new civil rights agenda, based upon expanding access to credit and capital, job opportunities, educational choice in our inner cities for a young urban mother who can't get the type of an education she wants for her child, and, ultimately, the type of ownership and entrepreneurship from public housing in, D.C. to Nickerson Gardens in Watts, Los Angeles. People need to own. And that's what Abraham Lincoln believed. That when people own something, they have a stake in the American dream. That is Affirmative Action in America. LEHRER: Mr. Vice President. GORE: With all due respect, I do not believe that Abraham Lincoln would have adopted Bob Dole's position to end all affirmative action. There is a specific measure on the ballot in California. It was embodied in legislation, introduced by Senator Dole, to apply to the whole nation. Mr. Kemp campaigned against it, spoke against it, wrote letters against it, went to California to fight against it, and now has endorsed it. I don't think it's a minor matter. I think this is one of the most important challenges that our country has to face in the future, and I hope that Mr. Kemp will try to persuade Senator Dole to adopt Mr. Kemp's position, instead of the other way around. LEHRER: Mr. Kemp, what is your position? KEMP: That red light means we're supposed to stop? LEHRER: Right. GORE: You thought that was going to be your problem, not mine. [ Laughter ] KEMP: Yeah, right. I can't believe I'm keeping within the time limit. LEHRER: Mr. Kemp, do we have a serious race problem in the United States right now? KEMP: Yeah, we really do. Um, this country has yet to deal with the type of exclusionary policies. It is so very important for Americans, white and black, Jew and Christian, immigrant and native-born, to sit down and talk and listen and begin to understand what it's like to come from that different perspective. Our country is as the Kerner Commission Report suggested a number of years ago was being split, but they said between white and black. I think it's being split, Jim, not so much between white and black, although that's still a very serious problem. We really have two economies. Our general economy, our national economy, our mainstream economy is democratic, is based on incentives, a small "d" Al, it's capitalism and incentives for working and saving and investing and producing, and families and the things that really lead to progress up that ladder that we call "The American Dream," but is what is really universal. But unfortunately, in urban America, and I was glad to hear the Vice President talk a little bit about it, uh there -- they have abandoned the inner cities. There's a socialist economy. There's no private housing. There's mostly public housing. You're told where to go to school, you're told what to buy with food stamps. It is a welfare system that is more like a third-world socialist country than what we would expect from the world's greatest democratic free-enterprise system. That must change, and it will under Bob Dole and Jack Kemp. GORE: Remember what I said just a moment ago. If it were not so, he would have told you. The problems between races in America must be addressed. The good news is we're making progress. We've seen 10.5 million new jobs created in the last four years. We've seen the unemployment rate come down dramatically. We've seen the African-American unemployment rate go below double digits for the first time in 25 years and stayed below for 25 months in a row. We have empowerment zones and enterprise communities, 105 of them in communities all across the United States of America. Let me tell you a story about Joann Crowder in Detroit. She was on welfare for eight years until the empowerment zone was created there. She just got a job in the new business that -- that launched its enterprise right in that empowerment zone. We want to do that for millions more all across the country. KEMP: Well, with all due respect, Jim, there are nine empowerment zones, a few little tinkering with tax credits around the country for inner cities. Los Angeles, after the riots, did not even get an empowerment zone, believe it or not. That is just unconscionable in America to have left Watts, South Central and East L.A. out. Earl Graves of "Black Enterprise" magazine said the single greatest deterrent to black advancement is the lack of access to capital, the credit and ownership. We will green-line every city in the United States where there is unemployment and welfare and we will eliminate the Capital Gains Tax, eliminated the tax on a on a welfare mother that takes a job. That is the answer. Give ownership and entrepreneurship to low income people based on need, not the color of their skin. LEHRER: Mr. Vice President, if re-elected, what would, what could we look forward to in the way of an inner city policy from a Clinton/Gore second term? GORE: Before I answer that specific question, let me say that we did put an empowerment zone in South Central, Los Angeles. It is in the form of the largest community development financial institution ever created in the United States or in any other country and it is creating jobs in South Central, Los Angeles right now. The Congress passed uh an enterprise zone after the Los Angeles riots five years ago. It was vetoed by the prior administration. Now, to your question. We have a specific plan to create 1 million new jobs in the inner cities of America with tax credits for employers who hire people coming off welfare, 'cause we've passed welfare reform now, we promised to end welfare as we know it. And we are implementing this new legislation. We have moved 1.9 million people off of the welfare rolls and into good jobs in the last four years. Our new plan is to have 1 million more jobs in the inner cities, but that's not all. We are also implementing the plan to put 100,000 community police officers in our cities. We've already got 20,000 out there. We're ahead of our six-year schedule. As a matter of fact, there're 8 here in St. Petersburg, already on the beat, you may run into one of them leaving this auditorium tonight. St. Petersburg is safer because of this urban agenda that we're following. We want the focus to be on millions more jobs, and we're very optimistic that it's gonna happen. KEMP: Well, we've had four years and there's no enterprise zone. There are empowerment zones, but you have to do what Bill Clinton and Al Gore want you to do. You get a $5,000 tax credit if you hire somebody that's unemployed, but you've already got to have an existing business. The answer is to say, once again, green-line any area in America that has been red-lined for lack of mortgage money, lack of credit and capital. Just say that area qualifies for no Capital Gains Tax, zero, nada. That's what Eleanor Holmes Norton wants to do in the District of Columbia and this administration said to D.C., Drop dead. Drop dead. We don't want to change the legislation that would lower the tax rate in D.C., allow welfare mothers to take a job without any tax on the first 10 percent of her income and no Capital Gain Tax that should be done in every urban area of America that would make capital flow back, and you can't have capitalism, Al, without capital. You may want give a tax credit, but it won't work. GORE: Well, we have 105 empowerment zones and enterprise communities all across the United States of America, and with all due respect, that's 105 more than there were when we came into the White House. We have been implementing them in a determined way. They are making a difference. You know, that empowerment zone that I mentioned in Detroit is creating jobs not only for Joann Crowder, who feels proud that she's off of welfare now, and we're proud of her. It's creating jobs for hundreds of others, and similar initiatives are working in the other empowerment zones. LEHRER: Mr. Kemp, you said recently that one of the problems related to this was that all the capital was in the hands of the white people. What did you mean by that? KEMP: The single greatest problem in our opinion, domestic -- in the domestic economy, is that this tax code, 83 years old, a relic of the Cold War and Hot War, inflation and depression, seven-and-a-half million words long, overtaxes capital, overtaxes working men and women and families. Clearly, the Gordian knot needs to be broken in one fell swoop. Bob Dole and Jack Kemp, as soon as we get through this first step of cutting tax rates across the board, are going to repeal the whole code while Bill Clinton and my friend, Al Gore, defend the status quo. We're going to repeal the seven-and-a-half million words of the U.S.tax code, make it tax income once, not twice, three, four, and if you die, it confiscates your estate. We must have a tax code going into the 21st Century that does not protect the establishment and this tax code does. And by cutting and eliminating the Capital Gains, by cutting and eliminating the Estate Tax, by bringing the top tax rate down to something reasonable, like -- here he goes again -- I think in peacetime, it shouldn't be higher, Bob, and I don't think it should be higher than 25 percent, phased in. But capital would flow out into the economy. We have people getting access to capital. Small businessmen and women, African-American, Asian Americans, Latino Americans, female Americans would be able to start their businesses. Dana Crist of Lancaster said the day the tax bill is passed in Congress, she will open a new factory with 40 or 50 or 60 employees in Lancaster, Pennsylvania. He'll call that trickle down. I'll call it Niagara Falls. GORE: The problem with this version of my Niagara Falls is that Senator Dole and Mr. Kemp would put the economy in a barrel and send it over the falls. [ Laughter ] It is a risky, $550-billion tax scheme that actually raises taxes on 9 million of the hardest working families. Again, Mr. Kemp opposed that and called it unconscionable. Now, it is part of the plan he is supporting. Not only that, though, it would blow a hole in the deficit, it would raise interest rates. That means higher mortgage payments, particularly those with the variable rate mortgages, higher car payments, he would also lead to much deeper cuts in Medicare, Medicaid, education and the environment. It is extremely risky. And as for these harsh words, I don't take them personally. He said much worse about Bob Dole when he said Bob Dole never met a tax that he didn't hike. He wrote about 450 separate provisions in that code. You better check with him before you eliminate it completely. He may be getting royalties. KEMP: Jim, a $550-billion tax cut, this is something that Al does not want to mention, has to be viewed against the context of a $50-trillion U.S. economy output of goods and services over the next six years. A $550-billion tax cut in a $50-trillion economy over six years is one-and-a-half percent, and the only hole it would blow is a hole in the plans of this administration to try to tinker with the tax code and defend the indefensible. It would blow up the bureaucracy, but you would expand the economy. That's important for America. LEHRER: Mr. Vice President, what about Mr. Kemp's point that he's made a couple of times that what we need is to throw away the current -- the present tax code and write a whole new tax system. Do you agree with that? GORE: We've passed the Taxpayer Bill of Rights. We have fought for new provisions that now make it possible to file over the telephone. We are fighting for tax reforms across-the-board, and most importantly, we have a plan on the table right now to cut taxes on middle income families with several specific provisions. We already cut taxes on 15 million working families in this county, with an average of about $1,000 in tax relief to those making $25,000 a year or less. And for the last two years, we have had middle-income tax cuts on the table in the Congress and they would not -- they weren't accepted by Bob Dole and Newt Gingrich, because they said they would not pass them without cutting deeply into Medicare, Medicaid, education and the environment. We are determined to move forward during these next four years, with the tax cuts that president Bill Clinton has proposed. Here they are again: A $1500 tax credit for tuition, a $10,000 tax deduction so that no family pays taxes on the money for college tuition, capital gains eliminated for the sale of a home, a tax break for first-time home buyers and for health care expenses and a $500 child tax credit. KEMP: You only get a tax cut in the Clinton administration if you do exactly what Al Gore and Bill Clinton want you to do. That's not America. When John F. Kennedy cut tax rates, the economy grew, unemployment went down and we balanced the budget, and revenues went up. Indeed, the Secretary of Treasury under John F. Kennedy and the Deputy Secretary of Treasury under John F. Kennedy endorsed Bob Dole's plan to cut rates, cut the Capital Gains Tax, balance the budget, provide a $500 tax credit, and, clearly, the plan should be to lift the economy, to get more revenues. Medicare will be saved because it will be put into a commission where both Bill Clinton and Bob Dole recognize it has to be studied by the same people that would study -- or did study, I should say, the Social Security System and saved it in 1983 and '84. Look, we can bring down government -- the growth of government spending, but we have to grow the economy. And Bob Dole and Jack Kemp's opinion, we should aim at doubling the side of the American economy under the next 15 years. Under their policies, it will take 30 to 40 years. That's not acceptable. GORE: The chairman of their national campaign steering committee, Senator D'Amato, said that Bob Dole would have to cut into Medicare in order to pay for this proposal, but that he would wait until after the election to do it. The proposal to cut Medicare that Senator Dole pushed before, and shut down the government to try to enact, would have already raised by $268, the fees paid by the average couple now on Medicare. He tried to double the deductibles and give people less in return. We have a balanced budget plan that protects Medicare and gives tax cuts. LEHRER: Mr. Kemp, is it really possible to balance the budget without reforming drastically the entitlements programs, including Social Security and Medicare? KEMP: Before I answer that, Jim, let me just say it is disgraceful, the campaign being waged to scare the American senior citizens, in this state and my home state of, well, New York and California, about Medicare. GORE: One other one in there, isn't there? KEMP: about Medicare Yeah, Maryland now. The amount of money being spent to try to mislead the American people is demagoguery, and only in the Clinton White House and in Al Gore's mind could an increase in spending per capita on a senior citizen from $4l00 in 1996 to $7200 over the next five years be considered a cut. Does anybody think that Bob Dole, who almost gave his life for his country, who has served in the Senate, who helped save Social Security, crawled out of a fox hole on Riva Ridge in Northern Italy in 1945 to save a wounded radioman? Does anybody think in this country that he could possibly want to move our country ahead and leave anybody behind? Of course, we can balance the budget. Of course, we have to hold down the growth in entitlement spending. But clearly, you cannot balance the budget, Jim, without growing this economy. It's only growing at about two-and-a-half percent. We should double the rate of growth and double the size of American economy. This means more jobs, more wealth, more income and more capital, particularly for our nation's poor and those left behind. GORE: Mr. Lehrer, our balanced budget plan extends the Medicare Trust Fund ten years into the future. A commission is fine, but a commission would not do any good if we adopted this risky $550-billion tax scheme. The word "scary" has been used. A couple of days ago I went with Governor Lawton Chiles, who was here, to Sarasota to the Friendship Senior Center. I talked with a woman there named Dorothy Wornell and she said, "You know, we may not be as sophisticated as some of those people in Washington, but we can add and subtract." Here are the numbers she's adding and subtracting. Bob Dole's plan would have already imposed an extra $268 on the average Medicare receiving couple, and his plan would have doubled deductibles. It would have cost an extra $1,700 over the lifetime of his plan and eliminated nursing home standards and guarantees of nursing home care for seniors. Bill Clinton prevented it from happening. We will never allow that to happen. KEMP: Jim, Medicare is too important to senior citizens around this country to play the type of politics that is being played on this issue. It is losing $8 billion as we stand here tonight. By the President's own trustees of Medicare, three members of which serve in his cabinet, it will be losing $23 billion a year by 1998. Something must be done. Bob Dole is -- has suggested a commission, but, clearly, you cannot save Medicare, Social Security, or any program for the social welfare net of American people, under which they should not be allowed to fall, unless we grow this economy at least twice the rate it is growing today. That is the issue, not scaring people in America. LEHRER: Mr. Vice President, Mr. Kemp has accused you of demagoguery. GORE: Well, as I said before, he used much harsher language when he talked about Bob Dole. He said that Bob Dole's solution for every single problem was to increase taxes. He said just two years ago that the Bob Dole tax increase of 1982 was the largest tax increase in the history of the world, but let's get to the point. Medicare has been adjusted 23 times since it was created in 1965. Bob Dole, incidentally, just bragged this year that he was one of only 12 people who voted against the creation of Medicare in the first place. I don't think he's -- he didn't believe in it then, and the plan that he promoted last year would have certainly been devastating to Medicare. Again, don't take my word for it. The American Hospital Association said it could have closed 700 hospitals. The Catholic Health Association, the AARP, and many other groups who pay careful attention to Medicare said that the Dole/Gingrich plan on Medicare would have led to deep cuts, possibly set up a two-tiered system, and would have ended the kind of Medicare system that we have. Our plan extends Medicare ten years into the future. We will always protect Medicare within the context of a balanced budget plan. KEMP: Folks, they have no plan. They have absolutely no plan. The President himself suggested that the reduction in the growth of Medicare over the next five or six years ought to be held to 6 percent under the Republican plan, irrespective of the numbers, it will grow at 7 or even more percent, but that is beside the point. What has to be discussed is how we, as a nation, are going to create the size of average economy, create a national wealth that would at least double this 6 or 7 trillion economy. We would have $6 trillion in 15 years extra wealth for the American people. Another trillion dollars of revenue, with which to save Medicare and Social Security. And you can't do it with a tax code and a regulatory code and people suing each other with frivolous suits, as this administration is allowing to happen. That has to change, and it will under Bob Dole and Jack Kemp. GORE: I think Mr. Kemp has unintentionally made a mistake in saying that President Clinton called for reduction of -- to 6 percent or whatever you said. I believe you were referring to the "Money" magazine interview, and the publisher of "Money" magazine just sent Mr. Kemp a letter two days ago asking him to please stop inaccurately citing "Money" magazine. It is not what the President said. It is not the President's position. Let me make clear what his position is. We will save Medicare. We will stop efforts to hurt Medicare, and we'll do it within a balanced budget plan. LEHRER: Mr. Kemp, what, if anything, would a Dole/Kemp administration do to change the current legal status of abortion in this country? KEMP: I will answer the question, but for the record, I would like to release the letter to our friends in the press of the letter I got from "Money" magazine, suggesting that Bill Clinton wanted and did lower the cost of living allowance for senior citizens as a way of reducing Social Security. Putting that aside, the -- we recognize there's no consensus in America. This country is split between those who call themselves pro-choice, and I'm sure, very sincerely, and those of us who call ourselves pro-life, this is a very emotional issue. I'm sure it is for a woman. It certainly is for those of us like my wife and myself who have three adopted grandchildren. We thank God every night of our life that a young woman was given a choice, was given the opportunity to choose life. This country should not be torn asunder over this debate, it has to be carried out with civility and respect, and Bob and I believe it can be. But we should recognize that every human life is precious and there should be all of the protection that we can give for an unborn human being. And to think that in this country, for every three births, there is one abortion. But even worse than that, as ugly as that might be -- and I know it's a tragedy to many people both on the pro-choice and pro-life position -- we have a President who vetoed a congressional ban on the ugly and gruesome practice of snatching life away from a child just moments before he or she enters the world. That is unacceptable. LEHRER: Mr. Vice President? GORE: President Clinton has made it clear that he will sign legislation outlawing procedures such as this if there is a -- an exception to protect the health of the mother where serious health consequences, such as the inability to have any further children, are involved and her doctor advises her so. What is really at stake here is whether or not women will have the right to choose. The platform on which Mr. Kemp and Senator Dole are running pledges a constitutional amendment to take away a woman's right to choose and to have the government come in and order that woman to do what the government says, no matter what the circumstances. Mr. Kemp has voted 47 out of 47 times to have such an amendment and to restrict this completely, no matter what the circumstances, even where rape and incest is involved. We will never allow a woman's right to choose to be taken away. KEMP: There is no consensus. A constitutional amendment would not pass. We must use persuasion, not intimidation. Bob Dole and Jack Kemp will try to remind the American people of what a tremendous asset our children are and why there should be protection for innocent human life, including that of the unborn. But to think that this administration vetoed the one chance they had to ban that practice without working with people in the Congress who would have loved to have had the opportunity to stop that gruesome practice is just unacceptable to the American people. And Bob Dole would never have vetoed that ban on partial-birth abortions in the third trimester of a woman's pregnancy. LEHRER: Mr. Vice President, is the war in Bosnia really over, or is it going to break out again once the U.S. and the NATO troops leave? GORE: The fighting has stopped in Bosnia. President Clinton showed tremendous courage, vision, wisdom, and leadership in having our country take the lead in rallying our allies, bringing the warring factions together in Dayton, Ohio, and hammering out a peace agreement that has ended the war in Bosnia. We hope that it will stay over with. Elections having just been held. There is great progress towards peace and reconciliation in Bosnia. We ought to be very proud of our soldiers who have played such a critical role in bringing about this peace in Bosnia. It's not the only case where Bill Clinton has provided such leadership. We have restored democracy to Haiti, with scarcely a shot being fired. We have seen movement towards reconciliation in Northern Ireland and in the Middle East. The Bible says there will always be wars and rumors of wars. As the President said the other night, there will always be troubles in this ol' world, but the United States of America can be counted on to provide the vision that the world looks for from the United States of America. Bill Clinton, as President, has provided that kind of leadership. We are more secure and stronger today because of Bill Clinton's handling of foreign policy. KEMP: Bob Dole supported the deployment of troops in Bosnia, but the problem with the foreign policy in this administration, there is none. It is ambiguous, it is contradictory. It is precipitous to go into Iraq with bombing before we had even consulted with our allies. To think that Sam Nunn of Georgia or Colin Powell helped put together the coalition in the Persian Gulf were not even consulted. It was not only precipitous, it was a sign, not of strength, but of weakness. What's worse, they declared victory. They've declared victory in every deployment. We've had more deployments in four years than any previous four years I can think of, and I'm 61 years of age. It's unbelievable that ambiguity can be called foreign policy. Let me say what a friend told me, and I believed it for my whole career, weakness is provocative and our message should be clear. And that's what our message would be to the world under Bob Dole as Commander-in-Chief of the United States of America. GORE: We did, of course, consult with our allies before we bombed Saddam Hussein, but sometimes the United States has to take unilateral action when our interests are at stake. General Schwarzkopf is in the audience tonight. We're awfully proud of the way he led our coalition, organized under former President Bush. When the United States toward the repulsing of Saddam Hussein from Kuwait, three times as he's tried to get out of that box, Saddam Hussein has felt the sting of a swift, certain response from the United States of America under President Bill Clinton. LEHRER: Mr. Kemp, Senator Dole has criticized the President on Haiti, that he handled that wrong. What did he do wrong? KEMP: Well, it was Bob Dole that suggested that there be a fact-finding commission. President Carter was on it. Colin Powell was on it. You cannot say, in our opinion, that Haiti is a great success. Clearly, uh it was maybe the right thing to do, but we did not go in with enough information. We caused problems in the first place by denying Caribbean countries and third-world countries a chance to trade freely in the United States. It causes economic problems and turmoil, and then we turn around, as we did in Mexico, having to bail them out. We caused the problem in the first place, and it cost us 20 to 50 billion to bail them out. Haiti is very ambiguous at best. We pray that democracy comes to Haiti, but so far, the message from Haiti is quite ambiguous, notwithstanding the declaration of victory by this administration. GORE: Well, I didn't hear anything wrong. The fact is, we restored democracy to Haiti. When I say "restored" actually, it's the first real democracy that Haiti has ever had. And it happened with scarcely any shots being fired. I was in the Oval Office the night when President Clinton dispatched our troops from Ft. Bragg. It was a tense moment. The planes were in the air and our negotiators were talking with the dictator down there. And when that dictator got the news from his spies outside the gate that all these planes were taking off, he said, let's get out of here. That's how it was done. It was one of the most defense uses of diplomacy and military force in combination that you will find anywhere in the annals of the history of this country. I was so proud of our President in the way he handled that, and the result, so far, is excellent. And we hope and pray that it will remain that way. KEMP: Many more results like Bosnia and Haiti and Mexico, and the Middle East, and we won't have much success. One of the most serious -- one of the most serious problems was the tremendous effort by this administration to force on Mexico a devaluation of their peso. The economy has dropped by almost 40 to 50 percent. Then we go in and bail them out. We cause the problem, then we have to bail them out. We should have a foreign policy that's predicated upon trade, on spreading democracy, by giving people opportunities to trade freely with us, and making sure that everybody recognizes a rule of the Golden Rule, "To do unto others to have them do unto you." Diplomacy first, and don't bomb before breakfast. LEHRER: Mr. Vice President, Mexico, we caused the problem, then had to go in and bail them out? GORE: No, that's not right. When Mr. Kemp started talking about the Golden Rule, I thought he was going to talk about the gold standard again. That used to be an integral part of this so-called "Supply Side Economics," but it may be something else that he now agrees with Bob Dole on, because Bob Dole voted to take us off the gold standard, a wise vote in my opinion. Most -- all economists say if we did that, it would throw us into a deep recession or depression and put millions out of work, but let me come directly to this question. No, when there was a crisis involving the Mexican peso, again, President Bill Clinton showed bold and dynamic leadership. I want to hasten to add that Senator Bob Dole gave critical bipartisan support at the time. He agreed with the President. He supported the President. He said this is a wise move. He could not get a majority in the Senate, and Speaker Gingrich could not get a majority in the house to go on record in support of it. So, the President, as presidents often have to do, went alone and did the right thing. You know, people said it was a big risk at that time. We've ended up making a $500 million profit. All of the loans have been paid back. We're using that $500 million to further reduce the deficit. It's come down 60 percent already. It's going down even more toward a balanced budget, and this is helping. KEMP: It's unbelievable that we could cause a drop in the standard of living of a friendly country like Mexico by nearly 40 to 50 percent. Unemployment goes up, we send U.S. tax dollars and IMF monies to Mexico, and we make a profit. At that level, that is -- gives new meaning to the word "profitability" for U.S. foreign policy. The pain, the suffering, the unemployment, the bankruptcies, the loss of the standard of living, the people who have had to come across the border of California, Arizona, New Mexico and Texas if that's our foreign policy for the third-world or Latin America, I believe more than ever, we have to elect a president who understands trade, who understands honest money, who understands private enterprise, who understands democratic capitalism, not socialism caused by the IMF and the Clinton administration. GORE: Well, I fail to understand the basis of the charge that we caused the monetary crisis in Mexico. They managed their own monetary policy. Years ago, we used to hear this phrase in American politics, the "Blame America First" crowd. I never liked that phrase, but if it was going to be applied today, it would have to be applied to this statement. The United States of America shouldn't be blamed for the management of Mexico's monetary policy. We helped our neighbor in an hour of need, and they survived. They're stronger. They're coming back. They paid us back, and we got a dividend in the process. LEHRER: Mr. Kemp, Senator Dole the other night criticized President Clinton for cutting defense spending and, thus, cutting jobs in California. Is that how defense spending should be seen, as a jobs program as well? KEMP: I don't think, Jim, that Bob Dole was suggesting that the defense of our country is a jobs or a socioeconomic program, but it's clear that the defense budget of this administration has taken defense as a percent of our national economy to a lower level than it was prior to Pearl Harbor. That's dangerous and it's provocative. And the mixed message, the ambiguities of U.S. foreign policy, uh are -- I believe, and Bob Dole believes, is causing not only problems for this country throughout the world, but particularly here at home. And the type of changes that were made overnight in California caused very severe dislocations. And then, of course, the President ran out to California and announced, well, maybe we'll have another B-1or B-2 Bomber. But that is not the way policy should be made. It should be predicated upon the defense needs, the security needs, the strategic needs of the United States of America, and that's how they'll be made under Bob Dole as president. GORE: Well, first of all, there are virtually no large differences in the defense budgets put forward by President Clinton and put forward by the majority in the Congress in the last two years. They're very, very similar. There is a huge difference in our economic plan. This risky $550-billion tax scheme that I talked about earlier is said by the Concord Coalition, including Republicans like Pete Peterson and Warren Rudman, to pose a threat to our nation's ability to have a sensible defense budget in the future. They've gone on record as saying that this tax scheme would not only raise taxes on 9 million hard-working American families, but would also lead, almost inevitably, to deep cuts in Medicare and in defense. We have a balanced budget plan that protects the defense budget, also Medicare, Medicaid, education, the environment, and give tax -- gives tax cuts to middle-income families. KEMP: Jim, Al has to hear one more time. Every time in this century we've lowered the tax rates across-the-board on employment, on saving, investment, and risk-taking in this economy, revenues went up, not down. Now, if the purpose of the tax code is to raise revenue. We ought to think, as John F. Kennedy did, about lowering the rates. We can't go to zero. They can't go too low, because there's not enough revenue, but President Clinton apologized in Houston for saying, whoops, I raised your taxes and they're too high. President Bush apologized for raising taxes. Bob Dole knows that the rates have to come down across-the-board and then we'll get to the most important part, to repeal this code and go to a new system for the 21st Century. LEHRER: Mr. Vice President, some Democrats have charged that the environment would be in jeopardy if Mr. Kemp and Senator Dole are elected. Do you share that fear? GORE: I certainly do. In citing John F. Kennedy's tax cut in the 1960s, I want to also remind you that, Mr. Kemp, pointed out in the past, Bob Dole was in the Congress then. He was one of those who voted against John F. Kennedy's tax cut. The environment faces dire threats from the kind of legislation that Senator Dole and Speaker Newt Gingrich tried to pass by shutting down the government and attempting to force President Clinton to accept it. They invited the lobbyists for the biggest polluters in America to come into the Congress and literally rewrite the Clean Water Act and the Clean Air Act. President Clinton stopped them dead in their tracks. We have a positive agenda on the environment because we believe very deeply that it's about our children and our future. Clean air and clean water, cleaning up toxic waste sites, when millions of children live within one mile of them. That's important. We have a plan to clean up two-thirds of the toxic waste sites in America over the next four years. We've already cleaned up more in the last three years than the previous two administrations did in 12. The President just set aside the Utah National Monument. He is protecting the Everglades here in Florida. Bob Dole is opposed to that plan. President Bill Clinton will protect our environment and prevent the kind of attacks on it that we saw in the last Congress and are included in the Republican platform. KEMP: And so will Bob Dole. I mean, Al, get real. Franklin Roosevelt said in 1932 that the only thing we have to fear is fear itself. The only thing, Jim, they have to offer is fear. Fear of the environment, fear of the climate, fear of Medicare, fear of Newt, fear of Republicans, fear of Bob, and probably fear of cutting tax rates. They ain't seen nothing yet. Look, we recognize that this country has to live in balance with our environment. Every one of us who have children and grandchildren recognize how we have to reach a balance. It is not jobs versus our environment. Both are important. This is the most overregulated, overly litigated economy in our nation's history. And to call a businessman or woman who sits down and has a chance to express his or her interest in how to make these laws work and call them a polluter is just outrageous. It is typical of the anti-capitalistic mentality of this administration. That will change, because we believe in democratic capitalism for everybody. GORE: There are lots of jobs to be created in cleaning up the environment. All around the world we're seeing problems that people want to solve because they love their children. They want them to be able to drink clean water and breathe clean air. They don't want them to live next to toxic waste sites. When the United States of America takes the lead in protecting the environment, we do right by our children, and we also create new business opportunities, new jobs, new sources of prosperity for the United States of America, and we're going about it in a common sense way. LEHRER: Mr. Kemp, you mentioned it already before and you said on "Meet the Press" Sunday that the federal government engages in "regulation reign of terror." What exactly do you mean? KEMP: Well, exactly just what I said. Regulations that would take property or reduce the value of some farmer or rancher or homeowner's property for wetlands or endangered species and take that property or reduce its value without compensating the owner. That is a reign of terror. It's happening. In Oregon, not too long ago, a farmer took 25 percent of his property and declared it a wetland. It had the runoff of snow that allowed it to be declared a wetland, but he did it himself voluntarily. He found within a couple of years that the Bald Eagle began to use it as a habitat. The Corporations of Engineers, the Bureau of Wildlife and Fisheries, all of the federal agencies came onto his property, declared it a federal wetland and said he couldn't drive. They took away the road, he couldn't mend his fences and they wouldn't pay the value of the loss of the -- they wouldn't pay -- or compensate, I should say, for the loss of value to that property. How can we, as a free society, turn people into enemies or adversaries of the United States government? OSHA does it, EPA does it, ERDA does it. We should recognize that this country lives in such a way as to build an alliance with our free enterprise system that can build a better America for our children and our grandchildren. We can do it. But it's got to take new leadership in Washington. GORE: Well, it takes values that recognize the importance of the environment. Mr. Kemp voted against the Clean Water Act, voted against the renewal of the Superfund Act. We have been taking a new approach, protecting the environment, but getting rid of unnecessary regulations. We're eliminating 16,000 pages of regulations. We've entered a -- into a new project called project XL. This is at the EPA. Where we enter into a bargain with businesses. When they say we'll exceed the standards, give the EPA a way to measure the progress and throw away the rulebook all together. Now this is the kind of common sense approach that can clean up the environment while eliminating unnecessary red tape. Make no mistake about it, though, there are those who would like to go much further. Some have even proposed and this bill he cites would do it, that polluters ought to be paid if they agree to stop dumping poisons into the river. The pay polluters provision is wrong. We fought against it. We'll never allow that. KEMP: When I went to Congress from Buffalo in 1970, you could almost walk across Lake Erie because of the pollution. Today, thanks to the secondary and tertiary treatment plants, which many of us voted for on both sides of the aisle, which actually started under Richard Nixon, a Republican president, our water is cleaner in the Great Lakes. We've got a lot of progress that we've made and we've got to make more, but to turn the country into a regulatory effort by the federal government to suggest that we can't work in harmony, "A" with the environment, and with business is a big mistake. We should use incentives, not always using uh sticks against business in America and the jobs it creates. LEHRER: Mr. Vice President, does the government of the -- of the United States has now operated by the Clinton Administration operate on a reign of terror, through a reign of terror? GORE: No, of course not. We're taking a brand new approach to eliminate unnecessary regulations, unnecessary bureaucracy. We've got lots of examples of this there was a story in the newspaper the other day about a home testing kit that the FDA had held up. That happened under a rule in the last administration. We said change that rule. It's being changed now. It's under consideration by the FDA right now and it will be changed. There are thousands of other examples. We believe that there is a new approach. Let me give you an example from OSHA. We're reinventing the way OSHA does its job. Some people would like to eliminate OSHA. We think that the protection of job safety in the workplace is very, very important, but what we've said is look, start, start measuring the results. We found that the inspectors were being rewarded on the basis of how many fines they issued. We changed that completely. They used to go in and give somebody a fine if they didn't have a poster on the wall informing employees of their rights. To use this as an example of our new approach, now if they go in and see that poster is not there, they go out to the trunk of the car and give them a poster. It's the same approach that we're taking in all the regulatory agencies. We're making a lot of progress. We want the protection with common sense, not nonsense. KEMP: Well, we have to have the type of economic prosperity that will allow us to generate the revenues to provide this technology. 10% of all the emissions -- 10% of the all the hydrocarbon emissions oxides going going into the air caused by 10% -- 100% of the all the emissions are caused by 10% of the automobiles. Now there is technology that would allow infrared technology to be used to identify those cars that are providing or the pollution in our atmosphere. It is not being able to be used because we are going to take every automobile driver in America, all 110 million automobiles, and charge them 17 or 20 or $25. Look, we ought to go after the ones that pollute, not go after the men and women who want to be able to drive their automobile to work or to school and to make sure that they have the type of opportunity to live like everyone else without having themselves regulated by Washington establishment. We can use technology. That's the answer, but to get the technology, you've got to have a growing economy. This economy is not growing fast enough and it will under Bob Dole and Jack Kemp. GORE: Well, the economy is growing very strongly right now. We've had 10.5 million new jobs created just in the last four years. In the last quarter, the growth rate was 4.7%. The average growth rate is also coming up. It is higher than in either of the last two Republican administrations. Bob Dole said in February of this year this is the strongest economy in 30 years. The conservative business journal, "Barron's," says this is the strongest economy in 30 years. We've got good solid growth. Let's don't risk it on some $550-billion risky scheme. LEHRER: What measurement do you use, Mr. Kemp, in saying the economy is not growing the way it should be? KEMP: Well, as I said earlier, Jim, it takes two bread winners to do what one breadwinner could have done just a relatively few short few years ago. As long as a woman or man wants to go to work it ought to be their choice, but in America today that woman or man must work in a family to, one to pay the tax and the other to help the family. That's not America. It doesn't leave enough time for the children. It doesn't leave enough time for people to enjoy their families. It doesn't allow people to save. The family is the most overtaxed institution in the United States of America. When I was growing up in Los Angeles, a family that median level of income might have sent four or five percent of their income to the federal government. Today, it's close to 30, or at least 27 or 28%. That's just unacceptable, and for Al Gore to keep suggesting that we can't afford to reduce the tax rates across-the-board on the American people and on the formation of the capital necessary to create the new jobs for America is just totally at odds with the experience of both Ronald Reagan, John F. Kennedy and other times in this century. One other thing that's very, very important. To call it a risky scheme reminds me of the fact that this administration is suggesting that they're going to give you a tax cut if you'll do what they want you to do. They want to cut the Capital Gain Tax, but only for home owners. How about the small businessmen and women of America that create 91% of all the new jobs? My Daddy was a truck driver who bought the truck and started a company. We need more truck drivers becoming truck owners and they can't do it if they don't have access to the capital and the seed corn for the next generation of truck and jobs for America. GORE: We've had the creation of more new small businesses in the last four years in each of the last three years than in any other year in all of American history. We've seen the creation of 10.5 million new jobs. We have the lowest combined rate of inflation and unemployment in 30 years. "Business Week" magazine said these are the kind of results that you want. Lower inflation, lower interest rates, more jobs and more growth, all within the context of a balanced budget. We have reduced the budget deficit four years in a row. We've cut it down 60 percent. After it went up by almost 300 percent during the previous two administrations. Now, this is the kind of growth that we want more of. We think we can do much better still. That's why we're pumping these income tax cuts for middle income families in the context of a balanced budget that protects important programs. KEMP: Four years too late. You told us that four years ago. And we still don't have it. How can we trust an administration that, all of a sudden, four years into or the last year of its four years tells us that now they're going to follow through on the promise they made four years ago? This economy is not growing fast enough. The haves are doing well, but Jim the have-nots are not doing well. There's people hurting, there're families that can't stay together. There's jobs that are not being created, and the unemployment rate in our nations' inner cities is somewhere between 16 and 25 percent. That is morally and socially unacceptable in a modern day economy. LEHRER: Mr Vice President, Senator Dole raised the same question to President Clinton the other night about keeping promises made. What is your reaction to that? What is your response to that charge against you and the President. GORE: President Bill Clinton promised to create 8 million jobs. He's created 10 and a half million new jobs. He's promised to cut the budget deficit in half. He has cut it by 60 percent. He promised to end welfare as we know it. He passed and signed the Welfare Reform Law. He has already moved 1.9 million people off the welfare rolls into good jobs. We've got a plan to move 1 million more off welfare during the next four years. He promised to implement the death penalty. We passed an anti-crime Bill that has 60 new death penalty provisions. He promised to pass a plan that would put 100,000 new police officers on the streets It is law, over the opposition of Senator Dole, and 20,000 of them are already on the streets, 2,000 of them have been funded already for here in Florida. We're ahead of schedule and we're going to get the additional 80,000 new police officers on the streets in the coming four years, 45,000 of them are now already funded. That is a record of promises made and promises kept. He promised middle-income tax cuts. We've cut taxes for 15 million families and our plan to cut them for all middle income families has been waiting for action in the Congress for two full years. In the next four years, we will pass it. KEMP: Well, to say that this is the best economy in 30 years just staggers the imagination. We have a growth rate of the last four years of about two and a half percent. My friend Al Gore says is better than the Reagan years. It isn't. But irrespective of whether he thinks it is or not means less than fact that this country cannot morally and socially and economically accept an economy running out the clock on the 20th Century. We're treading water. We have families that are hurting. We have people who are unemployed. We have people with no property. We have an administration that is demolishing public housing in our inner cities and not providing anything else but more public housing. Their solution to the inner city is more -- excuse the expression but it's true, "socialism." It is not for the people. It is for the government to tell them where to live, where to go to school. We need school choice. We need to privatize public housing, we need to sell it to the residents, we need to put enterprise zone into, in, America and need to lower the rates of taxation on labor, capital and the factors of production. That'll happen under Bob Dole. GORE: We are demolishing the outdated projects that did not work and we're replacing them with new units that do work. And we have private vouchers so that individuals can choose for themselves where they live and we're selling these units to many of those who want to buy them. Mr. Kemp had a good idea when he advocated that years ago. He talked about it we did it and we're going to do a lot more of it, if we have the opportunity with the help of the American people. LEHRER: Mr. Kemp, uh some are saying these days that something's gone terribly wrong with the American soul, that we've become too mean, too selfish, too uncaring and the spitting incident, how it was handled, the baseball players used as a recent example. What do you think about that? KEMP: Civility, responsibility, racial reconciliation, healing the wounds of our country has to be one of the greatest, most singularly important goals for this country here on the edge of the 21st Century. How in the name of American democracy can we say to eastern Europe that democratic capitalism will work there if we can't make it work in East L.A. or East Harlem or East Palo Alto, California? How can we tell South Africa and the new Mandela government that democracy and private property and limited government and the rule of law and civility will work there if it's not working in our own backyard here at home or the South Bronx? How can America go into the next century and leave so many people behind? "USA Today," just few weeks ago did a study. They said the affluent is doing very well in America, the haves, the have-nots and the poor are being left behind. It is a giant, in my opinion, zero sum game. Kind of like musical chairs when we were young boys and girls growing up. And it seemed like when the music stopped the big guy elbowed out the little guy from that last chair that's not America folks. We need more chairs, we need a bigger table, we need a greater banquet. We need to create more wealth. We need to create more jobs and more access to credit and capital and educational choice and opportunity for any man or woman and child to be what God meant them to be, not what Washington, D.C. wants them to be. GORE: I think Mr. Lehrer, that throughout most of his career, Jack Kemp has been a powerful and needed voice against the kind of coarseness and incivility that you refer to in the question. I think it's an extremely valuable service to have a voice within the Republican party who says we ought to be one nation. We ought to cross all of the racial and ethnic and cultural barriers. I think that is a very important message to deliver. And we ought to speak out against these violations of civility when they do occur. You asked about the incident involving Roberto Alomar. I won't hesitate to tell you what I think. I think he should have been severely disciplined, suspended perhaps, immediately. I don't understand why that action was not taken, but the same could be said of so many incidents in all kinds of institutions in our society, but I compliment Mr. Kemp for the leadership he has shown in moving us away from that kind of attitude. KEMP: Well, I thank you, Al. I mean that very, very sincerely, but I'm trying to make a bigger point. That civility cannot return to our country unless every person feels that they have an equal shot at the American dream. That if you're born in this country to be a mezzo-soprano or a master carpenter or a school teacher, like my daughter, or a professional football quarterback, nothing should be in your way. And removing those barriers is what Bob Dole is all about, moving our country forward and leaving no one behind. LEHRER: Mr. Vice President, do you agree with that thesis that in order to solve the problem of civility, the problems in the American soul, you have to -- it's an economic problem more than it is something else? GORE: I think that economics is one of the single most important parts of this problem. That's why we're focusing on tax credits, to hire 1 million more people coming off welfare in the inner city. That's why we're focusing on an economic policy that has already created 10.and a half million new jobs and is going to create millions more within the context, again, of a balanced budget that protects important programs. We have focused especially on the most distressed areas, because we cannot leave anyone behind. Our empowerment zones and enterprise communities, the tax credits that will encourage the formation of new businesses, the new approach by the small business administration to get more loans out to individuals that have not had equal access to capital in the past. These are parts of the plan. Another part of it is the community development financial institutions. And the -- and the law that says deposits that are made in a community, in the inner cities say, should be kept in the community, not entirely, but some percentage of them should be kept there. That prevents that money being taken from the community and invested in some go-go investment on the other side of the world. And when they invest in the community, they find that there's a better payback rate, more small businesses are created and the community improves. That's happening in America today, not fast enough, but faster than before and we think we can accelerate it with our plan. KEMP: There really is no separation between a strong community and a strong economy. And you can't have a strong economy without strong communities and strong families. The word "economics" in Greek came from the word family, or law or custom of the family. A family without a job where both breadwinners are away from home and cannot spend time with their children or can't send the child to the school of their choice rather than just the choice of the federal bureaucracy, cannot possibly be as strong as a family that has the nurture, the love, the dignity and the justice that goes along with one breadwinner, a strong job, and if that man or woman wants to work, it's their choice, not just to pay taxes. So we need both. We need strong commun -- we need strong schools, we need schools that nurture the type of discipline and respect from teachers and parents. And Bob Dole wants to empower the public school districts and the teachers, not the federal bureaucracy at the Department of Education. GORE: Well, Senator Dole has said he wants to abolish the Department of Education. He voted against the creation of Head Start. He vigorously opposed the Family and Medical Leave Act, which was the first law that President Clinton signed as president. Now, Senator Dole has suggested he would repeal the Family and Medical Leave Act if he had the chance if he was elected president. We believe in more educational opportunity and measures to strengthen families, not restrict their access to education. LEHRER: Mr. Kemp, speaking of the family, where do you come down on it? Do you believe it should be repealed? The Family Leave Act? KEMP: I wouldn't have voted for it. It's in place. Their answer, this administration to every single problem is another regulation and another tax. Clearly, in America, we need -- I am astounded to think that you can have a strong Family Leave Act or policy by a business if they're not making a profit. If there aren't a lot of jobs, if there isn't the types of policies that will enhance the formation of the seed corn and the oxygen and the capital that would allow that company not only retain that profit but invest it. As I said earlier, Dana Crist of Lancaster, Pennsylvania who runs a small little manufacturing or distribution center in Lancaster, said that she as an entrepreneur, would start a whole new factory if the federal government would cut the cost of capital. She wants the capital gains rate reduced. And if, to Al Gore and Bill Clinton that is somehow, trickle-down economics. Tell that to Dana Crist, tell it to Van Woods, tell it to the men and women I met in South Central. Tell it to anybody who understands how to makes democratic capitalism work. I want to say it one more time. The real excitement of a Dole/Kemp Administration would be to get out of this current tax code that redistributes wealth and create a brand new system for the 21st Century that's pro-family, pro-growth and stops the double, triple and quadruple taxation of income from work, savings, investment and entrepreneurial risk taking in America. GORE: The question as I recall, it was about Family and Medical Leave. Here's how it works. If you have a child who is critically ill or has been seriously injured and you have to stay with that child in the hospital, some employers, have said you can't take too much time off in spite of these circumstances. I personally know people who have been fired because they made the choice to be with their child. Don't tell me this doesn't happen. It happens all across the United States. But since Bill Clinton made this the first law he signed, it has been use 12 million times by American families to reconcile the demands of work with the responsibilities to the family. We now want to extend it to PTA meetings and scheduled doctors appointments. It shouldn't be repealed. It ought to be extended. 75 percent of businesses who have been -- had experience with it say they like it. It works. KEMP: Well, it was here before Bill Clinton and it will be here after Bill Clinton. Senator Tsongas a good friend of Senator Gore, Vice President Gore suggested that he was afraid his party was fall nothing the trap of loving the employee, but hating the employer. You cannot love labor and hate employers. You cannot drive this wedge between workers and management. And businesses were providing family leave. They will continue. They should. They've got to make a profit and the tax on business, capital, labor and families is too high and it will -- we want to reduce that regulatory burden and that tax burden in a new Dole/Kemp Administration. LEHRER: Gentlemen, that was the last question, so now we go to the closing statements. There will be three minutes each and Mr. Kemp, you are first. KEMP: Thank you, Jim and thanks to the people of St. Petersburg for a fantastic hospitality and my friend, Al Gore, for a vigorous debate. I think this is the most exciting time in the history of the world to be alive. We have lived through what Jean Kirpatrick called the bloodiest century in mankind's history. We have defeated in this system of ours fascism, Nazism, communism, socialism is defunct or debunked around the world, the evil of apartheid has ended. There is only one last question remaining for the next century, indeed the next millennium. Can we, in America, make the world's greatest liberal democracy, this democratic experiment in private property, limited government, the rule of law, respect for families and traditional Judeo-Christian values work, so it can be a blessing to our country and a blessing to the rest of the world? With all due respect to this administration, they've got a foreign policy in disarray. They have a lack of credibility around the world. Weakness, I said earlier, is provocative and clearly, this economy is not performing up to the standards that we would expect from this great nation going into the most exciting global economy the world has ever known. There's something amiss. Our culture seems to be weakening all around us. Families are under tremendous pressure. People do not -- do not feel safe in their homes. A mother doesn't feel safe sending her child to school. Our schools are not educating. It's not the problem of the teachers. They are overworked and my daughter will tell you, they are underpaid and we know that, they need to be empowered. We need to reform education. We need to reform welfare. We need to reform litigation and regulation. And we certainly need to reform this tax code that is a product of this terrible century of war and recession and inflations. It can be done. We need somebody who understands the potential of the American people, who are not just doing well for ourselves, we need to do well for the rest of the world, because they're looking at us. And we need to make it work in every neighborhood and community in America and for every family, so that no one as Bob Dole said in his San Diego acceptance speech is left behind. Bob Dole, as I said earlier, is a man of courage, a man of principles, a man who crawled out of a fox hole on Riva Ridge in 1945 to save a wounded brethren. The bible says no greater love hath a man than he gave his life. Well, Bob Dole did, just about, he'd been through the valley of the shadow and he as Commander-in-Chief can take this country with the courage of Churchill. The principles of Lincoln and the indefatigable optimism and spirit that this nation expects from its Commander-in-Chief and the next President of the United States, Bob Dole. LEHRER: Mr. Vice President? GORE: Thank you very much, Mr. Lehrer. Thanks again to the people of St. Petersburg and thanks again to Jack Kemp. I have enormous respect for Jack Kemp and for Bob Dole. They're good men. I don't agree with their plan. I've tried to make that clear tonight. And one reason I've tried to make it clear is that in just 27 days, the United States of America has an important choice to make. Between two approaches to the future of this country. We have a plan that will create millions more jobs, bring the deficits down further and balance the budget, while protecting Medicare, protecting Medicaid, protecting and preserving the environment, our air, our water, the Everglades, the Tongas, the Mojave Desert in California, the Utah-Red Rocks area, all of which have been protected by President Bill Clinton. We also have a plan to expand access to education. There's a family in the audience tonight, the McNeil family, who lives right here in St. Petersburg. Both parents are teachers, they're not rich in money, but they have strong values and they value education. They're oldest son is a freshman at St. Petersburg Junior High -- Junior College. Their younger son, Roderick, is a sophomore in the same high school that Don McNeil teaches at. Roderick is concerned that he may not be able to get the tuition he needs to go to college when the time comes. Our plan gives a $1500 tax credit to make that junior college essentially free. And a $10,000 tax deduction to make it so that no American family, or almost no family, will have to pay taxes on the money they pay for college tuition. This plan also gives tax breaks on the sale of a home, up to $500,000 in profit tax free. It gives the new break for first-time home buyers, and, again, all all in the context of a balanced budget. We have seen progress during the last four years because policies like these have been working. This risky scheme that I've described tonight has been said by many objective observers to not add up, it would be a serious risk. Our plan, by contrast, has been working and will work more. We want to build a bridge to the 21st Century and we want it to be strong enough and broad enough for all families to cross and we want it to lead to a brighter future for America, 'cause our best days are ahead. LEHRER: Thank you. (APPLAUSE)
