# Presidential Debate in Louisville, Kentucky

**Date:** October 7, 1984
**Source:** https://www.presidency.ucsb.edu/documents/debate-between-the-president-and-former-vice-president-walter-f-mondale-louisville

---

Ms. Ridings. Good evening from the Kentucky Center for the Arts in Louisville, Kentucky. I'm Dorothy Ridings, president of the League of Women Voters, the sponsor of tonight's first Presidential debate between Republican Ronald Reagan and Democrat Walter Mondale. Tonight's debate marks the third consecutive Presidential election in which the League is presenting the candidates for the Nation's highest office in face-to-face debate. Our panelists are James Wieghart, national political correspondent for Scripps-Howard News Service; Diane Sawyer, correspondent for the CBS program "60 Minutes;" and Fred Barnes, national political correspondent for the Baltimore Sun. Barbara Walters of ABC News, who is appearing in her fourth Presidential debate, is our moderator. Barbara. Ms. Walters. Thank you, Dorothy. A few words as we begin tonight's debate about the format. The position of the candidates-that is, who answers questions first and who gives the last statement--was determined by a toss of a coin between the two candidates. Mr. Mondale won, and that means that he chose to give the final closing statement. It means, too, that the President will answer the first question first. I hope that's clear. If it isn't, it will become clear as the debate goes on. Further, the candidates will be addressed as they each wanted and will, therefore, be called "Mr. President" and "Mr. Mondale." Since there will also be a second debate between the two Presidential candidates, tonight will focus primarily on the economy and other domestic issues. The debate, itself, is built around questions from the panel. In each of its segments, a reporter will ask the candidates the same general question. Then--and this is important-each candidate will have the chance to rebut what the other has said. And the final segment of the debate will be the closing segment, and the candidates will each have 4 minutes for their closing statements. And as I have said, Mr. Mondale will be the last person on the program to speak. And now I would like to add a personal note if I may. As Dorothy Ridings pointed out, I have been involved now in four Presidential debates, either as a moderator or as a panelist. In the past, there was no problem in selecting panelists. Tonight, however, there were to have been four panelists participating in this debate. The candidates were given a list of almost 100 qualified journalists from all the media and could agree on only these three fine journalists. As moderator, and on behalf of my fellow journalists, I very much regret, as does the League of Women Voters, that this situation has occurred. And now let us begin the debate with the first question from James Wieghart. Mr. Wieghart. The Nation's Economy Mr. Wieghart. Mr. President, in 1980 you promised the American people--in your campaign--a balanced budget by 1983. We've now had more and bigger deficits in the 4 years you've been in office. Mr. President, do you have a secret plan to balance the budget sometime in a second term, and if so, would you lay out that plan for us tonight? The President. I have a plan--not a secret plan. As a matter of fact, it is the economic recovery program that we presented when I took office in 1981. It is true that earlier, working with some very prominent economists, I had come up, during the campaign, with an economic program that I thought could rectify the great problems confronting us--the double-digit inflation, the high tax rates that I think were hurting the economy, the stagflation that we were undergoing. Before even the election day, something that none of those economists had even predicted had happened, that the economy was so worsened that I was openly saying that what we had thought on the basis of our plan could have brought a balanced budget--no, that was no longer possible. So, the plan that we have had and that we are following is a plan that is based on growth in the economy, recovery without inflation, and reducing the share that the Government is taking from the gross national product, which has become a drag on the economy. Already, we have a recovery that has been going on for about 21 months to the point that we can now call it an expansion. Under that, this year, we have seen a $21 billion reduction in the deficit from last year, based mainly on the increased revenues the Government is getting without raising tax rates. Our tax cut, we think, was very instrumental in bringing about this economic recovery. We have reduced inflation to about a third of what it was. The interest rates have come down about 9 or 10 points and, we think, must come down further. In the last 21 months, more than 6 million people have gotten jobs--there have been created new jobs for those people to where there are now 105 million civilians working, where there were only 99 million before; 107, if you count the military. So, we believe that as we continue to reduce the level of government spending--the increase, rate of increase in government spending, which has come down from 17 to 6 percent, and, at the same time, as the growth in the economy increases the revenues the Government gets, without raising taxes, those two lines will meet. And when they meet, that is a balanced budget. Mr. Wieghart. Mr. President, the Congressional Budget Office has some bad news. The lines aren't about to meet, according to their projections. They project that the budget deficit will continue to climb. In the year 1989 they project a budget deficit of $273 billion. In view of that, and in view of the economic recovery we are now enjoying, would it make sense to propose a tax increase or take some other fiscal measures to reduce that deficit now, when times are relatively good? The President. The deficit is the result of excessive government spending. I do not, very frankly, take seriously the Congressional Budget Office projections, because they have been wrong on virtually all of them, including the fact that our recovery wasn't going to take place to begin with. But it has taken place. But, as I said, we have the rate of increase in government spending down to 6 percent. If the rate of increase in government spending can be held at 5 percent-we're not far from there--by 1989 that would have reduced the budget deficits down to a $30 or $40 billion level. At the same time, if we can have a 4-percent recovery continue through that same period of time, that will mean--without an increase in tax rates--that will mean $400 billion more in government revenues. And so, I think that the lines can meet. Actually, in constant dollars, in the domestic side of the budget, there has been no spending increase in the 4 years that we have been here. Mr. Wieghart. Mr. Mondale, the Carter-Mondale administration didn't come close to balancing the budget in its 4 years in office either, despite the fact that President Carter did promise a balanced budget during his term. You have proposed a plan combining tax increases and budgetary cuts and other changes in the administration of the Government that would reduce the projected budget deficit by two-thirds, to approximately $87 billion in 1989. That still is an enormous deficit that will be running for these 4 years. What other steps do you think should be taken to reduce this deficit and position the country for economic growth? Mr. Mondale. One of the key tests of leadership is whether one sees clearly the nature of the problems confronted by our nation. And perhaps the dominant domestic issue of our times is what do we do about these enormous deficits. I respect the President; I respect the Presidency, and I think he knows that. But the fact of it is, every estimate by this administration about the size of the deficit has been off by billions and billions of dollars. As a matter of fact, over 4 years, they've missed the mark by nearly $600 billion. We were told we would have a balanced budget in 1983. It was $200 billion deficit instead. And now we have a major question facing the American people as to whether we'll deal with this deficit and get it down for the sake of a healthy recovery. Virtually every economic analysis that I've heard of, including the distinguished Congressional Budget Office, which is respected by, I think, almost everyone, says that even with historically high levels of economic growth, we will suffer a $263 billion deficit. In other words, it doesn't converge as the President suggests. It gets larger even with growth. What that means is that we will continue to have devastating problems with foreign trade. This is the worst trade year in American history by far. Our rural and farm friends will have continued devastation. Real interest rates--the real cost of interest-will remain very, very high, and many economists are predicting that we're moving into a period of very slow growth because the economy is tapering off and may be a recession. I get it down to a level below 2 percent of gross national product with a policy that's fair. I've stood up and told the American people that I think it's a real problem, that it can destroy long-term economic growth, and I've told you what I think should be done. I think this is a test of leadership, and I think the American people know the difference. Mr. Wieghart. Mr. Mondale, one other way to attack the deficit is further reductions in spending. The President has submitted a number of proposals to Congress to do just that, and in many instances the House, controlled by the Democrats, has opposed them. Isn't it one aspect of leadership for prominent Democrats such as yourself to encourage responsible reductions in spending, and thereby reduce the deficit? Mr. Mondale. Absolutely, and I proposed over a hundred billion dollars in cuts in Federal spending over 4 years, but I am not going to cut it out of Social Security and Medicare and student assistance and things-- [applause] --that people need. These people depend upon all of us for the little security that they have, and I'm not going to do it that way. The rate of defense spending increase can be slowed. Certainly we can find a coffeepot that costs something less than $7,000. And there are other ways of squeezing this budget without constantly picking on our senior citizens and the most vulnerable in American life. And that's why the Congress, including the Republicans, have not gone along with the President's recommendations. Ms. Walters. I would like to ask the audience please to refrain from applauding either side; it just takes away from the time for your candidates. And now it is time for the rebuttal. Mr. President, 1 minute for rebuttal. The President. Yes. I don't believe that Mr. Mondale has a plan for balancing the budget; he has a plan for raising taxes. And, as a matter of fact, the biggest single tax increase in our nation's history took place 1977. And for the 5 years previous to our taking office, taxes doubled in the United States, and the budgets increased $318 billion. So, there is no ratio between taxing and balancing a budget. Whether you borrow the money or whether you simply tax it away from the people, you're taking the same amount of money out of the private sector, unless and until you bring down government's share of what it is taking. With regard to Social Security, I hope there'll be more time than just this minute to mention that, but I will say this: A President should never say "never." But I'm going to violate that rule and say "never." I will never stand for a reduction of the Social Security benefits to the people that are now getting them. Ms. Walters. Mr. Mondale? Mr. Mondale. Well, that's exactly the commitment that was made to the American people in 1980: He would never reduce benefits. And of course, what happened right after the election is they proposed to cut Social Security benefits by 25 percent-reducing the adjustment for inflation, cutting out minimum benefits for the poorest on Social Security, removing educational benefits for dependents whose widows were trying--with widows trying to get them through college. Everybody remembers that; people know what happened. There's a difference. I have fought for Social Security and Medicare and for things to help people who are vulnerable all my life, and I will do it as President of the United States. Ms. Walters. Thank you very much. We'll now begin with segment number two with my colleague, Diane Sawyer. Ms. Sawyer? Leadership Qualities Ms. Sawyer. Mr. President, Mr. Mondale, the public opinion polls do suggest that the American people are most concerned about the personal leadership characteristics of the two candidates, and each of you has questioned the other's leadership ability. Mr. President, you have said that Mr. Mondale's leadership would take the country down the path of defeatism and despair, and Vice President Bush has called him whining and hoping for bad news. And, Mr. Mondale, you have said that President Reagan offers showmanship, not leadership, that he has not mastered what he must know to command his government. I'd like to ask each of you to substantiate your claims--Mr. Mondale first. Give us specifics to support your claim that President Reagan is a showman, not a leader; has not mastered what he must know to be President after 4 years, and then, second, tell us what personal leadership characteristics you have that he does not. Mr. Mondale. Well, first of all, I think the first answer this evening suggests exactly what I'm saying. There is no question that we face this massive deficit, and almost everybody agrees unless we get it down, the chances for long-term, healthy growth are nil. And it's also unfair to dump these tremendous bills on our children. The President says it will disappear overnight because of some reason. No one else believes that's the case. I do, and I'm standing up to the issue with an answer that's fair. I think that's what leadership is all about. There's a difference between being a quarterback and a cheerleader, and when there's a real problem, a President must confront it. What I was referring to, of course, in the comment that you referred to was the situation in Lebanon. Now, for three occasions, one after another, our Embassies were assaulted in the same way by a truck with demolitions. The first time--and I did not criticize the President, because these things can happen--once, and sometimes twice-the second time the barracks in Lebanon were assaulted, as we all remember. There was two or three commission reports, recommendations by the CIA, the State Department, and the others, and the third time there was even a warning from the terrorists themselves. Now, I believe that a President must command that White House and those who work for him. It's the toughest job on Earth, and you must master the facts and insist that things that must be done are done. I believe that the way in which I will approach the Presidency is what's needed, because all my life that has been the way in which I have sought to lead. And that's why in this campaign I'm telling you exactly what I want to do. I am answering your questions. I am trying to provide leadership now, before the election, so that the American people can participate in that decision. Ms. Sawyer. You have said, Mr. Mondale, that the polls have given you lower ratings on leadership than President Reagan because your message has failed to get through. Given that you have been in public office for so many years, what accounts for the failure of your message to get through? Mr, Mondale. Well, I think we're getting better all the time. And I think tonight, as we contrast for the first time our differing approach to government, to values, to the leadership in this country, I think as this debate goes forward, the American people will have for the first time a chance to weigh the two of us against each other. And I think, as a part of that process, what I am trying to say will come across, and that is that we must lead, we must command, we must direct, and a President must see it like it is. He must stand for the values of decency that the American people stand for, and he must use the power of the White House to try to control these nuclear weapons and lead this world toward a safer world. Ms. Sawyer. Mr. President, the issue is leadership in personal terms. First, do you think, as Vice President Bush said, that Mr. Mondale's campaign is one of whining and hoping for bad news? And second, what leadership characteristics do you possess that Mr. Mondale does not? The President. Well, whether he does or not, let me suggest my own idea about the leadership factor, since you've asked it. And, incidentally, I might say that with regard to the 25-percent cut in Social Security-before I get to the answer to your question--the only 25-percent cut that I know of was accompanying that huge 1977 tax increase, was a cut of 25 percent in the benefits for every American who was born after 1916. Now, leadership. First of all, I think you must have some principles you believe in. In mine, I happen to believe in the people and believe that the people are supposed to be dominant in our society--that they, not government, are to have control of their own affairs to the greatest extent possible, with an orderly society. Now, having that, I think also that in leadership--well, I believe that you find people, positions such as I'm in who have the talent and ability to do the things that are needed in the various departments of government. I don't believe that a leader should be spending his time in the Oval Office deciding who's going to play tennis on the White House court. And you let those people go with the guidelines of overall policy, not looking over their shoulder and nitpicking the manner in which they go at the job. You are ultimately responsible, however, for that job. But I also believe something else about that. I believe that--and when I became Governor of California, I started this, and I continue it in this office--that any issue that comes before me, I have instructed Cabinet members and staff they are not to bring up any of the political ramifications that might surround the issue. I don't want to hear them. I want to hear only arguments as to whether it is good or bad for the people--is it morally right? And on that basis and that basis alone, we make a decision on every issue. Now, with regard to my feeling about why I thought that his record bespoke his possible taking us back to the same things that we knew under the previous administration, his record is that he spoke in praise of deficits several times, said they weren't to be abhorred--that, as a matter of fact, he at one time said he wished the deficit could be doubled, because they stimulate the economy and helped reduce unemployment. Ms. Sawyer. As a followup, let me draw in another specific, if I could--a specific that the Democrats have claimed about your campaign--that it is essentially based on imagery. And one specific that they allege is that, for instance, recently you showed up at the opening ceremony of a Buffalo old-age housing project, when in fact, your policy was to cut Federal housing subsidies for the elderly. Yet you were there to have your picture taken with them. The President. Our policy was not to cut subsidies. We have believed in partnership, and that was an example of a partnership between, not only local government and the Federal Government but also between the private sector that built that particular structure. And this is what we've been trying to do, is involve the Federal Government in such partnerships. We are today subsidizing housing for more than 10 million people, and we're going to continue along that line. We have no thought of throwing people out into the snow, whether because of age or need. We have preserved the safety net for the people with true need in this country, and it has been pure demagoguery that we have in some way shut off all the charitable programs or many of them for the people who have real need. The safety net is there, and we're taking care of more people than has ever been taken care of before by any administration in this country. Ms. Walters. Mr. Mondale, an opportunity for you to rebut. Mr. Mondale. Well, I guess I'm reminded a little bit of what Will Rogers once said about Hoover. He said, "It's not what he doesn't know that bothers me; it's what he knows for sure that just ain't so." [Laughter] The fact of it is: The President's budget sought to cut Social Security by 25 percent. It's not an opinion; it's a fact. And when the President was asked the other day, "What do you want to cut in the budget?", he said, "Cut those things I asked for but didn't get." That's Social Security and Medicare. The second fact is that the housing unit for senior citizens that the President dedicated in Buffalo was only made possible through a Federal assistance program for senior citizens that the President's budget sought to terminate. So, if he'd had his way, there wouldn't have been any housing project there at all. This administration has taken a meat cleaver out, in terms of Federal-assisted housing, and the record is there. We have to see the facts before we can draw conclusions. Ms. Walters. Mr. President? The President. Well, let me just respond with regard to Social Security. When we took office, we discovered that the program that the Carter-Mondale administration had said would solve the fiscal problems of Social Security for the next 50 years wouldn't solve them for 5. Social Security was due to go bankrupt before 1983. Any proposals that I made at that time were at the request of the chairman, a Democrat, of one of the leading committees, who said we have to do something before the program goes broke and the checks bounce. And so, we made a proposal. And then in 1982, they used that proposal in a demagogic fashion for the 1982 campaign. And 3 days after the election in 1982, they came to us and said, Social Security, we know, is broke. Indeed, we had to borrow $17 billion to pay the checks. And then I asked for a bipartisan commission, which I'd asked for from the beginning, to sit down and work out a solution. And so, the whole matter of what to do with Social Security has been resolved by bipartisan legislation, and it is on a sound basis now for as far as you can see into the next century. Ms. Walters. Mr. President, we begin segment number three with Fred Barnes. Religion Mr. Barnes. Mr. President, would you describe your religious beliefs, noting particularly whether you consider yourself a born-again Christian, and explain how these beliefs affect your Presidential decisions? The President. Well, I was raised to have a faith and a belief and have been a member of a church since I was a small boy. In our particular church, we did not use that term, "born again," so I don't know whether I would fit that--that particular term. But I have--thanks to my mother, God rest her soul--the firmest possible belief and faith in God. And I don't believe--I believe, I should say, as Lincoln once said, that I could not--I would be the most stupid man in the world if I thought I could confront the duties of the office I hold if I could not turn to someone who was stronger and greater than all others. And I do resort to prayer. At the same time, however, I have not believed that prayer should be introduced into an election or be a part of a political campaign--or religion a part of that campaign. As a matter of fact, I think religion became a part of this campaign when Mr. Mondale's running mate said I wasn't a good Christian. So, it does play a part in my life. I have no hesitancy in saying so. And, as I say, I don't believe that I could carry on unless I had a belief in a higher authority and a belief that prayers are answered. Mr. Barnes. Given those beliefs, Mr. President, why don't you attend services regularly, either by going to church or by inviting a minister to the White House, as President Nixon used to do, or someone to Camp David, as President Carter used to do? The President. The answer to your question is very simple about why I don't go to church. I have gone to church regularly all my life, and I started to here in Washington. And now, in the position I hold and in the world in which we live, where Embassies do get blown up in Beirut--we're supposed to talk about that on the debate the 21st, I understand--but I pose a threat to several hundred people if I go to church. I know the threats that are made against me. We all know the possibility of terrorism. We have seen the barricades that have had to be built around the White House. And, therefore, I don't feel--and my minister knows this and supports me in this position--I don't feel that I have a right to go to church, knowing that my being there could cause something of the kind that we have seen in other places, in Beirut, for example. And I miss going to church, but I think the Lord understands. [Applause] Ms. Walters. May I ask you, please-- [applause] --may I ask the audience please to refrain from applause. Fred, your second question. Mr. Barnes. Mr. Mondale, would you describe your religious beliefs and mention whether you consider yourself a born-again Christian, and explain how those beliefs would affect your decisions as President? Mr. Mondale. First of all, I accept President Reagan's affirmation of faith. I'm sure that we all accept and admire his commitment to his faith, and we are strengthened, all of us, by that fact. I am a son of a Methodist minister. My wife is the daughter of a Presbyterian minister. And I don't know if I've been born again, but I know I was born into a Christian family. And I believe I have sung at more weddings and more funerals than anybody ever to seek the Presidency. Whether that helps or not, I don't know. I have a deep religious faith. Our family does. It is fundamental. It's probably the reason that I'm in politics. I think our faith tells us, instructs us, about the moral life that we should lead. And I think we're all together on that. What bothers me is this growing tendency to try to use one's own personal interpretation of faith politically, to question others' faith, and to try to use the instrumentalities of government to impose those views on others. All history tells us that that's a mistake. When the Republican platform says that from here on out, we're going to have a religious test for judges before they're selected for the Federal court, and then Jerry Falwell announces that that means they get at least two Justices of the Supreme Court, I think that's an abuse of faith in our country. This nation is the most religious nation on Earth--more people go to church and synagogues than any other nation on Earth-and it's because we kept the politicians and the state out of the personal exercise of our faith. That's why faith in the United States is pure and unpolluted by the intervention of politicians. And I think if we want to continue--as I do--to have a religious nation, lets keep that line and never cross it. Ms. Walters. Thank you. Mr. Barnes, next question. We have time for rebuttal now. Mr. Barnes. I think I have a followup. Ms. Walters. Yes, I asked you if you did. I'm sorry.-- Mr. Barnes. Yes, I do. Ms. Walters. --I thought you waived it. Mr. Barnes. Yes, Mr. Mondale, you've complained, just now, about Jerry Falwell, and you've complained other times about other fundamentalists in politics. Correct me if I'm wrong, but I don't recall your ever complaining about ministers who are involved in the civil rights movement or in the anti-Vietnam war demonstrations or about black preachers who've been so involved in American politics. Is it only conservative ministers that you object to? Mr. Mondale, No. What I object to-- [applause] --what I object to--what I object to is someone seeking to use his faith to question the faith of another or to use that faith and seek to use the power of government to impose it on others. A minister who is in civil rights or in the conservative movement, because he believes his faith instructs him to do that, I admire. The fact that the faith speaks to us and that we are moral people, hopefully, I accept and rejoice in. It's when you try to use that to undermine the integrity of private political--or private religious faith and the use of the state is where--for the most personal decisions in American life--that's where I draw the line. Ms. Walters. Thank you. Now, Mr. President, rebuttal. The President. Yes, it's very difficult to rebut, because I find myself in so much agreement with Mr. Mondale. I, too, want that wall that is in the Constitution of separation of church and state to remain there. The only attacks I have made are on people who apparently would break away at that wall from the government side, using the government, using the power of the courts and so forth to hinder that part of the Constitution that says the government shall not only not establish a religion, it shall not inhibit the practice of religion. And they have been using these things to have government, through court orders, inhibit the practice of religion. A child wants to say grace in a school cafeteria and a court rules that they can't do it because it's school property. These are they types of things that I think have been happening in a kind of a secular way that have been eroding that separation, and I am opposed to that. With regard to a platform on the Supreme Court, I can only say one thing about that. I have appointed one member to the Supreme Court: Sandra Day O'Connor. I'll stand on my record on that. And if I have the opportunity to appoint any more, I'll do it in the same manner that I did in selecting her. Ms. Walters. Mr. Mondale, your rebuttal, please. Mr. Mondale. The platform to which the President refers, in fact, calls for a religious test in the selection of judges. And Jerry Falwell says that means we get two or three judges. And it would involve a religious test for the first time in American life. Let's take the example that the President cites. I believe in prayer. My family prays. We've never had any difficulty finding time to pray. But do we want a constitutional amendment adopted of the kind proposed by the President that gets the local politicians into the business of selecting prayers that our children must either recite in school or be embarrassed and asked to excuse themselves? Who would write the prayer? What would it say? How would it be resolved when those disputes occur? It seems to me that a moment's reflection tells you why the United States Senate turned that amendment down, because it will undermine the practice of honest faith in our country by politicizing it. We don't want that. Ms. Walters. Thank you, Mr. Mondale. Our time is up for this round. We go into the second round of our questioning, begin again with Jim Wieghart. Jim? Political Issues Mr. Wieghart. After that discussion, this may be like going from the sublime to the ridiculous, but here goes. I have a political question for you, Mr. Mondale. [Laughter] Polls indicate a massive change in the electorate, away from the coalition that has long made the Democratic Party a majority. Blue-collar workers, young professionals, their children, and much of the middle class now regard themselves as Independents or Republican instead of Democrats, and the gap--the edge the Democrats had in party registration seems to be narrowing. I'd like to ask you, Mr. Mondale, what is causing this? Is the Democratic Party out of sync with the majority of Americans? And will it soon be replaced as the majority party by the Republicans? What do you think needs to be done about it, as a Democrat? Mr. Mondale. My answer is that this campaign isn't over yet. And when people vote, I think you're going to see a very strong verdict by the American people that they favor the approach that I'm talking about. The American people want arms control. They don't want this arms race. And they don't want this deadly new effort to bring weapons into the heavens. And they want an American foreign policy that leads toward a safer world. The American people see this debt, and they know it's got to come down. And if it won't come down, the economy's going to slow down, maybe go into a recession. They see this tremendous influx and swamping of cheap foreign imports in this country that has cost over 3 million jobs, given farmers the worst year in American history. And they know this debt must come down as well, because it's unfair to our children. The American people want this environment protected. They know that these toxic waste dumps should have been cleaned up a long time ago, and they know that people's lives and health are being risked, because we've had an administration that has been totally insensitive to the law and the demand for the protection of the environment. The American people want their children educated. They want to get our edge back in science, and they want a policy headed by the President that helps close this gap that's widening between the United States and Europe and Japan. The American people want to keep opening doors. They want those civil rights laws enforced. They want the equal rights amendment ratified. They want equal pay for comparable effort for women. And they want it because they've understood from the beginning that when we open doors, we're all stronger, just as we were at the Olympics. I think as you make the case, the American people will increasingly come to our cause. Mr. Wieghart. Mr. Mondale, isn't it possible that the American people have heard your message--and they are listening--but they are rejecting it? Mr. Mondale. Well, tonight we had the first debate over the deficit. The President says it'll disappear automatically. I've said it's going to take some work. I think the American people will draw their own conclusions. Secondly, I've said that I will not support the cuts in Social Security and Medicare and the rest that the President has proposed. The President answers that it didn't happen or, if it did, it was resolved later in a commission. As the record develops, I think it's going to become increasingly clear that what I am saying and where I want to take this country is exactly where the country wants to go, and the comparison of approaches is such that I think will lead to further strength. Mr. Wieghart. Mr. President, you and your party are benefiting from what appears to be an erosion of the old Democratic coalition, but you have not laid out a specific agenda to take this shift beyond November 6th. What is your program for America for the next decade, with some specificity? The President. Well, again, I'm running on the record. I think sometimes Mr. Mondale's running away from his. But I'm running on the record of what we have asked for. We'll continue to try to get things that we didn't get in a program that has already brought the rate of spending of government down from 17 percent to 6.1 percent, a program of returning authority and autonomy to the local and State governments that has been unjustly seized by the Federal Government. And you might find those words in a Democratic platform of some years ago--I know, because I was a Democrat at that time. And I left the party eventually, because I could no longer follow the turn in the Democratic leadership that took us down an entirely different path, a path of centralizing authority in the Federal Government, lacking trust in the American people. I promised, when we took office, that we would reduce inflation. We have, to onethird of what it was. I promised that we would reduce taxes. We did, 25 percent across the board. That barely held even with--if it did that much--with the gigantic tax increase imposed in 1977. But at least it took that burden away from them. I said that we would create jobs for our people, and we did--6 million in the last 20 or 21 months. I said that we would become respected in the world once again and that we would refurbish our national defense to the place that we could deal on the world scene and then seek disarmament, reduction of arms, and, hopefully, an elimination of nuclear weapons. We have done that. All of the things that I said we would do, from inflation being down, interest rates being down, unemployment falling, all of those things we have done. And I think this is something the American people see. I think they also know that we had a commission that came in a year ago with a recommendation on education--on excellence in education. And today, without the Federal Government being involved other than passing on to them, the school districts, the words from that commission, we find 35 States with task forces now dealing with their educational problems. We find that schools are extending the curriculum to now have forced teaching of mathematics and science and so forth. All of these things have brought an improvement in the college entrance exams for the first time in some 20 years. So, I think that many Democrats are seeing the same thing this Democrat saw: The leadership isn't taking us where we want to go. Mr. Wieghart. Mr. President, much of what you said affects the quality of life of many Americans--their income, the way they live, and so forth--but there's an aspect to quality of life that lies beyond the private sector which has to do with our neighborhoods, our cities, our streets, our parks, our environment. In those areas, I have difficulty seeing what your program is and what you feel the Federal responsibility is in these areas of the quality of life in the public sector that affects everybody, and even enormous wealth by one individual can't create the kind of environment that he might like. The President. There are tasks that government legitimately should enforce and tasks that government performs well, and you've named some of them. Crime has come down the last 2 years, for the first time in many, many decades that it has come down--or since we've kept records--2 consecutive years, and last year it came down the biggest drop in crime that we've had. I think that we've had something to do with that, just as we have with the drug problem nationwide. The environment? Yes, I feel as strongly as anyone about the preservation of the environment. When we took office, we found that the national parks were so dirty and contained so many hazards, lack of safety features, that we stopped buying additional park land until we had rectified this with what was to be a 5-year program--but it's just about finished already--a billion dollars. And now we're going back to budgeting for additional lands for our parks. We have added millions of acres to the wilderness lands, to the game refuges. I think that we're out in front of most--and I see that the red light is blinking, so I can't continue. But I've got more. Ms. Walters. Well, you'll have a chance when your rebuttal time comes up, perhaps, Mr. President. Mr. Mondale, now it's your turn for rebuttal. Mr. Mondale. The President says that when the Democratic Party made its turn, he left it. The year that he decided we had lost our way was the year that John F. Kennedy was running against Richard Nixon. I was chairman of "Minnesotans for Kennedy;" President Reagan was chairman of a thing called "Democrats for Nixon." Now, maybe we made a wrong turn with Kennedy, but I'll be proud of supporting him all of my life. And I'm very happy that John Kennedy was elected, because John Kennedy looked at the future with courage, saw what needed to be done, and understood his own government. The President just said that his government is shrinking. It's not. It's now the largest peacetime government ever in terms of the take from the total economy. And instead of retreating.--instead of being strong where we should be strong, he wants to make it strong and intervene in the most private and personal questions in American life. That's where government should not be. Ms. Walters. Mr. President? The President. Before I campaigned as a Democrat for a Republican candidate for President, I had already voted for Dwight Eisenhower to be President of the United States. And so, my change had come earlier than that. I hadn't gotten around to reregistering as yet. I found that was rather difficult to do. But I finally did it. There are some other things that have been said here--back, and you said that I might be able to dredge them up. Mr. Mondale referred to the farmers' worst year. The farmers are not the victims of anything this administration has done. The farmers were the victims of the double-digit inflation and the 21 1/2-percent interest rates of the Carter-Mondale administration and the grain embargo, which destroyed our reliability nationwide as a supplier. All of these things are presently being rectified, and I think that we are going to salvage the farmers. As a matter of fact, there has been less than one-quarter of i percent of foreclosures of the 270,000 loans from government that the farmers have. Ms. Walters. Thank you, Mr. President. We'll now turn to Diane Sawyer for her round of questions. Diane? Abortion Ms. Sawyer. I'd like to turn to an area that I think few people enjoy discussing, but that we probably should tonight because the positions of the two candidates are so clearly different and lead to very different policy consequences--and that is abortion and right to life. I'm exploring for your personal views of abortion and specifically how you would want them applied as public policy. First, Mr. President. Do you consider abortion murder or a sin? And second, how hard would you work--what kind of priority would you give in your second term legislation to make abortion illegal? And specifically, would you make certain, as your party platform urges, that Federal justices that you appoint be pro-life? The President. I have believed that in the appointment of judges that all that was specified in the party platform was that they respect the sanctity of human life. Now, that I would want to see in any judge and with regard to any issue having to do with human life. But with regard to abortion, and I have a feeling that this is-there's been some reference without naming it here in the remarks of Mr. Mondale tied to injecting religion into government. With me, abortion is not a problem of religion, it's a problem of the Constitution. I believe that until and unless someone can establish that the unborn child is not a living human being, then that child is already protected by the Constitution, which guarantees life, liberty, and the pursuit of happiness to all of us. And I think that this is what we should concentrate on, is trying--I know there were weeks and weeks of testimony before a Senate committee, there were medical authorities, there were religious--there were clerics there-everyone talking about this matter of pro-life. And at the end of all of that, not one shred of evidence was introduced that the unborn child was not alive. We have seen premature births that are now grown-up, happy people going around. Also, there is a strange dichotomy in this whole position about our courts ruling that abortion is not the taking of a human life. In California, sometime ago, a man beat a woman so savagely that her unborn child was born dead with a fractured skull, and the California State Legislature unanimously passed a law that was signed by the then-Democratic Governor--signed a law that said that any man who so abuses a pregnant woman that he causes the death of her unborn child shall be charged with murder. Now, isn't it strange that that same woman could have taken the life of her unborn child, and it was abortion and not murder, but if somebody else does it, that's murder? And it used the term "death of the unborn child." So, this has been my feeling about abortion, that we have a problem now to determine--and all the evidence so far comes down on the side of the unborn child being a living human being. Ms. Sawyer. A two-part followup. Do I take it from what you've said about the platform, then, that you don't regard the language and don't regard in your own appointments, abortion position a test of any kind for justices--that it should be? And also, if abortion is made illegal, how would you want it enforced? Who would be the policing units that would investigate? And would you want the women who have abortions to be prosecuted? The President. The laws regarding that always were State laws. It was only when the Supreme Court handed down a decision that the Federal Government intervened in what had always been a State policy. Our laws against murder are State laws. So, I would think that this would be the point of enforcement on this. As I say, I feel that we have a problem here to resolve. And no one has approached it from that matter. It does not happen that the church that I belong to had that as part of its dogma. I know that some churches do. Now, it is a sin if you're taking a human life. At the same time, in our Judeo-Christian tradition, we recognize the right of taking a human life in self-defense. And therefore, I've always believed that a mother, if medically it is determined that her life is at risk if she goes through with the pregnancy, she has a right then to take the life of even her own unborn child in defense of her own. Ms. Sawyer. Mr. Mondale, to turn to you, do you consider abortion a murder or a sin? And bridging from what President Reagan said, he has written that if society doesn't know whether life does--human life, in fact, does begin at conception, as long as there is a doubt, that the unborn child should at least be given the benefit of the doubt and that there should be protection for that unborn child. Mr. Mondale. This is one of the most emotional and difficult issues that could possibly be debated. I think your questions, however, underscore the fact there is probably no way that government should or could answer this question in every individual case and in the private lives of the American people. The constitutional amendment proposed by President Reagan would make it a crime for a woman to have an abortion if she had been raped or suffered from incest. Is it really the view of the American people, however you feel on the question of abortion, that government ought to be reaching into your living rooms and making choices like this? I think it cannot work, won't work, and will lead to all kinds of cynical evasions of the law. Those who can afford to have them will continue to have them. The disadvantaged will go out in the back alley as they used to do. I think these questions are inherently personal and moral, and every individual instance is different. Every American should be aware of the seriousness of the step. But there are some things that government can do and some things they cannot do. Now, the example that the President cites has nothing to do with abortion. Somebody went to a woman and nearly killed her. That's always been a serious crime and always should be a serious crime. But how does that compare with the problem of a woman who is raped? Do we really want those decisions made by judges who've been picked because they will agree to find the person guilty? I don't think so, and I think it's going in exactly the wrong direction. In America, on basic moral questions we have always let the people decide in their own personal lives. We haven't felt so insecure that we've reached for the club of state to have our point of view. It's been a good instinct. And we're the most religious people on Earth. One final point: President Reagan, as Governor of California, signed a bill which is perhaps the most liberal pro-abortion bill of any State in the Union. Ms. Sawyer. But if I can get you back for a moment on my point, which was the question of when human life begins--a two-part followup. First of all, at what point do you believe that human life begins in the growth of a fetus? And second of all, you said that government shouldn't be involved in the decisions. Yet there are those who would say that government is involved, and the consequence of the involvement was 1.5 million abortions in 1980. And how do you feel about that? Mr. Mondale. The basic decision of the Supreme Court is that each person has to make this judgment in her own life, and that's the way it's been done. And it's a personal and private, moral judgment. I don't know the answer to when life begins. And it's not that simple, either. You've got another life involved. And if it's rape, how do you draw moral judgments on that? If it's incest, how do you draw moral judgments on that? Does every woman in America have to present herself before some judge picked by Jerry Falwell to clear her personal judgment? It won't work. [Applause] Ms. Walters. I'm sorry to do this, but I really must talk to the audience. You're all invited guests. I know I'm wasting time in talking to you, but it really is very unfair of you to applaud--sometimes louder, less loud--and I ask you, as people who were invited here, and polite people, to refrain. We have our time now for rebuttal. Mr. President. The President. Yes. Well, with regard to this being a personal choice, isn't that what a murderer is insisting on, his or her right to kill someone because of whatever fault they think justifies that? Now, I'm not capable, and I don't think you are, any of us, to make this determination that must be made with regard to human life. I am simply saying that I believe that that's where the effort should be directed--to make that determination. I don't think that any of us should be called upon here to stand and make a decision as to what other things might come under the self-defense tradition. That, too, would have to be worked out then, when you once recognize that we're talking about a life. But in this great society of ours, wouldn't it make a lot more sense, in this gentle and kind society, if we had a program that made it possible for when incidents come along in which someone feels they must do away with that unborn child, that instead we make it available for the adoption? There are a million and a half people out there standing in line waiting to adopt children who can't have them any other way. Ms. Walters. Mr. Mondale. Mr. Mondale. I agree with that, and that's why I was a principal sponsor of a liberal adoption law, so that more of these children could come to term, so that the young mothers were educated, so we found an option, an alternative. I'm all for that. But the question is whether this other option proposed by the President should be pursued. And I don't agree with it. Since I've got about 20 seconds, let me just say one thing. The question of agriculture came up a minute ago. Net farm income is off 50 percent in the last 3 years, and every farmer knows it. And the effect of these economic policies is like a massive grain embargo, which has caused farm exports to drop 20 percent. It's been a big failure. I opposed the grain embargo in my administration. I'm opposed to these policies as well. Ms. Walters. I'm sitting here like the great schoolteacher, letting you both get away with things--because one did it, the other one did it. May I ask in the future that the rebuttal stick to what the rebuttal is. And also, foreign policy will be the next debate. Stop dragging it in by its ear into this one. [Laughter] Now, having admonished you, I would like to say to the panel, you are allowed one question and one followup. Would you try, as best you could, not to ask two and three--I know it's something we all want to do--two and three questions as part one and two and three as part two. Having said that, Fred, it's yours. Federal Taxation Mr. Barnes. Thank you. Mr. Mondale, let me ask you about middle-class Americans and the taxes they pay. Now, I'm talking not about the rich or the poor--I know your views on their taxes--but about families earning 25,000 to 45,000 a year. Do you think that those families are overtaxed or undertaxed by the Federal Government? Mr. Mondale. In my opinion, as we deal with this deficit, people from about $70,000 a year on down have to be dealt with very, very carefully, because they are the ones who didn't get any relief the first time around. Under the 1981 tax bill, people making $200,000 a year got $60,000 in tax relief over 3 years, while people making $30,000 a year, all taxes considered, got no relief at all or their taxes actually went up. That's why my proposal protects everybody from $25,000 a year or less against any tax increases, and treats those $70,000 and under in a way that is more beneficial than the way the President proposes with a sales tax or a fiat tax. What does this mean in real life? Well, the other day, Vice President Bush disclosed his tax returns to the American people. He's one of the wealthiest Americans, and he's our Vice President. In 1981 I think he paid about 40 percent in taxes. In 1983, as a result of these tax preferences, he paid a little over 12 percent, 12.8 percent in taxes. That meant that he paid a lower percent in taxes than the janitor who cleaned up his office or the chauffeur who drives him to work. I believe we need some fairness. And that's why I've proposed what I think is a fair and a responsible proposal that helps protect these people who've already got no relief or actually got a tax increase. Mr. Barnes. It sounds as if you are saying you think this group of taxpayers making 25,000 to 45,000 a year is already overtaxed, yet your tax proposal would increase their taxes. I think your aides have said those earning about 25,000 to 35,000, their tax rate would go up--their tax bill would go up a hundred dollars, and from 35,000 to 45,000, more than that, several hundred dollars. Wouldn't that stifle their incentive to work and invest and so on, and also hurt the recovery? Mr. Mondale. The first thing is, everybody 25,000 and under would have no tax increase. Mr. Reagan, after the election, is going to have to propose a tax increase, and you will have to compare what he proposes. And his Secretary of the Treasury said he's studying a sales tax or a value-added tax. They're the same thing. They hit middle- and moderate-income Americans and leave wealthy Americans largely untouched. Up until about $70,000, as you go up the ladder, my proposals will be far more beneficial. As soon as we get the economy on a sound ground as well, I'd like to see the total repeal of indexing. I don't think we can do that for a few years. But at some point, we want to do that as well. Mr. Barnes. Mr. President, let me try this on you. Do you think middle-income Americans are overtaxed or undertaxed? The President. You know, I wasn't going to say this at all, but I can't help it. There you go again. [Laughter] I don't have a plan to tax--or increase taxes. I'm not going to increase taxes. I can understand why you are, Mr. Mondale, because as a Senator you voted 16 times to increase taxes. Now, I believe that our problem has not been that anybody in our country is undertaxed; it's that government is overfed. And I think that most of our people--this is why we had a 25-percent tax cut across the board which maintained the same progressivity of our tax structure in the brackets on up. And, as a matter of fact, it just so happens that in the quirks of administering these taxes, those above $50,000 actually did not get quite as big a tax cut percentage-wise as did those from 50,000 down. From 50,000 down, those people paid two-thirds of the taxes, and those people got two-thirds of the tax cut. Now, the Social Security tax of '77--this indeed was a tax that hit people in the lower brackets the hardest. It had two features. It had several tax increases phased in over a period of time--there are two more yet to come between now and 1989. At the same time every year, it increased the amount of money--virtually every year, there may have been one or two that were skipped in there--that was subject to that tax. Today it is up to about $38,000 of earnings that is subject to the payroll tax for Social Security. And that tax, there are no deductions, so a person making anywhere from 10, 15, 20--they're paying that tax on the full gross earnings that they have after they have already paid an income tax on that same amount of money. Now, I don't think that to try and say that we were taxing the rich, and not the other way around, it just doesn't work out that way. The system is still where it was with regard to the progressivity, as I've said, and that has not been changed. But if you take it in numbers of dollars instead of percentage, yes, you could say, well, that person got 10 times as much as this other person. Yes, but he paid 10 times as much, also. But if you take it in percentages, then you find out that it is fair and equitable across the board. Mr. Barnes. I thought I caught, Mr. President, a glimmer of a stronger statement there in your answer than you've made before. I think the operative position you had before was that you would only raise taxes in a second term as a last resort, and I thought you said flatly that "I'm not going to raise taxes." Is that what you meant to say, that you will not--that you will flatly not raise taxes in your second term as President'? The President. Yes, I had used--"last resort" would always be with me. If you got the Government down to the lowest level, that you yourself could say it could not go any lower and still perform the services for the people, and if the recovery was so complete that you knew you were getting the ultimate amount of revenues that you could get through that growth, and there was still some slight difference there between those two lines, then I had said once that, yes, you would have to then look to see if taxes should not be adjusted. I don't foresee those things happening, so I say with great confidence I'm not going to go for a tax. With regard to assailing Mr. Bush about his tax problems and the difference from the tax he once paid and then the later tax he paid, I think if you looked at the deductions, there were great legal expenses in there--had to do, possibly, with the sale of his home, and they had to do with his setting up of a blind trust. All of those are legally deductions, deductible in computing your tax, and it was a 1-year thing with him. Ms. Walters. Mr. Mondale, here we go again. It's time for rebuttal. Mr. Mondale. Well, first of all, I gave him the benefit of the doubt on the house deal. I'm just talking about the 12.8 percent that he paid, and that's what's happening all over this country with wealthy Americans. They've got so many loopholes they don't have to pay much in taxes. Now, Mr. President, you said, "There you go again," right? The President. Yes. Mr. Mondale. You remember the last time you said that? The President. Mm-hmm. Mr. Mondale. You said it when President Carter said that you were going to cut Medicare, and you said, "Oh, no, there you go again, Mr. President." And what did you do right after the election? You went out and tried to cut $20 billion out of Medicare. And so, when you say, "There you go again"--people remember this, you know. [Laughter] And people will remember that you signed the biggest tax increase in the history of California and the biggest tax increase in the history of the United States, and what are you going to do? You've got a $260 billion deficit. You can't wish it away. You won't slow defense spending; you refuse to do that-- Ms. Walters. Mr. Mondale, I'm afraid your time is up. Mr. Mondale. Sorry. Ms. Walters. Mr. President? The President. Yes. With regard to Medicare, no, but it's time for us to say that Medicare is in pretty much the same condition that Social Security was, and something is going to have to be done in the next several years to make it fiscally sound. And, no, I never proposed any $20 billion should come out of Medicare; I have proposed that the program we must treat with that particular problem. And maybe part of that problem is because during the 4 years of the Carter-Mondale administration medical costs in this country went up 87 percent. Ms. Walters. All right. Fine. The President. I gave you back some of that time. [Laughter] Ms. Walters. We can't keep going back for other rebuttals; there'll be time later. We now go to our final round. The way things stand now, we have time for only two sets of questions, and by lot, it will be Jim and Diane. And we'll start with Jim Wieghart. Social Welfare Programs Mr. Wieghart. Mr. President, the economic recovery is real, but uneven. The Census Bureau, just a month ago, reported that there are more people living under poverty now, a million more people living under it, than when you took office. There have been a number of studies, including studies by the Urban Institute and other nonpolitical organizations, that say that the impact of the tax and budget cuts and your economic policies have impacted severely on certain classes of Americans-working mothers, head of households, minority groups, elderly poor. In fact, they're saying the rich are getting richer and the poor are getting poorer under your policies. What relief can you offer to the working poor, to the minorities, and to the women head of households who have borne the brunt of these economic programs? What can you offer them in the future, in your next term? The President. Well, some of those facts and figures just don't stand up. Yes, there has been an increase in poverty, but it is a lower rate of increase than it was in the preceding years before we got here. It has begun to decline, but it is still going up. On the other hand, women heads of household--single women heads of household have--for the first time there's been a turndown in the rate of poverty for them. We have found also in our studies that in this increase in poverty, it all had to do with their private earnings. It had nothing to do with the transfer of payments from government by way of many programs. We are spending now 37 percent more on food for the hungry in all the various types of programs than was spent in 1980. We're spending a third more on all of the-well, all of the programs of human service. We have more people receiving food stamps than were ever receiving them before--2,300,000 more are receiving them--even though we took 850,000 off the food stamp rolls because they were making an income that was above anything that warranted their fellow citizens having to support them. We found people making 185 percent of the poverty level were getting government benefits. We have set a line at 130 percent so that we can direct that aid down to the truly needy. Some time ago, Mr. Mondale said something about education and college students and help of that kind. Half--one out of two of the full-time college students in the United States are receiving some form of Federal aid. But there, again, we found people that there under the previous administration, families that had no limit to income were still eligible for low-interest college loans. We didn't think that was right. And so, we have set a standard that those loans and those grants are directed to the people who otherwise could not go to college, their family incomes were so low. So, there are a host of other figures that reveal that the grant programs are greater than they have ever been, taking care of more people than they ever have. 7.7 million elderly citizens who were living in the lowest 20 percent of earnings--7.7 million have moved up into another bracket since our administration took over, leaving only 5 million of the elderly in that bracket when there had been more than 13 million. Mr. Wieghart. Mr. President, in a visit to Texas--in Brownsville, I believe it was, in the Rio Grande Valley--you did observe that the economic recovery was uneven. The President. Yes. Mr. Wieghart. In that particular area of Texas, unemployment was over 14 percent, whereas statewide, it was the lowest in the country, I believe--5.6 percent. And you made the comment, however, that man does not live by bread alone. What did you mean by that comment? And if I interpret it correctly, it would be a comment more addressed to the affluent who obviously can look beyond just the bread they need to sustain them, with their wherewithal. The President. That had nothing to do with the other thing of talking about their needs or anything. I remember distinctly, I was segueing into another subject. I was talking about the things that have been accomplished, and that was referring to the revival of patriotism and optimism, the new spirit that we're finding all over America. And it is a wonderful thing to see when you get out there among the people. So, that was the only place that that was used. I did avoid, I'm afraid, in my previous answer, also, the idea of uneven, yes. There is no way that the recovery is even across the country, just as in the depths of the recession, there were some parts of the country that were worse off, but some that didn't even feel the pain of the recession. We're not going to rest and not going to be happy until every person in this country who wants a job can have one, until the recovery is complete across the country. Mr. Wieghart. Mr. Mondale, as you can gather from the question to the President, the celebrated War on Poverty obviously didn't end the problem of poverty, although it may have dented it. The poor and the homeless and the disadvantaged are still with us. What should the Federal Government's role be to turn back the growth in the number of people living below the poverty level, which is now 35 million in the United States, and to help deal with the structural unemployment problems that the President was referring to in an uneven recovery? Mr. Mondale. Number one, we've got to get the debt down to get the interest rates down so the economy will grow and people will be employed. Number two, we have to work with cities and others to help generate economic growth in those communities--through the Urban Development Action Grant Program. I don't mind those enterprise zones; let's try them, but not as a substitute for the others. Certainly education and training is crucial. If these young Americans don't have the skills that make them attractive to employees, they're not going to get jobs. The next thing is to try to get more entrepreneurship in business within the reach of minorities so that these businesses are located in the communities in which they're found. The other thing is, we need the business community as well as government heavily involved in these communities to try to get economic growth. There is no question that the poor are worse off. I think the President genuinely believes that they're better off. But the figures show that about 8 million more people are below the poverty line than 4 years ago. How you can cut school lunches, how you can cut student assistance, how you can cut housing, how you can cut disability benefits, how you can do all of these things and then the people receiving them for example, the disabled, who have no alternative--how they're going to do better, I don't know. Now, we need a tight budget, but there's no question that this administration has singled out things that affect the most vulnerable in American life, and they're hurting. One final point if I might. There's another part of the lopsided economy that we're in today, and that is that these heavy deficits have killed exports and are swamping the Nation with cheap imports. We are now $120 billion of imports, 3 million jobs lost, and farmers are having their worst year. That's another reason to get the deficit down. Mr. Wieghart. Mr. Mondale, is it possible that the vast majority of Americans who appear to be prosperous have lost interest in the kinds of programs you're discussing to help those less privileged than they are? Mr. Mondale. I think the American people want to make certain that that dollar is wisely spent. I think they stand for civil rights. I know they're all for education in science and training, which I strongly support. They want these young people to have a chance to get jobs and the rest. I think the business community wants to get involved. I think they're asking for new and creative ways to try to reach it with everyone involved. I think that's part of it. I think also that the American people want a balanced program that gives us long-term growth so that they're not having to take money that's desperate to themselves and their families and give it to someone else. I'm opposed to that, too. Ms. Walters. And now it is time for our rebuttal for this period. Mr. President? The President. Yes. The connection that's been made again between the deficit and the interest rates--there is no connection between them. There is a connection between interest rates and inflation, but I would call to your attention that in 1981 while we were operating still on the Carter-Mondale budget that we inherited--that the interest rates came down from 21 1/2, down toward the 12 or 13 figure. And while they were coming down, the deficits had started their great increase. They were going up. Now, if there was a connection I think that there would be a different parallel between deficits getting larger and interest rates going down. The interest rates are based on inflation. And right now I have to tell you I don't think there is any excuse for the interest rates being as high as they are because we have brought inflation down so low. I think it can only be that they're anticipating or hope--expecting, not hoping, that maybe we don't have a control of inflation and it's going to go back up again. Well, it isn't going to go back up. We're going to see that it doesn't. And I haven't got time to answer with regard to the disabled. Ms. Walters. Thank you, Mr. President. Mr. Mondale. Mr. Mondale. Mr. President, if I heard you correctly, you said that these deficits don't have anything to do with interest rates. I will grant you that interest rates were too high in 1980, and we can have another debate as to why--energy prices and so on. There's no way of glossing around that. But when these huge deficits went in place in 1981, what's called the real interest rates--the spread between inflation and what a loan costs you doubled--and that's still the case today. And the result is interest costs that have never been seen before in terms of real charges, and it's attributable to the deficit. Everybody--every economist, every businessman-believes that. Your own Council of Economic Advisers--Mr. Feldstein in his report told you that. Every chairman of the Finance and Ways and Means Committee, Republican leaders in the Senate and the House are telling you that. That deficit is ruining the long-term hopes for this economy. It's causing high interest rates. It's ruining us in trade. It's given us the highest small business failure in 50 years. The economy is starting downhill with housing failure.- Ms. Walters. Thank you, Mr. Mondale. You're both very obedient. I have to give you credit for that. We now start our final round of questions. We do want to have time for your rebuttal. We start with Diane--Diane Sawyer. Presidential Campaign Ms. Sawyer. Since we are reaching the end of the question period, and since in every Presidential campaign, the candidates tend to complain that the opposition candidate is not held accountable for what he or she says, let me give you the chance to do that. Mr. Mondale, beginning with you. What do you think the most outrageous thing is your opponent said in this debate tonight? [Laughter] Mr. Mondale. Do you want to give me some suggestions? [Laughter] I'm going to use my time a little differently. I'm going to give the President some credit. I think the President has done some things to raise the sense of spirit, morale, good feeling in this country, and he's entitled to credit for that. What I think we need, however, is not just that but to move forward, not just congratulating ourselves but challenging ourselves to get on with the business of dealing with America's problems. I think in education, when he lectured the country about the importance of discipline, I didn't like it at first, but I think it helped a little bit. But now we need both that kind of discipline and the resources and the consistent leadership that allows this country to catch up in education and science and training. I like President Reagan. And this is not personal--there are deep differences about our future, and that's the basis of my campaign. Ms. Sawyer. Follow up in a similar vein, then. What remaining question would you most like to see your opponent forced to answer? Mr. Mondale. Without any doubt, I have stood up and told the American people that that $263 billion deficit must come down. And I've done what no candidate for President has ever done, I told you before the election what I'd do. Mr. Reagan, as you saw tonight--President Reagan takes the position it will disappear by magic. It was once called voodoo economics. I wish the President would say: Yes, the CBO is right. Yes, we have a $263 billion deficit. This is how I'm going to get it done. Don't talk about growth, because even though we need growth, that's not helping. It's going to go in the other direction, as they've estimated. And give us a plan. What will you cut? Whose taxes will you raise? Will you finally touch that defense budget? Are you going to go after Social Security and Medicare and student assistance and the handicapped again as you did last time? If you'd just tell us what you're going to do, then the American people could compare my plan for the future with your plan. And that's the way it should be. The American people would be in charge. Ms. Sawyer. Mr. President, the most outrageous thing your opponent has said in the debate tonight? The President. Well, now, I have to start with a smile, since his kind words to me. I'll tell you what I think has been the most outrageous thing in political dialog, both in this campaign and the one in '82. And that is the continued discussion and claim that somehow I am the villain who is going to pull the Social Security checks out from those people who are dependent on them. And why I think it is outrageous--first of all, it isn't true. But why it is outrageous is because, for political advantage, every time they do that, they scare millions of senior citizens who are totally dependent on Social Security, have no place else to turn. And they have to live and go to bed at night thinking, "Is this true? Is someone going to take our check away from us and leave us destitute?" And I don't think that that should be a part of political dialog. Now, to--I still--I just have a minute here? Ms. Walters. You have more time. The President. Oh, I-- Ms. Walters. You can keep going. The President. Okay. All right. Now, Social Security, let's lay it to rest once and for all. I told you never would I do such a thing. But I tell you also now, Social Security has nothing to do with the deficit. Social Security is totally funded by the payroll tax levied on employer and employee. If you reduce the out-go of Social Security, that money would not go into the general fund to reduce a deficit. It would go into the Social Security Trust Fund. So, Social Security has nothing to do with balancing a budget or erasing or lowering the deficit. Now, again, to get to whether I am depending on magic, I think I have talked in straight economic terms about a program of recovery that I was told wouldn't work. And then, after it worked, I was told that lowering taxes would increase inflation. And none of these things happened. It is working, and we're going to continue on that same line. As to what we might do, and find in further savings cuts, no, we're not going to starve the hungry. But we have 2,478 specific recommendations from a commission of more than 2,000 business people in this country, through the Grace commission, that we're studying right now--and we've already implemented 17 percent of them-that are recommendations as to how to make government more efficient, more economic. Ms. Sawyer. And to keep it even, what remaining question would you most like to see your opponent forced to answer? The President. Why the deficits are so much of a problem for him now, but that in 1976, when the deficit was $52 billion and everyone was panicking about that, he said, no, that he thought it ought to be bigger, because a bigger deficit would stimulate the economy and would help do away with unemployment. In 1979 he made similar statements, the same effect, that the deficits-there was nothing wrong with having deficits. Remember, there was a trillion dollars in debt before we got here. That's got to be paid by our children and grandchildren, too, if we don't do it. And I'm hoping we can start some payments on it before we get through here. That's why I want another 4 years. Ms. Walters. Well, we have time now, if you'd like to answer the President's question, or whatever rebuttal. Mr. Mondale. Well, we've just finished almost the whole debate. And the American people don't have the slightest clue about what President Reagan will do about these deficits. [Laughter] And yet, that's the most important single issue of our time. I did support the '76 measure that he told about, because we were in a deep recession and we needed some stimulation. But I will say as a Democrat, I was a real piker, Mr. President. In 1979 we ran a $29 billion deficit all year. This administration seems to run that every morning. And the result is exactly what we see. This economy is starting to run downhill. Housing is off. Last report on new purchases, it's the lowest since 1982. Growth is a little over 3 percent now. Many people are predicting a recession. And the flow of imports into this country is swamping the American people. We've got to deal with this problem, and those of us who want to be your President should tell you now what we're going to do, so you can make a judgment. Ms. Walters. Thank you very much. We must stop now. I want to give you time for your closing statements. It's indeed time for that from each of you. We will begin with President Reagan. Oh, I'm sorry, Mr. Reagan, you had your rebuttal, and I just cut you off because our time is going. You have a chance now for rebuttal before your closing statement. Is that correct? The President. No, I might as well just go with- Ms. Walters. Do you want to go with your-- The President. I don't think so. I'm all confused now. Ms. Walters. Technically, you did. I have little voices that come in my ear. [Laughter] You don't get those same voices. I'm not hearing it from here--I'm hearing it from here. The President. All right. Ms. Walters. You have waived your rebuttal. You can go with your closing statement. Closing Statements The President. Well, we'll include it in that. Ms. Walters. Okay. The President. Four years ago, in similar circumstances to this, I asked you, the American people, a question. I asked: "Are you better off than you were 4 years before?" The answer to that obviously was no, and as the result, I was elected to this office and promised a new beginning. Now, maybe I'm expected to ask that same question again. I'm not going to, because I think that all of you--or not everyone, those people that are in those pockets of poverty and haven't caught up, they couldn't answer the way I would want them to--but I think that most of the people in this country would say, yes, they are better off than they were 4 years ago. The question, I think, should be enlarged. Is America better off than it was 4 years ago? And I believe the answer to that has to also be "yes." I promised a new beginning. So far, it is only a beginning. If the job were finished, I might have thought twice about seeking reelection for this job. But we now have an economy that, for the first time--well, let's put it this way: In the first half of 1980, gross national product was down a minus 3.7 percent. The first half of '84 it's up 8 1/2 percent. Productivity in the first half of 1980 was down a minus 2 percent. Today it is up a plus 4 percent. Personal earnings after taxes per capita have gone up almost $3,000 in these 4 years. In 1980--or 1979, a person with a fixed income of $8,000 was $500 above the poverty line, and this maybe explains why there are the numbers still in poverty. By 1980 that same person was $500 below the poverty line. We have restored much of our economy. With regard to business investment, it is higher than it has been since 1949. So, there seems to be no shortage of investment capital. We have, as I said, cut the taxes, but we have reduced inflation, and for 2 years now it has stayed down there, not at double digit, but in the range of 4 or below. We believe that we had also promised that we would make our country more secure. Yes, we have an increase in the defense budget. But back then we had planes that couldn't fly for lack of spare parts or pilots. We had navy vessels that couldn't leave harbor because of lack of crew or, again, lack of spare parts. Today we're well on our way to a 600-ship navy. We have 543 at present. We have--our military, the morale is high. I think the people should understand that two-thirds of the defense budget pays for pay and salary, or pay and pension. And then you add to that food and wardrobe, and all the other things, and you only have a small portion going for weapons. But I am determined that if ever our men are called on, they should have the best that we can provide in the manner of tools and weapons. There has been reference to expensive spare parts, hammers costing $500. Well, we are the ones who found those. I think we've given the American people back their spirit. I think there's an optimism in the land and a patriotism, and I think that we're in a position once again to heed the words of Thomas Paine, who said: "We have it in our power to begin the world over again." Ms. Walters. Thank you, Mr. Reagan. Mr. Mondale, the closing words are now yours. Mr. Mondale. I want to thank the League of Women Voters and the city of Louisville for hosting this evening's debate. I want to thank President Reagan for agreeing to debate. He didn't have to, and he did, and we all appreciate it. The President's favorite question is: Are you better off?. Well, if you're wealthy, you're better off. If you're middle income, you're about where you were. And if you're modest income, you're worse off. That's what the economists tell us. But is that really the question that should be asked? Isn't the real question is will we be better off?. Will our children be better off?. Are we building the future that this nation needs? I believe that if we ask those questions that bear on our future, not just congratulate ourselves but challenge us to solve those problems, you'll see that we need new leadership. Are we better of with this arms race? Will we be better off if we start this star wars escalation into the heavens? Are we better off when we de-emphasize our values in human rights? Are we better off when we load our children with this fantastic debt? Would fathers and mothers feel proud of themselves if they loaded their children with debts like this nation is now--over a trillion dollars on the shoulders of our children? Can we say, really say that we will be better off when we pull away from sort of that basic American instinct of decency and fairness? I would rather lose a campaign about decency than win a campaign about self-interest. I don't think this nation is composed of people who care only for themselves. And when we sought to assault Social Security and Medicare, as the record shows we did, I think that was mean-spirited. When we terminated 400,000 desperate, hopeless, defenseless Americans who were on disability-confused and unable to defend themselves, and just laid them out on the street, as we did for 4 years, I don't think that's what America is all about. America is a fair society, and it is not right that Vice President Bush pays less in taxes than the janitor who helps him. I believe there's fundamental fairness crying out that needs to be achieved in our tax system. I believe that we will be better off if we protect this environment. And contrary to what the President says, I think their record on the environment is inexcusable and often shameful. These laws are not being enforced, have not been enforced, and the public health and the air and the water are paying the price. That's not fair for our future. I think our future requires a President to lead us in an all-out search to advance our education, our learning, and our science and training, because this world is more complex and we're being pressed harder all the time. I believe in opening doors. We won the Olympics, in part, because we've had civil rights laws and the laws that prohibit discrimination against women. I have been for those efforts all my life. The President's record is quite different. The question is our future. President Kennedy once said in response to similar arguments, "We are great, but we can be greater." We can be better if we face our future, rejoice in our strengths, face our problems, and by solving them, build a better society for our children. Thank you. Ms. Walters. Thank you, Mr. Mondale. [Applause] Please, we have not finished quite yet. Thank you, Mr. Mondale, and thank you, Mr. President. And our thanks to our panel members, as well. And so we bring to a close this first of the League of Women Voters Presidential debates of 1984. You two can go at each again in the final League debate on October 21st, in Kansas City, Missouri. And this Thursday night, October 11th, at 9 p.m. eastern daylight time, the Vice President, George Bush, will debate Congresswoman Geraldine Ferraro in Philadelphia. And I hope that you will all watch once again. No matter what the format is, these debates are very important. We all have an extremely vital decision to make. Once more, gentlemen, our thanks. Once more, to you, our thanks. Now, this is Barbara Walters wishing you a good evening.
