# Presidential Debate in Washington, DC

**Date:** October 7, 1960
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-washington-dc

---

FRANK McGEE, MODERATOR: Good evening. This is Frank McGee, NBC News in Washington. This is the second in a series of programs unmatched in history. Never have so many people seen the major candidates for president of the United States at the same time; and never until this series have Americans seen the candidates in face-to-face exchange. Tonight the candidates have agreed to devote the full hour to answering questions on any issue of the campaign. And here tonight are: the Republican candidate, Vice President Richard M. Nixon; and the Democratic candidate, Senator John F. Kennedy. Now representatives of the candidates and of all the radio and television networks have agreed on these rules: neither candidate will make an opening statement or a closing summation; each will be questioned in turn; each will have an opportunity to comment upon the answer of the other; each reporter will ask only one question in turn. He is free to ask any question he chooses. Neither candidate knows what questions will be asked and only the clock will determine who will be asked the last question. These programs represent an unprecedented opportunity for the candidates to present their philosophies and programs directly to the people and for the people to compare these and the candidates. The four reporters on tonight's panel include a newspaperman and a wire service representative. These two were selected by lot by the press secretaries of the candidates from among the reporters traveling with the candidates. The broadcasting representatives were selected by their respective companies. The reporters are: Paul Niven of CBS, Edward P. Morgan of ABC, Alvin Spivak of United Press International, and Harold R. Levy of Newsday. Now the first question is from Mr. Niven and is for Vice President Nixon. MR. NIVEN: Mr. Vice President, Senator Kennedy said last night that the Administration must take responsibility for the loss of Cuba. Would you compare the validity of that statement with the validity of your own statements in previous campaigns that the Truman Administration was responsible for the loss of China to the Communists? MR. NIXON: Well first of all, I don't agree with Senator Kennedy that Cuba is lost and certainly China was lost when this Administration came into power in 1953. As I look at Cuba today, I believe that we are following the right course, a course which is difficult but a course which under the circumstance is the only proper one which will see that the Cuban people get a chance to realize their aspirations of progress through freedom and that they get that with our cooperation with the other organi- of the states in the Organization of American States. Now Senator Kennedy has made some very strong criticisms of my part - or alleged part - in what has happened in Cuba. He points to the fact that I visited Cuba while Mr. Batista was in power there. I can only point out that if we are going to judge the Administrations in terms of our attitude toward dictators, we're glad to have a comparison with the previous administration. There were eleven dictators in South America and in Central America when we came in, in 1953. Today there are only three left including the one in Cuba. We think that's pretty good progress. Senator Kennedy also indicated with regard to Cuba that he thought that I had made a mistake when I was in Cuba in not calling for free elections in that country. Now I'm very surprised that Senator Kennedy, who is on the Foreign Relations Committee, would have made such a statement as this kind. As a matter of fact in his book, The Strategy for Peace, he took the right position. And that position is that the United States has a treaty - a treaty with all of the Organization of American States - which prohibits us from interfering in the internal affairs of any other state and prohibits them as well. For me to have made such a statement would been in direct uh - opposition to that treaty. Now with regard to Cuba, let me make one thing clear. There isn't any question but that we will defend our rights there. There isn't any question but that we will defend Guantanamo if it's attacked. There also isn't any question but that the free people of Cuba - the people who want to be free - are going to be supported and that they will attain their freedom. No, Cuba is not lost, and I don't think this kind of defeatist talk by Senator Kennedy helps the situation one bit. MR. McGEE: Senator Kennedy, would you care to comment? MR. KENNEDY: In the first place I've never suggested that Cuba was lost except for the present. In my speech last night I indicated that I thought that Cuba one day again would be free. Where I've been critical of the Administration's policy, and where I criticized Mr. Nixon, was because in his press conference in Havana in 1955, he praised the competence and stability of the bicta- bict- Batista dictatorship - that dictatorship had killed over twenty thousand Cubans in seven years. Secondly, I did not criticize him for not calling for free elections. What I criticized was the failure of the Administration to use its great influence to persuade the Cuban government to hold free elections, particularly in 1957 and 1958. Thirdly, Arthur Gardner, a Republican Ambassador, Earl Smith, a Republican Ambassador, in succession - both have indicated in the past six weeks that they reported to Washington that Castro was a Marxist, that Raul Castro was a Communist, and that they got no effective results. Instead our aid continued to Batista, which was ineffective; we never were on the side of freedom; we never used our influence when we could have used it most effectively - and today Cuba is lost for freedom. I hope some day it will rise; but I don't think it will rise if we continue the same policies toward Cuba that we did in recent years, and in fact towards all of Latin America - when we've almost ignored the needs of Latin America; we've beamed not a single Voice of America program in Spanish to all of Latin America in the last eight years, except for the three months of the Hungarian uh - revolution. MR. McGEE: Mr. Morgan, with a question for Senator Kennedy. MR. MORGAN: Senator, last May, in Oregon, you discussed the possibilities of sending apologies or regrets to Khrushchev over the U-2 incident. Do you think now that that would have done any good? Did you think so then? MR. KENNEDY: Mr. Morgan, I suggested that if the United States felt that it could save the summit conference that it would have been proper for us to have expressed regrets. In my judgment that statement has been distorted uh - by Mr. Nixon and others in their debates around the country and in their discussions. Mr. Lodge, on "Meet the Press" a month ago, said if there was ever a case when we did not have law an our side it was in the U-2 incident. The U-2 flights were proper from the point of view of protecting our security. But they were not in accordance with international law. And I said that I felt that rather than tell the lie which we told, rather than indicate that the flights would continue - in fact, I believe Mr. Nixon himself said on May fifteenth that the flights would continue even though Mr. Herter testified before the Senate Foreign Relations Committee that they had been canceled as of May twelfth - that it would have been far better that if we had expressed regrets, if that would have saved the summit, and if the summit is useful - and I believe it is. The point that is always left out is the fact that we expressed regrets to Castro this winter; that we expressed regrets - the Eisenhower Administration expressed regrets - for a flight over Southern Russia in 1958. We expressed regrets for a flight over Eastern Germany under this Administration. The Soviet Union in 1955 expressed regrets to us over the Bering Sea incident. The Chinese Communists expressed regrets to us over a plane incident in 1956. That is the accepted procedure between nations; and my judgment is that we should follow the advice of Theodore Roosevelt: Be strong; maintain a strong position; but also speak softly. I believe that in those cases where international custom calls for the expression of a regret, if that would have kept the summit going, in my judgment it was a proper action. It's not appeasement. It's not soft. I believe we should be stronger than we now are. I believe we should have a stronger military force. I believe we should increase our strength all over the world. But I don't confuse words with strength; and in my judgment if the summit was useful, if it would have brought us closer to peace, that rather than the lie that we told - which has been criticized by all responsible people afterwards - it would have been far better for us to follow the common diplomatic procedure of expressing regrets and then try to move on. MR. McGEE: Mr. Vice President. MR. NIXON: I think Kenne- Senator Kennedy is wrong on three counts. First of all, he's wrong in thinking th- er- even suggesting that Mr. Khrushchev might have continued the conference if we had expressed regrets. He knew these flights were going on long before and that wasn't the reason that he broke up the conference. Second, he's wrong in the analogies that he makes. The United States is a strong country. Whenever we do anything that's wrong, we can express regrets. But when the president of the United States is doing something that's right, something that is for the purpose of defending the security of this country against surprise attack, he can never express regrets or apologize to anybody, including Mr. Khrushchev. Now in that connection Senator Kennedy has criticized the President on the ground not only of not expressing regrets, but because he allowed this flight to take place while the summit conference - or immediately before the summit conference occurred. This seems to me is criticism that again is wrong on his part. We all remember Pearl Harbor. We lost three thousand American lives. We cannot afford an intelligence gap. And I just want to make my position absolutely clear with regard to getting intelligence information. I don't intend to see to it that the United States is ever in a position where, while we're negotiating with the Soviet Union, that we discontinue our intelligence effort. And I don't intend ever to express regrets to Mr. Khrushchev or anybody else if I'm doing something that has the support of the Congress and that is right for the purpose of protecting the security of the United States. MR. McGEE: Mr. Spivak with a question for Vice President Nixon. MR. SPIVAK: Mr. Vice President, you have accused Senator Kennedy of avoiding the civil rights issue when he has been in the South and he has accused you of the same thing. With both North and South listening and watching, would you sum up uh - your own intentions in the field of civil rights if you become president. MR. NIXON: My intentions in the field of civil rights have been spelled out in the Republican platform. I think we have to make progress first in the field of employment. And there we would give statutory authority to the Committee on Government Contracts, which is an effective way of getting real progress made in this area, since about one out of every four jobs is held by and is allotted by people who have government contracts. Certainly I think all of us agree that when anybody has a government contract, certainly the money that is spent under that contract ought to be disbursed equally without regard to the race or creed or color of the individual who is to be employed. Second, in the field of schools, we believe that there should be provisions whereby the federal government would give assistance to those districts who do want to integrate their schools. That of course was rejected as was the government contracts provision by the special session of the Congress to - in which Mr. Kennedy was quite active. And then as far as other areas are concerned, I think that we have to look to presidential leadership. And when I speak of presidential leadership, I refer for example to our attitude on the sit-in strikes. Here we have a situation which causes all of us concern - causes us concern because of the denial of the rights of people to the equality which we think belongs to everybody. I have talked to Negro mothers. I've heard them explain - try to explain - how they tell their children how they can go into a store and buy a loaf of bread but then can't go into that store and sit at the counter and get a Coca Cola. This is wrong, and we have to do something about it. So, under the circumstances, what do we do? Well what we do is what the Attorney-General of the United States did under the direction of the President: call in the owners of chain stores and get them to take action. Now there are other places where the executive can lead, but let me just sum up by saying this: why do I talk every time I'm in the South on civil rights? Not because I am preaching to the people of the South because this isn't just a Southern problem; it's a Northern problem and a Western problem; it's a problem for all of us. I do it because it's the responsibility of leadership, I do it because we have to solve this problem together. I do it right at this time particularly because when we have Khrushchev in this country - a man who has enslaved millions, a man who has slaughtered thousands - we cannot continue to have a situation where he can point the finger at the United States of America and say that we are denying rights to our citizens. And so I say both the candidates and both the vice presidential candidates, I would hope as well - including Senator Johnson - should talk on this issue at every opportunity. MR. McGEE: Senator Kennedy. MR. KENNEDY: Well, Mr. Nixon hasn't discussed the two basic questions: what is going to be done and what will be his policy on implementing the Supreme Court decision of 1954? Giving aid to schools technically that are trying to carry out the decision is not the great question. Secondly, what's he going to do to provide fair employment? He's been the head of the Committee on Government Contracts that's carried out two cases, both in the District of Columbia. He has not indicated his support of an attempt to provide fair employment practices around the country, so that everyone can get a job regardless of their race or color. Nor has he indicated that he will support Title Three, which would give the Attorney General additional powers to protect Constitutional rights. These are the great questions: equality of education in school. About two percent of our population of white people are - is illiterate, ten per cent of our colored population. Sixty to seventy percent of our colored children do not finish high school. These are the questions in these areas that the North and South, East and West are entitled to know. What will be the leadership of the president in these areas to provide equality of opportunity for employment? Equality of opportunity in the field of housing, which could be done on all federal supported housing by a stroke of the president's pen. What will be done to provide equality of education in all sections of the United States? Those are the questions to which the president must establish a moral tone and moral leadership. And I can assure you that if I'm elected president we will do so. MR. McGEE: Mr. Levy with a question for Senator Kennedy. MR. LEVY: Senator, on the same subject, in the past you have emphasized the president's responsibility as a moral leader as well as an executive on civil rights questions. What specifically might the next president do uh - in the event of an uh - an occurrence such as Little Rock or the lunch-counter sit-ins? From the standpoint of MR, KENNEDY: Well let me say that I think that the president operates in a number of different areas. First, as a legislative leader. And as I just said that I believe that the passage of the so-called Title Three, which gives the Attorney General the power to protect Constitutional rights in those cases where it's not possible for the person involved to bring the suit. Secondly, as an executive leader. There have been only six cases brought by this Attorney General under the voting bill passed in 1957 and the voting bill passed in 1960. The right to vote is basic. I do not believe that this Administration has implemented those bills which represent the will of the majority of the Congress on two occasions with vigor. Thirdly, I don't believe that the government contracts division is operated with vigor. Everyone who does business with the government should have the opportunity to make sure that they do not practice discrimination in their hiring. And that's in all sections of the United States. And then fourthly, as a moral leader. There is a very strong moral basis for this concept of equality of opportunity. We are in a very difficult time. We need all the talent we can get. We sit on a conspicuous stage. We are a goldfish bowl before the world. We have to practice what we preach. We set a very high standard for ourselves. The Communists do not. They set a low standard of materialism. We preach in the Declaration of Independence and in the Constitution, in the statement of our greatest leaders, we preach very high standards; and if we're not going to be s- charged before the world with hypocrisy we have to meet those standards. I believe the president of the United States should indicate it. Now lastly, I believe in the case of Little Rock. I would have hoped that the president of the United States would have been possible for him to indicate it clearly that uh - the Supreme Court decision was going to be carried out. I would have hoped that it would have been possible to use marshals to do so. But it wou- uh - evidently uh - under the handling of the case it was not. I would hope an incident like that would not happen. I think if the president is responsible, if he consults with those involved, if he makes it clear that the Supreme Court decision is going to be carried out in a way that the Supreme Court planned - with deliberate speed - then in my judgment, providing he's behind action, I believe we can make uh - progress. Now the present Administration - the President - has said - never indicated what he thought of the 1954 decision. Unless the president speaks, then of course uh - the country doesn't speak, and Franklin Roosevelt said: "The pre - uh - the presidency of the United States is above all a place of moral leadership." And I believe on this great moral issue he should speak out and give his views clearly. MR. McGEE: Mr. Vice President. MR. NIXON: Senator Kennedy has expressed some hopes in this field, hopes which I think all Americans would share who want some problem - some progress in this area. But let's look at the performance. When he selected his vice presidential running mate, he selected a man who had voted against most of these proposals and who opposes them at the present time. Let me s- look also at what I did. I selected a man who stands with me in this field and who will talk with me and work with me on it. Now the Senator referred to the Committee on Government Contracts. And yet that very committee of which I am chairman has been handicapped by the fact that we have not had adequate funds; we have not had adequate powers; we haven't had an adequate staff. Now in the special session of Congress and also in the session that preceded it, the Democratic Congress - in which there's a two-to-one Democratic majority - was asked by the President to give us the funds and give us the power to do a job and they did nothing at all, And in the special session in which Senator Kennedy was calling the signals, along with Senator Johnson, they turned it down and he himself voted against giving us the powers despite the fact that the bill had already been considered before, that it already had hearings on, and the Congress already knew what it had before it. All that I can say is this: what we need here are not just high hopes. What we need is action. And in the field of executive leadership, I can say that I believe it's essential that the president of the United States not only set the tone but he also must lead; he must act as he talks. MR. McGEE: Mr. Morgan with a question for Vice President Nixon. MR. MORGAN: Mr. Vice President, in your speeches you emphasize that the United States is doing basically well in the cold war. Can you square that statement with a considerable mass of bipartisan reports and studies, including one prominently participated in by Governor Rockefeller, which almost unanimously conclude that we are not doing nearly so well as we should? MR. NIXON: Mr. Morgan, no matter how well we're doing in the cold war, we're not doing as well as we should. And that will always be the case as long as the Communists are on the international scene, in the aggressive tac- uh - tendencies that they presently are following. Now as far as the present situation is concerned, I think it's time that we nail a few of these distortions about the United States that have been put out. First of all, we hear that our prestige is at an all-time low. Senator Kennedy has been hitting that point over and over again. I would suggest that after Premier Kush- Khrushchev's uh - performance in the United Nations, compared with President Eisenhower's eloquent speech, that at the present time Communist prestige in the world is at an all-time low and American prestige is at an all-time high. Now that, of course, is just one factor, but it's a significant one. When we look, for example, at the vote on the Congo. We were on one side; they were on the other side. What happened? There were seventy votes for our position and none for theirs. Look at the votes in the United Nations over the past seven and a half years. That's a test of prestige. Every time the United States has been an one side and they've been on the other side, our position has been sustained. Now looking to what we ought to do in the future. In this cold war we have to recognize where it is being fought and then we have to develop programs to deal with it. It's being fought primarily in Asia, in Africa, and in Latin America. What do we need? What tools do we need to fight us? Well we need, for example, economic assistance; we need technical assistance; we need exchange; we need programs of diplomatic and other character which will be effective in that area. Now Senator Kennedy a moment ago referred to the fact that there was not an adequate Voice of America program for Latin America. I'd like to point out that in the last six years, the Democratic Congresses, of which he'd been a member, have cut twenty million dollars off of the Voice of America programs. They also have cut four billion dollars off of mutual security in these last six years. They also have cut two billion dollars off of defense. Now when they talk about our record here, it is well that they recognize that they have to stand up for their record as well. So let me summarize by saying this: I'm not satisfied with what we're doing in the cold war because I believe we have to step up our activities and launch an offensive for the minds and hearts and souls of men. It must be economic; it must be technological; above all it must be ideological. But we've got to get help from the Congress in order to do this. MR. McGEE: Senator Kennedy. MR. KENNEDY: Of course Mr. Nixon is wholly inaccurate when he says that the Congress has not provided more funds in fact than the President recommended for national defense. Nineteen fifty-three we tried to put an appropriation of five billion dollars for our defenses. I was responsible for the amendment with Senator Monroney in 1954 to strengthen our ground forces. The Congress of the United States appropriated six hundred and seventy-seven million dollars more than the President was willing to use up till a week ago. Secondly, on the question of our position in the United Nations. We all know about the vote held this week - of the five neutralists - and it was generally regarded as a defeat for the United States. Thirdly, in 1952, there were only seven votes in favor of the admission of Red China into the United Nations. Last year there were twenty-nine and tomorrow when the preliminary vote is held you will see a strengthening of that position or very closely to it. We have not maintained our position and our prestige. A Gallup Poll taken in February of this year asking the - in eight out of nine countries - they asked the people, who do they think would be ahead by 1970 militarily and scientifically, and a majority in eight of the nine countries said the Soviet Union would be by 1970. Governor Rockefeller has been far more critical in June of our position in the world than I have been. The Rockefeller Brothers report, General Ridgway, General Gavin, the Gaither Report, various reports of Congressional committees all indicate that the relative strength of the p- United States both militarily, politically, psychologically, and scientifically and industrially - the relative strength of the so- of United States compared to that of the Soviet Union and the Chinese Communists together - has deteriorated in the last eight years and we should know it, and the American people should be told the facts. MR. McGEE: Mr. Spivak with a question for Senator Kennedy. MR. SPIVAK: Senator, uh - following this up, how would you go about increasing the prestige you say we're losing, and could the programs you've devised to do so be accomplished without absolutely wrecking our economy? MR. KENNEDY: Yes. We have been wholly indifferent to Latin America until the last few months. The program that was put forward this summer, after we broke off the sugar quota with Cuba, really was done because we wanted to get through the O.A.S. meeting a condemnation of Russian infiltration of Cuba. And therefore we passed an authorization - not an aid bill - which was the first time, really, since the Inter-American Bank which was founded a year ago was developed, that we really have looked at the needs of Latin America; that we have associated ourselves with those people. Secondly, I believe that in the ca- that it's far better for the United States, instead of concentrating our aid, particularly in the underdeveloped world, on surplus military equipment - we poured three hundred million dollars of surplus military equipment into Laos. We paid more military aid, more aid into Laos po- per - per person than in any country in the world and we ought to know now that Laos is moving from neutralism in the direction of the Communists. I believe instead of doing that, we should concentrate our aid in long-term loans which these people can pay back either in hard money or in local currency. This permits them to maintain their self-respect. It permits us to make sure that the projects which are invested in are going to produce greater wealth. And I believe that in cases of India and Africa and Latin America that this is where our emphasis should be. I would strengthen the Development Loan Fund. And Senator Fulbright, Senator Humphrey and I tried to do that. We tried to provide an appropriation of a billion and a half for five years, on a long-term loan basis, which this Administration opposed. And unless we're ready to carry out programs like that in the sixties, this battle for economic survival which these people are waging are going to be lost. And if India should lose her battle, with thirty-five per cent of the people of the underdeveloped world within her borders, then I believe that the balance of power could move against us. I think the United States can afford to do these things. I think that we could not afford not to do these things. This goes to our survival. And here in a country which if it is moving ahead, if it's developing its economy to the fullest - which we are not now - in my judgment, we'll have the resources to meet our military commitments and also our commitments overseas. I believe it's essential that we do it because in the next ten years the balance of power is going to begin to move in the world from one direction or another - towards us or towards the Communists - and unless we begin to identify ourselves not only with the anti-Communist fight, but also with the fight against poverty and hunger, these people are going to begin to turn to the Communists as an example. I believe we can do it. If we build our economy the way we should, we can afford to do these things and we must do it. MR. McGEE: Mr. Vice President. MR. NIXON: Senator Kennedy has put a great deal of stress on the necessity for economic assistance. This is important. But it's also tremendously important to bear in mind that when you pour in money without pouring in technical assistance at w- as well, that you have a disastrous situation. We need to step up exchange; we need to step up technical assistance so that trained people in these newly developing countries can operate the economies. We also have to have in mind something else with regard to this whole situation in the world, and that is: that as America moves forward, we not only must think in terms of fighting Communism, but we must also think primarily in terms of the interests of these countries. We must associate ourselves with their aspirations. We must let them know that the great American ideals - of independence, of the right of people to be free, and of the right to progress - that these are ideals that belong not to ourselves alone, but they belong to everybody. This we must get across to the world. And we can't do it unless we do have adequate funds for, for example, information which has been cut by the Congress, adequate funds for technical assistance. The other point that I would make with regard to economic assistance and technical assistance is that the United States must not rest its case here alone. This is primarily an ideological battle - a battle for the minds and the hearts and the souls of men. We must not meet the Communists purely in the field of gross atheistic materialism. We must stand for our ideals. MR. McGEE: Mr. Levy with a question for Vice President Nixon. MR. LEVY; Mr. Vice President, the Labor Department today added five more major industrial centers to the list of areas with substantial unemployment. You said in New York this week that as president you would use the full powers of the government, if necessary, to combat unemployment. Specifically what measures would you advocate and at what point? MR. NIXON: To combat unemployment we first must concentrate on the very areas to which you refer - the so-called depressed areas. Now in the last Congress - the special session of the Congress - there was a bill: one by the President, one by Senator Kennedy and members of his party. Now the bill that the President had submitted would have provided more aid for those areas that really need it - areas like Scranton and Wilkes-Barre and the areas of West Virginia - than the ones that Senator Kennedy was supporting. On the other hand we found that the bill got into the legislative difficulties and consequently no action was taken. So point one, at the highest priority we must get a bill for depressed areas through the next Congress. I have made recommendations on that and I have discussed them previously and I will spell them out further in the campaign. Second, as we consider this problem of unemployment, we have to realize where it is. In analyzing the figures we will find that our unemployment exists among the older citizens; it exists also among those who are inadequately trained; that is, those who do not have an adequate opportunity for education. It also exists among minority groups. If we're going to combat unemployment, then, we have to do a better job in these areas. That's why I have a program for education, a program in the case of equal job opportunities, and one that would also deal with our older citizens. Now finally, with regard to the whole problem of combating recession, as you call it, we must use the full resources of the government in these respects: one, we must see to it that credit is expanded as we go into any recessionary period - and understand, I do not believe we're going into a recession. I believe this economy is sound and that we're going to move up. But second, in addition to that, if we do get into a recessionary period we should move on that part of the economy which is represented by the private sector, and I mean stimulate that part of the economy that can create jobs - the private sector of the economy. This means through tax reform and if necessary tax cuts that will stimulate more jobs. I favor that rather than massive federal spending programs which will come into effect usually long after you've passed through the recessionary period. So we must use all of these weapons for the purpose of combating recession if it should come. But I do not expect it to come. MR. McGEE: Senator Kennedy. MR. KENNEDY: Well Mr. Nixon has stated the record inaccurately in regard to the depressed area bill. I'm very familiar with it. It came out of the committee of which I was the chairman - the labor subcommittee - in fifty-five. I was the floor manager. We passed an area redevelopment bill far more effective than the bill the Administration suggested, on two occasions, and the President vetoed it both times. We passed a bill again this year in the cong- in the Senate and it died in the Rules Committee of the House of Representatives. Let me make it very clear that the bill that Mr. Nixon talked about did not mention Wilkes-Barre or Scranton; it did not mention West Virginia. Our bill was far more effective. The bill introduced and erd- sponsored by Senator Douglas was far more effective in trying to stimulate the economy of those areas. Secondly, he has mentioned the problem of our older citizens. I cannot still understand why this Administration and Mr. Nixon oppose putting medical care for the aged under Social Security to give them some security. Third, I believe we should step up the use of our surplus foods in these areas until we're able to get the people back to work. Five cents a day - that's what the food package averages per person. Fourthly, I believe we should not carry out a hard money, high interest rate policy which helped intensify certainly the recession of 1958, and I think helped bring the slow-down of 1960. If we move into a recession in sixty-one, then I would agree that we have to put more money into the economy, and it can be done by either one of the two methods discussed. One is by ex- the programs such as aid to education. The other would be to make a judgment on what's the most effective tax program to stimulate our economy. MR. McGEE: Mr. Niven with a question for Senator Kennedy. MR. NIVEN: Senator, while the main theme of your campaign has been this decline of American power and prestige in the last eight years, you've hardly criticized President Eisenhower at all. And in a speech last weekend you said you had no quarrel with the President. Now isn't Mr. Eisenhower and not Mr. Nixon responsible for any such decline? MR. KENNEDY: Well I understood that this was the Eisenhower-Nixon Administration according to all the Republican uh - propaganda that I've read. The question is what we're going to do in the future. I've been critical of this Administration and I've been critical of the President. In fact uh - Mr. Nixon uh - discussed that a week ago in a speech. I believe that our power and prestige in the last eight years has declined. Now what is the issue is what we're going to do in the future. Now that's an issue between Mr. Nixon and myself. He feels that we're moving ahead uh - in a - we're not going into a recession in this country, economically; he feels that our power and prestige is stronger than it ever was relative to that of the Communists, that we're moving ahead. I disagree. And I believe the American people have to make the choice on November eighth between the view of whether we have to move ahead faster, whether what we're doing now is not satisfactory, whether we have to build greater strength at home and abroad and Mr. Nixon's view. That's the great issue. President Eisenhower moves from the scene on January twentieth and the next four years are the critical years. And that's the debate. That's the argument between Mr. Nixon and myself and on that issue the American people have to make their judgment and I think it's a important judgment. I think in many ways this election is more important than any since 1932, or certainly almost any in this century. Because we disagree very fundamentally on the position of the United States, and if his view prevails then I think that's going to bring an important result to this country in the sixties. If our view prevails that we have to do more, that we have to make a greater national and international effort, that we have lost prestige in Latin America - the President of Brazil - the new incumbent running for office called on Castro during his campaign because he thought it was important to get the vote of those who were supporting Castro in Latin America. In Africa, the United States has ignored Latin uh - Africa. We gave more scholarships to the Congo - this summer we offered them - than we've given to all of Africa the year before. Less than two hundred for all the countries of Africa and they need trained leadership more than anything. We've been uh - having a very clear decision in the last eight years. Mr. Nixon has been part of that Administration. He's had experience in it. And I believe this Administration has not met its responsibilities in the last eight years, that our power relative to that of the Communists is declining, that we're facing a very hazardous time in the sixties, and unless the United States begin to move here - unless we start to go ahead - I don't believe that we're going to meet our responsibility to our own people or to the cause of freedom. I think the choice is clear and it involves the future. MR. McGEE: Mr. Vice President. MR. NIXON: Well first of all, I think Senator Kennedy should make up his mind with regard to my responsibility. In our first debate he indicated that I had not had experience or at least uh - had not participated significantly in the making of the decisions. I'm glad to hear tonight that he does suggest that I have had some experience. Let me make my position cl ear. I have participated in the discussions leading to the decisions in this Administration. I'm proud of the record of this Administration. I don't stand on it because it isn't something to stand on but something to build on. Now looking at Senator Kennedy's credentials: he is suggesting that he will move America faster and further than I will. But what does he offer? He offers retreads of programs that failed. I submit to you that as you look at his programs, his program for example with regard to the Federal Reserve and uh - free money or loose money uh - high - low interest rates, his program in the economic field generally are the programs that were adopted and tried during the Truman Administration. And when we compare the economic progress of this country in the Truman Administration with that of the Eisenhower Administration, we find that in every index there has been a tr- great deal more performance and more progress in this Administration than in that one. I say the programs and the leadership that failed then is not the program and the leadership that America needs now. I say that the American people don't want to go back to those policies. And incidentally if Senator Kennedy disagrees, he should indicate where he believes those policies are different from those he's advocating today. MR. McGEE: Mr. Spivak with a question for Vice President Nixon. MR. SPIVAK: Mr. Vice President, according to news dispatches Soviet Premier Khrushchev said today that Prime Minister Macmillan had assured him that there would be a summit conference next year after the presidential elections. Have you given any cause for such assurance, and do you consider it desirable or even possible that there would be a summit conference next year if Mr. Khrushchev persists in the conditions he's laid down? MR. NIXON: No, of course I haven't talked to Prime Minister Macmillan. It would not be appropriate for me to do so. The President is still going to be president for the next four months and he, of course, is the only one who could commit this country in this period. As far as a summit conference is concerned, I want to make my position absolutely clear. I would be willing as president to meet with Mr. Khrushchev or any other world leader if it would serve the cause of peace. I would not be able wou- would be willing to meet with him however, unless there were preparations for that conference which would give us some reasonable certainty - some reasonable certainty - that you were going to have some success. We must not build up the hopes of the world and then dash them as was the case in Paris. There, Mr. Khrushchev came to that conference determined to break it up. He was going to break it up because he would - knew that he wasn't going to get his way on Berlin and on the other key matters with which he was concerned at the Paris Conference. Now, if we're going to have another summit conference, there must be negotiations at the diplomatic level - the ambassadors, the Secretaries of State, and others at that level - prior to that time, which will delineate the issues and which will prepare the way for the heads of state to meet and make some progress. Otherwise, if we find the heads of state meeting and not making progress, we will find that the cause of peace will have been hurt rather than helped. So under these circumstances, I, therefore, strongly urge and I will strongly hold, if I have the opportunity to urge or to hold - this position: that any summit conference would be gone into only after the most careful preparation and only after Mr. Khrushchev - after his disgraceful conduct at Paris, after his disgraceful conduct at the United Nations - gave some assurance that he really wanted to sit down and talk and to accomplish something and not just to make propaganda. MR. McGEE: Senator Kennedy. MR. KENNEDY: I have no disagreement with the Vice President's position on that. It - my view is the same as his. Let me say there is only one uh - point I would add. That before we go into the summit, before we ever meet again, I think it's important that the United States build its strength; that it build its military strength as well as its own economic strength. If we negotiate from a position where the power balance or wave is moving away from us, it's extremely difficult to reach a successful decision on Berlin as well as the other questions. Now the next president of the United States in his first year is going to be confronted with a very serious question on our defense of Berlin, our commitment to Berlin. It's going to be a test of our nerve and will. It's going to be a test of our strength. And because we're going to move in sixty-one and two, partly because we have not maintained our strength with sufficient vigor in the last years, I believe that before we meet that crisis, that the next president of the United States should send a message to Congress asking for a revitalization of our military strength, because come spring or late in the winter we're going to be face to face with the most serious Berlin crisis since l949 or fifty. On the question of the summit, I agree with the position of Mr. Nixon. I would not meet Mr. Khrushchev unless there were some agreements at the secondary level - foreign ministers or ambassadors - which would indicate that the meeting would have some hope of success, or a useful exchange of ideas. MR. McGEE: Mr. Levy with a question for Senator Kennedy. MR. LEVY: Senator, in your acceptance speech at Los Angeles, you said that your campaign would be based not on what you intend to offer the American people, but what you intend to ask of them. Since that time you have spelled out many of the things that you intend to do but you have made only vague reference to sacrifice and self-denial. A year or so ago, I believe, you said that you would not hesitate to recommend a tax increase if you considered it necessary. MR. KENNEDY: That's right. MR. LEVY: Is this what you have in mind? MR. KENNEDY: Well I don't think that in the winter of sixty-one under present economic conditions, it uh - a - uh - tax uh - increase would be desirable. In fact, it would be deflationary; it would cause great unemployment; it would cause a real slowdown in our economy. If it ever becomes necessary, and is wise economically and essential to our security, I would have no hesitancy in suggesting a tax increase or any other policy which would defend the United States. I have talked in every speech about the fact that these are going to be very difficult times in the nineteen-sixties and that we're going to have to meet our responsibilities as citizens. I'm talking about a national mood. I'm talking about our willingness to bear any burdens in order to maintain our own freedom and in order to meet our freedom around the globe. We don't know what the future's going to bring. But I would not want anyone to elect me uh - president of the United States - or vote for me - under the expectation that life would be easier if I were elected. Now, many of the programs that I'm talking about - economic growth, care for the aged, development of our natural resources - build the strength of the United States. That's how the United States began to prepare for its great actions in World War II and in the post-war period. If we're moving ahead, if we're providing a viable economy, if our people have sufficient resources so that they can consume what we produce; then this country's on the move, then we're stronger, then we set a better example to the world. So we have the problem of not only building our own uh - military strength and extending uh - our policies abroad, we have to do a job here at home. So I believe that the policies that I recommend came under the general heading of strengthening the United States. We're using our steel capacity fifty-five per cent today. We're not able to consume what we're able to produce at a time when the Soviet Union is making great economic gains. And all I say is, I don't know what the sixties will bring - except I think they will bring hard times in the uh - international sphere; I hope we can move ahead here at home in the United States; I'm confident we can do a far better job of mobilizing our economy and resources in the United States. And I merely say that they - if they elect me president, I will do my best to carry the United States through a difficult period; but I would not want people to elect me because I promised them the easy, soft life. I think it's going to be difficult; but I'm confident that this country can meet its responsibilities. MR. McGEE: Mr. Vice President. MR. NIXON: Well I think we should be no - under no illusions whatever about what the responsibilities of the American people will be in the sixties. Our expenditures for defense, our expenditures for mutual security, our expenditures for economic assistance and technical assistance are not going to get less. In my opinion they're going to be de- be greater. I think it may be necessary that we have more taxes. I hope not. I hope we can economize elsewhere so that we don't have to. But I would have no hesitation to ask the American people to pay the taxes even in l961 - if necessary - to maintain a sound economy and also to maintain a sound dollar. Because when you do not tax, and tax enough to pay for your outgo, you pay it many times over in higher prices and inflation; and I simply will not do that. I think I should also add that as far as Senator Kennedy's proposals are concerned, if he intends to carry out his platform - the one adopted in Los Angeles - it is just impossible for him to make good on those promises without raising taxes or without having a rise in t- prices or both. The platform suggests that it can be done through economic growth; that it can be done, in effect, with mirrors. But it isn't going to be working that way. You can't add billions of dollars to our expenditures and not pay for it. After all, it isn't paid for by my money, it isn't paid for by his, but by the people's money. MR. McGEE: Mr. Niven with a question for Vice President Nixon. MR. NIVEN: Mr. Vice President, you said that while Mr. Khrushchev is here, Senator Kennedy should talk about what's right with this country as well as what's wrong with the country. In the 1952 campaign when you were Republican candidate for Vice President, and we were eh - at war with the Communists, did you feel a similar responsibility to t- talk about what was right with the country? MR. NIXON: I did. And as I pointed out in 1952, I made it very clear that as far as the Korean War was concerned, that I felt that the decision to go into the war in Korea was right and necessary. What I criticized were the policies that made it necessary to go to Korea. Now incidentally, I should point out here that Senator Kennedy has attacked our foreign policy. He's said that it's been a policy that has led to defeat and retreat. And I'd like to know where have we been defeated and where have we retreated? In the Truman Administration, six hundred million people went behind the Iron Curtain including the satellite countries of Eastern Europe and Communist China. In this Administration we've stopped them at Quemoy and Matsu; we've stopped them in Indochina; we've stopped them in Lebanon; we've stopped them in other parts of the world. I would also like to point out that as far as Senator Kennedy's comments are concerned, I think he has a perfect right and a responsibility to criticize this Administration whenever he thinks we're wrong. But he has a responsibility to be accurate, and not to misstate the case. I don't think he should say that our prestige is at an all-time low. I think this is very harmful at a time Mr. Khrushchev is here - harmful because it's wrong. I don't think it was helpful when he suggested - and I'm glad he's corrected this to an extent - that seventeen million people go to bed hungry every night in the United States. Now this just wasn't true. Now, there are people who go to bed hungry in the United States - far less, incidentally, than used to go to bed hungry when we came into power at the end of the Truman Administration. But the thing that is right about the United States, it should be emphasized, is that less people go to bed hungry in the United States than in any major country in the world. We're the best fed; we're the best clothed, with a better distribution of this world's goods to all of our people than any people in history. Now, in pointing out the things that are wrong, I think we ought to emphasize America's strengths. It isn't necessary to - to run America down in order to build her up. Now so that we get it absolutely clear: Senator Kennedy must as a candidate - as I as a candidate in fifty-two - criticize us when we're wrong. And he's doing a very effective job of that, in his way. But on the other hand, he has a responsibility to be accurate. And I have a responsibility to correct him every time he misstates the case; and I intend to continue to do so. MR. McGEE: Senator Kennedy. MR. KENNEDY: Well, Mr. Nixon uh- I'll just give you the testimony of Mr. George Aiken - Senator George Aiken, the ranking minority member - Republican member - and former chairman of the Senate Agricultural Committee testifying in 1959 - said there were twenty-six million Americans who did not have the income to afford a decent diet. Mr. Benson, testifying on the food stamp plan in 1957, said there were twenty-five million Americans who could not afford a elementary low-cost diet. And he defined that as someone who uses beans in place of meat. Now I've seen a good many hundreds of thousands of people who are uh - not adequately fed. You can't tell me that a surplus food distribution of five cents po- per person - and that n- nearly six million Americans receiving that - is adequate. You can't tell me that any one who uses beans instead of meat in the United States - and there are twenty-five million of them according to Mr. Benson - is well fed or adequately fed. I believe that we should not compare what our figures may be to India or some other country that has serious problems but to remember that we are the most prosperous country in the world and that these people are not getting adequate food. And they're not getting in many cases adequate shelter. And we ought to try to meet the problem. Secondly, Mr. Nixon has continued to state - and he stated it last week - these fantastic figures of what the Democratic budget would c- uh - platform would cost. They're wholly inaccurate. I said last week I believed in a balanced budget. Unless there was a severe recession - and after all the worst unbalanced budget in history was in 1958, twelve billion dollars - larger than in any Administration in the history of the United States. So that I believe that on this subject we can balance the budget unless we have a national emergency or unless we have a severe recession. MR. McGEE: Mr. Morgan with a question for Senator Kennedy. MR. MORGAN: Senator, Saturday on television you said that you had always thought that Quemoy and Matsu were unwise places to draw our defense line in the Far East. Would you comment further on that and also address to this question; couldn't a pullback from those islands be interpreted as appeasement? MR. KENNEDY: Well, the United States uh - has on occasion attempted uh - mostly in the middle fifties, to persuade Chiang Kai-shek to pull his troops back to Formosa. I believe strongly in the defense of Formosa. These islands are a few miles - five or six miles - off the coast of Red China, within a general harbor area and more than a hundred miles from Formosa. We have never said flatly that we will defend Quemoy and Matsu if it's attacked. We say we will defend it if it's part of a general attack on Formosa. But it's extremely difficult to make that judgment. Now, Mr. Herter in 1958, when he was Under Secretary of State, said they were strategically undefensible. Admirals Spruance and Callins in 1955 said that we should not attempt to defend these islands, in their conference in the Far East. General Ridgway has said the same thing. I believe that when you get into a w- if you're going to get into war for the defense of Formosa, it ought to be on a clearly defined line. One of the problems, I think, at the time of South Korea was the question of whether the United States would defend it if it were attacked. I believe that we should defend Formosa. We should come to its defense. To leave this rather in the air, that we will defend it under some conditions but not under other, I think is a mistake. Secondly, I would not suggest the withdrawal at the point of the Communist gun. It is a decision finally that the Nationalists should make and I believe that we should consult with them and attempt to work out a plan by which the line is drawn at the island of Formosa. It leaves a hundred miles between the sea. But with General Ridgway, Mr. Herter, General Collins, Admiral Spruance and many others, I think it's unwise to take the chance of being dragged into a war which may lead to a world war over two islands which are not strategically defensible, which are not, according to their testimony, essential to the defense of Formosa. I think that uh - we should protect our commitments. I believe strongly we should do so in Berlin. I believe strongly we should d- do so in Formosa and I believe we should meet our commitments to every country whose security we've guaranteed. But I do not believe that that line in case of war should be drawn on those islands but instead on the island of Formosa. And as long as they are not essential to the defense of Formosa, it's been my judgment ever since 1954, at the time of the Eisenhower Doctrine for the Far East, that our line should be drawn in the sea around the island itself. MR. McGEE: Mr. Vice President. MR. NIXON: I disagree completely with Senator Kennedy on this point. I remember in the period immediately before the Korean War, South Korea was supposed to be indefensible as well. Generals testified to that. And Secretary Acheson made a very famous speech at the Press Club, early in the year that k- Korean War started, indicating in effect that South Korea was beyond the defense zone of the United States. I suppose it was hoped when he made that speech that we wouldn't get into a war. But it didn't mean that. We had to go in when they came in. Now I think as far as Quemoy and Matsu are concerned, that the question is not these two little pieces of real estate - they are unimportant. It isn't the few people who live on them - they are not too important. It's the principle involved. These two islands are in the area of freedom. The Nationalists have these two islands. We should not uh - force our Nationalist allies to get off of them and give them to the Communists. If we do that we start a chain reaction; because the Communists aren't after Quemoy and Matsu, they're a- they're after Formosa. In my opinion this is the same kind of woolly thinking that led to disaster for America in Korea. I am against it. I would never tolerate it as president of the United States, and I will hope that Senator Kennedy will change his mind if he should be elected. MR. McGEE: Gentlemen, we have approximately four minutes remaining. May I ask you to make your questions and answers as brief as possible consistent with clarity. And Mr. Levy has a question for Vice President Nixon. MR. LEVY: Mr. Vice President, you are urging voters to forget party labels and vote for the man. Senator Kennedy says that in doing this you are trying to run away from your party on such issues as housing and aid to education by advocating what he calls a me-too program. Why do you say that party labels are not important? MR. NIXON; Because that's the way we elect a president in this country, and it's the way we should. I'm a student of history as is Senator Kennedy, incidentally; and I have found that in the history of this country we've had many great presidents. Some of them have been Democrats and some of them have been Republicans. The people, some way, have always understood that at a particular time a certain man was the one the country needed. Now, I believe that in an election when we are trying to determine who should lead the free world - not just America - perhaps, as Senator Kennedy has already indicated, the most important election in our history - it isn't the label that he wears or that I wear that counts. It's what we are. It's our whole lives. It's what we stand for. It's what we believe. And consequently, I don't think it's enough to go before Republican audiences - and I never do - and say, "Look, vote for me because I'm a Republican." I don't think it's enough for Senator Kennedy to go before the audiences on the Democratic side and say, "Vote for me because I'm a Democrat." That isn't enough. What's involved here is the question of leadership for the whole free world. Now that means the best leadership. It may be Republican, it may be Democratic. But the people are the ones that determine it. The people have to make up their minds. And I believe the people, therefore, should be asked to make up their minds not simply on the basis of, "Vote the way your grandfather did; vote the way your mother did." I think the people should put America first, rather than party first. Now, as far as running away from my party is concerned, Senator Kennedy has said that we have no compassion for the poor, that we are against progress - the enemies of progress, is the term that he's used, and the like. All that I can say is this: we do have programs in all of these fields - education, housing, defense - that will move America forward. They will move her forward faster, and they will move her more surely than in his program. This is what I deeply believe. I'm sure he believes just as deeply that his will move that way. I suggest, however, that in the interest of fairness that he could give me the benefit of also believing as he believes. MR. McGEE: Senator Kennedy. MR. KENNEDY: Well, let me say I do think that parties are important in that they tell something about the program and something about the man. Abraham Lincoln was a great president of all the people; but he was selected by his party at a key time in history because his party stood for something. The Democratic party in this century has stood for something. It has stood for progress; it has stood for concern for the people's welfare. It has stood for a strong foreign policy and a strong national defense, and as a result, produced Wilson, President Roosevelt, and President Truman. The Republican party has produced McKinley and Harding, Coolidge, Dewey, and Landon. They do stand for something. They stand for a whole different approach to the problems facing this country at home and abroad. That's the importance of party; only if it tells something about the record. And the Republicans in recent years - not only in the last twenty-five years, but in the last eight years - have opposed housing, opposed care for the aged, opposed federal aid to education, opposed minimum wage and I think that record tells something. MR. McGEE: Thank you gentlemen. Neither the questions from the reporters nor the answers you heard from Senator John Kennedy or Vice President Richard Nixon were rehearsed. By agreement neither candidate made an opening statement or a closing summation. They further agreed that the clock alone would decide who would speak last and each has asked me to express his thanks to the networks and their affiliated stations. Another program similar to this one will be presented Thursday, October thirteenth, and the final program will be presented Friday, October twenty-first. We hope this series of radio and television programs will help you toward a fuller understanding of the issues facing our country today and that on election day, November eighth, you will vote for the candidate of your choice. This is Frank McGee. Good night from Washington.
