# Presidential Debate in Hartford

**Date:** October 6, 1996
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-hartford

---

Jim Lehrer. Good evening from the Bushnell Theater in Hartford, Connecticut. I'm Jim Lehrer, of the "NewsHour" on PBS. Welcome to the first of the 1996 Presidential debates between President Bill Clinton, the Democratic nominee, and Senator Bob Dole, the Republican nominee. This event is sponsored by the Commission on Presidential Debates. It will last 90 minutes, following a format and rules worked out by the two campaigns. There will be 2-minute opening and closing statements; in between, a series of questions, each having three parts: a 90-second answer, a 60-second rebuttal, and a 30-second response. I will assist the candidates in adhering to those time limits, with the help of a series of lights visible to both. Under their rules, the candidates are not allowed to question each other directly. I will ask the questions. There are no limitations on the subjects. The order for everything tonight was determined by coin toss. Now to the opening statements and to President Clinton. Mr. President. Opening Statements The President. Thank you, Jim, and thank you to the people of Hartford, our hosts. I want to begin by saying again how much I respect Senator Dole and his record of public service, and how hard I will try to make this campaign and this debate one of ideas, not insults. Four years ago I ran for President at a time of high unemployment and rising frustration. I wanted to turn this country around with a program of opportunity for all, responsibility from all, and an American community where everybody has a role to play. I wanted a Government that was smaller and less bureaucratic to help people have the tools to make the most of their own lives. Four years ago you took me on faith. Now there's a record: 10 1/2 million more jobs, rising incomes, falling crime rates and welfare rolls, a strong America at peace. We are better off than we were 4 years ago. Let's keep it going. We cut the deficit by 60 percent. Now let's balance the budget and protect Medicare, Medicaid, education, and the environment. We cut taxes for 15 million working Americans. Now let's pass the tax cuts for education and childrearing, help with medical emergencies, and buying a home. We passed family and medical leave. Now let's expand it so more people can succeed as parents and in the work force. We passed the 100,000 police, the assault weapons ban, the Brady bill. Now let's keep going by finishing the work of putting the police on the street and tackling juvenile gangs. We passed welfare reform. Now let's move a million people from welfare to work. And most important, let's make education our highest priority so that every 8-year-old will be able to read, every 12-year-old can log on to the Internet, every 18-year-old can go to college. We can build that bridge to the 21st century, and I look forward to discussing exactly how we're going to do it. Mr. Lehrer. Senator Dole, 2 minutes. Senator Bob Dole. Thank you. Thank you, Mr. President, for those kind words. And I thank the people of Hartford, the commission, and all those out here who may be listening or watching. It's a great honor for me to be here, standing here as the Republican nominee. I'm very proud to be the Republican nominee, reaching out to Democrats and independents. I have three very special people with me: my wife, Elizabeth, my daughter, Robin, who have never let me down; and a fellow named Frank Carafa from New York, who along with Ollie Manninen helped me out in the mountains of Italy a few years back. I've learned from them that people do have tough times and sometimes you can't go it alone. And that's what America's all about. I remember getting my future back from doctors and nurses and a doctor in Chicago named Dr. Kelikian, and ever since that time I've tried to give something back to my country, to the people who are watching us tonight. America is the greatest place on the face of the Earth. And I know millions of you still have anxieties. You work harder and harder to make ends meet and put food on the table. You worry about the quality and the safety of your children and the quality of education. But even more importantly, you worry about the future and will they have the same opportunities that you and I have had. And Jack Kemp and I want to share with you some ideas tonight. Jack Kemp is my running mate, doing an outstanding job. Now, I'm a plain-speaking man, and I learned long ago that your word was your bond. And I promise you tonight that I'll try to address your concerns and not try to exploit them. It's a tall order, but I've been running against the odds for a long time. And again, I'm honored to be here this evening. Federal Government's Role Mr. Lehrer. Mr. President, first question: There's a major difference in your view of the role of the Federal Government and that of Senator Dole. How would you define the difference? The President. Well, Jim, I believe that the Federal Government should give people the tools and try to establish the conditions in which they can make the most of their own lives. That, to me, is the key. And that leads me to some different conclusions from Senator Dole. For example, we have reduced the size of the Federal Government to its smallest size in 30 years. We've reduced more regulations, eliminated more programs than my two Republican predecessors. But I have worked hard for things like the family and medical leave law, the Brady bill, the assault weapons ban, the program to put 100,000 police on the street. All of these are programs that Senator Dole opposed, that I supported because I felt they were a legitimate effort to help people make the most of their own lives. I've worked hard to help families impart values to their own children. I supported the Vchip so that parents would be able to control what their kids watch on television when they're young, along with the ratings system for television and educational television. I supported strong action against the tobacco companies to stop the marketing, advertising, and sale of tobacco to young people. I supported a big increase in the safe and drug-free schools program. These were areas on which Senator Dole and I differed, but I believed that they were the right areas for America to be acting together as one country to help individuals and families make the most of their own lives and raise their kids with good values and a good future. Mr. Lehrer. Senator Dole, one minute. Senator Dole. I think the basic difference is— and I have had some experience in this—I think the basic difference—I trust the people; the President trusts the Government. If you go back and look at the health care plan that he wanted to impose on the American people—one-seventh the total economy, 17 new taxes, price controls, 35 to 50 new bureaucracies, a cost of $1.5 trillion. Don't forget that; that happened in 1993. A tax increase that taxed everybody in America, not just the rich. If you made $25,000—that's the original proposal—you got your Social Security taxes increased. We had a BTU tax that turned into a $35 billion gas tax, a $265 billion tax increase. I guess I rely more on the individual. I carry a little card around in my pocket called the 10th amendment. Where possible, I want to give power back to the States and back to the people. That's my difference for the present, and we'll have specific differences later. He noted a few, but there are others. Mr. Lehrer. Mr. President, 30 seconds. The President. I trust the people. We've done a lot to give the people more powers to make their own decisions over their own lives. But I do think we are right when we try to, for example, give mothers and newborns 48 hours before they can be kicked out of the hospital, ending these drive-by deliveries. I think we were right to pass the Kassebaum-Kennedy bill, which states you can't lose your health insurance just because you change jobs or because someone in your family has been sick. Our Government is smaller and less bureaucratic and has given more authority to the States than its two predecessors under Republican Presidents. But I do believe we have to help our people get ready to succeed in the 21st century. State of the Nation Mr. Lehrer. Senator Dole, the President said in his opening statement, we are better off today than we were 4 years ago. Do you agree? Senator Dole. Well, he's better off than he was 4 years ago. [Laughter] The President. I agree with that. That's right. Senator Dole. And I may be better off 4 years from now. But—[laughter]—I don't know, I look at the slowest growth in a century. He inherited a growth of 4.7, 4.8 percent; now it's down to about 2.4 percent. We're going to pass a million bankruptcies this year for the first time in history. We've got stagnant wages; in fact, women's wages have dropped 2.2 percent. Men's wages haven't gone up, gone down. So we have stagnation. We have the highest foreign debt in history. And it seems to me that if you take a look— are you better off? Well, I guess some may be better off. Saddam Hussein is probably better off than he was 4 years ago. Rene Preval is probably better off than he was 4 years ago. But are the American people? They're working harder and harder and paying more taxes. For the first time in history, you pay about 40 percent of what you earn, more than you spend for food, clothing, and shelter combined, for taxes under this administration. So some may be better off. They talk about family income being up. That's not true in Connecticut; family income is down. And it's up in some cases because both parents are working; one works for the family, and one works to pay taxes for the Government. We're going to give them a tax cut so they can spend more time with their children, maybe even take a vacation. That's what America is all about. Mr. Lehrer. Mr. President, one minute. The President. Well, let me say, first of all, in February, Senator Dole acknowledged that the American economy was in the best shape it's been in in 30 years. We have 10 1/2 million more jobs, a faster job growth rate than under any Republican administration since the 1920's. Wages are going up for the first time in a decade. We have record number of new small businesses. We had the biggest drop in the number of people in poverty in 27 years. All groups of people are growing—we had the biggest drop in income inequality in 27 years in 1995. The average family's income has gone up over $1,600 just since our economic plan passed. So I think it's clear that we're better off than we were 4 years ago. Now we need to focus on, what do we need to do to be better off still? How can we help people—as we are— to get their retirements when they work for small businesses, to be able to afford health insurance, to be able to educate their children? That's what I want to focus on. But we're clearly better off than we were 4 years ago, as Senator Dole acknowledged this year. Mr. Lehrer. Senator Dole? Senator Dole. I doubt that I acknowledged that this year, but in any event, I think we just look at the facts. We ask the people that are viewing tonight, "Are you better off than you were 4 years ago?" It's not whether we're better off; it's whether they're better off. Are you working harder to put food on the table, to feed your children? Are your children getting a better education? Drug use has doubled the past 44 months all across America. Crime has gone down, but it's because of mayors like Rudy Giuliani, where one-third of the drop happened in one city, New York City. So, yes, some may be better off. But of the people listening tonight, the working families who will benefit from our economic package, they'll be better off when Bob Dole is President and Jack Kemp is Vice President. Medicare Reform Mr. Lehrer. Mr. President, Senator Dole has come pretty close in the last few days to accusing you of lying about his position on Medicare reform. Have you done so? The President. Absolutely not. Let's look at the position. First of all, remember that in this campaign season, since Senator Dole has been a candidate, he has bragged about the fact that he voted against Medicare in the beginning, in 1965, one of only 12 Members. He said he did the right thing then; he knew it wouldn't work at the time. That's what he said. Then his budget, that he passed along with Speaker Gingrich, cut Medicare $270 billion, more than was necessary to repair the Medicare Trust Fund. It would have charged seniors more for out-of-pocket costs, as well as more in premiums, because doctors could have charged them more. The American Hospital Association, the nurses association, the Catholic Hospital Association all said hundreds of hospitals could close and people would be hurt badly under the Dole-Gingrich Medicare plan that I vetoed. And now, with this risky $550 billion tax scheme of Senator Dole's, even his own friends—his campaign cochair, Senator D'Amato, says that they can't possibly pay for it without cutting Medicare more and cutting Social Security as well, according to him. Now, my balanced budget plan adds 10 years to the life of the Medicare Trust Fund—10 years. And we'll have time to deal with the long-term problems of the baby boomers. But it was simply wrong to finance their last scheme to cut Medicare $270 billion, to run the risk of it withering on the vine. We always have to reform it over the years, but we need someone who believes in it to reform it. Mr. Lehrer. Senator Dole. Senator Dole. Well, I must say I looked back at the vote on Medicare in 1965—we had a program called Eldercare that also provided drugs and was means-tested so people who needed medical attention received it. I thought it was a good program. But I have supported Medicare ever since. In fact, I used to go home and my mother would tell me—said, "Bob, all I've got is my Social Security and my Medicare. Don't cut it." I wouldn't violate anything my mother said. In fact, we had a conversation about our mothers one day, a very poignant conversation in the White House. I'm concerned about health care. I've had the best health care in Government hospitals, Army hospitals, and I know its importance. But we've got to fix it. It's his trustees, the President's trustees, not mine, who say it's going to go broke. He doesn't fix it for 10 years. We ought to appoint a commission, just as we did with Social Security in 1983 when we rescued Social Security. And I was proud to be on that commission, along with Claude Pepper, the champion of senior citizens from Florida. And we can do it again if we take politics out of it. Stop scaring the seniors, Mr. President. You've already spent $45 million scaring seniors and tearing me apart. I think it's time to have a truce. Mr. Lehrer. Mr. President. The President. Well, let me say first of all, I'd be happy to have a commission deal with this, and I appreciate what Senator Dole did on the '83 Social Security commission. But it won't be possible to do if his tax scheme passes, because even his own campaign cochair, Senator D'Amato, says he'll have to cut Medicare even more than was cut in the bill that I vetoed. I vetoed that bill because it cut more Medicare and basically ran the risk of breaking up the system. My balanced budget plan puts 10 years onto Medicare. We ought to do that; then we can have a commission. But Senator Dole's plans are not good for the country. Senator Dole's Tax Cut Proposal Mr. Lehrer. Senator Dole, speaking of your tax plan, do you still think that's a good idea, the 15 percent across-the-board tax cut? Senator Dole. Oh, yes, and you'll be eligible. [Laughter] The President. Me too? Senator Dole. And so will the former President, yes. [Laughter] The President. That's good. I need it. Senator Dole. Well, the people need it; that's the point. This is not a Wall Street tax cut. This is a family tax cut. This is a Main Street tax cut. Fifteen percent across—let's take a family making $30,000 a year—that's $1,261. Now, maybe to some in this Bushnell Memorial that's not a lot of money, but people watching tonight with a couple of kids, a working family—that's 4 or 5 months of day care, maybe a personal computer; it may be 3 or 4 months of mortgage payments. This economic package is about families, but it's a six-point package. First of all, it's a balanced budget amendment to the Constitution, which President Clinton defeated. He twisted arms and got six Democrats to vote the other way. We lost by one vote. It's balancing the budget by the year 2002. It's the tax cut, cutting capital gains 50 percent, so that you can go out and create more jobs and more opportunities. It's estate tax relief. It's a $500-per-child tax credit. It's about litigation reform. Now that the President gets millions of dollars from the trial lawyers, he probably doesn't like this provision. In fact, when I fell off that podium in Chico, before I hit the ground I had a call on my cell phone from a trial lawyer saying, "I think we've got a case here." [Laughter] And it's also regulatory reform. So it's a good package, Mr. President, and we'd like to have your support. Mr. Lehrer. Mr. President. The President. Well, here's the problem with it. It sounds very good, but there's a reason that 500 economists, including 7 Nobel Prize winners, and business periodicals like Business Week and even Senator Dole's friend Senator Warren Rudman, former Republican Senator from New Hampshire, says it is not a practical program. It's a $550 billion tax scheme that will cause a big hole in the deficit, which will raise interest rates and slow down the economy and cause people to pay more for home mortgages, car payments, credit card payments, college loans, and small business loans. It's not good to raise the deficit; we've worked too hard to lower it. It will actually raise taxes on 9 million people. And in addition to that, it will force bigger cuts in Medicare, Medicaid, education, and the environment than the ones that he and Mr. Gingrich passed that I vetoed last year. So it sounds great. But our targeted tax cut for education, childrearing, health care, and homebuying, which is paid for in my balanced budget plan—something that he has not done— certified by the Congressional Budget Office, that's the right way to go. Mr. Lehrer. Senator Dole. Senator Dole. The President wants to increase spending 20 percent over the next 6 years. I want to increase spending 14 percent. That's how simple it is. I want the Government to pinch pennies for a change, instead of the American families. We're talking about 6 percentage points over 6 years. And with that money, you give it back to the working people. You also provide opportunity scholarships so low-income parents will have the same choice that others have in sending their children to better schools. And it will work. And when it does work, Mr. President, I know you will congratulate me. Campaign Financing Mr. Lehrer. Mr. President, the Senator mentioned trial lawyers, and that means campaign financing. How do you personally avoid being unduly influenced by people who give you money or give you services in your campaigns? The President. Well, I try to articulate my positions as clearly as possible, tell people what I stand for, and let them decide whether they're going to support me or not. The Senator mentioned the trial lawyers. In the case of the product liability bill, which they passed and I vetoed—I think that's what he's talking about— I actually wanted to sign that bill, and I told the people exactly what—the Congress—exactly what kind of bill I would sign. Now, a lot of the trial lawyers didn't want me to sign any bill at all, but I thought we ought to do what we could to cut frivolous lawsuits. But they wouldn't make some of the changes that I thought should be made. And let me just give you an example. I had a person in the Oval Office who lost a child in a schoolbus accident where a drunk driver caused the accident directly, but there were problems with the schoolbus. The drunk driver had no money. Under the new bill, if I had signed it, a person like that could never have had any recovery. I thought that was wrong. So I gave four or five specific examples to the Congress, and I said, "Prove to me that these people could recover, but we're going to eliminate frivolous lawsuits; I'll sign the bill." But generally, I believe that a President has to be willing to do what he thinks is right. I've done a lot of things that were controversial: my economic plan, my trade position, Bosnia, Haiti, taking on the NRA for the first time, taking on the tobacco companies for the first time. Sometimes you just have to do that because you know it's right for the country over the long run. That's what I've tried to do, and that's what I will continue to do as President. Mr. Lehrer. Senator Dole? Senator Dole. You mean, how does he avoid the conflict? Well, I don't know in the case of the trial lawyers. When I look at the trial lawyers, and when you're a few million short you run out to Hollywood and pick up $2 million to $4 million, and organized labor comes to Washington, DC, and puts $35 million into the pot—now, if these aren't special interests, then I've got a lot to learn. I was there for a while before I left on June 11th. The trial lawyers—I don't—my wife is a lawyer. We're the only two lawyers in Washington that trust each other, but we're lawyers. I like lawyers. I don't dislike trial lawyers. But it seems to me there has got to be some end to the frivolous lawsuits, and there's got to be some cap on punitive damage. You're putting a lot of business people out of business, small-business men and small-business women who paid 70 percent of your $265 billion tax increase, the largest tax increase in the history of America. I said that one day, and Pat Moynihan—and the Democrats say no—he said, "in the history of the world." So I modified it—the largest tax increase in the history of the world. And it seems to me that there is a problem there, Mr. President. And I will address you as Mr. President. You didn't do that with President Bush in 1992. Mr. Lehrer. Mr. President. The President. Let me say, first of all, I signed a tort reform bill that dealt with civilian aviation a couple of years ago. I've proved that I will sign reasonable tort reform. Secondly, Senator Dole has had some pretty harsh comments about special interest money, but it wasn't me who opposed what we tried to do to save the lives of children who are subject to tobacco and then went to the tobacco growers and bragged about standing up to the Federal Government when we tried to stop the advertising, marketing, and sales of tobacco to children. And it wasn't me that let the polluters actually come into the Halls of Congress, into the rooms, and rewrite the environmental laws. That's what Speaker Gingrich and Senator Dole did, not me. Senator Dole. That's not true. The President. So I believe that we should take a different approach to this and talk about how we stand on the issues instead of trying to characterize each other's motivations. I think Senator Dole and I just honestly disagree. Mr. Lehrer. Well, Senator Dole, let me ask you the same question I asked the President: How do you avoid being influenced by people who contribute money and services to your campaigns? Senator Dole. I think it's very difficult. Let's be honest about it. That's why we need campaign finance reform. That's why I reach out to the Perot voters, and we've done about all that—we are the reform party, the Republican Party, and the Perot voters who are looking for a home ought to take a look at the Republican record. Whatever it is, whatever the checklist was in '92, it's all done but campaign finance reform. I worked with Senator Mitchell, who played me, I guess, in the debate warmup. We tried 6 or 8 years ago to—he appointed three people, I appointed three people—to get campaign finance reform. We couldn't get it done because it wasn't enforceable. You suggested a commission; Newt Gingrich did. I've suggested that, at least 4 or 5 years ago, we have a commission on campaign finance reform, they send it to Congress, and we have to vote it up or down. That's how it works. We're never going to fix it by the parties, because Democrats want a better advantage for themselves, we want a better advantage as Republicans, and that's not how it's going to work. But I want to touch on this tobacco thing. I know the President's been puffing a lot on that. But I want to go back to 1965. That was my first vote against tobacco companies when I said we ought to label cigarettes, and I've had a consistent record ever since 1965. We passed a bill in 1992 to encourage the States to adopt programs to stop kids from smoking. All 50 States did it. It took 3 1/2 years. It wasn't until election year, Mr. President, that you ever thought about stopping smoking. What about drugs that have increased—doubled in the last 44 months? Cocaine is up 141 percent—or marijuana; cocaine up 166 percent. And it seems to me that you have a selective memory. Mine doesn't work that way, so I just want to try to correct it as we go along. Mr. Lehrer. Mr. President. The President. Mr. Lehrer, I hope we'll have a chance to discuss drugs later in the program, but let me respond to what you said. I agree that too many incumbent politicians in Washington in both parties have consistently opposed campaign finance reform. That was certainly the case from the minute I got there. So after Speaker Gingrich and Senator Dole took over the Congress, I went to New Hampshire and a man suggested—a gentleman that, unfortunately, just passed away a couple of days ago suggested that we appoint a commission. And I shook hands with him on it, and I appointed my members, and the commission never met. And then Senator Dole's ardent supporter Senator McCain, who is out there today, along with Senator Feingold, supported—sponsored a campaign finance reform proposal. I strongly supported it, and members of Senator Dole's own party in the Senate killed it. And he was not out there urging them to vote for the McCain-Feingold bill. So I think the American people, including the Perot supporters, know that I've had a consistent record in favor of campaign finance reform, and I will continue to have. And I hope we can finally get it in the next session of Congress, because we need it badly. Mr. Lehrer. Senator Dole, 30 seconds. Senator Dole. Well, on campaign reform itself we're going to get it when we have a bipartisan commission, take it out of politics, get people who don't have any interest in politics but understand the issue, and let them make a recommendation to Congress. Now, we're not kidding anybody, Mr. President. These are sophisticated people watching tonight, millions and millions of Americans. They know the Republican Party hasn't done it. They know the Democratic Party won't do it. We ought to agree that somebody else should do it, and then we have to vote it up or down. The President. I agree. Teenage Drug Use Mr. Lehrer. Mr. President, the Senator mentioned drugs. He's suggested in the past that you bear some responsibility for the rise in drug use of teenagers in the United States. Is he right? The President. Well, Jim, I think every American in any position of responsibility should be concerned about what's happened. I am. But let's look at the overall record. Overall in America, cocaine use has dropped 30 percent in the last 4 years, casual drug use down 13 percent. The tragedy is that our young people are still increasing their use of drugs, up to about 11 percent total with marijuana. And I regret it. Let me tell you what I've tried to do about it. I appointed a four-star general, who led our efforts south of the border to keep drugs from coming into the country, as our Nation's drug czar—the most heavily decorated soldier in uniform when he retired. We submitted the biggest drug budget ever. We have dramatically increased control and enforcement at the border. We supported a crime bill that had 60 death penalties, including the death penalty for drug kingpins. And I supported a big expansion in the safe and drug-free schools program to support things like the D.A.R.E. program, because I thought all those things were very important. Do I think that I bear some responsibility for the fact that too many of our children still don't understand drugs are wrong, drugs can kill you, even though I have consistently opposed the legalization of drugs all my public life and worked hard against them? I think we all do. And I hope we can do better. I don't think this issue should be politicized, because my record is clear and I don't think Senator Dole supports using drugs. I think we just have to continue to work on this until those who think it isn't dangerous and won't kill them and won't destroy their lives get the message and change. Mr. Lehrer. Senator. Senator Dole. Again, you're very selective, Mr. President. You don't want to politicize drugs, but it's all right to politicize Medicare and go out and scare senior citizens and other vulnerable groups, veterans and people who get Pell grants and things like this. I mean, you say we have done all these bad things, which isn't the case. But it seems to me the record is clear. The record was pretty clear in Arkansas when you were Governor: Drug use doubled. You resisted the appointment of a drug czar there because you thought it might interfere with treatment. But here you cut the drug czar's office 83 percent. You have cut interdiction substantially. That's what—I want to stop it from coming across the border. And in my administration we're going to train the National Guard to stop it from coming across the border. This is an invasion of drugs from all over the world. And we have a responsibility. You had a Surgeon—or before General McCaffrey, you had a lady who said we ought to consider legalizing drugs. Is that the kind of leadership we need? And I won't comment on other things that have happened in your administration or your past about drugs. But it seems to me the kids ought to—if they have started they ought to stop, and just don't do it. Mr. Lehrer. Mr. President. The President. Let me say again, we did have a drug czar in Arkansas, but he answered to the Governor, just like this one answers to the President. That's what I thought we ought to do. Secondly, Senator Dole, you voted against the crime bill that had the death penalty for drug kingpins in it, and you voted to cut services to 23 million school children under the safe and drug-free schools act. I don't think that means you're soft on drugs. We just have a different approach. But let me remind you that my family has suffered from drug abuse. I know what it's like to see somebody you love nearly lose their lives, and I hate drugs, Senator. We need to do this together, and we can. Gun Control Mr. Lehrer. Senator Dole, on the Government—continuing to talk about the Government's role—if elected President, would you seek to repeal the Brady bill and the ban on assault weapons? Senator Dole. Not if I didn't have a better idea, but I've got a better idea. It's something I've worked on for 15 years. It's called the automated check or the instant check. It's being used in 17 States right now, States like Florida, Colorado, Virginia, and other States. You don't buy any gun—you don't get any gun. We've got 20 million names on a computer in Washington, DC, of people who should not have a gun. We ought to keep guns out of the hands of criminals, and there are eight other categories that should not have guns. I've been working on this for a long, long time. You walk in, you put your little card in there. If it says "tilt," you don't get any gun. You don't get a handgun; you don't get a rifle; you don't get a shotgun. You get zippo. If we're going to protect American children and American families and people who live as prisoners in their own home, we've got to stop guns from being dumped on the street. The administration says they support the instant check. They've appropriated about $200 million but only spent about $3 million to get it underway. In our administration, in my administration, we will expedite this. It keeps up the technology. It keeps guns out of the hands of people who should not have guns. That is the bottom line. And I believe it's a good idea. It has strong bipartisan support, and perhaps that's another thing we can depoliticize. You talk about the Brady bill. There's only been one prosecution under the Brady bill— only one under the assault weapon ban and only seven under the Brady bill that you talk about all the time. And on the assault weapons ban, out of 17 weapons that were banned, only 6 are banned now because 11 have been modified and they're back on the street. Let's get together on this instant check, because that will really make a difference. Mr. Lehrer. Mr. President. The President. Let me say, first of all, Senator Dole has gone back and forth about whether he'd be for repealing the Brady bill or repealing the assault weapons ban, and I think his present position is that he would not do so. And if that's true, I'm grateful for it. But let's look at the facts here. The Brady bill has kept at least 60,000 felons, fugitives, and stalkers from getting handguns. Senator Dole led the fight against the Brady bill. He tried to keep it from coming to my desk. He didn't succeed, and I signed it, and I'm glad I did. Then when we had the assault weapons ban in the Senate, Senator Dole fought it bitterly and opposed the entire crime bill and almost brought the entire crime bill down because the National Rifle Association didn't want the assault weapons ban, just like they didn't want the Brady bill. But 2 years later, nobody has lost their handguns—I mean, their rifles. We've expanded the Brady bill to cover people who beat up their spouses and their kids. And this is a safer country. So I'm glad I took on that fight. And I believe, with all respect, I was right, and he was wrong. Senator Dole. Well, the President doesn't have it quite right. I mean, it seemed to me at the time that the assault weapon ban was not effective. But that's history. As I told the NRA, that's history: You're not going to worry about it anymore; I'm not going to worry about it anymore. Let's do something better. Let's stop playing the political game, Mr. President, talking about this and this. You add up all the States who have used the instant check and how many weapons they've kept out of the hands of criminals, it would far surpass the number you mentioned. So in my view, if you want to be protected, you ought to vote for Bob Dole, and we'll get the instant check passed, and we'll keep guns out of the hands of criminals. Foreign Policy Mr. Lehrer. Mr. President, Senator Dole said the other day that you practiced a photo-op foreign policy that has lessened the credibility of the United States throughout the world. Is he wrong about that? The President. If that's what he said, he's not right about that. Look at where we are today. The United States is still the indispensable nation in the aftermath of the cold war and on the brink of the 21st century. I have worked to support our country as the world's strongest force for peace and freedom, prosperity and security. We have done the following things: Number one, we've managed the aftermath of the cold war, supporting a big drop in nuclear weapons in Russia, the removal of Russian troops from the Baltics, the integration of Central and Eastern European democracies into a new partnership with NATO and, I might add, with a democratic Russia. There are no nuclear missiles pointed at the children of the United States tonight and have not been in our administration for the first time since the dawn of the nuclear age. We have worked hard for peace and freedom. When I took office, Haiti was governed by a dictator that had defied the United States. When I took office, the worst war in Europe was waging in Bosnia. Now there is a democratically elected President in Haiti, peace in Bosnia. We have just had elections there. We have made progress in Northern Ireland and the Middle East. We've also stood up to the new threats of terrorism, the proliferation of weapons of mass destruction, organized crime. And we have worked hard to expand America's economic presence around the world with the biggest increase in trade, with the largest number of new trade agreements in history. That's one of the reasons America is number one in auto production again. Mr. Lehrer. Senator. Senator Dole. Well, I have a different view again. I've supported the President on Bosnia. And I think we were told the troops would be out in a year. Now I understand it's been extended till sometime next year. But let's start with Somalia, where they dragged Americans through the streets and where 18 Americans were killed one day because they didn't have—they were pinned down for 8 hours, the Rangers; they didn't have the weapons; they didn't have the tanks. They asked for the tanks. They didn't get the tanks from this administration, because we were nation building. It's called mission creep. We turned it over to the United Nations. The President didn't have much to do about it. Look at Haiti, where we've spent about $3 billion, and we got an alarm call there about 2 weeks ago: "You've got to send down some more people because the President has found out there are death squads on his own property, so we need more protection from America." Bosnia, Northern Ireland—there is no ceasefire in Bosnia. I think there are still lots of problems in Bosnia. We agreed to train and arm the Muslims so they could defend themselves—the policy you had when you ran in 1992. We haven't done that. We're way behind, which means Americans can't come home. Americans shouldn't have gone there in the first place, had we let them defend themselves as they have a right to do under Article 57 of the United Nations Charter. Mr. Lehrer. Mr. President. The President. First of all, I take full responsibility for what happened in Somalia, but the American people must remember that those soldiers were under an American commander when that happened. I believe they did the best they could under the circumstances. And let's not forget that hundreds of thousands of lives were saved there. Secondly, in Haiti, political violence is much, much smaller than it was. Thirdly, in Bosnia, it's a virtual miracle that there has been no return to war. And at least there has now been an election, and the institutions are beginning to function. In Northern Ireland and the Middle East, we are better off than we were 4 years ago. There will always be problems in this old world, but if we're moving in the right direction and America is leading, we're better off. Mr. Lehrer. Senator Dole, if elected President, what criteria would you use to decide when to send U.S. troops into harm's way? Senator Dole. Well, after World War I we had a policy of disengagement. Then from World War I to World War II we had sort of a compulsory engagement policy. Now, I think we have to have a selective engagement policy. We have to determine when our interests are involved, not the United Nations' interests. And many of the things the President talked about he turned over to the United Nations; they decided. He's deployed more troops than any President in history around the world. It's cost us billions and billions of dollars for peacekeeping operations. These are facts. And it seems to me that when you make a decision, the decision is made by the President of the United States, by the Commander in Chief. He makes that decision when he commits young men or young women who are going to go around and defend our liberty and our freedom. That would be my position. Then I'm going to have a top-down review at the Pentagon, not a bottom-up review where you all fight over how much money is there. I want a top-down review to determine what our priorities are and what we should do in defense and then follow that policy, instead of this bottom-up review with all of the services fighting for the money. The President said he was going to cut defense $60 billion; he cut defense $112 billion, devastated States like California and others. And I think now we've got a problem. We've got to go back and look. It's just like you said in Texas one day, you know, you raised taxes too much—and you did—and you cut defense too much, Mr. President—and you did—and you may have said that, too. But the bottom line is, we are the strongest nation in the world, we provide the leadership, and we're going to have to continue to provide the leadership. But let's do it on our terms when our interests are involved and not when somebody blows a whistle at the United Nations. The President. Our military is the strongest military in the world. It is the strongest, best prepared, best equipped it has ever been. There is very little difference in the budget that I have proposed and the Republican budget over the next 6-year period. We are spending a lot of money to modernize our weapons system. I have proposed a lot of new investments to improve the quality of life for our soldiers, for our men and women in uniform, for their families, for their training. That is my solemn obligation. You asked, when do you decide to deploy them? The interests of the American people must be at stake; our values must be at stake; we have to be able to make a difference. And frankly, we have to consider what the risks are to our young men and women in uniform. But I believe the evidence is that our deployments have been successful in Haiti, in Bosnia, when we moved to Kuwait to repel Saddam Hussein's threatened invasion of Kuwait, when I have sent the fleet into the Taiwan Straits, when we've worked hard to end the North Korean nuclear threat. I believe the United States is at peace tonight in part because of the disciplined, careful, effective deployment of our military resources. Mr. Lehrer. Senator Dole. Senator Dole. Well, I failed to mention North Korea and Cuba a while ago. You look at North Korea, where they have enough plutonium to build six nuclear bombs, where we've sort of distanced ourselves from our ally, South Korea. They lost about a million people in the war, the Korean war, the forgotten war. We lost 53,000 Americans. We shouldn't be doing any favors for North Korea. It's a closed society. We don't have any inspection. We don't know whether it's going to work or not. But we keep giving them these incentives—some would call them something else—incentives. We don't know what's going to happen. Here we have Cuba, 90 miles from our shores. And what have we done? We've passed a law that gave people the right to sue, and the President postponed it for 6 months. And it seems to me if you want to send a signal you've got to send a signal, Mr. President. The sooner, the better off we'll be if we put tougher sanctions on Castro, not try to make it easier for him. Mr. Lehrer. Well, Mr. President, what is your attitude toward Cuba and how Cuba should be treated? The President. Well, first of all, for the last 4 years we have worked hard to put more and more pressure on the Castro government to bring about more openness and a move toward democracy. In 1992, before I became President, Congress passed the Cuba Democracy Act, and I enforced it vigorously. We made the embargo tougher, but we increased contacts, people to people, with the Cubans, including direct telephone service, which was largely supported by the Cuban-American community. Then Cuba shot down two of our planes and murdered four people in international airspace. They were completely beyond the pale of the law, and I signed the Helms-Burton legislation. Senator Dole is correct. I did give about 6 months before the effective date of the act before lawsuits can actually be filed, even though they're effective now and can be legally binding, because I want to change Cuba. And the United States needs help from other countries. Nobody in the world agrees with our policy on Cuba now. But this law can be used as leverage to get other countries to help us to move Cuba to democracy. Every single country in Latin America, Central America, and the Caribbean is a democracy tonight but Cuba. And if we stay firm and strong, we will be able to bring Cuba around as well. Senator Dole. Well, that's the point I made; we have to be firm and strong. And I hope that will happen. It will happen starting next January and maybe can happen the balance of this year. We have not been firm and strong. If you look at the poor people who still live in Cuba, it's a haven for drug smugglers, and we don't have a firm policy when it comes to Fidel Castro. In my view, the policy has failed. So Congress passes a law, the President signs it like he does a lot of things, but he—like welfare reform, "Well, I'm going to sign it, but I'm going to try to change it next year." I mean, a lot of these election-year conversions the President is talking about—all the drug money and all the other things, all this antismoking campaign—all happened in 1996. And I think the people viewing out there ought to go back and take a look at the record. When he fought a balanced budget amendment, when he gave you that biggest tax increase in history, when he tried to take over your health care system, when he fought regulatory reform that costs the average family $6,000 to $7,000 a year—this is serious business. It's about your family. It's about your business. And in this case, it's about a firmer policy with Cuba. The President. There were several off-the-subject whoppers in that litany. Let me just mention, Senator Dole voted for $900 billion in tax increases. His running mate, Jack Kemp, once said that Bob Dole never met a tax he didn't hike. [Laughter] And everybody knows, including the Wall Street Journal, hardly a friend of the Democratic Party or this administration, that the '82 tax increase he sponsored, in inflationadjusted dollars, was the biggest tax increase in American history. So we ought to at least get the facts out here on the table so we can know where to go from here. Health Care Reform Mr. Lehrer. Senator Dole, you mentioned health reform several times. What do you think should be done about the health care system? Senator Dole. Let me first answer that question about the 1982 tax cut. You know, we were closing loopholes; we were going after big corporations. I know you probably would oppose it, Mr. President, but I think we should have a fairer system and a flatter system. And we will have a fairer, flatter system, and we're going to make the economic package work. Health care: Well, we finally passed the Kassebaum bill. The President was opposed to it in 1993. He wanted to give us this big system that took over about one-seventh the economy, that put on price controls, created all these State alliances, and would cost $1.5 trillion and force people into managed care whether they wanted it or not. Most people want to see their own doctor. They're going to see their own doctor when Bob Dole is President. We won't threaten anybody. So we passed the Kassebaum-Kennedy bill; that will cover about 20 to 25 million people. We've been for that for 4, 5, or 6 years. The President held it up. And even when it finally got near passage, Senator Kennedy held it up for 100 days because he wasn't satisfied with one provision. But it will cover a preexisting condition. If you change your job you're going to be covered. So there are a lot of good things in this bill that we should have done instead of trying this massive, massive takeover by the Federal Government. But then, of course, you had a Democratic Congress, and they didn't want to do that. Until we got a Republican Congress—we finally got action, and I'm very proud of my colleagues in the Republican Party for getting that done. It means a lot to a lot of people watching us tonight. The President. Well, that sounds very good, but it's very wrong. Senator Dole remembers well that we actually offered not to even put in a health care bill in 1994—'93—but instead to work with the Senate Republicans and write a joint bill. And they said no, because they got a memo from one of their political advisers saying that instead they should characterize whatever we did as big Government and make sure nothing was done to aid health care before the '94 elections so they could make that claim. Well, maybe we bit off more than we could chew. But we're pursuing a step-by-step reform now. The Kennedy-Kassebaum bill that I signed will make it possible for 25 million people to keep their health insurance when they change jobs or when somebody in their family has been sick. I signed a bill to stop these drive-by deliveries where insurance companies can force people out of the hospital after 24 hours. And I vetoed Senator Dole's Medicare plan that would have forced a lot of seniors into managed care and taken a lot more money out of their pockets and led to Medicare withering on the vine. Mr. Lehrer. Senator. Senator Dole. Well, many of the provisions in the Kassebaum bill were provisions—my provisions, like deductions for long-term care, making certain that self-employed people who are watching tonight can deduct not 30 percent but 80 percent of what you pay for premiums; you can also deduct long-term care now. So it's a good start. I think—we're even looking at our tax cut proposal, our economic package. There may be a way there to reach out to the uninsured, because there are a lot of uninsured people in this country, particularly children, that should be covered. Another way you can do it is to expand Medicaid. In America, no one will go without health care, no one will go without food—— Mr. Lehrer. Senator—go ahead and finish your sentence, sorry. Senator Dole. Food. [Laughter] Iraq Mr. Lehrer. Back to foreign affairs for a moment. Mr. President, are you satisfied with the way you handled this last Iraq crisis and the end result? The President. Well, I believe that we did the appropriate thing under the circumstances. Saddam Hussein is under a U.N. resolution not to threaten his neighbors or repress his own citizens. Unfortunately, a lot of people have never been as concerned about the Kurds as the United States has tried to be, and we've been flying an operation to protect them out of Turkey for many years now. What happened was, one of the Kurdish leaders invited him to go up north. But we felt, since the whole world community had told him not to do it, that once he did it we had to do something. We did not feel that I could commit—I certainly didn't feel I should commit American troops to throw him out of where he had gone, and that was the only way to do that. So the appropriate thing strategically to do was to reduce his ability to threaten his neighbors. We did that by expanding what's called the no-fly zone, by increasing our allies' control of the airspace, now from the Kuwait border to the suburbs of Baghdad. Was it the right thing to do? I believe it was. Is it fully effective? Did it make him withdraw from the north? Well, he has a little bit, and I hope he will continue. We have learned that if you give him an inch he'll take a mile. We had to do something. And even though not all of our allies supported it at first, I think most of them now believe that what we did was an appropriate thing to do. Mr. Lehrer. Senator Dole. Senator Dole. Well, the President's own CIA Director says that Saddam is stronger now than he was. And I don't understand extending the no-fly zone in the south when the trouble was in the north. And what we've done—during the Bush administration the Kurds were at the State Department negotiating, trying to work their differences out. Now we've got all—thousands and thousands of refugees. We're even shipping, I guess, 3,000 Kurds to Guam. It involves Turkey. It's a real problem, and Saddam is probably stronger than he ever was. We shot, what, 44 cruise missiles—they're worth about $1.2 million apiece—and hit some radar that—repaired in a couple, 3 days. Did we inflict any damage? No. Did we have any of our allies helping? Well, we have Great Britain. They're always very loyal to us, and I appreciate that. And of course Kuwait, even though they had to find out they had 5,000 troops coming. They didn't even understand that. We had to get their permission. The bottom line is, we went in there alone. We're supposed to be operating under a U.N. resolution. We did it without any of our allies that helped us in the Gulf. The President. Senator Dole has, two or three times before, tonight criticized me for working with the U.N. Now I'm being criticized for not working with the U.N. Senator Dole. That's not the U.N. The President. Sometimes the United States has to act alone, or at least has to act first. Sometimes we cannot let other countries have a veto on our foreign policy. I could not send soldiers into the north of Iraq; that would have been wrong. I could reduce Saddam Hussein's ability to threaten Kuwait and his other neighbors again. That's what I did. I still believe it was the right thing to do. Middle East Peace Process Mr. Lehrer. Senator Dole, on your photo-op foreign policy charge against the President—— Senator Dole. Not mine. Mr. Lehrer. No, no, I mean your charge against the President that he has a photo-op foreign policy; does the Middle East summit last week fall into that category? Senator Dole. Well, there were some good pictures, but does it fall into that category? I don't know. I want to be very serious. I have supported the President when I thought he was right on Bosnia; I supported him on NAFTA and GATT. So it's not that we always disagree; others disagreed with us. The Mideast is very difficult. But it seemed to me just as an observer that before you would call somebody to America, you would have some notion what the end result might be. Now, maybe it's better just to get together and sit down and talk; maybe that was the purpose. And I know talks have— [inaudible]—started again today. But again, it's almost like an ad hoc foreign policy. It's ad hoc. It's sort of, "Well, we get up in the morning and read the papers and what country's in trouble; we'll have a meeting." To me, that's not the strategy that I think that people expect from America. I think we have lost credibility. And I say this very honestly, without any partisanship. We've lost credibility around the world. Our allies don't—they're not certain what we're going to do, what our reaction, what our response is going to be. Nobody suggested sending troops to Iraq, if that was the hint there from the President. But I do think that Saddam Hussein is stronger than he was, and I do believe that we didn't gain a great deal in the Mideast by bringing three of the four leaders—one refused to come—to Washington, DC. The President. We have a very consistent policy in the Middle East: It is to support the peace process, to support the security of Israel, and to support those who are prepared to take risks for peace. It is a very difficult environment. The feelings are very strong. There are extremists in all parts of the Middle East who want to kill that peace process. Prime Minister Rabin gave his life because someone in his own country literally hated him for trying to bring peace. I would liked to have had a big, organized summit, but those people were killing each other rapidly. Innocent Arab children, innocent Israeli people, they were dying. So much trust has broken down in the aftermath of the change of government. I felt that if I could just get the parties together to say, let's stop the violence, start talking, commit to the negotiations, that would be a plus. Now, today the Secretary of State is in the Middle East, and they've started negotiations. And all of those leaders promised me they would not quit until they resolved the issues between them and got the peace process going forward again. Mr. Lehrer. Senator Dole. Senator Dole. Well, I was disappointed the President did not call for an unconditional end to the violence. I mean, it seemed to me the violence would stop when these leaders came to America. The killing and the tragedies had taken place, and it's unfortunate. And it is a difficult area, no doubt about it. It shouldn't be politicized in any way, by the President or by his opponent, and I don't intend to politicize it. I hope that they have talked, and I hope they've reached some result and that the killing will end. Vision for the Future Mr. Lehrer. Mr. President, in your acceptance speech in Chicago, you said the real choice in this race is, quote, "whether we build a bridge to the future or a bridge to the past, about whether we believe our best days are still out there or our best days are behind us, about whether we want a country of people all working together or one where you're on your own." End quote. Are you saying that you believe Senator Dole is a man of the past and if elected President he would lead the country backward? The President. Well, I'm saying that Senator Dole said in his fine speech in San Diego that he wanted to build a bridge to the past. And I think I know what he meant by that. He is troubled, as I am, by some of the things that go on today. But I believe America is the greatest country in human history because we have maintained freedom and increasing prosperity by relentlessly pushing the barriers of knowledge, the barriers of the present, always moving into the future. That's why when I became President I was determined to kind of move beyond this old, stale debate that had gone on in Washington for too long, to get this country moving again. And that's why we've got a country with 10 1/2 million more jobs and record numbers of new businesses and rising incomes and falling crime rates and welfare roll rates. That's why we're moving in the right direction. And I'm trying to emphasize that what I want to do is to continue to do that. That's why my balanced budget plan will still invest and grow this economy. That's why I want a tax cut for education and childrearing, but it's got to be paid for. That's why I want to continue the work we have done, over partisan opposition, to work with communities to bring that crime rate down until our streets are all safe again. These are my commitments. I am very oriented toward the future. I think this election has to be geared toward the future. I think America's best days are still ahead. But we've got to build the right bridge. Mr. Lehrer. Senator Dole. Senator Dole. You know, the President reminds me sometimes of my brother, Kenny, who is no longer alive, but Kenny was a great talker. And he used to tell me things that I knew were not quite accurate, so we always had a rule, we divided by 6. Now, maybe in your case, maybe just 2. But 11 million new jobs and everything—I mean, the President can't take credit for everything that Governors are doing or that's happening in New York City when it comes to the murder rate and then not be responsible for the bad things that happen, whether it's drug use or something else in America. And so it seems to me that we can talk about—well, we called Kenny the great exaggerator because he just liked to make it sound a little better; it made him feel better. When it comes to bridges, I want a bridge to the future. I also want a bridge to the truth. We have to tell the truth. We've got people watching tonight and listening tonight trying to find the truth. And the truth is, there's a lot wrong with America. We need a strong economic package. We need a tax cut. We need the $500 child credit. And we'll have that soon. Mr. Lehrer. Mr. President. The President. I do not for a moment think I'm entitled to all the credit for the good things that have happened in America. But where I have moved to work with the American people to help them have the tools to make the most of their own lives, I think I should get some credit for that. I also personally took responsibility tonight when Senator Dole asked me about the drug problem. But you know, I think my ideas are better for the future. Senator Dole voted against student loans, against Head Start, against creating the Department of Education. If he gets elected President, we'll start the new century without anyone in the Cabinet of the President representing education and our children. I personally don't think that's the right kind of future for America, and I think we ought to take a different tack. Education Mr. Lehrer. Senator Dole, do you still favor eliminating the Department of Education? Senator Dole. Yes. I didn't favor it when it was started. I voted against it. It was a tribute after President Carter's election to the National Education Association, who sent a lot of delegates to the Democratic Convention, who give 99.5 percent of their money to Democrats and the President. And a lot of the teachers send their kids to private schools or better public schools. So what we want to do is called opportunity scholarships. Now, some say, "Oh, you're Republican; you can't be reaching out to these people." I've reached out to people all my life. I've worked on the food stamp program proudly and the WIC program and the school lunch program with Senators like George McGovern, Hubert Humphrey, and others, to name a few of my Democratic friends. I'm not some extremist out here. I care about people. I have my own little foundation that's raised about $10 million for the disabled. I don't advertise it—just did, haven't before. I try to do a lot of things that I think might be helpful to people. So it seems to me that we ought to take that money we can save from the Department of Education, put it into opportunity scholarships, and tell little Landel Shakespeare out in Cleveland, Ohio, and tell your mother and father you're going to get to go to school because we're going to match what the State puts up, and you're going to get to go to the school of your choice. I don't fault the President or the Vice President for sending their children to private schools or better schools; I applaud them for it. I don't criticize them. But why shouldn't everybody have that choice? Why shouldn't low-income Americans and low-middle-income Americans? I'm excited about it. It's going to be a big, big opportunity for a lot of people. The President. Let me say, first of all, I'm all for students having more choices. We've worked hard to expand public school choice. In my balanced budget bill there are funds for 3,000 new schools, created by teachers and parents, sometimes by business people, called charter schools, that have no rules. They're free of bureaucracy and can only stay in existence if they perform and teach children. The ones that are out there are doing well. What I'm against is Senator Dole's plan to take money away from all of the children we now help with limited Federal funds and help far fewer. If we're going to have a private voucher plan, that ought to be done at the local level or the State level. But Senator Dole has consistently opposed Federal help to education. He voted against student loans, he voted against my improved student loan plan, he voted against the national service bill, against the Head Start bill. He voted against our efforts in safe and drug-free schools. He has voted against these programs. He does not believe it. That's the issue. Ninety percent of our kids are out there in those public schools, and we need to lift their standards and move them forward with the programs like those I've outlined in this campaign. Senator Dole. I had better correct the President. I don't know what time it is, but it's probably getting late. But I want to correct—all of these things I voted against, they were probably part of some big package that had a lot of pork in it or a lot of things that we shouldn't have had, and we probably voted no. I've supported all of the education programs; I've supported Head Start. I think we ought to look at it. So I don't want anybody out there to think that we've just been voting no, no, no. Let's give low-income parents the same right that people of power and prestige have in America and let them go to better schools. Let's turn the schools back to the teachers and back to the parents and take it away from the National Education Association. Mr. Lehrer. Mr. President, what's wrong with the school choice proposal? The President. I support school choice. I support school choice. I have advocated expansions of public school choice alternatives and, I said, the creation of 3,000 new schools that we are going to help the States to finance. But if you're going to have a private voucher plan, that ought to be determined by States and localities where they're raising and spending most of the money. I simply think it's wrong to take money away from programs that are helping build basic skills for kids—90 percent of them are in the public schools—to take money away from programs that are helping fund the school lunch program, that are helping to fund the other programs, that are helping our schools to improve their standards. Our schools are getting better. And our schools can be made to be even better still with the right kind of community leadership and partnership at the school level. I have been a strong force for reform. And Senator, I remind you that a few years ago, when I supported a teacher testing law in my home State, I was pretty well lambasted by the teachers association. I just don't believe we ought to be out there running down teachers and attacking them the way you did at the Republican Convention. I think we ought to be lifting them up and moving our children forward. And let me just say, that budget you passed that I vetoed would have cut 50,000 kids out of Head Start. It would have eliminated the AmeriCorps plan. And it would have cut back on student loans and scholarships. Now, it would have; that's a fact. That's one of the big reasons I vetoed it. We need to be doing more in education, not less. Senator Dole. Well, the AmeriCorps program, I must say, if that's one of your successes I wouldn't speak about it too loudly. It's cost about $27,000 to pay people to volunteer. We've got 4 million young people volunteering every year. The number hasn't gone down. And you pick out 20,000, whether they need the money or not, and they get paid for volunteering. I like young people. I like teachers. I'm a product of public schools. You attended a private school for some time in your life. I like teachers. You're not for school choice. You can't be for school choice, because it's that special interest money again. When you're getting 99.5 percent of the money—we don't know what happened to the other .5 percent; we're looking for it. Somebody got it. But it all went to Democrats, and this is part of that liberal establishment, one of those liberal things that you just can't do. You're for school uniforms and curfews, and you're opposed to truancy. Now, that's not reform, Mr. President. Why can't Landel Shakespeare in Cleveland or Pilar Gonzalez in Milwaukee give their children an opportunity to go to a better school? Some schools aren't safe; some schools aren't even safe. Your choice is nothing. Let's give them a real choice, the kind of choice you have and the kind of choice a lot of people have in America. If we want to stop crime and teenage pregnancy, let's start with education. The President. First of all, Senator Dole, let's set the record straight. I was able, for 2 years when I was a very young boy, to go to a Catholic school, but I basically went to public schools all my life. And I've worked hard for a long time to make them better. Ninety percent of our kids are there. It's amazing to me—you are all for having more responsibility at the local level for everything except schools, where we don't have very much money at the Federal level to spend on education. We ought to spend it helping the 90 percent of the kids that we can help. If a local school district in Cleveland or anyplace else wants to have a private school choice plan like Milwaukee did, let them have at it. I might say, the results are highly ambiguous. But I want to get out there and give a better education opportunity to all of our children. And that's why I vetoed the budget that you passed with $30 billion in education cuts. It was wrong, and my plan for the future is better. Political Philosophy Mr. Lehrer. Mr. President. Senator Dole, at the Republican Convention you said the following, and I quote: "It is demeaning to the Nation that within the Clinton administration, a corps of the elite who never grew up, never did anything real, never sacrificed, never suffered, and never learned should have the power to fund with your earnings their dubious and self-serving schemes." End quote. Whom, precisely, and what, precisely, did you have in mind? Senator Dole. I had precisely in mind a lot of the people that were in the White House and other agencies who have never been—had any experience, who came to Washington without any experience. They're all very liberal, of course, or they wouldn't be in the administration. And their idea was that they knew what was best for the American people. Now, I feel very strongly about a lot of things. I feel strongly about education. I want to help young people have an education, just as I had an education after World War II with the GI bill of rights. And we've had millions of young men and women in subsequent wars change the face of the Nation because the Government helped with their education. Now, the reason they don't want to have— you know, the reason the President can't support this is pretty obvious. It's not taking anything away from schools. It's new money. It's not going to be taken away from anybody else except it will downsize the Department of Education. But this is a very liberal administration. This is the administration that gave you the big tax cut. This is the administration that tried to take over health care and impose a governmental system. This is the administration that fought regulatory reform and that's putting a lot of smallbusiness men and small-business women out of business. This is the administration that fought the balanced budget amendment and vetoed a balanced budget and vetoed welfare reform twice. And the list goes on and on and on. That's what I had in mind. I want people in my administration and will have people in my administration who understand America. There won't be 10 millionaires and 14 lawyers in the Cabinet. They'll be people with experience and people who understand America and people who know the hard knocks in life. The President. When Senator Dole made that remark about all the elitists, young elitists in the administration, one of the young men who works for me who grew up in a house trailer looked at me and said, "Mr. President, I know how you grew up. Who is he talking about?" And you know, this liberal charge, that's what their party always drags out when they get in a tight race. It's sort of their golden oldie, you know, it's a record they think they can play that everybody loves to hear. [Laughter] And I just don't think that dog will hunt this time. The American people should make up their own mind. Here's the record: We cut the deficit 4 years in a row for the first time since before the Civil War—I mean, before World War II— and maybe before the Civil War, too. [Laughter] We've got 10 1/2 million new jobs. We've got record numbers of new small businesses. We made every one of them eligible for a tax cut. We've got declining crime rates, 2 million fewer people on welfare rolls before welfare reform passed, and a 50 percent increase in child support, and a crime bill with 60 death penalties, 100,000 police, and the assault weapons ban. The American people can make up their mind about whether that's a liberal record or a record that's good for America. Liberal, conservative, you put whatever label you want on it. Senator Dole. Well, I think it's pretty liberal; I'll put that label on it. When you take a look at all the programs you've advocated, Mr. President, thank goodness we had a Republican Congress there. The first thing you did when you came into office was send up a stimulus package that said, we've got a little pork we want to scatter around America, $16 billion. And even some in your own party couldn't buy that. I remember talking by the telephone—I'm not even certain you were too excited about it—I'll never repeat what I talked with the President about, but in any event, we saved the taxpayers $16 billion. And then came some other programs and then came health care and then came the tax increase. And a lot of these things just stopped in 1994 because then the Congress changed, and I think we've done a good job. Mr. Lehrer. Mr. President, if you're not a liberal, describe your political philosophy. The President. I believe that the purpose of politics is to give people the tools to make the most of their own lives, to reinforce the values of opportunity and responsibility, and to build a sense of community so we're all working together. I don't believe in discrimination. I believe you can protect the environment and grow the economy. I believe that we have to do these things with a Government that's smaller and less bureaucratic, but that we have to do them nonetheless. It's inconvenient for Senator Dole, but the truth is I've reduced the size of Government more than my Republican predecessors. And I did stop them, I admit that; I sure stopped their budget. Their budget cut enforcement for the Environmental Protection Agency by a third. It cut funds to clean up toxic waste dumps— with 10 million of our kids still living within 4 miles of a toxic waste dump—by a third. It ended the principle of the polluters should pay for those toxic waste dumps unless it was very recent. Their budget weakened our support for education $30 billion, even cut funds for scholarships and college loans. Their budget cut $270 billion in Medicare. And finally, their budget withdrew the national guarantee of health care to poor children, families with children with handicaps, the elderly in nursing homes, poor pregnant women. It was wrong for the country, and calling it conservative won't make it right. It was a bad decision for America and would have been bad for our future if I hadn't stopped it. Senator Dole. Well, the President can define himself in any way he wants, but I think we have to look at the record. Go back to the time he was, what, Texas director for George McGovern. George McGovern is a friend of mine, so I don't mean—but he was a liberal, proud liberal. I've just finished reading a book. I think it's called, what is it, "The Demise of the Democratic Party" by Ronald Radosh or something, talking about all the liberal influences in the administration, whether it's organized labor or whether it's the Hollywood elite or whether it's some of the media elite or whether it's the labor unions or whatever. And so I think—you take a look at it, but the bottom line is this: I think the American people probably lose sight of all of these bills and all these things. They want to know what's going to happen to them. They've all got a lot of anxieties out there. Did anybody complain when you raised taxes? Did anybody go out and ask the people, "How are you going to pay the extra money?" That's why we want an economic package. We want the Government to pinch their pennies for a change instead of the people pinching their pennies. That's what our message is to people watching, not all this back and forth—you voted this way, you voted that way. We want a better America as we go into the next century. The President. The way to get a better America is to balance the budget and protect Medicare, Medicaid, education, and the environment; to give a targeted tax cut—and let me talk about the education tax cut—to let people have a $10,000 deduction for the cost of college tuition in any year, any kind of college tuition; to give families a tax credit, a dollar-for-dollar reduction in their taxes for the cost of a typical community college so we can open that to everybody; and then to let people save in an IRA and withdraw from it without a tax penalty for education, homebuying, or medical expenses. That's the right way to go into the 21st century: balance the budget and cut taxes, not balloon with this $550 billion tax scheme. Personal Differences Mr. Lehrer. Senator Dole, we've talked mostly now about differences between the two of you that relate to policy issues and that sort of thing. Are there also significant differences in the more personal area that are relevant to this election? Senator Dole. Let me say first on the President's promise for another tax cut—I mean, I've told people as I travel around, "All of you who got the tax cut he promised last time, vote for him in '96," and not many hands go up. So the question is, would you buy a used election promise from my opponent? The people want economic reform. They're having a hard time making ends meet. You got one parent working for the Government, the other parent working for the family. And this is important business. This is about getting the economy moving again. This is about American jobs and opportunities. It's about the Government, as I said before, pinching its pennies for a change instead of the poor taxpayer. When they raise your taxes, nobody runs around asking people, "Where are you going to get the extra money?" I think the Government can do better. Are there personal differences? Mr. Lehrer. That are relevant to this. Senator Dole. Well, my blood pressure is lower and my weight, my cholesterol. But I will not make health an issue in this campaign. [Laughter] I think he's a bit taller than I am. But I think there are personal differences. I mean, I don't like to get into personal matters. As far as I'm concerned, this is a campaign about issues. It's about my vision for America and about his liberal vision for America, and not about personal things. And I think his liberal vision is a thing of the past. I know he wants to disown it. I wouldn't want to be a liberal either, Mr. President, but you're stuck with it because that's your record. It's your record in Arkansas: the biggest tax increase in history, the biggest crime increase in history, biggest drug increase in history in Arkansas. Mr. Lehrer. Mr. President. The President. Well, just for the record, when I was a Governor, we had the lowest—second lowest tax burden of any State in the country, the highest job growth rate of any State when I ran for President, and were widely recognized for a lot of other advances. But the important thing is, what are we going to do now? I think a targeted tax cut is better for our future, targeted to education and childrearing, with the rest of the education plan—hooking up all of our classrooms to the Internet by the year 2000, making sure we've got an army of reading volunteers, trained people to teach with parents and teachers so that our 8-year-olds can learn to read; investing in our environment, cleaning up two-thirds of the worst toxic waste dumps. Those plans are better than this $550 billion tax scheme. Now, remember, folks, even Senator Dole's campaign cochair, Senator D'Amato, says he's got to cut Medicare to pay for this. Everybody who has looked at it, 500 economists, 7 Nobel Prize winners, say it's bad for the economy. It's going to blow a hole in the deficit, raise taxes on 9 million people, and require bigger cuts than the one I vetoed. Our plan is better. It will take us into the future with a growing economy and healthier families. Senator Dole. Well, I'm really encouraged to know of your renewed friendship with Al D'Amato, and I know he appreciates it. [Laughter] You didn't even have tax cuts in your budget, Mr. President, the first 2 years you were President. It wasn't until we had a Republican Congress that you even thought about—you talked about tax cuts. And getting back to personal differences, I think, Jim, if you're a little more specific, but I think the President could clarify one thing tonight, and that's the question of pardons. I know you talked about it with Jim Lehrer on the PBS show. And I've never discussed Whitewater, as I've told you personally; I'm not discussing Whitewater now. But I am discussing a power the President has to grant pardons, and hopefully in the next segment you could lay that to rest. Mr. Lehrer. Mr. President. The President. Well, first of all, he made that remark about Senator D'Amato. He's arranged for me to spend a lot more time with Senator D'Amato in the last couple of years, and so I'm more familiar with his comments than I used to be. [Laughter] Let me say what I've said already about this pardon issue. This is an issue they brought up. There has been no consideration of it, no discussion of it. I'll tell you this: I will not give anyone special treatment, and I will strictly adhere to the law. And that is what every President has done, as far as I know, in the past. But whatever other Presidents have done, this is something I take seriously, and that's my position. Senator Dole. But it seems to me the President shouldn't have any comment at all, particularly where it's someone where you've had business dealings. I mean, you may be sending a signal; I don't know. I'm not questioning anybody. But as the President of the United States, when somebody asks you about pardons, you say "no comment," period. And I think he made a mistake, and I think when you make a mistake, you say, "I made a mistake." But apparently his position hasn't changed. If there are other specific areas—but beyond that, I haven't gotten into any of these things, as the President knows. We've had that discussion. And again, I know Senator D'Amato I think may have had a hearing or two on Whitewater; I can't remember. [Laughter] But he's not my general chairman, he's a friend of mine. And so is Senator Kennedy a friend of yours—— The President. You bet. Senator Dole. I remember one day on the floor, I said, "Now, gentlemen, let me tax your memories," and Kennedy jumped up and said, "Why haven't we thought of that before?" [Laughter] One of your liberal friends. The President. That's right. Thank you. Mr. Lehrer. Mr. President, 30 seconds. The President. No comment. [Laughter] Senator Dole. What's the subject matter? [Laughter] Mr. Lehrer. Senator Dole, if you could single out one thing that you would like for the voters to have in their mind about President Clinton, on a policy matter or a personal matter, what would it be? Something to know about him, understand it, and appreciate it. Senator Dole. See, if I say anything, it's going to be misconstrued. I don't think this is even a race between the two—it's about our vision for America. I happen to like President Clinton personally. I'm addressing him all evening as Mr. President. I said in 1992 he didn't extend that courtesy to President Bush. But I respect the Presidency. I've served under a number of Presidents; they all have their strengths, and they all have their weaknesses. So I'd rather talk about my strengths. I think I have my strengths. I think the best thing going for Bob Dole is that Bob Dole keeps his word. It's a question between trust and fear. And I would say I think, Mr. President, about all you've got going in this campaign is fear. You're spending millions and millions of dollars in negative ads, frightening senior citizens. I know this to be a fact, because I had one tell me last week, "Senator, don't cut my Medicare." I'm trying to save your Medicare, just as I rescued Social Security with a bipartisan commission. I have relatives on Medicare. I used to sign welfare checks for my grandparents. I know all about poverty and all about need and all about taking care of people, and that's been my career in the United States Senate. And I'll keep my word on the economic package. If I couldn't cut taxes and balance the budget at the same time, I wouldn't look you in the eye tonight in your living room, or wherever you may be, and say that this is good for America. People will tell you who have served with Bob Dole, agree or disagree, he kept his word. That's what this race is all about. The President. I'd like the American people to know that I have worked very hard to be on their side and to move this country forward, and we're better off than we were 4 years ago. But the most important thing is my plan for the 21st century is a better plan: a targeted tax cut; a real commitment to educational reform; a deep commitment to making welfare reform work, with incentives to the private sector to move people from welfare to work—now we have to create those jobs, now that we're requiring people to go to work; a commitment to step-by-step health care reform, with the next step helping people who are between jobs to access health care and not lose it just because they're out of work for a while; a commitment to grow the economy while protecting the environment. That's what I'd like them to know about me, that I've gotten up every day and worked for the American people and worked so that their children could have their dreams come true. And I believe we've got the results to show we're on the right track. The most important thing is I believe we've got the right ideas for the future. And like Senator Dole—I like Senator Dole. You can probably tell we like each other. We just see the world in different ways, and you folks out there are going to have to choose who you think is right. Senator Dole. Well, I'd say, you know, the first homeless bill in the Senate was the Dole-Byrd bill, part of the Byrd-Dole bill—I can't remember who was in control then. I remember working with Senator Ribicoff from Connecticut on the hospice program; we now have 2,500 hospices. As I said, I remember, I've worked all my life while I was in the Congress—I left on June 11th because I wanted the American people to know that I was willing to give up something. President Clinton ran for Governor in 1990 and said he was going to fill out his term, but he didn't. He's President, so I guess it's a little better deal. But I wanted the American people to know that I was willing to give up something; it wasn't just getting more power and more power. So I rolled the dice. I put my career on the line because I really believe the future of America is on the line. We can give you all these numbers. They don't mean a thing if you're out of work, you have nothing to eat, or you can't have medical care, or you're holding a crack baby in your arms right now, and what do you do next? You know, America's best days are ahead of us. I've seen the tough times. I know they can be better. And I'll lead America to a brighter future. Mr. Lehrer. Mr. President, what do you say to Senator Dole's point that this election is about keeping one's word? The President. Let's look at that. When I ran for President, I said we'd cut the deficit in half in 4 years; we've cut it by 60 percent. I said that our economic plan would produce 8 million jobs; we have 10 1/2 million new jobs. We're number one in autos again, record numbers of new small businesses. I said we'd pass a crime bill that would put 100,000 police on the street, ban assault weapons, and deal with the problems that ought to be dealt with with capital punishment, including capital punishment for drug kingpins. And we did that. I said we would change the way welfare works. And even before the bill passed, we had moved nearly 2 million people from welfare to work, working with States and communities. I said we'd get tougher on child support, and child support enforcement is up 50 percent. I said that I would work for tax relief for middle class Americans. The deficit was bigger than I thought it was going to be, and I think they're better off, all of us are, that we got those interest rates down and the deficit down. The Republicans talk about it, but we're the first administration in anybody's lifetime looking at this program to bring that deficit down 4 years in a row. We still gave tax cuts to 15 million working Americans. And now I've got a plan that has been out there for 2 years— it could have been passed already, but instead the Republicans shut the Government down to try to force their budget and their plan on me, and I couldn't take that. But we'll get the rest of that tax relief. And so I think when you can look at those results, you know that the plan I have laid out for the future has a very good chance of being enacted if you'll give me a chance to build that bridge to the 21st century. Mr. Lehrer. Senator. Senator Dole. Well, there he goes again— I mean, it's a line that has been used before— but exaggerating all of the things he did. He didn't do all these things. Let's take all of these 4, you know, years in a row. He came in with a high growth rate. The 1990 budget agreement, which some didn't like, had some very tough cost controls. It put a lot of pressure on Congress. The S&L crisis was over. They were starting to sell assets; all of that money was coming in. And he cut defense an extra $60 billion, threw a lot of people out of work. He talks about a smaller Government. There are actually more people in Government, except for the people in defense-related jobs. They're gone. The Government is bigger than it was when President Kennedy was around, even though he says it's not. In addition, the Republican Congress cut $53 billion. So let's give credit where credit is due. Governor Engler in Michigan cut taxes 21 times, created a lot of new jobs. So did Governor Thompson. So did Governor Rowland. And a lot of people out there deserve credit, Mr. President. When I'm President of the United States, we're going to have a Governors council, and we're going to work directly with the Governors, Republicans and Democrats, to get power back to the people and back to the States. The President. I think a lot of people deserve credit, and I've tried to give it to them. But I believe that my plan is better than Senator Dole's ill-advised $550 billion scheme, which I will say again will blow a hole in the deficit. Our plan will balance the budget and grow the economy, preserve the environment, and invest in education. We have the right approach for the future. And look at the results: It is not midnight in America, Senator. We are better off than we were 4 years ago. Closing Statements Mr. Lehrer. All right, that's the last question, the last answer. Let's go now to the closing statements. Senator Dole. Are we done? Mr. Lehrer. Mr. President, you're first. Two minutes. The President. Well, first, Jim, let me thank you, and thank you, Senator Dole, and thank you, ladies and gentlemen, all of you listening tonight, for the chance you've given us to appear. I want to say in the beginning that I am profoundly grateful for the chance that you have given me to serve as President for the last 4 years. I never could have dreamed anything like this would come my way in life, and I've done my best to be faithful to the charge you've given me. I'm proud of the fact that America is stronger and more prosperous and more secure than we were 4 years ago. I'm glad we're going in the right direction. And I've done my best tonight to lay out my plans for going forward to an even better future in the next century. I'd like to leave you with the thought that the things I do as President are basically driven by the people whose lives I have seen affected by what does or doesn't happen in this country: the autoworker in Toledo who was unemployed when I was elected and now has a great job, because we're number one in auto production again; all the people I've met who used to be on welfare who are now working and raising their children—and I think what others could do for our country and for themselves if we did the welfare reform thing in the proper way. I think of the man who grabbed me by the shoulder once with tears in his eyes and said his daughter was dying of cancer, and he thanked me for giving him a chance to spend some time with her without losing his job, because of the Family and Medical Leave Act. I think of all the people that I grew up with and went to school with whom I stay in touch with and who never let me forget how what we do in Washington affects all of you out there in America. Folks, we can build that bridge to the 21st century, big enough and strong enough for all of us to walk across. And I hope that you will help me build it. Mr. Lehrer. Senator Dole, your closing statement, sir. Senator Dole. Thank you, Jim. Thank you, Mr. President. Thank everyone for watching and listening. I want to address my remarks to the young people of America, because they're the ones that are going to spend most of their life in the 21st century. They're the ones who have the challenges. And there are people out there making predictions that it's not going to be the same; you're not going to have the opportunity; there is going to be more deficits, more drugs, more crime, and less confidence in the American people. And that's what you're faced with, what the parents are faced with and the grandparents are faced with. It's important. It's their future. And I would say to those—I know there are more young people experimenting with drugs today than ever before. Drug use has gone up. And if you care about the future of America, if you care about your future, just don't do it. And I know that I am someone older than you, but I've had my anxious moments in my life. I've learned to feed myself and to walk and to dress. I'm standing here as proof that in America, the possibilities are unlimited. I know who I am, and I know where I'm from, and I know where I want to take America. We are the greatest country on the face of the Earth. We do more good things for more people in our communities, our neighborhoods than anywhere that I know of. This is important business. This election is important. I ask for your support. I ask for your help. If you really want to get involved, just tap into my home page, www.dolekemp96.org. Thank you. God bless America.
