# Vice Presidential Debate in Omaha, Nebraska

**Date:** October 5, 1988
**Source:** https://www.presidency.ucsb.edu/documents/vice-presidential-debate-omaha-nebraska

---

WOODRUFF: On behalf of the Commission on Presidential Debates, I am pleased to welcome you to this Vice Presidential debate. I'm Judy Woodruff of PBS' MacNeil-Lehrer News Hour and Frontline. My colleagues on the panel are: John Margolis of the Chicago Tribune; Tom Brokaw of NBC NEWS; and Brit Hume of ABC NEWS. The importance of tonight's debate is underscored by two facts. Both George Bush and Michael Dukakis said their selections of a running mate would reveal a lot about themselves. And based on the history since World War II, there is almost a 50-50 chance that one of the two men here tonight will become President of the United States. The candidates are Senator Dan Quayle, the Republican nominee, and Senator Lloyd Bentsen, the Democratic nominee. (Applause) WOODRUFF: For the next 90 minutes we will be questioning the candidates following a format designed and agreed to by representatives of the two campaigns. However, there are no restrictions on the questions that my colleagues and I may ask this evening. By prior agreement between the two candidates, the first question goes to Senator Quayle, and you have two minutes to respond. Senator, you have been criticized, as we all know, for your decision to stay out of the Vietnam War, for your poor academic record. But more troubling to some are some of the comments that have been made by people in your own party. Just last week former Secretary of State Haig said that your pick was the dumbest call George Bush could have made. Your leader in the Senate. (Applause) WOODRUFF: Your leader in the Senate Bob Dole said that a better qualified person could have been chosen. Other Republicans have been far more critical in private. Why do you think that you have not made a more substantial impression on some of these people who have been able to observe you up close? QUAYLE: The question goes to whether I am qualified to be Vice President, and in the case of a tragedy, whether I'm qualified to be President. Qualifications for the office of Vice President or President are not age alone. You must look at accomplishments, and you must look at experience. I have more experience than others that have sought the office of Vice President. Now let's look at qualifications, and let's look at the three biggest issues that are going to be confronting America in the next presidency. Those three issues are national security and arms control; jobs and education; and the Federal budget deficit. On each one of those issues I have more experience than does the Governor of Massachusetts. In national security and arms control, you have to understand the difference between a ballistic missile, a warhead, what throwweight, what megatonnage is. You better understand about telemetry and encryption. And you better understand that you have to negotiate from a position of strength. These are important issues, because we want to have more arms control and arms reductions. In the area of jobs and education, I wrote the Job Training Partnership Act, a bipartisan bill, a bill that has trained and employed over three million economically disadvantaged youth and adults in this country. On the area of the Federal budget deficit, I have worked eight years on the Senate Budget Committee. And I wish that the Congress would give us the line item veto to help deal with that. And if qualifications alone are going to be the issue in this campaign, George Bush has more qualifications than Michael Dukakis and Lloyd Bentsen combined. (Applause) WOODRUFF: Senator Bentsen - I'm going to interrupt at this point and ask once again that the audience please keep your responses as quiet as possible. We know that many of you here are for one candidate or another. But you are simply taking time away from your candidate, and more likely than not, you'll be causing the partisans for the other candidate to react again when their candidate speaks. So please. Senator Bentsen, you have one minute to respond. BENTSEN: This debate tonight is not about the qualifications for the Vice Presidency. The debate is whether or not Dan Quayle and Lloyd Bentsen are qualified to be President of the United States. Because Judy, just as you have said, that has happened too often in the past. And if that tragedy should occur, we have to step in there without any margin for error, without time for preparation, to take over the responsibility for the biggest job in the world, that of running this great country of ours; to take over the awesome responsibility for commanding the nuclear weaponry that this country has. No, the debate tonight is a debate about the presidency itself, and a presidential decision that has to be made by you. The stakes could not be higher. WOODRUFF: Senator Bentsen, a question for you, and you also have two minutes to respond. What bothers people is not so much your qualifications but your split on policy with Gov. Dukakis. He has said that he does not want a clone of himself, but you disagree with him on some major issues: aid to the Nicaraguan Contras; the death penalty; gun control; among others. If you had to step into the presidency, whose agenda would you pursue, yours or his? BENTSEN: Well, I am delighted to respond to that question, because we agree on so many things and the vast majority of the issues. We agree on the fact that we have to cut this deficit. And Gov. Dukakis has been able to cut that deficit ten budgets in a row in the State of Massachusetts, while he lowered the tax burden on their people from one of the highest to one of the lower in the United States. That is a major sense of achievement. And I admire that. And I'm just delighted to be on the ticket with him. Gov. Dukakis and I agreed that we ought to have a trade policy for this country; that we've seen this Administration more than double the national debt, that; they've moved this country from the number one lender nation in the world to the number one debtor nation in the world under their Administration; that they have not had a trade policy; that they have let trade be a handmaiden for their foreign policy objectives of the country; that this country has exported too many jobs and not enough products. And as I worked to pass a trade bill through the United States Senate, they threw roadblocks in the way every step of the way. But we passed a trade bill that has this premise, that any country that has full access to our markets, we're entitled to full access to their markets. Now, that means that we're going to stand tough for America, and we're going to protect those jobs, and we're going to push American products, and we're going to open up markets around the world. We'll show leadership in that respect, and turn this deficit and trade around. That's the sort of thing that Michael Dukakis and I will do to bring about a better America for all our people. WOODRUFF: Senator Quayle, a minute to respond. QUAYLE: As you notice, Senator Bentsen didn't tell you very much about what Gov. Dukakis would do - Gov. Dukakis, one of the most liberal governors in the United States of America The one thing he tried to point out about Gov. Dukakis is that he's cut taxes. The fact of the matter is, Senator Bentsen, he's raised taxes five times. He just raised taxes this past year. And that's why a lot of people refer to him as Tax-hike Mike. That's why they refer to the State of Massachusetts as Taxachusetts. Because every time there's a problem, the liberal governor from Massachusetts raises taxes. I don't blame Senator Bentsen for not talking about Gov. Michael Dukakis. He's talking more about his record. If I had to defend the liberal policies of Gov. Michael Dukakis, I wouldn't talk about it either. WOODRUFF: John Margolis, a question for Senator Bentsen. MARGOLIS: Senator Bentsen, you have claimed that Vice President Bush and the Republicans will raid the Social Security Trust Fund, and you have vowed to protect it. But as Chairman of the Senate Finance Committee, you must know that there is something to the argument of your fellow Democrat Bob Strauss that some restraint on Social Security growth may be needed, or at least some decision to tax most Social Security benefits as regular income. In fact, you once voted for and spoke for a six-month delay on cost of living adjustment increases for Social Security. Senator, aren't you and Gov. Dukakis using this issue politically, rather than dealing with it responsibly? BENTSEN: Well, I must say I hate to disappoint my good friend Bob Strauss, but we have a contract with the American people on Social Security. And Social Security is an issue where Senator Quayle voted eight times to cut the benefits on Social Security, where this administration came in and tried to cut the benefits, the minimum benefits, $122 a month for widows, for retirees, tried to cut the benefits for 62-year-old retirees by 40 percent, tried to do an end run on Social Security when they first came in after promising not to cut it - to cut it by some 20 billion, and while we were working together to reform the Social Security system and to be certain that that money was going to be there for people when they retired. At that point they tried a $40-billion end run to cut Social Security. Now, the record is clear. And we saw Vice President Bush fly back from the west coast to break a tie in the United States Senate. He doesn't get to vote very often in the Senate, but he made a special trip to come back and vote against a cost-of-living increase. Now, when you talk about Social Security, the people that are going to protect it are the Democrats that brought forth that program. And I think it's very important that we not see these kinds of end runs by this administration. When they talk about the fact that they are going to continue to cut this budget, I know too well what their rack record is. And we should be concerned with that kind of an effort once again after the election is over. WOODRUFF: Senator Quayle, your response? QUAYLE: Senator Bentsen, you know that I did not vote to cut Social Security benefits eight times. What I have voted for and what Senator Bentsen has voted for is to delay the cost-of-living adjustments. Senator Bentsen two times in the United States Senate voted to delay the cost-of-living adjustments. The governor of Massachusetts at a governors' conference supported a resolution to delay the cost-of-living adjustment. And, John, you are right: they use this for political advantage. What they try to do time and time again is to scare the old people of this country. That's the politics of the past. In 1983 Republicans and Democrats dropped their political swords and in a bipartisan effort saved the Social Security system. Republicans and Democrats banded together because we know that this program is not a Republican program, it's not a Democrat program - it's a program for older Americans. And that program is actuarially sound to the turn of this century. WOODRUFF: John, a question for Senator Quayle. MARGOLIS: Senator, since coming to the Senate you have voted against environmental protection legislation about two-thirds of the time. This includes votes against pesticide controls, the toxic waste superfund, and health and safety protection from nuclear wastes. Senator, do you consider yourself an environmentalist, and, if you do, how do you reconcile that with your voting record? QUAYLE: I have a very strong record on the environment in the United States Senate. (Laughter) I have a record where I voted for the superfund legislation. I have a record where I voted against my president on the override of the Clean Water Act. I have voted for the major pieces of environmental legislation that have come down and been voted on in the United States Senate. This administration - and I support this administration and its environmental efforts - has moved in the area for the first time to deal with the ozone problem. We now have an international treaty, the treaty that is commonly referred to as the Montreal Treaty. For the first time we are talking about the impact of CO2 to the ozone layer. That's progress with the environment. We are committed to the environment. I take my children hiking and fishing, walking in the woods, in the wilderness. Believe me, we have a commit to preserving the environment. You bring up the environment, you can't help but think about the environmental policy of the governor of Massachusetts. He talks about being an environmentalist. Let me tell you about his environmental policy. The Boston Harbor - the Boston Harbor, which is the dirtiest waterway in America, tons of raw sewage go in there each and every day. What has the governor of Massachusetts done about that? Virtually nothing. And then he has the audacity to go down to New Jersey and tell the people of New Jersey that he's against ocean dumping. This is the same governor that applied for a license to dump Massachusetts sewage waste off the coast of New Jersey. Who has the environmental record? Who has the environmental interest? George Bush and I do. WOODRUFF: Senator Bentsen. BENTSEN: This late conversion is interesting to me. (Laughter and applause) I must say, when they talk about Boston Harbor and he says he hasn't done anything, the facts are he has a $6-billion program under way on waste treatment. And it was this administration, their administration, that cut out the money early on to be able to clean up water, and made it impossible to move ahead at that time on Boston Harbor. We are the authors, the Democratic Party, of Clean Air, of Clean Water, of the superfund. I am one who played a very major role in passing the superfund legislation. And every environmental organization that I know, every major one, has now endorsed the Dukakis-Bentsen ticket. And I am one who has just received the environmental award in Texas for the work I've done to clean up the bays, to clean up the water, off the coast of Texas. No, I think we know well who's going to help clean up this environment. The record is there, the history is there. And Dukakis and Bentsen will be committed to that. (Applause) WOODRUFF: Tom Brokaw, a question for Senator Quayle. BROKAW: Thank you, Judy. Senator Quayle, there's been a lot of talk during the course of this campaign about family. It was a principal theme, as I recall, in your acceptance speech in New Orleans. Tonight I'd like to ask you about the sixty-five million American children who live with their families in poverty. I'd like for you to describe to the audience the last time that you may have visited with one of those families personally and how you explain to that family your votes against the school breakfast program, the school lunch program, and the expansion of the child immunization program. (Applause) QUAYLE: I have met with those people, and I met with them in Fort Wayne, Indiana, at a food bank. You may be surprised, Tom, they didn't ask me those questions on those votes, because they were glad that I took time out of my schedule to go down and to talk about how we are going to get a food bank going and making sure that a food bank goes in Fort Wayne, Indiana. And I have a very good record and a commitment to the poor, to those that don't have a family, that want to have a family. This administration, and a George Bush administration, will be committed to eradicating poverty. Poverty hasn't gone up in this administration; it hasn't gone down much either, and that means we have a challenge ahead of us. But let me tell you something, what we have done for the poor. What we have done for the poor is that we in fact - the homeless bill, the McKinney Act, which is the major piece of legislation that deals with homeless - the Congress has cut the funding that the administration has recommended. The poor and the poverty - the biggest thing that we have done for poverty in America is the Tax Simplification Act of 1986: six million working poor families got off the payroll; six million people are off the taxpaying payrolls because of that tax reform, and they are keeping the tax money there. To help the poor, we'll have a commitment to the programs and those programs will go on. And we are spending more in poverty programs today than we were in 1981 - that is a fact. The poverty program we are going to concentrate on is creating jobs and opportunities, so that everyone will have the opportunities that they want.] (Scattered applause) WOODRUFF: Senator Bentsen, your response. BENTSEN: I find that very interesting, because he has been of no help at all when it comes to passing the most major welfare reform bill in the history of our country, one where we are working very hard to see that people can get off welfare, break that cycle, take a step up in life, doing the kinds of things that we did there to let them have Medicaid for a year. That's a positive thing that's done. What also frustrates me with the kind of report that I have just heard here is the kind of votes that he has cast against child nutrition programs, the fact that he has voted against money that we needed for further immunization, the denial of polio shots to kids where the parents couldn't afford to get that kind of a shot. Now, I don't really believe that that is identifying with the concerns of people in poverty. WOODRUFF: Tom, a question for Senator Bentsen. BROKAW: Senator Bentsen, I'd like to take you back to the question that Judy asked you about your differences with Michael Dukakis on contra aid. After all, the contra aid is one of the cutting issues of foreign policy of this country in the last eight years. You and Michael Dukakis seem to be diametrically opposed on that. 1 have been told that in a closed session of the U.S. Senate you made one of the most eloquent and statesmanlike speeches in behalf of contra aid that anyone had made in the eight years of the Reagan term, that in fact you alluded to the threat that the Sandinista regime could pose to your own state of Texas. Governor Dukakis, on the other hand, has described the contra aid policy as immoral and illegal. Is he wrong? (Scattered applause) BENTSEN: Gov. Dukakis and I have disagreed on the contra program; no question about that. But my big difference with this Administration is, they look at the contra aid program as the only way to resolve that problem. They concentrate on that. And I really think we have to give peace a chance. And that's why I have been a strong supporter of the Arias plan, a plan that won the Nobel Prize for President Arias, the President of Costa Rica. I believe you have to work with the leaders of those other Central American countries to try to bring about the democratization of Nicaragua - by negotiation, by pressure, by counseling, by diplomatic pressure, that we ought to be trying that first. But in concentrating so much just on the Contras, this Administration has not paid enough attention to the rest of Central America. The concern I have is that we have a country with 85 million people sharing a 2,000mile border with us, with half of those people under the age of 15, a country that's had its standard of living cut 50 percent in the last six years. Now we ought to be concerned about that, and we ought to be involved. I was born and reared on that Mexican border. I speak their language. I've spent a good part of my life down there. Gov. Dukakis speaks Spanish, too. He's spent a good deal of time in Central and South America. And we believe that we ought to be working with a new Alliance for Progress, bringing in other countries to help; bring in Europeans, the Spanish, who have a real affinity for that area; bringing in the Japanese who have a great surplus now and looking for places to invest it. Those are the positive things I think we could do to bring about peace in that area, to help raise that standard of living and give them the kind of stability where democracy can proceed and can prosper and bloom. Those are the kinds of things that we'd be committed to in a Dukakis-Bentsen Administration to try to make this world a better place in which to live. WOODRUFF: Senator Quayle, your response. QUAYLE: There's no doubt in a Dukakis Administration that the aid would be cut off to the democratic resistance in Nicaragua, and that is unfortunate. The reason it is unfortunate, because it is beyond me why it's okay for the Soviet Union to put in billions of dollars to prop up the communist Sandinistas, but somehow it's wrong for the United States to give a few dollars to the democratic resistance. There's a thing called the Monroe Doctrine, something that the Governor of Massachusetts has said has been superseded. I doubt if many Americans agree with that. I think they believe in the Monroe Doctrine. Senator Bentsen talked about the entire Central America. There's another issue that Michael Dukakis is wrong on in Central America, and that's Grenada. He criticized our rescue mission in Grenada, according to a UPI report. Criticized that, yet 85 percent of the American people supported our rescue mission, and we turned a communist country into a noncommunist country. The Governor of Massachusetts is simply out of step with mainstream America. WOODRUFF: Brit Hume, a question for Senator Bentsen. HUME: Good evening, Senator Bentsen, Senator Quayle. I'm sort of the cleanup man in this order, and I've been asked by my colleagues to try to deal with anything that's been left on base. Senator, I have a follow up question for you, Senator Quayle. But Senator Bentsen, I first want to ask you a question about PAC money, a thing I'm sure you're prepared to talk about. Gov. Dukakis has tried to make ethics a major issue in the campaign. And he has you as a running mate, a man who leads the league at last count in the receipt of PAC money, that being the money raised by the special interest organizations. That is a kind of campaign financing which Gov. Dukakis finds so distasteful that he has refused to accept any of it. Do you find that embarrassing, Senator? BENTSEN: No, I don't find it embarrassing at all. Because you have to remember that PAC money is the result of the last campaign reform bill, one that talks about employees have greater participation. And what I've done in PAC money is just what my opponent in my campaign has done in his campaign. He has been raising PAC money, too. So what you have to do is comply with the laws as they are, whether you're paying taxes or you're playing a football game. Whether you like those laws or not, you comply with them. Now, I have been for campaign reform, and have pushed it very hard. I believe that we have to do some things in that regard. But I've noticed that the Senator from Indiana has opposed that campaign reform and voted repeatedly against it. The things we have to do, I believe, that will cut back on soft money, for example, which I look on as frankly one of those things that we've had to do because the Republicans have done it for so long. But I think it's a loophole, frankly. But campaign reform, changing the rules of the game, is something we tried repeatedly in this session of the Congress, but only to have the Republicans lead the charge against us and defeat us. And I wish that Senator Quayle would change his mind on that particular piece of legislation and give us the kind of a campaign reform law that I think is needed in America. WOODRUFF: Senator Quayle, your response. QUAYLE: Senator Bentsen is the number one PAC raiser. As a matter of fact, he used to have a $10,000 breakfast club. $10,000 breakfast club. It only costs high paid lobbyists, special interests in Washington, to come down and have breakfast with the Chairman of the Senate Finance Committee, the one that oversees all the tax loopholes in the tax code, $10,000. I'm sure they weren't paying to have cornflakes. Well, I'll tell you the kind of campaign reform I'm supporting, Senator Bentsen. I think it's time we get rid of PAC money. Support our legislation where we totally eliminate contributions by special interests and political action committees, and let's have the individual contribute and the political parties contribute. That's the kind of campaign reform that Republicans are for. They want to get rid of this special interest and rely on the individuals, and also, the political parties. WOODRUFF: Brit, your question for Senator Quayle. Once again, let me caution the audience: please, keep your reactions as quiet as possible. Brit? HUME: Senator, I want to take you back if I can to the question Judy asked you about some of the apprehensions people may feel about your being a heart beat away from the presidency. And let us assume if we can for the sake of this question that you have become Vice President and the President is incapacitated for one reason or another, and you have to take the reins of power. When that moment came, what would be the first steps that you'd take, and why? QUAYLE: First - first, I'd say a prayer for myself and for the country that I'm about to lead. And then I would assemble his people and talk. And I think this question keeps going back to the qualifications and what kind of Vice President in this hypothetical situation, if I had to assume the responsibilities of President, what I would be. And as I have said, age alone, although I can tell you, after the experiences of these last few week in the campaign, I've added ten years to my age, age alone is not the only qualification. You've got to look at experience, and you've got to look at accomplishments, and can you make a difference. Have I made a difference in the United States Senate where I've served for eight years? Yes, I have. Have I made a difference in the Congress that I've served for 12 years? Yes, I have. As I said before, looking at the issue of qualifications - and I am delighted that it comes up, because on the three most important challenges facing America, arms control and national security, jobs and education and budget deficit, I have more experience and accomplishments than does the Governor of Massachusetts. I have been in the Congress and I've worked on these issues. And believe me, when you look at arms control and trying to deal with the Soviet Union, you cannot come at it from a naive position. You have to understand the Soviet Union. You have to understand how they will respond. Sitting on that Senate Armed Services Committee for eight years has given me the experience to deal with the Soviet Union and how we can move forward. That is just one of the troubling issues that's going to be facing this nation, and I'm prepared. WOODRUFF: Senator Bentsen. BENTSEN: Well, I can't leave something on the table that he's charged me with, and so let's get to that one. When you talk about the breakfast club, as you know, that was perfectly legal. And I formed it, and I closed it down almost immediately because I thought the perception was bad. But it's the same law - it's the same law - that lets you invite high priced lobbyists down to Williamsburg. And bring them down there and entertain them playing golf, playing tennis, and bringing Republican Senators down there, to have exchanged for that contributions to their campaign. It's the same kind of law that lets you have honorariums - and you've collected over a quarter of a million dollars of honorariums now, speaking to various interest groups. And there's no control over what you do with that money. You can spend it on anything you want to. You can spent it on golf club dues, if you want to do that. (Applause) BENTSEN: Now, that's what I've seen you do in this Administration. And that's why we need campaign reform laws, and why I support them. And you in turn have voted against them time and time again. (Applause) WOODRUFF: John Margolis, question for Senator Quayle. MARGOLIS: Senator Quayle, in recent years the Reagan administration has scaled back the activities of the Occupational Safety and Health Administration, prompted in part by Vice President Bush's Task Force on Regulatory Relief. The budget for the agency has been cut by 20 percent and the number of inspections and manufacturing plants has been reduced by 33 percent. This has had a special effect in this area where many people work in the meat packing industry, which has a far higher rate of serious injuries than almost any other injury, a rate which appears to have been rising, although we're not really sure, because some of the largest companies have allegedly falsifying their reports. Would you acknowledge to the hundreds of injured and maimed people Nebraska, Iowa and elsewhere in the Midwest that in this case deregulation may have gone too far and the government should reassert itself in protecting workers' rights. QUAYLE: The premise of your question, John, is that somehow this administration has been lax in enforcement of the OSHA regulations. And I disagree with that. And I'll tell you why. If you want to ask some business people that I talk to periodically, they complain about the tough enforcement of this administration and, furthermore, let me tell you this for the record, when we have found violations in this administration, there has not only been tough enforcement, but there have been the most severe penalties - the largest penalties in the history of the Department of Labor - have been levied when these violations have been found. There is a commitment and there will always be a commitment to the safety of our working men and women. They deserve it and we're committed to them. Now, the broader question goes to the whole issue of deregulation and has deregulation worked or has deregulation not worked. In my judgment deregulation has worked. We have a deregulated economy and we have produced through low taxes, not high taxes, through deregulation - the spirit of entrepreneurship, the individual going out and starting a business, the businessman or women willing to go out and risk their investments to start up a business and hire people. We have produced 17 million jobs in this country since 1982. Deregulation as a form of political philosophy is a good philosophy. It's one that our opponents disagree with. They want a centralized government. But we believe in the market, we believe in the people and yes, there's a role of government and the role of government is to make sure that those safety - and health and the welfare of the people is taken care of. And we'll continue to do that. WOODRUFF: Senator Bentsen? BENTSEN: Well, I think you see once again a piece of Democratic legislation that's been passed to try protect the working men and women of America. And then you've seen an administration that came in and really didn't have it's heart in that kind of an enforcement. A good example of that is the environmental protection laws that we were talking about a moment ago. This administration came in and put in a James Watt, an Ann Gorsuch, now that's the Bonnie and Clyde, really, of environmental protection. And that's why it's important that you have people that truly believe and trying to represent the working men and women of America. Most employers do a good job of that, but some of them put their profits before people and that's why you have to have OSHA and that's why you have to have tough and good and fair enforcement of it and that's what a Democratic administration would do to help make this working place a safer and better place to be employed. WOODRUFF: John Margolis, another question for Senator Bentsen. MARGOLIS: Senator Bentsen, since you have been in the Senate, the government has spent increasing amounts of money in an effort to protect the family farmer. Though most of the subsidies seem to go - do go to the largest and richest farmers who presumably need it least, while it's the smaller farmers who are often forced to sell out, sometimes to their large farmer neighbor who's gotten more subsidies to begin with. Despite the fact that I believe you, sir, are a rather large farmer, yourself, do you believe that it's time to uncouple the subsidy formula from the amount of land the farmer has and target Federal money to the small and medium size farmer? BENTSEN: Well, I've supported that. I voted for the 50,000 limitation to get away from the million dollar contributions to farmer. You know, of the four that are on this ticket, I'm the only on that was born and reared on a farm and still involved in farming, so I think I understand their concerns and their problems. Now, I feel very strongly that we ought to be doing more for the American farmer and what we've seen under this administration is neglect of that farmer. We've seen them drive 220,000 farmers off the farm. They seem to think the answer is move them to town, but we ought not to be doing that. What you have seen them do is cut the farm assistance for the rural areas by over 50 percent. We're seeing rural hospitals close all over the country because of this kind of an administration. We've seen an administration that has lost much of our market abroad, because they have not had a trade policy. We saw our market loss by some 40 percent. And that's one of the reasons that we've seen the cost of the farm program, which was only about two and a half billion dollars when they took office, now go to about $25 billion. Now, we can bring that kind of a cost down and get more to market prices if we'll have a good trade policy. I was in January visiting with Mr. Takeshita, the new Prime Minister of Japan. I said, "You're paying five times as much for beef as we pay for our in country - pay for it in our country, six times as much for rice. You have a $60 billion trade surplus with us. You could improve the standard of living of your people. You're spending 27 percent of your disposable income. We spend 14 or 15 percent." "When you have that kind of barrier up against us, that's not free and fair trade and we don't believe that should continue." We would be pushing very hard to open up those markets and stand up for the American farmer and see that we recapture those foreign markets and I think we can do it with the Dukakis-Bentsen administration. WOODRUFF: Senator Quayle? QUAYLE: Senator Bentsen talks about recapturing the foreign markets. Well, I'll tell you one way that we're not going to recapture the foreign markets and that is if, in fact, we have another Jimmy Carter grain embargo. (Equal amounts of cheering and booing) Jimmy Carter - Jimmy Carter grain embargo set the American farmer back. You know what the farmer's interested in? Net farm income. Every one percent in increase in interest rates, a billion dollars out of the farmer's pocket. Net farm income, increased inflation, another billion dollars. Another thing that a farmer is not interested in and that's supply management that the Democratic platform talks about. But the Governor of Massachusetts, he has a farm program. He went to the farmers in the Midwest and told them not to grow corn, not to grow soybeans, but to grow Belgium [sic] endive. That's what his - that's what he and his Harvard buddies think of the American farmer, grow Belgium endive. To come in and to tell our farmers not to grow corn, not to grow soybeans, that's the kind of farm policy you'll get under a Dukakis administration and one I think the American farmer rightfully will reject. WOODRUFF: Tom Brokaw, a question for Senator Bentsen. BROKAW: Senator Bentsen, you were a businessman before you entered the U.S. Senate. Let me offer you an inventory if I may: Lower interest rates, lower unemployment, lower inflation and an arms control deal with the Soviet Union. Now two guys come through your door at your business and say, "We'd like you to change," without offering a lot of specifics. Why would you accept their deal? BENTSEN: You know, if you let me write $200 billion worth of hot checks every year, I could give you an illusion of prosperity, too. (Laughter and applause) This is an administration that has more than doubled the national debt, and they've done that in less than eight years. They have taken this country from the No. 1 lender nation in the world to the No. 1 debtor nation in the world. And the interest on that debt next year, on this Reagan-Bush debt of our nation, is going to be $640 for every man, woman, and child in America because of this kind of a credit-card mentality. So we go out and we try to sell our securities every week, and hope that the foreigners will buy them. And they do buy them. But every time they do, we lose some of our economic independence for the future. Now they've turned around and they've bought 10 percent of the manufacturing base of this country. They bought 20 percent of the banks. They own 46 percent of the commercial real estate in Los Angeles. They are buying America on the cheap. Now, when we have other countries that can't manage their economy down in Central and South America, we send down the American ambassador, we send down the International Monetary Fund, and we tell them what they can buy and what they can sell and how to run their economies. The ultimate irony would be to have that happen to us, because foreigners finally quit buying our securities. So what we need in this country is someone like Mike Dukakis, who gave ten balanced budgets in a row there, and was able to do that, meet that kind of a commitment, set those tough priorities. We need an administration that will turn this trade policy around and open up those markets, stand tough with our trading partners to help keep the jobs at home and send the products abroad. WOODRUFF: Senator Quayle. QUAYLE: Senator Bentsen talks about running up the debt. Well, the governor of Massachusetts has run up more debt than all the governors in the history of Massachusetts combined, going back to the days of the Pilgrims. I don't believe that that's the kind of policy that we want. The question went to the heart of the matter, Tom. You asked the question why would we change. Well, we have changed since 1980. We've got interest rates down, we've got inflation down, people are working again, America is held in respect once again around the world. But we are going to build on that change. And as we made those positive changes of lower interest rates, lower rate of inflation, the governor of Massachusetts fought us every step of the way. We are proud of the record of accomplishment and the opportunities and the hope for millions of Americans. Hope and opportunity of these Americans is because of the policies that we have had for the last eight years, and we want to build on that and change it for even the better. WOODRUFF: Tom, a question for Senator Quayle. BROKAW: Senator Quayle, as you mentioned here tonight, you actively supported the invasion of Grenada, which was a military operation to rescue some American medical students and to rescue an island from a Marxist takeover. If military force was necessary in that endeavor, why not use the military to go after the South American drug cartels and after General Noriega, for that matter, in a surgical strike, since drugs in the minds of most Americans pose a far greater danger to many more people? (Scattered applause) QUAYLE: You are absolutely right that the drug problem is the No. 1 issue. BROKAW: But would you please address the military aspect of it. QUAYLE: I will address the military aspect, if I may respond. The military aspect of the drug problem is being addressed. As a matter of fact, we are using the Department of Defense in a coordinated effort, in reconnaissance. But I don't believe that we are going to turn the Department of Defense into a police organization. We are using our military assets in a prudent way to deal with interdiction, and we've made some success in this area. Seventy tons of cocaine have been stopped. But, you know, when you look at the drug problem - and it is a tremendous problem, and there are no easy solutions to it - it's a complicated problem, and it's heading up the effort to try to create a drug-free America, which is a challenge and a goal of all of us. Not only will we utilize national defense and the Department of Defense, but we've got to get on the demand side of the ledger; we've got to get to education. And education ought to begin at home, and it ought to be reinforced in our schools. And there's another thing that will be more important than the premise of this question on a hypothetical of using troops. We will use the military assets, we will use military assets - but we need to focus on another part of this problem, and that problem is law enforcement. And here is where we have a major disagreement with the governor of Massachusetts. He is opposed to the death penalty for drug kingpins. We believe people convicted of that crime deserve the death penalty, as does the legislation that's in the Congress that is supported by a bipartisan, including many Democrats of his party. He also was opposed to mandatory drug sentencing for drug dealers in the state of Massachusetts. You cannot have a war on drugs, you cannot be tough on drugs and weak on crime. WOODRUFF: Senator Bentsen. BENTSEN: It's interesting to see that the Senator from Indiana, when we had a resolution on the floor of the United States Senate sponsored by Senator Dole, that this government would make no deal with Noriega - that the Senator from Indiana was one of the dozen senators that voted against it. It's also interesting to see that one of his campaign managers that's trying to help him with his image was also hired by Noriega to help him with his image in Panama. (Shouts and applause) What we have seen under this administration - we have seen them using eight cabinet officers, twenty-eight different agencies, all fighting over turf - and that is one thing we would correct under a Dukakis-Bentsen administration. We would put one person in charge in the war against drugs, and we would commit the resources to get that job done. Now, Mike Dukakis has been able to do that type of thing in the state of Massachusetts by cutting the drug use in the high schools while it's going up around the rest of the country, by putting in a drug educational program that the Drug Enforcement Agency said was a model to the country. We would be doing that around the rest of the country. That's a positive attack against drugs. WOODRUFF: Brit Hume, a question for Senator Quayle. HUME: Senator, I want to take you back to the question that I asked you earlier about what would happen if you were to take over in an emergency, and what you would do first and why. You said you would say a prayer, and you said something about a meeting. What would you do next? (Laughter) QUAYLE: I don't believe that it's proper for me to get into the specifics of a hypothetical situation like that. The situation is that if I was called upon to serve as the president of this country, or the responsibilities of the president of this country, would I be capable and qualified to do that? And I've tried to list the qualifications of twelve years in the United States Congress. I have served in the Congress for twelve years; I have served in the Congress and served eight years on the Senate Armed Services Committee. I have traveled a number of times - I've been to Geneva many times to meet with our negotiators as we were hammering out the INF Treaty; I've met with the western political leaders - Margaret Thatcher, Chancellor Kohl - I know them, they know me. I know what it takes to lead this country forward. And if that situation arises, yes, I will be prepared, and I will be prepared to lead this country, if that happens. (Applause) WOODRUFF: Senator Bentsen. BENTSEN: Once again I think what we are looking at here is someone that can step in at the presidency level at the moment, if that tragedy would occur. And if that's the case, again you have to look at maturity of judgment, and you have to look at breadth of experience. You have to see what kind of leadership roles that person has played in his life before that crisis struck him. And if you do that type of thing, then you arrive at a judgment that I think would be a wise one. And I hope that would mean that you would say we are going to vote for Mike Dukakis and Lloyd Bentsen. (Applause) WOODRUFF: Brit, question for Senator Bentsen. HUME: Senator, I want to take you back if I can to the celebrated Breakfast Club, when it was first revealed that you had a plan to have people pay $10,000 a plate to have breakfast with you. You handled it with disarming, not to say charming, candor, you said it was a mistake, and you disbanded it and called the whole idea off. And you were widely praised for having handled it deftly. The question I have is: If The Washington Post had not broken that story and other media picked up on it, what can you tell us tonight as to why we should not believe that you would still be having those breakfasts to this day? (Scattered laughter) BENTSEN: I really must say, Brit, I don't make many mistakes, but that one was a real doozy. And I agree with that. And, as you know, I immediately disbanded it. It was perfectly legal. And you have all kinds of such clubs on the Hill - and you know that. But I still believe that the better way to go is to have a campaign reform law that takes care of that kind of a situation. Even though it's legal, the perception is bad. So I would push very strong to see that we reform the entire situation. I'd work for that end, and that's what my friend from Indiana has opposed repeatedly, vote after vote. WOODRUFF: Senator Quayle. QUAYLE: He disbanded the club, but he's still got the money. He is the number one - he is the number one receiver of political action committee money. Now, Senator Bentsen has talked about reform. Well, let me tell you about the reform that we're pushing. Let's eliminate political action committees, the special interest money. There's legislation before the Congress to do that. That way, we won't have to worry about breakfast clubs, or who's the number one PAC raiser. We can go back and get the contributions from the working men and women and the individuals of America. We can also strengthen our two party system - and it needs strengthening - and rely more on the political parties than we have in the past. That's the kind of campaign reform that I'm for, and I hope the Senator will join me. WOODRUFF: John Margolis, a question for Senator Bentsen. MARGOLIS: Senator, we've all just finished - most America has just finished one of the hottest summers it can remember. And apparently this year will be the fifth out of the last nine that are among the hottest on record. No one knows, but most scientists think, that something we're doing, human beings are doing, are exacerbating this problem, and that this could, in a couple of generations, threaten our descendants comfort and health and perhaps even their existence. As Vice President what would you urge our government to do to deal with this problem? And specifically as a Texan, could you support a substantial reduction in the use of fossil fuels which might be necessary down the road? BENTSEN: Well, I think what you can do in that one, and which would be very helpful, is to use a lot more natural gas, which burns a lot cleaner. And what Mike Dukakis has said is that he'll try to break down those regulatory roadblocks that you have in the regulatory agency that denies much of the passage of that natural gas to the northeast, a way, in turn, can fight against acid rain which is another threat, because it's sterilizing our lakes, it's killing our fish. And it's interesting to me to see in the resume of Senator Quayle that he brags on the fact that he's been able to fight the acid rain legislation. I don't think that that's a proper objective in trying to clean up this environment. But the greenhouse effect is one that has to be a threat to all of us, and we have to look for alternative sources of fuel. And I've supported that very strongly. The Department of Energy is one that has cut back substantially on the study of those alternative sources of fuels. We can use other things that'll help the farmer. We can convert corn to ethanol, and I would push for that very strong. So absolutely. I'll do those things that are necessary to put the environment of our country number one. Because if we don't protect that, we'll destroy the future of our children. And we must be committed to trying - to clean up the water, clean up the air, and do everything we can, not only from a research standpoint, but also in the applied legislation to see that that's carried out. WOODRUFF: Senator Quayle? QUAYLE: Vice President George Bush has said that he will take on the environmental problem. He has said further that he will deal with the acid rain legislation and reduce millions of tons of the S02 content. That legislation won't get through the Congress this year. But it will get through in a George Bush Administration, a George Bush Administration that is committed to the environment. Now the greenhouse effect is an important environmental issue. It is important for us to get the data in, to see what alternatives we might have to the fossil fuels, and make sure we know what we're doing. And there are some explorations and things that we can consider in this area. The drought highlighted the problem that we have, and therefore, we need to get on with it, and in a George Bush Administration, you can bet that we will. WOODRUFF: John, a question for Senator Quayle. MARGOLIS: Senator, as Vice President your most important contribution would be the advice you gave the President. One of the most troubling facts that's going to face the new Administration is the fact that the United States has now become the world's largest debtor nation. In 1987 foreigners underwrote our debts to the tune of about $138 billion. Last week a top official of the Japanese Economic Planning Agency bragged that Japan now is in a position to influence the value of the dollar, of our interest rates, and even our stock prices. And he warned that one day maybe they'd do just that. If you were Vice President of the United States and Japan did that, what would you tell the President to do? QUAYLE: When you look at dealing with this total problem - it's not just with the Japanese, but the underlying question on this total world debt problem - you have got to see, why are we a debtor, and what is attracting the foreign investment into our country today, whether it's Japanese or others. I would rather have people come over here and to make investments in this country, rather than going elsewhere. Because by coming over here, and making investments in this country, we are seeing jobs. Do you realize that today we are producing Hondas and exporting Hondas to Japan? We are the envy of the world. The United States - (Laughter) QUAYLE: Some of Senator Bentsen's supporters laugh at that. They laugh at that because they don't believe that the United States of America is the envy of the world. Well, I can tell you, the American people think the United States of America is the envy of the world. (Applause) WOODRUFF: Senator - oh, I'm sorry, go ahead. QUAYLE: We are the greatest nation in this world, and the greatest economic power. Now, there's been some talk in Congress about forgiveness of debt. Forgiveness of debt is wrong. Forgiveness of international debt would be counterproductive. And I would like to see those that talk about forgiving debt, Senator Bentsen, go out and talk about a farmer that's in debt that doesn't have his forgiven. That's not the kind of policy George Bush will have. WOODRUFF: Senator Bentsen. BENTSEN: Well, I've told you what I'd do about trade and trying to help turn that situation around. But what we also should do is get them to give us more burden sharing when it comes to national defense. We have a situation today where, on a per capita basis, people in Western Europe are spending about one-third as much as we are in our country. And then when you go to Japan, where we're spending 6-1/2 percent on defense of the democracies, they're spending one percent. I met with some of the Japanese business leaders, talking to them about it. And I said, you know, we have 50,000 troops here in Japan, protecting the democracies of Asia. And it costs $3.5 billion a year. You're the number two economic power in the world. You ought to measure up to that responsibility and carry some of that cost. I said, if we were not doing what we're doing, we'd have a big budget surplus. And I said, you'd have chaos, because you get 55 percent of your oil from the Persian Gulf, and you wouldn't have the U.S. Navy down there to take care of that. Now, the Senator from Indiana, when we passed a resolution in the United States Senate to ask for burden sharing on that cost to keep those sea lanes open from the Japanese, he votes against that. I don't understand that. WOODRUFF: Tom Brokaw, a question for Senator Quayle. BROKAW: Senator Quayle, I don't mean to beat this drum until it has no more sound in it. But to follow up on Brit Hume's question, when you said that it was a hypothetical situation, it is, sir, after all, the reason that we're here tonight, because you are running not just for Vice President - (Applause) BROKAW: And if you cite the experience that you had in Congress, surely you must have some plan in mind about what you would do if it fell to you to become President of the United States, as it has to so many Vice Presidents just in the last 25 years or so. QUAYLE: Let me try to answer the question one more time. I think this is the fourth time that I've had this question. BROKAW: The third time. QUAYLE: Three times that I've had this question - and I will try to answer it again for you, as clearly as I can, because the question you are asking is what kind of qualifications does Dan Quayle have to be president, what kind of qualifications do I have and what would I do in this kind of a situation. And what would I do in this situation? I would make sure that the people in the cabinet and the people that are advisors to the president are called in, and I would talk to them, and I will work with them. And I will know them on a firsthand basis, because as vice president I will sit on the National Security Council. And I will know them on a firsthand basis, because I'm going to be coordinating the drug effort. I will know them on a firsthand basis because Vice President George Bush is going to recreate the Space Council, and I will be in charge of that. I will have day-to-day activities with all the people in government. And then, if that unfortunate situation happens - if that situation, which would be very tragic, happens, I will be prepared to carry out the responsibilities of the presidency of the United States of America. And I will be prepared to do that. I will be prepared not only because of my service in the Congress, but because of my ability to communicate and to lead. It is not just age; it's accomplishments, it's experience. I have far more experience than many others that sought the office of vice president of this country. I have as much experience in the Congress as Jack Kennedy did when he sought the presidency. I will be prepared to deal with the people in the Bush administration, if that unfortunate event would ever occur. WOODRUFF: Senator Bentsen. BENTSEN: Senator, I served with Jack Kennedy, I knew Jack Kennedy, Jack Kennedy was a friend of mine. Senator, you are no Jack Kennedy. (Prolonged shouts and applause) What has to be done in a situation like that is to call in the - WOODRUFF: Please, please, once again you are only taking time away from your own candidate. QUAYLE: That was really uncalled for, Senator. (Shouts and applause) BENTSEN: You are the one that was making the comparison, Senator - and I'm one who knew him well. And frankly I think you are so far apart in the objectives you choose for your country that I did not think the comparison was well-taken. WOODRUFF: Tom, a question for Senator Bentsen. BROKAW: Since you seem to be taking no hostages on the stage, let me ask you a question - (Laughter) - about the American hostages, nine, still in brutal captivity in the Middle East. Senator Bentsen, you have been critical of the Iran-contra affair, but tell me, does the Dukakis-Bentsen ticket have any realistic plan for getting the American hostages being held in the Middle East released in any due time? BENTSEN: Tom, that's one of the toughest problems that any chief executive will face, because you can't help but have sympathy for that family, and for those hostages in the cells. But the one thing we ought to know by now is that you can't go out and make secret deals with the Ayatollah, you can't trade arms for hostages. When you try to do that there is no question but what you just encourage more taking of hostages. And that's been the result by this dumb idea that was cooked up in the White House basement. And I want to tell you that George Bush, attending seventeen of those meetings, and having no record of what he said - if Lloyd Bentsen was in those meetings, you would certainly hear from him and no one would be asking: Where is Lloyd? (Shouts and applause) Because I would be saying: That's a dumb idea, and now let's put an end to it. And I would speak up on that type of thing. So all you can do in that is to continue to push, use every bit of diplomatic pressure you can, what you can do in the way of economic pressure in addition to that. And that's what you would strive to do to have a successful release finally of those hostages. But not to encourage more taking of hostages. WOODRUFF: Senator Quayle. QUAYLE: There's no doubt about it that arms for hostages is wrong, and it will never be repeated - we learn by our mistakes. But there have been a number of successes in foreign policy in this administration. But the question goes to a very difficult one: How do you do it? No one has the answer. If they did, we would certainly do it. But we will keep trying, we'll keep the doors open, and hopefully some day Iran and others who control those hostages will want to return to civilized international community. And they can do that, starting now, by releasing those hostages that are held illegally. WOODRUFF: Brit Hume, a question for Senator Bentsen. BENTSEN: Senator, much of the Dukakis and Bentsen campaign of late has been devoted to the notion that Senator Quayle isn't ready for the vice presidency and perhaps the presidency, and certainly nothing that you have said here tonight suggests that you think otherwise. I wonder if you think it's really fair for you to advance that view in light of the fact that you ran for the presidency, not the vice-presidency, in 1976 having not yet completed one full term in the Senate and having previously served three terms in the House almost a quarter of a century earlier, when in fact your time in Washington was about equal to what he has now. BENTSEN: Well, I think what you have to look at is the record of a man who has served his country - (Shouts, laughter) - served his country in war, headed up a squadron in combat, a man who built a business, knew what it was to meet a payroll and create jobs, and then serve in the United States Senate; and one who has been able to bring about some of the kinds of legislation that I've been able to bring about in my service there. I must say I didn't do a very good job of running for the presidency, and I'm well aware of that. But what we are looking at today is trying to judge once again the breadth of experience and the maturity of someone taking on this kind of a task. That is the judgment that has to be exercised by the people of America. It's a presidential decision that you are facing, and a very important one, because we are talking about who is going to lead this country into its future. And you can't have a more important responsibility than that one. WOODRUFF: Senator Quayle. QUAYLE: When you look at qualifications, you look at accomplishments as well as experience. And one of the accomplishments I'm proudest of is the authorship of the Job Training Partnership Act that has trained and educated and employed over three million young people and adults that are economically disadvantaged. And we did it in a way that we got the private sector to involve itself with the public sector on private industry councils throughout America that serve over the service delivery areas. We have 51 percent of that private industry council that are businessmen and women; we have members of unions; we have community-based organizations; we have education leaders. And what we have been able to do is establish a program that is working, that is putting people back to work. That is an accomplishment, and that is an accomplishment that I will take with me into the White House. WOODRUFF: Brit, a question for Senator Quayle. HUME: Senator, I want to ask you a question that may be a little off the subject of politics, but which is aimed to get more at the question of what sort of person you are. I would hope that, Senator Bentsen, if you choose to, you might choose to answer the same question in your rebuttal time. Senator, can you identify any work of literature or art or even of film that you have seen or read or experienced in any way in the last two years that has had a particularly strong effect on you, and tell us why. QUAYLE: In the last six months, I think there are three very important books that I read that have had an impact. The three books are, one, Richard Nixon's Victory in 1999, Richard Lugar's - Senator Richard Lugar's - Letters to the Next President, Bob Massey's Nicholas and Alexandra, which deals with the fall of the Russian empire and the coming of Leninism in 1917. Those three books, which I read over the last spring vacation and early summer, had a very definite impact, because what former President Nixon and Senator Richard Lugar were talking about was a foreign policy as we move toward the 21st century. And the historical book of the downfall of the czar and the coming of Leninism, combining those three books together, gave me a better appreciation of the challenges that we have ahead of us. In Senator Lugar's book, he talks about the advancement of human rights around the world; he talked about his leadership effort in the Philippines and South Africa, where we now see human rights advancement on the Reagan agenda. Former President Nixon talked about what we are going to do after detente and arms control, and how we are going to pursue new arms control with the Soviet Union; he talked a little bit about how we deal with the Soviet Union - and this is one of the differences between George Bush and Michael Dukakis, because George Bush understands that to deal with the Soviet Union and to get progress you must deal from a position of strength. And the governor of Massachusetts doesn't understand that. I understand it. And a George Bush administration will pursue that policy. WOODRUFF: Senator Bentsen. BENTSEN: Well, I think reading "Winds of War" and "Guns of August" back to back - I think that really shows you how we make the same mistakes too often, over and over again. And it seems to me that the Senator from Indiana is beginning to do that one. As I look toward our progress that's been made toward disarmament and cutting back on nuclear weapons and see what Ronald Reagan has been able to do with the INF treaty - and I think he deserves great credit with that one. I see a situation where the Senator from Indiana has now jumped off the reservation, when we talk about building on what Ronald Reagan has done and opposes what Ronald Reagan wants to do, the Joint Chiefs of Staff and the Secretary of Defense and says let's go slow on further disarmament in trying to get the next treaty. I think that's a mistake. I think that you have to deal with the Russians from strength and we have to understand that you have to have a strong modernized nuclear deterrent, but I think we can make substantial progress and we ought to take advantage. I think he's arrived at a very dangerous judgment in the question of war and peace and it concerns me very much. Because I saw him also try to sabotage the INF treaty when it was on the Floor of the United States Senate with what he was doing there. He's listening once again to the winds of the radical right. WOODRUFF: Senator. BENTSEN: My light was still on, Judy. WOODRUFF: John Margolis, a question for Senator Quayle. MARGOLIS: Senator Quayle, I want to go back to the matter of qualifications, which I think for most people is more than just your - BENTSEN: John, we can't hear you. MARGOLIS: Can you hear now? QUAYLE: I can hear you. [Laughter.] MARGOLIS: I want to go back to the question of qualifications, which I think for most people is more than just how long you've been in the Senate and how long you've been in public life. There's also a question of candor and of consistency. And several of the things you've said, both here and earlier, I think have raised some reasonable questions. Each of them alone might seem rather trivial, but I think together they create a pattern that needs to be asked. You've talked a few times today about the Job Training Partnership Act, which you authored. In fact, I believe you co-authored it with another Senator, whom you almost never name. Earlier in the campaign when you were asked why you got a very - a desk job in the National Guard after being trained as a welder, you said at the time you had a very strong background in journalism, which at that time was summer jobs at your family-owned newspaper, which you have not been very forthcoming about what they were. As you have not been very forthcoming about your college record. Now, I have to say - at least the males on this panel have earlier agreed that your record was probably comparable to ours, but - [Laughter.] MARGOLIS: Nonetheless, these examples of sort of overstatement and exaggeration and not being forthcoming - this what has led a lot of people to question this part of your qualifications, not your experience, but your character. Would you like to set some of these things straight now as to what you did in your summer jobs in college, what your grades were like and would you like to identify your co-sponsor of the Job Training Partnership Act? QUAYLE: All in two minutes? MARGOLIS: Sure. QUAYLE: Let me start with the underlying premise, that somehow I haven't been straightforward. And I have. And let's go to the - right to the very first question - the Job Training Partnership Act. I was the author of that. The co-author in the United States Senate was Senator Kennedy. I was the Chairman of the Employment and Productivity Subcommittee. Chairmen of the committee write that legislation. Chairmen of the committee write the legislation and then they go out and get co-sponsorship. And when you are the chairman of the committee and you sit down and you write the legislation, you are the author of that. And I'm proud to have been the author of that. Because you know what we had, we had a CETA program that spent $50 billion from about 1973 through 1982 and when we concluded that program - when we concluded that program, unemployment was higher than when it began. It was a program that didn't work and the Job Training Partnership Act does work. Now, the issue of releasing all the - my grades - I am - and I stand before you tonight - as the most investigated person ever to seek public office. (Applause) QUAYLE: Thousands of journalists have asked every professor I've had, all my teachers and they know - and I have never professed to be anything but an average student. I have never said I was anything more than that, but it's not whether you're an average study, it's what are you going to do with your life. And what have I - going to do with my life. I have committed it to public service since I was 29 years of age - elected to the House of Representatives. Elected to the United States Senate when I was 33. I now have the opportunity at 41 to seek the office of the Vice Presidency. WOODRUFF: Senator Bentsen? BENTSEN: I have absolutely no quarrel with Senator Quayle's military record. But I do strongly disagree with him on some of the issues. You make great patriotic speeches and I enjoy them, but I don't understand your vote on veterans issues. Senator Quayle has one of the worst voting records in the United States Senate on veterans issues. And one of them that particularly bothers me, sponsoring legislation to put a tax on combat pay and disability pay for veterans, for fighting men and women of America. Tax on their disability pay when they're lying there in the hospital, people who have sacrificed for our country. I think you ought to explain that to the people of America and you ought to explain it tonight. WOODRUFF: John, a question for Senator Bentsen. MARGOLIS: Senator, you're Chairman of the Senate Finance Committee and you're generally considered rather an orthodox conservative on fiscal matters, meaning someone who would be very concerned about the budget deficit. With everybody in politics afraid even to mention taxes, more social security cuts or even very much restrain in defense sending, would you now list a few specific programs which would reduce or eliminate - which you would reduce or eliminate, to cut the deficit by about $50 billion, the deficit which is expected to be about $135 billion this Fiscal Year. BENTSEN: One of them that I'd work on - and I do this as a farmer - I try to turn the situation around where we have seen the subsidy payments go from two and a half billion to ten times that under this administration. And the way I would accomplish that--was with a tough trade policy, opening up those markets, getting those prices back up to market prices. We can do that if we have an aggressive trade policy for our country, if we make trade a number one priority and not trade it off for some foreign policy objective at the moment. That means we have to stand up for the American farmers and that cuts back on the regulation on American farmers. That's a positive way to accomplish that. In addition to that, we do some of the things that I think have to be done insofar as doing a better job of procurement, particularly when we're talking about some of our military things that we should buy. I know that I fought very hard to put in an independent inspector general for the Defense Department, that the Senator from Indiana opposed me on that. But we were finally able to put that into effect and we saved over a quarter of a billion dollars this year, almost enough to buy a squadron of 716s. Those are the kids of things that I'd work on. One of the things I learned in business is that you can expect what you inspect. So, we'd be a - doing a much tougher job of auditing, to try to get rid of some of these kickbacks to consultants on military contracts, to be much more aggressive on that. In addition, those types of things would bring the interest rate down. I'd try to turn this trade deficit around and that too would help us and help us very substantially. And I'd get rid of some things like these planes that - are going to have - that the administration wants that'll fly from New York to Tokyo and take those investment bankers over there in four hours. I don't think we can afford a piece of technological elegance like that. I'd strike that sort of thing from the ticket. I don't know how many people have ridden the Concorde, not many, but I voted against it, said it would be a financial disaster and it's been just that. WOODRUFF: Senator. BENTSEN: So, those are the types of things that I would work on. WOODRUFF: Senator Quayle? QUAYLE: The way we're going to reduce this budget deficit, and it is a challenge to make sure that it is reduce, is first to stick to the Gramm-Rudman targets. The Gramm-Rudman targets have worked. We've reduced the Federal budget deficit $70 billion. Senator Bentsen voted against Gramm-Rudman, the very tool that has been used to bring the Federal budget deficit down. We're going to need all the tools possible to bring this Federal budget deficit down. We need the tools of a line item veto. A line item veto that 43 governors in this country have, but not the President of the United States. The President of the United States needs to have a line item veto. When Congress goes ahead and puts into appropriations bills unrequested and unnecessary spending, let the President put a line through that, send it back to the Congress and let the Congress vote on it again. Congress has to help out in reducing this budget deficit as much as the Executive Branch. WOODRUFF: Tom Brokaw, a last question for Senator Bentsen. BROKAW: Senator Bentsen, I'd like to ask you about your split personality during this election year. You're running on the ticket with Michael Dukakis, a man who is opposed to the death penalty, a man who is in favor of gun control, and at the same time you're running for the United States Senate in the state of Texas, where your position on many of those same issues is well known, and absolutely opposed to him. How do you explain to the people of Texas how you can be a social conservative on those cutting issues and still run with Michael Dukakis on the national ticket? BENTSEN: Michael Dukakis wasn't looking for a clone. I think it's part of the strength and the character of this land that he reaches out, and that he wants someone that will speak up - and that I'll do. I've seen many chief executives come into my office and say they're going over and tell the president of the United States off, they're going to pound the desk, and go into that office and turn to Jello. Now, I've dealt with many a president, and I don't hesitate for a minute to speak up. But when you're talking about something like the death penalty, where Michael Dukakis and I do disagree, what you really ought to get to is what's being done against crime, and what kind of progress he's been able to make. In the state of Massachusetts he has the homicide rate down to the lowest of any industrial state. It's substantially ahead of the national average. He's been able to do that with an educated program for the people of that state by adding some 1,500 new police officers; he's done it in turn by the leadership that I think he will bring to the ticket when he becomes president of the United States and fighting drugs. He's taken it down some four percent in the high schools of that state, while it's gone up about the rest of the nation. But you would seem him as president of the United States being very aggressive in this fight against crime, and having that kind of a successful result. And that's one of the reasons I'm delighted and proud to be on the ticket with him. Sure, we have some differences, but overall we have so many things we agree on. This situation of a trade policy, of cutting back on the deficit. Those are positive, plus things, and major issues facing our nation. WOODRUFF: Senator Quayle. QUAYLE: One of the things that they don't agree on is in the area of national defense. National defense, and how we're going to preserve the freedom in this country. Michael Dukakis is the most liberal national Democrat to seek the office of presidency since George McGovern. He is for - he is against the MX missile, the midgetman, cutting two aircraft carriers. He is opposed to many defense programs that are necessary to defend this country. That's why former Secretary of Defense and former Energy Secretary in the Carter administration, Jim Schlesinger, in an open letter to Time magazine asked Governor Dukakis, "are you viscerally anti-military?" Jim Schlesinger never got an answer. And the reason he did is because the governor of Massachusetts doesn't want to answer former Secretary Jim Schlesinger on that very important question. WOODRUFF: Tom, a last question for Senator Quayle. BROKA W: Senator Quayle, all of us in our lifetime encounter an experience that helps shapes our adult philosophy in some form or another. Could you describe for this audience tonight what experience you may have had, and how it shaped our political philosophy? QUAYLE: There are a lot of experiences that I've had that have shaped my adult philosophy, but the one that I keep coming back to time and time again - and I talk about it at commencement addresses, I talk about it in the high schools. I talk about it when I visit the job training centers. And it's the advice that my maternal grandmother, Martha Pulliam, who's 97 years old. We are a modern day, four generation family. The advice that she gave me when I was growing up is advice that I've given my children, and I've given to a number of children, number of people. And it's very simple. It's very common sense. And she says, "You can do anything you want to if you just set your mind to it, and go to work." Now, the Dukakis supporters sneer at that because it's common sense. (Laughter) QUAYLE: They sneer at common sense advice. Midwestern advice. Midwestern advice from a grandmother to a grandson. Important advice. Something that we ought to talk about, because if you want to, you can make a difference. You, America can make a difference. You're going to have that choice come this election. Everyone can make a difference if they want to. WOODRUFF: Senator Bentsen? BENTSEN: I think being born and reared on the Rio Grande, to have spent part of my life seeing some of the struggles that have taken place in one of the lowest per capita incomes in the United States. And that's one of the reasons I worked so hard to try to assist on education. And when I found that the bankers in that area found that they could not handle the loans because of some of the detail and the expense, couldn't make a profit on it, I went down there and helped form a nonprofit organization, to buy out those loans from them, and to manage them, and do it in a way where they'd continue to make those loans. Now they have. And they've educated more than 20,000 of those students, loaned out over a hundred million dollars. And it hasn't cost the taxpayers of this country one cent. That's one of the reasons I've worked so hard to bring better health care to the people, because what I've seen in the way of poverty down there in that area, and the lack of medical attention, and trying to see that that's turned around; why I've worked so hard on the welfare reform bill--to give them a chance to break these cycles of poverty, a chance for a step up in life. Judy, something's happened. My light's still on. WOODRUFF: Your light's not working. BENTSEN: All right. WOODRUFF: We're sorry about that if that's the case. Thank you. Thank you, Senator Bentsen. Thank you, Senator Quayle. We have now come to the end of the questions, and before I ask the candidates to make their closing remarks, on behalf of the Commission on Presidential Debates, I'd like to thank all of you for joining us. Senator Quayle, yours is the first closing statement. QUAYLE: Thank you. Tonight has been a very important evening. You have been able to see Dan Quayle as I really am, and how George Bush and I want to lead this country into the future. Thank you, America, for listening, and thank you for your fairness. Now you will have a choice to make on election day. You will have a choice of whether America is going to choose the road of Michael Dukakis or the road of George Bush as we march toward the 21st Century. The road of Michael Dukakis comes down to this: Bigger government, higher taxes. They've always believed in higher taxes; they always have, and they always will. Cuts in national defense. Back to the old economics of high interest rates, high inflation, and the old politics of high unemployment. Now the road of George Bush is the road to the future, and it comes down to this: An America second to none, with visions of greatness, economic expansion, tough laws, tough judges, strong values, respect for the flag and our institutions. George Bush will lead us to the 21st Century, a century that will be of hope and peace. Ronald Reagan and George Bush saved America from decline. We changed America. Michael Dukakis fought us every step of the way. It's not that they're not sympathetic; it's simply that they will take America backwards. George Bush has the experience, and with me, the future, a future committed to our family, a future committed to the freedom. Thank you, good night, and God bless you. (Applause) WOODRUFF: Senator Bentsen, your closing statement. BENTSEN: In just 34 days, America will elect new leadership for our country. It's a most important decision, because there's no bigger job than governing this great country of ours, and leading it into its future. Mike Dukakis and Lloyd Bentsen offer you experience, tempered, capable leadership, to meet those challenges of the future. Our opposition says lower your sights, rest on your laurels. Mike Dukakis and Lloyd Bentsen think America can do better, that America can't just coast into the future, clinging to the past. This race is too close. The competition is too tough, the stakes are too high. Michael Dukakis and Lloyd Bentsen think America must move into that future united in a commitment to make this country of ours the most powerful, the most prosperous nation in the world. As Americans, we honor our past, and we should. But our children are going to live in the future, and Mike Dukakis says the best of America is yet to come. But that won't happen. Taking care of our economy, just putting it on automatic pilot. It won't happen by accident. It's going to take leadership, and it's going to take courage. And the commitment, and a contribution by all of us to do that. I've worked for the betterment of our country, both in war and peace, as a bomber pilot, as one who has been a businessman, and a United States senator, working to make this nation the fairest and the strongest and the most powerful in the world. Help us bring America to a new era of greatness. The debate has been ours, but the decision is yours. God bless you. (Applause) WOODRUFF: Thank you both, thank you.
