# Presidential Debate at the University of Denver

**Date:** October 3, 2012
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-denver-colorado

---

Moderator Jim Lehrer. Good evening from the Magness Arena at the University of Denver, in Denver, Colorado. I'm Jim Lehrer of the PBS NewsHour, and I welcome you to the first of the 2012 Presidential Debates between President Barack Obama, the Democratic nominee, and former Massachusetts Governor Mitt Romney, the Republican nominee. This debate and the next three—two Presidential, one Vice Presidential—are sponsored by the Commission on Presidential Debates. Tonight's 90 minutes will be about domestic issues and will follow a format designed by the Commission. There will be six roughly 15-minute segments, with 2-minute answers for the first question, then open discussion for the remainder of each segment. Thousands of people offered suggestions on segment subjects or questions via the Internet and other means, but I made the final selections. And for the record, they were not submitted for approval to the Commission or the candidates. The segments, as I announced in advance, will be three on the economy and one each on health care, the role of Government, and governing, with an emphasis throughout on differences, specifics, and choices. Both candidates will also have 2-minute closing statements. The audience here in the hall has promised to remain silent. No cheers, applause, boos, hisses, among other noisy, distracting things so we may all concentrate on what the candidates have to say. There is a noise exception right now, though, as we welcome President Obama and Governor Romney. National Economy Mr. Lehrer. Gentlemen, welcome to you both. Let's start the economy, segment one, and let's begin with jobs. What are the major differences between the two of you about how you would go about creating new jobs? You have 2 minutes—each of you have 2 minutes to start. A coin toss has determined, Mr. President, you go first. The President. Well, thank you very much, Jim, for this opportunity. I want to thank Governor Romney, and the University of Denver for your hospitality. There are a lot of points I want to make tonight, but the most important one is that 20 years ago, I became the luckiest man on Earth because Michelle Obama agreed to marry me. [Laughter] And so I just want to wish, sweetie, you happy anniversary and let you know that a year from now we will not be celebrating it in front of 40 million people. [Laughter] Four years ago, we went through the worst financial crisis since the Great Depression. Millions of jobs were lost. The auto industry was on the brink of collapse. The financial system had frozen up. And because of the resilience and the determination of the American people, we've begun to fight our way back. Over the last 30 months, we've seen 5 million jobs in the private sector created. The auto industry has come roaring back, and housing has begun to rise. But we all know that we've still got a lot of work to do. And so the question here tonight is not where we've been, but where we're going. Governor Romney has a perspective that says if we cut taxes skewed towards the wealthy and roll back regulations that we'll be better off. I've got a different view. I think we've got to invest in education and training. I think it's important for us to develop new sources of energy here in America; that we change our Tax Code to make sure that we're helping small businesses and companies that are investing here in the United States; that we take some of the money that we're saving as we wind down two wars to rebuild America; and that we reduce our deficit in a balanced way that allows us to make these critical investments. Now, it ultimately is going to be up to the voters—to you—which path we should take. Are we going to double down on the top-down economic policies that helped to get us into this mess? Or do we embrace a new economic patriotism that says America does best when the middle class does best? And I'm looking forward to having that debate. Mr. Lehrer. Governor Romney, 2 minutes. Republican Presidential Nominee W. Mitt Romney. Thank you, Jim. It's an honor to be here with you, and I appreciate the chance to be with the President. I'm pleased to be at the University of Denver, I appreciate their welcome, and also the Presidential Commission on these debates. And congratulations to you, Mr. President, on your anniversary. I'm sure this was the most romantic place you could imagine, here with me. So I—[Laughter]—congratulations. This is obviously a very tender topic. I've had the occasion over the last couple of years of meeting people across the country. I was in Dayton, Ohio, and a woman grabbed my arm and she said, I've been out of work since May, can you help me? Ann yesterday was at a rally in Denver, and a woman came up to her with a baby in her arms and said, Ann, my husband has had four jobs in 3 years, part-time jobs. He's lost his most recent job, and we've now just lost our home. Can you help us? And the answer is, yes, we can help, but it's going to take a different path, not the one we've been on, not the one the President describes as a top-down, cut taxes for the rich; that's not what I'm going to do. My plan has five basic parts: One, get us energy independent, North American energy independent. That creates about 4 million jobs. Number two, open up more trade, particularly in Latin America; crack down on China if and when they cheat. Number three, make sure our people have the skills they need to succeed and the best schools in the world; we are far away from that now. Number four, get us to a balanced budget. Number five, champion small business. It's small business that creates the jobs in America. And over the last 4 years, small-businesspeople have decided that America may not be the place to open a new business, because new business startups are down to a 30-year low. I know what it takes to get small business growing again, to hire people. Now, I'm concerned that the path that we're on has just been unsuccessful. The President has a view very similar to the view he had when he ran 4 years ago: that a bigger Government spending more, taxing more, regulating more—if you will, trickle-down Government—would work. That's not the right answer for America. I'll restore the vitality that gets America working again. Thank you. Education/Tax Reform/Energy Mr. Lehrer. Mr. President, please respond directly to what the Governor just said about trickle down—his trickle-down approach, as he said yours is. The President. Well, let me talk specifically about what I think we need to do. First, we've got to improve our education system. And we've made enormous progress drawing on ideas both from Democrats and Republicans that are already starting to show gains in some of the toughest-to-deal-with schools. We've got a program called Race to the Top that has prompted reforms in 46 States around the country, raising standards, improving how we train teachers. So now I want to hire another hundred thousand new math and science teachers and create 2 million more slots in our community colleges so that people can get trained for the jobs that are out there right now. And I want to make sure that we keep tuition low for our young people. When it comes to our Tax Code, Governor Romney and I both agree that our corporate tax rate is too high. So I want to lower it, particularly for manufacturing—taking it down to 25 percent—but I also want to close those loopholes that are giving incentives for companies that are shipping jobs overseas. I want to provide tax breaks for companies that are investing here in the United States. On energy, Governor Romney and I, we both agree that we've got to boost American energy production. And oil and natural gas production are higher than they've been in years. But I also believe that we've got to look at the energy sources of the future, like wind and solar and biofuels, and make those investments. So all of this is possible. Now, in order for us to do it, we do have to close our deficit. And one of the things I'm sure we'll be discussing tonight is how do we deal with our Tax Code and how do we make sure that we are reducing spending in a responsible way, but also how do we have enough revenue to make those investments. And this is where there's a difference, because Governor Romney's central economic plan calls for a $5 trillion tax cut on top of the extension of the Bush tax cuts—that's another trillion dollars—and $2 trillion in additional military spending that the military hasn't asked for. That's $8 trillion. How we pay for that, reduce the deficit, and make the investments that we need to make without dumping those costs onto middle class Americans, I think, is one of the central questions of this campaign. National Economy/Job Training/Tax Reform/Energy Mr. Lehrer. Both of you have spoken about a lot of different things. And we're going to try to get through them in as specific a way as we possibly can. But first, Governor Romney, do you have a question that you'd like to ask the President directly about something he just said? Gov. Romney. Well, sure, I'd like to clear up the record and go through piece by piece. First of all, I don't have a $5 trillion tax cut. I don't have a tax cut of the scale that you're talking about. My view is that we ought to provide tax relief to people in the middle class. But I'm not going to reduce the share of taxes paid by high-income people. High-income people are doing just fine in this economy. They'll do fine whether you're President or I am. The people who are having a hard time right now are middle-income Americans. Under the President's policies, middle-income Americans have been buried. They're just being crushed. Middle-income Americans have seen their income come down by $4,300. This is a tax in and of itself. I'll call it the economy tax. It's been crushing. At the same time, gasoline prices have doubled under the President, electric rates are up, food prices are up, health care costs have gone up by $2,500 a family. Middle-income families are being crushed. And so the question is, how to get them going again? And I've described it. It's energy and trade, the right kind of training programs, balancing our budget, and helping small business. Those are the cornerstones of my plan. But the President mentioned a couple of other ideas I'll just note. First, education. I agree education is key, particularly the future of our economy. But our training programs right now, we've got 47 of them housed in the Federal Government, reporting to 8 different agencies. Overhead is overwhelming. We've got to get those dollars back to the States and go to the workers so they can create their own pathways to get in the training they need for jobs that will really help them. The second area, taxation. We agree we ought to bring the tax rates down, and I do: both for corporations and for individuals. But in order for us not to lose revenue and have the Government run out of money, I also lower deductions and credits and exemptions so that we keep taking in the same money when you also account for growth. The third area, energy. Energy is critical, and the President pointed out correctly that production of oil and gas in the U.S. is up, but not due to his policies. In spite of his policies. Mr. President, all of the increase in natural gas and oil has happened on private land, not on Government land. On Government land, your administration has cut the number of permits and licenses in half. If I'm President, I'll double them and also get the oil from offshore in Alaska, and I'll bring that pipeline in from Canada. And by the way, I like coal. I'm going to make sure we can continue to burn clean coal. People in the coal industry feel like it's getting crushed by your policies. I want to get America and North America energy independent so we can create those jobs. And finally, with regards to that tax cut, look, I'm not looking to cut massive taxes and to reduce the revenues going to the Government. My number-one principle is there will be no tax cut that adds to the deficit. I want to underline that: no tax cut that adds to the deficit. But I do want to reduce the burden paid—being paid by middle-income Americans. And to do that, that also means I cannot reduce the burden paid by high-income Americans. So any language to the contrary is simply not accurate. Tax Relief/Tax Reform Mr. Lehrer. Mr. President. The President. Well, I think—let's talk about taxes because I think it's instructive. Now, 4 years ago when I stood on this stage, I said that I would cut taxes for middle class families, and that's exactly what I did. We cut taxes for middle class families by about $3,600. And the reason is because I believe that we do best when the middle class is doing well. And by giving them those tax cuts, they had a little more money in their pocket, and so maybe they can buy a new car. They are certainly in a better position to weather the extraordinary recession that we went through. They can buy a computer for their kid who is going off to college, which means they're spending more money, businesses have more customers, businesses make more profits and then hire more workers. Now, Governor Romney's proposal that he has been promoting for 18 months calls for a $5 trillion tax cut on top of $2 trillion of additional spending for our military. And he is saying that he is going to pay for it by closing loopholes and deductions. The problem is that he's been asked over a hundred times how you would close those deductions and loopholes, and he hasn't been able to identify them. But I'm going to make an important point here, Jim. When you add up all the loopholes and deductions that upper income individuals can—are currently taking advantage of, you take those all away, you don't come close to paying for $5 trillion in tax cuts and $2 trillion in additional military spending. And that's why independent studies looking at this said the only way to meet Governor Romney's pledge of not reducing the deficit—or not adding to the deficit is by burdening middle class families; the average middle class family with children would pay about $2,000 more. Now, that's not my analysis. That's the analysis of economists who have looked at this. And that kind of top-down economics, where folks at the top are doing well, so the average person making 3 million bucks is getting a $250,000 tax break, while middle class families are burdened further, that's not what I believe is a recipe for economic growth. Mr. Lehrer. All right, what is the difference? Let's just stay on taxes for a—— Gov. Romney. But I get—right, right. Mr. Lehrer. Let's just stay on taxes for a moment here. Gov. Romney. Yes. Well, but virtually—— Mr. Lehrer. What is the difference? Gov. Romney. ——virtually everything he just said about my tax plan is inaccurate. Mr. Lehrer. All right. Go ahead. Gov. Romney. So if the tax plan he described were a tax plan I was asked to support, I'd say, absolutely not. I'm not looking for a $5 trillion tax cut. What I've said is, I won't put in place a tax cut that adds to the deficit. That's part one. So there's no economist can say Mitt Romney's tax plan adds $5 trillion if I say I will not add to the deficit with my tax plan. Number two, I will not reduce the share paid by high-income individuals. I know that you and your running mate keep saying that, and I know it's a popular thing to say with a lot of people, but it's just not the case. Look, I've got five boys. I'm used to people saying something that's not always true, but just keep on repeating it and ultimately hoping I'll believe it. [Laughter] But that is not the case, all right? I will not reduce the taxes paid by high-income Americans. And number three, I will not, under any circumstances, raise taxes on middle-income families. I will lower taxes on middle-income families. Now, you cite a study. There are six other studies that looked at the study you described and say it's completely wrong. I saw a study that came out today that said you're going to raise taxes by $3,000 to $4,000 on middle-income families. Throw all these studies out there. But let's get to the bottom line. That is, I want to bring down rates. I want to bring the rates down, at the same time, lower deductions and exemptions and credits and so forth, so we keep getting the revenue we need. And you think, well, then why lower the rates? And the reason is, because small business pays that individual rate. Fifty-four percent of America's workers work in businesses that are taxed not at the corporate tax rate, but at the individual tax rate. And if we lower that rate, they will be able to hire more people. For me, this is about jobs. Mr. Lehrer. All right, that's where we started. Mr. Romney. This is about getting jobs for the American people. Tax Reform/Small-Business Promotion Mr. Lehrer. Yes. Do you challenge what the Governor just said about his own plan? The President. Well, for 18 months, he's been running on this tax plan. And now, 5 weeks before the election, he's saying that his big, bold idea is "never mind." And the fact is that if you are lowering the rates the way you described, Governor, then it is not possible to come up with enough deductions and loopholes that only affect high-income individuals to avoid either raising the deficit or burdening the middle class. It's math. It's arithmetic. Now, Governor Romney and I do share a deep interest in encouraging small-business growth. So at the same time that my tax plan has already lowered taxes for 98 percent of families, I also lowered taxes for small business 18 times. And what I want to do is continue the tax rates—the tax cuts that we put into place for small businesses and families. But I have said that for incomes over $250,000 a year that we should go back to the rates that we had when Bill Clinton was President, when we created 23 million new jobs, went from deficit to surplus, and created a whole lot of millionaires to boot. And the reason this is important is because, by doing that, we can not only reduce the deficit, we can not only encourage job growth through small businesses, but we're also able to make the investments that are necessary in education or in energy. And we do have a difference, though, when it comes to definitions of small business. Under my plan, 97 percent of small businesses would not see their income taxes go up. Governor Romney says, well, those top 3 percent, they're the job creators, they'd be burdened. But under Governor Romney's definition, there are a whole bunch of millionaires and billionaires who are small businesses. Donald Trump is a small business. And I know Donald Trump doesn't like to think of himself as small anything, but that's how you define small businesses if you're getting business income. And that kind of approach, I believe, will not grow our economy, because the only way to pay for it without either burdening the middle class or blowing up our deficit is to make drastic cuts in things like education, making sure that we are continuing to invest in basic science and research—all the things that are helping America grow. And I think that would be a mistake. Mr. Lehrer. All right. Gov. Romney. Jim, let me just come back on that point, which is these—— Mr. Lehrer. Just for the record—— Gov. Romney. ——small businesses we're talking about—— Mr. Lehrer. Excuse me, just so everybody understands, we're way over our first 15 minutes. Gov. Romney. It's fun, isn't it? Mr. Lehrer. It's okay. It's great. The President. That's okay. Mr. Lehrer. Great, no problem. As long as you all don't have a problem, I don't have a problem. Gov. Romney. That's good. Small-Business Promotion/Tax Reform/Job Creation Mr. Lehrer. Because we're still on the economy. We're going to come back to taxes, and we're going to move on to the deficit and a lot of other things too. But go ahead, sir. Gov. Romney. You bet. President, you're—Mr. President, you're absolutely right, which is that with regards to 97 percent of the businesses are not taxed at the 35-percent tax rate, they're taxed at a lower rate. But those businesses that are in the last 3 percent of businesses happen to employ half—half—of all the people who work in small business. Those are the businesses that employ one-quarter of all the workers in America. And your plan is to take their tax rate from 35 percent to 40 percent. Now, I talked to a guy who has a very small business. He's in the electronics business in St. Louis. He has four employees. He said he and his son calculated how much they pay in taxes: Federal income tax, Federal payroll tax, State income tax, State sales tax, State property tax, gasoline tax. It added up to well over 50 percent of what they earned. And your plan is to take the tax rate on successful small businesses from 35 percent to 40 percent. The National Federation of Independent Businesses has said that will cost 700,000 jobs. I don't want to cost jobs. My priority is jobs. And so what I do is I bring down the tax rates, lower deductions and exemptions, the same idea behind Bowles-Simpson, by the way—get the rates down, lower deductions and exemptions to create more jobs—because there's nothing better for getting us to a balanced budget than having more people working, earning more money, paying more taxes. That's by far the most effective and efficient way to get this budget balanced. The President. Jim, I—you may want to move on to another topic, but I would just say this to the American people: If you believe that we can cut taxes by $5 trillion and add $2 trillion in additional spending that the military is not asking for—$7 trillion—just to give you a sense, over 10 years, that's more than our entire defense budget—and you think that by closing loopholes and deductions for the well-to-do, somehow you will not end up picking up the tab, then Governor Romney's plan may work for you. But I think math, common sense, and our history shows us that's not a recipe for job growth. Look, we've tried this; we've tried both approaches. The approach that Governor Romney is talking about is the same sales pitch that was made in 2001 and 2003. And we ended up with the slowest job growth in 50 years. We ended up moving from surplus to deficits, and it all culminated in the worst financial crisis since the Great Depression. Bill Clinton tried the approach that I'm talking about. We created 23 million new jobs. We went from deficit to surplus. And businesses did very well. So in some ways we've got some data on which approach is more likely to create jobs and opportunity for Americans. And I believe that the economy works best when middle class families are getting tax breaks so that they've got some money in their pockets and those of us who have done extraordinarily well because of this magnificent country that we live in, that we can afford to do a little bit more to make sure we're not blowing up the deficit. Gov. Romney. Jim, the President began this segment, so I think I get the last word. So I'm going to take it. Mr. Lehrer. Well, you're going to get the first part in the next segment. Gov. Romney. Well, but he gets the first word of that segment. I get the last word of that segment. Well, I hope. Let me just make this comment. The President. He can have them, he can have them. Go ahead. [Laughter] Mr. Lehrer. That's not how it works. The President. Go ahead. [Laughter] Gov. Romney. Let me repeat what I said. The President. All right. Gov. Romney. I'm not in favor of a $5 trillion tax cut. That's not my plan. My plan is not to put in place any tax cut that will add to the deficit. That's point one. So you may keep referring to it as a $5 trillion tax cut, but that's not my plan. The President. Okay. Gov. Romney. Number two, let's look at history. My plan is not like anything that's been tried before. My plan is to bring down rates, but also bring down deductions and exemptions and credits at the same time so the revenue stays in, but that we bring down rates to get more people working. My priority is putting people back to work in America. They're suffering in this country. And we talk about evidence. Look at the evidence of the last 4 years. It's absolutely extraordinary. We've got 23 million people out of work or stopped looking for work in this country. Mr. Lehrer. All right. Gov. Romney. It's just—we've got—when the President took office, 32 million people on food stamps, 47 million on food stamps today; economic growth this year slower than last year and last year slower than the year before. Going forward with the status quo is not going to cut it for the American people who are struggling today. Mr. Lehrer. All right, let's talk specifics. We're still on the economy. This is theoretically now a second segment, still on the economy, and specifically on what to do about the Federal deficit, the Federal debt. And the question—you each have 2 minutes on this. And Governor Romney, you go first because the President went first on segment one. Gov. Romney. You bet. Deficit and National Debt/Spending Cuts Mr. Lehrer. And the question is this: What are the differences between the two of you as to how you would go about tackling the deficit problem in this country? Gov. Romney. Well, good. I'm glad you raised that, and it's a critical issue. I think it's not just an economic issue. I think it's a moral issue. I think it's frankly not moral for my generation to keep spending massively more than we take in, knowing those burdens are going to passed on to the next generation, and they're going to be paying the interest and the principal all their lives. And the amount of debt we're adding, at a trillion a year, is simply not moral. So how do we deal with it? Well, mathematically, there are three ways that you can cut a deficit. One, of course, is to raise taxes. Number two is to cut spending. And number three is to grow the economy, because if more people work in a growing economy, they're paying taxes and you can get the job done that way. The President would prefer raising taxes. I understand. The problem with raising taxes is that it slows down the rate of growth and you can never quite get the job done. I want to lower spending and encourage economic growth at the same time. What things would I cut from spending? Well, first of all, I will eliminate all programs by this test if they don't pass it: Is the program so critical it's worth borrowing money from China to pay for it? And if not, I'll get rid of it. Obamacare is on my list. I apologize, Mr. President. I use that term with all respect. The President. I like it. Gov. Romney. Good. Okay, good. So I'll get rid of that. I'm sorry, Jim, I'm going to stop the subsidy to PBS. I'm going to stop other things. I like PBS. I love Big Bird. I actually like you too. But I'm not going to keep on spending money on things to borrow money from China to pay for it. That's number one. Number two, I'll take programs that are currently good programs, but, I think, could be run more efficiently at the State level and send them to the State. Number three, I'll make Government more efficient. We're going to cut back the number of employees, combine some agencies and departments. My cutbacks will be done through attrition, by the way. This is the approach we have to take to get America to a balanced budget. The President said he'd cut the deficit in half. Unfortunately, he doubled it. Trillion-dollar deficits for the last 4 years. The President has put in place as much public debt—almost as much debt held by the public as all prior Presidents combined. Mr. Lehrer. Mr. President, 2 minutes. The President. When I walked into the Oval Office I had more than a trillion-dollar deficit greeting me, and we know where it came from: two wars that were paid for on a credit card, two tax cuts that were not paid for, and a whole bunch of programs that were not paid for, and then a massive economic crisis. And despite that, what we've said is, yes, we had to take some initial emergency measures to make sure we didn't slip into a Great Depression, but what we've also said is, let's make sure that we are cutting out those things that are not helping us grow. So 77 Government programs, everything from aircrafts that the Air Force had ordered, but weren't working very well, 18 Government programs for education that were well intentioned, but weren't helping kids learn. We went after medical fraud in Medicare and Medicaid very aggressively, more aggressively than ever before, and have saved tens of billions of dollars: $50 billion of waste taken out of the system. And I worked with Democrats and Republicans to cut a trillion dollars out of our discretionary domestic budget. That's the largest cut in the discretionary domestic budget since Dwight Eisenhower. Now, we all know that we've got to do more, and so I put forward a specific $4 trillion deficit reduction plan. It's on a website; you can look at all the numbers: what cuts we make and what revenue we raise. And the way we do it is $2.50 for every cut we ask for a dollar of additional revenue, paid for, as I indicated earlier, by asking those of us who have done very well in this country to contribute a little bit more to reduce the deficit. Governor Romney earlier mentioned the Bowles-Simpson Commission. Well, that's how the Commission—bipartisan Commission that talked about how we should move forward, suggested we have to do it: in a balanced way with some revenue and some spending cuts. And this is a major difference that Governor Romney and I have. Let me just finish this point because you're looking for contrast. When Governor Romney stood on a stage with other Republican candidates for the nomination, and he was asked, would you take $10 of spending cuts for just $1 of revenue? And he said no. Now, if you take such an unbalanced approach, then that means you are going to be gutting our investments in schools and education. It means that—— Mr. Lehrer. Simpson-Bowles—— The President. Governor Romney talked about Medicaid and how we could send it back to the States, but effectively, this means a 30-percent cut in the primary program we help for seniors who are in nursing homes, for kids who are with disabilities. And that is not a right strategy for us to move forward. Mr. Lehrer. Mr. President, sorry. Way over the 2 minutes. The President. Sorry. National Commission on Fiscal Responsibility and Reform/Deficit and National Debt Mr. Lehrer. Governor, what about Simpson-Bowles? Will you support Simpson-Bowles? Gov. Romney. Simpson-Bowles, the President should have grabbed that. Mr. Lehrer. No, I mean do you support Simpson-Bowles? Gov. Romney. I have my own plan. It's not the same as Simpson-Bowles. But in my view, the President should have grabbed it. If you wanted to make some adjustments to it, take it, go to Congress, fight for it. The President. That's what we've done, made some adjustments to it, and we're putting it forward before Congress right now, a $4 trillion plan—— Gov. Romney. But you've been President 4 years—— The President. ——of balanced—— Gov. Romney. You've been President 4 years. The President. Right. Gov. Romney. You said you'd cut the deficit in half. It's now 4 years later; we still have trillion-dollar deficits. The CBO says we'll have a trillion-dollar deficit each of the next 4 years. If you're reelected, we'll get to a trillion-dollar debt. But you have said before you'd cut the deficit in half. And this four—I love this idea of $4 trillion in cuts: You found $4 trillion of ways to reduce or to get closer to a balanced budget, except we still show trillion-dollar deficits every year. That doesn't get the job done. Let me come back and say, why is that I don't want to raise taxes? Why don't I want to raise taxes on people? And actually you said it. Back in 2010, you said, look, I'm going to extend the tax policies that we have. Now, I'm not going to raise taxes on anyone because when the economy is growing slow like this, when we're in recession, you shouldn't raise taxes on anyone. Well, the economy is still growing slow. As a matter of fact, it's growing much more slowly now than when you made that statement. And so if you believe the same thing, you just don't want to raise taxes on people. And the reality is, it's not just wealthy people—you mentioned Donald Trump—it's not just Donald Trump you're taxing. It's all those businesses that employ one-quarter of the workers in America, these small businesses that are taxed as individuals. You raise taxes, and you kill jobs. That's why the National Federation of Independent Businesses said your plan will kill 700,000 jobs. I don't want to kill jobs in this environment. I'll make one more point. Mr. Lehrer. Let's let him answer the taxes thing for a moment. Gov. Romney. Okay. Mr. Lehrer. Mr. President. The President. Well, we've had this discussion before—— Balancing Tax Reform and Spending Cuts/Oil Industry Subsidies/Corporate Tax Deductions Mr. Lehrer. No, about the idea that in order to reduce the deficit, there has to be revenue in addition to cuts. The President. Right. There has to be revenue in addition to cuts. Now, Governor Romney has ruled out revenue. He's ruled out revenue. Mr. Lehrer. Is that—that's true, right? Gov. Romney. Absolutely. Mr. Lehrer. Completely? Gov. Romney. Look, the revenue I get is by more people working, getting higher pay, paying more taxes. That's how we get growth and how we balance the budget. But the idea of taxing people more, putting more people out of work, you'll never get there. You never balance the budget by raising taxes. Spain—Spain spends 42 percent of their total economy on government. Mr. Lehrer. Okay. Gov. Romney. We're now spending 42 percent of our economy on Government. I don't want to go down the path to Spain. I want to go down the path of growth that puts Americans to work with more money coming in because they're working. Mr. Lehrer. Yes, but, Mr. President, you're saying in order to get the job done, it's got to be balanced. The President. If we're serious, we've got to take a balanced, responsible approach. And by the way, this is not just when it comes to individual taxes. Let's talk about corporate taxes. Now, I've identified areas where we can right away make a change that I believe would actually help the economy. The oil industry gets $4 billion a year in corporate welfare. Basically, they get deductions that those small businesses that Governor Romney refers to, they don't get. Now, does anybody think that ExxonMobil needs some extra money when they're making money every time you go to the pump? Why wouldn't we want to eliminate that? Why wouldn't we eliminate tax breaks for corporate jets? My attitude is, if you got a corporate jet, you can probably afford to pay full freight, not get a special break for it. When it comes to corporate taxes, Governor Romney has said he wants to, in a revenue-neutral way, close loopholes, deductions—he hasn't identified which ones they are—but that thereby bring down the corporate rate. Well, I want to do the same thing, but I've actually identified how we can do that. And part of the way to do it is to not give tax breaks to companies that are shipping jobs overseas. Right now you can actually take a deduction for moving a plant overseas. I think most Americans would say that doesn't make sense. And all that raises revenue. And so if we take a balanced approach, what that then allows us to do is also to help young people, the way we already have during my administration, make sure that they can afford to go to college. It means that the teacher that I met in Las Vegas, a wonderful young lady, who describes to me, she's got 42 kids in her class. The first 2 weeks, she's got some of them sitting on the floor until finally they get reassigned. They're using textbooks that are 10 years old. That is not a recipe for growth. That's not how America was built. And so budgets reflect choices. Ultimately, we're going to have to make some decisions. And if we're asking for no revenue, then that means that we've got to get rid of a whole bunch of stuff. And the magnitude of the tax cuts that you're talking about, Governor, would end up resulting in severe hardship for people, but more importantly, would not help us grow. As I indicated before, when you talk about shifting Medicaid to States, we're talking about potentially a 30-percent cut in Medicaid over time. Now, that may not seem like a big deal when it just is paper—numbers on a sheet of paper. But if we're talking about a family who's got an autistic kid and is depending on that Medicaid, that's a big problem. And Governors are creative, there's no doubt about it. But they're not creative enough to make up for 30 percent of revenue on something like Medicaid. What ends up happening is some people end up not getting help. Gov. Romney. Jim, let's—we've gone on a lot of topics there. And so it's going to take a minute to go from Medicaid to schools—— The President. Go ahead. Energy Sector Subsidies/Corporate Tax Rates/Medicaid Mr. Lehrer. Come back to Medicaid, yes. Gov. Romney. ——to oil to tax breaks and companies going overseas. So let's go through them one by one. First of all, the Department of Energy has said the tax break for oil companies is $2.8 billion a year. And it's actually an accounting treatment, as you know, that's been in place for a hundred years. Now—— The President. It's time to end it. Gov. Romney. And in 1 year, you provided $90 billion in breaks to the green energy world. Now, I like green energy as well, but that's about 50 years' worth of what oil and gas receives. And you say Exxon and Mobil; actually, those $2.8 billion goes largely to small companies, to drilling operators and so forth. But you know if we get that tax rate from 35 percent down to 25 percent, why, that $2.8 billion is on the table. Of course, it's on the table. That's probably not going to survive if you get that rate down to 25 percent. But don't forget, you put $90 billion—like 50 years' worth of breaks—into solar and wind: to Solyndra and Fisker and Tesla and Ener1. I mean, I had a friend who said you don't just pick the winners and losers, you pick the losers. All right? So this is not the kind of policy you want to have if you want to get America energy secure. The second topic, which is you said you get a deduction for taking a plant overseas, look, I've been in business for 25 years. I have no idea what you're talking about. I maybe need to get a new accountant. Mr. Lehrer. Let's just—— Gov. Romney. But the idea that you get a break for shipping jobs overseas is simply not the case. What we do have right now is a setting where I'd like to bring money from overseas back to this country. And finally, Medicaid to States, I'm not quite sure where that came in except this, which is, I would like to take the Medicaid dollars that go to States and say to a State, you're going to get what you got last year plus inflation, plus 1 percent. And then, you're going to manage your care for your poor in the way you think best. And I remember as a Governor, when this idea was floated by Tommy Thompson, the Governors—Republican and Democrats—said, please let us do that. We can care for our own poor in so much better and more effective a way than having the Federal Government tell us how to care for our poor. So let States—one of the magnificent things about this country is the whole idea that States are the laboratories of democracy. Don't have the Federal Government tell everybody what kind of training programs they have to have and what kind of Medicaid they have to have. Let States do this. And by the way, if a State gets in trouble, well, we could step in and see if we could find a way to help them. Mr. Lehrer. Let's go. Two seconds—— Gov. Romney. But the right approach is one which relies on the brilliance of our people and States, not the Federal Government. Social Security/Medicare Mr. Lehrer. Two seconds and we're going on, still on the economy, but another part of it. All right, this is segment three, the economy. Entitlements, first answer goes to you, two minutes, Mr. President. Do you see a major difference between the two of you on Social Security? The President. I suspect that on Social Security we've got a somewhat similar position. Social Security is structurally sound. It's going to have to be tweaked the way it was by Ronald Reagan and Speaker—Democratic Speaker Tip O'Neill. But it is—the basic structure is sound. But I want to talk about the values behind Social Security and Medicare and then talk about Medicare because that's the big driver of our deficits right now. My grandmother, some of you know, helped to raise me, my grandparents did. My grandfather died a while back. My grandmother died 3 days before I was elected President. And she was fiercely independent. She worked her way up. Only had a high school education, started as a secretary, ended up being the vice president of a local bank. And she ended up living alone by choice. And the reason she could be independent was because of Social Security and Medicare. She had worked all her life, put in this money, and understood that there was a basic guarantee, a floor under which she could not go. And that's the perspective I bring when I think about what's called entitlements. The name itself implies some sense of dependency on the part of these folks. These are folks who've worked hard, like my grandmother, and there are millions of people out there who are counting on this. So my approach is to say, how do we strengthen the system over the long term. And in Medicare, what we did was, we said we are going to have to bring down the costs if we're going to deal with our long-term deficits, but to do that, let's look where some of the money is going: $716 billion we were able to save from the Medicare program by no longer overpaying insurance companies, by making sure that we weren't overpaying providers. And using that money, we were actually able to lower prescription drug costs for seniors by an average of $600, and we were also able to make a significant dent in providing them the kind of preventive care that will ultimately save money through the—throughout the system. So the way for us to deal with Medicare in particular is to lower health care costs. When it comes to Social Security, as I said, you don't need a major structural change in order to make sure that Social Security is there for the future. Mr. Lehrer. We'll follow up on this. First, Governor Romney, you have 2 minutes on Social Security and entitlements. Gov. Romney. Well, Jim, our seniors depend on these programs, and I know any time we talk about entitlements people become concerned that something is going to happen that's going to change their life for the worse. And the answer is, neither the President, nor I are proposing any changes for any current retirees or near-retirees, either to Social Security or Medicare. So if you're 60 or around 60 or older, you don't need to listen any further. But for younger people, we need to talk about what changes are going to be occurring—oh, I just thought about one, and that is, in fact, I was wrong when I said the President isn't proposing any changes for current retirees. In fact, he is on Medicare. On Social Security, he's not. But on Medicare, for current retirees, he's cutting $716 billion from the program. Now, he says by not overpaying hospitals and providers. Actually, just going to them and saying we're going to reduce the rates you get paid across the board, everybody is going to get a lower rate, that's not just going after places where there's abuse. That's saying, we're cutting the rates. Some 15 percent of hospitals and nursing homes say they won't take any more Medicare patients under that scenario. We also have 50 percent of doctors who say they won't take more Medicare patients. This—we have 4 million people on Medicare Advantage that will lose Medicare Advantage because of those $716 billion in cuts. I can't understand how you can cut Medicare $716 billion for current recipients of Medicare. Now, you'd point out, well, we're putting some back, we're going to give a better prescription program. That's one of—that's $1 for every 15 you've cut. They're smart enough to know that's not a good trade. I want to take that $716 billion you've cut and put it back into Medicare. By the way, we can include a prescription program if we need to improve it. But the idea of cutting $716 billion from Medicare to be able to balance the additional cost of Obamacare is, in my opinion, a mistake. And with regards to young people coming along, I've got proposals to make sure Medicare and Social Security are there for them without any question. Health Care for Senior Citizens/Medicare Mr. Lehrer. Mr. President. The President. First of all, I think it's important for Governor Romney to present this plan that he says will only affect folks in the future. And the essence of the plan is that you would turn Medicare into a voucher program. It's called premium support, but it's understood to be a voucher program. His running mate—— Mr. Lehrer. And you don't support that? The President. I don't. And let me explain why. Gov. Romney. Again, that's for future people, right—— The President. I understand. Gov. Romney. ——not for current retirees. The President. So if you're 54 or 55, you might want to listen, because this will affect you. The idea, which was originally presented by Congressman Ryan, your running mate, is that we would give a voucher to seniors and they could go out in the private marketplace and buy their own health insurance. The problem is that because the voucher wouldn't necessarily keep up with health care inflation, it was estimated that this would cost the average senior about $6,000 a year. Now, in fairness, what Governor Romney has now said is, he'll maintain traditional Medicare alongside it. But there's still a problem, because what happens is those insurance companies are pretty clever at figuring out who are the younger and healthier seniors. They recruit them, leaving the older, sicker seniors in Medicare, and every health care economist who looks at it says, over time, what will happen is the traditional Medicare system will collapse. And then what you've got is folks like my grandmother at the mercy of the private insurance system precisely at the time when they are most in need of decent health care. So I don't think vouchers are the right way to go. And this is not my—only my opinion. AARP thinks that the savings that we obtained from Medicare bolstered the system, lengthened the Medicare trust fund by 8 years. Benefits were not affected at all. And ironically, if you repeal Obamacare—and I have become fond of this term, Obamacare—[Laughter]—if you repeal it, what happens is those seniors right away are going to be paying $600 more in prescription care. They're now going to have to be paying copays for basic checkups that can keep them healthier. And the primary beneficiary of that repeal are insurance companies that are estimated to gain billions of dollars back when they aren't making seniors any healthier. And I don't think that's the right approach when it comes to making sure that Medicare is stronger over the long term. Mr. Lehrer. We'll talk about—specifically about health care in a moment. But what—do you support the voucher system, Governor? Gov. Romney. What I support is no change for current retirees and near-retirees to Medicare. And the President supports taking $716 billion out of that program. Mr. Lehrer. What about the voucher—— Gov. Romney. So that's number one. Mr. Lehrer. All right. Gov. Romney. Number two is, for people coming along that are young, what I'd do to make sure that we can keep Medicare in place for them is to allow them either to choose the current Medicare program or a private plan, their choice. They get to—and they'll have at least two plans that will be entirely at no cost to them. So they don't have to pay additional money, no additional $6,000; that's not going to happen. They'll have at least two plans. And by the way, if the Government can be as efficient as the private sector and offer premiums that are as low as the private sector, people will be happy to get traditional Medicare. Or they'll be able to get a private plan. I know my own view is, I'd rather have a private plan. I'd just as soon not have the Government telling me what kind of health care I get. I'd rather be able to have an insurance company. If I don't like them, I can get rid of them and find a different insurance company. But people will make their own choice. The other thing we have to do to save Medicare, we have to have the benefits high for those that are low income. But for higher-income people, we're going to have to lower some of the benefits. We have to make sure this program is there for the long term. That's the plan that I put forward. And by the way, the idea came not even from Paul Ryan or Senator Wyden, who is a coauthor of the bill with Paul Ryan in the Senate, but also it came from Bill Clinton's Chief of Staff. This is an idea that's been around a long time, which is saying, hey, let's see if we can't get competition into the Medicare world so that people can get the choice of different plans at lower cost, better quality. I believe in competition. Mr. Lehrer. Okay. The President. Jim, if I can just respond very quickly. First of all, every study has shown that Medicare has lower administrative costs than private insurance does, which is why seniors are generally pretty happy with it. And private insurers have to make a profit. Nothing wrong with that, that's what they do. And so you've got higher administrative costs, plus profit on top of that, and if you are going to save any money through what Governor Romney is proposing, what has to happen is, is that the money has to come from somewhere. And when you move to a voucher system, you are putting seniors at the mercy of those insurance companies. And over time, if traditional Medicare has decayed or fallen apart, then they're stuck. And this is the reason why AARP has said that your plan would weaken Medicare substantially, and that's why they were supportive of the approach that we took. One last point I want to make: We do have to lower the cost of health care, not just in Medicare, but—— Mr. Lehrer. We'll talk about that in a minute. The President. ——but overall. Mr. Lehrer. Okay. The President. And so—— Gov. Romney. That's a big topic. Can we stay on Medicare? The President. Oh, is that a separate topic? Mr. Lehrer. Yes, we're going to—yes, I want to get to it. The President. I'm sorry. Mr. Lehrer. But all I want to do is very quickly—— Gov. Romney. Let's get back to Medicare. Mr. Lehrer. ——before we leave the economy—— Gov. Romney. Let's get back to Medicare. Mr. Lehrer. No, no, no—— Gov. Romney. The President said that the Government can provide the service at lower cost and without a profit. Mr. Lehrer. All right. Gov. Romney. If that's the case, then it will always be the best product that people can purchase. But my experience—— Mr. Lehrer. Wait a minute, Governor. Wait—— Gov. Romney. ——my experience is, the private sector typically is able to provide a better product at a lower cost. Mr. Lehrer. Can we—can the two of you agree that the voters have a choice, a clear choice between the two of you on Medicare? Gov. Romney. Absolutely. The President. Yes. Gov. Romney. Absolutely. The President. Absolutely. Federal Regulations/Dodd-Frank Wall Street Reform and Consumer Protection Act Mr. Lehrer. All right. So to finish quickly, briefly on the economy, what is your view about the level of Federal regulation of the economy right now? Is there too much? And in your case, Mr. President, is there—should there be more? Beginning with you—this is not a new 2-minute segment. Just start, and we'll go for a few minutes, and then we're going to go to health care, okay? Gov. Romney. Regulation is essential. You can't have a free market work if you don't have regulation. As a businessperson, I had to have—I needed to know the regulations. I needed them there. You couldn't have people opening up banks in their garage and making loans. I mean, you have to have regulations so that you can have an economy work. Every free economy has good regulation. At the same time, regulation can become excessive. Mr. Lehrer. Is it successing now, do you think? Gov. Romney. Well, in some places, yes—— Mr. Lehrer. Like where? Let me know. Give me—— Gov. Romney. ——other places, no. It can become out of date. And what's happened with some of the legislation that's been passed during the President's term, you've seen regulation become excessive, and it's hurt the economy. Let me give you an example. Dodd-Frank was passed, and it includes within it a number of provisions that I think has some unintended consequences that are harmful to the economy. One is it designates a number of banks as "too big to fail," and they're effectively guaranteed by the Federal Government. This is the biggest kiss that's been given to New York banks I've ever seen. The President. No. Gov. Romney. This is an enormous boon for them. There have been 122 community and small banks have closed since Dodd-Frank. So there's one example. Here's another. In Dodd-Frank, it says if—— Mr. Lehrer. You want to repeal Dodd-Frank? Gov. Romney. Well, I would repeal the—and replace it. We're not going to get rid of all regulation. You have to have regulation—— Mr. Lehrer. Okay. All right. Gov. Romney. ——and there are some parts of Dodd-Frank that make all the sense in the world. You need transparency. You need to have leverage limits for institutional—— Mr. Lehrer. Well, there's a specific—— Gov. Romney. But let's mention—— Mr. Lehrer. Let's get to the—excuse me—— Gov. Romney. Let me mention the other one. Let's talk the other big one—the big one. Mr. Lehrer. No, no, let's not. Gov. Romney. Okay. Dodd-Frank Wall Street Reform and Consumer Protection Act/Home Loan Industry Mr. Lehrer. Let's let him respond to this specific on Dodd-Frank and what the Governor just said. The President. Well, I think this is a great example. The reason we have been in such a enormous economic crisis was prompted by reckless behavior across the board. Now, it wasn't just on Wall Street. You had loan officers were—that were giving loans and mortgages that really shouldn't have been given because the folks didn't qualify. You had people who were borrowing money to buy a house that they couldn't afford. You had credit agencies that were stamping these as A1, great investments when they weren't. But you also had banks making money hand over fist, churning out products that the bankers themselves didn't even understand, in order to make big profits, but knowing that it made the entire system vulnerable. So what did we do? We stepped in and had the toughest reforms on Wall Street since the 1930s. We said you've got—banks, you've got to raise your capital requirements. You can't engage in some of this risky behavior that is putting Main Street at risk. We're going to make sure that you've got to have a living will so we can know how you're going to wind things down if you make a bad bet so we don't have other taxpayer bailouts. In the meantime, by the way, we also made sure that all the help that we provided those banks was paid back—every single dime—with interest. Now, Governor Romney has said he wants to repeal Dodd-Frank, and I appreciate—and it appears we've got some agreement that a marketplace, to work, has to have some regulation. But in the past, Governor Romney has said he just wants to repeal Dodd-Frank. Roll it back. And so the question is, does anybody out there think that the big problem we had is that there was too much oversight and regulation of Wall Street? Because if you do, then Governor Romney is your candidate. But that's not—— Gov. Romney. Sorry, Jim—— The President. ——what I believe. Gov. Romney. ——but that's just not the facts. Look, we have to have regulation on Wall Street. That's why I'd have regulation. But I wouldn't designate five banks as "too big to fail" and give them a blank check. That's one of the unintended consequences of Dodd-Frank. It wasn't thought through properly. We need to get rid of that provision because it's killing regional and small banks. They're getting hurt. Let me mention another regulation in Dodd-Frank. You say we were giving mortgages to people who weren't qualified. That's exactly right. It's one of the reasons for the great financial calamity we had. And so Dodd-Frank correctly says we need to have qualified mortgages, and if you give a mortgage that's not qualified, there are big penalties—except they didn't ever go on to define what a qualified mortgage was. Mr. Lehrer. All right—— Gov. Romney. It's been 2 years. We don't know what a qualified mortgage is yet. So banks are reluctant to make loans, mortgages. Try and get a mortgage these days. It's hurt the housing market, because Dodd-Frank didn't anticipate putting in place the kinds of regulations you have to have. It's not that Dodd-Frank always was wrong with too much regulation. Sometimes, they didn't come out with a clear regulation. Mr. Lehrer. Okay—— Gov. Romney. I will make sure we don't hurt the functioning of our marketplace and our businesses, because I want to bring back housing and get good jobs. Patient Protection and Affordable Care Act Mr. Lehrer. All right. I think we have another clear difference between the two of you. Now let's move to health care, where I know there is a clear difference—[Laughter]—and that has to do with the Affordable Care Act—Obamacare. And it's a 2-minute new segment, and that means 2 minutes each. And you go first, Governor Romney. You want it repealed. You want the Affordable Care Act repealed. Why? Gov. Romney. I sure do. Well, in part it comes, again, from my experience. I was in New Hampshire; a woman came to me and she said, look, I can't afford insurance for myself or my son. I met a couple in Appleton, Wisconsin, and they said, we're thinking of dropping our insurance; we can't afford it. And the number of small businesses I've gone to that are saying they're dropping insurance because they can't afford it—the cost of health care is just prohibitive, and we've got to deal with cost. And unfortunately, when you look at Obamacare, the Congressional Budget Office has said it will cost $2,500 a year more than traditional insurance. So it's adding to cost. And as a matter of fact, when the President ran for office, he said that by this year he would have brought down the cost of insurance for each family by $2,500 a family. Instead, it's gone up by that amount. So it's expensive. Expensive things hurt families. So that's one reason I don't want it. Second reason, it cuts $716 billion from Medicare to pay for it. I want to put that money back in Medicare for our seniors. Number three, it puts in place an unelected board that's going to tell people ultimately what kind of treatments they can have. I don't like that idea. Fourth, there was a survey done of small businesses across the country. It said, what's been the effect of Obamacare on your hiring plans? And three-quarters of them said, it makes us less likely to hire people. I just don't know how the President could have come into office facing 23 million people out of work, rising unemployment, an economic crisis at the kitchen table, and spend his energy and passion for 2 years fighting for Obamacare instead of fighting for jobs for the American people. It has killed jobs. And the best course for health care is to do what we did in my State: craft a plan at the State level that fits the needs of the State, and then let's focus on getting the cost down for people rather than raising it with a $2,500 additional premium. Mr. Lehrer. Mr. President, the argument against repeal. The President. Well, 4 years ago when I was running for office, I was traveling around and having those same conversations that Governor Romney talks about. And it wasn't just that small businesses were seeing costs skyrocket and they couldn't get affordable coverage even if they wanted to provide it to their employees. It wasn't just that this was the biggest driver of our Federal deficit, our overall health care cost. But it was families who were worried about going bankrupt if they got sick—millions of families all across the country. If they had a preexisting condition, they might not be able to get coverage at all. If they did have coverage, insurance companies might impose an arbitrary limit. And so, as a consequence, they're paying their premiums; somebody gets really sick; lo and behold, they don't have enough money to pay the bills because the insurance companies say that they've hit the limit. So we did work on this, alongside working on jobs, because this is part of making sure that middle class families are secure in this country. And let me tell you exactly what Obamacare did. Number one, if you've got health insurance, it doesn't mean a Government takeover. You keep your own insurance. You keep your own doctor. But it does say insurance companies can't jerk you around. They can't impose arbitrary lifetime limits. They have to let you keep your kid on their insurance—your insurance plan until you're 26 years old. And it also says that you're going to have to get rebates if insurance companies are spending more on administrative costs and profits than they are on actual care. Number two, if you don't have health insurance, we're essentially setting up a group plan that allows you to benefit from group rates that are typically 18 percent lower than if you're out there trying to get insurance on the individual market. Now, the last point I'd make before—— Massachusetts Health Care Reform/Bipartisanship/Medicare/Patient Protection and Affordable Care Act Mr. Lehrer. Two minutes is up, sir. The President. No, I think—I had 5 seconds before you interrupted me, was—[Laughter]. The irony is that we've seen this model work really well in Massachusetts, because Governor Romney did a good thing, working with Democrats in the State to set up what is essentially the identical model. And as consequence, people are covered there. It hasn't destroyed jobs. And as a consequence, we now have a system in which we have the opportunity to start bringing down costs, as opposed to just leaving millions of people out in the cold. Mr. Lehrer. Your 5 seconds went away a long time ago. [Laughter] The President. That I admit. [Laughter] Mr. Lehrer. All right, Governor, tell the President directly why you think what he just said is wrong about Obamacare. Gov. Romney. Well, I did with my first statement—— The President. You did. Gov. Romney. ——but I'll go on. The President. Please elaborate. [Laughter] Gov. Romney. I'll elaborate, exactly right. First of all, I like the way we did it in Massachusetts. I like the fact that in my State, we had Republicans and Democrats come together and work together. What you did instead was to push through a plan without a single Republican vote. As a matter of fact, when Massachusetts did something quite extraordinary—elected a Republican Senator—to stop Obamacare, you pushed it through anyway. So entirely on a partisan basis, instead of bringing America together and having a discussion on this important topic, you pushed through something that you and Nancy Pelosi and Harry Reid thought was the best answer and drove it through. What we did in a legislature 87-percent Democrat, we worked together. Two hundred legislators in my legislature; only two voted against the plan by the time we were finished. What were some differences? We didn't raise taxes. You've raised them by a trillion dollars under Obamacare. We didn't cut Medicare—of course, we don't have Medicare—but we didn't cut Medicare by $716 billion. We didn't put in place a board that can tell people ultimately what treatments they're going to receive. We didn't also do something that I think a number of people across this country recognize, which is put people in a position where they're going to lose the insurance they had and they wanted. Right now the CBO says up to 20 million people will lose their insurance as Obamacare goes into effect next year. And likewise, a study by McKinsey and Company of American businesses said 30 percent of them are anticipating dropping people from coverage. So, for those reasons—for the tax, for Medicare, for this board, and for people losing their insurance—this is why the American people don't want Medicare—don't want Obamacare. It's why Republicans said, do not do this. And the Republicans had a—had the plan. They put a plan out. They put a plan, a bipartisan plan. It was swept aside. I think something this big, this important, has to be done on a bipartisan basis. And we have to have a President who can reach across the aisle and fashion important legislation with the input from both parties. The President. Governor Romney said this has to be done on a bipartisan basis. This was a bipartisan idea. In fact, it was a Republican idea. And Governor Romney, at the beginning of this debate, wrote and said, what we did in Massachusetts could be a model for the Nation. And I agree that the Democratic legislators in Massachusetts might have given some advice to Republicans in Congress about how to cooperate, but the fact of the matter is we used the same advisers, and they say it's the same plan. It—when Governor Romney talks about this board, for example—unelected board that we've created—what this is, is a group of health care experts, doctors, et cetera, to figure out how can we reduce the cost of care in the system overall. Because there are two ways of dealing with our health care crisis. One is to simply leave a whole bunch of people uninsured and let them fend for themselves; to let businesses figure out how long they can continue to pay premiums until finally they just give up and their workers are no longer getting insured. And that's been the trend line. Or alternatively, we can figure out how do we make the cost of care more effective. And there are ways of doing it. So, at Cleveland Clinic, one of the best health care systems in the world, they actually provide great care, cheaper than average. And the reason they do is because they do some smart things. They say if a patient's coming in, let's get all the doctors together at once, do 1 test, instead of having the patient run around with 10 tests. Let's make sure that we're providing preventive care so we're catching the onset of something like diabetes. Let's pay providers on the basis of performance, as opposed to on the basis of how many procedures they've engaged in. Now, so what this board does is basically identifies best practices and says let's use the purchasing power of Medicare and Medicaid to help to institutionalize all these good things that we do. And the fact of the matter is that when Obamacare is fully implemented, we're going to be in a position to show that costs are going down. And over the last 2 years, health care premiums have gone up, it's true, but they've gone up slower than any time in the last 50 years. So we're already beginning to see progress. In the meantime, folks out there with insurance, you're already getting a rebate. Let me make one last point. Governor Romney says we should replace it—I'm just going to repeal it, but we can replace it with something. But the problem is, he hasn't described what exactly we'd replace it with, other than saying we're going to leave it to the States. But the fact of the matter is that some of the prescriptions that he's offered, like letting you buy insurance across State lines, there's no indication that that somehow is going to help somebody who has got a preexisting condition be able to finally buy insurance. In fact, it's estimated that by repealing Obamacare, you're looking at 50 million people losing health insurance at a time when it's vitally important. Health Care Reform/Patient Protection and Affordable Care Act/Preexisting Medical Conditions Mr. Lehrer. Let's let the Governor explain what you would do if Obamacare is repealed. How would you replace it? What do you have in mind? Gov. Romney. Well, actually, it's a lengthy description, but number one, preexisting conditions are covered under my plan. Number two, young people are able to stay on their family plan. That's already offered in the private marketplace. You don't have the Government mandate that for that to occur. But let's come back to something the President and I agree on, which is the key task we have in health care is to get the cost down so it's more affordable for families. And then he has as a model for doing that a board of people at the Government—an unelected board, appointed board—who are going to decide what kind of treatments you ought to have. The President. No, that's not—— Gov. Romney. In my opinion, the Government is not effective in bringing down the cost of almost anything. As a matter of fact, free people and free enterprises trying to find ways to do things better are able to be more effective in bringing down the costs than the Government will ever be. Your example of the Cleveland Clinic is my case in point, along with several others I could describe. This is the private market. These are small—these are enterprises competing with each other, learning how to do better and better jobs. I used to consult to businesses—excuse me, to hospitals and to health care providers. I was astonished at the creativity and innovation that exists in the American people. In order to bring the cost of health care down, we don't need to have a board of 15 people telling us what kinds of treatments we should have. We instead need to put insurance plans, providers, hospitals, doctors on target such that they have an incentive, as you say, performance pay, for doing an excellent job for keeping costs down. And that's happening; Intermountain Healthcare does it superbly well. The President. They do. Gov. Romney. Mayo Clinic is doing it superbly well, Cleveland Clinic, others. But the right answer is not to have the Federal Government take over health care and start mandating to the providers across America, telling a patient and a doctor what kind of treatment they can have. That's the wrong way to go. The private market and individual responsibility always work best. The President. Let me just point out, first of all, this board that we're talking about can't make decisions about what treatments are given. That's explicitly prohibited in the law. But let's go back to what Governor Romney indicated, that under his plan, he would be able to cover people with preexisting conditions. Well actually, Governor, that isn't what your plan does. What your plan does is to duplicate what's already the law, which says if you are out of health insurance for 3 months, then you can end up getting continuous coverage and an insurance company can't deny you if you've—if it's been under 90 days. But that's already the law. And that doesn't help the millions of people out there with preexisting conditions. There's a reason why Governor Romney set up the plan that he did in Massachusetts. It wasn't a government takeover of health care. It was the largest expansion of private insurance. But what it does say is that, insurers, you've got to take everybody. Now, that also means that you've got more customers. But when Governor Romney says that he'll replace it with something, but can't detail how it will be, in fact, replaced—and the reason he set up the system he did in Massachusetts was because there isn't a better way of dealing with the preexisting conditions problem—it just reminds me of—he says that he's going to close deductions and loopholes for his tax plan. That's how it's going to be paid for, but we don't know the details. He says that he's going to replace Dodd-Frank, Wall Street reform, but we don't know exactly which ones. He won't tell us. He now says he's going to replace Obamacare and assure that all the good things that are in it are going to be in there and you don't have to worry. And at some point, I think the American people have to ask themselves, is the reason that Governor Romney is keeping all these plans to replace secret because they're too good? Is it because that somehow middle class families are going to benefit too much from them? No. The reason is because when we reform Wall Street, when we tackle the problem of preexisting conditions then—these are tough problems, and we've got to make choices—— Mr. Lehrer. All right. Let's—— The President. ——and the choices we've made have been ones that ultimately are benefiting middle class families all across the country. Mr. Lehrer. We're going to move to—— Gov. Romney. No, I have to respond to that—— Mr. Lehrer. Well, but—— Tax Reform/Preexisting Medical Conditions Gov. Romney. ——which is, my experience as a Governor is if I come in and lay down a piece of legislation and say it's my way or the highway, I don't get a lot done. What I do is the same way that Tip O'Neill and Ronald Reagan worked together some years ago. When Ronald Reagan ran for office, he laid out the principles that he was going to foster. He said he was going to lower tax rates. He said he was going to broaden the base. You've said the same thing; you're going to simplify the Tax Code, broaden the base. Those are my principles. I want to bring down the tax burden on middle-income families, and I'm going to work together with Congress to say, okay, what are the various ways we can bring down deductions, for instance. One way, for instance, would be to have a single number—make up a number—$25,000, $50,000—anybody could have deductions up to that amount. And then, that number disappears for high income people. That's one way one could do it. One could follow Bowles-Simpson as a model and take deduction by deduction and make differences that way. There are alternatives to accomplish the objective I have, which is to bring down rates, broaden the base, simplify the Code, and create incentives for growth. And with regards to health care, you had remarkable details with regards to my preexisting condition plan. You obviously have studied up on my plan. In fact, I do have a plan that deals with people with preexisting conditions; that's part of my health care plan. And what we did in Massachusetts is a model for the Nation, State by State. And I said that at that time. The Federal Government taking over health care for the entire Nation and whisking aside the 10th Amendment, which gives States the rights for these kinds of things, is not the course for America to have a stronger, more vibrant economy. Role of the Federal Government Mr. Lehrer. That is a terrific segue to our next segment, and it's the role of Government. And let's see, role of Government, and it is—you are first on this, Mr. President. And the question is this: Do you believe—both of you, but you have the first 2 minutes on this, Mr. President—do you believe there's a fundamental difference between the two of you as to how you view the mission of the Federal Government? The President. Well, I definitely think there are differences. The first role of the Federal Government is to keep the American people safe. That's its most basic function. And as Commander in Chief, that is something that I have worked on and thought about every single day that I've been in the Oval Office. But I also believe that Government has the capacity—the Federal Government—has the capacity to help open up opportunity and create ladders of opportunity and to create frameworks where the American people can succeed. Look, the genius of America is the free enterprise system and freedom and the fact that people can go out there and start a business, work on an idea, make their own decisions. But as Abraham Lincoln understood, there are also some things we do better together. So, in the middle of the Civil War, Abraham Lincoln said, let's help to finance the transcontinental railroad. Let's start the National Academy of Sciences. Let's start land-grant colleges, because we want to give these gateways of opportunity for all Americans. Because if all Americans are getting opportunity, we're all going to be better off. That doesn't restrict people's freedom; that enhances it. And so what I've tried to do as President is to apply those same principles. When it comes to education, what I've said is we've got to reform schools that are not working. We use something called Race to the Top. It wasn't a top-down approach, Governor. What we've said is, to States, we'll give you more money if you initiate reforms. And as a consequence, you have 46 States around the country who have made a real difference. But what I've also said is, let's hire another 100,000 math and science teachers to make sure we maintain our technological lead and our people are skilled and able to succeed. And hard-pressed States right now can't all do that. In fact, we've seen layoffs of hundreds of thousands of teachers over the last several years, and Governor Romney doesn't think we need more teachers. I do, because I think that that is the kind of investment where the Federal Government can help. It can't do it all, but it can make a difference. And as a consequence, we'll have a better trained workforce, and that will create jobs because companies want to locate in places where we've got a skilled workforce. Mr. Lehrer. Two minutes, Governor, on the role of Government. Your view? Gov. Romney. Well, first, I love great schools. Massachusetts, our schools are ranked number 1 of all 50 States. And the key to great schools—great teachers. So I reject the idea that I don't believe in great teachers or more teachers. Every school district, every State should make that decision on their own. The role of Government: Look behind us—the Constitution and the Declaration of Independence. The role of Government is to promote and protect the principles of those documents. First, life and liberty: We have a responsibility to protect the lives and liberties of our people, and that means a military second to none. I do not believe in cutting our military. I believe in maintaining the strength of America's military. Second, in that line that says, "We are endowed by our Creator with our rights," I believe we must maintain our commitment to religious tolerance and freedom in this country. That statement also says that we are endowed by our Creator with the right to pursue happiness as we choose. I interpret that as, one, making sure that those people who are less fortunate and can't care for themselves are cared by—by one another. We're a nation that believes that we are all children of the same God, and we care for those that have difficulties. Those that are elderly and have problems and challenges, those that are disabled, we care for them. And we look for discovery and innovation, all these things desired out of the American heart to provide the pursuit of happiness for our citizens. But we also believe in maintaining for individuals the right to pursue their dreams and not to have the Government substitute itself for the rights of free individuals. And what we're seeing right now is, in my view, a trickle-down Government approach which has Government thinking it can do a better job than free people pursuing their dreams, and it's not working. And the proof of that is 23 million people out of work. The proof of that is one out of six people in poverty. The proof of that is we've gone from 32 million on food stamps to 47 million on food stamps. The proof of that is that 50 percent of college graduates this year can't find work. We know that the path we're taking is not working. It's time for a new path. Federal Role in Education/Education Reform/Community Colleges/Student Loan Programs Mr. Lehrer. All right, let's go through some specifics in terms of what—how each of you views the role of Government. How do—education: Does the Federal Government have a responsibility to improve the quality of public education in America? Gov. Romney. Well, the primary responsibility for education is, of course, at the State and local level. But the Federal Government also can play a very important role. And I agree with Secretary Arne Duncan, he's—some ideas he's put forward on Race to the Top—not all of them, but some of them I agree with and congratulate him for pursuing that. The Federal Government can get local and State schools to do a better job. My own view, by the way, is I've added to that. I happen to believe—I want the kids that are getting Federal dollars from IDEA or title I—these are disabled kids or poor kids—or lower income kids, rather—I want them to be able to go to the school of their choice. So all Federal funds, instead of going to the State or to the school district, I'd have go, if you will, follow the child and let the parent and the child decide where to send their student. Mr. Lehrer. How do you see the Federal Government's responsibility to, as I say, to improve the quality of public education in this country? The President. Well, as I've indicated, I think that it has a significant role to play. Through our Race to the Top program, we've worked with Republican and Democratic Governors to initiate major reforms, and they're having an impact right now. Mr. Lehrer. Do you think you have a difference with your views and those of Governor Romney on—about education and the Federal Government? The President. This is where budgets matter, because budgets reflect choices. So when Governor Romney indicates that he wants to cut taxes and potentially benefit folks like me and him, and to pay for it we're having to initiate significant cuts in Federal support for education, that makes a difference. His running mate, Congressman Ryan, put forward a budget that reflects many of the principles that Governor Romney's talked about. And it wasn't very detailed—this seems to be a trend—but what it did do is to, if you extrapolated how much money we're talking about, you'd look at cutting the education budget by up to 20 percent. When it comes to community colleges, we are seeing great work done out there all over the country because we have the opportunity to train people for jobs that exist right now. And one of the things, I suspect, Governor Romney and I probably agree on is getting businesses to work with community colleges so that they're setting up their training programs—— Mr. Lehrer. Do you agree, Governor? The President. Let me just finish the point. Gov. Romney. Oh, sure. Oh, yes. It's, by the way, going very well in my State, by the way. Yes. The President. I suspect it will be a small agreement. The—where they're partnering so that they're designing training programs and people who are going through them know that there's a job waiting for them if they complete it. Mr. Lehrer. Okay, now—— The President. That makes a big difference, but that requires some Federal support. Let me just use—say one final example. When it comes to making college affordable, whether it's 2-year or 4-year, one of the things that I did as President was we were sending $60 billion to banks and lenders as middlemen for the student loan program, even though the loans were guaranteed so there was no risk for the banks or the lenders. But they were taking billions out of the system. And we said why not cut out the middleman? And as a consequence, what we've been able to do is to provide millions more students assistance, lower or keep low interest rates on student loans. And this is an example of where our priorities make a difference. Governor Romney, I genuinely believe, cares about education, but when he tells a student that you should borrow money from your parents to go to college, that indicates the degree to which there may not be as much of a focus on the fact that folks like myself, folks like Michelle, kids probably who attend University of Denver just don't have that option. And for us to be able to make sure that they've got that opportunity and they can walk through that door, that is vitally important—not just to those kids; it's how we're going to grow this economy over the long term. Mr. Lehrer. We're running out of time, gentlemen—— Gov. Romney. Jim, Jim—— Energy Sector Subsidies/Education Reform Mr. Lehrer. ——so I think you have a chance—yes, respond to that. Yes, sir, Governor. The President. Yes, he has a chance. Gov. Romney. Mr. President, you're entitled, as the President, to your own airplane and to your own house, but not to your own facts—[Laughter]—all right? I'm not going to cut education funding. I don't have any plan to cut education funding. And grants that go to people going to college I'm planning on continuing to grow, so I'm not planning on making changes there. But you make a very good point, which is that the place you put your money makes a pretty clear indication of where your heart is. You put $90 billion into green jobs. And I—look, I'm all in favor of green energy. Ninety billion—that would have hired 2 million teachers. Ninety billion dollars. And these businesses, many of them have gone out of business. I think about half of them—of the ones that have been invested in have gone out of business. A number of them happen to be owned by people who were contributors to your campaigns. Look, the right course for America's Government—we were talking about the role of Government—is not to become the economic player picking winners and losers, telling people what kind of health treatment they can receive, taking over the health care system that has existed in this country for a long, long time and has produced the best health records in the world. The right answer for Government is to say, how do we make the private sector become more efficient and more effective? How do we get schools to be more competitive? Let's grade them. I propose we grade our schools so parents know which schools are succeeding and failing, so they can take their child to a school that's being more successful. I don't want to cut our commitment to education. I want to make it more effective and efficient. And by the way, I've had that experience. I don't just talk about it. I've been there. Massachusetts schools are ranked number one in the Nation. This is not because I didn't have commitment to education. It's because I care about education for all of our kids. Mr. Lehrer. All right, gentlemen—— The President. Jim, I—— Mr. Lehrer. Excuse me, one second. The President. Look—— Mr. Lehrer. Excuse me, sir. We've got—we barely have 3 minutes left. I'm not going to grade the two of you and say your answers have been too long or I've done a poor job—— The President. You've done a great job, Jim. Role of the Federal Government/Bipartisanship/Presidential Leadership Mr. Lehrer. Oh, well, no. But the fact is, Government—the role of Government and governing—we've lost a pod, in other words. So we only have 3 minutes left in the debate before we go to your closing statements. And so I want to ask, finally, here—and remember, we've got 3 minutes total time here. And the question is this: Many of the legislative functions of the Federal Government right now are in a state of paralysis as a result of partisan gridlock. If elected, in your case—if reelected, in your case—what would you do about that? Governor? Gov. Romney. Jim, I had the great experience—it didn't seem like it at the time—of being elected in a State where my legislature was 87-percent Democrat. And that meant I figured out, from day one I had to get along and I had to work across the aisle to get anything done. We drove our schools to be number one in the Nation. We cut taxes 19 times. Mr. Lehrer. What would you do as President? Gov. Romney. As President, I will sit down on day one—actually, the day after I get elected, I'll sit down with leaders, the Democratic leaders as well as Republican leaders, and continue—as we did in my State—we met every Monday for a couple hours, talked about the issues and the challenges in our State in that case. We have to work on a collaborative basis, not because we're going to compromise our principle, but because there's common ground. And the challenges America faces right now—look, the reason I'm in this race is there are people that are really hurting today in this country. And we face—this deficit could crush the future generations. What's happening in the Middle East; there are developments around the world that are of real concern. And Republicans and Democrats both love America, but we need to have leadership, leadership in Washington that will actually bring people together and get the job done and could not care less if it's a Republican or a Democrat. I've done it before. I'll do it again. Mr. Lehrer. Mr. President. The President. Well, first of all, I think Governor Romney is going to have a busy first day, because he's also going to repeal Obamacare, which will not be very popular among Democrats as you're sitting down with them. [Laughter] But look, my philosophy has been, I will take ideas from everybody—Democrat or Republican—as long as they're advancing the cause of making middle class families stronger and giving ladders of opportunity to the middle class. That's how we cut taxes for middle class families and small businesses. That's how we cut a trillion dollars of spending that wasn't advancing that cause. That's how we signed three trade deals into law that are helping us to double our exports and sell more American products around the world. That's how we repealed "don't ask, don't tell." That's how we ended the war in Iraq, as I promised. And that's how we're going to wind down the war in Afghanistan. That's how we went after Al Qaida and bin Laden. So we've seen progress even under Republican control of the House of Representatives. But ultimately, part of being principled, part of being a leader is, A, being able to describe exactly what it is that you intend to do, not just saying I'll sit down, but you have to have a plan. Number two, what's important is occasionally you've got to say no to folks both in your own party and in the other party. And yes, we had some fights between me and the Republicans when they fought back against us reining in the excesses of Wall Street? Absolutely, because that was a fight that needed to be had. When we were fighting about whether or not we were going to make sure that Americans had more security with their health insurance and they said no? Yes, that was a fight that we needed to have. Jim Lehrer. All right—— The President. And so part of leadership and governing is both saying what it is that you are for, but also being willing to say no to some things. And I've got to tell you, Governor Romney, when it comes to his own party during the course of this campaign, has not displayed that willingness to say no to some of the more extreme parts of his party. Closing Statements Mr. Lehrer. That brings us to closing statements. There was a coin toss. Governor Romney, you won the toss and you elected to go last. So you have a closing 2 minutes, Mr. President. The President. Well, Jim, I want to thank you. And I want to thank Governor Romney, because I think this was a terrific debate and I very much appreciate it. And I want to thank the University of Denver. Four years ago, we were going through a major crisis. And yet my faith and confidence in the American future is undiminished. And the reason is because of its people. Because of the woman I met in North Carolina who decided at 55 to go back to school because she wanted to inspire her daughter and now has a job from that new training that she's gotten. Because of a company in Minnesota who was willing to give up salaries and perks for their executives to make sure that they didn't lay off workers during a recession. The autoworkers that you meet in Toledo or Detroit take such pride in building the best cars in the world, not just because of a paycheck, but because it gives them that sense of pride that they're helping to build America. And so the question now is, how do we build on those strengths? And everything that I've tried to do and everything that I'm now proposing for the next 4 years in terms of improving our education system or developing American energy, or making sure that we're closing loopholes for companies that are shipping jobs overseas and focusing on small businesses and companies that are creating jobs here in the United States, or closing our deficit in a responsible, balanced way that allows us to invest in our future, all those things are designed to make sure that the American people—their genius, their grit, their determination is channeled and they have an opportunity to succeed and everybody's getting a fair shot and everybody's getting a fair share—everybody's doing a fair share and everybody's playing by the same rules. Four years ago, I said that I'm not a perfect man and I wouldn't be a perfect President. And that's probably a promise that Governor Romney thinks I've kept. [Laughter] But I also promised that I'd fight every single day on behalf of the American people and the middle class and all those who are striving to get into the middle class. I've kept that promise. And if you'll vote for me, then I promise I'll fight just as hard in a second term. Mr. Lehrer. Governor Romney, your 2-minute closing. Gov. Romney. Thank you, Jim and Mr. President. And thank you for tuning in this evening. This is a—this is an important election, and I'm concerned about America. I'm concerned about the direction America has been taking over the last 4 years. I know this is bigger than an election about the two of us as individuals. It's bigger than our respective parties. It's an election about the course of America: what kind of America do you want to have for yourself and for your children. And there really are two very different paths that we began speaking about this evening. And over the course of this month we're going to have two more Presidential debates and a Vice Presidential debate; we'll talk about those paths. But they lead in very different directions. And it's not just looking to our words that you have to take into evidence of where they go; you can look at the record. There's no question in my mind that if the President were to be reelected, you'll continue to a see a middle class squeeze, with incomes going down and prices going up. I'll get incomes up again. You'll see chronic unemployment. We've had 43 straight months with unemployment above 8 percent. If I'm President, I will create—help create 12 million new jobs in this country with rising incomes. If the President's reelected, Obamacare will be fully installed. In my view, that's going to mean a whole different way of life for people who counted on the insurance plan they had in the past. Many will lose it. You're going to see health premiums go up by some $2,500 per family. If I'm elected, we won't have Obamacare. We'll put in place the kind of principles that I put in place in my own State and allow each State to craft their own programs to get people insured, and we'll focus on getting the cost of health care down. If the President were to be reelected, you're going to see a $716 billion cut to Medicare. You'll have 4 million people who will lose Medicare Advantage. You'll have hospitals and providers that will no longer accept Medicare patients. I'll restore that $716 billion to Medicare. And finally, military. If the President's reelected, you'll see dramatic cuts to our military. The Secretary of Defense has said these would be even devastating. I will not cut our commitment to our military. I will keep America strong and get America's middle class working again. Thank you, Jim. Mr. Lehrer. Thank you, Governor. Thank you, Mr. President. The next debate will be the Vice Presidential event on Thursday, October 11, at Centre College in Danville, Kentucky. For now, from the University of Denver, I'm Jim Lehrer. Thank you, and good night.
