# Presidential Debate in Cleveland

**Date:** October 28, 1980
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-cleveland

---

MRS. HINERFELD. Good evening. I'm Ruth Hinerfeld of the League of Women Voters Education Fund. Next Tuesday is election day. Before going to the polls, voters want to understand the issues and know the candidates' positions. Tonight, voters will have an opportunity to see and hear the major party candidates for the Presidency state their views on issues that affect us all. The League of Women Voters is proud to present this Presidential debate. Our moderator is Howard K. Smith. MR. SMITH. Thank you, Mrs. Hinerfeld. The League of Women Voters is pleased to welcome to the Cleveland, Ohio, Convention Center Music Hall President Jimmy Carter, the Democratic Party's candidate for reelection to the Presidency, and Governor Ronald Reagan of California, the Republican Party's candidate for the Presidency. The candidates will debate questions on domestic, economic, foreign policy, and national security issues. The questions are going to be posed by a panel of distinguished journalists who are here with me. They are: Marvin Stone, the editor of U.S. News and World Report; Harry Ellis, national correspondent of the Christian Science Monitor; William Hilliard, assistant managing editor of the Portland Oregonian; Barbara Walters, correspondent, ABC News. The ground rules for this, as agreed by you gentlemen, are these: Each panelist down here will ask a question, the same question, to each of the two candidates. After the two candidates have answered, a panelist will ask followup questions to try to sharpen the answers. The candidates will then have an opportunity each to make a rebuttal. That will constitute the first half of the debate, and I will state the rules for the second half later on. Some other rules: The candidates are not permitted to bring prepared notes to the podium, but are permitted to make notes during the debate. If the candidates exceed the allotted time agreed on, I will reluctantly but certainly interrupt. We ask the Convention Center audience here to abide by one ground rule: Please do not applaud or express approval or disapproval during the debate. Now, based on a toss of the coin, Governor Reagan will respond to the first question from Marvin Stone. QUESTIONS U.S. ARMED FORCES MR. STONE. Governor, as you're well aware, the question of war and peace has emerged as a central issue in this campaign in the give-and-take of recent weeks. President Carter's been criticized for responding late to aggressive Soviet impulses, for insufficient buildup of our Armed Forces, and a paralysis in dealing with Afghanistan and Iran. You have been criticized for being all too quick to advocate the use of lots of muscle, military action, to deal with foreign crises. Specifically, what are the differences between the two of you on the uses of American military power? GOVERNOR REAGAN. I don't know what the differences might be, because I don't know what Mr. Carter's policies are. I do know what he has said about mine. And I'm only here to tell you that I believe with all my heart that our first priority must be world peace, and that use of force is always and only a last resort, when everything else has failed, and then only with regard to our national security. Now, I believe, also that this meeting, this mission, this responsibility for preserving the peace, which I believe is a responsibility peculiar to our country, that we cannot shirk our responsibility as the leader of the Free World, because we're the only one that can do it. And therefore, the burden of maintaining the peace falls on us. And to maintain that peace requires strength. America has never gotten in a war because we were too strong. We can get into a war by letting events get out of hand, as they have in the last 3Â¼ years under the foreign policies of this administration of Mr. Carter's, until we're faced each time with a crisis. And good management in preserving the peace requires that we control the events and try to intercept before they become a crisis. But I have seen four wars in my lifetime. I'm a father of sons; I have a grandson. I don't ever want to see another generation of young Americans bleed their lives into sandy beachheads in the Pacific, or rice paddies and jungles in Asia, or the muddy, bloody battlefields of Europe. MR. SMITH. Mr. Stone, do you have a followup question for the Governor? MR. STONE. Yes. Governor, we've been hearing that the defense buildup that you would associate yourself with would cost tens of billions of dollars more than is now contemplated. In assuming that the American people are ready to bear this cost, they nevertheless keep asking the following question: How do you reconcile huge increases in military outlays with your promise of substantial tax cuts and of balancing the budget, which in this fiscal year, the one that just ended, ran more than $60 billion in the red? GOVERNOR REAGAN. Mr. Stone, I have submitted an economic plan that I've worked out in concert with a number of fine economists in this country, all of whom approve it, and believe that over a 5-year projection, this plan can permit the extra spending for needed refurbishing of our defensive posture, that it can provide for a balanced budget by 1983, if not earlier, and that we can afford-along with the cuts that I have proposed in Government spending — we can afford the tax cuts I have proposed — and probably, mainly because Mr. Carter's economic policy has built into the next 5 years, and on beyond that, a tax increase that will be taking $86 billion more next year out of the people's pockets than was taken this year. And my tax cut does not come close to eliminating that $86 billion increase. I'm only reducing the amount of the increase. In other words, what I'm talking about is not putting Government back to getting less money than Government's been getting, but simply cutting the increase in spending. MR. SMITH. The same question now goes to President Garter. President Carter, would you like to have the question repeated? THE PRESIDENT. Yes. MR. STONE. Yes, President Carter, the question of war and peace, a central issue in this campaign. You've been criticized in the give-and-take for responding late to aggressive Soviet impulses, for an insufficient buildup of our Armed Forces, and a paralysis in dealing with Afghanistan and Iran. Governor Reagan, on the other hand, has been criticized for being all too quick to advocate the use of lots of muscle, military action, to deal with foreign crises such as I mentioned. Specifically, what are the differences between the two of you on the uses of American military power? THE PRESIDENT. Mr. Stone, I've had to make thousands of decisions since I've been President, serving in the Oval Office. And with each one of those decisions that affect the future of my country, I have learned in the process. I think I'm a much wiser and more experienced man than I was when I debated 4 years ago against President Ford. I've also learned that there are no simple answers to complicated questions. H. L. Mencken said that for every problem there's a simple answer. It would be neat and plausible — and wrong. The fact is that this Nation, in the 8 years before I became President, had its own military strength decreased. Seven out of eight years, the budget commitments for defense went down, 37 percent, in all. Since I've been in office, we've had a steady, carefully planned, methodical but very effective increase in our commitment for defense. But what we've done is to use that enormous power and prestige and military strength of the United States to preserve the peace. We've not only kept peace for our own country, but we've been able to extend the benefits of peace to others. In the Middle East, we've worked for a peace treaty between Israel and Egypt, successfully, and have tied ourselves together with Israel and Egypt in a common defense capability. This is a very good step forward for our Nation's security, and we'll continue to do as we've done in the past. I might also add that there are decisions that are made in the Oval Office by every President which are profound in nature. There are always troublespots in the world, and how those troubled areas are addressed by a President, alone in that Oval Office, affects our Nation directly, the involvement of the United States and also our American interests. That is a basic decision that has to be made so frequently by every President who serves. That's what I've tried to do, successfully, by keeping our country at peace. MR. SMITH. Mr. Stone, do you have a followup on — MR. STONE. Yes. I would like to be a little more specific on the use of military power, and let's talk about one area for a moment. Under what circumstances would you use military forces to deal with, for example, a shutoff of Persian Oil Gulf, if that should occur, or to counter Russian expansion beyond Afghanistan into either Iran or Pakistan? I ask this question in view of charges that we are woefully unprepared to project sustained — and I emphasize the word "sustained" — power in that part of the world. THE PRESIDENT. Mr. Stone, in my State of the Union address earlier this year, I pointed out that any threat to the stability or security of the Persian Gulf would be a threat to the security of our own country. In the past, we've not had an adequate military presence in that region. Now we have two major carrier task forces. We have access to facilities in five different areas of that region. And we've made it clear that working with our allies and others, that we are prepared to address any foreseeable eventuality which might interrupt commerce with that crucial area of the world. But in doing this, we have made sure that we address this question peacefully, not injecting American military forces into combat, but letting the strength of our Nation be felt in a beneficial way. This, I believe, has assured that our interests will be protected in the Persian Gulf region, as we've done in the Middle East and throughout the world. MR. SMITH. Governor Reagan, you have a minute to comment or rebut. GOVERNOR REAGAN. Well, yes, I question the figure about the decline in defense spending under the two previous administrations, in the preceding 8 years to this administration. I would call to your attention that we were in a war that wound down during those 8 years, which of course made a change in military spending because of turning from war to peace. I also would like to point out that Republican Presidents in those years, faced with a Democratic majority in both Houses of the Congress, found that their requests for defense budgets were very often cut. Now, Gerald Ford left a 5-year projected plan for a military buildup to restore our defenses, and President Garter's administration reduced that by 38 percent, cut 60 ships out of the Navy building program that had been proposed, and stopped the B-1, delayed the cruise missile, stopped the production line for the Minuteman missiles, delayed the Trident submarine, and now is planning a mobile military force that can be delivered to various spots in the world — which does make me question his assaults on whether I am the one that is quick to look for use of force. MR. SMITH. President Carter, you have the last word on this question. THE PRESIDENT. Well, there are various elements of defense. One is to control nuclear weapons, which I hope we'll get to later on, because that's the most important single issue in this campaign. Another one is how to address troubled areas of the world. I think, habitually, Governor Reagan has advocated the injection of military forces into troubled areas, when I and my predecessors both Democrats and Republicans — have advocated resolving those troubles and those difficult areas of the world peacefully, diplomatically, and through negotiation. In addition to that, the buildup of military forces is good for our country, because we've got to have military strength in order to preserve the peace. But I'll always remember that the best weapons are the ones that are never fired in combat, and the best soldier is one who never has to lay his life down on the field of battle. Strength is imperative for peace, but the two must go hand in hand. MR. SMITH. Thank you, gentlemen. The next question is from Harry Ellis to President Carter. THE NATION'S ECONOMY MR. ELLIS. Mr. President, when you were elected in 1976, the Consumer Price Index stood at 4.8 percent. It now stands at more than 12 percent. Perhaps more significantly, the Nation's broader, underlying inflation rate has gone up from 7 to 9 percent. Now, a part of that was due to external factors beyond U.S. control, notably the more than doubling of oil prices by OPEC last year. Because the United States remains vulnerable to such external shocks, can inflation in fact be controlled? If so, what measures would you pursue in a second term? THE PRESIDENT. Again it's important to put the situation into perspective. In 1974 we had a so-called oil shock, wherein the price of OPEC oil was raised to an extraordinary degree. We had an even worse oil shock in 1979. In 1974 we had the worst recession, the deepest and most penetrating recession since the Second World War. The recession that resulted this time was the briefest we've had since the Second World War. In addition, we've brought down inflation. Earlier this year, the first quarter, we did have a very severe inflation pressure, brought about by the OPEC price increase. It averaged about 18 percent the first quarter of this year. The second quarter, we had dropped it down to about 13 percent. The most recent figures, the last 3 months, or the third quarter of this year, the inflation rate is 7 percent — still too high, but it illustrates very vividly that in addition to providing an enormous number of jobs — 9 million new jobs in the last 3 1/2 years — that the inflationary threat is still urgent on us. I noticed that Governor Reagan recently mentioned the Reagan-Kemp-Roth proposal, which his own running mate, George Bush, described as voodoo economics, and said that it would result in a 30-percent inflation rate. And Business Week, which is not a Democratic publication, said that this Reagan-Kemp-Roth proposal — and I quote them, I think-was completely irresponsible and would result in inflationary pressures which would destroy this Nation. So, our proposals are very sound and very carefully considered to stimulate jobs, to improve the industrial complex of this country, to create tools for American workers, and at the same time would be anti-inflationary in nature. So, to add 9 million new jobs, to control inflation, and to plan for the future with the energy policy now intact as a foundation is our plan for the years ahead. MR. SMITH. Mr. Ellis, do you have a followup question for Mr. Carter? MR. ELLIS. Yes, Mr. President. You have mentioned the creation of 9 million new jobs. THE PRESIDENT. Yes. MR. ELLIS. At the same time, the unemployment rate still hangs high, as does the inflation rate. Now, I wonder, can you tell us what additional policies you would pursue in a second administration in order to try to bring down that inflation rate? And would it be an act of leadership to tell the American people they're going to have to sacrifice to adopt a leaner lifestyle for some time to come? THE PRESIDENT. Yes. We have demanded that the American people sacrifice, and they've done very well. As a matter of fact, we're importing today about one-third less oil from overseas than we did just a year ago. We've had a 25-percent reduction since the first year I was in office. At the same time, as I said earlier, we have added about 9 million net new jobs in that period of time — a record never before achieved. Also, the new energy policy has been predicated on two factors: One, conservation, which requires sacrifice, and the other one, increase in production of American energy, which is going along very well — more coal this year than ever before in history, more oil and gas wells drilled this year than ever before in history. The new economic revitalization program that we have in mind, which will be implemented next year, would result in tax credits which would let business invest in new tools and new factories to create even more new jobs — about a million in the next 2 years. And we also have planned a youth employment program which would encompass 600,000 jobs for young people. This has already passed the House; now has an excellent prospect to pass the Senate. MR. SMITH. Now, the same question goes to Governor Reagan. Governor Reagan, would you like to have the question repeated? GOVERNOR REAGAN. Yes, please. MR. ELLIS. Governor Reagan, during the past 4 years, the Consumer Price Index has risen from 4.8 percent to currently over 12 percent. And perhaps more significantly, the Nation's broader, underlying rate of inflation has gone up from 7 to 9 percent. Now, a part of that has been due to external factors beyond U.S. control, and notably, the more than doubling of OPEC oil prices last year, which leads me to ask you whether, since the United States remains vulnerable to such external shocks, can inflation in fact be controlled? If so, specifically what measures would you pursue? GOVERNOR REAGAN. Mr. Ellis, I think this idea that has been spawned here in our country, that inflation somehow came upon us like a plague and therefore it's uncontrollable and no one can do anything about it, is entirely spurious, and it's dangerous to say this to the people. When Mr. Carter became President, inflation was 4.8 percent, as you said. It had been cut in two by President Gerald Ford. It is now running at 12.7 percent. President Carter also has spoken of the new jobs created. Well, we always, with the normal growth in our country and increase in population, increase the number of jobs. But that can't hide the fact that there are 8 million men and women out of work in America today, and 2 million of those lost their jobs in just the last few months. Mr. Carter had also promised that he would not use unemployment as a tool to fight against inflation. And yet, his 1980 economic message stated that we would reduce productivity and gross national product and increase unemployment in order to get a handle on inflation, because in January, at the beginning of the year, it was more than 18 percent. Since then, he has blamed to the people for inflation, OPEC, he's blamed the Federal Reserve System, he has blamed the lack of productivity of the American people, he has then accused the people of living too well and that we must share in scarcity, we must sacrifice and get used to doing with less. We don't have inflation because the people are living too well. We have inflation because the Government is living too well. And the last statement, just a few days ago, was a speech to the effect that we have inflation because Government revenues have not kept pace with Government spending. I see my time is running out here. I'll have to get this down very fast. Yes, you can lick inflation by increasing productivity and by decreasing the cost of Government to the place that we have balanced budgets and are no longer grinding out printing press money, flooding the market with it because the Government is spending more than it takes in. And my economic plan calls for that. The President's economic plan calls for increasing the taxes to the point that we finally take so much money away from the people that we can balance the budget in that way. But we'll have a very poor nation and a very unsound economy if we follow that path. MR. SMITH. A followup, Mr. Ellis? MR. ELLIS. Yes, you have centered on cutting Government spending in what you have just said about your own policies. You have also said that you would increase defense spending. Specifically, where would you cut Government spending if you were to increase defense spending and also cut taxes, so that, presumably, Federal revenues would shrink? GOVERNOR REAGAN. Well, most people, when they think about cutting Government spending, they think in terms of eliminating necessary programs or wiping out something, some service that Government is supposed to perform. I believe that there is enough extravagance and fat in Government. As a matter of fact, one of the Secretaries of HEW under Mr. Carter testified that he thought there was $7 billion worth of fraud and waste in welfare and in the medical programs associated with it. We've had the General Accounting Office estimate that there is probably tens of billions of dollars that is lost in fraud alone, and they have added that waste adds even more to that. We have a program for a gradual reduction of Government spending based on these theories, and I have a task force now that has been working on where those cuts could be made. I'm confident that it can be done and that it will reduce inflation, because I did it in California. And inflation went down below the national average in California when we returned money to the people and reduced government spending. MR. SMITH. President Carter. THE PRESIDENT. Governor Reagan's proposal, the Reagan-Kemp-Roth proposal, is one of the most highly inflationary ideas that ever has been presented to the American public. He would actually have to cut Government spending by at least $130 billion in order to balance the budget under this ridiculous proposal. I noticed that his task force that's working for his future plans had some of their ideas revealed in the Wall Street Journal this week. One of those ideas was to repeal the minimum wage, and several times this year, Governor Reagan has said that the major cause of unemployment is the minimum wage. This is a heartless kind of approach to the working families of our country which is typical of many Republican leaders in the past, but I think has been accentuated under Governor Reagan. In California — I'm surprised Governor Reagan brought this up — he had the three largest tax increases in the history of that State under his administration. He more than doubled State spending while he was Governor — 122-percent increase — and had between a 20- and 30-percent increase in the number of employees — MR. SMITH. Sorry to interrupt — THE PRESIDENT. — in California. MR. SMITH. — Mr. Carter. THE PRESIDENT. Thank you, sir. MR. SMITH. Governor Reagan has the last word on this question. GOVERNOR REAGAN. Yes. The figures that the President has just used about California is a distortion of the situation there, because while I was Governor of California, our spending in California increased less per capita than the spending in Georgia while Mr. Carter was Governor of Georgia in the same 4 years. The size of government increased only onesixth in California of what it increased in proportion to population in Georgia. And the idea that my tax-cut proposal is inflationary: I would like to ask the President, why is it inflationary to let the people keep more of their money and spend it the way they'd like, and it isn't inflationary to let him take that money and spend it the way he wants? MR. SMITH. I wish that question need not be rhetorical, but it must be because we've run out of time on that. [Laughter] Now, the third question to Governor Reagan from William Hilliard. URBAN POLICIES MR. HILLIARD. Yes, Governor Reagan, the decline of our cities has been hastened by the continual rise in crime, strained race relations, the fall in the quality of public education, the persistence of abnormal poverty in a rich nation, and a decline in the services to the public. The signs seem to point toward a deterioration that could lead to the establishment of a permanent underclass in the cities. What, specifically, would you do in the next 4 years to reverse this trend? GOVERNOR REAGAN. I have been talking to a number of Congressmen who have much the same idea that I have, and that is that in the inner-city areas, that in cooperation with local government and with National Government, and using tax incentives and with cooperation with the private sector, that we have development zones. Let the local entity, the city, declare this particular area, based on the standards of the percentage of people on welfare, unemployed, and so forth, in that area. And then, through tax incentives, induce the creation of businesses providing jobs and so forth in those areas. The elements of government through these tax incentives for example, a business that would not have, for a period of time, an increase in the property tax reflecting its development of the unused property that it was making wouldn't be any loss to the city, because the city isn't getting any tax from that now. And there would simply be a delay, and on the other hand, many of the people that would then be given jobs are presently wards of the Government, and it wouldn't hurt to give them a tax incentive, because that wouldn't be costing Government anything either. I think there are things to do in this regard. I stood in the South Bronx on the exact spot that President Carter stood on in 1977. You have to see it to believe it. It looks like a bombed-out city — great, gaunt skeletons of buildings, windows smashed out, painted on one of them "Unkept promises," on another, "Despair." And this was the spot at which President Carter had promised that he was going to bring in a vast program to rebuild this area. There are whole blocks of land that are left bare, just bulldozed down flat, and nothing has been done. And they are now charging to take tourists through there to see this terrible desolation. I talked to a man just briefly there who asked me one simple question: "Do I have reason to hope that I can someday take care of my family again? Nothing has been done." MR. SMITH. Follow-up, Mr. Hilliard? MR. HILLIARD. Yes, Governor Reagan. Blacks and other nonwhites are increasing in numbers in our cities. Many of them feel that they are facing a hostility from whites that prevents them from joining the economic mainstream of our society. There is racial confrontation in the schools, on jobs, and in housing, as nonwhites seek to reap the benefits of a free society. What do you think is the Nation's future as a multiracial society? GOVERNOR REAGAN. I believe in it. I am eternally optimistic, and I happen to believe that we've made great progress from the days when I was young and when this country didn't even know it had a racial problem. I know those things can grow out of despair in an inner city, when there's hopelessness at home, lack of work, and so forth. But I believe that all of us together — and I believe the Presidency is what Teddy Roosevelt said it was; it's a bully pulpit — and I think that something can be done from there, because the goal for all of us should be that one day, things will be done neither because of nor in spite of any of the differences between us — ethnic differences or racial differences, whatever they may be — that we will have total equal opportunity for all people. And I would do everything I could in my power to bring that about. MR. SMITH. Mr. Hilliard, would you repeat your question for President Carter? MR. HILLIARD. President Carter, the decline of our cities has been hastened by the continual rise in crime, strained race relations, the fall in the quality of public education, the persistence of abnormal poverty in a rich nation, and a decline in services to the public. The signs seem to point toward a deterioration that could lead to the establishment of a permanent underclass in the cities. What, specifically, would you do in the next 4 years to reverse this trend? THE PRESIDENT. Thank you, Mr. Hilliard. When I was campaigning in 1976, everywhere I went the mayors and local officials were in despair about the rapidly deteriorating central cities of our Nation. We initiated a very fine urban renewal program, working with the mayors, the Governors, and other interested officials. This has been a very successful effort. That's one of the main reasons that we've had such an increase in the number of people employed. Of the 9 million people put to work in new jobs since I've been in office, 1.3 million of those has been among black Americans and another million among those who speak Spanish. We now are planning to continue the revitalization program with increased commitments of rapid transit, mass transit. Under the windfall profits tax, we expect to spend about $43 billion in the next 10 years to rebuild the transportation systems of our country. We also are pursuing housing programs. We've had a 73-percent increase in the allotment of Federal funds for improved education. These are the kinds of efforts worked on a joint basis with community leaders, particularly in the minority areas of the central cities that had been deteriorating so rapidly in the past. It's very important to us that this be done with the full involvement of minority citizens. I've brought into the top levels of Government — into the White House, into administrative offices of the executive branch, into the judicial system — highly qualified black and Spanish citizens and women who in the past had been excluded. I noticed that Governor Reagan said that when he was a younger man that there was no knowledge of a racial problem in this country. Those who suffered from discrimination because of race or sex certainly knew we had a racial problem. We have gone a long way toward correcting these problems, but we still have a long way to go. MR. SMITH. A followup question? MR. HILLIARD. Yes, President Carter, I'd like to repeat the same followup to you. Blacks and other nonwhites are increasing in numbers in our cities. Many of them feel that they are facing a hostility from whites that prevents them from joining the economic mainstream of our society. There is racial confrontation in the schools, on jobs, and in housing, as nonwhites seek to reap the benefits of a free society. What is your assessment of the Nation's future in a multiracial society? THE PRESIDENT. Ours is a nation of refugees, a nation of immigrants. Almost all of our citizens came here from other lands and now have hopes, which are being realized, for a better life, preserving their ethnic commitments, their family structures, their religious beliefs, preserving their relationships with their relatives in foreign countries, but still forming themselves together in a very coherent society, which gives our Nation its strength. In the past, those minority groups have often been excluded from participation in the affairs of government. Since I've been President, I've appointed, for instance, more than twice as many black Federal judges as all previous Presidents in the history of this country. I've done the same thing in the appointment of women, and also Spanish-speaking Americans. To involve them in administration of government and a feeling that they belong to the societal structure that makes decisions in the judiciary and in executive branch is a very important commitment which I am trying to realize and will continue to do so in the future. MR. SMITH. Governor Reagan, you have a minute for rebuttal. GOVERNOR REAGAN. Yes. The President talks of Government programs, and they have their place. But as Governor, when I was at that end of the line and receiving some of these grants for Government programs, I saw that so many of them were dead-end. They were public employment for these people who really want to get out into the private job market, where there are jobs with a future. Now, the President spoke a moment ago about — that I was against the minimum wage. I wish he could have been with me when I sat with a group of teenagers who were black and who were telling me about their unemployment problems, and that it was the minimum wage that had done away with the jobs that they once could get. And indeed, every time it has increased you will find there is an increase in minority unemployment among young people. And therefore, I have been in favor of a separate minimum for them. With regard to the great progress that has been made with this Government spending, the rate of black unemployment in Detroit, Michigan, is 56 percent. MR. SMITH. President Garter, you have the last word on this question. THE PRESIDENT. Well, it's obvious that we still have a long way to go in fully incorporating the minority groups into the mainstream of American life. We have made good progress, and there's no doubt in my mind that the commitment to unemployment compensation, the minimum wage, welfare, national health insurance, those kinds of commitments that have typified the Democratic Party since ancient history in this country's political life are a very important element of the future. In all those elements, Governor Reagan has repeatedly spoken out against them, which, to me, shows a very great insensitivity to giving deprived families a better chance in life. This, to me, is a very important difference between him and me in this election, and I believe the American people will judge accordingly. There is no doubt in my mind that in the downtown, central cities, with the new commitment on an energy policy, with a chance to revitalize homes and to make them more fuel-efficient, with a chance for a synthetic fuels program, solar power, this will give us an additional opportunity for jobs which will pay rich dividends. MR. SMITH. Thank you, gentlemen. Now for the fourth question, to President Garter from Barbara Walters. INTERNATIONAL TERRORISM MS. WALTERS. Mr. President, the eyes of the country tonight are on the hostages in Iran. I realize this is a sensitive area, but the question of how we respond to acts of terrorism goes beyond this current crisis. Other countries have policies that determine how they will respond. Israel, for example, considers hostages like soldiers and will not negotiate with terrorists. For the future, Mr. President, the country has the right to know, do you have a policy for dealing with terrorism wherever it might happen, and what have we learned from this experience in Iran that might cause us to do things differently if this or something similar happens again? THE PRESIDENT. Barbara, one of the blights on this world is the threat and the activities of terrorists. At one of the recent economic summit conferences between myself and the other leaders of the We. stern world, we committed ourselves to take strong action against terrorism. Airplane hijacking was one of the elements of that commitment. There is no doubt that we have seen in recent years, in recent months, additional acts of violence against Jews in France and, of course, against those who live in Israel by the PLO and other terrorist organizations. Ultimately, the most serious terrorist threat is if one of those radical nations, who believe in terrorism as a policy, should have atomic weapons. Both I and all my predecessors have had a deep commitment to controlling the proliferation of nuclear weapons in countries like Libya or Iraq. We have even alienated some of our closest trade partners, because we have insisted upon the control of the spread of nuclear weapons to those potentially terrorist countries. When Governor Reagan has been asked about that, he makes a very disturbing comment that nonproliferation, or the control of the spread of nuclear weapons, is none of our business. And when he was asked specifically, recently, about Iraq, he said there's nothing we can do about it. This ultimate terrorist threat is the most fearsome of all, and it's part of a pattern where our country must stand firm to control terrorism of all kinds. MR. SMITH. Ms. Walters, a followup? MS. WALTERS. Yes. While we are discussing policy, had Iran not taken American hostages, I assume that, in order to preserve our neutrality, we would have stopped the flow of spare parts and vital war materiels once war broke out between Iraq and Iran. Now, we're offering to lift the ban on such goods if they let our people come home. Doesn't this reward terrorism, compromise our neutrality, and possibly antagonize nations now friendly to us in the Middle East? THE PRESIDENT. We will maintain our position of neutrality in the Iran and Iraq war. We have no plans to sell additional materiel or goods to Iran that might be of a warlike nature. When I made my decision to stop all trade with Iran as a result of the taking of our hostages, I announced then and have consistently maintained since then that if the hostages are released safely, that we would make delivery on those items which Iran owns, which they have bought and paid for-also, that the frozen Iranian assets would be released. That's been a consistent policy, one I intend to carry out. MR. SMITH. Would you repeat the question now for Governor Reagan, please, Ms. Walters? Ms. WALTERS. Yes. Governor, the eyes of the country tonight remain on the hostages in Iran, but the question of how we respond to acts of terrorism goes beyond this current crisis. There are other countries that have policies that determine how they will respond. Israel, for example, considers hostages like soldiers and will not negotiate with terrorists. For the future, the country has the right to know, do you have a policy for dealing with terrorism wherever it might happen, and what have we learned from this experience in Iran that might cause us to do things differently if this, or something similar, should happen again? GOVERNOR REAGAN. Well, Barbara, you've asked that question twice. I think you ought to have at least one answer to it. [Laughter] I have been accused lately of having a secret plan with regard to the hostages. Now, this comes from an answer that I've made at least 50 times during this campaign to the press. The question would be, "Have you any ideas of what you would do if you were there?" And I said, well, yes. And I think that anyone that's seeking this position, as well as other people, probably, have thought to themselves, "What about this, what about that?" These are just ideas of what I would think of if I were in that position and had access to the information, in which I would know all the options that were open to me. I have never answered the question, however. Second — the one that says, "Well, tell me, what are some of those ideas?" First of all, I would be fearful that I might say something that was presently under way or in negotiations, and thus expose it and endanger the hostages. And sometimes, I think some of my ideas might involve quiet diplomacy, where you don't say in advance or say to anyone what it is you're thinking of doing. Your question is difficult to answer, because, in the situation right now, no one wants to say anything that would inadvertently delay, in any way, the return of those hostages if there is a chance of their coming home soon, or that might cause them harm. What I do think should be done, once they are safely here with their families and that tragedy is over — and we've endured this humiliation for just lacking 1 week of a year now — then, I think, it is time for us to have a complete investigation as to the diplomatic efforts that were made in the beginning, why they have been there so long, and when they come home, what did we have to do in order to bring that about, what arrangements were made? And I would suggest that Congress should hold such an investigation. In the meantime, I'm going to continue praying that they'll come home. MR. SMITH. Follow-up question. Ms. WALTERS. Well, I would like to say that neither candidate answered specifically the question of a specific policy for dealing with terrorism, but I will ask Governor Reagan a different followup question. You have suggested that there would be no Iranian crisis had you been President, because we would have given firmer support to the Shah. But Iran is a country of 37 million people who were resisting a government they regarded as dictatorial. My question is not whether the Shah's regime was preferable to the Ayatollah's, but whether the United States has the power or the right to try to determine what form of government any country will have, and do we back unpopular regimes whose major merit is that they are friendly to the United States? GOVERNOR REAGAN. The degree of unpopularity of a regime when the choice is total authoritarianism — totalitarianism, I should say, in the alternative government, makes one wonder whether you are being helpful to the people. And we've been guilty of that. Because someone didn't meet exactly our standards of human rights, even though they were an ally of ours, instead of trying patiently to persuade them to change their ways, we have, in a number of instances, aided a revolutionary overthrow which results in complete totalitarianism, instead, for those people. And I think that this is a kind of a hypocritical policy when, at the same time, we're maintaining a detente with the one nation in the world where there are no human rights at all — the Soviet Union. Now, there was a second phase in the Iranian affair in which we had something to do with that. And that was, we had adequate warning that there was a threat to our Embassy, and we could have done what other Embassies did — either strengthen our security there or remove our personnel before the kidnap and the takeover took place. MR. SMITH. Governor, I'm sorry, I must interrupt. President Carter, you have a minute for rebuttal. THE PRESIDENT. I didn't hear any comment from Governor Reagan about what he would do to stop or to reduce terrorism in the future. What the Western allies did decide to do is to stop all air flights-commercial air flights — to any nation involved in terrorism or the hijacking of airplanes, or the harboring of hijackers. Secondly, we all committed ourselves, as have all my predecessors in the Oval Office, not to permit the spread of nuclear weapons to a terrorist nation or to any other nation that does not presently have those weapons or capabilities for explosives. Third, not to make any sales of materiel or weapons to a nation which is involved in terrorist activities. And, lastly, not to deal with the PLO until and unless the PLO recognizes Israel's right to exist and recognizes U.N. Resolution 242 as a basis for a Middle East peace. These are a few of the things to which our Nation is committed, and we will continue with these commitments. MR. SMITH. Governor Reagan, you have the last word on that question. GOVERNOR REAGAN. Yes. I have no quarrel whatsoever with the things that have been done, because I believe it is high time that the civilized countries of the world made it plain that there is no room worldwide for terrorism; there will be no negotiation with terrorists of any kind. And while I have a last word here, I would like to correct a misstatement of fact by the President. I have never made the statement that he suggested about nuclear proliferation, and nuclear proliferation, or the trying to halt it, would be a major part of a foreign policy of mine. Mr. SMITH. Thank you, gentlemen. That is the first half of the debate. Now, the rules for the second half, quite simple. They're only complicated when I explain them. [Laughter] In the second half, the panelists with me will have no followup questions. Instead, after the panelists have asked a question the candidates have answered, each of the candidates will have two opportunities to follow up, to question, to rebut, or just to comment on his opponent's statement. Governor Reagan will respond, in this section, to the first question from Marvin Stone. STRATEGIC ARMS LIMITATION Mr. STONE. Governor Reagan, arms control: The President said it was the single most important issue, Both of you have expressed the desire to end the nuclear arms race with Russia, but by methods that are vastly different. You suggest that we scrap the SALT II treaty, already negotiated, and intensify the buildup of American power to induce the Soviets to sign a new treaty, one more favorable to us. GOVERNOR REAGAN. Yes. MR. STONE. President Carter, on the other hand, says he will again try to convince a reluctant Congress to ratify the present treaty on the grounds it's the best we can hope to get. Now, both of you cannot be right. Will you tell us why you think you are? GOVERNOR REAGAN. Yes. I think I'm right, because I believe that we must have a consistent foreign policy, a strong America, and a strong economy. And then, as we build up our national security, to restore our margin of safety, we at the same time try to restrain the Soviet buildup, which has been going forward at a rapid pace and for quite some time. The SALT II treaty was the result of negotiations that Mr. Carter's team entered into after he had asked the Soviet Union for a discussion of actual reduction of nuclear strategic weapons, and his emissary, I think, came home in 12 hours having heard a very definite yet. But taking that one no from the Soviet Union, we then went back into negotiations on their terms, because Mr. Carter had canceled the B-1 bomber, delayed the MX, delayed the Trident submarine, delayed the cruise missile, shut down the Minuteman missile production line, and whatever other things that might have been done. The Soviet Union sat at the table knowing that we had gone forward with unilateral concessions without any reciprocation from them whatsoever. Now, I have not blocked the SALT II treaty, as Mr. Carter and Mr. Mondale suggest that I have. It has been blocked by a Senate in which there is a Democratic majority. Indeed, the Senate Armed Services Committee voted 10 to 0, with 7 abstentions, against the SALT II treaty, and declared that it was not in the national security interests of the United States-besides which, it is illegal, because the law of the land, passed by Congress, says we cannot accept a treaty in which we are not equal. And we're not equal in this treaty for one reason alone: Our B-52 bombers are considered to be strategic weapons; their Backfire bombers are not. MR. SMITH. Governor, I have to interrupt you at that point. The time is up for that. But the same question now to President Carter. MR. STONE. Yes, President Carter. Both of you have expressed the desire to end the nuclear arms race with Russia, but through vastly different methods. The Governor suggests we scrap the SALT II treaty, which you signed in Vienna — intensify the buildup of American power to induce the Soviets to sign a new treaty, one more favorable to us. You, on the other hand, say you will again try to convince a reluctant Congress to ratify the present treaty on the grounds it is the best we can hope to get from the Russians. You cannot both be right. Will you tell us why you think you are? THE PRESIDENT. Yes, I'd be glad to. Inflation, unemployment, the cities-all very important issues, but they pale into insignificance in the life and duties of a President when compared with the control of nuclear weapons. Every President who has served in the Oval Office since Harry Truman has been dedicated to the proposition of controlling nuclear weapons, to negotiate with the Soviet Union — balanced, controlled, observable, and then reducing levels of atomic weaponry. There is a disturbing pattern in the attitude of Governor Reagan. He has never supported any of those arms control agreements — the limited test ban, SALT I, nor the antiballistic missile treaty, nor the Vladivostok Treaty negotiated with the Soviet Union by President Ford — and now he wants to throw into the wastebasket a treaty to control nuclear weapons on a balanced and equal basis between ourselves and the Soviet Union, negotiated over a 7-year period, by myself and my two Republican predecessors. The Senate has not voted yet on the strategic arms limitation treaty. There have been preliminary skirmishings in the committees of the Senate, but the treaty has never come to the floor of the Senate for either a debate or a vote. It's understandable that a Senator in the preliminary debates can make an irresponsible statement, or, maybe, an ill-advised statement. You've got 99 other Senators to correct that mistake, if it is a mistake. But when a man who hopes to be President says, "Take this treaty, discard it, do not vote, do not debate, do not explore the issues, do not finally capitalize on this long negotiation" — that is a very dangerous and disturbing thing. MR. SMITH. Governor Reagan, you have an opportunity to rebut that. GOVERNOR REAGAN. Yes, I'd like to respond very much. First of all, the Soviet Union — if I have been critical of some of the previous agreements, it's because we've been outnegotiated for quite a long time. And they have managed, in spite of all of our attempts at arms limitation, to go forward with the biggest military buildup in the history of man. Now, to suggest that because two Republican Presidents tried to pass the SALT treaty — that puts them on its side — I would like to say that President Ford, who was within 90 percent of a treaty that we could be in agreement with when he left office, is emphatically against this SALT treaty. I would like to point out also that Senators like Henry Jackson and Hollings of South Carolina — they are taking the lead in the fight against this particular treaty. I am not talking of scrapping; I am talking of taking the treaty back and going back into negotiations. And I would say to the Soviet Union, we will sit and negotiate with you as long as it takes, to have not only legitimate arms limitation but to have a reduction of these nuclear weapons to the point that neither one of us represents a threat to the other. That is hardly throwing away a treaty and being opposed to arms limitation. MR. SMITH. President Carter? THE PRESIDENT. Yes. Governor Reagan is making some very misleading and disturbing statements. He not only advocates the scrapping of this treaty — and I don't know that these men that he quotes are against the treaty in its final form — but he also advocates the possibility-he said it's been a missing element-of playing a trump card against the Soviet Union of a nuclear arms race and insisting upon nuclear superiority by our own Nation as a predication for negotiation in the future with the Soviet Union. If President Brezhnev said, "We will scrap this treaty, negotiated under three American presidents over a 7-year period of time; we insist upon nuclear superiority as a basis for future negotiations; and we believe that the launching of a nuclear arms race is a good basis for future negotiations," it's obvious that I, as President, and all Americans would reject such a proposition. This would mean the resumption of a very dangerous nuclear arms race. It would be very disturbing to American people. It would change the basic tone and commitment that our Nation has experienced ever since the Second World War, with all Presidents, Democratic and Republican, and would also be very disturbing to our allies, all of whom support this nuclear arms treaty. In addition to that, the adversarial relationship between ourselves and the Soviet Union would undoubtedly deteriorate very rapidly. This attitude is extremely dangerous and belligerent in its tone, although it's said with a quiet voice. MR. SMITH. Governor Reagan? GOVERNOR REAGAN. I know the President's supposed to be replying to me, but sometimes, I have a hard time in connecting what he's saying with what I have said or what my positions are. I sometimes think he's like the witch doctor that gets mad when a good doctor comes along with a cure that'll work. My point I have made already, Mr. President, with regard to negotiating. It does not call for nuclear superiority on the part of the United States; it calls for a mutual reduction of these weapons, as I say, that neither of us can represent a threat to the other. And to suggest that the SALT II treaty that your negotiators negotiated was just a continuation, and based on all of the preceding efforts by two previous Presidents, is just not true. It was a new negotiation, because, as I say, President Ford was within about 10 percent of having a solution that could be acceptable. And I think our allies would be very happy to go along with a fair and verifiable SALT agreement. MR. SMITH. President Carter, you have the last word on this question. THE PRESIDENT. I think, to close out this discussion, it would be better to put into perspective what we're talking about. I had a discussion with my daughter, Amy, the other day, before I came here, to ask her what the most important issue was. She said she thought nuclear weaponry and the control of nuclear arms. This is a formidable force. Some of these weapons have 10 megatons of explosion. If you put 50 tons of TNT in each one of railroad cars, you would have a trainload of TNT stretching across this Nation. That's one major war explosion in a warhead. We have thousands, equivalent of megaton, or million tons, of TNT warheads. The control of these weapons is the single major responsibility of a President, and to cast out this commitment of all Presidents, because of some slight technicalities that can be corrected, is a very dangerous approach. MR. SMITH. We have to go to another question now, from Harry Ellis to President Carter. ENERGY MR. ELLIS. Mr. President, as you have said, Americans, through conservation, are importing much less oil today than we were even a year ago. Yet U.S. dependence on Arab oil as a percentage of total imports is today much higher than it was at the time of the 1973 Arab oil embargo. And for some time to come, the loss of substantial amounts of Arab oil could plunge the U.S. into depression. Now, this means that a bridge must be built out of this dependence. Can the United States develop synthetic fuels and other alternative energy sources without damage to the environment, and will this process mean steadily higher fuel bills for American families? THE PRESIDENT. I don't think there's any doubt that, in the future, the cost of oil is going to go up. What I've had as a basic commitment since I've been President is to reduce our dependence on foreign oil: It can only be done in two ways: one, to conserve energy, to stop the waste of energy, and secondly, to produce more American energy. We've been very successful in both cases. We've now reduced the importing of foreign oil in the last year alone by onethird. We imported today 2 million barrels of oil less than we did the same day just a year ago. This commitment has been opening up a very bright vista for our Nation in the future, because with the windfall profits tax as a base, we now have an opportunity to use American technology and American ability and American natural resources to expand rapidly the production of synthetic fuels, yes; to expand rapidly the production of solar energy, yes; and also to produce the conventional kinds of American energy. We will drill more oil and gas wells this year than any year in history. We'll produce more coal this year than any year in history. We're exporting more coal this year than any year in history. And we have an opportunity now, with improved transportation systems and improved loading facilities in our ports, to see a very good opportunity on the world international market, to replace OPEC oil with American coal as a basic energy source. This exciting future will not only give us more energy security but will also open up vast opportunities for Americans to live a better life and to have millions of new jobs associated with this new and very dynamic industry now in prospect because of the new energy policy that we've put into effect. MR. SMITH. Would you repeat the question now for Governor Reagan? MR. ELLIS. Governor Reagan, Americans, through conservation, are importing much less oil today than we were even a year ago. And yet, U.S. reliance on Arab oil as a percentage of total imports is much higher today than it was during the 1973 Arab oil embargo. And the substantial loss of Arab oil could plunge the United States into depression. The question is whether the development of alternative energy sources, in order to reduce this dependence, can be done without damaging the environment, and will it mean for American families steadily higher fuel bills? GOVERNOR REAGAN. I'm not sure that it means steadily higher fuel costs, but I do believe that this Nation has been portrayed for too long a time to the people as being energy-poor when it is energy-rich. The coal that the President mentioned: Yes, we have it, and yet one-eighth of our total coal resources is not being utilized at all right now. The mines are closed down; there are 22,000 miners out of work. Most of this is due to regulations which either interfere with the mining of it or prevent the burning of it. With our modern technology, yes, we can burn our coal within the limits of the Clean Air Act. I think, as technology improves, we'll be able to do even better with that. The other thing is that we have only leased out and begun to explore 2 percent of our Outer Continental Shelf for oil, where it is believed by everyone familiar with that fuel and that source of energy that there are vast supplies yet to be found. Our Government has, in the last year or so, taken out of multiple use millions of acres of public lands that once were — well, they were public lands subject to multiple-use exploration for minerals and so forth. It is believed that probably 70 percent of the potential oil in the United States is probably hidden in those lands, and no one is allowed to even go and explore to find out if it is there. This is particularly true of the recent efforts to shut down part of Alaska. Nuclear power: There were 36 powerplants planned in this country — and let me add the word "safety"; it must be done with the utmost of safety. But 32 of those have given up and canceled their plans to build, and again, because Government regulations and permits and so forth make it take more than twice as long to build a nuclear plant in the United States as it does to build one in Japan or in Western Europe. We have the sources here. We are energy-rich, and coal is one of the great potentials we have. MR. SMITH. President Carter, your comment? THE PRESIDENT. Yes, sir. To repeat myself, we have this year the opportunity, which we'll realize, to produce 800 million tons of coal — an unequaled record in the history of our country. Governor Reagan says that this is not a good achievement, and he blames restraints on coal production on regulations — regulations that affect the life and the health and safety of miners and also regulations that protect the purity of our air and the quality of our water and our land. We cannot cast aside those regulations. We have a chance in the next 15 years, insisting upon the health and safety of workers in the mines, and also preserving the same high air and water pollution standards, to triple the amount of coal we produce. Governor Reagan's approach to our energy policy, which has already proven its effectiveness, is to repeal or to change substantially the windfall profits tax, to return a major portion of $227 billion back to the oil companies, to do away with the Department of Energy, to shortcircuit our synthetic fuels program, to put a minimal emphasis on solar power, to emphasize strongly nuclear powerplants as a major source of energy in the future. He wants to put all our eggs in one basket and give that basket to the major oil companies. MR. SMITH. Governor Reagan. GOVERNOR REAGAN. That is a misstatement, of course, of my position. I just happen to believe that free enterprise can do a better job of producing the things that people need than Government can. The Department of Energy has a multibillion-dollar budget, in excess of $10 billion. It hasn't produced a quart of oil or a lump of coal or anything else in the line of energy. And for Mr. Carter to suggest that I want to do away with the safety laws and with the laws that pertain to clean water and clean air, and so forth as Governor of California, I took charge of passing the strictest air pollution laws in the United States — the strictest air quality law that has ever been adopted in the United States. And we created an OSHA, an occupational safety and health agency, for the protection of employees before the Federal Government had one in place. And to this day, not one of its decisions or rulings has ever been challenged. So, I think some of those charges are missing the point. I am suggesting that there are literally thousands of unnecessary regulations that invade every facet of business, and indeed, very much of our personal lives, that are unnecessary; that Government can do without; that have added $130 billion to the cost of production in this country; and that are contributing their part to inflation. And I would like to see us a little more free, as we once were. MR. SMITH. President Carter, another crack at that? THE PRESIDENT. Sure. As a matter of fact, the air pollution standard laws that were passed in California were passed over the objections of Governor Reagan, and this is a very well known fact. Also, recently, when someone suggested that the Occupational Safety and Health Act should be abolished, Governor Reagan responded, "Amen." The offshore drilling rights is a question that Governor Reagan raises often. As a matter of fact, in the proposal for the Alaska lands legislation, 100 percent of all the offshore lands would be open for exploration, and 95 percent of all the Alaska lands where it is suspected or believed that minerals might exist. We have, with our 5-year plan for the leasing of offshore lands, proposed more land to be drilled than has been opened up for drilling since this program first started in 1954. So, we're not putting restraints on American exploration; we're encouraging it in every way we can. MR. SMITH. Governor Reagan, you have the last word on this question. GOVERNOR REAGAN. Yes. If it is a wellknown fact that I opposed air pollution laws in California, the only thing I can possibly think of is that the President must be suggesting the law that the Federal Government tried to impose on the State of California — not a law, regulations that would have made it impossible to drive an automobile within the city limits of any California city, or have a place to put it if you did drive it against their regulations. It would have destroyed the economy of California, and, I must say, we had the support of Congress when pointed out how ridiculous this attempt was by the Environmental Protection Agency. We still have the strictest air control or air pollution laws in the country. As for offshore oiling, only 2 percent now is so leased and is producing oil. The rest, as to whether the lands are going to be opened in the next 5 years or so — we're already 5 years behind in what we should be doing. There is more oil now in the wells that have been drilled than has been taken out in the 121 years that they've been drilled. MR. SMITH. Thank you, Governor. Thank you, Mr. President. The next question goes to Governor Reagan from William Hilliard. SOCIAL SECURITY MR. HILLIARD. Governor Reagan, wage earners in this country — especially the young — are supporting a social security system that continues to affect their income drastically. The system is fostering a struggle between the young and the old, and is drifting the country toward a polarization of these two groups. How much longer can the young wage earner expect to bear the ever-increasing burden of the social security system? GOVERNOR REAGAN. The social security system was based on a false premise, with regard to how fast the number of workers would increase and how fast the number of retirees would increase. It is actuarially out of balance, and this first became evident about 16 years ago, and some of us were voicing warnings then. Now, it is trillions of dollars out of balance, and the only answer that has come so far is the biggest single tax increase in our Nation's history, the payroll tax increase for social security, which will only put a Band-aid on this and postpone the day of reckoning by a few years at most. What is needed is a study that I have proposed by a task force of experts to look into this entire problem as to how it can be reformed and made actuarially sound, but with the premise that no one presently dependent on social security is going to have the rug pulled out from under them and not get their check. We cannot frighten, as we have with the threats and the campaign rhetoric that has gone on in this campaign, our senior citizens, leave them thinking that in some way they're endangered and they would have no place to turn. They must continue to get those checks, and I believe that the system can be put on a sound actuarial basis. But it's going to take some study and some work, and not just passing a tax increase to let the roof fall in on the next administration. MR. SMITH. Would you repeat that question for President Carter? MR. HILLIARD. Yes, President Carter. Wage earners in this country, especially the young, are supporting a social security system that continues to affect their income drastically. The system is fostering a struggle between young and old and is drifting the country toward a polarization of these two groups. How much longer can the young wage earner expect to bear the ever-increasing burden of the social security system? THE PRESIDENT. As long as there's a Democratic President in the White House, we will have a strong and viable social security system, free of the threat of bankruptcy. Although Governor Reagan has changed his position lately, on four different occasions he has advocated making social security a voluntary system, which would, in effect, very quickly bankrupt it. I noticed also in the Wall Street Journal earlier this week that a preliminary report of his task force advocates making social security more sound by reducing the adjustments in social security for the retired people to compensate for the impact of inflation. These kinds of approaches are very dangerous to the security and the well-being, and the peace of mind of the retired people of this country and those approaching retirement age. But no matter what it takes in the future to keep social security sound, it must be kept that way. And although there was a serious threat to the social security system and its integrity during the 1976 campaign and when I became President, the action of the Democratic Congress, working with me, has been to put social security back on a sound financial basis. That's the way it will stay. MR. SMITH. Governor Reagan. GOVERNOR REAGAN. Well, that just isn't true. It has, as I said, delayed the actuarial imbalance falling on us for just a few years with that increase in taxes. And I don't believe we can go on increasing the tax, because the problem for the young people today is that they're paying in far more than they can ever expect to get out. Now, again this statement that somehow I wanted to destroy it, and I just changed my tune, that I am for voluntary social security, which would mean the ruin of it. Mr. President, the voluntary thing that I suggested many years ago was that a young man, orphaned and raised by an aunt who died, his aunt was ineligible for social security insurance, because she was not his mother. And I suggested that if this is an insurance program, certainly the person who's paying in should be able to name his own beneficiaries. And that's the closest I've ever come to anything voluntary with social security. I, too, am pledged to a social security program that will reassure these senior citizens of ours they're going to continue to get their money. Them are some changes I'd like to make. I would like to make a change that discriminates in the regulations against a wife who works and finds that she then is faced with a choice between her husband's benefits, if he dies first, or what she has paid in; but it does not recognize that she has also been paying in herself, and she is entitled to more than she presently can get. I'd like to change that. MR. SMITH. President Carter's rebuttal now. THE PRESIDENT. Fine. These constant suggestions that the basic social security system should be changed does cause concern and consternation among the aged of our country. It's obvious that we should have a commitment to them, that social security benefits should not be taxed, and that there would be no peremptory change in the standards by which social security payments are made to the retired people. We also need to continue to index the social security payments so that if inflation rises, the social security payments would rise a commensurate degree to let the buying power of the social security check continue intact. In the past, the relationship between social security and Medicare has been very important to provide some modicum of aid for senior citizens in the retention of health benefits. Governor Reagan, as a matter of fact, began his political career campaigning around this Nation against Medicare. Now we have an opportunity to move toward national health insurance, with an emphasis on the prevention of disease; an emphasis on outpatient care, not inpatient care; an emphasis on hospital cost containment to hold down the cost of hospital care for those who are ill; an emphasis on catastrophic health insurance, so that if a family is threatened with being wiped out economically because of a very high medical bill, then the insurance would help pay for it. These are the kind of elements of a national health insurance, important to the American people. Governor Reagan, again, typically is against such a proposal. MR. SMITH. Governor. GOVERNOR REAGAN. There you go again. [Laughter] When I opposed Medicare, there was another piece of legislation meeting the same problem before the Congress. I happened to favor the other piece of legislation and thought that it would be better for the senior citizens and provide better care than the one that was finally passed. I was not opposing the principle of providing care for them. I was opposing one piece of legislation as versus another. There is something else about social security — of course, that doesn't come out of the payroll tax; it comes out of the general fund — that something should be done about. I think it's disgraceful that the Disability Insurance Fund in social security finds checks going every month to tens of thousands of people who are locked up in our institutions for crime or for mental illness, and they are receiving disability checks from social security every month while a State institution provides for all of their needs and their care. MR. SMITH. President Carter, you have the last word on this question. THE PRESIDENT. I think this debate on social security, Medicare, national health insurance typifies as vividly as any other subject tonight the basic historical differences between the Democratic Party and the Republican Party. The allusions to basic changes in the minimum wage is another, and the deleterious comments that Governor Reagan has made about unemployment compensation. These commitments that the Democratic Party has historically made to the working families of this Nation have been extremely important to the growth in their stature and in a better quality of life for them. I noticed recently that Governor Reagan frequently quotes Democratic Presidents, in his acceptance address and otherwise. I have never heard a candidate for President, who is a Republican, quote a Republican President, but when they get in office, they try to govern like Republicans. So, its good for the American people to remember there is a sharp basic historical difference between Governor Reagan and me on these crucial issues-also, between the two parties that we represent. Â MR. SMITH. Thank you, Mr. President, Governor Reagan. Â We now go to another question, a question to President Carter by Barbara Walters. ASSESSMENTS OF OPPONENT MS. WALTERS. Thank you. You have addressed some of the major issues tonight, but the biggest issue in the minds of American voters is yourselves, your ability to lead this country. When many voters go into that booth just a week from today, they will be voting their gut instinct about you men. You've already given us your reasons why people should vote for you. Now would you please tell us for this your final question, why they should not vote for your opponent, why his Presidency could be harmful to the Nation and, having examined both your opponent's record and the man himself, tell us his greatest weakness. THE PRESIDENT. Barbara, reluctant as I am to say anything critical about Governor Reagan, I will try to answer your question. [Laughter] First of all, there's the historical perspective that I just described. This is a contest between a Democrat in the mainstream of my party, as exemplified by the actions that I've taken in the Oval Office the last 4 years, as contrasted with Governor Reagan, who in most cases does typify his party, but in some cases, there is a radical departure by him from the heritage of Eisenhower and others. The most important crucial difference in this election campaign, in my judgment, is the approach to the control of nuclear weaponry and the inclination to control or not to control the spread of atomic weapons to other nations that don't presently have it, particularly the terrorist nations. The inclination that Governor Reagan has exemplified in many troubled times since he's been running for President — I think since 1968 — to inject American military forces in places like North Korea, to put a blockade around Cuba this year, or in some instances, to project American forces into a fishing dispute against the small nation of Ecuador on the west coast of South America — this is typical of his longstanding inclination, on the use of American power, not to resolve disputes diplomatically and peacefully, but to show that the exercise of military power is best proven by the actual use of it. Obviously, no President wants war, and I certainly do not believe that Governor Reagan, if he were President, would want war. But a President in the Oval Office has to make a judgment on almost a daily basis about how to exercise the enormous power of our country for peace, through diplomacy, or in a careless way, in a belligerent attitude which has exemplified his attitudes in the past. MR. SMITH. Barbara, would you repeat the question for Governor Reagan? MS. WALTERS. Yes, thank you. Realizing that you may be equally reluctant to speak ill of your opponent, may I ask why people should not vote for your opponent, why his Presidency could be harmful to the Nation? And having examined both your opponent's record and the man himself, could you tell us his greatest weakness? GOVERNOR REAGAN. Well, Barbara, I believe that there is a fundamental difference-and I think it has been evident in most of the answers that Mr. Carter has given tonight — that he seeks the solution to anything as another opportunity for a Federal Government program. I happen to believe that the Federal Government has usurped powers and autonomy and authority that belongs back at the State and local level — it has imposed on the individual freedoms of the people — and that there are more of these things that could be solved by the people themselves, if they were given a chance, or by the levels of government that were closer to them. Now, as to why I should be and he shouldn't be, when he was a candidate in 1976, President Carter invented a thing he called the misery index. He added the rate of unemployment and the rate of inflation, and it came, at that time, to 12.5 under President Ford. And he said that no man with that size misery index had a right to seek reelection to the Presidency. Today, by his own decision, the misery index is in excess of 20 percent, and I think this must suggest something. But when I have quoted a Democrat President, as the President says, I was a Democrat. I said many foolish things back in those days. [Laughter] But the President that I quoted had made a promise, a Democrat promise, and I quoted him because it was never kept. And today, you would find that that promise is at the very heart of what Republicanism represents in this country today. And that's why I believe there are going to be millions of Democrats that are going to vote with us this time around, because they too want that promise kept. It was a promise for less government and less taxes and more freedom for the people. MR. SMITH. President Carter. THE PRESIDENT. Yes. I mentioned the radical departure of Governor Reagan from the principles or ideals or historical perspective of his own party. I don't think this can be better illustrated than in the case with guaranteeing women equal rights under the Constitution of our Nation. For 40 years, the Republican Party platforms called for guaranteeing women equal rights with a constitutional amendment. Six predecessors of mine who served in the Oval Office called for this guarantee of women's rights. Governor Reagan and the new Republican Party has departed from this commitment — a very severe blow to the opportunity for women finally to correct discrimination under which they have suffered. When a man and a woman do the same amount of work, a man gets paid a dollar; a woman only gets paid 59 cents. And the equal rights amendment only says that equality of rights shall not be abridged for women by the Federal Government or by the State governments. That's all it says — a simple guarantee of equality of opportunity which typifies the Democratic Party and which is a very important commitment of mine, as contrasted with Governor Reagan's radical departure from the longstanding policy of his own party. MR. SMITH. Governor Reagan. GOVERNOR REAGAN. Yes. Mr. President, once again, I happen to be against the amendment, because I think the amendment will take this problem out of the hands of elected legislators and put it in the hands of unelected judges. I am for equal rights, and while you have been in office for 4 years, and not one single State — and most of them have a majority of Democratic legislators has added to the ratification or voted to ratify the equal rights amendment. While I was Governor, more than 8 years ago, I found 14 separate instances where women were discriminated against in the body of California law, and I had passed and signed into law 14 statutes that eliminated those discriminations, including the economic ones that you have just mentioned, equal pay and so forth. I believe that if in all these years that we've spent trying to get the amendment, that we'd spent as much time correcting these laws, as we did in California — and we were the first to do it. If I were President, I would also now take a look at the hundreds of Federal regulations which discriminate against women and which go right on while everyone is looking for an amendment. I would have someone ride herd on those regulations, and we'd start eliminating those discriminations in the Federal Government against women. MR. SMITH. President Carter. THE PRESIDENT. Yes. Howard, I'm a southerner, and I share the basic beliefs of my region about an excessive government intrusion into the private affairs of American citizens and also into the private affairs of the free enterprise system. One of the commitments that I made was to deregulate the major industries of this country. We've been remarkably successful, with the help of the Democratic Congress. We've deregulated the air industry, the rail industry, the trucking industry, financial institutions; now working on the communications industry. In addition to that, I believe this element of discrimination is something that the South has seen so vividly as a blight on our region of the country which has now been corrected — not only racial discrimination but discrimination against people that have to work for a living — because we have been trying to pick ourselves up by our bootstraps since the long Depression years and lead a full and useful life in the affairs of this country. We've made remarkable success. It's part of my consciousness and of my commitment to continue this progress. So, my heritage as a southerner, my experience in the Oval Office, convinces me that what I've just described is a proper course for the future. MR. SMITH. Governor Reagan, yours is the last word. GOVERNOR REAGAN. Well, my last word is again to say that we were talking about this very simple amendment and women's rights. And I make it plain again: I am for women's rights. But I would like to call the attention of the people to the fact that so-called simple amendment could be used by mischievous men to destroy discriminations that properly belong, by law, to women, respecting the physical differences between the two sexes, labor laws that protect them against doing things that would be physically harmful to them. Those could all be challenged by men. And the same would be true with regard to combat service in the military and so forth. I thought that was the subject we were supposed to be on. But, if we're talking about how much we think about the working people and so forth, I'm the only fellow that ever ran for this job who was six times president of his own union and still has a lifetime membership in that union. MR. SMITH. Gentlemen, each of you now have 3 minutes for a closing statement. President Carter, you're first. CLOSING STATEMENTS THE PRESIDENT. First of all, I'd like to thank the League of Women Voters for making this debate possible. I think it's been a very constructive debate, and I hope it's helped to acquaint the American people with the sharp differences between myself and Governor Reagan. Also, I want to thank the people of Cleveland and Ohio for being such hospitable hosts during this last few hours in my life. I've been President now for almost 4 years. I've had to make thousands of decisions, and each one of those decisions has been a learning process. I've seen the strength of my Nation, and I've seen the crises that it approached in a tentative way. And I've had to deal with those crises as best I could. As I've studied the record between myself and Governor Reagan, I've been impressed with the stark differences that exist between us. I think the results of this debate indicate that that fact is true. I consider myself in the mainstream of my party. I consider myself in the mainstream even of the bipartisan list of Presidents who've served before me. The United States must be a nation strong; the United States must be a nation secure. We must have a society that's just and fair. And we must extend the benefits of our own commitment to peace, to create a peaceful world. I believe that since I've been in office, there've been six or eight areas of combat evolve in other parts of the world. In each case, I alone have had to determine the interests of my country and the degree of involvement of my country. I've done that with moderation, with care, with thoughtfulness; sometimes consulting experts. But I've learned in this last 3 1/2 years that when an issue is extremely difficult, when the call is very close, the chances are the experts will be divided almost 50-50. And the final judgment about the future of our Nation — war, peace, involvement, reticence, thoughtfulness, care, consideration, concern — has to be made by the man in the Oval Office. It's a lonely job, but with the involvement of the American people in the process, with an open government, the job is a very gratifying one. The American people now are facing, next Tuesday, a lonely decision. Those listening to my voice will have to make a judgment about the future of this country. And I think they ought to remember that one vote can make a lot of difference. If one vote per precinct had changed in 1960, John Kennedy would never have been President of this Nation. And if a few more people had gone to the polls and voted in 1968, Hubert Humphrey would have been President; Richard Nixon would not. There is a partnership involved. And our Nation, to stay strong, to stay at peace, to raise high the banner of human rights, to set an example for the rest of the world, to let our deep beliefs and commitments be felt by others in all other nations is my plan for the future. I ask the American people to join me in this partnership. MR. SMITH. Governor Reagan. GOVERNOR REAGAN. Yes, I would like to add my words of thanks, too, to the ladies of the League of Women Voters for making these debates possible. I'm sorry that we couldn't persuade the bringing in of the third candidate, so that he could have been seen also in these debates. But still, it's good that at least once, all three of us were heard by the people of this country. Next Tuesday is election day. Next Tuesday all of you will go to the polls; you'll stand there in the polling place and make a decision. I think when you make that decision, it might be well if you would ask yourself, are you better off than you were 4 years ago? Is it easier for you to go and buy things in the stores than it was 4 years ago? Is there more or less unemployment in the country than there was 4 years ago? Is America as respected throughout the world as it was? Do you feel that our security is as safe, that we're as strong as we were 4 years ago? And if you answer all of those questions yes, why then, I think your choice is very obvious as to who you'll vote for. If you don't agree, if you don't think that this course that we've been on for the last 4 years is what you would like to see us follow for the next 4, then I could suggest another choice that you have. This country doesn't have to be in the shape that it is in. We do not have to go on sharing in scarcity, with the country getting worse off, with unemployment growing. We talk about the unemployment lines. If all of the unemployed today were in a single line allowing 2 feet for each one of them, that line would reach from New York City to Los Angeles, California. All of this can be cured, and all of it can be solved. I have not had the experience the President has had in holding that office, but I think in being Governor of California, the most populous State in the Union if it were a nation, it would be the seventh-ranking economic power in the world-I, too, had some lonely moments and decisions to make. I know that the economic program that I have proposed for this Nation in the next few years can resolve many of the problems that trouble us today. I know because we did it there. We cut the cost — the increased cost of government-the increase in half over the 8 years. We returned $5.7 billion in tax rebates, credits, and cuts to our people. We, as I've said earlier, fell below the national average in inflation when we did that. And I know that we did give back authority and autonomy to the people. I would like to have a crusade today, and I would like to lead that crusade with your help. And it would be one to take government off the backs of the great people of this country and turn you loose again to do those things that I know you can do so well, because you did them and made this country great. Thank you. MR. SMITH. Gentlemen, ladies and gentlemen, for 60 years the League of Women Voters has been committed to citizen education and effective participation of Americans in governmental and political affairs. The most critical element of all in that process is an informed citizen who goes to the polls and who votes. On behalf of the League of Women Voters, now, I would like to thank President Carter and Governor Reagan for being with us in Cleveland tonight. And, ladies and gentlemen, thank you and good night.
