# Presidential Debate at Lynn University in Boca Raton, Florida

**Date:** October 22, 2012
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-boca-raton-florida

---

Moderator Bob Schieffer. Good evening from the campus of Lynn University here in Boca Raton, Florida. This is the fourth and last debate of the 2012 campaign, brought to you by the Commission on Presidential Debates. This one is on foreign policy. I'm Bob Schieffer of CBS News. The questions are mine, and I have not shared them with the candidates or their aides. The audience has taken a vow of silence: no applause, no reaction of any kind, except right now, when we welcome President Barack Obama and Governor Mitt Romney. They've asked me to divide the evening into segments. I'll pose a question at the beginning of each segment. You'll each have 2 minutes to respond, and then, we will have a general discussion until we move to the next segment. Tonight's debate, as both of you know, comes on the 50th anniversary of the night that President Kennedy told the world that the Soviet Union had installed nuclear missiles in Cuba, perhaps the closest we've ever come to nuclear war. And it is a sobering reminder that every President faces, at some point, an unexpected threat to our national security from abroad. So let's begin. Situation in the Middle East and North Africa/Al Qaida Terrorist Organization The first segment is the challenge of a changing Middle East and the new face of terrorism. I'm going to put this into two segments, so you'll have two topic questions within this one segment on that subject. The first question, and it concerns Libya. The controversy over what happened there continues. Four Americans are dead, including an American Ambassador. Questions remain of what happened: What caused it? Was it spontaneous? Was it an intelligence failure? Was it a policy failure? Was there an attempt to mislead people about what really happened? Governor Romney, you said this was an example of an American policy in the Middle East that is unraveling before our very eyes. I'd like to hear each of you give your thoughts on that. Governor Romney, you won the toss; you go first. Republican Presidential Nominee W. Mitt Romney. Thank you, Bob. And thank you for agreeing to moderate this debate this evening. Thank you to Lynn University for welcoming us here. And, Mr. President, it's good to be with you again. We were together at a humorous event a little earlier, and it's nice to maybe be funny this time, not on purpose. We'll see what happens. This is obviously an area of great concern to the entire world and to America in particular, which is to see a complete change in the structure and the environment in the Middle East. With the Arab Spring came a great deal of hope that there would be a change towards more moderation, an opportunity for greater participation on the part of women in public life and in economic life in the Middle East. But instead, we've seen in nation after nation a number of disturbing events. Of course, we see in Syria 30,000 civilians having been killed by the military there. We see in Libya, an attack, apparently by—I think we know now—by terrorists of some kind against our people there, four people dead. Our hearts and minds go to them. Mali has been taken over—the northern part of Mali—by Al Qaida-type individuals. We have in Egypt a Muslim Brotherhood President. And so what we're seeing is a pretty dramatic reversal in the kind of hopes we had for that region. Of course, the greatest threat of all is Iran, 4 years closer to a nuclear weapon. And we're going to have to recognize that we have to do as the President has done; I congratulate him on taking out Usama bin Laden and going after the leadership in Al Qaida. But we can't kill our way out of this mess. We're going to have to put in place a very comprehensive and robust strategy to help the world of Islam and other parts of the world reject this radical, violent extremism, which is—it's certainly not on the run. It's certainly not hiding. This is a group that is now involved in 10 or 12 countries. And it presents an enormous threat to our friends, to the world, to America long term, and we must have a comprehensive strategy to help reject this kind of extremism. Mr. Schieffer. Mr. President. Counterterrorism Efforts/Libya The President. Well, my first job as Commander in Chief, Bob, is to keep the American people safe. And that's what we've done over the last 4 years. We ended the war in Iraq, refocused our attention on those who actually killed us on 9/11. And as a consequence, Al Qaida's core leadership has been decimated. In addition, we're now able to transition out of Afghanistan in a responsible way, making sure that Afghans take responsibility for their own security. And that allows us also to rebuild alliances and make friends around the world to combat future threats. Now, with respect to Libya, as I indicated in the last debate, when we received that phone call, I immediately made sure that, number one, we did everything we could to secure those Americans who were still in harm's way; number two, that we would investigate exactly what happened; and number three, most importantly, that we would go after those who killed Americans and we would bring them to justice. And that's exactly what we're going to do. But I think it's important to step back and think about what happened in Libya. Now, keep in mind that I and Americans took leadership in organizing an international coalition that made sure that we were able to—without putting troops on the ground, at the cost of less than what we spent in 2 weeks in Iraq—liberate a country that had been under the yoke of dictatorship for 40 years, got rid of a despot who had killed Americans. And as a consequence, despite this tragedy, you had tens of thousands of Libyans, after the events in Benghazi, marching and saying: America is our friend. We stand with them. Now, that represents the opportunity we have to take advantage of. And, Governor Romney, I'm glad that you agree that we have been successful in going after Al Qaida, but I have to tell you that your strategy previously has been one that has been all over the map and is not designed to keep Americans safe or to build on the opportunities that exist in the Middle East. Counterterrorism Efforts/Situation in the Middle East and North Africa Gov. Romney. Well, my strategy is pretty straightforward, which is to go after the bad guys, to make sure we do our very best to interrupt them, to kill them, to take them out of the picture. But my strategy is broader than that. That's important, of course. But the key that we're going to have to pursue is a pathway to get the Muslim world to be able to reject extremism on its own. We don't want another Iraq. We don't want another Afghanistan. That's not the right course for us. The right course for us is to make sure that we go after the people who are leaders of these various anti-American groups and these jihadists, but also help the Muslim world. And how do we do that? The group of Arab scholars came together, organized by the U.N., to look at how we can help the world reject these terrorists. And the answer they came up with was this: one, more economic development. We should key our foreign aid, our direct foreign investment—and that of our friends, we should coordinate it—to make sure that we push back and give them more economic development. Number two, better education. Number three, gender equality. Number four, the rule of law. We have to help these nations create civil societies. But what's been happening over the last couple of years is, as we've watched this tumult in the Middle East, this rising tide of chaos occur, you see Al Qaida rushing in. You see other jihadist groups rushing in. And they're throughout many nations in the Middle East. It's wonderful that Libya seems to be making some progress, despite this terrible tragedy. But next door, of course, we have Egypt; Libya is 6 million population, Egypt 80 million population. We want to make sure that we're seeing progress throughout the Middle East, with Mali now having North Mali taken over by Al Qaida, with Syria having Asad continuing to assassinate, to kill, to murder his own people. This is a region in tumult. Mr. Schieffer. Well, let's see what the—— Gov. Romney. And of course, Iran on the path to a nuclear weapon. We've got real problems in the region. Mr. Schieffer. We'll get to that. But let's give the President a chance. Governor Romney's Foreign Policy Agenda The President. Governor Romney, I'm glad that you recognize that Al Qaida is a threat, because a few months ago, when you were asked what's the biggest geopolitical threat facing America, you said Russia. Not Al Qaida, you said Russia. And the 1980s are now calling to ask for their foreign policy back, because the cold war has been over for 20 years. But, Governor, when it comes to our foreign policy, you seem to want to import the foreign policies of the 1980s, just like the social policies of the 1950s, and the economic policies of the 1920s. You say that you're not interested in duplicating what happened in Iraq, but just a few weeks ago, you said you think we should have more troops in Iraq right now. And the challenge we have—I know you haven't been in a position to actually execute foreign policy, but every time you've offered an opinion, you've been wrong. You said we should have gone into Iraq, despite the fact that there were no weapons of mass destruction. You said that we should still have troops in Iraq to this day. You indicated that we shouldn't be passing nuclear treaties with Russia, despite the fact that 71 Senators—Democrats and Republicans—voted for it. You've said that, first, we should not have a timeline in Afghanistan; then, you said we should; now you say maybe or it depends, which means not only were you wrong, but you were also confusing and sending mixed messages both to our troops and our allies. So what we need to do with respect to the Middle East is strong, steady leadership, not wrong and reckless leadership that is all over the map. And unfortunately, that's the kinds of opinions that you've offered throughout this campaign, and it is not a recipe for American strength or keeping America safe over the long term. Mr. Schieffer. I'm going to add a couple of minutes here to give you a chance to respond. Situation in the Middle East/Russia/Iraq Gov. Romney. Well, of course, I don't concur with what the President said about my own record and the things that I've said. They don't happen to be accurate. But I can say this: that we're talking about the Middle East and how to help the Middle East reject the kind of terrorism we're seeing and the rising tide of tumult and confusion. And attacking me is not an agenda. Attacking me is not talking about how we're going to deal with the challenges that exist in the Middle East and take advantage of the opportunity there and stem the tide of this violence. But I'll respond to a couple of the things you mentioned. First of all, Russia, I indicated, is a geopolitical foe, not a—— The President. Number-one geopolitical foe. Gov. Romney. Excuse me. It's a geopolitical foe, and I said in the same paragraph, I said, and Iran is the greatest national security threat we face. Russia does continue to battle us in the U.N. time and time again. I have clear eyes on this. I'm not going to wear rose-colored glasses when it comes to Russia or Mr. Putin. And I'm certainly not going to say to him, I'll give you more flexibility after the election. After the election, he'll get more backbone. Number two, with regards to Iraq, you and I agreed, I believe, that there should have been a status of forces agreement. Did you—— The President. That's not true. Gov. Romney. Oh, you didn't? You didn't want a status of forces agreement? The President. No, what I would not have done is left 10,000 troops in Iraq that would tie us down. That certainly would not help us in the Middle East. Gov. Romney. I'm sorry. You actually—there was an effort on the part of the President—— The President. Here is—— Gov. Romney. ——to have a status of forces agreement—— The President. Here is—— Gov. Romney. And I concurred in that and said that we should have some number of troops that stayed on. That was something I concurred with. The President. Governor—— Gov. Romney. That was your posture. That was my posture as well. You thought it should have been 5,000 troops. The President. Governor—— Gov. Romney. I thought it should have been more troops. But you know what, the answer was—— The President. This is just a few weeks ago. Gov. Romney. ——we got no troops through whatsoever. The President. This is just a few weeks ago that you indicated that we should still have troops in Iraq. Gov. Romney. No, I didn't. I'm sorry, that's—— The President. You made a major speech. Gov. Romney. I indicated that you failed to put in place a status of forces agreement—— The President. Governor—— Gov. Romney.——at the end of the conflict that existed in Iraq. The President. Governor, here's one thing—— Mr. Schieffer. You know what, let him answer, please. The President's Foreign Policy Agenda The President. Here's one thing I've learned as Commander in Chief. You've got to be clear both to our allies and our enemies about where you stand and what you mean. Now, you just gave a speech a few weeks ago in which you said we should still have troops in Iraq. That is not a recipe for making sure that we are taking advantage of the opportunities and meeting the challenges of the Middle East. Now, it is absolutely true that we cannot just beat these challenges militarily. And so what I've done—throughout my Presidency and will continue to do—is, number one, make sure that these countries are supporting our counterterrorism efforts. Number two, make sure that they are standing by our interests in Israel's security, because it is a true friend and our greatest ally in the region. Number three, we do have to make sure that we're protecting religious minorities and women because these countries can't develop unless all the population—not just half of it—is developing. Number four, we do have to develop their economic capabilities. But number five, the other thing that we have to do is recognize that we can't continue to do nation-building in these regions. Part of American leadership is making sure that we're doing nation-building here at home. Mr. Schieffer. All right. The President. That will help us maintain the kind of American leadership that we need. Syria Mr. Schieffer. Let me interject the second topic question in this segment about the Middle East and so on. And that is, you both mentioned—alluded to this, and that is Syria. The war in Syria has now spilled over into Lebanon. We have, what, more than a hundred people that were killed there in a bomb. There were demonstrations there, eight people dead. Mr. President, it's been more than a year since you saw—you told Asad he had to go. Since then, 30,000 Syrians have died. We've had 300,000 refugees. The war goes on; he's still there. Should we reassess our policy and see if we can find a better way to influence events there? Or is that even possible? And it's you—you go first, sir. The President. What we've done is organize the international community, saying Asad has to go. We've mobilized sanctions against that Government. We have made sure that they are isolated. We have provided humanitarian assistance, and we are helping the opposition organize. And we're particularly interested in making sure that we're mobilizing the moderate forces inside of Syria. But ultimately, Syrians are going to have to determine their own future. And so everything we're doing, we're doing in consultation with our partners in the region, including Israel, which obviously has a huge interest in seeing what happens in Syria, coordinating with Turkey and other countries in the region that have a great interest in this. Now, what we're seeing taking place in Syria is heartbreaking. And that's why we are going to do everything we can to make sure that we are helping the opposition. But we also have to recognize that for us to get more entangled militarily in Syria is a serious step. And we have to do so making absolutely certain that we know who we are helping, that we're not putting arms in the hands of folks who eventually could turn them against us or our allies in the region. And I am confident that Asad's days are numbered. But what we can't do is to simply suggest that, as Governor Romney at times has suggested, that giving heavy weapons, for example, to the Syrian opposition is a simple proposition that would lead us to be safer over the long term. Mr. Schieffer. Governor. Gov. Romney. Well, let's step back and talk about what's happening in Syria and how important it is. First of all, 30,000 people being killed by their Government is a humanitarian disaster. Secondly, Syria is an opportunity for us because Syria plays an important role in the Middle East, particularly right now. Syria is Iran's only ally in the Arab world. It's their route to the sea. It's the route for them to arm Hizballah in Lebanon, which threatens, of course, our ally, Israel. And so seeing Syria remove Asad is a very high priority for us. Number two, seeing a replacement Government being responsible people is critical for us. And finally, we don't want to have military involvement there. We don't want to get drawn in to a military conflict. And so the right course for us is working through our partners and with our own resources to identify responsible parties within Syria, organize them, bring them together in a form of, if not government, a form of council that can take the lead in Syria, and then make sure they have the arms necessary to defend themselves. We do need to make sure that they don't have arms that get into the wrong hands, that those arms could be used to hurt us down the road. We need to make sure as well that we coordinate this effort with our allies and particularly with Israel. But the Saudis and the Qatari and the Turks are all very concerned about this. They're willing to work with us. We need to have a very effective leadership effort in Syria, making sure that the insurgents there are armed and that the insurgents that become armed are people who will be the responsible parties. Recognize, I believe that Asad must go. I believe he will go. But I believe we want to make sure that we have the relationships of friendship with the people that take his place such that in the years to come, we see Syria as a friend and Syria as a responsible party in the Middle East. This is a critical opportunity for America. And what I'm afraid of is, what we've watched over the past year or so, first, the President saying, well, we'll let the U.N. deal with it, and Asad—excuse me, Kofi Annan came in and said we're going to try to have a cease-fire. That didn't work. Then it looked to the Russians and said, let's see if you can do something. We should be playing the leadership role there, not on the ground with military, but play the leadership role. Mr. Schieffer. All right. Syria/Libya The President. Bob, we are playing the leadership role. We organized the Friends of Syria. We are mobilizing humanitarian support and support for the opposition. And we are making sure that those we help are those who will be friends of ours in the long term and friends of our allies in the region over the long term. But going back to Libya, because this is an example of how we make choices: When we went into Libya, and we were able to immediately stop the massacre there because of the unique circumstances and the coalition that we had helped to organize, we also had to make sure that Muammar Qaddafi didn't stay there. And to the Governor's credit, you supported us going into Libya and the coalition that we organized. But when it came time to making sure that Qaddafi did not stay in power, that he was captured, Governor, your suggestion was that this was mission creep, that this was mission muddle. Imagine if we had pulled out at that point. Muammar Qaddafi had more American blood on his hands than any individual other than Usama bin Laden, and so we were going to make sure that we finished the job. That's part of the reason why the Libyans stand with us. But we did so in a careful, thoughtful way, making certain that we knew who we were dealing with, that those forces of moderation on the ground were ones that we could work with. And we have to take the same kind of steady, thoughtful leadership when it comes to Syria. That's exactly what we're doing. Syria Mr. Schieffer. Governor, can I just ask you, would you go beyond what the administration would do? Like, for example, would you put in no-fly zones over Syria? Gov. Romney. I don't want to have our military involved in Syria. I don't think there's a necessity to put our military in Syria at this stage. I don't anticipate that in the future. As I indicated, our objectives are to replace Asad and to have in place a new Government, which is friendly to us, a responsible Government, if possible. And I want to make sure they get armed and they have the arms necessary to defend themselves, but also to remove Asad. But I do not want to see a military involvement on the part of our troops. And this isn't going to be necessary. We have—with our partners in the region, we have sufficient resources to support those groups. But look, this has been going on for a year. This is a time—this should have been a time for American leadership. We should have taken a leading role—not militarily, but a leading role organizationally, governmentally—to bring together the parties there, to find responsible parties. As you hear from intelligence sources even today, the insurgents are highly disparate; they haven't come together; they haven't formed a unity group, a council of some kind. That needs to happen. America can help that happen. And we need to make sure they have the arms they need to carry out the very important role, which is getting rid of Asad. Mr. Schieffer. Could we get a quick response, Mr. President? Because I want to ask about Egypt. The President. I'll be very quick. What you just heard Governor Romney said is he doesn't have different ideas, and that's because we're doing exactly what we should be doing to try to promote a moderate Syrian leadership and an effective transition so that we get Asad out. That's the kind of leadership we've shown. That's the kind of leadership we'll continue to show. Arab Spring/Egypt/National Economy Mr. Schieffer. May I ask you, during the Egyptian turmoil, there came a point when you said it was time for President Mubarak to go. The President. Right. Mr. Schieffer. Some in your administration thought perhaps we should have waited a while on that. Do you have any regrets about that? The President. No, I don't, because I think that America has to stand with democracy. The notion that we would have tanks run over those young people who were in Tahrir Square, that is not the kind of American leadership that John F. Kennedy talked about 50 years ago. But what I've also said is that now that you have a democratically elected Government in Egypt, that they have to make sure that they take responsibility for protecting religious minorities—and we have put significant pressure on them to make sure they're doing that—to recognize the rights of women, which is critical throughout the region. These countries can't develop if young women are not given the kind of education that they need. They have to abide by their treaty with Israel. That is a red line for us, because not only is Israel's security at stake, but our security is at stake if that unravels. They have to make sure that they're cooperating with us when it comes to counterterrorism. And we will help them with respect to developing their own economy, because ultimately, what's going to make the Egyptian revolution successful for the people of Egypt, but also for the world is if those young people who gathered there are seeing opportunities. Their aspirations are similar to young people's here. They want jobs. They want to be able to make sure their kids are going to a good school. They want to make sure that they have a roof over their heads and that they have the prospects of a better life in the future. And so one of the things that we've been doing is, for example, organizing entrepreneurship conferences with these Egyptians to give them a sense of how they can start rebuilding their economy in a way that's noncorrupt, that's transparent. But what is also important for us to understand is, is that for America to be successful in this region, there are some things that we're going to have to do here at home as well. One of the challenges over the last decade is we've done experiments in nation-building in places like Iraq and Afghanistan, and we've neglected, for example, developing our own economy, our own energy sectors, our own education system. And it's very hard for us to project leadership around the world when we're not doing what we need to do here. Arab Spring/National Economy/U.S. Global Influence Mr. Schieffer. Governor Romney, I want to hear your response to that. But I would just ask you, would you have stuck with Mubarak? Gov. Romney. No. I believe as the President indicated and said at the time that I supported his action there. I felt that—I wish we'd have had a better vision of the future. I wish that, looking back at the beginning of the President's term and even further back than that, that we'd have recognized that there was a growing energy and passion for freedom in that part of the world and that we would have worked more aggressively with our friend and with other friends in the region to have them make the transition towards a more representative form of government, such that it didn't explode in the way it did. But once it exploded, I felt the same as the President did, which is, these freedom voices in the streets of Egypt were the people who were speaking of our principles. And President Mubarak had done things which were unimaginable, and the idea of him crushing his people was not something that we could possibly support. Let me step back and talk about what I think our mission has to be in the Middle East and even more broadly, because our purpose is to make sure the world is more—is peaceful. We want a peaceful planet. We want people to be able to enjoy their lives and know they're going to have a bright and prosperous future and not be at war. That's our purpose. And the mantle of leadership for the promoting the principles of peace has fallen to America. We didn't ask for it, but it's an honor that we have it. But for us to be able to promote those principles of peace requires us to be strong, and that begins with a strong economy here at home. And unfortunately, the economy is not stronger. When the President of Iraq—excuse me, of Iran, Ahmadi-nejad, says that our debt makes us not a great country, that's a frightening thing. The former chief of staff—chief of the Joint Chiefs of Staff said that—Admiral Mullen—said that our debt is the biggest national security threat we face. This—we have weakened our economy. We need a strong economy. We need to have, as well, a strong military. Our military is second to none in the world. We're blessed with terrific soldiers and extraordinary technology and intelligence. But the idea of a trillion dollars in cuts through sequestration and budget cuts to the military would change that. We need to have strong allies. Our association and connection with our allies is essential to America's strength. We're the great nation that has allies: 42 allies and friends around the world. And finally we have to stand by our principles. And if we're strong in each of those things, American influence will grow. But unfortunately, in nowhere in the world is America's influence greater today than it was 4 years ago. Mr. Schieffer. All right. Gov. Romney. And that's because we've become weaker—— The President. Bob, I think—— Gov. Romney. ——on each of those four dimensions. Governor Romney's Foreign Policy Agenda/National Economy/U.S. Armed Forces Mr. Schieffer. You're going to get a chance to respond to that because that's a perfect segue into our next segment, and that is, what is America's role in the world? And that is the question: What do each of you see as our role in the world? And I believe, Governor Romney, it's your turn to go first. Gov. Romney. Well, I absolutely believe that America has a responsibility and the privilege of helping defend freedom and promote the principles that make the world more peaceful, and those principles include human rights, human dignity, free enterprise, freedom of expression, elections, because when there are elections, people tend to vote for peace. They don't vote for war. So we want to promote those principles around the world. We recognize that there are places of conflict in the world. We want to end those conflicts to the extent humanly possible. But in order to be able to fulfill our role in the world, America must be strong. America must lead. And for that to happen, we have to strengthen our economy here at home. You can't have 23 million people struggling to get a job. You can't have an economy that, over the last 3 years, keeps slowing down in its growth rate. You can't have kids coming out of college, half of whom can't find a job today or a job that's commensurate with their college degree. We have to get our economy going. And our military: We've got to strengthen our military long term. We don't know what the world is going to throw at us down the road. We make decisions today in a military that will confront challenges we can't imagine. In the 2000 debates, there was no mention of terrorism, for instance. And a year later, 9/11 happened. So we have to make decisions based upon uncertainty, and that means a strong military. I will not cut our military budget. We have to also stand by our allies. I think the tension that existed between Israel and the United States was very unfortunate. I think also that pulling our missile defense program out of Poland in the way we did was also unfortunate in terms of, if you will, disrupting the relationship in some ways that existed between us. And then of course, with regards to standing for our principles, when the students took the streets in Tehran and the people there protested, the Green Revolution occurred. For the President to be silent, I thought was an enormous mistake. We have to stand for our principles, stand for our allies, stand for a strong military and stand for a stronger economy. Mr. Schieffer. Mr. President. The President's Foreign Policy Agenda/National Economy The President. America remains the one indispensible nation. And the world needs a strong America, and it is stronger now than when I came into office. Because we ended the war in Iraq, we were able to refocus our attention on not only the terrorist threat, but also beginning a transition process in Afghanistan. It also allowed us to refocus on alliances and relationships that had been neglected for a decade. And, Governor Romney, our alliances have never been stronger: in Asia, in Europe, in Africa, with Israel, where we have unprecedented military and intelligence cooperation, including dealing with the Iranian threat. But what we also have been able to do is position ourselves so we can start rebuilding America. And that's what my plan does: making sure that we're bringing manufacturing back to our shores so that we're creating jobs here, as we've done with the auto industry, not rewarding companies that are shipping jobs overseas; making sure that we've got the best education system in the world, including retraining our workers for the jobs of tomorrow. Doing everything we can to control our own energy. We've cut our oil imports to the lowest level in two decades because we've developed oil and natural gas, but we also have to develop clean energy technologies that will allow us to cut our exports in half by 2020. That's the kind of leadership that we need to show. And we've got to make sure that we reduce our deficit. Unfortunately, Governor Romney's plan doesn't do it. We've got to do it in a responsible way by cutting out spending we don't need, but also by asking the wealthiest to pay a little bit more. That way we can invest in the research and technology that's always kept us at the cutting edge. Now, Governor Romney has taken a different approach throughout this campaign. Both at home and abroad, he has proposed wrong and reckless policies. He's praised George Bush as a good economic steward and Dick Cheney as somebody who has—shows great wisdom and judgment. And taking us back to those kinds of strategies that got us into this mess are not the way that we are going to maintain leadership in the 21st century. National Economy Mr. Schieffer. Governor Romney, wrong and reckless policies? Gov. Romney. I've got a policy for the future and an agenda for the future. And when it comes to our economy here at home, I know what it takes to create 12 million new jobs and rising take-home pay. And what we've seen over the last 4 years is something I don't want to see over the next 4 years. The President said by now we'd be at 5.4-percent unemployment. We're 9 million jobs short of that. I will get America working again and see rising take-home pay again, and I'll do it with five simple steps. Number one, we are going to have North American energy independence. We're going to do it by taking full advantage of oil, coal, gas, nuclear, and our renewables. Number two, we're going to increase our trade. Trade grows about 12 percent per year. It doubles about every 5 or so years. We can do better than that, particularly in Latin America. The opportunities for us in Latin America we have just not taken advantage of fully. As a matter of fact, Latin America's economy is almost as big as the economy of China. We're all focused on China. Latin America is a huge opportunity for us: time zone, language opportunities. Number three, we're going to have to have training programs that work for our workers and schools that finally put the parents and the teachers and the kids first, and the teachers unions going to have to go behind. And then, we're going to have to get to a balanced budget. We can't expect entrepreneurs and businesses, large and small, to take their life savings or their company's money and invest in America if they think we're headed to the road to Greece. And that's where we're going right now unless we finally get off this spending and borrowing binge. And I'll get us on track to a balanced budget. And finally, number five, we've got to champion small business. Small businesses are where jobs come from. Two-thirds of our jobs come from small businesses. New business formation is down at the lowest level in 30 years under this administration. I want to bring it back and get back good jobs and rising take-home pay. Small-Business Promotion/Education The President. Well, let's talk about what we need to compete. First of all, Governor Romney talks about small businesses, but, Governor, when you were in Massachusetts, small businesses development ranked about 48th, I think, out of 50 States in Massachusetts because the policies that you're promoting actually don't help small businesses. And the way you define small businesses include folks at the very top; they include you and me. That's not the kind of small-business promotion we need. But let's take an example that we know is going to make a difference in the 21st century, and that's our education policy. We didn't have a lot of chance to talk about this in the last debate. Under my leadership, what we've done is reformed education, working with Governors, 46 States. We've seen progress and gains in schools that were having a terrible time, and they're starting to finally make progress. And what I now want to do is to hire more teachers, especially in math and science, because we know that we've fallen behind when it comes to math and science. And those teachers can make a difference. Now, Governor Romney, when you were asked by teachers whether or not this would help the economy grow, you said this isn't going to help the economy grow. When you were asked about reduced class sizes, you said class sizes don't make a difference. But I tell you, if you talk to teachers, they will tell you it does make a difference. And if we've got math teachers who are able to provide the kind of support that they need for our kids, that's what's going to determine whether or not the new businesses are created here. Companies are going to locate here depending on whether we've got the most highly skilled workforce. And the kinds of budget proposals that you've put forward, when we don't ask either you or me to pay a dime more in terms of reducing the deficit, but instead we slash support for education, that's undermining our long-term competitiveness. That is not good for America's position in the world, and the world notices. Mr. Schieffer. Let me get back to foreign policy. Gov. Romney. Well, look—— Mr. Schieffer. Can I just get back to—— Gov. Romney. Well, I need to speak a moment if you'll let me, Bob—— Mr. Schieffer. Okay. Education Gov. Romney. ——just about education, because I'm so proud of the State that I had the chance to be Governor of. We have, every 2 years, tests that look at how well our kids are doing. Fourth-graders and eighth-graders are tested in English and math. While I was Governor, I was proud that our fourth-graders came out number one of all 50 States in English and then also in math, and our eighth-graders number one in English and also in math. First time one State had been number one in all four measures. How did we do that? Well, Republicans and Democrats came together on a bipartisan basis to put in place education principles that focused on having great teachers in the classroom, and that was—— The President. Ten years earlier, Governor. Gov. Romney. ——and that was what allowed us to become the number-one State in the Nation. The President. But that was 10 years before you took office. Gov. Romney. And this is—and we were—— Mr. Schieffer. Gentlemen. Gov. Romney. Absolutely—— The President. And then you cut education spending when you came into office. Gov. Romney. The first—and we kept our schools number one in the Nation. They're still number one today. Mr. Schieffer. All right. Gov. Romney. And the principles that we put in place—we also gave kids not just a graduation exam that determined whether they were up to the skills needed to be able to compete, but also if they graduated in the top quarter of their class, they got a 4-year, tuition-free ride at any Massachusetts public institution of higher learning. The President. That happened before you came into office though. Mr. Schieffer. Governor—— Gov. Romney. That was actually mine. Actually, Mr. President, you've got that fact wrong. Deficit and National Debt Mr. Schieffer. Let me just—I want to try to shift it, because we have heard some of this in the other debates. Governor, you say you want a bigger military, you want a bigger Navy. You don't want to cut defense spending. What I want to ask you—we're talking about financial problems in this country—where are you going to get the money? Gov. Romney. Well, let's come back and talk about the military, but all the way through. First of all, I'm going through from the very beginning, we're going to cut about 5 percent of the discretionary budget, excluding military. That's number one, all right? And that's—— Mr. Schieffer. But can you do this without driving us deeper into debt? Gov. Romney. The good news is—I'll be happy to have you take a look. Come on our website; you'll look at how we get to a balanced budget within 8 to 10 years. We do it by getting—by reducing spending in a whole series of programs. By the way, number one, I get rid of is Obamacare. There are a number of things that sound good, but frankly, we just can't afford them, and that one doesn't sound good, and it's not affordable. So I get rid of that one from day one. To the extent humanly possible, we get that out. We take program after program that we don't absolutely have to have, and we get rid of them. Number two, we take some programs that we are going to keep, like Medicaid, which is a program for the poor, we take that health care program for the poor, and we give it to the States to run because States run these programs more efficiently. As a Governor, I thought, please, give me this program. I can run this more efficiently than the Federal Government. Mr. Schieffer. Can he do that, Mr. President? Gov. Romney. And States, by the way, are proving it. States like Arizona, Rhode Island have taken these Medicaid dollars, have shown they can run these programs more cost-effectively. The President. Bob—— Gov. Romney. And so I want to do those two things. It gets us to a balanced budget within 8 to 10 years. The President. Bob—— Mr. Schieffer. Let—— Gov. Romney. Let's get back to the military though. Mr. Schieffer. Well, that's what I'm trying to find out about. Deficit and National Debt The President. But he should have answered the first question. Look, Governor Romney has called for $5 trillion of tax cuts that he says he's going to pay for by closing deductions. Now, the math doesn't work, but he continues to claim that he's going to do it. He then wants to spend another $2 trillion on military spending that our military is not asking for. Now, keep in mind that our military spending has gone up every single year that I've been in office. We spend more on our military than the next 10 countries combined—China, Russia, France, the United Kingdom, you name it—next 10. And what I did was work with our Joint Chiefs of Staff to think about what are we going to need in the future to make sure that we are safe, and that's the budget that we've put forward. But what you can't do is spend $2 trillion in additional military spending that the military is not asking for, $5 trillion on tax cuts. You say that you're going to pay for it by closing loopholes and deductions without naming what those loopholes and deductions are, and then somehow, you're also going to deal with the deficit that we've already got. The math simply doesn't work. But when it comes to our military, what we have to think about is not just budgets. We've got think about capabilities. We need to be thinking about cybersecurity. We need to be thinking about space. That's exactly what our budget does, but it's driven by strategy. It's not driven by politics. It's not driven by Members of Congress and what they would like to see. It's driven by what are we going to need to keep the American people safe. That's exactly what our budget does. And it also then allows us to reduce our deficit, which is a significant national security concern, because we've got to make sure that our economy is strong at home so that we can project military power overseas. Deficit and National Debt/U.S. Armed Forces/Defense Spending Gov. Romney. Bob, I'm pleased that I've balanced budgets. I was in the world of business for 25 years. You didn't balance your budget, you went out of business. I went to the Olympics that was out of balance, and we got it on balance and made a success there. I had the chance to be Governor of a State; 4 years in a row, Democrats and Republicans came together to balance the budget. We cut taxes 19 times, balanced our budget. The President hasn't balanced a budget yet. I expect to have the opportunity to do so myself. Mr. Schieffer. All right. Gov. Romney. I'm going to be able to balance the budget. Let's talk about military spending, and that's this: Our Navy—— Mr. Schieffer. About 30 seconds. Gov. Romney. Our Navy is older—excuse me, our Navy is smaller now than any time since 1917. The Navy said they needed 313 ships to carry out their mission; we're now down to 285. We're headed down to the low two-hundreds if we go through with sequestration. That's unacceptable to me. I want to make sure that we have the ships that are required by our Navy. Our Air Force is older and smaller than any time since it was founded in 1947. We've changed for the first time since FDR; since FDR, we had the—we've always had the strategy of saying we could fight in two conflicts at once. Now we're changing to one conflict. Look, this, in my view, is the highest responsibility of the President of the United States, which is to maintain the safety of the American people. And I will not cut our military budget by a trillion dollars, which is the combination of the budget cuts that the President has, as well as the sequestration cuts. That, in my view, is making our future less certain and less secure—— The President. Bob, I just need to comment on this. First of all, the sequester is not something that I proposed. It's something that Congress has proposed. It will not happen. The budget that we're talking about is not reducing our military spending, it's maintaining it. But I think Governor Romney maybe hasn't spent enough time looking at how our military works. You mentioned the Navy, for example, and that we have fewer ships than we did in 1916. Well, Governor, we also have fewer horses and bayonets—[laughter]—because the nature of our military has changed. We have these things called aircraft carriers where planes land on them. We have these ships that go underwater, nuclear submarines. And so the question is not a game of Battleship where we're counting ships, it's what are our capabilities. And so, when I sit down with the Secretary of the Navy and the Joint Chiefs of Staff, we determine how are we going to be best able to meet all of our defense needs in a way that also keeps faith with our troops, that also makes sure that our veterans have the kind of support that they need when they come home. And that is not reflected in the kind of budget that you're putting forward, because it just doesn't work. Mr. Schieffer. All right. The President. And we visited the website quite a bit, and it still doesn't work. [Laughter] Israel/Iran Mr. Schieffer. A lot to cover. I'd like to move to the next segment: red lines, Israel, and Iran. Would either of you—and you'll have 2 minutes, and, President Obama, you have the first go at this one. Would either of you be willing to declare that an attack on Israel is an attack on the United States, which, of course, is the same promise that we give to our close allies like Japan? And if you made such a declaration, would not that deter Iran? It's certainly deterred the Soviet Union for a long, long time when we made that promise to our allies. Mr. President. The President. First of all, Israel is a true friend; it is our greatest ally in the region. And if Israel is attacked, America will stand with Israel. I've made that clear throughout my Presidency. Mr. Schieffer. So you're saying we've already made that declaration? The President. I will stand with Israel if they are attacked. And this is the reason why, working with Israel, we have created the strongest military and intelligence cooperation between our two countries in history. In fact, this week, we'll be carrying out the largest military exercise with Israel in history—this very week. But to the issue of Iran, as long as I'm President of the United States, Iran will not get a nuclear weapon. I made that clear when I came into office. We then organized the strongest coalition and the strongest sanctions against Iran in history, and it is crippling their economy. Their currency has dropped 80 percent. Their oil production has plunged to the lowest level since they were fighting a war with Iraq 20 years ago. So their economy is in a shambles. And the reason we did this is because a nuclear Iran is a threat to our national security, and it's a threat to Israel's national security. We cannot afford to have a nuclear arms race in the most volatile region in the world. Iran is a state sponsor of terrorism, and for them to be able to provide nuclear technology to nonstate actors, that's unacceptable. And they have said that they want to see Israel wiped off the map. So the work that we've done with respect to sanctions now offers Iran a choice: They can take the diplomatic route and end their nuclear program, or they will have to face a united world and a United States President—me—who said we're not going to take any options off the table. The disagreement I have with Governor Romney is that during the course of this campaign, he's often talked as if we should take premature military action. I think that would be a mistake, because when I've sent young men and women into harm's way, I always understand that that is the last resort, not the first resort. Mr. Schieffer. Two minutes. Gov. Romney. Well, first of all, I want to underscore the same point the President made, which is that if I'm President of the United States—when I'm President of the United States—we will stand with Israel. And if Israel is attacked, we have their back, not just diplomatically, not just culturally, but militarily. That's number one. Number two, with regards to Iran and the threat of Iran, there's no question but that a nuclear Iran—a nuclear-capable Iran—is unacceptable to America. It presents a threat not only to our friends, but ultimately a threat to us to have Iran have nuclear material, nuclear weapons that could be used against us or used to be threatening to us. It's also essential for us to understand what our mission is in Iran, and that is to dissuade Iran from having a nuclear weapon through peaceful and diplomatic means. And crippling sanctions are something I called for 5 years ago. When I was in Israel speaking at the Herzliya conference, I laid out seven steps. Crippling sanctions were number one, and they do work. You're seeing it right now in the economy. It's absolutely the right thing to do to have crippling sanctions. I'd have put them in place earlier, but it's good that we have them. Number two, something I would add today is I would tighten those sanctions. I would say that ships that carry Iranian oil can't come into our ports. I imagine the EU would agree with us as well. Not only ships couldn't, I'd say companies that are moving their oil can't; people who are trading in their oil can't. I would tighten those sanctions further. Secondly, I'd take on diplomatic isolation efforts. I'd make sure that Ahmadi-nejad is indicted under the genocide convention. His words amount to genocide incitation. I would indict him for it. I would also make sure that their diplomats are treated like the pariah they are around the world, the same way we treated the apartheid diplomats of South Africa. We need to increase pressure time and time again on Iran, because anything other than a solution to this which says—which stops this nuclear folly of theirs is unacceptable to America. And of course, a military action is the last resort. It is something one would only, only consider if all of the other avenues had been tried to their full extent. Iran Mr. Schieffer. Let me ask both of you, there are—as you know, there are reports that Iran and the United States, as part of an international group, have agreed in principle to talks about Iran's nuclear program. What is the deal—if there are such talks—what is the deal that you would accept? Mr. President. The President. Well, first of all, those are reports in the newspaper. They are not true. But our goal is to get Iran to recognize it needs to give up its nuclear program and abide by the U.N. resolutions that have been in place. Because they have the opportunity to reenter the community of nations. And we would welcome that. There are people in Iran who have the same aspirations as people all around the world for a better life. And we hope that their leadership takes the right decision. But the deal we'll accept is, they end their nuclear program. It's very straightforward. And I'm glad that Governor Romney agrees with the steps that we're taking. There have been times, Governor, frankly, during the course of this campaign where it sounded like you thought that you'd do the same things we did, but you'd say them louder, and somehow, that would make a difference. And it turns out that the work involved in setting up these crippling sanctions is painstaking. It's meticulous. We started from the day we got into office. And the reason it was so important—and this is a testament to how we've restored American credibility and strength around the world—is we had to make sure that all the countries participated, even countries like Russia and China, because if it's just us that are imposing sanctions, we've had sanctions in place for a long time. It's because we got everybody to agree that Iran is seeing so much pressure. And we've got to maintain that pressure. There is a deal to be had, and that is that they abide by the rules that have already been established, they convince the international community they are not pursuing a nuclear program, there are inspections that are very intrusive, but over time what they can do is regain credibility. In the meantime, though, we're not going to let up the pressure until we have clear evidence that that takes place. And one last thing, just to make this point: The clock is ticking. We're not going to allow Iran to perpetually engage in negotiations that lead nowhere. And I've been very clear to them. Because of the intelligence coordination that we do with a range of countries, including Israel, we have a sense of when they would get breakout capacity, which means that we would not be able to intervene in time to stop their nuclear program. And that clock is ticking. Mr. Schieffer. All right. The President. And we're going to make sure that if they do not meet the demands of the international community, then we are going to take all options necessary to make sure they don't have a nuclear weapon. Mr. Schieffer. Governor. Gov. Romney. I think from the very beginning, one of the challenges we've had with Iran is that they have looked at this administration and felt that the administration was not as strong as it needed to be. I think they saw weakness where they had expected to find American strength. And I say that because from the very beginning, the President, in his campaign some 4 years ago, said he'd meet with all the world's worst actors in his first year. He'd sit down with Chavez and Kim Jong Il, with Castro, and with President Ahmadi-nejad of Iran. And I think they looked and thought, well, that's an unusual honor to receive from the President of the United States. And then, the President began what I've called an apology tour of going to various nations in the Middle East and criticizing America. I think they looked at that and saw weakness. Then, when there were dissidents in the streets of Tehran, a Green Revolution, holding signs saying, is America with us, the President was silent. I think they noticed that as well. And I think that when the President said he was going to create daylight between ourselves and Israel, that they noticed that as well. All of these things suggested, I think, to the Iranian mullahs that, hey, we can keep on pushing along here, we can keep talks going on, but we're just going to keep on spinning centrifuges. Now there are some 10,000 centrifuges spinning uranium, preparing to create a nuclear threat to the United States and to the world. That's unacceptable for us. And it's essential for a President to show strength from the very beginning, to make it very clear what is acceptable and not acceptable. And an Iranian nuclear program is not acceptable to us. They must not develop nuclear capability. And the way to make sure they understand that is by having from the very beginning the tightest sanctions possible. They need to be tightened. Our diplomatic isolation needs to be tougher. We need to indict Ahmadi-nejad. We need to put the pressure on them as hard as we possibly can. Because if we do that, we won't have to take the military action. The President. Bob, let me just respond. Nothing Governor Romney just said is true, starting with this notion of me apologizing. This has been probably the biggest whopper that's been told during the course of this campaign. And every fact checker and every reporter who's looked at it, Governor, has said this is not true. And when it comes to tightening sanctions, look, as I said before, we've put in the toughest, most crippling sanctions ever. And the fact is, while we were coordinating an international coalition to make sure these sanctions were effective, you were still invested in a Chinese state oil company that was doing business with the Iranian oil sector. So I'll let the American people decide, judge who is going to be more effective and more credible when it comes to imposing crippling sanctions. And with respect to our attitude about the Iranian revolution, I was very clear about the murderous activities that had taken place, and that was contrary to international law and everything that civilized people stand for. And so the strength that we have shown in Iran is shown by the fact that we've been able to mobilize the world. When I came into office, the world was divided; Iran was resurgent. Iran is at its weakest point economically, strategically, militarily than since—than in many years. And we are going to continue to keep the pressure on to make sure that they do not get a nuclear weapon. That's in America's national interest, and that will be the case so long as I'm President. Iran/The President's Foreign Policy Agenda/Israel Gov. Romney. We're 4 years closer to a nuclear Iran. We're 4 years closer to a nuclear Iran. And we should not have wasted these 4 years to the extent they've continued to be able to spin these centrifuges and get that much closer. That's number one. Number two, Mr. President, the reason I call it an apology tour is because you went to the Middle East, and you flew to Egypt and to Saudi Arabia and to Turkey and Iraq, and by the way, you skipped Israel, our closest friend in the region. But you went to the other nations. And by the way, they noticed that you skipped Israel. And then in those nations, and on Arabic TV, you said that America had been dismissive and derisive. You said that on occasion America has dictated to other nations. Mr. President, America has not dictated to other nations. We have freed other nations from dictators. The President. Bob, let me respond. If we're going to talk about trips that we've taken, when I was a candidate for office, the first trip I took was to visit our troops. And when I went to Israel as a candidate, I didn't take donors, I didn't attend fundraisers. I went to Yad Vashem, the Holocaust museum there, to remind myself the nature of evil and why our bond with Israel will be unbreakable. And then I went down to the border towns of Sderot, which had experienced missiles raining down from Hamas. And I saw families there who showed me where missiles had come down near their children's bedrooms, and I was reminded of what that would mean if those were my kids, which is why, as President, we funded an Iron Dome program to stop those missiles. So that's how I've used my travels, when I traveled to Israel and when I traveled to the region. And the central question at this point is going to be who's going to be credible to all parties involved. And they can look at my track record—whether it's Iran's sanctions, whether it's dealing with counterterrorism, whether it's supporting democracy, whether it's supporting women's rights, whether it's supporting religious minorities—and they can say that the President of the United States and the United States of America has stood on the right side of history. And that kind of credibility is precisely why we've been able to show leadership on a wide range of issues facing the world right now. Israel/The President's Foreign Policy Agenda Mr. Schieffer. What if the Prime Minister of Israel called you on the phone and said: "Our bombers are on the way. We're going to bomb Iran"? What do you say? Gov. Romney. Bob, it's not—let's not go into hypotheticals of that nature. Our relationship with Israel, my relationship with the Prime Minister of Israel, is such that we would not get a call saying our bombers are on the way or their fighters are on the way. This is the kind of thing that would have been discussed and thoroughly evaluated well before that kind of last-minute—— Mr. Schieffer. So you say it just wouldn't happen. Gov. Romney. I'm just saying that's just not—— Mr. Schieffer. Okay, well, let's see what—— Gov. Romney. But let me—— The President. The—— Gov. Romney. ——let's come back to what the President was speaking about, which is what's happening in the world and the President's statement that things are going so well. Look, I look at what's happening around the world, and I see Iran 4 years closer to a bomb. I see the Middle East with a rising tide of violence, chaos, tumult. I see jihadists continuing to spread; whether they're rising or just about the same level, hard to precisely measure, but this—it's clear they're there. They're very strong. I see Syria with 30,000 civilians dead. Asad still in power. I see our trade deficit with China larger than it's—growing larger every year, as a matter of fact. I look around the world, and I don't feel that—you see North Korea continuing to export their nuclear technology. Russia has said they're not going to follow Nunn-Lugar anymore. They're—back away from a nuclear proliferation treaty that we had with them. I look around the world, I don't see our influence growing around the world. I see our influence receding, in part because of the failure of the President to deal with our economic challenges at home, in part because of our withdrawal from our commitment to our military in the way, I think, it ought to be; in part because of the turmoil with Israel. I mean, the President received a letter from 38 Democrat Senators saying that tensions—— The President. Bob—— Gov. Romney. ——with Israel were a real problem. They asked him, please repair the tension—Democrat Senators—please repair the damage in his own party. Mr. Schieffer. All right. Governor Romney's Foreign Policy Agenda/The President's Foreign Policy Agenda The President. Governor, the problem is, is that on a whole range of issues—whether it's the Middle East, whether it's Afghanistan, whether it's Iraq, whether it's now Iran—you've been all over the map. I mean, I'm pleased that you now are endorsing our policy of applying diplomatic pressure and potentially having bilateral discussions with the Iranians to end their nuclear program. But just a few years ago, you said that's something you'd never do. In the same way that you initially opposed a timetable in Afghanistan, now you're for it, although it depends. In the same way that you say you would have ended the war in Iraq, but recently gave a speech saying that we should have 20,000 more folks in there. The same way that you said that it was mission creep to go after Qaddafi. When it comes to going after Usama bin Laden, you said, well, any President would make that call. But when you were a candidate in 2008, as I was, and I said if I got bin Laden in our sights, I would take that shot, you said we shouldn't move heaven and earth to get one man. And you said we should ask Pakistan for permission. And if we had asked Pakistan for permission, we would not have gotten him. And it was worth moving heaven and earth to get him. After we killed bin Laden, I was at Ground Zero for a memorial and talked to a young woman who was 4 years old when 9/11 happened. And the last conversation she had with her father was him calling from the Twin Towers, saying, "Payton, I love you, and I will always watch over you." And for the next decade, she was haunted by that conversation. And she said to me, "By finally getting bin Laden, that brought some closure to me." And when we do things like that, when we bring those who have harmed us to justice, that sends a message to the world, and it tells Payton that we did not forget her father. Mr. Schieffer. All right. The President. And I make that point because that's the kind of clarity of leadership—and those decisions are not always popular. Those decisions generally are not poll tested. And even some in my own party, including my current Vice President, had the same critique as you did. But what the American people understand is, is that I look at what we need to get done to keep the American people safe and to move our interests forward, and I make those decisions. Mr. Schieffer. All right, let's go. And that leads us—this takes us right to the next segment, Governor, America's longest war, Afghanistan and Pakistan—— Gov. Romney. Bob—— Mr. Schieffer. Governor, you get to go first here. Gov. Romney. You can't—okay, but you can't have the President just lay out a whole series of items without giving me a chance to respond. Mr. Schieffer. Well, with respect, sir, you had laid out quite a program there. Gov. Romney. Well, that's probably true. [Laughter] Mr. Schieffer. And we'll give you—— The President. We'll agree on that. Afghanistan/Pakistan Mr. Schieffer. We'll catch up. The United States is scheduled to turn over responsibility for security in Afghanistan to the Afghan Government in 2014. At that point we will withdraw our combat troops, leave a smaller force of Americans—if I understand our policy—in Afghanistan for training purposes. It seems to me the key question here is what do you do if the deadline arrives and it is obvious the Afghans are unable to handle their security? Do we still leave? And I believe, Governor Romney, you go first. Gov. Romney. Well, we're going to be finished by 2014. And when I'm President, we'll make sure we bring our troops out by the end of 2014. The commanders and the generals there are on track to do so. We've seen progress over the past several years. The surge has been successful, and the training program is proceeding apace. There are now a large number of Afghan security forces, 350,000, that are ready to step in to provide security, and we're going to be able to make that transition by the end of 2014. So our troops will come home at that point. I can tell you at the same time that we will make sure that we look at what's happening in Pakistan and recognize that what's happening in Pakistan is going to have a major impact on the success in Afghanistan. And I say that because I know a lot of people just feel like we should brush our hands and walk away—and I don't mean you, Mr. President—but some people in our Nation feel that Pakistan isn't being nice to us and that we should just walk away from them. Pakistan is important to the region, to the world, and to us, because Pakistan has a hundred nuclear warheads and they're rushing to build a lot more. They'll have more than Great Britain sometime in the relatively near future. They also have the Haqqani network and the Taliban existent within their country. And so a Pakistan that falls apart, becomes a failed state, would be of extraordinary danger to Afghanistan and to us. And so we're going to have to remain helpful in encouraging Pakistan to move towards a more stable government and rebuild a relationship with us. And that means that our aid that we provide to Pakistan is going to have to be conditioned upon certain benchmarks being met. So for me, I look at this as both a need to help move Pakistan in the right direction and also to get Afghanistan to be ready, and they will be ready by the end of 2014. Afghanistan/Pakistan/Veterans Mr. Schieffer. Mr. President. The President. When I came into office, we were still bogged down in Iraq, and Afghanistan had been drifting for a decade. We ended the war in Iraq, refocused our attention on Afghanistan, and we did deliver a surge of troops. That was facilitated, in part, because we had ended the war in Iraq. And we are now in a position where we have met many of the objectives that got us there in the first place. Part of what had happened is, we had forgotten why we had gone. We went because there were people who were responsible for 3,000 American deaths. And so we decimated Al Qaida's core leadership in the border regions between Afghanistan and Pakistan. We then started to build up Afghan forces, and we're now in a position where we can transition out, because there's no reason why Americans should die when Afghans are perfectly capable of defending their own country. Now, that transition has to take place in a responsible fashion. We've been there a long time, and we've got to make sure that we and our coalition partners are pulling out responsibly and giving Afghans the capabilities that they need. But what I think the American people recognize is after a decade of war, it's time to do some nation-building here at home. And what we can now do is free up some resources to, for example, put Americans back to work—especially our veterans—rebuilding our roads, our bridges, our schools; making sure that our veterans are getting the care that they need when it comes to posttraumatic stress disorder and traumatic brain injury; making sure that the certifications that they need for good jobs of the future are in place. I was having lunch with some—a veteran in Minnesota who had been a medic dealing with the most extreme circumstances. When he came home and he wanted to become a nurse, he had to start from scratch. And what we've said is, let's change those certifications. The First Lady has done great work with an organization called Joining Forces, putting our veterans back to work. And as a consequence, veterans unemployment is actually now lower than the general population; it was higher when I came into office. So those are the kinds of things that we can now do because we're making that transition in Afghanistan. Pakistan Mr. Schieffer. All right, let me go to Governor Romney, because you talked about Pakistan and what needs to be done there. General Allen, our commander in Afghanistan, says that Americans continue to die at the hands of groups who are supported by Pakistan. We know that Pakistan has arrested the doctor who helped us catch Obamas—bin Laden. It still provides safe haven for terrorists. Yet we continue to give Pakistan billions of dollars. Is it time for us to divorce Pakistan? Gov. Romney. No, it's not time to divorce a nation on Earth that has a hundred nuclear weapons and is on the way to double that at some point, a nation that has serious threats from terrorist groups within its nation, as I indicated before, the Taliban, the Haqqani network. It's a nation that's not like others, and it does not have a civilian leadership that is calling the shots there. You've got the ISI, their intelligence organization, that's probably the most powerful of three branches there. Then you have the military, and then you have the civilian Government. This is a nation, which, if it falls apart, if it becomes a failed state, there are nuclear weapons there, and you've got terrorists there who could grab their hands onto those nuclear weapons. This is an important part of the world for us. Pakistan is technically an ally, and they're not acting very much like an ally right now, but we have some work to do. And I don't blame the administration for the fact that the relationship with Pakistan is strained. We had to go into Pakistan. We had to go in there to get Usama bin Laden. That was the right thing to do. And that upset them, but there was obviously a great deal of anger even before that. But we're going to have to work with the people in Pakistan to try and help them move to a more responsible course than the one that they're on. It's important for them. It's important for the nuclear weapons. It's important for the success of Afghanistan, because inside Pakistan you have a large group of Pashtuns that are Taliban. They're going to come rushing back in to Afghanistan when we go, and that's one of the reasons the Afghan security forces have so much work to do to be able to fight against that. But it's important for us to recognize that we can't just walk away from Pakistan. But we do need to make sure that as we send support for them, that this is tied to them making progress on matters that would lead them to becoming a civil society. Counterterrorism/The President's Foreign Policy Agenda/Israel Mr. Schieffer. Let me ask you, Governor—because we know President Obama's position on this—what is your position on the use of drones? Gov. Romney. Well, I believe that we should use any and all means necessary to take out people who pose a threat to us and our friends around the world. And it's widely reported that drones are being used in drone strikes, and I support that entirely, and feel the President was right to up the usage of that technology, and believe that we should continue to use it to continue to go after the people who represent a threat to this Nation and to our friends. Let me also note that, as I said earlier, we're going to have to do more than just going after leaders and killing bad guys, important as that is. We're also going to have to have a far more effective and comprehensive strategy to help move the world away from terror and Islamic extremism. We haven't done that yet. We talk a lot about these things, but you look at the record. You look at the record of the last 4 years and say, is Iran closer to a bomb? Yes. Is the Middle East in tumult? Yes. Is Al Qaida on the run, on its heels? No. Is—are Israel and the Palestinians closer to reaching a peace agreement? No, they haven't had talks in 2 years. We have not seen the progress we need to have. And I'm convinced that with strong leadership and an effort to build a strategy based upon helping these nations reject extremism, we can see the kind of peace and prosperity the world demands. Counterterrorism/Democracy Promotion The President. Well, keep in mind, our strategy wasn't just going after bin Laden. We've created partnerships throughout the region to deal with extremism: in Somalia, in Yemen, in Pakistan. And what we've also done is engage these Governments in the kind of reforms that are actually going to make a difference in people's lives day to day: to make sure that their Governments aren't corrupt, to make sure that they are treating women with the kind of respect and dignity that every nation that succeeds has shown, and to make sure that they've got a free market system that works. So across the board, we are engaging them in building capacity in these countries, and we have stood on the side of democracy. One thing I think Americans should be proud of, when Tunisians began to protest, this Nation—me, my administration—stood with them earlier than just about any other country. In Egypt, we stood on the side of democracy. In Libya, we stood on the side of the people. And as a consequence, there's no doubt that attitudes about Americans have changed. But there are always going to be elements in these countries that potentially threaten the United States, and we want to shrink those groups and those networks, and we can do that. But we're always also going to have to maintain vigilance when it comes to terrorist activities. The truth, though, is that Al Qaida is much weaker than it was when I came into office, and they don't have the same capacities to attack the U.S. homeland and our allies as they did 4 years ago. China Mr. Schieffer. Let's go to the next segment, because it's a very important one. It is the rise of China and future challenges for America. I want to just begin this by asking both of you—and, Mr. President, you go first this time—what do you believe is the greatest future threat to the national security of this country? The President. Well, I think it will continue to be terrorist networks. We have to remain vigilant, as I just said. But with respect to China, China is both an adversary, but also a potential partner in the international community if it's following the rules. So my attitude coming into office was that we are going to insist that China plays by the same rules as everybody else. Now, I know Americans had seen jobs being shipped overseas, businesses and workers not getting a level playing field when it came to trade. And that's the reason why I set up a trade Task Force to go after cheaters when it came to international trade. That's the reason why we have brought more cases against China for violating trade rules than the other—the previous administration had done in two terms. And we've won just about every case that we filed, that has been decided. In fact, just recently, steelworkers in Ohio and throughout the Midwest, Pennsylvania, are in a position now to sell steel to China because we won that case. We had a tire case in which they were flooding us with cheap domestic tires—or cheap Chinese tires, and we put a stop to it and, as a consequence, saved jobs throughout America. I have to say that Governor Romney criticized me for being too tough in that tire case, said this wouldn't be good for American workers and that it would be protectionist. But I tell you, those workers don't feel that way. They feel as if they had finally an administration who was going to take this issue seriously. Over the long term, in order for us to compete with China, we've also got to make sure, though, that we're taking care of business here at home. If we don't have the best education system in the world, if we don't continue to put money into research and technology that will allow us to create great businesses here in the United States, that's how we lose the competition. And unfortunately, Governor Romney's budget and his proposals would not allow us to make those investments. Mr. Schieffer. All right. Governor. Gov. Romney. Well, first of all, it's not government that makes business successful. It's not government investments that make businesses grow and hire people. Let me also note that the greatest threat that the world faces, the greatest national security threat is a nuclear Iran. Let's talk about China. China has an interest that's very much like ours in one respect, and that is they want a stable world. They don't want war. They don't want to see protectionism. They don't want to see the world break out into various forms of chaos, because they have to manufacture goods and put people to work. They have about 20,000—20 million, rather, people coming out of the farms every year, coming into the cities, needing jobs. So they want the economy to work and the world to be free and open. And so we can be a partner with China. We don't have to be an adversary in any way, shape, or form. We can work with them. We can collaborate with them, if they're willing to be responsible. Now, they look at us and say, is it a good idea to be with America? How strong are we going to be? How strong is our economy? They look at the fact that we owe them a trillion dollars and owe other people 16 trillion in total, including them. They look at our decision to cut back on our military capabilities: a trillion dollars. The Secretary of Defense called these trillion dollars of cuts to our military devastating. It's not my term. It's the President's own Secretary of Defense called them devastating. They look at America's commitments around the world, and they see what's happening, and they say, well, okay, is America going to be strong? And the answer is yes; if I'm President, America will be very strong. We'll also make sure that we have trade relations with China that work for us. I've watched year in and year out as companies have shut down and people have lost their jobs because China has not played by the same rules, in part by holding down artificially the value of their currency; it holds down the prices of their goods. It means our goods aren't as competitive, and we lose jobs. That's got to end. They're making some progress. They need to make more. That's why on day one I will label them a currency manipulator, which allows us to apply tariffs where they're taking jobs. They're stealing our intellectual property, our patents, our designs, our technology, hacking into our computers, counterfeiting our goods. They have to understand, we want to trade with them, we want a world that's stable, we like free enterprise, but you've got to play by the rules. China Mr. Schieffer. Well, Governor, let me just ask you, if you declare them a currency manipulator on day one, some people are—say you're just going to start a trade war with China on day one. Is that—isn't there a risk that that could happen? Gov. Romney. Well, they sell us about this much stuff every year, and we sell them about this much stuff every year. So it's pretty clear who doesn't want a trade war. And there's one going on right now which we don't know about; it's a silent one, and they're winning. We have enormous trade imbalance with China. And it's worse this year than last year. And it's worst last year than the year before. And so we have to understand that we can't just surrender and lose jobs year in and year out. We have to say to our friends in China, look, you guys are playing aggressively, we understand it, but this can't keep on going. You can't keep on holding down the value of your currency, stealing our intellectual property, counterfeiting our products, selling them around the world, even into the United States. I was with one company that makes valves in process industries. And they said, look, we were having some valves coming in that were broken, and we had to repair them under warranty. And we looked them up, and they had our serial number on them, and then we noticed that there was more than one with that same serial number. There were counterfeit products being made overseas with the same serial number as a U.S. company, the same packaging. These were being sold into our market and around the world as if they were made by the U.S. competitor. This can't go on. I want a great relationship with China. China can be our partner, but that doesn't mean they can just roll all over us and steal our jobs on an unfair basis. Global Competitiveness/China The President. Well, Governor Romney is right, you are familiar with jobs being shipped overseas because you invested in companies that were shipping jobs overseas. And that's your right. I mean, that's how our free market works. But I've made a different bet on American workers. If we had taken your advice, Governor Romney, about our auto industry, we'd be buying cars from China instead of selling cars to China. If we take your advice with respect to how we change our Tax Code so that companies that are in profits overseas don't pay U.S. taxes compared to companies here that are paying taxes, that's estimated to create 800,000 jobs. The problem is they won't be here, they'll be in places like China. And if we're not making investments in education and basic research, which is not something that the private sector is doing at a sufficient pace right now and has never done, then we will lose the lead in things like clean energy technology. Now, with respect to what we've done with China already, U.S. exports have doubled, since I came into office, to China. And actually, currencies are at their most advantageous point for U.S. exporters since 1993. We absolutely have to make more progress, and that's why we're going to keep on pressing. And when it comes to our military and Chinese security, part of the reason that we were able to pivot to the Asia-Pacific region after having ended the war in Iraq and transitioning out of Afghanistan is precisely because this is going to be a massive growth area in the future. And we believe China can be a partner, but we're also sending a very clear signal that America is a Pacific power, that we are going to have a presence there. We are working with countries in the region to make sure, for example, that ships can pass through, that commerce continues. And we're organizing trade relations with countries other than China so that China starts feeling more pressure about meeting basic international standards. That's the kind of leadership we've shown in the region. That's the kind of leadership that we'll continue to show. U.S. Automobile Industry Gov. Romney. I just want to take one of those points. Again, attacking me is not talking about an agenda for getting more trade and opening up more jobs in this country. But the President mentioned the auto industry and that somehow I would be in favor of jobs being elsewhere. Nothing could be further from the truth. I'm a son of Detroit. I was born in Detroit. My dad was head of a car company. I like American cars, and I would do nothing to hurt the U.S. auto industry. My plan to get the industry on its feet when it was in real trouble was not to start writing checks. It was President Bush that wrote the first checks. I disagreed with that. I said they need—these companies need to go through a managed bankruptcy. And in that process, they can get Government help and Government guarantees, but they need to go through bankruptcy to get rid of excess cost and the debt burden that they'd built up. And fortunately, the President took—— The President. Governor Romney, that's not what you said. Gov. Romney. Fortunately, the President—you can take a look at the op-ed. You can take a look at the op-ed. The President. Governor Romney, you did not say that you would provide Government help. Gov. Romney. You know, I'm still speaking. I said that we would provide guarantees, and that was what was able to allow these companies to go through bankruptcy, to come out of bankruptcy. Under no circumstances would I do anything other than to help this industry get on its feet. And the idea that has been suggested, that I would liquidate the industry, of course not, of course not. The President. Let's check the record. Gov. Romney. That's the height of silliness. I have never said I would—— The President. Let's check the record. Gov. Romney. ——liquidate the industry. I want to keep the industry going and thriving. The President. Governor, the people of Detroit don't forget. Global Competitiveness Gov. Romney. And that's why I have the kind of commitment to make sure that our industries in this country can compete and be successful. We in this country can compete successfully with anyone in the world, and we're going to. We're going to have to have a President, however, that doesn't think that somehow the Government investing in car companies like Tesla and Fisker, making electric battery cars—this is not research, Mr. President. These are the Government investing in companies, investing in Solyndra. This is a company; this isn't basic research. I want to invest in research. Research is great. Providing funding to universities and think tanks, great. But investing in companies, absolutely not. That's the wrong way to go. The President. Governor, the fact of the matter is—— Gov. Romney. I'm still speaking. So I want to make sure that we make America more competitive and that we do those things that make America the most attractive place in the world for entrepreneurs, innovators, businesses to grow. But your investing in companies doesn't do that. In fact, it makes it less likely for them to come here, because the private sector is not going to invest in a solar company—— The President. Governor, I'm happy to respond. You've held the floor for a while. Gov. Romney. ——if you're investing Government money in someone else's. The President. Look, I think anybody out there can check the record. Governor Romney, you keep on trying to airbrush history here. You were very clear that you would not provide Government assistance to the U.S. auto companies even if they went through bankruptcy. You said that they could get it in the private marketplace. That wasn't true. They would have gone through—— Gov. Romney. You're wrong. You're wrong, Mr. President. The President. No, I am not wrong. Gov. Romney. You're wrong. The President. I am not wrong. Gov. Romney. People can look it up, you're right. The President. People will look it up. Gov. Romney. Good. The President. But more importantly, it is true that in order for us to be competitive, we're going to have to make some smart choices right now. Cutting our education budget, that's not a smart choice. That will not help us compete with China. Cutting our investments in research and technology, that's not a smart choice. That will not help us compete with China. Bringing down our deficit by adding $7 trillion of tax cuts and military spending that our military is not asking for, before we even get to the debt that we currently have, that is not going to make us more competitive. Those are the kinds of choices that the American people face right now. Having a Tax Code that rewards companies that are shipping jobs overseas instead of companies that are investing here in the United States, that will not make us more competitive. And the one thing that I'm absolutely clear about is that after a decade in which we saw a drift, jobs being shipped overseas, nobody championing American workers and American businesses, we've now begun to make some real progress. What we can't do is go back to the same policies that got us into such difficulty in the first place. And that's why we have to move forward and not go back. The President's Economic Record Gov. Romney. I couldn't agree more about going forward, but I certainly don't want to go back to the policies of the last 4 years. The policies of the last 4 years has seen incomes in America decline every year for middle-income families, now down $4,300 during your term. Twenty-three million Americans still struggling to find a good job. When you came to office, 32 million people on food stamps; today, 47 million people on food stamps. When you came to office, just over $10 trillion in debt; now $16 trillion in debt. It hasn't worked. You said by now we'd be at 5.4-percent unemployment. We're 9 million jobs short of that. I've met some of those people. I met them in Appleton, Wisconsin. I met a young woman in Philadelphia who's coming out of college, can't find work. Ann was with someone just the other day that was just weeping about not being able to get work. It's just a tragedy in a nation so prosperous as ours that these last 4 years have been so hard. And that's why it's so critical that we make America once again the most attractive place in the world to start businesses, to build jobs, to grow the economy. And that's not going to happen by just hiring teachers. Look, I'd love to—I love teachers, and I'm happy to have States and communities that want to hire teachers do that. By the way, I don't like to have the Federal Government start pushing its way deeper and deeper into our schools; let the States and localities do that. I was a Governor; the Federal Government didn't hire our teachers. Mr. Schieffer. Governor—— Gov. Romney. But I love teachers, but I want to get our private sector growing, and I know how to do it. Mr. Schieffer. I think we all love teachers. [Laughter] Gentlemen, thank you so much for a very vigorous debate. We have come to the end. It is time for closing statements. I believe you're first, Mr. President. Closing Statements The President. Well, thank you very much, Bob, Governor Romney, and to Lynn University. You've now heard three debates, months of campaigning, and way too many TV commercials. [Laughter] And now you've got a choice. Over the last 4 years, we've made real progress digging our way out of policies that gave us two prolonged wars, record deficits, and the worst economic crisis since the Great Depression. And Governor Romney wants to take us back to those policies: a foreign policy that's wrong and reckless; economic policies that won't create jobs, won't reduce our deficit, but will make sure that folks at the very top don't have to play by the same rules that you do. And I've got a different vision for America. I want to build on our strengths. And I've put forward a plan to make sure that we're bringing manufacturing jobs back to our shores by rewarding companies and small businesses that are investing here, not overseas. I want to make sure we've got the best education system in the world, and we're retaining our workers for the jobs of tomorrow. I want to control our own energy by developing oil and natural gas, but also the energy sources of the future. Yes, I want to reduce our deficit by cutting spending that we don't need, but also by asking the wealthy to do a little bit more so that we can invest in things like research and technology that are the key to a 21st-century economy. As Commander in Chief, I will maintain the strongest military in the world, keep faith with our troops, and go after those who would do us harm. But after a decade of war, I think we all recognize we've got to do some nation-building here at home rebuilding our roads, our bridges, and especially caring for our veterans who sacrificed so much for our freedom. We've been through tough times, but we always bounce back because of our character, because we pull together. And if I have the privilege of being your President for another 4 years, I promise you I will always listen to your voices, I will fight for your families, and I will work every single day to make sure that America continues to be the greatest nation on Earth. Thank you. Mr. Schieffer. Governor. Gov. Romney. Thank you. Bob, Mr. President, folks at Lynn University, good to be with you. I'm optimistic about the future. I'm excited about our prospects as a nation. I want to see peace. I want to see growing peace in this country. It's our objective. We have an opportunity to have real leadership. America is going to have that kind of leadership and continue to promote principles of peace that will make the world a safer place and make people in this country more confident that their future is secure. I also to want to make sure that we get this economy going. And there are two very different paths the country can take. One is a path represented by the President, which, at the end of 4 years, would mean we'd have $20 trillion in debt, heading towards Greece. I'll get us on track to a balanced budget. The President's path will mean continuing declining in take-home pay. I want to make sure our take-home pay turns around and starts to grow. The President's path means 20 million people out of work, struggling for a good job. I'll get people back to work with 12 million new jobs. I'm going to make sure that we get people off of food stamps, not by cutting the program, but by getting them good jobs. America is going to come back, and for that to happen, we're going to have to have a President who can work across the aisle. I was in a State where my legislature was 87-percent Democrat. I learned how to get along on the other side of the aisle. We've got to do that in Washington. Washington is broken. I know what it takes to get this country back, and we'll work with good Democrats and good Republicans to do that. This Nation is the hope of the Earth. We've been blessed by having a nation that's free and prosperous thanks to the contributions of the greatest generation. They've held a torch for the world to see, a torch of freedom and hope and opportunity. Now it's our turn to take that torch. I'm convinced we'll do it. We need strong leadership. I'd like to be that leader, with your support. I'll work with you. I'll lead you in an open and honest way. And I ask for your vote. I'd like to be the next President of the United States to support and help this great Nation, and to make sure that we all together maintain America as the hope of the Earth. Thank you so much. Mr. Schieffer. Gentlemen, thank you both so much. That brings an end to this year's debates. And we want to thank Lynn University and its students for having us. As I always do at the end of these debates, I leave you with the words of my mom, who said, go vote. [Laughter] It makes you feel big and strong. The President. That's great. Mr. Schieffer. Good night.
