# Presidential Campaign Debate in Williamsburg, Virginia

**Date:** October 22, 1976
**Source:** https://www.presidency.ucsb.edu/documents/presidential-campaign-debate-0

---

THE MODERATOR. Good evening, I am Barbara Walters, moderator of the last of the debates of 1976 between Gerald R. Ford, Republican candidate for President, and Jimmy Carter, Democratic candidate for President. Welcome, President Ford, welcome, Governor Carter, and thank you for joining us this evening. This debate takes place before an audience in Phi Beta Kappa Memorial Hall on the campus of the College of William and Mary in historic Williamsburg, Virginia. It is particularly appropriate in this Bicentennial Year that we meet on these grounds to hear this debate. Two hundred years ago, five William and Mary students met at nearby Raleigh Tavern to form Phi Beta Kappa, a fraternity designed, they wrote, "to search out and dispel the clouds of falsehood by debating without reserve the issues of the day." In that spirit of debate--"without reserve, ....to dispel the clouds of falsehood"--gentlemen, let us proceed. The subject matter of this debate is open, covering all issues and topics. Our questioners tonight are Joseph Kraft, syndicated columnist, Robert Maynard, editorial writer for the Washington Post, and Jack Nelson, Washington bureau chief of the Los Angeles Times. The ground rules tonight are as follows: Questioners will alternate questions between the candidates. The candidate has up to 2 1/2 minutes to answer the question. The other candidate then has up to 2 minutes to respond. If necessary, a questioner may ask a follow-up question for further clarification, and in that case the candidate has up to 2 minutes to respond. As was initially agreed to by both candidates, the answers should be responsive to the particular questions. Finally, each candidate has up to 3 minutes for a closing statement. President Ford and Governor Carter do not have prepared notes or comments with them this evening, but they may make notes and refer to them during the debate. It has been determined that President Ford would take the first question in this last debate, and, Mr. Kraft, you have that first question for President Ford. MR. KRAFT. Mr. President, I assume that the Americans all know that these are difficult times and that there is no pie in the sky and that they don't expect something for nothing. So I'd like to ask you, as a first question, as you look ahead in the next 4 years, what sacrifices are you going to call on the American people to make? What price are you going to ask them to pay to realize your objectives? Let me add, Governor Carter, that if you felt that it was appropriate to answer that question in your comments, as to what price it would be appropriate for the American people to pay for a Carter administration, I think that would be proper, too. Mr. President? THE PRESIDENT. Mr. Kraft, I believe that the American people in the next 4 years, under a Ford administration, will be called upon to make those necessary sacrifices to preserve the peace--which we have--which means, of course, that we will have to maintain an adequate military capability; which means, of course, that we will have to add, I think, a few billion dollars to our defense appropriations to make certain that we have adequate strategic forces, adequate conventional forces. I think the American people will be called upon to be in the forefront in giving leadership to the solution of those problems that must be solved in the Middle East, in southern Africa, and any problems that might arise in the Pacific. The American people will be called upon to tighten their belts a bit in meeting some of the problems that we face domestically. I don't think that America can go on a big spending spree with a whole lot of new programs that would add significantly to the Federal budget. I believe that the American people, if given the leadership that I would expect to give, would be willing to give this thrust to preserve the peace and the necessary restraint at home to hold the lid on spending so that we could, I think, have a long overdue and totally justified tax decrease for the middle-income people. And then--with the economy that would be generated from a restraint on spending and a tax reduction primarily for the middle-income people--then I think the American people would be willing to make those sacrifices for peace and prosperity in the next 4 years. MR. KRAFT. Could I be a little bit more specific, Mr. President? THE PRESIDENT. Sure, sure. MR. KRAFT. Doesn't your policy really imply that we are going to have to have a pretty high rate of unemployment over a fairly long time, that growth is going to be fairly slow, and that we are not going to be able to do very much in the next 4 or 5 years to meet the basic agenda of our national needs in the cities, in health, in transit, and a whole lot of other things like that? THE PRESIDENT. Not at all. MR. KRAFT. Aren't those the real costs? THE PRESIDENT. No, Mr. Kraft. We're spending very significant amounts of money now, some $200 billion a year, almost 50 percent of our total Federal expenditure by the Federal Government at the present time, for human needs. Now, we will probably have to increase that to some extent, but we don't have to have growth in spending that will blow the lid off and add to the problems of inflation. I believe we can meet the problems within the cities of this country and still give a tax reduction. I proposed, as you know, a reduction to increase the personal exemption from $750 to $1,000, with the fiscal program that I have. And if you look at the projections, it shows that we will reduce unemployment, that we will continue to win the battle against inflation and, at the same time, give the kind of quality of life that I believe is possible in America: a job, a home for all those that will work and save for it, safety in the streets, health care that is affordable. These things can be done if we have the right vision and the right restraint and the right leadership. THE MODERATOR. Thank you. Governor Carter, your response, please. MR. CARTER. Well, I might say first of all, that I think in case of a Carter administration, the sacrifices would be much less. Mr. Ford's own environmental agency has projected a 10-percent unemployment rate by 1978 if be is President. The American people are ready to make sacrifices if they are part of the process, if they know that they will be helping to make decisions and won't be excluded from being an involved party to the national purpose. The major effort that we must put forward is to put our people back to work. And I think that this is one example where a lot of people have selfish, grasping ideas now. I remember in 1973, in the depth of the energy crisis, when President Nixon called on the American people to make a sacrifice to cut down on the waste of gasoline, to cut down on the speed of automobiles. It was a tremendous surge of patriotism. "I want to make a sacrifice for my country? I think we could call together--with strong leadership in the White House-business, industry, and labor, and say, let's have voluntary price restraints, let's lay down some guidelines so we don't have continuing inflation. We could also have an end to the extremes. We now have one extreme, for instance, of some welfare recipients who, by taking advantage of the welfare laws, the housing laws, the Medicaid laws, and the food stamp laws, make over $10,000 a year, and they don't have to pay any taxes on it. At the other extreme just I percent of the richest people in our country derive 25 percent of all the tax benefits. So both those extremes grasp for advantage, and the person who has to pay that expense is the middle-income family who is still working for a living. And they have to pay for the rich who have the privilege and for the poor who are not working. But I think that a balanced approach, with everybody being part of it, and striving for unselfishness could help, as it did in 1973, to let people sacrifice for their own country. I know I'm ready for it; I think the American people are, too. THE MODERATOR. Thank you. Mr. Maynard, your question to Governor Carter. MR. MAYNARD. Governor, by all indications, the voters are so turned off by this election campaign so far that only half intend to vote. One major reason for this apathetic electorate appears to be the low level at which this campaign bas been conducted. It has digressed frequently from important issues into allegations of blunders and brainwashing and fixations on lust in Playboy. What responsibility do you accept for the low level of this campaign for the Nation's highest office? MR. CARTER. I think the major reason for a decrease in participation that we've experienced ever since 1960 bas been the deep discouragement of the American people about the performance of public officials. When you've got 7 1/2, 8 million people out of work, when you've got three times as much inflation as you had during the last 8-year Democratic administration, when you have the highest deficits in history, when you have it becoming increasingly difficult for a family to put a child through college or to own a home, there is a natural inclination to be turned off. Also, in the aftermath of Vietnam and Cambodia and Watergate and the CIA revelations, people have felt that they've been betrayed by public officials. I have to admit that in the heat of the campaign--I've been in 30 primaries during the springtime; I've been campaigning for 22 months--I've made some mistakes. And I think this is part of just being a human being. I have to say that my campaign has been an open one. The Playboy thing bas been of very great concern to me. I don't know how to deal with it exactly. I agreed to give the interview to Playboy. Other people have done it who are notable--Governor Jerry Brown, Walter Cronkite, Albert Schweitzer, Mr. Ford's own Secretary of Treasury, Mr. Simon, William Buckley, many other people. But they weren't running for President. And in retrospect, from hindsight, I would not have given that interview had I to do it over again. If I should ever decide in the future to discuss my deep Christian beliefs and condemnation and sinfulness, l would use another forum besides Playboy. But I can say this: I'm doing the best I can to get away from that. And during the next 10 days, the American people will not see the Carter campaign running television advertisements or newspaper advertisements based on a personal attack on President Ford's character. I believe that the opposite is true with President Ford's campaign. And I hope that we can leave those issues, in the next 10 days, about personalities and mistakes of the past--we've both matte some mistakes--and talk about unemployment, inflation, housing, education, taxation, government organization, stripping away of secrecy, and the things that are crucial to the American people. I regret the things in my own long campaign that have been mistaken, but I'm trying to do away with those the last 10 days. THE MODERATOR. Thank you, Governor Carter. President Ford, your response? THE PRESIDENT. I believe that the American people have been turned off in this election, Mr. Maynard, for a variety of reasons. We have seen on Capitol Hill, in the Congress, a great many allegations of wrongdoing, of alleged immorality. Those are very disturbing to the American people. They wonder how an elected representative can serve them and participate in such activities,' serving in the Congress of the United States. Yes, and I'm certain many, many Americans were turned off by the revelations of Watergate, a very, very bad period of time in American political history. Yes, and thousands, maybe millions of Americans were turned off because of the problems that came out of our involvement in Vietnam. But on the other hand, I found on July 4 of this year a new spirit born in America. We were celebrating our Bicentennial. And I find that there is a movement--as I traveled around the country--of greater interest in this campaign. Now, like any hard-working person seeking public office, in the campaign, inevitably, sometimes you will use rather graphic language. And I am guilty of that just like, I think, most others in the political arena. But I do make a pledge that in the next 10 days when we are asking the American people to make one of the most important decisions in their lifetime, because I think this election is one of the most vital in the history of America, that we do together what we can to stimulate voter participation. THE MODERATOR. Thank you, President Ford. Mr. Nelson, your question to President Ford. MR. NELSON. Mr. President, you mentioned Watergate, and you became President because of Watergate, so don't you owe the American people a special obligation to explain in detail your role of limiting one of the original investigations of a Watergate--that was the one by the House Banking Committee? And I know you've answered questions on this before, but there are questions. that still remain, and I think people want to know what your role was. Will you name the persons you talked to in connection with that investigation, and since you say you have no recollection of talking to anyone from the White House, would you be willing to open for examination the White House tapes of conversations during that period? THE PRESIDENT. Mr. Nelson, I testified before two committees, House and Senate, on precisely the questions that you have asked. And the testimony, under oath, was to the effect that I did not talk to Mr. Nixon, to Mr. Haldeman, to Mr. Ehrlichman, or to any of the people at the White House. I said I had no recollection whatsoever of talking with any of the White House legislative liaison people. I indicated under oath that the initiative that I took was at the request of the ranking members of the House Banking and Currency Committee on the Republican side, which was a legitimate request and a proper response by me. Now, that was gone into by two congressional committees, and following that investigation both committees overwhelmingly approved me, and both the House and the Senate did likewise. Now, in the meantime the Special Prosecutor--within the last few days after an investigation himself--said there was no reason for him to get involved, because he found nothing that would justify it. And then, just a day or two ago, the Attorney General of the United States made a further investigation and came to precisely the same conclusion. Now, after all of those investigations by objective, responsible people, I think the matter is closed once and for all. But to add one other feature: I don't control any of the tapes. Those tapes are in the jurisdiction of the courts, and I have no right to say yes or no. But all the committees, the Attorney General, the Special Prosecutor--all of them have given me a clean bill of health. I think the matter is settled once and for all. MR. NELSON. Well, Mr. President, if I do say so, though, the question is that I think you still have not gone into details about what your role in it was. And I don't think there was any question about whether or not there was a criminal prosecution, but whether you have told the American people your entire involvement in it and whether you would be willing--even though you don't control the tapes--whether you would be willing to ask that the tapes be released for examination? THE PRESIDENT. That's for the proper authorities who have control over those tapes to make that decision. I have given every bit of evidence, answered every question that's been asked me by any Senator or any Member of the House, plus the fact that the Special Prosecutor, on his own initiation, and the Attorney General, on his initiation--the highest law enforcement official in this country-all of them have given me a clean bill of health. And I've told everything I know about it. I think the matter is settled once and for all. THE MODERATOR. Governor Carter, your response. MR. CARTER. I don't have any response. THE MODERATOR. Thank you. Then we will have the next question from Mr. Kraft to Governor Carter. MR. KRAFT. Governor Carter, the next big crisis spot in the world may be Yugoslavia. President Tito is old and sick, and there are divisions in his country. It's pretty certain that the Russians are going to do everything they possibly can after Tito dies to force Yugoslavia back into the Soviet camp. But last Saturday, you said--and this is a quote--"I would not go to war in Yugoslavia even if the Soviet Union sent in troops." Doesn't that statement practically invite the Russians to intervene in Yugoslavia? Doesn't it discourage Yugoslavs who might be tempted to resist? And wouldn't it have been wiser on your part to say nothing and to keep the Russians in the dark, as President Ford did and as, I think, every President has done since President Truman? MR. CARTER. In the last 2 weeks I've had a chance to talk to two men who have visited the Soviet Union, Yugoslavia, and China. One is Governor Averell Harriman,1 who visited the Soviet Union and Yugoslavia, and the other one is James Schlesinger,2 whom I think you accompanied to China. I got a complete report back from those countries from these two distinguished gentlemen. 1 Governor of New York 1954-58 and Ambassador at Large 1961, 1965-68. 2Secretary of Defense 1973-75. Mr. Harriman talked to the leaders in Yugoslavia, and I think it's accurate to say that there is no prospect, in their opinion, of the Soviet Union invading Yugoslavia should Mr. Tito pass away. The present leadership there is fairly uniform in their purpose. I think it's a close-knit group, and I think it would be unwise for us to say that we will go to war in Yugoslavia if the Soviets should invade, which I think would be an extremely unlikely thing. I have maintained from the very beginning of my campaign--and this was a standard answer that I made in response to the Yugoslavian question--that I would never go to war, become militarily involved in the internal affairs of another country, unless our own security was directly threatened. And I don't believe that our security would be directly threatened if the Soviet Union went into Yugoslavia. I don't believe it will happen. I certainly hope it won't. I would take the strongest possible measures short of actual military action there by our own troops, but I doubt that that would be an eventuality. MR. KRAFT. One quick follow-up. Did you clear the response you made with Secretary Schlesinger and Governor Harriman? MR. CARTER. No, I did not. THE MODERATOR. President Ford, your response. THE PRESIDENT. Well, I firmly believe, Mr. Kraft, that it's unwise for a President to signal in advance what options he might exercise if any international problem arose. I think we all recall with some sadness that at the period of the late 1940's, early 1950's, there were some indications that the United States would not include South Korea in an area of defense. There are some who allege--I can't prove it true or untrue--that such a statement, in effect, invited the North Koreans to invade South Korea. It's a fact they did. But no President of the United States, in my opinion, should signal in advance to a prospective enemy what his decision might be or what option he might exercise. It's far better for a person sitting in the White House, who has a number of options, to make certain that the other side, so to speak, doesn't know precisely what you're going to do. And therefore, that was the reason that I would not identify any particular course of action when I responded to a question a week or so ago. THE MODERATOR. Thank you. Mr. Maynard, your question to President Ford, please. MR. MAYNARD. Sir, this question concerns your administrative performance as President. The other day, General George Brown, the Chairman of the Joint Chiefs of Staff, delivered his views on several sensitive subjects, among them Great Britain, one of this country's oldest allies. He said, and I quote him now, "Great Britain--it's a pathetic thing, it just makes you cry. They are no longer a world power. All they have are generals, admirals, and bands." Since General Brown's comments have caused this country embarrassment in the past, why is he still this Nation's leading military officer? THE PRESIDENT. I have indicated to General Brown that the words that he used in that interview, in that particular case, and in several others were very ill-advised. And General Brown has indicated his apology, his regrets, and I think that will, in this situation, settle the matter. It is tragic that the full transcript of that interview was not released, and that there were excerpts, some of the excerpts, taken out of context--not this one, however--that you bring up. General Brown has an exemplary record of military performance. He served this Nation with great, great skill and courage and bravery for 35 years. And I think it's the consensus of the people who are knowledgeable in the military field that he is probably the outstanding military leader and strategist that we have in America today. Now, he did use ill-advised words. But I think in the fact that he apologized, that he was reprimanded, does permit him to stay on and continue that kind of leadership that we so badly need as we enter into negotiations under the SALT II agreement, or if we have operations that might be developing in the Middle East or in southern Africa or in the Pacific--we need a man with that experience, that knowledge, that know-how. And I think in light of the fact that he has apologized, would not have justified my asking for his resignation. THE MODERATOR. Thank you. Governor Carter, your response. MR. CARTER. Well, just briefly, I think this is the second time that General Brown has made a statement for which he did have to apologize--and I know that everybody makes mistakes. I think the first one was related to the unwarranted influence of American Jews on the media and in the Congress. This one concerned Great Britain. I think he said Israel was a military burden on us and that Iran hoped to reestablish the Persian Empire. I am not sure that I remembered earlier that President Ford had expressed his concern about the statement or apologized for it. This is something, though, that I think is indicative of a need among the American people to know how the Commander in Chief, the President, feels. And I think the only criticism that I would have of Mr. Ford is that immediately when the statement was revealed, perhaps a statement from the President would have been a clarifying and a very beneficial thing. THE MODERATOR. Mr. Nelson, your question now to Governor Carter. MR. NELSON. Governor, despite the fact that you've been running for President a long time now, many Americans still seem to be uneasy about you. They don't feel that they know you or the people around you. And one problem seems to be that you haven't reached out to bring people with broad background or national experience into your campaign or your Presidential plans. Most of the people around you on a day-to-day basis are the people you've known in Georgia. Many of them are young and relatively inexperienced in national affairs. Doesn't this raise a serious question as to whether you would bring into a Carter administration people with the necessary background to run the Federal Government? MR. CARTER. I don't believe it does. I began campaigning 22 months ago. At that time nobody thought I had a chance to win. Very few people knew who I was. I came from a tiny town, as you know--Plains--and didn't hold public office, didn't have very much money. And my first organization was just four or five people plus my wife and my children, my three sons and their wives. And we won the nomination by going out into the streets, barbershops, beauty parlors, restaurants, stores, in factory shift lines, also in farmers' markets and livestock sale barns, and we talked a lot and we listened a lot, and we learned from the American people. We built up an awareness among the voters of this country, particularly those in whose primaries I entered--30 of them, nobody has ever done that before--about who I was and what I stood for. Now we have a very wide-ranging group of advisers who help me prepare for these debates and who teach me about international economics and foreign affairs, defense matters, health, education, welfare, government reorganization-I'd say several hundred of them, and they are very fine and very highly qualified. The one major decision that I have made since acquiring the nomination-and I share this with President Ford--is the choice of the Vice President. I think this would be indicative of the kind of leaders that I would choose to help me if I am elected. I chose Senator Walter Mondale. And the only criterion that I have put forward in my own mind was, who among the several million people in this country would be the best person qualified to be President if something should happen to me and to join me in being Vice President if I should serve out my term? And I'm convinced now, more than I was when I got the nomination, that Walter Mondale was the right choice. And I believe this is a good indication of the kind of people that I would choose in the future. Mr. Ford has had that same choice to make. I don't want to say anything critical of Senator Dole, but I have never heard Mr. Ford say that that was his primary consideration--who is the best person I could choose in this country to be President of the United States. I feel completely at ease knowing that some day Senator Mondale might very well be President. In the last five Vice-Presidential nominees, incumbents, three of them have become President. But I think this is indicative of what I would do. THE MODERATOR. President Ford, your response please. THE PRESIDENT. The Governor may not have heard my established criteria for the selection of a Vice President, but it was a well-established criteria that the person I selected would be fully qualified to be President of the United States. And Senator Bob Dole is so qualified--16 years in the House of Representatives and in the Senate, very high responsibilities on important committees. I don't mean to be critical of Senator Mondale, but I was very, very surprised when I read that Senator Mondale made a very derogatory, very personal comment about General Brown after the news story that broke about General Brown. If my recollection is correct, he indicated that General Brown was not qualified to be a sewer commissioner. I don't think that's a proper way to describe a Chairman of the Joint Chiefs of Staff who has fought for his country for 35 years. And I'm sure the Governor would agree with me on that. I think Senator Dole would show more good judgment and discretion than to so describe a heroic and brave and very outstanding leader of the military. So, I think our selection of Bob Dole as Vice President is based on merit. And if he should ever become the President of the United States, with his vast experience as a Member of the House and a Member of the Senate, as well as a Vice President, I think he would do an outstanding job as President of the United States. THE MODERATOR. Mr. Kraft, your question to President Ford. MR. KRAFT. Mr. President, let me assure you and maybe some of the viewing audience that being on this panel hasn't been, as it may seem, all torture and agony. One of the heartening things is that I and my colleagues have received literally hundreds and maybe even thousands of suggested questions from ordinary citizens all across the country who want answers. THE PRESIDENT. That's a tribute to their interest in this election. MR. KRAFT. I will give you that. But let me go on, because one main subject on the minds of all of them has been the environment, particularly curious about your record. People 'really want to know why you vetoed the strip mining bill. They want to know why you worked against strong controls on auto emissions. They want to know why you aren't doing anything about pollution of the Atlantic Ocean. They want to know why a bipartisan organization such as the National League of Conservation Voters says that when it comes to environmental issues, you are--and I am quoting--"hopeless." THE PRESIDENT. First, let me set the record straight. I vetoed the strip mining bill, Mr. Kraft, because it was the overwhelming consensus of knowledgeable people that that strip mining bill would have meant the loss of literally thousands of jobs, something around 140,000 jobs. Number two, that strip mining bill would have severely set back our need for more coal, and Governor Carter has said repeatedly that coal is the resource that we need to use more in the effort to become independent of the Arab oil supplies. So, I vetoed it because of a loss of jobs and because it would have interfered with our energy independence program. The auto emissions--it was agreed by Leonard Woodcock, the head of the UAW, and by the heads of all of the automobile industry--we had labor and management together saying that those auto emission standards had to be modified. But let's talk about what the Ford administration has done in the field of environment. I have increased, as President, by over 60 percent, the funding for water treatment plants in the United States, the Federal contribution. I have fully funded the land and water conservation program; in fact, have recommended, and the Congress approved, a substantially increased land and water conservation program. I have added in the current year budget, the funds for the National Park Service. For example, we proposed about $12 million to add between 400 and 500 more employees for the National Park Service. And a month or so ago, I did likewise say over the next 10 years we should expand--double--the national parks, the wilderness areas, the scenic river areas. And then, of course, the final thing is that I have signed and approved of more scenic rivers, more wilderness areas since I've been President than any other President in the history of the United States. THE MODERATOR. Governor Carter. MR. CARTER. Well, I might say I think the League of Conservation Voters is absolutely right. This administration's record of environment is very bad. I think it's accurate to say that the strip mining law, which was passed twice by the Congress and only lacked two votes, I believe, of being overridden, would have been good for the country. The claim that it would have put 140,000 miners out of work is hard to believe when at the time Mr. Ford vetoed it, the United Mine Workers was supporting the bill. And I don't think they would have supported the bill had they known that they would lose 140,000 jobs. There has been a consistent policy on the part of this administration to lower or to delay enforcement of air pollution standards and water pollution standards. And under both Presidents Nixon and Ford, moneys have been impounded that would have gone to cities and others to control water pollution. We have no energy policy. We, I think, are the only developed nation in the world that has no comprehensive energy policy to permit us to plan, in an orderly way, how to shift from increasing the scarce energy forms--oil--and have research and development concentrated on the increased use of coal, which I strongly favor--the research and development to be used primarily to make the coal burning be clean. We need a heritage trust program, similar to the one we had in Georgia, to set aside additional lands that have geological and archeological importance, natural areas for enjoyment. The lands that Mr. Ford brags about having approved are in Alaska, and they are enormous in size, but as far as the accessibility of them by the American people, is very far in the future. We have taken no strong position in the control of pollution of our oceans. And I would say the worst threat to the environment of all is nuclear proliferation. And this administration, having been in office now for 2 years or more, has still not taken a strong and bold action to stop the proliferation of nuclear waste around the world, particularly plutonium. Those are some brief remarks about the failures of this administration. I would do the opposite in every respect. THE MODERATOR. Mr. Maynard to Governor Carter. MR. MAYNARD. Governor, Federal policy in this country since World War II has tended to favor the development of suburbs at the great expense of central cities. Does not the Federal Government now have an affirmative obligation to revitalize the American city? We have heard little in this campaign suggesting that you have an urban reconstruction program. Could you please outline your urban intentions for us tonight? MR. CARTER. Yes, I would be glad to. In the first place, as is the case with the environmental policy and energy policy that I just described, and the policy for nonproliferation of nuclear waste, this administration has no urban policy. It's impossible for mayors or Governors to cooperate with the President, because they can't anticipate what is going to happen next. A mayor of a city like New York, for example, needs to know 18 months or 2 years ahead of time what responsibility the city will have in administration and in financing, in things like housing, pollution control, crime control, education, welfare and health. This has not been done, unfortunately. I remember the headline in the Daily News that said, "Ford To New York--Drop Dead." I think it's very important that our cities know that they have a partner in the Federal Government. Quite often, Congress has passed laws in the past designed to help people with the ownership of homes and with the control of crime and with adequate health care and better education programs and so forth. Those programs were designed to help those who need it most, and quite often this has been in the very poor people and neighborhoods in the downtown urban centers. Because of the greatly advantaged persons who live in the suburbs--better education, better organization, more articulate, more aware of what the laws are--quite often this money has been channeled out of the downtown centers where it's needed. Also, I favor all revenue sharing money being used for local governments and also to remove the prohibitions in the use of revenue sharing money, so that it can be used to improve education and health care. We have now, for instance, only 7 percent of the total education costs being financed by the Federal Government. When the Nixon-Ford administration started, this was 10 percent. That's a 30-percent reduction in the portion that the Federal Government contributes to education in just 8 years and, as you know, the education costs have gone up tremendously. The last point is that the major thrust has got to be to put people back to work. We've got an extraordinarily high unemployment rate among downtown, urban ghetto areas; particularly among the very poor and particularly among minority groups, sometimes 50 or 60 percent. And the concentration of employment opportunities in those areas would help greatly not only to reestablish the tax base, but also to help reduce the extraordinary welfare costs. One of the major responsibilities on the shoulders of New York City is to finance welfare. And I favor the shifting of the welfare cost away from the local governments altogether and, over a longer period of time, let the Federal Government begin to absorb part of it that is now paid by the State government. Those things would help a great deal with the cities, but we still have a very serious problem there. THE MODERATOR. President Ford. THE PRESIDENT. Let me speak out very strongly. The Ford administration does have a very comprehensive program to help our major metropolitan areas. I fought for, and the Congress finally went along with, a general revenue sharing program whereby cities and States--the cities, two-thirds, and the States, one-third--get over $6 billion a year, in cash, with which they can provide many, many services, whatever they really want. In addition, we in the Federal Government make available to cities about $3,300 million in what we call community developments. In addition, as a result of my pressure on the Congress, we got a major mass transit program over a 4-year period--$11,800 million. We have a good housing program that will result in cutting the down payments by 50 percent and having mortgage payments lower at the beginning of any mortgage period. We are expanding our homestead housing program. The net result is, we think, under Carla Hills, who is the Chairman of my Urban Development and Neighborhood Revitalization program, we will really do a first-class job in helping the communities throughout the country. As a matter of fact, that committee, under Secretary Hills, released about a 75-page report with specific recommendations, so we can do a better job in the weeks ahead. And in addition, the tax program of the Ford administration, which provides an incentive for industry to move into our major metropolitan areas, into the inner cities, will bring jobs where people are and help to revitalize those cities as they can be. THE MODERATOR. Mr. Nelson, your question next to President Ford. MR. NELSON. Mr. President, your campaign has run ads in black newspapers saying that "for black Americans, President Ford is quietly getting the job done." Yet, study after study has shown little progress in desegregation and, in fact, actual increases in segregated schools and housing in the Northeast. Now, civil rights groups have complained repeatedly that there has been lack of progress in commitment to an integrated society during your administration. So, how are you getting the job done for blacks and other minorities, and what programs do you have in mind for the next 4 years? THE PRESIDENT. Well, let me say at the outset, I am very proud of the record of this administration. In the Cabinet I have one of the outstanding, I think, administrators as the Secretary of Transportation--Bill Coleman. You are familiar, I am sure, with the recognition given in the Air Force to General James. And there was just approved a three-star admiral, the first in the history of the United States Navy. So, we are giving full recognition to individuals, of quality in the Ford administration in positions of great responsibility. In addition, the Department of Justice is fully enforcing, and enforcing effectively, the Voting Rights Act--the legislation that involves jobs, housing for minorities, not only blacks but all others. The Department of HUD is enforcing the new legislation that takes care of redlining. What we are doing is saying that there are opportunities--business opportunities, educational opportunities, responsibilities--where people with talent--blacks or any other minority--can fully qualify. The office of minority business in the Department of Commerce has made available more money in trying to help black businessmen, or other minority businessmen, than any other administration since the office was established. The office of small business, under Mr. Kobelinski, has a very massive program trying to help the black community. The individual who wants to start a business or expand his business as a black businessman is able to borrow either directly or with guaranteed loans. I believe on the record that this administration has been responsive and have carried out the law to the letter, and I am proud of the record. THE MODERATOR. Governor Carter, your response, please. MR. CARTER. The description just made of this administration's record is hard to recognize. I think it is accurate to say that Mr. Ford voted against the voting rights acts and against the civil rights acts in their debative stage. I think once it was assured they were going to pass, he finally voted for it. This country changed drastically in 1969 when the terms of John Kennedy and Lyndon Johnson were over, and Richard Nixon and Gerald Ford became the Presidents. There was a time when there was hope for those who were poor and downtrodden and who were elderly or who were ill or who were in minority groups. That time has been gone. I think the greatest thing that ever happened to the South was the passage of the civil rights acts and the opening up of opportunities to black people, to have a chance to vote, to hold a job, to buy a house, to go to school, and to participate in public affairs. It not only liberated black people but it also liberated the whites. We have seen in many instances in recent years a minority affairs section of a small loan administration, Small Business Administration, lend a black entrepreneur just enough money to get started, and then to go bankrupt. The bankruptcies have gone up an extraordinary degree. The FHA [Federal Housing Administration], which used to be a very responsible agency that everyone looked to to help own a home, lost $600 million last year. There have been over 1,300 indictments in HUD, over 800 convictions relating just to home loans. And now the Federal Government has become the world's greatest slum landlord. We've got a 30-percent or 40-percent unemployment rate among minority young people. And there has been no concerted effort given to the needs of those who are both poor and black, or poor and who speak a foreign language. And that's where there has been a great generation of despair and ill-health and lack of education and lack of purposefulness and a lack of hope for the future. But it doesn't take just a quiet, dormant, minimum enforcement of the law. It requires an aggressive searching out and reaching out to help people who especially need it. And that's been lacking in the last 8 years. THE MODERATOR. Mr. Kraft, to Governor Carter. MR. KRAFT. Governor Carter, in the nearly 200-year history of the Constitution, there have been only, I think it is, 25 amendments, most of them on issues of the very broadest principle. Now we have proposed amendments in many highly specialized causes like gun control, school busing, balanced budget, school prayer, abortion, things like that. Do you think it's appropriate to the dignity of the Constitution to tack on amendments in a wholesale fashion, and which of the ones I listed--that is, balanced budget, school busing, school prayer, abortion, gun control--which of those would you really work hard to support if you were President? MR. CARTER. I would not work hard to support any of those. We have always had, I think, a lot of constitutional amendments proposed but the passage of them has been fairly slow and few and far between. In the 200-year history, there has been a very cautious approach to this. Quite often we have a transient problem. I am strongly against abortion. I think abortion is wrong. I don't think the Government ought to do anything to encourage abortion, but I don't favor a constitutional amendment on the subject. But short of a constitutional amendment, and within the confines of a Supreme Court ruling, I will do everything I can to minimize the need for abortions with better sex education, family planning, with better adoptive procedures. I personally don't believe that the Federal Government ought to finance abortions, but I draw the line and don't support a constitutional amendment. However, I honor the right of people to seek the constitutional amendments on school busing, on prayer in the schools, and on abortion, but among those you named, I won't actively work for the passage of any of them. THE MODERATOR. President Ford, your response, please. THE PRESIDENT. I support the Republican platform which calls for a constitutional amendment that would outlaw abortions. I favor the particular constitutional amendment that would turn over to the States the individual right of the voters in those States the chance to make a decision by public referendum. I call that the peoples' amendment. I think if you really believe that the people of a State ought to make a decision on a matter of this kind, that we ought to have a Federal constitutional amendment that would permit each one of the 50 States to make the choice. I think this is a reasonable and proper way to proceed. I believe also that there is some merit to an amendment that Senator Everett Dirksen proposed very frequently, an amendment that would change the Court decision as far as voluntary prayer in public schools. It seems to me that there should be an opportunity, as long as it's voluntary, as long as there is no compulsion whatsoever, that an individual ought to have that right. So, in those two cases I think such a constitutional amendment would be proper. And I really don't think in either case they are trivial matters. I think they are matters of very deep conviction as far as many, many people in this country believe, and therefore they shouldn't be treated lightly, but they are matters that are important. And in those two cases I would favor them. THE MODERATOR. Mr. Maynard, to President Ford. MR. MAYNARD. Mr. President, twice you have been the intended victim of would-be assassins using handguns, yet you remain a steadfast opponent of substantive handgun control. There are now some 40 million handguns in this country, going up at the rate of 2.5 million a year, and tragically those handguns are frequently purchased for self-protection and wind up being used against a relative or a friend. In light of that, why do you remain so adamant in your opposition to substantive gun control in this country? THE PRESIDENT. Mr. Maynard, the record of gun control, whether it's in one city or another or in some States does not show that the registration of a gun, handgun, or the registration of the gun owner has in any way whatsoever decreased the crime rate or the use of that gun in the committing of a crime. The record just doesn't prove that such legislation or action by a local city council is effective. What we have to do--and this is the crux of the matter--is to make it very, very difficult for a person who uses a gun in the commission of a crime to stay out of jail. If we make the use of a gun in the commission of a crime a serious criminal offense and that person is prosecuted, then in my opinion we are going after the person who uses the gun for the wrong reason. I don't believe in the registration of handguns or the registration of the handgun owner. That has not proven to be effective. And, therefore, I think the better way is to go after the criminal, the individual who commits a crime in the possession of a gun and uses that gun for a part of his criminal activity. Those are the people who ought to be in jail. And the only way to do it is to pass strong legislation so that once apprehended, indicted, convicted, they will be in jail and off the streets and not using guns in the commission of a crime. MR. MAYNARD. But, Mr. President, don't you think that the proliferation of the availability of handguns contributes to the possibility of those crimes being committed? And there is a second part to my follow-up. Very quickly, there are, as you know and as you've said, jurisdictions around the country with strong gun control laws. The police officials in those cities contend that if there were a national law to prevent other jurisdictions from providing the weapons that then come into places like New York, that they might have a better handle on the problem. Have you considered that in your analysis of the handgun proliferation problem? THE PRESIDENT. Yes, I have, and the individuals with whom I have consulted have not convinced me that a national registration of handguns or handgun owners will solve the problem you are talking about. The person who wants to use a gun for an illegal purpose can get it whether it's registered or outlawed-they will be obtained--and they are the people who ought to go behind bars. You should not, in the process, penalize the legitimate handgun owner. And when you go through the process of registration, you, in effect, are penalizing that individual who uses his gun for a very legitimate purpose. THE MODERATOR. Governor Carter. MR. CARTER. I think it's accurate to say that Mr. Ford's position on gun control has changed. Earlier, Mr. Levi, his Attorney General, put forward a gun control proposal which Mr. Ford later, I believe, espoused that called for the prohibition against the sale of the so-called "Saturday night specials." It would have put very strict control over who owned a handgun. I have been a hunter all my life and happen to own both shotguns, rifles, and a handgun. And the only purpose that I would see in registering handguns and not long guns of any kind would be to prohibit the ownership of those guns by those who have used them in the commission of a crime or who have been proven to be mentally incompetent to own a gun. I believe that limited approach to the question would be advisable, and I think adequate, but that's as far as I would go with it. THE MODERATOR. Mr. Nelson, to Governor Carter. MR. NELSON. Governor, you've said the Supreme Court today is, as you put it, moving back in the proper direction in rulings that have limited the rights of criminal defendants, and you've compared the present Supreme Court under Chief Justice Burger very favorably with the more liberal Court that we had under Chief Justice Warren. So, exactly what are you getting at, and can you elaborate on the kind of Court you think this country should have? And can you tell us the kind of qualifications and philosophy you would look for as President in making Supreme Court appointments? MR. CARTER. While I was Governor of Georgia, although I am not a lawyer, we had complete reform of the Georgia court system. We streamlined the structure of the courts, put in administrative offices, put a unified court system in, and required that all severe sentences be reviewed for uniformity; and, in addition to that, put forward a proposal that was adopted and used throughout my own term of office--selection of all judges and district attorneys, prosecuting attorneys, on the basis of merit. Every time I had a vacancy on the Georgia Supreme Court--and I filled five of those vacancies out of seven total, and about half of the Court of Appeals judges, about 35 percent of the trial judges--I was given from an objective panel the five most highly qualified persons in Georgia, and from those five I always chose the first or second one. So, merit selection of judges is the most important single criterion. And I would institute the same kind of procedure as President, not only in judicial appointments but also in diplomatic appointments. Secondly, I think that the Burger Court has fairly well confirmed the major and most far-reaching and most controversial decisions of the Warren Court. Civil rights has been confirmed by the Burger Court. It hasn't been reversed. And I don't think there is any inclination to reverse those basic decisions--of the one man-one vote rule, which is a very important one that struck down the unwarranted influence in the legislature of sparsely populated areas of the States. The right of indigent or very poor accused persons to legal counsel--I think the Burger Court has confirmed that basic and very controversial decision of the Warren Court. Also, the protection of an arrested person against unwarranted persecution in trying to get a false confession. But now, I think there have been a couple of instances where the Burger Court has made technical rulings where an obviously guilty person was later found to be guilty. And I think that in that case some of the more liberal members of the so-called Warren Court agreed with those decisions. But the only thing that I have pointed out was what I've just said, and that there was a need to clarify the technicalities so that you couldn't be forced to release a person who is obviously guilty just because of a small technicality in the law. And that's a reversal of position by the Burger Court with which I do agree. MR. NELSON. Governor, I don't believe you answered my question, though, about the kinds of people you would be looking for for the Court, the type of philosophy you would be looking for if you were making appointments to the Supreme Court as President. MR. CARTER. Okay, I thought I answered it by saying that it would be on the basis of merit. Once the search and analysis procedure had been completed, and once I am given a list of the 5 or 7 or 10 best qualified persons in the country, I would make a selection from among those persons. If the list was in my opinion fairly uniform, if there was no outstanding person, then I would undoubtedly choose someone who would most accurately reflect my own basic political philosophy, as best as I could determine it, which would be to continue the progress that has been made under the last two Courts--the Warren Court and the Burger Court. I would also like to completely revise our criminal justice system to do some of the things at the Federal level and court reform that I just described, as has been done in Georgia and other States. And I would like to appoint people who would be interested in helping with that. I know Chief Justice Burger is. He hasn't had help yet from the administration and from the Congress to carry this out. The emphasis, I think, of the court system should be to interpret the Constitution and the laws equally between property protection and personal protection. But when there is a very narrow decision--which quite often is one that reaches the Supreme Court--I think the choice should be with human rights, and that would be another factor that I would follow. THE MODERATOR. President Ford. THE. PRESIDENT. I think the answer as to the kind of person that I would select is obvious. I had one opportunity to nominate an individual to the Supreme Court, and I selected the Circuit Court of Appeals judge from Illinois, John Paul Stevens. I selected him because of his outstanding record as a Circuit Court of Appeals judge. And I was very pleased that an overwhelmingly Democratic United States Senate, after going into his background, came to the conclusion that he was fit and should serve, and the vote in his behalf was overwhelming. So, I would say somebody in the format of Justice Stevens would be the kind of an individual that I would select in the future, as I did him in the past. I believe, however, a comment ought to be made about the direction of the Burger Court vis-a-vis the Court that preceded it. It seems to me that the Miranda case was a case that really made it very, very difficult for the police, the law enforcement people in this country, to do what they could to make certain that the victim of a crime was protected and that those that commit crimes were properly handled and sent to jail. The Miranda case, the Burger Court is gradually changing. And I am pleased to see that there are some steps being made by the Burger Court to modify the so-called Miranda decision. I might make a correction of what Governor Carter said, speaking of gun control. Yes, it is true, I believe that the sale of Saturday night specials should be cut out, but he wants the registration of handguns. THE MODERATOR. Mr. Kraft. MR. KRAFT. Mr. President, the country is now in something that your advisers call an economic pause. I think to most Americans that sounds like an antiseptic term for low growth, unemployment, standstill at a high, high level, decline in take-home pay, lower factory earnings, more layoffs. Isn't that really a rotten record, and doesn't your administration bear most of the blame for it? THE PRESIDENT. Well, Mr. Kraft, I violently disagree with your assessment, and I don't think the record justifies the conclusion that you come to. Let me talk about the economic announcements that were made just this past week. Yes, it was announced that the GNP real growth in the third quarter was at 4 percent. But do you realize that over the last 10 years that's a higher figure than the average growth during the 10-year period. Now, it's lower than the 9.2-percent growth in the first quarter and it's lower than the 5-percent growth in the second quarter. But, every economist--liberal, conservative--that I am familiar with, recognizes that in the fourth quarter of this year and in the first quarter of next year that we will have an increase in real GNP. But now let's talk about the pluses that came out this week. We had an 18-percent increase in housing starts. We had a substantial increase in new permits for housing. As a matter of fact, based on the announcement this week, there will be at an annual rate, 1 million 800-some thousand new houses built, which is a tremendous increase over last year and a substantial increase over the earlier part of this year. Now, in addition, we had some very good news in the reduction in the rate of inflation, and inflation hits everybody--those who are working and those who are on welfare. The rate of inflation, as announced just the other day, is under 5 percent, and the 4.4 percent that was indicated at the time of the 4 percent GNP, was less than the 5.4 percent. It means that the American buyer is getting a better bargain today because inflation is less. MR. KRAFT. Mr. President, let me ask you this: There has been an increase in layoffs, and that's something that bothers everybody because even people that have a job are afraid they are going to be fired. Did you predict that increase in layoffs? Didn't that take you by surprise? Hasn't your administration been surprised by this pause? In fact, haven't you been so obsessed with saving money that you didn't even push the Government to spend funds that were allocated? THE PRESIDENT. Mr. Kraft, I think the record can be put in this way, which is the way that I think satisfies most Americans: Since the depths of the recession, we have added 4 million jobs. Most importantly, consumer confidence, as surveyed by the reputable organization at the University of Michigan, is at the highest since 1972. In other words, there is a growing public confidence in the strength of this economy. And that means that there will be more industrial activity; it means that there will be a reduction in the unemployment; it means that there will be increased hires; it means that there will be increased employment. Now, we've had this pause but most economists, regardless of their political philosophy, indicate that this pause for a month or two was healthy because we could not have honestly sustained a 9.2 percent rate of growth, which we had in the first quarter of this year. Now, I'd like to point out as well that the United States economic recovery from the recession of a year ago, is well ahead of the economic recovery of any major free industrial nation in the world today. We are ahead of all of the Western European countries. We are ahead of Japan. The United States is leading the free world out of the recession that was serious a year and a half ago. We are going to see unemployment going down, more jobs available, and the rate of inflation going down. And I think this is a record that the American people understand and will appreciate. THE MODERATOR. Governor Carter. MR. CARTER. Well, with all due respect to President Ford, I think he ought to be ashamed of making that statement because we have the highest unemployment rate now than we had at any time between the Great Depression, caused by Herbert Hoover, and the time President Ford took office. We have got 7 1/2 million people out of jobs. Since he has been in office, 2? million more American people have lost their jobs. In the last 4 months alone, 500,000 Americans have gone on the unemployment rolls. In the last month, we've had a net loss of 163,000 jobs. Anybody who says that the inflation rate is in good shape now ought to talk to the housewives. One of the overwhelming results that I have seen in places is people feel that you can't plan any more, there is no way to make a prediction that my family might be able to own a home or to put my kids through college. Saving accounts are losing money instead of gaining money. Inflation is robbing us. Under the present administrations--Nixon's and Ford's--we have had three times the inflation rate that we experienced under President Johnson and President Kennedy. The economic growth is less than half today what it was at the beginning of this year. And housing starts--he compares the housing starts with last year, I don't blame him because in 1975 we had fewer housing starts in this country, fewer homes built than any year since 1940. That's 35 years. And we've got a 35-percent unemployment rate in many areas of this country among construction workers. And Mr. Ford hasn't done anything about it. And I think this shows a callous indifference to the families that have suffered so much. He has vetoed bills passed by Congress within the congressional budget guidelines--job opportunities for 2 million Americans. We will never have a balanced budget, we will never meet the needs of our people, we will never control the inflationary spiral as long as we have 7? or 8 million people out of work who are looking for jobs. And we have probably got 2? more million people who are not looking for jobs any more because they've given up hope. That is a very serious indictment of this administration. It's probably the worst one of all. THE MODERATOR. Mr. Maynard. MR. MAYNARD. Governor Carter, you entered this race against President Ford with a 20-point lead or better in the polls and now it appears that this campaign is headed for a photo finish. You have said how difficult it is to run against a sitting President, but Mr. Ford was just as much an incumbent in July when you were 20 points ahead as he is now. Can you tell us what caused the evaporation of that lead, in your opinion? MR. CARTER. Well, that's not exactly an accurate description of what happened. When I was that far ahead it was immediately following the Democratic Convention and before the Republican Convention. At that time 25 or 30 percent of the Reagan supporters said that they would not support President Ford, but as occurred at the end of the Democratic Convention, the Republican Party unified itself, and I think immediately following the Republican Convention there was about a 10-point spread. I believe that to be accurate. I had 49 percent; President Ford had 39 percent. The polls are good indications of fluctuations, but they vary widely one from another, and the only poll I've ever followed is the one that, you know, is taken on Election Day. I was in 30 primaries in the spring and at first it was obvious that I didn't have any standing in the polls. As a matter of fact, I think when Gallup ran their first poll in December 1975, they didn't even put my name on the list. They had 35 people on the list--my name wasn't even there. At the beginning of the year, I had about 2 percent. So the polls, to me, are interesting, but they don't determine my hopes or my despair. I campaign among people. I have never depended on powerful political figures to put me in office. I have a direct relationship with hundreds of thousands of people around the country who actively campaign for me. In Georgia alone, for instance, I got 84 percent of the vote, and I think there were 14 people in addition to myself on the ballot, and Governor Wallace had been very strong in Georgia. That is an overwhelming support from my own people who know me best. And today we have about 500 Georgians at their own expense, just working people who believe in me, spread around the country involved in the political campaign. So the polls are interesting, but I don't know how to explain the fluctuations. I think a lot of it depends on current events--sometimes foreign affairs, sometimes domestic affairs. But I think our core of support among those who are crucial to the election has been fairly steady. And my success in the primary season was, I think, notable for a newcomer, from someone who's outside of Washington, who never has been a part of the Washington establishment. And I think that we will have a good result on November 2 for myself and I hope for the country. THE MODERATOR. President Ford, your response. THE PRESIDENT. I think the increase in the prospects as far as I am concerned and the less favorable prospects for Governor Carter reflect that Governor Carter is inconsistent in many of the positions that he takes. He tends to distort on a number of occasions. Just a moment ago, for example, he was indicating that in the 1950's, for example, unemployment was very low. He fails to point out that in the 1950's we were engaged in the war in Vietnam--I mean in Korea. We had 3,500,000 young men in the Army, Navy, Air Force, and Marines. That's not the way to end unemployment or to reduce unemployment. At the present time, we are at peace. We have reduced the number of people in the Army, Navy, Air Force, and Marines from 3,500,000 to 2,100,000. We are not at war. We have reduced the military manpower by 1,400,000. If we had that many more people in the Army, the Navy, the Air Force, and Marines, our unemployment figure would be considerably less. But this administration doesn't believe the way to reduce unemployment is to go to war or to increase the number of people in the military. So, you cannot compare unemployment, as you sought to, at the present time, with the 1950's, because the then administration had people in the military. They were at war. They were fighting overseas. And this administration has reduced the size of the military by 1,400,000. They are in the civilian labor market, and they are not fighting anywhere around the world today. THE MODERATOR. Thank you, gentlemen. This will complete our questioning for this debate. We don't have time for more questions and full answers. So, now each candidate will be allowed up to 4 minutes for a closing statement. And, at the original coin toss in Philadelphia a month ago, it was determined that President Ford would make the first closing statement tonight. President Ford. THE PRESIDENT. For 25 years, I served in the Congress under five Presidents. I saw them work, I saw them make very hard decisions. I didn't always agree with their decisions, whether they were Democratic or Republican Presidents. For the last 2 years, I've been the President, and I have found from experience that it's much more difficult to make those decisions than it is to second guess them. I became President at the time that the United States was in a very troubled time. We had inflation of over 12 percent; we were on the brink of the worst recession in the last 40 years; we were still deeply involved in the problems of Vietnam; the American people had lost faith and trust and confidence in the Presidency itself. That situation called for me to first put the United States on a steady course and to keep our keel well-balanced, because we had to face the difficult problems that had all of a sudden hit America. I think most people know that I did not seek the Presidency, but I am asking for your help and assistance to be President for the next 4 years. During this campaign, we've seen a lot of television shows, a lot of bumper stickers, and a great many slogans of one kind or another, but those are not the things that count. What counts is that the United States celebrated its 200th birthday on July 4. As a result of that wonderful experience all over the United States, there is a new spirit in America. The American people are healed, are working together. The American people are moving again and moving in the right direction. We have cut inflation by better than half. We have come out of the recession, and we are well on the road to real prosperity in this country again. There has been a restoration of faith and confidence and trust in the Presidency because I've been open, candid, and forthright. I have never promised more than I could produce and I have produced everything that I promised. We are at peace--not a single young American is fighting or dying on any foreign soil tonight. We have peace with freedom. I've been proud to be President of the United States during these very troubled times. I love America just as all of you love America. It would be the highest honor for me to have your support on November 2 and for you to say, "Jerry Ford, you've done a good job; keep on doing it." Thank you, and good night. THE MODERATOR. Thank you, President Ford. Governor Carter. MR. CARTER. The major purpose of an election for President is to choose a leader, someone who can analyze the depths of feeling in our country, to set a standard for our people to follow, to inspire people to reach for greatness, to correct our defects, to answer difficulties, to bind ourselves together in a spirit of unity. I don't believe the present administration has done that. We have been discouraged and we've been alienated, sometimes we've been embarrassed, sometimes we've been ashamed. Our people are out of work, and there is a sense of withdrawal. But our country is innately very strong. Mr. Ford is a good and decent man, but he has been in office now more than 800 days, approaching almost as long as John Kennedy was in office. I would like to ask the American people what has been accomplished. A lot remains to be done. My own background is different from his. I was a school board member and a library board member, I served on a hospital authority, and I was in the State senate, and I was Governor and I am an engineer, a naval officer, a farmer, a businessman. I believe we require someone who can work harmoniously with the Congress and can work closely with the people of this country, and who can bring a new image and a new spirit to Washington. Our tax structure is a disgrace and needs to be reformed, I was Governor of Georgia for 4 years. We never increased sales taxes or income tax or property taxes. As a matter of fact, the year before we went out of office we gave a $50 million refund to the property taxpayers of Georgia. We spend $600 per person in this country--every man, woman, and child-for health care. We still rank 15th among all of the nations in the world in infant mortality, and our cancer rate is higher than any country in the world. We don't have good health care. We could have it. Employment ought to be restored to our people. We have become almost a welfare state. We spend now 700 percent more on unemployment compensation than we did 8 years ago when the Republicans took over the White House. Our people want to go back to work. Our education system can be improved. Secrecy ought to be stripped away from government, and a maximum of personal privacy ought to be maintained. Our housing programs have gone bad. It used to be that the average family could own a house, but now less than a third of our people can afford to buy their own homes. The budget was more grossly out of balance last year than ever before in the history of our country--$65 billion--primarily because our people are not at work. Inflation is robbing us, as we've already discussed, and the Government bureaucracy is just a horrible mess. This doesn't have to be. I don't know all of the answers. Nobody could. But I do know that if the President of the United States and the Congress of the United States and the people of the United States said, "I believe our Nation is greater than what we are now," I believe that if we are inspired, if we can achieve a degree of unity, if we can set our goals high enough and work toward recognized goals with industry and labor and agriculture along with Government at all levels, we can achieve great things. We might have to do it slowly. There are no magic answers to it, but I believe together we can make great progress, we can correct our difficult mistakes and answer those very tough questions. I believe in the greatness of our country, and I believe the American people are ready for a change in Washington. We have been drifting too long. We have been dormant too long. We have been discouraged too long. And we have not set an example for our own people, but I believe that we can now establish in the White House a good relationship with Congress, a good relationship with our people, set very high goals for our country, and with inspiration and hard work we can achieve great things and let the world know--that's very important, but more importantly, let the people in our own country realize--that we still live in the greatest Nation on Earth. Thank you very much. THE MODERATOR. Thank you, Governor Carter, and thank you, President Ford. I also would like to thank the audience and my three colleagues--Mr. Kraft, Mr. Maynard, and Mr. Nelson, who have been our questioners. This debate has, of course, been seen by millions of Americans, and in addition tonight is being broadcast to 113 nations throughout the world. This concludes the 1976 Presidential debates, a truly remarkable exercise in democracy, for this is the first time in 16 years that the Presidential candidates have debated. It is the first time ever that an incumbent President has debated his challenger, and the debate included the first between the two Vice-Presidential candidates. President Ford and Governor Carter, we not only want to thank you but we commend you for agreeing to come together to discuss the issues before the American people. And our special thanks to the League of Women Voters for making these events possible. In sponsoring these events, the League of Women Voters Education Fund has tried to provide you with the information that you will need to choose wisely. The election is now only 11 days off. The candidates have participated in presenting their views in three 90-minute debates, and now it's up. to the voters, and now it is up to you to participate. The League urges all registered voters to vote on November 2 for the candidate of your choice. And now, from Phi Beta Kappa Memorial Hall on the campus of the College of William and Mary, this is Barbara Walters wishing you all a good evening.
