# Presidential Debate in St. Louis

**Date:** October 17, 2000
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-st-louis-0

---

MODERATOR: Good evening from the Field House at Washington University in St. Louis. I'm Jim Lehrer of the News Hour on PBS. And I welcome you to this third and final Campaign 2000 debate between the Democratic candidate for president, Vice President Al Gore, and the Republican candidate, Governor George W. Bush of Texas. Let's welcome the candidates now. Before proceeding tonight we would like to observe a moment of silence in memory of Governor Mel Carnahan of Missouri, who along with his son and his former chief of staff, died in a private plane crash last night near St. Louis. A reminder, as we continue now, that these debates are sponsored by the Commission on Presidential Debates. The formats and the rules were worked out by the commission and the two campaigns. Tonight's questions will be asked by St. Louis area voters who were identified as being uncommitted by the Gallup organization. Earlier today each of them wrote a question on a small card like this. Those cards were collected and then given to me this afternoon. My job, under the rules of the evening, was to decide the order the questions will be asked and to call on the questioners accordingly. I also have the option of asking follow-ups which -- in order to get to more of the panel's questions. For the record, I plan to do sparingly and mostly for clarifications. The audience participants are bound by the following rule. They shall not ask follow-up questions or otherwise participate in the extended discussion. And the questioner's microphone will be turned off after he or she completes asking the question. Those are the rules. As in Winston-Salem last week, no single answer or response from a candidate can exceed two minutes. There is an audience here in the hall and they have promised to remain absolutely quiet, as did their predecessors this year in Boston, Danville, and Winston-Salem. Before we begin, a correction from last week's debate. I was wrong when I said Vice President Gore's campaign commercials had called Governor Bush a bumbler. That specific charge was made in a press statement by Gore campaign spokesman Mark Fabiani, not in a TV Guide. GORE: I'm glad you clarified that. MODERATOR: Now, let's go to the first question. Of over the 130 questions we received from this panel, we will begin with one of the 19 on health issues, and it goes to you, Mr. Vice President, and it will be asked by James Hankin. Mr. Hankin? MEMBER OF AUDIENCE: How do you feel about HMOs and insurance companies making the critical decisions that affect people's lives instead of the medical professionals, and why are the HMOs and insurance companies not held accountable for their decisions? GORE: Mr. Hankins, I don't feel good about it, and I think we ought to have a patient's bill of rights to take the medical decisions away from the HMOs and give them back to the doctors and nurses. I want to come back and tell you why, but if you will forgive me, I would like to say something right now at the beginning of this debate following on the moment of silence for Mel Carnahan and Randy Carnahan and Chris Sifford. Tipper and I were good friends with Mel and Randy, and I know that all of us here want to extend our sympathy and condolences to Jean and the family and to the Sifford family. And I would just like to say that this debate in a way is a living tribute to Mel Carnahan because he loved the vigorous discussion of ideas in our democracy. He was a fantastic governor of Missouri. This state became one of the top five in the nation for health care coverage for children under his leadership. One of the best in advancing all kinds of benefits for children to grow up healthy and strong. And of course, this debate also takes place at a time when the tragedy of the USS Cole is on our minds and hearts and insofar as the memorial services tomorrow, I would like to also extend sympathy to the families of those who have died and those who are still missing, and the injured. Now, Mr. Hankins, I think that the situation that you describe has gotten completely out of hand. Doctors are giving prescriptions, they're recommending treatments, and then their recommendations are being overruled by HMOs and insurance companies. That is unacceptable. I support a strong national patient's bill of rights. It is actually a disagreement between us, a national law that is pending on this, the Dingle-Norwood bill, a bipartisan bill, is one that I support and that the governor does not. MODERATOR: Two minutes response, Governor Bush. BUSH: I, too, want to extend my prayers and blessings, God's blessings on the families whose lives were overturned yes -- tod -- last night. It's a tragic moment. Actually, Mr. Vice President, it's not true. I do support a national patient's bill of rights. As a matter of fact, I brought Republicans and Democrats together to do just that in the State of Texas to get a patient's bill of rights through. It requires a different kind of leadership style to do it, though. You see, in order to get something done on behalf of the people, you have to put partisanship aside, and that's what we did in my state. We have one of the most advanced patient's bill of rights. It says, for example, that a woman doesn't have to go through a gate keeper to go to her gynecologist. It says that you can't gag a doctor, doctor can advise you. The HMO, the insurance company, can't gag that doctor from giving you full advice. And this particular bill, it allows patients to choose a doctor, their own doctor if they want to. But we did something else that was interesting. We're one of the first states that said you can sue an HMO for denying you proper coverage. Now there's what's called an Independent Review Organization that you have to go through first. It says you have a complaint with your insurance company, you can take your complaint to an objective body. If the objective body rules on your behalf, the insurance company must follow those rules. However, if the insurance company doesn't follow the findings of the IRO, then that becomes a cause of action in a court of law. It's time for our nation to come together and do what's right for the people, and I think this is right for the people. You know, I support a national patient's bill of rights, Mr. Vice President, and I want all people covered. I don't want the law to supersede good law like we've got in Texas. I think -- MODERATOR: Governor, time is up, sir. GORE: Jim, we have a direct disagreement on this. MODERATOR: Just a minute, Mr. Vice President. I want to -- the way the rules go here now, two minutes, two minutes, and then I'll decide whether we go on. Okay. So what I want to make sure is we understand here is before we go on to another question in the health area, would you agree that you two agree on a national patient's bill of rights? GORE: Absolutely not. I referred to the Dingle-Norwood bill. It is the bipartisan bill that is now pending in the Congress. The HMOs and the insurance companies support the other bill that's pending, the one that the Republican majority has put forward. They like it because it doesn't accomplish what I think really needs to be accomplished to give the decisions back to the doctors and nurses and give you a right of appeal to somebody other than the HMO or insurance company, let you go to the nearest emergency room without having to call an HMO before you call 911, to let you see a specialist if you need to, and it has strong bipartisan support. It is being blocked by the Republican leadership in the Congress. MODERATOR: Sir. GORE: And I specifically would like to know whether Governor Bush will support the Dingle-Norwood bill, which is the main one pending. MODERATOR: Governor Bush, you may answer that if you'd like. But also I'd like to know how you see the differences between the two of you, and we need to move on. BUSH: Well, the difference is is that I can get it done. That I can get something positive done on behalf of the people. That's what the question in this campaign is about. It's not only what's your philosophy and what's your position on issues, but can you get things done? And I believe I can. GORE: What about the Dingle-Norwood bill? MODERATOR: All right. We're going to go now to another -- all right. Yes. BUSH: I'm not quite through. Let me finish. I talked about the principles and the issues that I think are important in a patient's bill of rights. It's kind of Washington, D.C. focus. Well, it's in this committee or it's got this sponsor. If I'm the president, we're going to have emergency room care, we're going have gag orders, we're going to have direct access to OB/GYN. People will be able to take their HMO insurance company to court. That's what I've done in Texas and that's the kind of leadership style I'll bring to Washington. MODERATOR: All right. Another -- the next question also on health issue is from -- it will be asked by Marie Payne Kloep, and it goes to Governor Bush. MEMBER OF AUDIENCE: Are either of you concerned with -- are either of you concerned with finding some feasible way to lower the price of pharmaceutical drugs such as education on minimizing intake, revamp of the FDA process or streamlining the drug companies' procedures instead of just finding more money to pay for them? BUSH: Well, that's a great question. I think one of the problems we have, particularly for seniors, is there is no prescription drug coverage in Medicare. And therefore, when they have to try to purchase drugs they do so on their own, there's no kind of collective bargaining, no power of purchasing among seniors. So I think step one to make sure prescription drugs is more affordable for seniors, and those are the folks who really rely upon prescription drugs a lot these days, is to reform the Medicare system, is to have precipitation drugs as an integral part of Medicare once and for all. The problem we have today is like the patient's bill of rights, particularly with health care, there's a lot of bickering in Washington, D.C. It's kind of like a political issue as opposed to a people issue. So what I want to do is I want to call upon Republicans and Democrats to forget all the arguing and finger pointing, and come together and take care of our seniors' prescription drug program, that says we'll pay for the poor seniors, we'll help all seniors with prescription drugs. In the meantime, I think it's important to have what's called Immediate Helping Hand, which is direct money to states so that seniors, poor seniors, don't have to choose between food and medicine. That's part of an overall overhaul. The purchasing powers. And I'm against price controls. I think price controls would hurt our ability to continue important research and development. Drug therapies are replacing a lot of medicines as we used to know it. One of the most important things is to continue the research and development component. And so I'm against price controls. Expediting drugs through the FDA makes sense, of course. Allowing the new bill that was passed in the Congress made sense to allow for, you know, drugs that were sold overseas to come back and other countries to come back into the United States. That makes sense. But the best thing to do is to reform Medicare. MODERATOR: Vice President Gore, two minutes. GORE: All right, here we go again. Now look, if you want someone who will spend a lot of words describing a whole convoluted process and then end up supporting legislation that is supported by the big drug companies, this is your man. If you want someone who will fight for you and who will fight for the middle-class families and working men and women, who are sick and tired of having their parents and grandparents pay higher prices for prescription drugs than anybody else, then I want to fight them. And you asked a great question because it's not only seniors. Listen, for 24 years I have never been afraid to take on the big drug companies. They do some great things. They discover great new cures and that's great. We want them to continue that. But they are now spending more money on advertising and promotion. You see all these ads? Than they are on research and development. And they are trying artificially extend the monopoly patent protection so they can keep charging these very high prices. I want to streamline the approval of the competing generic drugs and the new kinds of treatments that can compete with them so we bring the price down for everybody. Now, briefly, let me tell you how my prescription drug plan works. The governor talked about Medicare. I propose a real prescription drug benefit under Medicare for all seniors, all seniors, and here's how it works. You pick your own doctor, and nobody can take that away from you. The doctor chooses the prescription that you need and nobody can overrule your doctor. You go to your own pharmacy and then Medicare pays half the price. If you're poor, they pay all of it. If you have extraordinarily high cost, then they pay all over $4,000 out-of-pocket. And I'll bring new competition to bring the price down. And if you pass the big drug companies' bill, nothing will happen. MODERATOR: All right. Another health question, it comes from Vickie French, and it's for you, Vice President Gore. Vickie French, where are you? Oh, there she is. MEMBER OF AUDIENCE: You spend billions of dollars every year on taxes, or pay billions of dollars in taxes. Would you be open to the idea of a national health care plan for everybody? And if not, why? If so, is this something you would try to implement if you are elected into office and what would you do to implement this plan? GORE: I think that we should move step-by-step toward universal health coverage, but I am not in favor of government doing it all. We've spent 65 years now on the development of a hybrid system, partly private, partly public, and 85% of our people have health insurance, 15% don't. That adds up to 44 million people. That is a national outrage. We have got to get health coverage for those who do not have it and we've got to improve the quality for those who do with a patient's bill of rights that's real and that works, the Dingle-Norwood bill, and we have got to fill in the gaps in coverage by finally bringing parity for the treatment of mental illness, because that's been left out. We have got to deal with long-term care. Now, here are the steps that I would take, first of all. I will make a commitment to bring health care coverage of high quality that is affordable to every single child in America within four years. And then we'll fill other gaps by covering the parents of those children when the family is poor or up to two and a half times the poverty rate. I want to give a tax credit for the purchase of individual health insurance plans. I want to give small business employers a tax credit, 25%, to encourage the providing of health insurance for the employees in small businesses. I want to give seniors who are, well, the near elderly, I don't like that term because I am just about in that category, but those 55 to 65 ought to be able to buy into Medicare for premiums that are reasonable and fair and significantly below what they have to get now. Now, we have a big difference on this. And you need to know the record here. Under Governor Bush, Texas has sunk to be 50th out of 50 in health care -- in health insurance for their citizens. Last week he said that they were spending 3.7 billion dollars, or 4.7 billion dollars on this. MODERATOR: Mr. Vice president. GORE: Okay. MODERATOR: Time is up. Governor Bush, two minutes. BUSH: I'm absolutely opposed to a national health care plan. I don't want the federal government making decisions for consumers or for providers. I remember what the administration tried to do in 1993. They tried to have a national health care plan. And fortunately, it failed. I trust people, I don't trust the federal government. It's going to be one of the themes you hear tonight. I don't want the federal government making decisions on behalf of everybody. There is an issue with the uninsured, there sure is. And we have uninsured people in my state. Ours is a big state, a fast-growing state. We share a common border with another nation. But we're providing health care for our people. One thing about insurance, that's a Washington term. The question is, are people getting health care, and we have a strong safety net, and there needs to be a safety net in America. There needs to be more community health clinics where the poor can go get health care. We need a program for the uninsured. They've been talking about it in Washington, D.C. The number of uninsured has now gone up for the past seven years. We need a $2,000 credit, rebate for people, working people that don't have insurance, they can get in the marketplace and start purchasing insurance. We need to have -- allow small businesses to write insurance across jurisdictional lines so small business can afford health care, small restaurants can afford health care. So health care needs to be affordable and available. We have to trust people to make decisions with their lives. In the Medicare reform I talk about it says if you are a senior, you can stay in Medicare if you like it, and that's fine, but we're going to give you other choices to choose if you want to do so, just like they do the federal employees. The people that work in Washington, D.C. for the U.S. Congress or the United States senate. Get a variety of choices to make in their lives. And that's what we ought to do for all people in America. MODERATOR: Yes, sir, sorry. GORE: Follow-up? MODERATOR: Not right now. Education. These folks submitted 18 questions on education, and the first one is that will be asked on education will go to you, Governor, and asked by Angie Pettig. Angie Pettig, where are you? There she is, Governor, right there. MEMBER OF AUDIENCE: I've heard a lot about education and the need to hold teachers and schools accountable, and I certainly agree with that. But as an individual with an educational background, and also a parent, I have seen a lot of instances where the parents are unresponsive to the teachers or flat out uninvolved in their child's education. How do you intend to not only hold the teachers and schools accountable but also hold parents accountable? BUSH: Well, you know, it's hard to make people love one another. I wish I knew the law because I would darn sure sign it. I wish I knew the law that said all of us would be good parents. One of the things the next president must do is to remind people that if we are going to have a responsible period in America, that each of us must love our children with all our heart and all our soul. I happened to believe strong accountability encourages parental involvement, though. I think when you measure and post results on the Internet or in the town newspapers, most parents say wait a minute, my child's school isn't doing what I want it to do and, therefore, become involved in education. I recognize there are some who just don't seem to care. But there are a lot of parents who feel like everything is going well in their child's school, and all of a sudden they wake up and realize that wait a minute, standards aren't being met. That's why I'm so strong for accountability. I believe we ought to measure a lot, three, four, five, six, seven, eighth grade. We do so in my state of Texas. One of the good things we've gone in Texas is we have strong accountability because you can't cure unless you know. You can't solve a problem unless you diagnose it. I strongly believe that one of the best things to encourage parental involvement also is to know that the classrooms will be safe and secure. That's why I support a teacher liability act at the federal level, that says if a teacher or principal upholds reasonable standards of classroom discipline they can't be sued. They can't be sued. I think parents will be more involved with education when they know their children's classrooms are safe and secure as well. I also believe that we need to say to people that if you cannot meet standards, there has to be a consequence. Instead of just comes the soft bigotry of low expectations, that there has to be a consequence. We can't continue to shuffle children through school. And one of the consequences to allow parents to have different choices. MODERATOR: Governor. Vice president Gore. GORE: We have huge difference between us on this question. I'd like to start by telling you what my vision is. I see a day in the United States of America where all of our public schools are considered excellent, world class. Where there are no failing schools, where the classrooms are small enough in size, number of students, so that the teacher can spend enough one-on-one time with each student. Now that means recruiting new teachers for the public schools. It means in my plan hiring bonuses to get 100,000 new teachers in the public schools within the next four years. It means also helping local school districts that sometimes find the parents of school age children outvoted on bond issues, to give them some help with interest-free bonding authority so that we can build new schools and modernize the classrooms. We need to give teachers the training and professional development that they need, including a paid time off to go visit the classroom of a master teacher to pick up some new skills. I want to give every middle-class family a $10,000 a year tax deduction for college tuition so that middle-class families will always be able to send their kids on to college. I want to work for universal free school because we know from all the studies that the youngsters learn, kids learn more in the first few years of life than any where else. Now, I said there was a contrast. Governor Bush is for vouchers, and in his plan he proposes to drain more money, more taxpayer money out of the public schools for private school vouchers than all of the money that he proposes in his entire budget for public schools themselves. And only one in 20 students would be eligible for these vouchers, and they wouldn't even pay the full tuition to private school. I think that's a mistake. I don't think we should give up on the private schools and leave kids trapped in failing schools. I think we -- I think we should make it the number one priority to make our schools the best in the world, all of them. MODERATOR: Governor, what is your position on that? BUSH: Yeah, I appreciate that. I think any time we end with one of these attacks, it's appropriate to respond. Here's what I think. First of all, vouchers are up to states. If you want to do a voucher program in Missouri, fine. I strongly believe in local control of schools. I'm a governor of state and I don't like it when the federal government tells us what to do. I believe in local control of schools. But here's what I said. I've said to the extent we send federal money on disadvantaged children, we want the schools to show us whether or not the children are learning. What's unreasonable about that? We expect there to be standards met and we expect there to be measurement. And if we find success we'll praise it. But when we find children trapped in schools that will not change and will not teach, instead of saying oh, this is okay in America just to shuffle poor kids through schools, there has to be a consequence. And the consequence is that federal portion or federal money will go to the parent, so the parent can go to a tutoring program or another public school or another private school. You see, there has to be a consequence. We've got a society that says hey, the status quo is fine, just move them through. And guess who suffers. MODERATOR: What's the harm on that, what's the other side on that? GORE: Well, the program that he's proposing is not the one that he just. Described under your plan, Governor Bush, states would be required to pay vouchers to students to match the vouchers so that the federal government would put up. Now, you're -- and the way it would happen is that under his plan, if a school was designated as failing, the kids would be trapped there for another three years and then some of them would get federal vouchers and the state would be forced to match those, that money. Under my plan, if a school is failing, we work with the states to give them the authority and the resources to close down that school and reopen it right away with a new principal, a new faculty, a turn-around team of specialists who know what they're doing. It's based on the plan of Governor Jim Hunt in North Carolina, and it works great. MODERATOR: So no vouchers under -- in a Gore administration? GORE: If I thought that there was no alternative, then I might feel differently. But I have an obligation to fight to make sure there are no failing schools. We have to turn around -- most schools are excellent, but we have to make sure that all of them are. MODERATOR: Andrew Kosberg has a related question on education that's right on this subject. Mr. Kosberg, where are you? And it's for Vice President Gore. MEMBER OF AUDIENCE: Mr. Vice President, in a school district in which I work and in countless others across the nation, we face crumbling school buildings, increased school violence, student apathy, overcrowding, lack of funding, lawsuits, the list goes on. I could mention low teacher pay but I won't. What can you tell me and my fellow American teachers today about your plans for our immediate future? GORE: What grade do you teach? MODERATOR: That's a violation of your rule, Vice President Gore. GORE: High school. I mentioned before that the local communities are having a harder time passing bond issues. Traditionally, if you've been involved in a campaign like that, you know that the parents with kids in school are the ones that turn out and vote. It's ironic that there are now -- there is now a smaller percentage of the voters made up of parents with children than ever in American history because of the aging of our population, but at the same time we've got the largest generation of students in public schools ever. More than 90% of America's children go to public schools. And it's the largest number ever this year and they'll break the record next year and every year for ten years running. We've got to do something about this. And local -- it's not enough to leave it up to the local school districts. They're not able to do it and our future depends upon it. Look, we're in an information age. Our economic future depends upon whether or not our children are going to get the kind of education that lets them go on to college. And again, I want to make it possible for all middle-class families to send their kids to college and more Pell grants for those who are in the lower income groups also, and then I want to make sure that we have job training on top of that and lifelong learning, but it all starts with the public school teachers. My proposal gives $10,000 hiring bonuses for those teachers who are -- who get certified to teach in the areas where they're most needed. Now, accountability, we basically agree on accountability. My plan requires testing of all students. It also requires something that Governor Bush's plan doesn't. It requires testing of all new teachers, including in the subjects that they teach. We have to start treating teachers like the professionals that they are, and give them the respect and the kind of quality of life that will draw more people into teaching because we need a lot more teachers. MODERATOR: Governor Bush, two minutes. BUSH: When you total up all the federal spending he wants to do, it's the largest increase in federal spending in years. And there's just not going to be enough money. I have been a governor of a big state, I have made education my number one priority. That's what governors ought to do. They ought to say this is the most important thing we do as a state. The federal government puts about 6% of the money up. They put about, you know, 60% of the strings where you have to fill out the paperwork. I don't know if you have to be a paperwork filler-outer, but most of it's because of the federal government. What I want to do is to send flexibility and authority to the local folks so you can choose what to do with the money. One size does not fit all. I worry about federalizing education if I were you. I believe strongly that the federal government can help, need the funds, Headstart. We need to have accountability. The Vice President's plan does not have annual accountability, third grade, fourth grade, fifth grade. We need to demand on results. I believe strongly in a teacher protection act like I mentioned. I hear from teachers all the time about the lawsuits and the threats, respect in the classroom. Part of it's because you can't -- you can't control the classroom. You can't have a consequence for somebody without fear of getting sued under federal law. So I'm going to ask the Congress to pass a teacher protection act. So I believe in flexibility, I believe in a national reading initiative for local districts to access with K through 2 diagnostic testing, curriculum that works, phonics works, by the way, it needs to be a part of our curriculum. There needs to be flexibility for teacher training and teacher hiring with federal money. The federal government can be a part, but don't fall prey to all this stuff about money here and money there because education is really funded at the local level. 94% comes from the local level. MODERATOR: Vice President Gore, is the governor right when he says that you're proposing the largest federal spending in years? GORE: Absolutely not. Absolutely not. I'm so glad that I have the chance to knock that down. Look, the problem is that under Governor Bush's plan, $1.6 trillion tax cut, mostly to the wealthy, under his own budget numbers, he proposes spending more money for a tax cut just for the wealthiest 1% than all the new money he budgets for education, health care and national defense combined. Now under my plan we'll balance the budget every year. I'm not just saying this. I'm not just talking. I have helped to balance the budget for the first time in 30 years, paid down the debt. And under my plan, in four years, as the percentage of our gross domestic product, federal spending will be the smallest that it has been in 50 years. One reason is, you know, the third biggest spending item in our budget is interest on the national debt? We get nothing for it. We keep the good faith and credit of the United States. I will pay down the debt every single year until it is eliminated early in the next decade. That gets rid of the third biggest intrusion of the federal government in our economy. Now, because the governor has all this money for a tax cut mostly to the wealthy, there is no money left over, so schools get testing and lawsuit reform and not much else. MODERATOR: Governor, the vice president says you're wrong. BUSH: Well, he's wrong. (LAUGHTER) Just add up all the numbers. It's three times bigger than what President Clinton proposed. The Senate Budget Committee -- MODERATOR: Three times -- excuse me, three times bigger than what President Clinton proposed? GORE: That was in an ad, Jim, that was knocked down by the journalists who analyzed the ad and said it was misleading. BUSH: My turn? MODERATOR: Yes, sir. BUSH: Forget the journalists. He proposed more than Walter Mondale and Michael Dukakis combined. This is a big spender. And you ought to be proud of it, it's part of his record. We just have a different philosophy. Let me talk about tax relief. If you pay taxes, you ought to get tax relief. The Vice President believes only the right people ought to get tax relief. I don't think that's the role of the president to pick you're right and you're not right. I think if you're going to have tax relief, everybody ought to get it. And therefore, wealthy people are going to get it. But the top 1% will end up paying one-third of the taxes in America and they get one-fifth of the benefits. And that's because we structured the plan so that six million additional American families pay no taxes. If you're a family of four making $50,000 in Missouri, you get a 50% cut in your federal income taxes. What I've done is set priorities and funded them. And there's extra money. And I believe the people who pay the bills ought to get some money back. It's a difference of opinion. He wants to grow the government and I trust you with your own money. I wish we could spend an hour talking about trusting people. It's just the right position to take. GORE: Can we take the time -- MODERATOR: Governor -- yeah, hold on one second here, thought. The governor just reversed the thing. What do you say specifically to what the vice president said tonight, he said it many, many times, that your tax cut benefits the top 1% of the wealthiest Americans, and you've heard what he said. BUSH: Of course it does. If you pay taxes, you are going to get a benefit. People who pay taxes will get tax relief. MODERATOR: All right. Why shouldn't they? BUSH: Let me finish. Under my plan, if you make -- the top -- the wealthy people pay 62% of the taxes today. Afterwards they pay 64%. This is a fair plan. You know why? Because the tax code is unfair for people at the bottom end of the economic ladder. If you're a single mother making $22,000 a year today and you're trying to raise two children, for every additional dollar you earn you pay a higher marginal rate on that dollar than someone making $200,000, and that's not right. So I want to do something about that. MODERATOR: Vice President Gore? GORE: Yeah, look. Look, this isn't about Governor Bush, it's not about me. It is about you. And I want to come back to something I said before. If you want somebody who believes that we were better off eight years ago than we are now and that we ought to go back to the kind of policies that we had back then, emphasizing tax cuts mainly for the wealthy, here is your man. If you want somebody who will fight for you and who will fight to have middle-class tax cuts, then I am your man. I want to be. Now, I doubt anybody here makes more than $330,000 a year. I won't ask you, but if you do, you're in the top 1%. MODERATOR: It would be a violation of the rules. They couldn't -- GORE: I'm not going to ask them. But if everyone here in this audience was dead on in the middle of the middle-class, then the tax cuts for every single one of you all added up would be less than the tax cut his plan would give to just one member of that top wealthiest 1%. Now you judge for yourselves whether or not that's fair. MODERATOR: Quick, and then we're moving on. BUSH: Good. 50 million Americans get no tax relief under his plan. GORE: That's not right. BUSH: You may not be one of them, you're just not one of the right people. And secondly, we've had enough fighting. It's time to unite. You talk about eight years? In eight years they haven't gotten anything done on Medicare, on Social Security, a patient's bill of rights. It's time to get something done. GORE: Hey, I've got to answer that, Jim. MODERATOR: All right. GORE: Medicare -- I cast the tie-breaking vote to add 26 years to the life of Medicare. It was due to go bankrupt in 1999 and that 50 million figure again, the newspapers -- I said -- you said forget the journalists, but they are the keepers of the score card and whether or not you're using facts that aren't right. And that fact is just not right. MODERATOR: Speaking of keepers of the score card, that's what I'm trying to do here Mr. Vice President and Governor Bush. We're gonna move on. We're gonna have to move on. All right, there were 12 questions on foreign and military matters, and the first one that we're going to ask will be directed to you, Governor Bush. And David Norwood is going to ask it. Mr. Norwood, where are you? There you are. MEMBER OF AUDIENCE: What would you make -- what would make you the best candidate in office during the Middle East crisis? BUSH: I've been a leader. I've been a person who has to set a clear vision and convince people to follow. I've got a strategy for the Middle East. And first let me say that our nation now needs to speak with one voice during this time, and I applaud the president for working hard to diffuse tensions. Our nation needs to be credible and strong. When we say we're somebody's friend, everybody has got to believe it. Israel is our friend and we'll stand by Israel. We need to reach out to modern Arab nations as well. To build coalitions to keep the peace. I also need -- the next leader needs to be patient. We can't put the Middle East peace process on our timetable. It's got to be on the timetable of the people that we're trying to bring to the peace table. We can't dictate the terms of peace, which means that you have to be steady. You can't worry about polls or focus groups. You've got to have a clear vision. That's what a leader does. A leader also understands that the United States must be strong to keep the peace. Saddam Hussein still is a threat in the Middle East. Our coalition against Saddam is unraveling. Sanctions are loosened. The man who may be developing weapons of mass destruction, we don't know because inspectors aren't in. So to answer your question, it requires a clear vision, a willingness to stand by our friends, and the credibility for people both friend and foe to understand when America says something, we mean it. MODERATOR: Vice President Gore? GORE: I see a future when the world is at peace, with the United States of America promoting the values of democracy and human rights and freedom all around the world. Even in Iran they have had an election that began to bring about some change. We stand for those values and we have to be willing to assert them. Right now our military is the strongest in the entire history of the world. I will -- I pledge to you I will do whatever is necessary to make sure that it stays that way. Now, what can I bring to that challenge? When I was a young man, my father was a senator opposed to the Vietnam War. When I graduated from college, there were plenty of fancy ways to get out of going and being a part of that. I went and I volunteered, and I went to Vietnam. I didn't do the most or run the greatest risk by a long shot, but I learned what it was like to be an enlisted man in the United States Army. In the Congress, in the House of Representatives, I served on the House Intelligence Committee and I worked hard to learn the subject of nuclear arms control and how we can diffuse these tensions and deal with non-proliferation and deal with the problems of terrorism and these new weapons of mass destruction. Look, we're gonna face some serious new challenges in the next four years. I've worked on that long and hard. When I went to the United States Senate, I asked for an assignment to the Armed Services Committee. And while I was there I worked on a bipartisan basis, as I did in the House, I worked with former President Reagan on the modernization of our strategic weaponry. In the Senate I was one of only ten Democrats, along with Senator Joe Lieberman, to support Governor Bush's dad in the Persian Gulf War Resolution. And for the last eight years I've served on the National Security Council. Can I say just one other thing here? MODERATOR: No, sir. We'll get that -- I'm gonna -- the next question is to you. GORE: Fine, I'll wait. MODERATOR: It's a related -- it's a related question that is going to be asked by Kenneth Allen. Mr. Allen? GORE: I think he gets a -- oh, I'm sorry, you're right, go ahead. MODERATOR: Mr. Allen, right there. MEMBER OF AUDIENCE: Today our military forces are stretched thinner and doing more than they have ever done before during peacetime. I would like to know what you are -- I think we would all like to know what you as president would do to ensure proper resourcing for the current mission and/or more selectively choosing the time and place that our forces will be used around the world. GORE: Thank you, sir. Just to finish briefly, I started to say that for the last eight years I've been on the National Security Council. Last week I broke up -- I suspended campaigning for two days, or parts of two days, to go back and participate in the meetings that charted the President's summit meeting that he just returned from earlier today. And our team of -- our country's team over there did a great job. It's a difficult situation. The United States has to be strong in order to make sure that we can help promote peace and security and stability. And that means keeping our military strong. Now, I said earlier that we are the strongest military, but we need to continue improving readiness and making sure that our military personnel are adequately paid and that the combination of their pay and their benefits and their retirement as veterans is comparable to the stiff competition that's coming in this strong economy from the private sector. And I have supported the largest pay raise in many a year, and I support another one now. I also support modernization of our strategic and tactical weaponry. The governor has proposed skipping a generation of technology. I think that would be a mistake, because I think one of the ways we've been able to be so successful in Kosovo and Bosnia and Haiti and in other places is by having the technological edge. You know, we won that conflict in Kosovo without losing a single human life in combat, a single American life in combat. Now, readiness. The trends before we -- before I got my current job were on the decline, the number of divisions were reduced. I argued that we should reverse that trend and take it back up. And I'm happy to tell you that we have. Now, in my budget for the next ten years I propose $100 billion for this purpose. The governor proposes $45 billion. I propose more than twice as much because I think it's needed. MODERATOR: Governor Bush, two minutes. BUSH: If this were a spending contest, I would come in second. I readily admit I'm not going to grow the size of the federal government like he is. Your question was deployment. It must be in the national interests, must be in our vital interests whether we ever send troops. The mission must be clear. Soldiers must understand why we're going. The force must be strong enough so that the mission can be accomplished. And the exit strategy needs to be well-defined. I'm concerned that we're overdeployed around the world. See, I think the mission has somewhat become fuzzy. Should I be fortunate enough to earn your confidence, the mission of the United States military will be to be prepared and ready to fight and win war. And therefore prevent war from happening in the first place. There may be some moments when we use our troops as peacekeepers, but not often. The Vice President mentioned my view of long-term for the military. I want to make sure the equipment for our military is the best it can possibly be, of course. But we have an opportunity -- we have an opportunity to use our research and development capacities, the great technology of the United States, to make our military lighter, harder to find, more lethal. We have an opportunity, really, if you think about it, if we're smart and have got a strategic vision and a leader who understands strategic planning, to make sure that we change the terms of the battlefield of the future so we can keep the peace. This is a peaceful nation, and I intend to keep the peace. Spending money is one thing. But spending money without a strategic plan can oftentimes be wasted. First thing I'm going to do is ask the Secretary of Defense to develop a plan so we are making sure we're not spending our money on political projects, but on projects to make sure our soldiers are well-paid, well-housed, and have the best equipment in the world. MODERATOR: Governor Bush, another kind of gun question. It will be asked by Robert Lutz. Mr. Lutz? MEMBER OF AUDIENCE: Governor Bush -- BUSH: Yes, sir. MEMBER OF AUDIENCE: We would just like to know what is your opposition to the Brady Handgun bill? BUSH: I'm sorry, I didn't hear that. MEMBER OF AUDIENCE: We would like to know why you object to the Brady Handgun bill, if you do object to it. Because in a recent TV ad it showed that the National Rifle Association says that if you are elected, that they will be working out of your office. BUSH: I don't think the National Rifle Association ran that ad. But let me just tell you my position on guns in general, sir, if you don't mind. MODERATOR: Excuse me, I'm not sure he's finished with his question. BUSH: I'm sorry. MEMBER OF AUDIENCE: That kind of bothers me when I see an ad like that. I want you to explain that ad to me. BUSH: Well, I don't think I ran the ad. I think somebody who doesn't want me to be president might have run that ad. That wasn't my ad. I think it might have been one of my opponent's ads. Here is what I believe, sir. I believe law-abiding citizens ought to be allowed to protect themselves and their families. I believe that we ought to keep guns out of the hands of people that shouldn't have them. That's why I'm for instant background checks at gun shows, I'm for trigger locks, I think that makes sense. Matter of fact, we distributed free trigger locks in the State of Texas so that people can get them and put them on their guns to make their guns more safe. I think we ought to raise the age at which juveniles can have a gun. But I also believe strongly that we need to enforce laws on the books that the best way to make sure that we keep our society safe and secure is to hold people accountable for breaking the law. If we catch somebody illegally selling a gun, there needs to be a consequence. If we keep somebody -- you know, illegally using a gun, there needs to be a consequence. Enforcement of law, and the federal government can help. There is a great program called Project Exile in Richmond, Virginia, where we focused federal taxpayers' money and federal prosecutors and went after people who were illegally using guns. To me that's how you make society the safest it can be. And so, yeah, sometimes I agree with some of these groups in Washington and sometimes I don't. I'm a pretty independent thinker. The one thing I'm for is a safe society. And I'm for enforcing laws on the books. And that's what is going to happen should I earn your confidence. MODERATOR: Vice President Gore? GORE: Well, it was not one of my ads, either, Governor. But I am familiar with the statement, and it was made by one of the top-ranking officials of that organization. Let me tell you my position. I think that some common sense gun safety measures are certainly needed with the flood of cheap handguns that have sometimes been working their way into the hands of the wrong people. But all of my proposals are focused on that problem, gun safety. None of my proposals would have any effect on hunters, or sportsmen, or people who use rifles. They're aimed at the real problem. Let's make our schools safe, let's make our neighborhoods safe. Let's have a three-day waiting period, cooling off, so we can have a background check to make sure that criminals and people who really shouldn't have guns don't get them. But I would like to use my remaining time on this exchange, Jim, to respond to an exchange that took place just a moment ago. Because a couple of times the governor has said that I am for a bigger government. Governor, I'm not. And let me tell you what the record shows. For the last eight years I have had the challenge of running the streamlining program called Reinventing Government. And if there are any federal employees in this group, you know what that means. The federal government has been reduced in size by more than 300,000 people. And it's now the smallest number that we have had since the -- the smallest in size since John Kennedy's administration. During the last five years, Texas's government has gone up in size. Federal government has gone down, Texas's government has gone up. Now, my plan for the future, I see a time when we have smaller, smarter government where you don't have to wait in line because you can get services online cheaper, better, faster. We can do that. MODERATOR: Steve Luecker has a question, and it is for Vice President Gore. Mr. Luecker? There you are. MEMBER OF AUDIENCE: Vice President Gore. The family farms are disappearing and having a hard time even in the current positive economic environment. What steps would you or your administration take on agricultural policy developments to protect the family farms for this multi-functional service they perform? GORE: We've got a bumper crop this year. But that's the good news. You know what the bad news is that follows on that. The prices are low. In the last several years, the so-called Freedom To Farm Law has, in my view, been mostly a failure. I want to change many of its provisions. Now, many here who are not involved in farming don't -- won't follow this, so just forgive me. Because the 2% of the country that is involved in farming is important because the rest of us wouldn't eat except for them. And you guys have been having a hard time, and I want to fight for you. I want to change those provisions. I want to restore a meaningful safety net. And I think that you pointed the way in your comments, because when you say there are multiple things accomplished by farmers, you're specifically including conservation and protection of the environment. And yes, farmers are the first environmentalists. And when they decide not to plow a field that is vulnerable to soil erosion, that may cost them a little money, but it helps the environment. I think that we ought to have an expanded conservation reserve program. And I think that the environmental benefits that come from sound management of the land ought to represent a new way for farmers to get some income that will enable them -- enable you to make sensible choices in crop rotation, and when you leave the land fallow and the rest. Now, I'll go beyond that and say I think we need much more focus on rural economic development programs. I see a time when the Internet-based activities are more available in the rural areas and where the extra source of income that farm families used to have from shoe factories is replaced by an extra source of income from working in the information economy. So we need to do a lot of things, but we ought to start with a better safety net. MODERATOR: Governor Bush, two minutes. BUSH: I would like our farmers feeding the world. We're the best producers in the world, and I want -- I want the farmers feeding the world. We need to open up markets. Exports are down, and every time an export number goes down, it hurts the farmer. I want the next president to have fast track negotiating authority to open up markets around the world with the best and the most efficient farmers. I don't want to use food as a diplomatic weapon from this point forward. We shouldn't be using food. It hurts the farmers. It's not the right thing to do. I'm for value-added processing. We need more work on value-added processing. You take the raw product you produce, I presume you're a farmer, off your farm, and you convert it. Value-added processing is important. I'm for research and development. Spending research and development money so that we can use our technological base to figure out new uses for farm products. I'm for getting rid of the death tax, completely getting rid of the death tax. One reason family farmers are forced to sell early is because of the death tax. This is a bad tax. The President shouldn't have vetoed that bill. It's a tax that taxes people twice. It penalizes the family farmer. So should I be fortunate enough to earn your vote, I also understand -- I want to open up markets, but I also understand that farming is a part of our national security. I'm from a big farm state. We're the second biggest state -- farming state in the country. And I hear from my farmers and friends all the time. The Vice President is right, by the way. Every day is earth day if you own the land. I like the policies that will encourage farmers to put -- set aside land as well for conservation purposes. Thank you. MODERATOR: A quick thing on the inheritance tax. There is a difference between the two of you on this. Vice President Gore? GORE: Yeah. I'm for a massive reform of the estate tax or the death tax. And under the plan that I've proposed, 80% of all family farms will be completely exempt from the estate tax. And the vast majority of all family businesses would be completely exempt, and all of the others would have sharply reduced. So 80% -- now the problem with completely eliminating it goes back to the wealthiest 1%. The amount of money that has to be raised in taxes for middle-class families to make up for completely eliminating that on the very wealthiest, the billionaires, that would be an extra heavy burden on middle-class families. And so let's do it for most all, but not completely eliminate it for the very top. MODERATOR: What's the case for doing that, Governor? BUSH: Eliminating the death tax. MODERATOR: Completely. BUSH: Because people shouldn't be taxed twice on their assets. It's either unfair for some or unfair for all. Again, this is just a difference of opinion. If you're from Washington, you want to pick and choose winners. I don't think that's the role of the president. I think if you're going to have tax relief, everybody benefits. Secondly, I think your plan -- a lot of fine print in your plan, Mr. Vice President, with all due respect. It is -- I'm not so sure 80% of the people get the death tax. I know this, 100% will get it if I'm the president. I just don't think it's fair to tax people's assets twice regardless of your status. It's a fairness issue. It's an issue of principle, not politics. MODERATOR: New issue. New issue. And the question will be asked by Joyce Cleamer of Governor Bush. Joyce Cleamer? There you are. BUSH: Hi, Joyce. MEMBER OF AUDIENCE: Hi, Governor. I'm very concerned about the morality of our country now. TV, movies, the music that our children are, you know, barraged with every day. And I want to know if there's anything that can be worked out with the -- Hollywood, or whoever, to help get rid of some of this bad language and whatever, you know. It's just bringing the country down. And our children are very important to us and we're concerned about their education at school. We should be concerned about their education at home, also. Thank you. BUSH: Appreciate that question. Laura and I are proud parents of teenage girls, twin daughters, and I know what you're saying. Government ought to stand on the side of parents. Parents are teaching their children right from wrong, and the message oftentimes gets undermined by the popular culture. You bet there's things that government can do. We can work with the entertainment industry to provide family hour. We can have filters on Internets where public money is spent. There ought to be filters in public libraries and filters in public schools so if kids get on the Internet, there is not going to be pornography or violence coming in. I think we ought to have character education in our schools. I know that doesn't directly talk about Hollywood, but it does reinforce the values you're teaching. Greatly expand character education funding so that public schools will teach children values, values which have stood the test of time. There's afterschool money available. I think that afterschool money ought to be available for faith-based programs and charitable programs that exist because somebody has heard the call to love a neighbor like you would like to be loved yourself. That will help reinforce the values that parents teach at home as well. Ours is a great land, and one of the reasons why is because we're free. And so I don't support censorship. But I do believe that we ought to talk plainly to the Hollywood moguls and people who produce this stuff and explain the consequences. I think we need to have rating systems that are clear. I happen to like the idea of having technology for the TV, easy for parents to use so you can tune out these programs you don't want in your house. I'll remind mothers and dads the best weapon is the off/on button, and paying attention to your children, and eating dinner with them and being -- I'm sorry. GORE: My turn. MODERATOR: Vice President Gore. GORE: I care a lot about this. It's not just movies; television, video games, music, the Internet. Parents now feel like you have to compete with the mass culture in order to raise your kids with the values that you want them to have. Tipper and I have four children. And God bless them, every one of them decided on their own to come here this evening. I don't want to embarrass our oldest daughter. She and her husband made us grandparents almost a year-and-a-half ago, and yet if she'll forgive me, when she was little, she brought a record home that had some awful lyrics in it and Tipper hit the ceiling. And that launched a campaign to try to get the record companies to put ratings that -- warning labels for parents. And I'm so proud of what she accomplished in getting them on there. I've been involved myself in negotiating and helping to move along the negotiations with the Internet service providers to get a parents' protection page every time 95% of the pages come up. And a feature that allows parents to automatically check with one click what sites your kids have visited lately. You know, some parents are worried about those filters, that you will have to ask your kids how to put them on there. But if you can check up on them, that's real power. And recently the Federal Trade Commission pointed out that some of these entertainment companies have warned parents that the material is inappropriate for children, and then they've turned around behind the backs of the parents and advertised that same adult material directly to children. That is an outrage. Joe Lieberman and I gave them six months to clean up their act. And if they don't do it, we're gonna ask for tougher authority in the hands of the FTC on the false and deceptive advertising. I'll tell you this, I want to do something about this. Respect the First Amendment, but I will do something to help you raise your kids without that garbage. MODERATOR: All right. Vice President Gore, the next question is for you, and it will be asked by Steven Koosmann. Mr. Koosmann, where are you, sir? You're right behind me as well. There we go. GORE: Right next to the left. MEMBER OF AUDIENCE: It seems that when we hear about issues of this campaign, it's usually Medicare, Social Security or prescription drugs. As a college professor, I hear a lot of apathy amongst young people who feel that there are no issues directed to them. And they don't plan to vote. How do you address that? GORE: We've got to change it. I spend a good deal of time talking to young people, and in my standard speech out there on the stump I usually end my speech by saying, I want to ask you for something and I want to direct it especially to the young people in the audience. And I want to tell you what I tell them. Sometimes people who are very idealistic and have great dreams, as young people do, are apt to stay at arm's length from the political process because they think their good hearts might be brittle, and if they invest their hopes and allow themselves to believe, then they're gonna be let down and disappointed. But thank goodness we've always had enough people who have been willing in every generation to push past the fear of a broken heart and become deeply involved in forming a more perfect union. We're America, and we believe in our future and we know we have the ability to shape our future. Now, we've got to address one of the biggest threats to our democracy. And that is the current campaign financing system. And I know they say it doesn't rank anywhere on the polls. I don't believe that's a fair measure. I'm telling you, I will make it the -- I will make the McCain-Feingold Campaign Finance Reform bill the very first measure that I send to the Congress as president. Governor Bush opposes it. I wish that he would consider changing his mind on that. Because I think that the special interests have too much power, and we need to give our democracy back to the American people. Let me tell you why. Those issues you mentioned, Social Security, prescription drugs, the big drug companies are against the prescription drug proposal that I've made. The HMOs are against the patient's rights bill, the Dingle-Norwood bill that I support. The big oil companies are against the measures to get more energy independence and renewable fuel. They ought to have their voices heard, but they shouldn't have a big megaphone that drowns out the American people. We need campaign finance reform and we need to shoot straight with young and old alike and tell them what the real choices are. And we can renew and rekindle the American spirit and make our future what our founders dreamed it could be. We can. MODERATOR: Governor Bush, two minutes. BUSH: Tell you what I hear. A lot of people are sick and tired of the bitterness in Washington, D.C. and therefore they don't want any part of politics. They look at Washington and see people pointing fingers and casting blame and saying one thing and doing another. There's a lot of young folks saying, you know, why do I want to be involved with this mess? And what I think needs to happen in order to encourage the young to become involved is to shoot straight, is to set aside the partisan differences, and set an agenda that will make sense. Medicare, I know you talked about it, but Medicare is relevant for all of us, young and old alike. We better get it right now. Tax reform is relevant for old and young alike. I don't think it's the issues that turn kids off. I think it's the tone. I think it's the attitude. I think it's a cynicism in Washington and it doesn't have to be that way. Before I decided to run, I had to resolve two issues in my mind. One, could our family endure all this business. And I came to the conclusion that our love was strong enough to be able to do it. The other was could an administration change the tone in Washington, D.C. And I believe the answer is yes, otherwise I wouldn't be asking for your vote. That's what happened in Texas. We worked together. There is a man here in this audience named Hugo Berlanga. He is the chairman of the health committee. He came here for a reason, to tout our record on health in Texas. He's a Democrat. I didn't care whether he was a Republican or Democrat. What I cared about is could we work together. That's what Washington, D.C. needs. And finally, sir, to answer your question, you need somebody in office who will tell the truth. That's the best way to get people back in the system. MODERATOR: Governor Bush, Norma Curby has the next question. And it's for you. Norma Curby, where are you? BUSH: Hi, Norma. MEMBER OF AUDIENCE: Hi. How will your administration address diversity, inclusiveness, and what role will affirmative action play in your overall plan? BUSH: I've had a record of bringing people from all walks of life into my administration, and my administration is better off for it in Texas. I'm going to find people that want to serve their country. But I want a diverse administration, I think it's important. I've worked hard in the State of Texas to make sure our institutions reflect the state with good, smart policy. Policy that rejects quotas. I don't like quotas. Quotas tend to pit one group of people against another. Quotas are bad for America. It's not the way America is all about. But policies that give people a helping hand so they can help themselves. For example, in our State of Texas I worked with the legislature, both Republicans and Democrats, to pass a law that said if you come in the top 10% of your high school class, you're automatically admitted to one of our higher institutions of learning, college. And as a result, our universities are now more diverse. It was a smart thing to do. What I called it, I labeled it affirmative access. I think the contracting business in government can help. Not with quotas, but help meet a goal of ownership of small businesses, for example. The contracts need to be smaller, the agencies need to be -- need to recruit and to work hard to find people to bid on the state contracts. I think we can do that in a way that represents what America is all about, which is equal opportunity and an opportunity for people to realize their potential. So to answer your question, I support, I guess the way to put it, is affirmative access. I'll have an administration that will make you proud. Thank you. MODERATOR: Vice President Gore? GORE: I believe in this goal and effort with all my heart. I believe that our future as a nation depends upon whether or not we can break down these barriers that have been used to pit group against group, and bring our people together. How do you do it? Well, you establish respect for differences. You don't ignore differences. It's all too easy for somebody in the majority in the population to say oh, we're just all the same, without an understanding of the different life experience that you've had, that others have had. Once you have that understanding and mutual respect, then we can transcend the differences and embrace the highest common denominator of the American spirit. I don't know what affirmative access means. I do know what affirmative action means. I know the governor is against it, and I know that I'm for it. I know what a hate crime statute pending at the national level is all about in the aftermath of James Byrd's death. I'm for that proposed law, the governor is against it. I know what it means to have a commitment to diversity. I am part of an administration that has the finest record on diversity. And incidentally, an excellent -- I mean, I think our success over the last eight years has not been in spite of diversity but because of it. Because we're able to draw on the wisdom and experience from different parts of the society that hadn't been tapped in the same way before. And incidentally, Mel Carnahan in Missouri had the finest record on diversity in any governor in the entire history of the State of Missouri. And I want to honor that among his other achievements here. Now, I just believe that what we have to do is enforce the civil rights laws. I'm against quotas. This is, with all due respect, Governor, that's a red herring. Affirmative action isn't quotas. I'm against quotas, they're illegal. They're against the American way. Affirmative action means that you take extra steps to acknowledge the history of discrimination and injustice and prejudice and bring all people into the American dream because it helps everybody, not just those who are directly benefitting. MODERATOR: Governor, what is your -- are you opposed to affirmative action? BUSH: If affirmative action means quotas, I'm against it. If affirmative action means what I just described what I'm for, then I'm for it. You heard what I was for. The vice president keeps saying I'm against things. You heard what I was for, and that's what I support. MODERATOR: What about -- Mr. Vice President, you heard what he said. GORE: He said if affirmative action means quotas, he's against it. Affirmative action doesn't mean quotas. Are you for it without quotas? BUSH: I may not be for your version, Mr. Vice President, but I'm for what I just described to the lady. GORE: Are you for what the Supreme Court says is a constitutional way of having affirmative action? MODERATOR: Let's go on to another -- GORE: I think that speaks for itself. BUSH: No, it doesn't speak for itself, Mr. Vice President, it speaks for the fact that there are certain rules in this that we all agree to, but evidently rules don't mean anything. MODERATOR: The question is for you, Vice President Gore, and Lisa Kee will ask it. Lisa Kee, where are you? There we go, sorry. MEMBER OF AUDIENCE: How will your tax proposals affect me as a middle-class, 34-year-old single person with no dependents? GORE: If you make less than $60,000 a year and you decide to invest $1,000 in a savings account, you'll get a tax credit, which means in essence that the federal government will match your $1,000 with another $1,000. If you make less than $30,000 a year and you put $500 in a savings account, the federal government will match it with $1500. If you make more than $60,000 and up to 100 you'll still get a match, but not as generous. You'll get an access to life-long learning and education, help with tuition if you want to get a new skill or training. If you want to purchase health insurance, you will get help with that. If you want to participate in some of the dynamic changes that are going on in our country, you will get specific help in doing that. If you are part of the -- of the bottom 20% or so of wage earners, then you will get an expanded earned income tax credit. Now, the tax relief that I propose is directed specifically at middle-income individuals and families. And if you have a -- if you have an elderly parent or grandparent who needs long-term care, then you will get help with that. $3,000 tax credit to help your expenses in taking care of a loved one who needs long-term care. MODERATOR: Governor Bush? BUSH: Let me just say the first -- this business about the entitlement he tried to describe about savings, you know, matching savings here and matching savings there, fully-funded it's gonna cost a whole lot of money, a lot more than we have. You're going to get a tax refund in my plan. You're not going to be targeted in or targeted out. Everybody that pays taxes is going to get tax relief. If you take care of an elderly in your home, you're going to get the personal exemption increased. I think also what you need to think about is not the immediate, but what about Medicare? You get a plan that will include prescription drugs, a plan that will give you options. Now, I hope people understand that Medicare today is important, but it doesn't keep up with the new medicines. If you're a Medicare person, on Medicare, you don't get the new procedures. You're stuck in a time warp in many ways. So it will be a modern Medicare system that trusts you to make a variety of options for you. You're going to live in a peaceful world. It will be a world of peace because we're going to have a clear sight of foreign policy based upon a strong military and a mission that stands by our friends. A mission that doesn't try to be all things to all people. A judicious use of the military which will help keep the peace. You'll live in a world, hopefully, that is more educated so it's less likely you'll be harmed in your neighborhood. See, an educated child is one much more likely to be hopeful and optimistic. You'll be in a world in which fits into my philosophy. The harder you work, the more you can keep. It's the American way. Government shouldn't be a heavy hand. It's what the federal government does to you. It should be a helping hand, and tax relief and the proposals I just described should be a good helping hand. MODERATOR: Governor, next question is for you, and Leo Anderson will ask it. Mr. Anderson. You want a mike? MEMBER OF AUDIENCE: In one of the last debates held, the subject of capital punishment came up, and in your response to the question, you seemed overly joyed and as a matter of fact proud that Texas led the nation in the execution of prisoners. Sir, did I misread your response and are you really, really proud of the fact that Texas is number one in executions? BUSH: No, I'm not proud of that. The death penalty is a very serious business, Leo. It's an issue that good people obviously disagree on. I take my job seriously. And if you think I was proud of it, I think you misread me, I do. I was sworn to uphold the laws of my state. During the course of the campaign in 1994 I was asked do you support the death penalty. I said I did if administered fairly and justly. Because I believe it saves lives, Leo, I do. If it's administered swiftly, justly and fairly, it saves lives. One of the things that happens when you're a governor, at least oftentimes you have to make tough decisions. You can't let public persuasion sway you, because the job is to enforce the law. And that's what I did, sir. There have been some tough cases come across my desk. Some of the hardest moments since I've been the governor of the State of Texas is to deal with those cases. But my job is to ask two questions, sir. Is the person guilty of the crime? And did the person have full access to the courts of law? And I can tell you looking at you right now, in all cases those answers were affirmative. I'm not proud of any record. I'm proud of the fact that violent crime is down in the State of Texas. I'm proud of the fact that we hold people accountable. But I'm not proud of any record, sir, I'm not. MODERATOR: Vice President Gore? GORE: I support the death penalty. I think that it has to be administered not only fairly with attention to things like DNA evidence, which I think should be used in all capital cases, but also with very careful attention. If, for example, somebody confesses to the crime and somebody is waiting on death row, there has to be alertness to say wait a minute, have we got the wrong guy? If the wrong guy is put to death, then that's a double tragedy. Not only has an innocent person been executed, but the real perpetrator of the crime has not been held accountable for it. And in some cases may be still at large. But I support the death penalty in the most heinous cases. MODERATOR: Do both of you believe the death penalty actually deters crime? Governor? BUSH: I do. It's the only reason to be for it. Let me finish, sir. I don't think you should support the death penalty to seek revenge. I don't think that's right. I think the reason to support the death penalty is because it saves other people's lives. GORE: I think it is a deterrent. I know that's a controversial view, but I do believe it's a deterrent. MODERATOR: Next question is for you, Vice President Gore, and Thomas Fischer will ask it. Mr. Fischer? MEMBER OF AUDIENCE: Yes. My 6th grade class at St. Claire's School wanted to ask of all these promises you guys are making and all the pledges, will you keep them when you're in office? (LAUGHTER) GORE: Yes. (LAUGHTER) I am a person who keeps promises. And, you know, we've heard a lot about -- from the governor about not much being done in the last eight years, as if the promises that I made eight years ago have not been kept. I think the record shows otherwise. We have gone from the biggest deficits eight years ago to the biggest surpluses in history today. Instead of high unemployment, we now have the lowest African-American unemployment, the lowest Latino unemployment ever measured. 22 million new jobs, very low unemployment nationally. Instead of ballooning the debt and multiplying it four times over, we have seen the debt actually begun to be paid down. Here are some promises that I'll make to you now. I will balance the budget every year. I will pay down the debt every year. I will give middle-class Americans tax cuts, meaningful ones. And I will invest in education, health care, protecting the environment and retirement security. We both made promises in this campaign. I promise you I will keep mine. Let me tell you about one of the governor's. He has promised a trillion dollars out of the Social Security Trust Fund for young working adults to invest and save on their own. But he's promised seniors that their Social Security benefits will not be cut, and he's promised the same trillion dollars to them. So this is a show me state. Reminds me of the line from the movie, "Show me the money." Which one of those promises will be keep and which will you break, Governor? MODERATOR: Governor Bush. BUSH: Thank you for your question. (LAUGHTER) I -- there's an old high school debating trick, which is to answer something and then attack your opponent at the end. You asked about promises. You were promised that Medicare would be reformed, and that Social Security would be reformed. You were promised a middle-class tax cut in 1992. It didn't happen. There's too much bitterness in Washington. There's too much wrangling. It's time to have a fresh start. One of the reasons I was successful as the governor of Texas is because I didn't try to be all things to all people. When I campaigned in a race, a lot of folks didn't think I could win including, by the way, my mother. (LAUGHTER) I said I'd do four things; tort reform, education reform, welfare reform and juvenile justice reform. And I won. And I had the will of the people in my state behind me. And then I brought folks together to get it done. And that's what we need, I think, in this election. To me that's what it's all about. I'm sure your 6th grade kids are listening and saying, these guys will say anything to get elected. But there's a record, and that's what I hope people look at. One of my promises is going to be Social Security reform, and you bet, we need to take a trillion dollars out of that $2.4 trillion surplus. Now remember, Social Security revenue exceeds expenses up until 2015. People are going to get paid. But if you're a younger worker, if you're younger, you better hope this country thinks differently, otherwise you're gonna be faced with huge payroll taxes or reduced benefits. And you bet we're gonna take a trillion dollars of your own money and let you invest it under safe guidelines so you get a better rate of return on the money than the paltry 2% that the federal government gets for you today. That's one of my promises. But it's gonna require people to bring both Republicans and Democrats together to get it done. That's what it requires. There was a chance to get this done. It was a bipartisan approach, but it's been rejected. I'm going to bring them together. MODERATOR: Both of you -- both of you on this subject. There are other questions that also go to this skepticism, not necessarily about you, but all people in politics. Why is that? GORE: Well, first of all, Jim, I would like to respond to what the governor just said. Because the trillion dollars that has been promised to young people has also been promised to older people. And you cannot keep both promises. If you're in your mid-40's under the governor's plan, Social Security will be bankrupt by the time you retire, if he takes it out of the Social Security Trust Fund. Under my plan it will be -- its solvency will be extended until you're 100. Now that is the difference. And the governor may not want to answer that question, he may want to call it a high school debating trick, but let me tell you this. This election is not about debating tricks, it is about your future. The reason Social Security -- he says it gets 2%. You know, it's not a bank account that just pays back money that's invested. It is also used to give your mothers and fathers the Social Security checks that they live on. If you take a trillion dollars out of that Social Security Trust Fund, how are the checks going to be -- how are you going to keep faith with the seniors? Now let me come directly to your question. MODERATOR: We have to go to the closing statements and -- BUSH: Well, can I answer that? One reason people are skeptical is because people don't answer the questions they've been asked. The trillion dollars comes out of the surplus so that you can invest some of your own money. There's just a difference of opinion. I want workers to have their own assets. It's who you trust, government or people. MODERATOR: All right. Now we're going to go to closing statements. Vice President Gore, you're first. GORE: Thank you very much, Jim, and I'll begin by answering your questions -- your last question. I believe that a lot of people are skeptical about people in politics today because we have seen a time of great challenge for our country. Since the assassination of our best leaders in the '60's, since the Vietnam War, since Watergate, and because we need campaign finance reform. I would like to tell you something about me. I keep my word. I have kept the faith. I've kept the faith with my country. I volunteered for the Army. I served in Vietnam. I kept the faith with my family. Tipper and I have been married for 30 years. We have devoted ourselves to our children and now our nearly one-and-a-half-year-old grandson. I have kept the faith with our country. Nine times I have raised my hand to take an oath to the Constitution, and I have never violated that oath. I have not spent the last quarter century in pursuit of personal wealth. I have spent the last quarter century fighting for middle-class working men and women in the United States of America. I believe very deeply that you have to be willing to stand up and fight no matter what powerful forces might be on the other side. If you want somebody who is willing to fight for you, I am asking for your support and your vote and, yes, your confidence and your willingness to believe that we can do the right thing in America, and be the better for it. We've made some progress during the last eight years. We have seen the strongest economy in the history of the United States. Lower crime rates for eight years in a row. Highest private home ownership ever, but I'll make you one promise here. You ain't seen nothing yet. And I will keep that promise. MODERATOR: Governor Bush, two minutes. BUSH: Well, Jim, I want to thank you and thank the folks here at Washington University and the vice president. Appreciate the chance to have a good, honest dialogue about our differences of opinion. I think after three debates the good people of this country understand there is a difference of opinion. There is a difference between big federal government and somebody who is coming from outside of Washington who will trust individuals. I've got an agenda that I want to get done for the country. It's an agenda that says we're going to reform Medicare to make sure seniors have got prescription drugs and to give seniors different options from which they can choose. It's an agenda that says we're listen to the young voices in Social Security and say we're going to think differently about making sure we have a system, but also fulfill the promise to the seniors in America. A promise made will be a promise kept should I be fortunate enough to become your president. I want to have the military keeping the peace. I want to make sure the public school system in America keeps its promise so not one child is left behind. After setting priorities, I want to give some of your money back. I don't think the surplus is the government's money. I think it's the people's money. I don't think it exists because of the ingenuity and hard work of the federal government, I think in exists because of the ingenuity and hard work of the American people. And you ought to have some of this surplus so you can save and dream and build. I look forward to the final weeks of this campaign. I'm asking for your vote. For those of you for me, thanks for your help. For those of you for my opponent, please only vote once. (LAUGHTER) But for those who have not made up their mind, I would like to conclude by this promise. Should I be fortunate enough to become your president, when I put my hand on the Bible, I will swear to not only uphold the laws of the land, but I will also swear to uphold the honor and the dignity of the office to which I have been elected, so help me God. Thank you very much. MODERATOR: A closing piece of business before we go. The Debate Commission wants reaction to the three kinds of formats used in the debates this year, and you may register an opinion at their website at www.debates.org. Vice President Gore, Governor Bush, thank you. And good night from Washington University in St. Louis. (APPLAUSE)
