# Presidential Debate in San Diego

**Date:** October 16, 1996
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-san-diego

---

Jim Lehrer. Good evening from the Shiley Theatre at the University of San Diego, San Diego, California. I'm Jim Lehrer of the "NewsHour" on PBS. Welcome to this second 1996 Presidential debate between Senator Bob Dole, the Republican nominee, and President Bill Clinton, the Democratic nominee. It is sponsored by the Commission on Presidential Debates. We will follow a townhall-type format tonight. The questions over the next 90 minutes will come from 113 citizens of the greater San Diego area. They were chosen in the past week by the Gallup organization to represent a rough cross-section of voters as to political views, age, gender, and other factors. Each said he or she is undecided about this Presidential race. They were told to come tonight with questions. Nobody from the Debate Commission or the two campaigns has any idea what those questions are; neither do I. We will all be hearing them for the first time at the same time. I met with this group 3 hours ago, and we spoke only about how it was going to work tonight. They are sitting in five sections. I will call on individuals at random, moving from one section to another with each new question, alternating the questions between the two candidates. My job is to keep things fair and the subjects as clear and as varied as possible. The rules, drawn by the campaigns, are basically the same as they were for the Hartford and St. Petersburg debates: 90-second answers, 60-second rebuttals, 30-second responses for each question. The candidates are not allowed to question each other directly. There will be 2-minute opening and closing statements. The order for this evening was set by coin toss. We begin now with Senator Dole and his opening statement. Senator Dole. Opening Statements Senator Bob Dole. Thank you very much, Jim. Let me first give you a sports update: the Braves, one; Cardinals, nothing—early on. I want to thank you and I want to thank everybody here tonight, and I want a special thanks to my wife, Elizabeth, and my daughter, Robin, for their love and support, and thank the people who are listening and watching all over America. In 20 days, you will help decide who will lead this country into the next century. It's an awesome responsibility. And you must ask yourself, do you know enough about the candidates? You should know as much as possible about each of us. Sometimes the views have been distorted—and millions and millions of dollars in negative advertising spent distorting my views— but I hope tonight you'll get a better feel of who Bob Dole is and what he's all about. And I think first you should—I should understand that the question on your mind is, do I understand your problem? But I understand it if—it occurred to me and I might just say that I'm from a large family. I've got lots of relatives, and they're good, average, middle class, hard-working Americans. They live all across the country. They're not all Republicans—maybe all but one. [Laughter] But in any event, I understand the problems, whether it's two parents working because one has to pay the taxes and one has to provide for the family; whether it's a single parent who just barely pays the pressing bills; or whether you're worried about an education for your children—are they going to the best schools; or whether you're worried about safe playgrounds, drug-free schools, crime-free schools. This is what this election is all about. And hopefully tonight when we conclude this debate, you will have a better understanding and the viewing and listening audience will have a better understanding. Thank you. [Applause] Mr. Lehrer. Mr. President, 2 minutes, opening statement. The President. I was going to applaud, too. [Laughter] Well, thank you, Jim, and thanks to the people of San Diego for giving us this opportunity to have another discussion about the decision we all face in front of people who will make the decision. Again I will say, I'll do my best to make this a discussion of ideas and issues, not insults. What really matters is what happens to your future and what happens to our country as we stand on the brink of a new century, a time of extraordinary possibility. I have a simple philosophy that I've tried to follow for the last 4 years: Do what creates opportunity for all, what reinforces responsibility from all of us, and what will help us build a community where everybody's got a role to play and a place at the table. Compared to 4 years ago, we're clearly better off. We've got 10 1/2 million more jobs; the deficit's been reduced by 60 percent; incomes are rising for the first time in a decade; the crime rates, the welfare rolls are falling; we're putting 100,000 more police on the street; 60,000 felons, fugitives, and stalkers have been denied handguns. But that progress is only the beginning. What we really should focus on tonight is what we still have to do to help the American people make the most of this future that's out there. I think what really matters is what we can do to help build strong families. Strong families need a strong economy. To me, that means we have to go on and balance this budget while we protect Medicare and Medicaid and education and the environment. We should give a tax cut targeted to childrearing and education, to buying a first home and paying for health care. We ought to help protect our kids from drugs and guns and gangs and tobacco. We ought to help move a million people from welfare to work. And we ought to create the finest education system in the world, where every 18-year-old can go on to college and all of our younger children have great educational opportunities. If we do those things, we can build that bridge to the 21st century. That's what I hope to get to talk about tonight. Thank you. Mr. Lehrer. All right, let's go now to the first question from this section, and it's for Senator Dole. Yes, ma'am? Yes? Q. Hello, Senator Dole. Senator Dole. Hi. Leadership To Promote Unity Q. My name is Shannon MacAfee. I'm a beginning educator in this country, and I really think it's important what children have to say. They're still very idealistic, and everything they say comes from the heart. I have a quote for you from "If I Were President," compiled by Peggy Gavin. A sixth grader says, "If I were President, I would think about Abraham Lincoln and George Washington and what they did to make our country great. We should unite the white and black people and people of all cultures. Democrats and Republicans should unite also. We should all come together and think of the best ways to solve the economic problems of our country. I believe that when we are able to come together and stop fighting amongst ourselves, we will get along a lot better." These are the ideals and morals that we are trying to teach our children in these days, yet we don't seem to be practicing them in our Government, in anything. If you are President, how will you begin to practice what we are preaching to our children, the future of our Nation? Senator Dole. Well, I would say, first of all, I think it's a very good question, and I appreciate the quote from the young man. There's no doubt about it that many American people have lost their faith in government. They see scandals almost on a daily basis. They see ethical problems in the White House today. They see 900 FBI files of private persons being gathered up by somebody in the White House; nobody knows who hired this man. So there's a great deal of cynicism out there. But I've always tried, in whatever I've done, to bring people together. I said in my acceptance speech in San Diego about 2 months ago that the exits are clearly marked. If you think the Republican Party is someplace for you to come if you're narrow-minded or bigoted or don't like certain people in America, the exits are clearly marked for you to walk out of, as I stand here without compromise because this is the party of Lincoln. I think we have a real obligation, obviously, public officials. I'm no longer a public official; I left public life on June 11th of this year. But it is very important. Young people are looking to us. They're looking to us for leadership. They're watching what we do, what we say, what we promise, and what we finally deliver. And I would think—it seems to me that there are opportunities here. When I'm President of the United States, I will keep my word. My word is my bond. Mr. Lehrer. Mr. President? The President. One of the reasons that I ran for President, Sandy, is because not just children, a lot of grownups felt that way. If you remember, 4 years ago we had not only rising unemployment but a lot of rising cynicism. I'd never worked in Washington as an elected official. It seemed to me that most of the arguments were partisan: Republican, Democrat; left, right; liberal, conservative. That's why I said tonight I'm for opportunity, responsibility, and community. And we've gotten some real progress in the last 4 years. I've also done everything I could at every moment of division in this country—after Oklahoma City, when these churches were burned—to bring people together and remind people that we are stronger because of our diversity. We have to respect one another. You mentioned Washington and Lincoln; they were Presidents at historic times. This is an historic time. It's important that we go beyond those old partisan arguments and focus on people and their future. When we do that, instead of shutting the Government down over a partisan fight on the budget, we're a better country, and that's why we're making progress now. Mr. Lehrer. Senator? Senator Dole. Well, bringing people together again is obviously a responsibility we all have. I know you do it. Everybody here does it. You do a lot of things nobody knows about. I have a little foundation for the disabled called the Dole Foundation. We've raised about $10 million. We don't talk about it. We try to help people with disabilities. We bring them back into the mainstream of public life. So it seems to me that there's also a public trust. When you're the President of the United States, you have a public trust, and you have to keep that public trust, as George Washington did and as Abraham Lincoln did. And I think now that trust is being violated. And it seems to me we ought to face up to it, and the President ought to say tonight that he's not going to pardon anybody that he was involved in business with who might implicate him later on. Mr. Lehrer. All right, the next question from this section right here. Right there in the middle, sir. Yes, sir? Health Care Q. Dr. Robert Berkeley; I'm a cardiologist from Fallbrook, California. Mr. President, I'd like to know if you'd please explain your plans for—in a substantive fashion, for addressing the problems with the health care system in our country. The President. I will. First of all, let me say what we have done: In the last 4 years, we've worked hard to promote more competition to bring down the rate of inflation in health care costs without eroding health care quality. The Government pays for Medicare and Medicaid, as you know, and that's very important. Secondly, we've added a million more children to the ranks of the insured through the Medicaid program. We have protected 25 million people through the passage of the Kennedy-Kassebaum bill that says you can't lose your health insurance if you change jobs or if someone in your family's been sick. We just recently ended those drive-by deliveries, saying people couldn't be kicked out of the hospital by insurance companies when they'd just had babies. So this is—that's a good start. In the next 4 years, I want to focus on the following things: Number one, add another million children to the insured ranks through the Medicaid program; number two, keep working with the States, as we are now, to add 2.2 million more people to the insurance system; number three, cover people who are between jobs for up to 6 months—that could protect 3 million families, 700,000 kids; and number four, make sure we protect the integrity of the Medicare program and the Medicaid program and not do anything in cutting costs which would cause hundreds of hospitals to close, as could have been the case if the $270 billion Medicare cut that I vetoed had been enacted into law. Senator Dole. First, let me say there you go again, Mr. President, talking about a Medicare cut. Now, I've heard you say this time after time, and I've heard you say on one TV appearance, "The media made me do it." You were trying to defend your cut, which was not a cut either—a reduction in the growth of spending. And we always had at least 7 percent. You've said publicly that it's now 3 times the rate of inflation, we ought to cut the growth to twice the rate of inflation. That's about where we are now. So let's stop talking about cutting Medicare. In my economic plan we increase it 39 percent. Don't forget what he tried to do with health care: 17 new taxes, spend $1.5 trillion, 50 new bureaucracies. Can you believe that? You couldn't even have been a cardiologist because they had quotas. You had—you couldn't—you're a cardiologist; it wouldn't affect you. But if somebody wanted to be a cardiologist 10 years from now, you'd have to be certain that you complied with some of the rules in this extreme medical plan the Government was going to take over for all Americans. There are things we can do like the Kassebaum bill, that retains many provisions I authored, to cover preexisting—existing—portability. And there are other things we can do. We still need to cover about 20 million people and a lot of children. The President. I don't have time in 30 seconds to respond to fix all that. But let me just say, the American Hospital Association said that the budget I vetoed could have closed 700 hospitals, not me. And on a per-person basis, it did cut way below the rate of inflation in medical costs. But the important thing is, what are we going to do now? We need to help people who are between jobs. We need to cover more kids. We need to provide more preventive care. My balanced budget covers mammograms for ladies on—women on Medicare and also gives respite care to the million-plus families who have someone with Alzheimer's. These things are paid for in the balanced budget plan. It will move us forward. Mr. Lehrer. The next question is for Senator Dole from here. Yes, sir? Armed Forces Q. Senator Dole, my name is Jason Milligan, active-duty military and a small-business owner. And my question is, what is your position on closing the gap between military and civilian pay scales? Senator Dole. Jason, I appreciate that very much, being a former military man myself. You know, we have 17,000 men and women today wearing our uniform that receive food stamps. It shouldn't happen in America. We have men and women wearing our uniform in substandard housing. It shouldn't happen in America. And it's time we take a look at the pay scales. You did get a 3 percent increase this year, but that's not enough. If we're going to ask young men and young women to protect us and defend us around the world, and we've had more deployments under this administration than any time in history— 50 times we deployed troops around the world. Every time you do that, you take a risk—somebody you know, maybe your son, maybe your grandson, maybe somebody else. But I think anybody who wears a uniform is a great American. Remember Vietnam, remember when people almost used to walk across the street rather than have contact with somebody who was in Vietnam—that's all behind us now, and it should be behind us—and the forgotten war, the Korean war. But I guess, I can just answer you very plainly, Jason: Thank you for doing what you're doing. America owes you a debt of gratitude. The President. May I ask you a question? What kind of—which service are you in? Q. I'm in the United States Navy, sir. The President. And what kind of small business do you have? Q. I have an Amway business. The President. Good for you. Well, let me say—Senator Dole mentioned this. I just signed a bill that we got through Congress to increase the amount of pay increase we could give for military personnel and to make sure the pay increase this year was above the rate of inflation. I also had presented to the Congress, and they adopted, a large package of quality-of-life improvements which are very important. I've spent a lot of time talking to military families, as well as military members, all over the world and in bases all across the United States. And I became convinced, after talking to the families and the personnel in uniform, that we needed to not only have the pay raise but we needed to invest more in child care, housing, and other things to support families, especially when there are longer deployments because of the downsizing of the military. So we're going to do better, and we'll do better still. But this is a commitment I think that all Americans share, without regard to party. Mr. Lehrer. Senator Dole? Senator Dole. Well, Jason, I don't disagree with anything the President said except he waited 4 years to do these things. And my view is it ought to be—it'll be done on day one. We'll start working on it on day one in the Dole-Kemp administration. This is important. Now, we only have 10 divisions now; we used to have 18. We had 25 fighter wings; we're down to 13. We had 536 ships; we're down to 336 ships. I mean, we've cut defense spending too much in the first place. The President told you in '92 he would cut it $67 billion; he cut $112 billion. So we're right on the edge right now. But the last thing we ought to do is make those who wear the uniform sacrifice. Mr. Lehrer. Next question here for President Clinton. Yes, ma'am, here on the front row. Middle East Peace Process Q. President Clinton, my name is Cecily Kelly. Yesterday Yasser Arafat said in Palestine that he thinks the key to success in the Middle East is the commitment of Americans. Would you, as President, send American troops to Israel or the West Bank as peacekeepers? The President. Let me just take 2 seconds of my time, because I'm the Commander in Chief, to respond to one thing that was said. I propose to spend $1.6 trillion on defense between now and the year 2002. And there's less than one percent difference between my budget and the Republican budget on defense. Now, on the Middle East, as you know, I've worked very hard for peace in the Middle East. The agreement between the Palestinians and the Israelis was signed at the White House. And the agreement, the peace treaty with Jordan, I went to Jordan to sign that, to be there. But— and I think the United States could do whatever we reasonably can. I can say this: I do not believe Yasser Arafat wants us to send troops to the West Bank. We have never been asked to send troops to the West Bank. I saw the agreement that Prime Minister Rabin and Yasser Arafat signed on the West Bank. It had 26 separate maps they had to sign, literally thousands of delineations of who would do what on the West Bank. And I believe if the parties will get together and in a good faith manner make that agreement, that they'll be able to do it. We cannot impose a peace on the Middle East. My position has always been that the job of the United States was to minimize the risks of peace. You know, if they ask me to be part of some monitoring force—as we are in the Sinai and have been since 1978 to monitor the peace between Egypt and Israel—frankly, I would have to think about it; I would have to see what they wanted to do. But I don't believe that will be the request. I think what Mr. Arafat wants us to do is to make sure that everybody honors the agreements they've already made. That's why I brought the leaders to Washington a few days ago. I think they will, and I think we'll get there. Don't be too discouraged. Senator Dole. Well, let me, Jason, come back to you a minute because there is a big difference in the defense budget. We had $7 billion this year, and $10 billion more than the President. He puts his money in the out years— even if he were reelected, you know, he'd be gone before anything happened. And nothing's going to happen, because we don't have modernization now. If we don't build more B-2 bombers in California—and we lost about 500,000 jobs out in California because of this devastation, these big, big cuts. We had to make cuts; we didn't have to make the cuts the President promised he'd make and then he doubled. And so I think we need to go back and take a look. We're increasing defense reasonably, not too much but we are increasing defense some, because we want to be prepared in case somebody here gets called up, Jason. I would say I didn't hear what Yasser Arafat had to say, but I don't want to—you know, I think foreign policy is something we want to be very careful about. And I'm not here to argue about the President on some ongoing foreign policy matter. What I want the President to do, and I think he may have done it in his last statement, is call for an unconditional end to the violence and have the parties keep on talking as they should talk and have a resolution. The last thing we want to do is commit more forces anywhere. But let's sort of keep this out of politics, because it's pretty dicey right now. The President. When the change of government occurred in Israel, the people of Israel were saying, "We don't want to abandon the peace process. We want more security." Then, a lot of mutual distrust developed. A lot of things happened which maybe shouldn't have happened. When I asked Yasser Arafat and Prime Minister Netanyahu to come to Washington and got them together and they talked alone for 3 hours, I was convinced that they had to have a chance to make that peace. Again, I'd say if they ask us to play some reasonable role, I don't know how I would respond. It would depend entirely on what they ask us to do. But the real secret there is for them to abide by the agreements they've made and find a way to trust each other. And they're going to have to spend some time and trust each other. Prime Minister Rabin gave his life believing that that trust could be materialized, and I still think it can be. Mr. Lehrer. All right, next question from this section, and it is for Senator Dole. Back in the back. Yes, sir, right there. Yes, sir. Tobacco Q. Senator Dole, Oscar Delgado. Senator Dole. Oscar. Q. Ex-smoker for 30 years. About 30 years ago I was a pack-plus-a-day man, okay? You mentioned in a statement, you said some time ago that you didn't think nicotine was addictive. Would you care to—you still hold to that statement, or do you wish to recant or explain yourself? Senator Dole. Oh, that—that's very easy. My record going back to 1965 in the Congress, the first vote we had was whether or not you should put a little notice on cigarettes that they may be dangerous—I voted—I voted for everything since that time. In fact, in 1992 we had a bill come before us that all the States had to comply or they're going to lose certain money. We sent it to the Clinton administration for implementation. They waited 3 1/2 years. And during that period about 3,000 young kids every day started smoking. If you add it up, that's about 3 million—not until again 1996. I don't want anybody to smoke. My brother probably died partly because of cigarettes. I was asked a technical question: Are they addictive? Maybe they—they probably are addictive. I don't know; I'm not a doctor. You shouldn't smoke. You ought to be glad you quit, Oscar— 30 years? Q. Yes. Senator Dole. And it seems to me that what we need to do is to talk about not only tobacco but drugs, because drug use in 12- and 17year-olds has doubled in this administration, the last 44 months. Marijuana use is up 141 percent; cocaine use, up 160 percent. They're your kids. It's all happened in this administration because they cut funding and they cut interdiction. When I'm President of the United States, we're going to use the National Guard and whatever resources we need to stop some of the drugs coming into America. If you stop the drugs, nobody is going to use the drugs. So don't smoke, don't drink, don't use drugs. Just don't do it. The President. Oscar, the question of what the Federal Government should do to limit the access of tobacco to young people is one of the biggest differences between Senator Dole and me. We did propose a regulation 6 months after I became President under the law he mentioned. It simply says all these States—it made it illegal for kids to smoke—now they have to try harder if they want to keep getting Federal funds. Then we took comments, as we always do, and there were tens of thousands of comments about how we ought to do it. That's what drug it out. Meanwhile, we started, also in '93, to look into whether cigarettes were addictive enough for the Federal Food and Drug Administration to ban the ability of cigarette companies to advertise, market, and distribute tobacco products to our kids. No President had ever taken on the tobacco lobby before. I did. Senator Dole opposed me. He went down and made a speech to people who were on his side, saying that I did the wrong thing. I think I did the right thing. On drugs, I have repeatedly said drugs are wrong and illegal and can kill you. We have strengthened enforcement, and everybody in San Diego knows we've strengthened control of the border. We've done a lot more; I hope we get a chance to talk about it. Senator Dole. Well, they also know, if they live in San Diego, Mr. President, if you're caught with 125 pounds of marijuana or less, you go back to Mexico; you're not prosecuted. You have a U.S. Attorney here that sends them back home. So I think that's pretty important. That's a lot of marijuana. That's a big supply. But don't—you know, don't get into this smokescreen here, Oscar. The President, in the election year, decided, "Well, I ought to do something. I haven't done anything on drugs. I've been AWOL for 44 months. So let's take on smoking." But see, they haven't even done it. They haven't said what's going to happen, whether they're going to have it declared addictive; it's going to apply just to—once it's a drug, does it apply only to teenagers or to everybody in America? Nobody should smoke, young or old. But particularly, young people should not smoke. And my record is there. It's been there. I've voted 8, 10 times since 1965. Mr. Lehrer. The next question is for President Clinton, and it comes from right here. Yes, sir? Social Security and Medicare Q. President Clinton, my name is Jack Fleck. I'm a retired Air Force pilot. Sir, it's officially forecast that our annual Medicare and Social Security deficits are measured in the trillions of dollars next century. Depending upon who you listen to, Social Security will be bankrupt in either 2025 or 2030. I feel this is grossly unfair, especially to our younger generations, who are losing faith in the system. My question is this: Assuming you agree that our entitlement programs are on an unsustainable course, what specific reforms do you propose? The President. First of all, they're two different things. Social Security and Medicare are entirely different in terms of the financial stabilities. Let's talk about them separately. Social Security is stable until, as you pointed out, at least the third decade of the next century. But we'd like to have a Social Security fund that has about 70 years of life instead of about 30 years of life. What we have to do is simply to make some adjustments that take account of the fact that the baby boomers, people like me, are bigger in number than the people that went just before us and the people that come just after us. And I think what we'll plainly do is what we did in 1983, when Senator Dole served—and this is something I think he did a good job on— when he served on the Social Security Commission and they made some modest changes in Social Security to make sure that it would be alive and well into the 21st century. And we will do that. It's obvious that there are certain things that have to be done, and there are 50 to 60 different options. And a bipartisan commission, to take it out of politics, will make recommendations and build support for the people. Medicare is different. Medicare needs help now. I have proposed a budget which would put 10 years on the life of the Medicare Trust Fund; that's more than it's had a lot of the time for the last 20 years. It would save a lot of money through more managed care but giving more options, more preventive care, and lowering the inflation rate in the prices we're paying providers without having the kind of big premium increases and outof-pocket costs that the budget I vetoed would provide. Then that will give us 10 years to do with Medicare what we're going to do with Social Security: have a bipartisan group look at what we have to do to save it when the baby boomers retire. But now we ought to pass this budget now and put 10 years on it right away so no one has to worry about it. Senator Dole. Well, again, you know, if you're somebody thinking about the future, I think it's fair to say that it'll be—we'll work it out. I mean, this is a political year, and the President's playing politics with Medicare. But after this year's over we'll resolve it just as we did with Social Security in 1983. It was a nonpartisan commission. Ronald Reagan got together with Tip O'Neill and Howard Baker—two Republicans and one Democrat—and they formed a commission. I was on that commission. We resolved—we rescued Social Security. We suggested—I think it's been over a year ago now— we do the same with Medicare, and the White House called it a gimmick. Now last week, I guess it was, Donna Shalala said, "Well, we'll cut Medicare a hundred billion, and we'll appoint a commission." It will probably have to be done by a commission. Take it out of politics. I think if I were a senior citizen I'd be a little fed up with all these ads scaring seniors, scaring veterans, and scaring students about education. But when you don't have any ideas, when you don't have any agenda, and all you have is fear, that's all you can use. We have ideas in the Dole-Kemp campaign, and we'll rescue Medicare as we did Social Security. The President. Their idea was to have the poorest seniors in the country pay $270 more a year this year. Their idea was to budget— that the American Hospital Association said could close 700 hospitals. Their idea was to charge everybody more out-of-pocket costs in their budget that I vetoed—not in an election year, sir, I told them in early '95. Senator Dole said 30 years ago he was one of 12 people that voted against Medicare and he was proud of it. A year ago he said, "I was right then; I knew it wouldn't work." American seniors have the highest life expectancy in the world. We need to reform it, not wreck it. Mr. Lehrer. Next question from here, and it's for Senator Dole. Yes, ma'am, right here. Q. Me? Mr. Lehrer. Yes. Welfare Reform Q. Senator Dole, my name is Suzanne Gonzalez, and I would like to know what you are— what would be your first step in reforming welfare. Senator Dole. Well, we've taken the first step. We took it three steps. Twice we sent welfare reform to the President, and he vetoed it. On the third time we sent welfare reform to the President, he signed it but announced he would change it next year. And the Vice President said they were going to do something else through the line item veto, which I've never understood, but that's sort of inside baseball. What we need to do is make certain we try to return people to work. And I'm standing here as someone who a long time ago—as the county attorney in Russell, Kansas, one of our jobs every month was to go through all the welfare checks and sign them. And three of those checks were my grandparents'. So I know what it's like to have to look welfare head-on. Obviously some people are going to need help. This is the United States of America. You're not going to go without food, and you're not going to go without medical care. This is America. But at the same time, if you want to get off Medicare, get back in the mainstream, we're going to provide jobs. We're going to say you have a 5-year limit that you can be on welfare. You've got 2 years to look for a job. We provided more money for day care in the bill that passed the Senate and was vetoed. Then it came back, and the President signed pretty much the same bill. But this is an important issue. I don't think we ought to be giving welfare payments to illegal immigrants. I mean, it puts a heavy burden on a State like—except for emergencies. It puts a heavy burden on States like California. It costs California taxpayers $3 billion a year. Mr. Lehrer. President Clinton? Senator Dole. I'll get out of your way here. The President. It's illegal right now and has been for years for illegal immigrants to get welfare benefits. Let me say that this is one of the most important issues in the world to me. I started working on welfare reform in 1980 because I was sick of seeing people trapped in a system that was increasingly physically isolating them and making their kids more vulnerable to get in trouble. So I'd been working on it when I was a Governor for a long time. When I became President, I used the authority I had in this law to get out from under certain Federal rules to help States move people to work. We've reduced the welfare rolls by 2 million already. Now I've got a plan with this new welfare reform law to work with the private sector to give employers specific tax incentives to hire people off welfare and to do some other things which will create more jobs in the private sector, at least a million, to move more people from welfare to work. It's very important. And I hope we get a chance to talk about this more. There is not a more important issue. I still remember a woman that I met 10 years ago who said she wanted to get off welfare so her kids could tell—give an answer when they say, "What does your mother do for a job?" I met that woman again. She's got four kids. One's got a good job; one's studying to be a doctor; one's in technical school; one's an honor student in high school. I want to make more people like that woman, Lillie Harden. So I've got a plan to do it. And it's just beginning. Senator Dole. Well, another thing we can do—we talk about growth—we've got a great economic package which I hope we'll discuss later: across the board tax cut; child credits, $500 per child under 18; reduce the capital gains rate; create more jobs and opportunities for people on and off welfare. And we have other provisions: less litigation. The trial lawyers—big supporters of the President—the trial lawyers, of course they like lawsuits, so every time they have a bill that they want vetoed, the President vetoes it for them. We've got to understand in America that we've got to have growth, create more jobs and more opportunities in the private sector. The President takes credit for all of these people off welfare—the Governors did that. Federal Government doesn't do that. And the Government doesn't create jobs, they're created in the private sector. Mr. Lehrer. This section, question? Yes, ma'am, on the back row. This is for the President. Capital Gains Tax Q. Mr. President, my name is Pamela Johnson, and I'm a landlord. My question is, does your party have any future plans to reduce the capital gains tax, especially for retired Americans? The President. First of all, we have a big plan to reduce the capital gains tax when people sell their homes. Part of my tax package, which is paid for in my balanced budget plan, would exempt up to half a million dollars in gains for people when they sell their home, which I think is the biggest capital gains benefit we could give to most ordinary Americans. We also have a capital gains now for people that invest in new small businesses and hold the investment for 5 years. It was part of our other economic plan. And these are things I think that will go a long way toward helping America build a stronger economy and a better tax system. I think the most important thing to emphasize, though, is that we also have to help people in other ways to build a stronger economy. And we can't have any tax cut that's not paid for. One of the big differences between Senator Dole and myself is that I told you how I'm going to pay for every penny of the tax cuts I recommend. We've worked hard to bring this deficit down, and that's helped people in the real estate business, because the interest rates are lower. We've got homeownership at a 15year high. We've got this country going in the right direction. So we can have a tax cut, but my priority would be to help the families who need it with childrearing and education and buying a firsttime home and helping for health care costs. So from your business, helping in buying the first-time home, exempting the capital gains on the sale of the home would be the most important things that you asked about. Thank you, Pamela. Mr. Lehrer. Senator Dole. Senator Dole. Well, Pamela, what the President didn't tell you is that all his tax cuts expire at the year 2000, but all his increases go on forever. That's the liberal approach. You know, give you a little tax cut, give you a couple of years, then make the tax increases go on forever. So the net tax increase in his plan is somewhere between $60 billion and $80 billion. We have in the Dole-Kemp economic plan, unless your home is worth over $500,000—and if it is, I appreciate it, congratulate you—but in any event, no tax. And it's a good idea. They saw it, and they picked it up and put in theirs, but it's only temporary. Ours is permanent. Ours is a good plan: create jobs and opportunities; capital gains rate, cut it in half, cut it from 28 percent to 14 percent. There are $7 trillion in assets locked up in America. If we cut the capital gains rate—I'm told every day— I got a letter from a former constituent in Kansas saying, "I want to sell property in California, put it in my business in Kansas. I can't because the capital gains rate is too high." We need to get the economy going. That will help Social Security. That will create more jobs. That will help people who want to get off welfare. It's the American way. The President. Before Senator Dole left the Senate, he and Mr. Gingrich also were recommending that we pass these tax cuts only insofar as we could pay for them. And we all assume that the tax cuts will be permanent, but we have to prove we can pay for them. After he left the Senate, we abandoned that. That's why most experts say that this tax scheme will blow a huge hole in the deficit, raise interest rates, and weaken the economy. And that will take away all the benefits of the tax cut with a weaker economy. That's why we have to balance the budget. And I'll tell you how I'm going to pay for anything I promise you, line by line. You should expect that from both of us. Mr. Lehrer. All right. The next question is for Senator Dole. Yes, ma'am, right there. Responding to American Youth Q. My name is Melissa Lydeana, and I'm a third-year student out at UC-San Diego. And I just want to say that it's a great honor representing the voices of America. My question is concerning you, Mr. Dole, all the controversy regarding your age. How do you feel you can respond to young voices of America today and tomorrow? Senator Dole. Well, I think age is very—you know, wisdom comes from age, experience, and intelligence. And if you have some of each— and I have some age, some experience, some intelligence—[laughter]—that adds up to wisdom. I think it also is a strength; it's an advantage. And I have a lot of young people work in my office, work in my campaign. This is about America. This is about—somebody said earlier, one of the first questions, we're together. It's one America, one nation. I'm looking at our economic plan because I'm concerned about the future for young people. I'm looking about drugs. The President's been AWOL for 4 years. I'm looking about crime. He'll claim credit now for crime going down, but it happened because mayors and Governors and others have brought crime down. Rudy Giuliani, the mayor of New York, brought crime down 25 percent just in New York City, but of course the President will take credit for that. My view is we want to find jobs and opportunities and education. This year the Republican Congress, as far as student loans, went from 24 billion to 36 billion over the next 6 years— a 50 percent increase; the highest appropriation ever, $6 billion for Pell grants. Very, very important. And we also raised the amount of each Pell grant. In our economic plan, the $500 child credit can be used for young people. Rolled over and over and over—of course, not this age, but if you have a child 2 years old, 7 percent interest, it would be worth about $18,000 by the time that child was ready for college. The President. I can only tell you that I don't think Senator Dole is too old to be President. It's the age of his ideas that I question. You're almost not old enough to remember this, but we've tried this before, promising people an election-year tax cut that's not paid for—— Senator Dole. We tried it last time you ran. The President. ——telling you you can have everything you got—and let me just say this: Did you hear him say the Congress just voted to increase student loans and scholarships? They did, after he left. The last budget he led cut Pell grants, cut student loans. I vetoed it when they shut the Government down. My plan would give students a dollar-for-dollar reduction for the cost of the typical community college tuition, a $10,000 deduction a year for the cost of college tuition, would let families save in an IRA and withdraw tax-free to pay for the cost of education. And it's all paid for. My whole administration is about your future, it's about what the 21st century is going to be like for you. And I hope you'll look at the ideas in it. Thank you. Senator Dole. Well, when you don't have any ideas, I guess you say the other person's ideas are old. As I said earlier, they don't have any ideas. Their idea is to raise taxes and spend more money. That's the liberal philosophy. If that's what you like, you've got a perfect candidate. President Clinton came to California in 1992 and said, "The centerpiece in my first 4 years is going to be a middle class tax cut." Now, to all you who got that tax cut, congratulations, because you got a big tax increase. You got a $265 billion tax increase. And he stands here and says politicians who make promises like that ought to be ignored. Well, he made the promise. I keep my word, and you'll have a tax cut. It will help you in whatever you're going to do in the next few years. Thank you. Mr. Lehrer. Next question is for President Clinton, and it's from—yes, ma'am? Yes? Affirmative Action Q. Hello. My name is Chessie Sanders, and my question is do you feel that America has grown enough and has educated itself enough to totally cut out affirmative action? The President. No, ma'am, I don't. I am against quotas; I'm against giving anybody any kind of preference for something they're not qualified for, but because I still believe that there is some discrimination and that not everybody has an opportunity to prove they are qualified, I favor the right kind of affirmative action. I've done more to eliminate programs—affirmative action programs that I didn't think were fair and to tighten others up than my predecessors have since affirmative action has been around, but I have also worked hard to give people a chance to prove that they are qualified. Let me just give you some examples. We've doubled the number of loans from the Small Business Administration, tripled the number of loans to women business people—no one unqualified. Everybody had to meet the standards. We've opened 260,000 new jobs in the military to women since I've been President, but the Joint Chiefs say we're stronger and more competent and solid than ever. Let me give you another example of what I mean. To me, affirmative action is making that extra effort. It's sort of like what Senator Dole did when he sponsored the Americans with Disabilities Act that said to certain stores, "Okay, you've got to make it accessible to people with wheelchairs." We weren't guaranteeing anything—anybody anything except the chance to prove they were qualified, the chance to prove that they could do it. And that's why I must say I agree with General Colin Powell that we're not there yet. We ought to keep making those extra-effort affirmative action programs the law and the policy of the land. Mr. Lehrer. Senator Dole. Senator Dole. Well, we may not be there yet, but we're not going to get there by giving preferences and quotas. I supported that route for some time, and again, I think it gets back to experience—a little experience, a little age, a little intelligence. And I noticed that nobody was really benefiting except a very small group at the top. The average person wasn't benefiting. People who had the money were benefiting. People who got all the jobs were benefiting. It seems to me that we ought to support the California civil rights initiative. It ought to be not based on gender or ethnicity or color or disability. I'm disabled. I shouldn't have a preference. I would like to have one in this race, come to think of it. But I don't get one. Maybe we can work that out. I get a 10-point spot. [Laughter] This is America. No discrimination. Discrimination ought to be punished, but there ought to be equal opportunity. We ought to reach out and make certain everybody has a chance to participate. Equal opportunity, but we cannot guarantee equal results in America. That's not how America became the greatest country on the face of the Earth. The President. I have never supported quotas. I've always been against them. They don't favor equal results. But I do favor making sure everybody has a chance to prove they're competent. The reason I have opposed that initiative is because I'm afraid it will end those extra-effort programs. Again I say think of the American with Disabilities Act. Make an effort to put a ramp up there so someone in a wheelchair can get up. You don't guarantee that they get the job; you guarantee they have a chance to prove they're competent. And as I've said, this is not a partisan thing with me. General Powell, Colin Powell said the same thing. He fears that the initiative would take away the extra-effort programs. No preferences to unqualified people, no quotas, but don't give up on making an extra effort till you're sure everybody has a chance to prove they're qualified. Mr. Lehrer. All right, the next question is for Senator Dole, and it comes from this section right here. The back row, there, in the blue shirt. Yes, sir. Senator Dole's Tax Cut Proposal Q. My name's Tim David. I'm a mechanical engineer. Senator Dole, how do you reduce taxes and balance the budget? Senator Dole. Oh, I'm glad you asked. The President. So am I. I am too. Senator Dole. What's your first name? Tim? I first want to say the President didn't quite give you all the stuff on quotas, because the Justice Department entered what we call the Piscataway case up in New Jersey. It's pretty clear that was a quota case. And just because one teacher was white and one teacher was black and they had the same qualification, you know, they decided who would stay there. It shouldn't be that way. Now, the President can say, well, he wants to mend it, not end it. There are 168 Federal programs that allow quotas. He ended one. Now this economic package, Tim, I'm glad you asked because you look like the type that might be able to benefit from the 15 percent, across-the-board tax cut and $500-per-child tax credit or, you know, estate tax relief, which you're not interested in right now, but capital gains rate reduction—if you're taking care of an elderly parent, you get a $1,000 deduction. We think that's very important because a lot of people take care of their parents. How do we pay for it? We're going to have a constitutional amendment to balance the budget, which the President opposed and defeated. He twisted arms, got six Democrats to vote with him. We lost by one vote. We're going to balance the budget by the year 2002. The President wants to spend 20 percent more over the next 6 years; I want to spend 14 percent more and give that 6 percent back to the people. Remember, it's your money. It's not his money, and it's not my money. It's your money, and you shouldn't have to apologize for wanting to keep all you can of it, but he ought to apologize for wanting to take more and more. He wants to give you sort of a Government tax cut which really doesn't mean anything. The President. You know, one of the responsibilities of growing older, it seems to me, is being able to tell people something they may not want to hear just because it's truth. When they had a $250 billion tax scheme—that is half the size of this one, this one is 550—they passed a budget that had $270 billion in Medicare cuts, the first education cuts in history, cut environmental enforcement by 25 percent, took away the guarantee of quality standards in nursing homes, took away the guarantee of health care to folks with disabilities. Don't take my word for this. The Economist magazine polled lots of economists. Seven Nobel Prize winners have said, if this tax scheme passes, it will require huge cuts—40 percent— in the environment, in law enforcement, in education. It will require bigger cuts in Medicare than I vetoed last time. My targeted tax cut gives tax cuts for education, childrearing, buying a first-time home, paying for health care costs, and it's paid for. And I've told you how I'll pay for it. He won't tell you because he can't. Senator Dole. Your targeted tax cut, Mr. President, never hits anybody. That's the problem with it. Nobody ever gets it. But I must say I'm a little offended by this word "scheme." You talked about—last time you talked about a risky scheme, and then Vice President Gore repeated it about 10 times in St. Petersburg. If I have anything in politics, it's my word. My colleagues, Democrats and Republicans, will tell you that Bob Dole kept his word. I'm going to keep my word to you. I'm going to keep my word to the American people. We're going to cut taxes and balance the budget. We're not going to touch Medicare. It's going to grow 39 percent, and Social Security is going to grow 34 percent. Now, the President doesn't have any ideas so he's out trashing ours. This isn't going to blow a hole in the deficit. He promised you a tax cut in 1992, and if you got one, you ought to vote for him. Mr. Lehrer. Sir. The next question is for the President. Yes, sir, right there—white shirt. Family and Medical Leave Act Q. My name is Dwayne Burns. I'm a martial arts instructor and a father. Mr. President, could you outline any plans you have to expand the family leave act? The President. Thank you. Well, first let me say that I signed the family leave act. It was my very first bill, and I'm very proud of it because it symbolizes what I think we ought to be doing. I don't take credit for all the good things that have happened in America, but I take credit for what I've tried to do to work with others to make good things happen. The most important good things that happen in America happen in families. Just about every family I know, the main concern is how am I going to succeed at work and still do right by my children? Family and medical leave has let 12 million families take a little time off for the birth of a child or a family illness without losing their job. I'd like to see it expanded in two ways: I'd like to say you can also take a little time off without losing your job to go to a regular parent-teacher conference or to go to a regular doctor's appointment with a family member; I'd also like to see the overtime laws change so that we could have some more flextime so that at the discretion of the worker— the worker—if you earn overtime you could decide whether you want that time to be taken in cash or in time with your family if you've got a family problem. I never go anywhere, it seems like, where I don't meet somebody who's benefited from the family leave law. In Longview, Texas, the other day, I met a woman who was almost in tears because she had been able to keep her job while spending time with her husband who had cancer. One of the people who's here with me today met a woman in the airport saying that her son just was able to be present at the birth of his child because of the family leave law. So yes, I think it should be expanded. We have to help people succeed at home and at work. Senator Dole. Well, 88 percent of the people the President claims, or 11 million, are already covered. And only 5 percent—keep in mind, only 5 percent of the employers were even affected by the family leave act. We had a better idea. We didn't win, but we had a better idea. Now we have a majority; we need to get a President. That was a tax credit to the employer. Instead of the Federal Government reaching out, we had a tax credit to pick up some of the cost, because if you have to hire a replacement worker, that's a cost. This is the way it ought to work. Give more power back to the States and back to the people, back to the taxpayers, not always the long arm of the Federal Government. But keep in mind this bill covers 5 percent of the employers; 95 percent of the employers and all those employees they employ are not covered in this act. And according to Investors Daily, which I read just a couple of days ago, 88 percent of the people he claims credit for were already covered in collective bargaining agreements or other agreements. We had family leave in our office. I'm certain—I see my friend Senator Mitchell. He had family leave. I work every day with people. I spent a lot of time in hospitals. I know what it's like to be in a hospital. Sure, we want family leave, but there's a better way to do it. The President. I only have 30 seconds. I can't fix the statistics. It covers the majority of the work force. Employers of under 50 are exempted. The bill originally covered employers of 25 and more, but because of opposition, we went up to 50. Senator Dole led the opposition to it. He filibustered it. He said it was a mistake. He said it would hurt the economy. We've had record numbers of new small businesses and 10 1/2 million jobs. It didn't hurt the economy. He still believes it's a mistake. I believe it was right. You can decide which of us you think are right. It's up to you. Mr. Lehrer. Next question for Senator Dole. This side. Yes, ma'am. Domestic Manufacturing Q. Hi. My name is Bridget Gianotti, and I'm a wife and mother of two sons from Carlsbad. And my question for you, Senator Dole, is as the wife of a San Diego business owner, I see one of our biggest problems is the U.S. does not manufacture enough of our own products. How would you help this problem out? Senator Dole. Well, right, we've lost 357,000 manufacturing jobs. And the Bureau of Labor Statistics said today that they made a mistake, it's probably going to be a much, much higher figure. So we're talking about all these new jobs, we'd better wait and see what the results are. We're going to do that with a more aggressive trade policy. We're going to do that with an economic package. We're going to do that with regulatory reform. You know, regulations cost the average family—right here, Democrat or Republican—about $7,000 a year—7,000. It's like a tax. Put a lot of people out of business. I met a lady in Colorado Springs about 7 weeks ago, now. She had a small business with 63 employees. She finally gave it up. Why? Because of paperwork and regulation. Congress passed the Paperwork Reduction Act. The President exempts the IRS, which creates threefourths of the paperwork. We're going to have regulatory—we're going to have litigation reform. You know, I fell off a platform out in California, in Chico, a while back. Before I hit the ground, my cell phone rang, and this trial lawyer says, "I think we've got a case here." [Laughter] You know, we've got to stop some of these frivolous lawsuits. They're putting people out of business, men and women. Get the economy going, cut the capital gains rate, create more jobs and opportunities for everybody in America—that's what we will do, and my word is good. I keep my promises. I don't break my promises after the election, and I don't make new promises on an election year. We're going to get it done; we're going to grow some of these jobs in America because we need to get it. They're going the wrong way. The President. Let's look at the facts. We lost a lot of manufacturing jobs in the 12 years before I became President. We've gained manufacturing jobs since I've been President. We've negotiated over 200 separate trade agreements. Let's just take California. In California, we made $37 billion worth of telecommunications equipment eligible for exports for the first time. We're selling everything from telephones to CD's to rice in Japan. We're selling American automobiles in Japan now. I visited a Chrysler dealership in Japan. We're number one in automobile manufacturing, production, and sales around the world again for the first time since the 1970's. Why? Because we've had tough, aggressive trade policies, and because we got interest rates down, and we had a good, stable economic policy, because we've reduced the deficit 4 years in a row for the first time in the 20th century that a President's done that in all 4 years. And that's why I don't want to see us blow a big hole in the deficit with a tax program we can't pay for so your interest rates will go up and you'll have to pay back in higher interest rates what you allegedly will get in a tax cut. So I say keep working on expanding the markets. More than half of these 10 1/2 million new jobs were in higher wage areas, and we'll have more manufacturing and more sales at home and around the world. Senator Dole. Well, you may think the biggest employer in America is General Motors, but I've got news for you. It's manpower services, hiring people temporarily who've lost their jobs and they go to work for 30 days or 60 days. That's a good economy? I don't think so. They're setting new records this year. We have the worst economy in a century. We have the slowest growth, about 2.5 percent. The President inherited a growth of over 5 percent. We don't have the S&L crisis anymore. Republicans have cut $53 billion in spending. That's why the budget can look good. It didn't look too good the first 2 years when we had a Democratic President and a Democratic Congress. Mr. Lehrer. The next question is for President Clinton. Yes, sir? Gay Rights Q. I'm Bob Goldfarb. I'm a travel agent. And can you please explain your policy on the employment nondiscrimination act that would have prohibited discrimination, would have prohibited people from being fired from their jobs simply for being gay or lesbian? The President. I'm for it. That's my policy. I'm for it. I believe that any law-abiding taxpaying citizen who shows up in the morning and doesn't break the law and doesn't interfere with his or her neighbors ought to have the ability to work in our country and shouldn't be subject to unfair discrimination. I'm for it. Now, I have a little time left, so let me just say that I get attacked so many times on these questions it's hard to answer all those things. In February—Senator Dole just said we had the worst economy in a century. In February he said we had the best economy in 30 years— just February. And I don't want to respond in kind to all these things. I could; I could answer a lot of these things tit for tat. But I hope we can talk about what we're going to do in the future. No attack ever created a job or educated a child or helped a family make ends meet. No insult ever cleaned up a toxic waste dump or helped an elderly person. Now, for 4 years that's what I've worked on. If you'll give me 4 years more, I'll work on it some more. And I'll try to answer these charges, but I prefer to emphasize direct answers to the future, and I gave you a direct answer. Mr. Lehrer. Senator Dole? Senator Dole. Well, I'm opposed to discrimination in any form, but I'm—but I don't favor creating special rights for any group. That would be my answer to this question. And I'm—you know, there'd be special rights for different groups in America, but I'm totally opposed to discrimination, don't have any policy against hiring anyone—whether it's lifestyle or whatever, we don't have any policy of that kind, never have had in my office, nor will we have in the future. But as far as special rights, I'm opposed to same-sex marriages, which the President signed well after midnight one morning, in the dark of night—he opposed it. But I'll get back to the economic package because again, I think this is very important. If there is anything that's going to change America, it's get the economy to grow. The President inherited a good economy—sure. The S&L crisis ended, we were selling assets, we had a Republican Congress cutting spending finally, and he says we've had the best 4 years ever. That's not true. We've had over 1.2 million bankruptcies—set a new record. Credit card debt has never been higher. I just told you about this manufacturing job loss which is going to increase. We need a good, strong economic package. Let the private sector create the jobs. And they can do it. Mr. Lehrer. Mr. President? The President. If you believe that the California economy was better in 1992 than it is today, you should vote for Bob Dole. I have worked so hard out here to help turn this economy around. Let me just give you one tiny example. In San Diego, where we had some defense cutbacks, we funded a project with the University of California, San Diego to use airplane composite materials to build lighter, stronger bridges— a little project, and a program that Senator Dole opposed—and that composite now is going to be built around the bridges on the Santa Monica freeway to help minimize the impact of earthquakes and create more jobs. That's just one tiny example. Maybe we'll talk about some more before it's over. Mr. Lehrer. The next question is for Senator Dole and it's from this section. Yes, ma'am? Yes? Health Care Q. Senator Dole, I am Verda Stratigus, and I work in health care. And it's truly an honor to be here tonight to address both of you. Senator Dole. Thank you. Q. Being in health care—we have talked a little bit about health care tonight, but mainly MediCal and Medicare have been mentioned, but the private sector is a problem. Managed care is taking over, especially in California, and because of that, the quality of care is going downhill. There are many, many people who cannot get the tests that they need when they need them. And because of that, they are dying needlessly. There are many, many more lawsuits being presented against the managed care industry because of this. And I think it's a real problem that needs to be addressed. What would you do if you were President? Senator Dole. Well, one thing I did was to oppose the Government takeover of health care that President Clinton offered in 1993, which created 17 new taxes and 50 new bureaucracies and price controls, because we were afraid the very thing you mentioned would have happened. Everybody would have been forced into managed care. You couldn't have chosen your own doctor. And that would have been the end. And I think right now we've got to go back— I know they've appointed a commission to take a look at managed care. Maybe that's part of the answer. But it seems to me, if we start to take choices away from people and if we drive them into one type care, if we eliminate fee-for-service altogether or eliminate the fact you can go to your own doctor, you've got to go somewhere else, then I think we've taken a giant step backward in the United States of America. We have the best health care delivery system in the world, and we want to keep it that way. That's why we opposed the Government takeover health care plan that President Clinton tried and tried and tried to get through Congress. Didn't get it done. When it ended up we had more votes than he had, then they decided to pull the plug. It was a big, big mistake. Now, whether or not he'll do that again, I've heard some of the people say, "Well, that's the model we ought to use." And if he's reelected, maybe he'll come back and try it again. I hope not. I hope not in both cases. But it does seem to me that you've raised a very important point that needs to be addressed. We're going to have to watch it, going to have to take a look at all the managed care going on in California, or we're going to end up losing our best care that we have in the world. The President. I'm just curious. How many of you are under managed care plans? Raise your hand if you're in managed care. Senator Dole. Probably the young people here. The President. How many of you like it? Well—— Senator Dole. Two. The President. One of the things that I tried to do was to make sure that everybody in the country who was under a managed care plan should at least have three choices of plans and would have the right to get out without penalty every year. Now, that's not a Government takeover, that's like the family and medical leave law. It just tries to set the rules of the game. I'm strongly in favor of a Federal bill to repeal the—any gag rules on providers. In other words, I believe that doctors should not be able to be kicked out of managed care plans just because they tell the patients what they need and what more expensive care options might be. If we're saving money and managing resources better, that's a good thing. If we're saving money and depriving people of care, that's a bad thing. A good place to start is to say no managed care provider can gag a doctor and kick the doctor out of the managed care plan for the doctor telling the patient, "You need a more expensive test, you need a more expensive procedure. Your health requires it." Mr. Lehrer. Senator Dole? Senator Dole. Well, I don't have any quarrel with that. I think that would help. But I think what we want to avoid is falling back into this nationalized health care system that President Clinton wanted to give us in 1993. If that isn't a liberal idea, I've never heard one: 17 new taxes; price controls; 50 new bureaucracies. We'd have that trouble all over America. We need to deal with managed care. It not only happened in California, it's happening in other States that we visit too. It's a national problem, not just a State problem. Mr. Lehrer. The next question is for President Clinton, and in this section. Yes, ma'am. Yes. Participation in Electoral Process Q. All right, I'd sort of like to—Coleen O'Connor. I teach history and political science at San Diego Mesa College right up the road here. And I'd like to tee off from the original question by another teacher and speak for those people that aren't here tonight. Sixty-three percent of the American people are not participating, that are eligible to vote, not even participating in the process. Several parties can't even get into the debate: the Green Party, the Reform Party, the Natural Law Party. All of these people have basically opted out of what we're still participating in. And if we in fact are going to bring the country back together and be all faces around the table, the new American family, what do you see as something the President can do to begin that process to bring them back in? The President. First of all, I think it's important to make voting more accessible. That's why I strongly supported the motor voter law. There was a big story, I think, in USA Today about the millions of people who've now registered because of it. Secondly, I think we need to look at making the elections more accessible. You know, several States now are letting people vote over 3 weeks. A lot of people are busy, and it's hard for them to just get there and vote. The third thing I think we need is more forums like this, which is one of the reasons I have so strongly supported campaign finance reform, because if you want to cut the cost of campaigns, you have to open the airwaves, because what drives the cost of a campaign are the costs of advertising on television, radio, newspaper, mass mailing. And if you open the airwaves to more things like this—you see, it's not just you that are participating here. For every one of you who stood up here and asked a question tonight, I promise you, there's 100,000 Americans that said, "I wish I could have asked that question." So I think we have to change the nature of politics. The last thing I think we should do is something I've been trying to do since I've been President, is every time I do something in a public way, I try to have a real American citizen there who is directly affected by it so that people can see the connection of what happens way across the country in Washington with more police on the street in San Diego, clean up the sewage here in San Diego, doubling the border guards here in southern California, that there is a connection between what we do way back there and what we do here. Those are my best ideas about it. Senator Dole. Well, I don't know of any perfect solution. I've been in politics for some time, and I worry about people who don't vote. And I wonder if it's our fault, the candidates' fault. People say "I don't care. One vote doesn't make a difference." I can give you hundreds of cases—you can probably give me 200 cases where one vote made a difference. I know it made a lot of difference many times in the Congress. Campaign finance might help, might help contributions coming in from Indonesia or other foreign countries, rich people in those countries, and then being sent back after the L.A. Times discovers it—$250,000. But maybe there ought to be more debates. I'd be willing to have another debate this year where we'd invite all of the candidates and talk about the economy. If we don't get the economy to grow, if we don't cut taxes, and give people child credits, and cut the capital gains rate, and get this economy growing, we're going to limp into the next century. If we grow the economy, it's going to help Social Security, it's going to help jobs, it's going to help everything. The President. Let me make one other suggestion. As you're a teacher, you can have an impact on that. One of the things I think that really frustrates people is that so often, political campaigns seem to be more about the politicians that are running than the people. Now, there is a connection, and I think what we have to do is convince people there's a big difference. If you vote one way, you will have a Department of Education in the 21st century; if you vote the other way, you won't. If you vote one way, you'll have an expansion of family leave; if you vote the other way, you'll be lucky to save it. But these are important questions, and people have to decide. I think that the American people also need to be a little more responsible and think about whether there's a connection in their lives and what we do in Washington. Mr. Lehrer. For Senator Dole, in this section. On the back row, yes, ma'am. Social Security and Alternatives Q. I'm Iris Seiffert, and I'm unemployed. Senator Dole. Iris? Q. Iris. Senator Dole, we talked about Social Security for us baby boomers, but shouldn't we be saving and investing for our own retirement as well? Are you planning any incentives to encourage us to take care of ourselves rather than to rely on the Government and on Social Security when we retire? Senator Dole. Well, we have in our economic pack individual retirement accounts where we think it'll encourage savings. You could also use those accounts for health care or education or a first home. We're doing that precisely. And I think one thing sooner or later we're going to have to consider is to take a look at the Social Security system, because we've got a lot of people advocating that, well, we don't want to put our money into Social Security. Now, you've got to be very careful about that, because you have to protect the people who are already in the pipeline. But it's something you might consider. I'm not suggesting it will be done, but at least we ought to look at it. It's been looked—when I was chairman of the Finance Committee, which handles Social Security, we looked at all these options, and one thing we've got to make certain—when I used to go home, my mother would tell me, "All I've got is my Social Security; don't touch it." And we didn't touch it. We preserved it. And I'm an optimist. Your Social Security is going to be there when you retire. We'll fix it. It will probably happen in the year 2012 or 2015. In 1983, we thought we had a 75year fix. It didn't work—much, much less. But at least we fixed it for some time, and 37 to 40 million people get their checks on time. So we need to preserve the system, and we need to make it stronger. But we also need to look at some options whether or not we— it would depend on what the options are. In fact, they've got a commission right now in Congress, a bipartisan commission, looking at all the different options they're going to present to the next Congress. So I think we'll wait and see what they present, take a look at it. The President. This is one where we have some agreement, I think. Only about half the people in this country have pension plans, and Social Security is not enough for a lot of people to live on, or at least it's not enough for them to maintain anything like their previous lifestyle. So we've got to figure out how we're going to have more people with pension plans. And pension coverage has been declining as more and more people work for small businesses and fewer people work for big businesses. So what is in my plan—and I think it's almost identical to what's in Senator Dole's plan—is we make more people than are now eligible to save in an IRA, and we'd let couples—married couples save more, and then they could withdraw from it tax-free if they needed to for medical emergencies or to buy a home or for an education, but they could also save to supplement their retirement. In addition to that, we just passed a sweeping small business reform that makes it easier for small-business people to take out 401(k) plans for themselves and their employees and then much easier for employees to carry it from job to job. My best friend from grade school is a computer software salesman, and he told me last time he changed employers it took him 9 months to figure out how to transfer his 401(k) plan. Now, none of that will happen anymore. And so I hope that over the next 10 years you'll see a big increase in the percentage of people that have pension plans plus a secure Social Security System. Senator Dole. Did you say you're unemployed? The first thing we ought to do is get you a job. And that's the economic package again: Create jobs and opportunities, reduce the capital gains rate, reduce regulatory reform, stop some of this senseless litigation, and let people work in America. And I think that's the thrust we will make. Obviously, Social Security is a very important program. It'll be preserved—Democrats or Republicans. It'll be preserved. We want to make certain we protect those in the pipeline, just as we did back in 1983. And we did it on a bipartisan basis. We took it out of politics. People get so tired of politics. And we ought to do the same with Medicare. Maybe we could make a deal here tonight. Mr. Lehrer. All right, the question is for President Clinton. Does anybody have a foreign affairs question in this section? Yes, sir. Trade With Japan Q. Good evening. I'm Michael Smith. I'm an electronics technician in the Navy. My question was how you plan to deal with the trade deficit with Japan? The President. Let me tell you what we have done. We have concluded with Japan 21, about to be 22 trade agreements now. And since we did that, in the areas where we concluded trade agreements, our exports to Japan have gone up by 85 percent in the last 4 years, and our trade deficit with Japan has gone down. Until about 5 months ago, the Japanese economy was in a deep recession. It's coming back now, so they can buy even more American products, and I think it'll go down more. But I'm very—that's one of the real success stories here of the work we've done. We're selling Japanese rice from California for the first time. I visited a Chrysler dealership in Tokyo. I visited a Jeep plant, the oldest auto plant in America, in Toledo, Ohio, where they're going to export 41,000 right-hand-drive Jeeps this year, and they've got 700 new jobs because of it. There is no easy way to do this. When you're dealing with an economy that's traditionally been more closed and one that's traditionally been more open, you just have to gut it out issue by issue by issue. We agreed in principle on our insurance agreement, and we're working on three or four other areas now. But the way you have to do it is make sure you're competitive—we're the most competitive country in the world now—and then just fight to open those markets and go try to make the sale. And that's what our trade ambassador, our Commerce Secretary, and all the other people in our administration have tried to do. Mr. Lehrer. Senator? Senator Dole. Well, the bottom line is we've got to stop exporting jobs. We need to keep jobs here. I said there are 357,000 good jobs, manufacturing jobs, which were lost. And I assume some of those because of our trading partners; we didn't have access to their markets. We ought to insist on access. If we don't have access to their markets the same way they have access to our markets, we ought to say, "Wait, that's enough. Time out. When you give us access, we'll give you access." It's very hard to get into the Japanese market, as everybody knows. They want to get into our market. They sell a lot of automobiles here, create a lot of jobs—those who sell exports. And it's very important to the economy. But I think we want to make certain. I supported the President's trade policy, but we've got to be more aggressive. Once you have a policy, then you've got to go out and be aggressive and enforce that policy. There are American jobs that are being lost. This is what Ross Perot complains about. And I'd say to the Reform Party, take a look at the Republican Party. We're the reform party, and we're going to make things better. And one of the things we're going to do is stop exporting jobs in America. The President. Let me say again, we've had over 200 separate trade agreements in the last 4 years, by far the largest number in American history, not just the big ones you've read about but a lot of smaller ones. And now what we have to do is to focus on those things we're real good at and make sure we're getting a fair deal. We just had a pretty serious dispute with China because they were copying our CD's and costing thousands of jobs in places like California. But we said, "You know, if you want to keep doing business and selling your products over here, you're going to have to quit pirating our CD's." And they agreed to do a number of things and to let us verify that they'd done it. But I think they're going to make the problem much better. But there is not a simple, easy answer. You just have to work on this day-in and day-out, every month, every year, every issue to make sure that we have not only free trade but fair trade. I'm proud that we're better off on that than we were 4 years ago. Mr. Lehrer. All right, the next question is for Senator Dole, and it's in this section. Yes, sir. Religion and Values Q. Ron Kite, minister. Senator Dole. Hi, Ron. Q. This great Nation has been established by the Founding Fathers, who possessed very strong Christian beliefs and godly principles. If elected President of the United States, what could you do to return this Nation to these basic principles? And also, do you feel that the office of the President has the responsibility to set the role example to inspire our young people? Senator Dole. Well, no doubt about it, our Founding Fathers had a great deal of wisdom. And in addition to what you mentioned, they also were concerned about this all-powerful central Government in Washington, DC, that would in effect confiscate your property. So I carry around in my pocket—I can't pull it out, I'd violate the rules—a copy of the 10th amendment, which says that we ought to return power to the States and power to the people—people here. You ought to make more decisions. Honor, duty, and country: that's what America is all about. Certainly the President of the United States, in the highest office in the world, the most important office in the world, has a responsibility to young people, as we talked about earlier—to everyone, by example. And when it comes to public ethics, he has a responsibility. When you have 30-some in your administration who've either left or are being investigated or in jail or whatever, then you've got an ethical problem. It's public ethics—I'm not talking about private, we're talking about public ethics—when you have 900 files gathered up by some guy who was a bouncer in a bar and hired as a security officer to collect files. In Watergate, I know a person who went to jail for looking at one file, one FBI file. There are 900 sequestered in the White House—900— people like you. Why should they be rifling through your files? So the President has a great responsibility. And it's one that I understand and would certainly carry out. The President. This is the most religious great country in history, and yet, interestingly enough, we have the most religious freedom of any country in the world, including the freedom not to believe. And now we have all these people— just up the road in Los Angeles County we've got people from 150 different racial and ethnic groups, and they've got tons of different religions. But the fundamental tenets of virtually every religion are the same. And what I've tried to do is to support policies that would respect religion, and then help parents inculcate those values to their children. Let me very briefly give you some examples. One of my proudest moments was signing the Religious Freedom Restoration Act, which says the Government's got to bend over backwards before we interfere with religious practice. So I changed a Justice Department effort to get a church to pay back a man's tithe because he was bankrupt when he gave it. I've supported character education programs in our schools, drug-free schools programs. I've supported giving parents a V-chip on their television so if they don't want their young kids to watch things they shouldn't watch, they wouldn't have to. That's the kind of thing we need to do, give people like you and our families the power to give those values to our children. Senator Dole. Well, I think it's—you know, before I came in tonight, my wife and daughter and I had a prayer because if it's God's will, whatever happens—if it's God's will, it will happen. A constitutional amendment for voluntary prayer in school in my view would be a great idea. I support it, and the President opposes it. I mean, it seems to me the President, whoever the President may be, this is one of his highest responsibilities. People look to the President of the United States more than any other person in America. And that's the way it's always been, and that's the way it always will be. Mr. Lehrer. All right, this is our last question. It goes to President Clinton, and it's from this section. Yes, ma'am? "Special Rights" Q. My name is Evette Duby, and I too am a minister; I'm with the Universal Fellowship of Metropolitan Community Churches. President Clinton, perhaps you can help me with something tonight. I've heard Mr. Dole say several times, "all of us together." And when he was asked if he would support equal rights in employment for gay and lesbian people, you said that you favored that, and he said that he did not believe in special rights. And I thought the question was equal rights for all people, and I don't understand why people are using the term "special rights" when the question is equal rights. Could you help me in understanding that? The President. I want to answer your question, but let me say one other thing. We don't need a constitutional amendment for kids to pray. And what I did was to have the Justice Department and the Education Department, for the first time ever, issue a set of guidelines that we gave to every school in America saying that children could not be interfered with in religious advocacy, when they were praying, when they were doing whatever they could do under the Constitution just because they were on a public school grounds. And I think anyone who has experienced this would tell you that our administration has done more than any in 30 years to clarify the freedom of religion in the public square, including in the public schools. Now, I think I have to let Senator Dole speak for himself. It wouldn't be fair for me to do that. I would wind up—I mean, it's the last question, and I'd mischaracterize it to try to make you happy. Let me tell you what I feel. We have a lot of differences in our country, and some of us believe that other people's decisions are wrong, even immoral. But under our Constitution, if you show up tomorrow and obey the law, and you work hard, and you do what you are supposed to do, you're entitled to equal treatment. That's the way the system works. All over the world, people are being torn apart—Bosnia, the Middle East, Northern Ireland, Rwanda, Burundi, you name it—because of all their differences. We still have some of that hatred inside us; you see it in the church burnings. And one of the things I've tried hardest to do is to tell the American people that we have to get beyond that, we have to understand that we're stronger when we unite around shared values instead of being divided by our differences. Mr. Lehrer. Senator Dole? Senator Dole. Well, I hope I made my answer clear. I said I'm opposed to discrimination. You know, we've suffered discrimination in the disability community. There are 43 million of us. And I can recall cases where people would cross the street rather than meet somebody in a wheelchair. So we want to end discrimination. I think that answers itself. No discrimination in America. We've made that clear. And I would just say that it seems to me that that's the way it ought to be. We shouldn't discriminate—race, color, whatever, lifestyle, disability. This is America, and we're all proud of it. But we're not there yet. What we need is good, strong leadership going into the next century. I'm sorry we didn't have a foreign policy question, because just this week Secretary Christopher said, "Well, we really didn't know much the first couple of years about foreign policy." Now, that was quite an admission. It underscores what I had to say in the Hartford debate, that there is really no foreign policy in this administration. It's sort of ad hoc: "Whatever comes up, we'll deal with it." Unfortunately, we didn't have more questions on that. The President. Let me say again, there is no more important responsibility for the President than to say, "If you believe in the Constitution, the Bill of Rights, and the Declaration of Independence, that's all we need to know. And you can be part of our America, and you can walk across that bridge to the 21st century with us." And we are not well served when we attack each other in a kind of an ad hominem way. It doesn't create jobs. It doesn't educate children. It doesn't solve problems. We need to be disagreeing on ideas honestly and talking about the future. The future will be the greatest time in this country's history if we can beat this division that is bedeviling the whole rest of the world. Closing Statements Mr. Lehrer. All right. Now we go to the closing statements. Senator Dole, you're first. Two minutes, sir. Senator Dole. Well, let me thank everybody here at the university, and Jim, thank you, all the people who may still be watching or viewing. This is what it's all about. It's not about me. It's not about President Clinton. It's about the process. It's about selecting a President of the United States. So we have our differences. We should have our differences. I mentioned other parties. They have their differences. If we all agreed, it'd be a pretty dull place. We should have more debates. Maybe we'll have another debate on the economy. But I would just say this: This is the highest honor that I have ever had in my life, to think that somebody from Russell, Kansas, somebody who grew up living in a basement apartment, somebody whose parents didn't finish high school, somebody who spent about 39 months in hospitals after World War II, somebody who uses a buttonhook every day to get dressed, somebody who understands that there are real Americans out there with real problems, whether soccer moms or the single parents or families working or seniors or people with disabilities, whoever it may be. But there are some very fundamental differences in this campaign. President Clinton opposes term limits. President Clinton opposes a constitutional amendment to balance the budget. President Clinton opposes a voluntary prayer amendment. He opposes an amendment to protect the flag of the United States of America. People give their lives—a couple of servicemen here—they sacrifice, they give everything for America. We ought to protect the American flag with a constitutional amendment. But beyond that, we need to address the economy. And I would just say, with my time running out here, it's a very proud moment for me. And what I want the voters to do is to make a decision. And I want them to be proud of their vote in the years ahead, proud that they voted for the right candidate, proud that they voted, hopefully, for me. And I'll just make you one promise. My word is good. Democrats and Republicans have said Bob Dole's word is good. I keep my word. I promise you, the economy is going to get better, we're going to have a good economic package, and we're going into the next century a better America. Thank you. Mr. Lehrer. Mr. President. The President. Thank you, Jim. And thank you, ladies and gentlemen, and all the people who are watching. One thing I'd like to say is I agree with what Senator Dole said. It's a remarkable thing in a country like ours that a man who grew up in Russell, Kansas, and one who was born to a widowed mother in Hope, Arkansas, could wind up running for President, could have a chance to serve as President. So the first thing I want to say is thank you for giving me the chance to be President. This election is about two different visions about how we should go into the 21st century. Would we be better off—as I believe—working together to give each other the tools we need to make the most of our God-given potential, or are we better off saying, "You're on your own"? Would we be better off building that bridge to the future together so we can all walk across it, or saying, "You can get across yourself"? If you don't leave this room with anything else tonight and if the people watching us don't leave with anything else, I hope you'll leave with this: This is a real important election. The world is changing dramatically in how we work and how we live, how we relate to each other— huge changes. And the decisions we make will have enormous practical consequences. So we've talked about our responsibilities tonight. I want to talk about your responsibility and your responsibility. Your responsibility is to show up on November 5th, because you're going to decide whether we're going to balance the budget now but protect Medicare, Medicaid, education, and the environment. You'll decide whether we're going to keep fighting crime with the Brady bill, the assault weapons, and finish putting those 100,000 police; whether we're going to move a million people from welfare to work; whether we're going to give our families more protection for their kids against drugs and tobacco and gangs and guns; whether we're going to give our children world-class education where every 8-year-old can read, every 12-yearold can log in on the Internet, every 18-yearold can go to college. If we do those things, we'll build that bridge to the 21st century, and the greatest country in history will be even greater. Thank you. Mr. Lehrer. Thank you, Senator. Thank you, Mr. President. This concludes—this is the last of the three 1996 Presidential and Vice Presidential debates.
