# Presidential Debate in Tempe, Arizona

**Date:** October 13, 2004
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-tempe-arizona

---

Bob Schieffer. Good evening from Arizona State University in Tempe, Arizona. I'm Bob Schieffer of CBS News. I want to welcome you to the third and last of the 2004 debates between President George Bush and Senator John Kerry. As Jim Lehrer told you before the first one, these debates are sponsored by the Commission on Presidential Debates. Tonight the topic will be domestic affairs, but the format will be the same as that first debate. I'll moderate our discussion under detailed rules agreed to by the candidates, but the questions and the areas to be covered were chosen by me. I have not told the candidates or anyone else what they are. To refresh your memory on the rules, I will ask a question. The candidate is allowed 2 minutes to answer. His opponent then has a minute and a half to offer a rebuttal. At my discretion, I can extend the discussion by offering each candidate an additional 30 seconds. A green light will come on to signal the candidate has 30 seconds left; a yellow light signals 15 seconds left; a red light means 5 seconds left. There is also a buzzer if it is needed. The candidates may not question each other directly. There are no opening statements, but there will be 2-minute closing statements. There is an audience here tonight, but they have agreed to remain silent, except for right now, when they join me in welcoming President George Bush and Senator John Kerry. Gentlemen, welcome to you both. By coin toss, the first question goes to Senator Kerry. Homeland Security Senator, I want to set the stage for this discussion by asking the question that I think hangs over all of our politics today and is probably on the minds of many people watching this debate tonight, and that is: Will our children and grandchildren ever live in a world as safe and secure as the world in which we grew up? Senator John F. Kerry. Well, first of all, Bob, thank you for moderating tonight. Thank you, Arizona State, for welcoming us. And thank you to the Presidential Commission for undertaking this enormous task. We're proud to be here. Mr. President, I'm glad to be here with you again to share similarities and differences with the American people. Will we ever be safe and secure again? Yes, we absolutely must be. That's the goal. Now, how do we achieve it is the most critical component of it. I believe that this President, regrettably, rushed us into a war, made decisions about foreign policy, pushed alliances away, and as a result, America is now bearing this extraordinary burden where we are not as safe as we ought to be. The measurement is not: Are we safer? The measurement is: Are we as safe as we ought to be? And there are a host of options that this President had available to him, like making sure that at all our ports in America, containers are inspected. Only 95 percent of them—95 percent come in today uninspected. That's not good enough. People who fly on airplanes today—the cargo hold is not X-rayed, but the baggage is. That's not good enough. Firehouses don't have enough firefighters in them. Police officers are being cut from the streets of America because the President decided to cut the COPS program. So we can do a better job of homeland security. I can do a better job of waging a smarter, more effective war on terror and guarantee that we go after the terrorists. I will hunt them down, and we'll kill them. We'll capture them. We'll do what's ever necessary to be safe. But I pledge this to you, America: I will do it in the way that Franklin Roosevelt and Ronald Reagan and John Kennedy and others did, where we build the strongest alliances, where the world joins together, where we have the best intelligence, and where we are able, ultimately, to be more safe and secure. Mr. Schieffer. Mr. President, you have 90 seconds. President Bush. Bob, thank you very much. I want to thank Arizona State as well. Yes, we can be safe and secure if we stay on the offense against the terrorists and if we spread freedom and liberty around the world. I have got a comprehensive strategy to not only chase down Al Qaida, wherever it exists—and we're making progress; three-quarters of Al Qaida leaders have been brought to justice—but to make sure that countries who harbor terrorists are held to account. As a result of securing ourselves and ridding the Taliban out of Afghanistan, the Afghan people had elections this weekend. And the first voter was a 19-year-old woman. Think about that. Freedom is on the march. We held to account a terrorist regime in Saddam Hussein. In other words, in order to make sure we're secure, there must be a comprehensive plan. My opponent, just this weekend, talked about how terrorism could be reduced to a "nuisance," comparing it to prostitution and illegal gambling. I think that attitude and that point of view is dangerous. I don't think you can secure America for the long run if you don't have a comprehensive view as to how to defeat these people. At home, we'll do everything we can to protect the homeland. I signed the homeland security bill to better align our assets and resources. My opponent voted against it. We're doing everything we can to protect our borders and ports. But absolutely, we can be secure in the long run. It just takes good, strong leadership. Mr. Schieffer. Anything to add, Senator Kerry? Senator Kerry. Yes. When the President had an opportunity to capture or kill Usama bin Laden, he took his focus off of him, outsourced the job to Afghan warlords, and Usama bin Laden escaped. Six months after he said, "Usama bin Laden must be caught, dead or alive," this President was asked, "Where is Usama bin Laden?" He said, "I don't know. I don't really think about him very much. I'm not that concerned." We need a President who stays deadly focused on the real war on terror. Mr. Schieffer. Mr. President. President Bush. Gosh, I don't think I ever said I'm not worried about Usama bin Laden. That's kind of one of those exaggerations. Of course, we're worried about Usama bin Laden. We're on the hunt after Usama bin Laden. We're using every asset at our disposal to get Usama bin Laden. My opponent said this war is a matter of intelligence and law enforcement. No, this is a—war is a matter of using every asset at our disposal to keep the American people protected. Flu Vaccine Shortage/Health Care Mr. Schieffer. New question, Mr. President, to you. We're talking about protecting ourselves from the unexpected, but the flu season is suddenly upon us. Flu kills thousands of people every year. Suddenly we find ourselves with a severe shortage of flu vaccine. How did that happen? President Bush. Bob, we relied upon a company out of England to provide about half of the flu vaccines for the United States citizen, and it turned out that the vaccine they were producing was contaminated. And so we took the right action and didn't allow contaminated medicine into our country. We're working with Canada to, hopefully—that they'll produce a—help us realize the vaccine necessary to make sure our citizens have got flu vaccinations during this upcoming season. My call to our fellow Americans is, if you're healthy, if you're younger, don't get a flu shot this year. Help us prioritize those who need to get the flu shot, the elderly and the young. The CDC, responsible for health in the United States, is setting those priorities and is allocating the flu vaccine accordingly. I haven't gotten a flu shot, and I don't intend to, because I want to make sure that those who are most vulnerable get treated. We have a problem with litigation in the United States of America. Vaccine manufacturers are worried about getting sued, and so, therefore, they have backed off from providing this kind of vaccine. One of the reasons I'm such a strong believer in legal reform is so that people aren't afraid of producing a product that is necessary for the health of our citizens and then end up getting sued in a court of law. But the best thing we can do now, Bob, given the circumstances with the company in England, is for those of us who are younger and healthy, don't get a flu shot. Mr. Schieffer. Senator Kerry. Senator Kerry. This really underscores the problem with the American health care system. It's not working for the American family, and it's gotten worse under President Bush over the course of the last years. Five million Americans have lost their health insurance in this country. You got about a million right here in Arizona—just shy, 950,000—who have no health insurance at all. Eighty-two thousand Arizonians lost their health insurance under President Bush's watch. Two hundred and twenty-three thousand kids in Arizona have no health insurance at all. All across our country—go to Ohio, 1.4 million Ohioans have no health insurance; 114,000 of them lost it under President Bush; Wisconsin, 82,000 Wisconsinites lost it under President Bush. This President has turned his back on the wellness of America, and there is no system. In fact, it's starting to fall apart, not because of lawsuits—though they are a problem, and John Edwards and I are committed to fixing them—but because of the larger issue that we don't cover Americans. Children across our country don't have health care. We're the richest country on the face of the planet, the only industrialized nation in the world not to do it. I have a plan to cover all Americans. We're going to make it affordable and accessible. We're going to let everybody buy into the same health care plan the Senators and Congressmen give themselves. Mr. Schieffer. Mr. President, would you like to add something? President Bush. I would, thank you. I want to remind people listening tonight that a plan is not a litany of complaints, and a plan is not to lay out programs that you can't pay for. He just said he wants everybody to be able to buy into the same plan that Senators and Congressman get. That costs the Government $7,700 per family. If every family in America signed up like the Senator suggested, it would cost us $5 trillion over 10 years. It's an empty promise. It's called bait and switch. Mr. Schieffer. Time is up. President Bush. Thank you. Senator Kerry. Actually, it's not an empty promise. It's really interesting because the President used that very plan as a reason for seniors to accept his prescription drug plan. He said, "If it's good enough for the Congressmen and Senators to have choice, seniors ought to have choice." What we do is we have choice. I choose Blue Cross/Blue Shield. Other Senators, other Congressman choose other programs. But the fact is we're going to help Americans be able to buy into it. Those that can afford it are going to buy in themselves. We're not giving this away for nothing. Paying for New Federal Spending/Taxes Mr. Schieffer. All right, Senator Kerry, a new question. Let's talk about economic security. You pledged during the last debate that you would not raise taxes on those making less than $200,000 a year. But the price of everything is going up, and we all know it. Health care costs, as you all are talking about, is skyrocketing, the cost of the war. My question is, how can you or any President, whoever is elected next time, keep that pledge without running this country deeper into debt and passing on more of the bills that we're running up to our children? Senator Kerry. I'll tell you exactly how I can do it: by reinstating what President Bush took away, which is called pay as you go. During the 1990s, we had pay-as-you-go rules. If you were going to pass something in the Congress, you had to show where you were going to pay for it and how. President Bush has taken—he's the only President in history to do this. He's also the only President since—in 72 years to lose jobs, 1.6 million jobs lost. He's the only President to have incomes of families go down for the last 3 years, the only President to see exports go down, the only President to see the lowest level of business investment in our country as it is today. Now, I'm going to reverse that. I'm going to change that. We're going to restore the fiscal discipline we had in the 1990s. Every plan that I have laid out, my health care plan, my plan for education, my plan for kids to be able to get better college loans, I've shown exactly how I'm going to pay for those. And we start—we don't do it exclusively, but we start by rolling back George Bush's unaffordable tax cut for the wealthiest people, people earning more than $200,000 a year, and we pass, hopefully, the McCain/Kerry commission, which identified some $60 billion that we can get. We shut the loophole which has American workers actually subsidizing the loss of their own job. They just passed an expansion of that loophole in the last few days, $43 billion of giveaways, including favors to the oil and gas industry and to people importing ceiling fans from China. I'm going to stand up and fight for the American worker, and I'm going to do it in a way that's fiscally sound. I show how I pay for the health care, how we pay for the education. I have a manufacturing jobs credit. We pay for it by shutting that loophole overseas. We raise the student loans. I pay for it by changing the relationship with the banks. This President has never once vetoed one bill, the first President in 100 years not to do that. Mr. Schieffer. Mr. President. President Bush. Well, his rhetoric doesn't match his record. He's been a Senator for 20 years. He voted to increase taxes 98 times. When they tried to reduce taxes, he voted against that 127 times. He talks about being a fiscal conservative or fiscally sound, but he voted over—he voted 277 times to waive the budget caps, which would have cost the taxpayers $4.2 trillion. He talks about pay-go—I'll tell you what pay-go means when you're a Senator from Massachusetts, when you're a colleague of Ted Kennedy: Pay-go means you pay, and he goes ahead and spends. He's proposed $2.2 trillion of new spending, and yet the so-called tax on the rich, which is also a tax on many small-business owners in America, raises 600 million by our account—billion—800 billion by his account. There is a tax gap. And guess who usually ends up filling the tax gap? The middle class. I proposed a detailed budget, Bob. I sent up my budget man to the Congress, and he says, "Here's how we're going to reduce the deficit in half by 5 years." It requires pro-growth policies that grow our economy and fiscal sanity in the Halls of Congress. Jobs/Education Mr. Schieffer. Let's go to a new question, Mr. President, 2 minutes. And let's continue on jobs. You know, there are all kind of statistics out there, but I want to bring it down to an individual. Mr. President, what do you say to someone in this country who has lost his job to someone overseas who is being paid a fraction of what that job paid here in the United States? President Bush. I say, Bob, "I've got policies to continue to grow our economy and create the jobs of the 21st century, and here's some help for you to go get an education. Here's some help for you to go to a community college. We've expanded trade adjustment assistance. We want to help pay for you to gain the skills necessary to fill the jobs of the 21st century." You know, there's a lot of talk about how to keep the economy growing, and we talk about fiscal matters. But perhaps the best way to keep jobs here in America and to keep this economy growing is to make sure our education system works. I went to Washington to solve problems. And I saw a problem in the public education system in America. They were just shuffling too many kids through the system, year after year, grade after grade, without learning the basics. And so we said, "Let's raise the standards. We're spending more money, but let's raise the standards and measure early and solve problems now, before it's too late." You know, education is how to help the person who has lost a job. Education is how to make sure this—we've got a workforce that's productive and competitive. You got—4 more years, I've got more to do to continue to raise standards, to continue to reward teachers and school districts that are working, to emphasize math and science in the classrooms, to continue to expand Pell grants, to make sure that people have an opportunity to start their career with a college diploma. And so to the person you talked to, I say, "Here's some help. Here's some trade adjustment assistance money for you to go to a community college in your neighborhood, a community college which is providing the skills necessary to fill the jobs of the 21st century." And that's what we'd say to that person. Mr. Schieffer. Senator Kerry. Senator Kerry. I want you to notice how the President switched away from jobs and started talking about education principally. Let me come back in one moment to that, but I want to speak for a second, if I can, to what the President said about fiscal responsibility. Being lectured by the President on fiscal responsibility is a little bit like Tony Soprano talking to me about law and order in this country. [Laughter] This President has taken a $5.6 trillion surplus and turned it into deficits as far as the eye can see. Health care costs for the average American have gone up 64 percent. Tuitions have gone up 35 percent, gasoline prices up 30 percent. Medicare premiums went up 17 percent a few days ago. Prescription drugs are up 12 percent a year. But guess what, America? The wages of Americans have gone down. The jobs that are being created in Arizona right now are paying about $13,700 less than the jobs that we're losing, and the President just walks on by this problem. The fact is that he's cut job training money. A billion dollars was cut. They only added a little bit back this year because it's an election year. They've cut the Pell grants and the Perkins loans to help kids be able to go to college. They've cut the training money. They've wound up not even extending unemployment benefits and not even extending health care to those people who are unemployed. I'm going to do those things because that's what right in America: Help workers to transition in every respect. Outsourcing Jobs Mr. Schieffer. New question to you, Senator Kerry, 2 minutes, and it's still on jobs. You know, many experts say that a President really doesn't have much control over jobs. For example, if someone invents a machine that does the work of five people, that's progress. That's not the President's fault. So I ask you, is it fair to blame the administration entirely for this loss of jobs? Senator Kerry. I don't blame them entirely for it. I blame the President for the things the President could do that has an impact on it. Outsourcing is going to happen. I've acknowledged that in union halls across the country. I've had shop stewards stand up and say, "Will you promise me you're going to stop all this outsourcing?" And I've looked them in the eye and I've said, "No, I can't do that." What I can promise you is that I will make the playing field as fair as possible, that I will, for instance, make certain that with respect to the tax system, that you as a worker in America are not subsidizing the loss of your job. Today, if you're an American business, you actually get a benefit for going overseas. You get to defer your taxes. So if you're looking at a competitive world, you say to yourself, "Hey, I do better overseas than I do here in America." That's not smart. I don't want American workers subsidizing the loss of their own job. And when I'm President, we're going to shut that loophole in a nanosecond, and we're going to use that money to lower corporate tax rates in America for all corporations 5 percent. And we're going to have a manufacturing jobs credit and a job hiring credit so we actually help people be able to hire here. The second thing that we can do is provide a fair trade playing field. This President didn't stand up for Boeing when Airbus was violating international rules with subsidies. He discovered Boeing during the course of this campaign after I've been talking about it for months. The fact is that the President had an opportunity to stand up and take on China for currency manipulation. There are companies that wanted to petition the administration. They were told, "Don't even bother. We're not going to listen to it." The fact is that there have been markets shut to us that we haven't stood up and fought for. I'm going to fight for a fair trade playing field for the American worker. And I will fight for the American worker just as hard as I fight for my own job. That's what the American worker wants. And if we do that, we can have an impact. Plus, we need fiscal discipline. Restore fiscal discipline, we'll do a lot better. Mr. Schieffer. Mr. President. President Bush. Whoo! Let me start with the Pell grants. In his last litany of misstatements, he said we cut Pell grants. We've increased Pell grants by a million students. That's a fact. Here he talks to the workers; let me talk to the workers. You got more money in your pocket as a result of the tax relief we passed and he opposed. If you have a child, you got a $1,000 child credit. That's money in your pocket. If you're married, we reduced the marriage penalty. The code ought to encourage marriage, not discourage marriage. We created a 10-percent bracket to help lower income Americans. A family of four making 40,000 received about $1,700 in tax relief. It's your money. The way my opponent talks, he said we're going to spend the Government's money. No, we're spending your money. And when you have more money in your pocket, you're able to better afford things you want. I believe the role of Government is to stand side by side with our citizens to help them realize their dreams, not tell citizens how to live their lives. My opponent talks about fiscal sanity. His record in the United States Senate does not match his rhetoric. He voted to increase taxes 98 times and to bust the budget 277 times. Mr. Schieffer. Senator Kerry. Senator Kerry. Bob, anybody can play with these votes; everybody knows that. I have supported or voted for tax cuts over 600 times. I broke with my party in order to balance the budget, and Ronald Reagan signed into law the tax cut that we voted for. I voted for IRA tax cuts. I voted for small-business tax cuts. But you know why the Pell grants have gone up in their numbers? Because more people qualified for them, because they don't have money. But they're not getting the $5,100 the President promised them. They're getting less money. There are more people who qualify. That's not what we want. President Bush. Senator, no one is playing with your votes. You voted to increase taxes 98 times. When they voted—when they proposed reducing taxes, you voted against it 126 times. You voted to violate the budget caps 277 times. You know, there's a mainstream in American politics. You sit right on the far left bank. As a matter of fact, your record is such that Ted Kennedy, your colleague, is the conservative Senator from Massachusetts. Same-Sex Marriage Mr. Schieffer. Mr. President, let's get back to economic issues. But let's shift to some other questions here. Both of you are opposed to gay marriage. But to understand how you have come to that conclusion, I want to ask you a more basic question. Do you believe homosexuality is a choice? President Bush. You know, Bob, I don't know. I just don't know. I do know that we have a choice to make in America, and that is to treat people with tolerance and respect and dignity. It's important that we do that. I also know, in a free society, people, consenting adults, can live the way they want to live. And that's to be honored. But as we respect someone's rights and as we profess tolerance, we shouldn't change—or have to change our basic views on the sanctity of marriage. I believe in the sanctity of marriage. I think it's very important that we protect marriage as an institution between a man and a woman. I proposed a constitutional amendment. The reason I did so was because I was worried that activist judges are actually defining the definition of marriage. And the surest way to protect marriage between a man and woman is to amend the Constitution. It has also the benefit of allowing citizens to participate in the process. After all, when you amend the Constitution, State legislatures must participate in the ratification of the Constitution. I'm deeply concerned that judges are making those decisions and not the citizenry of the United States. You know, Congress passed a law called DOMA, the Defense of Marriage Act. My opponent was against it. It basically protected States from the action of one State to another. It also defined marriage as between a man and a woman. But I'm concerned that that will get overturned, and if it gets overturned, then we'll end up with marriage being defined by courts. And I don't think that's in our Nation's interest. Mr. Schieffer. Senator Kerry. Senator Kerry. We're all God's children, Bob, and I think if you were to talk to Dick Cheney's daughter, who is a lesbian, she would tell you that she's being who she was. She's being who she was born as. I think if you talk to anybody, it's not choice. I've met people who've struggled with this for years, people who were in a marriage because they were living a sort of convention, and they struggled with it. And I've met wives who are supportive of their husbands, or vice versa, when they finally sort of broke out and allowed themselves to live who they were, who they felt God had made them. I think we have to respect that. The President and I share the belief that marriage is between a man and a woman. I believe that. I believe marriage is between a man and a woman. But I also believe that because we are the United States of America, we're a country with a great, unbelievable Constitution, with rights that we afford people, that you can't discriminate in the workplace. You can't discriminate in the rights that you afford people. You can't disallow someone the right to visit their partner in a hospital. You have to allow people to transfer property, which is why I'm for partnership rights and so forth. Now, with respect to DOMA and the marriage laws, the States have always been able to manage those laws, and they're proving today, every State, that they can manage them adequately. Abortion Mr. Schieffer. Senator Kerry, a new question for you. The New York Times reports that some Catholic archbishops are telling their church members that it would be a sin to vote for a candidate like you because you support a woman's right to choose an abortion and unlimited stem cell research. What is your reaction to that? Senator Kerry. I respect their views. I completely respect their views. I am a Catholic, and I grew up learning how to respect those views. But I disagree with them, as do many. I believe that I can't legislate or transfer to another American citizen my article of faith. What is an article of faith for me is not something that I can legislate on somebody who doesn't share that article of faith. I believe that choice is a woman's choice. It's between a woman, God, and her doctor, and that's why I support that. Now, I will not allow somebody to come in and change Roe v. Wade. The President has never said whether or not he would do that, but we know from the people he's tried to appoint to the court, he wants to. I will not. I will defend the right of Roe v. Wade. Now, with respect to religion, you know, as I said, I grew up a Catholic. I was an altar boy. I know that throughout my life, this has made a difference to me. And as President Kennedy said when he ran for President, he said, "I'm not running to be a Catholic President. I'm running to be a President who happens to be Catholic." Now, my faith affects everything that I do and choose. There's a great passage of the Bible that says, "What does it mean, my brother, to say you have faith, if there are no deeds? Faith without works is dead." And I think that everything you do in public life has to be guided by your faith, affected by your faith, but without transferring it in any official way to other people. That's why I fight against poverty. That's why I fight to clean up the environment and protect this Earth. That's why I fight for equality and justice. All of those things come out of that fundamental teaching and belief of faith. But I know this, that President Kennedy, in his Inaugural Address, told all of us that, "Here on Earth, God's work must truly be our own." And that's what we have to—so I think that's the test of public service. Mr. Schieffer. Mr. President. President Bush. I think it's important to promote a culture of life. I think a hospitable society is a society where every being counts and every person matters. I believe the ideal world is one in which every child is protected in law and welcomed to life. I understand there's great differences on this issue of abortion, but I believe reasonable people can come together and put good law in place that will help reduce the number of abortions. Take, for example, the ban on partial-birth abortion. It's a brutal practice. People from both political parties came together in the Halls of Congress and voted overwhelmingly to ban that practice. It made a lot of sense. My opponent, in that he's out of the mainstream, voted against that law. What I'm saying is, is that as we promote life and promote a culture of life, surely there are ways we can work together to reduce the number of abortions: Continue to promote adoption laws—that's a great alternative to abortion; continue to fund and promote maternity group homes. I will continue to promote abstinence programs. At the last debate, my opponent said his wife was involved with those programs. That's great, and I appreciate that very much. All of us ought to be involved with programs that provide a viable alternative to abortion. Health Care Costs Mr. Schieffer. Mr. President, let's have a new question. It goes to you, and let's get back to economic issues. Health insurance costs have risen over 36 percent over the last 4 years, according to the Washington Post. We're paying more; we're getting less. I would like to ask you, who bears responsibility for this? Is it the Government? Is it the insurance companies? Is it the lawyers? Is it the doctors? Is it the administration? President Bush. Gosh, I sure hope it's not the administration. [Laughter] No, there is a—look, there's a systemic problem. Health care costs are on the rise because the consumers are not involved in the decisionmaking process. Most health care costs are covered by third parties, and therefore, the actual user of health care is not the purchaser of health care. And there's no market forces involved with health care. It's one of the reasons I'm a strong believer in what they call health savings accounts. These are accounts that allow somebody to buy a low-premium, high-deductible catastrophic plan and couple it with tax-free savings. Businesses can contribute; employees can contribute on a contractual basis. But this is a way to make sure people are actually involved with the decisionmaking process on health care. Secondly, I do believe the lawsuits—I don't believe, I know—that the lawsuits are causing health care costs to rise in America. That's why I'm such a strong believer in medical liability reform. At the last debate, my opponent said, "Well, they only—these lawsuits only cause costs to go up by one percent." Well, he didn't include the defensive practice of medicine that costs the Federal Government some $28 billion a year and costs our society between 60 and 100 billion dollars a year. Thirdly, one of the reasons why there's still high costs in medicine is because this is the—they don't use information technology. It's like if you looked at the—it's the equivalent of the buggy-and-horse days compared to other industries here in America. And so we've got to introduce high technology into health care. We're beginning to do it. We're changing the language. We want there to be electronic medical records to cut down on error as well as to reduce costs. People tell me that when the health care field is fully integrated with information technology, it will wring some 20 percent of the costs out of the system. And finally, moving generic drugs to the market quicker. So, those are four ways to help control the costs in health care. Mr. Schieffer. Senator Kerry. Senator Kerry. The reason health care costs are getting higher—one of the principal reasons is that this administration has stood in the way of commonsense efforts that would have reduced the costs. Let me give you a prime example. In the Senate, we passed the right of Americans to import drugs from Canada. But the President and his friends took it out in the House, and now you don't have that right. The President blocked you from the right to have less expensive drugs from Canada. We also wanted Medicare to be able to negotiate bulk purchasing. The VA does that. The VA provides lower cost drugs to our veterans. We could have done that in Medicare. Medicare is paid for by the American taxpayer. Medicare belongs to you. Medicare is for seniors who are— many of them—on fixed income, to lift them out of poverty. But rather than help you, the taxpayer, have lower cost, rather than help seniors have less expensive drugs, the President made it illegal—illegal—for Medicare to actually go out and bargain for lower prices. Result: $139 billion windfall profit to the drug companies coming out of your pockets. That's a large part of your 17-percent increase in Medicare premiums. When I'm President, I'm sending that back to Congress, and we're going to get a real prescription drug benefit. Now, we also have people sicker because they don't have health insurance. So whether it's diabetes or cancer, they come to the hospitals later, and it costs America more. We've got to have health care for all Americans. Mr. Schieffer. Go ahead, Mr. President. President Bush. I think it's important, since he talked about the Medicare plan— he's been in the United States Senate for 20 years. He has no record on reforming of health care, no record at all. He introduced some 300 bills, and he's passed 5— no record of leadership. I came to Washington to solve problems. I was deeply concerned about seniors having to choose between prescription drugs and food, and so I led. And in 2006, our seniors will get a prescription drug coverage in Medicare. Mr. Schieffer. Senator Kerry, 30 seconds. Senator Kerry. Once again, the President is misleading America. I've actually passed 56 individual bills that I've personally written. And in addition to that, they're not always under my name; there is amendments on certain bills. But more importantly, with respect to the question of "no record," I helped write—I did write—I was one of the original authors of the early childhood health care and the expansion of health care that we did in the middle of the 1990s. And I'm very proud of that. So the President's wrong. Senator's Health Care Plan Mr. Schieffer. Let me direct the next question to you, Senator Kerry, and again, let's stay on health care. You have, as you have proposed and as the President has commented on tonight, proposed a massive plan to extend health care coverage to children. You're also talking about the Government picking up a big part of the catastrophic bills that people get at the hospital. And you have said that you can pay for this by rolling back the President's tax cut on the upper two percent. Senator Kerry. That's correct. Mr. Schieffer. You heard the President say earlier tonight that it's going to cost a whole lot more money than that. I just ask you, where are you going to get the money? Senator Kerry. Well, two leading national news networks have both said the President's characterization of my health care plan is incorrect. One called it fiction. The other called it untrue. The fact is that my health care plan, America, is very simple. It gives you the choice. I don't force you to do anything. It's not a Government plan. The Government doesn't require you to do anything. You choose your doctor. You choose your plan. If you don't want to take the offer of the plan that I want to put forward, you don't have to. You can keep what you have today, keep a high deductible, keep high premiums, keep a high co-pay, keep low benefits. But I got a better plan, and I don't think a lot of people are going to want to keep what they have today. Here's what I do. We take over Medicaid children from the States so that every child in America is covered. And in exchange, if the States want to—they're not forced to; they can choose to—they cover individuals up to 300 percent of poverty. It's their choice. I think they'll choose it, because it's a net plus of $5 billion to them. We allow you—if you choose to; you don't have to—but we give you broader competition to allow you to buy into the same health care plan that Senators and Congressmen give themselves. If it's good enough for us, it's good enough for every American. I believe that your health care is just as important as any politician in Washington, DC. If you want to buy into it, you can. We give you broader competition. That helps lower prices. In addition to that, we're going to allow people 55 to 64 to buy into Medicare early. And most importantly, we give small business a 50-percent tax credit so that after we lower the cost of health care, they also get, whether they're self-employed or a small business, a lower cost to be able to cover their employees. Now, what happens is, when you begin to get people covered like that—for instance, in diabetes, if you diagnose diabetes early, you could save $50 billion in the health care system of America by avoiding surgery and dialysis. It works, and I'm going to offer it to America. Mr. Schieffer. Mr. President. President Bush. In all due respect, I'm not so sure it's credible to quote leading news organizations about—well, never mind. Anyway—[laughter]—let me quote the Lewin report. The Lewin report is a group of folks who are not politically affiliated. They analyzed the Senator's plan. It costs $1.2 trillion. The Lewin report accurately noted that there are going to be 20 million people—over 20 million people added to Government-controlled health care. It will be the largest increase in Government health care ever. If you raise the Medicaid to 300 percent, it provides an incentive for small businesses not to provide private insurance to their employees. Why should they insure somebody when the Government is going to insure for them? It's estimated that 8 million people will go from private insurance to Government insurance. We have a fundamental difference of opinion. I think Government-run health will lead to poor quality health, will lead to rationing, will lead to less choice. Once a health care program ends up in a line item in the Federal Government budget, it leads to more controls. And just look at other countries that have tried to have federally controlled health care. They have poor quality health care. Our health care system is the envy of the world because we believe in making sure that the decisions are made by doctors and patients, not by officials in the Nation's Capital. Mr. Schieffer. Senator. Senator Kerry. The President just said that Government-run health care results in poor quality. Now, maybe that explains why he hasn't fully funded the VA, and the VA hospital is having trouble, and veterans are complaining. Maybe that explains why Medicare patients are complaining about being pushed off of Medicare—he doesn't adequately fund it. But let me just say to America, I am not proposing a Government-run program. That's not what I have. I have Blue Cross/Blue Shield. Senators and Congressmen have a wide choice. Americans ought to have it too. Mr. Schieffer. Mr. President. President Bush. You talk about the VA. We've increased VA funding by 22 billion in the 4 years since I've been President. That's twice the amount that my predecessor increased VA funding. Of course, we're meeting our obligation to our veterans, and the veterans know that. We're expanding veterans' health care throughout the country. We're aligning facilities where the veterans live now. Veterans are getting very good health care under my administration, and they will continue to do so during the next 4 years. Social Security Mr. Schieffer. Mr. President, the next question is to you. We all know that Social Security is running out of money, and it has to be fixed. You have proposed to fix it by letting people put some of the money collected to pay benefits into private savings accounts. But the critics are saying that's going to mean finding a trillion dollars over the next 10 years to continue paying benefits as those accounts are being set up. So where do you get the money? Are you going to have to increase the deficit by that much over 10 years? President Bush. Bob, first let me make sure that every senior listening today understands that when we're talking about reforming Social Security, that they'll still get their checks. I remember the 2000 campaign; people said, "If George W. gets elected, your check will be taken away." Well, people got their checks, and they will continue to get their checks. There is a problem for our youngsters, a real problem, and if we don't act today, the problem will be valued in the trillions. And so I think we need to think differently. We'll honor our commitment to our seniors, but for young—for our children and our grandchildren, we need to have a different strategy. In recognizing that, I called together a group of our fellow citizens to study the issue. It was a committee chaired by the late Senator Daniel Patrick Moynihan of New York, a Democrat. And they came up with a variety of ideas for people to look at. I believe that younger workers ought to be allowed to take some of their own money and put it in a personal savings account, because I understand that they need to get better rates of return than the rates of return being given in the current Social Security trust. And the compounding rate of interest effect will make it more likely that the Social Security system is solvent for our children and our grandchildren. I will work with Republicans and Democrats. This will be a vital issue in my second term. It is an issue that I'm willing to take on. And so I'll bring Republicans and Democrats together, and we're of course going to have to consider the costs. But I want to warn my fellow citizens the cost of doing nothing, the cost of saying the current system is okay, far exceeds the cost of trying to make sure we save the system for our children. Mr. Schieffer. Senator Kerry. Senator Kerry. You just heard the President say that young people ought to be able to take money out of Social Security and put it in their own accounts. Now, my fellow Americans, that's an invitation to disaster. The CBO said very clearly that if you were to adopt the President's plan, there will be a $2 trillion hole in Social Security, because today's workers pay into the system for today's retirees. And the CBO said—that's the Congressional Budget Office; it's bipartisan—they said that there would have to be a cut in benefits of 25 to 40 percent. Now, the President has never explained to America—ever; hasn't done it tonight— where does the transitional money, that $2 trillion, come from? He's already got $3 trillion, according to the Washington Post, of expenses that he's put on the line from his convention and the promises of this campaign, none of which are paid for— not one of them are paid for. The fact is that the President is driving the largest deficits in American history. He's broken the pay-as-you-go rules. I have a record of fighting for fiscal responsibility. In 1985, I was one of the first Democrats— broke with my party—we balanced the budget in the nineties. We paid down the debt for 2 years. And that's what we're going to do. We're going to protect Social Security. I will not privatize it. I will not cut the benefits. And we're going to be fiscally responsible, and we will take care of Social Security. Mr. Schieffer. Let me just stay on Social Security with a new question for Senator Kerry, because Senator Kerry, you have just said you will not cut benefits. Alan Green-span, the Chairman of the Federal Reserve, says there's no way that Social Security can pay retirees what we have promised them unless we recalibrate. What he's suggesting, we're going to have to cut benefits or we're going to have to raise retirement age; we may have to take some other reform. But if you've just said you've promised no changes, does that mean you're just going to leave this as a problem, another problem, for our children to solve? Senator Kerry. Not at all. Absolutely not, Bob. This is the same thing we heard— I remember I appeared on "Meet the Press" with Tim Russert in 1990-something—we heard the same thing. We fixed it. In fact, we put together a $5.6 trillion surplus in the nineties that was for the purpose of saving Social Security. If you take the tax cut that the President of the United States has given—President Bush gave to Americans in the top 1 percent of America, just that tax cut that went to the top 1 percent of America would have saved Social Security until the year 2075. The President decided to give it to the wealthiest Americans in a tax cut. Now, Alan Greenspan, who I think has done a terrific job in monetary policy, supports the President's tax cut. I don't. I support it for the middle class, not that part of it that goes to people earning more than $200,000 a year. And when I roll it back and we invest in the things that I've talked about to move our economy, we're going to grow sufficiently that we begin to cut the deficit in half, and we get back to where we were at the end of the 1990s when we balanced the budget and paid down the debt of this country. Now, we can do that. Now, if later on, after a period of time, we find that Social Security is in trouble, then we'll pull together the top experts of the country. We'll do exactly what we did in the 1990s, and we'll make whatever adjustment is necessary. But the first and most important thing is to start creating jobs in America. The jobs the President is creating pay $9,000 less than the jobs that we're losing. And this is the first President in 72 years to preside over an economy in America that has lost jobs—1.6 million jobs. Eleven other Presidents—six Democrats and five Republicans—had wars, had recessions, had great difficulties. None of them lost jobs the way this President has. I have a plan to put America back to work. And if we're fiscally responsible and put America back to work, we're going to fix Social Security. Mr. Schieffer. Mr. President. President Bush. He forgot to tell you he voted to tax Social Security benefits more than one time. I didn't hear any plan to fix Social Security. I heard more of the same. He talks about middle-class tax cuts; that's exactly where the tax cuts went. Most of the tax cuts went to low- and middle-income Americans. And now the Tax Code is more fair; 20 percent of the upper income people pay about 80 percent of the taxes in America today because of how we structured the tax cuts. People listening out there know the benefits of the tax cuts we passed. If you have a child, you got tax relief. If you're married, you got tax relief. If you pay any tax at all, you got tax relief, all of which was opposed by my opponent. And the tax relief was important to spur consumption and investment to get us out of this recession. People need to remember, 6 months prior to my arrival, the stock market started to go down, and it was one of the largest declines in our history. And then we had a recession, and we got attacked, which cost us one million jobs. But we acted. I led the Congress. We passed tax relief. And now this economy is growing. We added 1.9 million new jobs over the last 13 months. Sure, there's more work to do. But the way to make sure our economy grows is not to raise taxes on small-business owners. It's not to increase the scope of the Federal Government. It's to make sure we have fiscal sanity and keep taxes low. Immigration/Border Security Mr. Schieffer. Let's go to a new question, Mr. President. I got more e-mail this week on this question than any other question, and it is about immigration. I'm told that at least 8,000 people cross our borders illegally every day. Some people believe this is a security issue, as you know. Some believe it's an economic issue. Some see it as a human rights issue. How do you see it, and what do we need to do about it? President Bush. I see it as a serious problem. I see it as a security issue; I see it as an economic issue; and I see it as a human rights issue. We're increasing the border security of the United States. We've got 1,000 more Border Patrol agents on the southern border. We're using new equipment. We're using unmanned vehicles to spot people coming across, and we'll continue to do so over the next 4 years. This is a subject I'm very familiar with. After all, I was a border Governor for a while. Many people are coming to this country for economic reasons. They're coming here to work. If you can make 50 cents in the heart of Mexico, for example, or make $5 here in America—5.15—you're going to come here if you're worth your salt, if you want to put food on the table for your families. And that's what's happening. And so, in order to take pressure off the border, in order to make the borders more secure, I believe there ought to be a temporary-worker card that allows a willing worker and a willing employer to mate up—so long as there's not an American willing to do the job—to join up in order to be able to fulfill the employer's needs. That has the benefit of making sure our employers aren't breaking the law as they try to fill their workforce needs. It makes sure that the people coming across the border are humanely treated, that they're not kept in the shadows of our society, that they're able to go back and forth to see their families. See, the card will have a period of time attached to it. It also means it takes pressure off the border. If somebody is coming here to work with a card, it means they're not going to have to sneak across the border. It means our Border Patrol will be more likely to be able to focus on doing their job. Now, it's very important for our citizens to also know that I don't believe we ought to have amnesty. I don't think we ought to reward illegal behavior. There are plenty of people standing in line to become a citizen, and we ought not to crowd these people ahead of them in line. If they want to become a citizen, they can stand in line too. And here's where my opponent and I differ. In September 2003, he supported amnesty for illegal aliens. Mr. Schieffer. Time's up. Senator. Senator Kerry. Let me just answer one part of that last question quickly, and then I'll come to immigration. The American middle-class family isn't making it right now, Bob, and what the President said about the tax cuts have been wiped out by the increase in health care, the increase in gasoline, the increase in tuitions, the increase in prescription drugs. The fact is the take-home pay of a typical American family as a share of national income is lower than it's been since 1929. And the take-home pay of the richest 1 percent of Americans is the highest it's been since 1928. Under President Bush, the middle class has seen their tax burden go up, and the wealthiest tax burden has gone down. Now, that's wrong. Now, with respect to immigration reform, the President broke his promise on immigration reform. He said he would reform it. Four years later, he's now promising another plan. Here's what I'll do. Number one, the borders are more leaking today than they were before 9/11. The fact is we haven't done what we need to do to toughen up our borders, and I will. Secondly, we need a guest-worker program, but if it's all we have, it's not going to solve the problem. The second thing we need is to crack down on illegal hiring. It's against the law in the United States to hire people illegally, and we ought to be enforcing that law properly. And thirdly, we need an earned legalization program for people who've been here for a long time, stayed out of trouble, got a job, paid their taxes, and their kids are American. We've got to start moving them toward full citizenship, out of the shadows. Mr. Schieffer. Do you want to respond, Mr. President? President Bush. Well, to say that the borders are not as protected as they were prior to September the 11th shows he doesn't know the borders. They're much better protected today than they were when I was the Governor of Texas. We've got much more manpower, much more equipment there. He just doesn't understand how the borders work, evidently, to say that. That is an outrageous claim. And we'll continue to protect our borders. We'll continue to increase manpower and equipment. Mr. Schieffer. Senator. Senator Kerry. Four thousand people a day are coming across the border. The fact is that we now have people from the Middle East—allegedly—coming across the border. And we're not doing what we ought to do in terms of the technology. We have iris identification technology. We have thumbprint, fingerprint technology today. We can know who the people are, that they're really the people they say they are, when they cross the border. We could speed it up. There are huge delays. The fact is, our borders are not as secure as they ought to be, and I'll make them secure. Minimum Wage/Education/Jobs Mr. Schieffer. Next question to you, Senator Kerry. The gap between rich and poor is growing wider. More people are dropping into poverty. Yet the minimum wage has been stuck at, what, $5.15 an hour now for about 7 years. Is it time to raise it? Senator Kerry. Well, I'm glad you raised that question. It's long-overdue time to raise the minimum wage. And America, this is one of those issues that separates the President and myself. We have fought to try to raise the minimum wage in the last years. But the Republican leadership of the House and Senate won't even let us have a vote on it. We're not allowed to vote on it. They don't want to raise the minimum wage. The minimum wage is the lowest minimum wage value it has been in our Nation in 50 years. If we raise the minimum wage, which I will do over several years to $7 an hour, 9.2 million women who are trying to raise their families would earn another $3,800 a year. The President has denied 9.2 million women $3,800 a year, but he doesn't hesitate to fight for $136,000 to a millionaire. One percent of America got $89 billion last year in a tax cut. But people working hard, playing by the rules, trying to take care of their kids—family values that we're supposed to value so much in America—I'm tired of politicians who talk about family values and don't value families. What we need to do is raise the minimum wage. We also need to hold onto equal pay. Women work for 76 cents on the dollar for the same work that men do. That's not right in America. And we have an initiative that we were working on to raise women's pay. They've cut it off. They've stopped it. They don't enforce these kinds of things. I think that it is a matter of fundamental right that if we raise the minimum wage, 15 million Americans would be positively affected. We'd put money into the hands of people who work hard, who obey the rules, who play for the American Dream. And if we did that, we'd have more consumption ability in America, which is what we need right now in order to kick our economy into gear. I will fight tooth and nail to pass the minimum wage. Mr. Schieffer. Mr. President. President Bush. Actually, Mitch McConnell had a minimum wage plan that I supported that would have increased the minimum wage. But let me talk about what's really important for the worker you're referring to, and that's to make sure the education system works, is to make sure we raise standards. Listen, the No Child Left Behind Act is really a jobs act when you think about it. The No Child Left Behind Act says, "We'll raise standards. We'll increase Federal spending, but in return for extra spending, we now want people to measure—States and local jurisdictions to measure, to show us whether or not a child can read or write or add and subtract." You cannot solve a problem unless you diagnose the problem, and we weren't diagnosing problems. And therefore, just kids were being shuffled through the school. And guess who would get shuffled through? Children whose parents wouldn't speak English as first language, just moved through; many inner-city kids, just moved through. We've stopped that practice now by measuring early, and when we find a problem, we spend extra money to correct it. I remember a lady in Houston, Texas, telling me reading is the new civil right. And she's right. In order to make sure people have jobs for the 21st century, we've got to get it right in the education system. And we're beginning to close a minority achievement gap now. You see, we'd never be able to compete in the 21st century unless we have an education system that doesn't quit on children, an education system that raises standards, an education that makes sure there's excellence in every classroom. Judicial Nominations/Education Funding Mr. Schieffer. Mr. President, I want to go back to something Senator Kerry said earlier tonight and ask a followup of my own. He said—and this will be a new question to you—he said that you had never said whether you would like to overturn Roe v. Wade. So I'd ask you directly, would you like to? President Bush. What he's asking me is will I have a litmus test for my judges, and the answer is no, I will not have a litmus test. I will pick judges who will interpret the Constitution, but I'll have no litmus test. Mr. Schieffer. Senator Kerry, you'd like to respond? Senator Kerry. Is that a new question, or a 30-second question? Mr. Schieffer. That's a new question for President Bush. Senator Kerry. Which time limit are we—— Mr. Schieffer. You have 90 seconds. Senator Kerry. Thank you very much. Well, again, the President didn't answer the question. I will answer it straight to America. I'm not going to appoint a judge to the court who is going to undo a constitutional right, whether it's the first amendment or the fifth amendment or some other right that's given under our courts today— under the Constitution. And I believe that the right of choice is a constitutional right. So, I don't intend to see it undone. Clearly, the President wants to leave an ambivalence or intends to undo it. Let me go a step further. We have a long distance yet to travel in terms of fairness in America. I don't know how you can govern in this country when you look at New York City and you see that 50 percent of the black males there are unemployed, when you see 40 percent of Hispanic children, of black children in some cities dropping out of high school. And yet the President, who talks about No Child Left Behind, refused to fully fund—by $28 billion—that particular program, so you can make a difference in the lives of those young people. Now, right here in Arizona, that difference would have been $131 million to the State of Arizona to help its kids be able to have better education and to lift the property tax burden from its citizens. The President reneged on his promise to fund No Child Left Behind. He will tell you he's raised the money, and he has, but he didn't put in what he promised. And that makes a difference in the lives of our children. Mr. Schieffer. Yes, sir. President Bush. Two things: One, he clearly has a litmus test for his judges, which I disagree with. And secondly, only a liberal Senator from Massachusetts would say that a 49-percent increase in funding for education was not enough. We've increased funds, but more importantly, we've reformed the system to make sure that we solve problems early, before they're too late. He talked about the unemployed. Absolutely, we've got to make sure they get educated. He talked about children whose parents don't speak English as a first language. Absolutely, we've got to make sure they get educated. And that's what the No Child Left Behind Act does. Mr. Schieffer. Senator. Senator Kerry. You don't measure it by a percentage increase. Mr. President, you measure it by whether you're getting the job done. Five hundred thousand kids lost after-school programs because of your budget. Now, that's not in my gut. That's not my value system—and certainly not so that the wealthiest people in America can walk away with another tax cut: $89 billion last year to the top 1 percent of Americans, but kids lost their after-school programs. You be the judge. Addressing the Needs of the Military Mr. Schieffer. All right, let's go to another question, and it is to Senator Kerry. You have 2 minutes, sir. Senator, at the last debate, President Bush said he did not favor a draft. You agreed with him. But our National Guard and Reserve forces are being severely strained because many of them are being held beyond their enlistments. Some of them say that it's a back-door draft. Is there any relief that could be offered to these brave Americans and their families? If you became President, Senator Kerry, what would you do about this situation of holding National Guard and Reservists for these extended periods of time and these repeated callups that they're now facing? Senator Kerry. Well, I think the fact that they're facing these repeated callups, some of them two and three deployments, and there's a stop-loss policy that prevents people from being able to get out when their time was up, is a reflection of the bad judgment this President exercised in how he has engaged in the world and deployed our forces. Our military is overextended. Nine out of ten Active Duty Army divisions are either in Iraq, going to Iraq, or have come back from Iraq. One way or the other, they're wrapped up in it. Now, I've proposed adding two active-duty divisions to the Armed Forces of the United States, one combat, one support. In addition, I'm going to double the number of special forces so that we can fight a more effective war on terror with less pressure on the National Guard and Reserve. And what I would like to do is see the National Guard and Reserve be deployed differently here in our own country. There's much we can do with them with respect to homeland security. We ought to be doing that, and that would relieve an enormous amount of pressure. But the most important thing to relieve the pressure on all of our Armed Forces is, frankly, to run a foreign policy that recognizes that America is strongest when we are working with real alliances, when we are sharing the burdens of the world by working through our statesmanship at the highest levels and our diplomacy to bring other nations to our side. I've said it before; I say it again: I believe the President broke faith with the American people in the way that he took this Nation to war. He said he would work through the—a real alliance. He said in Cincinnati, "We would plan carefully. We would take every precaution." Well, we didn't, and the result is our forces today are overextended. The fact is that he did not choose to go to war as a last resort. And America now is paying already 120 billion, up to 200 billion before we're finished and much more, probably, and that is the result of this President taking his eye off of Usama bin Laden. Mr. Schieffer. Mr. President. President Bush. The best way to take the pressure off our troops is to succeed in Iraq, is to train Iraqis so they can do the hard work of democracy, is to give them a chance to defend their country, which is precisely what we're doing. We'll have 125,000 troops trained by the end of this year. I remember going on an airplane in Bangor, Maine, to say thanks to the Reservists and Guard that were headed overseas from Tennessee and North Carolina and Georgia. Some of them had been there before. The people I talked to, the spirits were high. They didn't view their service as a backdoor draft. They view their service as an opportunity to serve their country. My opponent, the Senator, talks about foreign policy. In our first debate, he proposed America pass a "global test." In order to defend ourselves, we have to get international approval. That's one of the major differences we have about defending our country. I work with allies. I work with friends. We'll continue to build strong coalitions. But I will never turn over our national security decisions to leaders of other countries. We'll be resolute. We'll be strong, and we will wage a comprehensive war against the terrorists. Mr. Schieffer. Senator. Senator Kerry. I have never suggested a test where we turn over our security to any nation. In fact, I've said the opposite. I will never turn the security of the United States over to any nation. No nation will ever have a veto over us. But I think it makes sense—I think most Americans in their guts know that we ought to pass a sort of truth standard. That's how you gain legitimacy with your own countrypeople, and that's how you gain legitimacy in the world. But I will never fail to protect the United States of America. President Bush. In 1990, there was a vast coalition put together to run Saddam Hussein out of Kuwait. The international community, the international world, said this is the right thing to do. But when it came time to authorize the use of force on the Senate floor, my opponent voted against the use of force. Apparently, you can't pass any test under his vision of the world. Assault Weapons Ban Mr. Schieffer. Mr. President, new question, 2 minutes. You said that if Congress would vote to extend the ban on assault weapons, that you'd sign the legislation. But you did nothing to encourage the Congress to extend it. Why not? President Bush. Actually, I made my intentions—I made my views clear. I did think we ought to extend the assault weapons ban and was told the fact that the bill was never going to move because Republicans and Democrats were against the assault weapon ban, people of both parties. Now, I believe law-abiding citizens ought to be able to own a gun. I believe in background checks at gun shows or anywhere to make sure that guns don't get in the hands of people that shouldn't have them. But the best way to protect our citizens from guns is to prosecute those who commit crimes with guns. And that's why, early in my administration, I called the Attorney General and the U.S. attorneys and said, "Put together a task force all around the country to prosecute those who commit crime with guns." And the prosecutions are up by about 68 percent, I believe is the number. Neighborhoods are safer when we crack down on people who commit crimes with guns. To me, that's the best way to secure America. Mr. Schieffer. Senator. Senator Kerry. I believe it was a failure of Presidential leadership not to reauthorize the assault weapons ban. I am a hunter. I'm a gun owner. I've been a hunter since I was a kid, 12, 13 years old. And I respect the second amendment, and I will not tamper with the second amendment. But I'll tell you this. I'm also a former law enforcement officer. I ran one of the largest district attorney offices in America, one of the 10 largest. I've put people behind bars for the rest of their life. I've broken up organized crime. I know something about prosecuting. And most of the law enforcement agencies in America wanted that assault weapons ban. They don't want to go into a drug bust and be facing an AK-47. I was hunting in Iowa last year with the sheriff from one of the counties there, and he pointed to a house in back of us and said, "See that house over there? We just did a drug bust a week earlier, and the guy we arrested had an AK-47 lying on the bed right beside him." Because of the President's decision today, law enforcement officers will walk into a place that will be more dangerous. Terrorists can now come into America and go to a gun show and, without even a background check, buy an assault weapon today. And that's what Usama bin Laden's handbook said, because we captured it in Afghanistan, and it encouraged them to do it. So I believe America is less safe. If Tom DeLay or someone in the House said to me, "Sorry, we don't have the votes," I'd have said, "Then we're going to have a fight." And I'd have taken it out to the country, and I'd have had every law enforcement officer in the country visit those Congressmen. We'd have won what Bill Clinton won. Affirmative Action Mr. Schieffer. Let's go to a new question. For you, Senator Kerry, 2 minutes. Affirmative action—do you see a need for affirmative action programs, or have we moved far enough along that we no longer need to use race and gender as a factor in school admissions and Federal and State contracts, and so on? Senator Kerry. No, Bob, regrettably, we have not moved far enough along. And I regret to say that this administration has even blocked steps that could help us move further along. I'll give you an example. I'm the—I served on the Small Business Committee for a long time. I was chairman of it once; now I'm the senior Democrat on it. We used to—we have a goal there for minority set-aside programs to try to encourage ownership in the country. They don't reach those goals. They don't even fight to reach those goals. They've tried to undo them. The fact is that in too many parts of our country, we still have discrimination, and affirmative action is not just something that applies to people of color. Some people have a mistaken view of it in America. It also is with respect to women. It's with respect to other efforts to try to reach out and be inclusive in our country. I think that we have a long way to go, regrettably. If you look at what's happened, we've made progress; I want to say that at the same time. During the Clinton years, as you may recall, there was a fight over affirmative action. And there were many people, like myself, who opposed quotas, who felt there were places where it was overreaching. So we had a policy called "mend it, don't end it." We fixed it. And we fixed it for a reason, because there are too many people still in this country who feel the stark resistance of racism. And so we have a distance to travel. As President, I will make certain we travel it. Now, let me just share something. This President is the first President ever, I think, not to meet with the NAACP. This is a President who hasn't met with the Black Congressional Caucus. This is a President who has not met with the civil rights leadership of our country. If a President doesn't reach out and bring people in and be inclusive, then how are we going to get over those barriers? I see that as part of my job as President, and I'll make my best effort to do it. Mr. Schieffer. Mr. President. President Bush. Well, first of all, it is just not true that I haven't met with the Black Congressional Caucus. I met with the Black Congressional Caucus at the White House. And secondly, like my opponent, I don't agree we ought to have quotas—I agree, we shouldn't have quotas. But we ought to have an aggressive effort to make sure people are educated, to make sure when they get out of high school there's Pell grants available for them, which is what we've done. We've expanded Pell grants by a million students. Do you realize, today in America, we spend $73 billion to help 10 million low- and middle-income families better afford college? That's the access I believe is necessary, is to make sure every child learns to read, write, add, and subtract early, to be able to build on that education by going to college so they can start their careers with a college diploma. I believe the best way to help our small businesses is not only through small-business loans, which we have increased since I've been the President of the United States, but to unbundle Government contracts so people will have a chance to be able to bid and receive a contract to help get their business going. Minority ownership of businesses are up because we created an environment for the entrepreneurial spirit to be strong. I think—I believe part of a hopeful society is one in which somebody owns something. Today in America more minorities own a home than ever before. And that's hopeful, and that's positive. Candidates' Faith Mr. Schieffer. Mr. President, let's go to a new question. You were asked before the invasion—or after the invasion of Iraq if you had checked with your dad. And I believe—I don't remember the quote exactly—but I believe you said you had checked with a higher authority. I would like to ask you, what part does your faith play on your policy decisions? President Bush. First, my faith plays a lot—a big part in my life. And that's— when I was answering that question, what I was really saying to the person was that I pray a lot, and I do. And my faith is a very—it's very personal. I pray for strength. I pray for wisdom. I pray for our troops in harm's way. I pray for my family. I pray for my little girls. But I'm mindful, in a free society, that people can worship if they want to or not. You're equally an American if you choose to worship an Almighty and if you choose not to. If you're a Christian, Jew, or Muslim, you're equally an American. That's the great thing about America, is the right to worship the way you see fit. Prayer and religion sustain me. I've received calmness in the storms of the Presidency. I love the fact that people pray for me and my family all around the country. Somebody asked me one time, "Well, how do you know?" I said, "I just feel it." Religion is an important part. I never want to impose my religion on anybody else, but when I make decisions, I stand on principle. And the principles are derived from who I am. I believe we ought to love our neighbor like we love ourself. That's manifested in public policy through the Faith-Based Initiative, where we've unleashed the armies of compassion to help seal—heal people who hurt. I believe that God wants everybody to be free. That's what I believe. And that's part of my foreign policy. In Afghanistan, I believe that the freedom there is a gift from the Almighty, and I can't tell you how encouraged I am to see freedom on the march. And so my principles that I make decisions on are a part of me, and religion is a part of me. Mr. Schieffer. Senator Kerry. Senator Kerry. Well, I respect everything that the President has said, and certainly I respect his faith. I think it's important, and I share it. I think that he just said that freedom is a gift from the Almighty. Everything is a gift from the Almighty. And as I measure the words of the Bible—and we all do; different people measure different things, the Koran, the Torah, or— Native Americans who gave me a blessing the other day had their own special sense of connectedness to a higher being, and people all find their ways to express it. I was taught—I went to a church school, and I was taught that the two greatest commandments are "Love the Lord, your God, with all your mind, your body, and your soul" and "Love your neighbor as yourself." And frankly, I think we have a lot more loving of our neighbor to do in this country and on this planet. We have a separate and unequal school system in the United States of America. There's one for the people who have, and there's one for the people who don't have. And we're struggling with that today. The President and I have a difference of opinion about how we live out our sense of our faith. I talked about it earlier when I talked about the works and faith without works being dead. I think we've got a lot more work to do. And as President, I will always respect everybody's right to practice religion as they choose or not to practice, because that's part of America. Era of Divisiveness Mr. Schieffer. Senator Kerry, after 9/11— and this is a new question for you—it seemed to me that the country came together as I've never seen it come together since World War II. But some of that seems to have melted away. I think it's fair to say we've become pretty polarized, perhaps because of the political season. But if you were elected President or whoever is elected President, will you set a priority in trying to bring the Nation back together? Or what would be your attitude on that? Senator Kerry. Well, very much so. Let me pay a compliment to the President, if I may. I think in those days after 9/11, I thought the President did a terrific job. And I really was moved as well as impressed by the speech that he gave to the Congress. And I think the hug Tom Daschle gave him at that moment was about as genuine a sense of there being no Democrats, no Republicans; we were all just Americans. That's where we were. That's not where we are today. I regret to say that the President, who called himself a uniter, not a divider, is now presiding over the most divided America in the recent memory of our country. I've never seen such ideological squabbles in the Congress of the United States. I've never seen members of a party locked out of meetings the way they're locked out today. We have to change that, and as President, I am committed to changing that. I don't care if the idea comes from the other side or this side. I think we have to come together and work to change it. And I've done that. Over 20 years in the United States Senate, I've worked with John McCain, who's sitting here. I've worked with other colleagues. I've reached across the aisle. I've tried to find the common ground, because that's what makes us strong as Americans. And if Americans trust me with the Presidency, I can pledge to you, we will have the most significant effort—openly, not secret meetings in the White House with special interests, not ideologically driven efforts to push people aside, but a genuine effort to try to restore America's hope and possibilities by bringing people together. And one of the ways we're going to do it is, I'm going to work with my friend John McCain to further campaign finance reform so we get these incredible amounts of money out of the system and open it up to average people so America is really represented by the people who make up America. Mr. Schieffer. Mr. President. President Bush. My biggest disappointment in Washington is how partisan the town is. I had a record of working with Republicans and Democrats as the Governor of Texas, and I was hopeful to be able to do the same thing. And we made good progress early on. The No Child Left Behind Act, incredibly enough, was good work between me and my administration and people like Senator Ted Kennedy. And we worked together with Democrats to relieve the tax burden on the middle class and all who pay taxes in order to make sure this economy continues to grow. But Washington is a tough town, and the way I view it is there's a lot of entrenched special interests there, people who are on one side of the issue or another, and they spend enormous sums of money, and they convince different Senators to tout their way or different Congressmen to talk about their issue, and they dig in. I'll continue in the 4 years to continue to try to work to do so. My opponent said this is a bitterly divided time. It was pretty divided in the 2000 election. So, in other words, it's pretty divided during the 1990s as well. We're just in a period, and we've got to work to bring it out. My opponent keeps mentioning John McCain, and I'm glad he did. John McCain is for me for President because he understands I have the right view in winning the war on terror and that my plan will succeed in Iraq, and my opponent has got a plan of retreat and defeat in Iraq. Wives and Daughters of the Candidates Mr. Schieffer. We've come, gentlemen, to our last question. And it occurred to me, as I came to this debate tonight, that the three of us share something. All three of us are surrounded by very strong women. We're all married to strong women. Each of us have two daughters that make us very proud. I'd like to ask each of you, what is the most important thing you've learned from these strong women? President Bush. To listen to them— [laughter]—to stand up straight and not scowl. [Laughter] I love the strong women around me. I can't tell you how much I love my wife and our daughters. I am— you know, it's really interesting, I tell the people on the campaign trail, when I asked Laura to marry me, she said, "Fine, just so long as I never have to give a speech." I said, "Okay, you got a deal." Fortunately, she didn't hold me to that deal, and she's out campaigning, along with our girls, and she speaks English a lot better than I do. [Laughter] I think people understand what she's saying. But they see a compassionate, strong, great First Lady in Laura Bush. I can't tell you how lucky I am when I met her in the backyard at Joe and Jan O'Neill in Midland, Texas. It was the classic backyard barbecue. O'Neill said, "Come on over. I think you'll find somebody who might interest you." So I said, "All right," popped over there. There was only four of us there, and not only did she interest me, I guess you could say it was love at first sight. Mr. Schieffer. Senator Kerry. Senator Kerry. Well, I guess the President and you and I are three examples of lucky people who married up. [Laughter] And some would say maybe me more so than others. [Laughter] But I can take it. [Laughter] Can I say, if I could just say a word about a woman that you didn't ask about, but my mom passed away a couple years ago, just before I was deciding to run. And she was in the hospital, and I went in to talk to her and tell her what I was thinking of doing. And she looked at me from her hospital bed, and she just looked at me, and she said, "Remember, integrity, integrity, integrity." Those are the three words that she left me with. And my daughters and my wife are people who just are filled with that sense of what's right, what's wrong. They also kick me around. [Laughter] They keep me honest. They don't let me get away with anything. I can sometimes take myself too seriously. They surely don't let me do that. And I'm blessed, as I think the President is blessed. As I said last time, I've watched him with the First Lady, who I admire a great deal, and his daughters—he's a great father. And I think we're both very lucky. Closing Statements Mr. Schieffer. Well, gentlemen, that brings us to the closing statements. Senator Kerry, I believe you're first. Senator Kerry. My fellow Americans, as you heard from Bob Schieffer a moment ago, America is being tested by division. More than ever, we need to be united as a country. And like Franklin Roosevelt, I don't care whether an idea is a Republican idea or a Democrat idea. I just care whether it works for America and whether it's going to make us stronger. These are dangerous times. I believe I offer tested, strong leadership that can calm the waters of a troubled world. And I believe that we can, together, do things that are within the grasp of Americans. We can lift our schools up. We can create jobs that pay more than the jobs we're losing overseas. We can have health care for all Americans. We can further the cause of equality in our Nation. Let me just make it clear: I will never allow any country to have a veto over our security. Just as I fought for our country as a young man, with the same passion I will fight to defend this Nation that I love. And with faith in God and with conviction in the mission of America, I believe that we can reach higher. I believe we can do better. I think the greatest possibilities of our country, our dreams and our hopes, are out there just waiting for us to grab onto them. And I ask you to embark on that journey with me. I ask you for your trust. I ask you for your help. I ask you to allow me the privilege of leading this great Nation of ours, of helping us to be stronger here at home and to be respected again in the world and, most of all, to be safer forever. Thank you. Good night, and God bless the United States of America. Mr. Schieffer. Mr. President. President Bush. In the Oval Office, there's a painting by a friend of Laura and mine named—by Tom Lea. It's a west Texas painting, a painting of a mountain scene. And he said this about it, he said, "Sarah and I live on the east side of the mountain. It's the sunrise side, not the sunset side. It's the side to see the day that is coming, not to see the day that is gone." I love the optimism in that painting because that's how I feel about America. You know, we've been through a lot together during the last 3 3/4 years. We've come through a recession, a stock market decline, an attack on our country. And yet, because of the hard work of the American people and good policies, this economy is growing. Over the next 4 years, we'll make sure the economy continues to grow. We reformed our school system, and now there's an achievement gap in America that is beginning to close. Over the next 4 years, we'll continue to insist on excellence in every classroom in America so that our children have a chance to realize the great promise of America. Over the next 4 years, we'll continue to work to make sure health care is available and affordable. Over the next 4 years, we'll continue to rally the armies of compassion to help heal the hurt that exists in some of our country's neighborhoods. I'm optimistic that we'll win the war on terror, but I understand it requires firm resolve and clear purpose. We must never waver in the face of this enemy that—these ideologues of hate. And as we pursue the enemy wherever it exists, we'll also spread freedom and liberty. We've got great faith in the ability of liberty to transform societies, to convert hostile—a hostile world to a peaceful world. My hope for America is a prosperous America, a hopeful America, and a safer world. I want to thank you for listening tonight. I'm asking for your vote. God bless you. Mr. Schieffer. Thank you, Mr. President. Thank you, Senator Kerry. Well, that brings these debates to a close, but the campaign goes on. I want to wish both of you the very best of luck between now and election day. That's it for us from Arizona State University in Tempe, Arizona. I'm Bob Schieffer of CBS News. Good night, everyone.
