# Vice Presidential Debate at Centre College in Danville, Kentucky

**Date:** October 11, 2012
**Source:** https://www.presidency.ucsb.edu/documents/vice-presidential-debate-centre-college-danville-kentucky

---

MARTHA RADDATZ, MODERATOR: Good evening, and welcome to the first and only vice presidential debate of 2012, sponsored by the Commission on Presidential Debates. I'm Martha Raddatz of ABC News, and I am honored to moderate this debate between two men who have dedicated much of their lives to public service. Tonight's debate is divided between domestic and foreign policy issues. And I'm going to move back and forth between foreign and domestic, since that is what a vice president or president would have to do. We will have nine different segments. At the beginning of each segment, I will ask both candidates a question, and they will each have two minutes to answer. Then I will encourage a discussion between the candidates with follow-up questions. By coin toss, it has been determined that Vice President Biden will be first to answer the opening question. We have a wonderful audience here at Centre College tonight. You will no doubt hear their enthusiasm at the end of the debate — and right now, as we welcome Vice President Joe Biden and Congressman Paul Ryan. [applause] OK, you got your little wave to the families in. It's great. Good evening, gentlemen. It really is an honor to be here with both of you. I would like to begin with Libya. On a rather somber note, one month ago tonight, on the anniversary of 9/11, Ambassador Chris Stevens and three other brave Americans were killed in a terrorist attack in Benghazi. The State Department has now made clear, there were no protesters there. RADDATZ: it was a pre-planned assault by heavily armed men. Wasn't this a massive intelligence failure, Vice President Biden? VICE PRESIDENT JOSEPH BIDEN: What is was, it was a tragedy, Martha. It — Chris Stevens was one of our best. We lost three other brave Americans. I can make absolutely two commitments to you and all the American people tonight. One, we will find and bring to justice the men who did this. And secondly, we will get to the bottom of it, and whatever — wherever the facts lead us, wherever they lead us, we will make clear to the American public, because whatever mistakes were made will not be made again. When you're looking at a president, Martha, it seems to me that you should take a look at his most important responsibility. That's caring for the national security of the country. And the best way to do that is take a look at how he's handled the issues of the day. On Iraq, the president said he would end the war. Governor Romney said that was a tragic mistake, we should have left 30,000 — he ended it. Governor Romney said that was a tragic mistake, we should have left 30,000 troops there. With regard to Afghanistan, he said he will end the war in 2014. Governor Romney said we should not set a date, number one. And number two, with regard to 2014, it depends. When it came to Osama bin Laden, the president the first day in office, I was sitting with him in the Oval Office, he called in the CIA and signed an order saying, "My highest priority is to get bin Laden." Prior to the election, prior to the — him being sworn in, Governor Romney was asked the question about how he would proceed. He said, "I wouldn't move heaven and earth to get bin Laden." He didn't understand it was more than about taking a murderer off the battlefield. It was about restoring America's heart and letting terrorists around the world know, if you do harm to America, we will track you to the gates of hell if need be. And lastly, the president of the United States has — has led with a steady hand and clear vision. Governor Romney, the opposite. The last thing we need now is another war. RADDATZ: Congressman Ryan? REPRESENTATIVE PAUL RYAN: We mourn the loss of these four Americans who were murdered. RYAN: When you take a look at what has happened just in the last few weeks, they sent the U.N. ambassador out to say that this was because of a protest and a YouTube video. It took the president two weeks to acknowledge that this was a terrorist attack. He went to the U.N. and in his speech at the U.N. he said six times — he talked about the YouTube video. Look, if we're hit by terrorists we're going to call it for what it is, a terrorist attack. Our ambassador in Paris has a Marine detachment guarding him. Shouldn't we have a Marine detachment guarding our ambassador in Benghazi, a place where we knew that there was an Al Qaida cell with arms? This is becoming more troubling by the day. They first blamed the YouTube video. Now they're trying to blame the Romney-Ryan ticket for making this an issue. With respect to Iraq, we had the same position before the withdrawal, which was we agreed with the Obama administration. Let's have a status of forces agreement to make sure that we secure our gains. The vice president was put in charge of those negotiations by President Obama and they failed to get the agreement. We don't have a status of forces agreement because they failed to get one. That's what we are talking about. Now, when it comes to our veterans, we owe them a great debt of gratitude for what they've done for us, including your son Beau. But we also want to make sure that we don't lose the things we fought so hard to get. Now, with respect to Afghanistan, the 2014 deadline, we agree with a 2014 transition. But what we also want it do is make sure that we're not projecting weakness abroad, and that's what's happening here. RYAN: This Benghazi issue would be a tragedy in and of itself, but unfortunately it's indicative of a broader problem. And that is what we are watching on our TV screens is the unraveling of the Obama foreign policy, which is making the [inaudible] more chaotic us less safe. RADDATZ: I just want to you about right in the middle of the crisis. Governor Romney, and you're talking about this again tonight, talked about the weakness; talked about apologies from the Obama administration. Was that really appropriate right in the middle of the crisis? RYAN: On that same day, the Obama administration had the exact same position. Let's recall that they disavowed their own statement that they had put out earlier in the day in Cairo. So we had the same position, but we will — it's never too early to speak out for our values. We should have spoken out right away when the green revolution was up and starting; when the mullahs in Iran were attacking their people. We should not have called Bashar Assad a reformer when he was turning his Russian-provided guns on his own people. We should always stand up for peace, for democracy, for individual rights. And we should not be imposing these devastating defense cuts, because what that does when we equivocate on our values, when we show that we're cutting down on defense, it makes us more weak. It projects weakness. And when we look weak, our adversaries are much more willing to test us. They're more brazen in their attacks, and are allies are less willing to...[crosstalk] BIDEN: With all due respect, that's a bunch of malarkey. RADDATZ: And why is that so? BIDEN: Because not a single thing he said is accurate. First of all... RADDATZ: Be specific. BIDEN: I will be very specific. Number one, the — this lecture on embassy security — the congressman here cut embassy security in his budget by $300 million below what we asked for, number one. So much for the embassy security piece. Number two, Governor Romney, before he knew the facts, before he even knew that our ambassador was killed, he was out making a political statement which was panned by the media around the world. And this talk about this — this weakness. I — I don't understand what my friend's talking about here. We — this is a president who's gone out and done everything he has said he was going to do. This is a guy who's repaired our alliances so the rest of the world follows us again. This is the guy who brought the entire world, including Russia and China, to bring about the most devastating — most devastating — the most devastating efforts on Iran to make sure that they in fact stop [inaudible]. Look, I — I just — I mean, these guys bet against America all the time. RADDATZ: Can we talk — let me go back to Libya. BIDEN: Yeah, sure. RADDATZ: What were you first told about the attack? Why — why were people talking about protests? When people in the consulate first saw armed men attacking with guns, there were no protesters. Why did that go on [inaudible]? BIDEN: Because that was exactly what we were told by the intelligence community. The intelligence community told us that. As they learned more facts about exactly what happened, they changed their assessment. That's why there's also an investigation headed by Tom Pickering, a leading diplomat from the Reagan years, who is doing an investigation as to whether or not there are any lapses, what the lapses were, so that they will never happen again. RADDATZ: And they wanted more security there. BIDEN: Well, we weren't told they wanted more security there. We did not know they wanted more security again. And by the way, at the time we were told exactly — we said exactly what the intelligence community told us that they knew. That was the assessment. And as the intelligence community changed their view, we made it clear they changed their view. That's why I said we will get to the bottom of this. You know, usually when there's a crisis, we pull together. We pull together as a nation. But as I said, even before we knew what happened to the ambassador, the governor was holding a press conference — was holding a press conference. That's not presidential leadership. RADDATZ: Mr. Ryan, I want to ask you about — the Romney campaign talks a lot about no apologies. He has a book called called "No Apologies." Should the U.S. have apologized for Americans burning Korans in Afghanistan? Should the U.S. apologize for U.S. Marines urinating on Taliban corpses? RYAN: Oh, gosh, yes. Urinating on Taliban corpses? What we should not apologize for... RADDATZ: Burning Korans, immediately? RYAN: What — what we should not be apologizing for are standing up for our values. What we should not be doing is saying to the Egyptian people, while Mubarak is cracking down on them, that he's a good guy and, in the next week, say he ought to go. What we should not be doing is rejecting claims for — for calls for more security in our barracks, in our Marine — we need Marines in Benghazi when the commander on the ground says we need more forces for security. There were requests for extra security; those requests were not honored. Look, this was the anniversary of 9/11. It was Libya, a country we knew we had Al Qaida cells there, as we know Al Qaida and its affiliates are on the rise in Northern Africa. And we did not give our ambassador in Benghazi a Marine detachment? Of course there's an investigation, so we can make sure that this never happens again, but when it comes to speaking up for our values, we should not apologize for those. Here's the problem. Look at all the various issues out there, and it's unraveling before our eyes. The vice president talks about sanctions on Iran. They got — we've had four... RADDATZ: Let's move to Iran. I'd actually like to move to Iran, because there's really no bigger national security... RYAN: Absolutely. RADDATZ: ... this country is facing. Both President Obama and Governor Romney have said they will prevent Iran from getting a nuclear weapon, even if that means military action. Last week, former Defense Secretary Bob Gates said a strike on Iran's facilities would not work and, quote, "could prove catastrophic, haunting us for generations." Can the two of you be absolutely clear and specific to the American people how effective would a military strike be? Congressman Ryan? RYAN: We cannot allow Iran to gain a nuclear weapons capability. Now, let's take a look at where we've gone — come from. When Barack Obama was elected, they had enough fissile material — nuclear material to make one bomb. Now they have enough for five. They're racing toward a nuclear weapon. They're four years closer toward a nuclear weapons capability. We've had four different sanctions, the U.N. on Iran, three from the Bush administration, one here. And the only reason we got it is because Russia watered it down and prevented the — the sanctions from hitting the central bank. Mitt Romney proposed these sanctions in 2007. In Congress, I've been fighting for these sanctions since 2009. The administration was blocking us every step of the way. Only because we had strong bipartisan support for these tough sanctions were we able to overrule their objections and put them in spite of the administration. Imagine what would have happened if we had these sanctions in place earlier. You think Iran's not brazen? Look at what they're doing. They're stepping up their terrorist attacks. They tried a terrorist attack in the United States last year when they tried to blow up the Saudi ambassador at a restaurant in Washington, D.C. And talk about credibility? When this administration says that all options are on the table, they send out senior administration officials that send all these mixed signals. And so, in order to solve this peacefully — which is everybody's goal — you have to have the ayatollahs change their minds. Look at where they are. They're moving faster toward a nuclear weapon. It's because this administration has no credibility on this issue. It's because this administration watered down sanctions, delayed sanctions, tried to stop us for putting the tough sanctions in place. Now we have them in place because of Congress. They say the military option's on the table, but it's not being viewed as credible. And the key is to do this peacefully, is to make sure that we have credibility. Under a Romney administration, we will have credibility on this issue. RADDATZ: Vice President Biden? BIDEN: It's incredible. Look, imagine had we let the Republican Congress work out the sanctions. You think there's any possibility the entire world would have joined us, Russia and China, all of our allies? These are the most crippling sanctions in the history of sanctions, period. Period. When Governor Romney's asked about it, he said, "We gotta keep these sanctions." When he said, "Well, you're talking about doing more," what are you — you're going to go to war? Is that what you want to do? RYAN: We want to prevent war. BIDEN: And the interesting thing is, how are they going to prevent war? How are they going to prevent war if they say there's nothing more that we — that they say we should do than what we've already done, number one. And number two, with regard to the ability of the United States to take action militarily, it is — it is not in my purview to talk about classified information. But we feel quite confident we could deal a serious blow to the Iranians. But number two, the Iranians are — the Israelis and the United States, our military and intelligence communities are absolutely the same exact place in terms of how close — how close the Iranians are to getting a nuclear weapon. They are a good way away. There is no difference between our view and theirs. When my friend talks about fissile material, they have to take this highly enriched uranium, get it from 20 percent up, then they have to be able to have something to put it in. There is no weapon that the Iranians have at this point. Both the Israelis and we know — we'll know if they start the process of building a weapon. So all this bluster I keep hearing, all this loose talk, what are they talking about? Are you talking about, to be more credible — what more can the president do, stand before the United Nations, tell the whole world, directly communicate to the ayatollah, we will not let them acquire a nuclear weapon, period, unless he's talking about going to war. RYAN: Martha? Let's... RADDATZ: Congressman Ryan? RYAN: Let's look at this from the view of the ayatollahs. What do they see? They see this administration trying to water down sanctions in Congress for over two years. They're moving faster toward a nuclear weapon. They're spinning the centrifuges faster. They see us saying when we come into the administration, when they're sworn in, we need more space with our ally, Israel. They see President Obama in New York City the same day Bibi Netanyahu is and he, instead of meeting with him, goes on a — on a daily talk show. They see, when we say that these options are on the table, the secretary of defense walked them back. They are not changing their mind. That's what we have to do, is change their mind so they stop pursuing nuclear weapons, and they're going faster. RADDATZ: How do you do it so quickly? Look, you — you both saw Benjamin Netanyahu hold up that picture of a bomb with a red line and talking about the red line being in spring. So can you solve this, if the Romney-Ryan ticket is elected, can you solve this in two months before spring and avoid nuclear — nuclear...[crosstalk] RYAN: We can debate a time line. We can debate the time line, whether there's — it's that short a time or longer. I agree that it's probably longer. Number two, it's all about...[crosstalk] RADDATZ: You don't agree with that bomb and whether the Israelis...[crosstalk] RYAN: I don't want to go into classified stuff. But we both agree that to do this peacefully you've got to get them to change their minds. They're not changing their minds. And look at what this administration... RADDATZ: But what — what do...[crosstalk] BIDEN: Let me tell you what the ayatollah sees. RYAN: You have to have credibility. BIDEN: The ayatollah sees his economy being crippled. The ayatollah sees that there are 50 percent fewer exports of oil. He sees the currency going into the tank. He sees the economy going into freefall. And he sees the world for the first time totally united in opposition to him getting a nuclear weapon. Now, with regard to Bibi, who's been my friend 39 years, the president has met with Bibi a dozen times. He's spoken to Bibi Netanyahu as much as he's spoken to anybody. The idea that we're not — I was in a, just before he went to the U.N., I was in a conference call with the — with the president, with him talking to Bibi for well over an hour, in — in — in stark relief and detail of what was going on. This is a bunch of stuff. Look, here's the deal. RADDATZ: What does that mean, a bunch of stuff? BIDEN: Well, it means it's simply inaccurate. RYAN: It's Irish. BIDEN: It — it is. [laughter] We Irish call it malarkey. RADDATZ: Thanks for the translation. OK. [crosstalk] BIDEN: We Irish call it malarkey. But last thing. The secretary of defense has made it absolutely clear, we didn't walk anything back. We will not allow the Iranians to get a nuclear weapon. What Bibi held up there was when they get to the point where they can enrich uranium enough to put into a weapon. They don't have a weapon to put it into. Let's all calm down a little bit here. Iran is more isolated today than when we took office. It was on the ascendancy when we took office. It is totally isolated. RADDATZ: Congressman Ryan? BIDEN: I don't know what world this guy's living in. RYAN: Thank heavens we had these sanctions in place. It's in spite of their opposition. BIDEN: Oh, god. RYAN: They've given 20 waivers to this sanction. And all I have to point to are the results. They're four years closer toward a nuclear weapon. I think that case speaks for itself. RADDATZ: Can you tell the American people... BIDEN: By the way, they... [crosstalk] RADDATZ: What's worse, another war in the Middle East... BIDEN: ... they are not four years closer to a nuclear weapon. RYAN: Of course they are. BIDEN: They're — they're closer to being able to get enough fissile material to put in a weapon if they had a weapon. RADDATZ: You are acting a little bit like they don't want one. BIDEN: Oh, I didn't say — no, I'm not saying that. But facts matter, Martha. You're a foreign policy expert. Facts matter. All this loose talk about them, "All they have to do is get to enrich uranium in a certain amount and they have a weapon," not true. Not true. They are more — and if we ever have to take action, unlike when we took office, we will have the world behind us, and that matters. That matters. RADDATZ: What about Bob Gates' statement? Let me read that again, "could prove catastrophic, haunting us for generations." BIDEN: He is right. It could prove catastrophic, if we didn't do it with precision. RADDATZ: Congressman Ryan? RYAN: And what it does is it undermines our credibility by backing up the point when we make it that all options are on the table. That's the point. The ayatollahs see these kinds of statements and they think, "I'm going to get a nuclear weapon." When — when we see the kind of equivocation that took place because this administration wanted a precondition policy, so when the Green Revolution started up, they were silent for nine days. When they see us putting — when they see us putting daylight between ourselves and our allies in Israel, that gives them encouragement. When they see Russia watering down any further sanctions, the only reason we got a U.N. sanction is because Russia watered it down and prevented these central bank sanctions in the first place. So when they see this kind of activity, they are encouraged to continue, and that's the problem. BIDEN: Martha, let me tell you what Russia...[crosstalk] RADDATZ: Well, let me ask you what's worse, war in the Middle East, another war in the Middle East, or a nuclear-armed Iran? RYAN: I'll tell you what's worse. I'll tell you what's worse. RADDATZ: Quickly. RYAN: A nuclear-armed Iran which triggers a nuclear arms race in the Middle East. This is the world's largest sponsor of — of terrorism. They've dedicated themselves...[crosstalk]... to wiping an entire country off the map. They call us the Great Satan. And if they get nuclear weapons, other people in the neighborhood will pursue their nuclear weapons, as well. RADDATZ: Vice President Biden? RYAN: We can't live with that. BIDEN: War should always be the absolute last resort. That's why these crippling sanctions, which Bibi Netanyahu says we should continue, which — if I'm not mistaken — Governor Romney says we — we should continue. I may be mistaken. He changes his mind so often, I could be wrong. But the fact of the matter is, he says they're working. And the fact is that they are being crippled by them. And we've made it clear, big nations can't bluff. This president doesn't bluff. RADDATZ: Gentlemen, I want to bring the conversation to a different kind of national security issue, the state of our economy. The number-one issue here at home is jobs. The percentage of unemployed just fell below 8 percent for the first time in 43 months. The Obama administration had projected that it would fall below 6 percent now after the addition of close to a trillion dollars in stimulus money. So will both of you level with the American people: Can you get unemployment to under 6 percent and how long will it take? BIDEN: I don't know how long it will take. We can and we will get it under 6 percent. Let's look at — let's take a look at the facts. Let's look at where we were when we came to office. The economy was in free fall. We had — the great recession hit; 9 million people lost their job; $1.7 — $1.6 trillion in wealth lost in equity in your homes, in retirement accounts for the middle class. We knew we had to act for the middle class. We immediately went out and rescued General Motors. We went ahead and made sure that we cut taxes for the middle class. And in addition to that, when that — when that occurred, what did Romney do? Romney said, "No, let Detroit go bankrupt." We moved in and helped people refinance their homes. Governor Romney said, "No, let foreclosures hit the bottom." But it shouldn't be surprising for a guy who says 47 percent of the American people are unwilling to take responsibility for their own lives. My friend recently in a speech in Washington said "30 percent of the American people are takers." These people are my mom and dad — the people I grew up with, my neighbors. They pay more effective tax than Governor Romney pays in his federal income tax. They are elderly people who in fact are living off of Social Security. They are veterans and people fighting in Afghanistan right now who are, quote, "not paying any tax." I've had it up to here with this notion that 47 percent — it's about time they take some responsibility here. And instead of signing pledges to Grover Norquist not to ask the wealthiest among us to contribute to bring back the middle class, they should be signing a pledge saying to the middle class we're going to level the playing field; we're going to give you a fair shot again; we are going to not repeat the mistakes we made in the past by having a different set of rules for Wall Street and Main Street, making sure that we continue to hemorrhage these tax cuts for the super wealthy. They're pushing the continuation of a tax cut that will give an additional $500 billion in tax cuts to 120,000 families. And they're holding hostage the middle class tax cut because they say we won't pass — we won't continue the middle class tax cut unless you give the tax cut for the super wealthy. It's about time they take some responsibility. RADDATZ: Mr. Ryan? RYAN: Joe and I are from similar towns. He's from Scranton, Pennsylvania. I'm from Janesville, Wisconsin. You know what the unemployment rate in Scranton is today? BIDEN: I sure do. RYAN: It's 10 percent. BIDEN: Yeah. RYAN: You know what it was the day you guys came in — 8.5 percent. BIDEN: Yeah. RYAN: That's how it's going all around America. Look... BIDEN: You don't read the statistics. That's not how it's going. It's going down. RADDATZ: [inaudible] two-minute answer [inaudible] RYAN: Look, did they come in and inherit a tough situation? Absolutely. But we're going in the wrong direction. Look at where we are. The economy is barely limping along. It's growing a 1.3 percent. That's slower than it grew last year and last year was slower than the year before. Job growth in September was slower than it was in August, and August was slower than it was in July. We're heading in the wrong direction; 23 million Americans are struggling for work today; 15 percent of Americans are living in poverty today. This is not what a real recovery looks like. We need real reforms for real recovery and that's exactly what Mitt Romney and I are proposing. It's a five-point plan. Get America energy independent in North America by the end of the decade. Help people who are hurting get the skills they need to get the jobs they want. Get this deficit and debt under control to prevent a debt crisis. Make trade work for America so we can make more things in America and sell them overseas, and champion small businesses. Don't raise taxes on small businesses because they're our job creators. RYAN: He talks about Detroit. Mitt Romney's a car guy. They keep misquoting him, but let me tell you about the Mitt Romney I know. This is a guy who I was talking to a family in Northborough, Massachusetts the other day, Sheryl and Mark Nixon. Their kids were hit in a car crash, four of them. Two of them, Rob and Reed, were paralyzed. The Romneys didn't know them. They went to the same church; they never met before. Mitt asked if he could come over on Christmas. He brought his boys, his wife, and gifts. Later on, he said, "I know you're struggling, Mark. Don't worry about their college. I'll pay for it." When Mark told me this story, because, you know what, Mitt Romney doesn't tell these stories. The Nixons told this story. When he told me this story, he said it wasn't the help, the cash help. It's that he gave his time, and he has consistently. This is a man who gave 30 percent of his income to charity, more than the two of us combined. Mitt Romney's a good man. He cares about 100 percent of Americans in this country. And with respect to that quote, I think the vice president very well knows that sometimes the words don't come out of your mouth the right way. [laughter] BIDEN: But I always say what I mean. And so does Romney. RYAN: We want everybody to succeed. We want to get people out of poverty, in the middle class, onto a life of self-sufficiently. We believe in opportunity and upward mobility. That's what we're going to push for in a Romney administration. RADDATZ: Vice president? I have a feeling you have a few things to say here. BIDEN: The idea — if you heard that — that little soliloquy on 47 percent and you think he just made a mistake, then I think you're — I — I think — I got a bridge to sell you. Look, I don't doubt his personal generosity. And I understand what it's like. When I was a little younger than the congressman, my wife was in an accident, killed my daughter and my wife, and my two sons survived. I have sat in the homes of many people who've gone through what I get through, because the one thing you can give people solace is to know if they know you've been through it, that they can make it. So I don't doubt his personal commitment to individuals. But you know what? I know he had no commitment to the automobile industry. He just — he said, let it go bankrupt, period. Let it drop out. All this talk — we saved a million jobs. Two hundred thousand people are working today. And I've never met two guys who're more down on America across the board. We're told everything's going bad. There are 5.2 million new jobs, private-sector jobs. We need more, but 5.2 million — if they'd get out of the way, if they'd get out of the way and let us pass the tax cut for the middle class, make it permanent, if they get out of the way and pass the — pass the jobs bill, if they get out of the way and let us allow 14 million people who are struggling to stay in their homes because their mortgages are upside down, but they never missed a mortgage payment, just get out of the way. Stop talking about how you care about people. Show me something. Show me a policy. Show me a policy where you take responsibility. And, by the way, they talk about this Great Recession if it fell out of the sky, like, "Oh, my goodness, where did it come from?" It came from this man voting to put two wars on a credit card, to at the same time put a prescription drug benefit on the credit card, a trillion-dollar tax cut for the very wealthy. I was there. I voted against them. I said, no, we can't afford that. And now, all of a sudden, these guys are so seized with the concern about the debt that they created. RADDATZ: Congressman Ryan? RYAN: Let's not forget that they came in with one-party control. When Barack Obama was elected, his party controlled everything. They had the ability to do everything of their choosing. And look at where we are right now. They passed the stimulus. The idea that we could borrow $831 billion, spend it on all of these special interest groups, and that it would work out just fine, that unemployment would never get to 8 percent — it went up above 8 percent for 43 months. They said that, right now, if we just passed this stimulus, the economy would grow at 4 percent. It's growing at 1.3. RADDATZ: When could you get it below 6 percent? RYAN: That's what our entire premise of our pro-growth plan for a stronger middle class is all about: getting the economy growing at 4 percent, creating 12 million jobs over the next four years. Look at just the $90 billion in stimulus. The vice president was in charge of overseeing this. $90 billion in green pork to campaign contributors and special interest groups. There are just at the Department of Energy over 100 criminal investigations that have been launched into just how stimulus...[crosstalk] BIDEN: Martha... RADDATZ: Go ahead. Go ahead. BIDEN: Martha, look. His colleague... RYAN: Crony capitalism and corporate welfare. BIDEN: ... runs an investigative committee, spent months and months and months going into this. RYAN: This is the — this is the inspector general. BIDEN: Months and months. They found no evidence of cronyism. And I love my friend here. I — I'm not allowed to show letters but go on our website, he sent me two letters saying, "By the way, can you send me some stimulus money for companies here in the state of Wisconsin?" We sent millions of dollars. You know...[crosstalk] RADDATZ: You did ask for stimulus money, correct? BIDEN: Sure he did. By the way... RYAN: On two occasions we — we — we advocated for constituents who were applying for grants. That's what we do. We do that for all constituents who are...[crosstalk] BIDEN: I love that. I love that. This was such a bad program and he writes me a letter saying — writes the Department of Energy a letter saying, "The reason we need this stimulus, it will create growth and jobs." His words. And now he's sitting here looking at me. And by the way, that program, again, investigated. What the Congress said was it was a model. Less than four-tenths of 1 percent waste or fraud in the program. And all this talk about cronyism. They investigated and investigated, did not find one single piece of evidence. I wish he would just tell — be a little more candid. RYAN: Was it a good idea to spend taxpayer dollars on electric cars in Finland, or on windmills in China? BIDEN: Look... RYAN: Was it a good idea to borrow all this money from countries like China and spend it on all these various different interest groups? BIDEN: Let me tell you what was a good idea. It was a good idea, Moody's and others said that this was exactly what we needed to stop this from going off the cliff. It set the conditions to be able to grow again. We have, in fact, 4 percent of those green jobs didn't go under — went under, didn't work. It's a better batting average than investment bankers have. They have about a 40 percent... RYAN: Where are the 5 million green jobs that were being... RADDATZ: I want to move on here to Medicare and entitlements. I think we've gone over this quite enough. BIDEN: By the way, any letter you send me, I'll entertain. RYAN: I appreciate that, Joe. [laughter] RADDATZ: Let's talk about Medicare and entitlements. Both Medicare and Social Security are going broke and taking a larger share of the budget in the process. Will benefits for Americans under these programs have to change for the programs to survive? Mr. Ryan? RYAN: Absolutely. Medicare and Social Security are going bankrupt. These are indisputable facts. Look, when I look at these programs, we've all had tragedies in our lives. I think about what they've done for my own family. My mom and I had my grandmother move in with us who was facing Alzheimer's. Medicare was there for here, just like it's there for my mom right now who is a Florida senior. After my dad died, my mom and I got Social Security survivors benefits, helped me pay for college, it helped her go back to college in her 50s where she started a small business because of the new skills she got. She paid all of her taxes on the promise that these programs would be there for her. We will honor this promise. And the best way to do it is reform it for my generation. You see, if you reform these programs for my generation, people 54 and below, you can guarantee they don't change for people in or near retirement, which is precisely what Mitt Romney and I are proposing. Look what — look what Obamacare does. Obamacare takes $716 billion from Medicare to spend on Obamacare. Even their own chief actuary at Medicare backs this up. He says you can't spend the same dollar twice. You can't claim that this money goes to Medicare and Obamacare. RYAN: And then they put this new Obamacare board in charge of cutting Medicare each and every year in ways that will lead to denied care for current seniors. This board, by the way, it's 15 people, the president's supposed to appoint them next year. And not one of them even has to have medical training. And Social Security? If we don't shore up Social Security, when we run out of the IOUs, when the program goes bankrupt, a 25 percent across-the-board benefit cut kicks in on current seniors in the middle of their retirement. We're going to stop that from happening. They haven't put a credible solution on the table. He'll tell you about vouchers. He'll say all these things to try and scare people. Here's what we're saying: give younger people, when they become Medicare eligible, guaranteed coverage options that you can't be denied, including traditional Medicare. Choose your plan, and then Medicare subsidizes your premiums, not as much for the wealthy people, more coverage for middle-income people, and total out-of-pocket coverage for the poor and the sick. Choice and competition. We would rather have 50 million future seniors determine how their Medicare is delivered to them instead of 15 bureaucrats deciding what, if, when, where they get it. RADDATZ: Vice President Biden, two minutes. BIDEN: You know, I heard that death panel argument from Sarah Palin. It seems every vice presidential debate I hear this kind of stuff about panels. But let's talk about Medicare. What we did is, we saved $716 billion and put it back, applied it to Medicare. We cut the cost of Medicare. We stopped overpaying insurance companies, doctors and hospitals. The AMA supported what we did. AARP endorsed what we did. And it extends the life of Medicare to 2024. They want to wipe this all out. It also gave more benefits. Any senior out there, ask yourself: Do you have more benefits today? You do. If you're near the donut hole, you have $800 — $600 more to help your prescription drug costs. You get wellness visits without co-pays. They wipe all of this out, and Medicare goes — becomes insolvent in 2016, number one. Number two, "guaranteed benefit"? It's a voucher. When they first proposed — when the congressman had his first voucher program, the CBO said it would cost $6,400 a year, Martha, more for every senior, 55 and below, when they got there. He knew that, yet he got all the guys in Congress and women in the Republican Party to vote for it. Governor Romney, knowing that, said, I would sign it, were I there. Who you believe, the AMA, me, a guy who's fought his whole life for this, or somebody who would actually put in motion a plan that knowingly cut — added $6,400 a year more to the cost of Medicare? Now they got a new plan: "Trust me, it's not going to cost you any more." Folks, follow your instincts on this one. And with regard to Social Security, we will not — we will not privatize it. If we had listened to Romney, Governor Romney, and the congressman during the Bush years, imagine where all those seniors would be now if their money had been in the market. Their ideas are old and their ideas are bad, and they eliminate the guarantee of Medicare. RYAN: Here's the problem. They got caught with their hands in the cookie jar, turning Medicare into a piggybank for Obamacare. Their own actuary from the administration came to Congress and said one out of six hospitals and nursing homes are going to go out of business as a result of this. BIDEN: That's not what they said. RYAN: 7.4 million seniors are projected to lose their current Medicare Advantage coverage they have. That's a $3,200 benefit cut. BIDEN: That didn't happen. RYAN: What we're saying... BIDEN: More people signed up. RYAN: These are from your own actuaries. BIDEN: More — more — more people signed up for Medicare Advantage after the change. RYAN: What — there's... BIDEN: Nobody is...[crosstalk] RYAN: Mr. Vice President, I know... BIDEN: No, this is...[crosstalk] RYAN: Mr. Vice President, I know you're under a lot of duress to make up for lost ground, but I think people would be better served if we don't keep interrupting each other. BIDEN: Well, don't take all the four minutes then. RYAN: Let me just — let me just say this. We are not — we're saying don't change benefits for people 55 and above. They already organized their retirement around these promises. [crosstalk]... programs for those of us. RADDATZ: But let — let me ask you this. What — what is your specific plan for seniors who really can't afford to make up the difference in the value of what you call a premium support plan and others call a voucher? RYAN: Hundred percent coverage... RADDATZ: And what...[crosstalk] RYAN: That's what we're saying. So we're saying... RADDATZ: How do you make that up? RYAN: ... income adjusts [inaudible] these premium support payments by taking down the subsidies for wealthy people. Look, this is a plan — by the way, that $6,400 number, it was misleading then, it's totally inaccurate now. This is a plan that's bipartisan. It's a plan I put together with a prominent Democrat senator from Oregon. BIDEN: There's not one Democrat who endorses it. RYAN: It's a plan... BIDEN: Not one Democrat who [inaudible]. RYAN: Our partner is a Democrat from Oregon. BIDEN: And he said he does no longer support [inaudible]. RYAN: We — we — we put it — we put it together with the former Clinton budget director. BIDEN: Who disavows it. RYAN: This idea — this idea came from the Clinton commission to save Medicare chaired by Senator John Breaux. Here's the point, Martha. BIDEN: Which was rejected. RYAN: If we don't — if we don't fix this problem pretty soon then current seniors get cut. Here's the problem: 10,000 people are retiring every single day in America today and they will for 20 years. That's not a political thing, that's a math thing. BIDEN: Martha, if we just did one thing, if we just — if they just allowed Medicare to bargain for the cost of drugs like Medicaid can, that would save $156 billion right off the bat. RYAN: And it would deny seniors choices. BIDEN: All — all — all... RYAN: It has a restricted...[crosstalk] BIDEN: Seniors are not denied. RYAN: Absolutely. BIDEN: They are not denied. Look, folks, all you seniors out there, have you been denied choices? Have you lost Medicare Advantage. RYAN: Because it's working well right now. [crosstalk] BIDEN: Because we've changed the law. RADDATZ: Vice President Biden, let me ask you, if it could help solve the problem, why not very slowly raise the Medicare eligibility age by two years, as Congressman Ryan suggests? BIDEN: Look, I was there when we did that with Social Security in 1983. I was one of eight people sitting in the room that included Tip O'Neill negotiating with President Reagan. We all got together and everybody said, as long as everybody's in the deal, everybody's in the deal, and everybody is making some sacrifice, we can find a way. We made the system solvent to 2033. We will not, though, be part of any voucher plan eliminating — the voucher says, "Mom, when you're — when you're 65, go out there, shop for the best insurance you can get. You're out of Medicare." You can buy back in if you want with this voucher, which will not keep pace — will not keep pace with health care costs. Because if it did keep pace with health care costs, there would be no savings. That's why they go the voucher. They — we will be no part of a voucher program or the privatization of Social Security. RYAN: A voucher is you go to your mailbox, get a check, and buy something. Nobody's proposing that. Barack Obama four years ago running for president said if you don't have any fresh ideas, use stale tactics to scare voters. If you don't have a good record to run on, paint your opponent as someone people should run from. [crosstalk] Make a big election about small ideas. RADDATZ: You were one of the few lawmakers to stand with President Bush when he was seeking to partially privatize Social Security. RYAN: For younger people. What we said then, and what I've always agreed is let younger Americans have a voluntary choice of making their money work faster for them within the Social Security system. BIDEN: You saw how well that worked. RYAN: That's not what Mitt Romney's proposing. What we're saying is no changes for anybody 55 and above. BIDEN: What Mitt Romney is proposing... RYAN: And then the kinds of changes we're talking about for younger people like myself is don't increase the benefits for wealthy people as fast as everybody else. Slowly raise the retirement age over time. BIDEN: Martha... RYAN: It wouldn't get to the age of 70 until the year 2103 according to the actuaries. Now, here's...[crosstalk] RADDATZ: Quickly, Vice President? BIDEN: Quickly. The bottom line here is that all the studies show that if we went with Social Security proposal made by Mitt Romney, if you're 40 — in your 40s now you will pay $2,600 a year — you get $2,600 a year less in Social Security. If you're in your 20s now, you get $4,700 [inaudible] less. The idea of changing, and change being in this case to cut the benefits for people without taking other action you could do to make it work is absolutely the wrong way. These — look, these guys haven't been big on Medicare from the beginning. Their party's not been big on Medicare from the beginning. And they've always been about Social Security as little as you can do. Look, folks, use your common sense. Who do you trust on this — a man who introduced a bill that would raise it 40 — $6,400 a year; knowing it and passing it, and Romney saying he'd sign it, or me and the president? RYAN: That statistic was completely misleading. But more importantly... BIDEN: That's — there are the facts right...[crosstalk] RYAN: This is what politicians do when they don't have a record to run on: try to scare people from voting for you. If you don't get ahead of this problem, it's going to...[crosstalk] BIDEN: Medicare beneficiaries — there are more beneficiaries...[crosstalk] RADDATZ: We're going to — we're going to move...[crosstalk]... very simple question...[crosstalk] RYAN: We're not going to run away. Medicare and Social Security did so much for my own family. We are not going to jeopardize this program, but we have to save it...[crosstalk] BIDEN: You are jeopardizing this program. You're changing the program from a guaranteed benefit to premium support. Whatever you call it, the bottom line is people are going to have to pay more money out of their pocket and the families I know and the families I come from, they don't have the money to pay more out...[crosstalk] RYAN: That's why we're saying more for lower income people and less for higher income people. RADDATZ: Gentlemen, I would like to move on to a very simple question for both of you, and something tells me I won't get a very simple answer, but let me ask you this. BIDEN: I gave you a simple answer. He's raising the cost of Medicare. RADDATZ: OK, on to taxes. If your ticket is elected, who will pay more in taxes? Who will pay less? And we're starting with Vice President Biden for two minutes. BIDEN: The middle class will pay less and people making $1 million or more will begin to contribute slightly more. Let me give you one concrete example. The continuation of the Bush tax cuts — we are arguing that the Bush tax cuts for the wealthy should be allowed to expire. Of the Bush tax cuts for the wealthy, $800 million — billion of that goes to people making a minimum of $1 million. We see no justification in these economic times for those, and they're patriotic Americans. They're not asking for this continued tax cut. They're not suggesting it, but my friends are insisting on it; 120,000 families by continuing that tax cut will get an additional $500 billion in tax relief in the next 10 years and their income is an average of $8 million. We want to extend permanently the middle-class tax cut for — permanently, from the Bush middle-class tax cut. These guys won't allow us to. You know what they're saying? We say "let's have a vote — let's have a vote on the middle-class tax cut and let's have a vote on the upper tax cut; let's go ahead and vote on it." They're saying no. They're holding hostage the middle class tax cut to the super wealthy. And on top of that, they've got another tax cut coming that's $5 trillion that all of the studies point out will in fact give another $250 million — yeah, $250,000 a year to those 120,000 families and raise taxes for people who are middle income with a child by $2,000 a year. This is unconscionable. There is no need for this. The middle class got knocked on their heels. The great recession crushed them. They need some help now. The last people who need help are 120,000 families for another — another $500 billion tax cut over the next 10 years. RADDATZ: Congressman? RYAN: Our entire premise of these tax reform plans is to grow the economy and create jobs. It's a plan that's estimated to create 7 million jobs. Now, we think that government taking 28 percent of a family and business's income is enough. President Obama thinks that the government ought to be able to take as much as 44.8 percent of a small business's income. Look, if you taxed every person and successful business making over $250,000 at 100 percent, it would only run the government for 98 days. If everybody who paid income taxes last year, including successful small businesses, doubled their income taxes this year, we'd still have a $300 billion deficit. You see? There aren't enough rich people and small businesses to tax to pay for all their spending. And so the next time you hear them say, "Don't worry about it, we'll get a few wealthy people to pay their fair share," watch out, middle class, the tax bill's coming to you. That's why we're saying we need fundamental tax reform. Let's take a look at it this way. Eight out of 10 businesses, they file their taxes as individuals, not as corporations. And where I come from, overseas, which is Lake Superior, the Canadians, they dropped their tax rates to 15 percent. The average tax rate on businesses in the industrialized world is 25 percent, and the president wants the top effective tax rate on successful small businesses to go above 40 percent. Two-thirds of our jobs come from small businesses. This one tax would actually tax about 53 percent of small-business income. It's expected to cost us 710,000 jobs. And you know what? It doesn't even pay for 10 percent of their proposed deficit spending increases. What we are saying is, lower tax rates across the board and close loopholes, primarily to the higher-income people. We have three bottom lines: Don't raise the deficit, don't raise taxes on the middle class, and don't lower the share of income that is borne by the high-income earners. He'll keep saying this $5 trillion plan, I suppose. It's been discredited by six other studies. And even their own deputy campaign manager acknowledged that it wasn't correct. RADDATZ: Well, let's talk about this 20 percent. You have refused — and, again — to offer specifics on how you pay for that 20 percent across-the-board tax cut. Do you actually have the specifics? Or are you still working on it, and that's why you won't tell voters? RYAN: Different than this administration, we actually want to have big bipartisan agreements. You see, I understand the... RADDATZ: Do you have the specifics? Do you have the...[crosstalk] BIDEN: That would — that would be a first for the Republican Congress. RADDATZ: Do you know exactly what you're doing? RYAN: Look — look at what Mitt Romney — look at what Ronald Reagan and Tip O'Neill did. They worked together out of a framework to lower tax rates and broaden the base, and they worked together to fix that. What we're saying is, here's our framework. Lower tax rates 20 percent. We raised about $1.2 trillion through income taxes. We forego about $1.1 trillion in loopholes and deductions. And so what we're saying is, deny those loopholes and deductions to higher-income taxpayers so that more of their income is taxed, which has a broader base of taxation... BIDEN: Can I translate? RYAN: ... so we can lower tax rates across the board. Now, here's why I'm saying this. What we're saying is, here's the framework... BIDEN: I hope I'm going to get time to respond to this. RADDATZ: You'll get time. RYAN: We want to work with Congress — we want to work with the Congress on how best to achieve this. That means successful. Look... RADDATZ: No specifics, again. RYAN: Mitt — what we're saying is, lower tax rates 20 percent, start with the wealthy, work with Congress to do it... RADDATZ: And you guarantee this math will add up? RYAN: Absolutely. Six studies have guaranteed — six studies have verified that this math adds up. But here's... RADDATZ: Vice President Biden...[crosstalk] BIDEN: Look...[crosstalk]... let me translate. Let me have a chance to translate. RYAN: I'll come back in a second, then, right? BIDEN: First of all, I was there when Ronald Reagan tax breaks — he gave specifics of what he was going to cut, number one, in terms of tax expenditures. Number two, 97 percent of the small businesses in America pay less — make less than $250,000. Let me tell you who some of those other small businesses are: hedge funds that make $600 million, $800 million a year. That's — that's what they count as small businesses, because they're pass- through. Let's look at how sincere they are. Ronald — I mean, excuse me, Governor Romney on "60 Minutes" — I guess it was about 10 days ago — was asked, "Governor, you pay 14 percent on $20 million. Someone making $50,000 pays more than that. Do you think that's fair?" He said, "Oh, yes, that's fair. That's fair." This is — and they're going to talk — you think these guys are going to go out there and cut those loopholes? The loophole — the biggest loophole they take advantage of is the carried interest loophole and — and capital gains loophole. They exempt that. Now, there's not enough — the reason why the AEI study, the American Enterprise Institute study, the Tax Policy Center study, the reason they all say it's going — taxes go up on the middle class, the only way you can find $5 trillion in loopholes is cut the mortgage deduction for middle-class people, cut the health care deduction, middle-class people, take away their ability to get a tax break to send their kids to college. That's why they arrive at it. RADDATZ: Is he wrong about that? RYAN: He is wrong about that. They're... BIDEN: How's that? RYAN: You can — you can cut tax rates by 20 percent and still preserve these important preferences for middle-class taxpayers... BIDEN: Not mathematically possible. RYAN: It is mathematically possible. It's been done before. It's precisely what we're proposing. BIDEN: It has never been done before. RYAN: It's been done a couple of times, actually. BIDEN: It has never been done before. RYAN: Jack Kennedy lowered tax rates, increased growth. Ronald Reagan... BIDEN: Oh, now you're Jack Kennedy? [laughter] RYAN: Ronald Reagan — Republicans and Democrats... BIDEN: This is amazing. RYAN: Republican and Democrats have worked together on this. BIDEN: That's right. RYAN: You know, I understand you guys aren't used to doing bipartisan deals... BIDEN: But we told each other what we're going to do. RYAN: Republicans and Democrats... BIDEN: When we did it Reagan, we said, here — here are the things we're going to cut. [crosstalk] That's what we said. RYAN: We said here's the framework, let's work together to fill in the details. That's exactly... BIDEN: Fill in the detail. RYAN: That's how you get things done. You work with Congress — look, let me say it this way. [crosstalk] BIDEN: That's coming from a Republican Congress working bipartisanly, 7 percent rating? Come on. RYAN: Mitt Romney was governor of Massachusetts, where 87 percent of the legislators he served, which were Democrats. He didn't demonize them. He didn't demagogue them. He met with those party leaders every week. He reached across the aisle. He didn't compromise principles. BIDEN: And you saw what happened. RYAN: He found common ground — and he balanced the budget... BIDEN: You saw — if he did such a great job... RADDATZ: Mr. Vice President...[crosstalk] RYAN: ... four times without raising taxes... BIDEN: Why isn't he even contesting Massachusetts? [crosstalk] RADDATZ: Mr. Vice President, what would you suggest — what would you suggest beyond raising taxes on the wealthy, that would substantially reduce the long-term deficit? BIDEN: Just let the taxes expire like they're supposed to on those millionaires. We don't — we can't afford $800 billion going to people making a minimum of $1 million. They do not need it, Martha. Those 120,000 families make $8 million a year. Middle-class people need the help. Why does my friend cut out the tuition tax credit for them? Why does he go after the childcare... RADDATZ: Can you declare anything off-limits? BIDEN: Why do they do that? RADDATZ: Can you declare anything off-limits? RYAN: Yeah, we're saying close loopholes... RADDATZ: Home mortgage deduction? RYAN: ... on high-interest people. RADDATZ: Home mortgage deduction? RYAN: For higher-income people. Here... BIDEN: Can you guarantee that no one making less than $100,000 will have a mortgage — their mortgage deduction impacted? Guarantee? RYAN: This taxes a million small businesses. He keeps trying to make you think that it's just some movie star or hedge fund guy or an actor... BIDEN: Ninety-seven percent of the small businesses make less than $250,000 a year, would not be affected. RYAN: Joe, you know it hits a million — this taxes a million people, a million small businesses. BIDEN: Does it tax 97 percent of the American businesses? RYAN: It taxes a million small businesses... BIDEN: Small businesses? RYAN: ... who are our greatest job creators. BIDEN: I wish I'd get — the "greatest job creators" are the hedge fund guys. RADDATZ: And you're — and you're going to increase the defense budget. RYAN: Think about it this way. RADDATZ: And you're going to increase the defense budget. RYAN: No, we're not just going to cut the defense budget like they're — they're proposing... BIDEN: They're going to increase it $2 billion. RYAN: That's not...[crosstalk] We're talking about... RADDATZ: So no massive defense increases? RYAN: No, we're saying don't — OK, you want to get into defense now? RADDATZ: Yes, I do. I do, because that's another math question. RYAN: So — right, OK. RADDATZ: How do you do that? RYAN: So they proposed a $478 billion cut to defense to begin with. Now we have another $500 billion cut to defense that's lurking on the horizon. They insisted upon that cut being involved in the debt negotiations, and so we have a $1 trillion cut... RADDATZ: Let's put the automatic defense cuts aside, OK? RYAN: Right, OK. RADDATZ: Let's put those aside. No one wants that. BIDEN: I'd like to go back to that. RADDATZ: But I want to know how you do the math and have this increase in defense spending? BIDEN: Two trillion dollars. RYAN: You don't cut defense by a trillion dollars. That's what we're talking about. RADDATZ: And what — what national security issues justify an increase? BIDEN: Who's cutting it by $1 trillion? RYAN: We're going to cut 80,000 soldiers, 20,000 Marines, 120 cargo planes. We're going to push the Joint Strike Fighter out... RADDATZ: Drawing down in one war and one war... RYAN: If these cuts go through, our Navy will be the smallest — the smallest it has been since before World War I. This invites weakness. Look, do we believe in peace through strength? You bet we do. And that means you don't impose these devastating cuts on our military. So we're saying don't cut the military by a trillion dollars. Not increase it by a trillion, don't cut it by a trillion dollars. RADDATZ: Quickly, Vice President Biden on this. I want to move on. BIDEN: Look, we don't cut it. And I might add, this so-called — I know we don't want to use the fancy word "sequester," this automatic cut — that was part of a debt deal that they asked for. And let me tell you what my friend said at a press conference announcing his support of the deal. He said, and I'm paraphrase, We've been looking for this moment for a long time. RYAN: Can I tell you what that meant? [crosstalk] We've been looking for bipartisanship for a long time. BIDEN: And so the bipartisanship is what he voted for, the automatic cuts in defense if they didn't act. And beyond that, they asked for another — look, the military says we need a smaller, leaner Army, we need more special forces, we need — we don't need more M1 tanks, what we need is more UAVs. RADDATZ: Some of the military. [crosstalk] BIDEN: Not some of the military. That was the decision of the Joint Chiefs of Staff, recommended to us and agreed to by the president. That is a fact. RADDATZ: Who answers to a civilian leader. BIDEN: They made the recommendation first. RADDATZ: OK. Let's move on to Afghanistan. RYAN: Can I get into that for a second? RADDATZ: I'd like to move on to Afghanistan please. And that's one of the biggest expenditures this country has made, in dollars, and more importantly in lives. We just passed the sad milestone of losing 2,000 U.S. troops there in this war. More than 50 of them were killed this year by the very Afghan forces we are trying to help. Now, we've reached the recruiting goal for Afghan forces, we've degraded Al Qaida. So tell me, why not leave now? What more can we really accomplish? Is it worth more American lives? RYAN: We don't want to lose the gains we've gotten. We want to make sure that the Taliban does not come back in and give Al Qaida a safe haven. We agree with the administration on their 2014 transition. Look, when I think about Afghanistan, I think about the incredible job that our troops have done. You've been there more than the two of us combined. First time I was there in 2002, it was amazing to me what they were facing. When I went to the Ahgandah [ph] Valley in Kandahar before the surge, I sat down with a young private in the 82nd from the Monamanee [ph] Indian reservation who would tell me what he did every day, and I was in awe. And to see what they had in front of them. And then to go back there in December, to go throughout Helmand with the Marines, to see what they had accomplished, it's nothing short of amazing. What we don't want to do is lose the gains we've gotten. Now, we've disagreed from time to time on a few issues. We would have more likely taken into accounts the recommendations from our commanders, General Petraeus, Admiral Mullen, on troop levels throughout this year's fighting season. We've been skeptical about negotiations with the Taliban, especially while they're shooting at us. But we want to see the 2014 transition be successful, and that means we want to make sure our commanders have what they need to make sure that it is successful so that this does not once again become a launching pad for terrorists. RADDATZ: Vice President Biden? BIDEN: Martha, let's keep our eye on the ball. The reason — I've been in and out of Afghanistan and Iraq 20 times. I've been up in the Konar [ph] Valley. I've been throughout that whole country, mostly in a helicopter, and sometimes in a vehicle. The fact is, we went there for one reason: to get those people who killed Americans, Al Qaida. We've decimated Al Qaida central. We have eliminated Osama bin Laden. That was our purpose. And, in fact, in the meantime, what we said we would do, we would help train the Afghan military. It's their responsibility to take over their own security. That's why with 49 of our allies in Afghanistan, we've agreed on a gradual drawdown so we're out of there by the year 20 — in the year 2014. My friend and the governor say it's based on conditions, which means it depends. It does not depend for us. It is the responsibility of the Afghans to take care of their own security. We have trained over 315,000, mostly without incident. There have been more than two dozen cases of green-on-blue where Americans have been killed. If we do not — if the measures the military has taken do not take hold, we will not go on joint patrols. We will not train in the field. We'll only train in the — in the Army bases that exist there. But we are leaving. We are leaving in 2014. Period. And in the process, we're going to be saving over the next 10 years another $800 billion. We've been in this war for over a decade. The primary objective is almost completed. Now, all we're doing is putting the Kabul government in a position to be able to maintain their own security. It's their responsibility, not America's. RADDATZ: What — what conditions could justify staying, Congressman Ryan? RYAN: We don't want to stay. We want — look, one of my best friends in Janesville, a reservist, is at a forward-operating base in eastern Afghanistan right now. Our wives are best friends. Our daughters are best friends. I want — I want him and all of our troops to come home as soon and safely as possible. We want to make sure that 2014 is successful. That's why we want to make sure that we give our commanders what they say they need to make it successful. We don't want to extend beyond 2014. That's the point we're making. You know, if it was just this, I'd feel like we would — we would be able to call this a success, but it's not. What we are witnessing as we turn on our television screens these days is the absolute unraveling of the Obama foreign policy. Problems are growing at home, but — problems are growing abroad, but jobs aren't growing here at home. RADDATZ: Let me go back to this. He says we're absolutely leaving in 2014. You're saying that's not an absolute, but you won't talk about what conditions would justify...[crosstalk] RYAN: Do you know why we say that? BIDEN: I'd like to know...[crosstalk] RYAN: Because we don't want to broadcast to our enemies "put a date on your calendar, wait us out, and then come back." We want to make sure...[crosstalk] RADDATZ: But you agree with the timeline. RYAN: We do agree — we do agree with the timeline and the transition, but what we — what any administration will do in 2013 is assess the situation to see how best to complete this timeline. What we do not want to do... BIDEN: We will leave in 2014. RYAN: ... what we don't want to do is give our allies reason to trust us less and our enemies more — we don't want to embolden our enemies to hold and wait out for us and then take over...[crosstalk] BIDEN: Martha, that's a bizarre statement. RYAN: That's why we want to make sure — no, that's why we want to make sure that...[crosstalk] BIDEN: Forty-nine of our allies — hear me — 49 of our allies signed on to this position. RYAN: And we're reading that they want to...[crosstalk] BIDEN: Forty-nine — 49 of our allies said "out in 2014." It's the responsibility of the Afghans. We have other responsibilities... [crosstalk] RADDATZ: Do you really think that this timeline...[crosstalk] RYAN: Which is — which is...[crosstalk] RADDATZ: We have — we have soldiers and Marines. We have Afghan forces murdering our forces over there. The Taliban is, do you think, taking advantage of this timeline? BIDEN: Look, the Taliban — what we've found out, and we — you saw it in Iraq, Martha, unless you set a timeline, Baghdad, in the case of Iraq, and — and Kabul, in the case of Afghanistan will not step up. They're happy to let us continue to do the job; international security forces to do the job. The only way they step up is to say, "Fellas, we're leaving; we've trained you; step up, step up." RADDATZ: Let me go back. BIDEN: That's the only way it works. RADDATZ: Let me go back to the — the surge troops that we put in there. And — and you brought this up, Congressman Ryan. I have talked to a lot of troops. I've talked to senior offices who were concerned that the surge troops were pulled out during the fighting season, and some of them saw that as a political — as a political move. So can you tell me, Vice President Biden, what was the military reason for bringing those surge troops home... BIDEN: The military reason... RADDATZ: ... before the fighting had ended? BIDEN: ... was bringing — by the way, when the president announced the surge, you'll remember, Martha, he said the surge will be out by the end of the summer. The military said the surge will be out. Nothing political about this. Before the surge occurred — so you be a little straight with me here, too — before the surge occurred, we said they'll be out by the end of the summer. That's what the military said. The reason for that is... RADDATZ: The military follows orders. I mean, there — trust me. There are people who were concerned about pulling out on the fighting season. BIDEN: Sure. There are people that are concerned, but not the Joint Chiefs. That was their recommendation in the Oval Office to the president of the United States of America. I sat there. I'm sure you'll find someone who disagrees with the Pentagon. I'm positive you'll find that within the military. But that's not the case here. And, secondly, the reason why the military said that is, you cannot wait and have a cliff. It takes — you know — months and months and months to draw down forces. RYAN: Let me...[crosstalk] Let me try and illustrate the issue here, because I think this — it can get a little confusing. We've all met with General Allen and General Scaparrotti in Afghanistan to talk about fighting seasons. Here's the way it works. The mountain passes fill in with snow. The Taliban and the terrorists and the Haqqani and the Quetta Shura come over from Pakistan to fight our men and women. When it fills in with snow, they can't do it. That's what we call fighting seasons. In the warm months, fighting gets really high. In the winter, it goes down. And so when Admiral Mullen and General Petraeus came to Congress and said, if you pull these people out before the fighting season is end, it puts people more at risk. That's the problem. Yes, we drew 22,000 troops down last month, but the remaining troops that are there, who still have the same mission to prosecute counterinsurgency, are doing it with fewer people. That makes them less safe. BIDEN: Fighting season... RYAN: We're sending fewer people out in all of these hotspots to do the same job that they were supposed to do a month ago. BIDEN: Because we turned it over... RYAN: But we took 22,000 people out... BIDEN: ... we turned it over to the Afghan troops we trained. No one got pulled out that didn't get filled in by trained Afghan personnel. And he's — he's conflating two issues. The fighting season that Petraeus was talking about and former — and Admiral Mullen was the fighting season this spring. That's what he was talking about. We did not — we did not pull them out. RYAN: The calendar works the same every year. BIDEN: It does work the same every year. But we're not staying there... RYAN: Spring, summer, fall. It's warm, or it's not. They're still fighting us. They're still coming over the passes. They're still coming into Zabul, to Kunar, to all of these areas, but we are sending fewer people to the front to fight them. And that's...[crosstalk] BIDEN: That's right, because that's the Afghan responsibility. We've trained them. RYAN: Not in the east. RADDATZ: Let's move — let's move to another war. BIDEN: Not in the east? RYAN: R.C. East — R.C. East... BIDEN: R.C. East is the most dangerous place in the world. RYAN: That's right. That's why we don't want to send fewer people to the... BIDEN: That's — that's why we should send Americans in to do the job, instead of the — you'd rather Americans be going in doing the job instead of the trainees? RYAN: No. We are already sending Americans to do the job, but fewer of them. That's the whole problem. BIDEN: That's right. We're sending in more Afghans to do the job, Afghans to do the job. RADDATZ: Let's move to another war, the civil war in Syria, where there are estimates that more — estimates that more than 25,000, 30,000 people have now been killed. In March of last year, President Obama explained the military action taken in Libya by saying it was in the national interest to go in and prevent further massacres from occurring there. So why doesn't the same logic apply in Syria? Vice President Biden? BIDEN: Different country. It's a different country. It is five times as large geographically, it has one-fifth the population, that is Libya, one-fifth the population, five times as large geographically. It's in a part of the world where they're not going to see whatever would come from that war. It seep into a regional war. You're in a country that is heavily populated in the midst of the most dangerous area in the world. And, in fact, if in fact it blows up and the wrong people gain control, it's going to have impact on the entire region causing potentially regional wars. We are working hand and glove with the Turks, with the Jordanians, with the Saudis, and with all the people in the region attempting to identify the people who deserve the help so that when Assad goes — and he will go — there will be a legitimate government that follows on, not an Al Qaida-sponsored government that follows on. And all this loose talk of my friend, Governor Romney, and the congressman, about how we're going to do, we could do so much more in there, what more would they do other than put American boots on the ground? The last thing America needs is to get in another ground war in the Middle East, requiring tens of thousands, if not well over 100,000 American forces. That — they are the facts. They are the facts. Now, every time the governor is asked about this, he doesn't say anything. He — he goes up with a whole lot of verbiage, but when he gets pressed he says, no, he would not do anything different than we are doing now. Are they proposing putting American troops on the ground? Putting American aircraft in the airspace? Is that what they're proposing? If they do, they should speak up and say so, but that's not what they're saying. We are doing it exactly like we need to do to identify those forces who, in fact, will provide for a stable government and not cause a regional Sunni-Shia war when Bassad — when Bashar Assad falls. RADDATZ: Congressman Ryan? RYAN: Nobody is proposing to send troops to Syria. American troops. Now, let me say it this way. How would we do things differently? We wouldn't refer to Bashar Assad as a reformer when he's killing his own civilians with his Russian-provided weapons. We wouldn't be outsourcing our foreign policy to the United Nations giving Vladimir Putin veto power over our efforts to try and deal with this issue. He's vetoed three of them. Hillary Clinton went to Russia to try and convince them not to do so. They thwarted her efforts. She said they were on the wrong side of history. She was right about that. This is just one more example of how the Russia reset's not working. And so where are we? After international pressure mounted, the President Obama said Bashar Assad should go. It's been over a year. The man has slaughtered tens of thousands of his own people. And more foreign fighters are spilling into this country. So the longer this has gone on, the more people, groups like Al Qaida are going in. We could have more easily identified the free Syrian army, the freedom fighters, working with our allies, the Turks, the Qataris, the Saudis, had we had a better plan in place to begin with working through our allies. But, no, we waited for Kofi Annan to try and come up with an agreement through the U.N. That bought Bashar Assad time. We gave Russia veto power over our efforts through the U.N. And meanwhile about 30,000 Syrians are dead. BIDEN: What would my friend do differently? If you notice, he never answers the question. RYAN: No, I would — I — we would not be going through the U.N. in all of these things. BIDEN: Let me — you don't go through the U.N. We are in the process now — and have been for months — in making sure that help, humanitarian aid, as well as other aid and training is getting to those forces that we believe, the Turks believe, the Jordanians believe, the Saudis believe are the free forces inside of Syria. That is underway. Our allies were all on the same page, NATO, as well as our Arab allies, in terms of trying to get a settlement. That was their idea. We're the ones that said, "Enough." With regard to the reset not working, the fact of the matter is that Russia has a different interest in Syria than we do, and that's not in our interest. RADDATZ: What happens if Assad does not fall, Congressman Ryan? What happens to the region? What happens if he hangs on? What happens if he does? RYAN: Then Iran keeps their greatest ally in the region. He's a sponsor of terrorism. He'll probably continue slaughtering his people. We and the world community will lose our credibility on this. Look, he mentioned the reset... RADDATZ: So what would Romney-Ryan do about that credibility? RYAN: Well, we agree with the same red line, actually, they do on chemical weapons, but not putting American troops in, other than to secure those chemical weapons. They're right about that. But what we should have done earlier is work with those freedom fighters, those dissidents in Syria. We should not have called Bashar Assad a reformer. And... RADDATZ: What's your criteria...[crosstalk] RYAN: ... we should not have — we should not have waited to Russia... RADDATZ: What's your criteria...[crosstalk] RYAN: ... should not have waited for Russia to give us the green light at the U.N. to do something about it. BIDEN: Russia... RYAN: They're — they're still arming the man. Iran is flying flights over Iraq... BIDEN: And the opposition is being armed. RYAN: ... to help Bashar Assad. And, by the way, if we had the status-of-forces agreement that the vice president said he would bet his vice presidency on in Iraq, we probably would have been able to prevent that. But he failed to achieve that, as well, again. RADDATZ: Let me ask you a quick question. BIDEN: I don't... RADDATZ: What's your criteria for intervention? BIDEN: Yeah. RYAN: In Syria? RADDATZ: Worldwide. RYAN: What is in the national interests of the American people. RADDATZ: How about humanitarian interests? RYAN: What is in the national security of the American people. It's got to be in the strategic national interests of our country. RADDATZ: No humanitarian? RYAN: Each situation will — will come up with its own set of circumstances, but putting American troops on the ground? That's got to be within the national security interests of the American people. RADDATZ: I want to — we're — we're almost out of time here. RYAN: That means like embargoes and sanctions and overflights, those are things that don't put American troops on the ground. But if you're talking about putting American troops on the ground, only in our national security interests. RADDATZ: I want to move on, and I want to return home for these last few questions. This debate is, indeed, historic. We have two Catholic candidates, first time, on a stage such as this. And I would like to ask you both to tell me what role your religion has played in your own personal views on abortion. Please talk about how you came to that decision. Talk about how your religion played a part in that. And, please, this is such an emotional issue for so many people in this country... RYAN: Sure. RADDATZ: ... please talk personally about this, if you could. Congressman Ryan? RYAN: I don't see how a person can separate their public life from their private life or from their faith. Our faith informs us in everything we do. My faith informs me about how to take care of the vulnerable, of how to make sure that people have a chance in life. Now, you want to ask basically why I'm pro-life? It's not simply because of my Catholic faith. That's a factor, of course. But it's also because of reason and science. You know, I think about 10 1/2 years ago, my wife Janna and I went to Mercy Hospital in Janesville where I was born, for our seven week ultrasound for our firstborn child, and we saw that heartbeat. A little baby was in the shape of a bean. And to this day, we have nicknamed our firstborn child Liza, "Bean." Now I believe that life begins at conception. That's why — those are the reasons why I'm pro-life. Now I understand this is a difficult issue, and I respect people who don't agree with me on this, but the policy of a Romney administration will be to oppose abortions with the exceptions for rape, incest and life of the mother. What troubles me more is how this administration has handled all of these issues. Look at what they're doing through Obamacare with respect to assaulting the religious liberties of this country. They're infringing upon our first freedom, the freedom of religion, by infringing on Catholic charities, Catholic churches, Catholic hospitals. Our church should not have to sue our federal government to maintain their religious liberties. And with respect to abortion, the Democratic Party used to say they wanted it to be safe, legal and rare. Now they support it without restriction and with taxpayer funding. Taxpayer funding in Obamacare, taxpayer funding with foreign aid. The vice president himself went to China and said that he sympathized and wouldn't second guess their one child policy of forced abortions and sterilizations. That to me is pretty extreme. RADDATZ: Vice President Biden? BIDEN: My religion defines who I am, and I've been a practicing Catholic my whole life. And has particularly informed my social doctrine. The Catholic social doctrine talks about taking care of those who — who can't take care of themselves, people who need help. With regard to — with regard to abortion, I accept my church's position on abortion as a — what we call a [inaudible] doctrine. Life begins at conception in the church's judgment. I accept it in my personal life. But I refuse to impose it on equally devout Christians and Muslims and Jews, and I just refuse to impose that on others, unlike my friend here, the — the congressman. I — I do not believe that we have a right to tell other people that — women they can't control their body. It's a decision between them and their doctor. In my view and the Supreme Court, I'm not going to interfere with that. With regard to the assault on the Catholic church, let me make it absolutely clear, no religious institution, Catholic or otherwise, including Catholic Social Services, Georgetown Hospital, Mercy Hospital, any hospital, none has to either refer contraception, none has to pay for contraception, none has to be a vehicle to get contraception in any insurance policy they provide. That is a fact. That is a fact. Now with regard to the way in which the — we differ, my friend says that he — well I guess he accepts Governor Romney's position now, because in the past he has argued that there was — there's rape and forcible rape. He's argued that in the case of rape or incest, it was still — it would be a crime to engage in having an abortion. I just fundamentally disagree with my friend. RADDATZ: Congressman Ryan. RYAN: All I'm saying is, if you believe that life begins at conception, that, therefore, doesn't change the definition of life. That's a principle. The policy of a Romney administration is to oppose abortion with exceptions for rape, incest and life of the mother. Now, I've got to take issue with the Catholic church and religious liberty. BIDEN: You have on the issue... [crosstalk] RYAN: ... why would they keep — why would they keep suing you? It's a distinction without a difference. RADDATZ: I want to go back to the abortion question here. If the Romney-Ryan ticket is elected, should those who believe that abortion should remain legal be worried? RYAN: We don't think that unelected judges should make this decision; that people through their elected representatives in reaching a consensus in society through the democratic process should make this determination. BIDEN: The court — the next president will get one or two Supreme Court nominees. That's how close Roe v. Wade is. Just ask yourself, with Robert Bork being the chief adviser on the court for — for Mr. Romney, who do you think he's likely to appoint? Do you think he's likely to appoint someone like Scalia or someone else on the court far right that would outlaw [inaudible] — outlaw abortion? I suspect that would happen. I guarantee you, that will not happen. We picked two people. We pick people who are open-minded. They've been good justices. So keep an eye on the Supreme Court... RYAN: Was there a litmus test on them? BIDEN: There was no litmus test. We picked people who had an open mind; did not come with an agenda. RADDATZ: I'm — I'm going to move on to this closing question because we are running out of time. Certainly [inaudible] and you've said it here tonight, that the two of you respect our troops enormously. Your son has served and perhaps someday your children will serve as well. I recently spoke to a highly decorated soldier who said that this presidential campaign has left him dismayed. He told me, quote, "the ads are so negative and they are all tearing down each other rather than building up the country." What would you say to that American hero about this campaign? And at the end of the day, are you ever embarrassed by the tone? Vice President Biden? BIDEN: I would say to him the same thing I say to my son who did serve a year in Iraq, that we only have one truly sacred obligation as a government. That's to equip those we send into harm's way and care for those who come home. That's the only sacred obligation we have. Everything else falls behind that. I would also tell him that the fact that he, this decorated soldier you talked about, fought for his country, that that should be honored. He should not be thrown into a category of a 47 percent who don't pay their taxes while he was out there fighting and not having to pay taxes, and somehow not taking responsibility. I would also tell him that there are things that have occurred in this campaign and occur in every campaign that I'm sure both of us regret anyone having said, particularly in these — these special new groups that can go out there, raise all the money they want, not have to identify themselves, who say the most scurrilous things about the other candidate. It's — it's an abomination. But the bottom line here is I'd ask that hero you referenced to take a look at whether or not Governor Romney or President Obama has the conviction to help lift up the middle class, restore them to where they were before this great recession hit and they got wiped out. Or whether or not he's going to continue to focus on taking care of only the very wealthy, not asking them to make — pay any part of the deal to bring — bring back the middle class and the economy of this country. I'd ask him to take a look at whether the president of the United States has acted wisely in the use of force and whether or not the slipshod comments being made by my — my — or by Governor Romney serve — serve our interests very well. But there are things that have been said in campaigns that I — I find not very appealing. RADDATZ: Congressman Ryan? RYAN: First of all, I'd thank him to his service to our country. Second of all, I'd say we are not going to impose these devastating cuts on our military which compromises their mission and their safety. And then I would say, you have a president who ran for president four years ago promising hope and change, who has now turned his campaign into attack, blame and defame. You see, if you don't have a good record to run on, then you paint your opponent as someone to run from. That was what President Obama said in 2008. It's what he's doing right now. Look at all the string of broken promises. If you like your health care plan, you can keep it. Try telling that to the 20 million people who are projected to lose their health insurance if Obamacare goes through or the 7-point million — 7.4 million seniors who are going to lose it. Or remember when he said this: I guarantee if you make less than $250,000, your taxes won't go up. Of the 21 tax increases in Obamacare, 12 of them hit the middle class. Or remember when he said health insurance premiums will go down $2,500 per family, per year? They've gone up $3,000, and they're expected to go up another $2,400. Or remember when he said, "I promise by the end of my first term I'll cut the deficit in half in four years"? We've had four budgets, four trillion-dollar deficits. A debt crisis is coming. We can't keep spending and borrowing like this. We can't keep spending money we don't have. Leaders run to problem to fix problems. President Obama has not even put a credible plan on the table in any of his four years to deal with this debt crisis. I passed two budgets to deal with this. Mitt Romney's put ideas on the table. We've got to tackle this debt crisis before it tackles us. The president likes to say he has a plan. He gave a speech. We asked his budget office, "Can we see the plan?" They sent us to the press secretary. He gave us a copy of the speech. We asked the Congressional Budget Office, "Tell us what President Obama's plan is to prevent a debt crisis." They said, "It's a speech, we can't estimate speeches." You see, that's what we get in this administration — speeches — but we're not getting leadership. Mitt Romney is uniquely qualified to fix these problems. His lifetime of experience, his proven track record of bipartisanship. And what do we have from the president? He broke his big promise to bring people together to solve the country's biggest problems. And what I would tell him is we don't have to settle for this. BIDEN: Martha? RYAN: We can do better than this. BIDEN: I hope I'll get equal time. RADDATZ: You will get just a few minutes here. A few seconds, really. BIDEN: The two budgets the congressman introduced have eviscerated all the things that the middle class cares about. It is [inaudible] he will knock 19 million people off of Medicare. It will kick 200,000 children off of early education. It will eliminate the tax credit people have to be able to send their children to college. It cuts education by $450 billion. It does — it does virtually nothing except continue to increase the tax cuts for the very wealthy. And, you know, we've had enough of this. The idea that he's so concerned about these deficits, I've pointed out he voted to put two wars on a credit card. He did... RADDATZ: We're going to — we're going to the closing statements in a minute. [crosstalk] You're going to have your closing statement. RYAN: Not raising taxes is not cutting taxes. And by the way, our budget... BIDEN: We have not raised...[crosstalk] RYAN: ... by 3 percent a year instead of 4.5 percent like they propose. Not spending more money as much as they say is not a spending cut. RADDATZ: Let me — let me calm down things here just for a minute. And I want to talk to you very briefly before we go to closing statements about your own personal character. If you are elected, what could you both give to this country as a man, as a human being, that no one else could? RYAN: Honesty, no one else could? There are plenty of fine people who could lead this country. But what you need are people who, when they say they're going to do something, they go do it. What you need are, when people see problems, they offer solutions to fix those problems. We're not getting that. Look, we can grow this economy faster. That's what our five- point plan for a stronger middle class is all about. It's about getting 12 million jobs, higher take-home pay, getting people out of poverty into the middle class. That means going with proven, pro- growth policies that we know works to get people back to work. Putting ideas on the table, working with Democrats — that actually works sometimes — and then...[crosstalk] RADDATZ: Vice President, can we get to that — to that issue of what you could bring as a man, a human being? And I really — I'm going to keep you to about 15 seconds here. BIDEN: Well, he gets 40, I get 15, that's OK. RADDATZ: He didn't have 40. He didn't have 40. BIDEN: That's all right. Let me tell you. I — my — my record stands for itself. I never say anything I don't mean. Everybody knows, whatever I say, I do. And my whole life has been devoted to leveling the playing field for middle-class people, giving them an even break, treating Main Street and Wall Street the same, hold them to the same responsibility. Look at my record. It's been all about the middle class. They're the people who grow this country. We think you grow this country from the middle out, not from the top down. RADDATZ: OK, we now turn to the candidates for their closing statements. Thank you, gentlemen. And that coin toss, again, has Vice President Biden starting with the closing statement. BIDEN: Well, let — let me say at the outset that I want to thank you, Martha, for doing this, and Centre College. The fact is that we're in a situation where we inherited a god-awful circumstance. People are in real trouble. We acted to move to bring relief to the people who need the most help now. And — and in the process, we — in case you haven't noticed, we have strong disagreements, but I — you probably detected my frustration with their attitude about the American people. My friend says that 30 percent of the American people are takers. Romney points out 47 percent of the people won't take responsibility. He's talking about my mother and father. He's talking about the places I grew up in, my neighbors in Scranton and Claymont, and he's talking about — he's talking about the people that have built this country. All they're looking for, Martha, all they're looking for is an even shot. Whenever you give them the shot, they've done it. They've done it. Whenever you've leveled the playing field, they've been able to move. And they want a little bit of peace of mind. And the president and I are not going to rest until that playing field is leveled, they, in fact, have a clear shot, and they have peace of mind, until they can turn to their kid and say with a degree of confidence, "Honey, it's going to be OK. It's going to be OK." That's what this is all about. RADDATZ: Congressman Ryan? RYAN: I want to thank you, as well, Martha, Danville, Kentucky, Centre College, and I want to thank you, Joe. It's been an honor to engage in this critical debate. We face a very big choice. What kind of country are we going to be? What kind of country are we going to give our kids? President Obama, he had his chance. He made his choices. His economic agenda, more spending, more borrowing, higher taxes, a government takeover of health care. It's not working. It's failed to create the jobs we need. Twenty-three million Americans are struggling for work today. Fifteen percent of Americans are in poverty. This is not what a real recovery looks like. You deserve better. Mitt Romney and I want to earn your support. We're offering real reforms for a real recovery for every American. Mitt Romney — his experience, his ideas, his solutions — is uniquely qualified to get this job done. At a time when we have a jobs crisis in America, wouldn't it be nice to have a job-creator in the White House? The choice is clear: a stagnant economy that promotes more government dependency or a dynamic, growing economy that promotes opportunity and jobs. Mitt Romney and I will not duck the tough issues, and we will not blame others for the next four years. We will take responsibility. And we will not try to replace our founding principles. We will reapply our founding principles. The choice is clear, and the choice rests with you. And we ask you for your vote. Thank you. RADDATZ: And thank you both again. Thank you very much. BIDEN: Thank you. RADDATZ: This concludes the vice presidential debate. Please tune in next Tuesday for the second presidential debate at Hofstra University in New York. I'm Martha Raddatz of ABC News. I do hope all of you go to the polls. Have a good evening. [applause]
