# Presidential Debate in Winston-Salem, North Carolina

**Date:** October 11, 2000
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-winston-salem-north-carolina-0

---

MODERATOR: Let's welcome the candidates, Governor Bush and Vice President Gore. Good evening, from Wake Chapel at Wake Forest University at Winston-Salem, North Carolina. I'm Jim Lehrer of the News Hour on PBS. Welcome to this second election 2000 debate between the Republican candidate for president, George W. Bush of Texas, and the Democratic candidate, Vice President Al Gore. These debates are sponsored by the Commission on Presidential Debates. The format and the rules are those negotiated by representatives of the two campaigns. Only the subjects tonight and the questions are mine. The format tonight is that of a conversation. The only prevailing rule is that no single response can ever, ever exceed two minutes. The prevailing rule for the audience here in the hall is as always, absolute quiet, please. Good evening, Governor Bush, Vice President Gore. The end of our 90 minutes last week in Boston, the total time each of you took was virtually the same. Let's see if we can do the same tonight, or come close. Governor Bush, the first question goes to you. One of you is about to be elected the leader of the single-most powerful nation in the world, economically, financially, militarily, diplomatically, you name it. Have you formed any guiding principles for exercising this enormous power? BUSH: I have, I have. First question is what's in the best interests of the United States? What's in the best interests of our people? When it comes to foreign policy that will be my guiding question. Is it in our nation's interests? Peace in the Middle East is in our nation's interests. Having a hemisphere that is free for trade and peaceful is in our nation's interests. Strong relations in Europe is in our nation's interest. I've thought a lot about what it means to be the president. I also understand that an administration is not one person, but an administration is dedicated citizens who are called by the president to serve the country, to serve a cause greater than self, and so I've thought about an administration of people who represent all America, but people who understand my compassionate and conservative philosophy. I haven't started naming names except for one person, and that's Mr. Richard Cheney who I thought did a great job the other night. He's a vice presidential nominee who represents -- I think people got to see why I picked him. He's man of solid judgment and he's going to be a person to stand by my side. One of the things I've done in Texas is I've been able to put together a good team of people. I've been able to set clear goals. The goals ought to be an education system that leaves no child behind, Medicare for our seniors, a Social Security system that's safe and secure, foreign policy that's in our nation's interest, and a strong military, and then bring people together to achieve those goals. That's what a Chief Executive Officer does. So I've thought long and hard about the honor of being the President of the United States. MODERATOR: Vice President Gore? GORE: Yes, Jim. I've thought a lot about that particular question, and I see our greatest national strength coming from what we stand for in the world. I see it as a question of values. It is a great tribute to our founders that 224 years later this nation is now looked to by the peoples on every other continent and the peoples from every part of this earth as a kind of model for what their future could be. And I don't think that's just the kind of exaggeration that we take pride in as Americans. It's really true, even the ones that sometimes shake their fists at us. As soon as they have a change that allows the people to speak freely, they're wanting to develop some kind of blueprint that will help them be like us more, freedom, free markets, political freedom. So I think first and foremost our power ought to be wielded to in ways that form a more perfect union. The power of example is America's greatest power in the world. And that means, for example, standing up for human rights. It means addressing the problems of injustice and inequity, along the lines of race and ethnicity here at home, because in all these other places around the world where they're having these terrible problems, when they feel hope, it is often because they see in us a reflection of their potential. So we've got to enforce our civil rights laws. We've got to deal with things like racial profiling. And we have to keep our military strong. We have the strongest military, and I'll do whatever is necessary, if I'm president, to make sure that it stays that way. But our real power comes, I think, from our values. MODERATOR: Should the people of the world look at the United States, Governor, and say, should they fear us, should they welcome our involvement, should they see us as a friend, everybody in the world? How would you project us around the world, as president? BUSH: Well, I think they ought to look at us as a country that understands freedom where it doesn't matter who you are or how you're raised or where you're from, that you can succeed. I don't think they'll look at us with envy. It really depends upon how our nation conducts itself in foreign policy. If we're an arrogant nation, they'll resent us. If we're a humble nation, but strong, they'll welcome us. And it's -- our nation stands alone right now in the world in terms of power, and that's why we have to be humble. And yet project strength in a way that promotes freedom. So I don't think they ought to look at us in any way other than what we are. We're a freedom-loving nation and if we're an arrogant nation they'll view us that way, but if we're a humble nation they'll respect us. MODERATOR: A humble nation. GORE: I agree with that. I agree with that. I think that one of the problems that we have faced in the world is that we are so much more powerful than any single nation has been in relationship to the rest of the world than at any time in history, that I know about, anyway. That there is some resentment of U.S. power. So I think that the idea of humility is an important one. But I think that we also have to have a sense of mission in the world. We have to protect our capacity to push forward what America's all about. That means not only military strength and our values, it also means keeping our economy strong. You know, in the last, or two decades ago it was routine for leaders of foreign countries to come over here and say you guys have got to do something about these horrendous deficits because it's causing tremendous problems for the rest of the world, and we were lectured to all the time. The fact that we have the strongest economy in history today is not good enough. We need to do more. But the fact that it is so strong enables us to project the power for good that America can represent. MODERATOR: Does that give us -- does our wealth, our good economy, our power, bring with it special obligations to the rest of the world? BUSH: Yes, it does. Take, for example, Third World debt. I think we ought to be forgiving Third World debt under certain conditions. I think, for example, if we're convinced that a Third World country that's got a lot of debt would reform itself, that the money wouldn't go into the hands of a few but would go to help people, I think it makes sense for us to use our wealth in that way, or to trade debt for valuable rain forest lands, makes that much sense, yes. We do have an obligation, but we can't be all things to all people. We can help build coalitions but we can't put our troops all around the world. We can lend money but we have to do it wisely. We shouldn't be lending money to corrupt officials. So we have to be guarded in our generosity. MODERATOR: Let's go through some of the specifics now. New question. Vice President Gore, the governor mentioned the Middle East. Here we're talking at this stage in the game about diplomatic power that we have. What do you think the United States should do right now to resolve that conflict over there? GORE: The first priority has to be on ending the violence, dampening down the tensions that have arisen there. We need to call upon Syria to release the three Israeli soldiers who have been captured. We need to insist that Arafat send out instructions to halt some of the provocative acts of violence that have been going on. I think that we also have to keep a weather eye toward Saddam Hussein because he is taking advantage of this situation to once again make threats, and he needs to understand that he's not only dealing with Israel, he is dealing -- he's dealing with us if he is making the kind of threats that he's talking about there. The use of diplomacy in this situation has already, well, it goes hour-by-hour and day-by-day now. It's a very tense situation there. But in the last 24 hours there has been some subsiding of the violence there. It's too much to hope that this is going to continue, but I do hope that it will continue. Our country has been very active with regular conversations with the leaders there. And we just have to take it day-to-day right now. But one thing I would say where diplomacy is concerned, Israel should feel absolutely secure about one thing. Our bonds with Israel are larger than agreements or disagreements on some details of diplomatic initiatives. They are historic, they are strong, and they are enduring. And our ability to serve as an honest broker is something that we need to shepherd. MODERATOR: Governor? BUSH: Well, I think during the campaign, particularly now during this difficult period, we ought to be speaking with one voice, and I appreciate the way the administration has worked hard to calm the tensions. Like the vice president, I call on Chairman Arafat to have his people pull back to make the peace. I think credibility is going to be very important in the future in the Middle East. I want everybody to know should I be the president Israel's going to be our friend. I'm going to stand by Israel. Secondly, that I think it's important to reach out to moderate Arab nations, like Jordan and Egypt, Saudi Arabia and Kuwait. It's important to be friends with people when you don't need each other so that when you do there's a strong bond of friendship. And that's going to be particularly important in dealing not only with situations such as now occurring in Israel, but with Saddam Hussein. The coalition against Saddam has fallen apart or it's unraveling, let's put it that way. The sanctions are being violated. We don't know whether he's developing weapons of mass destruction. He better not be or there's going to be a consequence should I be the president. But it's important to have credibility and credibility is formed by being strong with your friends and resoluting your determination. One of the reasons why I think it's important for this nation to develop an anti-ballistic missile system that we can share with our allies in the Middle East if need be to keep the peace is to be able to say to the Saddam Husseins of the world or the Iranians, don't dare threaten our friends. It's also important to keep strong ties in the Middle East, credible ties, because of the energy crisis we're now in. After all, a lot of the energy is produced from the Middle East, and so I appreciate what the administration is doing. I hope to get a sense of should I be fortunate to be the president how my administration will react to the Middle East. MODERATOR: So you don't believe, Vice President Gore, that we should take sides and resolve this right now? A lot of people pushing hey, the United States should declare itself and not be so neutral in this particular situation. GORE: Well, we stand with Israel, but we have maintained the ability to serve as an honest broker. And one of the reasons that's important is that Israel cannot have direct dialogue with some of the people on the other side of conflicts, especially during times of tension, unless that dialogue comes through us. And if we throw away that ability to serve as an honest broker, then we have thrown -- we will have thrown away a strategic asset that's important not only to us but also to Israel. MODERATOR: You agree with that, Governor? BUSH: I do. I do think this, though. When it comes to timetables it can't be the United States timetable as to how discussions take place. It's got to be a timetable that all parties can agree to, like the Palestinians and Israelis. Secondly, any lasting peace is going to have to be a peace that's good for both sides. And therefore, the term honest broker makes sense. This current administration's worked hard to keep the parties at the table. I will try to do the same thing. But it won't be on my timetable, it will be on the timetable that people are comfortable with in the Middle East. MODERATOR: People watching here tonight are very interested in Middle East policy, and they are so interested they want to base their vote on differences between the two of you as president how you would handle Middle East policy. Is there any difference? GORE: I haven't heard a big difference in the last few exchanges. BUSH: That's hard to tell. I think that, you know, I would hope to be able to convince people I could handle the Iraqi situation better. MODERATOR: Saddam Hussein, you mean, get him out of there? BUSH: I would like to, of course, and I presume this administration would as well. We don't know -- there are no inspectors now in Iraq, the coalition that was in place isn't as strong as it used to be. He is a danger. We don't want him fishing in troubled waters in the Middle East. And it's going to be hard, it's going to be important to rebuild that coalition to keep the pressure on him. MODERATOR: You feel that is a failure of the Clinton administration? BUSH: I do. GORE: Well, when I got to be a part of the current administration, it was right after -- I was one of the few members of my political party to support former President Bush in the Persian Gulf War resolution, and at the end of that war, for whatever reason, it was not finished in a way that removed Saddam Hussein from power. I know there are all kinds of circumstances and explanations. But the fact is that that's the situation that was left when I got there. And we have maintained the sanctions. Now I want to go further. I want to give robust support to the groups that are trying to overthrow Saddam Hussein, and I know there are allegations that they're too weak to do it, but that's what they said about the forces that were opposing Milosevic in Serbia, and you know, the policy of enforcing sanctions against Serbia has just resulted in a spectacular victory for democracy just in the past week, and it seems to me that having taken so long to see the sanctions work there, building upon the policy of containment that was successful over a much longer period of time against the former Soviet Union in the communist block, seems a little early to declare that we should give up on the sanctions. I know the governor's not necessarily saying that but, you know, all of these flights that have come in, all of them have been in accordance with the sanctions regime, I'm told, except for three where they notified, and they're trying to break out of the box, there's no question about it. I don't think they should be allowed to. MODERATOR: Did he state your position correctly, you're not calling for eliminating the sanctions, are you? BUSH: No, of course not, absolutely not, I want them to be tougher. MODERATOR: Let's go on to Milosevic and Yugoslavia, and it falls under the area of our military power. Governor, new question. Should the fall of Milosevic be seen as a triumph for U.S. military intervention? BUSH: I think it's a triumph. I thought the president made the right decision in joining NATO and bombing Serbia. I supported them when they did so. I called upon the Congress not to hamstring the administration, and in terms of forcing troop withdrawals on a timetable that wasn't necessarily in our best interest or fit our nation's strategy, and so I think it's good public policy, I think it worked, and I'm pleased I took -- made the decision I made. I'm pleased the president made the decision he made. Because freedom to go in that part of the world, and where there's a lot of work left to be done, however. MODERATOR: But you think it would not have happened -- do you think that Milosevic would not have fallen if the United States and NATO had not intervened militarily? Is this a legitimate use of our military power? BUSH: Yes, I think it is. Absolutely. I don't think he would have fallen had we not used the force. And I know there are some in our party that disagree with that sentiment. I supported the president. I thought he made the right decision to do so. I didn't think he necessarily made the right decision to take land troops off the table right before we committed ourselves offensively, but nevertheless, it worked. The administration deserves credit for having made it work. It is important for NATO to have it work. It's important for NATO to be strong and confident and to help keep the peace in Europe. And one of the reasons I felt so strongly that the United States needed to participate was because of our relations with NATO, and NATO is going to be an important part of keeping the peace in the future. Now, there's more work to do. Remains to be seen, however, whether or not there's going to be a political settlement in Kosovo, and I certainly hope there is one. Also on record as saying at some point in time I hope our European friends become the peacekeepers in Bosnia and in the Balkans. I hope that they put the troops on the ground so that we can withdraw our troops and focus our military on fighting and winning war. GORE: Well, I've been kind of a hard-liner on this issue for more than eight years. When I was in the senate before I became vice president I was pushing for stronger action against Milosevic. He caused the death of so many people. He was the last communist party boss there and then he became a dictator that by some other label he was still essentially a communist dictator. And unfortunately now he is trying to reassert himself in Serbian politics. Already just today the members of his political party said that they were going to ignore the orders of the new president of Serbia, and that they question his legitimacy, and he's still going to try to be actively involved. He is an indicted war criminal. He should be held accountable. Now, I did want to pick up on one of the statements earlier, and maybe I have heard, maybe I have heard the previous statements wrong, Governor. In some of the discussions we've had about when it's appropriate for the U.S. to use force around the world, at times the standards that you've laid down have given me the impression that if it's something like a genocide taking place or what they called ethnic cleansing in Bosnia, that that alone would not be, that that wouldn't be the kind of situation that would cause you to think that the U.S. ought to get involved with troops. Now, have to be other factors involved for me to want to be involved. But by itself, that to me can bring into play a fundamental American strategic interest because I think it's based on our values. Now, have I got that wrong? MODERATOR: Trying to figure out who the questioner was. BUSH: If I think it's in our nation's strategic interest I'll commit troops. I thought it was in our strategic interests to keep Milosevic in check because of our relations in NATO, and that's why I took the position I took. I think it's important for NATO to be strong and confident. I felt like unchecked Milosevic would harm NATO, and so it depends on the situation, Mr. Vice President. MODERATOR: Well, let's stay on the subject for a moment. New question related to this. I figured this out; in the last 20 years there have been eight major actions that involved the introduction of U.S. ground, air or naval forces. Let me name them. Lebanon, Grenada, Panama, the Persian Gulf, Somalia, Bosnia, Haiti, Kosovo. If you had been president for any of those interventions, would any of those interventions not have happened? GORE: Can you run through the list again? MODERATOR: Sure. Lebanon. GORE: I thought that was a mistake. MODERATOR: Grenada. GORE: I supported that. MODERATOR: Panama. GORE: I supported that. MODERATOR: Persian Gulf. GORE: Yes, I voted for it, supported it. MODERATOR: Somalia. GORE: Of course, and that again -- no, I think that that was ill-considered. I did support it at the time. It was in the previous administration, in the Bush-Quayle administration, and I think in retrospect the lessons there are ones that we should take very, very seriously. MODERATOR: Bosnia. GORE: Oh, yes. MODERATOR: Haiti. GORE: Yes. MODERATOR: And then Kosovo. GORE: Yes. MODERATOR: We talked about that. Want me to do it with you? Lebanon. BUSH: Make a couple comments. MODERATOR: Sure, absolutely, sure. Somalia. BUSH: Started off as a humanitarian mission and it changed into a nation-building mission, and that's where the mission went wrong. The mission was changed. And as a result, our nation paid a price. And so I don't think our troops ought to be used for what's called nation-building. I think our troops ought to be used to fight and win war. I think our troops ought to be used to help overthrow the dictator when it's in our best interests. But in this case it was a nation-building exercise, and same with Haiti. I wouldn't have supported either. MODERATOR: What about Lebanon? BUSH: Yes. MODERATOR: Grenada. BUSH: Yes. MODERATOR: Panama? BUSH: Yes. Some of them I've got a conflict of interest on, if you know what I mean. MODERATOR: I do, I do. The Persian Gulf, obviously. And Bosnia. And you have already talked about Kosovo. But the reverse side of the question, Governor, that Vice President Gore mentioned, 600,000 people died in Rwanda in 1994. There was no U.S. intervention, no intervention from the outside world. Was that a mistake not to intervene? BUSH: I think the administration did the right thing in that case. I do. It was a horrible situation, no one liked to see it on our TV screens, but it's a case where we need to make sure we have an early warning system in place in places where there could be ethnic cleansing and genocide the way we saw it there in Rwanda. And that's a case where we need to use our influence to have countries in Africa come together and help deal with the situation. The administration, seem like we're having a great love for us tonight, but the administration made the right decision on training Nigerian troops for situations just such as this in Rwanda, and so I thought they made the right decision not to send U.S. troops into Rwanda. MODERATOR: Do you have any second thoughts on that, based on what you said a moment ago about genocide? GORE: I'd like to come back to the question of nation building, but let me address the question directly, first. Fine. We did, actually, send troops into Rwanda to help with the humanitarian relief measures. My wife Tipper, who is here, actually went on a military plane with General Sholicatchvieli on one of those flights. But I think in retrospect we were too late getting in there. We could have saved more lives if we had acted earlier. But I do not think that it was an example of a conflict where we should have put our troops in to try to separate the parties for this reason, Jim. One of the criteria that I think is important in deciding when and if we should ever get involved around the world is whether or not our national security interest is involved, if we can really make the difference with military forces. We tried everything else. If we have allies in the Balkans we have allies, NATO, ready, willing and able to go and carry a big part of the burden. In Africa we did not. Now, we have tried -- our countries tried to create an Africa crisis response team there, and we've met some resistance. We have had some luck with Nigeria, but in Sierra Leon, and now that Nigeria has become a democracy, and we hope it stays that way, then maybe we can build on that. But because we had no allies and because it was very unclear that we could actually accomplish what we would want to accomplish about putting military forces there, I think it was the right thing not to jump in, as heartbreaking as it was, but I think we should have come in much quicker with the humanitarian mission. MODERATOR: So what would you say, Governor, that somebody would say hey wait a minute, why not Africa, I mean why the Middle East, why the Balkans, but not Africa, when 600,000 people's lives are at risk? BUSH: Well, I understand, and Africa is important. And we've got to do a lot of work in Africa to promote democracy and trade, and there are some -- Vice President mentioned Nigeria is a fledgling democracy. We have to work with Nigeria. That's an important continent. But there's got to be priorities, and Middle East is a priority for a lot of reasons, as is Europe and the Far East, our own hemisphere. And those are my four top priorities should I be the president, not to say we won't be engaged nor work hard to get other nations to come together to prevent atrocity. I thought the best example of a way to handle the situation was East Timor when we provided logistical support to the Australians, support that only we can provide. I thought that was a good model. But we can't be all things to all people in the world, Jim. And I think that's where maybe the vice president and I begin to have some differences. I'm worried about overcommitting our military around the world. I want to be judicious in its use. You mentioned Haiti. I wouldn't have sent troops to Haiti. I didn't think it was a mission worthwhile. It was a nation building mission, and it was not very successful. It cost us billions, a couple billions of dollars, and I'm not so sure democracy is any better off in Haiti than it was before. MODERATOR: Vice President Gore, do you agree with the governor's views on nation building, the use of military, our military, for nation building as he described and defined it? GORE: I don't think we agree on that. I would certainly also be judicious in evaluating any potential use of American troops overseas. I think we have to be very reticent about that. But look, Jim, the world is changing so rapidly. The way I see it, the world is getting much closer together. Like it or not, we are now -- the United States is now the natural leader of the world. All these other countries are looking to us. Now, just because we cannot be involved everywhere, and shouldn't be, doesn't mean that we should shy away from going in anywhere. Now, both of us are kind of, I guess, stating the other's position in a maximalist extreme way, but I think there is a difference here. This idea of nation building is kind of a pejorative phrase, but think about the great conflict of the past century, World War II. During the years between World War I and World War II, a great lesson was learned by our military leaders and the people of the United States. The lesson was that in the aftermath of World War I, we kind of turned our backs and left them to their own devices and they brewed up a lot of trouble that quickly became World War II. And acting upon that lesson in the aftermath of our great victory in World War II, we laid down the Marshall Plan, President Truman did. We got intimately involved in building NATO and other structures there. We still have lots of troops in Europe. And what did we do in the late '40's and '50's and '60's? We were nation building. And it was economic. But it was also military. And the confidence that those countries recovering from the wounds of war had by having troops there. We had civil administrators come in to set up their ways of building their towns back. MODERATOR: You said in the Boston debate, Governor, on this issue of nation building, that the United States military is overextended now. Where is it overextended? Where are there U.S. military that you would bring home if you become president? BUSH: First let me just say one comment about what the vice president said. I think one of the lessons in between World War I and World War II is we let our military atrophy. And we can't do that. We've got to rebuild our military. But one of the problems we have in the military is we're in a lot of places around the world. And I mentioned one, and that's the Balkans. I would very much like to get our troops out of there. I recognize we can't do it now, nor do I advocate an immediate withdrawal. That would be an abrogation of our agreement with NATO. No one is suggesting that. But I think it ought to be one of our priorities to work with our European friends to convince them to put troops on the ground. And there is an example. Haiti is another example. Now there are some places where I think -- you know, I've supported the administration in Columbia. I think it's important for us to be training Columbians in that part of the world. The hemisphere is in our interest to have a peaceful Columbia. But -- MODERATOR: The use of the military, there -- some people are now suggesting that if you don't want to use the military to maintain the peace, to do the civil thing, is it time to consider a civil force of some kind that comes in after the military that builds nations or all of that? Is that on your radar screen? BUSH: I don't think so. I think what we need to do is convince people who live in the lands they live in to build the nations. Maybe I'm missing something here. I mean, we're going to have kind of a nation building core from America? Absolutely not. Our military is meant to fight and win war. That's what it's meant to do. And when it gets overextended, morale drops. I strongly believe we need to have a military presence in the peninsula, not only to keep the peace in the peninsula, but to keep regional stability. And I strongly believe we need to keep a presence in NATO, but I'm going to be judicious as to how to use the military. It needs to be in our vital interest, the mission needs to be clear, and the extra strategy obvious. GORE: I don't disagree with that. I certainly don't disagree that we ought to get our troops home from places like the Balkans as soon as we can, as soon as the mission is complete. That's what we did in Haiti. There are no more than a handful of American military personnel in Haiti now. And Haitians have their problems, but we gave them a chance to restore democracy. That's really about all we can do. But if you have a situation like that right in our backyard with chaos about to break out and flotillas forming to come across the water, and all kinds of violence there, right in one of our neighboring countries there, then I think that we did the right thing there. And as for this idea of nation building, the phrase sounds grandiose. And, you know, we can't be -- we can't allow ourselves to get overextended. I certainly agree with that. And that's why I've supported building up our capacity. I've devoted in the budget I've proposed, as I said last week, more than twice as much as the governor has proposed. I think that it's in better shape now than he generally does. We've had some disagreements about that. He said that two divisions would have to report not ready for duty, and that's not what the joint chiefs say. But there's no doubt that we have to continue building up readiness and military strength. And we have to also be very cautious in the way we use our military. MODERATOR: In the non-military area of influencing events around the world, the financial and economic are, the World Bank President Wilfinson said recently, Governor, that U.S. contributions to overseas development assistance is lower now almost than it has ever been. Is that a problem for you? Do you think -- what is your -- what is your idea about what the United States' obligations are? I'm talking about financial assistance and that sort of thing to other countries, the poor countries. BUSH: Well, I mentioned Third World debt. MODERATOR: Sure. BUSH: That's a place where we can use our generosity to influence in a positive way, influence nations. I believe we ought to have foreign aid, but I don't think we ought to just have foreign aid for the sake of foreign aid. I think foreign aid needs to be used to encourage markets and reform. I think a lot of times we just spend aid and say we feel better about it and it ends up being spent the wrong way, and there's some pretty egregious examples recently. One being Russia, where we had IMF loans that ended up in the pockets of a lot of powerful people and didn't help the nation. I think the IMF has got a role in the world, but I don't want to see the IMF out there as a way to say to world bankers, if you make a bad loan, we'll bail you out. It needs to be available for emergency situations. I thought the President did the right thing with Mexico and was very strongly supportive of the administration in Mexico. But I don't think the IMF ought to be a stop loss for people who ought to be able to evaluate risks themselves. So I'll look at every place where we're investing money. I just want to make sure the return is good. MODERATOR: Do you think we're meeting our obligations properly? GORE: No, I would make some changes. I think there need to be reforms in the IMF. I've generally supported it, but I've seen them make some calls that I thought were highly questionable. And I think that there's a general agreement in many parts of the world now that there ought to be changes in the IMF. The World Bank I think is generally doing a better job, but I think one of the big issues here that doesn't get nearly enough attention is the issue of corruption. The governor mentioned it earlier. I've worked on this issue. It's an enormous problem and corruption in official agencies, like militaries and police departments around the world, customs officials, that's one of the worst forms of it. And we have got to again lead by example and help these other countries that are trying to straighten out their situations find the tools in order to do it. I just think, Jim, that this is an absolutely unique period in world history. The world has come together, as I said, they're looking to us. And we have a fundamental choice to make. Are we going to step up to the plate as a nation the way we did after World War II, the way that generation of heroes said okay, the United States is going to be the leader. And the world benefitted tremendously from the courage that they showed in those post-war years. I think that in the aftermath of the Cold War, it's time for us to do something very similar, to step up to the plate, to provide the leadership on the environment, leadership to make sure the world economy keeps moving in the right direction. Again, that means not running big deficits here and not squandering our surplus. It means having intelligent decisions that keep our prosperity going and shepherds that economic strength so that we can provide that leadership role. BUSH: Let me comment on that. I'm not so sure the role of the United States is to go around the world and say this is the way it's got to be. We can help. And maybe it's just our difference in government, the way we view government. I want to empower the people. I want to help people help themselves, not have government tell people what to do. I just don't think it's the role of the United States to walk into a country and say, we do it this way, so should you. I think we can help. I know we've got to encourage democracy in the marketplaces. But take Russia, for example. We went into Russia, we said here is some IMF money, and it ended up in Viktor Chemomyrdin's pocket, and others, and yet we played like there was reform. The only people that are going to reform Russia are Russia. They're going to have to make the decision themselves. Mr. Putin is going to have to make the decision as to whether or not he wants to adhere to rule of law and normal accounting practices so that if countries and/or entities invest capital, there's a reasonable rate of return, a way to get the money out of the economy. But Russia has to make the decision. We can work with them on security matters, for example, but it's their call to make. So I'm not exactly sure where the vice president is coming from, but I think one way for us to end up being viewed as the ugly American is for us to go around the world saying, we do it this way, so should you. Now, we trust freedom. We know freedom is a powerful, powerful, powerful force, much bigger than the United States of America, as we saw recently in the Balkans. But maybe I misunderstand where you're coming from, Mr. Vice President, but I think the United States must be humble and must be proud and confident of our values, but humble in how we treat nations that are figuring out how to chart their own course. MODERATOR: Lets move on. No, let's move on. GORE: Far be it from me to suggest otherwise. (LAUGHTER) MODERATOR: First, a couple of follow-ups from the vice presidential debate last week. Vice President Gore, would you support or sign, as president, a federal law banning racial profiling by police and other authorities at all levels of government? GORE: Yes, I would. The only thing an executive order can accomplish is to ban it in federal law enforcement agencies, but I would also support a law in the Congress that would have the effect of doing the same thing. I just -- I think that racial profiling is a serious problem. I remember when the stories first came out about the stops in New Jersey by the highway patrol there. And I know it's been going on a long time. In some ways this is just a new label for something that has been going on for years. But I have to confess that it was the first time that I really focused on it in a new way. And I was surprised at the extent of it. And I think we've now got so many examples around the country that we really have to find ways to end this. Imagine what it -- what it is like for someone to be singled out unfairly, unjustly, and feel the unfair force of law simply because of race or ethnicity. Now, that runs counter to what the United States of America is all about at our core. And it's not an easy problem to solve. But if I am entrusted with the presidency, it will be the first Civil Rights Act of the 21st century. BUSH: Yeah, I can't imagine what it would be like to be singled out because of race and stopped and harassed. That's just flat wrong, and that's not what America is all about. And so we ought to do everything we can to end racial profiling. One of my concerns, though, is I don't want to federalize the local police forces. I want to -- obviously in the egregious cases we need to enforce civil rights law, but we need to make sure that internal affairs decisions at the local level do their job and be given a chance to do their job. I believe in local control of governments, and obviously if they don't there needs to be a consequence at the federal level. But it's very important that we not overstep our bounds and I think most people -- most police officers are good, dedicated, honorable citizens who are doing their job, putting their lives at risk who aren't bigoted or aren't prejudiced. I don't think they ought to be held guilty. But I do think we need to find out where racial profiling occurs and do something about it and say to the local folks, get it done. And if you can't, there will be a federal consequence. MODERATOR: And that could be a federal law? BUSH: Yeah. MODERATOR: And you would agree? GORE: I would agree. And I also agree that most police officers, of course, are doing a good job and hate this practice also. I talked to an African-American police officer in Springfield, Massachusetts not long ago who raised this question and said that in his opinion one of the biggest solutions is in the training. And not only the training in police procedures, but human relations. And I think that racial profiling is part of a larger issue of how we deal with race in America. And as for singling people out because of race, you know, James Byrd was singled out because of his race in Texas. And other Americans have been singled out because of their race or ethnicity. And that's why I think we can embody our values by passing a hate crimes law. I think these crimes are different. I think they're different because they're based on prejudice and hatred, which gives rise to crimes that have not just a single victim, but they're intended to stigmatize and dehumanize a whole group of people. MODERATOR: You have a different view of that. BUSH: No, I don't, really. MODERATOR: On hate crimes laws? BUSH: No. We've got one in Texas. And guess what? The three men who murdered James Byrd, guess what's going to happen to them? They're going to be put to death. A jury found them guilty. It's going to be hard to punish them any worse after they get put to death. And it's the right cause. It's the right decision. Secondly, there is other forms of racial profiling that goes on in America. Arab-Americans are racially profiled in what is called secret evidence. People are stopped, and we have to do something about that. My friend, Senator Spencer Abraham of Michigan, is pushing a law to make sure that Arab-Americans are treated with respect. So racial profiling isn't just an issue at local police forces. It's an issue throughout our society. And as we become a diverse society, we're going to have to deal with it more and more. I believe, though -- I believe, as sure as I'm sitting here, that most Americans really care. They're tolerant people. They're good, tolerant people. It's the very few that create most of the crises, and we just have to find them and deal with them. MODERATOR: What -- if you become president, Governor, are there other areas, racial problem areas, that you would deal with as president involving discrimination? Like you said, Arab-Americans, but also Hispanics, Asians, as well as Blacks in this country. BUSH: Let me tell you where the biggest discrimination comes. In public education when we just move children through the schools. My friend, Phyllis Hunter, is here. She had one of the greatest lines of all lines. She said, reading is the new civil right. She's right. And to make sure our society is as hopeful as it possibly can be, every single child in America must be educated. I mean every child. It starts with making sure every child learns to read. K-2 diagnostic testing so we know whether or not there's a deficiency. Curriculum that works and phonics needs to be an integral part of our reading curriculum. Intensive reading laboratories, teacher retraining. I mean, there needs to be a wholesale effort against racial profiling, which is illiterate children. We can do better in our public schools. We can close an achievement gap, and it starts with making sure we have strong accountability, Jim. One of the cornerstones of reform, and good reform, is to measure. Because when you measure you can ask the question, do they know? Is anybody being profiled? Is anybody being discriminated against? It becomes a tool, a corrective tool. And I believe the federal government must say that if you receive any money, any money from the federal government for disadvantaged children, for example, you must show us whether or not the children are learning. And if they are, fine. And if they're not, there has to be a consequence. And so to make sure we end up getting rid of basic structural prejudice is education. There is nothing more prejudiced than not educating a child. MODERATOR: Vice President Gore, what would be on your racial discrimination elimination list as president? GORE: Well, I think we need tough enforcement of the civil rights laws. I think we still need affirmative action. I would pass a hate crimes law, as I said, and I guess I had misunderstood the governor's previous position. The Byrd family may have a misunderstanding of it in Texas also. But I would like to shift, if I could, to the big issue of education. MODERATOR: Hold on one second. What is the misunderstanding? Let's clear this up. GORE: Well, I had thought that there was a controversy at the end of the legislative session where the hate crimes law in Texas was -- failed, and that the Byrd family, among others, asked you to support it, Governor, and it died in committee for lack of support. Am I wrong about that? BUSH: Well, you don't realize we have a hate crimes statute? We do. GORE: I'm talking about the one that was proposed to deal -- BUSH: No -- well, what the Vice President must not understand is we've got a hate crimes bill in Texas. And secondly, the people that murdered Mr. Byrd got the ultimate punishment. The death penalty. MODERATOR: They were prosecuted under the murder laws, were they not, in Texas? BUSH: In this case when you murder somebody it's hate, Jim. The crime is hate. And they got the ultimate punishment. I'm not exactly sure how you enhance the penalty any more than the death penalty. We happen to have a statute on the books that's a hate crimes statute in Texas. GORE: May I respond? MODERATOR: Sure. GORE: I don't want to jump in. I may have been misled by all the news reports about this matter, because the law that was proposed in Texas that had the support of the Byrd family and a whole lot of people in Texas did, in fact, die in committee. There may be some other statute that was already on the books, but certainly the advocates of the hate crimes law felt that a tough new law was needed. And it's important, Jim, not only -- not just because of Texas, but because this mirrors the national controversy. There is pending now in the Congress a national hate crimes law because of James Byrd, because of Matthew Shepard, who was crucified on a split rail fence by bigots, and because of others. And that law has died in committee also because of the same kind of opposition. MODERATOR: And you would support that bill. GORE: Absolutely. MODERATOR: Would you support a national hate crimes law? BUSH: I would support the Orrin Hatch version of it, not the Senator Kennedy version. But let me say to you, Mr. Vice President, we're happy with our laws on our books. That bill did -- there was another bill that did die in committee. But I want to repeat, if you have a state that fully supports the law like we do in Texas, we're going to go after all crime. And we're going to make sure people get punished for the crime. And in this case we can't enhance the penalty any more than putting those three thugs to deaths. And that's what's gonna happen in the State of Texas. MODERATOR: New subject, new question. Another vice presidential debate follow-up. Governor, both Senator Lieberman and Secretary Cheney said they were sympathetically rethinking their views on same sex relationships. What's your position on that? BUSH: I'm not for gay marriage. I think marriage is a sacred institution between a man and a woman. And I appreciated the way the administration signed the Defense of Marriage Act. I presume the Vice President supported it when the President signed that bill and supports it now. But I think marriage is a sacred institution. I'm going to be respectful for people who may disagree with me. I've had a record of doing so in the State of Texas. I've been a person that had been called a uniter, not a divider, because I accept other people's points of view. But I feel strongly that marriage should be between a man and a woman. MODERATOR: Vice President Gore? GORE: I agree with that, and I did support that law. But I think that we should find a way to allow some kind of civic unions, and I basically agree with Dick Cheney and Joe Lieberman. And I think the three of us have one view and the Governor has another view. MODERATOR: Is that right? BUSH: I'm not sure what kind of view he's describing to me. I can just tell you, I'm a person who respects other people. I respect their -- I respect -- on the one hand he says he agrees with me and then he says he doesn't. I'm not sure where he's coming from. But I will be a tolerant person. I've been a tolerant person all my life. I just happen to believe strongly that marriage is between a man and a woman. MODERATOR: Do you believe in general terms that gays and lesbians should have the same rights as other Americans? BUSH: Yes. I don't think they ought to have special rights, but I think they ought to have the same rights. GORE: Well, there's a law pending called the Employment Non-Discrimination Act. I strongly support it. What it says is that gays and lesbians can't be fired from their job because they're gay or lesbian. And it would be a federal law preventing that. Now, I wonder if the -- it's been blocked by the opponents in the majority in the Congress. I wonder if the Governor who lend his support to that law. MODERATOR: Governor? BUSH: The question -- MODERATOR: Well, but it's a logical response. BUSH: Well, I have no idea. I mean, he can throw out all kinds -- I don't know the particulars of this law. I will tell you I'm the kind of person, I don't hire or fire somebody based upon their sexual orientation. As a matter of fact, I would like to take the issue a little further. I don't really think it's any of my -- you know, any of my concerns what -- how you conduct your sex life. And I think that's a private matter. And I think that's the way it ought to be. But I'm going to be respectful for people, I'll tolerate people, and I support equal rights but not special rights for people. MODERATOR: Special rights, how does that affect gays and lesbians? BUSH: Well, it would be if they're given special protective status. That doesn't mean we shouldn't fully enforce laws and fully protect people and fully honor people, which I will do as the President of the United States. MODERATOR: New subject, new question, Vice President Gore. How do you see the connection between controlling gun sales in this country and the incidence of death by accidental or intentional use of guns? GORE: Jim, I hope that we can come back to the subject of education because the governor made an extensive statement on it and I have a very different view than the one he expressed. But that having been said, I believe that -- well, first of all, let me say that the governor and I agree on some things where this subject is concerned. I will not do anything to affect the rights of hunters or sportsmen. I think that homeowners have to be respected and their right to have a gun if they wish to. The problem I see is that there are too many guns getting into the hands of children, and criminals, and people who, for whatever reason, some kind of history of stalking or domestic abuse really should not be able to get guns. I think these assault weapons are a problem. So I favor closing the gun show loophole. In fact, I cast the tie-breaking vote to close it, but then the majority in the House of Representatives went the other way. That's still pending. If we could get agreement on that, maybe they could pass that in the final days of this Congress. I think we ought to restore the three-day waiting period under the Brady Law. I think we should toughen the enforcement of gun laws so that the ones that are already on the books can be enforced much more effectively. Some of the restrictions that have been placed by the Congress in the last couple of years. I think -- in the last few years I think have been unfortunate. I think that we ought to make all schools gun free. Have a gun-free zone around every school in this country. I think that measures like these are important. Child safety trigger locks on a mandatory basis, and others. MODERATOR: Governor? BUSH: Well, it starts with enforcing law. When you say loud and clear to somebody if you're going to carry a gun illegally, we're going to arrest you. If you're going to sell a gun illegally, you need to be arrested. If you commit a crime with a gun, there needs to be absolute certainty in the law. And that means that the local law enforcement officials need help at the federal level. Programs like Project Exile where the federal government intensifies arresting people who illegally use guns. And we haven't done a very good job of that at the federal level recently. And I'm going to make it a priority. Secondly, I don't think we ought to be selling guns to people who shouldn't have them. That's why I support instant background checks at gun shows. One of the reasons we have an instant background check is so that we instantly know whether or not somebody should have a gun or not. In Texas I tried to do something innovative. There's a lot of talk about trigger locks being on guns sold in the future. I support that. But I said if you want a trigger lock to make your gun safe, come and get one for free. So we're distributing in our State of Texas for free. I think we ought to raise the age at which a juvenile can carry a handgun from 18 to 21. I disagree with the vice president on this issue. He is for registration of guns. I think the only people that are going to show up to register or get a license -- I guess licensing like a driver's license for a gun, the only people that are going to show up are law-abiding citizens. The criminal is not going to show up and say hey, give me my I.D. card. It's the law-abiding citizens who will do that. An I don't think that is going to be an effective tool to make the -- keep our society safe. MODERATOR: All right. So on guns, somebody wants to cast a vote based on your differences, where are the differences? GORE: Well, I'm not for registration. I am for licensing by states of new handgun purchases. MODERATOR: What's that mean? GORE: A photo license I.D. like a driver's license for new handguns and, you know, the Los Angeles -- MODERATOR: Excuse me, you would have to get the license -- a photo I.D. to go in and before you could buy the gun? GORE: Correct. MODERATOR: All right. Who would issue the -- GORE: The state. The state. I think states should do that for new handguns, because too many criminals are getting guns. There was a recent investigation of the number in Texas who got -- who were given concealed weapons permits in spite of the fact that they had records. And the "Los Angeles Times" spent a lot of ink going into that. But I am not for doing anything that would affect hunters or sportsmen, rifles, shotguns, existing handguns. I do think that sensible gun safety measures are warranted now. Look, this is the year -- this is in the aftermath of Columbine, and Paducah, and all the places in our country where the nation has been shocked by these weapons in the hands of the wrong people. The woman who bought the guns for the two boys who did that killing at Columbine said that if she had had to give her name and fill out a form there, she would not have bought those guns. That conceivably could have prevented that tragedy. MODERATOR: Back to the question about the differences on gun control. What are they, Governor, from your point of view, between you and the Vice President? BUSH: Well, I'm not for photo licensing. Let me say something about Columbine. Listen, we've got gun laws. He says we ought to have gun-free schools. Everybody believes that. I'm sure every state in the union has got them. You can't carry a gun into a school. And there ought to be a consequence when you do carry a gun into a school. But Columbine spoke to a larger issue. It's really a matter of culture. It's a culture that somewhere along the line we've begun to disrespect life. Where a child can walk in and have their heart turned dark as a result of being on the Internet and walk in and decide to take somebody else's life? So gun laws are important, no question about it, but so is loving children, and character education classes, and faith-based programs being a part of after-school programs. Some desperate child needs to have somebody put their arm around them and say, we love you. So there's a -- this is a society that -- of ours that's got to do a better job of teaching children right from wrong. And we can enforce law. But there seems to be a lot of preoccupation on -- not certainly only in this debate, but just in general on law. But there's a larger law. Love your neighbor like you would like to be loved yourself. And that's where our society must head if we're going to be a peaceful and prosperous society. GORE: I also believe in the Golden Rule. And I agree with a lot of the other things that the governor has said. We do have a serious problem in our culture. Tipper and I have worked on the problem of violence in entertainment aimed at children. She's worked on it longer than I have. But I feel very strongly about that. And if I'm elected president, I will do something about that. But I think that we -- I think we have to start with better parenting. But I don't think that we can ignore the role played by guns. I mean, the fact is that there -- even though no state wants them, there are guns in some schools. And the reason it's so difficult for schools to control that is because in recent years there has been a flood of cheap handguns that are so widely available that kids are finding ways to get ahold of them. And I think that if you look at the situation as it exists here in the United States compared to any other country in the world, it seems to me pretty obvious that while we respect the rights of hunters and sportsmen, we do need some common sense gun safety steps to stem this flood of guns that are getting into the wrong hands. BUSH: Yeah, no question about that, but there also needs to be strong enforcement of the law. Some kid who feels like -- doesn't matter where the gun comes from, it could be a cheap gun, expensive gun. What matters is something in this person's head says there is not going to be a consequence. So in my state we toughen up the juvenile justice laws. We added beds. We're tough. We believe in tough love. We say, if you get caught carrying a gun, you're automatically detained. And that's what needs to happen. We've got laws. If laws need to be strengthened, like instant background checks, that's important. MODERATOR: New question. As I was saying. Both of you -- Governor, both of you have talked much about Medicare and health care for seniors. What about the more than 40 million younger Americans who do not have health insurance right now? What would you do about that? BUSH: Well, I've got a plan to do something about that. It's to make health care affordable and available this way. First, there's some who should be buying health care who choose not to. There's some -- MODERATOR: Some of the 40 million. BUSH: Some of the healthy folks, healthy young kids say I'll never get sick, therefore I don't need health care right now. For those what I think we need to do is to develop an investment-type vehicle that would be an incentive for them to invest, like medical savings accounts with rollover capacity. In other words, you say to a youngster, it will be in your financial interest to start saving for future illness, but for the working folks that do want to have health care that can't afford it, a couple of things we need to do. One, we need more community health centers. I've developed -- put out money in my budget to expand community health centers all around the country. These are places where people can get primary care. Secondly -- and they're good. They're very important parts of the safety net of health care. Secondly, that you get a $2,000 rebate from the government if you're a family of $30,000 or less -- it scales down as you get higher -- that you can use to purchase health care in the private markets. It will be a huge down payment for a pretty darn good system. If you allow -- also allow -- convince states to -- allow states to allow the mother to match some of the children's health insurance money with it, the pool purchasing power. And to make health care more affordable, allow business associations like the National Federal of Independent Business or the Chamber of Commerce or the National Restaurant Association to write association plans across jurisdictional lines so that small businesses have got the capacity to have national pooling to drive the cost of insurance down. I think that's the very best way to go. It empowers people, it trusts people, it makes -- and it's a practical way to encourage people to purchase health care insurance. MODERATOR: Vice President Gore? GORE: It's one of my top priorities, Jim, to give every single child in the United States affordable health care within the next four years. I would like to see eventually in this country some form of universal health care, but I'm not for a government-run system. In fact, I'm for shrinking the size of government. I want a smaller and smarter government. I have been in charge of this reinventing government streamlining project that's reduced the size of government by more than 300,000 people in the last several years. And the budget plan that I've put out, according to the "Los Angeles Times" again, the way these things are typically measured as a percentage of the GDP, will bring government spending down to the lowest level in 50 years. So I want to proceed carefully to cover more people. But I think we should start by greatly expanding the so-called child health insurance or CHIP program to give health insurance to every single child in this country. I think it's intolerable that we have so many millions of children without any health insurance. So it's one of my top priorities. Now, I know that we have some disagreements on this. And I'm sorry to tell you that, you know, there is a record here. And Texas ranks 49th out of the 50 states in health care -- in children with health care. 49th for women with health care, and 50th for families with health care. So it is a priority for me. I guarantee you. I'm not aware of any program -- well, I'll just leave it at that. I think it ought to be a top priority. MODERATOR: Governor, did the -- are the vice president's figures correct about Texas? BUSH: First of all, let me say he's not for a government-run health care system? I thought that's exactly what he and Mrs. Clinton and them fought for in 1993 was a government-run health care system. It was fortunately stopped in its tracks. Secondly, we spend $4.7 billion a year on the uninsured in the State of Texas. Our rate of uninsured, the percentage of uninsured in Texas has gone down, while the percentage of uninsured in America has gone up. Our CHIPS program got a late start because our government meets only four months out of every two years, Mr. Vice President. It may come as a shock for somebody who has been in Washington for so long. But actually limited government can work in the second largest state in the union. And therefore Congress passes the bill after our session in 1997 ended, we passed an enabling legislation in 1999. We've signed up over 110,000 children to the CHIPS program. For comparable states our size, we're signing them up as fast as any other state. You can quote all the numbers you want, but I'm telling you we care about our people in Texas. We spent a lot of money to make sure people get health care in the State of Texas, and we're doing a better job than they are at the national level for reducing uninsured. MODERATOR: Is he right? GORE: Well, I don't know about all these percentages that he throws out, but I do know that -- I speculate that the reason why he didn't answer your question directly as to whether my numbers were right, the facts were right about Texas ranking dead last in families with health insurance and 49th out of 50 for both children and women, is because those facts are correct. And as for why it happened, I'm no expert on the Texas procedures, but what my friends there tell me is that the governor opposed a measure put forward by Democrats in the legislature to expand the number of children that would be covered. And instead directed the money toward a tax cut, a significant part of which went to wealthy interests. He declared the need for a new tax cut for the oil companies in Texas an emergency need, and so the money was taken away from the CHIP program. There's -- you don't have to take my word for this. There is now a federal judge's opinion about the current management of this program ordering the State of Texas to do -- you should read that judge's language about this. I believe there are 1.4 million children in Texas who do not have health insurance. 600,000 of whom, and maybe some of those have since gotten it, but as of a year ago 600,000 of them were actually eligible for it but they couldn't sign up for it because of the barriers that they had set up. MODERATOR: Let's let the governor respond to that. Are those numbers correct? Are his charges correct? BUSH: If he's trying to allege that I'm a hard-hearted person and I don't care about children, he's absolutely wrong. We've spent $4.7 billion a year in the State of Texas for uninsured people. And they get health care. Now, it's not the most efficient way to get people health care. But I want to remind you, the number of uninsured in America during their watch has increased. He can make any excuse he wants, but the facts are that we're reducing the number of uninsured percentage of our population. And as the percentage of the population is increasing nationally, somehow the allegation that we don't care and we're going to give money for this interest or that interest and not for children in the State of Texas is totally absurd. Let me just tell you who the jury is. The people of Texas. There's only been one governor ever elected to back-to-back four-year terms, and that was me. And I was able to do so with a lot of Democrat votes, nearly 50% of the Hispanic vote, about 27% of the African-American vote, because people know I'm a conservative person and a compassionate person. So he can throw all the kinds of numbers around. I'm just telling you our state comes together to do what is right. We come together both Republicans and Democrats. MODERATOR: Let me put that directly to you, Vice President Gore. The reason you brought this up, is it -- are you suggesting that those numbers and that record will reflect the way Governor Bush will operate in this area of health insurance as president? GORE: Yes, yes. But it's not a statement about his heart. I don't claim to know his heart. I think he's a good person. I make no allegations about that. I believe him when he says that he has a good heart. I know enough about your story to admire a lot of the things that you have done as a person. But I think it's about his priorities. And let me tell you exactly why I think that the choice he made to give a tax cut for the oil companies and others before addressing this -- I mean, if you were the governor of a state that was dead last in health care for families, and all of a sudden you found yourself with the biggest surplus your state had ever had in its history, wouldn't you want to maybe use some of it to climb from 50th to, say, 45 or 40 or something or maybe better? I would. Now, but here is why it's directly relevant, Jim. Because by his own budget numbers, his proposals for spending on tax cuts for the wealthiest of the wealthy are more than the new spending proposals that he has made for health care and education and national defense all combined. According to his own numbers. So it's not a question of his heart, as far as I know. It's a question of priorities and values. See, you know -- MODERATOR: Let me ask -- BUSH: First of all, that's simply not true what he just said, of course. And secondly, I repeat to you -- MODERATOR: What is not true, Governor? BUSH: That we spent -- the top 1% receive 223 as opposed to 445 billion in new spending. The top -- let's talk about my tax plan. The top 1% will pay one-third of all the federal income taxes. And in return, get one-fifth of the benefits, because most of the tax reductions go to the people at the bottom end of the economic ladder. That stands in stark contrast, by the way, to a man who is going to leave 50 million -- 50 million Americans out of tax relief. We just have a different point of view. It's a totally different point of view. He believes only the right people ought to get tax relief. I believe everybody who pays taxes ought to get tax relief. Let me go back to Texas, for example, for a minute. We pay 4.7 billion. I can't emphasize to you how much. I signed a bill that puts CHIPS in place. The bill finally came out at the end of the 1999 session. We're working hard to sign up children. We're doing it faster than any other state our size, comparable state. We're making really good progress. And our state cares a lot about our children. My priority is going to be the health of our citizens. These folks have had eight years to get something done in Washington, D.C. on the uninsured. They have not done it. They've had eight years to get something done on Medicare. And they have not got it done. And my case to the American people is, if you're happy with inactivity, stay with the horse. The horse is up there now. But if you want change, you need to get somebody that knows how to bring Republicans and Democrats together to get positive things done for American. MODERATOR: New question, new subject. Vice President Gore, on the environment. In your 1992 book you said, quote, "We must make the rescue of our environment the central organizing principle for civilization and there must be a wrenching transformation to save the planet." Do you still feel that way? GORE: I do. I think that in this 21st century we will soon see the consequences of what's called global warming. There was a study just a few weeks ago suggesting that in summertime the north polar ice cap will be completely gone in 50 years. Already people see the strange weather conditions that the old timers say they've never seen before in their lifetimes. And what's happening is the level of pollution is increasing significantly. Now, here is the good news, Jim. If we take the leadership role and build the new technologies, like the new kinds of cars and trucks that Detroit is itching to build, then we can create millions of good new jobs by being first into the market with these new kinds of cars and trucks and other kinds of technologies. You know the Japanese are breathing down our necks on this. They're moving very rapidly because they know that it is a fast-growing world market. Some of these other countries, particularly in the developing world, their pollution is much worse than anywhere else and their people want higher standards of living. And so they're looking for ways to satisfy their desire for a better life and still reduce pollution at the same time. I think that holding onto the old ways and the old argument that the environment and the economy are in conflict is really outdated. We have to be bold. We have to provide leadership. Now it's true that we disagree on this. The governor said that he doesn't think this problem is necessarily caused by people. He's for letting the oil companies into the Arctic National Wildlife Refuge. Houston has just become the smoggiest city in the country. And Texas is number one in industrial pollution. We have a very different outlook. And I'll tell you this, I will fight for a clean environment in ways that strengthen our economy. MODERATOR: Governor? BUSH: Well, let me start with Texas. We are a big industrial state. We reduced our industrial waste by 11%. We cleaned up more brown fields than any other administration in my state's history, 450 of them. Our water is cleaner now. MODERATOR: Explain what a brown field is to those who don't follow this. BUSH: A brown field is an abandoned industrial site that just sits idle in some of our urban centers. And people are willing to invest capital in the brown fields don't want to do so for fear of lawsuit. I think we ought to have federal liability protection, depending upon whether or not standards have been met. The book you mentioned that Vice President Gore wrote, he also called for taxing -- big energy taxes in order to clean up the environment. And now that the energy prices are high, I guess he's not advocating those big energy taxes right now. I believe we ought to fully fund the Land and Water Conservation Fund to -- with half the money going to states so states can make the right decisions for environmental quality. I think we need to have clean coal technologies. I propose $2 billion worth. By the way, I just found out the other day an interesting fact, that there is a national petroleum reserve right next to -- in Prudhoe Bay that your administration opened up for exploration in that pristine area. And it was a smart move because there's gas reserves up there. We need gas pipelines to bring the gas down. Gas is a clean fuel that we can burn to -- we need to make sure that if we decontrol our plants that there's mandatory -- that the plants must conform to clean air standards, the grandfathered plants, that's what we did in Texas. No excuses. You must conform. In other words, there are practical things we can do. But it starts with working in a collaborative effort with states and local folks. If you own the land, every day is Earth Day. People care a lot about their land and care about their environment. Not all wisdom is in Washington, D.C. on this issue. MODERATOR: Where do you see the basic difference in very simple terms in two or three sentences between you and the governor on the environment? If a voter wants to make a choice, what is it? GORE: I'm really strongly committed to clean water and clean air, and cleaning up the new kinds of challenges like global warming. He is right that I'm not in favor of energy taxes. I am in favor of tax cuts to encourage and give incentives for the quicker development of these new kinds of technologies. And let me say again, Detroit is rearing to go on that. We differ on the Arctic National Wildlife Refuge, as I have said. We differ on whether or not pollution controls ought to be voluntary. I don't think you can -- I don't think you can get results that way. We differ on the kinds of appointments that we would make. MODERATOR: Would you say it's a fundamental difference? GORE: I think it's a fundamental difference. Let me give you an example. MODERATOR: Hold on one second. GORE: Okay, sure. MODERATOR: We've talked about supply. I just want to know for somebody -- we're getting close to the end of our time here. If somebody wanted to vote on the environment, how would you draw the differences, Governor? BUSH: Well, I don't believe in command and control out of Washington, D.C. I believe Washington ought to set standards, but again I think we ought to be collaborative at the local levels and I think we ought to work with people at the local levels. And by the way, I just want to make sure -- I can't let him just say something and not correct it. The electric decontrol bill that I fought for and signed in Texas has mandatory emission standards, Mr. Vice President. That's what we ought to do at the federal level when it comes to grandfathered plants for utilities. I think there's a difference. I think, for example, take -- when they took 40 million acres of land out of circulation without consulting local officials, I thought that was -- MODERATOR: That was out in the west? BUSH: Out in the west, yeah. And so -- on the logging issue. That's not the way I would have done it. Perhaps some of that land needs to be set aside. But I certainly would have consulted with governors and elected officials before I would have acted unilaterally. MODERATOR: Would you believe the federal government still has some new rules and new regulations and new laws to pass in the environmental area or do you think -- BUSH: Sure, absolutely, so long as they're based upon science and they're reasonable. So long as people have input. MODERATOR: What about global warming? BUSH: I think it's an issue that we need to take very seriously. But I don't think we know the solution to global warming yet. And I don't think we've got all the facts before we make decisions. I tell you one thing I'm not going to do is I'm not going to let the United States carry the burden for cleaning up the world's air. Like Kyoto Treaty would have done. China and India were exempted from that treaty. I think we need to be more even-handed, as evidently 99 senators -- I think it was 99 senators supported that position. MODERATOR: Global warming, the Senate did turn it down. I think -- BUSH: 99 to nothing. GORE: Well, that vote wasn't exactly -- a lot of the supporters of the Kyoto Treaty actually ended up voting for that because the way it was worded. But there's no doubt there's a lot of opposition to it in the Senate. I'm not for command and control techniques either. I'm for working with the groups, not just with industry but also with the citizen groups and local communities to control sprawl in ways that the local communities themselves come up with. But I disagree that we don't know the cause of global warming. I think that we do. It's pollution, carbon dioxide, and other chemicals that are even more potent, but in smaller quantities, that cause this. Look, the world's temperature is going up, weather patterns are changing, storms are getting more violent and unpredictable. What are we going to tell our children? I'm a grandfather now. I want to be able to tell my grandson when I'm in my later years that I didn't turn away from the evidence that showed that we were doing some serious harm. In my faith tradition, it is -- it's written in the book of Matthew, "Where your heart is, there is your treasure also." And I believe that -- that we ought to recognize the value to our children and grandchildren of taking steps that preserve the environment in a way that's good for them. BUSH: Yeah, I agree. I just -- I think there has been -- some of the scientists, I believe, Mr. Vice President, haven't they been changing their opinion a little bit on global warming? A profound scientist recently made a different -- MODERATOR: Both of you have now violated -- excuse me. Both of you have now violated your own rules. Hold that thought. GORE: I've been trying so hard not to. MODERATOR: I know, I know. But under your alls rules you are not allowed to ask each other a question. I let you do it a moment ago. BUSH: Twice. MODERATOR: Now you just -- twice, sorry. (LAUGHTER) GORE: That's an interruption, by the way. MODERATOR: That's an interruption, okay. But anyhow, you just did it so now -- BUSH: I'm sorry. I apologize, Mr. Vice President. MODERATOR: You aren't allowed to do that either, see? (LAUGHTER) I'm sorry, go ahead and finish your thought. People care about these things I've found out. BUSH: Of course they care about them. Oh, you mean the rules. MODERATOR: Yeah, right, exactly right. Go ahead. BUSH: What the heck. I -- of course there's a lot -- look, global warming needs to be taken very seriously, and I take it seriously. But science, there's a lot -- there's differing opinions. And before we react, I think it's best to have the full accounting, full understanding of what's taking place. And I think to answer your question, I think both of us care a lot about the environment. We may have different approaches. We may have different approaches in terms of how we deal with local folks. I just cited an example of the administration just unilaterally acting without any input. And I remember you gave a very good answer to New Hampshire about the White Mountains, about how it was important to keep that collaborative effort in place. I feel very strongly the same place. It certainly wasn't the attitude that took place out west, however. MODERATOR: New question. Last question. For you, Governor. And this flows somewhat out of the Boston debate. You, your running mate, your campaign officials have charged that Vice President Gore exaggerates, embellishes and stretches the facts, etcetera. Are you -- do you believe these are serious issues? This is a serious issue that the voters should use in deciding which one of you two men to vote for on November 7? BUSH: Well, we all make mistakes. I've been known to mangle a syllable or two myself, you know, if you know what I mean. I think credibility is important. It is going to be important for the president to be credible with Congress, important for the president to be credible with foreign nations. And yes, I think it's something that people need to consider. This isn't something new. I read a report, or a memo, from somebody in his 1988 campaign -- I forgot the fellow's name -- warning then Senator Gore to be careful about exaggerating claims. I thought during his debate with Senator Bradley saying he authored the EITC when it didn't happen. I mention the last debate -- MODERATOR: EITC? BUSH: The Earned Income Tax Credit, sorry. MODERATOR: That's all right. BUSH: A lot of initials from a guy who's not from Washington, isn't it? Anyway, he co-sponsored McCain-Feingold, and yet he didn't. And so I think this is an issue. I found it to be an issue in trying to defend my tax relief package. I thought there was some exaggerations about the numbers. But the people are going to have to make up their mind on this issue. And I am going to continue to defend my record and defend my propositions against what I think are exaggerations. Exaggerations like, for example, only 5% of seniors receive benefits under my Medicare reform package. That's what he said the other day, and that's simply not the case. And I have every right in the world to defend my record and positions. That's what debates are about and that's what campaigns are about. MODERATOR: Vice President Gore? GORE: I got some of the details wrong last week in some of the examples that I used, Jim, and I'm sorry about that. And I'm going to try to do better. One of the reasons I regret it is that getting a detail wrong interfered several times with the point that I was trying to make. However many days that young girl in Florida stood in her classroom, however long, even if it was only one day, doesn't change the fact that there are a lot of overcrowded classrooms in America and we need to do something about that. There are seniors who pay more for their prescriptions than a lot of other people, more than their pets, sometimes. More sometimes than people in foreign countries. And we need to do something about that. Not with the measure that leaves the majority of them without any real basic help until the next president's term of four years is over. But right away. And that means doing it under the Medicare program. I can't promise that I will never get another detail wrong. I can promise you that I will try not to, and hard. But I will promise you this with all the confidence in my heart and in the world, that I will do my best if I'm elected president, I'll work my heart out to get the big things right for the American people. MODERATOR: Does that resolve the issue, Governor? BUSH: That's going to be up to the people, isn't it? MODERATOR: Does it resolve it for you? BUSH: Depends on what he says in the future in the campaign. MODERATOR: Your folks are saying some awful things. BUSH: I hope they're not awful things. I think they may be using the man's own words. MODERATOR: Well, what I mean is calling him a serial exaggerator -- BUSH: I don't believe I've used those words. MODERATOR: No, but your campaign ads. BUSH: Maybe they have. MODERATOR: And your campaign officials have. And your campaign officials, Mr. Vice President, are now calling the governor a bumbler. BUSH: Wait a minute. (LAUGHTER) MODERATOR: I mean, my point is, should this -- is this -- GORE: I don't use language like that and I don't think that we should. MODERATOR: It's in your commercial. GORE: I understand. The -- I haven't seen that, in my commercials? BUSH: You haven't seen the commercial? MODERATOR: Your -- GORE: I think that what -- I think the point of that is that anybody would have a hard time trying to make a tax cut plan that is so large, that would put us into such big deficits, that gives almost half the benefits to the wealthiest of the wealthy. I think anybody would have a hard time explaining that clearly in a way that makes sense to the average person. BUSH: That's the kind of exaggeration I was just talking about. (LAUGHTER) GORE: Well, I wasn't the one having trouble explaining it. MODERATOR: Gentlemen, it's time to go to the closing statements. And Vice President Gore, you have two minutes. GORE: Jim, one of the issues that I would like to close with in my statement is education, because it's an example of the overall approach that I think is important. This race is about values, it's about change, it's about giving choices to the American people. And education is my number one priority, because I think that it's the most important big major change that we can bring in our country. I agree with Governor Bush that we should have new accountability, testing of students. I think that we should require states to test all students, test schools and school districts, and I think that we should go further and require teacher testing for new teachers also. The difference is that while my plan starts with new accountability and maintains local control, it doesn't stop there. Because I want to give new choices to parents. To send their kids to college with a $10,000 tax deduction for college tuition per child per year. I want to reduce the size of the classrooms in this country. For one basic reason, so that students can get more one-on-one time with teachers. And the way to do that is first to recruit more teachers. I've a plan in my budget to recruit 100,000 new, highly qualified teachers and to help local school districts build new schools. I think that we have to put more emphasis on early learning and pre-school. Now, here is how that connects with all the rest of what we've been talking about. If you have -- if you squander the surplus on a huge tax cut that goes mostly to those at the top, then you can't make education the top priority. If the tax cut is your number one, two, three and four priority, you can't do education. You can't do both. You have to choose. I choose education and health care, the environment and retirement security, and I ask for your support. MODERATOR: Governor Bush, two minutes. BUSH: Jim, thank you very much. Mr. Vice President, thank you very much, and I would like to thank the folks here at Wake Forest, and I want to thank you all for listening. I'm running to get some things done for America. There's too many issues left unresolved. There's been too much finger pointing and too much name calling in Washington, D.C. I would like to unite this country to get an agenda done that will speak to the hopes and aspirations of the future. I want to have an education system that sets high standards, local control of schools and strong accountability. No child should be left behind in America. I want to make sure we rebuild our military to keep the peace. I worry about morale in today's military. The warning signs are clear. It is time to have a new commander in chief who will rebuild the military, pay our men and women more, make sure they're housed better and have a focused mission for our military. Once and for all, I want to do something about Medicare. This issue has been too long on the table because it's been a political issue. It's time to bring folks together to say that all seniors will get prescription drug coverage. I want to do something about Social Security. It's an important priority, because now is the time to act and we're going to say to our seniors, our promises we've made to you will be promises kept. But younger workers, in order to make sure the system exists tomorrow, younger workers ought to be able to take some of your own money and invest it in safe securities to get a better rate of return on that money. And finally, I do believe in tax relief. I believe we can set our priorities. I don't believe, like the vice president does, in huge government. I believe in limited government. By having a limited government and a focused government, we can send some of the money back to the people who pay the bills. I want to have tax relief for all people who pay the bills in America, because I think you can spend your money more wisely than the federal government can. Thank you for listening. I'm asking for your vote, and God bless. MODERATOR: And we will return next Tuesday night, October 17th, from Washington University in St. Louis for the third and final debate. Thank you, Vice President Gore, Governor Bush. See you next week. For now, from Winston-Salem, I'm Jim Lehrer, thank you and good night. (APPLAUSE)
