# Democratic Candidates Debate in Manchester, New Hampshire

**Date:** January 5, 2008
**Source:** https://www.presidency.ucsb.edu/documents/democratic-presidential-candidates-debate-manchester-new-hampshire-0

---

PARTICIPANTS: Senator Hillary Clinton (NY); Former Senator John Edwards (NC); Senator Barack Obama (IL) and; Governor Bill Richardson (NM) MODERATORS: Charles Gibson (ABC-News); and Scott Spradling (WMUR-TV) CHARLES GIBSON, ABC: We are back at the Dana Humanities Center at Saint Anselm College here in Manchester, New Hampshire. And I am delighted to say that the four leading Democratic presidential candidates vying for the Democratic nomination are all joining us this evening. And we have, again, drawn lots for their placement on the stage. And so let me introduce them from left to right. We have with us former Senator John Edwards of North Carolina, Senator Barack Obama of Illinois, Governor Bill Richardson of New Mexico and Senator Hillary Clinton from New York. And again, for the first 45 minutes of this debate, I will be posing questions in three rather broad categories. We'll do 15 minutes each, but with the hope that I can sort of stay out of the way to the extent possible and let the candidates discuss the issues among themselves. There are no lights to limit -- time limits, at least for this part of the debate. But I will interrupt politely, I hope, if things seem to be going a little bit long. So let me start with what is generally agreed to be, I think, the greatest threat to the United States today, and, somewhat to my surprise, has not been discussed as much in the presidential debates this year as I thought would be, and that is nuclear terrorism. And for some background, here's ABC's Chief Investigative Correspondent Brian Ross. BRIAN ROSS, ABC CHIEF INVESTIGATIVE CORRESPONDENT: After more than six years of trying, the United States still does not have a reliable way to spot nuclear material that terrorists might smuggle into the country, much as ABC News twice did in demonstrations without being caught. And after six years of trying, the United States has yet to capture the man who says it is his religious duty to get nuclear weapons: Osama bin Laden. And in the last 18 months, U.S. officials say his Al Qaida has regrouped using safe havens along the Pakistani border to train and dispatch hundreds of new recruits. ROSS: And just as troubling, amidst all the turmoil in Pakistan, the influence of bin Laden continues to grow there, a country with many nuclear weapons. Charlie? (END VIDEO CLIP) MR. GIBSON: Brian Ross there. Well, Osama bin Laden, as he pointed out, has said it is his duty to try to get nuclear weapons. Al Qaida has been reconstituted and re-energized in the western part of Pakistan. And so my general question is, how aggressively would you go after Al Qaida leadership there? And let me start with you, Senator Obama, because it was you who said in your foreign policy speech that you would go into western Pakistan if you had actionable intelligence to go after it, whether or not the Pakistani government agreed. Do you stand by that? SEN. OBAMA: I absolutely do stand by it, Charlie. What I said was that we should do everything in our power to push and cooperate with the Pakistani government in taking on Al Qaida, which is now based in northwest Pakistan. And what we know from our national intelligence estimates is that Al Qaida is stronger now than at any time since 2001. And so, back in August, I said we should work with the Pakistani government, first of all to encourage democracy in Pakistan so you've got a legitimate government that we're working with, and secondly that we have to press them to do more to take on Al Qaida in their territory. What I said was, if they could not or would not do so, and we had actionable intelligence, then I would strike. And I should add that Lee Hamilton and Tom Keaton, the heads of the 9/11 Commission, a few months later wrote an editorial saying the exact same thing. I think it's indisputable that that should be our course. Let me just add one thing, though. On the broader issue of nuclear proliferation, this is something that I've worked on since I've been in the Senate. I worked with Richard Lugar, then the Republican head of the Senate Foreign Relations Committee, to pass the next stage of what was Nunn-Lugar so that we would have improved interdiction of potentially nuclear materials. And it is important for us to rebuild a nuclear nonproliferation strategy, something that this administration, frankly, has ignored, and has made us less safe as a consequence. It would not cost us that much, for example, and would take about four years for us to lock down the loose nuclear weapons that are still floating out there, and we have not done the job. MR. GIBSON: I'm going to go the others in a moment, but what you just outlined is essentially the Bush doctrine. We can attack if we want to, no matter the sovereignty of the Pakistanis. SEN. OBAMA: No, that is not the same thing, because here we have a situation where Al Qaida, a sworn enemy of the United States, that killed 3,000 Americans and is currently plotting to do the same, is in the territory of Pakistan. We know that. And this is not speculation. This is not a situation where we anticipate a possible threat in the future. And my job as commander in chief will be to make sure that we strike anybody who would do America harm when we have actionable intelligence do to that. MR. GIBSON: Senator Edwards, do you agree with him? SEN. EDWARDS: If I as president of the United States know where Osama bin Laden is, I would go get him, period. This man is the mastermind of a mass murder in the United States of America. He is public enemy number one, as Al Qaida is. But I would add, this has to be put into a bigger context of what should America be doing over the long term to deal with this whole issue of nuclear proliferation? Because if you look at Pakistan, it's a perfect vehicle for actually thinking about this issue. Here's an unstable leader, Musharraf, in a country with a serious radical -- violently radical element that could, under some circumstances, take over the government. If they did, they would have control of a nuclear weapon. They could either use it, or they could turn it over to a terrorist organization to be used against America or some of our allies. I think the bigger picture on this is, what do we do over the long term? Because what we're doing now is essentially an ad hoc, nation-by- nation, case-by-case basis of trying to control the spread of this nuclear technology. In the short term, that is exactly what we should do and what I would do as president of the United States. But A.Q. Khan, who developed the nuclear weapon for Pakistan, we know has already spread some of this technology to other places. And I think this ad hoc policy does not work over the long term. And what I believe we should be doing over the long term and what I will do as president of the United States, besides dealing with these short-term threats -- which are very serious and should be taken seriously -- I, as president of the United States, want to do what some Republicans and some Democrats have said, which is to lead a long-term initiative -- international initiative -- to actually rid the world of nuclear weapons, because that is the only way to make the world safer and secure and to keep America safe. MR. GIBSON: Well, you led me right up to the point of what you'd do if the Islamic radicals actually took control of the Pakistani government and, therefore, were in control of nuclear weapons, and then you went away from that. But I'll come back to that in a moment. Governor Richardson? GOV. RICHARDSON: In any foreign policy decision, I would use diplomacy first, in response to your question. And that basically means that the last thing we need in the Muslim world is another action like Iraq, which is going to inflame the Muslim world in a horrendous way. Now, here's what I would do. First, with Pakistan, here is an example of a country, a potentially failed nation-state with nuclear weapons. What a president must do is have a foreign policy of principles and realism. And the Bush foreign policy, with Musharraf, we get the worst of all worlds. We had a situation where he has not gone after Al Qaida in his own country, despite the fact that we've given him $11 billion. And he's also severely damaged the constitution. He's basically said that he is the supreme dictator. So we have the worst of all worlds. What I would specifically do as president is I would ask Musharraf to step aside. There is a provision in the Pakistani constitution... MR. GIBSON: Ask him to step aside? GOV. RICHARDSON: Yes. For a caretaker... (CROSSTALK) GOV. RICHARDSON: Because we have the leverage to do that. GOV. RICHARDSON: We have the leverage to do that. (CROSSTALK) GOV. RICHARDSON: And I would send a high-level envoy to ask him to step aside. There's a provision in the Pakistani constitution for a caretaker government of technocrats. This happened when a previous prime minister died. And I would make it unmistakably clear that he had to have elections. Now, elections are scheduled tentatively for February. A broadly based government, it's what's best for the United States. MR. GIBSON: I understand your point about diplomacy, but Senator Obama's postulate was, we have actionable intelligence, the Musharraf government won't move. Do we, should we go into western Pakistan and, essentially, try to take him out? GOV. RICHARDSON: If we have actionable intelligence that is real and if Musharraf is incapable, which he is -- because here's a man who has not stood up for his democracy, he is virtually in a situation where he's losing control -- then you do take that action. However, Charlie, first you use diplomacy. And diplomacy is to try to get what is best for the United States. And that is a democratic Pakistan with free and fair elections, and a concerted effort on the part of Musharraf or whoever is in the leadership in Pakistan to go after the terrorists in those safe havens which they have not done. MR. GIBSON: Senator Clinton? SEN. CLINTON: Well, I think it's important to get back to your question, because obviously that's the most direct threat to the United States. We did take action similar to what has been described about 10 years ago, based on what was thought to be actionable intelligence, sending in missiles to try to target bin Laden and his top leadership who were thought to be at a certain meeting place. They were not taken out at the time. So we have to be very conscious of all the consequences. Now, as far as I know, there are, like, five things quickly that we should be looking at. Bin Laden has in large measure regrouped because we did not put in the troops and make the commitment to aggressively going after him inside Afghanistan when we had a chance. Therefore, we need more NATO troops and a faster effort to train the Afghan army so that we do have the personnel and the technology, including the Predators, to be able to be on the spot at the time to try to move as quickly as possible. Secondly, I think it's imperative that any actionable intelligence that would lead to a strike inside Pakistan's territory be given the most careful consideration. SEN. CLINTON: And at some point -- probably when the missiles have been launched -- the Pakistani government has to know they're on the way. Because one of the problems is the inherent paranoia about India in the region in Pakistan, so that we've got to have a plan to try to make sure we don't ignite some kind of reaction before we even know whether the action we took with the missiles has worked. Real quickly, thirdly, so far as we know right now, the nuclear technology is considered secure, but there isn't any guarantee, especially given the political turmoil going on inside Pakistan. I would work very hard to try to get Musharraf, who is the elected president -- these elections are about parliamentary positions. If you remove Musharraf and have elections, that's going to be very difficult for the United States to be able to control what comes next. I would try to get Musharraf to share the security responsibility of the nuclear weapons with a delegation from the United States and, perhaps, Great Britain, so that there is some fail- safe. And just, finally, I think that what we have to do is, Musharraf and Afghanistan, is to repair the failed policies of the Bush administration. And that's going to require intensive effort in the region. And Bill is right that we should be engaged in that diplomacy right away. But this is the forgotten front line in the war against terrorism, because the Bush administration has walked away. GOV. RICHARDSON: Charlie, I want us to just remember history. I want us to remember history. Years ago, we backed the shah of Iran, a dictator. We are paying for that policy today by having backed a tyrant who repressed his people -- unintended consequences. A president has to act. I believe that we have to be on the side of the Pakistani people, not on the side of the dictator. And what we have today is an opportunity to get Musharraf to step aside, to move toward this caretaker government, but also -- also -- to use the leverage of the assistance we've given him. Most of the assistance that we've given him -- $11 billion, he hasn't used to go after terrorists. He's put it in military assistance for his fight against India. The money has been stolen. We get the worst of all worlds. If we stand on a foreign policy of principle, of human rights, along with protecting our security, that is the best direction for our foreign policy. SEN. OBAMA: Let me just pick up on a couple of things that have been said. And I think people are in broad agreement here. But I think one of the things that's been left out is Iraq. And part of the reason that we neglected Afghanistan, part of the reason that we didn't go after bin Laden as aggressively as we should have is we were distracted by a war of choice. And that's the flaw of the Bush doctrine. It wasn't that he went after those who attacked America. It was that he went after those who didn't. And as a consequence, we have been bogged down, paid extraordinary -- an extraordinary price in blood and treasure, and we have fanned the anti-American sentiment that actually makes it more difficult for us to act in Pakistan. Just one more point I want to make on this, Charlie. I think it is absolutely true that we have to, as much as possible, get Pakistan's agreement before we act. And that's always going to be the case. MR. GIBSON: I want to... SEN. OBAMA: But we have to make sure that we do not hesitate to act when it comes to Al Qaida. Because they are currently stronger than they were at any time since 2001, partly because we took our eye off the ball. MR. GIBSON: I want to go to another question. And it really is the central one in my mind in nuclear terrorism. The next president of the United States may have to deal with a nuclear attack on an American city. MR. GIBSON: I've read a lot about this in recent days. The best nuclear experts in the world say there's a 30 percent chance in the next 10 years. Some estimates are higher. Graham Allison (ph), at Harvard, says it's over 50 percent. Senator Sam Nunn, in 2005, who knows a lot about this, posed two questions that stick in my mind. And I want to put them to you here. On the day after a nuclear weapon goes off in an American city, what would we wish we had done to prevent it? And what will we actually do on the day after? Senator? SEN. EDWARDS: Well... (CROSSTALK) SEN. EDWARDS: Well, let me say first, this is the very point I was making a few minutes ago. In the short term, we're faced with very, very serious threats about the possibility of these nuclear weapons getting in the hands of a terrorist group or somebody who wants to attack the United States of America. The first thing is we have to immediately find out who's responsible and go after them. And that is the responsibility of the president of the United States. Because if someone has attacked us with a nuclear weapon, it means they have nuclear technology, it means they could have gotten another nuclear weapon into the United States that we're unaware of. We have to find these people immediately and use every tool available to us to stop them. Secondly, it is the responsibility of the United States -- and by the way, what I'm about to say doesn't just apply to a nuclear attack. It applies to this crisis that exists in Pakistan right now with the assassination of Benazir Bhutto. It is the responsibility of the president in times like this to be a force for strength, principled strength, but also calmness. It is enormously important for the president of the United States not to take -- to react and to react strongly, but to do it in a way that is calming for the American people and calming for the world. Because it would be an enormous mistake for the president of the United States to take a terrible, dangerous situation where millions of Americans or thousands of Americans could have lost their lives, and to ratchet up the rhetoric and make it worse than it already is. MR. GIBSON: Let me come to the two Sam Nunn questions to you, Senator. SEN. OBAMA: Well, as I said, I've already been working on this. And I think this is the most significant foreign policy issue that we confront. We would obviously have to retaliate against anybody who struck American soil, whether it was nuclear or not. It would be a much more profound issue if it were nuclear weapons. That's why it's so important for us to rebuild the Nuclear Non- Proliferation Treaty that has fallen apart under this administration. We have not made a commitment to work with the Russians to reduce our own nuclear stockpiles. That has weakened our capacity to pressure other countries to give up nuclear technology. We have not locked down the loose nuclear weapons that are out there right now. These are all things that we should be taking leadership on. And part of what we need to do in changing our foreign policy is not just end the war in Iraq; we have to change the mindset that ignores long- term threats and engages in the sorts of actions that are not making us safe over the long term. MR. GIBSON: And I know, Senator Clinton, you've worked on this, as well. SEN. CLINTON: Yes, I have. MR. GIBSON: But in terms of retaliation, this is not likely going to be a state that sets off a nuclear attack (inaudible), it's going to be a stateless group. SEN. CLINTON: Well, the first part of your question was, what would we wish we had done. And I have worked on this in past legislation to move in the direction that I think we should go to have a very high level of commitment from the White House, including a person responsible in our government for marshaling our resources against the proliferation of nuclear weapons. SEN. CLINTON: There has to be a better organizing effort to make sure that every part of the United States government is working together. I don't think we've done what we need to do on homeland defense. You started that segment talking about the ease with which ABC smuggled things into this country. We haven't done enough on port security. We have not made the kind of commitment that is necessary to protect us from this kind of importation. But let me just add that when you look at where we are, the stateless terrorists will operate from somewhere. I mean, part of our message has to be there is no safe haven. If we can demonstrate that the people responsible for planning the nuclear attack on our country may not themselves be in a government or associated with a state, but have a haven within one, then every state in the world must know we will retaliate against those states. There cannot be safe havens for stateless terrorists who are in these networks that are plotting to have the proliferation of nuclear weapons and be smuggling into our country or elsewhere the kind of suitcase device that could cause such havoc. So I think we have to be very, very clear. You know, deterrence worked during the Cold War in large measure because the United States made it clear to the Soviet Union that there would be massive retaliation. We have to make it clear to those states that would give safe haven to stateless terrorists, that would launch a nuclear attack against America that they would also face a very heavy retaliation. MR. GIBSON: Final word, Governor? GOV. RICHARDSON: Charlie, when I was secretary of energy, that was one of my responsibilities: securing nuclear stockpiles, nuclear materials, mainly with the Soviet Union. I went there many times. We made progress. But since then, there has been a proliferation of loose nuclear weapons, mainly in the hands of terrorists, that could cross, presumably, a border; that could be smuggled in in a cargo ship with our very weak port security. If I'm elected president, I will do two things. First, I will seek immediate negotiations with the Soviet Union and other nuclear states to reduce the number of nuclear weapons, but also a treaty on fissionable material, where you have verification, where you try to secure those loose nuclear weapons from states like North Korea and others that could be drifting into the international community. But most importantly, I think we have to realize that the challenges America faces internationally, they're transnational. They're stateless. It's international terrorism. It's nuclear terrorism. It's environmental degradation. Reducing greenhouse gas emissions. Making us less dependent on fossil fuels. Those are the transnational challenges that are going to require international cooperation. And this president believes in unilateralism. This president believes in going military first. This president believes in preemption. You discussed this in the Republican debate. My foreign policy would be different. MR. GIBSON: I'm going to... GOV. RICHARDSON: There would be realism,... MR. GIBSON: I'm going to move on. GOV. RICHARDSON: ... human rights and principles. MR. GIBSON: I'm going to move on. And I'm going to move on to domestic policy, how much the government is spending, how much you would spend with the programs you've proposed and the promises you've made. MR. GIBSON: And some of that is entitlements. For a little background, ABC's Betsy Stark. (BEGIN VIDEO CLIP) ABC BUSINESS CORRESPONDENT BETSY STARK: Every hour of this new year, another 400 baby boomers will turn 60, swelling the ranks of those soon eligible to collect Social Security and Medicare. The forecasts are foreboding. By 2017, the Social Security surplus runs dry and the system begins taking in less tax revenue than it pays out in benefits. For Medicare, the problems are even more severe. By 2013, the program's Hospital Insurance Fund is expected to fall into the red and the insurance premiums seniors pay for doctor's visits and prescription drugs are projected to keep rising. (END VIDEO CLIP) MS. STARK: Many young Americans simply assume there will be nothing left for them to guarantee the security of their old age. Charlie? MR. GIBSON: So I hope we have time to get to some of that, but before we get to it, talking about domestic policy, I want to get to the concept of change, because 60 percent of the people going into the Democratic caucuses in Iowa said they were going to go there for change, and that seemed to redound to your benefit, Senator Obama. MR. GIBSON: And arriving here in New Hampshire, Senator Clinton, you called into question, really, what that means. And you said, and I'm quoting you now, On a lot of issues, it's hard to know where he, referring to Senator Obama, stands. And people need to ask that. Everybody needs to be vetted. So let me have a little dialogue between the two of you. What does he need to be vetted on? And what questions are there about Senator Obama that are unanswered? SEN. CLINTON: Well, let me say, first, that I think we're all advocating for change. We all want to change the status quo, which is George W. Bush and the Republican domination of Washington for so many years. And we all are putting forth ideas about how best to deliver that change. But I don't think you make change by, you know, calling for it or by demanding it; I think it is a result of very hard work, bringing people together, stating clearly what your goals are, what your principles are and then achieving them. And I do think that, you know, part of what this primary process is all about, and New Hampshire voters are, you know, famously independent in making their judgments, is to look at our records, to evaluate where we stand and what we stand for. And I think that there is a lot of, you know, room to ask all of us questions. You know, Senator Obama has been -- as the Associated Press described it, he could have a pretty good debate with himself, because four years ago, he was for single-payer health care. Then he moved toward a rejection of that, a more incremental approach. Then he was for universal health care. Then he proposed a health care plan that doesn't cover everybody. SEN. CLINTON: I think that's relevant. I mean, I think that what we're looking for is a president we can count on, that you know where that president is yesterday, today and tomorrow. And I think that, you know, there are questions that should be asked and answered from each of us. And I certainly have no problem with whatever scrutiny comes my way. MR. GIBSON: Senator Obama? SEN. OBAMA: Well, you know, I think the Associated Press was quoting some of your folks, Hillary, so let's talk specifically about health care, since you mentioned that. I have been entirely consistent in my position on health care. What I said -- and I have said on the campaign trail this time -- is if I were designing a system from scratch, I would set up a single- payer system, because we could gain enormous efficiencies from it. SEN. OBAMA: Our medical care costs twice as much per capita as any other advanced nation. But what I've also said is that, given that half of the people are getting, already, employer-based health care, that it would be impractical for us to do so, which is why I put forward a plan that says anybody can get health care that is the same as the health care that I have as a member of Congress -- similar to the plans that you and John have offered. We do have a philosophical difference. John and yourself believe that, if we do not mandate care, if we don't force the government to get to -- if the government does not force taxpayers to buy health care, that we will penalize them in some fashion. I disagree with that because, as I go around town hall meetings, I don't meet people who are trying to avoid getting health care. The problem is, they can't afford it. And the costs are too high. And so, as a consequence, we focus on reducing costs. Now, this is a legitimate argument for us to have, but it's not true that I leave them out. Your premise is, they won't buy it even if it's affordable. I disagree with that. Now, let me just make one last point, because you say that somehow I have not been specific. Social Security is a great example, something that you just raised, Charlie. And here's an area where John and myself were actually quite specific and said if we are going to deal with this problem specifically, what we need to do is to raise the cap on the payroll tax so that wealthy individuals are paying a little bit more into the system. SEN. OBAMA: Right now, somebody like Warren Buffet pays a fraction of 1 percent of his income in payroll tax, whereas the majority of the audience here pays payroll tax on 100 percent of their income. And I've said that was not fair. You criticized me for that, which is fine. We have a disagreement on that, but that's hardly because I wasn't specific on it. I was very specific on it, and... SEN. CLINTON: Well, but I want to go back to health care and make another point. You have a mandate in your health care plan. SEN. OBAMA: For children. SEN. CLINTON: You mandate parents to have health care for children. SEN. OBAMA: That's exactly right. SEN. CLINTON: And, obviously, you did that because you want all children covered. So... SEN. OBAMA: Because they don't have a choice. SEN. CLINTON: Well, they don't have a choice, and you're going to make sure that parents get health care for children. So, you know, you stopped short of going the distance to make sure that we had a system that could actually deliver health care for everyone. But it's not only about health care. You know, I think that two weeks ago, you criticized Senator Edwards in saying that he was unelectable because he had changed positions over the course of four years, that four years ago he wasn't for universal health care; now, he is. Well, you've changed positions within three years on, you know, a range of issues that you put forth when you ran for the Senate, and now you have changed. You know, you said you would vote against the Patriot Act. You came to the Senate; you voted for it. You said that you would vote against funding for the Iraq war. You came to the Senate, and you voted for $300 billion of it. So I just think it's fair for people to understand that many of the charges that have been leveled, not just at me, but also at Senator Edwards, are not totally, you know, unrelated to the very record you have. And you've said records matter. (CROSSTALK) SEN. CLINTON: And I think that we should get into examining everybody's record. SEN. OBAMA: I want John to be able to get in on this, but since this was directed at me, let me just make sure that I address this. First of all, I never said John was unelectable. Somebody asked me specifically what did I think was the difference between myself and John, and I pointed out some areas where I thought we had some differences. SEN. CLINTON: And you said that he had changed positions, did you not? SEN. OBAMA: And I did, because I thought that I'd been more consistent on those positions. I have no problem, Hillary, with you pointing out areas where you think we have differences. But on health care, for example, the reason that I mandate for children is because children do not have a choice; adults do. And it's my belief that they will choose to have health care, if it is affordable. Now, that's a perfectly legitimate policy difference for us to have. And that is different from saying that I will refuse to cover or leave out a bunch of individuals. And the last point I just want to make on this, Charlie, is, you know, these are all good public servants. And everybody has great qualifications and has done good things. But what I think is important that we don't do is to try to distort each other's records as election day approaches here in New Hampshire. Because what I think the people of America are looking for are folks who are going to be straight about the issues and are going to be interested in solving problems and bringing people together. SEN. OBAMA: That's the reason, I think, we did so well in Iowa. MR. GIBSON: You've been very patient. (LAUGHTER) SEN. OBAMA: You were. And I appreciate it. SEN. EDWARDS: Thank you. No, you're welcome. You're more than welcome. Let me just say a quick word about this. You know, Senator Obama and I have differences. We do. We have a difference about health care, which he and I have talked about before. We have a fundamental difference about the way you bring about change. But both of us are powerful voices for change. And if I might add, we finished first and second in the Iowa caucus, I think in part as a result of that. Now, what I would say this: Any time you speak out powerfully for change, the forces of status quo attack. That's exactly what happens. It's fine to have a disagreement about health care. To say that Senator Obama is having a debate with himself from some Associated Press story I think is just not -- that's not the kind of discussion we should be having. I think that every time this happens, what will occur -- every time he speaks out for change, every time I fight for change, the forces of status quo are going to attack -- every single time. SEN. EDWARDS: And what we have to remember -- and this is the overarching issue here, because what we really need in New Hampshire and in future state primaries, is we need an unfiltered debate between the agents of change about how we bring about that change. Because we have differences about that. But the one thing I do not argue with him about is he believes deeply in change. And I believe deeply in change. And any time you're fighting for that -- I mean, I didn't hear these kind of attacks from Senator Clinton when she was ahead. Now that she's not, we hear them. And any time you speak out -- any time you speak out for change, this is what happens. MR. GIBSON: With apologies to Governor Richardson, I think (inaudible). SEN. CLINTON: Well, making change, making -- wait a minute. Now, wait a minute. I'm going to respond to this. Because obviously -- obviously making change is not about what you believe. It's not about a speech you make. It is about working hard. There are 7,000 kids in New Hampshire who have health care because I helped to create the Children's Health Insurance Program. There are 2,700 National Guard and Reserve members who have access to health care because, on a bipartisan basis, I pushed legislation through over the objection of the Pentagon, over the threat of a veto from President Bush. SEN. CLINTON: I want to make change, but I've already made change. I will continue to make change. I'm not just running on a promise of change. I'm running on 35 years of change. I'm running on having taken on the drug companies and the health insurance companies, taking on the oil companies. So, you know, I think it is clear that what we need is somebody who can deliver change. And we don't need to be raising the false hopes of our country about what can be delivered. The best way to know what change I will produce is to look at the changes that I've already made. SEN. EDWARDS: Can I respond briefly to that? MR. GIBSON: Let me -- I'll let you respond. Let me -- in all fairness to Governor Richardson. GOV. RICHARDSON: Well, I've been in hostage negotiations that are a lot more civil than this. (LAUGHTER) (APPLAUSE) You know, I think one of the things that we need to remember -- I'm going to say this again because I said it at a previous debate -- let's stay positive. You know, there will be plenty of time to get negative with the Republicans. GOV. RICHARDSON: You heard them earlier. (LAUGHTER) Let us talk about how we're going to make sure that we deliver health care for the American people, how we change America's foreign policy, how we make schools better and pay teachers better and get rid of No Child Left Behind. Look, what we need is change. There's no question. But, you know, whatever happened to experience? Is experience kind of a leper? What is wrong with, you know, what is wrong with having -- what is wrong with having been, like myself, 14 years in the Congress, two Cabinet positions? I mean, I've gone head-to-head with the North Koreans. We got the remains of soldiers back. We persuaded them to reduce their nuclear weapons. What is wrong with being a governor and going to a state and giving health care to kids under 12 and creating jobs and balancing budgets? What is wrong with being a secretary of energy who has made America, or tried to make America a land of clean energy (inaudible)? My point is this: We want to change this country, but you have to have -- you have to know how to do it. GOV. RICHARDSON: And there's nothing wrong with having experience. So, you know, I love change. We all are for change. But the question is, examine the record of those that, in the past, have produced change and that has taken responsibilities. We need somebody that has been tested. MR. GIBSON: I'm going to go to Senator Edwards and then Senator Obama, then we'll move on. SEN. EDWARDS: Thank you very much. What I would say in response to the discussion that just took place is we have to understand what's at stake. Nobody cares about hearing a bunch of politicians fight. They're not the slightest bit interested in that, and they shouldn't be interested in it. What's at stake here is a fight for the future of the middle class. And we do have different perspectives on how we fight for the middle class, how we fight for jobs, how we fight for health care. And I believe, and I believe it very strongly, that there are entrenched special interests very well-financed -- some examples are drug companies, insurance companies, oil companies, et cetera -- that stand between America and the change that we need. SEN. EDWARDS: And I think if you defend the way the system works, it's very hard to take those people on. I believe -- and it's -- I've fought these people. I'm 54 years old. I've been fighting these people, these irresponsible corporations -- and there are good corporations in America, Charlie, and I want to point that out, good corporations, good employers. Costco. AT&T, for example, is now working to help unionize some of their offices and to bring jobs back... (CROSSTALK) MR. GIBSON: We'll get -- we'll get to the commercials later. SEN. EDWARDS: Let me finish this, though. I want to finish this. The point is this: I think there are differences between us about how we fight for the future of the middle class. And I believe you have to be willing to take on these entrenched special interests. And I think if you're not willing to do it, it is impossible to bring about the change that the country needs. MR. GIBSON: Final words, Senator. SEN. OBAMA: And just to wrap up, part of the change that's desperately needed is to enlist the American people in the process of self-government. And one of the areas that I have constantly worked on is not only pushing aside the special interests -- this past year, passing the toughest ethics reform legislation since Watergate -- but also making sure that the government is transparent and accountable. SEN. OBAMA: And that's what I think people were responding to in Iowa. We saw it here in New Hampshire today. They want somebody who's talking straight to them about the choices that are ahead. And they want to make sure that government is responding to them directly, because folks out there feel the American dream is slipping away. They are working harder for less. They are paying more for health care, for college, for gas at the pump. And they are having a tougher time saving and retiring. And what they don't feel is that the government is listening to them and responding to them. That's the kind of change that I think we need. MR. GIBSON: I'm going to move on to our third subject before I run out of time. And I want to turn to Iraq. We started the surge early this year. You all opposed it. But there are real signs it has worked. So from background, our man in Baghdad for ABC, Terry McCarthy. (BEGIN VIDEO CLIP) TERRY MCCARTHY, ABC BAGHDAD CORRESPONDENT: It has been a tough 12 months in Iraq, with more U.S. troops killed than in any previous year of the war. But overall, the addition of an extra 30,000 troops has helped to reduce violence substantially. Civilian killings are down 65 percent in the last six months. U.S. deaths are down from 126 in May to 23 in December. General Petraeus has repeatedly said the solution in Iraq must be political, not military. So far, political progress has been frustratingly slow. But a year ago, many Americans, and the Iraqis, too, thought the country was a lost cause. Today, with improved security, life is returning to the streets of Baghdad. Nobody yet says the war is over. But Iraqis are finally able to hope that things might be getting better. Charlie? (END VIDEO CLIP) MR. GIBSON: So, I want to ask all of you: Are any of you ready to say that the surge has worked? And Senator Clinton, let me start with you, because when General Petraeus was in Washington in September, you said it would take a willful suspension of disbelief to think that the surge could do any good. SEN. CLINTON: And that's right. Because, remember, the purpose behind the surge was to create the space and time for political reconciliation, for the Iraqi government to do what only it can do and trying to deal with the myriad of unresolved problems that confront it. And as your report said, you know, we have the greatest military in the world. We send in more of our troops, they will be able to dampen down the violence. But there has not been a willingness on the part of the Iraqi government to do what the surge was intended to do, to push them to begin to make the tough decisions. And in the absence of that political action, 23 Americans dying in December is totally unacceptable. You know, there is no more cause for us to be there if the Iraqis are just not going to do what they need to do to take care of their own country. SEN. CLINTON: So it's time to bring our troops home and to bring them home as quickly and responsibly as possible. And unfortunately, I don't see any reason why they should remain beyond, you know, today. I think George Bush doesn't intend to bring them home. But certainly I have said when I'm president I will. Within 60 days, I'll start that withdrawal. GOV. RICHARDSON: The policy's a massive failure. Here are the measurements that we should look at. Thirty-nine hundred Americans have lost their lives. There are 60,000 Americans today that are wounded, mainly mentally wounded. Tell that to the family that only 23 died in December. Look, here are the barometers that we need to look at. First, there is no military solution. There's a political solution. Secondly, has there been progress in any political compromises or reconciliation between the Sunni, the Shia and the Kurds? Zero. Has there been progress in sharing oil revenues? Zero. Has there been any regional elections? Zero. Is the Maliki government intensifying its efforts to train the Iraqi security forces more than they have? No. Is there any end to Iran's efforts to bring terrorist activities to Iraq? No. Iran, Syria -- no one has participated in a regional solution. There... (CROSSTALK) GOV. RICHARDSON: No, Charlie, I mean, this is why I'm running for president. Because until we end this war, we cannot talk about the issues that need to be dealt with here: universal health care, improving schools, bringing people together. You can't have change until you end the war, and that means bringing all of our troops home within a year and leaving none behind. MR. GIBSON: I'm going to take this to Senator Obama and to Senator Edwards. But -- and I'm not here to debate -- the parliament meets, an oil law is under consideration, de-Baathification has progressed to some extent, and were it not for the surge, instead of counting votes, we'd be counting bodies in the streets. GOV. RICHARDSON: But this has been going on for years, Charlie. MR. GIBSON: And all of you -- all of you wanted the troops out last year. GOV. RICHARDSON: There is no serious progress. MR. GIBSON: Would you have seen this kind of greater security in Iraq if we had followed your recommendations to pull the troops out last year, Senator Obama? SEN. OBAMA: Let me respond. I think the bar of success has become so low that we've lost perspective on what should be our long-term national interests. It was a mistake to go in from the start, and that's why I opposed this war from the start. It has cost us upwards of $1 trillion. It may get close to $2 trillion. We have lost young men and women on the battlefield, and we have not made ourself safer as a consequence. Now, I had no doubt, and I said at the time when I opposed the surge, that given how wonderfully our troops perform, if we place 30,000 more troops in there, then we would see an improvement in the security situation and we would see a reduction in the violence. But understand, we started in 2006 with intolerable levels of violence and a dysfunctional government. We saw a spike in the violence. The surge reduced that violence, and we now are, two years later, back where we started two years ago. We have gone full circle at enormous cost to the American people. SEN. OBAMA: What we have to do is to begin a phased redeployment to send a clear signal to the Iraqi government that we are not going to be there in perpetuity. Now, it will -- we should be as careful getting out as we were careless getting in. I welcome the genuine reductions of violence that have taken place, although I would point out that much of that violence has been reduced because there was an agreement with tribes in Anbar province, Sunni tribes, who started to see, after the Democrats were elected in 2006, you know what? -- the Americans may be leaving soon. And we are going to be left very vulnerable to the Shias. We should start negotiating now. That's how you change behavior. And that's why I will send a clear signal to the Iraqi government. They will have ample time to get their act together, to actually pass an oil law, which has been -- they've been talking about now for years. They will actually be able to conduct de-Baathification. We will support them in all of those efforts. But what we can't do is to continue to ignore the enormous strains that this has placed on the American taxpayer, as well as the anti-American sentiment that it is fanning, and the neglect that's happening in Afghanistan as a consequence. MR. GIBSON: I'm going to go to Senator Edwards. But all of you serve in Congress or did serve in Congress. You know how slow legislatures can move; you've all experienced it in the United States Congress. But, Senator Edwards, let me go to you. Some of you -- Governor Richardson, Senator Obama -- you have talked about a timetable for withdrawal, getting all troops out by the end of 2009, 2010. If the generals in Iraq came to you as President Edwards and said, Mr. President -- on January 21, 2009 -- you're wrong, you can't do this. You're going to send Iraq back into the kind of chaos we had before, are you going to stick with it? SEN. EDWARDS: It is the responsibility of the president of the United States and the commander in chief to make policy decisions. It is the responsibility -- of course, I would always listen to my uniformed military leadership -- directly. Not filtered through civilians -- directly. But if you look at what happened in Iraq when the Brits began to pull their troops out, in the part of Iraq where those troops were located, there was a significant reduction in violence. What the whole purpose -- just to be clear with people -- the whole purpose for the surge was to create some environment where there could be political progress and political reconciliation between Sunni and Shia. Everyone believes -- even George Bush acknowledges that that's what we're trying to accomplish. The question is, how do you get there? Look at the loss of American lives; $600 billion and counting; and there's been essentially no political progress. I don't believe -- and I think others would agree -- that there will be political progress until we make it clear that we're going to stop propping the Sunni and Shia up with American lives and with American taxpayer dollars. So what we need to do -- and let me be very specific -- and this is what I will do as president: In the first year that I am president, I will pull 40,000 to 50,000 troops out very quickly. I will continue a steady redeployment of combat troops out of Iraq until they are all out within about nine to 10 months. If my military leadership says we need some more time to make sure that we can do this in the most effective way and the most efficient way and the safest way for my troops, of course I'd be listening to what they have to say. But I will end combat missions in Iraq in the first year, and there will be no permanent military bases. We have to end this war, and the only way to end the war is to end the occupation, which is what I will do as president. MR. GIBSON: I've got one minute left, and I owe each of you 30 seconds. GOV. RICHARDSON: Well, John, you can't end the war without -- you've got to get all the troops out to end the war because they become targets. And if you leave a small force behind, then you cannot bring the political reconciliation that is needed; you cannot bring a peacekeeping force by the United Nations or a donor conference to take over the $570 billion that we've spent on this war on resources that should be spent on health care and education for our own people. This is where, with all due respect, we differ. I'd bring the troops back within a year. I don't want, in five years -- because I did, in another debate, some of you said you would keep troops, you wouldn't say you wouldn't get them out by 2013. I don't want, in five years, to have to look at an 8-year old today -- an eighth grader, an American eighth grader today who is serving, five years from now, in Iraq. I don't want to hear about the death of an American. You know, as a governor, I fly the flags half-mast upon a death. I'm sick of doing that. We need to stop that. We need to think of our veterans that are coming back with PTSD, with traumatic brain injuries, with mental anguish. We have a crisis on our hands. And my whole point is that this whole campaign, everything we talk about -- universal health care, improving schools, helping kids -- cannot happen until we get out of this war, because the Congress and the president basically have a dysfunctional relationship where nothing gets done. GOV. RICHARDSON: And I can see that as a governor from my state as I try to deal with health care and education. So this is why it's so fundamental, and this is why I'm running for president. End this war, and the way you do it is by getting all the troops out in one year. MR. GIBSON: I owed you 30 seconds. Now, you owe me 45, but that's... (LAUGHTER) MR. GIBSON: Senator Clinton? SEN. CLINTON: I think we're in vigorous agreement about getting our troops home as quickly and responsibly as we possibly can, serving notice on the Maliki government that the blank check they've had from George Bush is no longer valid. We're going to have to have intensive diplomatic efforts in the region. I don't think anyone can predict what the consequences will be. And I think we have to be ready for whatever they might be. We have to figure out what we're going to do with the 100,000- plus American civilians who are there working at the embassy, working for not-for-profits or American businesses. We have to figure out what we're going to do about all the Iraqis who sided with us, you know, like the translators who helped the Marines in Fallujah whom I met, who said they wouldn't have survived without them. Are we going to leave them? You know, this is a complicated enterprise, so it has to be done right. And last spring, I began demanding that the Bush administration tell us whether they were undertaking the kind of planning that is necessary for the withdrawal. And, clearly, they're not. So as soon as I am elected, I will task the Joint Chiefs and the secretary of defense and the security advisers to provide such a plan and to begin to execute it within 60 days. MR. GIBSON: All right. Let me thank all of you. We're going to take a commercial break, three minutes. I'm going to bring Scott Spradling from WMUR up here, and we'll continue with some questions. The Democratic debate from Manchester, New Hampshire, continues. (COMMERCIAL BREAK) I am joined, for the last half of this debate, as I was for the Republican debate, by the political director here in Manchester, New Hampshire, Scott Spradling. And I appreciate all of you, again, being with us. It's good to have the four leading Democratic candidates with us. Just to reintroduce them, Senator John Edwards -- former Senator John Edwards, Senator Barack Obama, Governor Bill Richardson, Senator Hillary Clinton. Scott? MR. SPRADLING: Senator, I'd like to start with you. I was watching the exchange in the first half and saw what looked like a little bit of a double team that's probably going to have a lot of people talking tomorrow morning. (LAUGHTER) SEN. CLINTON: I'm glad you noticed. MR. SPRADLING: Yes, I did notice. (LAUGHTER) And I'd like to ask you this. The University of New Hampshire Survey Center has been consistently trying to probe the minds of New Hampshire voters and get a sense of what they think about all of you. I'd be happy to report that the experience vs. change debate seems to be sinking it. And what I'd like to get is to this: New Hampshire voters seem to believe that, of those of you on this stage, you are the most experienced and the most electable. In terms of change, they see Senators Obama and Edwards as the agents of change, in New Hampshire mindset. My question to you is simply this: What can you say to the voters of New Hampshire on this stage tonight who see a resume and like it, but are hesitating on the likability issue, where they seem to like Barack Obama more? SEN. CLINTON: Well, that hurts my feelings. (LAUGHTER) MR. SPRADLING: I'm sorry, Senator. I'm sorry. (APPLAUSE) SEN. CLINTON: But I'll try to go on. (LAUGHTER) He's very likable. I agree with that. I don't think I'm that bad. SEN. OBAMA: You're likable enough, Hillary. SEN. CLINTON: Thank you... (LAUGHTER) You know, I think this is one of the most serious decisions that the voters of New Hampshire have ever had to make. And I really believe that the most important question is who is ready to be president on day one. You know, the problems waiting, some of which we have talked about already, are huge and the stakes could not be higher. And, you know, in 2000 we, unfortunately, ended up with a president who people said they wanted to have a beer with; who said he wanted to be a uniter, not a divider; who said that he had his intuition and he was going to, you know, really come into the White House and transform the country. And, you know, at least I think there are the majority of Americans who think that was not the right choice. So I am offering 35 years of experience making change, and the results to show for it. I, you know, respect and like both Senator Edwards and Senator Obama. SEN. CLINTON: But I think if you want to know what change each of us will bring about, look at what we've done. And there are a lot of differences that I think need to be aired for the voters of New Hampshire. Because I stand on my record of experience, and I appreciate Governor Richardson's long history of serving our country. But I think I am an agent of change. I embody change. I think having the first woman president is a huge change... (APPLAUSE) ... with consequences across our country and the world. And that on the specific issues that I have worked on for a lifetime and the plans I have put forth, I believe I am more prepared and ready to actually deliver change. SEN. CLINTON: And I think that ultimately is what Americans want to know and believe. MR. SPRADLING: Senator, thank you. Senator Obama, I don't know if your ears were ringing during the first debate. I asked a question about you earlier, and am interested to hear your response to what the Republican candidates for president laid out in arguments for you not being elected president. I revved up the Republican attack machine. Please respond. SEN. OBAMA: Well, you know, I have to admit that I was going back and forth between the Republicans and football. (LAUGHTER) MR. GIBSON: How did the Redskins do? SEN. OBAMA: The Redskins lost. (LAUGHTER) But, look, I think there's no doubt that any of the candidates on this stage would represent significant change from George Bush. And we've seen a disaster, in both foreign policy and domestic policy, over the last seven years. But what the people in Iowa were responding to, what I think that we're seeing here in New Hampshire, is a hunger for a different kind of politics that is very specific about pushing aside special interests that have come to dominate the agenda and the debate, reducing the power of lobbyists; something that I have done. I think people are very concerned about making sure that the American people are let back into their government. So when I, for example, worked with a Republican to set up a searchable database, so that every dollar of federal spending -- we would know. If there was a bridge to nowhere, you'd know who was sponsoring it, and hopefully embarrassing them. If there was a no-bid contract to Halliburton, you'd know about that. Those are the kinds of steps that will actually lead to real changes in people's lives. And that's how I worked at the state level, bringing Republicans and Democrats together to provide health insurance to people who didn't have it. That's how we were able to provide tax cuts to working families. And that is what I intend to do as president of the United States of America. MR. SPRADLING: Senator Thompson referred to your support as endorsements by some of the most liberal groups in the nation, trying to paint a picture that you would be way left of center. SEN. OBAMA: Of course. But Scott, that's what they're going to do to any Democrat. I mean, we've seen this movie before. We know the Republican playbook. Here's what I'm betting on, though, is that regardless of what the Republican candidates are talking about, I think that there are a whole host of Republicans, and certainly independents, who have lost trust in their government, who don't believe anybody is listening to them, who are staggering under rising costs of health care, college education, don't believe what politicians say. And we can draw those independents and some Republicans into a working coalition, a working majority for change. SEN. OBAMA: And the fact of the matter is I think that Senator Clinton has done some good work. I think Bill Richardson has done some good work, as has John Edwards. But what we haven't seen over the last many years, even preceding George Bush, is tackling the big issues -- getting health care reform finally done, getting an energy policy that works. And that's going to require a working majority for change. We're starting to build that. We saw it in Iowa. We're going to build it here in New Hampshire. And I think we can build it across the country. MR. SPRADLING: Governor Richardson, I'm curious: Do you think to be president of the United States that prior executive experience is necessary? And is relative youth a detriment? GOV. RICHARDSON: Well, I think prior executive experience is very important. I'm the only governor here. I'm the only person here who has actually balanced budgets. I've balanced five. I've created 80,000 new jobs. I've lowered taxes for everybody. I've insured kids under 12 in my state. I've improved education. You know, you want somebody in this position that has had executive experience. And I will also say, Charlie, since, you know, I noticed Scott mentioned everybody else in the poll, he didn't mention me... (LAUGHTER) But that's OK. MR. GIBSON: Did that hurt your feelings, too? GOV. RICHARDSON: Well, a little bit. (LAUGHTER) MR. SPRADLING: Would you like to know? GOV. RICHARDSON: You know, let's face it -- the next president is going to have to have foreign policy experience. And of all the candidates here, I'm the only one that's negotiated with foreign governments, I'm the only one that has faced down the North Koreans and Saddam Hussein, I'm the only one that has had the highest national security clearance. You know, so there's something about having experience and been tested and represented... (CROSSTALK) MR. SPRADLING: Can I follow up on that, then... GOV. RICHARDSON: Sure. MR. SPRADLING: ... with your resume. I don't mean to interrupt, but I remember you as energy secretary coming to Boston for an energy summit way back in February of 2000, when the dialogue then was very similar to the dialogue that it is now: rising fuel prices, a struggling supply, frustration in the homes across New England and a call for some help. MR. SPRADLING: Here we are this past Thursday -- we've established it -- that it's $100 a barrel. Is it fair to say to you, in this experience argument, that you, as energy secretary, you didn't get it done then, so why believe you'd get it done now because we're having the same debate? GOV. RICHARDSON: Look, both parties have been failures in dealing with energy policy, but you know -- and I remember meeting you there. Remember what I did, Scott. I went to OPEC countries and tried to get them to increase production so prices would go down. At the time, there was a home heating oil crisis here in New England. I created reserves of home heating oil. Look at the price now in New Hampshire, $3.20, something like that. It's the highest ever. You know, what we need is an energy revolution in this country, not some of the bills that the Congress has passed. GOV. RICHARDSON: We need to go to 50 miles per gallon fuel efficiency. We need to have 30 percent of all our electricity renewable. We need to reduce greenhouse gas emissions by 80 percent by the year 2040. And we need the American people to sacrifice a little bit. I would ask the American people, when it comes to being more energy- conscious, to be cognizant of appliances, of fuel efficiency, the vehicles we drive, mass transit. You know, I -- and I did when I was energy secretary, air conditioners 30 percent more efficient. I started the renewable portfolio. So, I did some things, Scott. The problem -- you're right. We need a bipartisan approach. But we need to reduce fossil fuels by 50 percent by the year 2020, because our planet is getting damaged. And Al Gore has been right. GOV. RICHARDSON: He deserves the Nobel Prize. I'm glad he stayed out of the race. (LAUGHTER) MR. GIBSON: I'm going to go to Senator Edwards for just a moment. You answered the first part of my question about executive training. You didn't talk about whether relative youth is a detriment. GOV. RICHARDSON: I didn't hear that. MR. GIBSON: When I asked you the question, I said, is prior executive experience a key requirement for being president and is relative youth a detriment? GOV. RICHARDSON: Relative youth? No. You know, John F. Kennedy was 42 years old when he was elected president. He's my hero, and I think he was one of our greatest presidents because -- because he inspired, because he said he'd go to the moon in 10 years, because he said that we all collectively have to do something for the common good. MR. GIBSON: Senator Edwards? SEN. EDWARDS: What's my question? (LAUGHTER) No, I'm glad that people like me, Hillary. I'm glad they like... (CROSSTALK) MR. GIBSON: The prior executive experience. And is relative youth a detriment? SEN. EDWARDS: No, I think what matters -- we've had a lot of conversation about the first day in the White House. I think we ought to picture what that first day in the White House would be for each of us. I'll just speak for myself. You know, I'm the candidate up here who's never taken a dime from a Washington lobbyist in my entire time in public life or a dime from a special interest PAC. The first day that I'm president of the United States, there will be no corporate lobbyists working in my White House. There will be no lobbyist who's lobbied for foreign governments. And this is a very personal cause for me, because I come from a family -- my father is in the audience tonight -- where my father worked for 37 years in the mills. He didn't get a chance, like I did, to have a college education. And this is a fight for the middle class and families just like the one I grew up with. My grandmother, who helped raise me, had a fifth or sixth grade education, came from a family of share-croppers, she worked in the mill every day so that I could have the chances that I've had. And this -- I spent 20 years fighting irresponsible corporations in courtrooms. SEN. EDWARDS: I know what it takes to fight these people and win. But here's what I would want people to know. What I want people to know is, this battle is deep inside me and it is personal. And it matters whether it's personal or not, because is if it's either academic or political, when the tough fight comes, you'll walk away from it. You'll do what's political. This fight is deeply personal to me. I've been engaged in it my whole life, to fight for the middle class, to fight against powerful special interests. And it is a fight I will wage on behalf of the American people as president of the United States and win, as I have for 54 years. MR. SPRADLING: Senator, I'd like to follow that up then. SEN. EDWARDS: Sure. MR. SPRADLING: You served six years in the U.S. Senate. SEN. EDWARDS: Yes. MR. SPRADLING: And on the campaign trail, it seems like you don't talk a lot about the six years. The people of New Hampshire probably remember you talking about your war vote and explaining later on why you weren't happy about that. SEN. EDWARDS: Yes. MR. SPRADLING: Can you give New Hampshire voters a guide of something significant that you accomplished in your six years as a U.S. senator... SEN. EDWARDS: Absolutely. MR. SPRADLING: ... that would give us some guide as to what kind of president you're going to be? SEN. EDWARDS: Absolutely. I could tell you exactly one -- I'll give you one very specific example, a big example. When the Democrats finally took over the United States Senate, the first issue that was brought to the table was the so-called patient's bill of rights, so that patients and families could make their own health care decisions. SEN. EDWARDS: What's happening now is insurance companies are running all over people. I mean, the case of Nataline Sarkisyan, which a lot of the audience will be familiar with -- 17-year-old girl who lost her life a couple of weeks ago because her insurance company would not pay for a liver transplant operation. She had health insurance, but the insurance company wouldn't pay for it. They finally caved in a few hours before she died. We need a president who will take these people on. What we did -- and I didn't do it alone, don't claim to have done it alone -- but I, Senator McCain, who was here earlier, Senator Kennedy, the three of us wrote the Patient's Bill of Rights. The three of us took on the powerful insurance industry and their lobby, every single day of the fight for the Patient's Bill of Rights. And we got that bill through the United States Senate and got it passed. And I'm proud of having done that. But that's just an example of why this battle is personal for me. You know, we need a president who believes deeply -- in here -- believes deeply in this battle. And it is personal for me. When I see these lobbyists roaming around Washington, D.C., taking all the politicians to cocktail parties, I mean, the picture I get in my head is my father and my grandmother going in that mill every day so that I could have the chances I've had. Where is their voice in this democracy? When are they going to get heard? They need a president who will stand up for them, and so does every American who's listening to this debate. SEN. OBAMA: I just want to add, I agree with John, which is why I prohibited lobbyists from buying meals for members of Congress... SEN. EDWARDS: Good idea. SEN. OBAMA: ... because -- and some of them complained. They said... (CROSSTALK) SEN. OBAMA: They said, Where am I going to eat? MR. GIBSON: They can now buy food for members of Congress if the members of Congress are standing up. That's my understanding of what the rules have changed. You can't sit down and eat, but you can stand up and eat. Tell me why that's change. SEN. OBAMA: Here's what we did. They can't buy meals. They can't provide gifts. They can no longer lend corporate... MR. GIBSON: They can have huge parties for you as long as you're standing up. SEN. EDWARDS: They can't eat as much if they're standing up, Charlie. SEN. OBAMA: That's true. Look, we are now disclosing if they're bundling money for members of Congress. They've got to disclose who they're bundling money from and who they're giving it to. But here's the critical point that I want to make. Not only does this have to be personal, John -- and I completely agree. When I think about health care, I think about my mother, who when she was dying of cancer had to read an insurance form because she had just gotten a new job and they were trying to figure out whether or not this was going to be treated as a preexisting condition, and whether or not they would pay her medical bills. So I've seen the costs of a health care system that is broken in very personal terms. But what I also believe, if we're going to bring about real change, then we have to bring in the American people. We have to bet on them. SEN. OBAMA: And that's what's been lost. People, I think, feel that they are not heard at all, they are not involved. And the only way we're going to muster enough power over the long term to actually get something done is if we've got a working majority, which is why it's so important... (CROSSTALK) SEN. CLINTON: Can we just have a sort of a reality break for a minute? Because I think that it is important to make some kind of an assessment of these statements. You know, Senator Edwards did work and get the patient bill of rights through the Senate -- it never got through the House. One of the reasons that Natalie may well have died is because there isn't a patient's bill of rights. We don't have a patient's bill of rights. SEN. EDWARDS: Because George Bush killed it. SEN. CLINTON: Well, that's right. He killed it. So, we've got to have a plan and a real push to get it through. You know, when it comes to lobbyists, you know, Senator Obama's chair in New Hampshire is a lobbyist. He lobbies for the drug companies. So, I think it's important that all of us be held to the same standard -- that we're all held accountable. You know, the energy bill that passed in 2005 was larded with all kinds of special interest breaks, giveaways to the oil companies. Senator Obama voted for it. I did not because I knew that it was going to be an absolute nightmare. Now we're all out on the campaign trail talking about taking the tax subsidies away from the oil companies, some of which were in that 2005 energy bill. So, you know, words are not actions. And as beautifully presented and passionately felt as they are, they are not action. You know, what we've got to do is translate talk into action and feeling into reality. I have a long record of doing that, of taking on the very interests that you have just rightly excoriated because of the over-due influence that they have in our government. And, you know, probably nobody up here has been the subject of more incoming fire from the Republicans and the special interests. So I think I know exactly what I'm walking into. And I am prepared to take them on. (CROSSTALK) MR. SPRADLING: Senator, does that mean that you're further down the road than your opponents in this? Or are you saying that you can do things that these folks can't do, when it comes to being an agent of change? SEN. CLINTON: Absolutely. Because I've been an agent of change. You know, you go back 35 years, you know, I worked to help make the case for the law that, thankfully, required that public schools give an education to children with special needs. I worked to reform education and health care in Arkansas against, you know, some pretty tough odds. In the White House, I helped to create, you know, health care for kids and, you know, reform a lot of the other programs -- like taking on the drug companies. MR. SPRADLING: And to be clear, they can't. You're saying they can't. SEN. CLINTON: Well, I'm not saying that -- I'm only making my case, that this is what I have done. (CROSSTALK) MR. GIBSON: I'll come to all of you. I didn't want to get into this, but I've covered Washington for a long time. And I know President Clinton came to Washington talking about change. President Bush came to Washington talking about change. So many people in the administrations and in Congress say Washington is set up to resist change... SEN. EDWARDS: Absolutely. MR. GIBSON: And God love all of you for making this argument. (CROSSTALK) (LAUGHTER) (CROSSTALK) SEN. CLINTON: Can I just say, if you're going to mention President Clinton, I'm going to respond? SEN. EDWARDS: Let Hillary talk. Let her talk. SEN. CLINTON: President Clinton -- wait, President Clinton inherited a deficit, a debt that had been quadrupled in the previous 12 years. Now, anybody who doesn't think taking on the special interests to raise taxes on corporations, raise taxes on the wealthy, begin to whittle away at the deficit, to be able to leave with a balanced budget and a surplus -- if that didn't take a lot of change that actually produced results, then I think we've got amnesia. SEN. CLINTON: You know, change is hard, but change is possible... (APPLAUSE) SEN. EDWARDS: OK, can we speak to this? Can we speak to this? SEN. CLINTON: ... if you're prepared to work hard and follow through. SEN. EDWARDS: I want to say -- I just want to say a quick word about this. You know, it is true that these entrenched interests -- whether you're talking about oil companies, drug companies, gas companies, whoever, these entrenched interests are literally stealing our children's future. They have a stranglehold on this democracy. And they are having an incredibly destructive force on the middle class, on families being able to do what my family has done, and so many who are sitting here have been able to do. And the problem is you can't be with those people, take their money and then challenge them. It doesn't work. You have to be willing to actually stand up and say no, no to lobbyists' money, no to PAC money, no corporate lobbyists working for me in the White House. SEN. EDWARDS: If you intend to take them on, and if it is personal for you -- and this is extraordinarily personal for me -- if it's personal for you, then you can be successful bringing about the change. Teddy Roosevelt -- just one quick example -- Teddy Roosevelt -- Teddy Roosevelt, a great American president: He didn't make deals with the monopolies and the trusts. Teddy Roosevelt took them on, busted the monopolies, busted the trusts. That's what it's going to take. We have a battle in front of us. We do. I don't think we have a problem with politicians in Washington spending enough time with lobbyists and going to cocktail parties. They do it all the time. They do it every single day. And I'll tell you who's paying the price for those cocktail parties: Ed and Nataline Sarkisyan, every single American who doesn't have health care coverage, everybody who's going to the gas pump and paying so much for their gas. When are we going to have a president who actually takes these people on? That's what I'm going to do. (CROSSTALK) MR. GIBSON: I'm going to go Senator Obama, and I'll come to you. SEN. OBAMA: Look, I think it's easy to be cynical and just say, You know what? It can't be done, because Washington is designed to resist change. But in fact, there have been periods of time in our history where a president inspired the American people to do better. SEN. OBAMA: And I think we're in one of those moments right now. I think the American people are hungry for something different and can be mobilized around big changes; not incremental changes, not small changes. I actually give Bill Clinton enormous credit for having balanced those budgets during those years. It did take political courage for him to do that. But we never built the majority and coalesced the American people around being able to get the other stuff done. And, you know, so, the truth is, actually, words do inspire, words do help people get involved, words do help members of Congress get into power so that they can be part of a coalition to deliver health-care reform, to deliver a bold energy policy. Don't discount that power. SEN. OBAMA: Because when the American people are determined that something is going to happen, then it happens. And if they are disaffected and cynical and fearful and told that it can't be done, then it doesn't. I'm running for president because I want to tell them, Yes, we can, and that's why I think they're responding in such large numbers. GOV. RICHARDSON: You know, this is the kind of Washington bickering that the public turns off to. And, you know, with all due respect, as a governor, I'm frustrated every time you guys and the president get nothing done because then the burden is on us. And, you know, John, I understand your frustration. I understand, you know, that it's personal. But, you know, to resolve problems, you got to bring people together. You got to heal this country. You can't -- you know, it's great to say, We're going to take everybody on. But, you know, it's going to take coalitions of people backing us. It's going to take public financing to get the special interests out of politics. It's going to take bipartisanship. You know, what I've said is that if I'm elected president, I'm going to have a Cabinet of Republicans, Democrats and independents. Now, I won't overdo the Republicans. (LAUGHTER) GOV. RICHARDSON: But my point is, it's how you govern. It's coalition-building. It's bringing the public -- a citizens corps of activists. It's asking the public to sacrifice, to do something for the country like being more energy efficient, like national service. You know, I've got a program, two years the government pays for your college loans, your tuition, you give one year of national service to the country. It's emboldering (ph) the electorate. You can't do it by just fighting and taking everybody on. You got to bring people together. And that's a frustration. SEN. EDWARDS: Give me 30 seconds on this, because you just said something... MR. GIBSON: I'll hold you to it. (CROSSTALK) SEN. EDWARDS: I actually completely agree that it's the responsibility of the president to unite and galvanize the American people. It is also the responsibility of the president, and I will do it, to work with members of Congress to get things done. But these entrenched monied interests that have a stranglehold on the middle class, that are doing incredibly destructive to American jobs and the health care system, energy, all taxes, trade, they're in everything -- absolutely everything, you cannot nice these people to death. It doesn't work. I have been in the trenches fighting them for my whole adult life. And it takes strength, backbone, fight and you have to take them on. Yes, Barack, I agree with you completely that the best -- we need to unite America and we need to galvanize the American people. And, Bill, I completely agree with what you just said. This is not a fight with politicians. And this is certainly not a fight with the American people. It is a fight for the American people against those people who are stopping the change. MR. GIBSON: All right. Let me turn to something else. Reversing -- you invoked the name of Al Gore a few moments ago -- reversing or slowing global warming is going to take sacrifice. MR. GIBSON: I'm sort of sorry Chris Dodd isn't here because he's talked a lot about a carbon tax in this election. Al Gore favors a carbon tax. None of you have favored a carbon tax. Is it a bad idea, or is it just so politically unpalatable that you guys don't want to propose it? GOV. RICHARDSON: Can I answer? You know, I was energy secretary. It's a bad idea. Because, when you have a carbon tax, first of all, it's not a mandate. What you want is a mandate on polluters, on coal companies, on those that pollute, to reduce greenhouse gas emissions by a certain target. Under my plan: 30 percent by the year 2020; 80 percent by the year 2040. It takes international leadership. The better way to do it is through a cap-and-trade system which is a mandate. Furthermore, a carbon tax, that's passed on to consumers, that's passed on to the average person, that's money you take out of the economy. So it's a bad idea. Cap-and-trade is a mandate, but it's also going to take presidential leadership. It's going to take all of us here, every American, you know, to think more efficiently about how we transport ourself, what vehicles we purchase, appliances in our homes. It's going to take a transportation policy that doesn't just build more highways. We have to have commuter rail, light rail, open spaces. We've got to have land-use policies where we improve people's quality of life. MR. GIBSON: Senator Obama? SEN. OBAMA: Well, I agree with Bill that I think a cap-and-trade system makes more sense. That's why I proposed it: because you can be very specific in terms of how we're going to reduce the greenhouse gases by a particular level. Now, what you have to do is you have to combine it with a 100 percent auction. In other words, every little bit of pollution that is sent up into the atmosphere, that polluter is getting charged for it. SEN. OBAMA: Not only does that ensure that they don't game the system, but you're also generating billions of dollars that can be invested in solar and wind and biodiesel. I do disagree with one thing, though, that Bill said, and that is that on a carbon tax, the cost will be passed on to consumers, and that won't happen with a cap-and-trade. Under a cap-and-trade, there will be a cost. Plants are going to have to retrofit their equipment. And that's going to cost money, and they will pass it onto consumers. We have an obligation to use some of the money that we generate to shield low-income and fixed-income individuals from higher electricity prices. But we're also going to have to ask the American people to change how they use energy. Everybody is going to have to change their light bulbs. Everybody is going to have to insulate their homes. And that will be a sacrifice. But it's a sacrifice that we can meet. Over the long term, it will generate jobs and businesses, and can drive our economy for many decades. SEN. CLINTON: Charlie, let me make a connection here that I think is really important. I think the economy is slipping toward a recession -- the unemployment figures on Friday hitting 5 percent, the $100 a barrel oil that we also hit this week, the fall of the dollar. There's a lot of pressures on middle-class families, and the kind of costs that they have to keep up with have all gone up astronomically. I mean, you know, the energy costs for the typical family in New Hampshire since George Bush has been president have tripled. And that's far beyond what the costs of the tax cut that they got from George Bush. So, what we've got to do is use energy as an opportunity to actually jump-start economic recovery. We need to quickly move toward energy efficiency. We should require the utilities to begin to work for energy efficiency and conservation, costs that will be shared and decrease the pressure on families. We need a weatherization and low-income heating emergency program that is out there now helping families in New Hampshire and elsewhere to cover their costs. And we need to look at how doing what is right about energy is not only good for our security and good for the fight against global warming, but it will be essential in dealing with the economic challenges that we face. MR. GIBSON: Senator Edwards, I will take this question to you. But you raised the issue of the economy right now. And we have a housing crisis in this country. SEN. CLINTON: Yes, we do. MR. GIBSON: We have an energy problem -- in the cost of energy. And we now have a jobs problem. We have, when we are -- and you raised R word, recession -- when we are approaching recession, it is consumers who have spent us out of recession in most cases. You're all talking about letting some of the Bush tax cuts lapse. And yet... SEN. CLINTON: Yes, but, Charlie, the tax cuts on the wealthiest of Americans; not the middle-class tax cuts. One of the problems with George Bush's tax policy has been the way he has tilted it for the wealthy and the well-connected. MR. GIBSON: If you take a family of two professors, here at Saint Anselm, they're going to be in the $200,000 category that you're talking about lifting the taxes on. (LAUGHTER) MR. GIBSON: And... (CROSSTALK) (LAUGHTER) SEN. CLINTON: That may be NYU, Charlie. I don't think it's St. Anselm. MR. GIBSON: Two public school teachers in New York? (LAUGHTER) But that is -- you're in a situation where you're taking money out of the economy, is what I'm saying. SEN. CLINTON: Look, if we set the cap where I'm saying, at $250,000 and above, that's a very small percentage. And what I want to do is fix the alternative minimum tax, create these new job opportunities primarily through clean renewable energy, but also get back to where middle class families get the kind of tax relief that they deserve, which they really haven't been getting under George Bush. (CROSSTALK) MR. GIBSON: Go ahead. SEN. EDWARDS: Thank you. What you see happening in America today, if you're president of the United States and as you are looking at this from altitude, is you see a very few Americans getting wealthier and wealthier; you see the biggest corporations in America's profits through the roof. ExxonMobil just made $40 billion -- record profits. All of that happening at the same time that we have 47 million people with no health care; 37 million who will wake up in this country tomorrow worried about feeding and clothing their children. Tonight, 200,000 men and women who wore the uniform of the United States of America and served this country honorably will go to sleep under bridges and on grates. SEN. EDWARDS: It's time for us to say -- and it's time for the president to say -- enough is enough. This is a battle for the future of our children. This is a battle for the middle class. Let's take jobs, which we haven't talked about. We've touched on a lot of other things; we haven't talked about jobs. We've had a trade and tax policy that is bleeding American jobs. And all it has done is pad the profits of the biggest multinational corporations in America. You talk about professors here, at this college. Let me say a word... MR. GIBSON: Well, I shouldn't have done that, apparently. SEN. EDWARDS: Yes, it was a mistake. (LAUGHTER) But we are -- I saw a projection, just a week or so ago, suggesting that America could lose as many as 20 million to 30 million more jobs over the next decade. Think about that for a minute: 30 million. And who's the most at-risk group? SEN. EDWARDS: College graduates. This is not just people who are working in mills and working in factories who have been devastated by this -- completely devastated. These are middle class families. These are college graduates and their jobs at risk. We need a different tax policy, a different trade policy where the first question is -- and this is what I will ask when I am president of the United States -- is this trade proposal, is this tax proposal, is it good for working, middle class Americans? That's the question. MR. GIBSON: Senator Obama? SEN. OBAMA: There is no doubt that the economy has been out of balance. It's been out of balance throughout George Bush's tenure. And some of the trends from globalization preceded George Bush. That's why I have proposed specific tax relief now, immediately, so that we would offset some of the payroll tax, that we would immediately put some additional dollars in the pockets of American families, working families typically making $75,000 a year or less, to not only stimulate the economy, but also to balance out a tax code. And I would pay for it very specifically, by closing tax loopholes and tax havens. You've got a building in the Cayman Islands that supposedly houses 12,000 corporations. That's either the biggest building or the biggest tax scam on record. But the larger point is that we have to get back to a notion that opportunity and bottom-up economic growth is what the president should be fighting for. And what we've had is a top-down agenda that is skewed toward the wealthiest Americans. It is making worse some of the trends of globalization that are already out there. And one of the benefits of this campaign has been to listen and talk to the folks all throughout New Hampshire who are tired of it and want to see something change. MR. SPRADLING: Just very quickly, just for the governor -- I know we're running out of time. And I'd like to get this to you. You're going to say what you're going to say on this topic. But just, could you please address, as a governor, the small-business owners, in this tax talk, who may fit the category that we're talking about, but who are also providing the payrolls, proving the health insurance and are worried that if they lose out on this, that they could, too, be hurt? MR. SPRADLING: That's 75 percent of New Hampshire's economy we're talking about. GOV. RICHARDSON: Well, also, like Governor Lynch here, I'm the only one that's actually run a state economy. I'm the only one that's balanced budgets and created jobs. So, here's my response. You asked about how we improve the economy. One, you got to balance the budget. I mean, this is $9 trillion debt to China, to commercial banks. We got to have line-item veto authority for the president. We've got to get rid of $73 billion in corporate welfare. The second thing we need to do is, what ever happened to the Democratic Party? We used to be the party of jobs and economic growth. We should be investing in science and innovation and in green energy. Tax incentives -- if a company pays over prevailing wage, give them a tax incentive. GOV. RICHARDSON: And, lastly, we have not talked about education in this whole debate. We've got to improve our schools. We've got to pay our teachers better. Invest in science and math. Get rid of No Child Left Behind. We've got to have arts in the schools. We have to be an America that recognizes we're 29th in the world in science and math, and countries like China and India are graduating many more times engineers than we are. That's competitiveness. MR. GIBSON: We have just a couple of minutes left. And it's been a very interesting evening, I would say. And I've been fascinated. I hope people who have watched have been, as well. There have been an awful lot of debates. I think is debate 681. You guys may have counted. I've lost. SEN. EDWARDS: At least. MR. GIBSON: Tell me one thing you've said in those debates that you wish you hadn't said. And it's your chance to take... (LAUGHTER) MR. GIBSON: ... and it's your chance to take it back. SEN. CLINTON: Oh, you're going to start with me? (LAUGHTER) MR. GIBSON: Sure. SEN. CLINTON: Well, you know, we've had -- I don't exactly know how many -- 13, 14. And I've lost count. SEN. CLINTON: You know, I feel like they've been good exchanges among us. You know, there have been one or two moments that I would have taken back. But what's really most important about these debates is that the Democratic Party stands in such contrast to the Republicans. You know, the Republicans have a totally different approach to what we need to be doing. They're not talking about the mortgage crisis and trying to solve it. They're not talking about what I fear to be a slide into recession. They're not talking about global warming. They're not talking about science and innovation. They're not talking about what really is going to face the next president. So, I think that we've done in our debates a much better job in actually getting out the issues that are going to be on the desk in the Oval Office when the president walks in. And, beyond that, I will leave it to the pundits to decide what I might or might not have said at any one of the debates. MR. GIBSON: I will let you off on specificity of take-backs... SEN. CLINTON: Thank you. MR. GIBSON: ... since we're running out of time. Governor Richardson? GOV. RICHARDSON: Well, I made a lot of them. One that I particularly remember -- I think it was here in New Hampshire, the first debate. I was asked who my favorite Supreme Court justice was. And I said, dead or alive? (LAUGHTER) I said -- I should've stuck to the alive, because I then said Whizzer White because I idolized John F. Kennedy, and I figured if he appointed Whizzer White, this was a great Supreme Court justice. Well, then I find out that Whizzer White was against Roe v. Wade, against civil rights. You know, so that's -- that wasn't -- that wasn't a good one. (LAUGHTER) (APPLAUSE) MR. GIBSON: Senator Edwards, I'll go to you, just with the passing comment that you haven't talked about Mrs. Clinton's attire recently. SEN. EDWARDS: I was about to say... (CROSSTALK) SEN. EDWARDS: I already figured this out... OBAMA (?): That was a good (inaudible). (LAUGHTER) SEN. EDWARDS: If you're going to pick the one for me, it was when I made the horrendous mistake of teasing Hillary about her jacket. (LAUGHTER) And I want her to know, I think you look terrific tonight. (LAUGHTER) (APPLAUSE) MR. GIBSON: And Senator Obama? SEN. OBAMA: Well, I -- you know, there have been all kinds of aspects to my debate performance that I'd love to correct or sharpen. But, overall, actually, here's an area where I agree with Hillary: that there has been a stark contrast, generally, between the four of us and those who aren't debating with us now but were previously. There is going to be a fundamental difference between the Republican nominee and the Democratic nominee: ending the politics of fear that has so dominated our political debate, making certain that we're actually listening to the American people and the struggles and hardships that they're going through. SEN. OBAMA: And I think the opportunity to bring the American people together and to push back those special interests, to actually deliver on meaningful differences in their lives, that's something -- that's a prospect that I think all Democrats should be excited about. MR. GIBSON: I want to thank all four of you for being here. And I want to thank the six Republicans who preceded you. (APPLAUSE) No matter who people across the country are supporting, whether it's in this party or the other, we wish all of you well and we thank you for being here. All the best.
