# Democratic Candidates Debate in Austin, Texas

**Date:** February 21, 2008
**Source:** https://www.presidency.ucsb.edu/documents/democratic-presidential-candidates-debate-the-university-texas-austin

---

PARTICIPANTS: Senator Hillary Clinton (NY); and Senator Barack Obama (IL) MODERATORS: Campbell Brown (CNN); Jorge Ramos (Univision); and John King (CNN) MS. BROWN: And we have given the candidates the opportunity to make opening statements. The order was determined by a draw. Senator Obama won the draw and elected to go second, so please go ahead, Senator Clinton. SEN. CLINTON: Well, thank you. And I am just delighted to be back here in Austin. You know, nearly 36 years ago I came to Austin for my very first political job, and that was registering voters in south Texas. And I had the great privilege of living for a while in Austin and in San Antonio, and meeting people and making friends that have stayed with me for a lifetime. And I found that we had a lot in common, a lot of shared values -- a belief that hard work is important, that self-reliance and individual responsibility count for a lot. And among the people whom I got to know who became not only friends, but heroes, were Barbara Jordan, who taught me a lot about courage. And today -- (applause) -- today would actually be her birthday. And I remember all the time about how she got up every single morning facing almost insurmountable odds to do what she did. And another was my great friend Ann Richards, who taught me so much -- (cheers, applause) -- about determination. You know, Ann was a great champion for the people of Texas. She also reminded us that every so often, it's good to have a laugh about what it is we're engaged in. And as I think back on those years, and the work that I've done ever since, you know, for me, politics is about making real differences in people's lives. And I'm very, very proud that over these years, I have been able to make a difference in the lives of people in Texas, Ohio and elsewhere. You know, 350,000 children in Texas get health care every month, because I helped to start the Children's Health Insurance Program. (Applause.) And 21,000 National Guard and Reserve members get access to health care, because I went across the party line and joined up with a Republican senator to make that happen. So there's a lot that we've already done, but there's so much more to do. I want to take on the tough issues that face us now. I want to stop the health insurance companies from discriminating against people because they're sick. You know, it's unconstitutional to discriminate on the basis of race or gender or ethnic origin or religion, but it's okay to discriminate against sick people. And we're going to end that, because it's time we said, "No more." (Applause.) And I want to continue the work that I've done in the Senate to take care of our veterans. It was shocking and shameful what happened, that we discovered about a year ago at Walter Reed. We can do so much better to take care of the people who have taken care of us. And there is a lot of work ahead. I offer a lifetime of experience and proven results. And I know that if we work together, we can take on the special interests, transfer $55 billion of all those giveaways and subsidies that President Bush has given them back to the middle class to create jobs and provide health care and make college affordable -- (applause) -- and I ask you -- I ask you to join in my campaign. It's now up to the people of Texas, Ohio and the other states ahead. So if you'll be part of this campaign, which is really your campaign about your futures, your families, your jobs and your health care, we'll continue to make a difference for America. Thank you all very much. (Cheers, applause.) MS. BROWN: Senator Clinton, thank you. Senator Obama. SEN. OBAMA: Well, first of all, thank you so much to the University of Texas for hosting us, and it's a great honor to share the stage once again with Senator Clinton. I've said before that we've been friends before this campaign started; we will be friends afterwards -- unified to bring about changes in this country. You know, we are at a defining moment in our history. Our nation is at war, and our economy is increasingly in shambles. And the families of Texas and all across America are feeling the brunt of that failing economy. This week I met a couple in San Antonio who have, as a consequence of entering into a predatory loan, are on the brink of foreclosure, and are actually seeing them having to cut back on their medical expenses because their mortgage doubled in two weeks. I've met a young woman who gets three hours of sleep a night because she has to work the night shift even as she's going to school full time, and still can't afford to provide the health care for her sister, who's ill. In Youngstown, Ohio, I've talked to workers who have seen their plant shipped overseas as a consequence of bad trade deals like NAFTA, literally seeing equipment unbolted from the floors of factories and shipped to China, resulting in devastating job losses and communities completely falling apart. And all across America I'm meeting not just veterans, but also the parents of those who have fallen. One mother in Green Bay gave me this bracelet in memory of a 20-year-old son who had been killed in a roadside bomb as a consequence of a war that I believe should have never been authorized and should have never been waged, and that has cost us billions of dollars that could have been invested here in the United States, in roads and bridges and infrastructure and making sure that young people can go to college, and that those who need health care actually get it. Now, Senator Clinton -- (applause) -- and I have been talking about these issues for the last 13 months. And we both offer detailed proposals to try to deal with them. Some of them are the same; some, we have differences of opinion on. But I think we both recognize that these problems have to be dealt with, and that we've seen an administration, over the last seven years, that has failed to address them, in many ways has made them worse. But understand that what's lacking right now is not good ideas. The problem we have is that Washington has become a place where good ideas go to die. (Applause.) They go to die, because lobbyists and special interests have a stranglehold on the agenda in Washington. They go to die in Washington, because too many politicians are interested in scoring political points rather than bridging differences in order to get things done. And so the central premise of this campaign is that we can bring this country together, that we can push against the special interests that have come to dominate the agenda in Washington, that we can be straight with the American people about how we're going to solve these problems, and enlist them in taking back their government. You know, Senator Clinton mentioned Barbara Jordan, somebody who was an inspiration to me and so many people throughout the country, and she said that what the American people want is very simple. They want an America that is as good as its promise. I'm running for president because I want to help America be as good as its promise. Thank you very much. (Cheers, applause.) MS. BROWN: All right, Senator Obama, thank you. And let's begin with questions. Jorge Ramos. MR. RAMOS: Thank you very much. (Speaks in Spanish.) Thank you so much for being with us, and let me start with a little news. After nearly half a century in office Fidel Castro resigned as the head of the Cuban government. Ninety miles off the coast of the United States we might have a new opportunity. A question for you, Senator Clinton. Would you be willing to sit down with Raul Castro or whoever leads the Cuban dictatorship when you take office at least just once to get a measure of the man? SEN. CLINTON: Well, Jorge, I hope we have an opportunity. The people of Cuba deserve to have a democracy, and this gives the Cuban government under Raul Castro a chance to change direction from the one that was set for 50 years by his brother. I'm going to be looking for some of those changes -- releasing political prisoners, ending some of the oppressive practices on the press, opening up the economy. Of course the United States stands ready, and as president I would be ready, to reach out and work with a new Cuban government once it demonstrated that it truly was going to change that direction. I want to bring the region together, our European allies who have influence with Cuba, to try to push for some of those changes, and to make it very clear that if Cuba moves toward democracy and freedom for its people the United States will welcome that. And as president, I would look for opportunities to try to make that happen and to create the momentum that might eventually lead to a presidential visit. But there has to be evidence that, indeed, the changes are real, that they're taking place, and that the Cuban people will finally be given an opportunity to have their future determined by themselves. MR. RAMOS: Very simply, would you meet with him or not, with Raul Castro? SEN. CLINTON: I -- I would not meet with him until there was evidence that change was happening because I think it's important that they demonstrate clearly that they are committed to change the direction. Then I think, you know, something like diplomatic encounters and negotiations over specifics could take place. But we've had this conversation before, Senator Obama and myself, and I believe that we should have full diplomatic engagement, where appropriate. But a presidential visit should not be offered and given without some evidence that it will demonstrate the kind of progress that is in our interest and, in this case, in the interest of the Cuban people. (Applause.) MS. BROWN: Senator Obama, just to follow up, you had said in a previous CNN debate that you would meet with the leaders of Cuba, Iran, North Korea, among others. So presumably you would be willing to meet with the new leader of Cuba. SEN. OBAMA: That's correct. Now, keep in mind that the starting point for our policy in -- in Cuba should be the liberty of the Cuban people. And I think we recognize that that liberty has not existed throughout the Castro regime. And we now have an opportunity to potentially change the relationship between the United States and Cuba, after over half a century. I would meet without preconditions, although Senator Clinton is right that there has to be preparation. It is very important for us to make sure that there was an agenda and on that agenda was human rights, releasing of political prisoners, opening up the press. And that preparation might take some time. But I do think that it is important for the United States not just to talk to its friends but also to talk to its enemies. In fact, that's where diplomacy makes the biggest difference. (Applause.) One other thing that I've said as a show of good faith, that we're interested in pursuing potentially a new relationship, what I've called for is a loosening of the restrictions on remittances from family members to the people of Cuba as well as travel restrictions for family members who want to visit their family members in Cuba. And I think that initiating that change in policy as a start and then suggesting that an agenda get set up is something that could be useful, but I would not normalize relations until we started seeing some of the progress that Senator Clinton talked about. MS. BROWN: But that's different from your position back in 2003. You called U.S. policy towards Cuba a miserable failure, and you supported normalizing relations. So you've back-tracked now. SEN. OBAMA: Well, the -- I support the eventual normalization, and it's absolutely true that I think our policy has been a failure. I mean, the fact is is that during my entire lifetime -- and Senator Clinton's entire lifetime you essentially have seen a Cuba that has been isolated but has not made progress when it comes to the issues of political rights and personal freedoms that are so important to the people of Cuba. So I think that we have to shift policy. I think our goal has to be ultimately normalization, but that's going to happen in steps. And the first step, as I said, is changing our rules with respect to remittances and with respect to travel. And then I think it is important for us to have the direct contact not just in Cuba, but I think this principle applies generally. I'm -- I recall what John F. Kennedy once said, that we should never negotiate out of fear, but we should never fear to negotiate. And this moment, this opportunity when Fidel Castro has finally stepped down I think is one that we should try to take advantage of. (Applause.) MS. BROWN: Senator Clinton, do you want a quick response? SEN. CLINTON: Well, I agree absolutely that we should be willing to have diplomatic negotiations and processes with anyone. I've been a strong advocate of opening up such a diplomatic process with Iran for a number of years because I think we should look for ways that we can possibly move countries that are adversarial to us, you know, toward the world community. It's in our interest. It's in the interests of the people in countries that, frankly, are oppressed, like Cuba, like Iran. But there has been this difference between us over when and whether the president should offer a meeting without preconditions with those with whom we do not have diplomatic relations, and it should be part of a process. But I don't think it should be offered in the beginning because I think that undermines the capacity for us to actually take the measure of somebody like Raul Castro or Ahmadinejad and others. And as President Kennedy said, he wouldn't be afraid to negotiate but he would expect there to be a lot of preparatory work done, to find out exactly what we would get out of it. And therefore I do think we should be eliminating the policy of the Bush administration, which has been very narrowly defined and frankly against our interests, because we have failed to reach out to countries. We have alienated our friends and we have emboldened our enemies. So I would get back to very vigorous diplomacy and I would use bipartisan diplomacy. I would ask emissaries from both political parties to represent me and our country. Because I want to send a very clear message, to the rest of the world, that the era of unilateralism, preemption and arrogance, of the Bush administration, is over. And we're going to start working together. (Cheers, applause.) MS. BROWN: Okay. Very briefly, and then we're going to move on. SEN. OBAMA: I think, as I've said before, preparation is actually absolutely critical in any meeting. And I think it is absolutely true that either of us would step back from some of the Bush unilateralism that's caused so much damage. But I do think it is important, precisely because the Bush administration has done so much damage to American foreign relations, that the president take a more active role in diplomacy than might have been true 20 or 30 years ago. Because the problem isn't -- is if we think that meeting with the president is a privilege that has to be earned, I think that reinforces the sense that we stand above the rest of the world at this point in time, and I think that it's important for us, in undoing the damage that has been done over the last seven years, for the president to be willing to take that extra step. That's the kind of step that I would like to take as president of the United States. (Cheers, applause.) MS. BROWN: A question now on the economy. John King. MR. KING: Campbell noted -- Senators, good evening, first. I want to bring the conversation back home. You know from your travels, you don't need to look at the polls or anything else, that the economy is by far now the dominant issue that voters want to hear about from the candidates, and for some that's a question about what should we do about an economy that is at the edge or perhaps in the early stages of a recession. For some, it's more focused; maybe it's will you raise the minimum wage, maybe it is about trade deals that they think leave them on the raw end, as you mentioned in your opening statement, Senator Obama. But when we asked Democrats how are these two candidates different, many of them say they don't know. So Senator Obama, beginning with you, tell us as specifically as you can how would a President Obama be different than a President Clinton in managing the nation's economy. SEN. OBAMA: Well, first of all, let me emphasize the point that you just made, which is you don't need an economist or the Federal Reserve to tell the American people that the economy's in trouble because they've been experiencing it for years now. Everywhere you go, you meet people who are working harder for less. Wages and incomes have flatlined. People are seeing escalating costs from -- of everything from health care to gas at the pump. And so people have been struggling for a long time, and in some communities they have been struggling for decades now. So this has to be a priority of the next president. Now, what I've said is that we have to restore a sense of fairness and balance to our economy, and that means a couple of things. Number one, with our tax code, we've got to stop giving tax breaks to companies that are shipping jobs overseas and invest those tax breaks in companies that are investing here in the United States of America. (Applause.) We have to end the Bush tax cuts to the wealthy -- (cheers, applause) -- and to provide tax breaks to middle- class Americans and working Americans who need them. So I've said that if you are making $75,000 a year or less, I want to give a(n) offset to your payroll tax that will mean a thousand extra dollars in the pockets of ordinary Americans. Senior citizens making less than 50,000 (dollars), you shouldn't have to pay income tax on your Social Security. We pay for these by closing tax loopholes and tax havens that are being manipulated. On our trade deals, I think it is absolutely critical that we engage in trade, but it has to be viewed not just through the lens of Wall Street, but also Main Street, which means we've got strong labor standards and strong environmental standards, and safety standards so we don't have toys being shipped into the United States with lead paint on them. (Applause.) Now -- so that's -- these are all issues that I've -- I've talked about repeatedly. And I think there are also opportunities in our economy around creating a green economy. We send a billion dollars to foreign countries every day because of our addition to foreign oil. And for us to move rapidly to cap greenhouse gases, generate billions of dollars that we can reinvest in solar and wind and biodiesel -- that can put people back to work. (Applause.) So the -- now, I don't want to take too much time, and I'm sure we'll be able to spend more time discussing this. Senator Clinton and I, I think, both agree on many of these issues. And I think it's a credit to the Democratic Party as a whole that the other candidates who were involved earlier on agreed with us on many of these issues. I think that there is a -- a real, solid agenda for moving change forward in the next presidency. The question people are going to have to ask is, how do we get it done? And it is my strong belief that the changes are only going to come about if we're able to form a working coalition for change, because people who are benefiting from the current code are going to resist, the special interests and lobbyists are going to resist. And I think it has to be a priority for whoever the next president is to be able to overcome the dominance of the special interests in Washington, to bring about the kinds of economic changes that I'm talking about, and that's an area where Senator Clinton and I may have a slight difference. But I'm happy to let her speak first, and then can pick up on anything that's been left out. (Applause.) MR. KING: Let's give Senator Clinton that opportunity then. As you have campaigned, Senator, on this issue and others but specifically on this issue, you have said, I am ready on day one to take charge of the economy. The clear implication, since you have one opponent at the moment, is that you're ready; he's not. What would you do differently on day one than a President Obama would when it comes to managing the nation's economy? SEN. CLINTON: Well, I would agree with a lot that Senator Obama just said, because it is the Democratic agenda. We are going to rid the tax code of these loopholes and giveaways. We're going to stop giving a penny of your money to anybody who ships a job out of Texas, Ohio or anywhere else to another country. We're certainly going to begin to get the tax code to reflect what the needs of middle class families are, so we can rebuild a strong and prosperous middle class. The wealthy and the well-connected have had a president for the last seven years. And I think it's time that the rest of America had a president who works for you every single day. (Cheers, applause.) We will also have a different approach toward trade. We're going to start having trade agreements that not only have strong environmental and labor standards, but I want to have a trade timeout. We're going to look and see what's working, what's not working. And I'd like to have a trade prosecutor to actually enforce the trade agreements that we have before we enter into any others. We're also going to put much tougher standards in place so that people cannot import toys with lead paint, contaminated pet food, contaminated drugs into our market. We're going to have a much more vigorous enforcement of safety standards. Now, in addition, there are steps I would take immediately. One is on this foreclosure crisis. I have been saying for nearly a year we had to crack down on the abusive practices of the lenders. But we also need a moratorium on home foreclosures. Everywhere I go, I meet people who either have been or are about to lose their home -- 85,000 homes in foreclosure in Texas, 90,000 in Ohio. I've met the families: the hairdresser, the single mom who's going to lose her home; the postal worker who got really hoodwinked into an agreement that wasn't fair to him. So I would put a moratorium for 90 days to give us time to work out a way for people to stay in their homes, and I would freeze interest rates for five years because these adjustable-rate mortgages, if they keep going up, millions of Americans are going to be homeless -- (applause) -- and vacant homes will be across the neighborhoods of Texas and America. Now, in addition, there are three ways we need to jumpstart the economy. Clean green jobs -- I've been promoting this. I wanted it to be part of the stimulus package. I thought a $5 billion investment in clean green jobs would put hundreds of thousands of Americans to work helping to create our future. We also need to invest in our infrastructure. We don't have enough roads to take care of the congestion. We have crumbling bridges and tunnels. We need to rebuild America, and that will also put people to work. And finally, we need to end George Bush's war on science, which has been waged -- (cheers, applause) -- (off mike). MS. BROWN: Thank you, Senator. And we've got a lot of ground to cover -- SEN. CLINTON: So I want to think about how we fund the future. We've got to get back to being the innovation nation. Think of everything that goes on at this great university to create the new economy -- (cheers, applause). MS. BROWN: All right, Senator Clinton, thank you very much. As I was saying, we've got a lot to get through, so I do want to shift gears and go on to another topic especially important here in Texas, which is immigration. And Jorge, you have a question. MR. RAMOS: (Speaks in Spanish.) Federal raids by immigration enforcement officials on homes and businesses have generated a great deal of fear and anxiety in the Hispanic community and have divided the family of some of the 3 million U.S.-born children who have at least one undocumented parent. Would you consider stopping these raids once you take office until comprehensive immigration reform can be passed? SEN. CLINTON: I would consider that, except in egregious situations where it would be appropriate to take the actions you're referring to. But when we see what's been happening with literally babies being left with no one to take care of them, children coming home from school, no responsible adult left -- that is not the America that I know. That is against American values. (Applause.) And it is -- it is a stark admission of failure by the federal government. We need comprehensive immigration reform. I have been for this. I signed on to the first comprehensive bill back in 2004. I've been advocating for it. Tougher, more secure borders -- of course. But let's do it the right way: cracking down on employers, especially once we get to comprehensive immigration reform, who exploit undocumented workers and drive down wages for everyone else. I'd like to see more federal help for communities like Austin and others, like Laredo where I was this morning, that absorb the health care, education and law enforcement costs. And I personally, as president, would work with our neighbors to the south to help them create more jobs for their own people. And finally, we need a path to legalization to bring the immigrants out of the shadows, give them the conditions that we expect them to meet: paying a fine for coming here illegally, trying to pay back taxes over time, and learning English. If they had committed a crime in our country or the country they came from, then they should be deported. But for everyone else, there must be a path to legalization. I would introduce that in the first 100 days of my presidency. (Cheers, applause.) MS. BROWN: Senator Obama, is your position the same as Hillary Clinton's? SEN. OBAMA: You know, there are a couple of things I would add. Comprehensive immigration reform is something that I've worked on extensively. Two years ago we were able to get a bill out of the Senate. I was one of a group of senators that helped to move it through, but it died in the House this year. Because it was used as a political football instead of a way of solving a problem, nothing happened. And so there are a couple of things that I would just add to what Senator Clinton said. Number one, it is absolutely critical that we tone down the rhetoric when it comes to the immigration debate, because there has been an undertone that has been ugly. Oftentimes it has been directed at the Hispanic community. We have seen hate crimes skyrocket in the wake of the immigration debate, as it's been conducted in Washington, and that is unacceptable. We are a nation of laws and we are a nation of immigrants, and we can reconcile those two things. So we need comprehensive reform -- (applause) -- we need comprehensive reform, and that means stronger border security. It means that we are cracking down on employers that are taking advantage of undocumented workers because they can't complain if they're not paid a minimum wage, they can't complain if they're not getting overtime, worker safety laws are not being observed. We have to crack down on those employers, although we also have to make sure that we do it in a way that doesn't lead to people with Spanish surnames being discriminated against. So there's got to be a -- a -- a safeguard there. We have to require that undocumented workers, who are provided a pathway to citizenship, not only learn English, pay back taxes and pay a significant fine, but also that they're going to the back of the line, so that they're not getting citizenship before those who have applied legally, which raises two last points. Number one, it is important that we fix the legal immigration system, because right now we've got a backlog that means years for people to apply legally. (Applause.) And what's worse is, we keep on increasing the fees, so that if you've got a hard-working immigrant family, they've got to hire a lawyer; they've got to pay thousands of dollars in fees. They just can't afford it, and it's discriminatory against people, who have good character, we should want in this country, but don't have the money. So we've got to fix that. The second thing is, we have to improve our relationship with Mexico and work with the Mexican government, so that their economy is producing jobs on that side of the border. (Applause.) And the problem that we have, the problem that we have, is that we have had an administration that came in promising all sorts of leadership on creating a U.S.-Mexican relationship. And frankly President Bush dropped the ball. He has been so obsessed with Iraq that we have not seen the kinds of outreach and cooperative work that would ensure that the Mexican economy is working, not just for the very wealthy in Mexico but for all people. And that's a policy that I'm going to change when I'm president of the United States. (Cheers, applause.) MS. BROWN: All right, Senator Obama. We're going to stay with this topic. I want to have John King ask another question. Go ahead, John. MR. KING: I want to stay on the issue, but move to a controversial item that was not held up when the immigration debate collapsed in Washington, and that is the border fence. To many Americans, it is a simple question of sovereignty and security: America should be able to keep people out that it doesn't want in. But as you know, in this state, especially if you go to the south of here along the border, and in other border states, to many people it's a much more personal question. It could be a question of their livelihood. It could be a question of cross-border trade. It might be an issue to a rancher of property rights. It might be a simple question of whether someone can take a walk or a short drive to see their family members. Senator, back in 2006 you voted for the construction of that fence. As you know, progress has been slow. As president of the United States, would you commit tonight that you will finish the fence and speed up the construction, or do you think it's time for a president of the United States to raise his or her hand and say, you know what, wait a minute, let's think about this again; do we really want to do this? SEN. CLINTON: Well, I think both Senator Obama and I voted for that as part of the immigration debate. And having been along the border for the last week or so -- in fact, last night I was at the University of Texas at Brownsville, and this is how absurd this has become under the Bush administration because, you know, there is a smart way to protect our borders and there is a dumb way to protect our borders. (Laughter, applause.) And what I learned last night, when I was there with Congressman Ortiz, is that the University of Texas at Brownsville would have part of its campus cut off. This is the kind of absurdity that we're getting from this administration. I know it because I've been fighting with them about the northern border. Their imposition of passports and other kinds of burdens are separating people from families, interfering with business and commerce and movement of goods and people. So what I've said is that I would say, wait a minute. We need to review this. There may be places where a physical barrier is appropriate. I think when both of us voted for this we were voting for the possibility that where it was appropriate and made sense it would be considered, but as with so much, the Bush administration has gone off the deep end, and they are unfortunately coming up with a plan that I think is counterproductive. So I would have a review. I would listen to the people who live along the border, who understand what it is we need to be doing to protect our country. (Cheers, applause.) MS. BROWN: Let me go on and -- Sorry, John. MR. KING: But does that mean that you think your vote was wrong or the implementation of it was wrong, because, as you know, when they first built the fence in the San Diego area it only went so far, and what it did was it stopped the people coming straight up the path of where that was built and they simply moved, and California's problem became Arizona's problem. SEN. CLINTON: But you know, John, there is -- there's a lot we've learned about technology and smart fencing. You know, there is technology that can be used instead of a physical barrier. It requires us having enough personnel along the border, so that people can be supervising a certain limited amount of space and will be able to be responsive in the event of, you know, people attempting to cross illegally. And -- and I think that the way that the Bush administration is going about this, filing eminent domain actions against landowners and municipalities, makes no sense. So what I have said is, yes, there are places when, after a careful review -- again, listening to the people who live along the border -- there may be limited places where it would work. But let's deploy more technology and personnel instead of the physical barrier. I frankly think that will work better, and it will give us an opportunity to secure our borders without interfering with family relations, business relations, recreation and so much else that makes living along the border, you know, wonderful. MS. BROWN: All right -- SEN. CLINTON: And the people who live there need to have a president who understands it, will listen to them and be responsive. MS. BROWN: All right, Senator Clinton. Senator Obama, go ahead, please. (Applause.) SEN. OBAMA: Well, this is an area where Senator Clinton and I almost entirely agree. I think that the key is to consult with local communities, whether it's on the commercial interests or the environmental stakes of creating any kind of barrier. And the Bush administration is not real good at listening. That's not what they do well. (Laughter.) And so I will reverse that policy. As Senator Clinton indicated, there may be areas where it makes sense to have some fencing. But for the most part, having Border Patrol, surveillance, deploying effective technology, that's going to be the better approach. The one thing I do have to say, though, about this issue is it is very important for us, I think, to deal with this problem in terms of thousands of -- hundreds of thousands of people coming over the borders on a regular basis if we want to also provide opportunity for the 12 million undocumented workers who are here. Senator Clinton and I have both campaigned in places like Iowa and Ohio and my home state of Illinois, and I think that the American people want fairness, want justice. I think they recognize that the idea that you're going to deport 12 million people is ridiculous, that we're not going to be -- (applause) -- devoting all our law enforcement resources to sending people back. But what they do also want is some order to the process. And so we're not going to be able to do these things in isolation. We're not going to be able to deal with the 12 million people who are living in the shadows and give them a way of getting out of the shadows if we don't also deal with the problem of this constant influx of undocumented workers. And that's why I think comprehensive reform is so important. That's the kind of leadership that I've shown in the past. That's the kind of leadership that I'll show in the future. One last point I want to make on the immigration issue, because we may be moving to different topics. Something that we can do immediately that I think is very important is to pass the DREAM Act, which allows children who -- (applause) -- through no fault of their own are here but have essentially grown up as Americans -- allow them the opportunity for higher education. I do not want two classes of citizens in this country. I want everybody to prosper. That's going to be a top priority. (Cheers, applause.) MS. BROWN: Okay. Let's -- we've got one last question on immigration. Jorge, go ahead. MR. RAMOS: (Remarks in Spanish.) Right now there are more than 30 million people in this country who speak Spanish. (Applause.) Many of them are right here. By the year 2050, there will be 120 million Hispanics in the United States. Now, is there any downside, Senator Clinton, to the United States becoming -- (remarks in Spanish) -- becoming a bilingual nation? Is there a limit? SEN. CLINTON: Well, I think it's important for as many Americans as possible to do what I've never been able to do. And that is learn another language and try to be bilingual, because that connects us to the rest of the world. I think it is important though that English remain our common, unifying language -- (applause) -- because that brings our country together in a way that we've seen generations of immigrants, coming to our shores, be able to be part of the American experience and pursue the American dream. You know, I have been adamantly against the efforts by some to make English the official language. That I do not believe is appropriate, and I have voted against it and spoken against it. I represent New York. We have a hundred and seventy languages in New York City alone, and I do not think that we should be in any way discriminating against people who do not speak English, who use facilities like hospitals or have to go to court to enforce their rights. But I do think that English does remain an important part of the American experience, so I encourage people to become bilingual, but I also want to see English remain the common unifying language of our country. (Applause.) MR. RAMOS: Senator Obama, is there any downside to the United States becoming a bilingual nation? SEN. OBAMA: Well, I think it is important that everyone learns English and that we have that process of binding ourselves together as a country. I think that's very important. I also think that every student should be learning a second language because -- (interrupted by applause) -- you know -- so when you start getting into a debate about bilingual education, for example, now I want to make sure that children who are coming out of Spanish-speaking households have the opportunity to learn and are not falling behind. And if bilingual education helps them do that, I want to give them the opportunity. But I also want to make sure that English-speaking children are getting foreign languages because this world is becoming more interdependent, and part of the process of America's continued leadership in the world is going to be our capacity to communicate across boundaries, across borders. And that's something, frankly, that's fallen very -- where we've fallen behind. And one of the failures of No Child Left Behind, a law that I think a lot of local and state officials have been troubled by, is that it is so narrowly focused on standardized tests that it has pushed out a lot of important learning that needs to take place. (Cheers, applause.) And foreign languages is one of those areas that I think has been neglected. I want to put more resources into it. MS. BROWN: All right. We're going to take a quick break. We've got to go to a commercial. We'll be back with a lot more. There's also a debate, we should mention, raging online right now, so go to our website, CNNPolitics.com, to join in. The debate here at the University of Texas in Austin continues right after this. (Cheers, applause.) (Announcements.) MS. BROWN: And we are back. We're here in Austin, Texas, the capital city. Welcome back to the Texas Democratic debate at the University of Texas-Austin. The first question now goes to John King. MR. KING: Senators, as I'm sitting here, we're about 45 minutes into the discussion tonight, and I'm having what I like to call one of those parallel universe moments. I've been watching each of you give speeches in arenas not unlike this one, individually, and the tone is often quite different than the very polite, substantive discourse -- (laughter, applause) -- we've had tonight. And so I want to ask you about that. There are times when each of you seems to call into question the other one's credibility or truthfulness. And Senator Clinton, I want to talk specifically about some words you've spoken here in the state of Texas over the past couple of days. You've said, quote, "My opponent gives speeches; I offer solutions." You said the choice for Democrats in this campaign is, quote, "talk versus action." Now, in a campaign that some of us are old enough to remember -- maybe not many of the students here -- this would be called the "Where's the beef?" question. (Laughter.) But since we're in Texas, I'd like to borrow a phrase that they often use here, and you've used yourself in the context of President Bush. Are you saying that your opponent is all hat and no cattle? And can you say that after the last 45 minutes? (Laughter, applause.) SEN. CLINTON: Well, I have said that about President Bush, and I think our next president needs to be a lot less hat and a lot more cattle. (Cheers, applause.) You know, I think you can tell from the first 45 minutes, you know, Senator Obama and I have a lot in common. We both care passionately about our country. We are devoted to public service. We care deeply about the future. And we have run a very vigorous and contested primary campaign, which has been by most standards, I think, very positive and extremely civil. But there are differences between us, and I think in our efforts to draw those contrasts and comparisons we obviously try to let voters know how we see the world differently. And I do offer solutions. That's what I believe in and what I have done, and it's what I offer to voters because it's part of my life over the last 35 years: working to get kids health care, working to expand legal services for the poor, working to register voters, working to make a difference, because I think that this country has given me so much. And there are differences between our records and our accomplishments. I have to confess I was somewhat amused the other night when on one of the TV shows, one of Senator Obama's supporters was asked to name one accomplishment of Senator Obama, and he couldn't. So I know that there are comparisons and contrasts to be drawn between us, and it's important that voters get that information. So yes, I do think that words are important and words matter, but actions speak louder than words, and I offer -- (by cheers, applause) -- (off mike). MS. BROWN: Senator Obama, go ahead. Senator Obama, do you want to respond? SEN. OBAMA: Well, I think actions do speak louder than words, which is why over the 20 years of my public service I have acted a lot to provide health care to people who didn't have it, to provide tax breaks to families that needed it, to reform a criminal justice system that had resulted in wrongful convictions, to open up our government, and to pass the toughest ethics reform legislation since Watergate -- (applause) -- to make sure that we create transparency -- to make sure that we create transparency in our government so that we know where federal spending is going and it's not going to a bunch of boondoggles and earmarks that are wasting taxpayer money that could be spent on things like early childhood education. You know, I think if you talk to those wounded warriors at Walter Reed who, prior to me getting to the Senate, were having to pay for their meals and have to pay for their phone calls to their family while they're recovering from amputations, I think they'd say that I've engaged not just in talk, but in action. (Cheers, applause.) Now -- now, I think Senator Clinton has a fine record, and I don't to denigrate that record. I do think there is a fundamental difference between us in terms of how change comes about. Senator Clinton of late has said "let's get real." And the implication is, is that, you know, the people who have been voting for me or involved in my campaign are somehow delusional -- (laughter) -- and that -- (chuckles) -- that, you know, the -- (laughter) -- you know, the 20 million people who have been paying attention to 19 debates, and the editorial boards all across the country at newspapers who have given me endorsements including every major newspaper here in the state of Texas -- (cheers, applause) -- you know, the thinking is that somehow they're being duped and that eventually they're going to see the reality of things. Well, I think they perceive reality of what's going on in Washington very clearly. And what they see is that if we don't bring the country together, stop the endless bickering, actually focus on solutions and reduce the special interests that have dominated Washington, then we will not get anything done. And the reason that this campaign has done so well -- (applause) -- the reason that this campaign has done so well is because people understand that it is not just a matter of putting forward policy positions. Senator Clinton and I share a lot of policy positions. But if we can't inspire the American people to get involved in their government, and if we can't inspire them to go beyond the racial divisions and the religious divisions and the regional divisions, that have plagued our politics for so long, then we will continue to see the kind of gridlock and non-performance in Washington that is resulting in families suffering in very real ways. I'm running for president to start doing something about that suffering and so are the people who are behind my campaign. (Cheers, applause.) MS. BROWN: I think -- I think one of the points -- (interrupted by continued cheers, applause). I think one of the points that John King was alluding to in talking about some of Senator Clinton's comments is there has been a lot of attention lately on some of your speeches, that they're very similar to some of the speeches by your friend and supporter, Deval Patrick, the governor of Massachusetts. And Senator Clinton's campaign has made a big issue of this. To be blunt, they've accused you of plagiarism. SEN. OBAMA: Right. MS. BROWN: How do you respond? SEN. OBAMA: Well, look, the -- first of all, it's not a lot of speeches. There are two lines in speeches that I've been giving over the last couple of weeks. I've been campaigning now for the last two years. Deval is a national co-chairman of my campaign and suggested an argument that I share, that words are important, words matter, and the implication that they don't, I think, diminishes how important it is to speak to the American people directly about making America as good as its promise. And Barbara Jordan understood this as well as anybody. Now, the notion that I had plagiarized from somebody who's one of my national co-chairs -- (laughter) -- who gave me the line and suggested that I use it, I think is silly. (Cheers, applause.) And -- you know, but -- but -- but this is where we start getting into silly season in politics, and I think people start getting discouraged about it. (Cheers, applause.) They don't want -- what they want is, how are we going to create good jobs at good wages? How are we going to provide health care to the American people? How are we going to make sure that college is affordable? So what I have been talking about in these speeches -- and I got to admit, some of them are pretty good -- (laughter, cheers, applause) -- what I've been talking about is not just hope and not just inspiration; it's a $4,000 tuition credit for every student every year -- (cheers, applause) -- in exchange for national service so that college becomes more affordable. I've been talking about making sure that we change our tax code so that working families actually get relief. I have been talking about making sure that we bring an end to this war in Iraq so that we can start bringing our troops home and invest money here in the United States. (Applause.) And so just to finish up, these are very specific, concrete, detailed proposals, many of them which I've been working on for years now. Senator Clinton has a fine record. So do I. And I'm happy to have a debate on the issues, but what we shouldn't be spending time doing is tearing each other down. We should be spending time lifting the country up. (Cheers, applause.) MS. BROWN: Senator Clinton, is it the silly season? SEN. CLINTON: Well, I think that if your candidacy is going to be about words, then they should be your own words. That's, I think, a very simple proposition. (Applause.) And you know -- you know, lifting whole passages from someone else's speeches is not change you can believe in; it's change you can Xerox. And I just don't think -- SEN. OBAMA: Oh, but that -- that's not what happened there -- SEN. CLINTON: No, but -- you know, but Barack, it is, because if -- you know, if you look -- (jeers from the audience) -- if you look -- if you look -- if you look at the YouTube of these videos, it does raise questions. Now, there is no doubt that you are a passionate, eloquent speaker, and I applaud you for that. But when you look at what we face in this country, we do need to unite the country, but we have to unite it for a purpose around very specific goals. It is not enough to say, "Let's come together." We know we're going to have to work hard to overcome the opposition of those who do not want the changes to get to universal health care. You know, when I proposed a universal health care plan, as did Senator Edwards, we took a big risk, because we know it's politically controversial to say we're going to cover everyone. And you chose not to do that. You chose to put forth a health care plant that will leave out at least 15 million people. That's a big difference. When I said we should put a moratorium on home foreclosures, basically your response was, well, that wouldn't work, and you know, in the last week even President Bush said we have to do something like that. I just believe that we've got to look hard at the difficult challenges we face, especially after George Bush leaves the White House. The world will breathe a sigh of relief once he is gone. (Applause.) We all know that. But then we've got to do the hard work of not just bringing the country together, but overcoming a lot of the entrenched opposition to the very ideas that both of us believe in and for some of us have been fighting for a very long time. You know, when I took on -- (interrupted by cheers, applause). When I took on universal health care back in '93 and '94, it was against a fire storm of special interest opposition. I was more than happy to do that because I believe passionately in getting quality affordable health care to every American. I don't want to leave anybody out. I see the results of leaving people out. I am tired of health insurance companies deciding who will live or die in America. That has to end. (Applause.) MS. BROWN: All right. Senator Clinton, thank you. Senator Obama, please respond. SEN. OBAMA: Well, I think that Senator Clinton mentioned two specific issue areas where we've got some differences. And I'm happy to debate those, which is what I think should be the focus of this campaign. We both want universal health care. When I released my plan, a few months later, we were in a debate, and Senator Clinton said, we all want universal health care. And of course, I was down 20 points in the polls at the time, and so my plan was pretty good. It's not as good now, but my plan hasn't changed. The politics have changed a little bit. We do -- we both -- 95 percent of our plans are similar. We both want to set up a system in which any person is going to be able to get coverage that is as good as we have as members of Congress. And we are going to subsidize those who can't afford it. We're going to make sure that we reduce costs by emphasizing prevention, and I want to make sure that we're applying technology to improve quality, cut bureaucracy. Now, I also want to make sure that we're reducing costs for those who already have health insurance. So we put in place a catastrophic reinsurance plan that would reduce costs by $2,500 per family per year. So we've got a lot of similarities in our plan. We've got a philosophical difference which we've debated repeatedly, and that is that Senator Clinton believes the only way to achieve universal health care is to force everybody to purchase it, and my belief is the reason that people don't have it is not because they don't want it, but because they can't afford it. And so I emphasize -- (applause) -- reducing costs. And as has been noted by many observers, including Bill Clinton's former secretary of Labor, my plan does more than anybody to reduce costs, and there is nobody out there who wants health insurance who can't have it. Now, there are legitimate arguments for why Senator Clinton and others have called for a mandate, and I'm happy to have that debate. But the notion that I am leaving 15 -- 15 million people out somehow implies that we are different in our goals of providing coverage to all Americans, and that is simply not true. We think that there's going to be a different way of getting there. One last point I want to make on the health care front. I admire the fact that Senator Clinton tried to bring about health care reform back in 1993. She deserves credit for that. (Applause.) But I -- I've said before I think she did it in the wrong way because it wasn't just the fact that the insurance companies and the drug companies were battling her -- and no doubt they were -- it was also that Senator Clinton and the administration went behind closed doors, excluded the participation even of Democratic members of Congress who had slightly different ideas than the ones that Senator Clinton had put forward. And as a consequence, it was much more difficult to get Congress to cooperate. And I've said that I'm going to do things differently. I think we have to open up the process, everybody has to have a seat the table, and most importantly, the American people have to be involved and educated about how this change is going to be brought about. The point is this: We can have great plans, but if we don't change how the politics is working in Washington, then neither of our plans are going to happen and we're going to be four years from now debating once again how we're going to bring universal health care to this country. (Applause.) MS. BROWN: All right -- SEN. OBAMA: That's not something I want to do. MS. BROWN: -- I've got -- we've got some time constraints here. Now, we've got to take to another real quick break. Stay with us. We've got a lot more ahead. You can compare the candidates on the issues any time, just go to our website, cnnpolitics.com. A lot more ahead here at the University of Texas. We'll be right back. (Cheers, applause.) (Announcements.) (Cheers, applause.) MS. BROWN: An enthusiastic crowd here at the University of Texas. Welcome back to the Texas Democratic debate. Let's get right to it. Jorge Ramos with the next question. MR. RAMOS: (Thank you ?), Campbell. Senator Clinton, yesterday you said -- and I'm quoting -- "one of us is ready to be commander in chief." Are you saying that Senator Obama is not ready and not qualified to be commander in chief? SEN. CLINTON: Well, I believe that I am ready, and I am prepared. And I will leave that to voters to decide. But I want to get back to health care because I didn't get a chance to respond -- MS. BROWN: All right -- MR. RAMOS: Oh, but -- SEN. CLINTON: -- after Senator Obama. No, let -- let me finish, Jorge -- MR. RAMOS: But I would like you also to come back to this after -- SEN. CLINTON: -- because this is a significant difference. You know, Senator Obama has said it's a philosophical difference. I think it's a substantive difference. He has a mandate for parents to be sure to insure their children. I agree with that. I just know that if we don't go and require everyone to have health insurance, the health insurance industry will still game the system, every one of us with insurance will pay the hidden tax of approximately $900 a year -- (applause) -- to make up for the lack of insurance. And you know, in one of our earlier debates John Edwards made a great point. It would be as though Social Security were voluntary; Medicare, one of the great accomplishments of President Johnson, was voluntary. (Applause.) I do not believe that is going to work. So it's not just a philosophical difference. You look at what will work and what will not work. If you do not have a plan that starts out attempting to achieve universal health care, you will be nibbled to death, and we will be back here, with more and more people uninsured and rising costs. (Applause.) MS. BROWN: All right. We appreciate that you want to make a point. Senator Obama, we have limited time -- SEN. OBAMA: Yeah. MS. BROWN: -- so I would like Jorge to move on to another subject, or we're going to be out of time. SEN. OBAMA: But I -- well, I -- I understand, but I think that Senator Clinton made a -- (laughter) -- you know, she's making a point, and I -- and I think I should have the opportunity to respond very briefly, and I'll -- I'll try to make it as quickly as possible. MS. BROWN: Very briefly, absolutely. SEN. OBAMA: Number one, understand that when Senator Clinton says a mandate, it's not a mandate on government to provide health insurance; it's a mandate on individuals to purchase it. And Senator Clinton is right; we have to find out what works. Now, Massachusetts has a mandate right now. They have exempted 20 percent of the uninsured because they've concluded that that 20 percent can't afford it. In some cases, there are people who are paying fines and still can't afford it, so now they're worse off than they were. They don't have health insurance and they're paying a fine. (Applause.) And in order for you to force people to get health insurance, you've got to have a very harsh, stiff penalty. And Senator Clinton has said that we will go after their wages. Now, this is a substantive difference. But understand that both of us seek to get universal health care. I have a substantive difference with Senator Clinton on how to get there, okay. SEN. CLINTON: Well -- MS. BROWN: All right. All right, Senator Clinton -- SEN. CLINTON: Wait a minute. No, this is too important. (Laughter.) This is the number one issue that people talk to me about. You know, when a mother grabs my arm and says "I can't get the operation my son needs because I don't have health insurance," it is personal for me. And I just fundamentally disagree. You know, Senator Obama's plan has a mandate on parents and a fine if parents -- SEN. OBAMA: That's right. SEN. CLINTON: -- do not insure their children. SEN. OBAMA: That's right. SEN. CLINTON: Because he recognizes that unless we have some kind of restriction, we will not get there. He's also said that if people show up at the hospital sick without health insurance, well, maybe at that point, you can fine them. We would not have a social compact with Social Security and Medicare if everyone did not have to participate. I want a universal health care plan. (Cheers, applause.) SEN. OBAMA: That mother, who is desperate to get health care for her child, will be able to get that health care under my plan, point number one. Point number two, the reason a mandate for children can be effective is, we've got a ability to make affordable health care available to that child right now. There are no excuses. If a parent is not providing health care for that child, it's because the parent's not being responsible under my plan, and those children don't have a choice. But I think that adults are going to be able to see that they can afford it under my plan; they will get it under my plan. And it is true that if it turns out that some are gaming the system, then we can impose potentially some penalties on them for gaming the system. But the notion that somehow I am interested in leaving out 15 million people, without health insurance, is simply not true. SEN. CLINTON: Well -- MS. BROWN: (Off mike) -- (applause). SEN. CLINTON: We disagree on that. MS. BROWN: Okay. Let's let Jorge re-ask his question because I don't think anyone remembers. (Laughter.) MR. RAMOS: Let me try again and not in Spanish, okay? (Laughter.) Here we go again -- because we also believe the war in Iraq is very important, and here's the question. Are you suggesting that Senator Obama is not ready, he doesn't have the experience to be commander in chief? That's a question. What did you mean by that phrase? SEN. CLINTON: What I mean is that, you know, for more than 15 years I've been honored to represent our country in more than 80 countries to negotiate on matters such opening borders for refugees during the war in Kosovo, to stand up for women's rights and human rights around the world. I've served on the Senate -- (interrupted by cheers, applause). I've served on the Senate Armed Services Committee, and I have worked as one of the leaders in the Congress on behalf of homeland security and the very difficult challenges we face. You know, just this week -- it's a good example -- we had elections in Pakistan; we had a change in government in Cuba or at least the leadership; we've had the elections that, you know, should have happened, that haven't happened, and just change the leader the way they do in Cuba; we've had Kosovo declaring independence; and we have had our embassy set on fire in Serbia. So we have serious problems that pose a real question about presidential leadership, and also some great opportunities. You know, we now have opportunities, perhaps, with Cuba, I hope with President Musharraf for him to do the right thing. I've supported the independence of Kosovo because I think it is imperative that in the heart of Europe we continue to promote independence and democracy. And I would be moving very aggressively to hold the Serbian government responsible with their security forces to protect our embassy. Under international law they should be doing that. So when you think about everything that is going to happen, what we can predict and what we cannot predict, I believe that I am prepared and ready on day one to be commander in chief, to be the president, to turn our economy around, and to begin making a lot of these very difficult decisions that we will inherit from George Bush. And that is what I am putting forth to the voters. (Cheers, applause.) MS. BROWN: Senator Obama. Go ahead, Senator Obama. SEN. OBAMA: I wouldn't be running if I didn't think I was prepared to be commander in chief. (Cheers, applause.) And my -- my number one job as president will be to keep the American people safe. And I will do whatever is required to accomplish that, and I will not hesitate to act against those that would do America harm. Now, that involves maintaining the strongest military on earth, which means that we are training our troops properly and equipping them properly and putting them on proper rotations. And there are an awful lot of families, here in Texas, who have been burdened under two and three and four tours, because of the poor planning of the current commander in chief. And that will end when I'm president. (Applause.) But it also means using our military wisely. And on what I believe was the single most important foreign policy decision of this generation -- whether or not to go to war in Iraq -- I believe I showed the judgment of a commander in chief. I think that Senator Clinton was wrong in her judgments on that. (Applause.) Now, that has consequences. That has significant consequences because it has diverted attention from Afghanistan, where al Qaeda, that killed 3,000 Americans, are stronger now than at any time since 2001. I heard from a Army captain, who was the head of a rifle platoon, supposed to have 39 men in a rifle platoon. Ended up being sent to Afghanistan with 24, because 15 of those soldiers had been sent to Iraq. And as a consequence, they didn't have enough ammunition; they didn't have enough humvees. They were actually capturing Taliban weapons because it was easier to get Taliban weapons than it was for them to get properly equipped by our current commander in chief. Now that's a consequence of bad judgment, and you know, the question is on the critical issues that we face right now who's going to show the judgment to lead. And I think that on every critical issue that we've seen in foreign policy over the last several years -- going into Iraq originally, I didn't just oppose it for the sake of opposing it. I said this is going to distract us from Afghanistan; this is going to fan the flames of anti- American sentiment; this is going to cost us billions of dollars and thousands of lives and overstretch our military, and I was right. On the question of Pakistan, which Senator Clinton just raised, we just had an election there, but I've said very clearly that we have put all our eggs in the Musharraf basket. That was a mistake. We should be going after al Qaeda and making sure that Pakistan is serious about hunting down terrorists as well as expanding democracy, and I was right about that. On the issues that have come up, that a commander in chief is going to have to make decisions on, I have shown the judgment to lead. That is the leadership that I want to show when I'm president of the United States. (Cheers, applause.) MS. BROWN: All right, Senator Clinton, we're going to stay with this and stay on Iraq. John King. MR. KING: I want to continue in this vein and hone in on the very point you just made because one of you, unless this remarkable campaign here takes another wacky, unpredictable turn, is going to be running against a decorated war hero who is going to say that you don't have the experience to be commander in chief. And you have both said it's not about that type of experience; it's about judgment. You both had to make a judgment a short time ago in your job in the United States Senate about whether to support the surge. And as that was going on, Senator Clinton, you had the commanding general in Iraq before you, and you said, "I think that the reports you provide to us really require the willing suspension of disbelief," your words to General Petreaus. I want you to look at Iraq now and listen to those who say the security situation is better. Ideal? No, but better, some say significantly. In recent days, even some steps toward the political reconciliation. Is Iraq today better off than it was six months or a year ago because of the surge? SEN. CLINTON: Well, John, I think you forget a very important premise of the surge. The rationale of the surge was to create the space and time for the Iraqi government to make the decisions that only it can make. Now, there is no doubt, given the skill and the commitment of our young men and women in uniform, that putting more of them in will give us a tactical advantage and will provide security in some places. And that has occurred. But the fact is that the purpose of it has not been fulfilled. The Iraqi government has slowly inched toward making a few of the decisions in a less than complete way. It was one of the reasons why the economy was booming. I've got that, you know, clearly in my economic blueprint, which is something that I've published the last few days, because it's part of what we have to do again, and I think that I will be very comfortable and effective in taking on Senator McCain over the fiscal irresponsibility of the Republican Party that he's been a part of. (Applause.) MS. BROWN: All right. An issue relating to the current election. Jorge. MR. RAMOS: As we can see, this has been an extremely close nomination battle that will come down to superdelegates. And House Speaker Nancy Pelosi, the highest-ranking Democrat in government, said recently -- and I'm quoting -- "It would be a problem" -- and this is a question for you, Senator Clinton -- "It would be a problem for the party if the verdict would be something different than the public has decided." Do you agree? SEN. CLINTON: Well, you know, these are the rules that are followed, and I -- you know, I think that it'll sort itself out. I'm not worried about that. We will have a nominee, and we will a unified Democratic Party, and we will go on to victory in November. (Cheers, applause.) MS. BROWN: Senator Obama, go ahead. Do you have a response to Senator Clinton? SEN. OBAMA: Well, I think it is important, given how hard Senator Clinton and I have been working, that these primaries and caucuses count for something. (Applause.) And so my belief is that -- that the will of the voters, expressed in this long election process, is what ultimately determine who our next nominee is going to be. But understand what I think is most important to the voters, and that is that we have a government that is listening to them again. They feel as if they've been shut out. You know, when I meet mothers who are trying to figure out how to get health care for their kids, it's not just the desperation of that single mom. It's also that when they try to find some help, oftentimes they're hitting a brick wall. And they don't get a sense that the debates that are happening in Washington right now relate to them at all. What they believe is that people are trying to get on TV, and they're trying to score points, and they're trying to win elections, and that they're not interested in knocking down the barriers that stand between the American people and their dreams. And I have no doubt that the Democratic Party, at its best, can summon a sense of common purpose again, and higher purpose, for the American people. And I think that the next nominee, going into the November election, is going to have a lot to talk about, because the American people are tired of a politics that's dominated by the powerful, by the connected. They want their government back, and that's what I intend to provide them when I'm nominated for president of the United States. MS. BROWN: We have time for just one final question and we thought we'd sort of end on a more philosophical question. You've both spent a lot of time talking about leadership, about who's ready and who has the right judgment to lead if elected president. And a leader's judgment is -- is most tested at times of crisis. And I'm wondering if both of you will describe what was a moment -- what was THE moment that tested you the most, that moment of crisis? Senator Obama. SEN. OBAMA: Well, you know, I -- I wouldn't point to a single moment, and what I look at is the trajectory of my life, because I was raised by a single mom. My father left when I was two, and I was raised by my mother and my grandparents. And there were rocky periods during my youth when I made mistakes and was off course. And what was most important in my life was learning to take responsibility for my own -- my own actions -- learning to take responsibility for not only my own actions, but how I can bring people together to actually have an impact on the world. And so working as a community organizer on the streets of Chicago with ordinary people, bringing them together and organizing them to provide jobs and health care and economic security to people who didn't have it, then working as a civil rights attorney and rejecting the jobs on Wall Street to fight for those who were being discriminated against on the job, that cumulative experience I think is the judgment that I now bring. It's the reason that I have the capacity to bring people together, and it's the reason why I am determined to make sure that the American people get a government that is worthy of their decency and their generosity. (Applause.) MS. BROWN: Senator Clinton. SEN. CLINTON: Well, I think everybody here knows I have lived through some crises and some challenging -- (laughter) -- moments in my life, and -- (interrupted by cheers, applause). And I am grateful for the support and the prayers of countless Americans. But people often ask me, how do you do it, you know, how do you keep going, and I just have to shake my head in wonderment because with all of the challenges that I've had, they are nothing compared to what I see happening in the lives of Americans every single day. You know, a few months ago I was honored to be asked, along with Senator McCain, as the only two elected officials to speak at the opening of the Intrepid Center at Brooke Medical Center in San Antonio, a center designed to take care of and provide rehabilitation for our brave young men and women who have been injured in war. And I remember sitting up there and watching them come in: those who could walk were walking; those who had lost limbs were trying with great courage to get themselves in without the help of others; some were in wheelchairs and some were on gurneys. And the speaker representing these wounded warriors had had most of his face disfigured by the results of fire from a roadside bomb. You know, the hits I've taken in life are nothing compared to what goes on every single day in the lives of people across our country. And I resolved at a very young age that I'd been blessed, and that I was called by my faith and by my upbringing to do what I could to give others the same opportunities and blessings that I took for granted. That's what gets me up in the morning. That's what motivates me in this campaign. (Cheers, applause.) And -- and you know, no matter what happens in this contest -- and I am honored. I am honored to be here with Barack Obama. I am absolutely honored. (Cheers, applause.) SEN. OBAMA: (Off mike.) SEN. CLINTON: And you know, whatever happens, we're going to be fine. You know, we have strong support from our families and our friends. I just hope that we'll be able to say the same thing about the American people, and that's what this election should be about. Thanks. (Cheers, applause.) MS. BROWN: All right. A standing ovation here in Austin, Texas. Our thanks to Senator Barack Obama and Senator Hillary Clinton. Appreciate your time tonight -- (cheers, applause) -- and to John and Jorge as well. (Applause continues.) We also want to thank our debate partners, the university, the University of Texas at Austin, and the Texas Democratic Party and the LBJ Library, as well as the city of Austin. Stay with CNN on March 4th for complete coverage of the primary results in Texas, Ohio, Vermont, Rhode Island. I'm Campbell Brown in Austin. This debate will be broadcast in Spanish later tonight on the Univision television network. It'll air at 11:30 p.m. Eastern and 10:30 p.m. Central.
