# Presidential Debate in Coral Gables, Florida

**Date:** September 30, 2004
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-coral-gables-florida

---

Jim Lehrer. Good evening from the University of Miami Convocation Center in Coral Gables, Florida. I'm Jim Lehrer of the News Hour on PBS. And I welcome you to the first of the 2004 Presidential debates between President George W. Bush, the Republican nominee, and Senator John Kerry, the Democratic nominee. These debates are sponsored by the Commission on Presidential Debates. Tonight's will last 90 minutes, following detailed rules of engagement worked out by representatives of the candidates. I have agreed to enforce their rules on them. The umbrella topic is foreign policy and homeland security. But the specific subjects were chosen by me. The questions were composed by me. The candidates have not been told what they are, nor has anyone else. For each question, there can only be a 2-minute response, a 90-second rebuttal, and at my discretion, a discussion extension of 1 minute. A green light will come on when 30 seconds remain in any given answer, yellow at 15, red at 5 seconds, and then flashing red means time's up. There is also a backup buzzer system if needed. Candidates may not direct a question to each other. There will be 2-minute closing statements but no opening statements. There is an audience here in the hall, but they will remain absolutely silent for the next 90 minutes, except for now, when they join me in welcoming President Bush and Senator Kerry. [Applause] Good evening, Mr. President, Senator Kerry. As determined by a coin toss, the first question goes to you, Senator Kerry. You have 2 minutes. Preventing Future Terrorist Attacks Do you believe you could do a better job than President Bush in preventing another 9/11-type terrorist attack on the United States? Senator Kerry. Yes, I do. But before I answer further, let me thank you for moderating. I want to thank the University of Miami for hosting us. And I know the President will join me in welcoming all of Florida to this debate. You've been through the roughest weeks anybody could imagine. Our hearts go out to you, and we admire your pluck and perseverance. I can make America safer than President Bush has made us. And I believe President Bush and I both love our country equally, but we just have a different set of convictions about how you make America safe. I believe America is safest and strongest when we are leading the world and when we are leading strong alliances. I'll never give a veto to any country over our security, but I also know how to lead those alliances. This President has left them in shatters across the globe, and we're now 90 percent of the casualties in Iraq and 90 percent of the costs. I think that's wrong, and I think we can do better. I have a better plan for homeland security. I have a better plan to be able to fight the war on terror: by strengthening our military; strengthening our intelligence; by going after the financing more authoritatively; by doing what we need to do to rebuild the alliances; by reaching out to the Muslim world, which the President has almost not done; and beginning to isolate the radical Islamic Muslims, not have them isolate the United States of America. I know I can do a better job in Iraq, where I have a plan to have a summit with all of the allies, something this President has not yet achieved, not yet been able to do to bring people to the table. We can do a better job of training the Iraqi forces to defend themselves. And I know that we can do a better job of preparing for elections. All of these, and especially homeland security, which we'll talk about a little bit later. Mr. Lehrer. Mr. President, you have a 90-second rebut. President Bush. I too thank the University of Miami and say our prayers are with the good people of this State who've suffered a lot. September the 11th changed how America must look at the world. And since that day, our Nation has been on a multipronged strategy to keep our country safer. We've pursued Al Qaida wherever Al Qaida tries to hide; 75 percent of known Al Qaida leaders have been brought to justice. The rest of them know we're after them. We've upheld the doctrine that said, "If you harbor a terrorist, you're equally as guilty as the terrorist." And the Taliban, no longer in power; 10 million people have registered to vote in Afghanistan in the upcoming Presidential election. In Iraq, we saw a threat, and we realized that after September the 11th, we must take threats seriously before they fully materialize. Saddam Hussein now sits in a prison cell. America and the world are safer for it. We continue to pursue our policy of disrupting those who proliferate weapons of mass destruction. Libya has disarmed. The A.Q. Khan network has been brought to justice. And as well, we're pursuing a strategy of—of freedom around the world, because I understand free nations will reject terror; free nations will answer the hopes and aspirations of their people; free nations will help us achieve the peace we all want. Likelihood of Future Terrorist Attack Mr. Lehrer. New question, Mr. President, 2 minutes. Do you believe the election of Senator Kerry on November the 2d would increase the chances of the U.S. being hit by another 9/11-type terrorist attack? President Bush. No, I don't believe it's going to happen. I believe I'm going to win because the American people know I know how to lead. I've shown the American people I know how to lead. I have—I understand everybody in this country doesn't agree with the decisions that I've made, and I made some tough decisions. But people know where I stand. People out there listening know what I believe, and that's how best it is to keep the peace. This Nation of ours has got a solemn duty to defeat this ideology of hate, and that's what they are. This is a group of killers who will not only kill here but kill children in Russia, that will attack unmercifully in Iraq hoping to shake our will. We have a duty to defeat this enemy. We have a duty to protect our children and grandchildren. The best way to defeat them is to never waver, to be strong, to use every asset at our disposal, is to constantly stay on the offensive, and at the same time, spread liberty. And that's what people are seeing now is happening in Afghanistan. Ten million citizens have registered to vote. It's a phenomenal statistic, that if given a chance to be free, they will show up at the polls. Forty-one percent of those 10 million are women. In Iraq, no doubt about it, it's tough. It's hard work. It's incredibly hard. You know why? Because an enemy realizes the stakes. The enemy understands a free Iraq will be a major defeat in their ideology of hatred. That's why they're fighting so vociferously. They showed up in Afghanistan when they were there because they tried to beat us, and they didn't. And they're showing up in Iraq for the same reason. They're trying to defeat us. And if we lose our will, we lose. But if we remain strong and resolute, we will defeat this enemy. Mr. Lehrer. Ninety-second response, Senator Kerry. Senator Kerry. I believe in being strong and resolute and determined, and I will hunt down and kill the terrorists, wherever they are. But we also have to be smart, Jim, and smart means not diverting your attention from the real war on terror in Afghanistan against Usama bin Laden and taking it off to Iraq, where the 9/11 Commission confirms there was no connection to 9/11 itself and Saddam Hussein, and where the reason for going to war was weapons of mass destruction, not the removal of Saddam Hussein. This President has made, I regret to say, a colossal error of judgment. And judgment is what we look for in the President of the United States of America. I'm proud that important military figures are supporting me in this race: former Chairman of Joint Chiefs of Staff John Shalikashvili; just yesterday General Eisenhower's son, General John Eisenhower, endorsed me; General—Admiral William Crowe; General Tony McPeak, who ran the Air Force war so effectively for his father. All believe I would make a stronger Commander in Chief. And they believe it because they know I would not take my eye off of the goal, Usama bin Laden. Unfortunately, he escaped in the mountains of Tora Bora. We had him surrounded. But we didn't use American forces, the best trained in the world, to go kill him. The President relied on Afghan warlords that he outsourced that job to. That's wrong. President's Judgment on Foreign Policy Mr. Lehrer. New question, 2 minutes, Senator Kerry. "Colossal" misjudgments— what colossal misjudgments, in your opinion, has President Bush made in these areas? Senator Kerry. Well, where do you want me to begin? [Laughter] First of all, he made the misjudgment of saying to America that he was going to build a true alliance, that he would exhaust the remedies of the United Nations and go through the inspections. In fact, he first didn't even want to do that, and it wasn't until former Secretary of State Jim Baker and General Scowcroft and others pushed publicly and said, "You've got to go to the U.N.," that the President finally changed his mind— his campaign has a word for that—and went to the United Nations. Now, once there, we could have continued those inspections. We had Saddam Hussein trapped. He also promised America that he would go to war as a last resort. Those words mean something to me, as somebody who has been in combat, "last resort." You've got to be able to look in the eyes of families and say to those parents, "I tried to do everything in my power to prevent the loss of your son and daughter." I don't believe the United States did that, and we pushed our allies aside. And so today, we are 90 percent of the casualties and 90 percent of the cost, $200 billion—$200 billion that could have been used for health care, for schools, for construction, for prescription drugs for seniors, and it's in Iraq. And Iraq is not even the center of the focus of the war on terror. The center is Afghanistan where, incidentally, there were more Americans killed last year than the year before, where the opium production is 75 percent of the world's opium production, where 40 to 60 percent of the economy of Afghanistan is based on opium, where the elections have been postponed 3 times. The President moved the troops, so he's got 10 times the number of troops in Iraq than he has in Afghanistan, where Usama bin Laden is. Does that mean that Saddam Hussein was 10 times more important than Usama bin Laden— excuse me—Saddam Hussein more important than Usama bin Laden? I don't think so. Mr. Lehrer. Ninety-second response, Mr. President. President Bush. My opponent looked at the same intelligence I looked at and declared, in 2002, that Saddam Hussein was a grave threat. He also said, in December of 2003, that anyone who doubts that the world is safer without Saddam Hussein does not have the judgment to be President. I agree with him. The world is better off without Saddam Hussein. I was hoping diplomacy would work. I understand the serious consequences of committing our troops into harm's way. It's the hardest decision a President makes. So I went to the United Nations. I didn't need anybody to tell me to go to the United Nations; I decided to go there myself. And I went there hoping that, once and for all, the free world would act in concert to get Saddam Hussein to listen to our demands. And they passed a resolution that said, "Disclose, disarm, or face serious consequences." I believe when an international body speaks, it must mean what it says. But Saddam Hussein had no intention of disarming. Why should he? He had 16 other resolutions, and nothing took place. As a matter of fact—my opponent talks about inspectors—the facts are that he was systematically deceiving the inspectors. That wasn't going to work. That's kind of a pre-September-10th mentality, to hope that somehow resolutions and failed inspections would make this world a more peaceful place. He was hoping we'd turn away. But there was, fortunately, others beside myself who believed that we ought to take action, and we did. The world is safer without Saddam Hussein. Priorities in the War on Terror Mr. Lehrer. New question, Mr. President, 2 minutes. What about Senator Kerry's point, the comparison he drew between the priorities of going after Usama bin Laden and going after Saddam Hussein? President Bush. Jim, we've got the capability of doing both. As a matter of fact, this is a global effort. We're facing a— a group of folks who have such hatred in their heart, they'll strike anywhere with any means. And that's why it's essential that we have strong alliances, and we do. That's why it's essential that we make sure that we keep weapons of mass destruction out of the hands of people like Al Qaida, which we are. But to say that there's only one focus on the war on terror doesn't really understand the nature of the war on terror. Of course we're after Saddam Hussein— I mean, bin Laden. He's—he's isolated. Seventy-five percent of his people have been brought to justice. The killer in—the mastermind of the September the 11th attacks, Khalid Sheik Mohammad, is in prison. We're making progress, but the front on this war is more than just one place. The Philippines—we've got help—we're helping them there to bring—to bring Al Qaida affiliates to justice there. And of course Iraq is a central part of the war on terror. That's why Zarqawi and his people are trying to fight us. Their hope is that we grow weary and we leave. The biggest disaster that could happen is that we not succeed in Iraq. We will succeed. We've got a plan to do so, and the main reason we'll succeed is because the Iraqis want to be free. I had the honor of visiting with Prime Minister Allawi. He's a strong, courageous leader. He believes in the freedom of the Iraqi people. He doesn't want U.S. leadership, however, to send mixed signals, to not stand with the Iraqi people. He believes, like I believe, that the Iraqis are ready to fight for their own freedom. They just need the help to be trained. There will be elections in January. We're spending reconstruction money. And our alliance is strong. That's the plan for victory. And when Iraq is free, America will be more secure. Mr. Lehrer. Senator Kerry, 90 seconds. Senator Kerry. The President just talked about Iraq as a center of the war on terror. Iraq was not even close to the center of the war on terror before the President invaded it. The President made the judgment to divert forces from under General Tommy Franks from Afghanistan before the Congress even approved it, to begin to prepare to go to war in Iraq. And he rushed to war in Iraq without a plan to win the peace. Now, that is not the judgment that a President of the United States ought to make. You don't take America to war unless you have a plan to win the peace. You don't send troops to war without the body armor that they need. I've met kids in Ohio, parents in Wisconsin, places—Iowa, where they're going out on the Internet to get the state-of-the-art body gear to send to their kids—some of them have got them for a birthday present. I think that's wrong. Humvees—10,000 out of 12,000 Humvees that are over there aren't armored. And you go visit some of those kids in the hospitals today who were maimed because they don't have the armament. This President just—I don't know if he sees what's really happening out there, but it's getting worse by the day—more soldiers killed in June than before, more in July than June, more in August than July, more in September than in August. And now we see beheadings, and we've got weapons of mass destruction crossing the border every single day, and they're blowing people up. And we don't have enough troops there. President Bush. Can I respond? Mr. Lehrer. Let's do a—one of these one-minute extensions. You have 30 seconds. President Bush. Thank you, sir. First of all, what my opponent wants you to forget is that he voted to authorize the use of force and now says, "It's the wrong war at the wrong time at the wrong place." I don't see how you can lead this country to succeed in Iraq if you say "wrong war, wrong time, wrong place." What message does that send our troops? What message does that send our allies? What message does that send the Iraqis? No, the way to win this is to be steadfast and resolved and to follow through on the plan that I've just outlined. Mr. Lehrer. Thirty seconds, Senator. Senator Kerry. Yes, we have to be steadfast and resolved, and I am. And I will succeed for those troops, now that we're there. We have to succeed. We can't leave a failed Iraq. But that doesn't mean it wasn't a mistake of judgment to go there and take the focus off of Usama bin Laden. It was. Now, we can succeed, but I don't believe this President can. I think we need a President who has the credibility to bring the allies back to the table and to do what's necessary to make it so America isn't doing this alone. Homeland Security Mr. Lehrer. We'll come back to Iraq in a moment, but I want to come back to where I began, on homeland security. This is a 2-minute new question. Senator Kerry, as President, what would you do specifically, in addition to or differently, to increase the homeland security of the United States, than what President Bush is doing? Senator Kerry. Jim, let me tell you exactly what I'll do, and there are a long list of things. First of all, what kind of mixed message does it send when you've got $500 million going over to Iraq to put police officers in the streets of Iraq and the President is cutting the COPS program in America? What kind of message does it send to be sending money to open firehouses in Iraq, but we're shutting firehouses, who are the first-responders, here in America? The President hasn't put one nickel— not one nickel—into the effort to fix some of our tunnels and bridges and most exposed subway systems. That's why they had to close down the subway in New York when the Republican Convention was there. We hadn't done the work that ought to be done. The President—95 percent of the containers that come into the ports, right here in Florida, are not inspected. Civilians get onto aircraft, and their—their luggage is X-rayed, but the cargo hold is not X-rayed. Does that make you feel safer in America? This President thought it was more important to give the wealthiest people in America a tax cut rather than invest in homeland security. Those aren't my values. I believe in protecting America first. And long before President Bush and I get a tax cut—and that's who gets it—long before we do, I'm going to invest in homeland security, and I'm going to make sure we're not cutting COPS programs in America, and we're fully staffed at our firehouses and that we protect the nuclear and chemical plants. The President also, unfortunately, gave in to the chemical industry, which didn't want to do some of the things necessary to strengthen our chemical plant exposure. And there's an enormous undone job to protect the loose nuclear materials in the world that are able to get to terrorists. That's a whole other subject, but—I see we still have a little bit more time. Let me just quickly say, at the current pace the President will not secure the loose material in the Soviet Union—former Soviet Union for 13 years. I'm going to do it in 4 years. And we're going to keep it out of the hands of terrorists. Mr. Lehrer. Ninety-second response, Mr. President. President Bush. I don't think we want to get to how he's going to pay for all these promises. It's like a huge tax gap and—anyway, that's for another debate. My administration has tripled the amount of money we're spending on homeland security, to $30 billion a year. My administration worked with the Congress to create the Department of Homeland Security so we could better coordinate our borders and ports. We've got 1,000 extra Border Patrol on the southern border, more than 1,000 on the northern border. We're modernizing our borders. We've spent $3.1 billion for fire and police—$3.1 billion. We're doing our duty to provide the funding. But the best way to protect this homeland is to stay on the offense. We have to be right 100 percent of the time, and the enemy only has to be right once to hurt us. There's a lot of good people working hard. And by the way, we've also changed the culture of the FBI to have counterterrorism as its number one priority. We're communicating better. We're going to reform our intelligence services to make sure that we get the best intelligence possible. The PATRIOT Act is vital. It's vital that the Congress renew the PATRIOT Act, which enables our law enforcement to disrupt terrorist cells. But again, I repeat to my fellow citizens, the best way to protect you is to stay on the offense. Mr. Lehrer. Yes, let's do a little—yes, 30 seconds. Senator Kerry. The President just said the FBI had changed its culture. We just read on the front pages of America's papers that there are over 100,000 hours of tapes unlistened to. On one of those tapes may be the enemy being right the next time. And the test is not whether you're spending more money. The test is, are you doing everything possible to make America safe? We didn't need that tax cut. America needed to be safe. President Bush. Of course we're doing everything we can to protect America. I wake up every day thinking about how best to protect America. That's my job. I work with Director Mueller of the FBI. He comes into my office, when I'm in Washington, every morning talking about how to protect us. There's a lot of really good people working hard to do so. It's hard work. But again, I want to tell the American people, we're doing everything we can at home, but you better have a President who chases these terrorists down and bring them to justice before they hurt us again. Criteria for Withdrawal of U.S. Troops From Iraq Mr. Lehrer. New question, Mr. President, 2 minutes. What criteria would you use to determine when to start bringing U.S. troops home from Iraq? President Bush. Let me first tell you that the best way for Iraq to be safe and secure is for Iraqi citizens to be trained to do the job. And that's what we're doing. We got 100,000 trained now, 125,000 by the end of this year, over 200,000 by the end of next year. That is the best way. We'll never succeed in Iraq if the Iraqi citizens do not want to take matters into their own hands and protect themselves. I believe they want to. Prime Minister Allawi believes they want to. And so the best indication about when we can bring our troops home—which I really want to do, but I don't want to do so for the sake of bringing them home; I want to do so because we've achieved an objective—is to see the Iraqis perform, is to see the Iraqis step up and take responsibility. And so the answer to your question is, when our generals on the ground and Ambassador Negroponte tells me that Iraq is ready to defend herself from these terrorists, that elections will have been held by then, that there's stability, and that they're on their way to—you know, a nation of— that's free. That's when. And I hope it's as soon as possible. But I know putting artificial deadlines won't work. My opponent one time said, "Well, get me elected, I'll have them out of there in 6 months." That's—you can't do that and expect to win the war on terror. My message to our troops is: Thank you for what you're doing; we're standing with you strong; we'll give you all the equipment you need; and we'll get you home as soon as the mission's done, because this is a vital mission. A free Iraq will be a ally in the war on terror, and that's essential. A free Iraq will set a powerful example in the part of the world that is desperate for freedom. A free Iraq will help secure Israel. A free Iraq will enforce the hopes and aspirations of the reformers in places like Iran. A free Iraq is essential for the security of this country. Mr. Lehrer. Ninety seconds, Senator Kerry. Senator Kerry. Thank you, Jim. My message to the troops is also "Thank you" for what they're doing, but it's also, "Help is on the way." I believe those troops deserve better than what they are getting today. You know, it's interesting, when I was in the ropeline just the other day coming out here from Wisconsin, a couple of young returnees were in the line, one active duty, one from the Guard. And they both looked at me and said, "We need you. You've got to help us over there." Now, I believe there's a better way to do this. You know, the President's father did not go into Iraq—into Baghdad, beyond Basra. And the reason he didn't is, he said—he wrote in his book, because there was no viable exit strategy. And he said our troops would be occupiers in a bitterly hostile land. That's exactly where we find ourselves today. There's a sense of American occupation. The only building that was guarded when the troops went into Baghdad was the oil ministry. We didn't guard the nuclear facilities. We didn't guard the foreign office, where you might have found information about weapons of mass destruction. We didn't guard the borders. Almost every step of the way, our troops have been left on these extraordinarily difficult missions. I know what it's like to go out on one of those missions where you don't know what's around the corner. And I believe our troops need other allies helping. I'm going to hold that summit. I will bring fresh credibility, a new start, and we will get the job done right. Mr. Lehrer. New—— President Bush. Jim—— Mr. Lehrer. All right, go ahead. Yes, sir. President Bush. I think it's worthy for a followup—— Mr. Lehrer. Sure. President Bush. ——if you don't mind. Senator Kerry. Let's change the rules. We can add a whole—[inaudible]. Mr. Lehrer. We can do 30 seconds each here. President Bush. All right. My opponent says, "Help is on the way," but what kind of message does it say to our troops in harm's way, "wrong war, wrong place, wrong time"? That's not a message a Commander in Chief gives—or "This is a great diversion." As well, help is on the way, but it's certainly hard to tell it when he voted against the $87 billion supplemental to provide equipment for our troops and then said he actually did vote for it before he voted against it. That's not what Commander in Chiefs does when you're trying to lead troops. Mr. Lehrer. Senator Kerry, 30 seconds. Senator Kerry. Well, you know, when I talked about the $87 billion, I made a mistake in how I talk about the war. But the President made a mistake in invading Iraq. Which is worse? I believe that when you know something's going wrong, you make it right. That's what I learned in Vietnam. When I came back from that war, I saw that it was wrong. Some people don't like the fact that I stood up to say no, but I did. And that's what I did with that vote. And I'm going to lead those troops to victory. Planning and International Cooperation in Iraq Mr. Lehrer. All right, new question, 2 minutes, Senator Kerry. Speaking of Vietnam, you spoke to Congress in 1971, after you came back from Vietnam, and you said, quote, "How do you ask a man to be the last man to die for a mistake?" Are Americans now dying in Iraq for a mistake? Senator Kerry. No, and they don't have to, providing we have the leadership that we put—that I'm offering. I believe that we have to win this. The President and I have always agreed on that. And from the beginning, I did vote to give the authority because I thought Saddam Hussein was a threat. And I did accept that—that intelligence. But I also laid out a very strict series of things we needed to do in order to proceed from the position of strength, and the President, in fact, promised them. He went to Cincinnati, and he gave a speech in which he said, "We will plan carefully. We will proceed cautiously. We will not make war inevitable. We will go with our allies." He didn't do any of those things. They didn't do the planning. They left the planning of the State Department on the State Department desks. They avoided even the advice of their own general. General Shinseki, the Army Chief of Staff, said, "You're going to need several hundred thousand troops." Instead of listening to him, they retired him. The terrorism czar, who has worked for every President since Ronald Reagan, said, "Invading Iraq in response to 9/11 would be like Franklin Roosevelt invading Mexico in response to Pearl Harbor." That's what we have here. And what we need now is a President who understands how to bring these other countries together to recognize their stakes in this. They do have stakes in it. They've always had stakes in it. The Arab countries have a stake in not having a civil war. The European countries have a stake in not having total disorder on their doorstep. But this President hasn't even held the kind of statesmanlike summits that pull people together and get them to invest in those stakes. In fact, he's done the opposite; he pushed them away. When the Secretary-General, Kofi Annan, offered the United Nations, he said, "No, no, we'll go do this alone." To save for Halliburton the spoils of the war, they actually issued a memorandum from the Defense Department saying, "If you weren't with us in the war, don't bother applying for any construction." That's not a way to invite people. Mr. Lehrer. Ninety seconds. President Bush. That's totally absurd. Of course the U.N. was invited in, and we support the U.N. efforts there. They pulled out after Sergio de Mello got killed, but they're now back in, helping with elections. My opponent says we didn't have any allies in this war? What's he say to Tony Blair? What's he say to Aleksander Kwasniewski of Poland? I mean, you can't expect to build an alliance when you denigrate the contributions of those who are serving side by side with American troops in Iraq. Plus, he says the cornerstone of his plan to succeed in Iraq is to call upon nations to serve. So what's the message going to be? "Please join us in Iraq for a grand diversion"? "Join us for a war that is a wrong war at the wrong place at the wrong time"? I know how these people think. I deal with them all the time. I sit down with the world leaders frequently and talk to them on the phone frequently. They're not going to follow somebody who says this is "the wrong war at the wrong place at the wrong time." They're not going to follow somebody whose core convictions keep changing because of politics in America. And finally, he says we ought to have a summit. Well, there are summits being held. Japan is going to have a summit for the donors. There's $14 billion pledged, and Prime Minister Koizumi is going to call countries to account to get them to contribute. And there's going to be an Arab summit of the neighborhood countries, and Colin Powell helped set up that summit. Mr. Lehrer. Thirty seconds, Senator. Senator Kerry. The United Nations' Kofi Annan offered help after Baghdad fell. And we never picked him up on that and did what was necessary to transfer authority and to transfer reconstruction. It was always American-run. Secondly, when we went in, there were three countries, Great Britain, Australia, and the United States. That's not a grand coalition. We can do better. Mr. Lehrer. Thirty seconds, Mr. President. President Bush. Well, actually, he forgot Poland. And now, there are 30 nations involved, standing side by side with our American troops, and I honor their sacrifices. And I don't appreciate it when a candidate for President denigrates the contributions of these brave—brave soldiers. It's—you cannot lead the world if you do not honor the contributions of those who are with us. He called them the "coerced and the bribed." That's not how you bring people together. Our coalition is strong. It will remain strong, for my—so long as I'm the President. Postwar Iraq Mr. Lehrer. New question, Mr. President, 2 minutes. You have said there was a, quote, "miscalculation of what the conditions would be in postwar Iraq." What was the miscalculation, and how did it happen? President Bush. No, what I said was that because we achieved such a rapid victory, more of the Saddam loyalists were around. In other words, we thought we'd whip more of them going in. But because Tommy Franks did such a great job in planning the operations, we moved rapidly, and a lot of the Ba'athists and Saddam loyalists laid down their arms and disappeared. I thought we would—they would stay and fight, but they didn't. And now we're fighting them now. It's—and it's hard work. I understand how hard it is. I get the casualty reports every day. I see on the TV screens how hard it is, but it's necessary work. And I'm optimistic. See, I think you can be realistic and optimistic at the same time. I'm optimistic we'll achieve—I know we won't achieve if we send mixed signals. I know we're not going to achieve our objective if we send mixed signals to our troops, our friends, the Iraqi citizens. We've got a plan in place. The plan says there'll be elections in January, and there will be. The plan says we'll train Iraqi soldiers so they can do the hard work, and we are. And it's not only just America, but NATO is now helping. Jordan is helping train police. The UAE is helping train police. We've allocated $7 billion over the next months for reconstruction efforts, and we're making progress there. And our alliance is strong. Now, I just told you, there's going to be a summit of the Arab nations. Japan will be hosting a summit. We're making progress. It is hard work. It is hard work to go from a tyranny to a democracy. It's hard work to go from a place where people get their hands cut off or executed, to a place where people are free. But it's necessary work, and a free Iraq is going to make this world a more peaceful place. Mr. Lehrer. Ninety seconds, Senator Kerry. Senator Kerry. What I think troubles a lot of people in our country is that the President has just sort of described one kind of mistake, but what he has said is that even knowing there were no weapons of mass destruction, even knowing there was no imminent threat, even knowing there was no connection of Al Qaida, he would still have done everything the same way. Those are his words. Now, I would not. So what I'm trying to do is just talk the truth to the American people and to the world. Truth is what good policy is based on. It's what leadership is based on. The President says that I'm denigrating these troops. I have nothing but respect for the British and for Tony Blair and for what they've been willing to do. But you can't tell me that when the most troops any other country has on the ground is Great Britain with 8,300, and below that, the 4 others are below 4,000, and below that, there isn't anybody out of the hundreds, that we have a genuine coalition to get this job done. You can't tell me that on the day that we went into that war and it started, it was principally the United States, the—America and Great Britain and one or two others; that's it. And today we are 90 percent of the casualties and 90 percent of the costs. And meanwhile, North Korea has gotten nuclear weapons. Talk about mixed messages, the President is the one who said we can't allow countries to get nuclear weapons. They have. I'll change that. Candidates' Candor and Consistency Mr. Lehrer. New question, Senator Kerry, 2 minutes. You've just—you've repeatedly accused President Bush, not here tonight but elsewhere before, of not telling the truth about Iraq, essentially of lying to the American people about Iraq. Give us some examples of what you consider to be his not telling the truth. Senator Kerry. Well, I've never, ever used the harshest word, as you did just then, and I try not to. I've been—but I'll, nevertheless, tell you that I think he has not been candid with the American people, and I'll tell you exactly how. First of all, we all know that in his State of the Union Message he told Congress about nuclear materials that didn't exist. We know that he promised America that he was going to build this coalition. I just described the coalition. It is not the kind of coalition we were described when we were talking about voting for this. The President said he would exhaust the remedies of the United Nations and go through that full process. He didn't. He cut it off, sort of arbitrarily. And we know that there were further diplomatics—efforts underway. They just decided the time for diplomacy is over and rushed to war without planning for what happens afterwards. Now, he misled the American people in his speech when he said, "We will plan carefully." They obviously didn't. He misled the American people when he said, "We'd go to war as a last resort." We did not go as a last resort. And most Americans know the difference. Now, this has cost us deeply in the world. I believe that it is important to tell the truth to the American people. I've worked with those leaders the President talks about. I've worked with them for 20 years, for longer than this President, and I know what many of them say today, and I know how to bring them back to the table. And I believe that fresh start, new credibility, a President who can understand what we have to do to reach out to the Muslim world, to make it clear that this is not— you know, Usama bin Laden uses the invasion of Iraq in order to go out to people and say the—America has declared war on Islam. We need to be smarter about how we wage a war on terror. We need to deny them the recruits. We need to deny them the safe havens. We need to rebuild our alliances. I believe that Ronald Reagan, John Kennedy, and others did that more effectively, and I'm going to try to follow in their footsteps. Mr. Lehrer. Ninety seconds, Mr. President. President Bush. My opponent just said something amazing. He said Usama bin Laden uses the invasion of Iraq as an excuse to spread hatred for America. Usama bin Laden isn't going to determine how we defend ourselves. Usama bin Laden doesn't get to decide. The American people decide. I decided. The right action was in Iraq. My opponent calls it a mistake. It wasn't a mistake. He said I misled on Iraq. I don't think he was misleading when he called Iraq a grave threat in the fall of 2002. I don't think he was misleading when he said that it was right to disarm Iraq in the spring of 2003. I don't think he misled you when he said that if—anyone who doubted whether the world was better off without Saddam Hussein in power didn't have the judgment to be President. I don't think he was misleading. I think what is misleading is to say you can lead and succeed in Iraq if you keep changing your positions on this war, and he has. As the politics change, his positions change, and that's not how a Commander in Chief acts. I—let me finish. The intelligence I looked at was the same intelligence my opponent looked at, the very same intelligence. And when I stood up there and spoke to the Congress, I was speaking off the same intelligence he looked at to make his decisions to support the authorization of force. Mr. Lehrer. Thirty seconds—we'll do a 30-second here. Senator Kerry. I wasn't misleading when I said he was a threat. Nor was I misleading on the day that the President decided to go to war when I said that he had made a mistake in not building strong alliances and that I would have preferred that he did more diplomacy. I've had one position, one consistent position, that Sad-dam Hussein was a threat; there was a right way to disarm him and a wrong way. And the President chose the wrong way. Mr. Lehrer. Thirty seconds, Mr. President. President Bush. The only thing consistent about my opponent's position is that he's been inconsistent. He changes positions. And you cannot change positions in this war on terror if you expect to win. And I expect to win. It's necessary we win. We're being challenged like never before, and we have a duty to our country and to future generations of America to achieve a free Iraq, a free Afghanistan, and to rid the world of weapons of mass destruction. Hard Decisions/Support for the Military Mr. Lehrer. New question, Mr. President, 2 minutes. Has the war in Iraq been worth the cost in American lives? Ten thousand fifty two—I mean, 1,052 as of today. President Bush. No, every life is precious. Every life matters. You know, my hardest—the hardest part of the job is to know that I committed the troops in harm's way and then do the best I can to provide comfort for the loved ones who lost a son or a daughter or a husband and wife. And you know, I think about Missy Johnson, who is a fantastic young lady I met in Charlotte, North Carolina, she and her son, Bryan. They came to see me. Her husband, P.J., got killed. He'd been in Afghanistan, went to Iraq. You know, it's hard work to try to love her as best as I can, knowing full well that the decision I made caused her loved one to be in harm's way. I told her, after we prayed and teared up and laughed some, that I thought her husband's sacrifice was noble and worthy, because I understand the stakes of this war on terror. I understand that we must find Al Qaida wherever they hide. We must deal with threats before they fully materialize— and Saddam Hussein was a threat—and that we must spread liberty, because in the long run, the way to defeat hatred and tyranny and oppression is to spread freedom. Missy understood that. That's what she told me her husband understood. So you say, was it worth it? Every life is precious. That's what distinguishes us from the enemy. Everybody matters. But I think it's worth it, Jim. I think it's worth it because I think—I know in the long term, a free Iraq, a free Afghanistan will set such a powerful example in the part of the world that's desperate for freedom— it will help change the world—that we can look back and say, "We did our duty." Mr. Lehrer. Senator, 90 seconds. Senator Kerry. I understand what the President is talking about, because I know what it means to lose people in combat. And the question, is it worth the cost, reminds me of my own thinking when I came back from fighting in that war, and it reminds me that it is vital for us not to confuse the war, ever, with the warriors. That happened before. And that's one of the reasons why I believe I can get this job done, because I am determined, for those soldiers and for those families, for those kids who put their lives on the line—that is noble. That's the most noble thing that anybody can do. And I want to make sure the outcome honors that nobility. Now, we have a choice here. I've laid out a plan by which I think we can be successful in Iraq, with a summit, by doing better training faster, by cutting—by doing what we need to do with respect to the U.N. and the elections. There's only 25 percent of the people in there. They can't have an election right now. The President is not getting the job done. So the choice for America is, you can have a plan that I've laid out in four points, each of which I can tell you more about, or you can go to johnkerry.com and see more of it, or you have the President's plan, which is four words, "More of the same." I think my plan is better. And my plan has a better chance of standing up and fighting for those troops. I will never let those troops down and will hunt and kill the terrorists, wherever they are. Mr. Lehrer. New—all right, sir, go ahead. Thirty seconds. President Bush. I understand what it means to be the Commander in Chief, and if I were to ever say this is the wrong war at the wrong time at the right—wrong place, the troops would wonder, "How can I follow this guy?" You cannot lead the war on terror if you keep changing positions on the war on terror and say things like, "Well, this is just a grand diversion." It's not a grand diversion. This is an essential, that we get it right. And so I—the plan he talks about simply won't work. Mr. Lehrer. Senator Kerry, you have 30 seconds, right. Senator Kerry. Secretary of State Colin Powell told this President the Pottery Barn rule: If you break it, you fix it. Now, if you break it, you made a mistake. It's the wrong thing to do, but you own it. And then you've got to fix it and do something with it. Now, that's what we have to do. There's no inconsistency. Soldiers know, over there, that this isn't being done right yet. I'm going to get it right for those soldiers, because it's important to Israel. It's important to America. It's important to the world. It's important to the fight on terror. But I have a plan to do it. He doesn't. Timeline for Withdrawal From Iraq/ Conditions in Iraq Mr. Lehrer. Speaking of your plan, new question, Senator Kerry, 2 minutes. Can you give us specifics—in terms of a scenario, timelines, et cetera—for ending U.S.—major U.S. military involvement in Iraq? Senator Kerry. The timeline that I've set out—and again, I want to correct the President, because he's misled again this evening on what I've said. I didn't say I would bring troops out in 6 months. I said, "If we do the things that I've set out, and we are successful, we could begin to draw the troops down in 6 months." And I think a critical component of success in Iraq is being able to convince the Iraqis and the Arab world that the United States doesn't have long-term designs on it. As I understand it, we're building some 14 military bases there now, and some people say they've got a rather permanent concept to them. When you—when you guard the oil ministry but you don't guard the nuclear facilities, the message to a lot of people is, "Maybe—well, maybe they're interested in our oil." Now, the problem is that they didn't think these things through properly, and these are the things you have to think through. What I want to do is change the dynamics on the ground. And you have to do that by beginning to not back off of Fallujahs and other places and send the wrong message to the terrorists. You have to close the borders. You've got to show you're serious in that regard. But you've also got to show that you're prepared to bring the rest of the world in and share the stakes. I will make a flat statement: The United States of America has no long-term designs on staying in Iraq. And our goal, in my administration, would be to get all of the troops out of there, with the minimal amount you need for training and logistics as we do in some other countries in the world after a war to be able to sustain the peace. But that's how we're going to win the peace, by rapidly training the Iraqis themselves. Even the administration has admitted they haven't done the training, because they came to Congress a few weeks ago and asked for a complete reprogramming of the money. Now, what greater admission is there, 16 months afterwards, "Oops, we haven't done the job. We've got to start to spend the money now. Will you guys give us permission to shift it over into training?" Mr. Lehrer. Ninety seconds. President Bush. There's 100,000 troops trained, police, guard, special units, border patrol. There's going to be 125,000 trained by the end of this year. Yes, we're getting the job done. It's hard work. Everybody knows it's hard work because there's a determined enemy that's trying to defeat us. Now, my opponent says he's going to try to change the dynamics on the ground. Well, Prime Minister Allawi was here. He is the leader of that country. He's a brave, brave man. When he came, after giving a speech to the Congress, my opponent questioned his credibility. You can't change the dynamics on the ground if you've criticized the brave leader of Iraq. One of his campaign people alleged that Prime Minister Allawi was like a puppet. That's no way to treat somebody who's courageous and brave, that is trying to lead his country forward. The way to make sure that we succeed is to send consistent, sound messages to the Iraqi people that when we give our word, we will keep our word; that we stand with you; that we believe you want to be free. And I do. I believe that the 25 million people, the vast majority, long to have elections. I reject this notion—and I'm not suggesting that my opponent says it, but I reject the notion that some say that if you're Muslim you can't be free; you don't desire freedom. I disagree, strongly disagree with that. Mr. Lehrer. Thirty seconds. Senator Kerry. I couldn't agree more that the Iraqis want to be free and that they could be free. But I think the President, again, still hasn't shown how he's going to go about it the right way. He has more of the same. Now, Prime Minister Allawi came here, and he said the terrorists are pouring over the border. That's Allawi's assessment. The national intelligence assessment that was given to the President in July said: Best case scenario, more of the same of what we see today; worst case scenario, civil war. I can do better. President Bush. Yes, let me—— Mr. Lehrer. Yes, 30 seconds. President Bush. The reason why Prime Minister Allawi said they're coming across the border is because he recognizes that this is a central part of the war on terror. They're fighting us because they're fighting freedom. They understand that a free Afghanistan or a free Iraq will be a major defeat for them, and those are the stakes. And that's why it is essential we not leave. That's why it's essential we hold the line. That's why it's essential we win, and we will. Under my leadership, we're going to win this war in Iraq. Future U.S. Military Action Mr. Lehrer. Mr. President, a new question, 2 minutes. Does the Iraq experience make it more likely or less likely that you would take the United States into another preemptive military action? President Bush. I would hope I never have to. I understand how hard it is to commit troops. I never wanted to commit troops. I never—when I was running— when we had the debate in 2000, I never dreamt I would be doing that. But the enemy attacked us, Jim, and I have a solemn duty to protect the American people, to do everything I can to protect us. I think that by speaking clearly and doing what we say and not sending mixed messages, it is less likely we'll ever have to use troops. But a President must always be willing to use troops. It must—as a last resort. The—I was hopeful diplomacy would work in Iraq. It was falling apart. There was no doubt in my mind that Saddam Hussein was hoping that the world would turn a blind eye. And if he had been in power—in other words, we had said, "Let's let the inspectors work," or "Let's hope to talk him out; maybe an 18th resolution would work," he'd have been stronger and tougher, and the world would have been a lot worse off. There's just no doubt in my mind. We would rue the day if Saddam Hussein had been in power. So we use diplomacy every chance we get, believe me. And I—I would hope never to have to use force. But by speaking clearly and sending messages that we mean what we say, we've affected the world in a positive way. Look at Libya. Libya was a threat. Libya is now peacefully dismantling its weapons programs. Libya understood that America and others will enforce doctrine, and the world is better for it. So to answer your question, I would hope we'd never have to. I think by acting firmly and decisively, it will mean it's less likely to—less likely we have to use force. Mr. Lehrer. Senator Kerry, 90 seconds. Senator Kerry. Jim, the President just said something extraordinarily revealing and, frankly, very important in this debate. In answer to your question about Iraq and sending people into Iraq, he just said, "The enemy attacked us." Saddam Hussein didn't attack us. Usama bin Laden attacked us. Al Qaida attacked us. And when we had Usama bin Laden cornered in the mountains of Tora Bora, 1,000 of his cohorts with him in those mountains, with the American military forces nearby and in the field, we didn't use the best trained troops in the world to go kill the world's number one criminal and terrorist. They outsourced the job to Afghan warlords who only a week earlier had been on the other side fighting against us, neither of whom trusted each other. That's the enemy that attacked us. That's the enemy that was allowed to walk out of those mountains. That's the enemy that is now in 60 countries with stronger recruits. He also said Saddam Hussein would have been stronger. That is just factually incorrect. Two-thirds of the country was a no-fly zone when we started this war. We would have had sanctions. We would have had the U.N. inspectors. Saddam Hussein would have been continually weakening. If the President had shown the patience to go through another round of resolution, to sit down with those leaders and say, "What do you need? What do you need now? How much more will it take to get you to join us," we would be in a stronger place today. President Bush. First, listen—— Mr. Lehrer. Thirty seconds. President Bush. ——of course I know Usama bin Laden attacked us. I know that. And secondly, to think that another round of resolutions would have caused Saddam Hussein to disarm, disclose is ludicrous, in my judgment. It just shows a significant difference of opinion. We tried diplomacy. We did our best. He was hoping to turn a blind eye, and, yes, he would have been stronger had we not dealt with him. He had the capability of making weapons, and he would have made weapons. Mr. Lehrer. Thirty seconds, Senator. Senator Kerry. Thirty-five to forty countries in the world had a greater capability of making weapons at the moment the President invaded than Saddam Hussein. And while he has been diverted with 9 out of 10 active duty divisions of our Army either going to Iraq, coming back from Iraq, or getting ready to go, North Korea's got nuclear weapons, and the world is more dangerous. Iran is moving towards nuclear weapons, and the world is more dangerous. Darfur has a genocide. The world is more dangerous. I'd have made a better choice. Preemptive Action/International Cooperation Mr. Lehrer. New question, 2 minutes, Senator Kerry. What is your position on the whole concept of preemptive war? Senator Kerry. The President always has the right and always has had the right for preemptive strike. That was a great doctrine throughout the cold war, and it was always one of the things we argued about with respect to arms control. No President, through all of American history, has ever ceded, and nor would I, the right to preempt in any way necessary to protect the United States of America. But if and when you do it, Jim, you've got to do in a way that passes the test, that passes the global test, where your countrymen, your people, understand fully why you're doing what you're doing and you can prove to the world that you did it for legitimate reasons. Here we have our own Secretary of State who's had to apologize to the world for the presentation he made to the United Nations. I mean, we can remember when President Kennedy, in the Cuban missile crisis, sent his Secretary of State to Paris to meet with de Gaulle, and in the middle of the discussion to tell them about the missiles in Cuba, he said, "Here, let me show you the photos." And de Gaulle waved them off and said, "No, no, no, no. The word of the President of the United States is good enough for me." How many leaders in the world today would respond to us, as a result of what we've done, in that way? So what is at test here is the credibility of the United States of America and how we lead the world. Iran and Iraq are now more—Iran and North Korea are now more dangerous. Now, whether preemption is ultimately what has to happen or not, I don't know yet. But I'll tell you this, as President, I'll never take my eye off that ball. I've been fighting for proliferation the entire time—antiproliferation the entire time I've been in the Congress. And we've watched this President actually turn away from some of the treaties that were on the table. You don't help yourself with other nations when you turn away from the global warming treaty, for instance, or when you refuse to deal at length with the United Nations. You have to earn that respect. And I think we have a lot of earning back to do. Mr. Lehrer. Ninety seconds. President Bush. Let me—I'm not exactly sure what you mean, "passes the global test." You take preemptive action if you pass a global test? My attitude is you take preemptive action in order to protect the American people, that you act in order to make this country secure. My opponent talks about me not signing certain treaties. But let me tell you one thing I didn't sign—and I think it shows a difference of our opinion, the difference of opinions—and that is that I wouldn't join the International Criminal Court. This is a body based in The Hague where unaccountable judges and prosecutors could pull our troops, our diplomats up for trial. And I wouldn't join it. And I understand that in certain capitals around the world that that wasn't a popular move. But it's the right move, not to join a foreign court that could—where our people could be prosecuted. My opponent is for joining the International Criminal Court. I just think trying to be popular kind of in the global sense, if it's not in our best interest, makes no sense. I'm interested in working with other nations and do a lot of it. But I'm not going to make decisions that I think are wrong for America. North Korea and Iran Mr. Lehrer. New question. Mr. President, do you believe that diplomacy and sanctions can resolve the nuclear problems with North Korea and Iran? Taking them in any order you would like. President Bush. North Korea, first—I do. Let me say I certainly hope so. Before I was sworn in, the policy of this Government was to have bilateral negotiations with North Korea. And we signed an agreement with North Korea that my administration found out that was not being honored by the North Koreans. And so I decided that a better way to approach the issue was to get other nations involved, just—besides us. And in Crawford, Texas, Jiang Zemin and I agreed that the nuclear-weapons-free North—peninsula—Korean Peninsula was in his interest and our interest and the world's interest. And so we began a new dialog with North Korea, one that included not only the United States but now China. And China has got a lot of influence over North Korea, in some ways more than we do. As well we included South Korea, Japan, and Russia. So now there are five voices speaking to Kim Chong-il, not just one. And so if Kim Chong-il decides again to not honor an agreement, he's not only doing injustice to America, he'd be doing injustice to China as well. And I think this will work. It's not going to work if we open up a dialog with Kim Chong-il. That's what he wants. He wants to unravel the six-party talks—or the five—the five-nation coalition that's sending him a clear message. On Iran, I hope we can do the same thing, continue to work with the world to convince the Iranian mullahs to abandon their nuclear ambitions. We've worked very closely with the Foreign Ministers of France, Germany, and Great Britain, who have been the folks delivering the message to the mullahs that if you expect to be part of the world of nations, get rid of your nuclear programs. The IAEA is involved. There's a special protocol recently been passed that allows for instant inspections. I hope we can do it, and we've got a good strategy. Mr. Lehrer. Senator Kerry, 90 seconds. Senator Kerry. With respect to Iran, the British, French, and Germans were the ones who initiated an effort—without the United States, regrettably—to begin to try to move to deter the nuclear possibilities in Iran. I believe we could have done better. I think the United States should have offered the opportunity to provide the nuclear fuel, test them to see whether or not they were actually looking for it for peaceful purposes. If they weren't willing to work a deal, then we could have put sanctions together. The President did nothing. With respect to North Korea, the real story, we had inspectors and television cameras in the nuclear reactor in North Korea. Secretary Bill Perry negotiated that under President Clinton. And we knew where the fuel rods were, and we knew the limits on their nuclear power. Colin Powell, our Secretary of State, announced one day that we were going to continue the dialog and work with the North Koreans. The President reversed him publicly, while the President of South Korea was here. And the President of South Korea went back to South Korea bewildered and embarrassed because it went against his policy. And for 2 years, this administration didn't talk at all to North Korea. While they didn't talk at all, the fuel rods came out. The inspectors were kicked out. The television cameras were kicked out. And, today, there are four to seven nuclear weapons in the hands of North Korea. That happened on this President's watch. Now, that, I think, is one of the most serious sort of reversals or mixed messages that you could possibly send. Mr. Lehrer. I want to make sure—yes, sir—but in this one minute, I want to make sure that we understand—the people—the people watching you understand the differences between the two of you on this. You want to continue the multinational talks, correct? President Bush. Right. Mr. Lehrer. And you want—you're wanting to do it—— Senator Kerry. Both. I want bilateral talks which put all of the issues from the Armistice of 1952, the economic issues, the human rights issues, the artillery disposal issues, the DMZ issues, and the nuclear issues on the table. Mr. Lehrer. And you're opposed to that, right? President Bush. The minute we have bilateral talks, the six-party talks will unwind. It's exactly what Kim Chong-il wants. And by the way, the breach on the agreement was not to plutonium. The breach on the agreement is highly enriched uranium. That's what we caught him doing. That's where he was breaking the agreement. Secondly, you said—my opponent said that he'd work to put sanctions on Iran. We've already sanctioned Iran. We can't sanction them anymore. There are sanctions in place on Iran. And finally, we were a party to the convincing—to working with Germany, France, and Great Britain to send their Foreign Ministers into Iran. Iran/Sudan Mr. Lehrer. New question, 2 minutes, Senator Kerry. You mentioned Darfur, the Darfur region of Sudan. Fifty thousand people have already died in that area, more than a million are homeless, and it's been labeled an act of ongoing genocide. Yet, neither one of you or anyone else connected with your campaigns or your administration that I can find has discussed the possibility of sending in troops. Why not? Senator Kerry. Well, I'll tell you exactly why not, but I first want to say something about those sanctions on Iran. Only the United States put the sanctions on, alone, and that's exactly what I'm talking about. In order for the sanctions to be effective we should have been working with the British, French, and Germans and other countries. And that's the difference between the President and me. And there again, he sort of slid by the question. Now, with respect to Darfur, yes, it is a genocide. And months ago, many of us were pressing for action. I think the reason that we're not saying send American troops in at this point is several-fold. Number one, we can do this through the African Union, providing we give them the logistical support. Right now, all the President is providing is humanitarian support. We need to do more than that. They've got to have the logistical capacity to go in and stop the killing, and that's going to require more than is on the table today. I also believe that it is—one of the reasons we can't do it is we're overextended. Ask the people in the Armed Forces today. We've got Guards and Reserves who are doing double duties. We've got a backdoor draft taking place in America today, people with stop-loss programs where they're told, "You can't get out of the military," 9 out of our 10 active duty divisions committed to Iraq one way or the other, either going, coming, or preparing. So this is the way the President has overextended the United States. That's why, in my plan, I add two active duty divisions to the United States Army, not for Iraq but for our general demands across the globe. I also intend to double the number of Special Forces so that we can do the job we need to do with respect to fighting the terrorists around the world. And if we do that, then we have the ability to be able to respond more rapidly. But I'll tell you this, as President, if it took American forces, to some degree, to coalesce the African Union, I'd be prepared to do it, because we could never allow another Rwanda. It's a moral responsibility for us in the world. Mr. Lehrer. Ninety seconds. President Bush. Back to Iran, just for a second. It was not my administration that put the sanctions on Iran. That happened long before I arrived in Washington, DC. In terms of Darfur, I agree, it's genocide, and Colin Powell so stated. We have committed $200 million worth of aid. We're the leading donor in the world to help the suffering people there. We will commit more, over time, to help. We were very much involved at the U.N. on the sanction policy of the Bashir Government in the Sudan. Prior to Darfur, Ambassador Jack Danforth had been negotiating a north-south agreement that we would hope would have brought peace to the Sudan. I agree with my opponent that we shouldn't be committing troops, that we ought to be working with the African Union to do so—precisely what we did in Liberia. We helped stabilize the situation with some troops, and when the African Union came, we moved them out. My hope is that the African Union moves rapidly to help save lives. Fortunately, the rainy season will be ending shortly, which will make it easier to get aid there and help the long-suffering people there. Character of the Candidates Mr. Lehrer. New question, President Bush. There are clearly, as we have heard, major policy differences between the two of you. Are there also underlying character issues that you believe—that you believe— are serious enough to deny Senator Kerry the job as Commander in Chief of the United States? President Bush. Whew, that's a loaded question. [Laughter] First of all, I admire Senator Kerry's service to our country. I admire the fact that he is a great dad. I appreciate the fact that his daughters have been so kind to my daughters in what has been a pretty hard experience for, I guess, young girls seeing their dads out there campaigning. I admire the fact that he's served for 20 years in the Senate, although I'm not so sure I admire the record. I won't hold it against him that he went to Yale. Nothing wrong with that. I—my concerns about the Senator is that in the course of this campaign I've been listening very carefully to what he says, and he changed his positions on the war in Iraq, changed his positions on something as fundamental as what you believe in your core, in your heart of hearts, is right in Iraq. You cannot lead if you send mixed messages. Mixed messages send the wrong signals to our troops. Mixed messages send the wrong signals to our allies. Mixed messages send the wrong signals to the Iraqi citizens. And that's my biggest concern about my opponent. I admire his service. But I just know how this world works and that in the councils of government, there must be certainty from the U.S. President. Of course, we change tactics when need to, but we never change our beliefs, the strategic beliefs that are necessary to protect this country in the world. Mr. Lehrer. Ninety-second response, Senator. Senator Kerry. Well, first of all, I appreciate enormously the personal comments the President just made, and I share them with him. I think only if you've—if you're doing this, and he's done it more than I have in terms of the Presidency, can you begin to get a sense of what it means to your families. And it's tough. And so I acknowledge his daughters. I've watched them. I've chuckled a few times at some of their comments. [Laughter] And—— President Bush. I'm trying to put a leash on them. [Laughter] Senator Kerry. Well, I know, I've learned not to do that. [Laughter] And I have great respect and admiration for his wife. I think she's a terrific person—— President Bush. Thank you. Senator Kerry. ——and a great First Lady. But we do have differences. I'm not going to talk about a difference of character. I don't think that's my job or my business. But let me talk about something that the President just sort of finished up with—maybe someone would call it a character trait; maybe somebody wouldn't—but this issue of certainty. It's one thing to be certain, but you can be certain and be wrong. It's another to be certain and be right, or be certain and be moving in the right direction, or be certain about a principle and then learn new facts and take those new facts and put them to use in order to change and get your policy right. What I worry about with the President is that he's not acknowledging what's on the ground. He's not acknowledging the realities of North Korea. He's not acknowledging the truth of the science of stem cell research or of global warming and other issues. And certainty sometimes can get you in trouble. Mr. Lehrer. Thirty seconds. President Bush. Well, I think—listen, I fully agree that one should shift tactics, and we will in Iraq. Our commanders have got all the flexibility to do what is necessary to succeed. But what I won't do is change my core values because of politics or because of pressure. And it is—one of the things I've learned in the White House is that there's enormous pressure on the President, and you cannot wilt under that pressure. Otherwise the world won't be better off. Mr. Lehrer. Thirty seconds. Senator Kerry. I have no intention of wilting. I've never wilted in my life, and I've never wavered in my life. I know exactly what we need to do in Iraq and my position has been consistent. Saddam Hussein is a threat. He needed to be disarmed. We needed to go to the U.N. The President needed the authority to use force in order to be able to get him to do something because he never did it without the threat of force, but we didn't need to rush to war without a plan to win the peace. Nuclear Proliferation Mr. Lehrer. New question, 2 minutes, Senator Kerry. If you are elected President, what will you take to that office thinking is the single most serious threat to the national security of the United States? Senator Kerry. Nuclear proliferation— nuclear proliferation. There are some 600-plus tons of unsecured material still in the former Soviet Union, in Russia. At the rate that the President is currently securing that, it will take 13 years to get it. I did a lot of work on this. I wrote a book about it several years ago—maybe 6 or 7 years ago, called "The New War," which saw the difficulties of this international criminal network. And back then, we intercepted a suitcase in a Middle Eastern country with nuclear materials in it, and the black market sale price was about $250 million. Now, there are terrorists trying to get their hands on that stuff today. And this President, I regret to say, has secured less nuclear material in the last 2 years since 9/11 than we did in the 2 years preceding 9/11. We have to do this job. And to do the job, you can't cut the money for it. The President actually cut the money for it. You have to put the money into it and the funding and the leadership. And part of that leadership is sending the right message to places like North Korea. Right now the President is spending hundreds of millions of dollars to research bunker-busting nuclear weapons. The United States is pursuing a new set of nuclear weapons. It doesn't make sense. You talk about mixed messages. We're telling other people, "You can't have nuclear weapons," but we're pursuing a new nuclear weapon that we might even contemplate using. Not this President. I'm going to shut that program down, and we're going to make it clear to the world we're serious about containing nuclear proliferation. And we're going to get the job of containing all of that nuclear material in Russia done in 4 years. And we're going to build the strongest international network to prevent nuclear proliferation. This is the scale of what President Kennedy set out to do with the Nuclear Test Ban Treaty. It's our generation's equivalent, and I intend to get it done. Mr. Lehrer. Ninety seconds, Mr. President. President Bush. Actually, we've increased funding for dealing with nuclear proliferation about 35 percent since I've been the President. Secondly, we've set up what's called the—well, first of all, I agree with my opponent that the biggest threat facing this country is weapons of mass destruction in the hands of a terrorist network. And that's why we've put proliferation as the—one of the centerpieces of a multipronged strategy to make the country safer. My administration started what is called the Proliferation Security Initiative, over 60 nations involved with disrupting the trans-shipment of information and/or weapons of mass destruction materials. And we're— been effective. We busted the A.Q. Khan network. This was a proliferator out of Pakistan that was selling secrets to places like North Korea and Libya. We convinced Libya to disarm. It was an essential part of dealing with weapons of mass destruction and proliferation. I'll tell you another way to help protect America in the long—in the long run is continue with missile defenses, and we've got a robust research and development program that has been ongoing during my administration. We'll be implementing a missile defense system relatively quickly. And that is another way to help deal with the threats that we face in the 21st century. My opponent is opposed to the missile defenses. Mr. Lehrer. Just for this one-minute discussion here, is it just—for whatever seconds it takes—so it's correct to say that if somebody is listening to this, that both of you agree—if you're reelected, Mr. President, and if you are elected—the single most serious threat you believe—both of you believe is nuclear proliferation? President Bush. In the hands of a terrorist enemy. Senator Kerry. Weapons of mass destruction, nuclear proliferation. But again, the test of the difference between us—the President has had 4 years to try to do something about it, and North Korea has got more weapons. Iran is moving towards weapons. And at his pace, it will take 13 years to secure those weapons in Russia. I'm going to do it in 4 years, and I'm going to immediately set out to have bilateral talks with North Korea. Mr. Lehrer. Your response to that. President Bush. Again, I can't tell you how big a mistake I think that is, to have bilateral talks with North Korea. It's precisely what Kim Chong-il wants. It will cause the six-party talks to evaporate. It means that China no longer is involved in convincing, along with us, for Kim Chong-il to get rid of his weapons. It's a big mistake to do that. We must have China's leverage on Kim Chong-il, besides ourselves. And if you enter bilateral talks, they'll be happy to walk away from the table. I don't think that will work. President Vladimir Putin of Russia Mr. Lehrer. All right, Mr. President, this is—this is the last question, and 2 minutes. It's a new—new subject, new question. And it has to do with President Putin and Russia. Did you misjudge him, or are you— do you feel that what he is doing in the name of antiterrorism by changing some democratic processes is okay? President Bush. No, I don't think it's okay and said so publicly. I think that there needs to be checks and balances in a democracy and made that very clear—that by consolidating power in a central government, he's sending a signal to the Western world and the United States that—that perhaps he doesn't believe in checks and balances. And I've told him that. He's also a strong ally in the war on terror. He is—listen, they went through a horrible situation in Beslan where these terrorists gunned down young school kids. But it's the nature of the enemy, by the way. That's why we need to be firm and resolved in bringing them to justice. It's precisely what Vladimir Putin understands as well. I've got a good relation with Vladimir, and it's important that we do have a good relation because that enables me to better comment to him and to—better to discuss with him some of the decisions he makes. I found that in this world that it's important to establish good personal relationships with people so that when you have disagreements, you're able to disagree in a way that is effective. And so I've told him my opinion. I look forward to discussing it more with him as time goes on. Russia is a country in transition. Vladimir is going to have to make some hard choices, and I think it's very important for the American President as well as other Western leaders to remind him of the great benefits of democracy, that democracy will best help the people realize their hopes and aspirations and dreams. And I will continue working with him over the next 4 years. Mr. Lehrer. Ninety seconds, Senator Kerry. Senator Kerry. Well, let me just say quickly that I've had an extraordinary experience of watching up close and personal that transition in Russia, because I was there right after the transformation, and I was probably one of the first Senators, along with Senator Bob Smith of New Hampshire, a former Senator, to go down into the KGB underneath Treblinka Square and see reams of files with names in them. And it sort of brought home the transition to democracy that Russia was trying to make. I regret what's happened in these past months, and I think it goes beyond just the response to terror. Mr. Putin now controls all the television stations. His political opposition is being put in jail. And I think it's very important for the United States, obviously, to have a working relationship that is good. This is a very important country to us, and we want a partnership. But we always have to stand up for democracy. As George Will said the other day, "Freedom on the march, not in Russia right now." Now, I'd like to come back for a quick moment, if I can, to that issue about China and the talks, because that's one of the most critical issues here, North Korea. Just because the President says it can't be done, that you'd lose China, doesn't mean it can't be done. I mean, this is the President who said there were weapons of mass destruction, said "mission accomplished," said we could fight the war on the cheap, none of which were true. We can have bilateral talks with Kim Chong-il, and we can get those weapons at the same time as we get China, because China has an interest in the outcome too. Mr. Lehrer. Thirty seconds, Mr. President. President Bush. You know my opinion on North Korea. I can't say it any more plainly. Mr. Lehrer. Right. Well, but what—he used the word "truth" again. President Bush. Pardon me? Mr. Lehrer. Talking about the truth of the matter. He used the word "truth" again. Did that raise any hackles that you— with you? President Bush. Oh, I'm a pretty calm guy. [Laughter] I mean, I don't take it personally. Mr. Lehrer. All right. Yes. President Bush. But you know, look, we looked at the same intelligence. We came to the same conclusion, that Saddam Hussein was a grave threat. And I don't hold it against him that he said "grave threat." I'm not going to go around the country saying he didn't tell the truth, when he looked at the same intelligence I did. Senator Kerry. It was a threat. That's not the issue. The issue is what you do about it. The President said he was going to build a true coalition, exhaust the remedies of the U.N., and go to war as a last resort. Those words really have to mean something. And unfortunately, he didn't go to war as a last resort. Now we have this incredible mess in Iraq, $200 billion—it's— it's not what the American people thought they were getting when they voted. Closing Statements Mr. Lehrer. All right, that brings us to closing statements. And again, as determined by a coin toss, Senator Kerry, you go first, and you have 2 minutes. Senator Kerry. Thank you, Jim, very much. Thank you very much to the university again. Thank you, Mr. President. My fellow Americans, as I said at the very beginning of this debate, both President Bush and I love this country very much. There is no doubt, I think, about that. But we have a different set of convictions about how we make our country stronger here at home and respected again in the world. I know that for many of you sitting at home, parents of kids in Iraq, you want to know, who is the person who could be a Commander in Chief who can get your kids home and get the job done and win the peace? And for all the rest of the parents in America who are wondering about their kids going to a school or anywhere else in the world, what kind of world they're going to grow up in, let me look you in the eye and say to you: I've defended this country as a young man in war, and I will defend it as President of the United States. But I have a difference with this President. I believe we're strongest when we reach out and lead the world and build strong alliances. I have a plan for Iraq. I believe we can be successful. I'm not talking about leaving. I'm talking about winning. And we need a fresh start, a new credibility, a President who can bring allies to our side. I also have a plan to win the war on terror, funding homeland security, strengthening our military, cutting off finances, reaching out to the world—again, building strong alliances. I believe America's best days are ahead of us because I believe that the future belongs to freedom, not to fear. That's the country that I'm going to fight for, and I ask you to give me the opportunity to make you proud. I ask you to give me the opportunity to lead this great Nation so that we can be stronger here at home, respected again in the world, and have responsible leadership that we deserve. Thank you, and God bless America. Mr. Lehrer. Mr. President, 2 minutes. President Bush. Thank you very much, tonight, Jim. Thank you, Senator. If America shows uncertainty or weakness in this decade, the world will drift toward tragedy. That's not going to happen so long as I'm your President. In the next 4 years, we will continue to strengthen our homeland defenses. We will strengthen our intelligence gathering services. We will reform our military. The military will be an all-volunteer army. We will continue to stay on the offense. We will fight the terrorists around the world so we do not have to face them here at home. We'll continue to build our alliances. I'll never turn over America's national security needs to leaders of other countries as we continue to build those alliances. And we'll continue to spread freedom. I believe in the transformational power of liberty. I believe that a free Iraq is in this Nation's interests. I believe a free Afghanistan is in this Nation's interests, and I believe both a free Afghanistan and a free Iraq will serve as a powerful example for millions who plead in silence for liberty in the broader Middle East. We've done a lot of hard work together over the last 3 1/2 years. We've been challenged, and we've risen to those challenges. We've climbed the mighty mountain. I see the valley below, and it's a valley of peace. By being steadfast and resolute and strong, by keeping our word, by supporting our troops, we can achieve the peace we all want. I appreciate your listening tonight. I ask for your vote. And may God continue to bless our great land. Mr. Lehrer. And that ends tonight's debate. A reminder, the second Presidential debate will be a week from tomorrow, October 8th, from Washington University in St. Louis. Charles Gibson of ABC News will moderate a townhall-type event. Then, on October 13th, from Arizona State University in Tempe, Bob Schieffer of CBS News will moderate an exchange on domestic policy that will be similar in format to tonight's. Also, this coming Tuesday, at Case Western Reserve University in Cleveland, the Vice Presidential candidates, Vice President Cheney and Senator Edwards, will debate with my PBS colleague, Gwen Ifill, moderating. For now, thank you, Senator Kerry, President Bush. From Coral Gables, Florida, I'm Jim Lehrer. Thank you, and good night.
