# Presidential Debate in Chicago

**Date:** September 26, 1960
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-chicago

---

HOWARD K. SMITH, MODERATOR: Good evening. The television and radio stations of the United States and their affiliated stations are proud to provide facilities for a discussion of issues in the current political campaign by the two major candidates for the presidency. The candidates need no introduction. The Republican candidate, Vice President Richard M. Nixon, and the Democratic candidate, Senator John F. Kennedy. According to rules set by the candidates themselves, each man shall make an opening statement of approximately eight minutes' duration and a closing statement of approximately three minutes' duration. In between the candidates will answer, or comment upon answers to questions put by a panel of correspondents. In this, the first discussion in a series of four uh - joint appearances, the subject-matter has been agreed, will be restricted to internal or domestic American matters. And now for the first opening statement by Senator John F. Kennedy. SENATOR KENNEDY: Mr. Smith, Mr. Nixon. In the election of 1860, Abraham Lincoln said the question was whether this nation could exist half-slave or half-free. In the election of 1960, and with the world around us, the question is whether the world will exist half-slave or half-free, whether it will move in the direction of freedom, in the direction of the road that we are taking, or whether it will move in the direction of slavery. I think it will depend in great measure upon what we do here in the United States, on the kind of society that we build, on the kind of strength that we maintain. We discuss tonight domestic issues, but I would not want that to be any implication to be given that this does not involve directly our struggle with Mr. Khrushchev for survival. Mr. Khrushchev is in New York, and he maintains the Communist offensive throughout the world because of the productive power of the Soviet Union itself. The Chinese Communists have always had a large population. But they are important and dangerous now because they are mounting a major effort within their own country. The kind of country we have here, the kind of society we have, the kind of strength we build in the United States will be the defense of freedom. If we do well here, if we meet our obligations, if we're moving ahead, then I think freedom will be secure around the world. If we fail, then freedom fails. Therefore, I think the question before the American people is: Are we doing as much as we can do? Are we as strong as we should be? Are we as strong as we must be if we're going to maintain our independence, and if we're going to maintain and hold out the hand of friendship to those who look to us for assistance, to those who look to us for survival? I should make it very clear that I do not think we're doing enough, that I am not satisfied as an American with the progress that we're making. This is a great country, but I think it could be a greater country; and this is a powerful country, but I think it could be a more powerful country. I'm not satisfied to have fifty percent of our steel-mill capacity unused. I'm not satisfied when the United States had last year the lowest rate of economic growth of any major industrialized society in the world. Because economic growth means strength and vitality; it means we're able to sustain our defenses; it means we're able to meet our commitments abroad. I'm not satisfied when we have over nine billion dollars worth of food - some of it rotting - even though there is a hungry world, and even though four million Americans wait every month for a food package from the government, which averages five cents a day per individual. I saw cases in West Virginia, here in the United States, where children took home part of their school lunch in order to feed their families because I don't think we're meeting our obligations toward these Americans. I'm not satisfied when the Soviet Union is turning out twice as many scientists and engineers as we are. I'm not satisfied when many of our teachers are inadequately paid, or when our children go to school part-time shifts. I think we should have an educational system second to none. I'm not satisfied when I see men like Jimmy Hoffa - in charge of the largest union in the United States - still free. I'm not satisfied when we are failing to develop the natural resources of the United States to the fullest. Here in the United States, which developed the Tennessee Valley and which built the Grand Coulee and the other dams in the Northwest United States at the present rate of hydropower production - and that is the hallmark of an industrialized society - the Soviet Union by 1975 will be producing more power than we are. These are all the things, I think, in this country that can make our society strong, or can mean that it stands still. I'm not satisfied until every American enjoys his full constitutional rights. If a Negro baby is born - and this is true also of Puerto Ricans and Mexicans in some of our cities - he has about one-half as much chance to get through high school as a white baby. He has one-third as much chance to get through college as a white student. He has about a third as much chance to be a professional man, about half as much chance to own a house. He has about uh - four times as much chance that he'll be out of work in his life as the white baby. I think we can do better. I don't want the talents of any American to go to waste. I know that there are those who want to turn everything over to the government. I don't at all. I want the individuals to meet their responsibilities. And I want the states to meet their responsibilities. But I think there is also a national responsibility. The argument has been used against every piece of social legislation in the last twenty-five years. The people of the United States individually could not have developed the Tennessee Valley; collectively they could have. A cotton farmer in Georgia or a peanut farmer or a dairy farmer in Wisconsin and Minnesota, he cannot protect himself against the forces of supply and demand in the market place; but working together in effective governmental programs he can do so. Seventeen million Americans, who live over sixty-five on an average Social Security check of about seventy-eight dollars a month, they're not able to sustain themselves individually, but they can sustain themselves through the social security system. I don't believe in big government, but I believe in effective governmental action. And I think that's the only way that the United States is going to maintain its freedom. It's the only way that we're going to move ahead. I think we can do a better job. I think we're going to have to do a better job if we are going to meet the responsibilities which time and events have placed upon us. We cannot turn the job over to anyone else. If the United States fails, then the whole cause of freedom fails. And I think it depends in great measure on what we do here in this country. The reason Franklin Roosevelt was a good neighbor in Latin America was because he was a good neighbor in the United States. Because they felt that the American society was moving again. I want us to recapture that image. I want people in Latin America and Africa and Asia to start to look to America; to see how we're doing things; to wonder what the resident of the United States is doing; and not to look at Khrushchev, or look at the Chinese Communists. That is the obligation upon our generation. In 1933, Franklin Roosevelt said in his inaugural that this generation of Americans has a rendezvous with destiny. I think our generation of Americans has the same rendezvous. The question now is: Can freedom be maintained under the most severe tack - attack it has ever known? I think it can be. And I think in the final analysis it depends upon what we do here. I think it's time America started moving again. MR. SMITH: And now the opening statement by Vice President Richard M. Nixon. MR. NIXON: Mr. Smith, Senator Kennedy. The things that Senator Kennedy has said many of us can agree with. There is no question but that we cannot discuss our internal affairs in the United States without recognizing that they have a tremendous bearing on our international position. There is no question but that this nation cannot stand still; because we are in a deadly competition, a competition not only with the men in the Kremlin, but the men in Peking. We're ahead in this competition, as Senator Kennedy, I think, has implied. But when you're in a race, the only way to stay ahead is to move ahead. And I subscribe completely to the spirit that Senator Kennedy has expressed tonight, the spirit that the United States should move ahead. Where, then, do we disagree? I think we disagree on the implication of his remarks tonight and on the statements that he has made on many occasions during his campaign to the effect that the United States has been standing still. We heard tonight, for example, the statement made that our growth in national product last year was the lowest of any industrial nation in the world. Now last year, of course, was 1958. That happened to be a recession year. But when we look at the growth of G.N.P. this year, a year of recovery, we find that it's six and nine-tenths per cent and one of the highest in the world today. More about that later. Looking then to this problem of how the United States should move ahead and where the United States is moving, I think it is well that we take the advice of a very famous campaigner: Let's look at the record. Is the United States standing still? Is it true that this Administration, as Senator Kennedy has charged, has been an Administration of retreat, of defeat, of stagnation? Is it true that, as far as this country is concerned, in the field of electric power, in all of the fields that he has mentioned, we have not been moving ahead. Well, we have a comparison that we can make. We have the record of the Truman Administration of seven and a half years and the seven and a half years of the Eisenhower Administration. When we compare these two records in the areas that Senator Kennedy has - has discussed tonight, I think we find that America has been moving ahead. Let's take schools. We have built more schools in these last seven and a half years than we built in the previous seven and a half, for that matter in the previous twenty years. Let's take hydroelectric power. We have developed more hydroelectric power in these seven and a half years than was developed in any previous administration in history. Let us take hospitals. We find that more have been built in this Administration than in the previous Administration. The same is true of highways. Let's put it in terms that all of us can understand. We often hear gross national product discussed and in that respect may I say that when we compare the growth in this Administration with that of the previous Administration that then there was a total growth of eleven percent over seven years; in this Administration there has been a total growth of nineteen per cent over seven years. That shows that there's been more growth in this Administration than in its predecessor. But let's not put it there; let's put it in terms of the average family. What has happened to you? We find that your wages have gone up five times as much in the Eisenhower Administration as they did in the Truman Administration. What about the prices you pay? We find that the prices you pay went up five times as much in the Truman Administration as they did in the Eisenhower Administration. What's the net result of this? This means that the average family income went up fifteen per cent in the Eisenhower years as against two per cent in the Truman years. Now, this is not standing still. But, good as this record is, may I emphasize it isn't enough. A record is never something to stand on. It's something to build on. And in building on this record, I believe that we have the secret for progress, we know the way to progress. And I think, first of all, our own record proves that we know the way. Senator Kennedy has suggested that he believes he knows the way. I respect the sincerity which he m- which he makes that suggestion. But on the other hand, when we look at the various programs that he offers, they do not seem to be new. They seem to be simply retreads of the programs of the Truman Administration which preceded it. And I would suggest that during the course of the evening he might indicate those areas in which his programs are new, where they will mean more progress than we had then. What kind of programs are we for? We are for programs that will expand educational opportunities, that will give to all Americans their equal chance for education, for all of the things which are necessary and dear to the hearts of our people. We are for programs, in addition, which will see that our medical care for the aged are - is - are much - is much better handled than it is at the present time. Here again, may I indicate that Senator Kennedy and I are not in disagreement as to the aims. We both want to help the old people. We want to see that they do have adequate medical care. The question is the means. I think that the means that I advocate will reach that goal better than the means that he advocates. I could give better examples, but for - for whatever it is, whether it's in the field of housing, or health, or medical care, or schools, or the eh- development of electric power, we have programs which we believe will move America, move her forward and build on the wonderful record that we have made over these past seven and a half years. Now, when we look at these programs, might I suggest that in evaluating them we often have a tendency to say that the test of a program is how much you're spending. I will concede that in all the areas to which I have referred Senator Kennedy would have the spe- federal government spend more than I would have it spend. I costed out the cost of the Democratic platform. It runs a minimum of thirteen and two-tenths billions dollars a year more than we are presently spending to a maximum of eighteen billion dollars a year more than we're presently spending. Now the Republican platform will cost more too. It will cost a minimum of four billion dollars a year more, a maximum of four and nine-tenths billion dollar a year more than we're presently spending. Now, does this mean that his program is better than ours? Not at all. Because it isn't a question of how much the federal government spends; it isn't a question of which government does the most. It is a question of which administration does the right thing. And in our case, I do believe that our programs will stimulate the creative energies of a hundred and eighty million free Americans. I believe the programs that Senator Kennedy advocates will have a tendency to stifle those creative energies, I believe in other words, that his program would lead to the stagnation of the motive power that we need in this country to get progress. The final point that I would like to make is this: Senator Kennedy has suggested in his speeches that we lack compassion for the poor, for the old, and for others that are unfortunate. Let us understand throughout this campaign that his motives and mine are sincere. I know what it means to be poor. I know what it means to see people who are unemployed. I know Senator Kennedy feels as deeply about these problems as I do, but our disagreement is not about the goals for America but only about the means to reach those goals. MR. SMITH: Thank you, Mr. Nixon. That completes the opening statements, and now the candidates will answer questions or comment upon one another's answers to questions, put by correspondents of the networks. The correspondents: [introducing themselves: "I'm Sander Vanocur, NBC News;" "I'm Charles Warren, Mutual News;" "I'm Stuart Novins, CBS News;" "Bob Fleming, ABC News."] The first question to Senator Kennedy from Mr. Fleming. MR. FLEMING: Senator, the Vice President in his campaign has said that you were naive and at times immature. He has raised the question of leadership. On this issue, why do you think people should vote for you rather than the Vice President? MR. KENNEDY: Well, the Vice President and I came to the Congress together 1946; we both served in the Labor Committee. I've been there now for fourteen years, the same period of time that he has, so that our experience in uh - government is comparable. Secondly, I think the question is uh - what are the programs that we advocate, what is the party record that we lead? I come out of the Democratic party, which in this century has produced Woodrow Wilson and Franklin Roosevelt and Harry Truman, and which supported and sustained these programs which I've discussed tonight. Mr. Nixon comes out of the Republican party. He was nominated by it. And it is a fact that through most of these last twenty-five years the Republican leadership has opposed federal aid for education, medical care for the aged, development of the Tennessee Valley, development of our natural resources. I think Mr. Nixon is an effective leader of his party. I hope he would grant me the same. The question before us is: which point of view and which party do we want to lead the United States? MR. SMITH: Mr. Nixon, would you like to comment on that statement? Mr. NIXON: I have no comment. Mr. SMITH: The next question: Mr. Novins. MR. NOVINS: Mr. Vice President, your campaign stresses the value of your eight year experience, and the question arises as to whether that experience was as an observer or as a participant or as an initiator of policy-making. Would you tell us please specifically what major proposals you have made in the last eight years that have been adopted by the Administration? MR. NIXON: It would be rather difficult to cover them in eight and- in two and a half minutes. I would suggest that these proposals could be mentioned. First, after each of my foreign trips I have made recommendations that have been adopted. For example, after my first trip abroad - abroad, I strongly recommended that we increase our exchange programs particularly as they related to exchange of persons of leaders in the labor field and in the information field. After my trip to South America, I made recommendations that a separate inter-American lending agency be set up which the South American nations would like much better than a lend- than to participate in the lending agencies which treated all the countries of the world the same. Uh - I have made other recommendations after each of the other trips; for example, after my trip abroad to Hungary I made some recommendations with regard to the Hungarian refugee situation which were adopted, not only by the President but some of them were enacted into law by the Congress. Within the Administration, as a chairman of the President's Committee on Price Stability and Economic Growth, I have had the opportunity to make recommendations which have been adopted within the Administration and which I think have been reasonably effective. I know Senator Kennedy suggested in his speech at Cleveland yesterday that that committee had not been particularly effective. I would only suggest that while we do not take the credit for it - I would not presume to - that since that committee has been formed the price line has been held very well within the United States. MR. KENNEDY: Well, I would say in the latter that the - and that's what I found uh - somewhat unsatisfactory about the figures uh - Mr. Nixon, that you used in your previous speech, when you talked about the Truman Administration. You - Mr. Truman came to office in nineteen uh - forty-four and at the end of the war, and uh - difficulties that were facing the United States during that period of transition - 1946 when price controls were lifted - so it's rather difficult to use an overall figure taking those seven and a half years and comparing them to the last eight years. I prefer to take the overall percentage record of the last twenty years of the Democrats and the eight years of the Republicans to show an overall period of growth. In regard to uh - price stability uh - I'm not aware that that committee did produce recommendations that ever were certainly before the Congress from the point of view of legislation in regard to controlling prices. In regard to the exchange of students and labor unions, I am chairman of the subcommittee on Africa and I think that one of the most unfortunate phases of our policy towards that country was the very minute number of exchanges that we had. I think it's true of Latin America also. We did come forward with a program of students for the Congo of over three hundred which was more than the federal government had for all of Africa the previous year, so that I don't think that uh - we have moved at least in those two areas with sufficient vigor. MR. SMITH: The next question to Senator Kennedy from Mr. Warren. MR. WARREN: Uh - Senator Kennedy, during your brief speech a few minutes ago you mentioned farm surpluses. MR. KENNEDY: That's correct. MR. WARREN: I'd like to ask this: It's a fact, I think, that presidential candidates traditionally make promises to farmers. Lots of people, I think, don't understand why the government pays farmers for not producing certain crops or paying farmers if they overproduce for that matter. Now, let me ask, sir, why can't the farmer operate like the business man who operates a factory? If an auto company overproduces a certain model car Uncle Sam doesn't step in and buy up the surplus. Why this constant courting of the farmer? MR. KENNEDY: Well, because I think that if the federal government moved out of the program and withdrew its supports uh - then I think you would have complete uh - economic chaos. The farmer plants in the spring and harvests in the fall. There are hundreds of thousands of them. They really don't - they're not able to control their market very well. They bring their crops in or their livestock in, many of them about the same time. They have only a few purchasers that buy their milk or their hogs - a few large companies in many cases - and therefore the farmer is not in a position to bargain very effectively in the market place. I think the experience of the twenties has shown what a free market could do to agriculture. And if the agricultural economy collapses, then the economy of the rest of the United States sooner or later will collapse. The farmers are the number one market for the automobile industry of the United States. The automobile industry is the number one market for steel. So if the farmers' economy continues to decline as sharply as it has in recent years, then I think you would have a recession in the rest of the country. So I think the case for the government intervention is a good one. Secondly, my objection to present farm policy is that there are no effective controls to bring supply and demand into better balance. The dropping of the support price in order to limit production does not work, and we now have the highest uh - surpluses - nine billion dollars worth. We've had a uh - higher tax load from the Treasury for the farmer in the last few years with the lowest farm income in many years. I think that this farm policy has failed. In my judgment the only policy that will work will be for effective supply and demand to be in balance. And that can only be done through governmental action. I therefore suggest that in those basic commodities which are supported, that the federal government, after endorsement by the farmers in that commodity, attempt to bring supply and demand into balance - attempt effective production controls - so that we won't have that five or six per cent surplus which breaks the price fifteen or twenty per cent. I think Mr. Benson's program has failed. And I must say, after reading the Vice President's speech before the farmers, as he read mine, I don't believe that it's very much different from Mr. Benson's. I don't think it provides effective governmental controls. I think the support prices are tied to the average market price of the last three years, which was Mr. Benson's theory. I therefore do not believe that this is a sharp enough breach with the past to give us any hope of success for the future. MR. SMITH: Mr. Nixon, comment? MR. NIXON; I of course disagree with Senator Kennedy insofar as his suggestions as to what should be done uh - with re- on the farm program. He has made the suggestion that what we need is to move in the direction of more government controls, a suggestion that would also mean raising prices uh - that the consumers pay for products and im- and imposing upon the farmers uh - controls on acreage even far more than they have today. I think this is the wrong direction. I don't think this has worked in the past; I do not think it will work in the future. The program that I have advocated is one which departs from the present program that we have in this respect. It recognizes that the government has a responsibility to get the farmer out of the trouble he presently is in because the government got him into it. And that's the fundamental reason why we can't let the farmer go by himself at the present time. The farmer produced these surpluses because the government asked him to through legislation during the war. Now that we have these surpluses, it's our responsibility to indemnify the farmer during that period that we get rid of the farmer uh - the surpluses. Until we get the surpluses off the farmer's back, however, we should have a program such as I announced, which will see that farm income holds up. But I would propose holding that income up not through a type of program that Senator Kennedy has suggested that would raise prices, but one that would indemnify the farmer, pay the farmer in kind uh - from the products which are in surplus. Mr. SMITH: The next question to Vice President Nixon from Mr. Vanocur. MR. VANOCUR: Uh - Mr. Vice President, since the question of executive leadership is a very important campaign issue, I'd like to follow Mr. Novins' question. Now, Republican campaign slogans - you'll see them on signs around the country as you did last week - say it's experience that counts - that's over a picture of yourself; sir uh - implying that you've had more governmental executive decision-making uh - experience than uh - your opponent. Now, in his news conference on August twenty-fourth, President Eisenhower was asked to give one example of a major idea of yours that he adopted. His reply was, and I'm quoting; "If you give me a week I might think of one. I don't remember." Now that was a month ago, sir, and the President hasn't brought it up since, and I'm wondering, sir, if you can clarify which version is correct - the one put out by Republican campaign leaders or the one put out by President Eisenhower? MR. NIXON: Well, I would suggest, Mr. Vanocur, that uh - if you know the President, that was probably a facetious remark. Uh - I would also suggest that insofar as his statement is concerned, that I think it would be improper for the President of the United States to disclose uh - the instances in which members of his official family had made recommendations, as I have made them through the years to him, which he has accepted or rejected. The President has always maintained and very properly so that he is entitled to get what advice he wants from his cabinet and from his other advisers without disclosing that to anybody - including as a matter of fact the Congress. Now, I can only say this. Through the years I have sat in the National Security Council. I have been in the cabinet. I have met with the legislative leaders. I have met with the President when he made the great decisions with regard to Lebanon, Quemoy and Matsu, other matters. The President has asked for my advice. I have given it. Sometimes my advice has been taken. Sometimes it has not. I do not say that I have made the decisions. And I would say that no president should ever allow anybody else to make the major decisions, The president only makes the decisions. All that his advisers do is to give counsel when he asks for it. As far as what experience counts and whether that is experience that counts, that isn't for me to say. Uh - I can only say that my experience is there for the people to consider; Senator Kennedy's is there for the people to consider. As he pointed out, we came to the Congress in the same year. His experience has been different from mine. Mine has been in the executive branch. His has been in the legislative branch. I would say that the people now have the opportunity to evaluate his as against mine and I think both he and I are going to abide by whatever the people decide. MR. SMITH: Senator Kennedy. Mr. KENNEDY: Well, I'll just say that the question is of experience and the question also is uh - what our judgment is of the future, and what our goals are for the United States, and what ability we have to implement those goals. Abraham Lincoln came to the presidency in 1860 after a rather little known uh - session in the House of Representatives and after being defeated for the Senate in fifty-eight and was a distinguished president. There's no certain road to the presidency. There are no guarantees that uh - if you take uh - one road or another that you will be a successful president. I have been in the Congress for fourteen years. I have voted in the last uh - eight years uh - and the Vice President was uh - presiding over the Senate and meeting his other responsibilities. I have met met uh - decisions over eight hundred times on matters which affect not only the domestic security of the United States, but as a member of the Senate Foreign Relations Committee. The question really is: which candidate and which party can meet the problems that the United States is going to face in the sixties? MR. SMITH: The next question to Senator Kennedy from Mr. Novins. MR. NOVINS: Senator Kennedy, in connection with these problems of the future that you speak of, and the program that you enunciated earlier in your direct talk, you call for expanding some of the welfare programs for schools, for teacher salaries, medical care, and so forth; but you also call for reducing the federal debt. And I'm wondering how you, if you're president in January, would go about paying the bill for all this. Does this mean that you? MR. KENNEDY: I didn't indicate. I did not advocate reducing the federal debt because I don't believe that you're going to be able to reduce the federal debt very much in nineteen sixty-one, two, or three. I think you have heavy obligations which affect our security, which we're going to have to meet. And therefore I've never suggested we should uh - be able to retire the debt substantially, or even at all in nineteen sixty-one or two. MR. NOVINS: Senator, I believe in - in one of your speeches - MR. KENNEDY: No, never. MR. NOVINS: - you suggested that reducing the interest rate would help toward - MR. KENNEDY: No. No. Not reducing the interest - MR. NOVINS: - a reduction of the Federal debt. MR. KENNEDY: - reducing the interest rate. In my judgment, the hard money, tight money policy, fiscal policy of this Administration has contributed to the slow-down in our economy, which helped bring the recession of fifty-four; which made the recession of fifty-eight rather intense, and which has slowed, somewhat, our economic activity in 1960. What I have talked about, however, the kind of programs that I've talked about, in my judgment, are uh - fiscally sound. Medical care for the aged, I would put under social security. The Vice President and I disagree on this. The program - the Javits-Nixon or the Nixon-Javits program - would have cost, if fully used uh - six hundred million dollars by the government per year, and six hundred million dollars by the state. The program which I advocated, which failed by five votes in the United States Senate, would have put medical care for the aged in Social Security, and would have been paid for through the Social Security System and the Social Security tax. Secondly, I support federal aid to education and federal aid for teachers' salaries. I think that's a good investment. I think we're going to have to do it. And I think to heap the burden further on the property tax, which is already strained in many of our communities, will provide, will make sh- insure, in my opinion, that many of our children will not be adequately educated, and many of our teachers not adequately compensated. There is no greater return to an economy or to a society than an educational system second to none. On the question of the development of natural resources, I would pay as you go in the sense that they would be balanced and the power revenues would bring back sufficient money to finance the projects, in the same way as the Tennessee Valley. I believe in the balanced budget. And the only conditions under which I would unbalance the budget would be if there was a grave national emergency or a serious recession. Otherwise, with a steady rate of economic growth - and Mr. Nixon and Mr. Rockefeller, in their meeting, said a five per cent economic growth would bring by 1962 ten billion dollars extra in tax revenues. Whatever is brought in, I think that we can finance essential programs within a balanced budget, if business remains orderly. MR. SMITH: Mr. Nixon, your comment? MR. NIXON: Yes. I think what Mr. Novins was referring to was not one of Senator Kennedy's speeches, but the Democratic platform, which did mention cutting the national debt. I think, too, that it should be pointed out that of course it is not possible, particularly under the proposals that Senator Kennedy has advocated, either to cut the national debt or to reduce taxes. As a matter of fact it will be necessary to raise taxes. As Senator Kennedy points out that as far as his one proposal is concerned - the one for medical care for the aged - that that would be financed out of Social Security. That, however, is raising taxes for those who pay Social Security. He points out that he would make pay-as-you-go be the basis for our natural resources development. Where our natural resources development - which I also support, incidentally, however - whenever you uh - uh - in - in - uh - appropriates money for one of these projects, you have to pay now and appropriate the money and the eh- while they eventually do pay out, it doesn't mean that you - the government doesn't have to put out the money this year. And so I would say that in all of these proposals Senator Kennedy has made, they will result in one of two things: either he has to raise taxes or he has to unbalance the budget. If he unbalances the budget, that means you have inflation, and that will be, of course, a very cruel blow to the very people - the older people - that we've been talking about. As far as aid for school construction is concerned, I favor that, as Senator Kennedy did, in January of this year, when he said he favored that rather than aid to s- teacher salaries. I favor that because I believe that's the best way to aid our schools without running any risk whatever of the federal government telling our teachers what to teach. MR. SMITH: The next question to Vice President Nixon from Mr. Warren. MR. WARREN: Mr. Vice President you mentioned schools and it was just yesterday I think you asked for a crash program to raise education standards, and this evening you talked about advances in education. Mr. Vice President, you said - it was back in 1957 - that salaries paid to school teachers were nothing short of a national disgrace. Higher salaries for teachers, you added, were important and if the situation wasn't corrected it could lead to a national disaster. And yet, you refused to vote in the Senate in order to break a tie vote when that single vote, if it had been yes, would have granted salary increases to teachers. I wonder if you could explain that, sir. MR. NIXON: I'm awfully glad you ge- got that question because as you know I got into it at the last of my other question and wasn't able to complete the argument. Uh - I think that the reason that I voted against having the federal government uh - pay teachers' salaries was probably the very reason that concerned Senator Kennedy when in January of this year, in his kick-off press conference, he said that he favored aid for school construction, but at that time did not feel that there should be aid for teachers' salaries - at least that's the way I read his remarks. Now, why should there be any question about the federal government aiding s- teachers' salaries? Why did Senator Kennedy take that position then? Why do I take it now? We both took it then, and I take it now, for this reason: we want higher teachers' salaries. We need higher teachers' salaries. But we also want our education to be free of federal control. When the federal government gets the power to pay teachers, inevitably in my opinion, it will acquire the power to set standards and to tell the teachers what to teach. I think this would be bad for the country; I think it would be bad for the teaching profession. There is another point that should be made. I favor higher salaries for teachers. But, as Senator Kennedy said in January of this year in this same press conference, the way that you get higher salaries for teachers is to support school construction, which means that all of the local school districts in the various states then have money which is freed to raise the standards for teachers' salaries. I should also point out this; once you put the responsibility on the federal government for paying a portion of teachers' salaries, your local communities and your states are not going to meet the responsibility as much as they should. I believe, in other words, that we have seen the local communities and the state assuming more of that responsibility. Teachers' salaries very fortunately have gone up fifty percent in the last eight years as against only a thirty-four percent rise for other salaries. This is not enough; it should be more. But I do not believe that the way to get more salaries for teachers is to have the federal government get in with a massive program. My objection here is not the cost in dollars. My objection here is the potential cost in controls and eventual freedom for the American people by giving the federal government power over education, and that is the greatest power a government can have. MR. SMITH: Senator Kennedy's comment? MR. KENNEDY: When uh - the Vice President quotes me in January, sixty, I do not believe the federal government should pay directly teachers' salaries, but that was not the issue before the Senate in February. The issue before the Senate was that the money would be given to the state. The state then could determine whether the money would be spent for school construction or teacher salaries. On that question the Vice President and I disagreed. I voted in favor of that proposal and supported it strongly, because I think that that provided assistance to our teachers for their salaries without any chance of federal control and it is on that vote that th- Mr. Nixon and I disagreed, and his tie vote uh - defeated his breaking the tie defeated the proposal. I don't want the federal government paying teachers' salaries directly. But if the money will go to the states and the states can then determine whether it shall go for school construction or for teachers' salaries, in my opinion you protect the local authority over the school board and the school committee. And therefore I think that was a sound proposal and that is why I supported it and I regret that it did not pass. Secondly, there have been statements made that uh - the Democratic platform would cost a good deal of money and that I am in favor of unbalancing the budget. That is wholly wrong, wholly in error, and it is a fact that in the last eight years the Democratic Congress has reduced the appropri- the requests for the appropriations by over ten billion dollars. That is not my view and I think it ought to be stated very clearly on the record. My view is that you can do these programs - and they should be carefully drawn - within a balanced budget if our economy is moving ahead. MR. SMITH: The next question to Senator Kennedy from Mr. Vanocur. MR. VANOCUR: Senator, you've been promising the voters that if you are elected president you'll try and push through Congress bills on medical aid to the aged, a comprehensive minimum hourly wage bill, federal aid to education. Now, in the August post-convention session of the Congress, when you at least held up the possibility you could one day be president and when you had overwhelming majorities, especially in the Senate, you could not get action on these bills. Now how do you feel that you'll be able to get them in January - MR. KENNEDY: Well as you take the bills - MR. VANOCUR: - if you weren't able to get them in August? MR. KENNEDY: If I may take the bills, we did pass in the Senate a bill uh - to provide a dollar twenty-five cent minimum wage. It failed because the House did not pass it and the House failed by eleven votes. And I might say that two-thirds of the Republicans in the House voted against a dollar twenty-five cent minimum wage and a majority of the Democrats sustained it - nearly two-thirds of them voted for the dollar twenty-five. We were threatened by a veto if we passed a dollar and a quarter - it's extremely difficult with the great power that the president does to pass any bill when the president is opposed to it. All the president needs to sustain his veto of any bill is one-third plus one in either the House or the Senate. Secondly, we passed a federal aid to education bill in the Senate. It failed to came to the floor of the House of Representatives. It was killed in the Rules Committee. And it is a fact in the August session that the four members of the Rules Committee who were Republicans joining with two Democrats voted against sending the aid to education bill to the floor of the House. Four Democrats voted for it. Every Republican on the Rules Committee voted against sending that bill to be considered by the members of the House of Representatives. Thirdly, on medical care for the aged, this is the same fight that's been going on for twenty-five years in Social Security. We wanted to tie it to Social Security. We offered an amendment to do so. Forty-four Democrats voted for it, one Republican voted for it. And we were informed at the time it came to a vote that if it was adopted the President of the United States would veto it. In my judgment, a vigorous Democratic president supported by a Democratic majority in the House and Senate can win the support for these programs. But if you send a Republican president and a Democratic majority and the threat of a veto hangs over the Congress, in my judgment you will continue what happened in the August session, which is a clash of parties and inaction. MR. SMITH: Mr. Nixon, comment? MR. NIXON: Well obviously my views are a little different. First of all, I don't see how it's possible for a one-third of a body, such as the Republicans have in the House and the Senate to stop two-thirds, if the two-thirds are adequately led. I would say, too, that when Senator Kennedy refers to the action of the House Rules Committee, there are eight Democrats on that committee and four Republicans. It would seem to me again that it is very difficult to blame the four Republicans for the eight Democrats' not getting a something through that particular committee. I would say further that to blame the President in his veto power for the inability of the Senator and his colleagues to get action in this special session uh - misses the mark. When the president exercises his veto power, he has to have the people upo- behind him, not just a third of the Congress. Because let's consider it. If the majority of the members of the Congress felt that these particular proposals were good issues - the majority of those who were Democrats - why didn't they pass them and send to the President and get a veto and have an issue? The reason why these particular bills in these various fields that have been mentioned were not passed was not because the President was against them; it was because the people were against them. It was because they were too extreme. And I am convinced that the alternate proposals that I have, that the Republicans have in the field of health, in the field of education, in the field of welfare, because they are not extreme, because they will accomplish the end uh - without too great cost in dollars or in freedom, that they could get through the next Congress. MR. SMITH: The next question to Vice President Nixon fa- from Mr. Fleming. MR. FLEMING: Mr. Vice President, do I take it then you believe that you can work better with Democratic majorities in the House and Senate than Senator Kennedy could work with Democratic majorities in the House and Senate? MR. NIXON; I would say this: that we, of course, expect to pick up some seats in both in the House and the Senate. Uh - We would hope to control the House, to get a majority in the House uh - in this election. We cannot, of course, control the Senate. I would say that a president will be able to lead - a president will be able to get his program through - to the effect that he has the support of the country, the support of the people. Sometimes we - we get the opinion that in getting programs through the House or the Senate it's purely a question of legislative finagling and all that sort of thing. It isn't really that. Whenever a majority of the people are for a program, the House and the Senate responds to it. And whether this House and Senate, in the next session is Democratic or Republican, if the country will have voted for the candidate for the presidency and for the proposals that he has made, I believe that you will find that the president, if it were a Republican, as it would be in my case, would be able to get his program through that Congress. Now, I also say that as far as Senator Kennedy's proposals are concerned, that, again, the question is not simply one of uh - a presidential veto stopping programs. You must always remember that a president can't stop anything unless he has the people behind him. And the reason President Eisenhower's vetoes have been sustained - the reason the Congress does not send up bills to him which they think will be vetoed - is because the people and the Congress, the majority of them, know the country is behind the President. MR. SMITH: Senator Kennedy. MR. KENNEDY: Well, now let's look at these bills that the Vice President suggests were too extreme. One was a bill for a dollar twenty-five cents an hour for anyone who works in a store or company that has a million dollars a year business. I don't think that's extreme at all; and yet nearly two-thirds to three-fourths of the Republicans in the House of Representatives voted against that proposal. Secondly was the federal aid to education bill. It - it was a very uh - because of the defeat of teacher salaries, it was not a bill that uh - met in my opinion the need. The fact of the matter is it was a bill that was less than you recommended, Mr. Nixon, this morning in your proposal. It was not an extreme bill and yet we could not get one Republican to join, at least I think four of the eight Democrats voted to send it to the floor of the House - not one Republican - and they joined with those Democrats who were opposed to it. I don't say the Democrats are united in their support of the program. But I do say a majority are. And I say a majority of the Republicans are opposed to it. The third is medical care for the aged which is tied to Social Security, which is financed out of Social Security funds. It does not put a deficit on the Treasury. The proposal advanced by you and by Mr. Javits would have cost six hundred millions of dollars - Mr. Rockefeller rejected it in New York, said he didn't agree with the financing at all, said it ought to be on Social Security. So these are three programs which are quite moderate. I think it shows the difference between the two parties. One party is ready to move in these programs. The other party gives them lip service. MR. SMITH: Mr. Warren's question for Senator Kennedy. MR. WARREN: Senator Kennedy, on another subject, Communism is so often described as an ideology or a belief that exists somewhere other than in the United States. Let me ask you, sir: just how serious a threat to our national security are these Communist subversive activities in the United States today? MR. KENNEDY: Well, I think they're serious. I think it's a matter that we should continue to uh - give uh - great care and attention to. We should support uh - the laws which the United States has passed in order to protect us from uh - those who would destroy us from within. We should sustain uh - the Department of Justice in its efforts and the F.B.I., and we should be continually alert. I think if the United States is maintaining a strong society here in the United States, I think that we can meet any internal threat. The major threat is external and will continue. MR. SMITH: Mr. Nixon, comment? MR. NIXON: I agree with Senator Kennedy's appraisal generally in this respect. The question of Communism within the United States has been one that has worried us in the past. It is one that will continue to be a problem for years to come. We have to remember that the cold war that Mr. Khrushchev is waging and his colleagues are waging, is waged all over the world and it's waged right here in the United States. That's why we have to continue to be alert. It is also essential in being alert that we be fair; fair because by being fair we uphold the very freedoms that the Communists would destroy. We uphold the standards of conduct which they would never follow. And, in this connection, I think that uh - we must look to the future having in mind the fact that we fight Communism at home not only by our laws to deal with Communists uh - the few who do become Communists and the few who do become tra- fellow travelers, but we also fight Communism at home by moving against those various injustices which exist in our society which the Communists feed upon. And in that connection I again would say that while Senator Kennedy says we are for the status quo, I do believe that he uh - would agree that I am just as sincere in believing that my proposals for federal aid to education, my proposals for health care are just as sincerely held as his. The question again is not one of goals - we're for those goals - it's one of means. MR. SMITH: Mr. Vanocur's question for Vice President Nixon. MR. VANOCUR: Mr. Vice President uh - in one of your earlier statements you said we've moved ahead, we've built more schools, we've built more hospitals. Now, sir, isn't it true that the building of more schools is a local matter for financing? Uh - Were you claiming that the Eisenhower Administration was responsible for the building of these schools, or is it the local school districts that provide for it? MR. NIXON: Not at all. As a matter of fact your question brings out a point that I am very glad to make. Too often in appraising whether we are moving ahead or not we think only of what the federal government is doing. Now that isn't the test of whether America moves. The test of whether America moves is whether the federal government, plus the state government, plus the local government, plus the biggest segment of all - individual enterprise - moves. We have for example a gross national product of approximately five hundred billion dollars. Roughly a hundred billion to a hundred and a quarter billion of that is the result of government activity. Four hundred billion, approximately, is a result of what individuals do. Now, the reason the Eisenhower Administration has moved, the reason that we've had the funds, for example, locally to build the schools, and the hospitals, and the highways, to make the progress that we have, is because this Administration has encouraged individual enterprise; and it has resulted in the greatest expansion of the private sector of the economy that has ever been witnessed in an eight-year period. And that is growth. That is the growth that we are looking for; it is the growth that this Administration has supported and that its policies have stimulated. MR. SMITH: Senator Kennedy. MR. KENNEDY: Well, I must say that the reason that the schools have been constructed is because the local school districts were willing to increase the property taxes to a tremendously high figure - in my opinion, almost to the point of diminishing returns in order to sustain these schools. Secondly, I think we have a rich uh - country. And I think we have a powerful country. I think what we have to do, however, is have the president and the leadership set before our country exactly what we must do in the next decade, if we're going to maintain our security in education, in economic growth, in development of natural resources. The Soviet Union is making great gains. It isn't enough to compare what might have been done eight years ago, or ten years ago, or fifteen years ago, or twenty years ago. I want to compare what we're doing with what our adversaries are doing, so that by the year 1970 the United States is ahead in education, in health, in building, in homes, in economic strength. I think that's the big assignment, the big task, the big function of the federal government. MR. SMITH: Can I have the summation time please? We've completed our questions and our comments, and in just a moment, we'll have the summation time. VOICE: This will allow three minutes and twenty seconds for the summation by each candidate. MR. SM1TH: Three minutes and twenty seconds for each candidate. Vice President Nixon, will you make the first summation? MR. NIXON: Thank you, Mr. Smith. Senator Kennedy. First of all, I think it is well to put in perspective where we really do stand with regard to the Soviet Union in this whole matter of growth. The Soviet Union has been moving faster than we have. But the reason for that is obvious. They start from a much lower base. Although they have been moving faster in growth than we have, we find, for example, today that their total gross national product is only forty-four per cent of our total gross national product. That's the same percentage that it was twenty years ago. And as far as the absolute gap is concerned, we find that the United States is even further ahead than it was twenty years ago. Is this any reason for complacency? Not at all Because these are determined men. They are fanatical men. And we have to get the very most of uh - out uh - out of our economy. I agree with Senator Kennedy completely on that score. Where we disagree is in the means that we would use to get the most out of our economy. I respectfully submit that Senator Kennedy too often would rely too much on the federal government, on what it would do to solve our problems, to stimulate growth. I believe that when we examine the Democratic platform, when we examine the proposals that he has discussed tonight, when we compare them with the proposals that I have made, that these proposals that he makes would not result in greater growth for this country than would be the case if we followed the programs that I have advocated. There are many of the points that he has made that I would like to comment upon. The one in the field of health is worth mentioning. Our health program - the one that Senator Javits and other Republican Senators, as well as I supported - is one that provides for all people over sixty-five who want health insurance, the opportunity to have it if they want it. It provides a choice of having either government insurance or private insurance. But it compels nobody to have insurance who does not want it. His program under Social Security, would require everybody who had Social Security to take government health insurance whether he wanted it or not. And it would not cover several million people who are not covered by Social Security at all. Here is one place where I think that our program does a better job than his. The other point that I would make is this: this downgrading of how much things cost I think many of our people will understand better when they look at what happened when - during the Truman Administration when the government was spending more than it took in - we found savings over a lifetime eaten up by inflation. We found the people who could least afford it - people on retired incomes uh - people on fixed incomes - we found them unable to meet their bills at the end of the month. It is essential that a man who's president of this country certainly stand for every program that will mean for growth. And I stand for programs that will mean growth and progress. But it is also essential that he not allow a dollar spent that could be better spent by the people themselves. MR. SMITH: Senator Kennedy, your conclusion. MR. KENNEDY: The point was made by Mr. Nixon that the Soviet production is only forty-four percent of ours. I must say that forty-four percent and that Soviet country is causing us a good deal of trouble tonight. I want to make sure that it stays in that relationship. I don't want to see the day when it's sixty percent of ours, and seventy and seventy-five and eighty and ninety percent of ours, with all the force and power that it could bring to bear in order to cause our destruction. Secondly, the Vice President mentioned medical care for the aged. Our program was an amendment to the Kerr bill. The Kerr bill provided assistance to all those who were not on Social Security. I think it's a very clear contrast. In 1935, when the Social Security Act was written, ninety-four out of ninety-five Republicans voted against it. Mr. Landon ran in 1936 to repeal it. In August of 1960, when we tried to get it again, but this time for medical care, we received the support of one Republican in the Senate on this occasion. Thirdly, I think the question before the American people is: as they look at this country and as they look at the world around them, the goals are the same for all Americans. The means are at question. The means are at issue. If you feel that everything that is being done now is satisfactory, that the relative power and prestige and strength of the United States is increasing in relation to that of the Communists; that we've b- gaining more security, that we are achieving everything as a nation that we should achieve, that we are achieving a better life for our citizens and greater strength, then I agree. I think you should vote for Mr. Nixon. But if you feel that we have to move again in the sixties, that the function of the president is to set before the people the unfinished business of our society as Franklin Roosevelt did in the thirties, the agenda for our people - what we must do as a society to meet our needs in this country and protect our security and help the cause of freedom. As I said at the beginning, the question before us all, that faces all Republicans and all Democrats, is: can freedom in the next generation conquer, or are the Communists going to be successful? That's the great issue. And if we meet our responsibilities I think freedom will conquer. If we fail, if we fail to move ahead, if we fail to develop sufficient military and economic and social strength here in this country, then I think that uh - the tide could begin to run against us. And I don't want historians, ten years from now, to say, these were the years when the tide ran out for the United States. I want them to say these were the years when the tide came in; these were the years when the United States started to move again. That's the question before the American people, and only you can decide what you want, what you want this country to be, what you want to do with the future. I think we're ready to move. And it is to that great task, if we're successful, that we will address ourselves. MR. SMITH: Thank you very much, gentlemen. This hour has gone by all too quickly. Thank you very much for permitting us to present the next president of the United States on this unique program. I've been asked by the candidates to thank the American networks and the affiliated stations for providing time and facilities for this joint appearance. Other debates in this series will be announced later and will be on different subjects. This is Howard K. Smith. Good night from Chicago.
