# Presidential Debate in Baltimore (Reagan-Anderson)

**Date:** September 21, 1980
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-baltimore-reagan-anderson

---

RUTH J. HINERFELD, CHAIR, LEAGUE OF WOMEN VOTERS EDUCATION FUND: Good evening. I'm Ruth Hinerfeld of the League of Women Voters Education Fund. We're pleased to be in Baltimore for the first of our 1980 Presidential Debates. The League is a non-partisan organization. We're presenting these debates to provide citizens an opportunity to see and hear the candidates state their positions on important issues of concern to us all. Our moderator is Bill Moyers. MR. MOYERS, HOST AND EXECUTIVE EDITOR, "BILL MOYERS' JOURNAL," PUBLIC BROADCASTING SYSTEM: Thank you, Mrs. Hinerfeld. My colleagues and I agreed to participate tonight, although the questioners are limited by the constraints of the format, because we thought with the League of Women Voters, that it is desirable to seek a comparison of views on a few issues in a joint appearance by the men who would be the next President of the United States. Former Governor Ronald Reagan, a Republican Party candidate, and Congressman John Anderson, who is running as an Independent, accepted the League of Women Voters' invitation to be here. President Carter declined. Mr. Reagan and Mr. Anderson will respond with their views on certain issues posed by questions from my colleagues: Carol Loomis of Fortune Magazine; Daniel Greenberg, a syndicated columnist; Charles Corddry of the Baltimore Sun; Lee May of The Los Angeles Times; James Bryant Quinn. Jane Bryant Quinn of Newsweek; and Soma Golden of The New York Times. None of the questions has been submitted in advance to either the League of Women Voters, or to the candidates, or to their representatives. Gentlemen, thank you both for coming. The ground rules you agreed upon with the League are brief. Each panelist will ask a single question. You will have two and a half minutes in which to respond. After you've stated your positions in those two and a half minutes, each of you will have one minute and 15 seconds for response. At the close of the debate, each of you will have three minutes for closing remarks. We ask the Convention Center audience to abide by one simple ground rule: Please do not applaud or express approval or disapproval during the debate. You may do that on November 4. Having won the toss of the coin, Mr. Anderson will respond to the first question from Carol Loomis. CAROL LOOMIS, BOARD OF EDITORS,FORTUNE MAGAZINE : Mr. Anderson, opinion polls show that the American public sees inflation as the country's number one economic problem, yet, as individuals, they oppose cures that hurt them personally. Elected officials have played along by promising to cure inflation while backing away from tough programs that might hurt one special interest group or another, and by actually adding inflationary elements to the system, such as indexing. They have gone for what is politically popular, rather than for what might work and amount to leadership. My question, and please be specific, is what politically unpopular measures are you willing to endorse, push and stay with, that might provide real progress in reducing inflation? REP. JOHN B. ANDERSON: Miss Loomis, I think it's very appropriate that the first question in this first debate of Campaign '80 should relate to the economy of the country, because it seems to me that the people who are watching us tonight - 221 million Americans - are truly concerned about the poor rate of performance of the American economy over the last four years. Governor Reagan is not responsible for what has happened over the last four years, nor am I. The man who should be here tonight to respond to those charges chose not to attend. But I want to answer as specifically as I can the question that you have just put to me. Let me tell you that I, first of all, oppose an election year tax cut, whether it is the 10% across-the-board tax cut promised to the taxpayers by my opponent in this debate tonight, or whether it is the $27.5 billion tax cut promised on the 20th of August by President Carter. I simply think that when we are confronting a budget deficit this year - and this fiscal year will end in about 10 days, and we are confronted with the possibility of a deficit of $60 billion, perhaps as much as $63 billion - that that simply would be irresponsible. That, once again, the printing presses will start to roll; once again we will see the monetization of that debt result in a higher rate of inflation. Even though we've seen some hopeful signs, perhaps, in the flash report on the third quarter, that perhaps the economy is coming out of the recession, we've also seen the rise in the rate of the prime; we have seen mortgage rates back up again, a sure sign of inflation in the housing industry. What I would propose, and I proposed it way back in March when I was a candidate in my own state of Illinois, I proposed $11.3 billion, specifically, in cuts in the Federal budget. I think we've got to have fiscal restraint. And I said at that time that one of the things that we could do, that perhaps would save as much as $5 billion to $7 billion, according, to one of the leading members of the House Budget Committee, was to recalculate the index that is used to determine the cost of living benefits that are paid to civil service retirees, to military retirees. That we ought to ... in addition to that, we ought to pay those retirement benefits on the basis of once a year, rather than twice a year, and save $750 billion. In other words.... MOYERS: Mr. Anderson. ANDERSON: fiscal restraint, I think is necessary. MOYERS: your time is up. Ms. Loomis? LOOMIS: Governor Reagan, repeating the question, and I would ask you, again, to engage in as many specifics as you possibly can. What politically unpopular measures are you willing to endorse, push and stay with that might provide real progress in reducing inflation? GOV. RONALD REAGAN: I believe that the only unpopular measures, actually, that could be, or would be applied, would be unpopular with the government, and with those. perhaps, some special interest groups who are tied closely to government. I believe that inflation today is caused by government simply spending more than government takes in, at the same time that government has imposed upon business and industry, from the shopkeeper on the corner to the biggest industrial plant in America, countless harassing regulations and punitive taxes that have reduced productivity at the same time they have increased the cost of production. And when you are reducing productivity at the same time that you are turning out printing-press money in excessive amounts, you're causing inflation. And it isn't really higher prices, it's just, you are reducing the value of the money. You are robbing the American people of their savings. And so, the plan that I have proposed - and contrary to what John says, my plan is for a phased-in tax cut over a three-year period, tax increase and depreciation allowances for business and industry to give them the capital to refurbish plant and equipment, research and development, improved technology - all of which we see our foreign competitors having, and we have the greatest percentage of outmoded industrial plant and equipment of any of the industrial nations - produce more, have stable money supply, and give the people of this country a greater share of their own savings. Now, I know that this has been called inflationary by my opponent and by the man who isn't here tonight. But I don't see where it is inflationary to have people keep more of their earnings and spend it, and it isn't inflationary for government to take that money away from them and spend it on the things it wants to spend it on. I believe we need incentive for the individual, and for business and industry, and I believe the plan that I have submitted, with detailed backing, and which has been approved by a number of our leading economists in the country, is based on projections. conservative projections out for the next five years, that indicates that this plan would, by 1983, result in a balanced budget. We have to remember, when we talk a tax cut, we're only talking about reducing a tax increase, because this Administration has left us with a built-in tax increase that will amount to $86 billion next year. MOYERS: Your time is up. REAGAN: ...and $500 billion over the next five. MOYERS: Mr. Anderson? ANDERSON: Mr. Movers, in addition to saying that this is no time for a tax cut, in view of the incipient signs of renewed inflation, in addition to calling for restraint in Federal spending, 15 months ago, I also suggested we ought to have an emergency excise tax on gasoline. I say that because I think, this year, we will send $90 billion out of this country to pay for imported oil, even though that. those imports have been reduced. And since I first made that proposal 15 months ago, the price of gasoline, which was then $.80, has gone up to about $1.30. In other words, we've had a huge increase of about $.50 a gallon since that time, and all of that increase has gone out of this country - or much of it - into the pockets of OPEC oil producers. Whereas I have proposed we ought to take. put that tax on here at home, reduce our consumption of that imported oil. Recycle those proceeds, then, back into the pockets of the American workers by reducing their tax payments. their Social Security tax payments by 50%. That, I think, in addition, would be an anti-inflationary measure that would strengthen the economy of this country. MOYERS: Mr. Reagan. REAGAN: Well, I cannot see where a $.50 a gallon tax applied to gasoline would have changed the price of gasoline. It would still have gone up as much as it has, and the $.50 would be added on top of that. And it would be a tax paid by the consumers, and then we're asked to believe that some way, they would get this back to the consumers. But why? Why take it in the first place if you're going to give it back? Why not leave it with them? And John spoke about 15 years ago, on the position that he. or 15 months ago, on what he believed in. Fifteen months ago, he was a cosigner and advocating the very tax cut that I am proposing, and said that that would be a forward step in fighting inflation, and that it would be beneficial to the working people of this country. MOYERS: The next question goes to Mr. Reagan from Daniel Greenberg. GREENBERG, SYNDICATED COLUMNIST: Well, gentlemen, what I'd like to say first is, I think the panel and the audience would appreciate responsiveness to the questions, rather than repetitions of your campaign addresses. My question for the Governor is: Every serious examination of the future supply of energy and other essential resources - including air, land and water - finds that we face shortages and skyrocketing prices, and that, in many ways, we're pushing the environment to dangerous limits. I'd like to know, specifically, what changes you would encourage and require in American lifestyles in automobile use, housing, land use and general consumption, to meet problems that aren't going to respond to campaign lullabies about minor conservation efforts and more production? REAGAN: Well, I believe that conservation, at course, is worthy in and of itself. Anything that would preserve, or help us use less energy, that would be fine, and I'm for it. But I do not believe that conservation alone is the answer to the present energy problem, because all you're doing then is staving off, by a short time, the day when you would come to the end of the energy supply. To say that we are limited, and at a dangerous point in this country with regard to energy, I think, is to ignore the fact. The fact is, that in today's oil wells, there is more oil still there than we have so far taken out and used. But it would require what is known as secondary or tertiary efforts to bring it out of the ground. And this is known oil reserves, known supplies. There are hundreds of millions of acres of land that have been taken out of circulation by the Government for whatever reason they have, that is believed by the most knowledgeable oil geologists to contain probably more oil and natural gas than we have used so far since we drilled that first well 121 years ago. We have a coal supply that is equal to 50% of the world's coal supply, good for centuries, in this country. I grant you that prices may go up, because as you go further and have to go deeper, you are adding to the cost of production. We have nuclear power, which, I believe, with the safest. the most stringent of safety requirements, could meet our energy needs for the next couple of decades while we go forward exploring the areas of solar power and other forms of energy that might be renewable and that would not be exhaustible. All of these things can be done. When you stop and think that we are only drilling on 2%. have leased only 2% of the possible. possibility for oil of the continental shelf around the United States; when you stop to think that the government has taken over 100 million acres of land out of circulation in Alaska, alone, that is believed by geologists to contain much in the line of minerals and energy sources, then I think it is the Government, and the Government with its own restrictions and regulations, that is creating the energy crisis. That we are, indeed, an energy-rich nation. MOYERS: I would like to say at this point that the candidates requested the same questions to be repeated, for the sake of precision, on the part of the interrogator. So, Mr. Greenberg, you may address Mr. Anderson. GREENBERG: Mr. Anderson, I'd like to know specifically, what changes you would encourage and require in American lifestyles in automobile use, housing, land use and consumption, to meet problems that aren't going to respond to campaign lullabies about minor conservation efforts and more production? ANDERSON: Well, Mr. Greenberg, I simply cannot allow to go unpassed the statements that have just been made by Mr. Reagan, who once again, has demonstrated, I think, a total misunderstanding of the energy crisis that confronts, not only this country, but the world, when he suggests that we have 27 years' supply of natural gas, 47 years' supply of oil, and all the rest, and that we really. all we have to do is to get the Government off the back of the oil industry, and that's going to be enough. I agree with what I think is the major premise of your question, sir, that we are going to have to create a new conservation ethic in the minds of the American people. and that's simply why I proposed, 15 months ago, the emergency excise tax on gasoline that I did. I did it as a security measure to be sure, because I would rather see us reduce the consumption of imported oil than have to send American boys to fight in the Persian Gulf. But at the same time, I think it's going to take a dramatic measure of that kind to convince the American people that we will have to reduce the use of the private automobile. We simply cannot have people sitting one behind the wheel of a car in these long traffic jams going in and out of our great cities. We are going to have to resort to van pooling, to car pooling. We're going to have to develop better community transportation systems, so that with buses and light rail, we can replace the private automobile in those places where it clearly is not energy-efficient. I think that, with respect to housing, when we are consuming, even though our per capita income today is about the same as that of the Federal Republic of Germany, we are consuming about, by a factor of two, the amount of energy that they consume in that country. Surely, there are things that we can do in the retrofitting, ;n the redesign of our homes, not only of our houses, but of our commercial structures, as well, that will make it possible for us to achieve. According to one study that was published a short time ago - the Harvard Business School study - indicated that just in the commercial sector alone of the economy, we could save between 30% and 40% of the energy that we consume in this country today. So I think, yes, we will have to change in a very appreciable way, some of the lifestyles that we now enjoy. MOYERS: Mr. Reagan. REAGAN: Well, as I've said, I am not an enemy of conservation. I wouldn't be called a conservative if I were. But, when my figures are challenged, as the President himself challenged them after I made them, I think it should be called to the attention of John and the others here that my figures are the figures of the Department of Energy, which has not been overly optimistic in recent years as to how much supply we have left. That is the same Government that, in 1920, told us we only had enough oil left for 13 years, and 19 years later, told us we only had enough left for another 15 years. As for saving energy and conserving, the American people haven't been doing badly at that. Because in industry today, we're producing more, over the last several years, and at 12% less use of energy than we were back in about 1973. And motorists are using 8% less than they were back at that time of the oil embargo. So, I think we are proving that we can go forward with conservation and benefit from that. But also, I think it is safe to say that we do have sources of energy that have not yet been used or found. MOYERS: Mr. Anderson. ANDERSON: Mr. Greenberg, I think my opponent in this debate tonight is overlooking one other very important fact. And that is, that we cannot look at this as simply a national problem. Even though it's true that, perhaps, between now and the end of the decade, our total consumption of oil may not increase by more than, perhaps, a million or 2 million barrels of oil a day. The rest of the Western world, we are told, may see its consumption increase from 51 million barrels to about 66 million. And that additional 15 million barrels is going to cause scarcity. It is going to cause scarcity in world markets because there are at least five reputable studies, one even by the American Petroleum Institute itself, that, I think, clearly indicate that somewhere along around the end of the present decade, total world demand for oil is simply going to exceed total available supplies. I think that conservation - I think that a change in lifestyles - is necessary, and we had better begin to plan for that now rather than later. MOYERS: This question goes to you, Mr. Anderson, from Charles Corddry. CHARLES CORDDRY, MILITARY CORRESPONDENT,THE SUN , BALTIMORE: Mr. Anderson, you and Mr. Reagan both speak for better defense. for stronger defense and for programs that would mean spending more money. You do not, either of you, however, come to grips with the fundamental problem of manning the forces, of who shall serve, and how the burden will be distributed. This will surely be a critical issue in the next Presidential term. You both oppose the draft. The questions are, how would you fill the under-strength combat forces with numbers and quality, without reviving conscription? And will you commit yourself, here, tonight, should you become the Commander in Chief, to propose a draft, however unpopular, if it becomes clear that voluntary means are not working? ANDERSON: Mr. Corddry, I am well aware of the present deficiencies in the Armed Forces of this country. When you have a report, as we did recently, that six out of 10 CONUS Divisions in this country - Continental United States Army Divisions - simply could not pass a readiness test: that two out of three divisions that were to be allocated to the so-called Rapid Deployment Force could not meet a readiness test. And in most cases, that failure to meet the test was because of a lack of manning requirements, an inability to fill many of the slots in those divisions. Yes, I have seen figures that indicate that perhaps as of September, 1980 - this very month - that there is a shortage of about 104,000 in the ranks between E-4 and E-9. And there were reports. public reports not long ago about ships that could not leave American ports because of a lack of crews. I talked to one of the leading former chiefs of Naval operations in my office a few weeks ago, who told me about 25,000 Chief Petty Officers being short. But, I think that that is clearly related to the fact that, going back to the time when the all-volunteer Army was created in 1973 - and I worked hard for it and supported it - we simply have failed to keep pace with the cost of living. And today, on the average, the average serviceman is at least 15% - and I happen to think that's a very modest estimate - 15% below what has happened to the cost of living over that period of time. And as a result, the families of some of our young servicemen are on food stamps today. And I think that's shocking; it's shameful. So, yes, I told the American Legion National! Convention, the VFW National Convention - when I spoke to each of those bodies - I outlined a very specific program of increasing pay and allowances, reenlistment bonuses. That only makes sense. But I would leave you with this thought, sir, to be quite specific in my answer to your question: that, of course, to protect the vital interests of this country, if that became impossible; if I could not, despite the very best efforts that I asked the Congress to put forward, to raise those pay and incentives and allowances, of course, I would not leave this country go undefended. MOYERS: Mr. Corddry? CORDDRY: Mr. Reagan, I will just repeat the two questions: How would you fill the under-strength combat forces with numbers and with quality, without reviving conscription? And will you commit yourself; here, tonight, should you become the Commander in Chief, to propose a draft, however unpopular, if it becomes clear that voluntary means are not solving our manpower problems? REAGAN: Mr. Corddry, it's a shame now that there are only two of us here debating, because the two that are here are in more agreement than disagreement on this particular issue, and the only one who would be disagreeing with us is the President, if he were present. I. too, believe in the voluntary military. As a matter of fact, today the shortages of non-commissioned officers that John mentioned are such that if we tried to have a draft today, we wouldn't have the non-commissioned officers to train the draftees. I believe the answer lies in just recognizing human nature and how we make everything else work in this country, when we want it to work. Recognize that we have a voluntary military. We are asking for men and women to join the military as a career, and we're asking them to deal with the most sophisticated of equipment. And a young man is out there on a $1 billion carrier in charge of the maintenance of a $20 million aircraft, working 100 hours a week at times, and he's earning less for himself and his family, while he's away from his family, than he could earn if he were in one of the most menial jobs, working 40 hours a week here at home. As an aid to enlistment. we had an aid - 46% of the people who enlisted in the voluntary military up until 1977 said they did so for one particular reason, the G.I. Bill of Rights - the fact that, by serving in the military, they could provide for a future college education. In 1977, we took that away from the military. That meant immediately 46% of your people that were signing up had no reason for signing up. So I think it is a case of pay scale, of recognizing that if we're going to have young men and women responsible for our security, dealing with this sophisticated equipment, then for heaven's sakes, let's go out and have a pay scale that is commensurate with the sacrifice that we're asking of them. Along with this, I think we need something else that has been allowed to deteriorate. We need a million-man active reserve that could be called up on an instant's notice, and that would be also trained, ready to use that type of equipment. Both of these, I think, would respond to the proper kind of incentives that we could offer these people. The other day, I just - I'll hasten - I just saw one example. Down in Texas. I saw a high school that is military. MOYERS: Your time is up, Mr. Reagan. REAGAN: Fine. MOYERS: I'm sorry. REAGAN: I'll catch up with it later. MOYERS: You can finish it after it's over. Mr. Anderson? ANDERSON: Mr. Moyers. I must say that I think I have better opportunity, however, of finding the necessary funds to pay what, admittedly, will be very, very substantial sums of money. We signed one bill. or we passed one bill, just a couple of weeks ago in the House of Representatives for $500 million - a half a billion dollars. That is just a downpayment, in my opinion. But, unlike Governor Reagan, I do not support a boondoggle like the MX missile. I've just gotten a report from the Air Force that indicates that the 30-year lifecycle cost of that system is going to be $100 billion. The initial cost is about $54 billion, and then when you add in the additional costs - not only the construction of the system, the missiles and the personnel, and so on - when you add in the additional costs over the lifecycle of that system, over $100 billion. I would propose to save the taxpayers of this country from that kind of costly boondoggle. MOYERS: Mr. Reagan? REAGAN: Well, let me just say that, with regard to that same missile system, I happen to support and believe in the missile, itself. But that's not the $54 billion cost that John is talking about. He's talking about that fantastic plan of the Administration to take thousands and thousands of square miles out in the Western states. And first, he was going to dig a racetrack and have it going around in the racetrack so it would meet the requirements of SALT II treaty, and now he's decided it'll have a straight up and down thing, so it can he both verifiable and yet hideable from the Soviet Union. We need the missile, I think, because we are so out of balance strategically that we lack a deterrent to a possible first assault. But I am not in favor of the plan that is so costly. And therefore, if I only had another second left, I'd say that that high school class in a military training - 40 of its 80 graduates last year entered the United States service academies; West Point, Annapolis and the Air Force Academy, and to see those young men made me very proud to realize that there are young people in this country that are prepared to go into that kind of a career in service of their country. MOYERS: This question comes to you, Mr. Reagan, from my colleague, Lee May. LEE MAY, STAFF WRITER,THE LOS ANGELES TIMES - WASHINGTON BUREAU: Mr. Reagan, the military is not the only area in crisis. American cities are physically wearing out, as housing, streets, sewers and budgets all fall apart. And all of this is piled upon the emotional strain that comes from refugees and racial confrontations. Now, I'm wondering what specific plans do you have for Federal involvement in saving our cities from these physical and emotional! crises, and how would you carry out those plans in addition to raising military pay, without going against your pledge of fiscal restraint? REAGAN: I don't think I'd have to go against that pledge. I think one of the problems today with the cities is Federal aid. The mayors that I've talked to in some of our leading cities tell! me that the Federal grants that come with. for a specific cause or a specific objective, come with such red tape, such priorities established by a bureaucracy in Washington, that the local government's hands are tied with regard to using that money as they feel could best be used, and for what they think might be the top priority. If they had that money without those government restrictions, every one of them has told me they could make great savings and make far greater use of the money. What I have been advocating is, why don't we start with the Federal Government turning back tax sources to states and local governments, as well as the responsibilities for those programs? Seventy-five percent of the people live in the cities. I don't know of a city in America that doesn't have the kind of problems you're talking about. But, where are we getting the money that the Federal Government is putting out to help them? New York is being taxed for money that will then go to Detroit. But Detroit is being taxed for money that, let's say, will go to Chicago, while Chicago is being taxed to help with the problems in Philadelphia. Wouldn't it make a lot more sense if the government let them keep their own money there in the first place? But there are other things that we can do with the inner cities, and I've believed. I have talked of having zones in those cities that are run down, where there is a high percentage of people on welfare, and offer tax incentives. The government isn't getting a tax now from businesses there because they aren't there, or from individuals who are on welfare rather than working. And why don't we offer incentives for business and industry to start up in those zones? Give them a tax moratorium for a period if they build and develop there. The individuals that would then get jobs - give them a break that encourages them to leave the social welfare programs and go to work. We could have an urban homestead act. We've got thousands and thousands of homes owned by government boarded up, being vandalized, that have been taken in mortgage foreclosures. What if we had a homestead act, and said to the people, for $1 we sell you this house. All have to do is agree to refurbish it, make it habitable, and live in it - just as 100 or more years ago, we did with the open land in this country - urban . or country homesteading. MOYERS: Mr. May? MAY: Mr. Anderson, let me ask you, what specific plans do you have for Federal involvement in saving cities from the physical and emotional crises that confront them, and how would you carry out those plans, in addition to raising military pay, without going against your pledge of fiscal restraint? ANDERSON: Mr. May, I recently saw a Princeton University study that indicated that the cities of America - the large cities of this country - are in worse shape today than they were in 1960. It seems to totally belie the claim that I heard President Carter make a few days ago, that he was the first President that had come forth with a real urban strategy to meet the problems of urban America. Incidentally, just this past week, the crown jewel in that program that he had devised was stolen, I guess, because a conference committee turned down the ambitious plan that he had to increase the amount of money that would be available to the Economic Development Administration for loan guarantees and direct loans and credits. I'm happy to say that, in contrast to that, the Anderson-Lucey platform for America, program for the 80s, has devoted considerable time, and in very specific detail, we have talked about two things that ought to be done to aid urban America. We call, first of all, for the creation of a $4 billion urban reinvestment trust fund to do exactly what you spoke about in your question - to rebuild the streets, to rebuild the cities, the leaking water mains. I was in North Pittsburgh - I think it was a few weeks ago, on my campaign - the water mains in that city had begun to leak, and literally, there wasn't money available to fix them. And until we can begin to recreate the basic infrastructure of the great cities of America, particularly in the upper Midwest and in the Northeast, they simply are not going to provide the kind of economic climate that will enable them to retain industry, enable them to retain the kind of solid industrial base that they need, so that they can provide jobs. We have also provided in our program for a $4 billion Community Trust Fund, and we've told you where the money is coming from. It's going to come from the dedication, by 1984, of the excise revenues that today are being collected by the Federal Government on alcohol and tobacco. That money, I think, ought to be put into rebuilding the base of our cities. In addition to that, jobs programs to re-employ the youth in our cities would be very high on my priority list, both the Youth Opportunities Act of 1980 and a billion-dollar program that I would recommend to put youth to work in energy projects, in conservation projects, in projects that would carry out some of the great national goals of our country. MOYERS: Mr. Reagan, your response. REAGAN: Yes. Government claims. John claims that he is making plain where the money will come from. It will come from the pockets of the people. It will come from the pockets of the people who are living in those very areas. And the problem is, with Governments - Federal, State and Local - taking $.44 out of every dollar earned, that the Federal Government has pre-empted too many of the tax sources, and that the cities. if Pittsburgh does not have the money to fix the leaking water mains, it's because the Federal Government has pre-empted. Now, the Federal Government is going to turn around and say, well you have this problem; we will now hand you the money to do it. But the Federal Government doesn't make money. It just takes - from the people. And in my view, this is not the answer to the problem. Stand in the South Bronx as I did, in the spot where Jimmy Carter made his promise that he was going to, with multi-billion dollar programs, refurbish that area that looks like bombed-out London in World War II. I stood there, and I met the people. And I heard them ask just for something that would give them hope. And I believe that, while all of the promises have been broken, they've never been carried out. But I believe that my plan might offer an opportunity for that, if we would move into those areas and let, encourage - with the tax incentive - the private sector, to develop and to create the jobs for the people. MOYERS: Mr. Anderson. ANDERSON: Well, of course, where has the private sector been, Governor Reagan, during the years that our cities have been deteriorating? It seems to me that to deny the responsibility of the Federal Government to do something about our crumbling cities is to deny the opportunity for one thing: To 55% of the black population of our country that is locked within the inner cities of the metropolitan areas of our country. We simply cannot ignore the fact that, in those cities today, we have 55% youth unemployment among black and Hispanic youth. And why is that? It's because they have lost their industry. And why have they lost their industry? It's because they no longer present the kind of viable economic climate that makes it possible for industry to remain there, or to locate there. I think Government has a responsibility to find jobs for the youth of this country, and that the place to start is to assist in the very important and necessary task of helping cities rebuild. MOYERS: Jane Bryant Quinn has the next question, for you, Mr. Anderson. JANE BRYANT QUINN, CBS NEWS/NEWSWEEK /WASHINGTON POST : Mr. Anderson, many voters are very worried that tax cuts, nice as they are, will actually add to inflation. And many eminent conservatives have testified that even business tax cuts, as you have proposed, can be inflationary as long as we have a budget deficit. Now, Mr. Reagan has mentioned that he put out a five-year economic forecast, which indeed he did, but it contained no inflation number. You have published a detailed program, but it too does not have any hard numbers on it about how these things work with inflation. So I would like to ask you, if you will commit to publish specific forecasts within two weeks, so that the voters can absorb them and understand them and analyze them, showing exactly what al these problems you've mentioned tonight - on energy, on defense, on the cities - how these impact on inflation, and what inflation's actually going to be over five years. ANDERSON: Miss Quinn, I would be very happy to accept the challenge of your question tonight, to tell the voters of this country exactly what I think it's going to cost, because I believe that all too often in past elections, politicians have simply been promising people things that they cannot deliver. When these Presidential Debates were held just four years ago, I remember the incumbent President, who was willing to debate, President Ford, telling the American people that they simply ought not to vote for somebody who promised more than they could deliver. Well, we've seen what has happened. We haven't gotten either the economies in Government that were promised; we haven't gotten the 4% inflation that we were supposed to get at the end of Mr. Carter's first term. Instead we had, I think, in the second quarter, a Consumer Price Index registering around 12%. And nobody really knows, with the latest increase in the Wholesale Price Index - that's about 18% on an annualized basis - what it's going to be. Let me say this. I think my programs are far less inflationary than those of Governor Reagan. His own running mate, when he was running for the Presidency, said that they would cost 30% inflation inside of two years, and he cited his leading economic advisor, a very distinguished economist, Paul Macavoy, as the source of that information. He went so far as to call it "brutal economics." I've been very careful - I have been very careful in saying that what I'm going to do is to bring Federal spending under control first. I would like to stand here and promise the American people a tax cut, as Governor Reagan has done. But, you know, it's gotten to be about $122 difference. Somebody worked it out. And they figured out that between the tax cut that Governor Reagan is promising the American people, and the tax cut that Jimmy Carter is promising in 198I, his is worth about $122 more. So you, dear voters, are out there on the auction block, and these two candidates are bidding for your votes. And one is going to give you $122 more if you happen to be in that range of about a $20,000-a-year income. I'm going to wait until I see that that inflation rate is going down, before I even begin to phase in the business tax cuts that I've talked about. But I think, by improving productivity, they would be far less inflationary than the consumption-oriented tax cut that Governor Reagan is recommending. MOYERS: Ms. Quinn. QUINN: Mr. Anderson, I'll call you for that forecast. Mr. Reagan, will you publish specific forecasts within two weeks, so that the voters can have time to analyze and absorb them before the election, showing exactly what all these things you've discussed tonight - for energy, cities and defense - mean for inflation over the next five years? REAGAN: Miss Quinn, I don't have to. I've done it. We have a back-up paper to my economic speech of a couple of weeks ago in Chicago, that gives all of the figures. And we used - yes, we used - the Senate Budget Committee's projections for five years, which are based on an average inflation rate of 7.5% - which, I think, that under our plan, can be eliminated. And eliminated probably more quickly than our plan, but we wanted to be so conservative with it, that people would see how. how well it could be done. Now, John's been in the Congress for 20 years. And John tells us that first, we've got to reduce spending before we can reduce taxes. Well, if you've got a kid that's extravagant, you can lecture him all you want to about his extravagance. Or you can cut his allowance and achieve the same end much quicker. But Government has never reduced Government does not tax to get the money it needs. Government always needs the money it gets. And when John talks about his non-inflationary plan, as far as I have been able to learn, there are 88 proposals in it that call for additional Government spending programs. Now, I speak with some confidence of our plan, because I took over a state - California - 10% of the population of this nation - a state that, if it were a nation, would be the seventh-ranking economic power in the world. And that state we controlled spending. We cut the rate of increase in spending in half. But at the same time, we gave back to the people of California - in tax rebates, tax credits, tax cuts - $5.7 billion. I vetoed 993 measures without having a veto overturned. And among those vetoes, I stopped $16 billion in additional spending. And the funny thing was that California, which is normally above the national average in inflation and unemployment, for those six years for the first time, was below the national average in both inflation and unemployment. We have considered inflation in our figures. We deliberately took figures that we, ourselves, believed were too conservative. I believe the budget can be balanced by 1982 or 1983, and it is a combination of planned reduction of the tax increase that Carter has built into the economy, and that's what he's counting on for his plan. But he's going to get a half-a-trillion dollars more over the next five years that he can use for additional programs, or hopefully, someplace down the line, balancing the budget. We believe that that's too much additional money to take out of the pockets of the people. MOYERS: Mr. Anderson. ANDERSON: Mr. Moyers, I'm not here to debate Governor Reagan's record as Governor. This is 1980 and not 1966. But I do know that, despite his pledge to reduce state Government spending, that it rose from $4.6 billion when he took office in 1967, to $10.2 billion during his eight years in office. Spending, in other words. more than doubled, and it rose at a faster rate than spending was rising in the Federal Government. But on his very optimistic figures about his tax cut producing a balanced budget by 1983, and the fact that he is using, he says, the figures of the Senate Budget Committee, that Senate Budget Committee Report does not accommodate all of the Reagan defense plans. It doesn't accommodate the expenditures that he calls for, for accelerated development and deployment of a new manned strategic bomber, for a permanent fleet in the Indian Ocean, for the restoration of the fleet to 600 ships, to the development and deployment of a dedicated modern aircraft interceptor. In other words, I have seen his program costed out to the point where it would amount to more than $300 million a year, just for the military. And I think the figures that he has given are simply not going to stand up. MOYERS: Would would you have a comment, Mr. Reagan? REAGAN: Well, some people look up figures, and some people make up figures. And John has just made up some very interesting figures. We took the Senate report, of course. But we did factor in our own ideas with regard to increases in the projected military spending that we believe would, over a period of time, do what is necessary. Now also, with regard to the figures about California. The truth of the matter is, we did cut the increase in spending in half. It at the John doesn't quite realize - he's never held an executive position of that kind. And I think being Governor of California is probably the closest thing to the Presidency, if that's possible, of any executive job in America today - because it is the most populous state. And I can only tell him that we reduced, in proportion of other states, the per capita spending, the per capita size of Government - we only increased the size of Government one-twelfth what it had increased in the preceding eight years. And one journal, the San Francisco Chronicle, a respected newspaper, said there was no question about the fact that Governor Reagan had prevented the State of California from going bankrupt. MOYERS: Our final question comes from Soma Golden, and it's directed to Mr. Reagan. GOLDEN, EDITORIAL WRITER,THE NEW YORK TIMES : I'd like to switch the focus from inflation to God. This week, Cardinal Medeiros of Boston warned Catholics that it's sinful to vote for candidates who favor abortion. This did not defeat the two men he opposed, but it did raise questions about the roles of church and state. You. Mr. Reagan, have endorsed the participation of fundamentalist churches in your campaign. And you, Mr. Anderson, have tried three times to amend the Constitution to recognize the, quote, "law and authority," unquote, of Jesus Christ. My question: Do you approve of the Church's actions this week in Boston? And should a President be guided by organized religion on issues like abortion, equal rights, and defense spending? MOYERS: Mr. Reagan. GOLDEN: Mr. Reagan. REAGAN: Oh, I'm it's my question. But whether I agree or disagree with some individual, or what he may say, or how he may say it, I don't think there's any way that we can suggest that because people believe in God and go to church, that they should not want reflected in those people and those causes they support, their own belief in morality, and in the high traditions and principles which we've abandoned so much in this country. Going around this country, I think that I have found a great hunger in America for a spiritual revival. For a belief that law must be based on a higher law. For a return to traditions and values that we once had. Our Government, in its most sacred documents - the Constitution and the Declaration of Independence and all - speak of man being created, of a Creator. That we're a nation under God. Now, I have thought for a long time that too many of our churches have been too reluctant to speak up in behalf of what they believe is proper in Government, and they have been too too lax in interfering, in recent years, with Government's invasion of the family itself, putting itself between parent and child. I vetoed a number of bills of that kind myself, when I was in California. Now, whether it is rightful, on a single issue, for anyone to advocate that someone should not be elected or not, I won't take a position on that. But I do believe that no one in this country should be denied the right to express themselves, or to even try to persuade others to follow their leader. That's what elections are all about. MOYERS: Ms. Golden. GOLDEN: Okay. I would point out that churches are tax-exempt institutions, and I'll repeat my question. Do you approve the Church's action this week in Boston, and should a President be guided by organized religion on issues like abortion, equal rights and defense spending? ANDERSON: Ms. Golden, certainly the church has the right to take a position on moral issues. But to try, as occurred in the case that you mentioned - that specific case - to try to tell the parishioners of any church, of any denomination, how they should vote, or for whom they should vote, I think violates the principle of separation of church and state. Now, Governor Reagan is running on a platform that calls for a Constitutional amendment banning abortion. I think that is a moral issue that ought to be left to the freedom of conscience of the individual. And for the state to interfere with a Constitutional amendment, and tell a woman that she must carry that pregnancy to term, regardless of her personal belief, that, I think, violates freedom of conscience as much as anything that I can think of. And he is also running on a platform that suggests a litmus test for the selection of judges - that only judges that hold a certain, quote, "view," on the sanctity of family life, ought to be appointed to the Federal Judiciary, one of the three great independent branches of our Government. No. I believe in freedom of choice. I don't believe in Constitutional Amendments that would interfere with that. I don't believe in trying to legislate new tests for the selection of the Federal Judiciary. On the Amendment that you mentioned, I abandoned it 15 years ago. And I have said freely, all over this country, that it was a mistake for me or anyone to ever try to put the Judeo-Christian heritage of this country, important as it is, and important as my religious faith is to me - it's a very deeply personal matter. But for me to try, in this very pluralistic society of ours, to try to frame any definition, whatever, of what that belief should be, is wrong. And so, not once, but twice - in 1971 - I voted on the floor of the House of Representatives against a Constitutional amendment that tried to bring prayer back into the public schools. I think mother ought to whisper to Johnny and to Susie, as they button their coats in the morning and leave for the classroom, "Be sure to say a prayer before you start your day's work." But I don't think that the state, the Board of Regents, a Board of Education, or any state official, should try to compose that prayer for a child to recite. MOYERS: Mr. Reagan. REAGAN: The litmus test that John says is in the Republican platform, says no more than the judges to be appointed should have a respect for innocent life. Now, I don't think that's a bad idea. I think all of us should have a respect for innocent life. With regard to the freedom of the individual for choice with regard to abortion, there's one individual who's not being considered at all. That's the one who is being aborted. And I've noticed that everybody that is for abortion has already been born. I I think that, technically, I know this is a difficult and an emotional problem, and many people sincerely feel on both sides of this, but I do believe that maybe we could find the answer through medical evidence, if we would determine once and for all, is an unborn child a human being? I happen to believe it is. MOYERS: Mr. Anderson. ANDERSON: I also think that that unborn child has a right to be wanted. And I also believe, sir, that the most personal intimate decision that any woman is ever called upon to make is the decision as to whether or not she shall carry a pregnancy to term. And for the state to interfere in that decision, under whatever guise, and with whatever rationale, for the state to try to take over in that situation, and by edict, command what the individual shall do, and substitute itself for that individual's conscience, for her right to consult her rabbi, her minister, her priest, her doctor - any other counselor of her choice - I think goes beyond what we want to ever see accomplished in this country, if we really believe in the First Amendment: if we really believe in freedom of choice and the right of the individual. MOYERS: Mr. Reagan you now have three minutes for closing remarks. REAGAN: Before beginning my closing remarks, here, I would just like to remark a concern that I have that we have criticized the failures of the Carter policy here rather considerably, both of us this evening. And there might be some feeling of unfairness about this because he was not here to respond. But I believe it would have been much more unfair to have had John Anderson denied the right to participate in this debate. And I want to express my appreciation to the League of Women Voters for adopting a course with which I believe the great majority of Americans are in agreement. Now, as to my closing remarks: I've always believed that this land was placed here between the two great oceans by some divine plan. That it was placed here to be found by a special kind of people - people who had a special love for freedom and who had the courage to uproot themselves and leave hearth and homeland, and came to what, in the beginning, was the most undeveloped wilderness possible. We came from 100 different corners of the earth. We spoke a multitude of tongues. We landed on this Eastern shore and then went out over the mountains and the prairies and the deserts and the far western mountains to the Pacific, building cities and towns and farms, and schools and churches. If wind, water or fire destroyed them, we built them again. And in so doing, at the same time, we built a new breed of human called an American - a proud, an independent., and a most compassionate individual, for the most part. Two hundred years ago, Tom Paine, when the 13 tiny colonies were trying to become a nation, said, we have it in our power to begin the world over again. Today. we're confronted with the horrendous problems that we've discussed here tonight. And some people in high positions of leadership, tell us that the answer is to retreat. That the best is over. That we must cut back. That we must share in an ever-increasing scarcity. That we must, in the failure to be able to protect our national security as it is today, we must not be provocative to any possible adversary. Well, we, the living Americans, have gone through four wars. We've gone through a Great Depression in our lifetime that literally was worldwide and almost brought us to our knees. But we came through all of those things and we achieved even new heights and new greatness. The living Americans today have fought harder, paid a higher price for freedom, and done more to advance the dignity of man than any people who ever lived on this earth. For 200 years, we've lived in the future, believing that tomorrow would be better than today, and today would be better than yesterday. I still believe that. I'm not running for the Presidency because I believe that I can solve the problems we've discussed tonight. I believe the people of this country can, and together, we can begin the world over again. We can meet our destiny - and that destiny to build a land here that will be, for all mankind, a shining city on a hill. I think we ought to get at it. MOYERS: Mr. Anderson, you have the final three minutes. ANDERSON: Mr. Movers, President Carter was not right a few weeks ago when he said that the American people were confronted with only two choices, with only two men, and with only two parties. I think you've seen tonight in this debate that Governor Reagan and I have agreed on exactly one thing - we are both against the reimposition of a peacetime draft. We have disagreed, I believe, on virtually every other issue. I respect him for showing tonight - for appearing here, and I thank the League of Women Voters for the opportunity that they have given me. I am running for President as an Independent because I believe our country is in trouble. I believe that all of us are going to have to begin to work together to solve our problems. If you think that I am a spoiler, consider these facts: Do you really think that our economy is healthy? Do you really think that 8 million Americans being out of work and the 50% unemployment among the youth of our country are acceptable? Do you really think that our armed forces are really acceptably strong in those areas of conventional capability where they should be? Do you think that our political institutions are working the way they should when literally only half of our citizens vote? I don't think you do think that. And therefore, I think you ought to consider doing something about it, and voting for an Independent in 1980. You know, a generation of office seekers has tried to tell the American people that they could get something for nothing. It's been a time, therefore, of illusion and false hopes, and the longer it continues, the more dangerous it becomes. We've got to stop drifting. What I wish tonight so desperately is that we had had more time to talk about some of the other issues that are so fundamentally important. A great historian, Henry Steele Commager, said that in their lust for victory, neither traditional party is looking beyond November. And he went on to cite three issues that their platforms totally ignore: atomic warfare, Presidential Directive 59 notwithstanding. If we don't resolve that issue, all others become irrelevant. The issue of our natural resources; the right of posterity to inherit the earth, and what kind of earth will it be? The issue of nationalism - the recognition, he says, that every major problem confronting us is global, and cannot be solved by nationalism here or elsewhere - that is chauvinistic, that is parochial, that is as anachronistic as states' rights was in the days of Jefferson Davis. Those are some of the great issues - atomic warfare, the use of our natural resources, and the issue of nationalism - that I intend to be talking about in the remaining six weeks of this campaign, and I dare hope that the American people will be listening and that they will see that an Independent government of John Anderson and Patrick Lucey can give us the kind of coalition government that we need in 1980 to begin to solve our problems. Thank you. MOYERS: Mr. Anderson, we, too, wish there were more time, and for all the limitations of the form - and there are other forms to try - the Chair, for one, would like to see such meetings become a regular and frequent part of every Presidential campaign. Mr. Reagan, Mr. Anderson, we thank you for coming, and thanks to our panelists, Carol Loomis, Daniel Greenberg, Charles Corddry, Lee May, Jane Bryant Quinn and Soma Golden. And thank you in the audience at home for joining us. This first Presidential Debate of 1980 has been brought to you as a public service by the League of Women Voters Education Fund. I'm Bill Moyers. Good night.
