# Presidential Debate in St. Louis, Missouri

**Date:** October 8, 2004
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-st-louis-missouri

---

Charles Gibson. Good evening from the Field House at Washington University in St. Louis. I'm Charles Gibson of ABC News and "Good Morning America." I welcome you to the second of the 2004 Presidential debates between President George W. Bush, the Republican nominee, and Senator John Kerry, the Democratic nominee. The debates are sponsored by the Commission on Presidential Debates. Tonight's format is going to be a bit different. We have assembled a townhall meeting. We're in the "Show Me" State, as everyone knows Missouri to be, so Missouri residents will ask the questions, these 140 citizens who were identified by the Gallup Organization as not yet committed in this election. Now, earlier today each audience member gave me two questions on cards like this: One they'd like to ask of the President; the other they'd like to ask the Senator. I have selected the questions to be asked and the order. No one has seen the final list of questions but me—certainly not the candidates. No audience member knows if he or she will be called upon. Audience microphones will be turned off after a question is asked. Audience members will address their question to a specific candidate. He'll have 2 minutes to answer. The other candidate will have a minute and a half for rebuttal. And I have the option of extending discussion for 1 minute, to be divided equally between the two men. All subjects are open for discussion. And you probably know the light system by now, green light at 30 seconds, yellow at 15, red at 5, and flashing red means you're done. Those are the candidates' rules. I will hold the candidates to the time limits forcefully, but politely, I hope. And now please join me in welcoming, with great respect, President Bush and Senator Kerry. Gentlemen, to the business at hand. The first question is for Senator Kerry, and it will come from Cheryl Otis, who is right behind me. Consistent Leadership Cheryl Otis. Senator Kerry, after talking to several coworkers and family and friends, I asked the ones who said they were not voting for you, why. They said that you were too wishy-washy. Do you have a reply for them? Senator John F. Kerry. Yes, I certainly do. [Laughter] But let me just first, Cheryl, if you will, I want to thank Charlie for moderating. I want to thank Washington University for hosting us here this evening. Mr. President, it's good to be with you again this evening, sir. Cheryl, the President didn't find weapons of mass destruction in Iraq, so he's really turned his campaign into a weapon of mass deception. And the result is that you've been bombarded with advertisements suggesting that I've changed a position on this or that or the other. Now, the three things they try to say I've changed position on are the PATRIOT Act—I haven't. I support it. I just don't like the way John Ashcroft has applied it. And we're going to change a few things. The chairman of the Republican Party thinks we ought to change a few things. No Child Left Behind Act—I voted for it. I support it. I support the goals. But the President has underfunded it by $28 billion. Right here in St. Louis, you've laid off 350 teachers. You're 150—excuse me, I think it's a little more—about $100 million shy of what you ought to be under the No Child Left Behind Act to help your education system here. So I complain about that. I've argued that we should fully fund it. The President says I've changed my mind. I haven't changed my mind. I'm going to fully fund it. So these are the differences. Now, the President has presided over the economy where we've lost 1.6 million jobs, the first President in 72 years to lose jobs. I have a plan to put people back to work. That's not wishy-washy. I'm going to close the loopholes that actually encourage companies to go overseas. The President wants to keep them open. I think I'm right. I think he's wrong. I'm going to give you a tax cut. The President gave—the top one percent of income earners in America got $89 billion last year, more than the 80 percent of people who earn $100,000 or less all put together. I think that's wrong. That's not wishy-washy, and that's what I'm fighting for—you. Mr. Gibson. Mr. President, a minute and a half. President Bush. Charlie, thank you, and thank our panelists. Senator, thank you. I can—and thanks, Washington U. as well. I can see why people at your workplace think he changes positions a lot, because he does. He said he voted for the $87 billion and—or voted against it right before he voted for it. And that sends a confusing signal to people. He said he thought Saddam Hussein was a grave threat and now said it was a mistake to remove Saddam Hussein from power. No, I can see why people think that he changes position quite often, because he does. You know, for a while, he was a strong supporter of getting rid of Saddam Hussein. He saw the wisdom, until the Democratic primary came along and Howard Dean, the antiwar candidate, began to gain on him. And he changed positions. I don't see how you can lead this country in a time of war, in a time of uncertainty, if you change your mind because of politics. He just brought up the tax cut. You remember, we increased that child credit by $1000, reduced the marriage penalty, created a 10-percent tax bracket for the lower income Americans—that's right at the middle class. He voted against it, and yet he tells you he's for a middle-class tax cut. It's—you've got to be consistent when you're the President. There's a lot of pressures, and you've got to be firm and consistent. Mr. Gibson. Mr. President, I would follow up, but we have a series of questions on Iraq, and so I will turn to the next questioner. The question for President Bush, and the questioner is Robin Dahle. Iraqi Weapons of Mass Destruction Robin Dahle. Mr. President—— Mr. Gibson. Can you get a microphone, Robin, I'm sorry. Mr. Dahle. Mr. President, yesterday in a statement you admitted that Iraq did not have weapons of mass destruction but justified the invasion by stating, I quote, "He retained the knowledge, the materials, the means, and the intent to produce weapons of mass destruction and could have passed this knowledge to our terrorist enemies." Do you sincerely believe this to be a reasonable justification for invasion when this statement applies to so many other countries, including North Korea? President Bush. Each situation is different, Robin. And obviously, we hope that diplomacy works before you ever use force. The hardest decision a President makes is ever to use force. After 9/11, we had to look at the world differently. After 9/11, we had to recognize that when we saw a threat, we must take it seriously before it comes to hurt us. In the old days, we'd see a threat, and we could deal with it if we felt like it or not. But 9/11 changed it all. I vowed to our countrymen that I would do everything I could to protect the American people. That's why we're bringing Al Qaida to justice. Seventy-five percent of them have been brought to justice. That's why I said to Afghanistan, "If you harbor a terrorist, you're just as guilty as the terrorist." And the Taliban is no longer in power, and Al Qaida no longer has a place to plan. And I saw a unique threat in Saddam Hussein, as did my opponent, because we thought he had weapons of mass destruction. And the unique threat was that he could give weapons of mass destruction to an organization like Al Qaida, and the harm they inflicted on us with airplanes would be multiplied greatly by weapons of mass destruction. And that was a serious, serious threat. So I tried diplomacy. I went to the United Nations. But as we learned in the same report I quoted, Saddam Hussein was gaming the Oil for Food Programme to get rid of sanctions. He was trying to get rid of sanctions for a reason. He wanted to restart his weapons programs. We all thought there was weapons there, Robin. My opponent thought there was weapons there. That's why he called him a grave threat. I wasn't happy when we found out there wasn't weapons, and we've got an intelligence group together to figure out why. But Saddam Hussein was a unique threat, and the world is better off without him in power. And my opponent's plans lead me to conclude that Saddam Hussein would still be in power and the world would be more dangerous. Thank you, sir. Mr. Gibson. Senator Kerry, a minute and a half. Senator Kerry. Robin, I'm going to answer your question. I'm also going to talk— respond to what you asked, Cheryl, at the same time. The world is more dangerous today. The world is more dangerous today because the President didn't make the right judgments. Now, the President wishes that I had changed my mind. He wants you to believe that, because he can't come here and tell you that he's created new jobs for America. He's lost jobs. He can't come here and tell you that he's created health care for Americans because one-point—what, we've got 5 million Americans who have lost their health care, 96,000 of them right here in Missouri. He can't come here and tell you that he's left no child behind because he didn't fund No Child Left Behind. So what does he do? He's trying to attack me. He wants you to believe that I can't be President, and he's trying to make you believe it because he wants you to think I change my mind. Well, let me tell you straight up, I've never changed my mind about Iraq. I do believe Saddam Hussein was a threat. I always believed he was a threat—believed it in 1998 when Clinton was President. I wanted to give Clinton the power to use force if necessary. But I would have used that force wisely. I would have used that authority wisely, not rushed to war without a plan to win the peace. I would have brought our allies to our side. I would have fought to make certain our troops had everybody possible to help them win the mission. This President rushed to war, pushed our allies aside, and Iran now is more dangerous, and so is North Korea with nuclear weapons. He took his eye off the ball, off of Usama bin Laden. Mr. Gibson. Mr. President, I do want to follow up on this one, because there were several questions from the audience along this line. President Bush. Are we going to have a rebuttal thing back and forth? Mr. Gibson. Well, I was going to have you do it with the rebuttal. But you go ahead. [Laughter] You're up. President Bush. Remember the last debate? My opponent said that America must pass a global test before we use force to protect ourselves. That's the kind of mindset that says sanctions were working. That's the kind of mindset that says let's keep it at the United Nations and hope things go well. Saddam Hussein was a threat because he could have given weapons of mass destruction to terrorist enemies. Sanctions were not working. The United Nations was not effective at removing Saddam Hussein. Mr. Gibson. Senator? Senator Kerry. The goal of the sanctions was not to remove Saddam Hussein. It was to remove the weapons of mass destruction. And Mr. President, just yesterday the Duelfer report told you and the whole world they worked. He didn't have weapons of mass destruction, Mr. President. That was the objective. And if we had used smart diplomacy, we could have saved $200 billion and an invasion of Iraq, and right now Usama bin Laden might be in jail or dead. That's the war against terror. Mr. Gibson. We're going to have another question now on the subject of Iraq. And I'm just going to turn to Anthony Baldi with a question for Senator Kerry. Mr. Baldi. Iraq/War on Terror Anthony Baldi. Senator Kerry, the U.S. is preparing a new Iraq Government, and we'll proceed to withdraw U.S. troops. Would you proceed with the same plans as President Bush? Senator Kerry. Anthony, I would not. I have laid out a different plan because the President's plan is not working. You see that every night on television. There's chaos in Iraq. King Abdullah of Jordan said just yesterday—or the day before, you can't hold elections in Iraq with the chaos that's going on today. Senator Richard Lugar, the Republican chairman of the Foreign Relations Committee, said that the handling of the reconstruction aid in Iraq by this administration has been "incompetent." Those are the Republican chairman's words. Senator Hagel of Nebraska said that the handling of Iraq is "beyond pitiful, beyond embarrassing. It's in the zone of dangerous." Those are the words of two Republicans, respected, both on the Foreign Relations Committee. Now, I have to tell you, I would do something different. I would reach out to our allies in a way that this President hasn't. He pushed them away time and again, pushed them away at the U.N., pushed them away individually. Two weeks ago, there was a meeting of the North Atlantic Council, which is the political arm of NATO. They discussed the possibility of a small training unit or having a total takeover of the training in Iraq. Did our administration push for the total training of Iraq? No. Were they silent? Yes. Was there an effort to bring all the allies together around that? No—because they've always wanted this to be an American effort. You know, they even had the Defense Department issue a memorandum saying don't bother applying for assistance or for being part of the reconstruction if you weren't part of our original coalition. Now, that's not a good way to build support and reduce the risk for our troops and make America safer. I'm going to get the training done for our troops. I'm going to get the training of Iraqis done faster, and I'm going to get our allies back to the table. President Bush. Two days ago in the Oval Office, I met with the Finance Minister from Iraq. He came to see me, and he talked about how optimistic he was and the country was about heading toward elections. Think about it. They're going from tyranny to elections. He talked about the reconstruction efforts that are beginning to take hold. He talked about the fact that Iraqis love to be free. He said he was optimistic when he came here. Then he turned on the TV and listened to the political rhetoric, and all of a sudden he was pessimistic. This is a guy who, along with others, has taken great risk for freedom, and we need to stand with him. My opponent says he has a plan—sounds familiar because it's called the Bush plan. We're going to train troops, and we are. We'll have 125,000 trained by the end of December. We're spending about $7 billion. He talks about a grand idea: Let's have a summit; we're going to solve the problem in Iraq by holding a summit. And what is he going to say to those people that show up to the summit? "Join me in the wrong war at the wrong time at the wrong place"? Risk your troops in a war you've called a "mistake"? Nobody is going to follow somebody who doesn't believe we can succeed and somebody who says the war where we are is a "mistake." I know how these people think. I meet with them all the time. I talk to Tony Blair all the time. I talk to Silvio Berlusconi. They're not going to follow an American President who says, "Follow me into a mistake." Our plan is working. We're going to make elections, and Iraq is going to be free, and America will be better off for it. Mr. Gibson. Do you want to follow up, Senator? Senator Kerry. Yes, sir, please. Ladies and gentlemen, the right war was Usama bin Laden and Afghanistan. That was the right place, and the right time was Tora Bora, when we had him cornered in the mountains. Now, everyone in the world knows that there were no weapons of mass destruction. That was the reason Congress gave him the authority to use force, not after excuse to get rid of the regime. Now we have to succeed. I've always said that. I have been consistent. Yes, we have to succeed, and I have a better plan to help us do it. President Bush. First of all, we didn't find out he didn't have weapons until we got there, and my opponent thought he had weapons and told everybody he thought he had weapons. And secondly, it's a fundamental misunderstanding to say that the war on terror is only Usama bin Laden. The war on terror is to make sure that these terrorist organizations do not end up with weapons of mass destruction. That's what the war on terror is about. Of course we're going to find Usama bin Laden. We've already got 75 percent of his people, and we're on the hunt for him. But this is a global conflict that requires firm resolve. Mr. Gibson. The next question is for President Bush, and it comes from Nikki Washington. President's Decisionmaking on Iraq Nikki Washington. Thank you. Mr. President, my mother and sister traveled abroad this summer, and when they got back, they talked to us about how shocked they were at the intensity of aggravation that other countries had with how we handled the Iraq situation. Diplomacy is, obviously, something that we have to really work on. What is your plan to repair relations with other countries, given the current situation? President Bush. No, I appreciate that. I—listen, I—we've got a great country. I love our values. And I recognize I've made some decisions that have caused people to not understand the great values of our country. I remember when Ronald Reagan was the President. He stood on principle. Some might have called that stubborn. He stood on principle, standing up to the Soviet Union. And we won that conflict, yet at the same time, he was very—we were very unpopular in Europe because of decisions he made. I recognize that taking Saddam Hussein out was unpopular, but I made the decision because I thought it was in the right interests of our security. You know, I've made some decisions on Israel. That's unpopular. I wouldn't deal with Arafat because I felt like he had let the former President down, and I don't think he's the kind of person that can lead toward a Palestinian state. And people in Europe didn't like that decision. And that was unpopular, but it was the right thing to do. I believe Palestinians ought to have a state, but I know they need leadership that's committed to democracy and freedom, leadership that will be willing to reject terrorism. I made a decision not to join the International Criminal Court in The Hague, which is where our troops could be brought to—brought in front of a judge, an unaccounted judge. I don't think we ought to join that. That was unpopular. And so what I'm telling you is, is that sometimes in this world you make unpopular decisions because you think they're right. We'll continue to reach out. Listen, there's 30 nations involved in Iraq, some 40 nations involved in Afghanistan. People love America. Sometimes they don't like the decisions made by America, but I don't think you want a President who tries to become popular and does the wrong thing. You don't want to join the International Criminal Court just because it's popular in certain capitals in Europe. Mr. Gibson. Senator Kerry, a minute and a half. Senator Kerry. Nikki, that's a question that's been raised by a lot of people around the country. Let me address it but also talk about the weapons the President just talked about, because every part of the President's answer just now promises you more of the same over the next 4 years. The President stood right here in this hall 4 years ago, and he was asked a question by somebody just like you: Under what circumstances would you send people to war? And his answer was: With a viable exit strategy and only with enough forces to get the job done. He didn't do that. He broke that promise. We didn't have enough forces. General Shinseki, the Army Chief of Staff, told him he was going to need several hundred thousand. And guess what? They retired General Shinseki for telling him that. This President hasn't listened. I went to meet with the members of the Security Council in the week before we voted. I went to New York. I talked to all of them to find out how serious they were about really holding Saddam Hussein accountable. I came away convinced that if we worked at it, if we were ready to work at letting Hans Blix do his job and thoroughly go through the inspections, that if push came to shove, they'd be there with us. But the President just arbitrarily brought the hammer down and said, "Nope, sorry, time for diplomacy is over. We're going." He rushed to war without a plan to win the peace. Ladies and gentlemen, he gave you a speech and told you he'd plan carefully, take every precaution, take our allies with us. He didn't. He broke his word. Mr. Gibson. Mr. President. President Bush. I remember sitting in the White House, looking at those generals, saying, "Do you have what you need in this war? Do you have what it takes?" I remember going down in the basement of the White House the day we committed our troops—as last resort—looking at Tommy Franks and the generals on the ground, asking them, "Do we have the right plan with the right troop level?" And they looked me in the eye and said, "Yes, sir, Mr. President." Of course I listened to our generals. That's what a President does. A President sets the strategy and relies upon good military people to execute that strategy. Mr. Gibson. Senator. Senator Kerry. You rely on good military people to execute the military component of the strategy, but winning the peace is larger than just the military component. General Shinseki had the wisdom to say you're going to need several hundred thousand troops to win the peace. The military's job is to win the war. The President's job is to win the peace. The President did not do what was necessary, didn't bring in enough nations, didn't deliver the help, didn't close off the borders, didn't even guard the ammo dumps. And now our kids are being killed with ammos right out of that dump. Mr. Gibson. The next question is for Senator Kerry, and it comes from over here, from Randee Jacobs. You'll need a microphone. Senator Kerry. Is it Randee? I'm sorry. Iran/North Korea Randee Jacobs. Yes, Randee. Iran sponsors terrorism and has missiles capable of hitting Israel and southern Europe. Iran will have nuclear weapons in 2 to 3 years' time. In the event that U.N. sanctions don't stop this threat, what will you do as President? Senator Kerry. I don't think you can just rely on U.N. sanctions, Randee, but you're absolutely correct. It is a threat. It's a huge threat. And what's interesting is it's a threat that has grown while the President has been preoccupied with Iraq, where there wasn't a threat. If he'd let the inspectors do their job and go on, we wouldn't have 10 times the numbers of forces in Iraq that we have in Afghanistan chasing Usama bin Laden. Meanwhile, while Iran is moving towards nuclear weapons—some 37 tons of what they call yellow cake, the stuff they use to make enriched uranium—while they're doing that, North Korea has moved from one bomb, maybe—maybe—to 4 to 7 bombs. For 2 years the President didn't even engage with North Korea, did nothing at all, while it was growing more dangerous, despite the warnings of people like former Secretary of Defense William Perry, who negotiated getting television cameras and inspectors into that reactor. We were safer before President Bush came to office. Now, they have the bombs, and we're less safe. So what do we do? We've got to join with the British and the French, with the Germans who've been involved in their initiative. We've got to lead the world now to crack down on proliferation as a whole. But the President has been slow to do that even in Russia. At his pace, it's going to take 13 years to reduce and get a hold of all the loose nuclear material in the former Soviet Union. I've proposed a plan that can capture it and contain it and clean it within 4 years. And the President is moving toward the creation of our own bunker-busting nuclear weapon. It's very hard to get other countries to give up their weapons when you're busy developing a new one. I'm going to lead the world in the greatest counterproliferation effort, and if we have to get tough with Iran, believe me, we will get tough. Mr. Gibson. Mr. President, a minute and a half. President Bush. That answer almost made me want to scowl. [Laughter] He keeps talking about letting the inspectors do their job. It's naive and dangerous to say that. That's what the Duelfer report showed. He was deceiving the inspectors. Secondly, of course we've been involved with Iran. I fully understand the threat. And that's why we're doing what he suggested we do, get the Brits, the Germans, and the French to go make it very clear to the Iranians that if they expect to be a party to the world, to give up their nuclear ambitions. We've been doing that. Let me talk about North Korea. It is naive and dangerous to take a policy that he suggested the other day, which is to have bilateral relations with North Korea. Remember, he is the person who is accusing me of not acting multilaterally. He now wants to take the six-party talks we have— China, North Korea, South Korea, Russia, Japan, and the United States—and undermine them by having bilateral talks. That's what President Clinton did. He had bilateral talks with the North Korean, and guess what happened? He didn't honor the agreement. He was enriching uranium. That is a bad policy. Of course, we're paying attention to these. That's a great question about Iran. That's why, in my speech to the Congress, I said there is an axis of evil, Iraq, Iran, and North Korea, and we're paying attention to it, and we're making progress. Mr. Gibson. We're going to move on, Mr. President, with a question for you. And it comes from Daniel Farley. Mr. Farley. Possibility of Reinstating the Draft Daniel Farley. Mr. President, since we continue to police the world, how do you intend to maintain a military presence without reinstituting a draft? President Bush. Yes, great question. Thanks. I hear there's rumors on the Internets that we're going to have a draft. We're not going to have a draft—period. The All-Volunteer Army works. It works particularly when we pay our troops well. It works when we make sure they've got housing, like we have done in the last military budgets. An all-volunteer army is best suited to fight the new wars of the 21st century, which is to be specialized and to find these people as they hide around the world. We don't need massed armies anymore. One of the things we've done is we've taken the—we're beginning to transform our military. And by that I mean we're moving troops out of Korea and replacing them with more effective weapons. We don't need as much manpower on the Korean Peninsula to keep a deterrent. In Europe, we have massed troops as if the Soviet Union existed and was going to invade into Europe, but those days are over with. And so we're moving troops out of Europe and replacing it with more effective equipment. So the answer to your question is, we're withdrawing—not from the world—we're drawing manpower, so they can be stationed here in America, so there's less rotation, so life is easier on their families and therefore more likely to be—we'll be more likely to keep people in the All-Volunteer Army. One of the most important things we're doing in this administration is transformation. There's some really interesting technologies. For example, we're flying unmanned vehicles that can send real-time messages back to stations in the United States. That saves manpower, and it saves equipment. It also means that we can target things easier and move more quickly, which means we need to be lighter and quicker and more facile and highly trained. Forget all this talk about a draft. We're not going to have a draft so long as I'm the President. Mr. Gibson. Senator Kerry, minute and a half. Senator Kerry. Daniel, I don't support a draft. But let me tell you where the President's policies have put us. The President— and this is one of the reasons why I'm very proud in this race to have the support of General John Shalikashvili, former Chairman of the Joint Chiefs of Staff; Admiral William Crowe, former Chairman of the Joint Chiefs of Staff; General Tony McPeak, who ran the air war for the President's father and did a brilliant job—supporting me; General Wes Clark, who won the war in Kosovo—supporting me; because they all—and General Baca, who was the head of the National Guard—supporting me. Why? Because they understand that our military is overextended under this President. Our Guard and Reserves have been turned into almost active duty. You've got people doing two and three rotations. You've got stop-loss policies so people can't get out when they were supposed to. You've got a backdoor draft right now, and a lot of our military are underpaid. These are families that get hurt. It hurts the middle class. It hurts communities, because these are our first-responders, and they're called up, and they're over there, not over here. Now, I'm going to add 40,000 active duty forces to the military. And I'm going to make people feel good about being safe in our military and not overextended because I'm going to run a foreign policy that actually does what President Reagan did and President Eisenhower did and others. We're going to build alliances. We're not going to go unilaterally. We're not going to go alone like this President did. Mr. Gibson. Mr. President, let's extend for a minute. President Bush. Let me just—I've got to answer this. Mr. Gibson. Exactly. And with Reservists being held on duty and some soldiers—— President Bush. Let me just answer what he just said about going alone. Mr. Gibson. I wanted to get into the issue of the backdoor draft. President Bush. You tell Tony Blair we're going alone. Tell Tony Blair we're going alone. Tell Silvio Berlusconi we're going alone. Tell Aleksander Kwasniewski of Poland we're going alone. We've got 30 countries there. It denigrates an alliance to say we're going alone, to discount their sacrifices. You cannot lead an alliance if you say you're going alone. And people listen. They're sacrificing with us. Mr. Gibson. Senator. Senator Kerry. Mr. President, countries are leaving the coalition, not joining. Eight countries have left it. If Missouri, just given the number of people from Missouri who are in the military over there today, were a country, it would be the third largest country in the coalition, behind Great Britain and the United States. That's not a grand coalition. Ninety percent of the casualties are American. Ninety percent of the costs are coming out of your pockets. I could do a better job. My plan does a better job, and that's why I'll be a better Commander in Chief. Mr. Gibson. The next question, Senator Kerry, is for you, and it comes from Ann Bronsing, who I believe is over in this area. Terrorist Attacks/Homeland Security Ann Bronsing. Senator Kerry, we have been fortunate that there have been no further terrorist attacks on American soil since 9/11. Why do you think this is? And if elected, what will you do to assure our safety? Senator Kerry. Thank you very much, Ann. I've asked in my security briefings why that is, and I can't go into all the answers, et cetera, but let me say this to you. This President and his administration have told you and all of us, "It's not a question of when, it's a question of"—excuse me, "not a question of if, it's a question of when." We've been told that. The "when" I can't tell you. Between the World Trade Center bombing in—what was it, 1993 or so—and the next time was 5 years, 7 years. These people wait. They'll plan. They plot. I agree with the President that we have to go after them and get them wherever they are. I just think I can do that far more effectively because the most important weapon in doing that is intelligence. You've got to have the best intelligence in the world. And in order to have the best intelligence in the world, to know who the terrorists are and where they are and what they're plotting, you've got to have the best cooperation you've ever had in the world. Now, to go back to your question, Nikki, we're not getting the best cooperation in the world today. We've got a whole bunch of countries that pay a price for dealing with the United States of America now. I'm going to change that. And I'm going to put in place a better homeland security effort. Look at it, 95 percent of our containers coming into this country are not inspected today. When you get on an airplane, your cart—your bag is X-rayed, but the cargo hold isn't X-rayed. Do you feel safer? This President, in the last debate, said that, well, that would be a big tax gap if we did that. Ladies and gentlemen, it's his tax plan. He chose a tax cut for the wealthiest Americans over getting that equipment out into the homeland as fast as possible. We have bridges and tunnels that aren't being secured; chemical plants, nuclear plants that aren't secured; hospitals that are overcrowded in their emergency rooms. If we had a disaster today, could they handle it? This President chose a tax cut over homeland security. Wrong choice. Mr. Gibson. Mr. President. President Bush. That's an odd thing to say since we've tripled the homeland security budget from 10 to 30 billion dollars. Listen, we'll do everything we can to protect the homeland. My opponent is right: We need good intelligence. It's also a curious thing for him to say, since right after 1993, he voted to cut the intelligence budget by $7.5 billion. The best way to defend America in this world we live in is to stay on the offense. We've got to be right 100 percent of the time here at home, and they've got to be right once. And that's the reality. And there's a lot of good people working hard. We're doing the best we possibly can to share information. That's why the PATRIOT Act was important. The PATRIOT Act is vital, by the way. It's a tool that law enforcement now uses to be able to talk between each other. My opponent says he hasn't changed his positions on it. No, but he's for weakening it. I don't think my opponent has got the right view about the world to make us safe. I really don't. First of all, I don't think he can succeed in Iraq. And if Iraq were to fail, it would be a haven for terrorists, and there would be money, and the world would be much more dangerous. I don't see how you can win in Iraq if you don't believe we should be there in the first place. I don't see how you can lead troops if you say, "It's the wrong war at the wrong place at the wrong time." I don't see how the Iraqis are going to have confidence in the American President if all they hear is that it was a "mistake" to be there in the first place. This war is a long, long war, and it requires steadfast determination. And it requires a complete understanding that we not only chase down Al Qaida, but we disrupt terrorists' safe havens as well as people who could provide the terrorists with support. Mr. Gibson. I want to extend for a minute, Senator, and I'm curious about something you said. You said, "It's not when but if." You think it's inevitable? Because the sense of security is a very basic thing with everybody in this country, worried about their kids. Senator Kerry. Well, the President and his experts have told America that it's not a question of if, it's a question of when. And I accept what the President has said. These terrorists are serious. They're deadly, and they know nothing except trying to kill. I understand that. That's why I will never stop at anything to hunt down and kill the terrorists. But you heard the President just say to you that we've added money. Folks, the test is not if you've added money. The test is, have you done everything possible to make America secure? He chose a tax cut for wealthy Americans over the things that I listed to you. Mr. Gibson. Mr. President. President Bush. Well, we'll talk about the tax cut for middle class here in a minute. But yes, I'm worried. I'm worried. I'm worried about our country. And all I can tell you is, every day I know that there's people working overtime, doing the very best they can. And the reason I'm worried is because there's a vicious enemy that has an ideology of hate. And the way to defeat them long-term, by the way, is to spread freedom. Liberty can change habits, and that's what's happening in Afghanistan and Iraq. Mr. Gibson. Mr. President, we're going to turn to questions now on domestic policy, and we're going to start with health issues. And the first question is for President Bush, and it's from John Horstman. Drug Imports From Canada/Health Care John Horstman. Mr. President, why did you block the reimportation of safer and inexpensive drugs from Canada, which would have cut 40 to 60 percent off of the cost? President Bush. I haven't yet. I just want to make sure they're safe. When a drug comes in from Canada, I want to make sure it cures you and doesn't kill you. And that's why the FDA and that's why the Surgeon General are looking very carefully to make sure it can be done in a safe way. I've got an obligation to make sure our Government does everything we can to protect you. And one of—my worry is that it looks like it's from Canada, and it might be from a third world. We've just got to make sure, before somebody thinks they're buying a product, that it works. And that's why we're doing what we're doing. Now, it may very well be, here in December, you hear me say, "I think there's a safe way to do it." Other ways to make sure drugs are cheaper: One is to speed up generic drugs to the marketplace quicker. Pharmaceuticals were using loopholes to keep brand drugs in place, and generics are much less expensive than brand drugs. And we're doing just that. Another is to get our seniors to sign up for these drug discount cards, and they're working. Wanda Blackmore, I met here from Missouri—the first time she bought drugs with her drug discount card she paid $1.14, I think it was, for about $10 worth of drugs. These cards make sense. And you know, in 2006, seniors are going to get prescription drug coverage for the first time in Medicare, because I went to Washington to fix problems. Medicare—the issue of Medicare used to be called "Medi-scare." People didn't want to touch it for fear of getting hurt politically. I wanted to get something done. I think our seniors deserve a modern medical system. And in 2006, our seniors will get prescription drug coverage. Thank you for asking. Mr. Gibson. Senator, a minute and a half. Senator Kerry. John, you heard the President just say that he thought he might try to be for it. Four years ago, right here in this forum, he was asked the same question, "Can't people be able to import drugs from Canada?" Do you know what he said? "I think that makes sense. I think that's a good idea"—4 years ago. Now, the President said, "I'm not blocking that." Ladies and gentlemen, the President just didn't level with you—right now, again. He did block it, because we passed it in the United States Senate. We sent it over to the House that you could import drugs. We took care of the safety issues. We're not talking about third-world drugs. We're talking about drugs made right here in the United States of America that have American brand names on them, in American bottles, and we're asking they be able to allow you to get them. The President blocked it. The President also took Medicare, which belongs to you, and he could have lowered the cost of Medicare and lowered your taxes and lowered the cost to seniors. You know what he did? He made it illegal— illegal—for Medicare to do what the VA does, which is bulk-purchase drugs so that you could lower the price and get them out to you lower. He put $139 billion of windfall profit into the pockets of the drug companies, right out of your pockets. That's the difference between us. The President sides with the power companies, the oil companies, the drug companies. And I'm fighting to let you get those drugs from Canada, and I'm fighting to let Medicare survive. I'm fighting for the middle class. That's the difference. Mr. Gibson. Mr. President. President Bush. If they're safe, they're coming. I want to remind you that it wasn't just my administration that made the decision on safety. President Clinton did the same thing, because we have an obligation to protect you. Now, he talks about Medicare. He's been in the United States Senate 20 years. Show me one accomplishment toward Medicare that he accomplished. I've been in Washington, DC, 3 1/2 years and led the Congress to reform Medicare so our seniors have got a modern health care system. That's what leadership is all about. Senator Kerry. Actually, Mr. President, in 1997, we fixed Medicare, and I was one of the people involved in it. We not only fixed Medicare and took it way out into the future, we did something that you don't know how to do. We balanced the budget. And we paid down the debt of our Nation for 2 years in a row, and we created 23 million new jobs at the same time. And it's the President's fiscal policies that have driven up the biggest deficits in American history. He's added more debt to the debt of the United States in 4 years than all the way from George Washington to Ronald Reagan put together. Go figure. Mr. Gibson. Next question is for Senator Kerry, and this comes from Norma-Jean Laurent. Tort Reform Norma-Jean Laurent. Senator Kerry, you've stated your concern for the rising cost of health care. Yet you chose a Vice Presidential candidate who has made millions of dollars successfully suing medical professionals. How do you reconcile this with the voters? Senator Kerry. Very easily. John Edwards is the author of the Patients' Bill of Rights. He wanted to give people rights. John Edwards and I support tort reform. We both believe that as lawyers—I'm a lawyer too— and I believe that we will be able to get a fix that has eluded everybody else, because we know how to do it. It's in my health care proposal. Go to johnkerry.com—you can pull it off the Internet—and you'll find a tort reform plan. Now, ladies and gentlemen, important to understand, the President and his friends try to make a big deal out of it. Is it a problem? Yes, it's a problem. Do we need to fix it, particularly for ob-gyns * and for brain surgeons and others? Yes. But it's less than one percent of the total cost of health care. Your premiums are going up. You've gone up in Missouri about $3,500. You've gone up 64 percent. You've seen co-pays go up, deductibles go up. Everything has gone up. Five million people have lost their health insurance under this President, and he's done nothing about it. I have a plan. I have a plan to lower the cost of health care for you. I have a plan to cover all children. I have a plan to let you buy into the same health care Senators and Congressmen give themselves. I have a plan that's going to allow people 55 to 64 to buy into Medicare early. And I have a plan that will take the catastrophic cases out of the system, off your backs, pay for it out of a Federal fund, which lowers the premiums for everybody in America, makes American business more competitive, and makes health care more affordable. Now, all of that can happen, but I have to ask you to do one thing. Join me in rolling back the President's unaffordable tax cut for people earning more than $200,000 a year. That's all. Ninety-eight percent of America, I'm giving you a tax cut, and I'm giving you health care. Mr. Gibson. Mr. President, a minute and a half. President Bush. Let me see where to start here. First, the National Journal named Senator Kerry * the most liberal Senator of all. And that's saying something in that bunch. You might say that took a lot of hard work. The reason I bring that up is because he's proposed $2.2 trillion in new spending and he says he's going to tax the rich to close the tax gap. He can't. He's going to tax everybody here to fund his programs. That's just reality. And what are his health programs? First, he says he's for medical liability reform, particularly for ob-gyns. There was a bill on the floor of the United States Senate that he could have showed up and voted for if he's so much for it. Secondly, he says that medical liability costs only cause one percent increase. That shows a lack of understanding. Doctors practice defensive medicine because of all the frivolous lawsuits that cost our Government $28 billion a year. And finally, he says he's going to have a novel health care plan. You know what it is? The Federal Government is going to run it. It is the largest increase in Federal Government health care ever, and it fits with his philosophy. That's why I told you about the award he won from the National Journal. That's what liberals do: They create Government-sponsored health care. Maybe you think that makes sense. I don't. Government-sponsored health care would lead to rationing. It would ruin the quality of health care in America. Mr. Gibson. Senator Kerry, we got several questions along this line, and I'm just curious if you'd go further on what you talked about with tort reform. Would you be favoring capping awards on pain and suffering? Would you limit attorneys' fees— yes, to follow up on this for a minute. Thirty seconds. Senator Kerry. Yes, I think we should look at the punitive, and we should have some limitations. But look, what's really important, Charlie, is the President's just trying to scare everybody here with throwing labels around. I mean, "compassionate conservative," what does that mean? Cutting 500,000 kids from after-school programs? Cutting 365,000 kids from health care? Running up the biggest deficits in American history? Mr. President, you're batting 0 for 2. I mean, seriously, labels don't mean anything. What means something is do you have a plan, and I want to talk about my plan some more. I hope we can. Mr. Gibson. We'll get to that in just a minute. Thirty seconds. President Bush. What does matter is the plan. He said he is for—you're now for capping punitive damages? That's odd. You should have shown up on the floor in the Senate and voted for it then. Medical liability issues are a problem, a significant problem. He's been in the United States Senate for 20 years, and he hasn't addressed it. We passed it out of the House of Representatives. Guess where it stuck? It stuck in the Senate because the trial lawyers won't act on it, and he put a trial lawyer on the ticket. Mr. Gibson. The next question is for President Bush, and it comes from Matthew O'Brien. Federal Deficit Matthew O'Brien. Mr. President, you have enjoyed a Republican majority in the House and Senate for most of your Presidency. In that time, you've not vetoed a single spending bill. Excluding 120 billion spent in Iran and Afghan—I'm sorry, Iraq and Afghanistan, there has been $700 billion spent and not paid for by taxes. Please explain how the spending you have approved and not paid for is better for the American people than the spending proposed by your opponent. President Bush. Right. Thank you for that. We have a deficit. We have a deficit because this country went into a recession. You might remember the stock market started to decline dramatically 6 months before I came to office, and then the bubble of the 1990s popped. And that cost us rev-enue—that cost us revenue. Secondly, we're at war. And I'm going to spend what it takes to win the war, more than just 120 billion for Iraq and Afghanistan. We've got to pay our troops more. We have. We've increased money for ammunition and weapons and pay and homeland security. I just told this lady over here we spent—went from 10 to 30 billion dollars to protect the homeland. I think we have an obligation to spend that kind of money. Plus, we cut taxes for everybody. Everybody got tax relief, so that they'd get out of the recession. I think if you raise taxes during a recession, you head to depression. I come from the school of thought that says when people have more money in their pocket during tough economic times, it increases demand or investment. Small businesses begin to grow, and jobs are added. We found out today that over the past 13 months, we've added 1.9 million new jobs in the last 13 months. I proposed a plan, detailed budget, that shows us cutting the deficit in half by 5 years. And you're right, I haven't vetoed any spending bills because we worked together. Non-homeland, non-defense, discretionary spending was rising at 15 percent a year when I got into office. And today, it's less than one percent, because we're working together to try to bring this deficit under control. Like you, I'm concerned about the deficit. But I am not going to shortchange our troops in harm's way. And I'm not going to run up taxes which will cost this economy jobs. Thank you for your question. Mr. Gibson. Senator Kerry, a minute and a half. Senator Kerry. Let me begin by saying that my health care plan is not what the President described. It is not a Government takeover. You have choice: Choose your doctor; choose your plan. The Government has nothing to do with it. In fact, it doesn't ask you to do anything. If you don't want to take it, you don't have to. If you like your high premiums, you keep them. That's the way we leave it. Now, with respect to the deficit, the President was handed a $5.6 trillion surplus, ladies and gentlemen. That's where he was when he came into office. We now have a $2.6 trillion deficit. This is the biggest turnaround in the history of the country. He's the first President in 72 years to lose jobs. He talked about war. This is the first time the United States of America has ever had a tax cut when we're at war. Franklin Roosevelt, Harry Truman, others knew how to lead. They knew how to ask the American people for the right things. One percent of America—the highest one percent of income earners in America got $89 billion of tax cut last year. One percent of America got more than the 80 percent of America that earned from $100,000 down. The President thinks it's more important to fight for that top one percent than to fight for fiscal responsibility and to fight for you. I want to put money in your pocket. I am—I have a proposal for a tax cut for all people earning less than the $200,000. The only people affected in my plan are the top income earners of America. Mr. Gibson. I both—I heard you both say—I have heard you both say during the campaign, and I just heard you say it— that you're going to cut the deficit by a half in 4 years. But I didn't hear one thing in the last 3 1/2 minutes that would indicate how either one of you do that. President Bush. Look at the budget. One is, make sure Congress doesn't overspend. But let me talk back about where we've been. The stock market was declining 6 months prior to my arrival. It was the largest stock market correction—one of the largest in history, which foretold a recession. Because we cut taxes on everybody— remember, we ran up the child credit by 1,000; we reduced the marriage penalty; we created the 10-percent bracket; everybody who pays taxes got relief—the recession was one of the shortest in our Nation's history. Mr. Gibson. Senator Kerry, 30 seconds. Senator Kerry. After 9/11, after the recession had ended, the President asked for another tax cut and promised 5.6 million jobs would be created. He lost 1.6 million, ladies and gentlemen, and most of that tax cut went to the wealthiest people in the country. He came and asked for a tax cut; we wanted a tax cut to kick the economy into gear. Do you know what he presented us with? A $25 billion giveaway to the biggest corporations in America, including a $254 million refund check to Enron. Wrong priorities. You are my priority. Mr. Gibson. Senator Kerry, the next question will be for you, and it comes from James Varner, who I believe is in this section. Mr. Varner? You need a microphone. Taxes James Varner. Thank you. Senator Kerry, would you be willing to look directly into the camera and, using simple and unequivocal language, give the American people your solemn pledge not to sign any legislation that will increase the tax burden on families earning less than $200,000 a year during your first term? Senator Kerry. Absolutely. Yes. Right into the camera—yes. I am not going to raise taxes. I have a tax cut, and here's my tax cut. I raise the child care credit by $1,000 for families to help them be able to take care of their kids. I have a $4,000 tuition tax credit that goes to parents and kids, if they're earning for themselves, to be able to pay for college. And I lower the cost of health care in the way that I described to you. Every part of my program, I've shown how I'm going to pay for it. And I've gotten good people, like former Secretary of the Treasury Bob Rubin for instance, who showed how to balance budgets and give you a good economy, to help me crunch these numbers and make them work. I've even scaled back some of my favorite programs already, like the child care program I wanted to fund and the national service program, because the President's deficit keeps growing. And I've said, as a pledge, I'm going to cut the deficit in half in 4 years. Now, I'm going to restore what we did in the 1990s, ladies and gentlemen: Pay as you go. We're going to do it like you do it. The President broke the pay-as-you-go rule. Somebody here asked the question about why haven't you vetoed something. It's a good question. If you care about it, why don't you veto it? I think John McCain called the energy bill the no lobbyist left behind bill. I mean, you've got to stand up and fight somewhere, folks. I'm pledging I will not raise taxes. I'm giving a tax cut to the people earning less than $200,000 a year. Now, for the people earning more than $200,000 a year, you are going to see a rollback to the level we were at with Bill Clinton, when people made a lot of money. And looking around here at this group here, I suspect there are only three people here who are going to be affected: the President, me, and Charlie, I'm sorry, you too. [Laughter] Mr. Gibson. Mr. President, 90 seconds. President Bush. It's just not credible. When he talks about being fiscally conservative, it's just not credible. If you look at his record in the Senate, he voted to break the spending—the caps, the spending caps, over 200 times, and here he says he's going to be a fiscal conservative all of a sudden. It's just not credible. You cannot believe it. And of course he's going to raise your taxes. You see, he's proposed $2.2 trillion of new spending. And so they said, "Well, how are you going to pay for it?" He said, well, he's going to raise the taxes on the rich. That's what he said, the top two brackets. That raises—he says 800 billion; we say 600 billion. We've got battling green eyeshades—somewhere in between those numbers. And so there is a difference, what he's promised and what he could raise. Now, either he's going to break all these wonderful promises he's told you about, or he's going to raise taxes. And I suspect, given his record, he's going to raise taxes. Is my time up yet? Mr. Gibson. No, you can keep going. President Bush. Keep going, good. [Laughter] Mr. Gibson. You're on—— President Bush. You looked at me like my clock was up. I think that the way to grow this economy is to keep taxes low, is to have an energy plan, is to have litigation reform. As I told you, we just got a report that said over the past 13 months, we've created 1.9 million new jobs. We're growing. And so the fundamental question of this campaign is, who's going to keep the economy growing so people can work? That's the fundamental question. Mr. Gibson. I'm going to come back one more time to how these numbers add up and how you can cut that deficit in half in 4 years, given what you've both said. Senator Kerry. Well, first of all, the President's figures of 2.2 trillion just aren't accurate. Those are the fuzzy math figures put together by some group that works for the campaign. That's not the number. Number two, John McCain and I have a proposal, jointly, for a commission that closes corporate giveaway loopholes. We've got $40 billion going to Bermuda. We've got all kinds of giveaways. We ought to be shutting those down. And third, credible? Ladies and gentlemen, in 1985, I was one of the first Democrats to move to balance the budget. I voted for the balanced budget in '93 and '97. We did it. We did it, and I was there. Mr. Gibson. Thirty seconds—I'm sorry, thirty seconds, Mr. President. President Bush. Yes, I mean, he's got a record. He's been there for 20 years. You can run, but you can't hide. He voted 98 times to raise taxes. I mean, these aren't make-up figures. And so people are going to have to look at the record—look at the record of the man running for the President. They don't name him the most liberal in the United States Senate because he hasn't shown up to many meetings. They named him because of his votes, and it's reality. It's just not credible to say he's going to keep taxes down and balance budgets. Mr. Gibson. Mr. President, the next question is for you, and it comes from James Hubb, over here. Action on the Environment/Kyoto Protocol to the United Nations Framework Convention on Climate Change James Hubb. Mr. President, how would you rate yourself as an environmentalist? What specifically has your administration done to improve the condition of our Nation's air and water supply? President Bush. Off-road diesel engines—we have reached an agreement to reduce pollution from off-road diesel engines by 90 percent. I've got a plan to increase the wetlands by 3 million. We've got an aggressive brownfield program to refurbish inner-city sore spots to useful pieces of property. I proposed to the United States Congress a Clear Skies Initiative to reduce sulfur dioxide, nitrogen oxide, and mercury by 70 percent. I was—fought for a very strong title in the farm bill for the Conservation Reserve Program to set aside millions of acres of land for—to help improve wildlife in the habitat. We proposed and passed a Healthy Forests bill, which was essential to working with—particularly in western States, to make sure that our forests were protected. What happens in those forests, because of lousy Federal policy, is they grow to be— they are not—they're not harvested. They're not taken care of, and as a result, they're like tinder boxes. And over the last summers I've flown over there. And so this is a reasonable policy to protect old stands of trees and, at the same time, make sure our forests aren't vulnerable to the forest fires that have destroyed acres after acres in the West. We've got a good, commonsense policy. Now, I'm going to tell you what I really think is going to happen over time, is technology is going to change the way we live, for the good, for the environment. So I proposed a hydrogen automobile, a hydrogen-generated automobile. We're spending a billion dollars to come up with the technologies to do that. That's why I'm a big proponent of clean coal technology, to make sure we can use coal but in a clean way. I guess you'd say I'm a good steward of the land. The quality of the air is cleaner since I've been the President; fewer water complaints since I've been the President; more land being restored since I've been the President. Thank you for your question. Mr. Gibson. Senator Kerry, a minute and a half. Senator Kerry. Boy, to listen to that, the President I don't think is living in a world of reality with respect to the environment. Now, if you're a Red Sox fan, that's okay. But if you're a President, it's not. Let me just say to you, number one, don't throw the labels around. Labels don't mean anything. I supported welfare reform. I led the fight to put 100,000 cops on the streets of America. I've been for faith-based initiatives helping to intervene in the lives of young children for years. I was—broke with my party in 1985, one of the first three Democrats to fight for a balanced budget when it was heresy. Labels don't fit, ladies and gentlemen. Now, when it comes to the issue of the environment, this is one of the worst administrations in modern history. The Clear Skies bill that he just talked about—it's one of those Orwellian names you pull out of the sky, slap it onto something—like No Child Left Behind, but you leave millions of children behind. Here they're leaving the skies and the environment behind. If they just left the Clean Air Act all alone the way it is today, no change, the air would be cleaner than it is if you pass the cleaner skies act. We're going backwards. In fact, his environmental enforcement chief air quality person at the EPA resigned in protest over what they're doing to what are called the New Source Performance Standards for air quality. They're going backwards on the definition for wetlands. They're going backwards on the water quality. They pulled out of the global warming, declared it dead; didn't even accept the science. I'm going to be a President who believes in science. Mr. Gibson. Mr. President? President Bush. Well, had we joined the Kyoto treaty, which I guess he's referring to, it would have cost America a lot of jobs. It's one of these deals where in order to be popular in the halls of Europe, you sign a treaty. But I thought it would cost a lot of—I think there's a better way to do it. And I just told you the facts, sir. The quality of the air is cleaner since I've been the President of the United States. And we'll continue to spend money on research and development because I truly believe that's the way to get from how we live today to being able to live a standard of living that we're accustomed to and being able to protect our environment bet-ter—the use of technologies. Mr. Gibson. Senator Kerry, 30 seconds. Senator Kerry. The fact is that the Kyoto treaty was flawed. I was in Kyoto, and I was part of that. I know what happened. But this President didn't try to fix it. He just declared it dead, ladies and gentlemen, and we walked away from the work of 160 nations over 10 years. You wonder, Nikki, why it is that people don't like us in some parts of the world. You just say, "Hey, we don't agree with you. Goodbye." The President has done nothing to try to fix it. I will. Mr. Gibson. Senator Kerry, the next question is for you. It involves jobs, which is a topic in the news today. And for the question, we're going to turn to Jane Barrow. Trade Competitiveness/Jobs/Taxes Jane Barrow. Senator Kerry, how can the U.S. be competitive in a manufacturing given—in manufacturing, excuse me, given the wage necessary and comfortably accepted for American workers to maintain the standard of living that they expect? Senator Kerry. Jane, there are a lot of ways to be competitive. And unfortunately, again, I regret, this administration has not seized them and embraced them. Let me give you an example. There's a tax loophole right now—if you're a company in St. Louis working, trying to make jobs here, there's actually an incentive for you to go away. You get more money—you can keep more of your taxes by going abroad. I'm going to shut that loophole, and I'm going to give the tax benefit to the companies that stay here in America to help make them more competitive. Secondly, we're going to create a manufacturing jobs credit and a new jobs credit for people to be able to help hire and be more competitive here in America. Third, what's really hurting American business, more than anything else, is the cost of health care. Now, you didn't hear any plan from the President, because he doesn't have a plan to lower the cost of health care. Five million Americans have lost their health care; 620,000 Missourians have no health care at all; 96,000 Missourians have lost their health care under President Bush. I have a plan to cover those folks, and it's a plan that lowers costs for everybody, covers all children. And the way I pay for it—I'm not fiscally irresponsible—is I roll back the tax cut that this President so fiercely wants to defend, the one for him and me and Charlie. I think you ought to get the break. I want to lower your cost of health care. I want to fully fund education, No Child Left Behind, special needs education. And that's how we're going to be more competitive, by making sure our kids are graduating from school and college. China and India are graduating more graduates in technology and science than we are. We've got to create the products of the future. That's why I have a plan for energy independence within 10 years. And we're going to put our laboratories and our colleges and universities to work, and we're going to get the great entrepreneurial spirit of this country, and we're going to free ourselves from this dependency on Mideast oil. That's how you create jobs and become competitive. Mr. Gibson. Mr. President, minute and a half. President Bush. Let me start with how to control the costs of health care: Medical liability reform, for starters, which he's opposed. Secondly, allow small businesses to pool together so they can share risk and buy insurance at the same discounts big businesses get to do. Thirdly, spread what's called health savings accounts. It's good for small businesses, good for owners. You own your own account. You can save tax-free. You get a catastrophic plan to help you— own it. This is different from saying, "Okay, let me incent you to go on the Government." He's talking about his plan to keep jobs here. You know, he calls it an outsourcing—to keep—stop outsourcing. Robert Rubin looked at his plan and said it won't work. The best way to keep jobs here in America is, one, have an energy plan. I proposed one to the Congress 2 years ago. It encourages conservation, encourages technology to explore for environmentally friendly ways for coal and use coal and gas. It encourages the use of renewables like ethanol and biodiesel. It's stuck in the Senate. He and his runningmate didn't show up to vote when they could have got it going in the Senate. Less regulations if we want jobs here. Legal reform if we want jobs here. And we've got to keep taxes low. Now, he says he's only going to tax the rich. Do you realize 900,000 small businesses will be taxed under his plan because most small businesses are Subchapter S corps or limited partnerships, and they pay tax at the individual income-tax level. And so when you're running up the taxes like that, you're taxing job creators, and that's not how you keep jobs here. Mr. Gibson. Senator, I want to extend for a minute. You talk about tax credits to stop outsourcing. But when you have IBM documents that I saw recently, where you can hire a programmer for $12 in China, $56 an hour here, tax credits won't cut it in that area. Senator Kerry. You can't stop all outsourcing, Charlie. I've never promised that. I'm not going to, because that would be pandering. You can't. But what you can do is create a fair playing field, and that's what I'm talking about. But let me just address what the President just said. Ladies and gentlemen, that's just not true, what he said. The Wall Street Journal said 96 percent of small businesses are not affected at all by my plan. And you know why he gets that count? The President got $84 from a timber company that he owns, and he's counted as a small business. Dick Cheney is counted as a small business. That's how they do things. That's just not right. President Bush. I own a timber company? That's news to me. [Laughter] Need some wood? [Laughter] Most small businesses are Subchapter S corps. They just are. I met Grant Milliron, Mansfield, Ohio. He's creating jobs. Most small businesses—70 percent of the new jobs in America are created by small business. His taxes are going up when you run up the top two brackets. It's a fact. Mr. Gibson. President Bush, the next question is for you, and it comes from Rob Fowler, who I believe is over in this area. PATRIOT Act Rob Fowler. President Bush, 45 days after 9/11, Congress passed the PATRIOT Act, which takes away checks on law enforcement and weakens American citizens' rights and freedoms, especially Fourth Amendment rights. With expansions of the PATRIOT Act and PATRIOT Act II, my question to you is, why are my rights being watered down and my citizens around me, and what are the specific justifications for these reforms? President Bush. Yes, I appreciate that. I really don't think your rights are being watered down. As a matter of fact, I wouldn't support it if I thought that. Every action being taken against terrorists requires a court order, requires scrutiny. As a matter of fact, the tools now given to the terrorist fighters are the same tools that we've been using against drug dealers and white-collar criminals. So I really don't think so. I hope you don't think that. I mean, I—because I think whoever is the President must guard your liberties, must not erode your rights in America. The PATRIOT Act is necessary, for example, because parts of the FBI couldn't talk to each other. Intelligence gathering and the law enforcement arms of the FBI just couldn't share intelligence under the old law, and that didn't make any sense. Our law enforcement must have every tool necessary to find and disrupt terrorists at home and abroad before they hurt us again. That's the task of the 21st century. And so I don't think the PATRIOT Act abridges your rights at all, and I know it's necessary. I can remember being in upstate New York talking to FBI agents that helped bust the Lackawanna cell up there. And they told me they could not have performed their duty, the duty we all expect of them, if they did not have the ability to communicate with each other under the PATRIOT Act. Mr. Gibson. Senator Kerry, a minute and a half. Senator Kerry. Former Governor Racicot, as chairman of the Republican Party, said he thought that the PATRIOT Act has to be changed and fixed. Congressman Jim Sensenbrenner—he's the chairman of the House Judiciary Committee— has said over his dead body before it gets renewed without being thoroughly rechecked. Whole bunch of folks in America concerned about the way the PATRIOT Act has been applied. In fact, the Inspector General of the Justice Department found that John Ashcroft had twice applied it in ways that were inappropriate. People's rights have been abused. I met a man who spent 8 months in prison, wasn't even allowed to call his lawyer, wasn't allowed to—finally, Senator Dick Durbin of Illinois intervened and was able to get him out. This is in our country, folks, the United States of America. They've got sneak-and-peak searches that are allowed. They've got people allowed to go into churches now and political meetings, without any showing of potential criminal activity or otherwise. Now, I voted for the PATRIOT Act. Ninety-nine United States Senators voted for it. And the President has been very busy running around the country using what I just described to you as a reason to say I'm wishy-washy, that I'm a flip-flopper. Now, that's not a flip-flop. I believe in the PATRIOT Act. We need the things in it that coordinate the FBI and the CIA. We need to be stronger on terrorism. But you know what we also need to do as Americans is never let the terrorists change the Constitution of the United States in a way that disadvantages our rights. Mr. Gibson. Senator Kerry, the next question is for you, and it comes from Elizabeth Long. Embryonic Stem Cell Research Elizabeth Long. Senator Kerry, thousands of people have already been cured or treated by the use of adult stem cells or umbilical cord stem cells. However, no one has been cured by using embryonic stem cells. Wouldn't it be wise to use stem cells obtained without the destruction of an embryo? Senator Kerry. You know, Elizabeth, I really respect your—the feeling that's in your question. I understand it. I know the morality that's prompting that question, and I respect it enormously. But like Nancy Reagan and so many other people—you know, I was at a forum with Michael J. Fox the other day in New Hampshire, who's suffering from Parkinson's, and he wants us to do stem cell—embryonic stem cell. And this fellow stood up, and he was quivering. His whole body was shaking from the nerve disease, the muscular disease that he had, and he said to me and to the whole hall, he said, you know, "Don't take away my hope because my hope is what keeps me going." Chris Reeve is a friend of mine. Chris Reeve exercises every single day to keep those muscles alive for the day when he believes he can walk again, and I want him to walk again. I think we can save lives. Now, I think we can do ethically guided embryonic stem cell research. We have 100,000 to 200,000 embryos that are frozen in nitrogen today from fertility clinics. These weren't taken from abortion or something like that. They're from a fertility clinic, and they're either going to be destroyed or left frozen. And I believe if we have the option, which scientists tell us we do, of curing Parkinson's, curing diabetes, curing some kind of a paraplegic or quadriplegic or a spinal cord injury, anything—that's the nature of the human spirit. I think it is respecting life to reach for that cure. I think it is respecting life to do it in an ethical way. And the President's chosen a policy that makes it impossible for our scientists to do that. I want the future, and I think we have to grab it. Mr. Gibson. Mr. President, a minute and a half. President Bush. Embryonic stem cell research requires the destruction of life to create a stem cell. I'm the first President ever to allow funding, Federal funding, for embryonic stem cell research. I did so because I too hope that we'll discover cures from the stem cells and from the research derived. But I think we've got to be very careful in balancing the ethics and the science. And so I made the decision we wouldn't spend any more money beyond the 70 lines, 22 of which are now in action, because science is important but so is ethics, so is balancing life. To destroy life to save life is one of the real ethical dilemmas that we face. There is going to be hundreds of experiments off the 22 lines that now exist, that are active, and hopefully we find a cure. But as well we need to continue to pursue adult stem cell research. I helped double the NIH budget to $28 billion a year to find cures. And the approach I took is one that I think is a balanced and necessary approach, to balance science and the concerns for life. Mr. Gibson. Senator, thirty seconds, let's extend. Senator Kerry. When you talk about walking a waffle line, he says he's allowed it, which means he's going to allow the destruction of life up to a certain amount, and then he isn't going to allow it. Now, I don't know how you draw that line. But let me tell you pointblank, the lines of stem cells that he's made available, every scientist in the country will tell you, "Not adequate," because they're contaminated by mouse cells and because there aren't 60 or 70; there are only about 11 to 20 now, and there aren't enough to be able to do the research because they're contaminated. We've got to open up the possibilities of this research. And when I am President, I'm going to do it, because we have to. Mr. Gibson. Mr. President. President Bush. Let me make sure you understand my decision. Those stem cell lines already existed. The embryo had already been destroyed prior to my decision. I had to make the decision: Do we destroy more life; do we continue to destroy life? I made the decision to balance science and ethics. Mr. Gibson. Mr. President, the next question is for you, and it comes from Jonathan Michaelson. Supreme Court Jonathan Michaelson. Mr. President, if there were a vacancy in the Supreme Court and you had the opportunity to fill that position today, who would you choose, and why? President Bush. I'm not telling. [Laughter] I really don't have—I haven't picked anybody yet. Plus, I want them all voting for me. [Laughter] I would pick somebody who would not allow their personal opinion to get in the way of the law. I would pick somebody who would strictly interpret the Constitution of the United States. Let me give you a couple of examples, I guess, of the kind of person I wouldn't pick. I wouldn't pick a judge who said that the Pledge of Allegiance couldn't be said in a school because it had the words "under God" in it. I think that's an example of a judge allowing personal opinion to enter into the decisionmaking process, as opposed to strict interpretation of the Constitution. Another example would be the Dred Scott case, which is where judges years ago said that the Constitution allowed slavery because of personal property rights. That's personal opinion. That's not what the Constitution says. The Constitution of the United States says we're all—it doesn't say that. It doesn't speak to the equality of America. And so I would pick people that would be strict constructionists. We've got plenty of lawmakers in Washington, DC. Legislators make law. Judges interpret the Constitution. And I suspect one of us will have a pick at the end of next year—next 4 years. And that's the kind of judge I'm going to put on there—no litmus test except for how they interpret the Constitution. Mr. Gibson. Senator Kerry, a minute and a half. Senator Kerry. Thank you, Charlie. A few years ago, when he came to office, the President said—these are his words— "What we need are some good conservative judges on the courts." And he said also that his two favorite Justices are Justice Scalia and Justice Thomas. So you get a pretty good sense of where he's heading if he were to appoint somebody. Now, here's what I believe. I don't believe we need a good conservative judge, and I don't believe we need a good liberal judge. I don't believe we need a good judge of that kind of definition on either side. I subscribe to the Justice Potter Stewart standard. He was a Justice on the Supreme Court of the United States, and he said the mark of a good judge, a good Justice, is that when you're reading their decision, their opinion, you can't tell if it's written by a man or a woman, a liberal or a conservative, a Muslim, a Jew, or a Christian. You just know you're reading a good judicial decision. What I want to find, if I'm privileged to have the opportunity to do it—and the Supreme Court of the United States is at stake in this race, ladies and gentlemen, the future of things that matter to you in terms of civil rights, what kind of Justice Department you'll have, whether we'll enforce the law, will we have equal opportunity, will women's rights be protected, will we have equal pay for women, which is going backwards, will a woman's right to choose be protected. These are constitutional rights, and I want to make sure we have judges who interpret the Constitution of the United States according to the law. Mr. Gibson. Going to go to the final two questions, now. And the first one will be for Senator Kerry, and this comes from Sarah Degenhart. Federal Funding of Abortions Sarah Degenhart. Senator Kerry, suppose you are speaking with a voter who believed abortion is murder, and the voter asked for reassurance that his or her tax dollars would not go to support abortion. What would you say to that person? Senator Kerry. I would say to that person exactly what I will say to you right now. First of all, I cannot tell you how deeply I respect the belief about life and when it begins. I'm a Catholic, raised a Catholic. I was an altar boy. Religion has been a huge part of my life. It helped lead me through a war, leads me today. But I can't take what is an article of faith for me and legislate it for someone who doesn't share that article of faith, whether they be agnostic, atheist, Jew, Protestant, whatever. I can't do that. But I can counsel people. I can talk reasonably about life and about responsibility. I can talk to people, as my wife, Teresa, does, about making other choices and about abstinence and about all these other things that we ought to do as a responsible society. But as a President, I have to represent all the people in the Nation, and I have to make that judgment. Now, I believe that you can take that position and not be pro-abortion. But you have to afford people their constitutional rights. And that means being smart about allowing people to be fully educated, to know what their options are in life, and making certain that you don't deny a poor person the right to be able to have whatever the Constitution affords them if they can't afford it otherwise. That's why I think it's important. That's why I think it's important for the United States, for instance, not to have this rigid ideological restriction on helping families around the world to be able to make a smart decision about family planning. You'll help prevent AIDS. You'll help prevent unwanted children, unwanted pregnancies. You'll actually do a better job, I think, of passing on the moral responsibility that is expressed in your question, and I truly respect it. Mr. Gibson. Mr. President, a minute and a half. President Bush. Trying to decipher that. [Laughter] My answer is we're not going to spend Federal taxpayers' money on abortion. This is an issue that divides America, but certainly reasonable people can agree on how to reduce abortions in America. I signed the ban on partial-birth abortion. It's a brutal practice. It's one way to help reduce abortions. My opponent voted against the ban. I think there ought to be parental notification laws. He's against them. I signed a bill called the Unborn Victims of Violence Act. In other words, if you're a mom and you're pregnant, you get killed, the murderer gets tried for two cases, not just one. My opponent was against that. These are reasonable ways to help promote a culture of life in America. I think it is a worthy goal in America to have every child protected by law and welcomed in life. I also think we ought to continue to have good adoption law as an alternative to abortion. And we need to promote maternity group homes, which my administration has done. Culture of life is really important for a country to have if it's going to be a hospitable society. Thank you. Mr. Gibson. Senator, do you want to follow up? Thirty seconds. Senator Kerry. Well, again, the President just said categorically, "My opponent is against this. My opponent is against that." It's just not that simple. No, I'm not. I'm against the partial-birth abortion, but you've got to have an exception for the life of the mother and the health of the mother under the strictest test of bodily injury to the mother. Secondly, with respect to parental notification, I'm not going to require a 16- or 17-year old kid who's been raped by her father and who's pregnant to have to notify her father. So you've got to have a judicial intervention. And because they didn't have a judicial intervention where she could go somewhere and get help, I voted against it. It's never quite as simple as the President wants you to believe. Mr. Gibson. And 30 seconds, Mr. President. President Bush. It's pretty simple when they say, "Are you for a ban on partial-birth abortion? Yes or no." And he was given a chance to vote, and he voted no. And that's just the way it is. That's a vote. It came right up. It's clear for everybody to see. And as I said, you can run, but you can't hide. It's the reality. Mr. Gibson. And the final question of the evening will be addressed to President Bush, and it will come from Linda Grabel. Linda Grabel is over here. President Bush. Put a head fake on. Mr. Gibson. I got faked out, myself. [Laughter] Presidential Decisionmaking/Funding U.S. Troops Linda Grabel. President Bush, during the last 4 years, you have made thousands of decisions that have affected millions of lives. Please give three instances in which you came to realize you had made a wrong decision, and what you did to correct it. Thank you. President Bush. I have made a lot of decisions, some of them little, like appointments to a board you've never heard of, and some of them big. And in a war, there's a lot of tactical decisions that historians will look back and say, "You shouldn't have done that. You shouldn't have made that decision." And I'll take responsibility for them. I'm human. But on the big questions about whether or not we should have gone into Afghanistan, the big question about whether we should have removed somebody in Iraq, I'll stand by those decisions because I think they're right. That's really what you're— when they ask about the mistakes, that's what they're talking about. They're trying to say, "Did you make a mistake going into Iraq?" And the answer is absolutely not. It was the right decision. The Duelfer report confirmed that decision today, because what Saddam Hussein was doing was trying to get rid of sanctions so he could reconstitute a weapons program, and the biggest threat facing America is terrorists with weapons of mass destruction. We knew he hated us. We knew he had been a—invaded other countries. We knew he tortured his own people. On the tax cut, it's a big decision. I did the right decision. Our recession was one of the shallowest in modern history. Now, you ask what mistakes—I made some mistakes in appointing people, but I'm not going to name them. I don't want to hurt their feelings on national TV. But history will look back, and I'm fully prepared to accept any mistakes that history judges to my administration. Because the President makes the decisions, the President has to take the responsibility. Mr. Gibson. Senator Kerry, a minute and a half. Senator Kerry. I believe the President made a huge mistake, a catastrophic mistake, not to live up to his own standard, which was build a true global coalition, give the inspectors time to finish their job, and go through the U.N. process to its end and go to war as a last resort. I ask each of you just to look into your hearts, look into your guts—gut-check time. Was this really going to war as a last resort? The President rushed our Nation to war without a plan to win the peace, and simple things weren't done. That's why Senator Lugar says "incompetent" in the delivery of services. That's why Senator Hagel, Republican, says, "beyond pitiful, beyond embarrassing, in the zone of dangerous." We didn't guard 850,000 tons of ammo. That ammo is now being used against our kids. Ten thousand out of twelve thousand Humvees aren't armored. I've visited some of those kids with no limbs today because they didn't have the armor on those vehicles. They didn't have the right body armor. I've met parents who've, on the Internet, gotten the armor to send their kids. There's no bigger judgment for a President of the United States than how you take a nation to war. And you can't say, "Because Saddam might have done it 10 years from now, that's a reason." That's an excuse. Mr. Gibson. Mr. President. President Bush. He complains about the fact our troops don't have adequate equipment, yet he voted against the $87 billion supplemental I sent to the Congress and then issued one of the most amazing quotes in political history: "I actually did vote for the $87 billion, before I voted against it." Saddam Hussein was a risk to our country, ma'am. And he was a risk that—and this is where we just have a difference of opinion. The truth of the matter is, if you listen carefully: Saddam would still be in power if he were the President of the United States, and the world would be "a lot better off." Mr. Gibson. And Senator Kerry, 30 seconds. Senator Kerry. Not necessarily be in power. But here's what I'll say about the 87 billion: I made a mistake in the way I talked about it. He made a mistake in invading Iraq. Which is a worse decision? Now, I voted the way I voted because I saw that he had the policy wrong, and I wanted accountability. I didn't want to give a slush fund to Halliburton. I also thought the wealthiest people in America ought to pay for it, ladies and gentlemen. He wants your kids to pay for it. I wanted us to pay for it, since we're at war. I don't think that's a bad decision. Closing Statements Mr. Gibson. That's going to conclude the questioning. We're going to go now to closing statements, 2 minutes from each candidate. And the first closing statement goes to Senator Kerry. I believe that was the agreement. President Bush. Go ahead. Actually—— Senator Kerry. You want to go first? President Bush. Either way. [Laughter] Senator Kerry. Thank you. Charlie, thank you. And thank you all. Thank you, all of you, for taking part; thanks for your questions tonight very, very much. Obviously, the President and I both have very strong convictions. I respect him for that, but we have a very different view about how to make America stronger and safer. I will never cede the authority of our country or our security to any other nation. I'll never give a veto of American security to any other entity, not a nation, not a country, not an institution. But I know, as I think you do, that our country is strongest when we lead the world, when we lead strong alliances. And that's the way Eisenhower and Reagan and Kennedy and others did it. We are not doing that today. We need to. I have a plan that will help us go out and kill and find the terrorists, and I will not stop in our effort to hunt down and kill the terrorists. But I also have a better plan on how we're going to deal with Iraq, training the Iraqi forces more rapidly, getting our allies back to the table with a fresh start, with new credibility, with a President whose judgment the rest of the world trusts. In addition to that, I believe we have a crisis here at home, a crisis of the middle class that is increasingly squeezed, health care costs going up. I have a plan to provide health care to all Americans. I have a plan to provide for our schools so we keep the standards, but we help our teachers teach and elevate our schools by funding No Child Left Behind. I have a plan to protect the environment so that we leave this place in better shape to our children than we were handed it by our parents. That's the test. I believe America's best days are ahead of us. I'm an optimist. But we have to make the right choices, to be fiscally responsible and to create the new jobs of the future. We can do this. And I ask you for the privilege of leading our Nation to be stronger at home and respected again in the world. Thank you. Mr. Gibson. Senator. And a closing statement from President Bush. President Bush. Charlie, thanks. Thank you all very much. It's been enjoyable. The great contest for the Presidency is about the future, who can lead, who can get things done. We've been through a lot together as a country, been through a recession, corporate scandals, war. And yet, think about where we are. We added 1.9 million new jobs over the past 13 months. The farm income in America is high. Small businesses are flourishing. Homeownership rate is at an alltime high in America. We're on the move. Tonight I had a chance to discuss with you what to do to keep this economy going: Keep the taxes low, don't increase the scope of the Federal Government, keep regulations down, legal reform, a health care policy that does not empower the Federal Government but empowers individuals, and an energy plan that will help us become less dependent on foreign sources of energy. And abroad, we're at war, and it requires a President who is steadfast and strong and determined. I vowed to the American people after that fateful day of September the 11th that we would not rest nor tire until we're safe. The 9/11 Commission put out a report that said America is safer, but not yet safe. There's more work to be done. We'll stay on the hunt on Al Qaida. We'll deny sanctuary to these terrorists. We'll make sure they do not end up with weapons of mass destruction. The great nexus, the great threat to our country is that these haters end up with weapons of mass destruction. But our long-term security depends on our deep faith in liberty. We'll continue to promote freedom around the world. Freedom is on the march. Tomorrow Afghanistan will be voting for a President. In Iraq, we'll be having free elections, and a free society will make this world more peaceful. God bless. Mr. Gibson. Mr. President and Senator Kerry. That concludes tonight's debate. I want to give you a reminder that the third and final debate, on issues of domestic policy, will be held next Wednesday, October 13th, at Arizona State University in Tempe, Arizona, hosted by Bob Schieffer of CBS News. I want to thank President Bush and Senator Kerry for tonight. I want to thank these citizens of the St. Louis area who asked the questions, who gave so willingly of their time, and who took their responsibility very seriously. Thank you also to everyone at Washington. I want to thank everyone at Washington University in St. Louis for being such gracious hosts. I'm Charles Gibson from ABC News. From St. Louis, good night.
