# Presidential Debate in Nashville, Tennessee

**Date:** October 7, 2008
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-belmont-university-nashville-tennessee

---

[moderated by Tom Brokaw of NBC News] BROKAW: Good evening from Belmont University in Nashville, Tennessee. I'm Tom Brokaw of NBC News. And welcome to this second presidential debate, sponsored by the Commission on Presidential Debates. Tonight's debate is the only one with a town hall format. The Gallup Organization chose 80 uncommitted voters from the Nashville area to be here with us tonight. And earlier today, each of them gave me a copy of their question for the candidates. From all of these questions -- and from tens of thousands submitted online -- I have selected a long list of excellent questions on domestic and foreign policy. Neither the commission nor the candidates have seen the questions. And although we won't be able to get to all of them tonight, we should have a wide-ranging discussion one month before the election. Each candidate will have two minutes to respond to a common question, and there will be a one-minute follow-up. The audience here in the hall has agreed to be polite, and attentive, no cheering or outbursts. Those of you at home, of course, are not so constrained. The only exception in the hall is right now, as it is my privilege to introduce the candidates, Senator Barack Obama of Illinois and Senator John McCain of Arizona. Gentlemen? (APPLAUSE) Gentlemen, we want to get underway immediately, if we can. Since you last met at Ole Miss 12 days ago, the world has changed a great deal, and not for the better. We still don't know where the bottom is at this time. As you might expect, many of the questions that we have from here in the hall tonight and from online have to do with the American economy and, in fact, with global economic conditions. I understand that you flipped a coin. And, Senator Obama, you will begin tonight. And we're going to have our first question from over here in Section A from Alan Schaefer. Alan? QUESTION: With the economy on the downturn and retired and older citizens and workers losing their incomes, what's the fastest, most positive solution to bail these people out of the economic ruin? OBAMA: Well, Alan, thank you very much for the question. I want to first, obviously, thank Belmont University, Tom, thank you, and to all of you who are participating tonight and those of you who sent e-mail questions in. I think everybody knows now we are in the worst financial crisis since the Great Depression. And a lot of you I think are worried about your jobs, your pensions, your retirement accounts, your ability to send your child or your grandchild to college. And I believe this is a final verdict on the failed economic policies of the last eight years, strongly promoted by President Bush and supported by Senator McCain, that essentially said that we should strip away regulations, consumer protections, let the market run wild, and prosperity would rain down on all of us. It hasn't worked out that way. And so now we've got to take some decisive action. OBAMA: Now, step one was a rescue package that was passed last week. We've got to make sure that works properly. And that means strong oversight, making sure that investors, taxpayers are getting their money back and treated as investors. It means that we are cracking down on CEOs and making sure that they're not getting bonuses or golden parachutes as a consequence of this package. And, in fact, we just found out that AIG, a company that got a bailout, just a week after they got help went on a $400,000 junket. And I'll tell you what, the Treasury should demand that money back and those executives should be fired. But that's only step one. The middle-class need a rescue package. And that means tax cuts for the middle-class. It means help for homeowners so that they can stay in their homes. It means that we are helping state and local governments set up road projects and bridge projects that keep people in their jobs. And then long-term we've got to fix our health care system, we've got to fix our energy system that is putting such an enormous burden on families. You need somebody working for you and you've got to have somebody in Washington who is thinking about the middle class and not just those who can afford to hire lobbyists. BROKAW: Senator McCain? MCCAIN: Well, thank you, Tom. Thank you, Belmont University. And Senator Obama, it's good to be with you at a town hall meeting. And, Alan, thank you for your question. You go to the heart of America's worries tonight. Americans are angry, they're upset, and they're a little fearful. It's our job to fix the problem. Now, I have a plan to fix this problem and it has got to do with energy independence. We've got to stop sending $700 billion a year to countries that don't want us very -- like us very much. We have to keep Americans' taxes low. All Americans' taxes low. Let's not raise taxes on anybody today. We obviously have to stop this spending spree that's going on in Washington. Do you know that we've laid a $10 trillion debt on these young Americans who are here with us tonight, $500 billion of it we owe to China? We've got to have a package of reforms and it has got to lead to reform prosperity and peace in the world. And I think that this problem has become so severe, as you know, that we're going to have to do something about home values. You know that home values of retirees continues to decline and people are no longer able to afford their mortgage payments. As president of the United States, Alan, I would order the secretary of the treasury to immediately buy up the bad home loan mortgages in America and renegotiate at the new value of those homes -- at the diminished value of those homes and let people be able to make those -- be able to make those payments and stay in their homes. Is it expensive? Yes. But we all know, my friends, until we stabilize home values in America, we're never going to start turning around and creating jobs and fixing our economy. And we've got to give some trust and confidence back to America. I know how the do that, my friends. And it's my proposal, it's not Senator Obama's proposal, it's not President Bush's proposal. But I know how to get America working again, restore our economy and take care of working Americans. Thank you. BROKAW: Senator, we have one minute for a discussion here. Obviously the powers of the treasury secretary have been greatly expanded. The most powerful officer in the cabinet now. Hank Paulson says he won't stay on. Who do you have in mind to appoint to that very important post? Senator McCain? MCCAIN: Not you, Tom. (LAUGHTER) BROKAW: No, with good reason. MCCAIN: You know, that's a tough question and there's a lot of qualified Americans. But I think the first criteria, Tom, would have to be somebody who immediately Americans identify with, immediately say, we can trust that individual. A supporter of Senator Obama's is Warren Buffett. He has already weighed in and helped stabilize some of the difficulties in the markets and with companies and corporations, institutions today. I like Meg Whitman, she knows what it's like to be out there in the marketplace. She knows how to create jobs. Meg Whitman was CEO of a company that started with 12 people and is now 1.3 million people in America make their living off eBay. Maybe somebody here has done a little business with them. But the point is it's going to have to be somebody who inspires trust and confidence. Because the problem in America today to a large extent, Tom, is that we don't have trust and confidence in our institutions because of the corruption on Wall Street and the greed and excess and the cronyism in Washington, D.C. BROKAW: All right. Senator McCain -- Senator Obama, who do you have in mind for treasury secretary? OBAMA: Well, Warren would be a pretty good choice -- Warren Buffett, and I'm pleased to have his support. But there are other folks out there. The key is making sure that the next treasury secretary understands that it's not enough just to help those at the top. Prosperity is not just going to trickle down. We've got to help the middle class. OBAMA: And we've -- you know, Senator McCain and I have some fundamental disagreements on the economy, starting with Senator McCain's statement earlier that he thought the fundamentals of the economy were sound. Part of the problem here is that for many of you, wages and incomes have flat-lined. For many of you, it is getting harder and harder to save, harder and harder to retire. And that's why, for example, on tax policy, what I want to do is provide a middle class tax cut to 95 percent of working Americans, those who are working two jobs, people who are not spending enough time with their kids, because they are struggling to make ends meet. Senator McCain is right that we've got to stabilize housing prices. But underlying that is loss of jobs and loss of income. That's something that the next treasury secretary is going to have to work on. BROKAW: Senator Obama, thank you very much. May I remind both of you, if I can, that we're operating under rules that you signed off on and when we have a discussion, it really is to be confined within about a minute or so. We're going to go now, Senator McCain, to the next question from you from the hall here, and it comes from Oliver Clark, who is over here in section F. Oliver? QUESTION: Well, Senators, through this economic crisis, most of the people that I know have had a difficult time. And through this bailout package, I was wondering what it is that's going to actually help those people out. MCCAIN: Well, thank you, Oliver, and that's an excellent question, because as you just described it, bailout, when I believe that it's rescue, because -- because of the greed and excess in Washington and Wall Street, Main Street was paying a very heavy price, and we know that. I left my campaign and suspended it to go back to Washington to make sure that there were additional protections for the taxpayer in the form of good oversight, in the form of taxpayers being the first to be paid back when our economy recovers -- and it will recover -- and a number of other measures. But you know, one of the real catalysts, really the match that lit this fire was Fannie Mae and Freddie Mac. I'll bet you, you may never even have heard of them before this crisis. But you know, they're the ones that, with the encouragement of Senator Obama and his cronies and his friends in Washington, that went out and made all these risky loans, gave them to people that could never afford to pay back. And you know, there were some of us that stood up two years ago and said we've got to enact legislation to fix this. We've got to stop this greed and excess. Meanwhile, the Democrats in the Senate and some -- and some members of Congress defended what Fannie and Freddie were doing. They resisted any change. Meanwhile, they were getting all kinds of money in campaign contributions. Senator Obama was the second highest recipient of Fannie Mae and Freddie Mac money in history -- in history. So this rescue package means that we will stabilize markets, we will shore up these institutions. But it's not enough. That's why we're going to have to go out into the housing market and we're going to have to buy up these bad loans and we're going to have to stabilize home values, and that way, Americans, like Alan, can realize the American dream and stay in their home. But Fannie and Freddie were the catalysts, the match that started this forest fire. There were some of us -- there were some of us that stood up against it. There were others who took a hike. BROKAW: Senator Obama? OBAMA: Well, Oliver, first, let me tell you what's in the rescue package for you. Right now, the credit markets are frozen up and what that means, as a practical matter, is that small businesses and some large businesses just can't get loans. If they can't get a loan, that means that they can't make payroll. If they can't make payroll, then they may end up having to shut their doors and lay people off. And if you imagine just one company trying to deal with that, now imagine a million companies all across the country. So it could end up having an adverse effect on everybody, and that's why we had to take action. But we shouldn't have been there in the first place. Now, I've got to correct a little bit of Senator McCain's history, not surprisingly. Let's, first of all, understand that the biggest problem in this whole process was the deregulation of the financial system. Senator McCain, as recently as March, bragged about the fact that he is a deregulator. On the other hand, two years ago, I said that we've got a sub-prime lending crisis that has to be dealt with. I wrote to Secretary Paulson, I wrote to Federal Reserve Chairman Bernanke, and told them this is something we have to deal with, and nobody did anything about it. A year ago, I went to Wall Street and said we've got to reregulate, and nothing happened. OBAMA: And Senator McCain during that period said that we should keep on deregulating because that's how the free enterprise system works. Now, with respect to Fannie Mae, what Senator McCain didn't mention is the fact that this bill that he talked about wasn't his own bill. He jumped on it a year after it had been introduced and it never got passed. And I never promoted Fannie Mae. In fact, Senator McCain's campaign chairman's firm was a lobbyist on behalf of Fannie Mae, not me. So -- but, look, you're not interested in hearing politicians pointing fingers. What you're interested in is trying to figure out, how is this going to impact you? This is not the end of the process; this is the beginning of the process. And that's why it's going to be so important for us to work with homeowners to make sure that they can stay in their homes. The secretary already has the power to do that in the rescue package, but it hasn't been exercised yet. And the next president has to make sure that the next Treasury secretary is thinking about how to strengthen you as a home buyer, you as a homeowner, and not simply think about bailing out banks on Wall Street. BROKAW: Senator Obama, time for a discussion. I'm going to begin with you. Are you saying to Mr. Clark and to the other members of the American television audience that the American economy is going to get much worse before it gets better and they ought to be prepared for that? OBAMA: No, I am confident about the American economy. But we are going to have to have some leadership from Washington that not only sets out much better regulations for the financial system. The problem is we still have a archaic, 20th-century regulatory system for 21st-century financial markets. We're going to have to coordinate with other countries to make sure that whatever actions we take work. But most importantly, we're going to have to help ordinary families be able to stay in their homes, make sure that they can pay their bills, deal with critical issues like health care and energy, and we're going to have to change the culture in Washington so that lobbyists and special interests aren't driving the process and your voices aren't being drowned out. BROKAW: Senator McCain, in all candor, do you think the economy is going to get worse before it gets better? MCCAIN: I think it depends on what we do. I think if we act effectively, if we stabilize the housing market -- which I believe we can, if we go out and buy up these bad loans, so that people can have a new mortgage at the new value of their home -- I think if we get rid of the cronyism and special interest influence in Washington so we can act more effectively. My friend, I'd like you to see the letter that a group of senators and I wrote warning exactly of this crisis. Senator Obama's name was not on that letter. The point is -- the point is that we can fix our economy. Americans' workers are the best in the world. They're the fundamental aspect of America's economy. They're the most innovative. They're the best -- they're most -- have best -- we're the best exporters. We're the best importers. They're most effective. They are the best workers in the world. And we've got to give them a chance. They've got -- we've got to give them a chance to do their best again. And they are the innocent bystanders here in what is the biggest financial crisis and challenge of our time. We can do it. BROKAW: Thank you, Senator McCain. We're going to continue over in Section F, as it turns out. Senator Obama, this is a question from you from Theresa Finch. Theresa? QUESTION: How can we trust either of you with our money when both parties got -- got us into this global economic crisis? OBAMA: Well, look, I understand your frustration and your cynicism, because while you've been carrying out your responsibilities -- most of the people here, you've got a family budget. If less money is coming in, you end up making cuts. Maybe you don't go out to dinner as much. Maybe you put off buying a new car. That's not what happens in Washington. And you're right. There is a lot of blame to go around. But I think it's important just to remember a little bit of history. When George Bush came into office, we had surpluses. And now we have half-a-trillion-dollar deficit annually. When George Bush came into office, our debt -- national debt was around $5 trillion. It's now over $10 trillion. We've almost doubled it. And so while it's true that nobody's completely innocent here, we have had over the last eight years the biggest increases in deficit spending and national debt in our history. And Senator McCain voted for four out of five of those George Bush budgets. So here's what I would do. I'm going to spend some money on the key issues that we've got to work on. OBAMA: You know, you may have seen your health care premiums go up. We've got to reform health care to help you and your budget. We are going to have to deal with energy because we can't keep on borrowing from the Chinese and sending money to Saudi Arabia. We are mortgaging our children's future. We've got to have a different energy plan. We've got to invest in college affordability. So we're going to have to make some investments, but we've also got to make spending cuts. And what I've proposed, you'll hear Senator McCain say, well, he's proposing a whole bunch of new spending, but actually I'm cutting more than I'm spending so that it will be a net spending cut. The key is whether or not we've got priorities that are working for you as opposed to those who have been dictating the policy in Washington lately, and that's mostly lobbyists and special interests. We've got to put an end to that. BROKAW: Senator McCain? MCCAIN: Well, Theresa, thank you. And I can see why you feel that cynicism and mistrust, because the system in Washington is broken. And I have been a consistent reformer. I have advocated and taken on the special interests, whether they be the big money people by reaching across the aisle and working with Senator Feingold on campaign finance reform, whether it being a variety of other issues, working with Senator Lieberman on trying to address climate change. I have a clear record of bipartisanship. The situation today cries out for bipartisanship. Senator Obama has never taken on his leaders of his party on a single issue. And we need to reform. And so let's look at our records as well as our rhetoric. That's really part of your mistrust here. And now I suggest that maybe you go to some of these organizations that are the watchdogs of what we do, like the Citizens Against Government Waste or the National Taxpayers Union or these other organizations that watch us all the time. I don't expect you to watch every vote. And you know what you'll find? This is the most liberal big-spending record in the United States Senate. I have fought against excessive spending and outrages. I have fought to reduce the earmarks and eliminate them. Do you know that Senator Obama has voted for -- is proposing $860 billion of new spending now? New spending. Do you know that he voted for every increase in spending that I saw come across the floor of the United States Senate while we were working to eliminate these pork barrel earmarks? He voted for nearly a billion dollars in pork barrel earmark projects, including, by the way, $3 million for an overhead projector at a planetarium in Chicago, Illinois. My friends, do we need to spend that kind of money? I think you have to look at my record and you have to look at his. Then you have to look at our proposals for our economy, not $860 billion in new spending, but for the kinds of reforms that keep people in their jobs, get middle-income Americans working again, and getting our economy moving again. You're going to be examining our proposals tonight and in the future, and energy independence is a way to do that, is one of them. And drilling offshore and nuclear power are two vital elements of that. And I've been supporting those and I know how to fix this economy, and eliminate our dependence on foreign oil, and stop sending $700 billion a year overseas. BROKAW: We've run out of time. We have this one-minute discussion period going on here. There are new economic realities out there that everyone in this hall and across this country understands that there are going to have to be some choices made. Health policies, energy policies, and entitlement reform, what are going to be your priorities in what order? Which of those will be your highest priority your first year in office and which will follow in sequence? Senator McCain? MCCAIN: The three priorities were health... BROKAW: The three -- health care, energy, and entitlement reform: Social Security and Medicare. In what order would you put them in terms of priorities? MCCAIN: I think you can work on all three at once, Tom. I think it's very important that reform our entitlement programs. My friends, we are not going to be able to provide the same benefit for present-day workers that we are going -- that present-day retirees have today. We're going to have to sit down across the table, Republican and Democrat, as we did in 1983 between Ronald Reagan and Tip O'Neill. I know how to do that. I have a clear record of reaching across the aisle, whether it be Joe Lieberman or Russ Feingold or Ted Kennedy or others. That's my clear record. We can work on nuclear power plants. Build a whole bunch of them, create millions of new jobs. We have to have all of the above, alternative fuels, wind, tide, solar, natural gas, clean coal technology. All of these things we can do as Americans and we can take on this mission and we can overcome it. MCCAIN: My friends, some of this $700 billion ends up in the hands of terrorist organizations. As far as health care is concerned, obviously, everyone is struggling to make sure that they can afford their premiums and that they can have affordable and available health care. That's the next issue. But we can do them all at once. There's no -- and we have to do them all at once. All three you mentioned are compelling national security requirements. BROKAW: I'm trying to play by the rules that you all established. One minute for discussion. Senator Obama, if you would give us your list of priorities, there are some real questions about whether everything can be done at once. OBAMA: We're going to have to prioritize, just like a family has to prioritize. Now, I've listed the things that I think have to be at the top of the list. Energy we have to deal with today, because you're paying $3.80 here in Nashville for gasoline, and it could go up. And it's a strain on your family budget, but it's also bad for our national security, because countries like Russia and Venezuela and, you know, in some cases, countries like Iran, are benefiting from higher oil prices. So we've got to deal with that right away. That's why I've called for an investment of $15 billion a year over 10 years. Our goal should be, in 10 year's time, we are free of dependence on Middle Eastern oil. And we can do it. Now, when JFK said we're going to the Moon in 10 years, nobody was sure how to do it, but we understood that, if the American people make a decision to do something, it gets done. So that would be priority number one. Health care is priority number two, because that broken health care system is bad not only for families, but it's making our businesses less competitive. And, number three, we've got to deal with education so that our young people are competitive in a global economy. But just one point I want to make, Tom. Senator McCain mentioned looking at our records. We do need to look at our records. Senator McCain likes to talk about earmarks a lot. And that's important. I want to go line by line through every item in the federal budget and eliminate programs that don't work and make sure that those that do work, work better and cheaper. But understand this: We also have to look at where some of our tax revenues are going. So when Senator McCain proposes a $300 billion tax cut, a continuation not only of the Bush tax cuts, but an additional $200 billion that he's going to give to big corporations, including big oil companies, $4 billion worth, that's money out of the system. And so we've got to prioritize both our spending side and our tax policies to make sure that they're working for you. That's what I'm going to do as president of the United States. BROKAW: All right, gentlemen, I want to just remind you one more time about time. We're going to have a larger deficit than the federal government does if we don't get this under control here before too long. (LAUGHTER) Senator McCain, for you, we have our first question from the Internet tonight. A child of the Depression, 78-year-old Fiora from Chicago. Since World War II, we have never been asked to sacrifice anything to help our country, except the blood of our heroic men and women. As president, what sacrifices -- sacrifices will you ask every American to make to help restore the American dream and to get out of the economic morass that we're now in? MCCAIN: Well, Fiora, I'm going to ask the American people to understand that there are some programs that we may have to eliminate. I first proposed a long time ago that we would have to examine every agency and every bureaucracy of government. And we're going to have to eliminate those that aren't working. I know a lot of them that aren't working. One of them is in defense spending, because I've taken on some of the defense contractors. I saved the taxpayers $6.8 billion in a deal for an Air Force tanker that was done in a corrupt fashion. I believe that we have to eliminate the earmarks. And sometimes those projects, not -- not the overhead projector that Senator Obama asked for, but some of them that are really good projects, will have -- will have to be eliminated, as well. And they'll have to undergo the same scrutiny that all projects should in competition with others. So we're going to have to tell the American people that spending is going to have to be cut in America. And I recommend a spending freeze that -- except for defense, Veterans Affairs, and some other vital programs, we'll just have to have across-the-board freeze. And some of those programs may not grow as much as we would like for them to, but we can establish priorities with full transparency, with full knowledge of the American people, and full consultation, not done behind closed doors and shoving earmarks in the middle of the night into programs that we don't even -- sometimes we don't even know about until months later. And, by the way, I want to go back a second. MCCAIN: Look, we can attack health care and energy at the same time. We're not -- we're not -- we're not rifle shots here. We are Americans. We can, with the participation of all Americans, work together and solve these problems together. Frankly, I'm not going to tell that person without health insurance that, "I'm sorry, you'll have to wait." I'm going to tell you Americans we'll get to work right away and we'll get to work together, and we can get them all done, because that's what America has been doing. BROKAW: Senator McCain, thank you very much. Senator Obama? OBAMA: You know, a lot of you remember the tragedy of 9/11 and where you were on that day and, you know, how all of the country was ready to come together and make enormous changes to make us not only safer, but to make us a better country and a more unified country. And President Bush did some smart things at the outset, but one of the opportunities that was missed was, when he spoke to the American people, he said, "Go out and shop." That wasn't the kind of call to service that I think the American people were looking for. And so it's important to understand that the -- I think the American people are hungry for the kind of leadership that is going to tackle these problems not just in government, but outside of government. And let's take the example of energy, which we already spoke about. There is going to be the need for each and every one of us to start thinking about how we use energy. I believe in the need for increased oil production. We're going to have to explore new ways to get more oil, and that includes offshore drilling. It includes telling the oil companies, that currently have 68 million acres that they're not using, that either you use them or you lose them. We're going to have to develop clean coal technology and safe ways to store nuclear energy. But each and every one of us can start thinking about how can we save energy in our homes, in our buildings. And one of the things I want to do is make sure that we're providing incentives so that you can buy a fuel efficient car that's made right here in the United States of America, not in Japan or South Korea, making sure that you are able to weatherize your home or make your business more fuel efficient. And that's going to require effort from each and every one of us. And the last point I just want to make. I think the young people of America are especially interested in how they can serve, and that's one of the reasons why I'm interested in doubling the Peace Corps, making sure that we are creating a volunteer corps all across this country that can be involved in their community, involved in military service, so that military families and our troops are not the only ones bearing the burden of renewing America. That's something that all of us have to be involved with and that requires some leadership from Washington. BROKAW: Senator Obama, as we begin, very quickly, our discussion period, President Bush, you'll remember, last summer, said that "Wall Street got drunk." A lot of people now look back and think the federal government got drunk and, in fact, the American consumers got drunk. How would you, as president, try to break those bad habits of too much debt and too much easy credit, specifically, across the board, for this country, not just at the federal level, but as a model for the rest of the country, as well? OBAMA: Well, I think it starts with Washington. We've got to show that we've got good habits, because if we're running up trillion dollar debts that we're passing on to the next generation, then a lot of people are going to think, "Well, you know what? There's easy money out there." It means -- and I have to, again, repeat this. It means looking at the spending side, but also at the revenue side. I mean, Senator McCain has been talking tough about earmarks, and that's good, but earmarks account for about $18 billion of our budget. Now, when Senator McCain is proposing tax cuts that would give the average Fortune 500 CEO an additional $700,000 in tax cuts, that's not sharing a burden. And so part of the problem, I think, for a lot of people who are listening here tonight is they don't feel as if they are sharing the burden with other folks. I mean, you know, it's tough to ask a teacher who's making $30,000 or $35,000 a year to tighten her belt when people who are making much more than her are living pretty high on the hog. And that's why I think it's important for the president to set a tone that says all of us are going to contribute, all of us are going to make sacrifices, and it means that, yes, we may have to cut some spending, although I disagree with Senator McCain about an across-the- board freeze. That's an example of an unfair burden sharing. That's using a hatchet to cut the federal budget. OBAMA: I want to use a scalpel so that people who need help are getting help and those of us, like myself and Senator McCain, who don't need help, aren't getting it. That's how we make sure that everybody is willing to make a few sacrifices. BROKAW: Senator McCain? MCCAIN: Well, you know, nailing down Senator Obama's various tax proposals is like nailing Jell-O to the wall. There has been five or six of them and if you wait long enough, there will probably be another one. But he wants to raise taxes. My friends, the last president to raise taxes during tough economic times was Herbert Hoover, and he practiced protectionism as well, which I'm sure we'll get to at some point. You know, last year up to this time, we've lost 700,000 jobs in America. The only bright spot is that over 300,000 jobs have been created by small businesses. Senator Obama's secret that you don't know is that his tax increases will increase taxes on 50 percent of small business revenue. Small businesses across America will have to cut jobs and will have their taxes increase and won't be able to hire because of Senator Obama's tax policies. You know, he said some time ago, he said he would forgo his tax increases if the economy was bad. I've got some news, Senator Obama, the news is bad. So let's not raise anybody's taxes, my friends, and make it be very clear to you I am not in favor of tax cuts for the wealthy. I am in favor of leaving the tax rates alone and reducing the tax burden on middle-income Americans by doubling your tax exemption for every child from $3,500 to $7,000. To giving every American a $5,000 refundable tax credit and go out and get the health insurance you want rather than mandates and fines for small businesses, as Senator Obama's plan calls for. And let's create jobs and let's get our economy going again. And let's not raise anybody's taxes. BROKAW: Senator Obama, we have another question from the Internet. OBAMA: Tom, can I respond to this briefly? Because... BROKAW: Well, look, guys, the rules were established by the two campaigns, we worked very hard on this. This will address, I think, the next question. OBAMA: The tax issue, because I think it's very important. Go ahead. BROKAW: There are lots of issues that we are going to be dealing with here tonight. And we have a question from Langdon in Ballston Spa, New York, and that's about huge unfunded obligations for Social Security, Medicare, and other entitlement programs that will soon eat up all of the revenue that's in place and then go into a deficit position. Since the rules are pretty loose here, I'm going to add my own to this one. Instead of having a discussion, let me ask you as a coda to that. Would you give Congress a date certain to reform Social Security and Medicare within two years after you take office? Because in a bipartisan way, everyone agrees, that's a big ticking time bomb that will eat us up maybe even more than the mortgage crisis. OBAMA: Well, Tom, we're going to have to take on entitlements and I think we've got to do it quickly. We're going to have a lot of work to do, so I can't guarantee that we're going to do it in the next two years, but I'd like to do in the my first term as president. But I think it's important to understand, we're not going to solve Social Security and Medicare unless we understand the rest of our tax policies. And you know, Senator McCain, I think the "Straight Talk Express" lost a wheel on that one. So let's be clear about my tax plan and Senator McCain's, because we're not going to be able to deal with entitlements unless we understand the revenues coming in. I want to provide a tax cut for 95 percent of Americans, 95 percent. If you make less than a quarter of a million dollars a year, you will not see a single dime of your taxes go up. If you make $200,000 a year or less, your taxes will go down. Now, Senator McCain talks about small businesses. Only a few percent of small businesses make more than $250,000 a year. So the vast majority of small businesses would get a tax cut under my plan. And we provide a 50 percent tax credit so that they can buy health insurance for their workers, because there are an awful lot of small businesses that I meet across America that want to do right by their workers but they just can't afford it. Some small business owners, a lot of them, can't even afford health insurance for themselves. Now, in contrast, Senator McCain wants to give a $300 billion tax cut, $200 billion of it to the largest corporations and a hundred thousand of it -- a hundred billion of it going to people like CEOs on Wall Street. He wants to give average Fortune 500 CEO an additional $700,000 in tax cuts. That is not fair. And it doesn't work. OBAMA: Now, if we get our tax policies right so that they're good for the middle class, if we reverse the policies of the last eight years that got us into this fix in the first place and that Senator McCain supported, then we are going to be in a position to deal with Social Security and deal with Medicare, because we will have a health care plan that actually works for you, reduces spending and costs over the long term, and Social Security that is stable and solvent for all Americans and not just some. BROKAW: Senator McCain, two years for a reform of entitlement programs? MCCAIN: Sure. Hey, I'll answer the question. Look -- look, it's not that hard to fix Social Security, Tom. It's just... BROKAW: And Medicare. MCCAIN: ... tough decisions. I want to get to Medicare in a second. Social Security is not that tough. We know what the problems are, my friends, and we know what the fixes are. We've got to sit down together across the table. It's been done before. I saw it done with our -- our wonderful Ronald Reagan, a conservative from California, and the liberal Democrat Tip O'Neill from Massachusetts. That's what we need more of, and that's what I've done in Washington. Senator Obama has never taken on his party leaders on a single major issue. I've taken them on. I'm not too popular sometimes with my own party, much less his. So Medicare, it's going to be a little tougher. It's going to be a little tougher because we're talking about very complex and difficult issues. My friends, what we have to do with Medicare is have a commission, have the smartest people in America come together, come up with recommendations, and then, like the base-closing commission idea we had, then we should have Congress vote up or down. Let's not let them fool with it anymore. There's too much special interests and too many lobbyists working there. So let's have -- and let's have the American people say, "Fix it for us." Now, just back on this -- on this tax, you know, again, it's back to our first question here about rhetoric and record. Senator Obama has voted 94 times to either increase your taxes or against tax cuts. That's his record. When he ran for the United States Senate from Illinois, he said he would have a middle-income tax cut. You know he came to the Senate and never once proposed legislation to do that? So let's look at our record. I've fought higher taxes. I have fought excess spending. I have fought to reform government. Let's look at our records, my friends, and then listen to my vision for the future of America. And we'll get our economy going again. And our best days are ahead of us. BROKAW: Senator McCain, thank you very much. I'm going to stick by my part of the pact and not ask a follow-up here. The next question does come from the hall for Senator McCain. It comes from Section C over here, and it's from Ingrid Jackson. Ingrid? QUESTION: Senator McCain, I want to know, we saw that Congress moved pretty fast in the face of an economic crisis. I want to know what you would do within the first two years to make sure that Congress moves fast as far as environmental issues, like climate change and green jobs? MCCAIN: Well, thank you. Look, we are in tough economic times; we all know that. And let's keep -- never forget the struggle that Americans are in today. But when we can -- when we have an issue that we may hand our children and our grandchildren a damaged planet, I have disagreed strongly with the Bush administration on this issue. I traveled all over the world looking at the effects of greenhouse gas emissions, Joe Lieberman and I. And I introduced the first legislation, and we forced votes on it. That's the good news, my friends. The bad news is we lost. But we kept the debate going, and we kept this issue to -- to posing to Americans the danger that climate change opposes. Now, how -- what's -- what's the best way of fixing it? Nuclear power. Senator Obama says that it has to be safe or disposable or something like that. Look, I -- I was on Navy ships that had nuclear power plants. Nuclear power is safe, and it's clean, and it creates hundreds of thousands of jobs. And -- and I know that we can reprocess the spent nuclear fuel. The Japanese, the British, the French do it. And we can do it, too. Senator Obama has opposed that. We can move forward, and clean up our climate, and develop green technologies, and alternate -- alternative energies for -- for hybrid, for hydrogen, for battery-powered cars, so that we can clean up our environment and at the same time get our economy going by creating millions of jobs. We can do that, we as Americans, because we're the best innovators, we're the best producers, and 95 percent of the people who are our market live outside of the United States of America. BROKAW: Senator Obama? OBAMA: This is one of the biggest challenges of our times. OBAMA: And it is absolutely critical that we understand this is not just a challenge, it's an opportunity, because if we create a new energy economy, we can create five million new jobs, easily, here in the United States. It can be an engine that drives us into the future the same way the computer was the engine for economic growth over the last couple of decades. And we can do it, but we're going to have to make an investment. The same way the computer was originally invented by a bunch of government scientists who were trying to figure out, for defense purposes, how to communicate, we've got to understand that this is a national security issue, as well. And that's why we've got to make some investments and I've called for investments in solar, wind, geothermal. Contrary to what Senator McCain keeps on saying, I favor nuclear power as one component of our overall energy mix. But this is another example where I think it is important to look at the record. Senator McCain and I actually agree on something. He said a while back that the big problem with energy is that for 30 years, politicians in Washington haven't done anything. What Senator McCain doesn't mention is he's been there 26 of them. And during that time, he voted 23 times against alternative fuels, 23 times. So it's easy to talk about this stuff during a campaign, but it's important for us to understand that it requires a sustained effort from the next president. One last point I want to make on energy. Senator McCain talks a lot about drilling, and that's important, but we have three percent of the world's oil reserves and we use 25 percent of the world's oil. So what that means is that we can't simply drill our way out of the problem. And we're not going to be able to deal with the climate crisis if our only solution is to use more fossil fuels that create global warming. We're going to have to come up with alternatives, and that means that the United States government is working with the private sector to fund the kind of innovation that we can then export to countries like China that also need energy and are setting up one coal power plant a week. We've got to make sure that we're giving them the energy that they need or helping them to create the energy that they need. BROKAW: Gentlemen, you may not have noticed, but we have lights around here. They have red and green and yellow and they are to signal... OBAMA: I'm just trying to keep up with John. MCCAIN: Tom, wave like that and I'll look at you. BROKAW: All right, Senator. Here's a follow-up to that, one-minute discussion. It's a simple question. MCCAIN: Sure. BROKAW: Should we fund a Manhattan-like project that develops a nuclear bomb to deal with global energy and alternative energy or should we fund 100,000 garages across America, the kind of industry and innovation that developed Silicon Valley? MCCAIN: I think pure research and development investment on the part of the United States government is certainly appropriate. I think once it gets into productive stages, that we ought to, obviously, turn it over to the private sector. By the way, my friends, I know you grow a little weary with this back-and-forth. It was an energy bill on the floor of the Senate loaded down with goodies, billions for the oil companies, and it was sponsored by Bush and Cheney. You know who voted for it? You might never know. That one. You know who voted against it? Me. I have fought time after time against these pork barrel -- these bills that come to the floor and they have all kinds of goodies and all kinds of things in them for everybody and they buy off the votes. I vote against them, my friends. I vote against them. But the point is, also, on oil drilling, oil drilling offshore now is vital so that we can bridge the gap. We can bridge the gap between imported oil, which is a national security issue, as well as any other, and it will reduce the price of a barrel of oil, because when people know there's a greater supply, then the cost of that will go down. That's fundamental economics. We've got to drill offshore, my friends, and we've got to do it now, and we can do it. And as far as nuclear power is concerned, again, look at the record. Senator Obama has approved storage and reprocessing of spent nuclear fuel. And I'll stop, Tom, and you didn't even wave. Thanks. BROKAW: Thank you very much, Senator. Next question for you, Senator Obama, and it comes from the E section over here and it's from Lindsey Trellow. Lindsey? QUESTION: Senator, selling health care coverage in America as the marketable commodity has become a very profitable industry. Do you believe health care should be treated as a commodity? OBAMA: Well, you know, as I travel around the country, this is one of the single most frequently asked issues that I get, is the issue of health care. It is breaking family budgets. I can't tell you how many people I meet who don't have health insurance. If you've got health insurance, most of you have seen your premiums double over the last eight years. And your co-payments and deductibles have gone up 30 percent just in the last year alone. If you're a small business, it's a crushing burden. So one of the things that I have said from the start of this campaign is that we have a moral commitment as well as an economic imperative to do something about the health care crisis that so many families are facing. So here's what I would do. If you've got health care already, and probably the majority of you do, then you can keep your plan if you are satisfied with it. You can keep your choice of doctor. We're going to work with your employer to lower the cost of your premiums by up to $2,500 a year. And we're going to do it by investing in prevention. We're going to do it by making sure that we use information technology so that medical records are actually on computers instead of you filling forms out in triplicate when you go to the hospital. That will reduce medical errors and reduce costs. If you don't have health insurance, you're going to be able to buy the same kind of insurance that Senator McCain and I enjoy as federal employees. Because there's a huge pool, we can drop the costs. And nobody will be excluded for pre-existing conditions, which is a huge problem. Now, Senator McCain has a different kind of approach. He says that he's going to give you a $5,000 tax credit. What he doesn't tell you is that he is going to tax your employer-based health care benefits for the first time ever. So what one hand giveth, the other hand taketh away. He would also strip away the ability of states to provide some of the regulations on insurance companies to make sure you're not excluded for pre-existing conditions or your mammograms are covered or your maternity is covered. And that is fundamentally the wrong way to go. In fact, just today business organizations like the United States Chamber of Commerce, which generally are pretty supportive of Republicans, said that this would lead to the unraveling of the employer-based health care system. That, I don't think, is the kind of change that we need. We've got to have somebody who is fighting for patients and making sure that you get decent, affordable health care. And that's something that I'm committed to doing as president. BROKAW: Senator McCain? MCCAIN: Well, thank you for the question. You really identified one of the really major challenges that America faces. Co-payments go up, costs go up, skyrocketing costs, which make people less and less able to afford health insurance in America. And we need to do all of the things that are necessary to make it more efficient. Let's put health records online, that will reduce medical errors, as they call them. Let's have community health centers. Let's have walk-in clinics. Let's do a lot of things to impose efficiencies. But what is at stake here in this health care issue is the fundamental difference between myself and Senator Obama. As you notice, he starts talking about government. He starts saying, government will do this and government will do that, and then government will, and he'll impose mandates. If you're a small business person and you don't insure your employees, Senator Obama will fine you. Will fine you. That's remarkable. If you're a parent and you're struggling to get health insurance for your children, Senator Obama will fine you. I want to give every American a $5,000 refundable tax credit. They can take it anywhere, across state lines. Why not? Don't we go across state lines when we purchase other things in America? Of course it's OK to go across state lines because in Arizona they may offer a better plan that suits you best than it does here in Tennessee. And if you do the math, those people who have employer-based health benefits, if you put the tax on it and you have what's left over and you add $5,000 that you're going to get as a refundable tax credit, do the math, 95 percent of the American people will have increased funds to go out and buy the insurance of their choice and to shop around and to get -- all of those people will be covered except for those who have these gold-plated Cadillac kinds of policies. You know, like hair transplants, I might need one of those myself. But the point is that we have got to give people choice in America and not mandate things on them and give them the ability. Every parent I know would acquire health insurance for their children if they could. Obviously small business people want to give their employees health insurance. Of course they all want to do that. We've got to give them the wherewithal to do it. We can do it by giving them, as a start, a $5,000 refundable tax credit to go around and get the health insurance policy of their choice. BROKAW: Quick discussion. Is health care in America a privilege, a right, or a responsibility? Senator McCain? MCCAIN: I think it's a responsibility, in this respect, in that we should have available and affordable health care to every American citizen, to every family member. And with the plan that -- that I have, that will do that. But government mandates I -- I'm always a little nervous about. But it is certainly my responsibility. It is certainly small-business people and others, and they understand that responsibility. American citizens understand that. Employers understand that. But they certainly are a little nervous when Senator Obama says, if you don't get the health care policy that I think you should have, then you're going to get fined. And, by the way, Senator Obama has never mentioned how much that fine might be. Perhaps we might find that out tonight. OBAMA: Well, why don't -- why don't -- let's talk about this, Tom, because there was just a lot of stuff out there. BROKAW: Privilege, right or responsibility. Let's start with that. OBAMA: Well, I think it should be a right for every American. In a country as wealthy as ours, for us to have people who are going bankrupt because they can't pay their medical bills -- for my mother to die of cancer at the age of 53 and have to spend the last months of her life in the hospital room arguing with insurance companies because they're saying that this may be a pre-existing condition and they don't have to pay her treatment, there's something fundamentally wrong about that. So let me -- let me just talk about this fundamental difference. And, Tom, I know that we're under time constraints, but Senator McCain through a lot of stuff out there. Number one, let me just repeat, if you've got a health care plan that you like, you can keep it. All I'm going to do is help you to lower the premiums on it. You'll still have choice of doctor. There's no mandate involved. Small businesses are not going to have a mandate. What we're going to give you is a 50 percent tax credit to help provide health care for those that you need. Now, it's true that I say that you are going to have to make sure that your child has health care, because children are relatively cheap to insure and we don't want them going to the emergency room for treatable illnesses like asthma. And when Senator McCain says that he wants to provide children health care, what he doesn't mention is he voted against the expansion of the Children's Health Insurance Program that is responsible for making sure that so many children who didn't have previously health insurance have it now. Now, the final point I'll make on this whole issue of government intrusion and mandates -- it is absolutely true that I think it is important for government to crack down on insurance companies that are cheating their customers, that don't give you the fine print, so you end up thinking that you're paying for something and, when you finally get sick and you need it, you're not getting it. And the reason that it's a problem to go shopping state by state, you know what insurance companies will do? They will find a state -- maybe Arizona, maybe another state -- where there are no requirements for you to get cancer screenings, where there are no requirements for you to have to get pre-existing conditions, and they will all set up shop there. That's how in banking it works. Everybody goes to Delaware, because they've got very -- pretty loose laws when it comes to things like credit cards. And in that situation, what happens is, is that the protections you have, the consumer protections that you need, you're not going to have available to you. That is a fundamental difference that I have with Senator McCain. He believes in deregulation in every circumstance. That's what we've been going through for the last eight years. It hasn't worked, and we need fundamental change. BROKAW: Senator, we want to move on now. If we'd come back to the hall here, we're going to shift gears here a little bit and we're going to go to foreign policy and international matters, if we can... MCCAIN: I don't believe that -- did we hear the size of the fine? BROKAW: Phil Elliott is over here in this section, and Phil Elliott has a question for Senator McCain. Phil? QUESTION: Yes. Senator McCain, how will all the recent economic stress affect our nation's ability to act as a peacemaker in the world? MCCAIN: Well, I thank you for that question, because there's no doubt that history shows us that nations that are strong militarily over time have to have a strong economy, as well. And that is one of the challenges that America faces. But having said that, America -- and we'll hear a lot of criticism. I've heard a lot of criticism about America, and our national security policy, and all that, and much of that criticism is justified. But the fact is, America is the greatest force for good in the history of the world. My friends, we have gone to all four corners of the Earth and shed American blood in defense, usually, of somebody else's freedom and our own. MCCAIN: So we are peacemakers and we're peacekeepers. But the challenge is to know when the United States of American can beneficially effect the outcome of a crisis, when to go in and when not, when American military power is worth the expenditure of our most precious treasure. And that question can only be answered by someone with the knowledge and experience and the judgment, the judgment to know when our national security is not only at risk, but where the United States of America can make a difference in preventing genocide, in preventing the spread of terrorism, in doing the things that the United States has done, not always well, but we've done because we're a nation of good. And I am convinced that my record, going back to my opposition from sending the Marines to Lebanon, to supporting our efforts in Kosovo and Bosnia and the first Gulf War, and my judgment, I think, is something that I'm -- a record that I'm willing to stand on. Senator Obama was wrong about Iraq and the surge. He was wrong about Russia when they committed aggression against Georgia. And in his short career, he does not understand our national security challenges. We don't have time for on-the-job training, my friends. BROKAW: Senator Obama, the economic constraints on the U.S. military action around the world. OBAMA: Well, you know, Senator McCain, in the last debate and today, again, suggested that I don't understand. It's true. There are some things I don't understand. I don't understand how we ended up invading a country that had nothing to do with 9/11, while Osama Bin Laden and Al Qaeda are setting up base camps and safe havens to train terrorists to attack us. That was Senator McCain's judgment and it was the wrong judgment. When Senator McCain was cheerleading the president to go into Iraq, he suggested it was going to be quick and easy, we'd be greeted as liberators. That was the wrong judgment, and it's been costly to us. So one of the difficulties with Iraq is that it has put an enormous strain, first of all, on our troops, obviously, and they have performed heroically and honorably and we owe them an extraordinary debt of gratitude. But it's also put an enormous strain on our budget. We've spent, so far, close to $700 billion and if we continue on the path that we're on, as Senator McCain is suggesting, it's going to go well over $1 trillion. We're spending $10 billion a month in Iraq at a time when the Iraqis have a $79 billion surplus, $79 billion. And we need that $10 billion a month here in the United States to put people back to work, to do all these wonderful things that Senator McCain suggested we should be doing, but has not yet explained how he would pay for. Now, Senator McCain and I do agree, this is the greatest nation on earth. We are a force of good in the world. But there has never been a nation in the history of the world that saw its economy decline and maintained its military superiority. And the strains that have been placed on our alliances around the world and the respect that's been diminished over the last eight years has constrained us being able to act on something like the genocide in Darfur, because we don't have the resources or the allies to do everything that we should be doing. That's going to change when I'm president, but we can't change it unless we fundamentally change Senator McCain's and George Bush's foreign policy. It has not worked for America. BROKAW: Senator Obama, let me ask you if -- let's see if we can establish tonight the Obama doctrine and the McCain doctrine for the use of United States combat forces in situations where there's a humanitarian crisis, but it does not affect our national security. Take the Congo, where 4.5 million people have died since 1998, or take Rwanda in the earlier dreadful days, or Somalia. What is the Obama doctrine for use of force that the United States would send when we don't have national security issues at stake? OBAMA: Well, we may not always have national security issues at stake, but we have moral issues at stake. If we could have intervened effectively in the Holocaust, who among us would say that we had a moral obligation not to go in? If we could've stopped Rwanda, surely, if we had the ability, that would be something that we would have to strongly consider and act. So when genocide is happening, when ethnic cleansing is happening somewhere around the world and we stand idly by, that diminishes us. OBAMA: And so I do believe that we have to consider it as part of our interests, our national interests, in intervening where possible. But understand that there's a lot of cruelty around the world. We're not going to be able to be everywhere all the time. That's why it's so important for us to be able to work in concert with our allies. Let's take the example of Darfur just for a moment. Right now there's a peacekeeping force that has been set up and we have African Union troops in Darfur to stop a genocide that has killed hundreds of thousands of people. We could be providing logistical support, setting up a no-fly zone at relatively little cost to us, but we can only do it if we can help mobilize the international community and lead. And that's what I intend to do when I'm president. BROKAW: Senator McCain, the McCain Doctrine, if you will. MCCAIN: Well, let me just follow up, my friends. If we had done what Senator Obama wanted done in Iraq, and that was set a date for withdrawal, which General Petraeus, our chief -- chairman of our Joint Chiefs of Staff said would be a very dangerous course to take for America, then we would have had a wider war, we would have been back, Iranian influence would have increased, al Qaeda would have re- established a base. There was a lot at stake there, my friends. And I can tell you right now that Senator Obama would have brought our troops home in defeat. I'll bring them home with victory and with honor and that is a fundamental difference. The United States of America, Tom, is the greatest force for good, as I said. And we must do whatever we can to prevent genocide, whatever we can to prevent these terrible calamities that we have said never again. But it also has to be tempered with our ability to beneficially affect the situation. That requires a cool hand at the tiller. This requires a person who understands what our -- the limits of our capability are. We went in to Somalia as a peacemaking organization, we ended up trying to be -- excuse me, as a peacekeeping organization, we ended up trying to be peacemakers and we ended up having to withdraw in humiliation. In Lebanon, I stood up to President Reagan, my hero, and said, if we send Marines in there, how can we possibly beneficially affect this situation? And said we shouldn't. Unfortunately, almost 300 brave young Marines were killed. So you have to temper your decisions with the ability to beneficially affect the situation and realize you're sending America's most precious asset, American blood, into harm's way. And, again, I know those situations. I've been in them all my life. And I can tell you right now the security of your young men and women who are serving in the military are my first priority right after our nation's security. And I may have to make those tough decisions. But I won't take them lightly. And I understand that we have to say never again to a Holocaust and never again to Rwanda. But we had also better be darn sure we don't leave and make the situation worse, thereby exacerbating our reputation and our ability to address crises in other parts of the world. BROKAW: Senator McCain, thank you very much. Next question for Senator Obama, it comes from the F section and is from Katie Hamm. Katie? QUESTION: Should the United States respect Pakistani sovereignty and not pursue al Qaeda terrorists who maintain bases there, or should we ignore their borders and pursue our enemies like we did in Cambodia during the Vietnam War? OBAMA: Katie, it's a terrific question and we have a difficult situation in Pakistan. I believe that part of the reason we have a difficult situation is because we made a bad judgment going into Iraq in the first place when we hadn't finished the job of hunting down bin Laden and crushing al Qaeda. So what happened was we got distracted, we diverted resources, and ultimately bin Laden escaped, set up base camps in the mountains of Pakistan in the northwest provinces there. They are now raiding our troops in Afghanistan, destabilizing the situation. They're stronger now than at any time since 2001. And that's why I think it's so important for us to reverse course, because that's the central front on terrorism. They are plotting to kill Americans right now. As Secretary Gates, the defense secretary, said, the war against terrorism began in that region and that's where it will end. So part of the reason I think it's so important for us to end the war in Iraq is to be able to get more troops into Afghanistan, put more pressure on the Afghan government to do what it needs to do, eliminate some of the drug trafficking that's funding terrorism. But I do believe that we have to change our policies with Pakistan. We can't coddle, as we did, a dictator, give him billions of dollars and then he's making peace treaties with the Taliban and militants. OBAMA: What I've said is we're going to encourage democracy in Pakistan, expand our nonmilitary aid to Pakistan so that they have more of a stake in working with us, but insisting that they go after these militants. And if we have Osama bin Laden in our sights and the Pakistani government is unable or unwilling to take them out, then I think that we have to act and we will take them out. We will kill bin Laden; we will crush Al Qaida. That has to be our biggest national security priority. BROKAW: Senator McCain? MCCAIN: Well, Katie, thank you. You know, my hero is a guy named Teddy Roosevelt. Teddy Roosevelt used to say walk softly -- talk softly, but carry a big stick. Senator Obama likes to talk loudly. In fact, he said he wants to announce that he's going to attack Pakistan. Remarkable. You know, if you are a country and you're trying to gain the support of another country, then you want to do everything you can that they would act in a cooperative fashion. When you announce that you're going to launch an attack into another country, it's pretty obvious that you have the effect that it had in Pakistan: It turns public opinion against us. Now, let me just go back with you very briefly. We drove the Russians out with -- the Afghan freedom fighters drove the Russians out of Afghanistan, and then we made a most serious mistake. We washed our hands of Afghanistan. The Taliban came back in, Al Qaida, we then had the situation that required us to conduct the Afghan war. Now, our relations with Pakistan are critical, because the border areas are being used as safe havens by the Taliban and Al Qaida and other extremist organizations, and we have to get their support. Now, General Petraeus had a strategy, the same strategy -- very, very different, because of the conditions and the situation -- but the same fundamental strategy that succeeded in Iraq. And that is to get the support of the people. We need to help the Pakistani government go into Waziristan, where I visited, a very rough country, and -- and get the support of the people, and get them to work with us and turn against the cruel Taliban and others. And by working and coordinating our efforts together, not threatening to attack them, but working with them, and where necessary use force, but talk softly, but carry a big stick. OBAMA: Tom, just a... BROKAW: Senator McCain... OBAMA: ... just a quick follow-up on this. I think... MCCAIN: If we're going to have follow-ups, then I will want follow-ups, as well. BROKAW: No, I know. So but I think we get at it... MCCAIN: It'd be fine with me. It'd be fine with me. BROKAW: ... if I can, with this question. OBAMA: Then let's have one. BROKAW: All right, let's have a follow-up. MCCAIN: It'd be fine with me. OBAMA: Just -- just -- just a quick follow-up, because I think -- I think this is important. BROKAW: I'm just the hired help here, so, I mean... (LAUGHTER) OBAMA: You're doing a great job, Tom. Look, I -- I want to be very clear about what I said. Nobody called for the invasion of Pakistan. Senator McCain continues to repeat this. What I said was the same thing that the audience here today heard me say, which is, if Pakistan is unable or unwilling to hunt down bin Laden and take him out, then we should. Now, that I think has to be our policy, because they are threatening to kill more Americans. Now, Senator McCain suggests that somehow, you know, I'm green behind the ears and, you know, I'm just spouting off, and he's somber and responsible. MCCAIN: Thank you very much. OBAMA: Senator McCain, this is the guy who sang, "Bomb, bomb, bomb Iran," who called for the annihilation of North Korea. That I don't think is an example of "speaking softly." This is the person who, after we had -- we hadn't even finished Afghanistan, where he said, "Next up, Baghdad." So I agree that we have to speak responsibly and we have to act responsibly. And the reason Pakistan -- the popular opinion of America had diminished in Pakistan was because we were supporting a dictator, Musharraf, had given him $10 billion over seven years, and he had suspended civil liberties. We were not promoting democracy. This is the kind of policies that ultimately end up undermining our ability to fight the war on terrorism, and it will change when I'm president. MCCAIN: And, Tom, if -- if we're going to go back and forth, I then -- I'd like to have equal time to go -- to respond to... BROKAW: Yes, you get the... MCCAIN: ... to -- to -- to... BROKAW: ... last word here, and then we have to move on. MCCAIN: Not true. Not true. I have, obviously, supported those efforts that the United States had to go in militarily and I have opposed that I didn't think so. I understand what it's like to send young American's in harm's way. I say -- I was joking with a veteran -- I hate to even go into this. I was joking with an old veteran friend, who joked with me, about Iran. But the point is that I know how to handle these crises. And Senator Obama, by saying that he would attack Pakistan, look at the context of his words. I'll get Osama bin Laden, my friends. I'll get him. I know how to get him. I'll get him no matter what and I know how to do it. But I'm not going to telegraph my punches, which is what Senator Obama did. And I'm going to act responsibly, as I have acted responsibly throughout my military career and throughout my career in the United States Senate. And we have fundamental disagreements about the use of military power and how you do it, and you just saw it in response to previous questions. BROKAW: Can I get a quick response from the two of you about developments in Afghanistan this week? The senior British military commander, who is now leading there for a second tour, and their senior diplomatic presence there, Sherard Cowper-Coles, who is well known as an expert in the area, both have said that we're failing in Afghanistan. The commander said we cannot win there. We've got to get it down to a low level insurgency, let the Afghans take it over. Cowper-Coles said what we need is an acceptable dictator. If either of you becomes president, as one of you will, how do you reorganize Afghanistan's strategy or do you? Briefly, if you can. OBAMA: I'll be very brief. We are going to have to make the Iraqi government start taking more responsibility, withdraw our troops in a responsible way over time, because we're going to have to put some additional troops in Afghanistan. General McKiernan, the commander in Afghanistan right now, is desperate for more help, because our bases and outposts are now targets for more aggressive Afghan -- Taliban offenses. We're also going to have to work with the Karzai government, and when I met with President Karzai, I was very clear that, "You are going to have to do better by your people in order for us to gain the popular support that's necessary." I don't think he has to be a dictator. And we want a democracy in Afghanistan. But we have to have a government that is responsive to the Afghan people, and, frankly, it's just not responsive right now. BROKAW: Senator McCain, briefly. MCCAIN: General Petraeus has just taken over a position of responsibility, where he has the command and will really set the tone for the strategy and tactics that are used. And I've had conversations with him. It is the same overall strategy. Of course, we have to do some things tactically, some of which Senator Obama is correct on. We have to double the size of the Afghan army. We have to have a streamlined NATO command structure. We have to do a lot of things. We have to work much more closely with the Pakistanis. But most importantly, we have to have the same strategy, which Senator Obama said wouldn't work, couldn't work, still fails to admit that he was wrong about Iraq. He still will not admit that he was wrong about the strategy of the surge in Iraq, and that's the same kind of strategy of go out and secure and hold and allow people to live normal lives. And once they feel secure, then they lead normal, social, economic, political lives, the same thing that's happening in Iraq today. So I have confidence that General Petraeus, working with the Pakistanis, working with the Afghans, doing the same job that he did in Iraq, will again. We will succeed and we will bring our troops home with honor and victory and not in defeat. BROKAW: Senator McCain, this question is for you from the Internet. It's from Alden in Hewitt, Texas. How can we apply pressure to Russia for humanitarian issues in an effective manner without starting another Cold War? MCCAIN: First of all, as I say, I don't think that -- we're not going to have another Cold War with Russia. But have no doubt that Russia's behavior is certainly outside the norms of behavior that we would expect for nations which are very wealthy, as Russia has become, because of their petro dollars. Now, long ago, I warned about Vladimir Putin. I said I looked into his eyes and saw three letters, a K, a G and a B. He has surrounded himself with former KGB apparatchiks. He has gradually repressed most of the liberties that we would expect for nations to observe, and he has exhibited most aggressive behavior, obviously, in Georgia. I said before, watch Ukraine. Ukraine, right now, is in the sights of Vladimir Putin, those that want to reassemble the old Soviet Union. We've got to show moral support for Georgia. MCCAIN: We've got to show moral support for Ukraine. We've got to advocate for their membership in NATO. We have to make the Russians understand that there are penalties for these this kind of behavior, this kind of naked aggression into Georgia, a tiny country and a tiny democracy. And so, of course we want to bring international pressures to bear on Russia in hopes that that will modify and eventually change their behavior. Now, the G-8 is one of those, but there are many others. But the Russians must understand that these kinds of actions and activities are not acceptable and hopefully we will use the leverage, economic, diplomatic and others united with our allies, with our allies and friends in Europe who are equally disturbed as we are about their recent behaviors. BROKAW: Senator Obama. MCCAIN: It will not be a re-ignition of the Cold War, but Russia is a challenge. BROKAW: Senator Obama? We're winding down, so if we can keep track of the time. OBAMA: Well, the resurgence of Russia is one of the central issues that we're going to have to deal with in the next presidency. And for the most part I agree with Senator McCain on many of the steps that have to be taken. But we can't just provide moral support. We've got to provide moral support to the Poles and Estonia and Latvia and all of the nations that were former Soviet satellites. But we've also got to provide them with financial and concrete assistance to help rebuild their economies. Georgia in particular is now on the brink of enormous economic challenges. And some say that that's what Putin intended in the first place. The other thing we have to do, though, is we've got to see around the corners. We've got to anticipate some of these problems ahead of time. You know, back in April, I put out a statement saying that the situation in Georgia was unsustainable because you had Russian peacekeepers in these territories that were under dispute. And you knew that if the Russians themselves were trying to obtain some of these territories or push back against Georgia, that that was not a stable situation. So part of the job of the next commander-in-chief, in keeping all of you safe, is making sure that we can see some of the 21st Century challenges and anticipate them before they happen. We haven't been doing enough of that. We tend to be reactive. That's what we've been doing over the last eight years and that has actually made us more safe. That's part of what happened in Afghanistan, where we rushed into Iraq and Senator McCain and President Bush suggested that it wasn't that important to catch bin Laden right now and that we could muddle through, and that has cost us dearly. We've got to be much more strategic if we're going to be able to deal with all of the challenges that we face out there. And one last point I want to make about Russia. Energy is going to be key in dealing with Russia. If we can reduce our energy consumption, that reduces the amount of petro dollars that they have to make mischief around the world. That will strengthen us and weaken them when it comes to issues like Georgia. BROKAW: This requires only a yes or a no. Ronald Reagan famously said that the Soviet Union was the evil empire. Do you think that Russia under Vladimir Putin is an evil empire? OBAMA: I think they've engaged in an evil behavior and I think that it is important that we understand they're not the old Soviet Union but they still have nationalist impulses that I think are very dangerous. BROKAW: Senator McCain? MCCAIN: Maybe. (LAUGHTER) BROKAW: Maybe. MCCAIN: Depends on how we respond to Russia and it depends on a lot of things. If I say yes, then that means that we're reigniting the old Cold War. If I say no, it ignores their behavior. Obviously energy is going to be a big, big factor. And Georgia and Ukraine are both major gateways of energy into Europe. And that's one of the reasons why it's in our interest. But the Russians, I think we can deal with them but they've got to understand that they're facing a very firm and determined United States of America that will defend our interests and that of other countries in the world. BROKAW: All right. We're going to try to get in two more questions, if we can. So we have to move along. Over in section A, Terry Chary -- do I have that right, Terry? QUESTION: Senator, as a retired Navy chief, my thoughts are often with those who serve our country. I know both candidates, both of you, expressed support for Israel. QUESTION: If, despite your best diplomatic efforts, Iran attacks Israel, would you be willing to commit U.S. troops in support and defense of Israel? Or would you wait on approval from the U.N. Security Council? MCCAIN: Well, thank you, Terry. And thank you for your service to the country. I want to say, everything I ever learned about leadership I learned from a chief petty officer. And I thank you, and I thank you, my friend. Thanks for serving. Let -- let -- let me say that we obviously would not wait for the United Nations Security Council. I think the realities are that both Russia and China would probably pose significant obstacles. And our challenge right now is the Iranians continue on the path to acquiring nuclear weapons, and it's a great threat. It's not just a threat -- threat to the state of Israel. It's a threat to the stability of the entire Middle East. If Iran acquires nuclear weapons, all the other countries will acquire them, too. The tensions will be ratcheted up. What would you do if you were the Israelis and the president of a country says that they are -- they are determined to wipe you off the map, calls your country a stinking corpse? Now, Senator Obama without precondition wants to sit down and negotiate with them, without preconditions. That's what he stated, again, a matter of record. I want to make sure that the Iranians are put enough -- that we put enough pressure on the Iranians by joining with our allies, imposing significant, tough sanctions to modify their behavior. And I think we can do that. I think, joining with our allies and friends in a league of democracies, that we can effectively abridge their behavior, and hopefully they would abandon this quest that they are on for nuclear weapons. But, at the end of the day, my friend, I have to tell you again, and you know what it's like to serve, and you know what it's like to sacrifice, but we can never allow a second Holocaust to take place. BROKAW: Senator Obama? OBAMA: Well, Terry, first of all, we honor your service, and we're grateful for it. We cannot allow Iran to get a nuclear weapon. It would be a game-changer in the region. Not only would it threaten Israel, our strongest ally in the region and one of our strongest allies in the world, but it would also create a possibility of nuclear weapons falling into the hands of terrorists. And so it's unacceptable. And I will do everything that's required to prevent it. And we will never take military options off the table. And it is important that we don't provide veto power to the United Nations or anyone else in acting in our interests. It is important, though, for us to use all the tools at our disposal to prevent the scenario where we've got to make those kinds of choices. And that's why I have consistently said that, if we can work more effectively with other countries diplomatically to tighten sanctions on Iran, if we can reduce our energy consumption through alternative energy, so that Iran has less money, if we can impose the kinds of sanctions that, say, for example, Iran right now imports gasoline, even though it's an oil-producer, because its oil infrastructure has broken down, if we can prevent them from importing the gasoline that they need and the refined petroleum products, that starts changing their cost-benefit analysis. That starts putting the squeeze on them. Now, it is true, though, that I believe that we should have direct talks -- not just with our friends, but also with our enemies -- to deliver a tough, direct message to Iran that, if you don't change your behavior, then there will be dire consequences. If you do change your behavior, then it is possible for you to re-join the community of nations. Now, it may not work. But one of the things we've learned is, is that when we take that approach, whether it's in North Korea or in Iran, then we have a better chance at better outcomes. When President Bush decided we're not going to talk to Iran, we're not going to talk to North Korea, you know what happened? Iran went from zero centrifuges to develop nuclear weapons to 4,000. North Korea quadrupled its nuclear capability. We've got to try to have talks, understanding that we're not taking military options off the table. BROKAW: All right, gentlemen, we've come to the last question. And you'll both be interested to know this comes from the Internet and it's from a state that you're strongly contesting, both of you. It's from Peggy in Amherst, New Hampshire. And it has a certain Zen-like quality, I'll give you a fair warning. She says, "What don't you know and how will you learn it?" (LAUGHTER) Senator Obama, you get first crack at that. OBAMA: My wife, Michelle, is there and she could give you a much longer list than I do. And most of the time, I learn it by asking her. But, look, the nature of the challenges that we're going to face are immense and one of the things that we know about the presidency is that it's never the challenges that you expect. It's the challenges that you don't that end up consuming most of your time. But here's what I do know. I know that I wouldn't be standing here if it weren't for the fact that this country gave me opportunity. I came from very modest means. I had a single mom and my grandparents raised me and it was because of the help of scholarships and my grandmother scrimping on things that she might have wanted to purchase and my mom, at one point, getting food stamps in order for us to put food on the table. Despite all that, I was able to go to the best schools on earth and I was able to succeed in a way that I could not have succeeded anywhere else in this country. The same is true for Michelle and I'm sure the same is true for a lot of you. And the question in this election is: are we going to pass on that same American dream to the next generation? Over the last eight years, we've seen that dream diminish. Wages and incomes have gone down. People have lost their health care or are going bankrupt because they get sick. We've got young people who have got the grades and the will and the drive to go to college, but they just don't have the money. And we can't expect that if we do the same things that we've been doing over the last eight years, that somehow we are going to have a different outcome. We need fundamental change. That's what's at stake in this election. That's the reason I decided to run for president, and I'm hopeful that all of you are prepared to continue this extraordinary journey that we call America. But we're going to have to have the courage and the sacrifice, the nerve to move in a new direction. Thank you. BROKAW: Senator McCain, you get the last word. Senator Obama had the opening. You're last up. MCCAIN: Well, thank you, Tom. And I think what I don't know is what all of us don't know, and that's what's going to happen both here at home and abroad. The challenges that we face are unprecedented. Americans are hurting tonight in a way they have not in our generation. There are challenges around the world that are new and different and there will be different -- we will be talking about countries sometime in the future that we hardly know where they are on the map, some Americans. So what I don't know is what the unexpected will be. But I have spent my whole life serving this country. I grew up in a family where my father was gone most of the time because he was at sea and doing our country's business. My mother basically raised our family. I know what it's like in dark times. I know what it's like to have to fight to keep one's hope going through difficult times. I know what it's like to rely on others for support and courage and love in tough times. I know what it's like to have your comrades reach out to you and your neighbors and your fellow citizens and pick you up and put you back in the fight. That's what America's all about. I believe in this country. I believe in its future. I believe in its greatness. It's been my great honor to serve it for many, many years. And I'm asking the American people to give me another opportunity and I'll rest on my record, but I'll also tell you, when times are tough, we need a steady hand at the tiller and the great honor of my life was to always put my country first. Thank you, Tom. BROKAW: Thank you very much, Senator McCain. That concludes tonight's debate from here in Nashville. We want to thank our hosts here at Belmont University in Nashville and the Commission on Presidential Debates. And you're in my way of my script there, if you will move. (APPLAUSE) In addition to everything else, there is one more presidential debate on Wednesday, October 15, at Hofstra University in New York, moderated by my friend, Bob Schieffer of "CBS News." Thank you, Senator McCain. Thank you, Senator Obama. Good night, everyone, from Nashville.
