# Presidential Campaign Debate in San Francisco

**Date:** October 6, 1976
**Source:** https://www.presidency.ucsb.edu/documents/presidential-campaign-debate

---

THE MODERATOR. Good evening. I am Pauline Frederick of NPR [National Public Radio], moderator of the second of the historic debates of the 1976 campaign between Gerald R. Ford of Michigan, Republican candidate for President, and Jimmy Carter of Georgia, Democratic candidate for President. Thank you, President Ford, and thank you, Governor Carter, for being with us tonight. The debate takes place before an audience in the Palace of Fine Arts Theatre in San Francisco. An estimated 100 million Americans are watching on television as well. San Francisco was the site of the signing of the United Nations Charter 31 years ago. Thus, it is an appropriate place to hold this debate, the subject of which is foreign and defense issues. The questioners tonight are Max Frankel, associate editor of the New York Times, Henry L. Trewhitt, diplomatic correspondent of the Baltimore Sun, and Richard Valeriani, diplomatic correspondent of NBC News. The ground rules tonight are basically the same as they were for the first debate 2 weeks ago. The questions will be alternated between candidates. By the toss of a coin, Governor Carter will take the first question. Each question sequence will be as follows: The question will be asked, and the candidate will have up to 3 minutes to answer. His opponent will have up to 2 minutes to respond. And prior to the response, the questioner may ask a follow-up question to clarify the candidate's answer, when necessary, with up to 2 minutes to reply. Each candidate will have 3 minutes for a closing statement at the end. President Ford and Governor Carter do not have notes or prepared remarks with them this evening, but they may take notes during the debate and refer to them. Mr. Frankel, you have the first question for Governor Carter. MR. FRANKEL. Governor, since the Democrats last ran our foreign policy, including many of the men who are advising you, the country has been relieved of the Vietnam agony and the military draft; we've started arms control negotiations with the Russians; we've opened relations with China; we've arranged the disengagement in the Middle East; we've regained influence with the Arabs without deserting Israel. Now, maybe, we've even begun a process of peaceful change in Africa. Now, you've objected in this campaign to the style with which much of this was done, and you've mentioned some other things that you think ought to have been done. But do you really have a quarrel with this Republican record? Would you not have done any of those things? MR. CARTER. Well, I think this Republican administration has been almost all style and spectacular and not substance. We've got a chance tonight to talk about, first of all, leadership, the character of our country, and a vision of the future. In every one of these instances, the Ford administration has failed. And I hope tonight that I and Mr. Ford will have a chance to discuss the reason for those failures. Our country is not strong any more; we're not respected any more. We can only be strong overseas if we're strong at home, and when I become President, we'll not only be strong in those areas but also in defense--a defense capability second to none. We've lost, in our foreign policy, the character of the American people. We've ignored or excluded the American people and the Congress from participation in the shaping of our foreign policy. It's been one of secrecy and exclusion. In addition to that, we've had a chance to become now, contrary to our long-standing beliefs and principles, the arms merchant of the whole world. We've tried to buy success from our enemies, and at the same time we've excluded from the process the normal friendship of our allies. In addition to that, we've become fearful to compete with the Soviet Union on an equal basis. We talk about detente. The Soviet Union knows what they want in detente, and they've been getting it. We have not known what we've wanted, and we've been out-traded in almost every instance. The other point I want to make is about our defense. We've got to be a nation blessed with the defense capability that's efficient, tough, capable, well organized, narrowly focused fighting capability. The ability to fight if necessary is the best way to avoid the chance for or the requirement to fight. And the last point I want to make is this: Mr. Ford, Mr. Kissinger have continued on with the policies and failures of Richard Nixon. Even the Republican platform has criticized the lack of leadership in Mr. Ford, and they've criticized the foreign policy of this administration. This is one instance where I agree with the Republican platform. I might say this in closing, and that is, that as far as foreign policy goes, Mr. Kissinger has been the President of this country. Mr. Ford has shown an absence of leadership and an absence of a grasp of what this country is and what it ought to be. That's got to be changed, and that is one of the major issues in this campaign of 1976. THE MODERATOR. President Ford, would you like to respond? THE PRESIDENT. Governor Carter again is talking in broad generalities. Let me take just one question that he raises--the military strength and capability of the United States. Governor Carter, in November of 1975, indicated that he wanted to cut the defense budget by $15 billion. A few months later he said he wanted to cut the defense budget by $8 billion or $9 billion. And more recently he talks about cutting the defense budget by $5 billion to $7 billion. There is no way you can be strong militarily and have those kinds of reductions in our military appropriations. Now let me just tell you a little story. About late October of 1975, I asked the then Secretary of Defense, Mr. Schlesinger, to tell me what had to be done if we were going to reduce the defense budget by $3 to $5 billion. A few days later Mr. Schlesinger came back and said if we cut the defense budget by $3 to $5 billion, we will have to cut military personnel by 250,000, civilian personnel by 100,000, jobs in America by 100,000. We would have to stretch out our aircraft procurement. We would have to reduce our naval construction program. We would have to reduce the research and development for the Army, the Navy, the Air Force, and Marines by 8 percent. We would have to close 20 military bases in the United States immediately. That's the kind of a defense program that Mr. Carter wants. Let me tell you this straight from the shoulder: You don't negotiate with Mr. Brezhnev from weakness. And the kind of a defense program that Mr. Carter wants will mean a weaker defense and a poorer negotiating position. THE MODERATOR. Mr. Trewhitt, a question for President Ford. MR. TREWHITT. Mr. President, my question really is the other side of the coin from Mr. Frankel's. For a generation the United States has had a foreign policy based on containment of communism; yet we have lost the first war in Vietnam, we lost a shoving match in Angola, Communists threaten to come to power by peaceful means in Italy, and relations generally have cooled with the Soviet Union in the last few months. So, let me ask you, first, what do you do about such cases as Italy, and, secondly, does this general drift mean that we're moving back toward something like an old cold war relationship with the Soviet Union? THE PRESIDENT. I don't believe we should move to a cold war relationship. I think it's in the best interest of the United States and the world as a whole that the United States negotiate rather than go back to the cold war relationship with the Soviet Union. I don't look at the picture as bleakly as you have indicated in your question, Mr. Trewhitt. I believe that the United States has had many successes in recent years and recent months as far as the Communist movement is concerned. We have been successful in Portugal where, a year ago, it looked like there was a very great possibility that the Communists would take over in Portugal. It didn't happen. We have a democracy in Portugal today. A few months ago--or I should say maybe 2 years ago--the Soviet Union looked like they had continued strength in the Middle East. Today, according to Prime Minister Rabin, the Soviet Union is weaker in the Middle East than they have been in many, many years. The facts are the Soviet Union relationship with Egypt is at a low level; the Soviet Union relationship with Syria is at a very low point. The United States today, according to Prime Minister Rabin of Israel, is at a peak in its influence and power in the Middle East. But let's turn for a minute to the southern African operations that are now going on. The United States of America took the initiative in southern Africa. We wanted to end the bloodshed in southern Africa. We wanted to have the right of self-determination in southern Africa. We wanted to have majority rule with the full protection of the rights of the minority. We wanted to preserve human dignity in southern Africa. We have taken initiative, and in southern Africa today the United States is trusted by the black frontline nations and black Africa. The United States is trusted by the other elements in southern Africa. The United States foreign policy under this administration has been one of progress and success. And I believe that instead of talking about Soviet progress, we can talk about American successes. And may I make an observation--part of the question you asked, Mr. Trewhitt--I don't believe that it's in the best interests of the United States and the NATO nations to have a Communist government in NATO. Mr. Carter has indicated he would look with sympathy to a Communist government in NATO. I think that would destroy the integrity and the strength of NATO, and I am totally opposed to it. MR. CARTER. Well, Mr. Ford, unfortunately, has just made a statement that's not true. I have never advocated a Communist government for Italy; that would, obviously, be a ridiculous thing for anyone to do who wanted to be President of the country. I think that this is an instance for deliberate distortion, and this has occurred also in the question about defense. As a matter of fact, I've never advocated any cut of $15 billion in our defense budget. As a matter of fact, Mr. Ford has made a political football out of the defense budget. About a year ago, he cut the Pentagon budget $6.8 billion. After he fired James Schlesinger the political heat got so great that he added back about $3 billion. When Ronald Reagan won the Texas primary election, Mr. Ford added back another $1 1/2 billion. Immediately before the Kansas City convention he added back another $1.8 billion in the defense budget. And his own Office of Management and Budget testified that he had a $3 billion cut insurance added to the defense budget under the pressure from the Pentagon. Obviously, this is another indication of trying to use the defense budget for political purposes, which he's trying to do tonight. Now, we went into South Africa late, after Great Britain, Rhodesia, the black nations had been trying to solve this problem for many, many years. We didn't go in until right before the election, similar to what was taking place in 1972, when Mr. Kissinger announced peace is at hand just before the election at that time. And we have weakened our position in NATO, because the other countries in Europe supported the democratic forces in Portugal long before we did. We stuck to the Portugal dictatorships much longer than other democracies did in this world. THE MODERATOR. Mr. Valeriani, a question for Governor Carter. MR. VALERIANI. Governor Carter, much of what the United States does abroad is done in the name of the national interest. What is your concept of the national interest? What should the role of the United States in the world be? And in that connection, considering your limited experience in foreign affairs and the fact that you take some pride in being a Washington outsider, don't you think it would be appropriate for you to tell the American voters, before the election, the people that you would like to have in key positions such as Secretary of State, Secretary of Defense, national security affairs adviser at the White House? MR. CARTER. Well, I'm not going to name my Cabinet before I get elected; I've got a little ways to go before I start doing that. But I have an adequate background, I believe. I am a graduate of the U.S. Naval Academy, the first military graduate since Eisenhower. I've served as Governor of Georgia and have traveled extensively in foreign countries--in South America, Central America, Europe, the Middle East, and in Japan. I've traveled the last 21 months among the people of this country. I've talked to them, and I've listened. And I've seen at firsthand, in a very vivid way, the deep hurt that's come to this country in the aftermath of Vietnam and Cambodia and Chile and Pakistan and Angola and Watergate, CIA revelations. What we were formerly so proud of--the strength of our country, its moral integrity, the representation in foreign affairs of what our people are, what our Constitution stands for--has been gone. And in the secrecy that has surrounded our foreign policy in the last few years, the American people and the Congress have been excluded. I believe I know what this country ought to be. I've been one who's loved my Nation, as many Americans do. And I believe that there is no limit placed on what we can be in the future if we can harness the tremendous resources-militarily, economically--and the stature of our people, the meaning of our Constitution in the future. Every time we've made a serious mistake in foreign affairs, it's been because the American people have been excluded from the process. If we can just tap the intelligence and ability, the sound commonsense, and the good judgment of the American people, we can once again have a foreign policy to make us proud instead of ashamed. And I'm not going to exclude the American people from that process in the future, as Mr. Ford and Kissinger have done. This is what it takes to have a sound foreign policy: strong at home, strong defense, permanent commitments, not betray the principles of our country, and involve the American people and the Congress in the shaping of our foreign policy. Every time Mr. Ford speaks from a position of secrecy--in negotiations and secret treaties that have been pursued and achieved, in supporting dictatorships, in ignoring human rights--we are weak and the rest of the world knows it. So these are the ways that we can restore the strength of our country. And they don't require long experience in foreign policy--nobody has that except a President who served a long time or a Secretary of State. But my background, my experience, my knowledge of the people of this country, my commitment to our principles that don't change--those are the best bases to correct the horrible mistakes of this administration and restore our own country to a position of leadership in the world. MR. VALERIANI. How, specifically, Governor, are you going to bring the American people into the decisionmaking process in foreign policy? What does that mean? MR. CARTER. First of all, I would quit conducting the decisionmaking process in secret, as has been a characteristic of Mr. Kissinger and Mr. Ford. In many instances we've made agreements, like in Vietnam, that have been revealed later on to our embarrassment. Recently, Ian Smith, the President of Rhodesia, announced that he had unequivocal commitments from Mr. Kissinger that he could not reveal. The American people don't know what those commitments are. We've seen in the past a destruction of elected governments, like in Chile, and the strong support of military dictatorship there. These kinds of things have hurt us very much. I would restore the concept of the fireside chat, which was an integral part of the administration of Franklin Roosevelt. And I would also restore the involvement of the Congress. When Harry Truman was President, he was not afraid to have a strong Secretary of Defense--Dean Acheson, George Marshall were strong Secretaries of State--excuse me, State. But he also made sure that there was a bipartisan support. The Members of Congress, Arthur Vandenburg, Walter George, were part of the process. And before our Nation made a secret agreement and before we made a bluffing statement, we were sure that we had the backing not only of the President and the Secretary of State but also of the Congress and the people. This is a responsibility of the President, and I think it's very damaging to our country for Mr. Ford to have turned over this responsibility to the Secretary of State. THE MODERATOR. President Ford, do you have a response? THE PRESIDENT. Governor Carter again contradicts himself. He complains about secrecy, and yet he is quoted as saying that in the attempt to find a solution in the Middle East, that he would hold unpublicized meetings with the Soviet Union--I presume for the purpose of imposing a settlement on Israel and the Arab nations. But let me talk just a minute about what we've done to avoid secrecy in the Ford administration. After the United States took the initiative in working with Israel and with Egypt and achieving the Sinai II agreement--and I am proud to say that not a single Egyptian or Israeli soldier has lost his life since the signing of the Sinai agreement--but at the time that I submitted the Sinai agreement to the Congress of the United States, I submitted every single document that was applicable to the Sinai II agreement. It was the most complete documentation by any President of any agreement signed by a President on behalf of the United States. Now, as far as meeting with the Congress is concerned, during the 24 months that I've been the President of the United States, I have averaged better than one meeting a month with responsible groups or committees of the Congress, both House and Senate. The Secretary of State has appeared, in the several years that he's been the Secretary, before 80 different committee hearings in the House and in the Senate. The Secretary of State has made better than 50 speeches all over the United States explaining American foreign policy. I have made, myself, at least 10 speeches in various parts of the country, where I have discussed with the American people defense and foreign policy. THE MODERATOR. Mr. Frankel, a question for President Ford. MR. FRANKEL. Mr. President, I'd like to explore a little more deeply our relationship with the Russians. They used to brag, back in Khrushchev's day, that because of their greater patience and because of our greed for business deals, that they would sooner or later get the better of us. Is it possible that, despite some setbacks in the Middle East, they've proved their point? Our allies in France and Italy are now flirting with communism; we've recognized a permanent Communist regime in East Germany; we virtually signed, in Helsinki, an agreement that the Russians have dominance in Eastern Europe; we bailed out Soviet agriculture with our huge grain sales, we've given them large loans, access to our best technology, and if the Senate hadn't interfered with the Jackson Amendment, maybe you would have given them even larger loans. Is that what you call a two-way street of traffic in Europe? THE PRESIDENT. I believe that we have negotiated with the Soviet Union since I've been President from a position of strength. And let me cite several examples. Shortly after I became President, in December of 1974, I met with General Secretary Brezhnev in Vladivostok. And we agreed to a mutual cap on the ballistic missile launchers at a ceiling of 2,400, which means that the Soviet Union, if that becomes a permanent agreement, will have to make a reduction in their launchers that they now have or plan to have. I negotiated at Vladivostok with Mr. Brezhnev a limitation on the MIRVing of their ballistic missiles at a figure of 1,320, which is the first time that any President has achieved a cap either on launchers or on MIRV's. It seems to me that we can go from there to the grain sales. The grain sales have been a benefit to American agriculture. We have achieved a 5 3/4-year sale of a minimum of 6 million metric tons, which means that they have already bought about 4 million metric tons this year and are bound to buy another 2 million metric tons, to take the grain and corn and wheat that the American farmers have produced in order to have full production. And these grain sales to the Soviet Union have helped us tremendously in meeting the cost of the additional oil and the oil that we have bought from overseas. If we turn to Helsinki--I am glad you raised it, Mr. Frankel--in the case of Helsinki, 35 nations signed an agreement, including the Secretary of State for the Vatican. I can't under any circumstances believe that His Holiness the Pope would agree, by signing that agreement, that the 35 nations have turned over to the Warsaw Pact nations the domination of Eastern Europe. It just isn't true. And if Mr. Carter alleges that His Holiness, by signing that, has done it, he is totally inaccurate. Now, what has been accomplished by the Helsinki agreement? Number one, we have an agreement where they notify us and we notify them of any military maneuvers that are to be undertaken. They have done it in both cases where they've done so. There is no Soviet domination of Eastern Europe, and there never will be under a Ford administration. MR. FRANKEL. I'm sorry, could I just follow--did I understand you to say, sir, that the Russians are not using Eastern Europe as their own sphere of influence and occupying most of the countries there and making sure with their troops that it's a Communist zone, whereas on our side of the line the Italians and the French are still flirting with the possibility of communism? THE PRESIDENT. I don't believe, Mr. Frankel, that the Yugoslavians consider themselves dominated by the Soviet Union. I don't believe that the Romanians consider themselves dominated by the Soviet Union. I don't believe that the Poles consider themselves dominated by the Soviet Union. Each of those countries is independent, autonomous; it has its own territorial integrity. And the United States does not concede that those countries are under the domination of the Soviet Union. As a matter of fact, I visited Poland, Yugoslavia, and Romania, to make certain that the people of those countries understood that the President of the United States and the people of the United States are dedicated to their independence, their autonomy, and their freedom. THE MODERATOR. Governor Carter, have you a response? MR. CARTER. Well, in the first place, I am not criticizing His Holiness the Pope. I was talking about Mr. Ford. The fact is that secrecy has surrounded the decisions made by the Ford administration. In the case of the Helsinki agreement, it may have been a good agreement at the beginning, but we have failed to enforce the so-called Basket 3 part, which ensures the right of people to migrate, to join their families, to be free to speak out. The Soviet Union is still jamming Radio Free Europe. Radio Free Europe is being jammed. We've also seen a very serious problem with the so-called Sonnenfeldt document which, apparently, Mr. Ford has just endorsed, which said that there is an organic linkage between the Eastern European countries and the Soviet Union. And I would like to see Mr. Ford convince the Polish Americans and the Czech Americans and the Hungarian Americans in this county that those countries don't live under the domination and supervision of the Soviet Union behind the Iron Curtain. We also have seen Mr. Ford exclude himself from access to the public. He hasn't had a tough, cross-examination-type press conference in over 30 days. One press conference he had without sound. He's also shown a weakness in yielding to pressure. The Soviet Union, for instance, put pressure on Mr. Ford, and he refused to see a symbol of human freedom recognized around the world--Alexander Solzhenitsyn. The Arabs have put pressure on Mr. Ford, and he's yielded, and he has permitted a boycott by the Arab countries of American businesses who trade with Israel, who have American Jews owning or taking part in the management of American companies. His own Secretary of Commerce had to be subpenaed by the Congress to reveal the names of businesses who were subject to this boycott. They didn't volunteer the information; he had to be subpenaed. And the last thing I'd like to say is this: This grain deal with the Soviet Union in '72 was terrible, and Mr. Ford made up for it with three embargoes--one against our own ally in Japan. That's not the way to run our foreign policy, including international trade. THE MODERATOR. Mr. Trewhitt, a question for Governor Carter. MR. TREWHITT. Governor, I'd like to pick up on that point, actually, and on your appeal for a greater measure of American idealism in foreign affairs. Foreign affairs come home to the American public pretty much in such issues as oil embargoes and grain sales, that sort of thing. Would you be willing to risk an oil embargo in order to promote human rights in Iran, Saudi Arabia--withhold arms from Saudi Arabia for the same purpose? As a matter of fact, I think you have perhaps answered this final part, but would you withhold grain from the Soviet Union in order to promote civil rights in the Soviet Union? MR. CARTER. I would never single out food as a trade embargo item. If I ever decided to impose an embargo because of a crisis in international relationships, it would include all shipments of all equipment. For instance, if the Arab countries ever again declare an embargo against our Nation on oil, I would consider that not a military but an economic declaration of war. And I would respond instantly and in kind. I would not ship that Arab country anything--no weapons, no spare parts for weapons, no oil-drilling rigs, no oil pipe, no nothing. I wouldn't single out just food. Another thing I'd like to say is this: In our international trade, as I said in my opening statement, we have become the arms merchant of the world. When this Republican administration came into office, we were shipping about $1 billion worth of arms overseas; now $10 to $12 billion worth of arms overseas to countries that quite often use these weapons to fight each other. The shift in emphasis has been very disturbing to me, speaking about the Middle East. Under the last Democratic administration 60 percent of all weapons that went into the Middle East were for Israel. Nowadays--75 percent were for Israel before--now 60 percent go to the Arab countries, and this does not include Iran. If you include Iran, our present shipment of weapons to the Middle East--only 20 percent goes to Israel. This is a deviation from idealism; it's a deviation from a commitment to our major ally in the Middle East, which is Israel; it's a yielding to economic pressure on the part of the Arabs on the oil issue; and it's also a tremendous indication that under the Ford administration, we have not addressed the energy policy adequately. We still have no comprehensive energy policy in this country, and it's an overall sign of weakness. When we are weak at home economically--high unemployment, high inflation, a confused Government, a wasteful Defense Establishment-this encourages the kind of pressure that's been put on us successfully. It would have been inconceivable 10, 15 years ago for us to be brought to our knees with an Arab oil embargo. But it was done 3 years ago and they're still putting pressure on us from the Arab countries to our discredit around the world. These are the weaknesses that I see, and I believe it's not just a matter of idealism. It's a matter of being tough. It's a matter of being strong. It's a matter of being consistent. Our priorities ought to be, first of all, to meet our own military needs; secondly, to meet the needs of our allies and friends, and only then should we ship military equipment to foreign countries. As a matter of fact, Iran is going to get 80 F-14's before we even meet our own Air Force orders for F-14's, and the shipment of Spruance Class Destroyers to Iran are much more highly sophisticated than the Spruance Class Destroyers that are presently being delivered to our own Navy. This is ridiculous, and it ought to be changed. MR. TREWHITT. Governor, let me pursue that, if I may. If I understand you correctly, you would, in fact, to use my examples, withhold arms from Iran and Saudi Arabia even if the risk was an oil embargo and if they should be securing those arms from somewhere else. And then, if the embargo came, then you would respond in kind. Do I have it correctly? MR. CARTER. If--Iran is not an Arab country, as you know, it's a Moslem country. But if Saudi Arabia should declare an oil embargo against us, then I would consider that an economic declaration of war. And I would make sure that the Saudis understood this ahead of time, so there would be no doubt in their mind. I think under those circumstances, they would refrain from pushing us to our knees as they did in 1973 with the previous oil embargo. THE MODERATOR. President Ford. THE PRESIDENT. Governor Carter apparently doesn't realize that since I've been President, we have sold to the Israelis over $4 billion in military hardware. We have made available to the Israelis over 45 percent of the total economic and military aid since the establishment of Israel 27 years ago. So, the Ford administration has done a good job in helping our good ally, Israel, and we're dedicated to the survival and security of Israel. I believe that Governor Carter doesn't realize the need and necessity for arms sales to Iran. He indicates he would not make those. Iran is bordered very extensively by the Soviet Union. Iran has Iraq as one of its neighbors. The Soviet Union and the Communist-dominated government of Iraq are neighbors of Iran, and Iran is an ally of the United States. It's my strong feeling that we ought to sell arms to Iran for its own national security and as an ally, a strong ally, of the United States. The history of our relationship with Iran goes back to the days of President Truman, when he decided that it was vitally necessary for our own security, as well as that of Iran, that we should help that country. And Iran has been a good ally. In 1973 when there was an oil embargo, Iran did not participate; Iran continued to sell oil to the United States. I believe that it's in our interest and in the interest of Israel and Iran and Saudi Arabia for the United States to sell arms to those countries. It's for their security as well as ours. THE MODERATOR. Mr. Valeriani, a question for President Ford. MR. VALERIANI. Mr. President, the policy of your administration is to normalize relations with mainland China. That means establishing, at some point, full diplomatic relations and, obviously, doing something about the mutual defense treaty with Taiwan. If you are elected, will you move to establish full diplomatic relations with Peking, and will you abrogate the mutual defense treaty with Taiwan? And, as a corollary, would you provide mainland China with military equipment if the Chinese were to ask for it? THE PRESIDENT. Our relationship with the People's Republic of China is based upon the Shanghai communiqué ¯f 1972. That communiqué £alls for the normalization of relations between the United States and the People's Republic. It doesn't set a time schedule; it doesn't make a determination as to how that relationship should be achieved in relationship to our current diplomatic recognition and obligations to the Taiwanese Government. The Shanghai communiqué ¤oes say that the differences between the People's Republic on the one hand and Taiwan on the other shall be settled by peaceful means. The net result is this administration--and during my time as the President for the next 4 years--we will continue to move for normalization of relations in the traditional sense. And we will insist that the disputes between Taiwan and the People's Republic be settled peacefully, as was agreed in the Shanghai communiqué ¯f 1972. The Ford administration will not let down, will not eliminate or forget our obligation to the people of Taiwan. We feel that there must be a continued obligation to the people, the some 19 or 20 million people in Taiwan, and as we move during the next 4 years, those will be the policies of this administration. MR. VALERIANI. Sir, the military equipment for the mainland Chinese? THE PRESIDENT. There is no policy of this Government to give to the People's Republic, or to sell to the People's Republic of China, military equipment. I do not believe that we, the United States, should sell, give, or otherwise transfer military hardware to the People's Republic of China or any other Communist nations, such as the Soviet Union and the like. THE MODERATOR. Governor Carter. MR. CARTER. I'd like to go back just one moment to the previous question, where Mr. Ford, I think, confused the issue by trying to say that we're shipping Israel 40 percent of our aid. As a matter of fact, during this current year, we are shipping Iran--or have contracted to ship to Iran--about $7? billion worth of arms and also to Saudi Arabia about $7? billion worth of arms. Also, in 1975 we almost brought Israel to their knees after the Yom Kippur war by the so-called reassessment of our relationship to Israel. We, in effect, tried to make Israel the scapegoat for the problems in the Middle East. And this weakened our relationship with Israel a great deal and put a cloud on the total commitment that our people feel toward the Israelis. There ought to be a clear, unequivocal commitment without change to Israel. In the Far East I think we need to continue to be strong, and I would certainly pursue the normalization of relationships with the People's Republic of China. We opened up a great opportunity in 1972--which has pretty well been frittered away under Mr. Ford--that ought to be a constant inclination toward friendship. But I would never let that friendship with the People's Republic of China stand in the way of the preservation of the independence and freedom of the people on Taiwan. THE MODERATOR. Mr. Frankel, a question for Governor Carter. MR. FRANKEL. Governor, we always seem, in our elections, and maybe in between, too, to argue about who can be tougher in the world. Give or take a few billion dollars, give or take one weapons systems, our leading politicians, and I think you two gentlemen, seem to settle roughly on the same strategy in the world at roughly the same Pentagon budget cost. How bad do things have to get in our own economy, or how much backwardness and hunger would it take in the world to persuade you that our national security and our survival required very drastic cutbacks in arms spending and dramatic new efforts in other directions? MR. CARTER. Well, always in the past we have had an ability to have a strong defense and also to have a strong domestic economy and also to be strong in our reputation and influence within the community of nations. These characteristics of our country have been endangered under Mr. Ford. We are no longer respected. In a showdown vote in the United Nations or in any other international council we are lucky to get 20 percent of the other nations to vote with us. Our allies feel that we've neglected them. The so-called Nixon shocks against Japan have weakened our relationships there. Under this administration we have also had an inclination to keep separate the European countries, thinking that if they are separate, then we can dominate them and proceed with our secret Lone Ranger-type diplomatic efforts. I would also like to point out that we in this country have let our economy go down the drain--the worst inflation since the Great Depression, the highest unemployment of any developed nation of the world. We have a higher unemployment rate in this country than Great Britain, than West Germany; our unemployment rate is twice as high as it is in Italy; it's three or four times as high as it is in Japan. And that terrible circumstance in this country is exported overseas. We comprise about 30 percent of the world's economic trade power influence. And when we are weak at home, weaker than all our allies, that weakness weakens the whole free world. So, strong economy is very important. Another thing that we need to do is to reestablish the good relationships that we ought to have between the United States and our natural allies and friends-they have felt neglected. And using that base of strength, and using the idealism, the honesty, the predictability, the commitment, the integrity of our own country--that's where our strength lies. And that would permit us to deal with the developing nations in a position of strength. Under this administration, we've bad a continuation of a so-called "balance of power politics" where everything is looked on as a struggle between us on the one side and the Soviet Union on the other. Our allies, the smaller countries, get trampled in the rush. What we need is to try to seek individualized, bilateral relationships with countries regardless of their size and to establish world order politics, which means we want to preserve peace through strength. We also want to revert back to the stature and the respect that our country had in previous administrations. Now, I can't say when this can come, but I can guarantee it will not come if Gerald Ford is reelected and this present policy is continued. It will come if I am elected. MR. FRANKEL. If I hear you right, sir, you are saying guns and butter both, but President Johnson also had trouble keeping up both Vietnam and his domestic programs. I was really asking, when do the needs of the cities and our own needs and those of other backward and even more needy countries and societies around the world take precedence over some of our military spending? Ever? MR. CARTER. Let me say very quickly that under President Johnson, in spite of the massive investment in the Vietnam war, he turned over a balanced budget to Mr. Nixon. The unemployment rate was less than 4 percent. The inflation rate under Kennedy and Johnson was about 2 percent--out-third what it is under this administration. So, we did have at that time, with good management, the ability to do both. I don't think anybody can say that Johnson and Kennedy neglected the poor and the destitute people in this country or around the world. But I can say this: The number one responsibility of any President, above all else, is to guarantee the security of our Nation, an ability to be free of the threat of attack or blackmail and to carry out our obligations to our allies and friends and to carry out a legitimate foreign policy. They must go hand in hand. But the security of this Nation has got to come first. THE MODERATOR. President Ford. THE PRESIDENT. Let me say very categorically, you cannot maintain the security and the strength of the United States with the kind of defense budget cuts that Governor Carter has indicated. In 1975 he wanted to cut the budget $15 billion. He is now down to a figure of $5 billion to $7 billion. Reductions of that kind will not permit the United States to be strong enough to deter aggression and maintain the peace. Governor Carter apparently does not know the facts. As soon as I became President, I initiated meetings with the NATO heads of state and met with them in Brussels to discuss how we could improve the defense relationship in Western Europe. In November of 1975, I met with the leaders of the five industrial nations in France for the purpose of seeing what we could do, acting together, to meet the problems of the coming recession. In Puerto Rico this year, I met with six of the leading industrial nations' heads of state to meet the problem of inflation so we would be able to solve it before it got out of hand. I have met with the heads of government, bilaterally as well as multilaterally. Our relations with Japan have never been better. I was the first United States President to visit Japan. And we had the Emperor of Japan here this past year. And the net result is Japan and the United States are working more closely together now than at any time in the history of our relationship. You can go around the world--and let me take Israel, for example. Just recently, President [Prime Minister] Rabin said that our relations were never better. THE MODERATOR. Mr. Trewhitt, a question for President Ford. MR. TREWHITT. Mr. President, you referred earlier to your meeting with Mr. Brezhnev at Vladivostok in 1974. You agreed on that occasion to try to achieve another strategic arms limitation--SALT--agreement within the year. Nothing happened in 1975 or not very much publicly, at least, and those talks are still dragging, and things got quieter as the current season approached. Is there a bit of politics involved there, perhaps on both sides? Or, perhaps more important, are interim weapons developments--and I am thinking of such things as the cruise missile and the Soviet SS-20 intermediate range rocket--making SALT irrelevant, bypassing the SALT negotiations? THE PRESIDENT. First, we have to understand that SALT I expires October 3, 1977. Mr. Brezhnev and I met in Vladivostok in December of 1974 for the purpose of trying to take the initial steps so we could have a SALT II agreement that would go to 1985. As I indicated earlier, we did agree on a 2,400 limitation on launchers of ballistic missiles. That would mean a cutback in the Soviet program. It would not interfere with our .own program. At the same time we put a limitation of 1,320 on MIRV's. Our technicians have been working since that time in Geneva trying to put into technical language an agreement that can be verified by both parties. In the meantime there has developed the problem of the Soviet Backfire, their high performance aircraft, which they say is not a long-range aircraft and which some of our people say is an intercontinental aircraft. In the interim there has been the development on our part primarily, the cruise missiles--cruise missiles that could be launched from land-based mobile installations; cruise missiles that could be launched from high performance aircraft like the B-52's or the B-l's, which I hope we proceed with; cruise missiles which could be launched from either surface or submarine naval vessels. Those gray area weapons systems are creating some problems in the agreement for a SALT II negotiation. But I can say that I am dedicated to proceeding. And I met just last week with the Foreign Minister of the Soviet Union, and he indicated to me that the Soviet Union was interested in narrowing the differences and making a realistic and a sound compromise. I hope and trust in the best interests of both countries and in the best interests of all peoples throughout this globe that the Soviet Union and the United States can make a mutually beneficial agreement because, if we do not and SALT I expires on October 3, 1977, you will unleash again an all-out nuclear arms race with the potential of a nuclear holocaust of unbelievable dimensions. So, it is the obligation of the President to do just that, and I intend to do so. MR. TREWHITT. Mr. President, let me follow that up. I'll submit that the cruise missile adds a whole new dimension to the arms competition, and then cite a statement by your office to the arms control association a few days ago in which you said that the cruise missile might eventually be included in a comprehensive arms limitation agreement, but that in the meantime it was an essential part of the American strategic arsenal. Now, may I assume from that that you are tending to exclude the cruise missile from the next SALT agreement, or is it still negotiable in that context? THE PRESIDENT. I believe that the cruise missiles which we are now developing in research and development across the spectrum--from air, from the sea, or from the land--can be included within a SALT II agreement. They are a new weapons system that has a great potential, both conventional and nuclear armed. At the same time we have to make certain that the Soviet Union's Backfire, which they claim is not an intercontinental aircraft and which some of our people contend is, must also be included if we are to get the kind of an agreement which is in the best interests of both countries. And I really believe that it's far better for us and for the Soviet Union and, more importantly, for the people around the world that these two super powers find an answer for a SALT II agreement before October 3, 1977. I think good will on both parts, hard bargaining by both parties, and a reasonable compromise will be in the best interests of all parties. THE MODERATOR. Governor Carter. MR. CARTER. Well, Mr. Ford acts like he is running for President for the first time. He has been in office 2 years, and there has been absolutely no progress made toward a new SALT agreement. He has learned the date of the expiration of SALT I, apparently. We have seen in this world a development of a tremendous threat to us. As a nuclear engineer myself, I know the limitations and capabilities of atomic power. I also know that as far as the human beings on this Earth are concerned, that the nonproliferation of atomic weapons is number one. Only in the last few days, with the election approaching, has Mr. Ford taken any interest in a nonproliferation movement. I advocated last May, in a speech at the United Nations, that we move immediately as a nation to declare a complete moratorium on the testing of all nuclear devices, both weapons and peaceful devices, that we not ship any more atomic fuel to a country that refuses to comply with strict controls over the waste which can be reprocessed into explosives. I've also advocated that we stop the sale by Germany and France of reprocessing plants to Pakistan and Brazil. Mr. Ford hasn't moved on this. We also need to provide an adequate supply of enriched uranium. Mr. Ford again, under pressure from the atomic energy lobby, has insisted that this reprocessing or rather reenrichment be done by private industry and not by the existing government plants. This kind of confusion and absence of leadership has let us drift now for 2 years with the constantly increasing threat of atomic weapons throughout the world. We now have five nations that have atomic bombs that we know about. If we continue under Mr. Ford's policy, by 1985 or '90 we will have 20 nations that have the capability of exploding atomic weapons. This has got to be stopped. That is one of the major challenges and major undertakings that I will assume as the next President. THE MODERATOR. Mr. Valeriani, a question for Governor Carter. MR. VALERIANI. Governor Carter, earlier tonight you said America is not strong anymore, America is not respected anymore. And I feel I must ask you, do you really believe that the United States is not the strongest country in the world? Do you really believe that the United States is not the most respected country in the world, or is that just campaign rhetoric? MR. CARTER. No, it's not just campaign rhetoric. I think that militarily we are as strong as any nation on Earth. I think we've got to stay that way and continue to increase our capabilities to meet any potential threat. But as far as strength derived from commitment to principles; as far as strength derived from the unity within our country; as far as strength derived from the people, the Congress, the Secretary of State, the President, sharing in the evolution and carrying out of a foreign policy; as far as strength derived from the respect of our own allies and friends, their assurance that we will be staunch in our commitment, that we will not deviate, and we will give them adequate attention; as far as strength derived from doing what is right, caring for the poor, providing food, becoming the breadbasket of the world instead of the arms merchant of the world--in those respects we are not strong. Also, we will never be strong again overseas unless we are strong at home. And with our economy in such terrible disarray, and getting worse by the month--we have got 500,000 more Americans unemployed today than we had 3 months ago; we have got 2 1/2 million more Americans out of work now than we had when Mr. Ford took office--this kind of deterioration in our economic strength is bound to weaken us around the world. And we not only have problems at home but we export those problems overseas. So, as far as the respect of our own people toward our own Government, as far as participation in the shaping of concepts and commitments, as far as a trust of our country among the nations of the world, as far as dependence of our country in meeting the needs and obligations that we've expressed to our allies, as far as the respect of our country, even among our potential adversaries, we are weak. Potentially, we are strong. Under this administration that strength has not been realized. THE MODERATOR. President Ford. THE PRESIDENT. Governor Carter brags about the unemployment during Democratic administrations and condemns the unemployment at the present time. I must remind him that we are at peace, and during the period that he brags about unemployment being low, the United States was at war. Now let me correct one other comment that Governor Carter has made. I have recommended to the Congress that we develop the uranium enrichment plant at Portsmouth, Ohio, which is a publicly owned US. Government facility, and have indicated that the private program which would follow on in Alabama is one that may or may not be constructed, but I committed to the one at Portsmouth, Ohio. The Governor also talks about morality in foreign policy. The foreign policy of the United States meets the highest standards of morality. What is more moral than peace? And the United States is at peace today. What is more moral in foreign policy than for the administration to take the lead in the World Food Conference in Rome in 1974, when the United States committed 6 million metric tons of food, over 60 percent of the food committed for the disadvantaged and underdeveloped nations of the world? The Ford administration wants to eradicate hunger and disease in our underdeveloped countries throughout the world. What is more moral than for the United States under the Ford administration to take the lead in southern Africa, in the Middle East? Those are initiatives in foreign policy which are of the highest moral standards. And that is indicative of the foreign policy of this country. THE MODERATOR. Mr. Frankel, a question for President Ford. MR. FRANKEL. Mr. President, can we stick with morality? For a lot of people it seems to cover a bunch of sins. Mr. Nixon and Mr. Kissinger used to tell us that instead of morality we had to worry in the world about living with and letting live all kinds of governments that we really didn't like--North and South Korean dictators, Chilean fascists, Chinese Communists, Iranian emperors, and so on. They said the only way to get by in a wicked world was to treat others on the basis of how they treated us and not how they treated their own people. But more recently we seem to have taken a different tack. We seem to have decided that it is part of our business to tell the Rhodesians, for instance, that the way they are treating their own black people is wrong and they've got to change their government. And we put pressure on them. We were rather liberal in our advice to the Italians as to how to vote. Is this a new Ford foreign policy in the making? Can we expect that you are now going to turn to South Africa and force them to change their government, to intervene in similar ways to end the bloodshed, as you called it, say in Chile or Chilean prisons, and to throw our weight around for the values that we hold dear in the world? THE PRESIDENT. I believe that our foreign policy must express the highest standards of morality, and the initiatives that we took in southern Africa are the best examples of what this administration is doing and will continue to do in the next 4 years. If the United States had not moved when we did in southern Africa, there is no doubt there would have been an acceleration of bloodshed in that tragic part of the world. If we had not taken our initiative, it's very, very possible that the Government of Rhodesia would have been overrun and that the Soviet Union and the Cubans would have dominated southern Africa. So, the United States, seeking to preserve the principle of self-determination, to eliminate the possibility of bloodshed, to protect the rights of the minority as we insisted upon the rights of the majority, I believe followed the good conscience of the American people in foreign policy, and I believe that we have used our skill. Secretary of State Kissinger has done a superb job in working with the black African nations, the so-called frontline nations. He has done a superb job in getting the Prime Minister of South Africa, Mr. Vorster, to agree that the time had come for a solution to the problem of Rhodesia. Secretary Kissinger, in his meeting with Prime Minister Smith of Rhodesia, was able to convince him that it was in the best interests of whites as well as blacks in Rhodesia to find an answer for a transitional government and then a majority government. This is a perfect example of the kind of leadership that the United States, under this administration, has taken. And I can assure you that this administration will follow that high moral principle in our future efforts in foreign policy, including our efforts in the Middle East, where it is vitally important because the Middle East is the crossroads of the world. There have been more disputes, and it's an area where there is more volatility than any other place in the world. But because Arab nations and the Israelis trust the United States, we were able to take the lead in the Sinai II agreement. And I can assure you that the United States will have the leadership role in moving toward a comprehensive settlement of the Middle Eastern problems-I hope and trust as soon as possible--and we will do it with the highest moral principles. Ms. FRANKEL. Mr. President, just clarify one point. There are lots of majorities in the world that feel they are being pushed around by minority governments. And are you saying they can now expect to look to us for not just good cheer but throwing our weight on their side in South Africa or on Taiwan or in Chile, to help change their governments as in Rhodesia? THE PRESIDENT. I would hope that as we move to one area of the world from another--and the United States must not spread itself too thinly; that was one of the problems that helped to create the circumstances in Vietnam--but as we as a nation find that we are asked by the various parties, either one nation against another or individuals within a nation, that the United States will take the leadership and try to resolve the differences. Let me take South Korea as an example. I have personally told President Park that the United States does not condone the kind of repressive measures that he has taken in that country. But I think in all fairness and equity, we have to recognize the problem that South Korea has. On the north they have North Korea with 500,000 well-trained, well-equipped troops. They are supported by the People's Republic of China. They are supported by the Soviet Union. South Korea faces a very delicate situation. Now, the United States in this case, this administration has recommended a year ago--and we have reiterated it again this year--that the United States, South Korea, North Korea, and the People's Republic of China sit down at a conference table to resolve the problems of the Korean peninsula. This is a leadership role that the United States, under this administration, is carrying out. And if we do it--and I think the opportunities and the possibilities are getting better--we will have solved many of the internal domestic problems that exist in South Korea at the present time. THE MODERATOR. Governor Carter? MR. CARTER. I noticed that Mr. Ford didn't comment on the prisons in Chile. This is a typical example, maybe of many others, where this administration overthrew an elected government and helped to establish a military dictatorship. This has not been an ancient history story. Last year, under Mr. Ford, of all the Food for Peace that went to South America, 85 percent went to the military dictatorship in Chile. Another point I want to make is this: He says we have to move from one area of the world to another. That is one of the problems with this administration's so-called shuttle diplomacy. While the Secretary of State is in one country, there are almost 150 others that are wondering what we are going to do next, what will be the next secret agreement. We don't have a comprehensive, understandable foreign policy that deals with world problems or even regional problems. Another thing that concerned me was what Mr. Ford said about unemployment, that insinuating that under Johnson and Kennedy that unemployment could only be held down when this country is at war. Karl Marx said that the free enterprise system in a democracy can only continue to exist when they are at war or preparing for war. Karl Marx was the grandfather of communism. I don't agree with that statement; I hope Mr. Ford doesn't, either. He has put pressure on the Congress--and I don't believe Mr. Ford would even deny this--to hold up on nonproliferation legislation until the Congress agreed for an $8 billion program for private industry to start producing enriched uranium. And the last thing I want to make is this: He talks about peace, and I am thankful for peace. We were peaceful when Mr. Ford went into office, but he and Mr. Kissinger and others tried to start a new Vietnam in Angola. And it was only the outcry of the American people and the Congress when this secret deal was discovered that prevented our renewed involvement in that conflagration which was taking place there. THE MODERATOR. Gentlemen, I am sorry to say we do not have time enough for two complete sequences of questions. We now have only 12 minutes left. Therefore, I would like to ask for shorter questions and shorter answers. And we also will drop the follow-up question. Each candidate may still respond, of course, to the other's answer. Mr. Trewhitt, a question for Governor Carter. MR. TREWHITT. Governor Carter, before this event the most communication I received concerned Panama. Would you, as President, be prepared to sign a treaty which at a fixed date yielded administrative and economic control of the Canal Zone and shared defense which, as I understand it, is the position the United States took in 1974? MR. CARTER. Well, here again, the Panamanian question is one that has been confused by Mr. Ford. He had directed his diplomatic representative to yield to the Panamanians full sovereignty over the Panama Canal Zone at the end of a certain period of time. When Mr. Reagan raised this question in Florida, Mr. Ford not only disavowed his instructions but he also even dropped, parenthetically, the use of the word "detente." I would never give up complete control or practical control of the Panama Canal Zone, but I would continue to negotiate with the Panamanians. When the original treaty was signed back in the early 1900's, when Theodore Roosevelt was President, Panama retained sovereignty over the Panama Canal Zone. We retained control as though we had sovereignty. Now, I would be willing to go ahead with negotiations. I believe that we could share more fully responsibilities for the Panama Canal Zone with Panama. I would be willing to continue to raise the payment for shipment of goods through the Panama Canal Zone. I might even be willing to reduce to some degree our military emplacements in the Panama Canal Zone, but I would not relinquish practical control of the Panama Canal Zone any time in the foreseeable future. THE MODERATOR. President Ford. THE PRESIDENT. The United States must and will maintain complete access to the Panama Canal. The United States must maintain a defense capability of the Panama Canal, and the United States will maintain our national security interests in the Panama Canal. The negotiations for the Panama Canal started under President Johnson and have continued up to the present time. I believe those negotiations should continue. But there are certain guidelines that must be followed, and I've just defined them. Let me take just a minute to comment on something that Governor Carter said on nonproliferation. In May of 1975, I called for a conference of nuclear suppliers. That conference has met six times. In May of this year, Governor Carter took the first initiative, approximately 12 months after I had taken my initiative a year ago. THE MODERATOR. Mr. Valeriani, a question for President Ford. MR. VALERIANI. Mr. President, the Government [General] Accounting Office has just put out a report suggesting that you shot from the hip in the Mayaguez rescue mission and that you ignored diplomatic messages saying that a peaceful solution was in prospect. Why didn't you do more diplomatically at the time? And a related question: Did the White I--House try to prevent the release of that report? THE PRESIDENT. The White House did not prevent the release of that report. On July 12 of this year, we gave full permission for the release of that report. I was very disappointed in the fact that the GAO released that report because I think it interjected political, partisan politics at the present time. But let me comment on the report. Somebody who sits in Washington, D.C., 18 months after the Mayaguez incident can be a very good grandstand quarterback. And let me make another observation. This morning I got a call from the skipper of the Mayaguez. He was furious, because he told me that it was the action of me, President Ford, that saved the lives of the crew of the Mayaguez. And I can assure you that if we had not taken the strong and forceful action that we did, we would have been criticized very, very severely for sitting back and not moving. Captain Miller is thankful, the crew is thankful. We did the right thing. It seems to me that those who sit in Washington 18 months after the incident are not the best judges of the decisionmaking process that had to be made by the National Security Council and by myself at the time the incident was developing in the Pacific. Let me assure you that we made every possible overture to the People's Republic of China and, through them, to the Cambodian Government; we made diplomatic protest to the Cambodian Government through the United Nations. Every possible diplomatic means was utilized. But at the same time I had a responsibility, and so did the National Security Council, to meet the problem at hand, and we handled it responsibly. And I think Captain Miller's testimony to that effect is the best evidence. THE. MODERATOR. Governor Carter. MR. CARTER. Well, I am reluctant to comment on the recent report. I haven't read it. I think the American people have only one requirement--that the facts about Mayaguez be given to them accurately and completely. Mr. Ford has been there for 18 months. He had the facts that were released today immediately after the Mayaguez incident. I understand that the report today is accurate. Mr. Ford has said, I believe, that it was accurate and that the White House made no attempt to block the issuing of that report. I don't know if that is exactly accurate or not. I understand that both the Department of State and the Defense Department have approved the accuracy of today's report, or yesterday's report, and also the National Security Agency. I don't know what was right or what was wrong or what was done. The only thing I believe is that whatever the knowledge was that Mr. Ford had should have been given to the American people 18 months ago, immediately after the Mayaguez incident occurred. This is what the American people want. When something happens that endangers our security, or when something happens that threatens our stature in the world, or when American people are endangered by the actions of a foreign country, just 40 sailors on the Mayaguez, we obviously have to move aggressively and quickly to rescue them. But then, after the immediate action is taken, I believe the President has an obligation to tell the American people the truth and not wait 18 months later for the report to be issued. THE MODERATOR. Gentlemen, at this time we have time for only two very short questions. Mr. Frankel, a question for Governor Carter. MR. FRANKEL. Governor Carter, if the price of gaining influence among the Arabs is closing our eyes a little bit to their boycott against Israel, how would you handle that? MR. CARTER. I believe that the boycott of American businesses by the Arab countries, because those businesses trade with Israel or because they have American Jews who are owners or directors in the company, is an absolute disgrace. This is the first time that I remember in the history of our country when we've let a foreign country circumvent or change our Bill of Rights. I will do everything I can as President to stop the boycott of American businesses by the Arab countries. It's not a matter of diplomacy or trade with me; it's a matter of morality. And I don't believe that the Arab countries will pursue it when we have a strong President who will protect the integrity of our country, the commitment of our Constitution and Bill of Rights, and protect people in this country who happen to be Jews--it may later be Catholics, it may later be Baptists--who are threatened by some foreign country. But we ought to stand staunch. And I think it is a disgrace that so far Mr. Ford's administration has blocked the passage of legislation that would have revealed by law every instance of the boycott, and it would have prevented the boycott from continuing. THE MODERATOR. President Ford? THE PRESIDENT. Again, Governor Carter is inaccurate. The Arab boycott action was first taken in 1952. And in November of 1975, I was the first President to order the executive branch to take action--affirmative action through the Department of Commerce and other Cabinet Departments--to make certain that no American businessman or business organization should discriminate against Jews because of an Arab boycott. And I might add that my administration--and I am very proud of it--is the first administration that has taken an antitrust action against companies in this country that have allegedly cooperated with the Arab boycott. Just on Monday of this week, I signed a tax bill that included an amendment that would prevent companies in the United States from taking a tax deduction if they have, in any way whatsoever, cooperated with the Arab boycott. And last week, when we were trying to get the Export Administration Act through the Congress--necessary legislation--my administration went to Capitol Hill and tried to convince the House and the Senate that we should have an amendment on that legislation which would take strong and effective action against those who participate or cooperate with the Arab boycott. One other point: Because the Congress failed to act I am going to announce tomorrow that the Department of Commerce will disclose those companies that have participated in the Arab boycott. This is something that we can do. The Congress failed to do it, and we intend to do it. THE MODERATOR. Mr. Trewhitt, a very brief question for President Ford. MR. TREWHITT. Mr. President, if you get the accounting of missing in action you want from North Vietnam--or from Vietnam, I am sorry, now--would you then be prepared to reopen negotiations for restoration of relations with that country? THE PRESIDENT. Let me restate our policy. As long as Vietnam, North Vietnam, does not give us a full and complete accounting of our missing in action, I will never go along with the admission of Vietnam to the United Nations. If they do give us a bona fide, complete accounting of the 800 MIA's, then I believe that the United States should begin negotiations for the admission of Vietnam to the United Nations, but not until they have given us the full accounting of our MIA's. THE MODERATOR. Governor Carter? MR. CARTER. One of the most embarrassing failures of the Ford administration, and one that touches specifically on human rights, is his refusal to appoint a Presidential commission to go to Vietnam, to go to Laos, to go to Cambodia and try to trade for the release of information about those who are missing in action in those wars. This is what the families of MIA's want. So far, Mr. Ford has not done it. We have had several fragmentary efforts by Members of the Congress and by private citizens. Several months ago the Vietnam Government said we are ready to sit down and negotiate for release of information on MIA's. So far, Mr. Ford has not responded. I also would never formalize relationships with Vietnam nor permit them to join the United Nations until they have taken this action. But that is not enough. We need to have an active and aggressive action on the part of the President, the leader of this country, to seek out every possible way to get that information which has kept the MIA families in despair and doubt, and Mr. Ford has just not done it. THE MODERATOR. Thank you, Governor Carter. That completes the questioning for this evening. Each candidate now has up to 3 minutes for a closing statement. It was determined by the toss of a coin that Governor Carter would take the first question, and he now goes first with his closing remarks. Governor Carter. MR. CATER. The purpose of this debate and the outcome of the election will determine three basic things--leadership, upholding the principles of our country, and proper priorities and commitments for the future. This election will also determine what kind of world we leave our children. Will it be a nightmare world, threatened with the proliferation of atomic bombs, not just in five major countries, but dozens of smaller countries that have been permitted to develop atomic weapons because of a failure of our top leadership to stop proliferation? Will we have a world of hunger and barred, and will we be living in an armed camp, stripped of our friendships and allies, hiding behind a tight defense that has been drawn in around us because we are fearful of the outside world? Will we have a government of secrecy that excludes the American people from participation in making basic decisions and therefore covers up mistakes and makes it possible for our Government--our Government--to depart from the principles of our Constitution and Bill of Rights? Or will we have a world of peace with the threat of atomic weapons eliminated, with full trade, with our people at work, inflation controlled, openness in government, our people proud once again; Congress, citizens, President, Secretary of State, working in harmony and unity toward a common future, a world where people have enough to cat, arid a world where we care about those who don't? Can we become a breadbasket of the world, instead of the arms merchant of the world? I believe we can and we ought to. Now, we have been hurt in recent years in this country, in the aftermath of Vietnam, Cambodia, Chile, Pakistan, Angola, Watergate, CIA. We have been hurt. Our people feel that we have lost something precious. That's not necessary. I want to see our Nation return to a posture and an image and a standard to make us proud once again. I remember the world of NATO and the world of point four and the world of the Marshall plan and a world of the Peace Corps. Why can't we have that once again? We ought to be a beacon for nations who search for peace and who search for freedom, who search for individual liberty, who search for basic human rights. We haven't been lately. We can be once again. We will never have that world leadership until we are strong at home, and we can have that strength if we return to the basic principles. It ought not to be a strength of bombast and threats. It ought to be a quiet strength based on the integrity of our people, the vision of the Constitution, and an innate strong will and purpose that God has given us in the greatest nation on Earth, the United States. THE MODERATOR. President Ford. THE PRESIDENT. As we have seen tonight, foreign policy and defense policy are difficult and complex issues. We can debate methods; we can debate one decision or another. But there are two things which cannot be debated---experience and results. In the last 2 years I have made policy decisions involving long-range difficulties and policies and made day-to-day judgments, not only as President of the United States but as the leader of the free world. What is the result of that leadership? America is strong, America is free, America is respected. Not a single young American today is fighting or dying on any foreign battlefield. America is at peace, with freedom. Thank you, and good night. THE MODERATOR. Thank you, President Ford. Thank you, Governor Carter. I also want to thank our questioners and the audience here this evening. The third and final debate between President Ford and Governor Carter will take place on October the 22d at 9:30 p.m., eastern daylight time, on the campus of the College of William and Mary in Williamsburg, Virginia. The subject matter will cover all issues. These debates are sponsored by the League of Women Voters Education Fund to help voters become better informed on the issues and to generate greater voter turnout in the November election. Now from the Palace of Fine Arts Theatre in San Francisco, good night.
