# Vice Presidential Debate in Cleveland

**Date:** October 5, 2004
**Source:** https://www.presidency.ucsb.edu/documents/vice-presidential-debate-case-western-reserve-university-cleveland

---

[moderated by Gwen Ifill of PBS] IFILL: Good evening from Case Western Reserve University's Veale Center here in Cleveland, Ohio. I'm Gwen Ifill of "The NewsHour" and "Washington Week" on PBS, and I welcome you to the first and the only vice presidential debate between Vice President Dick Cheney, the Republican nominee, and Senator John Edwards, the Democratic nominee. These debates are sponsored by the Commission on Presidential Debates. Tonight's will last 90 minutes, following detailed rules of engagement worked out by representatives of the candidates. I have agreed to enforce the rules they have devised for themselves to the best of my ability. The questions tonight will be divided between foreign and domestic policy, but the specific topics were chosen by me. The candidates have not been told what they are. The rules: For each question, there can be only a two- minute response, a 90-second rebuttal and, at my discretion, a discussion extension of one minute. A green light will come on when 30 seconds remain in any given answer, yellow at 15 seconds, red at five seconds, and then flashing red means time's up. There's also a back-up buzzer system, if needed. Candidates may not direct questions to one another. There will be two-minute closing statements, but no opening statements. There is an audience here in the hall, but they have been instructed to remain silent throughout. The order of the first question was determined by the candidates in advance, and the first one goes to Vice President Cheney. Vice President Cheney, there have been new developments in Iraq, especially having to do with the administration's handling. Paul Bremer, the former head of the Coalition Provisional Authority, gave a speech in which he said that we have never had enough troops on the ground, or we've never had enough troops on the ground. Donald Rumsfeld said he has not seen any hard evidence of a link between Al Qaida and Saddam Hussein. Was this approved -- of a report that you requested that you received a week ago that showed there was no connection between Abu Musab al-Zarqawi and Saddam Hussein? CHENEY: Gwen, I want to thank you, and I want to thank the folks here at Case Western Reserve for hosting this tonight. It's a very important event, and they've done a superb job of putting it together. It's important to look at all of our developments in Iraq within the broader context of the global war on terror. And, after 9/11, it became clear that we had to do several things to have a successful strategy to win the global war on terror, specifically that we had to go after the terrorists where ever we might find them, that we also had to go after state sponsors of terror, those who might provide sanctuary or safe harbor for terror. And we also then finally had to stand up democracies in their stead afterwards, because that was the only way to guarantee that these states would not again become safe harbors for terror or for the development of deadly weapons. Concern about Iraq specifically focused on the fact that Saddam Hussein had been, for years, listed on the state sponsor of terror, that they he had established relationships with Abu Nidal, who operated out of Baghdad; he paid $25,000 to the families of suicide bombers; and he had an established relationship with Al Qaida. Specifically, look at George Tenet, the CIA director's testimony before the Committee on Foreign Relations two years ago when he talked about a 10-year relationship. The effort that we've mounted with respect to Iraq focused specifically on the possibility that this was the most likely nexus between the terrorists and weapons of mass destruction. The biggest threat we faced today is the possibility of terrorists smuggling a nuclear weapon or a biological agent into one of our own cities and threatening the lives of hundreds of thousands of Americans. What we did in Iraq was exactly the right thing to do. If I had it to recommend all over again, I would recommend exactly the same course of action. The world is far safer today because Saddam Hussein is in jail, his government is no longer in power. And we did exactly the right thing. IFILL: Senator Edwards, you have 90 seconds to respond. EDWARDS: Thank you. Thank you, Gwen, for moderating this debate. Thank you to the folks of Case Western and all the people in Ohio for having us here. Mr. Vice President, you are still not being straight with the American people. I mean, the reality you and George Bush continue to tell people, first, that things are going well in Iraq -- the American people don't need us to explain this to them, they see it on their television every single day. We lost more troops in September than we lost in August; lost more in August than we lost in July; lost more in July than we lost in June. The truth is, our men and women in uniform have been heroic. Our military has done everything they've been asked to do. And it's not just me that sees the mess in Iraq. There are Republican leaders, like John McCain, like Richard Lugar, like Chuck Hagel, who have said Iraq is a mess and it's getting worse. And when they were asked why, Richard Lugar said because of the incompetence of the administration. What Paul Bremer said yesterday is they didn't have enough troops to secure the country. They also didn't have a plan to win the peace. They also didn't put the alliances together to make this successful. We need a fresh start. We need a president who will speed up the training of the Iraqis, get more staff in for doing that. We need to speed up the reconstruction so the Iraqis see some tangible benefit. We need a new president who has the credibility, which John Kerry has, to bring others into this effort. IFILL: You have 30 seconds to respond, Mr. Vice President. CHENEY: We've made significant progress in Iraq. We've stood up a new government that's been in power now only 90 days. The notion of additional troops is talked about frequently, but the point of success in Iraq will be reached when we have turned governance over to the Iraqi people; they have been able to establish a democratic government. They're well on their way to doing that. They will have free elections next January for the first time in history. We also are actively, rapidly training Iraqis to take on the security responsibility. Those two steps are crucial to success in Iraq. They're well in hand, well under way. And I'm confident that, in fact, we'll get the job done. IFILL: You have 30 seconds, Senator. EDWARDS: Yes. Mr. Vice President, there is no connection between the attacks of September 11th and Saddam Hussein. The 9/11 Commission has said it. Your own secretary of state has said it. And you've gone around the country suggesting that there is some connection. There is not. And in fact the CIA is now about to report that the connection between Al Qaida and Saddam Hussein is tenuous at best. And, in fact, the secretary of defense said yesterday that he knows of no hard evidence of the connection. We need to be straight with the American people. IFILL: Time for a new question but the same topic. And this time to you, Senator Edwards. You and Senator Kerry have said that the war in Iraq is the wrong war at the wrong time. Does that mean that if you had been president and vice president that Saddam Hussein would still be in power? EDWARDS: Here's what it means: It means that Saddam Hussein needed to be confronted. John Kerry and I have consistently said that. That's why we voted for the resolution. But it also means it needed to be done the right way. And doing it the right way meant that we were prepared; that we gave the weapons inspectors time to find out what we now know, that in fact there were no weapons of mass destruction; that we didn't take our eye off the ball, which are Al Qaida, Osama bin Laden, the people who attacked us on September the 11th. Now, remember, we went into Afghanistan, which, by the way, was the right thing to do. That was the right decision. And our military performed terrifically there. But we had Osama bin Laden cornered at Tora Bora. We had the 10th Mountain Division up in Uzbekistan available. We had the finest military in the world on the ground. And what did we do? We turned -- this is the man who masterminded the greatest mass murder and terrorist attack in American history. And what did the administration decide to do? They gave the responsibility of capturing and/or killing Saddam -- I mean Osama bin Laden to Afghan warlords who, just a few weeks before, had been working with Osama bin Laden. Our point in this is not complicated: We were attacked by Al Qaida and Osama bin Laden. We went into Afghanistan and very quickly the administration made a decision to divert attention from that and instead began to plan for the invasion of Iraq. And these connections -- I want the American people to hear this very clearly. Listen carefully to what the vice president is saying. Because there is no connection between Saddam Hussein and the attacks of September 11th -- period. The 9/11 Commission has said that's true. Colin Powell has said it's true. But the vice president keeps suggesting that there is. There is not. And, in fact, any connection with Al Qaida is tenuous at best. IFILL: Mr. Vice President, you have 90 seconds to respond. CHENEY: The senator has got his facts wrong. I have not suggested there's a connection between Iraq and 9/11, but there's clearly an established Iraqi track record with terror. And the point is that that's the place where you're most likely to see the terrorists come together with weapons of mass destruction, the deadly technologies that Saddam Hussein had developed and used over the years. Now, the fact of the matter is, the big difference here, Gwen, is they are not prepared to deal with states that sponsor terror. They've got a very limited view about how to use U.S. military forces to defend America. We heard Senator Kerry say the other night that there ought to be some kind of global test before U.S. troops are deployed preemptively to protect the United States. That's part of a track record that goes back to the 1970s when he ran for Congress the first time and said troops should not be deployed without U.N. approval. Then, in the mid-'80s, he ran on the basis of cutting most of our major defense programs. In 1991, he voted against Desert Storm. It's a consistent pattern over time of always being on the wrong side of defense issues. A little tough talk in the midst of a campaign or as part of a presidential debate cannot obscure a record of 30 years of being on the wrong side of defense issues. And they give absolutely no indication, based on that record, of being wiling to go forward and aggressively pursue the war on terror with a kind of strategy that will work, that will defeat our enemies and will guarantee that the United States doesn't again get attacked by the likes of Al Qaida. IFILL: You will respond to that topic, but first I want to ask you for two minutes, Vice President Cheney. Tonight we mentioned Afghanistan. We believe that Osama bin Laden is hiding perhaps in a cave somewhere along the Afghan-Pakistan border. If you get a second term, what is your plan to capture him and then to neutralize those who have sprung up to replace him? CHENEY: Gwen, we've never let up on Osama bin Laden from day one. We've actively and aggressively pursued him. We've captured or killed thousands of Al Qaida in various places around the world and especially in Afghanistan. We'll continue to very aggressively pursue him, and I'm confident eventually we'll get him. The key to success in Afghanistan has been, again, to go in and go after the terrorists, which we've done, and also take down the Taliban regime which allowed them to function there, in effect sponsors, if you will, of the Al Qaida organization. John Edwards, two and a half years ago, six months after we went into Afghanistan announced that it was chaotic, the situation was deteriorating, the warlords were about to take over. Here we are, two and a half years later, we're four days away from a democratic election, the first one in history in Afghanistan. We've got 10 million voters who have registered to vote, nearly half of them women. That election will put in place a democratically elected government that will take over next December. We've made enormous progress in Afghanistan, in exactly the right direction, in spite of what John Edwards said two and a half years ago. He just got it wrong. The fact is, as we go forward in Afghanistan, we will pursue Osama bin Laden and the terrorists as long as necessary. We're standing up Afghan security forces so they can take on responsibility for their own security. We'll keep U.S. forces there -- we have about 16,000 there today -- as long as necessary, to assist the Afghans in terms of dealing with their security situation. But they're making significant progress. We have President Karzai, who is in power. They have done wonders writing their own constitution for the first time ever. Schools are open. Young girls are going to school. Women are going to vote. Women are even eligible to run for office. This is major, major progress. There will be democracy in Afghanistan, make no doubt about it. Freedom is the best antidote to terror. IFILL: Senator Edwards, you have 90 seconds. EDWARDS: Someone did get it wrong. But it wasn't John Kerry and John Edwards. They got it wrong. When we had Osama bin Laden cornered, they left the job to the Afghan warlords. They then diverted their attention from the very people who attacked us, who were at the center of the war on terror, and so Osama bin Laden is still at large. Now, I want to go back to something the vice president said just a minute ago, because these distortions are continuing. He said that -- made mention of this global test. What John Kerry said -- and it's just as clear as day to anybody who was listening -- he said: We will find terrorists where they are and kill them before they ever do harm to the American people, first. We will keep this country safe. He defended this country as a young man, he will defend this country as president of the United States. He also said very clearly that he will never give any country veto power over the security of the United States of America. Now, I know the vice president would like to pretend that wasn't said, and the president would too. But the reality is it was said. Here's what's actually happened in Afghanistan, regardless of this rosy scenario that they paint on Afghanistan, just like they do with Iraq. What's actually happened is they're now providing 75 percent of the world's opium. Not only are they providing 75 percent of the world's opium, large-cut parts of the country are under the control of drug lords and warlords. Big parts of the country are still insecure. And the reality is the part of Afghanistan, eastern Afghanistan, where Osama bin Laden is, is one of the hardest places to control and the most insecure, Gwen. IFILL: Mr. Vice President, 30 seconds. CHENEY: Twenty years ago we had a similar situation in El Salvador. We had -- guerrilla insurgency controlled roughly a third of the country, 75,000 people dead, and we held free elections. I was there as an observer on behalf of the Congress. The human drive for freedom, the determination of these people to vote, was unbelievable. And the terrorists would come in and shoot up polling places; as soon as they left, the voters would come back and get in line and would not be denied the right to vote. And today El Salvador is a whale of a lot better because we held free elections. The power of that concept is enormous. And it will apply in Afghanistan, and it will apply as well in Iraq. EDWARDS: The vice president just said that we should focus on state sponsors of terrorism. Iran has moved forward with its nuclear weapons program. They're more dangerous today than they were four years ago. North Korea has moved forward with their nuclear weapons program, gone from one to two nuclear weapons to six to eight nuclear weapons. This vice president has been an advocate for over a decade for lifting sanctions against Iran, the largest state sponsor of terrorism on the planet. It's a mistake. We should not only not lift them, we should strengthen those sanctions. IFILL: New question to you, Senator Edwards, but I don't want to let go of the global test question first, because... EDWARDS: Sure. IFILL: ... I want people to understand exactly what it is, as you said, that Senator Kerry did say. He said, "You've got to do" -- you know, he was asked about preemptive action at the last debate -- he said, "You've got to do it in a way that passes the test, that passes the global test where your countrymen, your people understand fully why you're doing what you're doing and can prove to the world that you did it for legitimate reasons." What is a global test if it's not a global veto? EDWARDS: Well, let me say, first, he said in the same segment -- I don't remember precisely where it was connected with what you just read -- but he said, point blank, "We will never give anyone a veto over the security of the United States of America." What he's saying is we're going to go back to the proud tradition of the United States of America and presidents of the United States of America for the last 50 to 75 years. First, we're going to actually tell the American people the truth. We're going to tell them the truth about what's happening. We're not going to suggest to them that things are going well in Iraq or anyplace else when, in fact, they're not. We're going to make sure that the American people know the truth about why we are using force and what the explanation for it is. And it's not just the American people. We're also going to make sure that we tell the world the truth. Because the reality is, for America to lead, for America to do what it's done for 50 years before this president and vice president came into office, it is critical that we be credible. It is critical that they believe that when America takes action, they can trust what we're doing, what we say, what we say at the United Nations, what we say in direct conversations with leaders of the world -- of other countries. They need to know that the credibility of the United States is always good, because they will not follow us without that. And unfortunately, we're seeing the consequences of that right now. It's one of the reasons that we're having so much difficulty getting others involved in the effort in Iraq. You know, we've taken 90 percent of the coalition causalities. American taxpayers have borne 90 percent of the costs of the effort in Iraq. And we see the result of there not being a coalition: The first Gulf war cost America $5 billion. We're at $200 billion and counting. John Kerry will never give up control over the security of the United States of America to any other country. We will not outsource our responsibility to keep this country safe. IFILL: Mr. Vice President, you have 90 seconds to respond. CHENEY: Well, Gwen, the 90 percent figure is just dead wrong. When you include the Iraqi security forces that have suffered casualties, as well as the allies, they've taken almost 50 percent of the casualties in operations in Iraq, which leaves the U.S. with 50 percent, not 90 percent. With respect to the cost, it wasn't $200 billion. You probably weren't there to vote for that. But $120 billion is, in fact, what has been allocated to Iraq. The rest of it's for Afghanistan and the global war on terror. The allies have stepped forward and agreed to reduce and forgive Iraqi debt to the tune of nearly $80 billion by one estimate. That, plus $14 billion they promised in terms of direct aid, puts the overall allied contribution financially at about $95 billion, not to the $120 billion we've got, but, you know, better than 40 percent. So your facts are just wrong, Senator. You also have a situation where you talk about credibility. It's awfully hard to convey a sense of credibility to allies when you voted for the war and then you declared: Wrong war, wrong place, wrong time. You voted for the war, and then you voted against supporting the troops when they needed the equipment, the fuel, the spare parts and the ammunition and the body armor. You're not credible on Iraq because of the enormous inconsistencies that John Kerry and you have cited time after time after time during the course of the campaign. Whatever the political pressures of the moment requires, that's where you're at. But you've not been consistent, and there's no indication at all that John Kerry has the conviction to successfully carry through on the war on terror. EDWARDS: May I respond briefly? What the vice president has just said is just a complete distortion. The American people saw John Kerry on Thursday night. They don't need the vice president or the president to tell them what they saw. They saw a man who was strong, who had conviction, who is resolute, who made it very clear that he will do everything that has to be done to find terrorists, to keep the American people safe. He laid out his plan for success in Iraq, made it clear that we were committed to success in Iraq. We have to be, because we have troops on the ground there and because they have created a haven for terrorists. IFILL: Mr. Vice President, you have 30 seconds. CHENEY: Your rhetoric, Senator, would be a lot more credible if there was a record to back it up. There isn't. And you cannot use "talk tough" during the course of a 90-minute debate in a presidential campaign to obscure a 30-year record in the United States Senate and, prior to that by John Kerry, who has consistently come down on the wrong side of all the major defense issues that he's faced as a public official. IFILL: Mr. Vice President, a new question for you. You have two minutes to respond. When the president says that Senator Kerry is emboldening enemies and you say that we could get hit again if voters make the wrong choice in November, are you saying that it would be a dangerous thing to have John Kerry as president? CHENEY: I'm saying specifically that I don't believe he has the qualities we need in a commander in chief because I don't think, based on his record, that he would pursue the kind of aggressive policies that need to be pursued if we're going to defeat these terrorists. We need to battle them overseas so we don't have to battle them here at home. I'm not challenging John Kerry's patriotism. I said in my acceptance speech in New York City at the Republican convention that we respected his service in Vietnam, and I got applause for that. We've never criticized his patriotism. What we've questioned is his judgment. And his judgment's flawed, and the record's there for anybody who wants to look at it. In 1984, when he ran for the Senate he opposed, or called for the elimination of a great many major weapons systems that were crucial to winning the Cold War and are important today to our overall forces. When Saddam Hussein invaded Kuwait and occupied it in 1990 and '91, he stood up on the floor of the Senate and voted against going in to liberate Kuwait and push Saddam Hussein back to Iraq. The problem we have is that, if you look at his record, he doesn't display the qualities of somebody who has conviction. And with respect to this particular operation, we've seen a situation in which, first, they voted to commit the troops, to send them to war, John Edwards and John Kerry, then they came back and when the question was whether or not you provide them with the resources they needed -- body armor, spare parts, ammunition -- they voted against it. I couldn't figure out why that happened initially. And then I looked and figured out that what was happening was Howard Dean was making major progress in the Democratic primaries, running away with the primaries based on an anti-war record. So they, in effect, decided they would cast an anti-war vote and they voted against the troops. Now if they couldn't stand up to the pressures that Howard Dean represented, how can we expect them to stand up to Al Qaida? IFILL: Senator Edwards, you have 90 seconds to respond. EDWARDS: Thank you. One thing that's very clear is that a long resume does not equal good judgment. I mean, we've seen over and over and over the misjudgments made by this administration. I want to go back to what the vice president just said, because it's a continuation of the things he's been doing, unfortunately, on the campaign trail; it's a continuation of what he began his first answer with tonight. John Kerry has voted for the biggest military appropriations bill in the country's history. John Kerry has voted for the biggest intelligence appropriations in the country's history. This vice president, when he was secretary of defense, cut over 80 weapons systems, including the very ones he's criticizing John Kerry for voting against. These are weapons systems, a big chunk of which, the vice president himself suggested we get rid of after the Cold War. The reality is that John Kerry has consistently supported the very men that he served with in Vietnam and led. On the $87 billion, it was clear at the time of that vote that they had no plan to win the peace. We're seeing the consequences of that everyday on the ground right now. We stood up and said: For our troops, we must have a plan to win the peace. We also thought it was wrong to have a $20 billion fund out of which $7.5 billion was going to go to a no-bid contract for Halliburton, the vice president's former company. It was wrong then. It's wrong now. IFILL: Mr. Vice President, you have 30 seconds. CHENEY: Well, Gwen, I think the record speaks for itself. These are two individuals who have been for the war when the headlines were good and against it when their poll ratings were bad. We have not seen the kind of consistency that a commander in chief has to have in order to be a leader in wartime and in order to be able to see the strategy through to victory. If we want to win the war on terror, it seems to me it's pretty clear the choice is George Bush, not John Kerry. IFILL: And 30 seconds... EDWARDS: John Kerry has been absolutely clear and consistent from the beginning that we must stay focused on the people who attacked us; that Saddam Hussein was a threat that needed to be addressed directly; that the weapons inspectors needed to have time to do their job. Had they had time to do their job, they would have discovered what we now know, that in fact Saddam Hussein had no weapons, that in fact Saddam Hussein has no connection with 9/11, that in fact Saddam Hussein has little or no connection with Al Qaida. IFILL: Senator Edwards, new question to you, and you have two minutes to respond. Part of what you have said and Senator Kerry has said that you are going to do in order to get us out of the problems in Iraq is to internationalize the effort. Yet French and German officials have both said they have no intention even if John Kerry is elected of sending any troops into Iraq for any peacekeeping effort. Does that make your effort or your plan to internationalize this effort seem kind of naive? EDWARDS: Well, let's start with what we know. What we know is that the president and the vice president have not done the work to build the coalition that we need -- dramatically different than the first Gulf War. We know that they haven't done it, and we know they can't do it. They didn't, by the way, just reject the allies going into lead- up to the war. They also rejected them in the effort to do the reconstruction in Iraq, and that has consequences. What we believe is, as part of our entire plan for Iraq -- and we have a plan for Iraq. They have a plan for Iraq too: more of the same. We have a plan for success. And that plan includes speeding up the training of the military. We have less than half of the staff that we need there to complete that training. Second, make sure that the reconstruction is sped up in a way that the Iraqis see some tangible benefit for what's happening. And by the way, if we need to, we can take Iraqis out of Iraq to train them. It is not secure enough. It's so dangerous on the ground that they can't be trained there. We can take them out of Iraq for purposes of training. We should do whatever has to be done to train the Iraqis and to speed up that process. That works in conjunction with making sure the elections take place on time. Right now, the United Nations, which is responsible for the elections in January, has about 35 people there. Now, that's compared with a much smaller country like East Timor, where they had over 200 people on the ground. You need more than 35 people to hold an election in Cleveland, much less in Iraq. And they keep saying the election's on schedule, this is going to happen. The reality is we need a new president with credibility with the rest of the world and who has a real plan for success. Success breeds contribution, breeds joining the coalition. Not only that, I want to go back to what the vice president said. He attacks us about the troops. They sent 40,000 American troops into Iraq without the body armor they needed. They sent them without the armored vehicles they needed. While they were on the ground fighting, they lobbied the Congress to cut their combat pay. This is the height of hypocrisy. IFILL: Mr. Vice President, you have 90 seconds. CHENEY: Well, Gwen, it's hard to know where to start; there are so many inaccuracies there. The fact of the matter is the troops wouldn't have what they have today if you guys had had your way. You talk about internationalizing the effort. They don't have a plan. Basically, it's an echo. You made the comment that the Gulf War coalition in '91 was far stronger than this. No. We had 34 countries then; we've got 30 today. We've got troops beside us. It's hard, after John Kerry referred to our allies as a coalition of the coerced and the bribed, to go out and persuade people to send troops and to participate in this process. You end up with a situation in which -- talk about demeaning. In effect, you demean the sacrifice of our allies when you say it's the wrong war, wrong place, wrong time, and oh, by the way, send troops. Makes no sense at all. It's totally inconsistent. There isn't a plan there. Our most important ally in the war on terror, in Iraq specifically, is Prime Minister Allawi. He came recently and addressed a joint session of Congress that I presided over with the speaker of the House. And John Kerry rushed out immediately after his speech was over with, where he came and he thanked America for our contributions and our sacrifice and pledged to hold those elections in January, went out and demeaned him, criticized him, challenged his credibility. That is not the way to win friends and allies. You're never going to add to the coalition with that kind of attitude. IFILL: Senator Edwards, 30 seconds. EDWARDS: Thank you. The vice president suggests that we have the same number of countries involved now that we had in the first Gulf War. The first Gulf War cost the American people $5 billion. And regardless of what the vice president says, we're at $200 billion and counting. Not only that, 90 percent of the coalition casualties, Mr. Vice President, the coalition casualties, are American casualties. Ninety percent of the cost of this effort are being borne by American taxpayers. It is the direct result of the failures of this administration. IFILL: Mr. Vice President? CHENEY: Classic example. He won't count the sacrifice and the contribution of Iraqi allies. It's their country. They're in the fight. They're increasingly the ones out there putting their necks on the line to take back their country from the terrorists and the old regime elements that are still left. They're doing a superb job. And for you to demean their sacrifices strikes me as... EDWARDS: Oh, I'm not... CHENEY: ... as beyond... EDWARDS: I'm not demeaning... CHENEY: It is indeed. You suggested... EDWARDS: No, sir, I did not... CHENEY: ... somehow they shouldn't count, because you want to be able to say that the Americans are taking 90 percent of the sacrifice. You cannot succeed in this effort if you're not willing to recognize the enormous contribution the Iraqis are increasingly making to their own future. We'll win when they take on responsibility for governance, which they're doing, and when the take on responsibility for their own security, which they increasingly are doing. IFILL: New question, similar topic, because I want to circle back to a question which I'm not quite certain we got an answer to. But I will direct it to you first, Senator Edwards. EDWARDS: Thanks. IFILL: It's a question of American intelligence. If this report that we've read about today is true, and if Vice President Cheney ordered it and asked about this, do you think that, in the future, that your administration or the Bush administration would have sufficient and accurate enough intelligence to be able to make decisions about where to go next? EDWARDS: Well, let me speak, first of all, to what the vice president just said, and then I'll answer that question. This, unfortunately -- what the vice president is telling people is inconsistent with everything they see every single day. It's a continuation of, "Well, there's a strong connection between Al Qaida and Saddam Hussein." It's not true. It's a continuation of at least insinuating that there's some connection between 9/11 and Saddam Hussein. It's not true. It's saying to the American people, as the president said last Thursday, and the vice president continues to say tonight, that things are going well in Iraq, contrary to what people who have been there have seen, including Republican leaders, contrary to what everyone in America sees on their television every day -- Americans being kidnapped, people being beheaded, parts of the country under the control of insurgents, even today, under the control of the insurgents. The vice president has still not said anything about what Mr. Bremer said, about the failure to have adequate troops, the failure to be able to secure the country in the short term. You know, remember "shock and awe"? Look at where we are now. It is a direct result of the failure to plan, the failure to have others involved in this effort. This is not an accident. Now, let me go back to your question. If we want to do the things that need to be done to keep this country safe, we can't be dragged kicking and screaming to it. One thing that everybody does agree on is that 9/11 did change things. But what's happened is this administration opposed the creation of a 9/11 Commission to find out why it happened and what we needed to do. They opposed the creation of a Department of Homeland Security, and then they were for it. We can't react that way. We must be more aggressive. With John Kerry as president of the United States, we are committed to immediately implementing all of the reforms suggested by the 9/11 Commission, so that we have the information we need to find terrorists and crush them before hey hurt us. IFILL: Mr. Vice President? CHENEY: Gwen, the story that appeared today about this report is one I asked for. I ask an awful lot of questions as part of my job as vice president. A CIA spokesman was quoted in that story as saying they had not yet reached the bottom line and there is still debate over this question of the relationship between Zarqawi and Saddam Hussein. The report also points out that at one point some of Zarqawi's people were arrested. Saddam personally intervened to have them released, supposedly at the request of Zarqawi But let's look at what we know about Mr. Zarqawi. We know he was running a terrorist camp, training terrorists in Afghanistan prior to 9/11. We know that when we went into Afghanistan that he then migrated to Baghdad. He set up shop in Baghdad, where he oversaw the poisons facility up at Kermal (ph), where the terrorists were developing ricin and other deadly substances to use. We know he's still in Baghdad today. He is responsible for most of the major car bombings that have killed or maimed thousands of people. He's the one you will see on the evening news beheading hostages. He is, without question, a bad guy. He is, without question, a terrorist. He was, in fact, in Baghdad before the war, and he's in Baghdad now after the war. The fact of the matter is that this is exactly the kind of track record we've seen over the years. We have to deal with Zarqawi by taking him out, and that's exactly what we'll do. IFILL: Mr. Vice President, in June of 2000 when you were still CEO of Halliburton, you said that U.S. businesses should be allowed to do business with Iran because, quote, "Unilateral sanctions almost never work." After four years as vice president now, and with Iran having been declared by your administration as part of the "Axis of Evil," do you still believe that we should lift sanctions on Iran? CHENEY: No, I do not. And, Gwen, at the time, I was talking specifically about this question of unilateral sanctions. What happens when we impose unilateral sanctions is, unless there's a collective effort, then other people move in and take advantage of the situation and you don't have any impact, except to penalize American companies. We've got sanctions on Iran now. We may well want to go to the U.N. Security Council and ask for even tougher sanctions if they don't live up to their obligations under the initial -- International Atomic Energy Agency Non-Proliferation Treaty. We dealt with Iran differently than we have Iraq partly because Iran has not yet, as Iraq did, violated 12 years of resolutions by the U.N. Security Council. We're working with the Brits and the Germans and the French, who've been negotiating with the Iranians. We recently were actively involved in a meeting with the board of governors in the International Atomic Energy Agency. And as I say, there will be a follow-up meeting in November to determine whether or not Iran's living up to their commitments and obligations. And if they aren't, my guess is then the board of governors will recommend sending the whole matter to the U.N. Security Council for the application of the international sanctions, which I think would be exactly the right way to go. We're addressing North Korea on a similar basis, working with the Chinese, the South Koreans, the Japanese and others to try to bring them around. One of the great by-products, for example, of what we did in Iraq and Afghanistan is that five days after we captured Saddam Hussein, Moammar Gadhafi in Libya came forward and announced that he was going to surrender all of his nuclear materials to the United States, which he has done. This was one of the biggest sources of proliferation in the world today in terms of the threat that was represented by that. The suppliers network that provided that, headed by Mr. A.Q. Khan, has been shut down. We've made major progress in dealing here with a major issue with respect to nuclear proliferation. And we'll continue to press very hard on the North Koreans and the Iranians as well. IFILL: Senator Edwards? EDWARDS: Well, the vice president talks about there being a member, or someone associated with Al Qaida, in Iraq. There are 60 countries who have members of Al Qaida in them. How many of those countries are we going to invade? Not only that, he talks about Iran. The reality about Iran is that Iran has moved forward with their nuclear weapons program on their watch. They ceded responsibility to dealing with it to the Europeans. Now, the vice president, as you pointed out, spoke out loudly for lifting the sanctions on Iraq. John Kerry and I believe we need to strengthen the sanctions on Iraq, including closing the loophole that allows companies to use a subsidiary, offshore subsidiaries to do business with Iran. I mentioned Halliburton a few minute ago in connection with the $87 billion, and you raised it in this question. This is relevant, because he was pushing for lifting sanctions when he was CEO of Halliburton. Here's why we didn't think Halliburton should have a no-bid contract. While he was CEO of Halliburton, they paid millions of dollars in fines for providing false information on their company, just like Enron and Ken Lay. They did business with Libya and Iran, two sworn enemies of the United States. They're now under investigation for having bribed foreign officials during that period of time. Not only that, they've gotten a $7.5 billion no-bid contract in Iraq, and instead of part of their money being withheld, which is the way it's normally done, because they're under investigation, they've continued to get their money. IFILL: Mr. Vice President? CHENEY: I can respond, Gwen, but it's going to take more than 30 seconds. IFILL: Well, that's all you've got. (LAUGHTER) CHENEY: Well, the reason they keep mentioning Halliburton is because they're trying to throw up a smokescreen. They know the charges are false. They know that if you go, for example, to factcheck.com (sic), an independent Web site sponsored by the University of Pennsylvania, you can get the specific details with respect to Halliburton. It's an effort that they've made repeatedly to try to confuse the voters and to raise questions, but there's no substance to the charges. IFILL: Thirty seconds. EDWARDS: These are the facts. The facts are the vice president's company that he was CEO of, that did business with sworn enemies of the United States, paid millions of dollars in fines for providing false financial information, it's under investigation for bribing foreign officials. The same company that got a $7.5 billion no-bid contract, the rule is that part of their money is supposed to be withheld when they're under investigation, as they are now, for having overcharged the American taxpayer, but they're getting every dime of their money. I'm happy to let voters make their own decision about this. IFILL: Senator Edwards, as we wrap up the foreign policy part of this, I do want to talk to you about the Israeli-Palestinian conflict. Today, a senior member of Islamic Jihad was killed in Gaza. There have been suicide bombings, targeted assassinations, mortar attacks, all of this continuing at a time when the United States seems absent in the peace-making process. What would your administration do? First of all, do you agree that the United States is absent? Maybe you don't. But what would your administration do to try to resolve that conflict? EDWARDS: Well, first of all, I do agree that we've been largely absent, not entirely absent, but largely absent from the peace-making process over the last four years. And let me just say a couple of preliminary things and then talk about where we are now. First, the Israeli people not only have the right to defend themselves, they should defend themselves. They have an obligation to defend themselves. I mean, if I can, just for a moment, tell you a personal story. I was in Jerusalem a couple of years ago, actually three years ago, in August of 2001, staying at the King David Hotel. We left in the morning, headed to the airport to leave, and later in the day I found out that that same day, not far from where we were staying, the Sbarro Pizzeria was hit by a suicide bomber in Jerusalem. Fifteen people were killed. Six children were killed. What are the Israeli people supposed to do? How can they continue to watch Israeli children killed by suicide bombers, killed by terrorists? They have not only the right to the obligation to defend themselves. Now, we know that the prime minister has made a decision, an historic decision, to unilaterally withdraw from Gaza. It's important for America to participate in helping with that process. Now, if Gaza's being used as a platform for attacking the Israeli people, that has to be stopped. And Israel has a right to defend itself. They don't have a partner for peace right now. They certainly don't have a partner in Arafat, and they need a legitimate partner for peace. And I might add, it is very important for America to crack down on the Saudis who have not had a public prosecution for financing terrorism since 9/11. And it's important for America to confront the situation in Iran, because Iran is an enormous threat to Israel and to the Israeli people. IFILL: Mr. Vice President, 90 seconds. CHENEY: Gwen, I want to go back to the last comment, and then I'll come back to Israel-Palestine. The reason they keep trying to attack Halliburton is because they want to obscure their own record. And Senator, frankly, you have a record in the Senate that's not very distinguished. You've missed 33 out of 36 meetings in the Judiciary Committee, almost 70 percent of the meetings of the Intelligence Committee. You've missed a lot of key votes: on tax policy, on energy, on Medicare reform. Your hometown newspaper has taken to calling you "Senator Gone." You've got one of the worst attendance records in the United States Senate. Now, in my capacity as vice president, I am the president of Senate, the presiding officer. I'm up in the Senate most Tuesdays when they're in session. The first time I ever met you was when you walked on the stage tonight. In respect to Israel and Palestine, Gwen, the suicide bombers, in part, were generated by Saddam Hussein, who paid $25,000 to the families of suicide bombers. I personally think one of the reasons that we don't have as many suicide attacks today in Israel as we've had in the past is because Saddam is no longer in business. We've been strong supporters of Israel. The president stepped forward and put in place a policy basically that said we will support the establishment of two states. First president ever to say we'll establish and support a Palestinian state nextdoor to Israelis. But first, there has to be an interlocutor you can trust and deal with. And we won't have that, we don't have it now, in a Yasser Arafat. There has to be reform of the Palestinian system. IFILL: Senator Edwards, it's your turn to use 30 seconds for a complicated response... EDWARDS: That was a complete distortion of my record. I know that won't come as a shock. The vice president, I'm surprised to hear him talk about records. When he was one of 435 members of the United States House, he was one of 10 to vote against Head Start, one of four to vote against banning plastic weapons that can pass through metal detectors. He voted against the Department of Education. He voted against funding for Meals on Wheels for seniors. He voted against a holiday for Martin Luther King. He voted against a resolution calling for the release of Nelson Mandela in South Africa. It's amazing to hear him criticize either my record or John Kerry's. IFILL: Thirty seconds. CHENEY: Oh, I think his record speaks for itself. And frankly, it's not very distinguished. IFILL: In that case, we'll move on to domestic matters. And this question, I believe, goes to Senator -- to Vice President Cheney. The Census Bureau... CHENEY: I think it goes to Senator Edwards. IFILL: It goes to the Senator. I see you. I just asked him about Israel, even though we didn't actually talk about it much. CHENEY: I concede the point. (LAUGHTER) EDWARDS: No, I did talk about it, Israel. He's the one who didn't talk about it. IFILL: Mr. Vice President, the Census Bureau ranked Cleveland as the biggest poor city in the country, 31 percent jobless rate. You two gentlemen are pretty well off. You did well for yourselves in the private sector. What can you tell the people of Cleveland, or people of cities like Cleveland, that your administration will do to better their lives? CHENEY: Well, Gwen, there are several things that I think need to be done and are being done. We've, of course, been through a difficult recession, and then the aftermath of 9/11, where we lost over a million jobs after that attack. But we think the key is to address some basic, fundamental issues that the president's already working on. I think probably the most successful thing we can do with respect to ending poverty is to get people jobs. There's no better antidote to poverty than a good, well-paying job that allows somebody to take care of their own family. To do that, we have to make America the best place in the world to do business. And that means we've got to deal effectively with tax policy. We've got to reduce the litigation costs that are built into our society. We've got to provide the adequate medical care and make certain that we can, in fact, create the opportunities that are vital to that process. I'd zero in, in particular, on education. I think the most important thing we can do is have a first-class public school system. I'm a product of public schools. And the president, his first legislative priority was the No Child Left Behind Act. It was the first piece of legislation we introduced. We got it passed that first summer on a bipartisan basis. We even had Ted Kennedy on board for the effort. And it does several things. It establishes high standards. It, at the same time, sets up a system of testing with respect to our school system, so we can establish accountability to parents and make certain that they understand how well their students are doing. And they have the opportunity to move students out of poorly performing schools to good schools. It strikes me that that is absolutely the heart of what needs to be done from the standpoint of education. It's also important, as we go forward in the next term, we want to be able to take what we've done for elementary education and move it into the secondary education. It's working. We've seen reports now of a reduction in the achievement gap between majority students and minority students. We're making significant progress. IFILL: Senator Edwards, you have 90 seconds. EDWARDS: Gwen, your question was about jobs? IFILL: It was about jobs, and it was about poverty. EDWARDS: I thought it was about jobs and poverty. I hope we get a chance to talk about education, but that's what the vice president talked about. Here's what's happened: In the time that they have been in office, in the last four years, 1.6 million private sector jobs have been lost, 2.7 million manufacturing jobs have been lost. And it's had real consequences in places like Cleveland. Cleveland is a wonderful, distinguished city that's done a lot of great things, but it has the highest poverty rate in the country. One out of almost two children in Cleveland are now living in poverty. During the time that the vice president and the president have been in office, 4 million more Americans have fallen into poverty. During the time that the vice president and the president have been in office, 4 million more Americans have fallen into poverty. And what the most striking and startling thing is, they are the first presidency in 70 years -- and I'm talking Democrats, Republican, presidents who led us through World War, through the Korean War, the Vietnam War, Cold War -- every one of them created jobs until this president. We have to do better. We have a plan. We're going to get rid of -- by the way, they're for outsourcing jobs. I want to make sure people hear that, the fundamental difference with us. The administration says over and over that the outsourcing of millions of American jobs is good. We're against it. We want to get rid of tax cuts for companies sending jobs overseas. We want to balance this budget, get back to fiscal responsibility. And we want to invest in the creative, innovative jobs of the future. IFILL: Mr. Vice President? CHENEY: Gwen, we've got 111 million American taxpayers that have benefited from our income tax cuts. We've got 33 million students who've benefited from No Child Left Behind. We've got 40 million seniors who benefited from the reform of the Medicare system. The Democrats promised prescription drug benefits. For years they've run on that platform. They never got it done. The president got it done. We also dropped 5 million people totally off the federal income tax rolls, so they no longer have to pay any federal income tax at all. So the story, I think, is a good one. And the data he's using is old data. It's from 2003. It doesn't include any of the gains that we've made in the last years. We've added 1.7 million jobs to the economy. IFILL: Thirty seconds. EDWARDS: The vice president and president like to talk about their experience on the campaign trail. Millions of people have lost their jobs. Millions have fallen into poverty. Family incomes are down, while the cost of everything is going up. Medical costs are up the highest they've ever been over the last four years. We have this mess in Iraq. Mr. Vice President, I don't think the country can take four more years of this kind of experience. IFILL: This next question goes to you, Senator Edwards. Senator Kerry said in a recent interview that he absolutely will not raise taxes on anyone under -- who earns under $200,000 a year. How can he guarantee that and also cut the deficit in half, as he's promised? EDWARDS: Because we will do what they've not done. You know, if you look at what's happened over the last four years, we have gone from a $5 trillion projected surplus when George Bush took office to a $3 trillion projected deficit. They promised they were going to put $2 trillion of the surplus aside from Social Security. Not done. Not only that, it's the biggest fiscal turnaround in American history. And there's no end in sight. The Washington Post just reported they have several trillion dollars of additional tax cuts and spending, no suggestion of what they're going to do about it. John Kerry and I believe we have a moral responsibility not to leave trillions of debt to our children and our grandchildren. So here's what we're going to do, to answer you question. To pay for the things that we believe need to be done -- and I hope to get the chance to talk about health care and also about education, because we have plans on both of those subjects -- what we're going to do is roll back tax cuts. And I want everyone to hear this, because there have been exaggerations made on the campaign trail: Roll back tax cuts for people who make over $200,000 a year; we will do that. We want to keep the tax cuts that are in place for people who make less than $200,000 a year and give additional tax cuts to those middle-class families, tax cuts for health care, tax cuts to help families pay for their college tuition, tax cuts for child care. These families are struggling and hurting, and they need more tax relief, not less tax relief. But to help get us back on the path to a balanced budget, we also want to get rid of some of the bureaucratic spending in Washington. One of the amazing things that's happened is they've actually layered on more supervisory people, people at the supervisory level, in this government. We also want to close some corporate loopholes. Now, I want to be honest with people. We can't eliminate this deficit. People have heard that over and over and over in four years. We cannot do it. We're in too deep a hole. But we can cut the deficit in half. And if we move, we can move this country back on a path to fiscal responsibility. IFILL: You have 90 seconds, Mr. Vice President. CHENEY: Gwen, the Kerry record on taxes is one basically of voting for a large number of tax increases -- 98 times in the United States Senate. There's a fundamental philosophical difference here between the president and myself, who believe that we ought to let the American people keep more of what they earn and we ought to empower them to have more control over their own lives -- I think the Kerry-Edwards approach basically is to raise taxes and to give government more control over the lives of individual citizens. We think that's the wrong way to go. There's a fundamental difference of opinion here. They talk about the top bracket and going after only those people in the top bracket. Well, the fact of the matter is a great many of our small businesses pay taxes under the personal income taxes rather than the corporate rate. And about 900,000 small businesses will be hit if you do, in fact, do what they want to do with the top bracket. That's not smart because seven out of 10 new jobs in America are created by small businesses. You do not want to tax them. It's a bad idea to increase the burden on those folks. The senator himself said, during the course of the primaries, that the Kerry plan would drive us deeper into deficit. Those were the senator's word about his running-mate. The fact of the matter is, the president and I will go forward to make the tax cuts permanent. That's good policy. That's what we ought to do. But with fiscal restraint, we'll also drive the deficit down 50 percent in the course of the next five years. IFILL: Thirty seconds, Senator Edwards. EDWARDS: We are committed to cutting back anything in our programs that need to be cut back to get us back on a path to fiscal responsibility. John Kerry, Mr. Vice President, has voted or co-sponsored over 600 times tax cuts for the American people -- over 600 times. And there is a philosophical difference between us and them. We are for more tax cuts for the middle class than they're for, have been for the last four years. But we are not for more tax cuts for multimillionaires. They are. And it is a fundamental difference in what we think needs to be done in this country. IFILL: You have 30 seconds, Mr. Vice President. CHENEY: Yesterday, the president signed an extension of middle- class tax cuts, the 10 percent bracket, the marriage penalty relief and the increase in the child tax credit. Senators Kerry and Edwards weren't even there to vote for it when it came to final passage. IFILL: The next question goes to you, Mr. Vice President. I want to read something you said four years ago at this very setting: "Freedom means freedom for everybody." You said it again recently when you were asked about legalizing same-sex unions. And you used your family's experience as a context for your remarks. Can you describe then your administration's support for a constitutional ban on same-sex unions? CHENEY: Gwen, you're right, four years ago in this debate, the subject came up. And I said then and I believe today that freedom does mean freedom for everybody. People ought to be free to choose any arrangement they want. It's really no one else's business. That's a separate question from the issue of whether or not government should sanction or approve or give some sort of authorization, if you will, to these relationships. Traditionally, that's been an issue for the states. States have regulated marriage, if you will. That would be my preference. In effect, what's happened is that in recent months, especially in Massachusetts, but also in California, but in Massachusetts we had the Massachusetts Supreme Court direct the state of -- the legislature of Massachusetts to modify their constitution to allow gay marriage. And the fact is that the president felt that it was important to make it clear that that's the wrong way to go, as far as he's concerned. Now, he sets the policy for this administration, and I support the president. IFILL: Senator Edwards, 90 seconds. EDWARDS: Yes. Let me say first, on an issue that the vice president said in his last answer before we got to this question, talking about tax policy, the country needs to know that under what they have put in place and want to put in place, a millionaire sitting by their swimming pool, collecting their statements to see how much money they're making, make their money from dividends, pays a lower tax rate than the men and women who are receiving paychecks for serving on the ground in Iraq. Now, they may think that's right. John Kerry and I do not. We don't just value wealth, which they do. We value work in this country. And it is a fundamental value difference between them and us. Now, as to this question, let me say first that I think the vice president and his wife love their daughter. I think they love her very much. And you can't have anything but respect for the fact that they're willing to talk about the fact that they have a gay daughter, the fact that they embrace her. It's a wonderful thing. And there are millions of parents like that who love their children, who want their children to be happy. And I believe that marriage is between a man and a woman, and so does John Kerry. I also believe that there should be partnership benefits for gay and lesbian couples in long-term, committed relationships. But we should not use the Constitution to divide this country. No state for the last 200 years has ever had to recognize another state's marriage. This is using the Constitution as a political tool, and it's wrong. IFILL: New question, but same subject. As the vice president mentioned, John Kerry comes from the state of Massachusetts, which has taken as big a step as any state in the union to legalize gay marriage. Yet both you and Senator Kerry say you oppose it. Are you trying to have it both ways? EDWARDS: No. I think we've both said the same thing all along. We both believe that -- and this goes onto the end of what I just talked about -- we both believe that marriage is between a man and a woman. But we also believe that gay and lesbians and gay and lesbian couples, those who have been in long-term relationships, deserve to be treated respectfully, they deserve to have benefits. For example, a gay couple now has a very difficult time, one, visiting the other when they're in the hospital, or, for example, if, heaven forbid, one of them were to pass away, they have trouble even arranging the funeral. I mean, those are not the kind of things that John Kerry and I believe in. I suspect the vice president himself does not believe in that. But we don't -- we do believe that marriage should be between a man and a woman. And I want to go back, if I can, to the question you just asked, which is this constitutional amendment. I want to make sure people understand that the president is proposing a constitutional amendment to ban gay marriage that is completely unnecessary. Under the law of this country for the last 200 years, no state has been required to recognize another state's marriage. Let me just be simple about this. My state of North Carolina would not be required to recognize a marriage from Massachusetts, which you just asked about. There is absolutely no purpose in the law and in reality for this amendment. It's nothing but a political tool. And it's being used in an effort to divide this country on an issue that we should not be dividing America on. We ought to be talking about issues like health care and jobs and what's happening in Iraq, not using an issue to divide this country in a way that's solely for political purposes. It's wrong. IFILL: Mr. Vice President, you have 90 seconds. CHENEY: Well, Gwen, let me simply thank the senator for the kind words he said about my family and our daughter. I appreciate that very much. IFILL: That's it? CHENEY: That's it. IFILL: OK, then we'll move on to the next question. This one is for you, Mr. Vice President. President Bush has derided in John Kerry for putting a trial lawyer on the ticket. You yourself have said that lawsuits are partly to blame for higher medical costs. Are you willing to say that John Edwards, sitting here, has been part of the problem? (LAUGHTER) CHENEY: Well, Gwen... IFILL: Mr. Vice President? (LAUGHTER) CHENEY: First of all, I'm not familiar with his cases. My concern is specifically with what's happened to our medical care system because of rising malpractice insurance rates, because we failed to adequately reform our medical liability structure. I was in New Mexico the other day and met with a group of OB/GYN docs. And they were deeply concerned because they were fearful that there'd be another increase in malpractice insurance rates as a result of what they believe are frivolous lawsuits and that that would put them out of business. And one doctor indicated that her rates have gone up so much that she's now to the point where she is screening patients. She won't take high-risk patients anymore because of the danger that that will generate a lawsuit, and a lawsuit will put her out of business. This has had a devastating impact in a lot of communities. My home state of Wyoming, we've lost the top insurer of malpractice insurance in the state. The rates for a general practitioner have gone from $40,000 a year to $100,000 a year for an insurance policy. We think this has a devastating impact on the quality of health care. As I say, high risk patients don't get covered anymore. We've lost one out of eleven OB/GYN practitioners in the country. We think it can be fixed, needs to be fixed. Now, specifically, what we need to do is cap non-economic damages, and we also think you need to limit the awards that the trial attorneys take out of all of this. Over 50 percent of the settlements go to the attorneys and for administrating overhead. We passed medical liability reform through the House of Representatives. It's been blocked in the Senate. Senator Kerry's voted 10 times against medical liability reform, and I don't believe Senator Edwards supports it, either, not the kind that would be meaningful. IFILL: Senator Edwards? EDWARDS: Yes. Well let me say, first of all, I'm proud of the work I did on behalf of kids and families against big insurance companies, big drug companies and big HMOs. We do have too many lawsuits. And the reality is there's something that we can do about it. John Kerry and I have a plan to do something about it. We want to put more responsibility on the lawyers to require, before a case, malpractice, which the vice president just spoke about, have the case reviewed by independent experts to determine if the case is serious and meritorious before it can be filed; hold the lawyers responsible for that, certify that and hold the lawyer financially responsible if they don't do it; have a three-strikes-and-you're-out rule so that a lawyer who files three of these cases without meeting this requirement loses their right to file these cases. That way we keep the cases out of the system that don't belong in the system. They talk about frivolous cases. We believe cases that don't belong in the system should never be in the system. But we don't believe that we should take away the right of people like Valerie Lakey, who was the young girl who I represented, five years old, severely injured for life, on a defective swimming pool drain cover. It turns out the company knew of 12 other children who had either been killed or severely injured by the same problem. They hid it. They didn't tell anybody. They could have fixed it with a 2-cent screw. That's wrong. John Kerry and I are always going to stand with the Valerie Lakeys of the world, and not with the insurance companies. IFILL: Senator Edwards, new question to you, same topic. Do you feel personally attacked when Vice President Cheney talks about liability reform and tort reform and the president talks about having a trial lawyer on the ticket? EDWARDS: Am I personally attacked? I think the truth is that what they're doing is talking about an issue that really doesn't have a great deal to do with what's happening with medical policy in this country, which I think is a very serious issue. And I would be the first to say that what the vice president described a few minutes ago, problems with malpractice premiums, that's true, it's real. It's very real. What doctors talk about is very serious. And they're getting squeezed from both sides. I mean, because, they have trouble getting reimbursed, first of all, for the care that they provide, you know, from the government or from health-care companies. And, on the flip side, their malpractice costs are going up. That's very real, which is why we have proposed a plan to keep cases out of the system that don't belong there. But it's very important to put this in context. Because, in context, everything they're proposing, according to the bipartisan Congressional Budget Office, amounts to about half of 1 percent of health-care costs in this country -- half of 1 percent. We have double-digit inflation in health care costs. We've seen the largest rise in medical costs in the last four years in the country's history: $3,500 nationally. And nobody who's watching this debate needs me to explain this to them. They know it. Medicare premiums are up 17 percent on their watch. Again, largest increase in Medicare premiums in the history of Medicare. We think we have a plan to keep cases that don't belong in the system out, but we also do what they haven't done. Five million Americans have lost their health care coverage. Medical costs are skyrocketing. We have a serious health care plan to bring down costs for everybody, to cover millions more Americans and to actually stand up to drug companies and insurance companies which this administration has been unwilling to do. IFILL: Mr. Vice President? CHENEY: Gwen, we think lawsuit abuse is a serious problem in this country. We think we badly need tort reform. I was in Minnesota the other day, where I visited an aircraft manufacturing plant. It's a great success story. This is a company that started 20 years ago with nothing. Today they're the second- leading producer of piston-driven aircraft in the country. He told me that if it weren't for the increased cost of his liability insurance, in this case product liability, he could hire 200 more people in his factory. We've built into the system enormous costs as a result of our practice with respect to litigation. We have to find ways to get a handle on it. He mentioned Medicare up 17 percent, somehow that that was something we caused. No. The 17 percent increase in Medicare premiums was the direct result of a statute adopted in 1997. John Kerry voted for it. It establishes the formula for Part B of Medicare that says, in effect, it has to cover 25 percent of the cost of the program. And the reason the money had to go into the trust fund was to make certain that we could cover those eligible for benefits. While you were in private practice in law and as a senator, you had the advantage of a special tax loophole, Subchapter S corporation, which you set up so you could avoid paying $600,000 in Medicare taxes that would have gone into the fund. And it's those kinds of loopholes that necessitate a premium increase under the law that was enacted in 1997, supported by John Kerry. IFILL: You have 30 seconds to respond. EDWARDS: Well, first of all, I have paid all the taxes that I owe. When the vice president was CEO of Halliburton, they took advantage of every offshore loophole available. They had multiple offshore companies that were avoiding taxes. Those are the kind of things that ought to be closed. They ought to be closed. They ought to be closed for anybody. They ought to be closed whether they're personal, and they ought to be closed whether they apply to a corporation. But the reality is health care costs are going up every day for the American people, and I hope we're going to get a chance to talk more about health care. IFILL: Thirty seconds, Mr. Vice President. CHENEY: We've done a lot to reduce the cost of health care. The Medicare drug benefit that we'll be providing to seniors beginning in '06 will provide upwards to $1,300 a year to help them buy prescription drugs. The drug savings -- drug discount card that's now available saves an estimated 15 percent to 30 percent off the cost of prescription drugs for senior citizens. So we're moving in as many areas as we can to make certain we hold down and reduce the health care costs. IFILL: I will talk to you about health care, Mr. Vice President. You have two minutes. But in particular, I want to talk to you about AIDS, and not about AIDS in China or Africa, but AIDS right here in this country, where black women between the ages of 25 and 44 are 13 times more likely to die of the disease than their counterparts. What should the government's role be in helping to end the growth of this epidemic? CHENEY: Well, this is a great tragedy, Gwen, when you think about the enormous cost here in the United States and around the world of the AIDS epidemic -- pandemic, really. Millions of lives lost, millions more infected and facing a very bleak future. In some parts of the world, we've got the entire, sort of, productive generation has been eliminated as a result of AIDS, all except for old folks and kids -- nobody to do the basic work that runs an economy. The president has been deeply concerned about it. He has moved and proposed and gotten through the Congress authorization for $15 billion to help in the international effort, to be targeted in those places where we need to do everything we can, through a combination of education as well as providing the kinds of medicines that will help people control the infection. Here in the United States, we've made significant progress. I have not heard those numbers with respect to African- American women. I was not aware that it was -- that they're in epidemic there, because we have made progress in terms of the overall rate of AIDS infection, and I think primarily through a combination of education and public awareness as well as the development, as a result of research, of drugs that allow people to live longer lives even though they are infected -- obviously we need to do more of that. IFILL: Senator Edwards, you have 90 seconds. EDWARDS: Well, first, with respect to what's happening in Africa and Russia and in other places around the world, the vice president spoke about the $15 billion for AIDS. John Kerry and I believe that needs to be doubled. And I might add, on the first year of their commitment, they came up significantly short of what they had promised. And we probably won't get a chance to talk about Africa. Let me just say a couple of things. The AIDS epidemic in Africa, which is killing millions and millions of people and is a frightening thing not just for the people of Africa but also for the rest of the world, that, combined with the genocide that we're now seeing in Sudan, are two huge moral issues for the United States of America, which John Kerry spoke about eloquently last Thursday night. Here at home we need to do much more. And the vice president spoke about doing research, making sure we have the drugs available, making sure that we do everything possible to have prevention. But it's a bigger question than that. You know, we have 5 million Americans who've lost their health care coverage in the last four years; 45 million Americans without health care coverage. We have children who don't have health care coverage. If kids and adults don't have access to preventative care, if they're not getting the health care that they need day after day after day, the possibility of not only developing AIDS and having a problem -- having a problem -- a life-threatening problem, but the problem of developing other life-threatening diseases is there every day of their lives. IFILL: OK, we'll move on. This goes to you, Senator Edwards, and you have two minutes. Ten men and women have been nominees of their parties since 1976 to be vice president. Out of those ten, you have the least governmental experience of any of them. What qualifies you to be a heartbeat away? EDWARDS: The American people want in their president and in their vice president basically three things: They want to know that their president and their vice president will keep them safe. They want to know that they have good judgment. And they want to know that you'll tell them the truth. John Kerry and I will tell the American people the truth. During the time that I have served on the Intelligence Committee in the Senate, traveling to some of the places we've talked about tonight -- Afghanistan, Pakistan, the Middle East, Turkey -- meeting with the leaders of NATO, I have a very clear idea of what has to be done to keep this country safe. The threats we face: terrorism, killing terrorists and stopping them before they can do damage to us, making sure that we stop the spread of nuclear weapons. I agree with John Kerry from Thursday night, that the danger of nuclear weapons getting in the hands of terrorists is one of the greatest threats that America faces. But the one thing that we know from this administration is -- and I -- first of all, I don't claim to have the long political resume that Vice President Cheney has. That's just the truth, and the American people know that and deserve to know it. But what we know from this administration is that a long resume does not equal good judgment. Here are the judgments I would make: My first priority would be to keep this country safe. I would find terrorists where they are and stop them and kill them before they do harm to us. We would stop the spread of nuclear weapons. And we would also strengthen this military, which means providing the equipment and training that they need. We want to raise the active-duty forces by 40,000, double the special forces so we can find terrorists where they are, and provide the kind of support for families -- health care, housing -- that they deserve while their loved ones are serving and protecting us. IFILL: Mr. Vice President, you have 90 seconds. CHENEY: You want me to answer a question about his qualifications? IFILL: That was the question. CHENEY: I see. Well, I think the important thing in picking a vice president probably varies from president to president. Different presidents approach it in different ways. When George Bush asked me to sign on, it obviously wasn't because he was worried about carrying Wyoming. We got 70 percent of the vote in Wyoming, although those three electoral votes turned out to be pretty important last time around. What he said he wanted me to do was to sign on because of my experience to be a member of the team, to help him govern, and that's exactly the way he's used me. And I think from the perspective of the nation, it's worked in our relationship, in this administration. I think it's worked in part because I made it clear that I don't have any further political aspirations myself. And I think that's been an advantage. I think it allows the president to know that my only agenda is his agenda. I'm not worried about what some precinct committeemen in Iowa were thinking of me with respect to the next round of caucuses of 2008. It's a very significant responsibility when you consider that at a moment's notice you may have to take over as president of the United States and make all of those decisions. It's happened several times in our history. And I think that probably is the most important consideration in picking a vice president, somebody who could take over. IFILL: You have 30 seconds, if you'd like to respond to that. EDWARDS: I think the most important thing I've learned from this process is what I now know about John Kerry. I knew him before. I know him better now. He's the one candidate who's led troops in battle. He was a prosecutor, putting people behind bars to protect neighborhoods from crime. He fought for 100,000 cops on the street, and went with John McCain to Vietnam to find out what happened to our POWs. And the American people saw for themselves on Thursday night the strength, resolve, and backbone that I, myself, have seen in John Kerry. He is ready to be commander in chief. IFILL: Mr. Vice President, you have 30 seconds to respond. CHENEY: Well, I clearly believe that George W. Bush would be a better commander in chief. He's already done it for four years. And he's demonstrated, without question, the conviction, the vision, the determination to win this war against terror. He understands it's a global conflict that reaches from the United States all the way around the globe to Jakarta. And those very special qualities are vital in a commander in chief. And I think the president has them, and I'm not at all convinced his opponent does. IFILL: Mr. Vice President, picking up on that, you both just sang the praises of the tops of your ticket. Without mentioning them by name at all, explain to us why you are different from your opponent, starting with you, Mr. Vice President. CHENEY: Why I am different from John Edwards. Well, in some respects, I think, probably there are more similarities than there are differences in our personal story. I don't talk about myself very much, but I've heard Senator Edwards, and as I listen to him, I find some similarities. I come from relatively modest circumstances. My grandfather never even went to high school. I'm the first in my family to graduate from college. I carried a ticket in the International Brotherhood of Electrical Workers for six years. I've been laid off, been hospitalized without health insurance. So I have some idea of the problems that people encounter. So I think the personal stories are, in some respects, surprisingly similar. With respect to how we've spent our careers, I obviously made a choice for public service. And I've been at it for a good long time now, except for those periods when we lost elections. And that goes with the turf, as well, too. I'm absolutely convinced that the threat we face now, the idea of a terrorist in the middle of one of our cities with a nuclear weapon, is very real and that we have to use extraordinary measures to deal with it. I feel very strongly that the significance of 9/11 cannot be underestimated. It forces us to think in new ways about strategy, about national security, about how we structure our forces and about how we use U.S. military power. Some people say we should wait until we are attacked before we use force. I would argue we've already been attacked. We lost more people on 9/11 than we lost at Pearl Harbor. And I'm a very strong advocate of a very aggressive policy of going after the terrorists and those who support terror. IFILL: Senator Edwards, you have 90 seconds. EDWARDS: Mr. Vice President, we were attacked. But we weren't attacked by Saddam Hussein. And one thing that John Kerry and I would agree with you about is that it is... IFILL: You just used John Kerry's name. EDWARDS: Oh, I'm sorry. I broke the rule. One thing that we agree about is the need to be offensive in going after terrorists. The reality is that the best defense is a good offense, which means leading -- America returning to its proud tradition of the last 75 years, of once again leading strong coalitions so we can get at these terrorist cells where they are, before they can do damage to us and to the American people. John Kerry made clear on Thursday night that -- I'm sorry, I broke the rules. We made clear -- we made clear on Thursday night that we will do that, and we will do it aggressively. But there are things that need to be done to keep this country safe that have not yet been done. For example, three years after 9/11, we find out that the administration still does not have a unified terrorist watch list. It's amazing. Three years. What are we waiting for? You know, we still don't have one list that everyone can work off of to see if terrorists are entering this country. We're screening our passengers going onto airplanes, but we don't screen the cargo. There are so many things that could be done to keep this country safe. You have to be strong, and you have to be aggressive. But we also have to be smart. And there are things that have not been done that need to be done to keep the American people safe. IFILL: Would you like to respond? Thirty seconds. CHENEY: No. IFILL: OK, we'll move on. This goes to Senator Edwards. Flip-flopping has become a recurring theme in this campaign, you may have noticed. Senator Kerry changed his mind about whether to vote to authorize the president to go to war. President Bush changed his mind about whether a homeland security department was a good idea or a 9/11 Commission was a good idea. What's wrong with a little flip-flop every now and then? EDWARDS: Well, first of all, let me say that John Kerry has -- I can use his name now? IFILL: Yes. EDWARDS: OK. John Kerry has been, as have I, been completely consistent about Iraq. We've made very clear from the beginning -- and not an afterthought; we said it at the time -- that we had to confront Saddam Hussein and that we had to have a coalition and a plan to be successful. And the vice president didn't say much about it in your earlier question, but Paul Bremer has now made clear that they didn't have enough troops and they didn't have a plan. And the American people are seeing the results of that every single day, in spite of the proud and courageous service of our men and women in uniform. Now, flip-flops: They should know something about flip-flops. They've seen a lot of it during their administration. They were first against the 9/11 Commission; then they were for it. They were for a department of homeland security -- I mean, they were against the Department of Homeland Security; then they were for it. They said they were going to put $2 trillion of the surplus when they came into office aside to protect Social Security; then they changed their minds. They said that they supported the troops; and then while our troops were on the ground in Iraq and Afghanistan, they went to the Congress and lobbied to have their combat pay cut. They said that they were going to do something about health care in this country. And they've done something: They've made it worse. They said that they were going to fund their No Child Left Behind; $27 billion short today. Over and over, this administration has said one thing and done another. This president said -- I listened to him the other night at his 2000 debate saying: I'm for a national patients bill of rights. I know something about this. John McCain and Senator Kennedy and I wrote it, got it passed in the Senate. We don't have a patients bill of rights because of one man today, the president of the United States. They've gone back and forth. IFILL: Mr. Vice President? CHENEY: Well, Gwen, I can think of a lot of words to describe Senator Kerry's position on Iraq; "consistent" is not one of them. I think if you look at the record from voting for sending the troops then voting against the resources they needed when they got there, then saying I actually voted for the $87 billion before I voted against it, saying in response to a question knowing everything I know now, yes, I would have cast exactly the same vote and then shortly after that saying wrong war, wrong place, wrong time, consistency doesn't come to mind as I consider that record. The question of troops is an interesting and important one. We have looked to our commanders on the ground in Iraq for guidance on what they think they need. If they need more troops, they'll ask us. But the key here is not to try to solve the problems in Iraq by putting in more American troops. The key is to get the Iraqis to take on the responsibility for their own security. That's exactly what we're doing. If you put American troops in there in larger number and don't get the Iraqis into the fight, you'll postpone the day when you can in fact bring our boys home. It's vital that we deal with any need for additional troops by putting Iraqis into the effort. Forty-nine percent increase in funding for elementary and secondary education under No Child Left Behind; that's a lot of money even by Massachusetts' standards. IFILL: You have 30 seconds if you choose. EDWARDS: Yes, but they didn't fund the mandates that they put on the schools all over this country. That's the reason 800 teachers -- one of the reasons -- 800 teachers have been laid off, right here in Cleveland. One-third of our public schools are failing under this administration. Half of African-Americans are dropping out of high school. Half of Hispanic-American are dropping out of high school. John and I have -- and I don't have the time now -- but we have a clear plan to improve our public schools that starts with getting our best teachers into the schools where we need them the most by creating incentives for them to go there. IFILL: Mr. Vice President? CHENEY: Gwen, No Child Left Behind, they were for it; now they're against it. They voted for it; now they're opposed to it. We are making significant progress there. We are closing the achievement gap. The results coming in from a number of studies show, without question, that on math and reading, that in fact our minority students, our Hispanic and African-American students are doing better, and that gap between them and the majority population is, in fact, closing. So we are doing exactly the right thing. They're the ones who have been for the Patriot Act and against it, for No Child Left Behind and then against it. IFILL: Mr. Vice President, our final -- I'm sorry, you have 30 seconds, Senator Edwards. EDWARDS: Are you sure -- yes, he started. Yes, 30 seconds, please, yes. We are for accountability, and we are for high standards. John and I voted for No Child Left Behind because we thought that accountability and standards were the right thing to do. But they make -- did you figure out you were wrong? IFILL: I did figure out I was wrong. EDWARDS: Well, in fairness, if you feel like you need to go to him, we'll -- I'll stop. IFILL: Well, I do, because we're actually on the final question. I apologize for giving you an extra 15 seconds there. I go now to Vice President Cheney. Whichever one of you is elected in November -- you mentioned those three electoral votes in Wyoming and how critical they've turned out to be. But what they're a sign of also is that you're going to inherit a very deeply divided electorate, economically, politically, you name it. How will you set out, Mr. Vice President, in a way that you weren't able to in these past four years, to bridge that divide? CHENEY: Well, I must say it's one of the disappointments of the last four years, is that we've not been able to do what the president did in Texas, for example, when he was able to reach across the aisle and bring Democrats along on major issues of the day. We had some success early on, I think, in No Child Left Behind, when we, in fact, had broad, bipartisan support. We had a lot of support for the Patriot Act, when we passed that on a bipartisan basis. Now we're seeing objection to that by the other side. All I know is to continue to try to work it. It's a disappointment, in a sense, that I remember from my earlier service when things worked much differently, when, in fact, some of my best friends in the Congress were people I worked with, like Tom Foley, who was a majority leader and later speaker of the House. One of my strongest allies in Congress when I secretary of defense was Jack Murtha, a Democrat who is chairman of the Defense Appropriations Subcommittee. We used to be able to do more together on a bipartisan basis than seems possible these days. I'm not sure exactly why. I think, in part, it may be the change in the majority-minority status in the Senate has been difficult for both sides to adjust to. And the Senate, of course, has been very evenly divided, 50-50, then 51-49, then 49-51 the other way. We'll keep working at it. I think it's important for us to try. I believe that it is essential for us to do everything we can to garner as much support from the other side of the aisle as possible. We've had support -- we had our keynote address at our convention was delivered by Zell Miller. So there are some Democrats who agree with our approach. And hopefully in a second term, we'll see an improvement along those lines. IFILL: Senator, there's 90 seconds. EDWARDS: Thank you. The president said that he would unite this country, that he was a uniter, not a divider. Have you ever seen America more divided? Have you ever seen Washington more divided? The reality is it is not an accident. It's the direct result of the choices they've made and their efforts that have created division in America. We can do better than that in this country. Now I want to go back to the whole issue of health care, because we touched it, but I think the American people deserve to know what we would do different. I mean, 5 million people losing their health care -- everyone who's watching this knows health insurance premiums are through the roof. We need to talk about what we will do that they haven't done. First, we're going to make the same health care that's available to members of Congress available to all Americans. We're going to cover all kids. Not only that, we're going to bring down costs by pooling the catastrophic costs so we bring down premiums. And we're going to give tax breaks directly to families, save them up to $1,000 a year, and to businesses -- the vice president talked about that a few minutes ago -- so that they can provide health care to their employees. And we're also going to finally do something about the cost of prescription drugs. They've blocked allowing prescription drugs into this country from Canada. We're going to allow it. They would not allow the government to use its negotiating power to get discounts for seniors. We're going to allow it. We're also going to stand up to the drug companies and do something about these drug company ads on television which are out of control. IFILL: You have 30 seconds to respond to that, Mr. Vice President. CHENEY: Well, Gwen -- I'm sorry, it's hard to know where to start. The fact of the matter is, the most important and significant change in health care in the last several years was the Medicare reform bill this year. It's the most sweeping change in 40 years. Medicare used to pay for heart bypass surgery but didn't pay for the prescription drugs that might allow you to avoid it. The fact is that when that came up, Senator Kerry and Senator Edwards voted against it. It'll provide prescription drug benefits to 40 million senior citizens. It's a very, very significant piece of legislation. IFILL: Thirty seconds. EDWARDS: They had a choice on allowing prescription drugs into this country from Canada, of being with the American people or with the drug companies. They were with the drug companies. They had a choice on negotiating discounts in the Medicare prescription drug bill of being with the American people or with the drug companies. They were with the drug companies. They had a choice on the patients' bill of rights, allowing people to make their own health care decisions and not having insurance companies make them, be with the American people, be with the big insurance companies. They're with the insurance companies. John Kerry and I will always fight for the American people. IFILL: As previously agreed, we'll go to closing statements now, two minutes each. Coin toss, Senator Edwards, you begin. EDWARDS: Thank you. Thank you, Gwen. Thank you, Mr. Vice President, for being here. You know, when I was young and growing up, I remember coming down the steps into the kitchen, early in the morning, and I would see the glow of the television. And I'd see my father sitting at a table. He wasn't paying bills, and he wasn't doing paperwork from work. What he was doing was learning math on television. Now, he didn't have a college education, but he was doing what he could do to get a better job in the mill where he worked. I was proud of him. I'm still proud of him. And I was also hopeful, because I knew that I lived in a country where I could get a college education. Here's the truth: I have grown up in the bright light of America. But that light is flickering today. Now, I know that the vice president and the president don't see it, but you do. You see it when your incomes are going down and the cost of everything -- college tuition, health care -- is going through the roof. You see it when you sit at your table each night and there's an empty chair because a loved one is serving in Iraq or Afghanistan. What they're going to give you is four more years of the same. John Kerry and I believe that we can do better. We believe in a strong middle-class in this country. That's why we have a plan to create jobs, getting rid of tax cuts for companies outsourcing your jobs; give tax cuts to companies that'll keep jobs here in America. That's why we have a health care plan. That's why we have a plan to keep you safe and to fix this mess in Iraq. The truth is that every four years you get to decide. You have the ability to decide where America's going to go. John Kerry and I are asking you to give us the power to fight for you, to fight to keep that dream in America, that I saw as a young man, alive for every parent sitting at that kitchen table. IFILL: Vice President Cheney? CHENEY: Gwen, I want to thank you. It's been a privilege to serve as your vice president these last four years and to work alongside President Bush to put our economy on an upward path. We've cut taxes, added 1.7 million new jobs in the last year, and we'll continue to provide opportunities for business and for workers. We won't be happy until every American who wants to work can find a job. We believe that all Americans ought to have access to available -- to medical care and that they ought to have access to the finest schools in the world. We'll do everything we can to preserve Social Security and to make certain that it's there for future generations. I've worked for four presidents and watched two others up close, and I know that there's no such thing as a routine day in the Oval Office. We saw on 9/11 that the next president -- next decision a president has to make can affect the lives of all of us. Now we find ourselves in the midst of a conflict unlike any we've ever known, faced with the possibility that terrorists could smuggle a deadly biological agent or a nuclear weapon into the middle of one of our own cities. That threat -- and the presidential leadership needed to deal with it -- is placing a special responsibility on all of you who will decide on November 2nd who will be our commander in chief. The only viable option for winning the war on terrorism is the one the president has chosen, to use the power of the United States to aggressively go after the terrorists wherever we find them and also to hold to account states that sponsor terror. Now that we've captured or killed thousands of Al Qaida and taken down the regimes of Saddam Hussein and the Taliban, it's important that we stand up democratically elected governments as the only guarantee that they'll never again revert to terrorism or the production of deadly weapons. This is the task of our generation. And I know firsthand the strength the president brings to it. The overall outcome will depend upon the ability of the American people and the strong leadership of the president to meet all the challenges that we'll face in the days and years ahead. I'm confident we can do it. IFILL: And with that, we come to the end of tonight's debate. On behalf of the commission and the candidates, I'd like to extend a special thank you to the students and administration here at Case Western Reserve University. A reminder: The second presidential debate takes place this coming Friday at Washington University in St. Louis, Missouri. Charles Gibson of ABC News will serve as moderator of that encounter, where the candidates will field questions from an audience. Then, on October 13th, from Arizona State University in Tempe, Arizona, Bob Schieffer of CBS News will moderate a debate on domestic issues. For now, thank you, Vice President Cheney, Senator Edwards. From Cleveland, Ohio, I'm Gwen Ifill. Thank you, and goodnight. (APPLAUSE)
