# Presidential Debate in Boston

**Date:** October 3, 2000
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-boston

---

MODERATOR: Good evening from the Clark Athletic Center at the University of Massachusetts in Boston. I'm Jim Lehrer of the NewsHour on PBS, and I welcome you to the first of three 90-minute debates between the Democratic candidate for president, Vice President Al Gore and the Republican candidate, Governor George W. Bush of Texas. The debates are sponsored by the Commission on Presidential Debates and they will be conducted within formats agreed to between the two campaigns. We'll have the candidates at podiums. No answer to a question can exceed two minutes. Rebuttal is limited to one minute. But as moderator I have the option to follow up and extend any give and take any three-and-a-half minutes. Even then, no single answer can exceed two minutes. The candidates under their rules may not question each other directly. There will be no opening statements, but each candidate may have up to two minutes for a closing statement. The questions and the subjects were chosen by me alone. I have told no one from the two campaigns, or the Commission, or anyone else involved what they are. There is a small audience in the hall tonight. They are not here to participate, only to listen. I have asked, and they have agreed, to remain silent for the next 90 minutes. Except for right now, when they will applaud as we welcome the two candidates, Governor Bush and Vice President Gore. (Applause) MODERATOR: And now the first question as determined by a flip of a coin, it goes to Vice President Gore. Vice President Gore, you have questioned whether Governor Bush has the experience to be President of the United States. What exactly do you mean? GORE: Well, Jim, first of all, I would like to thank the sponsors of this debate and the people of Boston for hosting the debate. I would like to thank Governor Bush for participating, and I would like to say I'm happy to be here with Tipper and our family. I have actually not questioned Governor Bush's experience. I have questioned his proposals. And here is why. I think this is a very important moment for our country. We have achieved extraordinary prosperity. And in this election, America has to make an important choice. Will we use our prosperity to enrich not just the few, but all of our families? I believe we have to make the right and responsible choices. If I'm entrusted with the presidency, here are the choices that I will make. I will balance the budget every year. I will pay down the national debt. I will put Medicare and Social Security in a lockbox and protect them. And I will cut taxes for middle-class families. I believe it's important to resist the temptation to squander our surplus. If we make the right choices, we can have a prosperity that endures and enriches all of our people. If I'm entrusted with the presidency, I will help parents and strengthen families because, you know, if we have prosperity that grows and grows, we still won't be successful unless we strengthen families by, for example, ensuring that children can always go to schools that are safe. By giving parents the tools to protect their children against cultural pollution. I will make sure that we invest in our country and our families. And I mean investing in education, health care, the environment, and middle-class tax cuts and retirement security. That is my agenda and that is why I think that it's not just a question of experience. MODERATOR: Governor Bush, one minute rebuttal. BUSH: Well, we do come from different places. I come from being a West Texas. The governor is the chief executive officer. We know how to set agendas as a governor. I think you'll find the difference reflected in our budgets. I want to take one-half of the surplus and dedicate it to Social Security. One-quarter of the surplus for important projects, and I want to send one-quarter of the surplus back to the people who pay the bills. I want everybody who pays taxes to have their tax rates cut. And that stands in contrast to my worthy opponent's plan, which will increase the size of government dramatically. His plan is three times larger than President Clinton's proposed plan eight years ago. It is a plan that will have 200 new programs -- expanded programs and creates 20,000 new bureaucrats. It it empowers Washington. My vision is to empower Americans to be able to make decisions for themselves in their own lives. MODERATOR: So I take it by your answer, then, Mr. Vice President, in an interview recently with the "New York Times" when you said that you questioned whether or not Governor Bush has experience enough to be president, you were talking about strictly policy differences. GORE: Yes, Jim. I said that his tax cut plan, for example, raises the question of whether it's the right choice for the country. And let me give you an example of what I mean. Under Governor Bush's tax cut proposal, he would spend more money on tax cuts for the wealthiest 1% than all of the new spending that he proposes for education, health care, prescription drug and national defense all combined. Now, I think those are the wrong priorities. Now, under my proposal, for every dollar that I propose in spending for things like education and health care, I will put another dollar into middle class tax cuts. And for every dollar that I spend in those two categories, I'll put $2 toward paying down the national debt. I think it's very important to keep the debt going down and completely eliminate it. And I also think it's very important to go to the next stage of welfare reform. Our country has cut the welfare rolls in half. I fought hard from my days in the Senate and as vice president to cut the welfare rolls and we've moved millions of people in America into good jobs. But it's now time for the next stage of welfare reform, and include fathers and not only mothers. MODERATOR: We're going to get a lot of those. BUSH: Let me just say that obviously tonight we're going to hear some phony numbers about what I think and what we ought to do. People need to know that over the next ten years it is going to be $25 trillion of revenue that comes into our Treasury and we anticipate spending $21 trillion. And my plan say why don't we pass 1.3 trillion of that back to the people who pay the bills? Surely we can afford 5% of the $25 trillion that are coming into the treasury to the hard working people that pay the bills. There is a difference of opinion. My opponent thinks the government -- the surplus is the government's money. That's not what I think. I think it's the hard-working people of America's money and I want to share some of that money with you so you have more money to build and save and dream for your families. It's a difference of opinion. It's a difference between government making decisions for you and you getting more of your money to make decisions for yourself. MODERATOR: Let me just follow up one quick question. When you hear Vice President Gore question your experience, do you read it the same way, that he's talking about policy differences only? BUSH: Yes. I take him for his word. Look, I fully recognize I'm not of Washington. I'm from Texas. And he's got a lot of experience, but so do I. And I've been the chief executive officer of the second biggest state in the union. I have a proud record of working with both Republicans and Democrats, which is what our nation needs. Somebody that can come to Washington and say let's forget all the finger pointing and get positive things done on Medicare, prescription drugs, Social Security, and so I take him for his word. GORE: Jim, if I could just respond. I know that. The governor used the phrase phony numbers, but if you look at the plan and add the numbers up, these numbers are correct. He spends more money for tax cuts for the wealthiest 1% than all of his new spending proposals for health care, prescription drug, education and national defense all combined. I agree that the surplus is the American people's money, it's your money. That's why I don't think we should give nearly half of it to the wealthiest 1%, because the other 99% have had an awful lot to do with building the surplus in our prosperity. MODERATOR: Three-and-a-half minutes is up. New question. Governor Bush, you have a question. This is a companion question to the question I asked Vice President Gore. You have questioned whether Vice President Gore has demonstrated the leadership qualities necessary to be President of the United States. What do you mean by that? BUSH: Actually what I've said, Jim. I've said that eight years ago they campaigned on prescription drugs for seniors. And four years ago they campaigned on getting prescription drugs for seniors. And now they're campaigning on getting prescription drugs for seniors. It seems like they can't get it done. Now, they may blame other folks, but it's time to get somebody in Washington who is going to work with both Republicans and Democrats to get some positive things done when it comes to our seniors. And so what I've said is that there's been some missed opportunities. They've had a chance. They've had a chance to form consensus. I've go a plan on Medicare, for example, that's a two-stage plan that says we'll have immediate help for seniors and what I call immediately Helping Hand, a $48 billion program. But I also want to say to seniors, if you're happy with Medicare the way it is, fine, you can stay in the program. But we're going to give you additional choices like they give federal employees in the federal employee health plan. They have a variety of choices to choose, so should seniors. And my point has been, as opposed to politicizing an issue like Medicare, in other words, holding it up hoping somebody bites it and try to clobber them over the head for political purposes, this year it's time to get it done once and for all. That's what I've been critical about the administration for. Same with Social Security. I think there was a good opportunity to bring Republicans and Democrats together to reform the Social Security system so seniors will never go without. Those on Social Security today will have their promise made, but also to give younger workers the option at their choice of being able to manage some of their own money in the private sector to make sure there's a Social Security system around tomorrow. There are a lot of young workers at our rallies we go to that when they hear I'll trust them at their option to be able to manage, under certain guidelines, some of their own money to get a better rate of return so that they'll have a retirement plan in the future, they begin to nod their heads and they want a different attitude in Washington. MODERATOR: One minute rebuttal. GORE: Well, Jim, under my plan all seniors will get prescription drugs under Medicare. The governor has described Medicare as a government HMO. It's not, and let me explain the difference. Under the Medicare prescription drug proposal I'm making, here is how it works, you go to your own doctor. Your doctor chooses your prescription. No HMO or insurance company can take those choices away from you. Then you go to your own pharmacy. You fill the prescription and Medicare pays half the cost. If you're in a very poor family or if you have very high costs, Medicare will pay all the costs, a $25 premium, and much better benefits than you can possibly find in the private sector. Now here is the contrast. 95% of all seniors would get no help whatsoever under my opponent's plan for the first four or five years. Now, one thing I don't understand, Jim, is why is it that the wealthiest 1% get their tax cuts the first year, but 95% of seniors have to wait four to five years before they get a single penny? BUSH: I guess my answer to that is the man is running on Medi-scare. Trying to frighten people into the voting booth. It's not what I think and it's not my intentions and not my plan. I want all seniors to have prescription drugs in Medicare. We need to reform Medicare. This administration has failed to do it. Seniors will have not only a Medicare plan where the poor seniors will have prescription drugs paid for, but there will be a variety of options. The current system today has meant a lot for a lot of seniors, and I really appreciate the intent of the current system. If you're happy with the system you can stay in it. There are a lot of procedures that haven't kept up in Medicare with the current times. No prescription drug benefits, no drug therapy, no preventative medicines, no vision care. We need to have a modern system to help seniors, and the idea of supporting a federally controlled 132,000-page document bureaucracy as being a compassionate way for seniors, and the only compassionate source of care for seniors is not my vision. We ought to give seniors more options. I believe we ought to make the system work better. I know this. I know it will require a different kind of leader to go to Washington to say to both Republicans and Democrats, let's come together. You've had your chance, Vice President, you've been there for eight years and nothing has been done. My point is, is that my plan not only trusts seniors with options, my plan sets aside $3.4 trillion for Medicare over the next ten years. My plan also says it requires a new approach in Washington, D.C. It's going to require somebody who can work across the partisan divide. GORE: If I could respond to that. Under my plan I will put Medicare in an iron clad lockbox and prevent the money from being used for anything other than Medicare. The governor has declined to endorse that idea even though the Republican as well as Democratic leaders in Congress have endorsed it. I would be interested to see if he would say this evening he'll put Medicare in a lockbox. $100 billion comes out of Medicare just for the wealthiest 1% in the tax cut. Now here is the difference. Some people who say the word reform actually mean cuts. Under the governor's plan, if you kept the same fee for service that you have now under Medicare, your premiums would go up by between 18% and 47%, and that is the study of the Congressional plan that he's modeled his proposal on by the Medicare actuaries. Let me give you one quick example. There is a man here tonight named George McKinney from Milwaukee. He's 70 years old, has high blood pressure, his wife has heart trouble. They have an income of $25,000 a year. They can't pay for their prescription drugs. They're some of the ones that go to Canada regularly in order to get their prescription drugs. Under my plan, half of their costs would be paid right away. Under Governor Bush's plan, they would get not one penny for four to five years and then they would be forced to go into an HMO or to an insurance company and ask them for coverage, but there would be no limit on the premiums or the deductibles or any of the terms and conditions. BUSH: I cannot let this go by, the old-style Washington politics, if we're going to scare you in the voting booth. Under my plan the man gets immediate help with prescription drugs. It's called Immediate Helping Hand. Instead of squabbling and finger pointing, he gets immediate help. Let me say something. MODERATOR: Your -- GORE: They get $25,000 a year income, that makes them ineligible. BUSH: Look, this is a man who has great numbers. He talks about numbers. I'm beginning to think not only did he invent the Internet, but he invented the calculator. It's fuzzy math. It's a scaring -- he's trying to scare people in the voting booth. Under my tax plan that he continues to criticize, I set one-third. The federal government should take no more than a third of anybody's check. But I also dropped the bottom rate from 15% to 10%. Because by far the vast majority of the help goes to people at the bottom end of the economic ladder. If you're a family of four in Massachusetts, making $50,000, you get a 50% cut in the federal income taxes you pay. It's from $4000 to about $2000. Now, the difference in our plans is I want that $2,000 to go to you, and the vice president would like to be spending the $2,000 on your behalf. MODERATOR: One quick thing, gentlemen. These are your rules. I'm doing my best. We're way over the three minutes. I have no problems with it. We're over the three-and-a-half. Do you want to have a quick response? We're almost to five minutes on this. GORE: It's just clear you can go to the website and look. If you make more than $25,000 a year you don't get a penny of help under the Bush prescription drug proposal for at least four to five years, and then you're pushed into a Medicare -- into an HMO or insurance company plan, and there's no limit on the premiums or the deductibles or any of the conditions. And the insurance companies say it won't work and they won't offer these plans. MODERATOR: Let me ask you both this and we'll move on on the subject. As a practical matter, both of you want to bring prescription drugs to seniors, correct? GORE: Correct. BUSH: Correct. GORE: The difference is I want to bring it to 100% and he wants to bring it to 5%. BUSH: That's totally false for him to stand up here and say that. Let me make sure the seniors hear me loud and clear. They have had their chance to get something done. I'm going to work with Democrats and Republicans to reform the system. All seniors will be covered, all seniors will have their prescription drugs paid for, and in the meantime, we'll have a plan to help poor seniors and in the meantime it could be one year or two years. GORE: Let me call your attention to the key word there. He said all poor seniors. BUSH: Wait a minute. All seniors are covered under prescription drugs in my plan. GORE: In the first year? BUSH: If we can get it done in the first year, you bet. GORE: It's a two-phase plan. For the first four years -- it takes a year to pass it and for the first four years only the poor are covered. Middle class seniors like George McKinney and his wife are not covered for four to five years. MODERATOR: I have an idea. If you have any more to say about this, you can say it in your closing statements and we'll move on, okay? New question. Vice President Gore. How would you contrast your approach to preventing future oil price and supply problems like we have now to the approach of Governor Bush? GORE: Excellent question. And here is the simple difference. My plan has not only a short-term component, but also a long-term component. And it focuses not only on increasing the supply, which I think we have to do, but also on working on the consumption side. Now, in the short-term we have to free ourselves from the domination of the big oil companies that have the ability to manipulate the price from OPEC when they want to raise the price. And in the long-term we have to give new incentives for the development of domestic resources like deep gas in the western Gulf, like stripper wells for oil, but also renewable sources of energy. And domestic sources that are cleaner and better. And I'm proposing a plan that will give tax credits and tax incentives for the rapid development of new kinds of cars and trucks and buses and factories and boilers and furnaces that don't have as much pollution, that don't burn as much energy, and that help us get out on the cutting edge of the new technologies that will create millions of new jobs. Because, when we sell these new products here, we'll then be able to sell them overseas. There is a ravenous demand for them overseas. Now, another big difference is Governor Bush is proposing to open up some of our most precious environmental treasures, like the Arctic National Wildlife Refuge for the big oil companies to go in and start producing oil there. I think that is the wrong choice. It would only give us a few months' worth of oil and the oil wouldn't start flowing for many years into the future. I don't think it's a fair price to pay to destroy precious parts of America's environment. We have to bet on the future and move beyond the current technologies to have a whole new generation of more efficient, cleaner, energy technology. BUSH: It's an issue I know a lot about. I was a small oil person for a while in west Texas. This is an administration that's had no plan. And all of a sudden the results of having no plan have caught up with America. First and foremost we have to fully fund -- heat which is a way to help low income people in the east to pay for high fuel bills. We need an active exploration incentive in America. We need to explore at home. You bet I want to open up a small part of Alaska. When that field is online it will produce one million barrels a day. Today we import one million barrels from Saddam Hussein. I would rather that a million come from our own hemisphere, have it come from our own country as opposed to Saddam Hussein. I want to develop the coal resources in America. Have clean coal technologies. We better start exploring it or otherwise we'll be in deep trouble in the future because of our dependency upon foreign sources of crude. MODERATOR: So if somebody is watching tonight and listening to what the two of you just said, is it fair to say, okay, the differences between Governor Bush and Vice President Gore are as follows. You're for doing something on the consumption end and you're for doing something on the production end? GORE: Let me clarify. I'm for doing something both on the supply side and production side and on the consumption side. Let me say, that I found one thing in Governor Bush's answer that we certainly agree on, and that's the low income heating assistance program. I commend you for supporting that. I worked to get $400 million just a couple of weeks ago. And to establish a permanent home heating oil reserve here in the northeast. Now, as for the proposals that I've worked for for renewables and conservation and efficiencies and new technologies for the last few years in the Congress, we've faced a lot of opposition to them. They've only approved about 10% of the agenda I've helped to send up there. We need to get serious about this energy crisis, both in the Congress and in the White House, and if you entrust me with the presidency, I will tackle this problem and focus on new technologies that will make us less dependent on big oil or foreign oil. MODERATOR: How would you draw the difference? BUSH: Well I would first say he should have been tackling it for the last seven years. The difference is we need to explore at home. And the vice president doesn't believe in exploration, for example, in Alaska. There's a lot of shut-in gas that we need to be moving out of Alaska by pipeline. There's an interesting issue up in the northwest as well. Do we remove dams that produce hydroelectric energy? I'm against removing dams in the northwest. We need to keep that in line. I was in coal country in West Virginia. There is an abundant supply of coal in this country. I know we can do a better job of clean coal technologies. I'm going to ask the Congress for $2 billion to make sure we have the cleanest coal technologies in the world. In the short-term we need to get after it here in America. We need to explore our resources and we need to develop our reservoirs of domestic production. We also need to have a hemispheric energy policy where Canada, Mexico and the United States come together. I brought this up recently with the newly elected president in Mexico, he's a man I know from Mexico. I talked to him about how best to expedite the exploration of natural gas in Mexico and transport it up to the United States so we become less dependent on foreign sources of crude oil. It's a major problem facing America. The administration did not deal with it. It's time for a new administration to deal with the energy problem. GORE: I found a couple of other things we agree upon. We may not find that many this evening, so I wanted to emphasize. I strongly support new investments in clean coal technology. I made a proposal three months ago on this. And also domestic exploration yes, but not in the environmental treasures of our country. We don't have to do that. That's the wrong choice. I know the oil companies have been itching to do that, but it is not the right thing to do. BUSH: It's the right thing for the consumers. Less dependency upon foreign sources of crude is good for consumers. And we can do so in an environmentally friendly way. MODERATOR: New question, new subject. Governor Bush. If elected president, would you try to overturn the FDA's approval last week of the abortion pill RU-486? BUSH: I don't think a president can do that. I was disappointed in the ruling because I think abortions ought to be more rare in America, and I'm worried that that pill will create more abortions and cause more people to have abortions. This is a very important topic and it's a very sensitive topic, because a lot of good people disagree on the issue. I think what the next president ought to do is to promote a culture of life in America. Life of the elderly and life of those women all across the country. Life of the unborn. As a matter of fact, I think a noble goal for this country is that every child, born or unborn, need to be protected by law and welcomed to life. I know we need to change a lot of minds before we get there in America. What I do believe is that we can find good, common ground on issues of parental consent or parental notification. I know we need to ban partial birth abortions. This is a place where my opponent and I have strong disagreement. I believe banning partial birth abortions would be a positive step to reducing the number of abortions in America. It is an issue that will require a new attitude. We've been battling over abortion for a long period of time. Surely this nation can come together to promote the value of life. Surely we can fight off these laws that will encourage doctors to -- to allow doctors to take the lives of our seniors. Surely we can work together to create a cultural life so some of these youngsters who feel like they can take a neighbor's life with a gun will understand that that's not the way America is meant to be. Surely we can find common ground to reduce the number of abortions in America. As to the drug itself, I mentioned I was disappointed. I hope the FDA took its time to make sure that American women will be safe who use this drug. MODERATOR: Vice President Gore? GORE: Well, Jim, the FDA took 12 years, and I do support that decision. They determined it was medically safe for the women who use that drug. This is indeed a very important issue. First of all on the issue of partial birth or so-called late-term abortion, I would sign a law banning that procedure, provided that doctors have the ability to save a woman's life or to act if her health is severely at risk. That's not the main issue. The main issue is whether or not the Roe v. Wade decision is going to be overturned. I support a woman's right to choose. My opponent does not. It is important because the next president is going to appoint three and maybe even four justices of the Supreme Court. And Governor Bush has declared to the anti-choice group that he will appoint justices in the mold of Scalia and Clarence Thomas, who are known for being the most vigorous opponents of a woman's right to choose. Here is the difference. He trusts the government to order a woman to do what it thinks she ought to do. I trust women to make the decisions that affect their lives, their destinies and their bodies. And I think a woman's right to choose ought to be protected and defended. MODERATOR: Governor, we'll go to the Supreme Court question in a moment, but make sure I understand your position on RU-486. If you're elected president, you won't support legislation to overturn this? BUSH: I don't think a president can unilaterally overturn it. The FDA has made its decision. MODERATOR: That means you wouldn't, through appointments, to the FDA and ask them to -- BUSH: I think once a decision has been made, it's been made unless it's proven to be unsafe to women. GORE: Jim, the question you asked, if I heard you correctly, was would he support legislation to overturn it. And if I heard the statement day before yesterday, you said you would order -- he said he would order his FDA appointee to review the decision. Now that sounds to me a little bit different. I just think that we ought to support the decision. BUSH: I said I would make sure that women would be safe who used the drug. MODERATOR: On the Supreme Court question. Should a voter assume -- you're pro-life. BUSH: I am pro-life. MODERATOR: Should a voter assume that all judicial appointments you make to the supreme court or any other court, federal court, will also be pro-life? BUSH: The voters should assume I have no litmus test on that issue or any other issue. Voters will know I'll put competent judges on the bench. People who will strictly interpret the Constitution and not use the bench for writing social policy. That is going to be a big difference between my opponent and me. I believe that the judges ought not to take the place of the legislative branch of government. That they're appointed for life and that they ought to look at the Constitution as sacred. They shouldn't misuse their bench. I don't believe in liberal activist judges. I believe in strict constructionists. Those are the kind of judges I will appoint. I've named four in the State of Texas and ask the people to check out their qualifications, their deliberations. They're good, solid men and women who have made good, sound judgments on behalf of the people of Texas. MODERATOR: What kind of appointments should they expect from you? GORE: We both use similar language to reach an exactly opposite outcome. I don't favor a litmus test, but I know that there are ways to assess how a potential justice interprets the Constitution. And in my view, the Constitution ought to be interpreted as a document that grows with our country and our history. And I believe, for example, that there is a right of privacy in the Fourth Amendment. And when the phrase a strict constructionist is used and when the names of Scalia and Thomas are used as the benchmarks for who would be appointed, those are code words, and nobody should mistake this, for saying the governor would appoint people who would overturn Roe v. Wade. It's very clear to me. I would appoint people that have a philosophy that I think will be quite likely would uphold Roe v. Wade. MODERATOR: Is the vice president right? BUSH: It sounds like he's not very right tonight. I just told you the criteria on which I'll appoint judges. I have a record of appointing judges in the State of Texas. That's what a governor gets to do. A governor gets to name supreme court judges. He also reads all kinds of things into my tax plan and into my Medicare plan. I want the viewers out there to listen to what I have to say about it. MODERATOR: Reverse the question. What code phrases should we read by what you said about what kind of people you would appoint? GORE: It would be likely that they would uphold Roe v. Wade. I do believe it's wrong to use a litmus test. If you look at the history of a lower court judge's rulings, you can get a pretty good idea of how they'll interpret questions. A lot of questions are first impression, and these questions that have been seen many times come up in a new context and so -- but, you know, this is a very important issue. Because a lot of young women in this country take this right for granted and it could be lost. It is on the ballot in this election, make no mistake about it. BUSH: I'll tell you what kind of judges he'll put on. He'll put liberal activists justices who will use their bench to subvert the legislature, that's what he'll do. MODERATOR: Vice President Gore, if President Milosevic of Yugoslavia refuses to leave office, what action, if any, should the United States take to get him out of there? GORE: Well, Milosevic has lost the election. His opponent, Kostunica, has won the election. It's overwhelming. Milosevic's government refuses to release the vote count. There's now a general strike going on. They're demonstrating. I think we should support the people of Serbia and Yugoslavia, as they call the Serbia plus Montenegro, and put pressure in every way possible to recognize the lawful outcome of the election. The people of Serbia have acted very bravely in kicking this guy out of office. Now he is trying to not release the votes and then go straight to a so-called runoff election without even announcing the results of the first vote. Now, we've made it clear, along with our allies, that when Milosevic leaves, then Serbia will be able to have a more normal relationship with the rest of the world. That is a very strong incentive that we've given them to do the right thing. Bear in mind also, Milosevic has been indicted as a war criminal and he should be held accountable for his actions. Now, we have to take measured steps because the sentiment within Serbia is, for understandable reasons, against the United States because their nationalism -- even if they don't like Milosevic, they still have some feelings lingering from the NATO action there. So we have to be intelligent in the way we go about it. But make no mistake about it, we should do everything we can to see that the will of the Serbian people expressed in this extraordinary election is done. And I hope that he'll be out of office very shortly. MODERATOR: Governor Bush, one minute. BUSH: Well, I'm pleased with the results of the election. As the vice president said, it's time for the man to go. It means that the United States must have a strong diplomatic hand with our friends in NATO. That's why it's important to make sure our alliances are as strong as they possibly can be to keep the pressure on Mr. Milosevic. But this will be an interesting moment for the Russians to step up and lead as well. Be a wonderful time for the Russians to step into the Balkans and convince Mr. Milosevic that it's in his best interest and his country's best interest. The Russians have sway in that part of the world. We would like to see the Russians use that sway to encourage democracy to take hold. It's an encouraging election. It's time for the man to leave. MODERATOR: What if he doesn't leave? What if all the diplomatic efforts, all the pressure and he still doesn't go? Is this the kind of thing, and be specific, that you as president would consider the use of U.S. military force to get him gone? GORE: In this particular situation, no. Bear in mind that we have a lot of sanctions in force against Serbia right now. And the people of Serbia know that they can escape all those sanctions if this guy is turned out of power. Now, I understand what the governor has said about asking the Russians to be involved, and under some circumstances that might be a good idea. But being as they have not yet been willing to recognize Kostunica as the lawful winner of the election, I'm not sure it's right for us to invite the president of Russia to mediate this -- this dispute there because we might not like the results that comes out of that. They currently favor going forward with a runoff election. I think that's the wrong thing. I think the governor's instinct is not necessarily bad because we have worked with the Russians in a constructive way in Kosovo, for example, to end the conflict there. But I think we need to be very careful in the present situation before we invite the Russians to play the lead role in mediating. BUSH: Well obviously we wouldn't use the Russians if they didn't agree with our answer, Mr. Vice President. Let me say this to you, I wouldn't use force. I wouldn't use force. MODERATOR: You wouldn't use force? BUSH: No. MODERATOR: Why not? BUSH: It's not in our national interest to use force. I would use pressure and diplomacy. There is a difference what the president did in Kosovo and this. It's up to the people in this region to take control of their country. MODERATOR: New question. How would you go about as president deciding when it was in the national interest to use U.S. force, generally? BUSH: Well, if it's in our vital national interest, and that means whether our territory is threatened or people could be harmed, whether or not the alliances are -- our defense alliances are threatened, whether or not our friends in the Middle East are threatened. That would be a time to seriously consider the use of force. Secondly, whether or not the mission was clear. Whether or not it was a clear understanding as to what the mission would be. Thirdly, whether or not we were prepared and trained to win. Whether or not our forces were of high morale and high standing and well-equipped. And finally, whether or not there was an exit strategy. I would take the use of force very seriously. I would be guarded in my approach. I don't think we can be all things to all people in the world. I think we've got to be very careful when we commit our troops. The vice president and I have a disagreement about the use of troops. He believes in nation building. I would be very careful about using our troops as nation builders. I believe the role of the military is to fight and win war and therefore prevent war from happening in the first place. So I would take my responsibility seriously. And it starts with making sure we rebuild our military power. Morale in today's military is too low. We're having trouble meeting recruiting goals. We met the goals this year, but in the previous years we have not met recruiting goals. Some of our troops are not well-equipped. I believe we're overextended in too many places. And therefore I want to rebuild the military power. It starts with a billion dollar pay raise for the men and women who wear the uniform. A billion dollars more than the president recently signed into law. It's to make sure our troops are well-housed and well-equipped. Bonus plans to keep some of our high-skilled folks in the services and a commander in chief that sets the mission to fight and win war and prevent war from happening in the first place. MODERATOR: Vice President Gore, one minute. GORE: I want to make it clear, our military is the strongest, best-trained, best-equipped, best-led fighting force in the world and in the history of the world. Nobody should have any doubt about that, least of all our adversaries or potential adversaries. If you entrust me with the presidency, I will do whatever is necessary in order to make sure our forces stay the strongest in the world. In fact, in my ten-year budget proposal I've set aside more than twice as much for this purpose as Governor Bush has in his proposal. Now, I think we should be reluctant to get involved in someplace in a foreign country. But if our national security is at stake, if we have allies, if we've tried every other course, if we're sure military action will succeed, and if the costs are proportionate to the benefits, we should get involved. Now, just because we don't want to get involved everywhere doesn't mean we should back off anywhere it comes up. I disagree with the proposal that maybe only when oil supplies are at stake that our national security is at risk. I think that there are situations like in Bosnia or Kosovo where there's a genocide, where our national security is at stake there. BUSH: I agree our military is the strongest in the world today, that's not the question. The question is will it be the strongest in the years to come? Everywhere I go on the campaign trail I see moms and dads whose son or daughter may wear the uniform and they tell me about how discouraged their son or daughter may be. A recent poll was taken among 1,000 enlisted personnel, as well as officers, over half of whom will leave the service when their time of enlistment is up. The captains are leaving the service. There is a problem. And it's going to require a new commander in chief to rebuild the military power. I was honored to be flanked by Colin Powell and General Norman Schwartzkopf recently stood by me side and agreed with me. If we don't have a clear vision of the military, if we don't stop extending our troops all around the world and nation building missions, then we're going to have a serious problem coming down the road, and I'm going to prevent that. I'm going to rebuild our military power. It's one of the major priorities of my administration. MODERATOR: Vice President Gore, how should the voters go about deciding which one of you is better suited to make the kinds of decisions, whether it's Milosevic or whatever, in the military and foreign policy area? GORE: Well, they should look at our proposals and look at us as people and make up their own minds. When I was a young man, I volunteered for the Army. I served my country in Vietnam. My father was a senator who strongly opposed the Vietnam War. I went to college in this great city, and most of my peers felt against the war as I did. But I went anyway because I knew if I didn't, somebody else in the small town of Carthage, Tennessee, would have to go in my place. I served for eight years in the House of Representatives and I served on the Intelligence Committee, specialized in looking at arms control. I served for eight years in the United States Senate and served on the Armed Services Committee. For the last eight years I've served on the National Security Council, and when the conflict came up in Bosnia, I saw a genocide in the heart of Europe with the most violent war on the continent of Europe since World War II. Look, that's where World War I started. My uncle was a victim of poisonous gas there. Millions of Americans saw the results of that conflict. We have to be willing to make good, sound judgments. Incidentally, I know the value of making sure our troops have the latest technology. The governor has proposed skipping the next generation of weapons. I think that's a big mistake, because I think we have to stay at the cutting edge. MODERATOR: Governor, how would you advise the voters to make the decision on this issue? BUSH: I think you've got to look at how one has handled responsibility in office. Whether or not it's -- the same in domestic policy as well. Whether or not you have the capacity to convince people to follow? Whether or not one makes decisions based on sound principles or whether or not you rely upon polls or focus groups on how to decide what the course of action is. We have too much polling and focus groups going on in Washington today. We need decisions made on sound principles. I've been the governor of a big state. I think one of the hallmarks of my relationship in Austin, Texas, is that I've had the capacity to work with both Republicans and Democrats. I think that's an important part of leadership. I think what it means to build consensus. I've shown I know how to do so. Tonight in the audience there's one elected state senator who is a Democrat, a former state-wide officer who is a Democrat, a lot of Democrats who are here in the debate to -- because they want to show their support that shows I know how to lead. And so the fundamental answer to your question, who can lead and who's shown the ability to get things done? GORE: If I could say one thing. MODERATOR: We are way over three-and-a-half minutes. Go ahead. GORE: One of the key points in foreign policy and national security policy is the need to establish the old-fashioned principle that politics ought to stop at the water's edge. When I was in the United States Congress, I worked with former President Reagan. When I was in the United States Senate I worked with former President Bush, your father. I was one of only a few Democrats in the Senate to support the Persian Gulf War. I think bipartisanship is a national asset. We have to find ways to reestablish it in foreign policy and national security policy. MODERATOR: Do you have a problem with that? BUSH: Yeah. Why haven't they done it in seven years? MODERATOR: New subject. New question. Should the voters of this election, Vice President Gore, see this in the domestic area as a major choice between competing political philosophies? GORE: Oh, absolutely. This is a very important moment in the history of our country. Look, we've got the biggest surpluses in all of American history. The key question that has to be answered in this election is will we use that prosperity wisely in a way that benefits all of our people and doesn't go just to the few. Almost half of all the tax cut benefits, as I said under Governor Bush's plan, go to the wealthiest 1%. I think we have to make the right and responsible choices. I think we have to invest in education, protecting the environment, health care, a prescription drug benefit that goes to all seniors, not just to the poor, under Medicare, not relying on HMOs and insurance companies. I think that we have to help parents and strengthen families by dealing with the kind of inappropriate entertainment material that families are just heart sick that their children are exposed to. I think we've got to have welfare reform taken to the next stage. I think that we have got to balance the budget every single year, pay down the national debt and, in fact, under my proposal the national debt will be completely eliminated by the year 2012. I think we need to put Medicare and Social Security in a lockbox. The governor will not put Medicare in a lockbox. I don't think it should be used as a piggy bank for other programs. I think it needs to be moved out of the budget and protected. I'll veto anything that takes money out of Social Security or Medicare for anything other than Social Security or Medicare. Now, the priorities are just very different. I'll give you a couple of examples. For every new dollar that I propose for spending on health care, Governor Bush spends $3 for a tax cut for the wealthiest 1%. Now, for every dollar that I propose to spend on education, he spends $5 on a tax cut for the wealthiest 1%. Those are very clear differences. MODERATOR: Governor, one minute. BUSH: The man is practicing fuzzy math again. There's differences. Under Vice President Gore's plan, he is going to grow the federal government in the largest increase since Lyndon Baines Johnson in 1965. We're talking about a massive government, folks. We're talking about adding to or increasing 200 programs, 20,000 new bureaucrats. Imagine how many IRS agents it is going to take to be able to figure out his targeted tax cut for the middle class that excludes 50 million Americans. There is a huge difference in this campaign. He says he's going to give you tax cuts. 50 million of you won't receive it. He said in his speech he wants to make sure the right people get tax relief. That's not the role of a president to decide right and wrong. Everybody who pays taxes ought to get tax relief. After my plan is in place, the wealthiest Americans will pay more tax, the poorest of Americans, six million families, won't pay any tax at all. It's a huge difference. A difference between big exploding federal government that wants to think on your behalf and a plan that meets priorities and liberates working people to be able to make decisions on your own. GORE: You haven't heard the governor deny these numbers. He's called them phony and fuzzy. The fact remains almost 30% of his proposed tax cut goes to -- only to Americans that make more than $1 million per year. More money goes to the -- can I have a rebuttal here? MODERATOR: I want to see if he buys that. BUSH: Let me tell you what the facts are. The facts are after my plan, the wealthiest of Americans pay more taxes of the percentage of the whole than they do today. Secondly, if you're a family of four making $50,000 in Massachusetts, you get a 50% tax cut. Let me give you one example. A family in Allentown, Pennsylvania, I campaigned with them the other day. They make $51,000 combined income, they pay about $3500 in taxes. Under my plan, they get $1800 of tax relief. Under Vice President Gore's plan, they get $145 of tax relief. Now you tell me who stands on the side of the fence. You ask whose plan makes more sense. There is a difference of opinion. He would rather spend the family's $1800 and I would rather the family spend that money. GORE: No, I don't, and I'm not going to go to calling names on his facts. I'm just gonna tell you what the real facts are. The analysis that he's talking about leaves out more than half of the tax cuts that I have proposed. And if you just add the numbers up, he still hasn't denied it, he spends more money on a tax cut for the wealthiest 1% than all his new proposals for all his other things combined. Now those are the wrong priorities. $665 billion over ten years for the wealthiest 1%. As I said, almost 30% of it goes to Americans that make more than $1 million per year. Every middle class family is eligible for a tax cut under my proposal. Let me give you some specific examples. I believe college tuition up to $10,000 per year ought to be tax deductible so middle-class families can choose to send their children to college. I believe all senior citizens should be able to choose their own doctors and get prescription drugs from their own pharmacists with Medicare paying half the bill. I believe parents need more public and charter school choice to send their kids to a safe school. We need to make education the number one priority in our country and treat teachers like the professionals that they are. And that's why I have made it a number one priority in my budget. BUSH: Let me talk about tax cuts one more time. It excludes 50 million Americans. GORE: Not so. BUSH: The marriage penalty. If you itemize your tax return, you get no marriage penalty relief. He picks and chooses. He decides who the right people are. It's a fundamental difference of opinion. I want my fellow Americans to hear one more time. We'll spend $25 trillion -- we'll collect $25 trillion in revenue in the next 10 years and spend $21 trillion. We need to send 5% back to you that pay the bills. I want to say something. This man has been disparaging my plan with all this Washington fuzzy math. If you're a single mother making $22,000 a year and you have two children, under this tax code, for every additional dollar you make, you pay a higher marginal rate on that dollar than someone making more than $200,000 a year, and that is not right. My plan drops the rate from 15% to 10% and increases the child credit from $500 to $1,000 to make the code more fair for everybody, not just a few, not just a handful. Everybody who pays taxes ought to get some relief. MODERATOR: Having cleared that up, we're going to a new question. Education. Governor Bush. Both of you have promised dramatically to change -- to change dramatically public education in this country. Of the public money spent on education, only 6% of that is federal money. You want to change 100% of the public education on 6% of the money, is it possible to change it? BUSH: We can make a huge difference by saying if you receive federal money we expect you to show results. Let me give you a story about public education, if I might. It's about Kipp Academy in Houston, Texas. A charter school run by some people from Teach For America. Young folks saying I'm going to do something good for my country. I want to teach. A guy named Michael runs the school. It is a school full of so-called at-risk children. It's how wer unfortunately label certain children. Basically it means they can't learn. It's a school of strong discipline and high standards. It's one of the best schools in Houston. Here are the key ingredients. High expectations, strong accountabily. What Michael says, don't put all these rules on us, just let us teach and hold us accountable for every grade. That's what we do. And as a result, these mainly Hispanic youngsters are some of the best learners in Houston, Texas. That's my vision for public education all around America. Many of you viewers don't know, but Laura and I sent our girls to public school. They went to Austin High School. And many of the public schools are meeting the call. But, unfortunately, a lot of schools are trapping children in schools that just won't teach and won't change. Here is the role of the federal government. One is to change Head Start to a reading program. Two is to say if you want to access reading money, you can do so. The goal is for every single child to learn to Read. there must by K-2 diagnostic teaching tools available. We have to consolidate the system to free the schools and encourage innovators. Let them reach out beyond the confines of the current structure to recruit teach-for-the-children type teachers. Four, we're going to say if you receive federal money, measure third, fourth, fifth, sixth, seventh and eighth grade. Show us if they are learning to read, write, add and subtract there will be bonus plans. If not, instead of continuing to subsidize failure, the money will go to -- the federal money will go to the parents for public school or charter school or tutorial or Catholic school. What I care about is children. And so does Michael Feinberg. And you know what? It can happen in America with the right kind of leadership. GORE: We agree on a couple of things on education. I strongly support new accountability, so does Governor Bush. I strongly support local control, so does Governor Bush. I'm in favor of testing as a way of measuring performance. Every school and every school district, have every state test the children. I've also proposed a voluntary national test in the fourth grade and eighth grade, and a form of testing the governor has not endorsed. I think that all new teachers ought to be tested, including in the subjects that they teach. We've got to recruit 100,000 new teachers. And I have budgeted for that. We've got to reduce the class size so that the student who walks in has more one-on-one time with the teacher. We ought to have universal pre-school and we ought to make college tuition tax deductible, up to $10,000 a year. I would like to tell you a quick story. I got a letter today as I left Sarasota, Florida. I'm here with a group of 13 people from around the country who helped me prepare. We had a great time. Two days ago we ate lunch at a restaurant. The guy that served us lunch gave me a letter today. His name is Randy Ellis. He has a 15-year-old daughter named Caley, who is in Sarasota High School. Her science class was supposed to be for 24 students. She's the 36th student in that classroom. They sent me a picture of her in the classroom. They can't squeeze another desk in for her, so she has to stand during class. I want the federal government, consistent with local control and new accountability, to make improvement of our schools the number one priority so Caley will have a desk and can sit down in a classroom where she can learn. MODERATOR: All right. So having heard the two of you, the voters have just heard the two of you, what is the difference? What is the choice between the two of you on education? BUSH: The first is, the difference is there is no new accountability measures in Vice President Gore's plan. He says he's for voluntary testing. You can't have voluntary testing. You must have mandatory testing. You must say that if you receive money you must show us whether or not children are learning to read and write and add and subtract. That's the difference. You may claim you've got mandatory testing but you don't, Mr. Vice President. That's a huge difference. Testing is the cornerstone of reform. You know how I know? Because it's the cornerstone of reform in the State of Texas. Republicans and Democrats came together and said what can we do to make our public education the best in the country? We've done a long way working together to do so. The cornerstone is to have strong accountability in return for money and in return for flexibility. We're going to ask you to show us whether or not -- we ask you to post the results on the Internet. We encourage parents to take a look at the comparative results of schools. We have a strong charter school movement that I signed the legislation to get started in the State of Texas. I believe if we find poor children trapped in schools that won't teach, we need to free the parents. We need to expand education savings accounts. Something that my vice presidential running mate supports. There's big differences. He won't support freeing local districts from the strings of federal money. GORE: First of all, I do have mandatory testing. I think the governor may not have heard what I said clearly. The voluntary national testing is in addition to the mandatory testing that we require of states. All schools, all school districts, students themselves, and required teacher testing, which goes a step farther than Governor Bush has been willing to go. Here are a couple of differences, though, Jim. Governor Bush is in favor of vouchers which take taxpayer money away from public schools and give them to private schools that are not accountable for how the money is used and don't have to take all applicants. Now, private schools play a great role in our society. All of our children have gone to both public schools and private schools. But I don't think private schools should have a right to take taxpayer money away from public schools at a time when Caley Ellis is standing in that classroom. Let me give you another example. I went to a school in Dade County, Florida where the facilities are so overcrowded the children have to eat lunch in shifts with the first shift for lunch starting at 9:30 in the morning. Look, this is a funding crisis all around the country. There are fewer parents of school-age children as a percentage of the voting population and there is the largest generation of students ever. We're in an information age when learning is more important than ever. 90% of our kids go to public schools. We have to make it the number one priority. Modernize our schools, reduce class size, recruit new teachers, give every child a chance to learn with one-on-one time in a quality -- high-quality, safe school. If it's a failing school, shut it down and reopen it under a new principal with a turnaround team of specialists the way Governor Jim Hunt does in North Carolina. Here is another difference. The governor, if it's a failing school, would leave the children in that failing school for three years and then give a little bit of money to the parents, a down payment on a down payment for private school tuition, and pretend that that would be enough for them to go out and go to a private school. It's an illusion. MODERATOR: Wait a minute, Governor. BUSH: Okay. First of all, most of this is at the state level. See, here is the mentality. I'm going to make the state do this and make the state do that. All I'm saying is if you spend money, show us results and test every year, which you do not do, Mr. Vice President. You don't test every year. You can say you do to the cameras but you don't, unless you've changed your plan. GORE: I didn't say that. BUSH: You need to test every year. That's why you determine if children are progressing to excellence. Secondly, one of the things that we have to be careful about in politics is throwing money at a system that has not yet been reformed. More money is needed and I spend more money, but step one is to make sure we reform the system to have the system in place that leaves no child behind. Stop this business about asking gosh, how old are you? If you're 10 we'll put you here, 12 you put here. Start asking the question, what do you know? If you don't know what you're supposed to know, we'll make sure you do early before it's too late. MODERATOR: New question. We've been talking about a lot of specific issues. It's often said that in the final analysis about 90% of being the President of the United States is dealing with the unexpected, not with issues that came up in the campaign. Vice President Gore, can you point to a decision, an action you have taken, that illustrates your ability to handle the unexpected, the crisis under fire? GORE: When the action in Kosovo was dragging on and we were searching for a solution to the problem, our country had defeated the adversary on the battlefield without a single American life being lost in combat. But the dictator Milosevic was hanging on. I invited the former prime minister of Russia to my house and took a risk in asking him to get personally involved, along with the head of Finland, to go to Belgrade and to take a set of proposals from the United States that would constitute basically a surrender by Serbia. But it was a calculated risk that paid off. Now, I could probably give you some other examples of decisions over the last 24 years. I have been in public service for 24 years, Jim. And throughout all that time the people I have fought for have been the middle-class families, and I have been willing to stand up to powerful interests like the big insurance companies, the drug companies, the HMOs, the oil companies. They have good people and they play constructive roles sometimes, but sometimes they get too much power. I cast my lot with the people even when it means that you have to stand up to some powerful interests who are trying to turn the -- the policies and the laws to their advantage. You can see it in this campaign. The big drug companies support Governor Bush's prescription drug proposal. They oppose mine because they don't want to get Medicare involved because they're afraid that Medicare will negotiate lower prices for seniors who currently pay the highest prices of all. MODERATOR: Governor Bush? BUSH: I've been standing up to big business, Hollywood, big trial lawyers. Was -- the question about emergencies, wasn't it? MODERATOR: It was about -- okay. BUSH: You know, as governor, one of the things you have to deal with is catastrophe. I can remember the fires that swept Parker County, Texas. I remember the floods that swept our state. I remember going down to Del Rio, Texas. I have to pay the administration a compliment. James Lee Witt of FEMA has done a really good job of working with governors during times of crisis. But that's the time when you're tested not only -- it's the time to test your metal, a time to test your heart when you see people whose lives have been turned upside down. It broke my heart to go to the flood scene in Del Rio where a fellow and his family got completely uprooted. The only thing I knew was to got aid as quickly as possible with state and federal help, and to put my arms around the man and his family and cry with them. That's what governors do. They are often on the front line of catastrophic situations. MODERATOR: New question. There can be all kinds of crises, Governor. A questions for you. There could be a crisis, for instance, in the financial area, the stock market could take a tumble, there could be a failure of a major financial institution. What is your general attitude toward government intervention in such events? BUSH: Well, it depends, obviously. But what I would do first and foremost, is I would get in touch with the Federal Reserve Chairman, Allen Greenspan, to find out all the facts and all the circumstances. I would have my Secretary of the Treasury be in touch with the financial centers not only here, but at home. I would make sure that key members of Congress were called in to discuss the gravity of the situation. And I would come up with a game plan to deal with it. That's what governors end up doing. We end up being problem solvers. We come up with practical, common sense solutions for problems that we're confronted with. In this case, in the case of a financial crisis, I would gather all the facts before I made the decision as to what the government ought or ought not to do. MODERATOR: Vice President Gore? GORE: First I want to compliment the governor on his response to those fires and floods in Texas. I accompanied James Lee Witt down to Texas when those fires broke out. And FEMA has been a major flagship project of our reinventing government efforts. And I agree, it works extremely well now. On the international financial crises that come up, my friend, Bob Rubin, the former Secretary of Treasury is here, he's a close advisor to me and great friend in all respects. I have had a chance to work with him and Allen Greenspan and others on the crisis following the collapse of the Mexican peso. When the Asian financial crisis raised the risk of world-wide recession that could affect our economy, And now, of course, the euro's value has been dropping, but seems to be under control. But it started for me in the last eight years when I had the honor of casting the tie-breaking vote to end the old economic plan here at home and put into place a new economic plan that has helped us to make some progress, 22 million new jobs, the greatest prosperity ever. But it's not good enough. My attitude is you ain't seen nothing yet. We need to do more and better. MODERATOR: So, Governor, would you agree there is no basic difference here on intervening -- on federal government intervening in what might be seen by others to be a private financial crisis? BUSH: No, there's no difference on that. There is a difference, though, as to what the economy has meant. I think the economy has meant more for the Gore and Clinton folks than the Gore and Clinton folks have meant for the economy. I think most of the economic growth that has taken place is a result of ingenuity and hard work and entrepreneurship and that's the role of goverment to encourage that. In terms of in response to the question, no. GORE: Can I comment on that? MODERATOR: You may. GORE: You know, I think the American people deserve credit for the great economy that we have. It's their ingenuity, I agree with that. But you know, they were working pretty hard eight years ago. And now they had ingenuity eight years ago. The difference is we've got a new policy. And instead of concentrating on tax cuts mostly for the wealthy, we want -- I want tax cuts for the middle-class families and I want to continue the prosperity and make sure that it enriches not just a few but all of our families. We have gone from the biggest deficits to the biggest surpluses. We have gone from a triple debt recession during the previous 12 years to a tripling in the stock market. Instead of a high unemployment, we have the lowest African-American and Latin American unemployment rates in history and 22 million new jobs. It's not good enough. Too many people have been left behind. We have got to do much more. The key is job training, education, investments in health care and education, environment, retirement security. And incidentally, we have got to preserve Social Security. I'm opposed to diverting one out of every six dollars out of the Social Security trust fund, as the Governor has proposed, into the stock market. I want new incentives for savings and investment for the young couples who are working hard so they can save and invest on their own on top of Social Security, not at the expense of Social Security, as the governor proposes. BUSH: Two points. One, a lot of folks are still waiting for that 1992 middle-class tax cut. I remember the vice president saying, "Just give us a chance to get up there, we're going to make sure you get tax cuts." It didn't happen. Now he's having to say that again. They've had their chance to deliver a tax cut to you. Secondly, the surest way to bust this economy is to increase the role and size of the federal budget. The Senate Budget Committee did a study of the vice president's expenditures. It's been projected that they could conceivably bust the budget by $900 billion. That means he'll either have to raise your taxes by $900 billion or go into the Social Security surplus for $900 billion. This is a plan that is going to increase the bureaucracy by 20,000 people. His targeted tax cut is so detailed, so much fine print that it is going to require numerous IRS agents. We need somebody to simplify the code, to be fair, to continue prosperity by sharing some of the surplus with the people who pay the bills, particularly those at the bottom end of the economic ladder. GORE: If I could respond, Jim. What he's quoting is not the Senate Budget Commiitte, it is a partisan press release by the Republicans on the Senate Budget Committee that's not worth the government -- the taxpayer-paid paper that it's printed on. Now, as for 20,000 new bureaucrats, as you call them, you know, the size of the federal government will go down in a Gore administration. In the reinventing government program you just look at the numbers. It is 300,000 people smaller today than it was eight years ago. Now, the fact is you're going to have a hard time convincing folks that we were a whole lot better off eight years ago than we are today. But that's not the question. The question is, will we be better off four years from now than we are today? And as for the surest way to threaten our prosperity, having a $1.9 trillion tax cut, almost half of which goes to the wealthy, and a $1 trillion Social Security privatization proposal is the surest way to put our budget into deficit -- BUSH: I can't let the man continue with fuzzy math. It is 1.3 trillion. It will go to everybody who pays taxes. I'm not going to be the kind of president that says you get tax relief and you don't. I'm not going to be a picker and chooser. What is fair is everybody who pays taxes ought to get relief. MODERATOR: I thought we cleared this up a while ago. New question on Social Security. Both of you have Social Security reform plans, so we could spend the rest of the evening and two or three other evenings talking about them in detail. We won't do that. But -- GORE: Suits me. MODERATOR: Many experts, including Federal Reserve Chairman Greenspan, Vice President Gore, say that it will be impossible for either of you, essentially, to keep the system viable on its own during the coming baby boomer retirement onslaught without either reducing benefits or increasing taxes. You disagree? GORE: I do disagree. Because if we can keep our prosperity going, if we can continue balancing the budget and paying down the debt, then the strong economy keeps generating surpluses. Here is my plan. I will keep Social Security in a lockbox and that pays down the national debt. And the interest savings I would put right back into Social Security. That extends the life of Social Security for 55 years. Now, I think that it's very important to understand that cutting benefits under Social Security means that people like Winifred Skinner from Des Moines, Iowa, who is here, would really have a much harder time. Because there are millions of seniors who are living almost hand to mouth. And you talk about cutting benefits. I don't go along with it. I am opposed to it. I'm also opposed to a plan that diverts 1 out of every $6 away from the Social Security Trust Fund. Social Security is a trust fund that pays the checks this year with the money that is paid into Social Security this year. The governor wants to divert 1 out of every $6 off into the stock market, which means that he would drain a trillion dollars out of the Social Security Trust Fund in this generation over the next ten years, and Social Security under that approach would go bankrupt within this generation. His leading advisor on this plan actually said that would be okay, because then the Social Security Trust Fund could start borrowing. It would borrow up to $3 trillion. Now, Social Security has never done that. And I don't think it should do that. I think it should stay in a lockbox, and I'll tell you this. I will veto anything that takes money out of Social Security for privatization or anything else other than Social Security. BUSH: I thought it was interesting that on the two minutes he spent about a million-and-a-half on my plan, which means he doesn't want you to know what he's doing is loading up IOUs for future generations. He puts no real assets into the Social Security system. The revenues exceed the expenses in Social Security until the year 2015 which means all retirees are going to get the promises made. For those of you who he wants to scare into the voting booth to vote for him, hear me loud and clear. A promise made will be a promise kept. You bet we want to allow younger workers to take some of their own money. That's the difference of opinion. The vice president thinks it's the government's money. The payroll taxes are your money. You ought to put it in prudent, safe investments so that $1 trillion over the next ten years grows to be $3 trillion. The money stays within the Social Security system. It's a part of the Social Security system. He claims it will be out of Social Security. It's your money, it's a part of your retirement benefit. It's a fundamental difference between what we believe. I want you to have your own asset that you can call your own. That you can pass on from one generation to the next. I want to get a better rate of return for your own money than the paltry 2% that the current Social Security Trust gets today. Mr. Greenspan I thought missed an opportunity to say there's a third way, and that is to get a better rate of return on the Social Security monies coming into the trust. There is $2.3 trillion of surplus that we can use to make sure that younger workers have a Social Security plan in the future. If we're smart and if we trust workers and if we understand the power of the compounding rate of interest. GORE: Here is the difference. I give a new incentive for younger workers to save their own money and invest their own money, but not at the expense of Social Security, on top of Social Security. My plan is Social Security plus. The governor's plan is Social Security minus. Your future benefits would be cut by the amount that's diverted into the stock market. If you make bad investments, that's too bad. But even before then the problem hits because the money contributed to Social Security this year is an entitlement. That's how it works. And the money is used to pay the benefits for seniors this year. If you cut the amount going in 1 out of every $6, then you have to cut the value of each check by 1 out of every $6 unless you come up with the money from somewhere else. I would like to know from the governor -- I know we're not supposed to ask each other questions -- but I'd be interested in knowing, does that trillion dollars come from the trust fund, or does it come from the rest of the budget? BUSH: No. There's enough money to pay seniors today in the current affairs of Social Security. The trillion comes from the surplus. Surplus is money -- more money than needed. Let me tell you what your plan is. It's not Social Security plus, it's Social Security plus huge debt. That is what it is. You leave future generations with tremendous IOUs. It's time to have a leader that doesn't put off tomorrow what we should do today. It's time to have somebody to step up and say look, let's let younger workers take some of their own money and under certain guidelines invest it in the private markets. The safest of federal investments yields 4%. That's twice the amount of rate of return than the current Social Security Trust. It's a fundamental difference of opinion here, folks. Younger worker after younger worker hears my call that says I trust you. And you know what, the issue is changeing. Seniors now understand that the promise made will be a promise kept, but younger workers now understand we better have a government that trusts them and that's exactly what I'm going to do. GORE: Could I respond to that, Jim? This is a big issue. Could we do another round on it? MODERATOR: We're almost out of time. GORE: Just briefly. When FDR established Social Security, they didn't call them IOUs, they called it the full faith and credit of the United States. If you don't have trust in that, I do. If you take it out of the surplus in the trust fund, that means the trust fund goes bankrupt in this generation within 20 years. BUSH: This is a government that thinks a 2% rate of return on your money is satisfactory. It's not. This is a government that says younger workers can't possibly have their own assets. We need to think differently about the issue. We need to make sure our seniors get the promise made. If we don't trust younger workers to manage some of their own money with the Social Security surplus, to grow from $1 trillion to $3 trillion, it will be impossible to bridge the gap without it. What Mr. Gore's plan will do causing huge payroll taxes or major benefit reductions. MODERATOR: New question. Are there issues of character that distinguish you from Vice President Gore? BUSH: The man loves his wife and I appreciate that a lot. And I love mine. The man loves his family a lot, and I appreciate that, because I love my family. I think the thing that discouraged me about the vice president was uttering those famous words, "No controlling legal authority." I felt like there needed to be a better sense of responsibility of what was going on in the White House. I believe that -- I believe they've moved that sign, "The buck stops here" from the Oval Office desk to "The buck stops here" on the Lincoln bedroom. It's not good for the country and it's not right. We need to have a new look about how we conduct ourselves in office. There's a huge trust. I see it all the time when people come up to me and say, I don't want you to let me down again. And we can do better than the past administration has done. It's time for a fresh start. It's time for a new look. It's time for a fresh start after a season of cynicism. And so I don't know the man well, but I've been disappointed about how he and his administration have conducted the fundraising affairs. You know, going to a Buddhist temple and then claiming it wasn't a fundraiser isn't my view of responsibility. MODERATOR: Vice President Gore? GORE: I think we ought to attack our country's problems, not attack each other. I want to spend my time making this country even better than it is, not trying to make you out to be a bad person. You may want to focus on scandal. I want to focus on results. As I said a couple of months ago, I stand here as my own man and I want you to see me for who I really am. Tipper and I have been married for 30 years. We became grandparents a year-and-a-half ago. We've got four children. I have devoted 24 years of my life to public service and I've said this before and I'll say it again, if you entrust me with the presidency, I may not be the most exciting politician, but I will work hard for you every day. I will fight for middle-class families and working men and women and I will never let you down. MODERATOR: So, Governor, what are you saying when you mention the fundraising scandals or the fundraising charges that involve Vice President Gore? What are you saying that the voters should take from that that's relevant to this election? BUSH: They ought to factor in it when they go to the voting booth. MODERATOR: In what way? BUSH: I think people need to be held responsible for the actions they take in life. I think that -- well, I think that's part of the need for a cultural change. We need to say we each need to be responsible for what we do. People in the highest office of the land must be responsible for decisions they make in life. And that's the way I've conducted myself as Governor of Texas and that's the way I'll conduct myself as President of the United States, should I be fortunate enough to earn your vote. MODERATOR: Are you saying all this is irrelevant, Vice President Gore? GORE: No. I think the American people should take into account who we are as individuals, what our experience is, what our positions are on the issues and proposals are. I'm asking you to see me for who I really am. I'm offering you my own vision, my own experience, my own proposals. And incidentally, one of them is this. This current campaign financing system has not reflected credit on anybody in either party. And that's one of the reasons I've said before, and I'll pledge here tonight, if I'm president, the very first bill that Joe Lieberman and I will send to the United States Congress is the McCain-Feingold campaign finance reform bill. And the reason it's that important is that all of the other issues, whether prescription drugs for all seniors that are opposed by the drug companies or the patient's bill of rights to take the decisions away from the HMOs and give them to the doctors and nurses, opposed by the HMOs and insurance companies, all these other proposals are going to be a lot easier to get passed for the American people if we limit the influence of special interest money and give democracy back to the American people. And I wish Governor Bush would join me this evening in endorsing the McCain-Feingold Campaign Finance Reform Bill. BUSH: You know, this man has no credibility on the issue. As a matter of fact, I read in the "New York Times" where he said he co-sponsored the McCain-Feingold Campaign Fundraising Bill. But he wasn't in the Senate with Senator Feingold. And so, look, I'm going to -- what you need to know about me is I will uphold the law, I'm going to have an attorney general that enforces the law. The time for campaign funding reform is after the election. This man has outspent me and the special interests are outspending me. And I am not going to lay down my arms in the middle of the campaign for somebody who has got no credibility on the issue. MODERATOR: Senator McCain -- hold on one second. Senator McCain said in August, "It doesn't matter which one of you is President of the United States in January, there is going to be blood on the floor of the United States Senate," and he'll tie up the Senate until campaign finance reform is passed that includes a ban on soft money. First of all, would you support that effort by him, or would you sign a bill that is finally passed that included -- BUSH: I would support an effort to ban corporate soft money and labor union soft money so long as there was dues check-off. I've campaigned on this since the primaries. I believe there needs to be instant disclosure on the Internet as to who has given to who. I think we need to fully enforce the law. I think we need to have an attorney general that says if a law is broken, we'll enforce it. Be strict and firm about it. GORE: Look, Governor Bush, you have attacked my character and credibility and I am not going to respond in kind. I think we ought to focus on the problems and not attack each other. One of the serious problems, hear me well, is that our system of government is being undermined by too much influence coming from special interest money. We have to get a handle on it. And like John McCain, I have learned from experience, and it's not a new position for me. 24 years ago I supported full public financing of all federal elections. And anybody who thinks I'm just saying it, it will be the first bill I send to the Congress. I want you to know I care passionately about this and I will fight until it becomes law. BUSH: I want people to hear what he just said. He is for full public financing of Congressional elections. I'm absolutely, adamently opposed to that. I don't want the government financing congressional elections. MODERATOR: On that wonderful note of disagreement, we have to stop here and we want to go now to your closing statements. Governor Bush is first. You have two minutes. BUSH: Thank you, Jim. Thank the University of Massachusetts and Mr. Vice President, thank you. It has been a good, lively exchange. There is a huge difference of opinion. Mine is I want to empower people in their own lives. I also want to go to Washington to get some positive things done. It is going to require a new spirit. A spirit of cooperation. It will require the ability of a Republican president to reach out across the partisan divide and to say to Democrats, let's come together to do what is right for America. It's been my record as Governor of Texas, it will be how I conduct myself if I'm fortunate enough to earn your vote as President of the United States. I want to finally get something done on Medicare. I want to make sure prescription drugs are available for all seniors. And I want seniors to have additional choices when it comes to choosing their health care plans. I want to finally get something done on Social Security. I want to make sure the seniors have the promise made will be a promise kept, but I want younger workers to be able to manage some of their own money, some of their own payroll taxes in the private sector under certain guidelines to get a better rate of return on your own money. I want to rebuild our military to keep the peace. I want to have a strong hand when it comes to the United States in world affairs. I don't want to try to put our troops in all places at all times. I don't want to be the world's policeman, I want to be the world's peacemaker by having a military of high morale and a military that is well-equipped. I want anti-ballistic missile systems to protect ourselves and our allies from a rogue nation that may try to hold us hostage or blackmail our allies and friends. I want to make sure the education system fulfills its hope and promise. I've had a strong record of working with Democrats and Republicans in Texas to make sure no child is left behind. I understand the limited role of the federal government, but it could be a constructive role when it comes to reform, by insisting that there be a strong accountability systems. My intentions are to earn your vote and earn your confidence. I'm asking for your vote. I want you to be on my team. And for those of you working, thanks from the bottom of my heart. For those of you making up your mind, I would be honored to have your support. MODERATOR: Vice President Gore, two minutes. GORE: I want to thank everybody who watched and listened tonight because this is indeed a crucial time in American history. We're at a fork in the road. We have this incredible prosperity, but a lot of people have been left behind. And we have a very important decision to make. Will we use the prosperity to enrich all of our families and not just a few? One important way of looking at this is to ask who are you going to fight for? Throughout my career in public service, I have fought for the working men and women of this country, middle-class families. Why? Because you are the ones who have the hardest time paying taxes, the hardest time making ends meet. You are the ones who are making car payments and mortgage payments and doing right by your kids. And a lot of times there are powerful forces that are against you. Make no mistake about it, they do have undue influence in Washington, D.C. and it makes a difference if you have a president who will fight for you. I know one thing about the position of president, it's the only position in our Constitution that is filled by an individual who is given the responsibility to fight not just for one state or one district or the well-connected or wealthy, but to fight for all of the people, including especially those who most need somebody who will stand up and take on whatever powerful forces might stand in the way. There is a woman named Winifred Skinner here tonight from Iowa. I mentioned her earlier. She's 79 years old. She has Social Security. I'm not going to cut her benefits or support any proposal that would. She gets a small pension, but in order to pay for her prescription drug benefits, she has to go out seven days a week several hours a day picking up cans. She came all the way from Iowa in a Winnebago with her poodle in order attend here tonight. I want to tell her, I'll fight for a prescription drug benefit for all seniors and fight for the people of this country for a prosperity that benefits all. MODERATOR: We will continue this dialogue next week on October 11th at Wake Forest University in Winston-Salem, North Carolina. The format then will be more informal, more conversational with the two candidates seated at a table with me. The third will be October 17th at Washington University in St. Louis, and that will follow a town-hall type format. October 5 there is a 90-minute debate between Senator Joe Lieberman and Secretary Dick Cheney. It will be held at Center College in Danville, Kentucky. The moderator will be Bernard Shaw of CNN. Thank you, Governor Bush, Vice President Gore. See you next week. For now from Boston, I'm Jim Lehrer. Thank you, and good night. (APPLAUSE)
