# Presidential Debate in Kansas City, Missouri

**Date:** October 21, 1984
**Source:** https://www.presidency.ucsb.edu/documents/debate-between-the-president-and-former-vice-president-walter-f-mondale-kansas-city

---

Ms. Ridings. Good evening from the Municipal Auditorium in Kansas City. I am Dorothy Ridings, the president of the League of Women Voters, the sponsor of this final Presidential debate of the 1984 campaign between Republican Ronald Reagan and Democrat Walter Mondale. Our panelists for tonight's debate on defense and foreign policy issues are Georgie Anne Geyer, syndicated columnist for Universal Press Syndicate; Marvin Kalb, chief diplomatic correspondent for NBC News; Morton Kondracke, executive editor of the New Republic magazine; and Henry Trewhitt, diplomatic correspondent for the Baltimore Sun. Edwin Newman, formerly of NBC News and now a syndicated columnist for King Features, is our moderator. Ed. Mr. Newman. Dorothy Ridings, thank you. A brief word about our procedure tonight. The first question will go to Mr. Mondale. He'll have 2 1/2 minutes to reply. Then the panel member who put the question will ask a followup. The answer to that will be limited to 1 minute. After that, the same question will be put to President Reagan. Again, there will be a followup. And then each man will have 1 minute for rebuttal. The second question will go to President Reagan first. After that, the alternating will continue. At the end there will be 4-minute summations, with President Reagan going last. We have asked the questioners to be brief. Let's begin. Ms. Geyer, your question to Mr. Mondale. Central America Ms. Geyer. Mr. Mondale, two related questions on the crucial issue of Central America. You and the Democratic Party have said that the only policy toward the horrendous civil wars in Central America should be on the economic development and negotiations, with perhaps a quarantine of Marxist Nicaragua. Do you believe that these answers would in any way solve the bitter conflicts there? Do you really believe that there is no need to resort to force at all? Are not the solutions to Central America's gnawing problems simply, again, too weak and too late? Mr. Mondale. I believe that the question oversimplifies the difficulties of what we must do in Central America. Our objectives ought to be to strengthen the democracies, to stop Communist and other extremist influences, and stabilize the community in that area. To do that we need a three-pronged attack: one is military assistance to our friends who are being pressured; secondly, a strong and sophisticated economic aid program and human rights program that offers a better life and a sharper alternative to the alternative offered by the totalitarians who oppose us; and finally, a strong diplomatic effort that pursues the possibilities of peace in the area. That's one of the big disagreements that we have with the President—that they have not pursued the diplomatic opportunities either within El Salvador or as between the countries and have lost time during which we might have been able to achieve a peace This brings up the whole question of what Presidential leadership is all about. I think the lesson in Central America, this recent embarrassment in Nicaragua where we are giving instructions for hired assassins, hiring criminals, and the rest—all of this has strengthened our opponents. A President must not only assure that we're tough, but we must also be wise and smart in the exercise of that power. We saw the same thing in Lebanon, where we spent a good deal of America's assets. But because the leadership of this government did not pursue wise policies, we have been humiliated, and our opponents are stronger. The bottom line of national strength is that the President must be in command, he must lead. And when a President doesn't know that submarine missiles are recallable, says that 70 percent of our strategic forces are conventional, discovers 3 years into his administration that our arms control efforts have failed because he didn't know that most Soviet missiles were on land—these are things a President must know to command. A President is called the Commander in Chief. And he's called that because he's supposed to be in charge of the facts and run our government and strengthen our nation. Ms. Geyer. Mr. Mondale, if I could broaden the question just a little bit: Since World War II, every conflict that we as Americans have been involved with has been in nonconventional or irregular terms. And yet, we keep fighting in conventional or traditional military terms. The Central American wars are very much in the same pattern as China, as Lebanon, as Iran, as Cuba, in their early days. Do you see any possibility that we are going to realize the change in warfare in our time, or react to it in those terms? Mr. Mondale. We absolutely must, which is why I responded to your first question the way I did. It's much more complex. You must understand the region; you must understand the politics in the area; you must provide a strong alternative; and you must show strength—and all at the same time. That's why I object to the covert action in Nicaragua. That's a classic example of a strategy that's embarrassed us, strengthened our opposition, and undermined the moral authority of our people and our country in the region. Strength requires knowledge, command. We've seen in the Nicaraguan example a policy that has actually hurt us, strengthened our opposition, and undermined the moral authority of our country in that region. Ms. Geyer. Mr. President, in the last few months it has seemed more and more that your policies in Central America were beginning to work. Yet, just at this moment, we are confronted with the extraordinary story of a CIA guerrilla manual for the anti-Sandinista contras whom we are backing, which advocates not only assassinations of Sandinistas but the hiring of criminals to assassinate the guerrillas we are supporting in order to create martyrs. Is this not, in effect, our own state-supported terrorism? The President. No, but I'm glad you asked that question, because I know it's on many peoples' minds. I have ordered an investigation. I know that the CIA is already going forward with one. We have a gentleman down in Nicaragua who is on contract to the CIA, advising—supposedly on military tactics—the contras. And he drew up this manual. It was turned over to the agency head of the CIA in Nicaragua to be printed. And a number of pages were excised by that agency head there, the man in charge, and he sent it on up here to CIA, where more pages were excised before it was printed. But some way or other, there were 12 of the original copies that got out down there and were not submitted for this printing process by the CIA. Now, those are the details as we have them. And as soon as we have an investigation and find out where any blame lies for the few that did not get excised or changed, we certainly are going to do something about that. We'll take the proper action at the proper time. I was very interested to hear about Central America and our process down there, and I thought for a moment that instead of a debate I was going to find Mr. Mondale in complete agreement with what we're doing, because the plan that he has outlined is the one we've been following for quite some time, including diplomatic processes throughout Central America and working closely with the Contadora group. So, I can only tell you about the manual-that we're not in the habit of assigning guilt before there has been proper evidence produced and proof of that guilt. But if guilt is established, whoever is guilty we will treat with that situation then, and they will be removed. Ms. Geyer. Well, Mr. President, you are implying then that the CIA in Nicaragua is directing the contras there. I'd also like to ask whether having the CIA investigate its own manual in such a sensitive area is not sort of like sending the fox into the chicken coop a second time? The President. I'm afraid I misspoke when I said a CIA head in Nicaragua. There's not someone there directing all of this activity. There are, as you know, CIA men stationed in other countries in the world and, certainly, in Central America. And so it was a man down there in that area that this was delivered to, and he recognized that what was in that manual was in direct contravention of my own Executive order, in December of 1981, that we would have nothing to do with regard to political assassinations. Mr. Newman. Mr. Mondale, your rebuttal. Mr. Mondale. What is a President charged with doing when he takes his oath of office? He raises his right hand and takes an oath of office to take care to faithfully execute the laws of the land. A President can't know everything, but a President has to know those things that are essential to his leadership and the enforcement of our laws. This manual—several thousands of which were produced—was distributed, ordering political assassinations, hiring of criminals, and other forms of terrorism. Some of it was excised, but the part dealing with political terrorism was continued. How can this happen? How can something this serious occur in an administration and have a President of the United States in a situation like this say he didn't know? A President must know these things. I don't know which is worse, not knowing or knowing and not stopping it. And what about the mining of the harbors in Nicaragua which violated international law? This has hurt this country, and a President's supposed to command. Mr. Newman. Mr. President, your rebuttal. The President. Yes. I have so many things there to respond to, I'm going to pick out something you said earlier. You've been all over the country repeating something that, I will admit, the press has also been repeating-that I believed that nuclear missiles could be fired and then called back. I never, ever conceived of such a thing. I never said any such thing. In a discussion of our strategic arms negotiations, I said that submarines carrying missiles and airplanes carrying missiles were more conventional-type weapons, not as destabilizing as the land-based missiles, and that they were also weapons that—or carriers-that if they were sent out and there was a change, you could call them back before they had launched their missiles. But I hope that from here on you will no longer be saying that particular thing, which is absolutely false. How anyone could think that any sane person would believe you could call back a nuclear missile, I think is as ridiculous as the whole concept has been. So, thank you for giving me a chance to straighten the record. I'm sure that you appreciate that. [Laughter] Mr. Newman. Mr. Kalb, your question to President Reagan. Soviet Union Mr. Kalb. Mr. President, you have often described the Soviet Union as a powerful, evil empire intent on world domination. But this year you have said, and I quote. "If they want to keep their Mickey Mouse system, that's okay with me." Which is it, Mr. President? Do you want to contain them within their present borders and perhaps try to reestablish detente—or what goes for detente—or do you really want to roll back their empire? The President. I have said on a number of occasions exactly what I believe about the Soviet Union. I retract nothing that I have said. I believe that many of the things they have done are evil in any concept of morality that we have. But I also recognize that as the two great superpowers in the world, we have to live with each other. And I told Mr. Gromyko we don't like their system. They don't like ours. And we're not going to change their system, and they sure better not try to change ours. But between us, we can either destroy the world or we can save it. And I suggested that, certainly, it was to their common interest, along with ours, to avoid a conflict and to attempt to save the world and remove the nuclear weapons. And I think that perhaps we established a little better understanding. I think that in dealing with the Soviet Union one has to be realistic. I know that Mr. Mondale, in the past, has made statements as if they were just people like ourselves, and if we were kind and good and did something nice, they would respond accordingly. And the result was unilateral disarmament. We canceled the B-1 under the previous administration. What did we get for it? Nothing. The Soviet Union has been engaged in the biggest military buildup in the history of man at the same time that we tried the policy of unilateral disarmament, of weakness, if you will. And now we are putting up a defense of our own. And I've made it very plain to them, we seek no superiority. We simply are going to provide a deterrent so that it will be too costly for them if they are nursing any ideas of aggression against us. Now, they claim they're not. And I made it plain to them, we're not. There's been no change in my attitude at all. I just thought when I came into office it was time that there was some realistic talk to and about the Soviet Union. And we did get their attention. Regions Vital to U.S. Interests Mr. Kalb. Mr. President, perhaps the other side of the coin, a related question, sir. Since World War II, the vital interests of the United States have always been defined by treaty commitments and by Presidential proclamations. Aside from what is obvious, such as NATO, for example, which countries, which regions in the world do you regard as vital national interests of this country, meaning that you would send American troops to fight there if they were in danger? The President. Ah, well, now you've added a hypothetical there at the end, Mr. Kalb, about where we would send troops in to fight. I am not going to make the decision as to what the tactics could be, but obviously there are a number of areas in the world that are of importance to us. One is the Middle East, and that is of interest to the whole Western World and the industrialized nations, because of the great supply of energy upon which so many depend there. Our neighbors here in America are vital to us. We're working right now in trying to be of help in southern Africa with regard to the independence of Namibia and the removal of the Cuban surrogates, the thousands of them, from Angola. So, I can say there are a great many interests. I believe that we have a great interest in the Pacific Basin. That is where I think the future of the world lies. But I am not going to pick out one and, in advance, hypothetically say, "Oh, yes, we would send troops there." I don't want to send troops any place. Mr. Newman. I'm sorry, Mr. President. Sir, your time was up. The President. All right. Soviet Union Mr. Kalb. Mr. Mondale, you have described the Soviet leaders as, and I'm quoting, ". . . cynical, ruthless, and dangerous," suggesting an almost total lack of trust in them. In that case, what makes you think that the annual summit meetings with them that you have proposed will result in agreements that would satisfy the interests of this country? Mr. Mondale. Because the only type of agreements to reach with the Soviet Union are the types that are specifically defined, so we know exactly what they must do; subject to full verification, which means we know every day whether they're living up to it; and follow-ups, wherever we find suggestions that they're violating it; and the strongest possible terms. I have no illusions about the Soviet Union leadership or the nature of that state. They are a tough and a ruthless adversary, and we must be prepared to meet that challenge, and I would. Where I part with the President is that despite all of those differences we must, as past Presidents before this one have done, meet on the common ground of survival. And that's where the President has opposed practically every arms control agreement, by every President, of both political parties, since the bomb went off. And he now completes this term with no progress toward arms control at all, but with a very dangerous arms race underway instead. There are now over 2,000 more warheads pointed at us today than there were when he was sworn in, and that does not strengthen us. We must be very, very realistic in the nature of that leadership, but we must grind away and talk to find ways of reducing these differences, particularly where arms races are concerned and other dangerous exercises of Soviet power. There will be no unilateral disarmament under my administration. I will keep this nation strong. I understand exactly what the Soviets are up to, but that, too, is a part of national strength. To do that, a President must know what is essential to command and to leadership and to strength. And that's where the President's failure to master, in my opinion, the essential elements of arms control has cost us dearly. He's 3 years into this administration. He said he just discovered that most Soviet missiles are on land, and that's why his proposal didn't work. I invite the American people tomorrow-because I will issue the statement quoting President Reagan—he said exactly what I said he said. He said that these missiles were less dangerous than ballistic missiles because you could fire them, and you could recall them if you decided there'd been a miscalculation. Mr. Newman. I'm sorry, sir— Mr. Mondale. A President must know those things. Eastern Europe Mr. Kalb. A related question, Mr. Mondale, on Eastern Europe. Do you accept the conventional diplomatic wisdom that Eastern Europe is a Soviet sphere of influence? And if you do, what could a Mondale administration realistically do to help the people of Eastern Europe achieve the human rights that were guaranteed to them as a result of the Helsinki accords? Mr. Mondale. I think the essential strategy of the United States ought not accept any Soviet control over Eastern Europe. We ought to deal with each of these countries separately. We ought to pursue strategies with each of them, economic and the rest, that help them pull away from their dependence upon the Soviet Union. Where the Soviet Union has acted irresponsibly, as they have in many of those countries, especially, recently, in Poland, I believe we ought to insist that Western credits extended to the Soviet Union bear the market rate. Make the Soviets pay for their irresponsibility. That is a very important objective—to make certain that we continue to look forward to progress toward greater independence by these nations and work with each of them separately. Mr. Newman. Mr. President, your rebuttal. The President. Yes. I'm not going to continue trying to respond to these repetitions of the falsehoods that have already been stated here. But with regard to whether Mr. Mondale would be strong, as he said he would be, I know that he has a commercial out where he's appearing on the deck of the Nimitz and watching the F-14's take off. And that's an image of strength—except that if he had had his way when the Nimitz was being planned, he would have been deep in the water out there because there wouldn't have been any Nimitz to stand on—he was against it. [Laughter] He was against the F-14 fighter, he was against the M-1 tank, he was against the BI bomber, he wanted to cut the salary of all of the military, he wanted to bring home half of the American forces in Europe. And he has a record of weakness with regard to our national defense that is second to none. Audience member. Hear, hear! The President. Indeed, he was on that side virtually throughout all his years in the Senate. And he opposed even President Carter, when toward the end of his term President Carter wanted to increase the defense budget. Mr. Newman. Mr. Mondale, your rebuttal. Mr. Mondale. Mr. President, I accept your commitment to peace, but I want you to accept my commitment to a strong national defense. [Applause] I propose a budget—I have proposed a budget which would increase our nation's strength, in real terms, by double that of the Soviet Union. I'll tell you where we disagree. It is true over 10 years ago I voted to delay production of the F-14, and I'll tell you why. The plane wasn't flying the way it was supposed to be; it was a waste of money. Your definition of national strength is to throw money at the Defense Department. My definition of national strength is to make certain that a dollar spent buys us a dollar's worth of defense. There's a big difference between the two of us. A President must manage that budget. I will keep us strong, but you'll not do that unless you command that budget and make certain we get the strength that we need. You pay $500 for a $5 hammer, you're not buying strength. Mr. Newman. I would ask the audience not to applaud. All it does is take up time that we would like to devote to the debate. Mr. Kondracke, your question to Mr. Mondale. Use of Military Force Mr. Kondracke. Mr. Mondale, in an address earlier this year you said that before this country resorts to military force, and I'm quoting, "American interests should be sharply defined, publicly supported, congressionally sanctioned, militarily feasible, internationally defensible, open to independent scrutiny, and alert to regional history." Now, aren't you setting up such a gauntlet of tests here that adversaries could easily suspect that as President you would never use force to protect American interests? Mr. Mondale. No. As a matter of fact, I believe every one of those standards is essential to the exercise of power by this country. And we can see that in both Lebanon and in Central America. In Lebanon, this President exercised American power, all right, but the management of it was such that our marines were killed, we had to leave in humiliation, the Soviet Union became stronger, terrorists became emboldened. And it was because they did not think through how power should be exercised, did not have the American public with them on a plan that worked, that we ended up the way we did. Similarly, in Central America: What we're doing in Nicaragua with this covert war-which the Congress, including many Republicans, have tried to stop—is finally end up with a public definition of American power that hurts us, where we get associated with political assassins and the rest. We have to decline, for the first time in modern history, jurisdiction in the World Court because they'll find us guilty of illegal actions. And our enemies are strengthened from all of this. We need to be strong, we need to be prepared to use that strength, but we must understand that we are a democracy. We are a government by the people, and when we move, it should be for very severe and extreme reasons that serve our national interests and end up with a stronger country behind us. It is only in that way that we can persevere. Nicaragua Mr. Kondracke. You've been quoted as saying that you might quarantine Nicaragua. I'd like to know what that means. Would you stop Soviet ships, as President Kennedy did in 1962? And wouldn't that be more dangerous than President Reagan's covert war? Mr. Mondale. What I'm referring to there is the mutual self-defense provisions that exist in the Inter-American treaty, the so-called Rio Pact, that permits the nations, our friends in that region, to combine to take steps—diplomatic and otherwise—to prevent Nicaragua, when she acts irresponsibly in asserting power in other parts outside of her border, to take those steps, whatever they might be, to stop it. The Nicaraguans must know that it is the policy of our government that that leadership must stay behind the boundaries of their nation, not interfere in other nations. And by working with all of the nations in the region—unlike the policies of this administration and unlike the President said, they have not supported negotiations in that region—we will be much stronger, because we'll have the moral authority that goes with those efforts. Lebanon Mr. Kondracke. President Reagan, you introduced U.S. forces into Lebanon as neutral peacekeepers, but then you made them combatants on the side of the Lebanese Government. Eventually you were forced to withdraw them under fire, and now Syria, a Soviet ally, is dominant in the country. Doesn't Lebanon represent a major failure on the part of your administration and raise serious questions about your capacity as a foreign policy strategist and as Commander in Chief?. The President. No, Morton, I don't agree to all of those things. First of all, when we and our allies—the Italians, the French, and the United Kingdom—went into Lebanon, we went in there at the request of what was left of the Lebanese Government to be a stabilizing force while they tried to establish a government. But the first—pardon me—the first time we went in, we went in at their request because the war was going on right in Beirut between Israel and the PLO terrorists. Israel could not be blamed for that. Those terrorists had been violating their northern border consistently, and Israel chased them all the way to there. Then we went in with the multinational force to help remove, and did remove, more than 13,000 of those terrorists from Lebanon. We departed. And then the Government of Lebanon asked us back in as a stabilizing force while they established a government and sought to get the foreign forces all the way out of Lebanon and that they could then take care of their own borders. And we were succeeding. We were there for the better part of a year. Our position happened to be at the airport. Oh, there were occasional snipings and sometimes some artillery fire, but we did not engage in conflict that was out of line with our mission. I will never send troops anywhere on a mission of that kind without telling them that if somebody shoots at them, they can darn well shoot back. And this is what we did. We never initiated any kind of action; we defended ourselves there. But we were succeeding to the point that the Lebanese Government had been organized-if you will remember, there were the meetings in Geneva in which they began to meet with the hostile factional forces and try to put together some kind of a peace plan. We were succeeding, and that was why the terrorist acts began. There are forces there—and that includes Syria, in my mind—who don't want us to succeed, who don't want that kind of a peace with a dominant Lebanon, dominant over its own territory. And so, the terrorist acts began and led to the one great tragedy when they were killed in that suicide bombing of the building. Then the multilateral force withdrew for only one reason: We withdrew because we were no longer able to carry out the mission for which we had been sent in. But we went in in the interest of peace and to keep Israel and Syria from getting into the sixth war between them. And I have no apologies for our going on a peace mission. Mr. Kondracke. Mr. President, 4 years ago you criticized President Carter for ignoring ample warnings that our diplomats in Iran might be taken hostage. Haven't you done exactly the same thing in Lebanon, not once, but three times, with 300 Americans, not hostages, but dead? And you vowed swift retaliation against terrorists, but doesn't our lack of response suggest that you're just bluffing? The President. Morton, no. I think there's a great difference between the Government of Iran threatening our diplomatic personnel, and there is a government that you can see and can put your hand on. In the terrorist situation, there are terrorist factions all over. In a recent 30-day period, 37 terrorist acts in 20 countries have been committed. The most recent has been the one in Brighton. In dealing with terrorists, yes, we want to retaliate, but only if we can put our finger on the people responsible and not endanger the lives of innocent civilians there in the various communities and in the city of Beirut where these terrorists are operating. I have just signed legislation to add to our ability to deal, along with our allies, with this terrorist problem. And it's going to take all the nations together, just as when we banded together we pretty much resolved the whole problem of skyjackings sometime ago. Well, the red light went on. I could have gone on forever. Mr. Newman. Mr. Mondale, your rebuttal? Mr. Mondale. Groucho Marx said, "Who do you believe?—me, or your own eyes?" And what we have in Lebanon is something that the American people have seen. The Joint Chiefs urged the President not to put our troops in that barracks because they were indefensible. They went to him 5 days before they were killed and said, "Please, take them out of there." The Secretary of State admitted that this morning. He did not do so. The report following the explosion of the barracks disclosed that we had not taken any of the steps that we should have taken. That was the second time. Then the Embassy was blown up a few weeks ago, and once again none of the steps that should have been taken were taken. And we were warned 5 days before that explosives were on their way, and they weren't taken. The terrorists have won each time. The President told the terrorists he was going to retaliate. He didn't. They called their bluff. And the bottom line is that the United States left in humiliation, and our enemies are stronger. Mr. Newman. Mr. President, your rebuttal? The President. Yes. First of all, Mr. Mondale should know that the President of the United States did not order the marines into that barracks. That was a command decision made by the commanders on the spot and based with what they thought was best for the men there. That is one. On the other things that you've just said about the terrorists, I'm tempted to ask you what you would do. These are unidentified people, and after the bomb goes off, they're blown to bits because they are suicidal individuals who think they're going to go to paradise if they perpetrate such an act and lose their life in doing it. We are going to, as I say, we're busy trying to find the centers where these operations stem from, and retaliation will be taken. But we're not going to simply kill some people to say, "Oh, look, we got even." We want to know when we retaliate that we're retaliating with those who are responsible for the terrorist acts. And terrorist acts are such that our own United States Capitol in Washington has been bombed twice. Mr. Newman. Mr. Trewhitt, your question to President Reagan? The President's Age Mr. Trewhitt. Mr. President, I want to raise an issue that I think has been lurking out there for 2 or 3 weeks and cast it specifically in national security terms. You already are the oldest President in history. And some of your staff say you were tired after your most recent encounter with Mr. Mondale. I recall yet that President Kennedy had to go for days on end with very little sleep during the Cuban missile crisis. Is there any doubt in your mind that you would be able to function in such circumstances? The President. Not at all, Mr. Trewhitt, and I want you to know that also I will not make age an issue of this campaign. I am not going to exploit, for political purposes, my opponent's youth and inexperience. [Laughter and applause] If I still have time, I might add, Mr. Trewhitt, I might add that it was Seneca or it was Cicero, I don't know which, that said, "If it was not for the elders correcting the mistakes of the young, there would be no state." Strategic Missiles Mr. Trewhitt. Mr. President, I'd like to head for the fence and try to catch that one before it goes over, but I'll go on to another question. You and Mr. Mondale have already disagreed about what you had to say about recalling submarine-launched missiles. There's another, a similar issue out there that relates to your—it is said, at least, that you were unaware that the Soviet retaliatory power was based on land-based missiles. First, is that correct? Secondly, if it is correct, have you informed yourself in the meantime? And third, is it even necessary for the President to be so intimately involved in strategic details? The President. Yes, this had to do with our disarmament talks. And the whole controversy about land missiles came up because we thought that the strategic nuclear weapons, the most destabilizing are the land-based. You put your thumb on a button and somebody blows up 20 minutes later. So, we thought that it would be simpler to negotiate first with those. And then we made it plain, a second phase, take up the submarine-launched or the airborne missiles. The Soviet Union, to our surprise—and not just mine—made it plain when we brought this up that they placed, they thought, a greater reliance on the landbased missiles and, therefore, they wanted to take up all three. And we agreed. We said, "All right, if that's what you want to do." But it was a surprise to us, because they outnumbered us 64 to 36 in submarines and 20 percent more bombers capable of carrying nuclear missiles than we had. So, why should we believe that they had placed that much more reliance on landbased? But even after we gave in and said, "All right, let's discuss it all," they walked away from the table. We didn't. The President's Age Mr. Trewhitt. Mr. Mondale, I'm going to hang in there. Should the President's age and stamina be an issue in the political campaign? Mr. Mondale. No. And I have not made it an issue, nor should it be. What's at issue here is the President's application of his authority to understand what a President must know to lead this nation, secure our defense, and make the decisions and the judgments that are necessary. A minute ago the President quoted Cicero, I believe. I want to quote somebody a little closer to home, Harry Truman. He said, "The buck stops here." We just heard the President's answer for the problems at the barracks in Lebanon, where 241 marines were killed. What happened? First, the Joint Chiefs of Staff went to the President, said, "Don't put those troops there." They did it. And then 5 days before the troops were killed, they went back to the President, through the Secretary of Defense, and said, "Please, Mr. President, take those troops out of there because we can't defend them." They didn't do it. And we know what happened. After that, once again, our Embassy was exploded. This is the fourth time this has happened—an identical attack, in the same region, despite warnings—even public warnings—from the terrorists. Who's in charge? Who's handling this matter? That's my main point. Now, on arms control, we're completing 4 years. This is the first administration since the bomb went off that made no progress. We have an arms race underway instead. A President has to lead his government or it won't be done. Different people with different views fight with each other. For 3 1/2 years, this administration avoided arms control, resisted tabling arms control proposals that had any hope of agreeing, rebuked their negotiator in 1981 when he came close to an agreement, at least in principle, on medium-range weapons. And we have this arms race underway. And a recent book that just came out by perhaps the Nation's most respected author in this field, Strobe Talbott, called "Deadly Gambits," concludes that this President has failed to master the essential details needed to command and lead us, both in terms of security and terms of arms control. That's why they call the President the Commander in Chief. Good intentions, I grant. But it takes more than that. You must be tough and smart. The President's Leadership Mr. Trewhitt. This question of leadership keeps arising in different forms in this discussion already. And the President, Mr. Mondale, has called you whining and vacillating, among the more charitable phrases-weak, I believe. It is a question of leadership. And he has made the point that you have not repudiated some of the semidiplomatic activity of the Reverend Jackson, particularly in Central America. Did you approve of his diplomatic activity? And are you prepared to repudiate him now? Mr. Mondale. I read his statement the other day. I don't admire Fidel Castro at all. And I've said that Che Guevara was a contemptible figure in civilization's history. I know the Cuban state as a police state, and all my life I've worked in a way that demonstrates that. But Jesse Jackson is an independent person. I don't control him. And let's talk about people we do control. In the last debate,1 the Vice President of the United States said that I said the marines had died shamefully and died in shame in Lebanon. I demanded an apology from Vice President Bush because I had, instead, honored these young men, grieved for their families, and think they were wonderful Americans that honored us all. What does the President have to say about taking responsibility for a Vice President who won't apologize for something like that? 1 Mr. Mondale was referring to an earlier debate between George Bush and Geraldine Ferarro, the Vice-Presidential candidates. Mr. Newman. Mr. President, your rebuttal? The President. Yes. I know it'll come as a surprise to Mr. Mondale, but I am in charge. And, as a matter of fact, we haven't avoided arms control talks with the Soviet Union. Very early in my administration I proposed—and I think something that had never been proposed by any previous administration—I proposed a total elimination of intermediate-range missiles, where the Soviets had better than a 10—and still have—better than a 10-to-1 advantage over the allies in Europe. When they protested that and suggested a smaller number, perhaps, I went along with that. The so-called negotiation that you said I walked out on was the so-called walk in the woods between one of our representatives and one of the Soviet Union, and it wasn't me that turned it down, the Soviet Union disavowed it. Mr. Newman. Mr. Mondale, your rebuttal? Mr. Mondale. There are two distinguished authors on arms control in this country-there are many others, but two that I want to cite tonight. One is Strobe Talbott in his classic book, "Deadly Gambits." The other is John Neuhaus, who's one of the most distinguished arms control specialists in our country. Both said that this administration turned down the "walk in the woods" agreement first, and that would have been a perfect agreement from the standpoint of the United States in Europe and our security. When Mr. Nitze, a good negotiator, returned, he was rebuked, and his boss was fired. This is the kind of leadership that we've had in this administration on the most deadly issue of our times. Now we have a runaway arms race. All they've got to show for 4 years in U.S.-Soviet relations is one meeting in the last weeks of an administration, and nothing before. They're tough negotiators, but all previous Presidents have made progress. This one has not. Mr. Newman. Ms. Geyer, your question to Mr. Mondale. Illegal Immigration Ms. Geyer. Mr. Mondale, many analysts are now saying that actually our number one foreign policy problem today is one that remains almost totally unrecognized: massive illegal immigration from economically collapsing countries. They are saying that it is the only real territorial threat to the American nation-state. You, yourself, said in the 1970's that we had a "hemorrhage on our borders." Yet today you have backed off any immigration reform, such as the balanced and highly crafted Simpson-Mazzoli bill. Why? What would you do instead today, if anything? Mr. Mondale. This is a very serious problem in our country, and it has to be dealt with. I object to that part of the Simpson-Mazzoli bill which I think is very unfair and would prove to be so. That is the part that requires employers to determine the citizenship of an employee before they're hired. I'm convinced that the result of this would be that people who are Hispanic, people who have different languages or speak with an accent, would find it difficult to be employed. I think that's wrong. We've never had citizenship tests in our country before, and I don't think we should have a citizenship card today. That is counterproductive. I do support the other aspects of the Simpson-Mazzoli bill that strengthen enforcement at the border, strengthen other ways of dealing with undocumented workers in this difficult area and dealing with the problem of settling people who have lived here for many, many years and do not have an established status. I have further strongly recommended that this administration do something it has not done, and that is to strengthen enforcement at the border, strengthen the officials in this government that deal with undocumented workers, and to do so in a way that's responsible and within the Constitution of the United States. We need an answer to this problem, but it must be an American answer that is consistent with justice and due process. Everyone in this room, practically, here tonight, is an immigrant. We came here loving this nation, serving it, and it has served all of our most bountiful dreams. And one of those dreams is justice. And we need a measure—and I will support a measure-that brings about those objectives but avoids that one aspect that I think is very serious. The second part is to maintain and improve relations with our friends to the south. We cannot solve this problem all on our own. And that's why the failure of this administration to deal in an effective and a good-faith way with Mexico, with Costa Rica, with the other nations in trying to find a peaceful settlement to the dispute in Central America has undermined our capacity to effectively deal diplomatically in this area as well. Ms. Geyer. Sir, people as well-balanced and just as Father Theodore Hesburgh at Notre Dame, who headed the select commission on immigration, have pointed out repeatedly that there will be no immigration reform without employer sanctions, because it would be an unbalanced bill, and there would be simply no way to enforce it. However, putting that aside for the moment, your critics have also said repeatedly that you have not gone along with the bill or with any immigration reform because of the Hispanic groups—or Hispanic leadership groups—who actually do not represent what the Hispanic-Americans want, because polls show that they overwhelmingly want some kind of immigration reform. Can you say, or how can you justify your position on this? And how do you respond to the criticism that this is another, or that this is an example of your flip-flopping and giving in to special interest groups at the expense of the American nation? Mr. Mondale. I think you're right that the polls show that the majority of Hispanics want that bill, so I'm not doing it for political reasons. I'm doing it because all my life I've fought for a system of justice in this country, a system in which every American has a chance to achieve the fullness in life without discrimination. This bill imposes upon employers the responsibility of determining whether somebody who applies for a job is an American or not. And just inevitably, they're going to be reluctant to hire Hispanics or people with a different accent. If I were dealing with politics here, the polls show the American people want this. I am for reform in this area, for tough enforcement at the border, and for many other aspects of the Simpson-Mazzoli bill, but all my life I've fought for a fair nation. And despite the politics of it, I stand where I stand, and I think I'm right, and before this fight is over we're going to come up with a better bill, a more effective bill that does not undermine the liberties of our people. Ms. Geyer. Mr. President, you, too, have said that our borders are out of control. Yet this fall you allowed the Simpson-Mazzoli bill—which would at least have minimally protected our borders and the rights of citizenship—because of a relatively unimportant issue of reimbursement to the States for legalized aliens. Given that, may I ask what priority can we expect you to give this forgotten national security element? How sincere are you in your efforts to control, in effect, the nation-state that is the United States? The President. Georgie Anne, we, believe me, supported the Simpson-Mazzoli bill strongly—and the bill that came out of the Senate. However, there were things added in in the House side that we felt made it less of a good bill; as a matter of fact, made it a bad bill. And in conference—we stayed with them in conference all the way to where even Senator Simpson did not want the bill in the manner in which it would come out of the conference committee. There were a number of things in there that weakened that bill. I can't go into detail about them here. But it is true our borders are out of control. It is also true that this has been a situation on our borders back through a number of administrations. And I supported this bill. I believe in the idea of amnesty for those who have put down roots and who have lived here even though sometime back they may have entered illegally. With regard to the employer sanctions, we must have that not only to ensure that we can identify the illegal aliens, but also, while some keep protesting about what it would do to employers, there is another employer that we shouldn't be so concerned about, and these are employers down through the years who have encouraged the illegal entry into this country because they then hire these individuals and hire them at starvation wages and with none of the benefits that we think are normal and natural for workers in our country, and the individuals can't complain because of their illegal status. We don't think that those people should be allowed to continue operating free. And this was why the provisions that we had in with regard to sanctions, and so forth—and I'm going to do everything I can, and all of us in the administration are, to join in again when Congress is back at it to get an immigration bill that will give us, once again, control of our borders. And with regard to friendship below the border and with the countries down there, yes, no administration that I know has established the relationship that we have with our Latin friends. But as long as they have an economy that leaves so many people in dire poverty and unemployment, they are going to seek that employment across our borders. And we work with those other countries. Ms. Geyer. Mr. President, the experts also say that the situation today is terribly different quantitatively—qualitatively different from what it has been in the past because of the gigantic population growth. For instance, Mexico's population will go from about 60 million today to 120 million at the turn of the century. Many of these people will be coming into the United States not as citizens, but as illegal workers. You have repeatedly said recently that you believe that Armageddon, the destruction of the world, may be imminent in our times. Do you ever feel that we are in for an Armageddon or a situation, a time of anarchy, regarding the population explosion in the world? The President. No. As a matter of fact, the population explosion, if you look at the actual figures, has been vastly exaggerated—over exaggerated. As a matter of fact, there are some pretty scientific and solid figures about how much space there still is in the world and how many more people we can have. It's almost like going back to the Malthusian theory, when even then they were saying that everyone would starve with the limited population they had then. But the problem of population growth is one, here, with regard to our immigration. And we have been the safety valve, whether we wanted to or not, with the illegal entry here, in Mexico, where their population is increasing and they don't have an economy that can absorb them and provide the jobs. And this is what we're trying to work out, not only to protect our own borders but to have some kind of fairness and recognition of that problem. Mr. Newman. Mr. Mondale, your rebuttal? Mr. Mondale. One of the biggest problems today is that the countries to our south are so desperately poor that these people who will almost lose their lives if they don't come north, come north despite all the risks. And if we're going to find a permanent, fundamental answer to this, it goes to American economic and trade policies that permit these nations to have a chance to get on their own two feet and to get prosperity, so that they can have jobs for themselves and their people. And that's why this enormous national debt, engineered by this administration, is harming these countries in fueling this immigration. These high interest rates—real rates that have doubled under this administration—have had the same effect on Mexico and so on, and the cost of repaying those debts is so enormous that it results in massive unemployment, hardship, and heartache. And that drives our friends to the south up into our region, and we need to end those deficits as well. Mr. Newman. Mr. President, your rebuttal. The President. Well, my rebuttal is I've heard the national debt blamed for a lot of things, but not for illegal immigration across our border— [laughter] —and it has nothing to do with it. But with regard to these high interest rates, too, at least give us the recognition of the fact that when you left office, Mr. Mondale, they were 21 1/2—the prime rate. It's now 12 1/4, and I predict it'll be coming down a little more shortly. So, we're trying to undo some of the things that your administration did. [Applause] Mr. Newman. No applause, please. Mr. Kalb, your question to President Reagan. Armageddon Mr. Kalb. Mr. President, I'd like to pick up this Armageddon theme. You've been quoted as saying that you do believe, deep down, that we are heading for some kind of biblical Armageddon. Your Pentagon and your Secretary of Defense have plans for the United States to fight and prevail in a nuclear war. Do you feel that we are now heading perhaps, for some kind of nuclear Armageddon? And do you feel that this country and the world could survive that kind of calamity? The President. Mr. Kalb, I think what has been hailed as something I'm supposedly, as President, discussing as principle is the recall of just some philosophical discussions with people who are interested in the same things; and that is the prophecies down through the years, the biblical prophecies of what would portend the coming of Armageddon, and so forth, and the fact that a number of theologians for the last decade or more have believed that this was true, that the prophecies are coming together that portend that. But no one knows whether Armageddon, those prophecies mean that Armageddon is a thousand years away or day after tomorrow. So, I have never seriously warned and said we must plan according to Armageddon. Now, with regard to having to say whether we would try to survive in the event of a nuclear war, of course we would. But let me also point out that to several parliaments around the world, in Europe and in Asia, I have made a statement to each one of them, and I'll repeat it here: A nuclear war cannot be won and must never be fought. And that is why we are maintaining a deterrent and trying to achieve a deterrent capacity to where no one would believe that they could start such a war and escape with limited damage. But the deterrent—and that's what it is for—is also what led me to propose what is now being called the Star Wars concept, but propose that we research to see if there isn't a defensive weapon that could defend against incoming missiles. And if such a defense could be found, wouldn't it be far more humanitarian to say that now we can defend against a nuclear war by destroying missiles instead of slaughtering millions of people? Strategic Defense Initiative Mr. Kalb. Mr. President, when you made that proposal, the so-called Star Wars proposal, you said, if I'm not mistaken, that you would share this very super-sophisticated technology with the Soviet Union. After all of the distrust over the years, sir, that you have expressed towards the Soviet Union, do you really expect anyone to take seriously that offer that you would share the best of America's technology in this weapons area with our principal adversary? The President. Why not? What if we did-and I hope we can; we're still researching-what if we come up with a weapon that renders those missiles obsolete? There has never been a weapon invented in the history of man that has not led to a defensive, a counter-weapon. But suppose we came up with that? Now, some people have said, "Ah, that would make war imminent, because they would think that we could launch a first strike because we could defend against the enemy." But why not do what I have offered to do and asked the Soviet Union to do? Say, "Look, here's what we can do. We'll even give it to you. Now, will you sit down with us and once and for all get rid, all of us, of these nuclear weapons and free mankind from that threat?" I think that would be the greatest use of a defensive weapon. Mr. Kalb. Mr. Mondale, you've been very sharply critical of the President's Strategic Defense Initiative. And yet, what is wrong with a major effort by this country to try to use its best technology to knock out as many incoming nuclear warheads as possible? Mr. Mondale. First of all, let me sharply disagree with the President on sharing the most advanced, the most dangerous, the most important technology in America with the Soviet Union. We have had 'for many years, understandably, a system of restraints on high technology because the Soviets are behind us. And any research or development along the Star Wars schemes would inevitably involve our most advanced computers, our most advanced engineering. And the thought that we would share this with the Soviet Union is, in my opinion, a total non-starter. I would not let the Soviet Union get their hands on it at all. Now, what's wrong with Star Wars? There's nothing wrong with the theory of it. If we could develop a principle that would say both sides could fire all their missiles and no one would get hurt, I suppose it's a good idea. But the fact of it is we're so far away from research that even comes close to that, that the Director of Engineering Research at the Defense Department said to get there we would have to solve eight problems, each of which are more difficult than the atomic bomb and the Manhattan project. It would cost something like a trillion dollars to test and deploy weapons. The second thing is this all assumes that the Soviets wouldn't respond in kind. And they always do. We don't get behind. They won't get behind. And that's been the tragic story of the arms race. We have more at stake in space satellites than they do. If we could stop, right now, the testing and the deployment of these space weapons-and-the President's proposals go clear beyond research; if it was just research we wouldn't have any argument, because maybe someday, somebody will think of something—but to commit this nation to a buildup of antisatellite and space weapons at this time, in their crude state, would bring about an arms race that's very dangerous indeed. One final point. The most dangerous aspect of this proposal is, for the first time, we would delegate to computers the decision as to whether to start a war. That's dead wrong. There wouldn't be time for a President to decide; it would be decided by these remote computers. It might be an oil fire, it might be a jet exhaust, the computer might decide it's a missile—and off we go. Why don't we stop this madness now and draw a line and keep the heavens free from war? [Applause] Nuclear Freeze Mr. Kalb. Mr. Mondale, in this general area, sir, of arms control, President Carter's national security adviser, Zbigniew Brzezinski, said, "A nuclear freeze is a hoax." Yet the basis of your arms proposals, as I understand them, is a mutual and verifiable freeze on existing weapons systems. In your view, which specific weapons systems could be subject to a mutual and verifiable freeze, and which could not? Mr. Mondale. Every system that is verifiable should be placed on the table for negotiations for an agreement. I would not agree to any negotiations or any agreement that involved conduct on the part of the Soviet Union that we couldn't verify every day. I would not agree to any agreement in which the United States security interest was not fully recognized and supported. That's why we say mutual and verifiable freezes. Now, why do I support the freeze? Because this ever-rising arms race madness makes both nations less secure. It's more difficult to defend this nation. It's putting a hair-trigger on nuclear war. This administration, by going into the Star Wars system, is going to add a dangerous new escalation. We have to be tough on the Soviet Union, but I think the American people— Mr. Newman. Your time is up, Mr. Mondale. Mr. Mondale. —and the people of the Soviet Union want it to stop. Mr. Newman. President Reagan, your rebuttal? The President. Yes, my rebuttal, once again, is that this invention that has just been created here of how I would go about rolling over for the Soviet Union—no, Mr. Mondale, my idea would be with that defensive weapon that we would sit down with them and then say, "Now, are you willing to join us? Here's what we"—give them a demonstration and then say—"Here's what we can do. Now, if you're willing to join us in getting rid of all the nuclear weapons in the world, then we'll give you this one, so that we would both know that no one can cheat; that we're both got something that if anyone tries to cheat .... " But when you keep star-warring it—I never suggested where the weapons should be or what kind; I'm not a scientist. I said, and the Joint Chiefs of Staff agreed with me, that it was time for us to turn our research ability to seeing if we could not find this kind of defensive weapon. And suddenly somebody says, "Oh, it's got to be up there, and it's Star Wars," and so forth. I don't know what it would be, but if we can come up with one, I think the world will be better off. Mr. Newman. Mr. Mondale, your rebuttal. Mr. Mondale. Well, that's what a President's supposed to know—where those weapons are going to be. If they're space weapons, I assume they'll be in space. [Laughter] If they're antisatellite weapons, I assume they're going to be aimed against satellites. Now, this is the most dangerous technology that we possess. The Soviets try to spy on us, steal this stuff. And to give them technology of this kind, I disagree with. You haven't just accepted research, Mr. President. You've set up a Strategic Defense Initiative, an agency, you're beginning to test, you're talking about deploying, you're asking for a budget of some $30 billion for this purpose. This is an arms escalation. And we will be better off, far better off, if we stop right now, because we have more to lose in space then they do. If someday, somebody comes along with an answer, that's something else. But that there would be an answer in our lifetime is unimaginable. Why do we start things that we know the Soviets will match and make us all less secure? That's what a President's for. Mr. Newman. Mr. Kondracke, your question to Mr. Mondale. Strategic Weapons Mr. Kondracke. Mr. Mondale, you say that with respect to the Soviet Union you want to negotiate a mutual nuclear freeze, yet you would unilaterally give up the MX missile and the B-1 bomber before the talks have even begun. And you have announced, in advance, that reaching an agreement with the Soviets is the most important thing in the world to you. Now, aren't you giving away half the store before you even sit down to talk? Mr. Mondale. No. As a matter of fact, we have a vast range of technology and weaponry right now that provides all the bargaining chips that we need. And I support the air launch cruise missile, the ground launch cruise missile, the Pershing missile, the Trident submarine, the D-5 submarine, Stealth technology, the Midgetman—we have a whole range of technology. Why I disagree with the MX is that it's a sitting duck. It'll draw an attack. It puts a hair-trigger, and it is a dangerous, destabilizing weapon. And the B-1 is similarly to be opposed, because for 15 years the Soviet Union has been preparing to meet the B-1. The Secretary' of Defense himself said it would be a suicide mission if it were built. Instead, I want to build the Midgetman, which is mobile and thus less vulnerable, contributing to stability, and a weapon that will give us security and contribute to an incentive for arms control. That's why I'm for Stealth technology, to build a Stealth bomber—which I've supported for years-that can penetrate the Soviet air defense system without any hope that they can perceive where it is because their radar system is frustrated. In other words, a President has to make choices. This makes us stronger. The final point is that we can use this money that we save on these weapons to spend on things that we really need. Our conventional strength in Europe is under strength. We need to strengthen that in order to assure our Western allies of our presence there, a strong defense, but also to diminish and reduce the likelihood of a commencement of a war and the use of nuclear weapons. It's in this way, by making wise choices, that we're stronger, we enhance the chances of arms control. Every President until this one has been able to do it, and this nation—or the world is more dangerous as a result. Nuclear Freeze Mr. Kondracke. I want to follow up on Mr. Kalb's question. It seems to me on the question of verifiability, that you do have some problems with the extent of the freeze. It seems to me, for example, that testing would be very difficult to verify because the Soviets encode their telemetry. Research would be impossible to verify. Numbers of warheads would be impossible to verify by satellite, except for with on-site inspection, and production of any weapon would be impossible to verify. Now, in view of that, what is going to be frozen? Mr. Mondale. I will not agree to any arms control agreement, including a freeze, that's not verifiable. Let's take your warhead principle. The warhead principle-there have been counting rules for years. Whenever a weapon is tested we count the number of warheads on it, and whenever that warhead is used we count that number of warheads, whether they have that number or less on it, or not. These are standard rules. I will not agree to any production restrictions—or agreements, unless we have the ability to verify those agreements. I don't trust the Russians. I believe that every agreement we reach must be verifiable, and I will not agree to anything that we cannot tell every day. In other words, we've got to be tough. But in order to stop this arms madness, we've got to push ahead with tough negotiations that are verifiable so that we know the Soviets are agreeing and living up to their agreement. Support for U.S. Allies Mr. Kondracke. Mr. President, I want to ask you a question about negotiating with friends. You severely criticized President Carter for helping to undermine two friendly dictators who got into trouble with their own people—the Shah of Iran and President Somoza of Nicaragua. Now there are other such leaders heading for trouble, including President Pinochet of Chile and President Marcos of the Philippines. What should you do, and what can you do to prevent the Philippines from becoming another Nicaragua? The President. Morton, I did criticize the President because of our undercutting of what was a stalwart ally—the Shah of Iran. And I am not at all convinced that he was that far out of line with his people or that they wanted that to happen. The Shah had done our bidding and carried our load in the Middle East for quite some time, and I did think that it was a blot on our record that we let him down. Have things gotten better? The Shah, whatever he might have done, was building low-cost housing, had taken land away from the Mullahs and was distributing it to the peasants so they could be landowners—things of that kind. But we turned it over to a maniacal fanatic who has slaughtered thousands and thousands of people, calling it executions. The matter of Somoza—no, I never defended Somoza. And, as a matter of fact, the previous administration stood by and so did I—not that I could have done anything in my position at that time—but for this revolution to take place. And the promise of the revolution was democracy, human rights, free labor unions, free press. And then, just as Castro had done in Cuba, the Sandinistas ousted the other parties to the revolution. Many of them are now the contras. They exiled some, they jailed some, they murdered some. And they installed a Marxist-Leninist totalitarian government. And what I have to say about this is, many times—and this has to do with the Philippines, also, I know there are things there in the Philippines that do not look good to us from the standpoint right now of democratic rights, but what is the alternative? It is a large Communist movement to take over the Philippines. They have been our friend since their inception as a nation. And I think that we've had enough of a record of letting—under the guise of revolution-someone that we thought was a little more right than we would be, letting that person go, and then winding up with totalitarianism, pure and simple, as the alternative. And I think that we're better off, for example with the Philippines, of trying to retain our friendship and help them right the wrongs we see, rather than throwing them to the wolves and then facing a Communist power in the Pacific. Mr. Kondracke. Mr. President, since the United States has two strategically important bases in the Philippines, would the overthrow of President Marcos constitute a threat to vital American interests and, if so, what would you do about it? The President. Well, as I say, we have to look at what an overthrow there would mean and what the government would be that would follow. And there is every evidence, every indication that that government would be hostile to the United States. And that would be a severe blow to our abilities there in the Pacific. Mr. Kondracke. And what would you do about it? Mr. Newman. Sorry. I'm sorry, you've asked the followup question. Mr. Mondale, your rebuttal? Mr. Mondale. Perhaps in no area do we disagree more than this administration's policies on human rights. I went to the Philippines as Vice President, pressed for human rights, called for the release of Aquino, and made progress that had been stalled on both the Subic and the Clark airfield bases. What explains this administration cozying up to the Argentine dictators after they took over? Fortunately, a democracy took over, but this nation was embarrassed by this current administration's adoption of their policies. What happens in South Africa, where, for example, the Nobel Prize winner, 2 days ago, said this administration is seen as working with the oppressive government of South Africa. That hurts this nation. We need to stand for human rights. We need to make it clear we're for human liberty. National security and human rights must go together. But this administration time and time again has lost its way in this field. Mr. Newman. President Reagan, your rebuttal. The President. Well, the invasion of Afghanistan didn't take place on our watch. I have described what has happened in Iran, and we weren't here then either. I don't think that our record of human rights can be assailed. I think that we have observed, ourselves, and have done our best to see that human rights are extended throughout the world. Mr. Mondale has recently announced a plan of his to get the democracies together and to work with the whole world to turn to democracy. And I was glad to hear him say that, because that's what we've been doing ever since I announced to the British Parliament that I thought we should do this. Human rights are not advanced when, at the same time, you then stand back and say, "Whoops, we didn't know the gun was loaded," and you have another totalitarian power on your hands. Mr. Newman. In this segment, because of the pressure of time, there will be no rebuttals, and there will be no followup questions. Mr. Trewhitt, your question to President Reagan. Mr. Trewhitt. One question to each candidate? Mr. Newman. One question to each candidate. Nuclear Weapons Mr. Trewhitt. Mr. President, could I take you back to something you said earlier, and if I'm misquoting you, please correct me. But I understood you to say that if the development of space military technology was successful, you might give the Soviets a demonstration and say, "Here it is," which sounds to me as if you might be trying to gain the sort of advantage that would enable you to dictate terms, and which I will then suggest to you might mean scrapping a generation of nuclear strategy called mutual deterrence in which we, in effect, hold each other hostage. Is that your intention? The President, Well, I can't say that I have roundtabled that and sat down with the Chiefs of Staff, but I have said that it seems to me that this could be a logical step in what is my ultimate goal, my ultimate dream, and that is the elimination of nuclear weapons in the world. And it seems to me that this could be an adjunct, or certainly a great assisting agent in getting that done. I am not going to roll over, as Mr. Mondale suggests, and give them something that could turn around and be used against us. But I think it's a very interesting proposal, to see if we can find, first of all, something that renders those weapons obsolete, incapable of their mission. But Mr. Mondale seems to approve MAD—MAD is mutual assured destruction-meaning, if you use nuclear weapons on us, the only thing we have to keep you from doing it is that we'll kill as many people of yours as you'll kill of ours. I think that to do everything we can to find, as I say, something that would destroy weapons and not humans is a great step forward in human rights. Mr. Trewhitt. Mr. Mondale, could I ask you to address the question of nuclear strategy then? The formal doctrine is very arcane, but I'm going to ask you to deal with it anyway. Do you believe in MAD, mutual assured destruction, mutual deterrence as it has been practiced for the last generation? Mr. Mondale. I believe in a sensible arms control approach that brings down these weapons to manageable levels. I would like to see their elimination. And in the meantime, we have to be strong enough to make certain that the Soviet Union never tempts US. Now, here we have to decide between generalized objectives and reality. The President says he wants to eliminate or reduce the number of nuclear weapons. But, in fact, these last 4 years have seen more weapons built, a wider and more vigorous arms race than in human history. He says he wants a system that will make nuclear wars safe, so nobody's going to get hurt. Well, maybe someday, somebody can dream of that. But why start an arms race now? Why destabilize our relationship? Why threaten our space satellites upon which we depend? Why pursue a strategy that would delegate to computers the question of starting a war? A President, to defend this country and to get arms control, must master what's going on. I accept his objective and his dream; we all do. But the hard reality is that we must know what we're doing and pursue those objectives that are possible in our time. He's opposed every effort of every President to do so, and in the 4 years of his administration he's failed to do so. And if you want a tough President who uses that strength to get arms control and draws the line in the heavens, vote for Walter Mondale. [Applause] Mr. Newman. Please, I must again ask the audience not to applaud, not to cheer, not to demonstrate its feelings in any way. We've arrived at the point in the debate now where we call for closing statements. You have the full 4 minutes, each of you. Mr. Mondale, will you go first? Closing Statements Mr. Mondale. I want to thank the League of Women Voters, the good citizens of Kansas City, and President Reagan for agreeing to debate this evening. This evening we talked about national strength. I believe we need to be strong, and I will keep us strong. But I think strength must also require wisdom and smarts in its exercise. That's key to the strength of our nation. A President must know the essential facts essential to command. But a President must also have a vision of where this nation should go. Tonight, as Americans, you have a choice. And you're entitled to know where we would take this country if you decide to elect us. As President, I would press for long-term, vigorous economic growth. That's why I want to get these debts down and these interest rates down, restore America's exports, help rural America, which is suffering so much, and bring the jobs back here for our children. I want this next generation to be the best educated in American history, to invest in the human mind and science again, so we're out front. I want this nation to protect its air, its water, its land, and its public health. America is not temporary; we're forever. And as Americans, our generation should protect this wonderful land for our children. I want a nation of fairness, where no one is denied the fullness of life or discriminated against, and we deal compassionately with those in our midst who are in trouble. And, above all, I want a nation that's strong. Since we debated 2 weeks ago, the United States and the Soviet Union have built a hundred more warheads, enough to kill millions of Americans and millions of Soviet citizens. This doesn't strengthen us. This weakens the chances of civilization to survive. I remember the night before I became Vice President. I was given the briefing and told that any time, night or day, I might be called upon to make the most fateful decision on Earth—whether to fire these atomic weapons that could destroy the human species. That lesson tells us two things: One, pick a President that you know will know if that tragic moment ever comes what he must know, because there'll be no time for staffing committees or advisers. A President must know right then. But above all, pick a President who will fight to avoid the day when that God-awful decision ever needs to be made. And that's why this election is so terribly important. America and Americans decide not just what's happening in this country. We are the strongest and most powerful free society on Earth. When you make that judgment, you are deciding not only the future of our nation; in a very profound respect, you're deciding the future of the world. We need to move on. It's time for America to find new leadership. Please, join me in this cause to move confidently and with a sense of assurance and command to build the blessed future of our nation. Mr. Newman. President Reagan, your summation, please. The President. Yes. My thanks to the League of Women Voters, to the panelists, the moderator, and to the people of Kansas City for their warm hospitality and greeting. I think the American people tonight have much to be grateful for—an economic recovery that has become expansion, freedom and, most of all, we are at peace. I am grateful for the chance to reaffirm my commitment to reduce nuclear weapons and, one day, to eliminate them entirely. The question before you comes down to this: Do you want to see America return to the policies of weakness of the last 4 years? Or do we want to go forward, marching together, as a nation of strength and that's going to continue to be strong? We shouldn't be dwelling on the past, or even the present. The meaning of this election is the future and whether we're going to grow and provide the jobs and the opportunities for all Americans and that they need. Several years ago, I was given an assignment to write a letter. It was to go into a time capsule and would be read in 100 years when that time capsule was opened. I remember driving down the California coast one day. My mind was full of what I was going to put in that letter about the problems and the issues that confront us in our time and what we did about them. But I couldn't completely neglect the beauty around me—the Pacific out there on one side of the highway, shining in the sunlight, the mountains of the coast range rising on the other side. And I found myself wondering what it would be like for someone-wondering if someone 100 years from now would be driving down that highway, and if they would see the same thing. And with that thought, I realized what a job I had with that letter. I would be writing a letter to people who know everything there is to know about us. We know nothing about them. They would know all about our problems. They would know how we solved them, and whether our solution was beneficial to them down through the years or whether it hurt them. They would also know that we lived in a world with terrible weapons, nuclear weapons of terrible destructive power, aimed at each other, capable of crossing the ocean in a matter of minutes and destroying civilization as we knew it. And then I thought to myself, what are they going to say about us, what are those people 100 years from now going to think? They will know whether we used those weapons or not. Well, what they will say about us 100 years from now depends on how we keep our rendezvous with destiny. Will we do the things that we know must be done and know that one day, down in history 100 years or perhaps before, someone will say, "Thank God for those people back in the 1980's for preserving our freedom, for saving for us this blessed planet called Earth, with all its grandeur and its beauty." You know, I am grateful to all of you for giving me the opportunity to serve you for these 4 years, and I seek reelection because I want more than anything else to try to complete the new beginning that we charted 4 years ago. George Bush, who I think is one of the finest Vice Presidents this country has ever had—George Bush and I have crisscrossed the country, and we've had, in these last few months, a wonderful experience. We have met young America. We have met your sons and daughters. Mr. Newman. Mr. President, I'm obliged to cut you off there under the rules of the debate. I'm sorry. The President. All right. I was just going to— Mr. Newman. Perhaps I should point out that the rules under which I did that were agreed upon by the two campaigns— The President. I know. Mr. Newman. — with the league, as you know, sir. The President. I know, yes. Mr. Newman. Thank you, Mr. President. Thank you, Mr. Mondale. Our thanks also to the panel, finally, to our audience. We thank you, and the League of Women Voters asks me to say to you, don't forget to vote on November 6th.
