# Presidential Debate in East Lansing, Michigan

**Date:** October 19, 1992
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-east-lansing-michigan

---

Jim Lehrer. Good evening. Welcome to this third and final debate among the three major candidates for President of the United States: Governor Bill Clinton, the Democratic nominee; President George Bush, the Republican nominee; and independent candidate Ross Perot. I am Jim Lehrer, of "The MacNeil/Lehrer NewsHour" on PBS. I will be the moderator for this debate, which is being sponsored by the Commission on Presidential Debates. It will be 90 minutes long. It is happening before an audience on the campus of Michigan State University in East Lansing. The format was conceived by and agreed to by representatives of the Bush and Clinton campaigns. And it is somewhat different than those used in the earlier debates. I will ask questions for the first half under rules that permit followups. A panel of three other journalists will ask questions in the second half under rules that do not. As always, each candidate will have 2 minutes, up to 2 minutes, to make a closing statement. The order of those as well as that for the formal questioning were all determined by a drawing. Gentlemen, again, welcome. And again, good evening. Credibility It seems, from what some of those voters said at your Richmond debate and from polling and other data, that each of you, fairly or not, faces serious voter concerns about the underlying credibility and believability of what each of you says you would do as President in the next 4 years. Governor Clinton, in accordance with the draw, those concerns about you are first. You are promising to create jobs, reduce the deficit, reform the health care system, rebuild the infrastructure, guarantee college education for everyone who is qualified, among many other things, all with financial pain only for the very rich. Some people are having trouble, apparently, believing that is possible. Should they have that concern? Governor Clinton. No. There are many people who believe that the only way we can get this country turned around is to tax the middle class more and punish them more. But the truth is that middle class Americans are basically the only group of Americans who have been taxed more in the 1980's and during the last 12 years even though their incomes have gone down. The wealthiest Americans have been taxed much less even though their incomes have gone up. Middle class people will have their fair share of changing to do and many challenges to face, including the challenge of becoming constantly reeducated. But my plan is a departure from trickle-down economics, just cutting taxes on the wealthiest Americans and getting out of the way. It's also a departure from tax-and-spend economics because you can't tax and divide an economy that isn't growing. I propose an American version of what works in other countries. I think we can do it better: invest and grow. I believe we can increase investment and reduce the deficit at the same time if we not only ask the wealthiest Americans and foreign corporations to pay their fair share, we also provide over $100 billion in tax relief in terms of incentives for new plants, new small businesses, new technologies, new housing, and for middle class families, and we have $140 billion of spending cuts. Invest and grow: raise some more money; spend the money on tax incentives to have growth in the private sector; take the money from the defense cuts and reinvest it in new transportation and communications and environmental cleanup systems. This will work. On this, as on so many other issues, I have a fundamental difference from the present administration. I don't believe trickle-down economics will work. Unemployment is up. Most people are working harder for less money than they were making 10 years ago. I think we can do better if we have the courage to change. Mr. Lehrer. Mr. President, a response. President Bush. Do I have one minute? Just the ground rules here. Mr. Lehrer. Well, you have roughly one minute. We can loosen that up a little bit. But go ahead. President Bush. He doesn't like trickle-down Government, but hey, I think he's talking about the Reagan-Bush years where we created 15 million jobs. The rich are paying a bigger percent of the total tax burden. What I don't like is trickle-down Government. I think Governor Clinton keeps talking about trickle-down, trickle-down, and he's still talking about spending more and taxing more. Government, he says, invest Government, grow Government. Government doesn't create jobs. If they do, they're make-work jobs. It's the private sector that creates jobs. And yes, we've got too many taxes on the American people, and we're spending too much. That's why I want to get the deficit down by controlling the growth of mandatory spending. It won't be painless. I think Mr. Perot put his finger on something there. It won't be painless, but we've got to get the job done. But not by raising taxes. Mr. and Mrs. America, when you hear him say we're going to tax only the rich, watch your wallet, because his figures don't add up, and he's going to sock it right to the middle class taxpayer and lower if he's going to pay for all the spending programs he's proposed. So we have a big difference on this trickle-down theory. I do not want any more trickle-down Government. It's gotten too big. I want to do something about that. Mr. Lehrer. Mr. Perot, what do you think of the Governor's approach, what he just laid out? Mr. Perot. Well, the basic problem with it is it doesn't balance the budget. If you forecast it out, you still will have a significant deficit under each of their plans, as I understand them. Our challenge is to stop the financial bleeding. If you take a patient into a hospital that's bleeding arterially, step one is to stop the bleeding. And we are bleeding arterially. There's only one way out of this, and that is to stop the deterioration of our job base, to have a growing, expanding job base to give us the tax base. See, balancing the budget is not nearly as difficult as paying off the $4 trillion debt and leaving our children the American dream intact. We have spent their money. We have got to pay it back. This is going to take fair-shared sacrifice. My plan balances the budget within 6 years. We didn't do it faster than that because we didn't want to disrupt the economy. We gave it off to a slow start and a fast finish to give the economy time to recover. But we faced it, and we did it. And we believe it's fair-shared sacrifice. The one thing I have done is lay it squarely on the table in front of the American people. You've had a number of occasions to see in detail what the plan is and at least you'll understand it. I think that's fundamental in our country that you know what you're getting into. Mr. Lehrer. Governor, the word "pain," one of the other leadership things that's put on you is that you don't speak of pain, that you speak of all things -- nobody's going to really have to suffer under your plan. You've heard what Mr. Perot has said. He said to do the things you want to do, you can't do it by just taking the money from the rich. That's what the President says as well. How do you respond to that? The numbers don't add up. Governor Clinton. I disagree with both of them. Let me just follow up here. I disagree with Mr. Perot that the answer is to put a 50-cent gas tax on the middle class and raise more taxes on the middle class and the working poor than on the wealthy. His own analysis says that unemployment will be slightly higher in 1995 under his plan than it is today. As far as what Mr. Bush says, he is the person who raised taxes on the middle class after saying he wouldn't. Just this year Mr. Bush vetoed a tax increase on the wealthy that gave middle class tax relief. He vetoed middle class tax relief this year. Furthermore, under this administration, spending has increased more than it has in the last 20 years, and he asked Congress to spend more money than it actually spent. Now, it's hard to outspend Congress, but he tried to for the last 3 years. So my view is the middle class is the -- they've been suffering, Jim. Now, should people pay more for Medicare if they can? Yes. Should they pay more for Social Security if they get more out of it than they've paid in and they're upper income people? Yes. But look what's happened to the middle class. Middle class Americans are working harder for less money than they were making 10 years ago, and they're paying higher taxes. The tax burden on them has not gone down; it has gone up. I don't think the answer is to slow the economy down more, drive unemployment up more, and undermine the health of the private sector. The answer is to invest and grow this economy. That's what works in other countries, and that's what will work here. Mr. Lehrer. As a practical matter, Mr. President, do you agree with the Governor when he says that the middle class -- the taxes on the middle class -- do your numbers agree that the taxes on the middle class have gone up during the last -- -- President Bush. I think everybody is paying too much taxes. He refers to one tax increase. Let me remind you it was a Democratic tax increase. I didn't want to do it, and I went along with it. I said I made a mistake. If I make a mistake, I admit it. That's quite different than some. But I think that's the American way. I think everyone is paying too much. But I think this idea that you can go out and -- then he hits me for vetoing a tax bill. Yes, I did, and the American taxpayer ought to be glad they have a President to stand up to a spending Congress. We remember what it was like when we had a spending President and a spending Congress and interest rates -- who remembers that -- they were 21.5 percent under Jimmy Carter, and inflation was 15. We don't want to go back to that. So yes, everybody's taxed too much, and I want to get the taxes down, but not by signing a tax bill that's going to raise taxes on people. Mr. Lehrer. Mr. President, when you said just then that you admit your mistakes, and you looked at Governor Clinton and said -- what mistake is it that you want him to admit to? President Bush. Well, the record in Arkansas. I mean, look at it. And that's what we're asking America to have? Now, look, he says Arkansas's a poor State. They are. But in almost every category, they're lagging. I'll give you an example. He talks about all the jobs he's created in 1 or 2 years. Over the last 10 years since he's been Governor, they're 30 percent behind. They're 30 percent of the national average. On pay for teachers, on all these categories, Arkansas is right near the very bottom. You haven't heard me mention this before, but we're getting close now, and I think it's about time I start putting things in perspective. I'm going to do that. It's not dirty campaigning, because he's been talking about my record for half a year here, 11 months here, and so we've got to do that. I've got to get it in perspective. What's his mistake? Admit it, that Arkansas is doing very, very badly against any standard: environment, support for police officers, whatever it is. Mr. Lehrer. Governor, is that true? Governor Clinton. Mr. Bush's Bureau of Labor Statistics says that Arkansas ranks first in the country in the growth of new jobs this year, first -- -- President Bush. This year. Governor Clinton. -- -- fourth in manufacturing jobs; fourth in the reduction of poverty; fourth in income increase. Over the last 10 years we've created manufacturing jobs much more rapidly than the national average. Over the last 5 years our income has grown more rapidly than the national average. We are second in tax burden, the second lowest tax burden in the country. We have the lowest per capita State and local spending in the country. We are low-spending, low tax burden. We've dramatically increased investment and our jobs are growing. I wish America had that kind of record, and I think most people looking at us tonight would like it if we had more jobs and a lower spending burden on the Government. Mr. Lehrer. Mr. Perot, if you were sitting at home now and just heard this exchange about Arkansas, who would you believe? Mr. Perot. I grew up five blocks from Arkansas. [Laughter] Let's put it in perspective. It's a beautiful State. It's a fairly rural State. It has a population less than Chicago or Los Angeles, about the size of Dallas and Fort Worth combined. So I think probably we're making a mistake night after night after night to cast the Nation's future on a unit that small. Mr. Lehrer. Why is that a mistake? Mr. Perot. It's irrelevant. [Laughter] Mr. Lehrer. What he did as Governor of Arkansas -- -- Mr. Perot. No, no, no. But you can't -- I could say that I ran a small grocery store on the corner, therefore, I extrapolate that into the fact that I could run Wal-Mart. That's not true. I carefully picked an Arkansas company, you notice there, Governor. Mr. Lehrer. Governor? Governor Clinton. Mr. Perot, with all respect, I think it is highly relevant, and I think that a $4 billion budget in State and Federal funds is not all that small. I think the fact that I took a State that was one of the poorest States in the country and had been for 153 years and tried my best to modernize its economy and to make the kind of changes that have generated support from people like the presidents of Apple Computer and Hewlett-Packard and some of the biggest companies in this country, 24 retired generals and admirals, and hundreds of business executives are highly relevant. And you know, I'm frankly amazed that since you grew up five blocks from there you would think that what goes on in that State is irrelevant. I think it's been pretty impressive. Mr. Perot. It's not -- -- Governor Clinton. And the people who have jobs and educations and opportunities that didn't have them 10 years ago don't think it's irrelevant at all. They think it's highly relevant and wish the rest of the country -- -- President Bush. I don't have a dog in this fight, but I'd like to get in on it. Governor Clinton. You think it's relevant. President Bush. Governor Clinton has to operate under a balanced budget amendment. He has to do it. That is the law. I'd like to see a balanced budget amendment for America, to protect the American taxpayers. Then that would discipline not only the executive branch but the spending Congress, the Congress that's been in control of one party, his party, for 38 years. We almost had it done. And that institution, the House of Representatives -- everyone's yelling "Clean House!" One of the reasons is we almost had it done, and the Speaker, very able, decent fellow, I might add, but he twisted the arms of some of the sponsors of that legislation and had them change their vote. What's relevant here is that tool, that discipline that he has to live by in Arkansas. And I'd like it for the American people. I want the line-item veto. I want a check-off so if the Congress can't do it, let people check off their income tax, 10 percent of it, to compel the Government to cut spending. If they can't do it, if the Congress can't do it, let them then have to do it across the board. That's what we call a sequester. That's the discipline we need. And I'm working for that to protect the American taxpayer against the big spenders. Leadership Mr. Lehrer. Mr. President, let's move to some of the leadership concerns that have been voiced about you. They relate to something you said in your closing statement in Richmond the other night about the President being the manager of crises, and that relates to an earlier criticism that you began to focus on the economy, on health care, on racial divisions in this country only after they became crises. Is that a fair criticism? President Bush. Jim, I don't think that's a fair shot. I hear it. I hear it echoed by political opponents, but I don't think it's fair. I think we've been fighting from day one to do something about the inner cities. I'm for enterprise zones. I have had it in every single proposal I've sent to the Congress. Now we hear a lot of talk, "Oh, well, we all want enterprise zones." Yet the House and the Senate can't send it down without loading it up with a lot of these Christmas tree ornaments they put on the legislation. I don't think in racial harmony that I'm a laggard on that. I've been speaking out since day one. We've gotten the Americans for Disabilities Act, which I think is one of the foremost pieces of civil rights legislation. And yes, it took me to veto two civil rights quota bills, because I don't believe in quotas, and I don't think the American people believe in quotas. I beat back the Congress on that, and then we passed a decent civil rights bill that offers guarantees against discrimination in employment, and that is good. I've spoken out over and over again against anti-Semitism and racism, and I think my record as a Member of Congress speaks for itself on that. What was the other part of it? Mr. Lehrer. Well, it's just that -- you've spoken to it, I mean, but the idea -- not so much in specifics -- -- President Bush. Yes. Mr. Lehrer. -- -- but that it has to be a crisis before it gets your attention. President Bush. I don't think that's true at all. I don't think that's true. But, you know, let others fire away on it. Mr. Lehrer. Do you think that's true, Mr. Perot? Mr. Perot. I'd like to just talk about issues, and so -- -- Mr. Lehrer. You don't think this is an issue? Mr. Perot. Well, no. But the point is that's a subjective thing. The subjective thing is when does President Bush react. It would be very difficult for me to answer that in any short period of time. Mr. Lehrer. Well, then, I'll phrase it differently then. He said the other night in his closing words in Richmond that one of the key things that he believes the American people should decide among the three of you, is who they want in charge if this country gets to a crisis. Now, that's what he said. And the rap on the President is that it's only crisis time that he focuses on some of these things. So my question to you -- we're going to talk about you in a minute. Mr. Perot. I thought you'd forgotten I was here. [Laughter] Mr. Lehrer. No, no, no. No, no. But my question to you is -- so, if you have nothing to say about it, fine. I'll go to Governor Clinton. But -- -- Mr. Perot. I will let the American people decide that. I would rather not critique the two candidates. Mr. Lehrer. All right. Governor, what do you think? Governor Clinton. The only thing I would say about that is I think that on the economy, Mr. Bush said for a long time there was no recession and then said it would be better to do nothing than to have a compromise effort with the Congress. He really didn't have a new economic program until over 1,300 days into his Presidency and not all of his health care initiative has been presented to the Congress even now. I think it's important to elect a President who is committed to getting this economy going again and who realizes we have to abandon trickle-down economics and put the American people first again and who will send programs to the Congress in the first 100 days to deal with the critical issues that America's crying out for leadership on: jobs, incomes, the health care crisis, the need to control the economy. Those things deserve to be dealt with from day one. I will deal with them from day one. They will be my first priority, not my election year concerns. Mr. Lehrer. Mr. President. President Bush. Well, I think you're overlooking that we have had major accomplishments in the first term. But if you're talking about protecting the taxpayer against his friends in the United States Congress, go back to what it was like when you had a Democratic President and a Democratic Congress. You don't have to go back to Herbert Hoover. Go back to Jimmy Carter. Interest rates were 21 percent. Inflation was 15 percent. The "misery index," unemployment, inflation added together, it was invented by the Democrats, went right through the roof. We've cut it in half, and all you hear about is how bad things are. You know, you remember the question, "Are you better off?" Well, is a homebuyer better off who can refinance the home because interest rates are down? Is a senior citizen better off because inflation is not wiping out their family savings? I think they are. Is the guy out of work better off? Of course he's not. But he's not going to be better off if we grow the Government, if we invest, as Governor Clinton says, invest in more Government. You've got to free up the private sector. You've got to let small business have more incentives. For 3 months -- three quarters I've been fighting, three quarters, been fighting to get the Congress to pass some incentives for small business, capital gains, investment tax allowance, credit for first-time homebuyers, and it's blocked by the Congress. Then if a little of it comes my way, they load it up with Christmas trees and tax increases. And I have to stand up in favor of the taxpayer. Staying the Course Mr. Lehrer. We have to talk about Ross Perot now, or he'll get me, I'm sure. Mr. Perot, on this issue that I have raised at the very beginning and we've been talking about, which is leadership as President of the United States, the concerns -- my reading of it, at least -- my concerns about you, as expressed by folks in the polls and other places, it goes like this: You've got a problem with General Motors. You took over $750 million, and you left. You had a problem in the spring and summer about some personal hits that you took as a potential candidate for President of the United States, and you walked out. Does that say anything relevant to how you would function as President of the United States? Mr. Perot. I think the General Motors thing is very relevant. I did everything I could to get General Motors to face its problems in the mid-eighties while it was still financially strong. They just wouldn't do it. Everybody now knows the terrible price they're paying by waiting until it's obvious to the brain dead that they have problems. [Laughter] Now, hundreds, thousands of good, decent people, whole cities up here in this State are adversely impacted because they would not move in a timely way. Our Government is at that point now. The thing that I am in this race for is to tap the American people on the shoulder and to say to every single one of you: Fix it while we're still relatively strong. If you have a heart problem, you don't wait until the heart attack to address it. So the General Motors experience is relevant. At the point when I could not get them to address those problems, I had created so much stress in the board, who wanted just to keep the Lawrence Welk music going, that they asked to buy my remaining shares. I sold them my remaining shares. They went their way; I went my way, because it was obvious we had a complete disagreement about what should be done with the company. But let's take my life in perspective. Again and again on complex, difficult tasks, I have stayed the course. When I was asked by our Government to do the POW project, within a year the Vietnamese had sent people into Canada to make arrangements to have me and my family killed. And I had five small children. And my family and I decided we would stay the course, and we lived with that problem for 3 years. Then I got into the Texans' war on drugs program, and the big-time drug dealers got all upset. Then when I had two people imprisoned in Iran, I could have left them there. I could have rationalized it. We went over, we got them out, and we brought them back home. And since then, for years, I have lived with the burden of the Middle East, where it's eye-for-an-eye and tooth-for-a-tooth country, in terms of their unhappiness with the fact that I was successful in that effort. Again and again and again, in the middle of the night, 2 or 3 o'clock in the morning, my Government has called me to take extraordinary steps for Americans in distress. And again and again and again, I have responded. And I didn't wilt, and I didn't quit. Now, what happened in July we've covered again and again and again. But I think in terms of the American people's concern about my commitment -- and I'm here tonight, folks. I've never quit supporting you as you put me on the ballot in the other 26 States. When you asked me to come back in, I came back in. And talk about not quitting, I'm spending my money on this campaign. The two parties are spending your money, taxpayer money. I've put my wallet on the table for you and your children. Over $60 million at least will go into this campaign to leave the American dream to you and your children, to get this country straightened out, because if anybody owes it to you, I do. I've lived the American dream. I'd like for your children to be able to live it, too. Mr. Lehrer. Governor, do you have a response to the staying the course question about Mr. Perot? Governor Clinton. I don't have any criticism of Mr. Perot. I think what I'd like to talk about a minute is, since you asked him the question, was the General Motors issue. I don't think there's any question that the automobile executives made some errors in the 1980's, but I also think we should look at how much productivity has increased lately, how much labor has done to increase productivity, and how much management has done. We're still losing a lot of auto jobs, in my judgment, because we don't have a national economic strategy that would build the industrial base of this country. Just today, I met with the presidents and the vice presidents of the Willow Run union near here. They both said they were Vietnam veterans supporting me because I had an economic program that put them back to work. We need an investment incentive to modernize plant and equipment. We've got to control the health care costs for those people. Otherwise we can't keep the manufacturing jobs here. We need a tough trade policy that is fair, that insists on open markets in return for open markets. We ought to have a strategy that will build the economic and industrial base. So I think Mr. Perot was right in questioning the management practices. But they didn't have much of a partner in Government here as compared with the policies the Germans and the Japanese followed. I believe we can do better. That's one of the things I want to change. I know that we can grow manufacturing jobs. We did it in my State, and we can do it nationally. CAFE Standards Mr. Lehrer. Mr. President, do you have a response? President Bush. To this? Mr. Lehrer. Yes. President Bush. Well, I wondered when Governor Clinton was talking to the autoworkers whether he talked about his and Senator Gore's favoring CAFE standards, those are fuel efficiency standards, of 40 miles per gallon. That would break the auto industry and throw a lot of people out of work. As regarding Mr. Perot, I take back something I said about him. I once said in a frivolous moment when he got out of the race, if you can't stand the heat, buy an air conditioning company. I take it back because I think he said he made a mistake. The thing I find is if I make a mistake, I admit it. I've never heard Governor Clinton make a mistake. But one mistake he's made is fuel efficiency standards at 40 to 45 miles per gallon will throw many autoworkers out of work, and you can't have it both ways. There's a pattern here of appealing to the autoworkers and then trying to appeal to the spotted owl crowd or the extremes in the environmental movement. You can't do it as President. You can't have a pattern of one side of the issue one day and another the next. So my argument is not with Ross Perot; it is more with Governor Clinton. Mr. Lehrer. Governor, what about that charge that you want it both ways on this issue? Governor Clinton. Let's just talk about the CAFE standards. Mr. Lehrer. All right. Governor Clinton. That's the fuel efficiency standards. They're now 27.5 miles per gallon per automobile fleet. I never said, and I defy you to find where I said -- I gave an extensive environment speech in April. I said that we ought to have a goal of raising the fuel efficiency standards to 40 miles a gallon. I think that should be a goal. I never said we should write it into law if there is evidence that that goal cannot be achieved. The National Science Foundation did a study which said it would be difficult for us to reach fuel efficiency standards in excess of 37 miles per gallon by the year 2000. I think we should try to raise the fuel efficiency. And let me say this: I think we ought to have incentives to do it. I think we ought to push to do it. That doesn't mean we have to write it into the law. Look, I am a job creator, not a job destroyer. It is the Bush administration that has had no new jobs in the private sector in the last 4 years. In my State we're leading the country in private sector job growth. But it is good for America to improve fuel efficiency. We also ought to convert more vehicles to compressed natural gas. That's another way to improve the environment. NAFTA Mr. Lehrer. Mr. Perot, based on your experience at General Motors, where do you come down on this? This has been thrown about, back and forth during this campaign from the very beginning about jobs and CAFE standards. Mr. Perot. Well, everybody's nibbling around the edges. Let's go to the center of the bull's eye to the core problem. Believe me, everybody on the factory floor all over this country knows it. You implement that NAFTA, the Mexican trade agreement, where they pay people $1 an hour, have no health care, no retirement, no pollution controls, et cetera, et cetera, et cetera, and you're going to hear a giant sucking sound of jobs being pulled out of this country right at a time when we need the tax base to pay the debt and pay down the interest on the debt and get our house back in order. We have got to proceed very carefully on that. See, there's a lot I don't understand. I do understand business. I do understand creating jobs. I do understand how to make things work. And I've got a long history of doing that. Now, if you want to go to the core problem that faces everybody in manufacturing in this country, it's that agreement that's about to be put into practice. But here, very simply, everybody says it will create jobs. Yes, it will create bubble jobs. Now, watch this. Listen very carefully to this: One-time surge while we build factories and ship machine tools and equipment down there. Then year after year for decades they will have jobs. And I finally thought I didn't understand it. I called all the experts, and they said, "Oh, it will be disruptive for 12 to 15 years." We haven't got 12 days, folks. We cannot lose those jobs. They were saying Mexican jobs will eventually come to $7.50 an hour and ours will eventually go down to $7.50 an hour. It makes you feel real good to hear that, right? Let's think it through, here. Let's be careful. I'm for free trade philosophically, but I have studied these trade agreements until the world has gone flat, and we don't have good trade agreements across the world. I hope we'll have a chance to get into that tonight, because I can get right to the center of the bull's eye and tell you why we're losing whole industries in this country. Excuse me. Mr. Lehrer. Just for the record, though, Mr. Perot, I take it then for your answer you do not have a position on whether or not enforcing the CAFE standards will cost jobs in the auto industry. Mr. Perot. Oh, no. It will cost jobs. But that's not -- let me say this: I'd rather, if you gave me two bad choices -- -- Mr. Lehrer. Okay. Mr. Perot. I'd rather have some jobs left here than just see everything head south, see? Mr. Lehrer. So that means no -- [laughter] -- in other words, you agree with President Bush, is that right? Mr. Perot. No, I'm saying our principal need now is to stabilize the tax base, which is the job base, and create a growing, dynamic base. Now, please, folks, if you don't hear anything else I say, remember millions of people at work are our tax base. One quick point: If you confiscate the Forbes 400 wealth, take it all, you cannot balance the budget this year. Kind of gets your head straight about where the taxes year-in and year-out have got to come from. Millions and millions of people at work. Mr. Lehrer. I wanted -- yes, sir. President Bush. Well, I'm caught in the middle of NAFTA. Ross says, with great conviction, he opposes the North American free trade agreement. I am for the North American free trade agreement. My problem with Governor Clinton, once again, is that one time he's going to make up his mind, he will see some merit in it. But then he sees a lot of things wrong with it. And then the other day, he says he's for it; however, then we've got to pass other legislation. When you're President of the United States, you cannot have this pattern of saying, "Well, I'm for it, but I'm on the other side of it." And it's true on this, and it's true on CAFE. Look, if Ross were right and we get a free trade agreement with Mexico, why wouldn't they have gone down there now? You have a differential in wages right now. I just have an honest philosophical difference. I think free trade is going to expand our job opportunity. I think it is exports that have saved us when we're in a global slowdown, a connected, global slowdown, a recession in some countries. It's free trade, fair trade that needs to be our hallmark, and we need more free trade agreements, not fewer. Mr. Lehrer. Governor, a quick answer on trade, and I want to go on to something else. Governor Clinton. I'd like to respond to that. You know, Mr. Bush was very grateful when I was among the Democrats who said he ought to have the authority to negotiate an agreement with Mexico. Neither I nor anybody else, as far as I know, agreed to give him our proxy to say that whatever he did was fine for the workers of this country and for the interests of this country. I am the one who is in the middle on this. Mr. Perot says it's a bad deal. Mr. Bush says it's a hunky-dory deal. I say, on balance, it does more good than harm if we could get some protection for the environment so that the Mexicans have to follow their own environmental standards, their own labor law standards, and if we have a genuine commitment to reeducate and retrain the American workers who lose their jobs and reinvest in this economy. I have a realistic approach to trade. I want more trade. I know there are some good things in that agreement, but it can sure be made better. Let me just point out, just today in the Los Angeles Times, Clyde Prestowitz, who was one of President Reagan's leading trade advisers, and a lifelong conservative Republican, endorsed my candidacy because he knows that I'll have a free and fair trade policy, a hard-headed realistic policy, and not get caught up in rubber-stamping everything the Bush administration did. If I wanted to do that, why would I run for President, Jim? Anybody else can run the middle class down and run the economy in a ditch. I want to change it. President Bush. I think he made my case. On the one hand, it's a good deal, but on the other hand, I'd make it better. You can't do that as President. You can't do it on the war, where he says, "Well, I was with the minority, but I guess I would have voted with the majority." This is my point tonight: We're talking about 2 weeks from now you've got to decide who is going to be President. And there is this pattern that has plagued him in the primaries and now about trying to have it both ways on all these issues. You can't do that. If you make a mistake, say you made a mistake and go on about your business, trying to serve the American people. Right now we heard it. Ross is against it. I am for it. He says, "On the one hand, I'm for it, and on the other hand, I may be against it." Mr. Lehrer. Governor -- -- Governor Clinton. That's what's wrong with Mr. Bush. His whole deal is, you've got to be for it or against it, and you can't make it better. I believe we can be better. I think the American people are sick and tired of either-or solutions, people being pushed in the corner, polarized to extremes. I think they want somebody with common sense, who can do what's best for the American people. I'd be happy to discuss these other issues, but I can't believe he is accusing me of getting on both sides. He said trickle-down economics was voodoo economics. Now, he's its biggest practitioner. Let me just say -- -- President Bush. I've always said trickle-down Government is bad. Governor Clinton. I could run this string out a long time, but remember this, Jim: Those 209 Americans last Thursday night in Richmond told us they wanted us to stop talking about each other and start talking about Americans and their problems and their promises. I think we ought to get back to that. I'll be glad to answer any question you have, but this election ought to be about the American people. Mr. Lehrer. Mr. Perot? Mr. Perot. Is there an equal time rule here tonight? President Bush. Yes. Mr. Perot. Or do you just keep lunging in at will? I thought we were going to have equal time, but maybe I just have to interrupt the other two. Is that the way it works this -- -- Mr. Lehrer. No. Mr. Perot, you're doing fine. Go ahead. Whatever you want to say, say it. Foreign Lobbyists Mr. Perot. Now that we've talked all around the problem about free trade, let's go again to the center of the bull's eye. Mr. Lehrer. Wait a minute. I was going to ask -- I thought you wanted to respond to what we were talking about. Mr. Perot. I do. I do. I just want to make -- these foreign lobbyists, this whole thing. Our country has sold out to foreign lobbyists. We don't have free trade. Both parties have foreign lobbyists on leave in key roles in their campaigns. If there's anything more unwise than that, I don't know what it is. Every debate, I bring this up, and nobody ever addresses it. I would like for them to look you in the eye and tell you why they have people representing foreign countries working on their campaigns. And you know, you've seen the list; I've seen the list. We won't go into the names. But no wonder they -- if I had those people around me all day every day telling me it was fair and free, I might believe it. But if I look at the facts as a businessman, it's so tilted. The first thing you ought to do is just say, "Guys, if you like these deals so well, we'll give you the deal you gave us." Now, Japanese couldn't unload the cars in this country if they had the same restrictions we had, and on and on and on and on and on. I suggest to you that the core problem -- one country spent $400 million lobbying in 1988 -- our country. And it goes on and on. And you look at a Who's Who in these campaigns around the two candidates. They're foreign lobbyists taking leaves. What do you think they're going to do when the campaign's over? Go back to work at 30,000 bucks a month representing some other country. I don't believe that's in the American people's interest. I don't have a one of them, and I haven't taken a penny of foreign money, and I never will. Mr. Lehrer. Mr. President, how do you respond to that? Mr. Perot has made that charge several times, the fact that you have people working in your campaign who are paid foreign lobbyists. President Bush. Most people that are lobbying are lobbying the Congress. I don't think there's anything wrong with an honest person who happens to represent an interest of another country for making his case. That's the American way. What you're assuming is that that makes the recipient of the lobbying corrupt or the lobbyists themselves corrupt. I don't agree with that. But if I found somebody that had a conflict of interest that would try to illegally do something as a foreign registered lobby, the laws cover this. I don't know why -- I've never understood quite why Mr. Perot was so upset about it, because one of the guys he used to have working for him, I believe, had foreign accounts. Could be wrong, but I think so. Mr. Perot. Soon as I found it out, he went out the door, too. President Bush. Well, I think you've got to look at the integrity and the honor of the people that are being lobbied and those that are lobbyists. The laws protect the American taxpayer in this regard. If the laws are violated so much -- but to suggest if somebody represents a foreign country on anything, that makes him corrupt or against the taxpayer, I don't agree with it. Mr. Perot. One quick relevant specific. We're getting ready to dismantle the airlines industry in our country, and none of you know it. I doubt, in all candor, if the President knows it. But this deal that we're doing with BAC and USAir and KLM and Northwest -- now, guess who is on the President's campaign big time? A guy from Northwest. This deal is terribly destructive to the U.S. airline industry. One of the largest industries in the world is the travel and tourist business. We won't be making airplanes in this country 10 years from now if we let deals like this go through. If the press has any interest tonight, I'll detail it to you. I won't take 10 minutes tonight; all these things take a few minutes. But that's happening as we sit here today. We hammerlock the American companies, American Airlines, Delta, the last few great we have, because we're trying to do this deal with these two European companies. Never forget, they've got Airbus over there, and it's a government-owned, privately owned consortium across Europe. They're dying to get the commercial airline business. Japan is trying to get the commercial airline business. I don't think there are any villains inside Government on this issue, but there sure are a lot of people who don't understand business. And maybe you need somebody up there who understands when you're getting your pocket picked. Mr. Lehrer. Governor, I'm sorry, but that concludes my time with -- -- Governor Clinton. Boy, I had a great response to that. Mr. Lehrer. All right. Go ahead, quickly. Just very briefly. Governor Clinton. I think Ross is right and that we do need some more restrictions on lobbyists. We ought to make them disclose the people they've given money to when they're testifying before congressional committees. We ought to close the lawyers' loophole; they ought to have to disclose when they're really lobbying. We ought to have a much longer period of time, about 5 years, between the time when people can leave executive branch offices and then go out and start lobbying for foreign interest. I agree with that. We've wrecked the airline industry already because there's all these leveraged buyouts and all these terrible things that have happened to the airline industry. We're going to have a hard time rebuilding it. But the real thing we've got to have is a competitive economic strategy. Look what's happening to McDonnell Douglas. Even Boeing is losing market share because we let the Europeans spend 25 to 40 billion dollars on Airbus without an appropriate competitive response. What I want America to do is to trade more, but to compete and win by investing in competitive ways. And we're in real trouble on that. Mr. Lehrer. I'm going to be in real trouble if I don't bring out -- it's about time -- -- President Bush. I promise it's less than 10 seconds. Mr. Lehrer. Okay. President Bush. I heard Governor Clinton congratulate us on one thing. First time he said something pleasant about this administration. Productivity in this country is up. It is way up. Productivity is up, and that's a good thing. There are many other good ones, but I was glad he acknowledged that. Mr. Perot. I've volunteered -- now, look, I'm just kind of a, you know, cur dog here. I was put on the ballot by the people, not special interest, so I have to stand up for myself. Now, Jim, let me net it out. On the second debate, I offered, since both sides want the enterprise zones but can't get together, I said I'll take a few days off and go to Washington and hold hands with you, and we'll get it done. I'll take a few days off, hold hands with you, and get this airline thing straightened out, because that's important to this country. That's kind of pathetic I have to do it, and nobody's called me yet to come up, I might mention -- [laughter] -- but if they do, if they do, it's easy to fix. If you all want the enterprise zones, why don't we pass the dang thing and do it? Right? Mr. Lehrer. All right. Now we're going to bring in three other journalists to ask questions. They are Susan Rook of CNN, Gene Gibbons of Reuters, and Helen Thomas of United Press International. You thought you'd never get in here, didn't you? President Bush. Uh-oh. Mr. Lehrer. Okay, we are going to continue on the subject of leadership, and the first question goes to Governor Clinton for a 2-minute answer. It will be asked by Helen Thomas. Helen? The Draft Issue Helen Thomas. Governor Clinton, your credibility has come into question because of your different responses on the Vietnam draft. If you had to do it over again, would you put on the Nation's uniform? And, if elected, could you, in good conscience, send someone to war? Governor Clinton. If I had to do it over again, I might answer the questions a little better. You know, I had been in public life a long time and no one had ever questioned my role, and so I was asked a lot of questions about the things that happened a long time ago. I don't think I answered them as well as I could have. Going back 23 years, I don't know, Helen. I was opposed to the war. I couldn't help that. I felt very strongly about it, and I didn't want to go at the time. It's easy to say in retrospect I would have done something differently. President Lincoln opposed the war, and there were people who said maybe he shouldn't be President. But I think he made us a pretty good President in wartime. We've got a lot of other Presidents who didn't wear their country's uniform and had to order our young soldiers into battle, including President Wilson and President Roosevelt. So the answer is, I could do that. I wouldn't relish doing it, but I wouldn't shrink from it. I think that the President has to be prepared to use the power of the Nation when our vital interests are threatened, when our treaty commitments are at stake, when we know that something has to be done that is in the national interest. And that is a part of being President. Could I do it? Yes, I could. Mr. Lehrer. A reminder now, we're back on the St. Louis rules, which means that the Governor had his answer, and then each of you will have one minute to respond. Mr. President. President Bush. Well, I've expressed my heartfelt difference with Governor Clinton on organizing demonstrations while in a foreign land against your country when young ghetto kids have been drafted and are dying. My argument with him on -- the question was about the draft is that there is this same pattern. In New Hampshire, Senator Kerry said you ought to level, you ought to tell the truth about it. And April 17th, he said he'd bring out all the records on the draft. They have not been forthcoming. He got a deferment, or he didn't. He got a notice, or he didn't. I think it's this pattern that troubles me more than the draft. A lot of decent, honorable people felt as he did on the draft. But it is this pattern. And again, you might be able to make amendments all the time, Governor, but as President, you can't be on all these different sides, and you can't have this pattern of saying, well, I did this, or I didn't. Then the facts come out, and you change it. That's my big difference with him on the draft. It wasn't failing to serve. Mr. Lehrer. Your minute is up, sir. Mr. Perot, one minute. Mr. Perot. I've spent my whole adult life very close to the military; feel very strongly about the people who go into battle for our country; appreciate their idealism, their sacrifices; appreciate the sacrifices their families make. That's been displayed again and again in a very tangible way. I look on this as history. I don't look on it, personally, as relevant. I consider it really a waste of time tonight when you consider the issues that face our country right now. Mr. Lehrer. All right. The next question goes to President Bush, and Gene Gibbons will ask it. 1990 Budget Agreement Gene Gibbons. Mr. President, you keep saying that you made a mistake in agreeing to a tax increase to get the 1990 budget deal with Congress. But if you hadn't gotten that deal you would have either had to get repeal of the Gramm-Rudman deficit control act or cut defense spending drastically at a time when the country was building up for the Gulf war and decimate domestic discretionary spending, including such things as air traffic control. If you had it to do all over again, sir, which of those alternatives would you choose? President Bush. I wouldn't have taken any of the alternatives. I believe I made a mistake. I did it for the very reasons you say. There was one good thing that came out of that budget agreement, and that is we put a cap on discretionary spending. One-third of the President's budget is at the President's discretion, or really, the Congress', since they appropriate every dime and tell the President how to spend every dime. We've put a cap on the growth of all that spending, and that's good. And that's helped. But I was wrong because I thought the tax compromise, going along with one Democratic tax increase, would help the economy. I see no evidence that it has done it. So what would I have done, what should I have done? I should have held out for a better deal that would have protected the taxpayer and not ended up doing what we had to do or what I thought at the time would help. So I made a mistake. You know, the difference, I think, is that I knew at the time I was going to take a lot of political flak. I knew we'd have somebody out there yelling, "Read my lips." And I did it because I thought it was right. And I made a mistake. That's quite different than taking a position where you know it's best for you. That wasn't best for me, and I knew it in the very beginning. I thought it would be better for the country than it was. So there we are. Mr. Lehrer. Mr. Perot, one minute. Mr. Perot. The 101 in leadership is be accountable for what you do. Let's go back to the tax and budget summit briefly. Nobody ever told the American people that we increased spending $1.83 for every dollar of taxes raised. That's absolutely unconscionable. Both parties carry a huge blame for that on their shoulders. This was not a way to pay on the deficit. This was a trick on the American people. That's not leadership. Let's go back in terms of accepting responsibilities for your actions. To create Saddam Hussein over a 10-year period, using billions of dollars of U.S. taxpayer money, step up to the plate and say it was a mistake. To create Noriega using taxpayer money, step up to the plate and say it was a mistake. If you can't get your act together to pick him up one day when a Panamanian major has kidnaped him, a special forces team is 400 yards away and it's a stroll across the park to get him, and if you can't get your act together, at least pick up the Panamanian major who they then killed, step up to the plate and admit it was a mistake. That's leadership, folks. Now, leaders will always make mistakes. And I'm not aiming at any one person here. I'm aiming at our Government. Nobody takes responsibility for anything. We've got to change that. Mr. Lehrer. I'll take responsibility for saying your time is up. Mr. Perot. I'm watching the light. Mr. Lehrer. All right. Governor Clinton, one minute, sir. Governor Clinton. The mistake that was made was making the "read my lips" promise in the first place just to get elected, knowing what the size of the deficit was, knowing there was no plan to control health care costs, and knowing that we did not have a strategy to get real economic growth back into this economy. The choices were not good then. I think at the time the mistake that was made was signing off on the deal late on Saturday night in the middle of the night. That's just what the President did when he vetoed the family leave act. I think what he should have done is gone before the American people on the front end and said, "Listen, I made a commitment, and it was wrong. I made a mistake because I couldn't have foreseen these circumstances. And this is the best deal we can work out at the time." He said it was in the public interest at the time, and most everybody who was involved in it, I guess, thought it was. The real mistake was the "read my lips" promise in the first place. You just can't promise something like that just to get elected if you know there's a good chance that circumstances may overtake you. Mr. Lehrer. All right, Mr. Perot, the question is for you. You have a 2-minute answer, and it will be asked by Susan Rook. Leadership Susan Rook. Mr. Perot, you've talked about going to Washington to do what the people who run this country want you to do. But it is the President's duty to lead and often lead alone. How can you lead if you are forever seeking consensus before you act? Mr. Perot. Let's talk about two different subjects. In order to lead, you first have to use the White House as a bully pulpit and lead. Then you have to develop consensus, or you can't get anything done. That's where we are now. We can't get anything done. How do you get anything done when you've got all of these political action committees, all of these thousands of registered lobbyists, 40,000 registered lobbyists, 23,000 special interest groups, and the list goes on and on and on, and the average citizen out here just working hard every day. You've got to go to the people. I just love the fact that everybody, particularly in the media, goes bonkers over the town hall. I guess it's because you will lose your right to tell them what to think. [Laughter] The point is, they'll get to decide what to think. President Bush. Hey, you've got something there. Mr. Perot. I love the fact that people will listen to a guy with a bad accent and a poor presentation manner talking about flip charts for 30 minutes, because they want the details. See, all the folks up there at the top said, people, "The attention span of the American people is no more than 5 minutes. They won't watch it." They're thirsty for it. You want to have a new program in this country? If you get grassroots America excited about it and if they tap Congress on the shoulder and say, "Do it, Charlie," it will happen. That's a whole lot different from these fellows running up and down the halls whispering in their ears now and promising campaign funds for the next election if they do it. Now, I think that's going back to where we started. That's having a Government from the people. I think that's the essence of leadership, rather than cutting deals in dark rooms in Washington. Mr. Lehrer. Governor Clinton, one minute. Governor Clinton. Well, I believe in the town hall meetings. They started with my campaign in New Hampshire. I think Ross Perot has done a good job in having them. And I, as you know, pushed for the debate to include 209 American citizens who were part of it in Richmond a few days ago. I've done a lot of them, and I'll continue to do them as President. But I'd also like to point out that I haven't been part of what we're criticizing in Washington tonight. Of the three of us, I have balanced a government budget 12 times. I have offered and passed campaign finance reform; offered, pushed for, and passed in public referendum lobbyist restrictions; done the kinds of things you have to do to get legislators together, not only to establish consensus but to challenge them to change. In 12 years as Governor, I guess I've taken on every interest group there was in my State at one time or another to fight for change. It can be done. That's why I've tried to be so specific in this campaign: to have a mandate, if elected, so that Congress will know what the American people have voted for. Mr. Lehrer. President Bush, one minute. President Bush. I would like the record to show the panelists that Ross Perot took the first shot at the press. My favorite bumper sticker, though, is "Annoy the Media. Reelect President Bush." [Laughter] I just had to work that in. Sorry, Helen. I'm going to pay for this later on. Look, you have to build a consensus, but in some things -- Ross mentioned Saddam Hussein. Yes, we tried, and yes, we failed to bring him into the family of nations. He had the fourth largest army. But then when he moved against Kuwait I said, this will not stand. And it's hard to build a consensus. We went to the U.N. We made historic resolutions up there. The whole world was united. Our Congress was dragging its feet. Governor Clinton said, "Well, I might have been with the minority, let sanctions work. But I guess I would have voted with the majority." A President can't do that. Sometimes he has to act. In this case, I'm glad we did, because if we'd have let sanctions work and had tried to build a consensus on that, Saddam Hussein today would be in Saudi Arabia controlling the world's oil supply, and he would be there maybe with a nuclear weapon. We busted the fourth largest army, and we did it through leadership. Mr. Lehrer. All right, we're going to go on to another subject now, and the subject is priorities. And the first question goes to you, President Bush, and Susan will ask it. Women Advisers Ms. Rook. President Bush, gentlemen, I acknowledge that all of you have women and ethnic minorities working for you and working with you. But when we look at the circle of the key people closest to you, your inner circle of advisers, we see white men only. Why, and when will that change? President Bush. You don't see Margaret Tutwiler sitting in there with me today? Ms. Rook. The key people, President Bush. President Bush. What? Ms. Rook. The key people, the people beyond the glass ceiling. President Bush. I happen to think she's a key person. I think our Cabinet members are key people. I think the woman that works with me, Rose Zamaria, is about as tough as a boot out there and makes some discipline and protects the taxpayer. Look at our Cabinet. You talk about somebody strong, look at Carla Hills. Look at Lynn Martin, who's fighting against this glass ceiling and doing a first-class job on it. Look at our Surgeon General, Dr. Novello. You can look all around and you'll see first-class, strong women. Jim Baker's a man. Yes, I plead guilty to that. [Laughter] But look who's around with him there. I mean, this is a little defensive on your part, Susan, to be honest with you. We've got a very good record appointing women to high positions and positions of trust. And I'm not defensive at all about it. What we've got to do is keep working, as the Labor Department is doing a first-class job on, to break down discrimination, to break down the glass ceiling. I am not apologetic at all about our record with women. You think about women in Government. I think about women in business. Why not try to help them with my small business program to build some incentives into the system? I think we're making progress here. You've got a lot of women running for office. As I said the other night, I hope a lot of them lose, because they're liberal Democrats, and we don't need more of them in the Senate or more of them in the House. But nevertheless, they're out there. And we've got some very good Republican women running. So we're making dramatic progress. Mr. Lehrer. Mr. Perot, one minute. Mr. Perot. Well, I've come from the computer business, and everybody knows women are more talented than the men. So we have a long history of having a lot of talented women. One of our first officers was a woman, a chief financial officer. She was a director. And it was so far back, it was considered so odd. And even though we were a tiny little company at the time, it made all the national magazines. But in terms of being influenced by women and being a minority, there they are right out there, my wife and my four beautiful daughters. And I just have one son. So he and I are surrounded by women telling us what to do all the time. [Laughter] Iraq For the rest of my minute, I want to make a very brief comment here in terms of Saddam Hussein. We told him that we wouldn't get involved with this border dispute, and we've never revealed those papers that were given to Ambassador Glaspie on July 25. I suggest, in the sense of taking responsibility for your actions, we lay those papers on the table. They're not the secrets to the nuclear bomb. Secondly, we got upset when he took the whole thing, but to the ordinary American out there who doesn't know where the oilfields are in Kuwait, they're near the border. We told him he could take the northern part of Kuwait, and when he took the whole thing, we went nuts. And if we didn't tell him that, why won't we even let the Senate Foreign Relations Committee and the Senate Intelligence Committee see the written instructions for Ambassador Glaspie? President Bush. I'd like to reply on that. That gets to the national honor. We did not say to Saddam Hussein, Ross, "You can take the northern part of Kuwait." That is absolutely absurd. Glaspie has testified -- -- Mr. Perot. Where are the papers? President Bush. -- -- and Glaspie's papers have been presented to the United States Senate. So please -- -- Mr. Perot. If you have time, go through NEXIS and LEXIS, pull all the old news articles. Look at what Ambassador Glaspie said all through the fall and what have you, and then look at what she and Kelly and all the others in State said at the end when they were trying to clean it up. And talk to any head of any of those key committees in the Senate. They will not let them see the written instructions given to Ambassador Glaspie. And I suggest that in a free society owned by the people, the American people ought to know what we told Ambassador Glaspie to tell Saddam Hussein. Because we spent a lot of money and risked lives and lost lives in that effort, and did not accomplish most of our objectives. We got Kuwait back to the Amir; but he still got his nuclear, his chemical, his bacteriological, and he's still over there, right? I'd like to see those written instructions. Sorry. Mr. Lehrer. Mr. President, when you -- just make sure that everybody knows what's going on here. When you responded directly to Mr. Perot then -- -- President Bush. Yes. Mr. Lehrer. -- -- you violated the rule, your rules. Now, I'm willing -- -- President Bush. I apologize. When I make a mistake, I say -- [laughter]. Mr. Lehrer. No, no, no. I just want to make sure that everybody understands. If you all want to change the rules, we can do it. President Bush. No, I don't. I apologize for it. But that one got right to the national honor. Mr. Lehrer. All right. Okay. President Bush. And I'm sorry. Mr. Lehrer. Okay. But Governor Clinton, you have a minute. Women Advisers Governor Clinton. Susan, I don't agree that there are no women and minorities in important positions in my campaign. There are many. But I think even more relevant is my record at home. For most of my time as Governor, a woman was my chief of staff, an African American was my chief cabinet officer, an African American was my chief economic development officer. It was interesting, there was a story either today or yesterday in the Washington Post about my economic programs. My chief budget officer and my chief economic officer were both African Americans, even though the Post didn't mention that, which I think is a sign of progress. The National Women's Political Caucus gave me an award, one of their good guy awards, for my involvement of women in high levels of government. I've appointed more minorities to positions of high levels in government than all the Governors in the history of my State combined before me. So that's what I'll do as President. I don't think we've got a person to waste. I think I owe the American people a White House staff, a Cabinet, and appointments that look like America, but that meet high standards of excellence, and that's what I'll do. Mr. Lehrer. All right. The next question goes to you, Mr. Perot, for 2 minutes. It's a 2-minute question, and Helen will ask it. Helen? Investigations Ms. Thomas. Mr. Perot, what proof do you have that Saddam Hussein was told that he could have -- do you have any actual proof, or are you asking for the papers? And also, I really came in with another question. What is this penchant you have to investigate everyone? Are those accusations correct, investigating your staff, investigating the leaders of the grassroots movement, investigating associates of your family? Mr. Perot. No, they're not correct. And if you look at my life for the first -- until I got involved in this effort, I was one person. And then after the Republican dirty tricks group got through with me, I'm another person, which I consider an absolutely sick operation. And all of you in the press know exactly what I'm talking about. They investigated every single one of my children. They investigated my wife. They interviewed all my children's friends from childhood on. They went to extraordinary, sick lengths. And I just found it amusing that they would take two or three cases where I was involved in lawsuits and would engage an investigator, the lawyers would engage an investigator, which is common. And the only difference between me and any other businessman that has the range of businesses I have is I haven't had that many lawsuits. So that's just another one of those little fruit-loopy things they make up to try to, instead of facing issues, to try to redefine a person that's running against them. This goes on night and day. I will do everything I can, if I get up there, to make dirty tricks a thing of the past. One of the two groups has raised it to an art form. It's a sick art form. Iraq Now, let's go back to Saddam Hussein. We gave Ambassador Glaspie written instructions. That's a fact. We've never let the Congress and these Foreign Relations -- Senate Intelligence Committee see them. That's a fact. Ambassador Glaspie did a lot of talking, right after July the 25th, and that's a fact, and it saw the newspapers. You pull all of it at once and read it, and I did, and it's pretty clear what she and Kelly and the other key guys around that thing thought they were doing. Then, at the end of the war when they had to go testify about it, their stories are a total disconnect from what they said in August, September, and October. So I say, this is very simple: Saddam Hussein released a tape, as you know, claiming it was a transcript of their meeting, where she said, "We will not become involved in your border dispute," and in effect, "You can take the northern part of the country." We later said, "No, that's not true." I said, well, this is simple. What were her written instructions? We guard those like the secrets to the atomic bomb, literally. Now, I say: Whose country is this? This is ours. Who will get hurt if we lay those papers on the table? The worst thing is, again, it's a mistake. Nobody did any of this with evil intent. I just object to the fact that we cover up and hide things, whether it's Iran-contra, Iraqgate, or you name it. It's a steady stream. Mr. Lehrer. Governor Clinton, you have one minute. Governor Clinton. Let's take Mr. Bush for the moment at his word. I mean, he's right, we don't have any evidence, at least, that our Government did tell Saddam Hussein he could have that part of Kuwait. And let's give him the credit he deserves for organizing Operation Desert Storm and Desert Shield. It was a remarkable event. But let's look at where, I think, the real mistake was made. In 1988, when the war between Iraq and Iran ended, we knew Saddam Hussein was a tyrant. We had dealt with him because he was against Iran. The enemy of my enemy maybe is my friend. All right, the war is over. We know he's dropping mustard gas on his own people. We know he's threatened to incinerate half of Israel. Several Government Departments, several, had information that he was converting our aid to military purposes and trying to develop weapons of mass destruction. But in late '89, the President signed a secret policy saying we were going to continue to try to improve relations with him, and we sent him some sort of communication on the eve of his invasion of Kuwait that we still wanted better relations. So I think what was wrong -- I give credit where credit is due, but the responsibility was in coddling Saddam Hussein when there was no reason to do it and when people at high levels in our Government knew he was trying to do things that were outrageous. Mr. Lehrer. Mr. President, you have a moment -- a minute, I'm sorry. President Bush. It's awful easy when you're dealing with 90/90 hindsight. We did try to bring Saddam Hussein into the family of nations. He did have the fourth largest army. All our Arab allies out there thought we ought to do just exactly that. When he crossed the line, I stood up and looked into the camera and I said, "This aggression will not stand." We formed a historic coalition, and we brought him down. We destroyed the fourth largest army, and the battlefield was searched, and there wasn't one single iota of evidence that any U.S. weapons were on that battlefield. The nuclear capability has been searched by the United Nations, and there hasn't been one single scintilla of evidence that there's any U.S. technology involved in it. What you're seeing on all this Iraqgate is a bunch of people who were wrong on the war trying to cover their necks here and try to do a little revisionism. I cannot let that stand, because it isn't true. Yes, we had grain credits for Iraq, and there isn't any evidence that those grain credits were diverted into weaponry, none, none whatsoever. And so I just have to say it's fine. You can't say there, Governor Clinton, and say, "Well, I think I have supported the minority" -- let sanctions work or wish that it would go away -- "but I would have voted with the majority." Come on, that's not leadership. Mr. Lehrer. The next question goes to Governor Clinton, and Gene Gibbons will ask it. Gene? Banking Situation Mr. Gibbons. Governor, an important aspect of leadership is, of course, anticipating problems. During the 1988 campaign, there was little or no mention of the savings and loan crisis that has cost the American people billions and billions of dollars. Now there are rumblings that a commercial bank crisis is on the horizon. Is there such a problem, sir? If so, how bad is it, and what will it cost to clean it up? Governor Clinton. Gene, there is a problem in the sense that there are some problem banks. And on December 19th, new regulations will go into effect which will, in effect, give the Government the responsibility to close some banks that are not technically insolvent but that are plainly in trouble. On the other hand, I don't think that we have any reason to believe that the dimensions of this crisis are anywhere near as great as the savings and loan crisis. The mistake that both parties made in Washington with the S&L business was deregulating them without proper capital requirements, proper oversight and regulation, proper training of the executives. Many people predicted what happened, and it was a disaster. The banking system in this country is fundamentally sound, with some weak banks. I think that our goal ought to be, first of all, not to politicize it, not to frighten people; secondly, to say that we have to enforce the law in two ways. We don't want to overreact as the Federal regulators have, in my judgment, on good banks so that they've created credit crunches that have made our recession worse in the last couple of years, but we do want to act prudently with the banks that are in trouble. We also want to say that, insofar as is humanly possible, the banking industry itself should pay for the cost of any bank failures, the taxpayers should not, and that will be my policy. I believe we have a good, balanced approach. We can get the good banks loaning money again in the credit crunch, have proper regulation on the ones that are in trouble, and not > Transfer interrupted! em, but I don't see it as the kind of terrible, terrible problem that the S&L problem was. Mr. Lehrer. President Bush, one minute. President Bush. Well, I don't believe it would be appropriate for a President to suggest that the banking system is not sound; it is sound. There are some problem banks out there. But what we need is financial reform. We need some real financial reform, banking reform legislation. I have proposed that, and when I am reelected I believe one of the first things ought to be to press a new Congress, not beholden to the old ways, to pass financial reform legislation that modernizes the banking system, doesn't put a lot of inhibitions on it, and protects the depositors through keeping the FDIC sound. I just was watching some of the proceedings of the American Bankers Association, and I think the general feeling is most of the banks are sound. Certainly there's no comparison here between what happened to the S&L's and where the banks stand right now, in my view. Mr. Lehrer. Mr. Perot, one minute. Mr. Perot. Well, nobody's gotten into the real issue yet on the savings and loan. Again, nobody's got a business background, I guess. The whole problem came up in 1984. The President of the United States was told officially it was a $20 billion problem. These crooks -- now, Willie Sutton would have gone to own a savings and loan rather than rob banks. He robbed banks because that's where the money is; owning a savings and loan is where the money was. Now, in 1984 they were told. I believe the Vice President was in charge of deregulation. Nobody touched that tar baby until the day after election in 1988, because they were flooding both parties with crooked PAC money. And it was, in many cases, stolen PAC money. Now, you and I never got a ride on a lot of these yachts and fancy things it bought, but you and I are paying for it. And they buried it until right after the election. Now, if you believe the Washington Post and you believe this extensive study that's been done, and I'm reading it, right after election day this year they're going to hit us with 100 banks. It'll be a $100 billion problem. Now, if that's true, just tell me now. I'm grown up. I can deal with it. I'll pay my share. But just tell me now. Don't bury it until after the election twice. I say that to both political parties. The people deserve that, since we have to pick up the tab. You've got the PAC money. We'll pay the tab. Just tell us. Mr. Lehrer. All right, Mr. Perot. The next question, we're going into a new round here on a category just called "differences." And the question goes to you, Mr. Perot, and Gene will ask it. Gene? Government Reform Mr. Gibbons. Mr. Perot, aside from the deficit, what Government policy or policies do you really want to do something about? What really sticks in your craw about conditions in this country, beside the deficit, that you would want to fix as President? Mr. Perot. The debt and the deficit. Well, if you watched my television show the other night, you saw it. If you watch it Thursday, Friday, Saturday this week, you'll get more. So, a shameless plug there, Mr. President. But in a nutshell, we've got to reform our Government or we won't get anything done. We have a Government that doesn't work. All these specific examples I'm giving tonight, if you had a business like that, they'd be leading you away and boarding up the doors. We have a Government that doesn't work. It's supposed to come from the people. It comes at the people. The people need to take their Government back. You've got to reform Congress. They've got to be servants to the people again. You've got to reform the White House. We've got to turn this thing around. It's a long list of specific items, and I've covered it again and again in print and on television. But very specifically, the key thing is to turn the Government back to the people and take it away from the special interests and have people go to Washington to serve. Who can give themselves a 23-percent pay raise anywhere in the world except Congress? Who would have 1,200 airplanes worth $2 billion a year just to fly around in? I don't have a free reserved parking place at National Airport. Why should my servants? I don't have an indoor gymnasium and an indoor tennis court, an indoor every other thing they can think of. I don't have a place where I can go make free TV to send to my constituents to try to brainwash them to elect me the next time. And I'm paying for all that for those guys. I'm going to be running an ad pretty soon that shows -- they promised us they were going to hold the line on spending, a tax and budget summit -- and I'm going to show how much they've increased this little stuff they do for themselves. It is Silly Putty, folks, and the American people have had enough of it. Step one, if I get up there, we're going to clean that up. You say, how can I get Congress to do that? I'll have millions of people shoulder-to-shoulder with me, and we will see it done warp speed, because it's wrong. We've turned the country upside down. Mr. Lehrer. Governor Clinton, you have one minute. Governor. Governor Clinton. I would just point out on the point Mr. Perot made, I agree that we need to cut spending in Congress. I've called for a 25-percent reduction in congressional staffs and expenditures. But the White House staff increased its expenditures by considerably more than Congress has in the last 4 years under the Bush administration, and Congress has actually spent $1 billion less than President Bush asked them to spend. Now, when you outspend Congress, you're really swinging. That, however, is not my only passion. The real problem in this country is that most people are working hard and falling further behind. My passion is to pass a jobs program to get incomes up with an investment incentive program to grow jobs in the private sector, to waste less public money and invest more, to control health care costs and provide for affordable health care for all Americans, and to make sure we've got the best trained work force in the world. That is my passion. We've got to get this country growing again and this economy strong again, or we can't bring down the deficit. Economic growth is the key to the future of this country. Mr. Lehrer. President Bush, one minute. President Bush. On Government reform? Mr. Lehrer. Sir? President Bush. Government reform? Mr. Lehrer. Yes. Well, to respond to the subject that Mr. Perot mentioned. President Bush. How about this for a Government reform policy? Reduce the White House staff by a third after or at the same time the Congress does the same thing for their staff; term limits for Members of the United States Congress. Give the Government back to the people. Let's do it that way. The President has term limits. Let's limit some of these guys sitting out here tonight. Term limits, and then how about a balanced budget amendment to the Constitution? Forty-three States, more than that, States have it, I believe. Let's try that. You want to do something about all this extra spending that concerns Mr. Perot and me? Okay, how about a line-item veto? Forty-three Governors have that. Give it to the President. If the Congress isn't big enough to do it, let the President have a shot at this excess spending. A line-item veto, that means you can take a line and cut out some of the pork out of a meaningful bill. Governor Clinton keeps hitting me on vetoing legislation. Well, that's the only protection the taxpayer has against some of these reckless pork programs up there. I'd rather be able to just line it right out of there and get on about passing some good stuff, but leave out the garbage. Line-item veto, there's a good reform program for you. Mr. Lehrer. The next question goes to Governor Clinton. You have two minutes, Governor, and Susan will ask it. Taxes Ms. Rook. Governor Clinton, you said that you will raise taxes on the rich, people with incomes of $200,000 a year or higher. A lot of people are saying that you will have to go lower than that, much lower. Will you make a pledge tonight below which -- an income level that you will not go below? I am looking for numbers, sir, not just a concept. Governor Clinton. You can read my plan. My plan says that we want to raise marginal incomes on family incomes above $200,000 from 31 to 36 percent; that we want to ask foreign corporations simply to pay the same percentage of taxes on their income that American corporations pay in America; that we want to use that money to provide over $100 billion in tax cuts for investment in new plant and equipment, for small business, for new technologies, and for middle class tax relief. Now, I can tell you this: I will not raise taxes on the middle class to pay for these programs. If the money does not come in there to pay for these programs, we will cut other Government spending, or we will slow down the phase-in to the programs. I am not going to raise taxes on the middle class to pay for these programs. Now, furthermore, I am not going to tell you "Read my lips" on anything because I cannot foresee what emergencies might develop in this country. And the President said never, never, never would he raise taxes, in New Jersey. Within a day, Marlin Fitzwater, his spokesman, said, now, that's not a promise. So I think even he has learned that you can't say "Read my lips" because you can't know what emergencies might come up. But I can tell you this: I'm not going to raise taxes on middle class Americans to pay for the programs I've recommended. Read my plan. And you know how you can trust me about that? Because you know, in the first debate, Mr. Bush made some news. He had just said Jim Baker was going to be Secretary of State, but in the first debate he said no, now he's going to be responsible for domestic economic policy. Well, I'll tell you, I'll make some news in the third debate: The person responsible for domestic economic policy in my administration will be Bill Clinton. I'm going to make those decisions, and I won't raise taxes in the middle class to pay for my program. Mr. Lehrer. President Bush, you have one minute. President Bush. That's what worries me, that he's going to be responsible. He would do for the United States what he has done for Arkansas. He would do for the United States what he's done to Arkansas. We do not want to be the lowest of the low. We are not a nation in decline. We are a rising nation. My problem is, I heard what he said. He said, "I want to take it from the rich, raise $150 billion from the rich." To get it, to get $150 billion in new taxes, you've got to go down to the guy that's making $36,600. And if you want to pay for the rest of his plan, all the other spending programs, you're going to sock it to the working man. So when you hear "tax the rich," Mr. and Mrs. America, watch your wallet. Lock your wallet, because he's coming right after you just like Jimmy Carter did, and just like you're going to get -- you're going to end up with interest rates at 21 percent, and you're going to have inflation going through the roof. Yes, we're having tough times. But we do not need to go back to the failed policies of the past when you had a Democratic President and a spendthrift Democratic Congress. Mr. Lehrer. Mr. Perot. Governor Clinton. You permitted Mr. Bush to break the rules, he said to defend the honor of the country. What about the honor of my State? We rank first in the country in job growth. We've got the lowest spending, State and local, in the country and the second lowest tax burden. The difference between Arkansas and the United States is that we're going in the right direction, and this country's going in the wrong direction. And I have to defend the honor of my State. Mr. Lehrer. We've got a wash, according to my calculations. We have a wash. And we'll go to Mr. Perot for one minute. In other words, the violation of the rule; that's what I meant. Mr. Perot. I'm the only one that's untarnished at this point. Mr. Lehrer. That's right, you're clean. [Laughter] Mr. Perot. I'm sure I'll do it before it's over. The key thing here, see, we all come up with images. Images don't fix anything. You know, I'm starting to understand it. You stay around this long enough, you think about -- if you talk about it in Washington, you think you did it. If you've been on television about it, you think you did it. [Laughter] What we need is people to stop talking and start doing. Now, our real problem here is they both have plans that will not work. The Wall Street Journal said your numbers don't add up. And you can take it out on charts; you look at all the studies that different groups have done; you go out 4, 5, 6 years: We're still drifting along with a huge deficit. So let's come back to harsh reality. Everybody said, "Gee, Perot, you're tough." I say, well, this is not as tough as World War II; and it's not as tough as the Revolution. It's fair-shared sacrifice to do the right thing for our country and for our children. And it will be fun if we all work together to do it. Mr. Lehrer. This is the last question, and it goes to President Bush for a 2-minute answer. And it will be asked by Helen. Presidential Campaign Ms. Thomas. Mr. President, why have you dropped so dramatically in the leadership polls, from the high eighties to the forties? And you have said you will do anything you have to do to get reelected. What can you do in 2 weeks to win reelection? President Bush. Well, I think the answer to why the drop, I think, has been the economy in the doldrums. Why I'll win is I think I have the best plan of the three of us up here to do something about it. Mine does not grow the Government. It does not have Government invest. It says we need to do better in terms of stimulating private business. We've got a big philosophical difference here tonight between one who thinks the Government can do all these things through tax and spend, and one who thinks it ought to go the other way. So I believe the answer is, I'm going to win it because I'm getting into focus my agenda for America's renewal, and also I think that Governor Clinton's had pretty much of a free ride on looking specifically at the Arkansas record. He keeps criticizing us, criticizing me; I'm the incumbent. Fine. But he's an incumbent. And we've got to look at all the facts. They're almost at the bottom on every single category. We can't do that to the American people. Then, Helen, I really believe where people are going to ask this question about trust -- because I do think there's a pattern by Governor Clinton of saying one thing to please one group and then trying to please another group. I think that pattern is a dangerous thing to suggest would work for the Oval Office. It doesn't work that way when you're President. Truman is right: The buck stops there. You have to make decisions, even when it's against your own interest. I've done that. It's against my political interests to say go ahead and go along with the tax increase. But I did what I thought was right at the time. So I think people are going to be looking for trust and experience. Then, I mentioned it the other night, I think if there's a crisis, people are going to say, "Well, George Bush has taken us through some tough crises, and we trust him to do that." So I'll make the appeal on a wide array of issues. Also I've got a philosophical difference -- I've got to watch the clock here -- I don't think we're a declining nation. The whole world has had economic problems. We're doing better than a lot of the countries in the world. And we're going to lead the way out of this economic recession across this world and economic slowdown here at home. Mr. Lehrer. Mr. Perot, you have one minute. President Bush. That's why I think I'll win. Mr. Lehrer. Mr. Perot, you have -- sorry. Excuse me, sir. Mr. Perot, you have one minute. Mr. Perot. I'm the last one, right? Mr. Lehrer. No. Governor Clinton has a minute after you. Then we have the closing statements. Mr. Perot. One minute after you? Mr. Lehrer. Right. Mr. Perot. I'm totally focused on the fact that we may have bank failures, and nobody answered it. I'm totally focused on that fact that we are still evading the issue of the Glaspie papers. I'm totally focused on the fact that we still could have enterprise zones, according to both parties, but we don't. So I'm still focused on gridlock, I guess. I'm also focused on the fact that isn't it a paradox that we have the highest productivity in our work force in the industrialized world and at the same time have the largest trade deficit, and at the same time rank behind nine other nations in what we pay our most productive people in the world. We're losing whole industries overseas. Now, can't somebody agree with me that the Government is breaking business' legs with these trade agreements? They're breaking business' legs in a number of different ways. We have an adversarial relationship that's destroying jobs and sending them overseas, while we have the finest workers in the world. Keep in mind the factory worker has nothing to do with anything except putting it together on the factory floor. It's our obligation to make sure that we give him the finest products in the world to put together, and we don't break his legs in the process. Mr. Lehrer. Governor Clinton, one minute. Governor Clinton. I really can't believe Mr. Bush is still trying to make trust an issue after "read my lips" and "15 billion new jobs" and embracing what he called "voodoo economics" and embracing an export enhancing program for farmers he threatened to veto and going all around the country giving out money and programs that he once opposed. But the main thing is he still didn't get it, from what he said the other night to that fine woman on our program, the 209 people in Richmond. They don't want us talking about each other. They want us to talk about the problems of this country. I don't think he'll be reelected because trickle-down economics is a failure, and he's offering more of it. And what he's saying about my program is just not true. Look at the Republicans that have endorsed me, high-tech executives in northern California. Look at the 24 generals and admirals, retired, who have endorsed me, including the deputy commander of Desert Storm. Look at Sarah Brady, Jim Brady's wife, President Reagan's Press Secretary, who endorsed me because he knuckled under to the NRA and wouldn't fight for the Brady bill. We've got a broad-based coalition that goes beyond party, because I am going to change this country and make it better with the help of the American people. Mr. Lehrer. All right. That was the final question and answer, and we now go to the closing statements. Each candidate will have up to 2 minutes. The order was determined by a drawing. Governor Clinton, you are first. Governor. Closing Statements Governor Clinton. First I'd like to thank the Commission and my opponents for participating in these debates and making them possible. I think the real winners of the debates were the American people. I was especially moved in Richmond a few days ago when 209 of our fellow citizens got to ask us questions. They went a long way toward reclaiming this election for the American people and taking their country back. I want to say, since this is the last time I'll be on a platform with my opponents, that even though I disagree with Mr. Perot on how fast we can reduce the deficit and how much we can increase taxes on the middle class, I really respect what he's done in this campaign to bring the issue of deficit reduction to our attention. I'd like to say to Mr. Bush, even though I've got profound differences with him, I do honor his service to our country. I appreciate his efforts, and I wish him well. I just believe it's time to change. I offer a new approach. It's not trickle-down economics; it's been tried for 12 years, and it's failed. More people are working harder for less, 100,000 people a month losing their health insurance, unemployment going up, our economy slowing down. We can do better. And it's not tax-and-spend economics. It's invest and grow, put our people first, control health care costs and provide basic health care to all Americans, have an education system second to none, and revitalize the private economy. That is my commitment to you. It is a kind of change that can open up a whole new world of opportunities to America as we enter the last decade of this century and move toward the 21st century. I want a country where people who work hard and play by the rules are rewarded, not punished. I want a country where people are coming together across the lines of race and region and income. I know we can do better. It won't take miracles, and it won't happen overnight. But we can do much, much better if we have the courage to change. Thank you very much. Mr. Lehrer. President Bush, your closing statement, sir. President Bush. Three weeks from now -- two weeks from tomorrow, America goes to the polls. You're going to have to decide who you want to lead this country to economic recovery. On jobs, that's the number one priority, and I believe my program for stimulating investment, encouraging small business, brandnew approach to education, strengthening the American family, and yes, creating more exports is the way to go. I don't believe in trickle-down Government. I don't believe in larger taxes and larger Government spending. On foreign affairs, some think it's irrelevant. I believe it's not. We're living in an interconnected world. The whole world is having economic difficulties. The U.S. is doing better than a lot. But we've got to do even better. If a crisis comes up, I ask: Who has the judgment and the experience and, yes, the character to make the right decision? Lastly, the other night on character, Governor Clinton said it's not the character of the President but "the character of the Presidency." I couldn't disagree more. Horace Greeley said, "The only thing that endures is character." And I think it was Justice Black who talked about "Great nations, like great men, must keep their word." And so the question is: Who will safeguard this Nation? Who will safeguard our people and our children? I need your support. I ask for your vote. And may God bless the United States of America. Mr. Lehrer. Mr. Perot, your closing statement, sir. Mr. Perot. To the millions of fine, decent people who did the unthinkable and took their country back in their own hands and put me on the ballot, let me pledge to you that tonight is just the beginning. These next 2 weeks we will be going full steam ahead to make sure that you get a voice and that you get your country back. This Thursday night on ABC from 8:30 to 9, Friday night on NBC from 8 to 8:30, and Saturday night on CBS from 8 to 8:30, we'll be down in the trenches, under the hood, working on fixing the old car to get it back on the road. [Laughter] Now, the question is: Can we win? Absolutely we can win, because it's your country. The question really is: Who do you want in to the White House? It's that simple. Now, you've got to stop letting these people tell you who to vote for. You've got to stop letting these folks in the press tell you you're throwing your vote away. You've got to start using your own head. Then the question is: Can we govern? I love that one. The "we" is you and me. You bet your hat we can govern, because we will be in there together, and we will figure out what to do. You won't tolerate gridlock. You won't tolerate endless meandering and wandering around. You won't tolerate nonperformance. And believe me, anybody who knows me understands I have a very low tolerance for nonperformance also. Together we can get anything done. The President mentioned that you need the right person in a crisis. Well, folks, we've got one. And that crisis is a financial crisis. Pretty simply, who's the best qualified person up here on the stage to create jobs? Make your decision and vote on November the 3d. I suggest you might consider somebody who's created jobs. Second, who's the best person to manage money? I suggest you pick a person who's successfully managed money. Who's the best person to get results and not talk? Look at the record; make your decision. Finally, who would you give your pension fund and your savings account to to manage? And the last one, who would you ask to be the trustee of your estate and take care of your children if something happened to you? Finally, to you students up there, God bless you. I'm doing this for you. I want you to have the American dream. And to the American people, to the American people, I'm doing this because I love you. That's it. Thank you very much. Mr. Lehrer. Thank you, Mr. Perot. Thank you, Mr. President. Thank you, Governor Clinton, for being with us tonight and the previous debates. Thank you to the panel. The only thing that is left to be said is, from Michigan State University in East Lansing, I'm Jim Lehrer. Thank you, and good night.
