# Presidential Debate in Richmond, Virginia

**Date:** October 15, 1992
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-the-university-richmond

---

Carole Simpson. Good evening, and welcome to the second of three Presidential debates between the major candidates for President of the United States. The candidates are the Republican nominee, President George Bush; the independent, Ross Perot; and Governor Bill Clinton, the Democratic nominee. My name is Carole Simpson, and I will be the moderator for tonight's 90-minute debate which is coming to you from the campus of the University of Richmond in Richmond, Virginia. Now, tonight's program is unlike any other Presidential debate in history. We're making history now, and it's pretty exciting. An independent polling firm has selected an audience of 209 uncommitted voters from this area. The candidates will be asked questions by these voters on a topic of their choosing, anything they want to ask about. My job as moderator is to, you know, take care of the questioning, ask questions myself if I think there needs to be continuity and balance, and sometimes I might ask the candidates to respond to what another candidate may have said. Now, the format has been agreed to by representatives of both the Republican and Democratic campaigns, and there is no subject matter that is restricted. Anything goes. We can ask anything. After the debate the candidates will have an opportunity to make a closing statement. So, President Bush, I think you said it earlier, let's get it on. President Bush. Let's go. Ms. Simpson. And I think the first question is over here. Foreign Trade and Domestic Jobs Q. I'd like to direct my question to Mr. Perot. What will you do as President to open foreign markets to fair competition from American business and to stop unfair competition here at home from foreign countries so that we can bring jobs back to the United States? Mr. Perot. That's right at the top of my agenda. We've shipped millions of jobs overseas, and we have a strange situation because we have a process in Washington where after you've served for a while, you cash in, become a foreign lobbyist, make $30,000 a month, then take a leave, work on Presidential campaigns, make sure you got good contacts, and then go back out. Now, if you just want to get down to brass tacks, first thing you ought to do is get all these folks that have got these one-way trade agreements that we've negotiated over the years and say, "Fellas, we'll take the same deal we gave you." They'll gridlock right at that point, because, for example, we've got international competitors who simply could not unload their cars off the ships if they had to comply, you see, if it was a two-way street, just couldn't do it. We have got to stop sending jobs overseas. To those of you in the audience who are business people, pretty simple: If you're paying $12, $13, $14 an hour for factory workers, and you can move your factory south of the border, pay $1 an hour for labor, hire young -- let's assume you've been in business for a long time; you've got a mature work force -- pay $1 an hour for your labor, have no health care -- that's the most expensive single element in making a car -- have no environmental controls, no pollution controls, and no retirement, and you don't care about anything but making money, there will be a giant sucking sound going south. So if the people send me to Washington, the first thing I'll do is study that 2,000-page agreement and make sure it's a two-way street. I have one last part here. I decided I was dumb and didn't understand it, so I called the "Who's Who" of the folks that have been around it. And I said, "Why won't everybody go south?" They say, "It would be disruptive." I said, "For how long?" I finally got them up for 12 to 15 years. And I said, "Well, how does it stop being disruptive?" And that is, when their jobs come up from $1 an hour to $6 an hour, and ours go down to $6 an hour, then it's leveled again. But in the meantime, you've wrecked the country with these kinds of deals. We've got to cut it out. Ms. Simpson. Thank you, Mr. Perot. I see that the President has stood up, so he must have something to say about this. President Bush. Well, Carole, the thing that saved us in this global economic slowdown has been our exports, and what I'm trying to do is increase our exports. If, indeed, all the jobs were going to move south because of lower wages, there are lower wages now, and they haven't done that. So I have just negotiated with the President of Mexico the North American free trade agreement, and the Prime Minister of Canada, I might add. I want to have more of these free trade agreements because export jobs are increasing far faster than any jobs that may have moved overseas. That's a scare tactic, because it's not that many. But any one that's here, we want to have more jobs here, and the way to do that is to increase our exports. Some believe in protection. I don't. I believe in free and fair trade. That's the thing that saved us. And so I will keep on, as President, trying to get a successful conclusion to the GATT round, the big Uruguay round of trade which will really open up markets for our agriculture, particularly. I want to continue to work after we get this NAFTA agreement ratified this coming year. I want to get one with Eastern Europe. I want to get one with Chile. Free and fair trade is the answer, not protection. As I say, we've had tough economic times, and it's exports that have saved us, exports that have built -- -- Ms. Simpson. Governor Clinton. Governor Clinton. I'd like to answer the question, because I've actually been a Governor for 12 years, so I've known a lot of people who have lost their jobs because of jobs moving overseas, and I know a lot of people whose plants have been strengthened by increasing exports. The trick is to expand our export base and to expand trade on terms that are fair to us. It is true that our exports to Mexico, for example, have gone up, and our trade deficit's gone down. It's also true that just today a record-high trade deficit was announced with Japan. So what is the answer? Let me just mention three things very quickly. Number one, make sure that other countries are as open to our markets as our markets are to them. If they're not, have measures on the books that don't take forever and a day to implement. Number two, change the Tax Code. There are more deductions in the Tax Code for shutting plants down and moving overseas than there are for modernizing plants and equipment here. Our competitors don't do that. Emphasize and subsidize modernizing plants and equipment here, not moving plants overseas. Number three, stop the Federal Government's program that now gives low interest loans and job training funds to companies that will actually shut down and move to other countries, but we won't do the same thing for plants that stay here. So more trade, but on fair terms, and favor investment in America. Ms. Simpson. Thank you. I think we have a question over here. Federal Deficit Q. This is for Governor Clinton. In the real world, that is, outside of Washington, DC, compensation and achievement are based on goals defined and achieved. My question is about the deficit. Would you define in specific dollar goals how much you would reduce the deficit in each of the 4 years of a Clinton administration and then enter into a legally binding contract with the American people that if you did not achieve those goals that you would not seek a second term? Answer yes or no, and then comment on your answer, please. Governor Clinton. No, and here's why; I'll tell you exactly why, because the deficit now has been building up for 12 years. I'll tell you exactly what I think can be done. I think we can bring it down by 50 percent in 4 years and grow the economy. Now, I could get rid of it in 4 years in theory on the books now, but to do it you'd have to raise taxes too much and cut benefits too much to people who need them, and it would even make the economy worse. Mr. Perot will tell you, for example, that the expert he hired to analyze his plan says that it will bring the deficit down in 5 years, but it will make unemployment bad for 4 more years. So my view is, sir, you have to increase investment, grow the economy, and reduce the deficit by controlling health care costs, prudent reductions in defense, cuts in domestic programs, and asking the wealthiest Americans and foreign corporations to pay their fair share of taxes, and investing in growing this economy. I ask everybody to look at my economic ideas. Nine Nobel Prize winners and over 500 economists and hundreds of business people, including a lot of Republicans, said this is the way you've got to go. If you don't grow the economy, you can't get it done. But I can't foresee all the things that will happen, and I don't think a President should be judged solely on the deficit. Let me also say we're having an election today. You'll have a shot at me in 4 years, and you can vote me right out if you think I've done a lousy job. I would welcome you to do that. Ms. Simpson. Mr. President? President Bush. Well, I've got to -- I'm a little confused here because I don't see how you can grow the deficit down by raising people's taxes. You see, I don't think the American people are taxed too little. I think they're taxed too much. I went for one tax increase, and when I make a mistake, I admit it, say that wasn't the right thing to do. Governor Clinton's program wants to tax more and spend more: $150 billion in new taxes, spend another $220 billion. I don't believe that's the way to do it. Here's some things that will help. Give us a balanced budget amendment. He always talks about Arkansas having a balanced budget, and they do. But he has a balanced budget amendment; have to do it. I'd like the Government to have that. I think it would discipline not only the Congress, which needs it, but also the executive branch. I'd like to have what 43 Governors have, the line-item veto. So if the Congress can't cut, we've got a reckless spending Congress, let the President have a shot at it by wiping out things that are pork barrel or something of that nature. I've proposed another one. Some sophisticates think it may be a little gimmicky. I think it's good. It's a check-off. It says to you as a taxpayer -- say, you're going to pay a tax of $1,000 or something; you can check 10 percent of that if you want to in one box, and that 10 percent, $100, or if you're paying $10,000, whatever it is, $1,000, check it off, and make the Government, make it lower the deficit by that amount. If the Congress won't do it, if they can't get together and negotiate how to do that, then you'd have a sequester across the board. You'd exempt Social Security. I don't want to tax or touch Social Security. I'm the President that said, "Hey, don't mess with Social Security." And we haven't. So I believe we need to control the growth of mandatory spending, back to this gentleman's question, that's the main growing thing in the budget. The program that the President -- two-thirds of the budget, I, as President, never get to look at, never get to touch. We've got to control that growth to inflation and population increase, but not raise taxes on the American people now. I just don't believe that would stimulate any kind of growth at all. Ms. Simpson. How about you, Mr. Perot? Mr. Perot. Well, we're $4 trillion in debt, and we're going into debt an additional $1 billion, a little more than $1 billion, every working day of the year. Now, the thing I love about it -- I'm just a businessman. I was down in Texas, taking care of business, tending to my family. This situation got so bad that I decided I had better get into it. The American people asked me to get into it. But I just find it fascinating that while we sit here tonight, we will go into debt an additional $50 million in an hour and a half. Now, it's not the Republicans' fault, of course, and it's not the Democrats' fault. What I'm looking for is who did it? Now, they're the two folks involved; so maybe if you put them together, they did it. Now, the facts are we have to fix it. I'm here tonight for these young people up here in the balcony from this college. When I was a young man, when I got out of the Navy, I had multiple job offers. Young people with high grades can't get a job. The 18- to 24-year-old high school graduates 10 years ago were making more than they are now. In other words, we were down to -- 18 percent of them were making -- the 18- to 24-year-olds were making less than $12,000. Now that's up to 40 percent. And what's happening in the meantime? The dollar's gone through the floor. Now, whose fault is that? Not the Democrats; not the Republicans. Somewhere out there there's an extraterrestrial that's doing this to us, I guess. [Laughter] And everybody says they take responsibility. Somebody, somewhere has to take responsibility for this. Put it to you bluntly, the American people: If you want me to be your President, we're going to face our problems. We'll deal with the problems. We'll solve our problems. We'll pay down our debt. We'll pass on the American dream to our children. I will not leave our children a situation that they have today. When I was a boy, it took two generations to double the standard of living. Today it will take 12 generations. Our children will not see the American dream because of this debt that somebody, somewhere dropped on us. Ms. Simpson. You're all wonderful speakers, and I know you have lots more to add. But I have talked to this audience, and they have lots of questions on other topics. Can we move to another topic, please? We have one up here, I think. Presidential Campaign Q. Yes, I'd like to address all the candidates with this question. The amount of time the candidates have spent in this campaign trashing their opponents' character and their programs is depressingly large. Why can't your discussions and proposals reflect the genuine complexity and the difficulty of the issues to try to build a consensus around the best aspects of all proposals? Ms. Simpson. Who wants to take that one? Mr. Perot, you have an answer for everything, don't you? Go right ahead, sir. [Laughter] Mr. Perot. No, I don't have an answer for everything. As you all know, I've been buying 30-minute segments to talk about issues. Tomorrow night on NBC from 10:30 to 11, eastern, we're going to talk about how you pay the debt down. So we're going to come right down to that one, see. We'll be on again Saturday night 8 to 9 o'clock on ABC. [Laughter] Ms. Simpson. Okay, okay. Mr. Perot. So the point is, finally, I couldn't agree with you more, couldn't agree with you more. And I have said again and again and again, let's get off mud wrestling. Let's get off personalities, and let's talk about jobs, health care, crime, the things that concern the American people. I'm spending my money, not PAC money, not foreign money, my money to take this message to the people. Ms. Simpson. Thank you, Mr. Perot. So that seems directed. He would say it's you gentlemen that have been doing that. Mr. Clinton, Governor Clinton, how do you -- President Bush, how would you like to respond? President Bush. Well, first place, I believe that character is a part of being President. I think you have to look at it. I think that has to be a part of candidate for President or being President. In terms of programs, I've submitted, what, four different budgets to the United States Congress in great detail. They're so heavy they'd give you a broken back. Everything in there says what I am for. Now, I've come out with a new agenda for America's renewal, a plan that I believe really will help stimulate the growth of this economy. My record on world affairs is pretty well-known because I've been President for 4 years. So I feel I've been talking issues. Nobody likes "who shot John," but I think the first negative campaign run in this election was by Governor Clinton. And I'm not going to sit there and be a punching bag. I'm going to stand up and say, "Hey, listen, here's my side of it." But character is an important part of the equation. The other night, Governor Clinton raised -- I don't know if you saw the debate the other night, suffered through that. [Laughter] Well, he raised a question of my father. It was a good line, well-rehearsed and well-delivered. But he raised a question of my father and said, "Well, your father, Prescott Bush, was against McCarthy. You should be ashamed of yourself -- McCarthyism." I remember something my dad told me. I was 18 years old, going to Penn Station to go into the Navy. He said, "Write your mother," which I faithfully did. He said, "Serve your country." My father was an honor, duty, and country man. And he said, "Tell the truth." And I've tried to do that in public life, all through it. That has said something about character. My argument with Governor Clinton -- you can call it mud wrestling, but I think it's fair to put it in focus -- is I am deeply troubled by someone who demonstrates and organizes demonstration in a foreign land when his country's at war. Probably a lot of kids here disagree with me, but that's what I feel. That's what I feel passionately about. I'm thinking of Ross Perot's running mate sitting in the jail; how would he feel about it? But maybe that's generational. I don't know. But the big argument I have with the Governor on this is this taking different positions on different issues, trying to be one thing to one person here that's opposing the NAFTA agreement and then for it; what we call waffling. And I do think that you can't turn the White House into the waffle house. You've got to say what you're for. And you have got to -- -- Ms. Simpson. Mr. President, I am getting time cues, and with all due respect, I'm sorry. President Bush. Excuse me, I don't want to -- no, go ahead, Carole. Ms. Simpson. Governor Clinton. President Bush. I get wound up because I feel strongly. Ms. Simpson. Yes, you do. [Laughter] Governor Clinton. Let me say first of all to you that I believe so strongly in the question you asked that I suggested this format tonight. I started doing these formats a year ago in New Hampshire, and I found that we had huge crowds because all I did was let people ask questions, and I tried to give very specific answers. I also had a program starting last year. I've been disturbed by the tone and the tenor of this campaign. Thank goodness the networks have a fact check so I don't have to just go blue in the face anymore. Mr. Bush said once again tonight I was going to have a $150 billion tax increase. When Mr. Quayle said that, all the networks said: that's not true; he's got over $100 billion in tax cuts and incentives. So I'm not going to take up your time tonight, but let me just say this. We'll have a debate in 4 days, and we can talk about this character thing again, but the Washington Post ran a long editorial today saying they couldn't believe Mr. Bush was making character an issue, and they said he was the greatest political chameleon, for changing his positions, of all time. Now, I don't want to get into that -- -- President Bush. Please don't say anything by the Washington Post. Governor Clinton. Wait a minute. Let's don't -- you don't have to believe that. Here's my point. I'm not interested in his character. I want to change the character of the Presidency. And I'm interested in what we can trust him to do and what you can trust me to do and what you can trust Mr. Perot to do for the next 4 years. So I think you're right, and I hope the rest of the night belongs to you. Ms. Simpson. May I -- I talked to this audience before you gentlemen came, and I asked them about how they felt about the tenor of the campaign. Would you like to let them know what you thought about that, when I said, "Are you pleased with how the campaign's been going?" Audience members. No! Ms. Simpson. Who wants to say why you don't like the way the campaign is going? We have a gentleman back here? Focusing on Issues Q. If I may, and forgive the notes here, but I'm shy on camera. The focus of my work as a domestic mediator is meeting the needs of the children that I work with by way of their parents, and not the wants of their parents. I ask the three of you, how can we as, symbolically, the children of the future President, expect the two of you, the three of you, to meet our needs, the needs in housing and in crime and you name it, as opposed to the wants of your political spin doctors and your political parties? Ms. Simpson. So your question is -- -- Q. Can we focus on the issues and not the personalities and the mud? I think there is a need -- if we could take a poll here with the folks from Gallup, perhaps -- I think there is a real need here to focus at this point on the needs. Ms. Simpson. How do you respond? How do you gentlemen respond to -- -- Governor Clinton. I agree with him. Ms. Simpson. President Bush? President Bush. Let's do it. Let's talk about programs for children. Q. Could we cross our hearts, and it sounds silly here, but could we make a commitment? You know, we're not under oath at this point, but could you make a commitment to the citizens of the United States to meet our needs, and we have many, and not yours again? You know, I repeat that; that's a real need I think that we all have. President Bush. I think it depends on how you define it. I mean, I think, in general, let's talk about these issues, let's talk about the programs. But in the Presidency, a lot goes into it. Caring goes into it; that's not particularly specific. Strength goes into it; that's not specific. Standing up against aggression; that's not specific in terms of a program. This is what a President has to do. So, in principle, though, I'll take your point. I think we ought to discuss child care or whatever else it is. Ms. Simpson. And you two? Governor Clinton. Ross had his hand up. Mr. Perot. No hedges, no ifs, ands, and buts, I'll take the pledge, because I know the American people want to talk about issues and not tabloid journalism. So I'll take the pledge, and we'll stay on the issues. Now, just for the record, I don't have any spin doctors. I don't have any speechwriters. Probably shows. [Laughter] I make those charts you see on television even. [Laughter] But you don't have to wonder if it's me talking. Hey, what you see is what you get. If you don't like it, you've got two other choices, right? Governor Clinton. Wait a minute. I want to say just one thing now, Ross, in fairness. The ideas I express are mine. I've worked on these things for 12 years, and I'm the only person up here who hasn't been part of Washington in any way for the last 20 years. So I don't want the implication to be that somehow everything we say is just cooked up and put in our head by somebody else. I worked 12 years very hard as a Governor on the real problems of real people. I'm just as sick as you are by having to wake up and figure out how to defend myself every day. I never thought I'd ever be involved in anything like this. Mr. Perot. May I finish? Ms. Simpson. Yes, you may finish. Mr. Perot. Very briefly? Ms. Simpson. Yes, very briefly. Mr. Perot. I don't have any foreign money in my campaign. I don't have any foreign lobbyists on leave in my campaign. I don't have any PAC money in my campaign. I've got 5 1/2 million hard-working people who have put me on the ballot, and I belong to them. Ms. Simpson. Okay. Mr. Perot. And they are interested in what you're interested in. I'll take the pledge. I've already taken the pledge on cutting the deficit in half. I never got to say that. There's a great young group, Lead or Leave, college students, young people who don't want us to spend their money. I took the pledge we'd cut it out. Ms. Simpson. Thank you. We have a question here. Domestic Infrastructure Q. Yes. I would like to get a response from all three gentlemen. And the question is, what are your plans to improve the physical infrastructure of this Nation, which includes the water system, the sewer system, our transportation systems, et cetera? Thank you. Ms. Simpson. The cities. Who is going to fix the cities, and how? President Bush. I'd be glad to take a shot at it. Ms. Simpson. Please. President Bush. I'm not sure that -- and I can understand if you haven't seen this because there's been a lot of hue and cry. We passed this year the most farthest looking transportation bill in the history of this country since Eisenhower started the interstate highways, $150 billion for improving the infrastructure. That happened when I was President. So I am very proud of the way that came about, and I think it's a very, very good beginning. Like Mr. Perot, I am concerned about the deficits. And $150 billion is a lot of money, but it's awful hard to say we're going to go out and spend more money when we're trying to get the deficit down. But I would cite that as a major accomplishment. We hear all the negatives. When you're President, you expect this. Everybody's running against the incumbent. They can do better; everyone knows that. But here's something that we can take great pride in because it really does get to what you're talking about. Our home initiative, our homeownership initiative, HOPE, that passed the Congress is a good start for having people own their own homes instead of living in these deadly tenements. Our enterprise zones that we hear a lot of lip service about in Congress would bring jobs into the inner city. There's a good program. I need the help of everybody across this country to get it passed in substantial way by the Congress. When we went out to South Central in Los Angeles -- some of you may remember the riots there. I went out there. I went to a boys club, and every one of them, the boys club leaders, the ministers, all of them were saying, pass enterprise zones. We go back to Washington, and very difficult to get it through the Congress. But there's going to be a new Congress. No one likes gridlock. There's going to be a new Congress because the old one, I don't want to get this man mad at me, but there was a post office scandal and a bank scandal. You're going to have a lot of new Members of Congress. And then you can sit down and say, "Help me do what we should for the cities. Help me pass these programs." Ms. Simpson. Mr. President, aren't you threatening to veto the bill, the urban aid bill, that included enterprise zones? President Bush. Sure, but the problem is you get so many things included in a great big bill that you have to look at the overall good. That's the problem with our system. If you had a line-item veto, you could knock out the pork. You could knock out the tax increases, and you could do what the people want, and that is create enterprise zones. Ms. Simpson. Governor Clinton, you're chomping at the bit. Governor Clinton. That bill pays for these urban enterprise zones by asking the wealthiest Americans to pay a little more, and that's why he wants to veto it, just like he vetoed an earlier bill this year. This is not mud slinging. This is fact slinging. President Bush. There you go. Governor Clinton. A bill earlier this year -- this is fact -- that would have given investment tax credits and other incentives to reinvest in our cities and our country. But it asked the wealthiest Americans to pay a little more. Mr. Perot wants to do the same thing. I agree with him. I mean, we agree with that. Let me tell you specifically what my plan does: My plan would dedicate $20 billion a year in each of the next 4 years for investments in new transportation, communications, environmental cleanup, and new technologies for the 21st century. We would target it especially in areas that have been either depressed or which have lost a lot of defense-related jobs. There are 200,000 people in California, for example, who have lost their defense-related jobs. They ought to be engaged in making high-speed rail. They ought to be engaged in breaking ground in other technologies, doing waste recycling, clean water technology, and things of that kind. We can create millions of jobs in these new technologies, more than we're going to lose in defense if we target it. But we're investing a much smaller percentage of our income in the things you just asked about than all of our major competitors. Our wealth growth is going down as a result of it. It's making the country poorer, which is why I answered the gentleman the way I did before. We have to both bring down the deficit and get our economy going through these kinds of investments in order to get the kind of wealth and jobs and incomes we need in America. Ms. Simpson. Mr. Perot, what about your plans for the cities? You want to tackle the economy and the deficit first. Mr. Perot. First, you've got to have money to pay for these things. So you've got to create jobs, and there are all kinds of ways to create jobs in the inner city. Now, I am not a politician, but I think I could go to Washington in a week and get everybody holding hands and get this bill signed, because I talked to the Democratic leaders, and they want it. I talked to the Republican leaders, and they want it. But since they are bred from childhood to fight with one another rather than get results, I would be glad to drop out and spend a little time and see if we couldn't build some bridges. Now, results is what counts. The President can't order Congress around. Congress can't order the President around. That's not bad for a guy that's never been there, right? But you have to work together. Now, I have talked to the chairmen of the committees that want this; they're Democrats. The President wants it. But we can't get it because we sit here in gridlock because it's a campaign year. We didn't fund a lot of other things this year, like the savings and loan mess. That's another story that we're going to pay a big price for right after the election. The facts are, though, the facts are the American people are hurting. These people are hurting in the inner cities. We're shipping the low-paying, quote, "low-paying" jobs overseas. What are low-paying jobs? Textiles, shoes, things like that that we say are yesterday's industries. They're tomorrow's industries in the inner city. Let me say in my case, if I'm out of work, I'll cut grass tomorrow to take care of my family. I'll be happy to make shoes. I'll be happy to make clothing. I'll make sausage. You just give me a job. Put those jobs in the inner cities, instead of doing diplomatic deals and shipping them to China, where prison labor does the work. Washington Gridlock Ms. Simpson. Mr. Perot, everybody thought you won the first debate because you were plain-speaking, and you make it sound, oh, so simple. "We'll just do it." What makes you think that you're going to be able to get the Democrats and Republicans together any better than these guys? Mr. Perot. If you asked me if I could fly a fighter plane or be an astronaut, I can't. I've spent my life creating jobs. It's something I know how to do, and very simply in the inner city, they're starved. You see, small businesses is the way to jump-start the inner city. Ms. Simpson. Are you answering my question? [Laughter] Mr. Perot. You want jobs in the inner city? Do you want jobs in the inner city? Is that your question? Ms. Simpson. No, I want you to tell me how you're going to be able to get the Republicans and Democrats in Congress -- -- Mr. Perot. Oh, I'm sorry. Ms. Simpson. -- -- to work together better than these two gentlemen. Mr. Perot. I've listened to both sides. If they would talk to one another instead of throwing rocks, I think we could get a lot done. And among other things, I would say, okay, over here in this Senate committee, to the chairman who is anxious to get this bill passed, to the President who's anxious, I'd say, "Rather than just yelling at one another, why don't we find out where we're apart; try to get together. Get the bill passed, and give the people the benefits, and not play party politics right now." I think the press would follow that so closely that probably they would get it done. That's the way I would do it. I doubt if they'll give me the chance, but I will drop everything and go work on it. Ms. Simpson. Okay. I have a question here. Gun Control and Crime Q. My question was originally for Governor Clinton, but I think I would welcome a response from all three candidates. As you are aware, crime is rampant in our cities. In the Richmond area, and I'm sure it's happened elsewhere, 12-year-olds are carrying guns to school. And I'm sure when our Founding Fathers wrote the Constitution, they did not mean for the right to bear arms to apply to 12-year-olds. So I'm asking, where do you stand on gun control, and what do you plan to do about it? Ms. Simpson. Governor Clinton? Governor Clinton. I support the right to keep and bear arms. I live in a State where over half the adults have hunting or fishing licenses or both. But I believe we have to have some way of checking handguns before they're sold, to check the criminal history, the mental health history, and the age of people who are buying them. Therefore, I support the Brady bill, which would impose a national waiting period, unless and until a State did what only Virginia has done now, which is to automate its records. Once you automate your records, then you don't have to have a waiting period, but at least you can check. I also think we should have, frankly, restrictions on assault weapons, whose only purpose is to kill. We need to give the police a fighting chance in our urban areas where the gangs are building up. The third thing I would say doesn't bear directly on gun control, but it's very important. We need more police on the street. There is a crime bill which would put more police on the street, which was killed for this session by a filibuster in the Senate, mostly by Republican Senators. I think it's a shame it didn't pass. I think it should be made the law, but it had the Brady bill in it, the waiting period. I also believe that we should offer college scholarships to people who will agree to work them off as police officers. I think as we reduce our military forces, we should let people earn military retirement by coming out and working as police officers. Thirty years ago there were three police officers on the street for every crime. Today, there are three crimes for every police officer. In the communities which have had real success putting police officers near schools where kids carry weapons, to get the weapons out of the schools, or on the same blocks, you've seen crime go down. In Houston there's been a 15-percent drop in the crime rate in the last year because of the work the Mayor did there in increasing the police force. So I know it can work. I've seen it happen. Ms. Simpson. Thank you. President Bush? President Bush. I think you put your finger on a major problem. I talk about strengthening the American family. It's very hard to strengthen the family if people are scared to walk down to the corner store and send their kid down to get a loaf of bread. It's very hard. I have been fighting for very strong anticrime legislation: habeas corpus reform, so you don't have these endless appeals; so when somebody gets sentenced, hey, this is for real. I've been fighting for changes in the exclusionary rule, so if an honest cop stops somebody and makes a technical mistake, the criminal doesn't go away. I'll probably get into a fight in this room with some, but I happen to think that we need stronger death penalties for those that kill police officers. Virginia's in lead in this, as Governor Clinton properly said, on this identification system for firearms. I am not for national registration of firearms. Some of the States that have the toughest antigun laws have the highest levels of crime. I am for the right -- as the Governor says, I'm a sportsman, and I don't think you ought to eliminate all kinds of weapons. But I was not for the bill that he was talking about because it was not tough enough on the criminal. I'm very pleased that the Fraternal Order of Police in Little Rock, Arkansas, endorsed me, because I think they see I'm trying to strengthen the anticrime legislation. We've got more money going out for local police than any previous administration. So we've got to get it under control. And as one last point I'd make: drugs. We have got to win our national strategy against drugs, the fight against drugs. We're making some progress, doing a little better on interdiction. We're not doing as well amongst the people that get to be habitual drug users. The good news is, and I think it's true in Richmond, teenage use is down of cocaine substantially, 60 percent in the last couple of years. So we're making progress. But until we get that one done, we're not going to solve the neighborhood crime problem. Ms. Simpson. Mr. Perot, there are young black males in America dying at unprecedented -- -- Mr. Perot. I would just make a comment on this. Ms. Simpson. Yes, I'm getting -- -- Mr. Perot. Oh, you're going to elaborate. Okay, excuse me. Ms. Simpson. -- -- to the fact that homicide is the leading cause of death among young black males, 15 to 24 years old. What are you going to do to get the guns off the street? Mr. Perot. On any program, and this includes crime, you'll find we have all kinds of great plans lying around that never get enacted into law and implemented. I don't care what it is, competitiveness, health care, crime, you name it. The Brady bill, I agree that it's a timid step in the right direction, but it won't fix it. So why pass a law that won't fix it? Now, what it really boils down to is can you live -- we have become so preoccupied with the rights of the criminal that we have forgotten the rights of the innocent. In our country, we have evolved to a point where we've put millions of innocent people in jail, because you go to the poor neighborhoods and they've put bars on their windows and bars on their doors and put themselves in jail to protect the things that they acquired legitimately. Now, that's where we are. We have got to become more concerned about people who play by the rules and get the balance we require. This is going to take, first, building a consensus in grassroots America. Right from the bottom up, the American people have got to say they want it. And at that point, we can pick from a variety of plans and develop new plans. And the way you get things done is bury yourselves in the room with one another, put together the best program, take it to the American people, use the electronic town hall, the kind of thing you're doing here tonight, build a consensus, and then do it and then go on to the next one. But don't just sit here slow dancing for 4 years doing nothing. Ms. Simpson. Thank you. Thank you, Mr. Perot. We have a question up here. Term Limits Q. Please state your position on term limits. And if you are in favor of them, how will you get them enacted? President Bush. Any order? I'll be glad to respond. I strongly support term limits for Members of the United States Congress. I believe it would return the Government closer to the people, the way that Ross Perot is talking about. The President's terms are limited to two, a total of 8 years. What's wrong with limiting the terms of Members of Congress to 12? Congress has gotten kind of institutionalized. For 38 years, one party has controlled the House of Representatives. And the result? A sorry little post office that can't do anything right and a bank that has more overdrafts than all of Chase Bank and Citibank put together. We've got to do something about it. I think you get a certain arrogance, bureaucratic arrogance if people stay there too long. So I favor, strongly favor term limits. And how to get them passed? Send us some people that will pass the idea, and I think you will. I think the American people want it now. Everyplace I go, I talk about it, and I think they want it done. Actually, you'd have to have some amendments to the Constitution because of the way the Constitution reads. Ms. Simpson. Thank you. Governor Clinton? Governor Clinton. I know they're popular, but I'm against them. I'll tell you why. I believe, number one, it would pose a real problem for a lot of smaller States in the Congress who would have enough trouble now making sure their interests are heard. Number two, I think it would increase the influence of unelected staff members in the Congress who have too much influence already. I want to cut the size of the congressional staffs, but I think you're going to have too much influence there with people who were never elected who have lots of expertise. Number three, if the people really have a mind to change, they can. You're going to have 120 to 150 new Members of Congress. Now, let me tell you what I favor instead. I favor strict controls on how much you can spend running for Congress, strict limits on political action committees, requirements that people running for Congress appear in open public debates like we're doing now. If you did that, you could take away the incumbent's advantage, because challengers like me would have a chance to run against incumbents like him for the House races and Senate races, and then the voters could make up their own mind without being subject to an unfair fight. So that's how I feel about it, and I think if we had the right kind of campaign reform, we'd get the changes you want. Ms. Simpson. Mr. Perot, would you like to address term limitations? Mr. Perot. Yes. Let me do it first on a personal level. If the American people send me up to do this job, I intend to be there one term. I do not intend to spend one minute of one day thinking about reelection. It is a matter of principle. My situation is unique, and I understand it. I will take absolutely no compensation. I go as their servant. Now, I have set as strong an example as I can. And at that point, when we sit down over at Capitol Hill -- tomorrow night I'm going to be talking about Government reform. It is a long subject; you wouldn't let me finish tonight. If you want to hear it, you can get it tomorrow night. [Laughter] But the point is, you'll hear it tomorrow night. But we have got to reform Government. If you put term limits in and don't reform Government, you won't get the benefit you thought. It takes both. So we need to do the reforms and the term limits. And after we reform it, it won't be a lifetime career opportunity. Good people will go serve and then go back to their homes, and not become foreign lobbyists and cash in at 30,000 bucks a month, and then take time off to run some President's campaign. They're all nice people. They're just in a bad system. I don't think there are any villains, but boy, is the system rotten. Ms. Simpson. Thank you very much. We have a question over here. Health Care Reform Q. I'd like to ask Governor Clinton, do you attribute the rising costs of health care to the medical profession itself, or do you think the problem lies elsewhere? And what specific proposals do you have to tackle this problem? Governor Clinton. I've had more people talk to me about their health care problems, I guess, than anything else. All across America, people who have lost their jobs, lost their businesses, had to give up their jobs because of sick children -- so let me try to answer you in this way. Let's start with the premise. We spend 30 percent more of our income than any nation on Earth on health care. And yet, we insure fewer people. We have 35 million people without any insurance at all, and I see them all the time. One hundred thousand Americans a month have lost their health insurance just in the last 4 years. So if you analyze where we're out of line with other countries you come up with the following conclusions: Number one, we spend at least $60 billion a year on insurance, administrative costs, bureaucracy, and Government regulation that wouldn't be spent in any other nation. So we have to have, in my judgment, a drastic simplification of the basic health insurance policies of this country, be very comprehensive for everybody. Employers would cover their employees. Government would cover the unemployed. Number two, I think you have to take on specifically the insurance companies and require them to make some significant change in the way they rate people in the big community pools. I think you have to tell the pharmaceutical companies they can't keep raising drug prices at 3 times the rate of inflation. I think you have to take on medical fraud. I think you have to help doctors stop practicing defensive medicine. I've recommended that our doctors be given a set of national practice guidelines and that if they follow those guidelines, that raises the presumption that they didn't do anything wrong. I think you have to have a system of primary preventive clinics in our inner cities and our rural areas so people can have access to health care. But the key is to control the costs and maintain the quality. To do that, you need a system of managed competition where all of us are covered in big groups, and we can choose our doctors and our hospitals from a wide range, but there is an incentive to control costs. And I think there has to be -- I think Mr. Perot and I agree on this -- there has to be a national commission of health care providers and health care consumers that set ceilings to keep health costs in line with inflation plus population growth. Now, let me say, some people say we can't do this, but Hawaii does it. They cover 98 percent of their people, and their insurance premiums are much cheaper than the rest of America. So does Rochester, New York. They now have a plan to cover everybody, and their premiums are two-thirds the rest of the country. This is very important. It's a big human problem and a devastating economic problem for America. I'm going to send a plan to do this within the first 100 days of my Presidency. It's terribly important. Ms. Simpson. Thank you. Sorry to cut you short, but, President Bush, health care reform. President Bush. I just have to say something. I don't want to stampede -- Ross was very articulate. Across the country, I don't want anybody to stampede to cut the President's salary off altogether. Barbara is sitting over here, and I -- [laughter] -- but what I have proposed, 10 percent cut, downsize the Government, and we can get that done. She asked the question, I think, is whether the health care profession was to blame. No. One thing to blame is these malpractice lawsuits. They are breaking the system. It costs $20 to $25 billion a year, and I want to see those outrageous claims capped. Doctors don't dare to deliver babies sometimes because they're afraid that somebody's going to sue them. People don't dare, medical practitioners, to help somebody along the highway that are hurt because they're afraid that some lawyer's going to come along and get a big lawsuit. So you can't blame the practitioners or the health -- and my program is this: Keep the Government as far out of it as possible, make insurance available to the poorest of the poor through vouchers, next range in the income bracket through tax credits, and get on about the business of pooling insurance. A great, big company can buy -- Ross has got a good size company, been very successful. He can buy insurance cheaper than mom-and-pop stores on the corner. But if those mom-and-pop stores all get together and pool, they, too, can bring the cost of insurance down. So I want to keep the quality of health care. That means keep Government out of it. I don't like this idea of these boards. It all sounds to me like you're going to have some Government setting price. I want competition, and I want to pool the insurance and take care of it that way. Here's the other point. I think medical care should go with the person. If you leave a business, I think your insurance should go with you to some other business. You shouldn't be worrying if you get a new job as to whether that's going to -- and part of our plan is to make it what they call portable, big word, but that means if you're working for the Jones Company and you go to the Smith Company, your insurance goes with you. I think it's a good program. I'm really excited about getting it done, too. Ms. Simpson. Mr. Perot? Mr. Perot. We have the most expensive health care system in the world. Twelve percent of our gross national product goes to health care. Our industrial competitors, who are beating us in competition, spend less and have better health care. Japan spends a little over 6 percent of its gross national product; Germany spends 8 percent. It's fascinating. You bought a front-row box seat, and you're not happy with your health care. You're saying tonight we've got bad health care but very expensive health care. Folks, here's why. Go home and look in the mirror. You own this country, but you have no voice in it the way it's organized now. If you want to have a high-risk experience comparable to bungee jumping -- [laughter] -- go into Congress sometime when they're working on this kind of legislation, when the lobbyists are running up and down the halls. Wear your safety-toe shoes when you go. [Laughter] And as a private citizen, believe me, you are looked on as a major nuisance. The facts are, you now have a Government that comes at you. You're supposed to have a Government that comes from you. Now, there are all kinds of good ideas, brilliant ideas, terrific ideas on health care. None of them ever get implemented because -- let me give you an example. A Senator runs every 6 years. He's got to raise 20,000 bucks a week to have enough money to run. Who's he going to listen to, us or the folks running up and down the aisle with money, the lobbyists, the PAC money? He listens to them. Who do they represent? Health care industry. Not us. Now, you've got to have a Government that comes from you again. You've got to reassert your ownership in this country, and you've got to completely reform our Government. And at that point, they'll just be like apples falling out of a tree. The programs will be good because the elected officials will be listening, too. I said the other night I was all ears and I would listen to any good idea. I think we ought to do plastic surgery on a lot of these guys so that they're all ears, too, and listen to you. Then you get what you want, and shouldn't you? You paid for it. Why shouldn't you get what you want as opposed to what some lobbyist cuts a deal, writes the little piece in the law, and it goes through. That's the way the game's played now. Until you change it, you're going to be unhappy. Ms. Simpson. Thank you. Governor Clinton, you wanted one brief point. Governor Clinton. One brief point. We have elections so people can make decisions about this. The point I want to make to you is, a bipartisan commission reviewed my plan and the Bush plan and concluded -- there were as many Republicans as Democratic health care experts on it -- they concluded that my plan would cover everybody, and his would leave 27 million behind by the year 2000, and that my plan in the next 12 years would save $2.2 trillion in public and private money to reinvest in this economy. The average family would save $1,200 a year under the plan that I offered, without any erosion in the quality of health care. So I ask you to look at that. You have to vote for somebody with a plan. That's what you have elections for. If people say, "Well, he got elected to do this," and then the Congress says, "Okay, I'm going to do it." That's what the election was about. Ms. Simpson. Brief, Governor Clinton. Thank you. We have a question right here. Personal Impact of the Economy Q. Yes, how has the national debt personally affected each of your lives? And if it hasn't, how can you honestly find a cure for the economic problems of the common people if you have no experience in what's ailing them? Mr. Perot. May I answer it? Ms. Simpson. Well, Mr. Perot, yes, of course. Mr. Perot. Who do you want to start with? Q. My question is for each of you, so -- -- Mr. Perot. Yes, it caused me to disrupt my private life and my business to get involved in this activity. That's how much I care about it. Believe me, if you knew my family and if you knew the private life I have, you would agree in a minute that that's a whole lot more fun than getting involved in politics. I have lived the American dream. I came from a very modest background. Nobody's been luckier than I've been, all the way across the spectrum, and the greatest riches of all are my wife and children. It's true of any family. But I want all the children, I want these young people up here to be able to start with nothing but an idea like I did and build a business. But they've got to have a strong basic economy. And if you're in debt, it's like having a ball and chain around you. I just figure as lucky as I've been, I owe it to them, and I owe it to the future generations. And on a very personal basis, I owe it to my children and grandchildren. Ms. Simpson. Thank you, Mr. Perot. Mr. President. President Bush. Well, I think the national debt affects everybody. Obviously, it has a lot to do with interest rates -- -- Ms. Simpson. She's saying you personally. Q. You, on a personal basis, how has it affected you? Ms. Simpson. Has it affected you personally? President Bush. Well, I'm sure it has. I love my grandchildren. I want to think that -- -- Q. How? President Bush. I want to think that they're going to be able to afford an education. I think that that's an important part of being a parent. If the question -- maybe I get it wrong. Are you suggesting that if somebody has means that the national debt doesn't affect them? Q. What I'm saying -- -- President Bush. I'm not sure I get it. Help me with the question, and I'll try to answer it. Q. Well, I've had friends that have been laid off in jobs -- -- President Bush. Yes. Q. I know people who cannot afford to pay the mortgage on their homes, their car payment. I have personal problems with the national debt. But how has it affected you? And if you have no experience in it, how can you help us if you don't know what we're feeling? Ms. Simpson. I think she means more the recession, the economic problems today the country faces rather than -- -- President Bush. Well, listen, you ought to be in the White House for a day and hear what I hear and see what I see and read the mail I read and touch the people that I touch from time to time. I was in the Lomax AME Church. It's a black church just outside of Washington, DC, and I read in the bulletin about teenage pregnancies, about the difficulty that families are having to make ends meet. I talked to parents. I mean, you've got to care. Everybody cares if people aren't doing well. But I don't think it's fair to say you haven't had cancer, therefore you don't know what it's like. I don't think it's fair to say, whatever it is, if you haven't been hit by it personally. But everybody's affected by the debt, because of the tremendous interest that goes into paying on that debt, everything's more expensive. Everything comes out of your pocket and my pocket. So it's that. But I think in terms of the recession, of course, you feel it when you're President of the United States. That's why I'm trying to do something about it by stimulating the export, investing more, better education system. Thank you. I'm glad you clarified it. Governor Clinton. Tell me how it's affected you again? You know people who have lost their jobs and lost their homes? Q. Yes. Governor Clinton. Well, I've been Governor of a small State for 12 years. I'll tell you how it's affected me. Every year, Congress and the President sign laws that make us do more things; it gives us less money to do it with. I see people in my State, middle class people, their taxes have gone up from Washington and their services have gone down, while the wealthy have gotten tax cuts. I have seen what's happened in this last 4 years when, in my State, when people lose their jobs there's a good chance I'll know them by their names. When a factory closes, I know the people who ran it. When the businesses go bankrupt, I know them. And I've been out here for 13 months, meeting in meetings just like this ever since October with people like you all over America, people that have lost their jobs, lost their livelihood, lost their health insurance. What I want you to understand is, the national debt is not the only cause of that. It is because America has not invested in its people. It is because we have not grown. It is because we've had 12 years of trickle-down economics. We've gone from 1st to 12th in the world in wages. We've had 4 years where we've produced no private sector jobs. Most people are working harder for less money than they were making 10 years ago. It is because we are in the grip of a failed economic theory. And this decision you're about to make better be about what kind of economic theory you want, not just people saying, "I want to go fix it," but what are we going to do. What I think we have to do is invest in American jobs, in American education, control American health care costs, and bring the American people together again. Ms. Simpson. Thank you, Governor Clinton. We are a little more than halfway through this program, and I'm glad that we're getting the diversity of questions that we are. And I don't want to forget these folks on the wings over here, so let's go over here. Do you have a question? Entitlement Programs Q. Yes, I do. My name is Ben Smith. I work in the financial field, counseling retirees. And I'm personally concerned about three major areas. One is the Social Security Administration or trust fund is projected to be insolvent by the year 2036. We've funded the trust fund with IOU's in the form of Treasury bonds. The pension guaranty fund which backs up our private retirement plans for retirees is projected to be bankrupt by the year 2026, not to mention the cutbacks by private companies. And Medicare is projected to be bankrupt maybe as soon as 1997. I would like from each of you a specific response as to what you intend to do for retirees relative to these issues, not generalities but specifics, because I think they're very disturbing issues. Ms. Simpson. President Bush, may we start with you? President Bush. Well, the Social Security -- you're an expert and I could, I'm sure, learn from you the details of the pension guaranty fund and the Social Security fund. The Social Security system was fixed, about 5 years, and I think it's projected out to be sound beyond that. So at least we have time to work with it. But on all of these things, a sound economy is the only way to get it going. Growth in the economy is going to add to the overall prosperity and wealth. I can't give you a specific answer on pension guaranty fund. All I know is that we have firm Government credit to guarantee the pensions, and that is very important. But the full faith in credit of the United States, in spite of our difficulties, is still pretty good. It's still the most respected credit. So I would simply say, as these dates get close you're going to have to reorganize and refix as we did with the Social Security fund. I think that's the only answer. But the more immediate answer is to do what this lady was suggesting we do, and that is to get this deficit down and get on without adding to the woes, and then restructure. One thing I've called for that has been stymied, and I'll keep on working for it, is a whole financial reform legislation. It is absolutely essential in terms of bringing our banking system and credit system into the new age instead of having it living back in the dark ages, and it's a big fight. I don't want to give my friend Ross another shot at me here, but I am fighting with the Congress to get this through. You can't just go up and say, "I'm going to fix it." You've got some pretty strong-willed guys up there that argue with you. But that's what the election's about; I agree with the Governor. That's what the election is about. Sound fiscal policy is the best answer, I think, to all the three problems you mentioned. Ms. Simpson. Thank you. Mr. Perot? Mr. Perot. Just on a broad issue here. When you're trying to solve a problem, you get the best plans. You have a raging debate about those plans. Then out of that debate, with leadership, comes consensus. And if the plans are huge and complex, like health care, I would urge you to implement pilot programs. Like the older carpenter says, measure twice, cut once. Let's make sure this thing's as good as we all think it is at the end of the meeting. Then, finally, our Government passes laws and freezes the plan in concrete. Anybody that's ever built a successful business will tell you, you optimize, optimize, optimize after you put something into effect. The reason Medicare and Medicaid are a mess is we froze them. Everybody knows how to fix them. There are people all over the Federal Government if they could just touch it with a screwdriver could fix it. Now, back over here. See, we've got a $4 trillion debt, and only in America would you have $2.8 trillion of it, or 70 percent of it, financed 5 years or less. Now, that's another thing for you to think about when you go home tonight. You don't finance long-term debt with short-term money. Why did our Government do it? To get the interest rates down. A one-percent increase in interest rates in that $2.8 trillion is $28 billion a year. Now, when you look at what Germany pays for money and what we don't pay for money, you realize there's quite a spread, right? You realize this is a temporary thing and there's going to be another sucking sound that runs our deficit through the roof. You know, and everybody's ducking it so I'm going to say it, that we are not letting that surplus stay in the bank. We are not investing that surplus like a pension fund. We are spending that surplus to make the deficit look smaller to you than it really is. Now, that puts you in jail in corporate America if you kept books that way, but in Government it's just kind of the way things are. That's because it comes at you, not from you. Now then, that money needs to be -- they don't even pay interest on it, they just write a note for the interest. Ms. Simpson. Mr. Perot, can you wrap it up? Mr. Perot. Sure. But the point, see, do you want to fix the problem or sound-bite it? I understand the importance of time, but see, here's how we get to this mess we're in. This is just 1 of 1,000. Ms. Simpson. But we've got to be fair. Mr. Perot. Now then, to nail it, there's one way out, a growing, expanding job base, a growing, expanding job base to generate the funds and the tax revenues to pay off the mess and rebuild America. We've got to double hit. If we're $4 trillion down, we should have everything perfect, but we don't. We've got to pay it off and build money to renew it, spend money to renew it, and that's going to take a growing, expanding job base. That is priority one in this country. Put everybody that's breathing to work. I'd love to be out of workers and have to import them, like some of our international competitors. Ms. Simpson. Mr. Perot, I'm sorry, I'm going to -- -- Mr. Perot. Sorry. Ms. Simpson. And I don't want to sound-bite you, but we are trying to be fair to everyone. Mr. Perot. No, absolutely. I apologize. Ms. Simpson. All right, Governor Clinton. Governor Clinton. I think I remember the question. [Laughter] Let me say first of all, I want to answer your specific question, but first of all, we all agree that there should be a growing economy. What you have to decide is who's got the best economic plan. We all have ideas out there, and Mr. Bush has a record. I don't want you to read my lips, and I sure don't want you to read his. [Laughter] I do hope you will read our plans. Now, specifically -- -- President Bush. [Inaudible] -- first rule? Governor Clinton. -- -- one, on Medicare, it is not true that everyone knows how to fix it; there are different ideas. The Bush plan, the Perot plan, the Clinton -- we have different ideas. I am convinced, having studied health care for a year, hard, and talking to hundreds and hundreds of people all across America, that you cannot control the costs of Medicare until you control the cost of private health care and public health care with managed competition, ceiling on cost, and radical reorganization of the insurance markets. You've got to do that. We've got to get those costs down. Number two, with regard to Social Security, that program, a lot of you may not know this: It produces a $70 billion surplus a year. Social Security is in surplus $70 billion. Six increases in the payroll tax -- that means people with incomes of $51,000 a year or less pay a disproportionately high share of the Federal tax burden, which is why I want some middle class tax relief. What do we have to do? By the time the century turns, we have got to have our deficit under control, we have to work out of so that surplus is building up, so when the baby boomers like me retire, we're okay. Number three, on the pension funds, I don't know as much about it, but I will say this: What I will do is to bring in the pension experts of the country, take a look at it, and strengthen the pension requirements further, because it's not just enough to have the guarantee. We had a guarantee on the S&L's, right? We had a guarantee, and what happened? You picked up a $500 billion bill because of the dumb way the Federal Government deregulated it. So I think we are going to have to change and strengthen the pension requirements on private retirement plans. Ms. Simpson. Thank you. I think we have a question here on international affairs, hopefully. Foreign Affairs Q. We've come to a position where we're in the new world order. And I'd like to know what the candidates feel our position is in this new world order and what our responsibilities are as a superpower. Ms. Simpson. Mr. President? President Bush. We have come to that position. Since I became President, 43, 44 countries have gone democratic. No longer totalitarian, no longer living under dictatorship or communist rule. This is exciting. This new world order to me means freedom and democracy. I think we will have a continuing responsibility, as the only remaining superpower, to stay involved. If we pull back in some isolation and say we don't have to do our share, or more than our share, anymore, I believe you're going to just ask for conflagration that we'll get involved in in the future. NATO, for example, has kept the peace for many, many years. I want to see us keep fully staffed in NATO so we'll continue to guarantee the peace in Europe. But the exciting thing is the fear of nuclear war is down. You hear all the bad stuff that's happened on my watch. I hope people will recognize that this is something pretty good for mankind. I hope they'll think it's good that democracy and freedom is on the move. And we're going to stay engaged, as long as I am President, working to improve things. You know, it's so easy now to say, hey, cut out foreign aid, we've got a problem at home. I think the United States has to still have the Statue of Liberty as a symbol of caring for others. We're right this very minute, we're sending supplies in to help these little starving kids in Somalia. It's the United States that's taken the lead in humanitarian aid into Bosnia. We're doing this all around the world. And yes, we've got problems at home. I think I've got a good plan to help fix those problems at home. But because of our leadership, because we didn't listen to the freeze, the nuclear freeze group -- do you remember: "Freeze it," back in about in the late seventies. "Freeze, don't touch it. We're going to lock it in now, or else we'll have war." President Reagan said, "No. Peace through strength." It worked. The Soviet Union is no more. Now we're working to help them become totally democratic through the FREEDOM Support Act that I led on. A great Democratic Ambassador, Bob Strauss over there, Jim Baker, all of us got this thing passed, through cooperation, Ross. It worked with cooperation. And you're for that, I'm sure, helping Russia become democratic. So the new world order to me means freedom and democracy, keep engaged, do not pull back into isolation. We are the United States, and we have a responsibility to lead and to guarantee the security. If it hadn't been for us, Saddam Hussein would be sitting on top of three-fifths of the oil supply of the world, and he'd have nuclear weapons. Only the United States could do this. Excuse me, Carole. Ms. Simpson. Thank you. Mr. Perot. Mr. Perot. Well, it's cost-effective to help Russia succeed in its revolution. It's pennies on the dollar compared to going back to the cold war. Russia's still very unstable. They could go back to square one and worse. All the nuclear weapons are not dismantled. I'm particularly concerned about the intercontinental weapons, the ones that can hit us. We've got agreements, but they're still there. With all this instability and breaking into Republics and all the Middle Eastern countries going over there and shopping for weapons, we've got our work cut out for us. So we need to stay right on top of that and constructively help them move toward democracy and capitalism. We have to have money to do that. We have to have our people at work. See, for 45 years, we were preoccupied with the Red Army. I suggest now that our number one preoccupation is red ink in our country. And we've got to put our people back to work so that we can afford to do these things we want to do in Russia. We cannot be the policeman for the world any longer. We spend $300 billion a year defending the world. Germany and Japan spend around $30 billion apiece. It's neat. If I can get you to defend me and I can spend all my money building industry, that's a home run for me. Coming out of World War II, it made sense. Now the other superpowers need to do their part. I'll close on this point: You can't be a superpower unless you're an economic superpower. If we're not an economic superpower, we are a used-to-be, and we will no longer be a force for good throughout the world. If nothing else gets you excited about rebuilding our industrial base, maybe that will, because job one is to put our people back to work. Ms. Simpson. Governor Clinton, the President mentioned Saddam Hussein. Your vice president and you have had some words about the President and Saddam Hussein. Would you care to comment? Governor Clinton. I'd rather answer her question first, and then I'll be glad to, because the question you ask is important. The end of the cold war brings an incredible opportunity for change, the winds of freedom blowing around the world, Russia demilitarizing. It also requires us to maintain some continuity, some bipartisan American commitment to certain principles. I would just say there are three things that I would like to say. Number one, we do have to maintain the world's strongest defense. We may differ about what the elements of that are. I think the defense needs to be with fewer people and permanent armed services, but with greater mobility on the land, in the air, and on the sea, with a real dedication to continuing development of high-technology weaponry and well-trained people. I think we're going to have to work to stop the proliferation of weapons of mass destruction. We've got to keep going until all those nuclear weapons in Russia are gone and the other Republics. Number two, if you don't rebuild the economic strength of this country at home, we won't be a superpower. We can't have any more instances like what happened when Mr. Bush went to Japan and the Japanese Prime Minister said he felt sympathy for our country. We have to be the strongest economic power in the world. That's what got me into this race, so we could rebuild the American economy. Number three, we need to be a force for freedom and democracy. We need to use our unique position to support freedom, whether it's in Haiti or in China or in any other place, wherever the seeds of freedom are sprouting. We can't impose it, but we need to nourish it. That's the kind of thing that I would do as President, follow those three commitments into the future. Ms. Simpson. Okay, we have a question up there. Education Q. We've talked a lot tonight about creating jobs. But we have an awful lot of high school graduates who don't know how to read a ruler, who cannot fill out an application for a job. How can we create high-paying jobs with the education system we have? And what would you do to change it? Ms. Simpson. Who would like to begin? The education President? President Bush. I'd be delighted to, because you can't do it the old way. You can't do it with the school bureaucracy controlling everything. And that's why we have a new program that I hope people have heard about. It's being worked now in 1,700 communities -- I bypassed Congress on this one, Ross -- 1,700 communities across the country. It's called America 2000. It literally says to the communities: Reinvent the schools, not just the bricks and mortar but the curriculum and everything else. Think anew. We have a concept called the New American School Corporation, where we're doing exactly that. So I believe that we've got to get the power in the hands of the teachers, not the teachers union -- what's happening up there? [Laughter] So our America 2000 program also says this: It says let's give parents the choice of a public, private, or religious school. And it works. It works in Milwaukee. A Democratic woman up there taking the lead in this, the Mayor up there on the program, and the schools that are not chosen are improved. Competition does that. So we've got to innovate through school choice. We've got to innovate through this America 2000 program. But she is absolutely right. The programs that we've been trying where you control everything and mandate it from Washington don't work. The Governors -- and I believe Governor Clinton was in on this, but I don't want to invoke him here -- but they come to me, and they say, please get the Congress to stop passing so many mandates telling us how to control things. We know better how to do it in California or Texas or wherever it is. So this is what our program is all about. I believe -- you're right onto something -- that if we don't change the education, we're not going to be able to compete. Federal funding for education is up substantially. Pell Grants are up. But it isn't going to get the job done if we don't change K through 12. Ms. Simpson. Governor Clinton? Governor Clinton. First of all, let me say that I've spent more of my time in life on this in the last 12 years than any other issue. Seventy percent of my State's money goes to public schools. I was really honored when Time magazine said that our schools have shown more improvement than any other State in the country except one other. They named two States showing real strides forward in the eighties. So I care a lot about this, and I've spent countless hours in schools. But let me start with what you've said. I agree with some of what Mr. Bush said, but it's nowhere near enough. We live in a world where what you earn depends on what you can learn, where the average 18-year-old will change jobs eight times in a lifetime, and where none of us can promise any of you that what you now do for a living is absolutely safe from now on. Nobody running can promise that. There's too much change in the world. So what should we do? Let me reel some things off real quick, because you said you wanted specifics. Number one, under my program we would provide matching funds to States to teach everybody with a job to read in the next 5 years and give everybody with a job a chance to get a high school diploma, in big places, on the job. Number two, we would provide 2-year apprenticeship programs to high school graduates who don't go to college, in community colleges or on the job. Number three, we'd open the doors to college education to high school graduates without regard to income. They could borrow the money and pay it back as a percentage of their income over the couple of years of service to our Nation here home. Number four, we would fully fund the Head Start program to get little kids off to a good start. Five, I would have an aggressive program of school reform. More choices in the -- I favor public schools or these new charter schools. We can talk about that if you want. I don't think we should spend tax money on private schools, but I favor public school choice. I favor radical decentralization in giving more power to better trained principals and teachers with parent councils to control their schools. Those things would revolutionize American education and take us to the top economically. Ms. Simpson. Thank you, Governor Clinton. What the question is -- what is it going to cost? Q. What is it going to cost? Ms. Simpson. What is it going to cost? Governor Clinton. In 6 years -- I budget all this in my budget. In 6 years, the college program would cost $8 billion over and above what -- the present student loan program costs 4. You pay $3 billion for busted loans, because we don't have an automatic recovery system, and a billion dollars in bank fees. So the net cost will be $8 billion 6 years from now, in a trillion-plus budget: not very much. The other stuff, all the other stuff I mentioned costs much less than that. The Head Start program, full funding, would cost about $5 billion more. It's all covered in my budget from the plans that I've laid out, from raising taxes on families with incomes above $200,000, and asking foreign corporations to pay the same tax that American corporations do on the same income; from $140 billion in budget cuts, including what I think are very prudent cuts in the defense budget. It's all covered in the plan. Ms. Simpson. Mr. Perot, you on education, please. Mr. Perot. Yes. I've got scars to show from being around education reform. The first words you need to say in every city and State and just draw a line in the sand -- public schools exist for the benefit of the children -- you're going to see a lot of people fall over it, because any time you're spending $199 billion a year, somebody's getting it, and the children get lost in the process. So that's step one. Keep in mind in 1960 when our schools were the envy of the world, we were spending $16 billion on them. Now we spend more than any other nation in the world, $199 billion a year, and rank at the bottom of the industrialized world in terms of educational achievement. One more time, you've bought a front-row box seat and got a third-rate performance. This is a Government that's not serving you. By and large, it should be local. The more local, the better. Interesting phenomenon, small towns have good schools, big cities have terrible schools. The best people in a small town will serve on the school board. You get into big cities, it's political patronage, stepping stones. You get the job, give your relatives the janitor's job at $57,000 a year, more than the teachers make. And with luck, they clean the cafeteria once a week. [Laughter] Now, you're paying for that. Those schools belong to you, and we put up with that. As long as you put up with that, that's what you're going to get. These folks are just dividing up 199 billion bucks, and the children get lost. If I could wish for one thing for great public schools, it would be a strong family unit in every home. Nothing will ever replace that. You say, "Well, gee, what are you going to do about that?" Well, the White House is a bully pulpit, and I think we ought to be pounding on the table every day. There's nothing -- the most efficient unit of Government we'll ever know is a strong, loving family unit. Next thing. You need small schools, not big schools. A little school, everybody's somebody. Individualism is very important. These big factories, everybody told me they were cost-effective. I did a study on it. They're cost-ineffective. Five thousand students: why is a high school that big? One reason. Sooner or later, you get 11 more boys that can run like the devil, that weigh 250 pounds, and they might win district. Now, that has nothing to do with learning. Secondly, across Texas, typically half the school day was nonacademic pursuits. In one place, it was 35 percent. In Texas, you could have unlimited absences to go to livestock shows. Found a boy -- excuse me, but this gives the flavor -- a boy in Houston kept a chicken in the bathtub in downtown Houston. Missed 65 days going to livestock shows. Finally had to come back to school, the chicken lost his feathers. That's the only way we got him back. [Laughter] Now, that's your tax money being wasted. Now, neighborhood schools. It is terrible to bus tiny little children across town. It is particularly terrible to take poor, tiny little children and wait until the first grade and bus them across town to Mars where the children know their numbers, know their letters, have had every advantage; the end of the first day, that little child wants out. I close on this: You've got to have world-class teachers, world-class books. If you ever got close to how textbooks were selected, you wouldn't want to go back the second day. I don't have time to tell you the stories. [Laughter] Ms. Simpson. No, you don't. [Laughter] Mr. Perot. Finally. If we don't fix this, you're right, we can't have the industries of tomorrow unless we have the best educated work force. And here, for the disadvantaged children, you've got to have early childhood development, the cheapest money you'll ever spend. The first contact should be with the mother when she's pregnant. That little child needs to be loved and hugged and nurtured and made to feel special, like you children were. They learn to think well or poorly of themselves in the first 18 months. Ms. Simpson. Thank you, Mr. Perot. Mr. Perot. Within the first few years, they either learn how to learn or don't learn how to learn. If they don't, they wind up in prison, and it costs more to keep them in prison than it does to send them to Harvard. I rest my case. Ms. Simpson. Thank you. President Bush, you wanted to add something. President Bush. I just had a word of clarification because of something Governor Clinton said. My school choice program, "GI bill" for kids, does not take public money and give it to private schools. It does what the GI bill itself did when I came out of World War II. It takes public money and gives it to families or individuals to choose the school they want. Where it's been done, those schools, like in Rochester, those schools that weren't chosen find that they then compete and do better. So I think it's worth a shot. We've got a pilot program. It ought to be tried: school choice, public, private, or religious, not to the schools, but to -- 46 percent of the teachers in Chicago, public schoolteachers, send their kids to private school. Now, I think we ought to try to help families and see if it will do what I think, make all schools better. Governor Clinton. I just want to mention if I could -- -- Ms. Simpson. Very briefly. Governor Clinton. Very briefly. Involving the parents in the preschool education of their kids, even if they're poor and uneducated, can make a huge difference. We have a big program in my State that teaches mothers or fathers to teach their kids to get ready for school. It's the most successful thing we've ever done. Just a fact clarification real quickly. We do not spend a higher percentage of our income on public education than every other country. There are nine countries that spend more than we do on public education. We spend more on education because we spend so much more on colleges. But if you look at public education alone, and you take into account that we have more racial diversity and more poverty, it makes a big difference. There are great public schools where there are public school choice, accountability, and brilliant principals. I'll just mention one, the Beasley Academic Center in Chicago. I commend it to anybody. It's as good as any private school in the country. Ms. Simpson. We have very little time left, and it occurs to me that we have talked all this time and there has not been one question about some of the racial tensions and ethnic tensions in America. Is there anyone in this audience that would like to pose a question to the candidates on this? Yes? Women or Minority Presidential Candidates Q. What I'd like to know, and this is to any of the three of you, is aside from the recent accomplishments of your party, aside from those accomplishments in racial representation and without citing any of your current appointments or successful elections, when do you estimate your party will both nominate and elect an Afro-American and female ticket to the Presidency of the United States? Ms. Simpson. Governor Clinton, why don't you answer that first. Governor Clinton. Well, I don't have any idea, but I hope it will happen sometime in my lifetime. Q. I do, too. Governor Clinton. I believe that this country is electing more and more African-Americans and Latinos and Asian-Americans who are representing districts that are themselves not necessarily of a majority of their race. The American people are beginning to vote across racial lines, and I hope it will happen more and more. More and more women are being elected. Look at all these women Senate candidates we have here. You know, according to my mother and my wife and my daughter, this world would be a lot better place if women were running it most of the time. I do think there are special experiences and judgments and backgrounds and understandings that women bring to this process, by the way. This lady said here, how have you been affected by the economy? I mean, women know what it's like to be paid an unequal amount for equal work; they know what's it like not to have flexible working hours; they know what it's like not to have family leave or child care. So I think it would be a good thing for America if it happened, and I think it will happen in my lifetime. Ms. Simpson. Okay. I'm sorry we have just a little bit of time left. Let's try to get responses from each of them. President Bush or Mr. Perot? President Bush. I think if Barbara Bush were running this year she'd be elected. [Laughter] But it's too late. You don't want us to mention appointees but when you see the quality of people in our administration, see how Colin Powell performed -- I say administration, he's in the military. Q. I said when's your guess? President Bush. You weren't impressed with the fact that he performed -- -- Q. Excuse me, I'm extremely impressed with that. President Bush. Yes, but wouldn't that suggest to the American people then here's a quality person, if he decided that he could automatically -- -- Q. Sure. I just wanted to know -- -- President Bush. -- -- get the nomination of either party? Huh? Q. I'm totally impressed with that. I just wanted to know is when is your guess of when. President Bush. Oh, I see. You mean time? Q. Yeah. President Bush. I don't know. Starting after 4 years. [Laughter] No, I think you'll see -- -- Ms. Simpson. Mr. Perot? President Bush. I think you'll see more minority candidates and women candidates coming forward. Ms. Simpson. Thank you. President Bush. This is supposed to be the year of the women in the Senate. Let's see how they do. I hope a lot of them lose. Ms. Simpson. Mr. Perot, I don't want to cut you up any more, but we only have a minute left. Mr. Perot. I have a fearless forecast. Unless he just won't do it, Colin Powell will be on somebody's ticket 4 years from now. Right? Right? You wanted -- that's it. Four years. Ms. Simpson. How about a woman? Mr. Perot. Now, if he won't be, General Waller would be a -- you say, why do you keep picking military people? These are people that I just happened to know and have a high regard for. I'm sure there are hundreds of others. President Bush. How about Dr. Lou Sullivan? Mr. Perot. Absolutely. President Bush. Yeah, good man. Mr. Perot. Absolutely. Ms. Simpson. What about a woman? Mr. Perot. Oh, oh. President Bush. My candidate's right back there. Mr. Perot. I can think of many. Ms. Simpson. Many? Mr. Perot. Absolutely. Ms. Simpson. When? Mr. Perot. How about Sandra Day O'Connor as an example? Dr. Bernadine Healy. Ms. Simpson. Good. Mr. Perot. National Institutes of Health. All right, I'll yield the floor. Name some more. President Bush. Good Republicans. [Laughter] Ms. Simpson. Thank you. I want to apologize to our audience because there were 209 people here, and there were 209 questions. We only got to a fraction of them, and I'm sorry to those of you that didn't get to ask your questions, but we must move to the conclusion of the program. It is time now for the 2-minute closing statements. By prior agreement, President Bush will go first. Closing Statements President Bush. May I ask for an exception because I think we owe Carole Simpson a -- anybody who can stand in between these three characters here and get the job done -- we owe her a round of applause. [Applause] Just don't take it out of my time. Ms. Simpson. That's right. President Bush. I feel strongly about it, but I don't want it to come out of my time. Ms. Simpson. That's right. [Laughter] President Bush. No, but let me just say to the American people: In 2 1/2 weeks, we're going to choose who should sit in this Oval Office, who to lead the economic recovery, who to be the leader of the free world, who to get the deficit down. Three ways to do that: one is to raise taxes; one is to reduce spending, controlling that mandatory spending; another one is to invest and save and to stimulate growth. I do not want to raise taxes. I differ with the two here on that. I'm just not going to do that. I do believe that we need to control mandatory spending. I think we need to invest and save more. I believe that we need to educate better and retrain better. I believe that we need to export more, so I'll keep working for export agreements where we can sell more abroad. And I believe that we must strengthen the family. We've got to strengthen the family. Now, let me pose this question to America: If in the next 5 minutes a television announcer came on and said, there is a major international crisis, there is a major threat to the world, or in this country a major threat, my question is, if you were appointed to name one of the three of us, who would you choose? Who has the perseverance, the character, the integrity, the maturity to get the job done? I hope I'm that person. Thank you very, very much. Ms. Simpson. Thank you, Mr. President. And now a closing statement from Mr. Perot. Mr. Perot. If the American people want to do it and not talk about it, then I'm one person they ought to consider. If they just want to keep slow dancing and talk about it and not do it, I'm not your man. I am results oriented. I am action oriented. I've built my businesses getting things done in 3 months that my competitors took 18 months to do. Everybody says, you can't do that with Congress. Sure you can do that with Congress. Congress, they're all good people. They're all patriots. But you've got to link arms and work with them. Sure, you'll have arguments. Sure, you'll have fights. We have them all day, every day. But we get the job done. Now, I have to come back in my close to one thing, because I am passionate about education. I was talking about early childhood education for disadvantaged little children. Let me tell you one specific pilot program where children who don't have a chance go to this program when they're 3. Now, we're going back to when the mother is pregnant, and they'll start right after they're born, starting when they're 3 and going to this school until they're 9, and then going into the public school in the fourth grade -- 90 percent are on the honor roll. Now, that will change America. Those children will all go to college. They will live the American dream. I beg the American people, anytime they think about reforming education, to take this piece of society that doesn't have a chance, and take these little pieces of clay that can be shaped and molded and give them the same love and nurture and affection and support you give your children. Teach them that they're unique and that they're precious and there's only one person in the world like them, and you will see this Nation bloom. We will have so many people who are qualified for the top job that it will be terrific. Now, finally, if you can't pay the bills, you're dead in the water. We have got to put our Nation back to work. Now, if you don't want to really do that, I'm not your man. I'd go crazy sitting up there slow dancing that one. In other words, unless we're going to do it, then pick somebody who likes to talk about it. Now, just remember, when you think about me, I didn't create this mess. I've been paying taxes just like you. And Lord knows, I've paid my share, over $1 billion in taxes. And for a guy that started out with everything he owned in the trunk of his car, that ain't bad. Ms. Simpson. I'm sorry, Mr. Perot. Once again -- -- Mr. Perot. But it's in your hands. I wish you well. I'll see you tomorrow night on NBC, 10:30 p.m., 11 p.m., eastern. [Laughter] Ms. Simpson. And finally, last but not least, Governor Clinton. Governor Clinton. Thank you, Carole, and thank you, ladies and gentleman. Since I suggested this format, I hope it's been good for all of you. I've really tried to be faithful to your request that we answer the questions specifically and pointedly. I thought I owed that to you. And I respect you for being here, and for the impact you've had on making this a more positive experience. These problems are not easy. They're not going to be solved overnight. But I want you to think about just two or three things. First of all, the people of my State have let me be their Governor for 12 years because I made commitments to two things, more jobs and better schools. Our schools are now better. Our children get off to a better start, from preschool programs and smaller classes in the early grades. We have one of the most aggressive adult education programs in the country. We talked about that. This year, my State ranks first in the country in job growth, fourth in manufacturing job growth, fourth in income growth, fourth in the decline of poverty. I'm proud of that. It happened because I could work with people, Republicans and Democrats. That's why we've had 24 retired generals and admirals, hundreds of business people, many of them Republican, support this campaign. You have to decide whether you want to change or not. We do not need 4 more years of an economic theory that doesn't work. We've had 12 years of trickle-down economics. It's time to put the American people first, to invest and grow this economy. I'm the only person here who's ever balanced a government budget, and I've presented 12 of them and cut spending repeatedly. But you cannot just get there by balancing the budget. We've got to grow the economy by putting people first, real people like you. I got into this race because I did not want my child to grow up to be part of the first generation of Americans to do worse than their parents. We're better than that. We can do better than that. I want to make America as great as it can be, and I ask for your help in doing it. Thank you very much. Ms. Simpson. Thank you, Governor Clinton. Ladies and gentlemen, this concludes the debate, sponsored by the Bipartisan Commission on Presidential Debates. I'd like to thank our audience of 209 uncommitted voters who may leave this evening maybe being committed. And hopefully, they'll go to the polls like everyone else on November 3d and vote. We invite you to join us on the third and final Presidential debate next Monday, October 19th, from the campus of Michigan State University in East Lansing, Michigan. I'm Carole Simpson. Good night.
