# Vice Presidential Debate in Houston

**Date:** October 15, 1976
**Source:** https://www.presidency.ucsb.edu/documents/vice-presidential-debate-houston-texas

---

HOGE: Good evening, I'm James Hoge, editor of the Chicago Sun Times, and moderator of this third of the historic debates of the 1976 campaign. Tonight we have the vice-presidential candidates: for the Democrats, Senator Walter Mondale of Minnesota; for the Republicans, Senator Robert Dole of Kansas. Thank you, Senator Mondale, and thank you, Senator Dole, for being with us this evening. This debate is taking place before an audience in the Alley Theater in Houston, Texas. It is also being broadcast by radio and television to an audience estimated at some eighty-five million persons in this nation and overseas. As far as we can tell this is the first formal debate ever held between vice-presidential candidates. Their views are important not only because they seek the second highest office in the land, but because as potential vice presidents, they must be judged on their capacities to serve as president of the United States. For example, of the last five presidents, three have become president due to death, or resignation, by a chief executive. We will begin this debate tonight with opening statements of up to two minutes by each candidate. By the toss of a coin it was determined that Senator Dole would go first. Senator Dole, your opening statement. DOLE: Thank you very much. First, I wish to thank the League of Women Voters, and this is a great privilege and honor for me. I also wanna thank my many friends in Russell, Kansas, for that big long telegram I received today. I think tonight may be sort of a fun evening. It's a very important evening; it's a very historic evening. But I've known ah my counterpart for some time, and we've been friends and we're - we'll be friends when this debate is over and we'll be friends when the election is over and he'll still be in the Senate. [audience laughter] And I think first of all I should make it very clear that I'm most proud to be on the ticket with President Ford. I've known President Ford for sixteen years - sixteen years. It's a long time. He's known me for that long. I know him to be a man of compassion and competence. He has that confidence and he projects that leadership that America needs and that you need right now. Now, I don't know much about uh - Governor Carter. I've tried to find out. I know he's very ambitious. I know he wants to be president. He's been running for three years. But I know he said uh - at least one thing - that he does agree with my opponent, my friend, uh - Walter Mondale, probably the most liberal senator in the United States Senate. And that's really what this debate's all about. If by some uh - tragic circumstance one of us should become president of the United States, where do we stand on the issues? I would just say in a very uh - summary way that I have a great deal of faith in you, the American people. I'm concerned about farmers and housewives and young people and professional people, working men and women. I think we can find our solutions working together. My opponent has a record of voting for ever- every inflationary spending program except in defense, where he votes for every cut. And we'll explore that as this debate goes on. HOGE: Thank you, Senator Dole. Senator Mondale, your opening statement. MONDALE: I believe that most Americans would agree on the problems that this country faces and that the next - and which the next administration must solve. They include the need once again for an economy that works. The economy today is in very, very bad shape - the highest unemployment since the Great Depression, 50 percent higher than when Mr. Ford took office; raging inflation, with the latest uh - wholesale price indexes once again raising the specter of double-digit inflation. The purchasing power of the average American has slipped so much that it is now the equivalent of the purchasing power in 1965. It is not getting better. It is getting worse. All the leading indicators now point downward, and stock investors are now losing confidence and over $50 billion of value has disappeared from the stock market in less than a month. We need a government that works, and we need a government that cares, and once again we have to get back to work on education, on health, on housing, on the environment, on energy; and we need a foreign policy that once again reflects the values and the beliefs of the American people. This will take leadership, and we need leadership, too. The Republican administration, the Republican party has had eight years to solve these problems. All of them have gotten worse. The Republican ticket does not offer new plans for their solution but is engaged in a frantic effort to defend the past. This nation desperately needs new leadership. The Carter-Mondale ticket would offer a new generation of leadership dedicated to solving the problems which I have listed, and that is the basis of our appeal. HOGE: Thank you gentlemen. The subject matter of tonight's debate, like that of the first two presidential debates, covers domestic and economic policies, and foreign and defense issues. The questioners tonight are Hal Bruno, chief political correspondent of Newsweek magazine; Marilyn Berger, White House correspondent of NBC News; and Walter Mears, special correspondent for the Associated Press. Questions will be alternated between the two candidates. After a question is asked, the candidate will have up to two and a half minutes to respond. His opponent will then have two and a half minutes to reply to that. The first candidate then may reply to those remarks for up to one minute. I should mention at this point that I will intervene if a candidate is not addressing the question which has been posed to him. At the conclusion of the questioning, each candidate will be allowed up to three minutes for a closing remark. Senator Mondale and Senator Dole do not have prepared notes or comments with them this evening. However, they may make notes and refer to them during the debate. We now begin with questions on domestic and economic policies. The first question goes to Senator Dole, as was determined by the coin toss. Mr. Bruno, you have the first question. Hal Bruno: Senator Dole, presidential candidates always promise that their vice president will play an important role. But it seldom turns out that way and they usually wind up as standby equipment, which is the way Vice President Rockefeller once described the job. What's your view of this office that you're seeking? Has President Ford told you what your role might be, and what would you like it to be? DOLE: Well, I've said, as I've traveled around the country, in - mostly in jest, that - why you are running for vice president, I said, well, it's indoor work and no heavy lifting. [audience laughter] But I've also thought very seriously about it. President Ford has discussed it with me. It's a great opportunity. It's a great responsibility. I can't stand here tonight uh - in Houston, Texas, and say that come uh - January when I'll be sworn in as vice president that I'm gonna do anything in the first hundred days, or even the second hundred days. But I have discussed it with President Ford. He's indicated two uh - responsibilities that he's going to designate. One will be having some role in increasing our agricultural exports, because we believe - we believe together that the future of American agriculture lies in its exports. Also, because of my long association with families who had uh - their sons or husbands as missing in action and prisoners of war - he indicated to me last week that I would have a role as his representative - try to get some accounting for the missing in action in Southeast Asia. But beyond that, of course, our constitutional duty is to preside over the Senate, and vote in case of a tie. We also serve on the National Security Council, Domestic Council, and whatever other assignments we may have from time to time. I think probably one important aspect that we ought to talk about - and that's our vision of America. I believe the people viewing tonight - people who watching us tonight - may well determine the role I play as vice president. I believe that we're going forward in America under the leadership of President Ford, and I believe there'll be more and more challenges, positive challenges, to those of us who hold high office, to serve the American people. And that's really what it's all about: whether we're vice president, on the city council, member of the legislature, or whatever. Our obligation is to the people. We must have faith in the American people - and I have that faith. But I think the opponents have more faith in bigger government, more controls and more interference with their everyday lives. HOGE: Senator Mondale, your response. MONDALE: The problems that our country faces are so great that a very strong role is required of the vice president and of all federal officials. I've discussed this matter - uh extensively with Governor Carter and as vice president I would have such a substantial role in both domestic and foreign policy. I would work with the president, for example, in this long overdue effort to basically restructure and reorganize the federal government. Today it's a mess. There's no one in charge. There's great waste, great duplication, and the time has come for a long overdue reorganization. That would be one of the first tasks that I would have working with the new president. There would be a whole range of duties that I would have working with the president and uh - on problems of economic growth, we got to get people back to work, attacking inflation and finally getting a policy to - to keep the dollar worth a dollar, and the other problems that we face here at home. One of the specific suggestions that uh - we are considering now is that I would head up the task force to deal with the federal aspects of crime in America. Today, the federal function in law enforcement is in disarray. The Drug Enforcement Ad- Administration is totally demoralized. The FBI is also under great difficulty. We need to have a coordinated, effective, and national attack on organized and hard crime, those crimes prohibited by federal law. We need to finally get a national effort that really makes sense, that stops the importation of those death-dealing imported illegal drugs. We need to have a new look at official lawlessness at the federal level, because we've seen too many instances where people in high public office - uh violate the law themselves. And one of the things that we're considering is establishing an interdepartmental agency under the chairmanship of the vice president to finally, at long last, put some strength behind a national effort to deal with these uh - terrible problems in American life. And may I close by saying that uh - one of the reasons that I believe I am gonna be the vice president, is one of the reasons that uh - my opponent mentioned, and that is the present president imposed an embargo on farm exports four times in three years, and they want a change. HOGE: Senator Dole, do you have a further comment? DOLE: Well, I would just say to my good friend, uh - I'm happy that you're going to be responsible uh - for reorganization. I hope you don't pattern it after Governor Carter's efforts in Georgia. They added more bureaucrats to the government in Georgia, the cost of government went up, his Human Resources uh - Committee or whatever it's called was called an organizational nightmare by Governor Busbee, his successor. I understand from Bobby Smith, who's supposed to be the ag expert in the Carter campaign, that you're going to do away with the Department of Agriculture. That's in essence what he said. You're gonna put it together with a lot of other things. And I know the farmers who may be viewing will be pleased to know that. They should also be pleased to know that uh - Senator Mondale - uh sponsors export licensing proposals in the Congress, which would make it necessary for farmers to get an export license before they could ship their goods overseas. And under his proposal - which is still pending, thank goodness it hasn't passed, we'd all be in difficulty - we wouldn't be able to ship anything out. HOGE: Miss Berger, your question to Senator Mondale. Marilyn Berger: Senator Mondale, the polls indicate that less than half of those eligible will vote in this coming election. And although you and Senator Dole have both touched on the very important issues that are before the country, many Americans feel that they're being shortchanged by a campaign that has descended into a name-calling contest. For example, Governor Carter has said that President Ford has been brainwashed; President Ford says that Carter is slandering America. If the tone of the campaign worries the electorate, does it worry you, Senator Mondale? MONDALE: There are many things that I think have contributed to this phenomenon that I find very, very discouraging. And that is, the great numbers of Americans do not plan to participate in the electoral process which is so crucial to uh - a sound and effective nation. We can't solve our problems unless everyone helps. There've been so many things that have dispirited the American people, that have fed frustration and despair. We've gone through the worst war in American history, that divided this country perhaps just as much it's ever been divided. We then went through the worst political scandal in American history, with the highest officers in government being found guilty or at least charged with guilt in very serious crimes. We then saw evidence that even our own intelligence agencies and law enforcement agencies, charged to enforce the law, had themselves violated the law. And then we've seen a government that is unable to deal with the real problems that the American people face. People need jobs. It's a tragedy every time an able-bodied American is denied the opportunity to make - to work. There are now eight million Americans who can't find work. It's a tragedy when Americans work and find the value of their dollar disappearing. It's a tragedy when children can't get educated, when health care wipes them out, when senior citizens find that the attention and the credit they're entitled to - through Social Security and Medicaid - is being taken from them. These things have all contributed to a growing feeling in America that government does not respond to solve people's problems, that government lives by one standard and expects Americans to live by another, and because of that we have this large feeling in America, reflected in those surveys that were suggested in your question, that has contributed to this feeling that involvement in politics does not count. And if there's one hope that Governor Carter and I have, if there's one objective that's central above all, is that we can restore the faith in the American people by simply telling the truth, obeying the law, seeing problems as they really are, attacking the real questions, the real problems that affect Americans, and then I think we will see the restoration of public trust. HOGE: Senator Dole, your response. DOLE: Well I think it's a very good question. It goes back to the party institutions. Uh - maybe it's uh - an indictment uh - in that sense of uh - those of us who seek office. It goes back to my basic premise - and that's faith in the people. It just seems to me that some of those who lust for power are not really concerned about the people. They say they're concerned, and they talk about the people. They never give us their positions. And so I think many Americans are sort of turned off, and they were turned off by the war in Southeast Asia. They were turned off by Watergate - I'll say that word first - they were turned off by Watergate. But we're looking ahead. They were probably turned off by what they saw in U.S. House of Representatives. They've been turned off by a lot of things they've seen in politics. But I think they've been turned off too by promises and promises, and bigger and bigger spending programs, and more and more inflation. They're looking for leadership. They yearn for leadership and they found that leadership in President Ford. And Governor Carter talks about tax reform, talks about taxing the rich. He talks about nearly everyone. He said former president Johnson lied and cheated and distorted the facts. I think that turns a lot of people off. He was quick to apologize to Mrs. Johnson. He insulted Governor Wallace, but he was quick to apologize to Governor Wallace. Someone in the family insulted Billy Graham but they were quick to apologize to Billy Graham. I think it's time we stopped apologizing and talked - it's time we started talking to you, the American people. We need your help. We wanna restore faith in this system and I think we can. Let's not promise what we can't deliver. Let's be honest with you, the voter, with you the taxpayer. It's fine to talk about education, more this, more that, and more that. But there're eighty-eight million people working in America that are gonna pay the taxes - the highest number ever working in America - some 40 percent of the population, the highest in history, working now in America. And we're concerned about the 7.8 percent unemployed. We'll be concerned until that's reduced to 4 percent or 3 percent or wherever. But we can't lose sight of the number one enemy, and that number one enemy is inflation. And I think the American people are coming around. They're beginning to understand that President Ford says what he means and does what he says. HOGE: Senator Mondale. MONDALE: Well, who really has faith in the people? A candidate like Governor Carter, who campaigns far the people, is out every day meeting and talking with the people, holds news conferences and answers questions of the - of the news media as he has every day for twenty-four months, or a president who's in the White House, not through election but through appointment, who has held only two preannounce news conferences since February? Who trusts the people more - Governor Carter and Senator Mondale, who have disclosed our income-tax returns so the American people can look at our private financial affairs and determine how we conducted our affairs, or President Ford and Senator Dole, who refuse to let the American people see their tax returns? Who trusts the people? A candidate like Governor Carter, who tells the truth, or a president like Mr. Ford, who last week told the American people that he had fought the Arab boycott and sought legislation and sanctions against it when the whole record shows he's proc- proceeded in just the opposite direction? HOGE: Thank you. Mr. Mears, your question for Senator Dole. Walter Mears: Senator Dole, prior to your current campaign you sometimes expressed concern about a negative image of the Republican party. You're quoted as having said last spring that, "We're in the unfortunate position of having a president vetoing bills and getting on the wrong side of people issues. He's vetoed the education bill, the jobs bill, you name it." Are you still concerned about the risk that Republicans will be perceived as opposed to what you call vet- uh - "people issues" and do you think that President Ford has exercised the veto too frequently? DOLE: Well, I might say at the outset I haven't always agreed with President Ford and I've voted to override on occasion - but not every time, as my counterpart has. I think President Ford uh - and hindsight's very good, particularly when you're on the ticket. And my hindsight is, the president's been very courageous. And there is a difference. You know, we look at our states and we look at the bills and we decide to sustain or override. The president - and particularly this president, who has courage - President Ford looks at the nation; he looks at all the American people, and he makes that judgment: Should I sign, can I sign, or must I veto this bill? And so he's vetoed sixty-two bills - I think the sixty-second happened today. And I say that's uh - a courageous act repeated sixty-two times, because much of that legislation sounded good, some of it was good, some of it we just couldn't have unless we're gonna fuel the fires of inflation. I don't suggest that every veto uh - I must agree with. But I also suggest that I'm a Republican. I'm proud to be a Republican. We're sometimes perceived, as I've said before, as the anti-people party because we're not for more spending. We're not for more government; we're for a strong defense. We're for peace in the world. Those aren't very attractive to some people. They wanna know how much we're gonna spend for this, and how much we're gonna spend for that. Well Senator Mondale could tell 'em that because he votes for every piece of spending legislation that comes down the pike unless it's in the area of defense, and then he votes for every budget cut. I think he's voted to cut the budget - in addition to what had already been cut in the Congress - some $16 billion: against the B-1 bomber, which means a lot of jobs, against the C5-A, against the Trident submarine. And the list goes on and on and on and on. I believe the American people want us to be responsible. We've got to make the tough decisions. It's one thing to be in the office of the president or a senator of the United States and vote for every spending program, never concern ourselves with inflation or the total cost. But I would only close by saying that I hope the viewers remember we had a Democratic Congress, we've had one for twenty-two straight years. And so if anyone stands up to debate this Republican senator and tries to dump all the responsibility on a Republican president by the name of Gerald Ford, I'd just ask that question: Where have you been for twenty-two years? HOGE: Senator Mondale, your response. MONDALE: Perhaps the most pronounced difference that ref- separates the Democratic and the Republican candidates is reflected in the question that was just asked. There is practically no difference between the two parties in terms of how much they would spend. The Senate Budget Committee estimated that the Republican platform cost $50 billion, the Democratic platform cost $40 billion. The difference between the Democratic Congressional budget which I supported and the - and the president's budget was only $3 billion in deficit, and if you removed the gimmickry in the president's budget it was exactly the same. The difference is in how we spend those resources. And I am unashamed of my support for programs to put people back to work. I am unashamed of my support for programs to build housing so the families of this country can live in decent housing. I'm unashamed of supporting education programs that give our kids a decent education. I'm unashamed of supporting health programs that give people who get ill a chance to have decent health without being totally wiped out. And I'm unashamed of supporting programs such as Medicare. My opponent voted against Medicare. Can you imagine voting against program, as did the president, that would provide help for senior citizens after they're past their earning years so that they could have decent health care without being wiped out? Now, where do the Republicans want to spend their money? Well, I'll tell you. First of all, this year they're spending $55 billion in the cost of the recession that they created. We didn't give 'em this recession. We had full employment when they took over. Mr. Ford, in just two years, has increased unemployment by two and a half million Americans. They haven't solved inflation and they - and instead of trying to deal with the problem of unemployment, instead of that they proposed a $20 billion tax cut for wealthy corporations, despite the fact that just yesterday a newspaper carried a story that ten major corporations made massive amounts of money and didn't owe a dime in federal taxes. Ford Motor Corporation earned $800 million and didn't owe a dime to the federal government; in fact, got a hundred and eighty million dollars back. So between those tax cuts and between the massive costs of unemployment, they spend much more than we would. But what do they get for it? We wanna see money spent to help problems that people really face in their lives. HOGE: Senator Dole. DOLE: Well, we're all for those programs. Uh - but it's uh - we just don't believe in excesses. I think in retrospect uh - the elder-care program that I voted for instead of Medicare is probably a better program because Medicare, everybody gets the benefits, whether you're in need or not, once you reach the age of sixty-five. Now they're having a lot of problems in Medicare. I'm glad you mentioned Ford Motor Company not paying taxes. Again the Democrats control the committee. I'm on the committee. Senator Mondale's on the Finance Committee. Henry Ford happens to be supporting Governor Carter, maybe that's why. Governor Carter did have a little meeting with him at the Twenty-One Club, had some small businessmen there, said don't worry about taxes, I won't be doing anything for at least a year. That's after he said the tax system was a disgrace. We have peace in this country today. That's important to me - important to mothers who may be listening. They talk about their full employment when we took over - that's because they had a full-grown war in Southeast Asia. That's not the way we try to end unemployment in the Republican party. HOGE: Mr. Bruno, your question to Senator Mondale. Hal Bruno: Uh - Senator Mondale, uh - everyone seems to agree that solving the economic problems of inflation and unemployment has to be given top priority. Uh - you and Governor Carter have a whole shopping list of things that you wanna do. After - after the economic problem, what do you see as the next most urgent and crucial domestic problems? In what order of importance would you go to work on such problems as the decay and bankruptcy of the cities, uh - tax reform, health insurance, uh - help for the poor and the elderly - in short, after the economy, what would be the very specific priorities of a Carter administration? MONDALE: You have to work on several problems at once, because they all demand the attention of the American people. One of the key problems would be to try to finally get a health insurance program to deal with the health crisis in America. In just the past two years, health costs in America have risen in the cities by over 25 percent. We have to do something about that. There's no hope under the ad- Republican administration. Mr. Ford said he vet- he would veto any legislation if we sent it. We have to do something about housing. We're in a housing depression. Today, nearly 20 percent of the building tradesmen in America are unemployed. We need to put them back to work - to build that Americans need. We need to continue to - to build support, as the budget permits, for education. We need to - to get back to work on the problems of senior citizens. Now, all of this has to be done prudently, within a budget, and within the constraints that our resources permit; but once we put people back to work, once we end this recession - which we will do - even president's own estimates indicates that we will have somewhere between sixty and seventy billion dollars of increased revenues on existing tax rates just from economic growth which we can use to work on these programs. Then we'll have tax reform, and I wanna deal with this problem just a moment. Mr. Dole has probably the worst record in favor of loopholes of any senator in the United States Senate. Mr. Ford has one of the worst records in favor of tax loopholes in the history of the House of Representatives. I have one of the best records of tax reform in the United States Senate, and it - I find it very peculiar to find two people who spent their congressional careers trying to block tax reform that permits very wealthy Americans to avoid most of their taxes to suddenly complain when the Congress hadn't passed the kind of legislation that we're talking about. What we're basically talking about is presidential leadership. We need leadership in the presidency to help support those of us in the Congress that have been pushing for tax reform and then we will have it. It is now possible for people of great wealth, by using complete tax fictions, to avoid all or most their taxes. But most Americans listening to me tonight could hire the best tax lawyer in America and you couldn't save a dime. There are no loopholes for you. HOGE: Senator Dole, your response. DOLE: I think Senator Mondale is a little nervous, but uh - time I think of loophole, I think of Governor Carter. I don't know why it comes to me, but uh - uh - I remember his '75 tax return - you've probably seen it, since it's public. His tax liability was $58 thousand. Not many Americans - I don't imagine many of you in the viewing audience - uh had to worry about a $58 thousand tax bill. I didn't. But Governor Carter did until he took off $41 thousand. That's called the investment tax credit - he bought some peanut machinery - gonna use it next year. So he took $41 thousand off his tax and sent the government a check for $17 thousand. So how much did he pay on his income? Well, he paid about twelve point eight percent. This that same man, that same Governor Carter who runs around the country talking about tax reform, loopholes, and the rich. I don't know who uh - rates uh - Senator Mondale on the Finance Committee. I don't know how they rated him on the Honeywell amendment he offered and the IDS amendment he offered. They never passed, they never got out of the Senate. They're both special interest amendments. That's all right, because those were his amendments. I don't know where Governor Carter's corporate returns are and partnership returns - I haven't seen those published anywhere. But I know about his tax reform. I wanna get back to the question, if that's all right. We're talking about the economy. What are we going to do after the economy's taken care of? Well, I don't know, it's occurred to me, and I'm certain it hasn't occurred to my counterpart - we might - it's not illegal, to take some of that surplus and apply it to the national debt. We've never done it, but we wouldn't be put in jail if Congress voted to try to retire some of that debt, to take some of the pressure off the American working man, and the American working woman. And I get a little tired of Governor Carter's anti-business attitude. I know they get great support, monetary support, from George Meany. In fact I've been suggesting that George Meany was probably Senator Mondale's makeup man - he may or may not have been, they did a good job. (laughter from audience). But I think it's time the American people understand that this is a very serious election; and we got a tough choice to make. Governor Carter talks about raising everyone's taxes above the median income. He didn't know what the median income was, of course. It's $14 thousand per American family, that's what it is. So I say, take a look and you'll vote for Ford. HOGE: Senator Mondale. MONDALE: The question was, what would we do to deal with the human problems in America? The first thing we would do is to put people back to work. The most atrocious result of the Republican policy is massive unemployment. It costs us $50 billion this year. Secondly, we will fight inflation. Today, inflation is three times worse than it was under the Democrats. And the latest indexes indicate that it's back on its way up. No effort to fight this at all. We will have tax reform. There's no question about our commitment to tax reform. My record proves it. Governor Carter's uh - positions prove that. We are fully committed to tax reform, and when the Republicans are raising money around the country, they say give us same money to defeat Governor Carter because if he gets elected there'll be a tax reform. And they are right when they say that, because we'll have tax reform and bring relief to the average income earner in this country. They know what Governor Carter is talking about, He's talking about the loopholes that favor Americans, usually earning above $50 thousand a year. HOGE: Thank you, Senator Mondale. We now turn to questions on foreign and defense issues. Miss Berger, you have the first question in this subject area and it is for Senator Dole. Marilyn Berger: Senator Dole, President Ford said in an interview this week that if he's elected he would like to see Henry Kissinger stay on as secretary of state. This hardly seems to square with the Republican platform which appears to repudiate much of Kissinger's foreign policy. Which way do you go, Senator Dole, with President Ford or with the Republican platform? DOLE: I go with both and stay with Henry. Uhh - you know if you look back over history, uh - President Washington had Thomas Jefferson for his secretary of state, uh - Harry Truman had Dean Acheson for his secretary of state, both very strong men, both very active men, both very powerful men. Henry Kissinger is a powerful man. And I haven't always agreed with Henry - Henry Kissinger but I - when I start disagreeing with Henry I start looking at what he's done for America - uh what he's done for the free world. I think about the breakthrough in China. I think about our increased responsive relations with - with the Soviet Union. I think about winding down the war that we inherited from another Democrat administration in Southeast Asia. I think most recently about his efforts in South Africa, where he's trying to protect the rights of the majority and the rights of the minority. You know we sort of thought that Henry might have had a role to play in grain embargoes, so we weren't totally happy at that time. We're not happy with embargoes; there'll not be any more embargoes except in extreme circumstances under a Ford-Dole Administration. So I agree with the president. Uh Secretary Kissinger's performed yeoman service. Anywhere you look you find Henry's tracks and they're tracks that are right for America. They're tracks that are right for the free world. And I wonder how many mothers and how many fathers and how many young men and young women who may be viewing tonight have really stopped to think about what this Republican administration has done. No one's being drafted; no one's going off to war; no one's being shot at; no one's being hospitalized; no one's being buried in America; not a single shot being fired in anger. And this is a Republican administration, this is a Republican policy. And this policy by and large has been spearheaded by one Henry Kissinger. And we have our differences. And I looked at the platform - I was on the Platform Committee. I don't see any contradiction on that platform. I've read the morality section. I think it sustains President Ford, and sustains Henry Kissinger. HOGE: Senator Mondale, your response. MONDALE: The real question of the foreign policy of the next administration is the responsibility of the president of the United States. He is the person elected to discharge the responsibility of foreign policy. He is the person that must conduct it and lead this nation's efforts. And that's where I think the key difference between the two parties lie. We want a change. We want new leadership. And above all we want a change of philosophy and direction. America's greatest strength is to be found in its values and its beliefs. And every time in our pursuit of foreign policy that we disregard those basic values, of freedom, of democracy, of national independence, we pursue a policy that is not credible, is not sustainable, either overseas or at home. Now let me say what I mean. For example, in Africa, for seven and a half years it was the policy of this administration to support the colonial control of black Africa and support white minority rule in majority black states. That was our explicit policy. And after that failed, and on the eve of this election, suddenly we've turned around and wanted to be believed as we pursued the policy that we should have pursued in the first place. Failure to follow our beliefs in the first instance is causing us great trouble in Africa. Look at Greece. During the whole period that the military junta controlled Greek government, this administration cozied up to that military dictatorship, befriended them, did everything they could to support them, but once Greek restored their own democracy, we've turned our back on them and have not assisted them in seeking a just and final settlement on the island of Cyprus. Take the issue of the Middle East. This government of ours is pursuing a policy of permitting the vicious Arab boycott to continue in this country. They have not sought any reform. They are pursuing an arms-peddling policy in this world which - in which we s- sell more arms by double of all the rest of the world put together. And last year alone, or this year, we're selling and contracting for seven and a half billion dollars of arms for Saudi Arabia and only a billion four for Israel. We've lost our way. We need a new sense of values, and we intend to restore them. HOGE: Senator Dole. DOLE: Well, I noticed in all that discussion he never once criticized Secretary Kissinger; I don't recall Senator Mondale ever criticizing Secretary Kissinger. As I think back uh - the Democrat policies that - and their secret agreements at Yalta and Potsdam and how this had the effect of enslaving Eastern Europe, and as I think of uh - the leadership of President Roosevelt - and I think about that every day because of a personal experience in World War II - I'm kind of thankful we have somebody who's concerned about peace. And whether Senator Mondale likes it or not, or whether Governor Carter likes it or not - and Governor Carter won't tell us who he's gonna to put in the cabinet. He probably doesn't know - I think it's kinda nice to be at peace in the world, to be respected in the world. We've had more respect than we've ever had. Prime Minister Rabin said our relations to - Israel are at a peak, the highest they've been. The same is true of France and West Germany. We have a balanced peace in the Mideast because of our leadership. HOGE: Mr. Mears, your question to Senator Mondale. Walter Mears: Senator Mondale, you and Governor Carter have made an issue of President Ford's statement that there is no Soviet domination of Eastern Europe - a statement the president now says was in error. I'd like to know whether there's any real difference between the two tickets an Eastern Europe or whether this is simply an effort by the Democrats to attract voters of Eastern European backgrounds. What would a Democratic administration do that the Republicans are not doing to foster freedom in Eastern Europe? And what would a new administration do on the question that the president declined to answer yesterday? If an Eastern European nation attempted to overthrow Soviet domination, should the United States help? MONDALE: Well, there're several things we would do. The first thing we would do was - is to make clear consistently what the facts are in Eastern Europe. The comment that the president made that Eastern Europe was independent and autonomous from Soviet control is probably one of the most outrageous statements made by a president in recent political history. It's caused great confusion in Europe. Communist newspapers in Poland are praising the president because the statement helped give credibility to Soviet control. I'm glad the president finally apologized for that remark, but it's surprising that it took six days and several attempts before we finally received that apology. What we think is needed in our policies with Eastern Europe is not to deal with Eastern Europe as a bloc as does this administration, but to deal with each country individually on its own status directly and not through the Soviet Union; to continue to identify with their aspirations for national independence, not because we are any- under any illusions about how easy it would be for them to become independent, but because it's important for us to identify as the nation which above all stands for freedom and independence with the aspirations of all people around the world for those same objectives. Secondly, we would push the - that part of the Helsinki accords known as Basket Three, which requires much opening up - much more opening up in people-to-people contacts and informational contacts. This administration signed the Helsinki accords but don- has done practically nothing to push those agreements which would open up communications between our nation and our peoples and the peoples of Eastern Europe and the Soviet Union. As a matter of fact it was just the other day, after several weeks delay, before they even finally appointed representatives of the administration to the commission looking into the enforcement of that provision. And finally, I think it's important that we honor people from Eastern Europe who stand as symbols of the human spirit's ability to stand up to police oppression. And I will never understand why this president of the United States refused to even receive and honor Mr. Solzhenitsyn, who perhaps above all people in the human race stands as a symbol for the ability and the strength of spirit against police oppression. HOGE: Senator Dole, your response. DOLE: Well, I'm glad you mentioned Solzhenitsyn. I checked today with his interpreter and I understand you've never met Mr. Solzhenitsyn, and neither has Mr. Carter. Now I've had the privilege of meeting uh - uh - Mr. Solzhenitsyn - maybe you've shook his hand somewhere - but uh - I want to move into the Eastern Europe sector. I'm reminded of how the Berlin Wall went up and who was in power when it went up. I think if we take a hard look at President Ford's record rather than all the rhetoric that followed uh - a mistake in the last debate about uh Poland, uh we'd know very clearly where President Ford not only stands but has stood for twenty some years I think one way to let the people in Eastern Europe know of our concern is by trade. As President Ford said, they've never really given up hope. Their government may be dominated, their leaders of that government may be dominated by Soviet Russia, but the hearts and the minds of the Polish people, or the Yugoslavs or Rumanians, or the Czechs, or whoever, have never been dominated. And they're good customers. You know we have a favorable balance of trade with Eastern Europe. I think last year they exported almost a half-billion dollars' worth of goods and material and we sent in about a billion dollars' worth. I just wish Governor Carter had a foreign policy. He doesn't have any - doesn't have any experience. He made some statement about Italy that bothers me because I was in World War II in Italy. My whole life changed because of my experience in Italy. I know the Italian people. I know they're God-fearing, freedom-loving people. I couldn't quite understand what Governor Carter meant in Playboy magazine. I couldn't understand frankly why he was in Playboy magazine. But he was, and we'll give him the bunny vote. But I couldn't understand what he meant when he said that we ought to extend the hand of friendship to Communists in Portugal and governments of France and Italy, because by doing that he simply invites difficulty from Communist leaders in those countries. So I say, oh we're strong, we're firm, President Ford understands, we're still at peace, we still have those same hopes and aspirations of the Eastern Europeans. And that's what it's all about: freedom, peace, no bloodshed. HOGE: Senator Mondale. MONDALE: Well, I regret that uh - Mr. Dole made that statement about Mr. Solzhenitsyn, because it's false. I've repeatedly spoken out in admiration of him. I served on the host committee receiving Mr. Solzhenitsyn in the United States Senate. He's a man that deserved to be honored and it was a shame to me that the president of the United States, because we were fearful of offending the Soviet Union, failed to accord that high honor to Mr. Solzhenitsyn. I'm also sorry that he's tried to misrepresent Governor Carter's position on the government that should control Portugal and Italy. The governor made it very clear that he hoped the noncommunist would continue to control those countries. The biggest thing that we're doing today that is undermining those forces of democracy is the disarray of our economy here at home. With our tremendous unemployment, with our tremendous inflation, and the dominance of our economy on the economies of Western Europe, of Japan and Canada, we have contributed to such conditions that it has strengthened the radical forces in those countries. And that's what we need to do to best help the democratic forces of those nations. HOGE: Thank you, Senators. We have reserved time this evening for questions on general subjects. The first question in this area is from Mr. Bruno, and it is for Senator Dole. Hal Bruno: Senator Dole, out there in the campaign trail uh - you been saying that a Carter-Mondale Administration would take its orders from George Meany and the AFL-CIO. Yet Mr. Meany was among those who influenced President Ford on the grain embargo, which you personally opposed. Now how do you know that Mr. Meany will influence Governor Carter any more than he already has influenced President Ford? And what, if anything, is wrong with labor or business or farmers making their views known in the White House as long as it's done openly and honestly? DOLE: I don't have any quarrel, uh - say, first of all, with anybody making their views known. I wish more businessmen would participate in active politics. In fact, I've held up labor as an example for others to follow because they are very active. I just don't believe that uh - labor leaders, whether it's Leonard Woodcock or George Meany or Jerry Wurf, whoever, ought to make a decision for thousands and millions of working men and women who are concerned about spending; they're concerned about taxes; they're concerned about the gun control that Mondale and Carter favor. They're concerned about abortion. They're concerned about a lot of things and their labor leader makes the decision, "We're gonna support the Carter-Mondale ticket." Now, George Meany did exercise some influence on the first embargo. I don't know how much because I wasn't privy to those meetings. He said he did it in the name of the consumer, when he really did it in the name of organized labor to increase the shipping subsidy. at the taxpayers' expense. Working with Mr. Gleason and the Longshoremen's Union they refused to load the ships, and it really put the president in a very difficult spot. As I think back of all the Democrat senators who now talking about embargoes, uh I can only recall one who spoke out at the time, that was Senator George McGovern. He had no allegiance and owed nothing to Mr. Meany because, as you know, Meany didn't support him in 1972. But, all of a sudden embargoes have cropped up as a great big issue. I know how much strength uh - labor leaders have. I know how much they're out pushing voter registration. I know how much they - control they have in the Democratic party. And that's their right, to have influence, but not to take aver the party. They have great influence on Senator Mondale, always have had. He's got a 95 percent labor rating or higher, the most liberal senor- senator in the United States Senate, and that's his right. He wants to be liberal and spend your money and tax and tax and spend and spend. That's his right. He gets - when he first - he was appointed as attorney general, then appointed to the Senate. Some of us had to run for what we have. When you have had things given to you, you like to give something else to someone else. You give away your tax money back to the taxpayers. And I just think that George Meany has every right to have influence, but not domination of a great party like the Democratic party. HOGE: Senator Mondale. MONDALE: Well, there are many things that could be said about that, I might begin first with voting records. Uh - there are many organizations that uh - prepare voting records. I'm pleased to have a very high rating in small business groups, among farmer groups, a much higher rating than my opponent from - the senator from Kansas; good ratings, high ratings in housing, in health and education; good ratings from organizations dealing with economic management - and I'm pleased by that. But perhaps one that's most appropriate tonight is an independent dispassionate organization that represents the views of all Americans: conservative, liberal, moderate, and so on - called the League of Women Voters. For five years the league has prepared the list of the most crucial issues that they believe affects governmental effectiveness, that affects governmental honesty, that affects dealing with America's real problems. And I'm proud of the fact that in each of those five years the League of Women Voters has rated me one hundred percent in favor of every one of those issues that they, on an independent and a bipartisan basis, have believed to be the most important to this country. And I note in that same record that my opponent was wrong half the time. He only was there 50 percent of the time. And I noted that the president of the United States, Mr. Ford, when he was in the Congress was right only 35 percent of the time. And I think that says something about balance. We are in the mainstream of public life. We want to get along with business, we want to get along with farmers, we want to get along with labor. We think the president has to lead everyone. And that's the only way that a president can lead. This president and his running mate think they can get elected by whipping labor on the back. Well labor's got a right to participate in the public life of this country as well as anyone else. Just take the embargo, for example. I was opposed, and said so at the time, of all the embargoes: the four imposed by the Republicans and the short one imposed by members of the labor movement. I thought it was wrong in both instances. This - this particular ticket here uh - is - selects out Mr. Meany as the scapegoat. Well, you can't run this country trying to scapegoat Americans. You have to bring everybody together and have a united country working together to solve our real problems. And that's another reason why we need Governor Carter. HOGE: Senator Dole, any further response? DOLE: Well, I'd say as far as the League of Women Voters - uh concerned, you can look at that two ways - either I was wrong half the time or they were wrong half of the time. [audience laughter] And I think, knowing the League of Women Voters, I think I'll take my interpretation. But with reference to uh - and they - cause they - very fine, but they tend to be a little bit liberal. Now, George Meany, he wants the right-to-work law repealed in Texas, in my state. Senator Mondale's for the repeal of right-to-work laws. He wants to force you to join a labor union. Seventy-five percent of America's working men and women don't belong to labor unions, but they will if George Meany and Governor Carter and Senator Mondale have their way. They've also got some big Proposition Fourteen out in California where organizers come on your property three hours a day and organize farmers, unionize farmers. Governor Carter's for that. I assume Senator Mondale's for that. Certainly Cesar Chavez is, and other labor leaders. I just say they ought to have influence; they shouldn't have domination. What about your national security voting record where you get a zero every year - to talk about our defense? HOGE: Thank you. Miss Berger, your question to Senator Mondale. Marilyn Berger: Senator Mondale, you've criticized Mr. Ford for having defended Richard Nixon - that is, while Mr. Ford was vice president - and you did see in your own political career that Hubert Humphrey suffered a great deal politically by standing with Lyndon Johnson almost to the end on Vietnam. And now you've acknowledged that you have differences with Governor Carter. You've said that an important mark of national leadership is the ability to put loyalty to principle above loyalty to party, or even to the president of the United States. If push came to shove, would you put principle above loyalty to your running mate, and possibly to the president of the United States? And what issues are important enough to do that? MONDALE: The answer is, yes I would. But I would not have accepted a place as the running mate of Governor Carter if I thought that was a real possibility. We had a long talk about the problem of independence between the two - the president and the vice president. And I made it clear to him that I was not interested in serving in a role that was ceremonial, or serving in a role where if I really felt deeply about something I was prevented from saying so. I did not wanna go through that; I did not wanna give up my position in the Senate where I have that right. We agreed that that would be the relationship. And during this campaign on three separate occasions where I've agreed with Mis- disagreed with Mr. Carter, I've said so in the course of this campaign. And I think the whole issue of public trust and public faith is bound up very closely with that question. We have had so much politics-as-usual, so much political trimming, that Americans have lost faith in public leadership. For example, in Watergate, when this nation's whole system of liberty was at stake, and the Ervin Committee was established to investigate wrongdoing by the president of the United States, my opponent introduced a resolution to slam the door shut on the Ervin Committee so the people could not see and hear what was going on. In the - night of the Saturday Night Massacre, perhaps the most treacherous moment in the history of American liberty, when the high officers - Richardson and Ruckelshaus - were fired for enforcing the law fired by the president of the United States, both Mr. Ford and Mr. Dole stood up and defended Mr. Nixon. And if Mr. Nixon had gotten away with that massacre that night he would - probably still be president of the United States and we would not have taught that crucial lesson that not even the highest officials in government can violate the law. Never again can we permit that kind of politics-above-all to dominate this country. Even today this administration is fighting all the Watergate reforms, opposed the appointment of a special prosecutor, opposed the reforms that were cried out for adoption following the revelations of the abuse of the CIA and the FBI. And with a record like that, and with all of the abuse of public faith and trust that we've been through, surely that, too, is another reason for a new generation of leadership. HOGE: Senator Dole. DOLE: Well, Watergate is a Republican problem, and I voted for the Watergate investigation. My opponent was absent - which is - we're all absent sometimes, but he's absent more than others. I think also it's well to point up that uh - I did introduce a resolution to shut off the public hearings and to get down to business and get Watergate behind us. Democrats didn't wanna do that. They were having great fun on TV every day it looked for a while they didn't want to find a solution. I remember Senator Ervin's report, the chairman of the Watergate committee, and he said in that report - and I was chairman of the Republican party during the Watergate years, and I'm very proud to have been chairman. I've always said that the night Watergate happened was my night off, so can't hook me for that. But Senator Ervin said had Senator Dole been in charge, there wouldn't have been a Watergate, so I don't want any rub-off from Senator Mondale's statements to want any of you people to believe that he might be suggesting that somehow President Ford or Senator Dole was in any way involved in Watergate; we were not. He brings it up all the time, he brings up the pardon all the time. He didn't bring up the fact that we tried to extend the investigation of Watergate back into other areas that were voted down along straight party lines. That's their right. They control the Senate. He didn't bring up the fact that uh - on the problems in the House uh - Democrats this year, the speaker appointed three Democrats to investigate the Democrats. Can you imagine the hue and cry in America had the Republicans done that? Why Mondale would've dropped dead. And that's the way it's been - that's the way it's been. But Watergate's our burden. We're going forward. It's behind us, and Governor Carter can talk about it, and Senator Mondale can talk about it, but beyond that I think we must say as Senator Mondale has - and I don't quarrel with him - that if there comes a time when I'm the vice president I can't agree with the president, then I must say so. I think that's fundamental. I think we're both honorable men, I think we both make that judgment. The only mystery to me is how do you know what Governor - Carter stands for? I've been trying to find out for six weeks. He has three positions on everything - that's why they're having three TV debates. [audience laughter] So I just suggest that uh - maybe in the time remaining Senator Mondale can tell us what his running mate stands for. The American people would like to know. HOGE: Senator Mondale. MONDALE: My candidate stands for jobs for all Americans. He stands for a government that fights inflation. He stands for tax reform and to take those revenues and reduce taxes for the average American. He stands for a program at long last to solve the high - health crisis in America. He stands for - at long last, to get the housing industry back an its feet. He will support programs to give senior citizens a decent break. He will not try, as Mr. Ford did, to put a cap on Social Security so senior citizens were robbed of their inflationary adjustments. He will not destroy the housing programs for senior citizens as this Republican administration has done. Governor Carter stands for leadership. He's gonna take charge. We need someone to lead this country. We haven't had it. Governor Carter will provide that leadership. And Governor Carter will restore to this nation a foreign policy that operates in the public and on the basis of the beliefs of the American people. HOGE: Gentlemen, we have about five minutes left for short questions and short answers. Each sequence from now on will consist only of the question, the answer and the other candidate's response. We'll drop the further response. The first question is from Mr. Mears to Senator Dole. Walter Mears: Senator Dole, ten days ago when Senator Mondale raised the issues of Watergate and the Nixon pardon, you called it the start of a campaign mud-slinging. Two years ago when you were running for the Senate you said that the pardon was prematurely granted and that it was a - and that it was a mistake. You were quoted by the Kansas City Times as saying, "You can't ignore our tradition of equal application of the law." Did you approve of the Nixon pardon when President Ford granted it? Do you approve of it now, and if the issue was fair game in your 1974 campaign in Kansas, why is it not an appropriate topic now? DOLE: Well it - [cough] it is an appropriate topic, I guess, but it's not a very good issue any more than the war in Vietnam would be or World War II, or World War I, or the war in Korea, all Democrat wars, all in this century. I figured up the other day, if we added up the killed and wounded in Democrat wars in this century, it'd be about one point six million Americans - enough to fill the city of Detroit. Now if we wanna go back and rake that over and over and over, we can do that. I assume Senator Mondale doesn't want to do that. But it seems to me that the pardon of Richard Nixon is behind us, Watergate's behind us. If we have this vision for American, if we're really concerned about those people out there and their problems, yes, and their education and their jobs, we ought to be talking about that. I know it strikes a responsive chord in some to kick Richard Nixon around. I don't know how long you can keep that up. How much mileage is there in someone who's been kicked, whose wife suffered a serious stroke, who's been disgraced in office and stepped down from that office, and I think after two years and some months that it's probably a dead issue. But let 'em play that game. That's the only game they know. HOGE: Senator Mondale. MONDALE: I think uh - Senator Dole has richly earned his reputation as a hatchet man tonight, by implying, and stating, that World War II and the Korean War were Democratic wars. Does he really mean to suggest to the American people that there was a partisan difference over our involvement in the war to fight Nazi Germany? I don't think any reasonable American would accept that. Does he really mean to suggest that it was only partisanship that got us into the war in Korea? Does he really mean to forget that part of the record where Mr. Nixon and the Republican party wanted us to get involved earlier in the war in Vietnam, and long after Mr. Nixon and the Republican party promised to finish the war in Vietnam, they kept urging us forward, and that in fact it was the Democratic Congress that passed the law ending the war in Vietnam and preventing a new war in Angola? Now, on Watergate, we're not charging, and he knows it, his involvement in Watergate. What we're saying is that they defended Mr. Nixon up to the last. HOGE: Mr. Bruno, your question to Senator Mondale. Hal Bruno: Senator Mondale, uh - you cited the priorities of a Carter administration. At the same time Governor Carter has promised to balance the federal budget within four years. Now can we take just one of those items that you gave very high priority to that would be very costly, uh - national health insurance? Now, realistically, what are the chances of getting this program in a Carter-Mondale administration, or would it have to be postponed until the budget is balanced? Which comes first? MONDALE: Well, I think both the presidential budget and our estimates agree that if we move back to full employment, as we intend to do, and achieve a five and a half percent real growth rate, as we did under Truman, and as we did under Kennedy and Johnson, that within four years the revenues generated by that growth, without increasing taxes, will pay for the costs of the programs now in place, such as Social Security, pensions and the rest, the ongoing programs that are essential in America - the defense program and the rest - and that we will have a full employment yield of somewhere between seventy and eighty billions of dollars. Some of that could be used for tax relief and it should be. Some of it should be, however, used for programs that at long last start dealing with the real problems that American faces, such as health care. Now, there are many different versions of health care; but we would work closely with Senator Kennedy, with Paul Rogers and others to develop a health program. Now there's no question about the difference in spending. The Republicans would spend more than we do during that same period, but they would spend it first by $20 billion in tax relief for wealthy businessmen or wealthy corporations, and secondly by the continuation of these economic policies that are costing us over $50 billion a year. So the question is not spending, the question is the priorities. HOGE: Senator Dole. DOLE: Well, I would remind uh - those who may be still tuned in that the Democrats still control the Congress. They did when we started this debate an hour and twenty minutes ago; they still do by two-to-one margins almost, and they're responsible for legislation. I know Senator Long, who's the chairman of our finance committee, be very pleased to learn what Senator Mondale is gonna do now with Governor Carter. Now if they're talking about full employment they're talking about the Humphrey-Hawkins bill, which they support. We don't know what it costs - twenty billion dollars? forty billion dollars? or more? Another government employment program. I'd like to add up the number of jobs Senator Mondale has cost this country in defense plants, defense jobs, in all his anti-defense votes. They'd be hundreds and hundreds of thousands and he knows it. He wants bigger welfare programs, bigger giveaway programs. We wanna take care of those out of work; we wanna take care of those in need. Let's not wreck our business system, let's not wreck our free enterprise system just to prove a point. HOGE: Thank you, Senators. That concludes the questioning for this evening. Each candidate now has up to three minutes for a closing statement. By the coin toss, it was determined that Senator Dole would make the first opening statement and take the first question. He now also goes first with his closing statement. Senator Dole. DOLE: Well, first I wish to thank the panel for their indulgence and of course all those in the viewing audience who may still be with us. I really hope - and I haven't prepared any final statement in advance - I really hope you were listening and we were able to tell you who's concerned about the American people, which party has faith in the American people, which party and which candidates want bigger and bigger and bigger government, which candidates want more and more spending, more and more interference. And we added up five of the programs that Governor Carter and Mondale talk about - only five, they really want sixty some new programs in their platform or expanded programs - they wanna create twenty-two new agencies, or expand that many existing agencies. We only added up five programs and the cost is a hundred and three billion dollars, a hundred and three billion! That would cost every taxpayer in America several hundred dollars. They don't care about inflation - the cruelest tax of all. And if you're in your living room watching tonight and you're making six thousand dollars a year on a fixed income and there's a six percent inflation, that's three hundred and sixty dollars a year, that's thirty dollars a month. That affects everybody in America. And add up your inflation if you let Carter and Mondale have their way - one spending program after another. We're concerned about the poor. We're concerned about the sick. We're concerned about the disabled. We're concerned about those on Social Security. And we have programs for that. We're concerned about housing - Carla Hills announced one today to reduce the interest payments from eight and a half percent to eight percent for FHA and VA homes. Governor Carter wants to preclude you from taking off your interest, your mortgage interest as a tax reduction. He says nobody wants their taxes lowered. Well, maybe not if they're getting a forty-one thousand dollar tax credit as he is. I just say in my final minute, it's a great honor and privilege to even be standing here - whatever happens on November second - it's an honor and a privilege. It's an honor and a privilege to have known President Ford for sixteen years, sixteen years, as I said at the outset. He's a man of unparalleled decency and honesty and courage; he's a man we can be proud of; he's gonna give us that leadership that America needs - all Americans - white, blacks, Spanish-speaking, rich, poor. Don't be fooled by the words, don't be fooled by the rhetoric, don't be fooled by the promises because somebody has to pay for those promises. Just take a look at the leadership. Take a look at President Ford. And thank President Ford for the fact that we live in peace and freedom and your sons and your husbands and your relatives are home and they're safe. It could only happen in America. Thank you. HOGE: Senator Mondale. MONDALE: Americans are not interested in partisan debating points. They're not interested in how many uh - debate points are scored. That means little to the lives of Americans. What really counts is whether this country can begin to solve those problems that are overwhelming so many Americans: record unemployment - the highest since the Great Depression, and getting worse; runaway inflation - three times worse than that under the Democratic party; deficits that are unbelievable. Just last year, under this administration, we had a deficit larger than all of the deficits created in the eight years of the Democratic administration, and under this Republican party higher deficits than in the previous one hundred and ninety two years of this government's history. Now we recognize that you have to be prudent, that you have to live within a budget, that you have to deal with the resources that are at hand. There's no dispute on that. The question is how will those resources be used? And we believe that we need a government that works, that's efficient, but we also think that we need a government that cares. We've cared too little for people in this country that have gotten sick and can't afford decent health care. We've cared too little for the thousands and thousands of American families that cannot get or afford decent housing. This administration has fought time and time again to cut back support for our senior citizens. They have no energy policy. They have no environmental policy. Those things must change. We believe in a strong defense. We're not going to let this nation's defenses drop. But there's a big difference between waste and strength, and what we've been attacking is waste because waste does not contribute to strength - it contributes to weakness. There are many problems in the Defense Department that require better management in order to get that increased strength. We need leadership in this country to do all of those things. For eight years now the Republicans have controlled government. For eight years they've controlled the White House, and every one of those problems has gotten worse. They are not now proposing new policies and new directions. Tonight you heard what they are doing. They are defending the past. Everything is all right. The problems are not as bad as the statistics or the people believe, and therefore they might go away. That is not enough. This country cries out for new leadership. We need a fresh start. And the Carter-Mondale ticket promises that start. Not because we know all the answers - we know better. Not because we can do everything at once - because we know better than that. But because a good nation requires that we begin the effort. HOGE: Thank you, Senator Mondale and thank you, Senator Dole. I want to thank as well the audience here tonight and my colleagues who were our questioners. The final debate in this series will be between the presidential candidates, Gerald Ford and his challenger, Jimmy Carter. It will be held on October 22nd at 9:30 p.m. Eastern Daylight Time on the campus of William and Mary College in Williamsburg, Virginia. The subject matter will cover all issues. The sponsors of these debates is the League of Women Voters Education Fund, whose purpose is to promote greater participation by a better informed electorate in the election on November second. Now, from the Alley Theater, Houston, Texas, good night.
