# Presidential Debate in St. Louis

**Date:** October 11, 1992
**Source:** https://www.presidency.ucsb.edu/documents/presidential-debate-st-louis

---

Jim Lehrer. Good evening, and welcome to the first of three debates among the major candidates for President of the United States, sponsored by the Commission on Presidential Debates. The candidates are independent candidate Ross Perot; Governor Bill Clinton, the Democratic nominee; and President George Bush, the Republican nominee. I am Jim Lehrer of "The MacNeil/Lehrer NewsHour" on PBS, and I will be the moderator for this 90-minute event, which is taking place before an audience here in the Athletic Complex on the campus of Washington University in St. Louis, Missouri. Three journalists will be asking questions tonight. They are John Mashek of the Boston Globe; Ann Compton of ABC News; and Sander Vanocur, a freelance journalist. We will follow a format agreed to by representatives of the Clinton and Bush campaigns. That agreement contains no restrictions on the content or subject matter of the questions. Each candidate will have up to 2 minutes for a closing statement. The order of those as well as the questioning was determined by a drawing. The first question goes to Mr. Perot. He will have 2 minutes to answer, to be followed by rebuttals of one minute each from Governor Clinton and then President Bush. Distinction Among Candidates Gentlemen, good evening. The first topic tonight is what separates each of you from the other. Mr. Perot, what do you believe tonight is the single most important separating issue of this campaign? Mr. Perot. I think the principal issue that separates me is that 5 1/2 million people came together on their own and put me on the ballot. I was not put on the ballot by either of the two parties. I was not put on the ballot by any PAC money, by any foreign lobbyist money, by any special interest money. This is a movement that came from the people. This is the way the framers of the Constitution intended our Government to be, a Government that comes from the people. Over time we have developed a Government that comes at the people, that comes from the top down, where the people are more or less treated as objects to be programmed during the campaign, with commercials and media events and fear messages and personal attacks and things of that nature. The thing that separates my candidacy and makes it unique is that this came from millions of people in 50 States all over this country who wanted a candidate that worked and belonged to nobody but them. I go into this race as their servant, and I belong to them. So this comes from the people. Mr. Lehrer. Governor Clinton, one-minute response. Governor Clinton. The most important distinction in this campaign is that I represent real hope for change: a departure from trickle-down economics, a departure from tax-and-spend economics, to invest and grow. But before I can do that I must challenge the American people to change, and they must decide. Tonight I say to the President: Mr. Bush, for 12 years you've had it your way. You've had your chance, and it didn't work. It's time to change. I want to bring that change to the American people, but we must all decide first we have the courage to change for hope and a better tomorrow. Mr. Lehrer. President Bush, one-minute response, sir. President Bush. Well, I think one thing that distinguishes is experience. I think we've dramatically changed the world. I'll talk about that a little bit later, but the changes are mind-boggling for world peace. Kids go to bed at night without the same fear of nuclear war. And change for change's sake isn't enough. We saw that message in the late seventies when we heard a lot about change. And what happened? That "misery index" went right through the roof. But my economic program, I think, is the kind of change we want. And the way we're going to get it done is we're going to have a brandnew Congress. A lot of them are thrown out because of all the scandals. I'll sit down with them, Democrats and Republicans alike, and work for my Agenda for American Renewal which represents real change. But I'd say, if you had to separate out, I think it's experience at this level. Experience Mr. Lehrer. Governor Clinton, how do you respond to the President -- you have 2 minutes -- on the question of experience? He says that is what distinguishes him from the other two of you. Governor Clinton. I believe experience counts, but it's not everything. Values, judgment, and the record that I have amassed in my State also should count for something. I've worked hard to create good jobs and to educate people. My State now ranks first in the country in job growth this year, fourth in income growth, fourth in the reduction of poverty, third in overall economic performance, according to a major news magazine. That's because we believe in investing in education and in jobs. We have to change in this country. You know, my wife, Hillary, gave me a book about a year ago in which the author defined insanity as just doing the same old thing over and over again and expecting a different result. We have got to have the courage to change. Experience is important, yes. I've gotten a lot of good experience in dealing with ordinary people over the last year and a month. I've touched more people's lives and seen more heartbreak and hope, more pain and more promise than anybody else who's run for President this year. And I think the American people deserve better than they're getting. We have gone from first to 13th in the world in wages in the last 12 years since Mr. Bush and Mr. Reagan have been in. Personal income has dropped while people have worked harder in the last 4 years. There have been twice as many bankruptcies as new jobs created. We need a new approach. The same old experience is not relevant. We're living in a new world after the cold war. And what works in this new world is not trickle-down, not Government for the benefit of the privileged few, not tax-and-spend but a commitment to invest in American jobs and American education. Controlling American health care costs and bringing the American people together, that is what works. And you can have the right kind of experience and the wrong kind of experience. Mine is rooted in the real lives of real people. And it will bring real results if we have the courage to change. Mr. Lehrer. President Bush, one minute to respond. President Bush. I just thought of another, another big difference here between me -- I don't believe Mr. Perot feels this way, but I know Governor Clinton did, because I want to accurately quote him. He thinks, I think he said, that the country is coming apart at the seams. Now, I know that the only way he can win is to make everybody believe the economy is worse than it is. But this country's not coming apart at the seams, for heaven sakes. We're the United States of America. In spite of the economic problems, we are the most respected economy around the world. Many would trade for it. We've been caught up in a global slowdown. We can do much, much better. But we ought not to try to convince the American people that America is a country that's coming apart at the seams. I would hate to be running for President and think that the only way I could win would be to convince everybody how horrible things are. Yes, there are big problems. And yes, people are hurting. But I believe that this Agenda for American Renewal I have is the answer to do it. And I believe we can get it done now, whereas we didn't in the past, because you're going to have a whole brandnew bunch of people in the Congress that are going to have to listen to the same American people I'm listening to. Mr. Lehrer. Mr. Perot, a minute response, sir. Mr. Perot. Well, they've got a point. I don't have any experience in running up a $4 trillion debt. [Laughter] I don't have any experience in gridlocked Government where nobody takes responsibility for anything and everybody blames everybody else. I don't have any experience in creating the worst public school system in the industrialized world, the most violent, crime-ridden society in the industrialized world. But I do have a lot of experience in getting things done. So if we're at a point in history where we want to stop talking about it and do it, I've got a lot of experience in figuring out how to solve problems, making the solutions work, and then moving on to the next one. I've got a lot of experience in not taking 10 years to solve a 10-minute problem. So if it's time for action, I think I have experience that counts. If it's more time for gridlock and talk and finger-pointing, I'm the wrong man. Character Issues Mr. Lehrer. President Bush, the question goes to you. You have 2 minutes. And the question is this: Are there important issues of character separating you from these other two men? President Bush. I think the American people should be the judge of that. I think character is a very important question. I said something the other day where I was accused of being like Joe McCarthy because I questioned -- put it this way -- I think it's wrong to demonstrate against your own country or organize demonstrations against your own country in foreign soil. I just think it's wrong. Maybe, they say, well, it was a youthful indiscretion. I was 19 or 20, flying off an aircraft carrier, and that shaped me to be Commander in Chief of the Armed Forces. And I'm sorry, but demonstrating -- it's not a question of patriotism. It's a question of character and judgment. They get on me, Bill's gotten on me about "Read my lips." When I make a mistake, I'll admit it. But he has not admitted the mistake. And I just find it impossible to understand how an American can demonstrate against his own country in a foreign land, organizing demonstrations against it, when young men are held prisoner in Hanoi or kids out of the ghetto were drafted. Some say, well, you're a little old-fashioned. Maybe I am, but I just don't think that's right. Now, whether it's character or judgment, whatever it is, I have a big difference here on this issue. And so we'll just have to see how it plays out. But I couldn't do that. And I don't think most Americans could do that. And they all say, well, it was a long time ago. Well, let's admit it then, say, "I made a terrible mistake." How could you be Commander in Chief of the Armed Forces and have some kid say, when you have to make a tough decision, as I did in Panama or in Kuwait, and then have some kid jump up and say, "Well, I'm not going to go. The Commander in Chief was organizing demonstrations halfway around the world during another era"? So there are differences. But that's about the main area where I think we have a difference. I don't know about -- we'll talk about that a little with Ross here in a bit. Mr. Lehrer. Mr. Perot, you have one minute. Mr. Perot. I think the American people will make their own decisions on character. And at a time when we have work to do and we need action, I think they need to clearly understand the backgrounds of each person. I think the press can play a huge role in making sure that the backgrounds are clearly presented in an objective way. Then make a decision. Certainly anyone in the White House should have the character to be there. But I think it's very important to measure when and where things occurred. Did they occur when you were a young person in your formative years, or did they occur while you were a senior official in the Federal Government? When you're a senior official in the Federal Government, spending billions of dollars in taxpayers' money, and you're a mature individual and you make a mistake, then that was on our ticket. If you make it as a young man, time passes. So I would say just look at all three of us, decide who you think will do the job, pick that person in November, because, believe me, as I've said before, the party's over, and it's time for the cleanup crew. And we do have to have change. And people who never take responsibility for anything when it happens on their watch, and people who are in charge -- -- Mr. Lehrer. Your time is up. Mr. Perot. -- -- the time is up. [Laughter] Mr. Lehrer. Time is up. Mr. Perot. More later. Mr. Lehrer. Governor Clinton, you have one minute. Governor Clinton. Ross gave a good answer, but I've got to respond directly to Mr. Bush. You have questioned my patriotism. You even brought some rightwing Congressmen into the White House to plot how to attack me for going to Russia in 1969 - 1970, when over 50,000 other Americans did. Now, I honor your service in World War II. I honor Mr. Perot's service in uniform and the service of every man and woman who ever served, including Admiral Crowe, who was your Chairman of the Joint Chiefs and who's supporting me. But when Joe McCarthy went around this country attacking people's patriotism, he was wrong. He was wrong. And a Senator from Connecticut stood up to him, named Prescott Bush. Your father was right to stand up to Joe McCarthy. You were wrong to attack my patriotism. I was opposed to the war, but I love my country. And we need a President who will bring this country together, not divide it. We've had enough division. I want to lead a unified country. Mr. Lehrer. All right. We move now to the subject of taxes and spending. The question goes to Governor Clinton for a two-minute answer. It will be asked by Ann Compton. Taxes Ann Compton. Governor Clinton, can you lock in a level here tonight on where middle-income families can be guaranteed a tax cut or, at the very least, at what income level they can be guaranteed no tax increase? Governor Clinton. The tax increase I have proposed triggers in at family incomes of $200,000 and above. Those are the people who, in the 1980's, had their incomes go up while their taxes went down. Middle-class people, defined as people with incomes of $52,000 and down, had their incomes go down while their taxes went up in the Reagan-Bush years because of six increases in the payroll taxes. So that is where my income limit would trigger. Ms. Compton. So there will be no tax increases below $200,000? Governor Clinton. My plan, notwithstanding my opponent's ad, my plan triggers in at gross incomes, family incomes of $200,000 and above. And then we want to give modest middle-class tax relief to restore some fairness, especially to middle-class people with families with incomes of under $60,000. In addition to that, the money that I raise from upper income people and from asking foreign corporations just to pay the same income on their income earned in America that American corporations do will be used to give incentives back to upper income people. I want to give people permanent incentives on investment tax credit like President Kennedy and the Congress inaugurated in the early sixties to get industry moving again; a research and development tax credit; a low-income housing tax credit; a long-term capital gains proposal for new business and business expansions. We've got to have no more trickle-down. We don't need across-the-board tax cuts for the wealthy for nothing; we need to say, here's your tax incentive if you create American jobs the old-fashioned way. I'd like to create more millionaires than were created under Mr. Bush and Mr. Reagan, but I don't want to have 4 years where we have no growth in the private sector. And that's what's happened in the last 4 years. We're down 35,000 jobs in the private sector. We need to invest and grow, and that's what I want to do. Mr. Lehrer. President Bush, one minute, sir. President Bush. I have to correct one thing. I didn't question the man's patriotism; I questioned his judgment and his character. What he did in Moscow, that's fine. Let him explain it. He did. I accept that. What I don't accept is demonstrating and organizing demonstrations in a foreign country when your country's at war. I'm sorry, I cannot accept that. This one on taxes spells out the biggest difference between us. I do not believe we need to go back to the Mondale proposals or the Dukakis proposals of tax-and-spend. Governor Clinton says $200,000, but he also says he wants to raise $150 billion. Taxing people over $200,000 will not get you $150 billion. And then when you add in his other spending proposals, regrettably, you end up socking it to the working man. That old adage that they use, "We're going to soak the rich, we're going to soak the rich," it always ends up being the poor cab driver or the working man that ends up paying the bill. And so I just have a different approach. I believe the way to get the deficit down is to control the growth of mandatory spending programs and not raise taxes on the American people. We've got a big difference there. Mr. Lehrer. Mr. Perot, one minute. Mr. Perot. We've got to have a growing, expanding job base to give us a growing, expanding tax base. Right now, we have a flat-to-deteriorating job base, and where it appears to be growing is minimum-wage jobs. So we've got to really rebuild our job base. That's going to take money for infrastructure and investment to do that. Our foreign competitors are doing it; we're not. We cannot pay off the $4 trillion debt, balance the budget, and have the industries of the future and the high-paying jobs in this country without having the revenue. We're going to go through a period of shared sacrifice. There's one challenge: It's got to be fair. We've created a mess and don't have much to show for it, and we have got to fix it. And that's about all I can say in a minute. Mr. Lehrer. Okay. Next question goes to President Bush for a 2-minute answer, and it will be asked by Sandy Vanocur. U.S. Troops in Europe Sander Vanocur. Mr. President, this past week your Secretary of the Army, Michael Stone, said he had no plans to abide by a congressional mandate to cut U.S. forces in Europe from 150,000 to 100,000 by the end of September 1996. Now, why, almost 50 years after the end of World War II and with the total collapse of the Soviet Union, should American taxpayers be taxed, support armies in Europe, when the Europeans have plenty of money to do it for themselves? President Bush. Well, Sander, that's a good question. And the answer is: For 40-some years, we kept the peace. If you look at the cost of not keeping the peace in Europe, it would be exorbitant. We have reduced the number of troops that are deployed and going to be deployed. I have cut defense spending. And the reason we could do that is because of our fantastic success in winning the cold war. We never would have got there if we'd gone for the nuclear-freeze crowd; never would have got there if we'd listened to those that wanted to cut defense spending. I think it is important that the United States stay in Europe and continue to guarantee the peace. We simply cannot pull back. Now, when anybody has a spending program they want to spend money on at home, they say, well, let's cut money out of the Defense Department. I will accept and have accepted the recommendations of two proven leaders, General Colin Powell and Dick, Secretary Dick Cheney. They feel that the levels we're operating at and the reductions that I have proposed are proper. And so I simply do not think we should go back to the isolation days and start blaming foreigners. We are the sole remaining superpower. And we should be that. We have a certain disproportionate responsibility. But I would ask the American people to understand that if we make imprudent cuts, if we go too far, we risk the peace. And I don't want to do that. I've seen what it is like to see the burdens of a war, and I don't want to see us make reckless cuts. Because of our programs, we have been able to significantly cut defense spending. But let's not cut into the muscle. And let's not cut down our insurance policy, which is participation of American forces in NATO, the greatest peacekeeping organization ever made. Today, you've got problems in Europe still bubbling along, even though Europe's going democracy's route. But we are there. And I think this insurance policy is necessary. I think it goes with world leadership. And I think the levels we've come up with are just about right. Mr. Lehrer. Mr. Perot, one minute, sir. Mr. Perot. If I'm poor and you're rich and I can get you to defend me, that's good. But when the tables get turned, I ought to do my share. Right now we spend about $300 billion a year on defense. The Japanese spend around $30 billion in Asia. The Germans spend around $30 billion in Europe. For example, Germany will spend a trillion dollars building infrastructure over the next 10 years. It's kind of easy to do if you only have to pick up a $30 billion tab to defend your country. The European Community is in a position to pay a lot more than they have in the past. I agree with the President, when they couldn't, we should have; now that they can, they should. We sort of seem to have a desire to try to stay over there and control it. They don't want us to control it, very candidly. So it I think is very important for us to let them assume more and more of the burden and for us to bring that money back here and rebuild our infrastructure. Because we can only be a superpower if we are an economic superpower, and we can only be an economic superpower if we have a growing, expanding job base. Mr. Lehrer. Governor Clinton, one minute, sir. Governor Clinton. I agree with the general statement Mr. Bush made. I disagree that we need 150,000 troops to fulfill our role in Europe. We certainly must maintain an engagement there. There are certainly dangers there. There are certainly other trouble spots in the world which are closer to Europe than to the United States. But two former Defense Secretaries recently issued reports saying that 100,000 or slightly fewer troops would be enough, including President Reagan's former Defense Secretary, Mr. Carlucci. Many of the military experts whom I consulted on this agreed. We're going to have to spend more money in the future on military technology and on greater mobility, greater airlift, greater sealift, the B - 22 airplane. We're going to have to do some things that are quite costly, and I simply don't believe we can afford, nor do we need to keep 150,000 troops in Europe, given how much the Red Army, now under the control of Russia, has been cut; the arms control agreement concluded between Mr. Bush and Mr. Yeltsin, something I have applauded. I don't think we need 150,000 troops. Let me make one other point. Mr. Bush talked about taxes. He didn't tell you that he vetoed a middle-class tax cut because it would be paid for by raising taxes on the wealthy and vetoed an investment tax credit paid for by raising taxes on the wealthy. Taxes Mr. Lehrer. All right. We go now to Mr. Perot for a 2-minute question, and it will be asked by John Mashek. John Mashek. Mr. Perot, you talked about fairness just a minute ago, on sharing the pain. As part of your plan to reduce the ballooning Federal deficit, you've suggested that we raise gasoline taxes 50 cents a gallon over 5 years. Why punish the middle-class consumer to such a degree? Mr. Perot. It's 10 cents a year, cumulative. It finally gets to 50 cents at the end of the fifth year. I think "punish" is the wrong word. Again, you see, I didn't create this problem; we're trying to solve it. Now, if you study our international competitors, some of our international competitors collect up to $3.50 a gallon in taxes. And they use that money to build infrastructure and create jobs. We collect 35 cents, and we don't have it to spend. I know it's not popular. And I understand the nature of your question. But the people who will be helped the most by it are the working people who will get the jobs created because of this tax. Why do we have to do it? Because we have so mismanaged our country over the years, and it is now time to pay the fiddler. And if we don't, we will be spending our children's money. We have spent $4 trillion worth. An incredible number of young people are active in supporting my effort because they're deeply concerned that we have taken the American dream from them. I think it's fitting that we're on the campus of a university tonight. These young people, when they get out of this wonderful university, will have difficulty finding a job. We've got to clean this mess up, leave this country in good shape, and pass on the American dream to them. We're got to collect the taxes to do it. If there's a fairer way, I'm all ears. Ah-h-h. [Laughter] But see, let me make it very clear. People don't have the stomach to fix these problems, I think it's a good time to face it in November. If they do, then they will have heard the harsh reality of what we have to do. I'm not playing Lawrence Welk music tonight. Mr. Lehrer. Governor Clinton, you have a minute, sir. Governor Clinton. I think Mr. Perot has confronted this deficit issue, but I think it's important to point out that we really have two deficits in America, not one. We have a budget deficit in the Federal Government, but we also have an investment, a jobs, an income deficit. People are working harder for less money than they were making 10 years ago: two-thirds of our people, a $1,600 drop in average income in just the last 2 years. The problem I have with the Perot prescription is that almost all economists who have looked at it say that if you cut the deficit this much this quick, it will increase unemployment, it will slow down the economy. That's why I think we shouldn't do it that quickly. We have a disciplined reduction in the deficit of 50 percent over the next 4 years. But first, get incentives to invest in this economy, put the American people back to work. We've got to invest in growth. Nine Nobel Prize-winning economists and 500 others, including numerous Republican and Democratic business executives, have endorsed this approach because it offers the best hope to put America back to work and get our incomes rising instead of falling. Mr. Lehrer. President Bush, one minute, sir. President Bush. The question was on fairness. I just disagree with Mr. Perot. I don't believe it is fair to slap a 50-cent-a-gallon tax over whatever many years on the people that have to drive for a living, people that go long distances. I don't think we need to do it. You see, I have a fundamental difference. I agree with what he's talking about in trying to get the spending down and to discipline, although I think we ought to totally exempt Social Security. But he's talking tough medicine, and I think that's good. I disagree with the tax-and-spend philosophy. You see, I don't think we need to tax more and spend more and then say that's going to make the problem better. And I'm afraid that's what I think I'm hearing from Governor Clinton. I believe what you need to do is some of what Ross is talking about: control the growth of mandatory spending and get taxes down. He's mentioned some ways to do it, and I agree with those. I've been talking about getting a capital gains cut forever. And his friends in Congress have been telling me that's a tax break for the rich. It would stimulate investment. I'm for an investment tax allowance. I am for a tax break for first-time homebuyers. And with this new Congress coming in, gridlock will be gone and I'll sit down with them and say, let's get this done. But I do not want to go the tax-and-spend route. Mr. Lehrer. All right. Let's move on now to the subject of jobs. The first question goes to President Bush for 2 minutes, and John will ask that question. John? The Defense Industry Mr. Mashek. Mr. President, last month you came to St. Louis to announce a very lucrative contract for McDonnell Douglas to build F - 15's for Saudi Arabia. In today's Post-Dispatch, a retired saleswoman, a 75-year-old woman named Marjorie Roberts, asked if she could ask a question of the candidates, said she wanted to register her concern about the lack of a plan to convert our defense-oriented industries into other purposes. How would you answer her? President Bush. Well, I assume she was supportive of the decision on McDonnell Douglas. I assume she was supporting me on the decision to sell those airplanes. I think it's a good decision. I took a little heat for it, but I think it was the correct decision to do. And we've worked it out, and indeed, we're moving forward all around the world in a much more peaceful way. So that one we came away with which -- in creating jobs for the American people. I would simply say to her, look, take a look at what the President has proposed on job retraining. When you cut back on defense spending, some people are going to be thrown out of work. If you throw another 50,000 kids on the street because of cutting recklessly in troop levels, you're going to put a lot more out of work. I would say to them, look at the job retraining programs that we're proposing. Therein is the best answer to her. And another one is, stimulate investment and savings. I mean, we've got big economic problems, but we are not coming apart at the seams. We're ready for a recovery with interest rates down and inflation down, the cruelest tax of all; caught up in a global slowdown right now, but that will change if you go with the programs I've talked about and if you help with job retraining and education. I am a firm believer that our America 2000 education problem is the answer. A little longer run; it's going to take a while to educate, but it is a good program. So her best hope for short term is job retraining if she was thrown out of work at a defense plant. But tell her it's not all that gloomy. We're the United States. We've faced tough problems before. Look at the "misery index" when the Democrats had both the White House and the Congress. It was just right through the roof. Now, we can do better. And the way to do better is not to tax and spend but to retrain, get that control of the mandatory spending programs. I am much more optimistic about this country than some. Mr. Lehrer. Mr. Perot, you have one minute, sir. Mr. Perot. Your defense industries are going to have to convert to civilian industries, many of them are. And the sooner they start, the sooner they'll finish. And there will be a significant transition. And it's very important that we not continue to let our industrial base deteriorate. We had someone who I'm sure regrets said it in the President's staff, said he didn't care whether we make potato chips or computer chips. Well, anybody that thinks about it cares a great deal. Number one, you make more making computer chips than you do potato chips. Number two, 19 out of 20 computer chips that we have in this country now come from Japan. We've given away whole industries. So as we phase these industries over, there's a lot of intellectual talent in these industries. A lot of these people in industries can be converted to the industries of tomorrow. And that's where the high-paying jobs are. We need to have a very carefully thought through phaseover. See, we practice 19th century capitalism. The rest of the world practices 21st century capitalism. I can't handle that in a minute, but I hope we can get back into it later. The rest of the world, the countries and the businesses would be working together to make this transition in an intelligent way. Mr. Lehrer. Governor Clinton, you have one minute, sir. Governor Clinton. We must have a transition plan, a plan to convert from a defense to a domestic economy. No other nation would have cut defense as much as we already have without that. There are 200,000 people unemployed in California alone because we have cut defense without planning to retrain them and to reinvest in the technologies of the future here at home. That is what I want to do. This administration may say they have a plan, but the truth is they have not even released all the money, the paltry sum of money that Congress appropriated. I want to take every dollar by which we reduced defense and reinvest it in technologies for the 21st century: in new transportation, in communication, and environmental cleanup technologies. Let's put the American people to work. And let's build the kind of high-tech, high-wage, high-growth economy that the American people deserve. Mr. Lehrer. All right. The next question goes to Mr. Perot for a 2 minute answer. It will be asked by Ann. Ann? Jobs Program Ms. Compton. Mr. Perot, you talked a minute ago about rebuilding the job base. But is it true what Governor Clinton just said, that that means that unemployment will increase, that it will slow the economy? And how would you specifically use the powers of the Presidency to get more people back into good jobs immediately? Mr. Perot. Step one: The American people send me up there, the day after election, I'll get with the -- we won't even wait until inauguration -- I'll ask the President to help me, and I'll ask his staff to help me. And we will start putting together teams to put together -- to take all the plans that exist and do something with them. Please understand, there are great plans lying all over Washington nobody ever executes. It's like having a blueprint for a house you never built. You don't have anywhere to sleep. Now, our challenge is to take these things, do something with them. Step one: You want to put America back to work, clean up the small business problem. Have one task force at work on that. The second: You've got your big companies that are in trouble, including the defense industries, have another one on that. Have a third task force on new industries of the future to make sure we nail those for our country, and they don't wind up in Europe and Asia. Convert from 19th to 21st century capitalism. You see, we have an adversarial relationship between Government and business. Our international competitors that are cleaning our plate have an intelligent relationship between Government and business and a supportive relationship. Then, have another task force on crime, because next to jobs, our people are concerned about their safety. Health care, schools, one on the debt and deficit. And finally, in that 90-day period before the inauguration, put together the framework for the town hall and give the American people a Christmas present, show them by Christmas the first cut at these plans. By the time Congress comes into session to go to work, have those plans ready to go in front of Congress. Then get off to a flying start in '93 to execute these plans. Now, there are people in this room and people on this stage who have been in meetings when I would sit there and say, is this one we're going to talk about or do something about? Well, obviously, my orientation is let's go do it. Now, put together your plans by Christmas. Be ready to go when Congress goes. Nail these things -- small business, you've got to have capital; you've got to have credit; and many of them need mentors or coaches. And we can create more jobs there in a hurry than any other place. Mr. Lehrer. Governor Clinton, one minute. Governor Clinton. This country desperately needs a jobs program. And my first priority would be to pass a jobs program, to introduce it on the first day I was inaugurated. I would meet with the leaders of the Congress, with all the newly elected Members of the Congress, and as many others with whom I could meet between the time of the election and the inauguration. And we would present a jobs program. Then we would present a plan to control health care costs and phase in health care coverage for all Americans. Until we control health care costs, we're not going to control the deficit. It is the number one culprit. But first we must have an aggressive jobs program. I live in a State where manufacturing job growth has far outpaced the Nation in the last few years; where we have created more private sector jobs since Mr. Bush has been President than have been created in the entire rest of the country, where Mr. Bush's Labor Secretary said the job growth has been enormous. We've done it in Arkansas. Give me a chance to create these kinds of jobs in America. We can do it. I know we can. Mr. Lehrer. President Bush, one minute. President Bush. Well, we've got a plan announced for what we can do for small business. I've already put forward things that will get this country working fast, some of which have been echoed here tonight: investment tax allowance, capital gains reduction, more on research and development, a tax credit for first-time homebuyers. What I'm going to do is say to Jim Baker when this campaign is over, "All right, let's sit down now. You do in domestic affairs what you've done in foreign affairs. Be the kind of economic coordinator of all the domestic side of the house, and that includes all the economic side, all the training side, and bring this program together." We're going to have a new Congress. And we're going to say to them, "You've listened to the voters the way we have. Nobody wants gridlock anymore. And so let's get the program through." And I believe it will work, because, as Ross said, we've got the plans. The plans are all over Washington. And I have put ours together in something called the Agenda for American Renewal. And it makes sense. It's sensible. It creates jobs. It gets to the base of the kind of jobs we need. And so I'll just be asking for support to get that put into effect. Mr. Lehrer. The next question goes to Governor Clinton for 2 minutes. It will be asked by Sandy. Federal Reserve Board Chairman Mr. Vanocur. Governor Clinton, when a President running for the first time gets into the office and wants to do something about the economy, he finds in Washington there's a person who has much more power over the economy than he does: the Chairman of the Federal Reserve Board, accountable to no one. That being the case, would you go along with proposals made by Treasury Secretary James Brady and Congressman Lee Hamilton to make the Federal Reserve Board Chairman somehow more accountable to elected officials? Governor Clinton. Well, let me say that I think that we might ought to review the terms and the way it works. But frankly, I don't think that's the problem today. We have low interest rates today. At least we have low interest rates that the Fed can control. Our long-term interest rates are still pretty high because of our deficit and because of our economic performance. And there was a terrible reaction internationally to Mr. Bush saying he was going to give us 4 more years of trickle-down economics and other across-the-board tax cuts and most of it going to the wealthy with no real guarantee of investment. But I think the important thing is to use the powers the President does have on the assumption that given the condition of this economy, we're going to keep interest rates down if we have the discipline to increase investment and reduce the debt at the same time. That is my commitment. I think the American people are hungry for action. I think Congress is hungry for someone who will work with them, instead of manipulate them; someone who will not veto a bill that has an investment credit, middle class tax relief, research and development tax credits, as Mr. Bush has done. Give me a chance to do that. I don't have to worry, I don't think, in the near term, about the Federal Reserve. Their policies so far, it seems to me, are pretty sound. Mr. Lehrer. President Bush, you have one minute. President Bush. I don't think the Fed ought to be put under the Executive Branch. There is separation there. I think that's fine. Alan Greenspan is respected. I've had some arguments with him about the speed in which we might have lowered rates. But Governor Clinton, he talks about the reaction to the markets. There was a momentary fear that he might win, and the markets went "rrrfft" -- down like that -- [laughter] -- so I don't -- we can judge on -- the stock market has been strong. It's been very strong since I've been President. And they recognize we've got great difficulties. But they're also much more optimistic than the pessimists we have up here tonight. In terms of vetoing tax bills, you're darn right. I am going to protect the American taxpayer against the spend-and-tax Congress. And I'm going to keep on vetoing them because I don't think we are taxed too little. I think the Government's spending too much. So Governor Clinton can label it tax for the rich or anything he wants. I'm going to protect the working man by continuing to veto and to threaten veto until we get this new Congress, when then we're going to move forward on our plan. I`ve got to protect them. Mr. Lehrer. Mr. Perot, one minute. Mr. Perot. Keep the Federal Reserve independent, but let's live in a world of reality. We live in a global economy, not a national economy. These interest rates we have now don't make any sense. We have a $4 trillion debt, and only in America would you finance 70 percent of it 5 years or less. So 70 percent of our debt is 5 years or less, it's very interest-sensitive. We have a 4-percent gap between what we pay for treasuries and what Germany pays for 1- to 5-year treasuries. That gap is going to close because the Arabs, the Japanese, and folks in this country are going to start buying German treasuries because they can get more money. Every time our interest rates go up 1 percent, that adds $28 billion to the deficit or to the debt, whichever place you want to put it. We are sitting on a ticking bomb, folks, because we have totally mismanaged our country. And we had better get it back under control. Just think, in your own business, if you had all of your long-term problems financed short term, you'd go broke in a hurry. Mr. Lehrer. We're going to move to foreign affairs. The first question goes to Mr. Perot for a 2-minute answer, and Sandy will ask it. Foreign Affairs Mr. Vanocur. Mr. Perot, in the post-cold-war environment, what should be the overriding U.S. national interest? And what can the United States do, and what can it afford to do to defend that national interest? Mr. Perot. Again, if you're not rich, you're not a superpower, so we have two that I'd put as number one. I have a "1" and "1a." One is, we've got to have the money to be able to pay for defense. And we've got to manufacture here. Believe it or not, folks, you can't ship it all overseas. You've got to make it here. And you can't convert from potato chips to airplanes in an emergency. You see, Willow Run could be converted from cars to airplanes in World War II because it was here. We've got to make things here. You just can't ship them overseas anymore. I hope we talk more about that. Second thing, on priorities, we've got to help Russia succeed in its revolution and all of its republics. When we think of Russia, remember we're thinking of many countries now. We've got to help them. That's pennies on the dollar compared to renewing the cold war. Third, we've got all kinds of agreements on paper and some that are being executed on getting rid of nuclear warheads. Russia and its republics are out of control or, at best, in weak control right now. It's a very unstable situation. You've got every rich Middle Eastern country over there trying to buy nuclear weapons, as you well know. And that will lead to another five-star migraine headache down the road. We really need to nail down the intercontinental ballistic missiles, the ones that can hit us from Russia. We've focused on the tactical; we've made real progress there. We've got some agreements on the nuclear, but we don't have those things put away yet. The sooner, the better. So in terms of priorities, we've got to be financially strong. Number two, we've got to take care of this missile situation and try to get the nuclear war behind us and give that a very high priority. And number three, we need to help and support Russia and the republics in every possible way to become democratic, capitalistic societies and not just sit back and let those countries continue in turmoil, because they could go back worse than things used to be. And believe me, there are a lot of old boys in the KGB and the military that like it better the way it used to be. Thank you. Mr. Lehrer. Governor Clinton, one minute. Governor Clinton. In order to keep America the strongest nation in the world, we need some continuity and some change. There are three fundamental challenges. First of all, the world is still a dangerous and uncertain place. We need a new military and a new national security policy equal to the challenges of the post-cold-war era; a smaller permanent military force, but one that is more mobile, well-trained, with high-technology equipment. We need to continue the negotiations to reduce nuclear arsenals in the Soviet Union, the former Soviet Union, and the United States. We need to stop this proliferation of weapons of mass destruction. Second, we have to face that in this world economic security is a whole lot of national security. Our dollar is at an all-time low against some foreign currencies. We're weak in the world. We must rebuild America's strength at home. Finally, we ought to be promoting the democratic impulses around the world. Democracies are our partners. They don't go to war with each other. They're reliable friends in the future. National security, economic strength, democracy. Mr. Lehrer. President Bush, one minute. President Bush. We still are the envy of the world in terms of our military; there's no question about that. We're the envy of the world in terms of our economy, in spite of the difficulties we're having; there's no question about that. Our exports are dramatically up. I might say to Mr. Perot, I can understand why you might have missed it because there's so much fascination by trivia, but I worked out a deal with Boris Yeltsin to eliminate, get rid of entirely, the most destabilizing weapons of all, the SS - 18, the big intercontinental ballistic missile. I mean, that's been done. And thank God it has, because the parents of these young people around here go to bed at night without the same fear of nuclear war. We've made dramatic progress. So we've got a good military -- the question that says get a new military, get the best in the world -- we've got it, and they're keeping the peace. They're respected around the world, and we are more respected because of the way we have conducted ourselves. We didn't listen to the nuclear freeze crowd. We said, peace through strength. It worked, and the cold war is over. America understands that. But we're turned so inward we don't understand the global picture. We are helping democracy. Ross, the FREEDOM Support Act is something that I got through the Congress, and it's a very good thing because it does exactly what you say, and I think you agree with that, to help Russian democracy. We're going to keep on doing that. Mr. Lehrer. All right, Next question is for Governor Clinton, and John will ask it. China-U.S. Relations Mr. Mashek. Governor Clinton, you've accused the President of coddling tyrants, including those in Beijing. As President, how would you exert U.S. power to influence affairs in China? Governor Clinton. I think our relation-ships with China are important, and I don't think we want to isolate China. But I think it is a mistake for us to do what this administration did when all those kids went out there carrying the Statue of Liberty in Tiananmen Square, and Mr. Bush sent two people in secret to toast the Chinese leaders and basically tell them not to worry about it. They rewarded him by opening negotiations with Iran to transfer nuclear technology. That was their response to that sort of action. Now that voices in the Congress and throughout the country have insisted that we do something about China, look what has happened. China has finally agreed to stop sending us products made with prison labor not because we coddled them but because the administration was pushed into doing something about it. Recently the Chinese have announced that they're going to lower some barriers to our products, which they ought to do since they have a $15 billion trade surplus with the United States under Mr. Bush, the second biggest surplus of all, second to Japan. So I would be firm. I would say, if you want to continue most-favored-nation status for your government-owned industries as well as your private ones, observe human rights in the future. Open your society. Recognize the legitimacy of those kids that were carrying the Statue of Liberty. If we can stand up for our economic interests, we ought to be able to pursue the democratic interests of the people in China. And over the long run they'll be more reliable partners. Mr. Lehrer. President Bush, you have one minute. President Bush. Well, the administration was the first major country to stand up against the abuse in Tiananmen Square. We are the ones that worked out the prison labor deal. We are the ones that have lowered the barrier to products, the Carla Hills negotiation. I am the one that said, let's keep the MFN because you see China moving toward a free market economy. To do what the Congress and Governor Clinton are suggesting, you would isolate and ruin Hong Kong. They are making some progress, not enough for us. We were the first ones to put sanctions on. We still have them on some things. But Governor Clinton's philosophy is isolate them. He says don't do it, but the policies he's expounding of putting conditions on MFN and kind of humiliating them is not the way you make the kind of progress we are getting. I have stood up with these people, and I understand what you have to do to be strong in this situation. It's moving, not as fast as we'd like. But you isolate China and turn them inward, and then we've made a tremendous mistake. I'm not going to do it. I've had to fight a lot of people that were saying "human rights." We are the ones that put the sanctions on and stood for it. And he can insult General Scowcroft if he wants to. He didn't go over to coddle. He went over to say -- -- Mr. Lehrer. Mr. President, you're over -- -- President Bush. -- -- you must make the very changes they're making now. Mr. Lehrer. One minute, Mr. Perot. Mr. Perot. China's a huge country, broken into many provinces. It has some very elderly leaders that will not be around too much longer. Capitalism is growing and thriving across big portions of China. Asia will be our largest trading partner in the future. It will be a growing and a closer relationship. We have a delicate tightwire walk that we must go through at the present time to make sure that we do not cozy up to tyrants, to make sure that they don't get the impression that they can suppress their people. But time is our friend there because their leaders will change in not too many years, worst case. And their country is making great progress. One last point on the missiles. I don't want the American people to be confused. We have written agreements, and we have some missiles that have been destroyed, but we have a huge number of intercontinental ballistic missiles that are still in place in Russia. The fact that you have an agreement is one thing. Until they're destroyed, some crazy person can either sell them or use them. Mr. Lehrer. All right. The next question goes to President Bush for a 2-minute answer, and Ann will ask it. Bosnia and Somalia Ms. Compton. Mr. President, how can you watch the killing in Bosnia and the ethnic cleansing, or the starvation and anarchy in Somalia, and not want to use America's might, if not America's military, to try to end that kind of suffering? President Bush. Ann, both of them are very complicated situations. I vowed something, because I learned something from Vietnam: I am not going to commit U.S. forces until I know what the mission is, until the military tell me that it can be completed, until I know how they can come out. We are helping. American airplanes are helping today on humanitarian relief for Sarajevo. It is America that's in the lead in helping with humanitarian relief for Somalia. But when you go to put somebody else's son or daughter into war, I think you've got to be a little bit careful, and you have to be sure that there's a military plan that can do this. You have ancient ethnic rivalries that have cropped up as Yugoslavia is dissolved or getting dissolved. It isn't going to be solved by sending in the 82d Airborne, and I'm not going to do that as Commander in Chief. I am going to stand by and use the moral persuasion of the United States to get satisfaction in terms of prison camps, and we're making some progress there, and in terms of getting humanitarian relief in there. Right now, as you know, the United States took the lead in a no-fly operation up there, no-fly order up in the United Nations. We're working through the international organizations. That's one thing I learned by forging that tremendous and greatly, highly successful coalition against Saddam Hussein, the dictator: Work internationally to do it. I'm very concerned about it. I'm concerned about ethnic cleansing. I'm concerned about attacks on Muslims, for example, over there. But I must stop short of using American force until I know how those young men and women are going to get out of there as well as get in, know what the mission is and define it. I think I'm on the right track. Ms. Compton. Are you designing a mission that would -- -- Mr. Lehrer. Ann, sorry, sorry. Time is up. We have to go to Mr. Perot for a one-minute response. Mr. Perot. If we learned anything in Vietnam, it's you first commit this Nation before you commit the troops to the battlefield. We cannot send our people all over the world to solve every problem that comes up. This is basically a problem that is a primary concern to the European Community. Certainly we care about the people. We care about the children. We care about the tragedy. But it is inappropriate for us, just because there's a problem somewhere around the world, to take the sons and daughters of working people -- and make no mistake about it, our all-volunteer armed force is not made up of the sons and daughters of the beautiful people. It's the working folks that send their sons and daughters to war, with a few exceptions. Very unlike World War II when FDR's sons flew missions; everybody went. It's a different world now. It's very important that we not just, without thinking it through, just rush to every problem in the world and have our people torn to pieces. Mr. Lehrer. Governor Clinton, one minute. Governor Clinton. I agree that we cannot commit ground forces to become involved in the quagmire of Bosnia or in the tribal wars of Somalia. But I think that it's important to recognize that there are things that can be done short of that and that we do have interests there. There are, after all, two million refugees now because of the problems in what was Yugoslavia, the largest number since World War II, and there may be hundreds of thousands of people who will starve or freeze to death in this winter. The United States should try to work with its allies and stop it. I urged the President to support this air cover, and he did, and I applaud that. I applaud the no-fly zone, and I know that he's going back to the United Nations to try to get authority to enforce it. I think we should stiffen the embargo on the Belgrade government. I think we have to consider whether or not we should lift the arms embargo now on the Bosnians, since they are in no way in a fair fight with a heavily armed opponent bent on ethnic cleansing. We can't get involved in the quagmire, but we must do what we can. Mr. Lehrer. All right. Moving on now to divisions in our country. The first question goes to Governor Clinton for two minutes, and Ann will ask it. Family Values Ms. Compton. Governor Clinton, can you tell us what your definition of the word "family" is? Governor Clinton. A family involves at least one parent, whether natural or adoptive or foster, and children. A good family is a place where love and discipline and good values are transmuted from the elders to the children, a place where people turn for refuge and where they know they're the most important people in the world. America has a lot of families that are in trouble today. There's been a lot of talk about family values in this campaign. I know a lot about that. I was born to a widowed mother who gave me family values, and grandparents. I've seen the family values of my people in Arkansas. I've seen the family values of all these people in America who are out there killing themselves, working harder for less in a country that's had the worst economic years in 50 years and the first decline in industrial production ever. I think the President owes it to family values to show that he values America's families. Whether they're people on welfare, you're trying to move from welfare to work; the working poor, whom I think deserve a tax break to lift them above poverty if they've got a child in the house and working 40 hours a week; working families, who deserve a fair tax system and the opportunity for constant retraining. They deserve a strong economy. I think they deserve a family and medical leave act. Seventy-two other nations have been able to do it. Mr. Bush vetoed it twice because he says we can't do something 72 other countries do, even though there was a small business exemption. So with all the talk about family values, I know about family values. I wouldn't be here without them. The best expression of my family values is that tonight's my 17th wedding anniversary, and I'd like to close my question by just wishing my wife a happy anniversary and thanking my daughter for being here. Mr. Lehrer. President Bush, one minute. President Bush. Well, I would say that one meeting that made a profound impression on me was when the mayors of the big cities, including the Mayor of Los Angeles, a Democrat, came to see me, and they unanimously said the decline in urban America stems from the decline in the American family. So I do think we need to strengthen family. When Barbara holds an AIDS baby, she's showing a certain compassion for family. When she reads to children, the same thing. I believe that discipline and respect for the law, all of these things, should be taught to children, not in our schools but families have to do that. I'm appalled at the high, outrageous numbers of divorces. It's happened in families; it's happened in ours. But it's gotten too much, and I just think that we ought to do everything we can to respect the American family. It can be a single-parent family. Those mothers need help. One way to do it is to get these deadbeat fathers to pay their obligations to these mothers. That will help strengthen the American family. And there's a whole bunch of other things that I can't click off in this short period of time. Mr. Lehrer. Mr. Perot, you have one minute. Mr. Perot. If I had to solve all the problems that face this country and I could be granted one wish as we started down the trail to rebuild the job base, the schools, and so on and so forth, I would say a strong family unit in every home, where every child is loved, nurtured, and encouraged. A little child, before they're 18 months, learns to think well of himself or herself, or poorly. They develop a positive or negative self-image. At a very early age, they learn how to learn. If we have children who are not surrounded with love and affection -- see, I look at my grandchildren and wonder if they'll ever learn to walk because they're always in someone's arms. I think, my gosh, wouldn't it be wonderful if every child had that love and support, but they don't. We will not be a great country unless we have a strong family unit in every home. And I think you can use the White House as a bully pulpit to stress the importance of these little children, particularly in their young and formative years, to mold these little precious pieces of clay so that they, too, can live rich, full lives when they're grown. Mr. Lehrer. New question, 2-minute answer, goes to President Bush. Sandy will ask it. Legalization of Drugs Mr. Vanocur. Mr. President, there's been a lot of talk about Harry Truman in this campaign, so much so that I think tomorrow I'll wake up and see him named as the next commissioner of baseball. [Laughter] President Bush. We could use one. Mr. Vanocur. The thing that Mr. Truman didn't have to deal with is drugs. Americans are increasingly alarmed about drug-related crimes in cities and suburbs, and your administration is not the first to have grappled with this. Are you at all of a mind that maybe it ought to go to another level, if not to what's advocated by William F. Buckley, Jr., and Milton Friedman, legalization, somewhere between there and where we are now? President Bush. No. I don't think that's the right answer. I don't believe legalizing narcotics is the answer. I just don't believe that's the answer. I do believe that there's some fairly good news out there. The use of cocaine, for example, by teenagers is dramatically down. But we've got to keep fighting on this war against drugs. We're doing a little better in interdiction. Many of the countries that used to say, "Well, this is a United States problem. If you'd get the demand down, then we wouldn't have the problem," are working cooperatively with the DEA and other law -- the military. We're using the military more now in terms of interdiction. Our funding for recovery is up, recovering the addicts. Where we're not making the progress, Sander, is in -- we're making it in teenagers. And thank God, because I thought what Ross said was most appropriate about these families and these children. But where we're not making it is with the confirmed addicts. I'll tell you one place that's working well, and that is the private sector, Jim Burke and this task force that he has. You may know about it. Tell the American people, but this man said, "I'll get you a million dollars a day in pro bono advertising," something that's very hard for the Government to do. He went out and he did it, and people are beginning to educate through this program, teaching these kids you shouldn't use drugs. So we're still in the fight. But I must tell you, I think legalization of narcotics or something of that nature, in the face of the medical evidence, would be totally counterproductive. And I oppose it, and I'm going to stand up and continue to oppose it. Mr. Lehrer. Mr. Perot, one minute. Mr. Perot. Any time you think you want to legalize drugs, go to a neonatal unit, if you can get in. They are between 100 and 200 percent capacity up and down the East Coast, and the reason is crack babies being born. Baby's in the hospital 42 days; typical cost to you and me is $125,000. Again and again and again, the mother disappears in 3 days, and the child becomes a ward of the State because he's permanently and genetically damaged. Just look at those little children, and if anybody can even think about legalizing drugs, they've lost me. Now, let's look at priorities. We went on the Libyan raid, you remember that one, because we were worried to death that Qadhafi might be building up chemical weapons. We've got chemical warfare being conducted against our children on the streets in this country all day, every day, and we don't have the will to stamp it out. Again, if I get up there, if you send me, we're going to have some blunt talks about this. We're really going to get out in the trenches and say, "Is this one you want to talk about or fix?" Because talk won't do it, folks. There are guys that couldn't get a job third shift in a Dairy Queen, driving BMW's and Mercedes, selling drugs. These old boys are not going to quit easy. Mr. Lehrer. Governor Clinton, one minute. Governor Clinton. Like Mr. Perot, I have held crack babies in my arms. But I know more about this, I think, than anybody else up here because I have a brother who's a recovering drug addict. I'm very proud of him. But I can tell you this: If drugs were legal, I don't think he'd be alive today. I am adamantly opposed to legalizing drugs. He is alive today because of the criminal justice system. That's a mistake. What should we do? First, we ought to prevent more of this on the street. Thirty years ago there were three policemen for every crime. Now there are three crimes for every policeman. We need 100,000 more police on the street. I have a plan for that. Secondly, we ought to have treatment on demand. Thirdly, we ought to have boot camps for first-time nonviolent offenders so they can get discipline and treatment and education and get reconnected to the community, before they are severed and sent to prison where they can learn how to be first-class criminals. There is a crime bill that, lamentably, was blocked from passage once again, mostly by Republicans in the United States Senate, which would have addressed some of these problems. That crime bill is going to be one of my highest priorities next January if I become President. Mr. Lehrer. Next question is to you, Mr. Perot. You have 2 minutes to answer it, and John will ask it. Racial Harmony Mr. Mashek. Mr. Perot, racial division continues to tear apart our great cities, the last episode being this spring in Los Angeles. Why is this still happening in America? And what would you do to end it? Mr. Perot. This is a relevant question here tonight. First thing I'd do is during political campaigns, I would urge everybody to stop trying to split this country into fragments and appeal to the differences between us, and then wonder why the melting pot's all broken to pieces after November the 3d. We are all in this together. We ought to love one another, because united teams win and divided teams lose. If we can't love one another, we ought to get along with one another. If you can't get there, just recognize we're all stuck with one another, because nobody's going anywhere. Right? [Laughter] Now, that ought to get everybody back up to let's get along together and make it work. Our diversity is a strength. We've turned it into a weakness. Now, again, the White House is a bully pulpit. I think whoever's in the White House should just make it absolutely unconscionable and inexcusable. And if anybody's in the middle of a speech at, you know, one of these conventions, I would expect the candidate to go out and lift him off the stage if he starts preaching hate, because we don't have time for it. Our differences are our strengths. We have got to pull together. In athletics, we know it. You see, divided teams lose; united teams win. We have got to unite and pull together. And there's nothing we can't do. But if we sit around blowing all this energy out the window on racial strife and hatred, we are stuck with a sure loser, because we have been a melting pot. We're becoming more and more of a melting pot. Let's make it a strength, not a weakness. Mr. Lehrer. Governor Clinton, one minute. Governor Clinton. I grew up in the segregated south, thankfully raised by a grandfather with almost no formal education but with a heart of gold who taught me early that all people were equal in the eyes of God. I saw the winds of hatred divide people and keep the people of my State poorer than they would have been, spiritually and economically. I've done everything I could in my public life to overcome racial divisions. We don't have a person to waste in this country. We are being murdered economically because we have too many dropouts. We have too many low-birth weight babies. We have too many drug addicts as kids. We have too much violence. We are too divided by race, by income, by region. I have devoted a major portion of this campaign to going across this country and looking for opportunities to go to white groups and African-American groups and Latino groups, Asian-American groups and say the same thing: If the American people cannot be brought together, we can't turn this country around. If we can come together, nothing, nothing can stop us. Mr. Lehrer. Mr. President, one minute. President Bush. Well, I think Governor Clinton is committed. I do think it's fair to note -- he can rebut it -- that Arkansas is one of the few States that doesn't have any civil rights legislation. I've tried to use the White House as a bully pulpit, speaking out against discrimination. We passed two very forward-looking civil rights bills. It's not going to be all done by legislation, but I do think that you need to make an appeal every time you can to eliminate racial divisions and discrimination. And I'll keep on doing that and pointing to some legislative accomplishment to back it up. I have to take 10 seconds here at the end -- the red light isn't on yet -- to say to Ross Perot, please don't say to the DEA agents on the street that we don't have the will to fight drugs. Please, I have watched these people. The same for our local law enforcement people; we're backing them in every way we possibly can. But maybe you meant that some in the country don't have the will to fight it. But those that are out there on the front line -- as you know; you've been a strong backer of law enforcement; really, I just want to clear that up -- have the will to fight it. And frankly, some of them are giving their lives. Mr. Lehrer. Time, Mr. President. All right, let's go now to another subject, the subject of health. The first question for 2 minutes is to President Bush, and John will ask it. AIDS Mr. Mashek. Mr. President, yesterday tens of thousands of people paraded past the White House to demonstrate their concern about the disease AIDS. A celebrated member of your Commission, Magic Johnson, quit, saying that there was too much inaction. Where is this widespread feeling coming from that your administration is not doing enough about AIDS? President Bush. Coming from the political process. We have increased funding for AIDS. We've doubled it, on research and on every other aspect of it. My request for this year was $4.9 billion for AIDS, 10 times as much for AIDS victim as per cancer victim. I think that we're showing the proper compassion and concern. So I can't tell you where it's coming from, but I am very much concerned about AIDS, and I believe that we've got the best researchers in the world out there at NIH working the problem. We're funding them. I wish there was more money, but we're funding them far more than any time in the past. We're going to keep on doing that. I don't know, I was a little disappointed in Magic, because he came to me and I said, "Now, if you see something we're not doing, get ahold of me, call me, let me know." He went to one meeting, and then we heard that he was stepping down. So he's been replaced by Mary Fisher, who electrified the Republican Convention by talking about the compassion and the concern that we feel. It was a beautiful moment. And I think she'll do a first-class job on that Commission. So I think the appeal is, yes, we care. The other thing is, part of AIDS, it's one of the few diseases where behavior matters. And I once called on somebody, "Well, change your behavior. If the behavior you're using is prone to cause AIDS, change the behavior." The next thing I know, one of these ACT-UP groups is out saying, "Bush ought to change his behavior." You can't talk about it rationally. The extremes are hurting the AIDS cause. To go into a Catholic mass in a beautiful cathedral in New York under the cause of helping in AIDS and start throwing condoms around in the mass, I'm sorry, I think it sets back the cause. We cannot move to the extreme. We've got to care. We've got to continue everything we can at the Federal and the local level. Barbara, I think, is doing a superb job in destroying the myth about AIDS. All of us are in this fight together. All of us care. Do not go to the extreme. Mr. Lehrer. One minute, Mr. Perot. Mr. Perot. First, I think Mary Fisher was a great choice. We're lucky to have her heading the Commission. Secondly, I think one thing, that if I were sent to do the job, I would sit down with FDA, look exactly where we are. Then I would really focus on let's get these things out. If you're going to die, you don't have to go through this 10-year cycle that FDA goes through on new drugs. Believe me, people with AIDS are more than willing to take that risk. We could be moving out to the human population a whole lot faster than we are on some of these new drugs. So I think we can expedite the problem there. Let me go back a minute to racial divisiveness. All-time low in our country was the Judge Thomas-Anita Hill hearings, and those Senators ought to be hanging their heads in shame for what they did there. Second thing, there are not many times in your life when you get to talk to a whole country, but let me just say this to all of America: If you hate people, I don't want your vote. That's how strongly I feel about it. Mr. Lehrer. Governor Clinton, one minute. Governor Clinton. Over 150,000 Americans have died of AIDS. Well over a million and a quarter Americans are HIV-positive. We need to put one person in charge of the battle against AIDS to cut across all the agencies that deal with it. We need to accelerate the drug approval process. We need to fully fund the act named for that wonderful boy, Ryan White, to make sure we're doing everything we can on research and treatment. The President should lead a national effort to change behavior to keep our children alive in the schools, responsible behavior to keep people alive. This is a matter of life and death. I've worked in my State to reduce teen pregnancy and illness among children. And I know it's tough. The reason Magic Johnson resigned from the AIDS Commission is because the statement you heard tonight from Mr. Bush is the longest and best statement he's made about it in public. I'm proud of what we did at the Democratic Convention, putting two HIV-positive people on the platform, and I'm proud of the leadership that I'm going to bring to this country in dealing with the AIDS crisis. Mr. Lehrer. New question for Mr. Perot. You have 2 minutes to answer, and Ann will ask it. Entitlement Programs Ms. Compton. Mr. Perot, even if you've got what people say are the guts to take on changes in the most popular and the most sacred of the entitlements, Medicare, people say you haven't a prayer of actually getting anything passed in Washington. Since the President isn't a Lone Ranger, how in the world can you make some of those unpopular changes? Mr. Perot. Two ways. Number one, if I get there, it will be a very unusual and historical event because -- [laughter] -- because the people, not the special interests, put me there. I will have a unique mandate. I have said again and again, and this really upsets the establishment in Washington, that we're going to inform the people in detail on the issues through an electronic town hall so that they really know what's going on. They will want to do what's good for our country. Now, all these fellows with thousand-dollar suits and alligator shoes running up and down the Halls of Congress that make policy now, the lobbyists, the PAC guys, the foreign lobbyists, what have you, they'll be over there in the Smithsonian -- [laughter] -- because we're going to get rid of them. The Congress will be listening to the people. And the American people are willing to have fair, shared sacrifice. They're not as stupid as Washington thinks they are. The American people are bright, intelligent, caring, loving people who want a great country for their children and grandchildren. They will make those sacrifices. So I welcome that challenge. And just watch, because if the American people send me there, we'll get it done. Now, everybody will faint in Washington. They've never seen anything happen in that town. [Laughter] This is a town where the White House says, "Congress did it." Congress says, "The White House did it." And I'm sitting there and saying, "Well, who else could be around?" And then when they get off by themselves, they said, "Nobody did it." [Laughter] And yet, the cash register is empty. And it used to have our money, the taxpayers' money, in it, and we didn't get the results. We'll get it done. Mr. Lehrer. Governor, one minute. Governor Clinton. Ross, that's a great speech, but it's not quite that simple. [Laughter] I mean, look at the facts. Both parties in Washington, the President and the Congress, have cut Medicare. The average senior citizen is spending a higher percentage of income on health care today than they were in 1965 before Medicare came in. The President's got another proposal to require them to pay $400 a year more for the next 5 years. But if you don't have the guts to control cost by changing the insurance system and taking on the bureaucracies and the regulation of health care in the private and public sector, you can't fix this problem. Costs will continue to spiral. Just remember this, folks: A lot of folks on Medicare are out there every day making the choice between food and medicine. Not poor enough for Medicare, Medicaid; not wealthy enough to buy their medicine. I've met them, people like Mary Annie and Edward Davis of Nashua, New Hampshire, all over this country. They cannot even buy medicine. So let's be careful. When we talk about cutting health care costs, let's start with the insurance companies and the people that are making a killing instead of making our people healthy. Mr. Lehrer. One minute, President Bush. President Bush. Well, first place I'd like to clear up something, because every 4 years the Democrats go around and say, "Hey, Republicans are going to cut Social Security and Medicare." They've started it again. I am the President that stood up and said, "Don't mess with Social Security." And I'm not going to, and we haven't. We are not going to go after the Social Security recipient. I have one difference with Mr. Perot on that because I don't think we need to touch Social Security. What we do need to do, though, is control the growth of these mandatory programs. And Ross properly says, "Okay, there's some pain in that." But Governor Clinton refuses to touch that, simply refuses. So what we've got to do is control it, the growth. Let it grow for inflation; let it grow for the amount of new people added, population. And then hold the line. I believe that is the way you get the deficit down, not by the tax-and-spend program that we hear every 4 years, whether it's Mondale, Dukakis, whoever else it is. I just don't believe we ought to do that. So hold the line on Social Security, and put a cap on the growth of the mandatory program. Mr. Lehrer. New question. It is for Governor Clinton, 2-minute answer. Sandy will ask it. Health Care Costs Mr. Vanocur. Governor Clinton, Ann Compton has brought up Medicare. I remember in 1965 when Wilbur Mills of Arkansas, the chairman of Ways and Means, was pushing it through the Congress. The charge against it was it's socialized medicine. One, you never -- -- Governor Clinton. Mr. Bush made that charge. Mr. Vanocur. Well, he served with him 2 years later in 1967 where I first met him. The second point, though, is that it is now skyrocketing out of control. People want it; we say it's going bonkers. Is not the Oregon plan, applied to Medicaid rationing, the proper way to go, even though the Federal Government last August ruled that violated the Americans with Disabilities Act of 1990? Governor Clinton. I thought the Oregon plan should at least have been allowed to be tried because at least the people in Oregon were trying to do something. Let me go back to the main point, Sandy. Mr. Bush is trying to run against Lyndon Johnson and Jimmy Carter and everybody in the world but me in this race. I have proposed a managed competition plan for health care. I will say again: You cannot control health care costs simply by cutting Medicare. Look what's happened. The Federal Government has cut Medicare and Medicaid in the last few years. States have cut Medicaid; we've done it in Arkansas under budget pressures. But what happens? More and more people get on the rolls as poverty increases. If you don't control the health care costs of the entire system, you cannot get control of it. Look at our program. We've set up a national ceiling on health care costs tied to inflation and population growth set by health care providers, not by the Government. We provide for managed competition, not Government models, in every State, and we control private and public health care costs. Now, just a few days ago, a bipartisan commission of Republicans and Democrats, more Republicans than Democrats, said my plan will save the average family $1,200 a year more than the Bush plan will by the year 2000; $2.2 trillion in the next 12 years; $400 billion a year by the end of this decade. I've got a plan to control health care costs. But you can't just do it by cutting Medicare. You have to take on the insurance companies, the bureaucracies, and you have to have cost controls, yes. But keep in mind, we are spending 30 percent more on health care than any country in the world, any other country. Yet, we have 35 million people uninsured. We have no preventive and primary care. The Oregon plan is a good start if the Federal Government is going to continue to abandon its responsibilities. I say if Germany can cover everybody and keep costs under inflation, if Hawaii can cover 98 percent of their people at lower health care costs than the rest of us, if Rochester, New York, can do it with two-thirds of the cost of the rest of us, America can do it, too. I'm tried of being told we can't. I say we can. We can do better, and we must. Mr. Lehrer. President Bush, one minute. President Bush. Well, I don't have time in 30 seconds or one minute to talk about our health care reform plan. The Oregon plan made some good sense, but it's easy to dismiss the concerns of the disabled. As President, I have to be sure that those waivers which we're approving all over the place are covered under the law. Maybe we can work it out. But the Americans for Disabilities Act, speaking about sound and sensible civil rights legislation, was the foremost piece of legislation passed in modern times. So we do have something more than a technical problem. Governor Clinton clicked off the things: You've got to take on insurance companies and bureaucracies. He failed to take on somebody else, the malpractice suit people, those that bring these lawsuits against -- these frivolous trial lawyers' lawsuits that are running costs of medical care up by $25 billion to $50 billion. He refuses to put anything -- controls on these crazy lawsuits. If you want to help somebody, don't run the costs up by making doctors have to have five or six tests where one would do for fear of being sued, or have somebody along the highway not stop to pick up a guy and help him because he's afraid a trial lawyer will come along and sue him. We're suing each other too much and caring for each other too little. Mr. Lehrer. Mr. Perot, one minute. Mr. Perot. We've got the most expensive health care system in the world. It ranks behind 15 other nations when we come to life expectancy and 22 other nations when we come to infant mortality. So we don't have the best. Pretty simple, folks, if you're paying more and you don't have the best, if all else fails go copy the people who have the best who spend less, right? But we can do better than that. Again, we've got plans lying all over the place in Washington. Nobody ever implements them. Now I'm back to square one: If you want to stop talking about it and do it, then I'll be glad to go up there and we'll get it done. But if you just want to keep the music going, just stay traditional this next time around, and 4 years from now you'll have everybody blaming everybody else for a bad health care system. Talk is cheap. Words are plentiful. Deeds are precious. Let's get on with it. Mr. Lehrer. And that's exactly what we're going to do. That was, in fact, the final question and answer. We're now going to move to closing statements. Each candidate will have up to 2 minutes. The order, remember, was determined by a drawing. And Mr. Perot, you were first. Closing Statements Mr. Perot. Well, it's been a privilege to be able to talk to the American people tonight. I make no bones about it: I love this country. I love the principle it's founded on. I love the people here. I don't like to see the country's principles violated. I don't like to see the people in a deteriorating economy and a deteriorating country because our Government has lost touch with the people. The people in Washington are good people; we just have a bad system. We've got to change the system. It's time to do it because we have run up so much debt that time is no longer our friend. We've got to put our house in order. When you go to bed tonight, look at your children. Think of their dreams. Think of your dreams as a child. And ask yourself, "Isn't it time to stop talking about it? Isn't it time to stop creating images? Isn't it time to do it?" Aren't you sick of being treated like an unprogrammed robot? Every 4 years they send you all kinds of messages to tell you how to vote and then go back to business as usual. They told you at the tax and budget summit that if you agreed to a tax increase, we could balance the budget. They didn't tell you that that same year they increased spending $1.83 for every dollar we increased taxes. That's Washington in a nutshell right there. In the final analysis, I'm doing this for your children, when you look at them tonight. There's another group that I feel very close to, and these are the men and women who fought on the battlefield, the children, the families of the ones who died, the people who left parts of their bodies over there. I'd never ask you to do anything for me, but I owe you this, and I'm doing it for you. I can't tell you what it means to me at these rallies when I see you and you come up, and the look in your eyes. I know how you feel, and you know how I feel. And then I think of the older people who are retired. They grew up in the Depression. They fought and won World War II. We owe you a debt we can never repay you. And the greatest repayment I can ever give is to recreate the American dream for your children and grandchildren. I'll give it everything I have if you want me to do it. Mr. Lehrer. Governor Clinton, your closing statement. Governor Clinton. I'd like to thank the people of St. Louis and Washington University, the Presidential Debate Commission, and all those who made this night possible. And I'd like to thank those of you who are watching. Most of all, I'd like to thank all of you who have touched me in some way over this last year, all the thousands of you whom I've seen. I'd like to thank the computer executives and the electronics executives in Silicon Valley, two-thirds of whom are Republicans, who said they wanted to sign on to a change to create a new America. I'd like to thank the hundreds of executives who came to Chicago, a third of them Republicans, who said they wanted a change. I'd like to thank the people who started with Mr. Perot who have come on to help our campaign. I'd like to thank all the folks around America that no one ever knows about: the woman who was holding the AIDS baby she adopted in Cedar Rapids, Iowa, who asked me to do something more for adoption; the woman who stopped along the road in Wisconsin and wept because her husband had lost his job after 27 years; all the people who are having a tough time; and the people who are winning, but who know how desperately we need to change. This debate tonight has made crystal clear a challenge that is as old as America: the choice between hope and fear, change or more of the same; the courage to move into a new tomorrow or to listen to the crowd who says, "Things could be worse." Mr. Bush has said some very compelling things tonight that don't quite square with the record. He was President for 3 years before he proposed a health care plan that still hasn't been sent to Congress in total; 3 years before an economic plan; and he still didn't say tonight that that tax bill he vetoed raised taxes only on the rich and gave the rest of you a break, but he vetoed it anyway. I offer a new direction: Invest in American jobs, American education, control health care costs, bring this country together again. I want the future of this country to be as bright and brilliant as its past, and it can be if we have the courage to change. Mr. Lehrer. President Bush, your closing statement. President Bush. Well, let me tell you a little what it's like to be President. In the Oval Office, you can't predict what kind of crisis is going to come up. You have to make tough calls. You can't be on one hand this way and one hand another. You can't take different positions on these difficult issues. Then you need a philosophical -- I'd call it a philosophical underpinning; mine for foreign affairs is democracy and freedom. Look at the dramatic changes around the world. The cold war is over. The Soviet Union is no more, and we're working with a democratic country. Poland, Hungary, Czechoslovakia, the Baltics are free. Take a look at the Middle East. We had to stand up against a tyrant. The United States came together as we haven't in many, many years. We kicked this man out of Kuwait. In the process, as a result of that will and that decision and that toughness, we now have ancient enemies talking peace in the Middle East. Nobody would have dreamed it possible. I think the biggest dividend of making these tough calls is the fact that we are less afraid of nuclear war. Every parent out there has much less worry that their kids are going to be faced with nuclear holocaust. All this is good. On the domestic side, what we must do is have change that empowers people, not change for the sake of change, tax and spend. We don't need to do that anymore. What we need to do is empower people. We need to invest and save. We need to do better in education. We need to do better in job retraining. We need to expand our exports, and they're going very, very well indeed. We need to strengthen the American family. I hope as President that I've earned your trust. I've admitted it when I make a mistake, but then I go on and help try to solve the problems. I hope I've earned your trust, because a lot of being President is about trust and character. And I ask for your support for 4 more years to finish this job. Thank you very, very much. Mr. Lehrer. Don't go away yet. I just want to thank the three panelists and thank the three candidates for participating, President Bush, Governor Clinton, and Mr. Perot. They will appear again together on October the 15th and again on October 19th. Next Tuesday there will be a debate among the three candidates for Vice President. And for now, from Washington University in St. Louis, Missouri, I'm Jim Lehrer. Thank you, and good night.
