# Democratic Candidates Debate in Myrtle Beach, South Carolina

**Date:** January 21, 2008
**Source:** https://www.presidency.ucsb.edu/documents/democratic-presidential-candidates-debate-myrtle-beach-south-carolina

---

PARTICIPANTS: Senator Hillary Clinton (NY); Former Senator John Edwards (NC); and Senator Barack Obama (IL) MODERATORS: Wolf Blitzer (CNN); Suzanne Malveaux (CNN); and Joe Johns (CNN) JOHNS: Senator Clinton, good evening. The number-one issue for Americans of both parties is the economy, and today the news is simply not good. Markets around the world are in a tailspin because of fears of a U.S. recession. So far this year, the Dow has lost nearly 9 percent. How much money would your stimulus plan put in the pockets of the average South Carolinian? CLINTON: Well, Joe, I'm glad you started with the economy, because that is the number-one issue. What's been happening in the markets, what's been happening with the home mortgage crisis, $100-a-barrel oil, so many of the issues that are really at the kitchen tables of Americans today and what they're talking to me about. We have to stimulate the economy. I began calling for some kind of economic action plan back at the beginning of December. I have a package of $110 billion; $70 billion of that would go towards dealing with the mortgage crisis, which, unfortunately, I don't think that President Bush has really taken seriously enough. I would have a moratorium on home foreclosures for 90 days to try to help families work it out so that they don't lose their homes. We're in danger of seeing millions of Americans become basically, you know, homeless and losing the American dream. I want to have an interest rate freeze for five years, because these adjustable-rate mortgages, if they keep going up, the problem will just get compounded. And we need more transparency in the market. Then, I think we need to give people about $650, if they qualify -- which will be millions of people -- to help pay their energy bills this winter. You know, there are so many people on fixed incomes and working people who are not going to be able to afford the spike in energy costs. We need to make sure that we start jumpstarting the jobs in this country again. That's why I want to put money into clean energy jobs, green-collar jobs, and also make sure we have a fund that will help communities deal with the consequences of the home foreclosure crisis and make sure the unemployment system is up to the task. And then we will have money for rebates, but let's make them the right rebates. Everything we know about President Bush's plans would leave 50 million to 70 million Americans out, because a lot of our seniors on fixed incomes don't pay income taxes. But that doesn't mean they're immune from the energy costs and the health care costs and everything else that's going up around them. And we have a huge number of working people who thankfully don't pay income tax. They pay payroll tax. They pay a lot of other taxes. President Bush's plan would do nothing to help them. But thankfully we've got leaders of the Congressional Black Caucus here who are going to make sure that we get the right kind of stimulus. And that's what the Democrats are going to support. It's imperative we do it. It's a part of economic justice, which on Dr. King's holiday is part of his unfinished legacy. BLITZER: All right. Senator Obama? (APPLAUSE) OBAMA: Well, we do meet on the King holiday. And I think it's important to remember that, in the march on Washington, where Dr. King always talks about -- or it's always repeated, the dream speech that is so famous -- that march was for jobs, as well as justice. And, unfortunately, we have not made the kind of progress that we need in having a balanced economy, and George Bush has made it worse. George Bush has consistently skewed our tax code to the wealthy. He has squandered billions of dollars in a war that I believe should never have been authorized and should have never been waged. (APPLAUSE) We have not made the investments that are needed in our school system. You travel around South Carolina along the corridor of shame, and you've got children who are going to schools that were built in the 1800s. And they are not able to compete in an international economy. So it is absolutely critical right now to give a stimulus to the economy. And Senator Clinton mentioned tax rebates. That wasn't the original focus of her plan. I think recently she has caught up with what I had originally said, which is we've got to get taxes into the -- tax cuts into the pockets of hard-working Americans right away. And it is important for us to make sure that they are not just going to the wealthy. They should be going to folks who are making $75,000 a year or less, and they should be going to folks who only pay payroll tax, but typically are not paying income tax. If we do that, then not only can we stimulate the economy, those are the folks who are most likely to spend money right away. BLITZER: Do you agree with her, $650 is a good number for a tax rebate? OBAMA: Well, I think that we are going to have to get some immediate money. What I do is I say, for a typical family, $500 for a tax rebate per family. But also, for senior citizens, get a supplement to their Social Security check, because they get that every month. We know exactly how to do it. And that would provide seniors all across the country right away some money to help pay for their heating bills and other expenses that they've got right now. BLITZER: Correct me if I'm wrong, Senator Edwards. Your plan does not call for a tax rebate, does it? EDWARDS: No, that's exactly right. Can I start by saying how proud I am to be here tonight, a debate sponsored by the Congressional Black Caucus on Dr. King's holiday? And particularly on this night, when we're honoring the legacy of Dr. King, central to his work was the idea of fighting for real equality between the races, fighting to end poverty in America, his famous Poor People's Campaign, which he was engaged in at the time of his death, fighting for garbage workers, actually, in Memphis. And the chasm between the rich and the poor in America is wide. It is getting worse. The rich are get richer. And we've added five million people to the poverty rolls in just over the course of the last seven years, which is... BLITZER: But what about the stimulus package? EDWARDS: Here's what we should do. That's why I'm getting to this. What Bush does is he leaves 50 million -- as Hillary pointed out -- 50 million Americans. They're low-income Americans and moderate-income Americans. They are completely left out of the stimulus package. If we're actually going to deal with the legacy of Dr. King, if we're going to deal with this issue of poverty -- and I have a comprehensive plan to do that, it is the cause of my life, to end poverty in this country -- we also have to include all Americans in this stimulus plan. Now, one difference between what I have proposed and what my two colleagues have proposed is I have done something that not only stimulates the economy, but creates long-term benefits, investment in green infrastructure, which creates jobs. Instead of just getting money out in the short term, this will actually create jobs over the long term, create green infrastructure. Yes, we need to do something about the mortgage crisis. I want to mention one last thing. There is one other issue that was mentioned in passing by the two of them, which is the issue of jobs. And there is a difference between myself and my colleagues on this issue of jobs, because they both supported the Peru trade deal. My view is the Peru trade deal was similar to NAFTA. And this is crucial to the state of South Carolina... BLITZER: But... EDWARDS: ... no, no -- and crucial to the state of the South Carolina and jobs in South Carolina. South Carolina has been devastated by NAFTA and trade deals like NAFTA. BLITZER: I just want to be precise. What you're proposing are really long-term objectives. In terms of a short-term stimulus package, you disagree with them on an immediate tax rebate. EDWARDS: No, no. What I'm saying is if we do what we should do to green the economy, if we change our unemployment insurance laws, modernize them to make them available to more people, to more Americans, if we in fact give help to the states, which gets money straight into the economy and we deal with the mortgage crisis in a serious way with a home rescue fund to provide transitional financing for those people who are about to lose their homes, all those things will stimulate the economy. BLITZER: I'll let both of you respond, but let me let Senator Obama respond first. (APPLAUSE) OBAMA: Let me just respond to a couple of things. I think the idea of bringing jobs is important, which is why that's central to my energy plan. But, Wolf, you're exactly right, that is a long-term agenda. That is not going to deal with the immediate crisis we have right now. You've got the European markets dropped 5 percent. The expectation is that the Dow Jones tomorrow may do the same. We could be sliding into an extraordinary recession unless we stimulate the economy immediately. That's point number one. Point number two, on trade, John is exactly right that you travel around South Carolina and you see the textile mills that John's father worked in closed, all over the region. And it is absolutely true that NAFTA was a mistake. I know that Hillary on occasion has said -- just last year said this was a boon to the economy. I think it has been devastating, because our trade agreements did not have labor standards and environmental standards that would assure that workers in the U.S. were getting a square deal. But the only thing I want to differ on John is this whole notion of Peru. The Peru trade deal had labor and environmental agreements in it. Peru is an economy the size of New Hampshire. Over 90 percent of the goods coming from Peru already come in under various free trade agreements. And, John, you voted for permanent trade relations with China, which I think anybody who looks at how we structure trade in this country would tell you has been the biggest beneficiary and the biggest problem that we have with respect to trade, particularly because they're still manipulating the currency. BLITZER: I'll let you respond, but, Senator Clinton, I want to get back to the issue of an immediate stimulus for the economy. CLINTON: That's what I want to get back to. BLITZER: Because who knows what the markets are going to be like tomorrow and there are a lot of people out there who are suffering already. But go ahead and respond. CLINTON: Well, I want to just clarify a couple of points. My original plan was $70 billion in spending with a $40 billion contingency that was part of the original plan, in order to have that money available for tax rebates. I hope that we could do it through spending, and here's why: I don't want to necessarily open up the tax code while we've got Republicans in the Senate who are going to try to come back and open up making Bush's tax cuts permanent. (APPLAUSE) I understand that that's a real risk. So I was hoping to be able to do it through spending, but the crisis has gotten too deep, and what happened in the markets globally today is a huge wakeup call. The president should convene the working group on financial markets. He should ask the secretary of treasury to do this immediately. I know that there's been talking going on, but the president's proposed stimulus package is not adequate. It is too little too late and it doesn't give enough money to the people who are hardest hit by the increased costs in energy and everything else. (APPLAUSE) As a further point, I do believe that the green-collar job piece of this is important. That's why I have $5 billion to do it. There are programs already. Oakland, California, Mayor Dellums is working to have a green-collar job program. We could put hundreds and hundreds of young people to work right now, putting solar panels in, insulating homes. That would give them jobs and it would move us more quickly to a green economy. And I think that if you look at this from a jobs and justice, a stimulation and long-term planning effort, we need to lay down the markers now. And that's why the Congress, under the leadership of a lot of the people who are chairs of committees and subcommittees who are here today are going to play a major role in this. And we've got to hold the line against President Bush with his ill-advised approach to stimulating the economy. BLITZER: All right. We're staying on topic. We're staying on this subject, but I want to ask Suzanne Malveaux to ask a question and then all of you will be able to weigh... EDWARDS: You have to give me a chance to respond to Senator Obama. BLITZER: All right, go ahead, respond quickly and then Suzanne. EDWARDS: Thank you. Well, first of all, what I have proposed for green-collar jobs will create jobs within 30 or so days, so we will have an immediate impact on the economy and stimulate the economy. Second, no one has to explain to me what these trade deals have done to South Carolina, to North Carolina. My father, who's sitting right out there in the audience, worked in the mills for 36 years and we have seen what these trade deals have done to people who have worked hard all their lives. EDWARDS: And the problem with Peru, Barack, is you are leaving the enforcement of environmental and labor regulations in the hands of George Bush. I wouldn't trust George Bush to enforce anything, certainly not trade obligations. (APPLAUSE) BLITZER: All right. Ten seconds, go ahead. (APPLAUSE) OBAMA: Well, the only point I would make is that in a year's time, it'll be me who's enforcing them. (APPLAUSE) And so we're going to make sure that the right thing is being done. And, John, you tell an extraordinarily powerful story. I mean, you understand what's happened with respect to trade here and I think it is powerful when you talk about it. But keep in mind, I first moved to Chicago to be a community organizer with churches who were trying to deal with the devastation of steel plants that had closed in that region. And so I spent 3.5 years working alongside folks who had lost their jobs. And I know what it's like for families to have put their life and their heart and soul into a company, building profits for shareholders, and then suddenly they had the rug pulled out from under them. Not only have they lost their job, they've lost their health care, they've lost their pension benefits. And it is absolutely critical for us to understand that NAFTA was an enormous problem. The permanent trade relations with China, without some of the enforcement mechanisms that were in there, that you voted for, was also a significant problem. And we've got to all move forward as Democrats to make sure that we've got trade deals that work for working people and not just for corporate profits. BLITZER: All right. Suzanne Malveaux, go ahead. (APPLAUSE) MALVEAUX: I'd like to follow-up with Senator Obama. It was just a few days ago that Senator Clinton asserted that she was the strongest candidate when it comes to fiscal responsibility. She says that the new programs that she proposes she essentially can pay for. She says that you have failed in that regard in the tune of some $50 billion worth of new programs that you cannot account for. How do you respond to that charge? OBAMA: What she said wasn't true. We account for every single dollar that we propose. Now, this, I think, is one of the things that's happened during the course of this campaign, that there's a set of assertions made by Senator Clinton, as well as her husband, that are not factually accurate. And I think that part of what the people are looking for right now is somebody who's going to solve problems and not resort to the same typical politics that we've seen in Washington. (APPLAUSE) That is something that I hear all across the country. So when Senator Clinton says -- or President Clinton says that I wasn't opposed to the war from the start or says it's a fairytale that I opposed the war, that is simply not true. When Senator Clinton or President Clinton asserts that I said that the Republicans had had better economic policies since 1980, that is not the case. Now, the viewers aren't concerned with this kind of back-and-forth. What they're concerned about is who's actually going to help the get health care, how are they going to get their kids... (APPLAUSE) ... going to college, and that's the kind of campaign I've tried to run. I think that's the kind of campaign we should all try to run. (APPLAUSE) CLINTON: Well, I couldn't agree more. But I do think that your record and what you say does matter. And when it comes to... (APPLAUSE) ... a lot of the issues that are important in this race, it is sometimes difficult to understand what Senator Obama has said, because as soon as he is confronted on it, he says that's not what he meant. The facts are that he has said in the last week that he really liked the ideas of the Republicans over the last 10 to 15 years, and we can give you the exact quote. Now, I personally think they had ideas, but they were bad ideas. They were bad ideas for America. (APPLAUSE) They were ideas like privatizing Social Security, like moving back from a balanced budget and a surplus to deficit and debt. And with respect to putting forth how one would pay for all of the programs that we're proposing in this campaign, I will be more than happy, Barack, to get the information, because we have searched for it. You have a lot of money that you want to put into foreign aid, a very worthy program. There is no evidence from your Web site, from your speeches, as to how you would pay for it. Now, why is this important? It's important because I think elections are about the future. But how do you determine what will happen in the future? Well, you have to look to the record, you have to look to what we say in campaigns, and what we have done during our careers. And I want to be just very explicit about this. We are not, neither my campaign nor anyone associated with it, are in any way saying you did not oppose the war in Iraq. CLINTON: You did. You gave a great speech in 2002 opposing the war in Iraq. That was not what the point of our criticism was. It was after having given that speech, by the next year the speech was off your Web site. By the next year, you were telling reporters that you agreed with President Bush in his conduct of the war. And by the next year, when you were in the Senate, you were voting to fund the war time after time after time. BLITZER: All right. CLINTON: So it was more about the distinction between words and action. And I think that is a fair assessment for voters to make. (APPLAUSE) BLITZER: OK. Thank you, Senator. Senator, we're a little off topic. I have to let Senator Obama respond, then Senator Edwards, who's going to come... OBAMA: We're off topic, but... BLITZER: But go ahead and respond, and then I want to get back to this issue that we're talking about, fiscal responsibility. But go ahead. OBAMA: Let's talk about it. Hillary, I will be happy to provide you with the information about all -- all the spending that we do. Now, let's talk about Ronald Reagan. What you just repeated here today is... CLINTON: Barack... OBAMA: Wait. No. Hillary, you just spoke. CLINTON: I did not say anything about Ronald Reagan. OBAMA: You just spoke for two minutes. CLINTON: You said two things. OBAMA: You just... CLINTON: You talked about admiring Ronald Reagan and you talked about the ideas... OBAMA: Hillary, I'm sorry. You just... BLITZER: Senator... CLINTON: I didn't talk about Reagan. OBAMA: Hillary, we just had the tape. You just said that I complimented the Republican ideas. That is not true. What I said -- and I will provide you with a quote -- what I said was is that Ronald Reagan was a transformative political figure because he was able to get Democrats to vote against their economic interests to form a majority to push through their agenda, an agenda that I objected to. Because while I was working on those streets watching those folks see their jobs shift overseas, you were a corporate lawyer sitting on the board at Wal-Mart. (APPLAUSE) OBAMA: I was fighting these fights. I was fighting these fights. So -- but I want to be clear. So I want to be clear. What I said had nothing to do with their policies. I spent a lifetime fighting a lifetime against Ronald Reagan's policies. But what I did say is that we have to be thinking in the same transformative way about our Democratic agenda. We've got to appeal to Independents and Republicans in order to build a working majority to move an agenda forward. That is what I said. (APPLAUSE) OBAMA: Now, you can dispute that, but let me finish. Hillary, you went on for two minutes. Let me finish. The irony of this is that you provided much more fulsome praise of Ronald Reagan in a book by Tom Brokaw that's being published right now, as did -- as did Bill Clinton in the past. So these are the kinds of political games that we are accustomed to. CLINTON: Now, wait a minute. Wolf, wait a minute. Wait a minute. Just a minute. BLITZER: Senator Edwards, let them wrap up. Then I'm going to come to you. Yes? CLINTON: I just want -- I just to clarify -- I want to clarify the record. Wait a minute. EDWARDS: There's a third person in this debate. BLITZER: Wait a minute, Senator Edwards. Hold on. There has been a specific charge leveled against Hillary Clinton, so she can respond. Then I'll bring in Senator Edwards. CLINTON: I just want to be sure... OBAMA: Go ahead and address what you said about... BLITZER: We have got a long time to go. You'll have a good opportunity. CLINTON: We're just getting warmed up. (APPLAUSE) CLINTON: Now, I just -- I just want to be clear about this. In an editorial board with the Reno newspaper, you said two different things, because I have read the transcript. You talked about Ronald Reagan being a transformative political leader. I did not mention his name. OBAMA: Your husband did. CLINTON: Well, I'm here. He's not. And... OBAMA: OK. Well, I can't tell who I'm running against sometimes. (APPLAUSE) CLINTON: Well, you know, I think we both have very passionate and committed spouses who stand up for us. And I'm proud of that. But you also talked about the Republicans having ideas over the last 10 to 15 years. OBAMA: I didn't say they were good ones. CLINTON: Well, you can read the context of it. OBAMA: Well, I didn't say they were good ones. CLINTON: Well, it certainly... OBAMA: All right, Wolf. CLINTON: It certainly came across in the way that it was presented, as though the Republicans had been standing up against the conventional wisdom with their ideas. I'm just reacting to the fact, yes, they did have ideas, and they were bad ideas. OBAMA: I agree. CLINTON: Bad for America, and I was fighting against those ideas when you were practicing law and representing your contributor, Resco, in his slum landlord business in inner city Chicago. (APPLAUSE) OBAMA: No, no, no. BLITZER: Hold on one second. Hold on. Senator Edwards -- Senator Edwards has been remarkably patient during this exchange. And I want him -- I don't know if you want to get involved in this, Senator Edwards. EDWARDS: What I want to say first is, are there three people in this debate, not two? (APPLAUSE) EDWARDS: And I also want to know -- I also want to know on behalf of voters here in South Carolina, this kind of squabbling, how many children is this going to get health care? How many people are going to get an education from this? How many kids are going to be able to go to college because of this? EDWARDS: We have got to understand -- you know, and I respect both of my fellow candidates -- but we have got to understand this is not about us personally. It is about... (APPLAUSE) ... what we are trying to do for this country and what we believe in. Now, fiscal responsibility, which I think was the question. It was a little hard to tell there at the end of that. But I think the question was about fiscal responsibility. I have proposed, I think, the most aggressive, most progressive agenda of the three of us up here. And I was the first to come out with a universal health care plan, first to come out with a global warming plan, first -- and, to the best of my knowledge, only at this point -- to come out with a comprehensive, detailed plan to end poverty in America, since we are on Dr. King's day. This is the cause of my life. Everything I have proposed, I have come up with a way to pay for it. And I've been very explicit about how it should be paid for, not abstract, not rhetoric, very, very explicit. But I do have to say, in response to something Senator Clinton said just a minute ago, both Senator Obama and I have said Social Security needs a solution. And we have said we won't privatize, we won't cut benefits, we won't raise the retirement age. Same thing that Hillary has said. But she has proposed nothing about how we're going to create revenue to keep Social Security alive and talked about fiscal responsibility. Here's the problem: If you don't have -- this is not complicated. The American people understand it. If you've got more money going out than is coming in, you're going to eventually run out of money. And you've got to have a way to pay for it, which is why -- now, let me finish this. Lord knows you let them go on forever. (APPLAUSE) What I'm saying is we have to be consistent in what we're saying. I have said I think Hillary doesn't want to talk about raising taxes. Let's just be honest about that. Barack and I have both said that you've got to do something about the cap on Social Security taxes, which is now capped at $97,000. It means if somebody is making $80,000 a year, every dime of their income is taxed for Social Security. But if you are making $50 million a year, only the first $97,000 is taxed. That's not right. And people ought to be paying their Social Security taxes. But the American people deserve to know what we're going to do. We can disagree. There's nothing wrong with that, so they can make an informed choice, but they at least deserve to know where they stand and what we'd do. BLITZER: We're staying on the economy, but I want Joe Johns to ask another question so we can continue this dialogue. JOHNS: All right. Well, Senator Edwards, let's dig a little deeper on the economic mess we're in currently. In 2006, a study from the Center for Responsible Lending found that African-Americans are something like 30 percent more likely to be sold a subprime loan than white borrowers with similar credit histories and income. The South Carolina NAACP said last month that the American dream for too many Americans, too many African-Americans is a national nightmare. The national NAACP has even filed a class-action lawsuit against 12 nationwide lenders. So the bottom-line question really is: Do you believe that lenders have specifically targeted African-Americans? Is this subprime mess really also an issue of race? EDWARDS: Yes, is the answer. I think they have targeted - if they haven't been racially motivated, I don't know. There's no way for me to know what's inside their head. But what they have done is they have targeted the lowest income, most vulnerable families. And anybody who's paying any attention to what's going on in America today understands, if you are African-American in this country today, you are likely to have a net worth of about 10 percent of what white families have. This is not an accident. I mean, we can go put our heads against the wall and pretend that the past never happened, pretend that we didn't live through decades of slavery, followed by decades of segregation, followed by decades of discrimination, which is still going on today. (APPLAUSE) That history and that legacy has consequences. And the consequence has been that African-American families are more vulnerable. They're more vulnerable to payday lenders. They're more vulnerable to predatory lenders, which is why we desperately need a national law, which I have proposed, which would crack down on these predatory payday lenders. It's not enough to do it state-by-state, because these predators just move from place to place to place. I was in a neighborhood in Cleveland a few months ago, one-block radius, 38 houses under foreclosure, middle-class, African-American neighborhood. These people work. They put everything they had into their homes. And they were about to lose them because these predators have come into the neighborhood and taken everything they have. So here are the solutions. Number one, we need a national predatory lending law. Number two, we've got to help low-income families save. EDWARDS: They have nothing to fall back on. Many have no bank account. They don't deal with financial institutions. We need to teach financial literacy, we need to match what they're able to save so that they actually have something that they can fall back on in case they get in a place where they need more money. (APPLAUSE) BLITZER: All right. I want both Senator Clinton and Senator Obama to respond. But, briefly, Senator Clinton, your proposal calls for a five-year moratorium on interest rates, 90-day moratorium on foreclosure, five year keeping those interest rates the same. Alan Greenspan suggested that we simply have to let this housing crisis exhaust itself. Trying to prevent the housing markets from going down merely prolongs the agony. Does your plan, as he would seem to be suggesting, prolong the agony? CLINTON: No. I think it helps to mitigate the agony. I mean, what I hear as I go in and out of people's homes and talk to so many who have already lost their homes, they're in foreclosure, they see these interest rates that are about to go up and they know they can't pay them, is that we take action now. I've been calling for action since last March. When I first started calling for it, a lot of the same economists who now say don't do anything about it said, well, it won't be that bad. We'll be able to weather the crisis. Well, the fact is, the mortgage crisis is not only destroying the dreams of Americans for home ownership, it is having a ripple effect across the world. So my moratorium for 90 days is a work-out. It's not a bailout. I want people to be able to see whether they can stay in their homes paying a rate that is affordable for them. And the interest rate freeze is I think merited, because look at what's happening -- if you're a big bank that helped get us into this mess, you go borrow money from Abu Dhabi or somewhere. If you're a homeowner who has been at the bottom of this incredible scheme that was established, you're left holding the bag and you don't have the house anymore. BLITZER: Thank you, Senator. CLINTON: So I just disagree with those who say don't try to do anything to help the people who need the help right now. BLITZER: Senator Obama. OBAMA: I think that we need to help them. I think it is important to make sure that we're not helping out the speculators, but instead are helping out the homeowners who are actually living in their homes, who have the capacity to make the payments if they're not seeing a huge increase in their mortgage payments. But understand this, this is not new. We have a history in this country of preying on low-income peoples because they don't have access to banks. The Community Reinvestment Act is oftentimes not enforced as it should be. We've got to open up bank branches. We've got to give people access to financing so that they're not going to a payday loan operation. I two years ago introduced a provision that would eliminate predatory lending, something that I had already helped to get passed at the state level. But it is important for us to understand that we've got to give ordinary working people access to financing. And it's important to understand that part of the reason that they are borrowing on their homes, they're borrowing on credit cards, is that the banks and financial institutions have dominated policy in Washington. And this is an area where I've got a policy disagreement with Senator Clinton. When we talked a while back, just in the last debate, we talked about the bankruptcy bill, which had been pushed by the banks and the financial institutions, that said, basically, it will be harder for folks who have been lured into these teaser rates and then see their credit cards go up to 30 percent, that they would have a tougher time getting out of bankruptcy. In the last debate, Senator Clinton said she voted for it but hoped that it wouldn't pass. Now, I don't understand that approach to legislation. I think it is important for us to stand up to these special interests consistently, all the time, and that's what I've done and that's what I will continue to... BLITZER: I'm going to go to Suzanne... CLINTON: Wait, Wolf, I have to answer this. BLITZER: I'm going to go to Suzanne Malveaux in a second, but I just want to give you a chance, Senator Obama, if you want to respond. Senator Clinton made a serious allegation that you worked for a slumlord. And I wonder if you want to respond. OBAMA: I'm happy to respond. Here's what happened: I was an associate at a law firm that represented a church group that had partnered with this individual to do a project and I did about five hours worth of work on this joint project. That's what she's referring to. Now, it's fine for her to throw that out, but the larger reason that I think this debate is important is because we do have to trust our leaders and what they say. That is important, because if we can't, then we're not going to be able to mobilize the American people behind bringing about changes in health care reform, bringing about changes in how we're going to put people back to work, changing our trade laws. And consistency matters. Truthfulness during campaigns makes a difference. (APPLAUSE) And that's what I've tried to do and I will continue to try to do as president of the United States. CLINTON: Now, let me start with the claim about the bankruptcy bill. I said very clearly I regretted voting for it and I was happy that it didn't get into law. By 2005, there was another run at a bankruptcy reform, motivated by the credit card companies and the other big lenders. I opposed that bill. I said very forcefully I opposed that bill. There was a particular amendment that I think is very telling. It was an amendment to prohibit credit card companies from charging more than 30 percent interest. Senator Obama voted for it. I voted against it. It was one of the biggest lobbyist victories on that very bad bill that the bankruptcy bill represented. And I think it's important. You know, if you look at the recent article about Senator Obama's work on health care reform in the Illinois legislature, it's a very interesting piece about how he basically did the bidding of the insurance companies during that effort. Now, I'm just saying that if we're going to... OBAMA: That's... CLINTON: ... be hurling these charges against one another, I'm used to taking the incoming fire. I've taken it for 16 years. But when you get into this arena... (APPLAUSE) ... you can't expect to have a hands-off attitude about your record. And it is perfectly fair to have comparisons and contrasts. I voted against a 30 -- I voted for limiting to 30 percent what credit card companies could charge. Senator Obama did not. That's a fact. (CROSSTALK) OBAMA: Absolutely. It is a fact, because I thought 30 percent potentially was too high of a ceiling. So we had had no hearings... (APPLAUSE) ... on that bill. It had not gone through the Banking Committee. I don't know about a lot of folks here, most folks here, if they've got a credit card, are paying 29 percent. So under this provision, that would've been fine. And we had not created the kind of serious... EDWARDS: You voted against it because the limit was too high, is that what you just said? OBAMA: That is exactly what I just said, John, because... EDWARDS: So there's no limit at all. OBAMA: ... there had been no discussions... (APPLAUSE) Hold on, John. Hold on. Listen to this. There had been no discussion about how we were going to structure this and this was something that had not gone through the committee and we hadn't talked about. It didn't make sense for us to cap interest rates... CLINTON: So you voted with the credit card companies. OBAMA: No. CLINTON: That's the bottom line. OBAMA: Hillary, I opposed that bill and you know I did. (APPLAUSE) CLINTON: Well... OBAMA: And consistently did and unlike you and John who voted for it previously. But here's the point. What we have to do is we've got to have consistency in how we vote. You can't say one thing during the campaign trail and then apologize afterward and say it was a mistake, and that has repeatedly happened during the course of this campaign... (APPLAUSE) ... and I think that tells you the kind of president that folks are going to be. CLINTON: Well, you know, Senator Obama, it is very difficult having a straight-up debate with you, because you never take responsibility for any vote, and that has been a pattern. You, in the -- now, wait a minute. In the Illinois state legislature... (AUDIENCE BOOING) CLINTON: Just a minute. In the Illinois state senate, Senator Obama voted 130 times present. That's not yes, that's not no. That's maybe. And on issue after issue that really were hard to explain or understand, you know, voted present on keeping sex shops away from schools, voted present on limiting the rights of victims of sexual abuse, voted present time and time again. And anytime anyone raises that, there's always some kind of explanation like you just heard about the 30 percent. It's just very difficult to get a straight answer, and that's what we are probing for. OBAMA: I feel bad for John... BLITZER (?): I know. (APPLAUSE) OBAMA: ... because I know John's not getting a lot of time here. Let me just respond to this. BLITZER (?): You can... OBAMA: I feel pretty bad, I do. I feel pretty bad. But let's just respond to the example that was just thrown out. The bill with respect to privacy for victims of sexual abuse is a bill I had actually sponsored, Hillary. I actually sponsored the bill. It got through the senate. (APPLAUSE) That was on the back of 12 other provisions that I was able to pass in the state legislature. Nobody has worked harder than me in the Illinois state legislature to make sure that victims of sexual abuse were dealt with, partly because I've had family members who were victims of sexual abuse and I've got two daughters who I want to protect. What happened on that particular provision was that after I had sponsored it and helped to get it passed, it turned out that there was a legal provision in it that was problematic and needed to be fixed so that it wouldn't be struck down. But when you comb my 4,000 votes in Illinois, choose one... (APPLAUSE) ... try to present it in the worst possible light, that does have to be answered. That does have to be answered. OBAMA: And as I said before, the reason this makes a difference -- and I understand that most viewers want to know, how am I going to get helped in terms of paying my health care? How am I going to get help being able to go to college? All those things are important. But what's also important that people are not just willing to say anything to get elected. And... (APPLAUSE) BLITZER: Senator... OBAMA: ... that's what I have tried to do in this campaign, is try to maintain a certain credibility. I don't mind having policy debates with Senator Clinton or Senator Edwards. But what I don't enjoy is spending the week or two weeks or the last month having to answer to these kinds of criticisms that are not factually accurate. (APPLAUSE) OBAMA: And the press has looked at them. They are not accurate. And you need to present them as accurate. BLITZER: We're going to be coming back. CLINTON: Well, that law is still on the books. It was never struck down. That was there. BLITZER: We're going to be visiting all these subjects, but I just want Senator Edwards to weigh in. Suzanne has got an excellent question coming up. Go ahead. (LAUGHTER) EDWARDS: She's been wanting to ask it, too. Can I just ask, though, before I do -- I mean, I hear the back and forth on this one particular vote, but it is -- I do think it's important, and I mentioned this about Senator Clinton earlier, to be fair, about Social Security. I do think it's important whether you are willing to take hard positions. I mean, the members of the Congressional Black Caucus who are sitting in front of me right know they have to go to the floor of the House every day and vote on hard issues. And they have to vote up or down or not show up to vote -- one of those three choices. What I didn't hear was an explanation for why over 100 times you voted present instead of yes or no when you had a choice to vote up or down. (APPLAUSE) OBAMA: I'll be happy to answer it. Because in Illinois - in Illinois, oftentimes you vote present in order to indicate that you had problems with a bill that otherwise you might be willing to vote for. And oftentimes you would have a strategy that would help move the thing forward. Keep in mind, John, I voted for 4,000 bills. And if you want to know whether or not I worked on tough stuff, I passed the first racial... EDWARDS: I don't question whether you worked on tough stuff. OBAMA: No, no, no. Hold on a second. EDWARDS: I don't question whether you worked on tough stuff. OBAMA: No, no. But you... EDWARDS: The question is, why would you over 100 times vote present? I mean, every one of us -- every one -- you've criticized Hillary. You've criticized me for our votes. OBAMA: Right. EDWARDS: We've cast hundreds and hundreds of votes. What you're criticizing her for, by the way, you've done to us, which is you pick this vote and that vote out of the hundreds that we've cast. (APPLAUSE) OBAMA: No. EDWARDS: And what -- all I'm saying is, what's fair is fair. You have every right to defend any vote. You do. OBAMA: Right. EDWARDS: And I respect your right to do that on any -- on any substantive issue. It does not make sense to me -- and what if I had just not shown up... OBAMA: John -- John, Illinois... EDWARDS: Wait, wait, wait. Wait, let me finish. OBAMA: Hold on a second. EDWARDS: What if I had just not shown up to vote on things that really mattered to this country? It would have been safe for me politically. It would have been the careful and cautious thing to do, but I have a responsibility to take a position... OBAMA: John, you... EDWARDS: ... even when it has political consequences for me. (APPLAUSE) OBAMA: You asked for the -- most of these did not have political consequences. This -- most of these were technical problems with a piece of legislation that ended up getting modified. But let's talk about taking on tough votes. I mean, I am somebody who led on reforming a death penalty system that was broken in Illinois, that nobody thought was good politics, but was the right thing to do. (APPLAUSE) OBAMA: I opposed legislation that now is being used against me politically to make sure that juveniles were not put in the criminal justice system as adults, even though it was not the smart thing to do politically. It was not smart for me to oppose the war at the start of this war, but I did so because it was the right thing to do. (APPLAUSE) OBAMA: So I understand that Illinois has a different system than Congress, and that it is fine to try to use that politically. But don't question, John, the fact that on issue after issue that is important to the American people, I haven't simply followed, I have lead. BLITZER: We have an important issue that Suzanne wants to raise right now. Go ahead, Suzanne. MALVEAUX: Thank you. I would like to raise the issue of health care. It was last June, Senator Clinton. It was the PBS forum at Howard University where you said if HIV/AIDS was the leading cause of death among white women ages 25 to 34, there would be a national outcry. Obviously, you're calling attention to the need, specific need for African-American women and their health concerns. Why is it that African-American women would be better off in your health care program? CLINTON: Well, first of all, my health care program will cover everyone. I don't leave anybody out. It is a universal system. It will build on the congressional plan that provides health care for members of Congress, their staffs, government employees, and therefore it is not a new system. CLINTON: It is not government-run. It has the advantage of being proven, so that we can withstand what will be obviously the attacks coming from the Republicans, and the right, and the drug companies, and the health insurance companies. It also will give comprehensive health care to everyone. It's especially important we do that with chronic diseases. And, thankfully (sic) HIV/AIDS has become a chronic disease. We're able to keep people alive in the United States. We don't do enough around the world. And we don't do enough yet to get the services as quickly as necessary to a lot of our people who are not given the kind of immediate help that they deserve. But we need a universal health care system where we manage chronic diseases, where we get prices down because we can bargain with the drug companies, where we say to the health insurance companies that they must cover everyone, they have to do it at an affordable rate. And for people who might have some financial challenges, I am proposing health care tax credits that will make health care for everyone affordable. And I think that that is the right way to go, because if we don't have everybody in the system, we know what will happen. We will begin to have more and more people who are uninsured. The health care companies will continue to cherry pick. The hidden tax that comes when someone does finally show up at the emergency room will be passed onto everyone else. So I am adamantly in favor of universal health care. And that means everybody is covered. And we will have a system to make it affordable, but it will be required, as part of shared responsibility, under a new way of making sure that we don't leave anybody out and provide quality, affordable health care for everyone. BLITZER: I want to stay on health care. Joe Johns has a follow-up question. Go ahead, Joe. JOHNS: Senator Obama, we all know what universal health care is, as Senator Clinton just said, sort of the idea that everybody deserves health care. And I have not been able to sort of zero in on your position on this one question: Does your plan cover the estimated 12 million or so illegal immigrants in the country? OBAMA: It does not. JOHNS: Why not? OBAMA: Well, because I think we've got limited resources. And it is important for us that, when we've got millions of U.S. citizens that aren't yet covered, it's important for us to make sure that they are provided coverage. I do think that we have an obligation to make sure that children are covered. And we want to make sure that they are not sick in the emergency room. But the critical issue on these various plans is, how are we going to actually get it done? Because, you know, I respect the fact that Senator Clinton and President Clinton attempted in '93 to get health care reform passed. But I do think that they did it in the wrong way, because it was behind closed doors, and we did not enlist the American people in the process. The only way we're going to be able to overcome the insurance companies, and the drug companies, and the HMOs who are profiting from the current system is if we are having all these negotiations in a public setting, we are very clear about who's carrying water for the drug companies and the insurance companies, and who is looking out for the families who, day to day, are struggling. All of us, all three of us have met people every day in our travels across the country who, even if they have health care, are looking at such high premiums that effectively it's not really health insurance, it's house insurance. They're paying premiums, in case they get hit by a car, they don't lose their home. But they never go to a doctor. And we've got to put responsibility not just on the next president, but also on Congress to make sure it happens. And that means that we've got to have the American people clear about the choices that we face. BLITZER: Senator Edwards, would your plan include the 12 million illegal immigrants? And if not, what happens if they get sick and they wind up in emergency rooms? Who's going to pay for that? EDWARDS: Well, it's a good question. I think, honestly, none of our three plans cover them. But what I have done is strengthen... (APPLAUSE) ... strengthen the safety net of the public health system so that our public health clinics, our public hospitals will always be available. And if that is married to comprehensive immigration reform, so that people who are living here undocumented actually have a chance to become American citizens, then I think they've got the opportunity to become part of the plan. There are a couple things I want to say, though. Senator Obama spoke -- and he's right about this -- about the importance of us being straightforward and being honest during the campaign. The truth is that there are three health care plans represented on this stage. Two are universal; one is not. His is not. Senator Clinton's is, and mine is. EDWARDS: In order for the plan to be universal, it has to mandate coverage for everybody. And when we talk about getting it done -- and Barack just spoke, as he does often, eloquently, about taking on the drug companies, the insurance companies, I also think it's important to recognize that Senator Obama has taken more money from the drug companies than anybody. Senator Clinton has taken more money from the insurance companies than anybody. I have not. And I am ready to take these people on. BLITZER: All right. OBAMA: Well, a couple of points. BLITZER: I'm going to give both of you 30 seconds, please. OBAMA: A couple of points. John, I think, is aware I don't take PAC money. I don't take money from federal lobbyists. I'm not taking money from their companies. It is true that there are employees of all sorts of companies that have given to my campaign because, frankly, I've raised a lot of money, and sometimes in $25, $50, $100 donations. But that does mean that I've gotten a bunch of money from drug lobbyists. And I think it's important to make that distinction, John. EDWARDS: That's fair. OBAMA: Point number two. With respect to universal coverage, understand what this debate is about. And this is a legitimate policy debate. And I respect the positions that John and Hillary have taken. They have decided that we should mandate coverage for all adults. I believe that the problem -- and understand what that means. A mandate means that, in some fashion, everybody will be forced to buy health insurance. Now, John has been honest that that may mean taking money out of people's paychecks in order to make sure that they're covered. Senator Clinton has not been clear about how that mandate would be enforced. But I believe the problem is not that folks are trying to avoid getting health care; the problem is they can't afford it. (APPLAUSE) And that's why my plan emphasizes lowering costs, not only setting up a government plan so that people who don't have health insurance can buy into it and will get subsidized, but also making sure that those who have health insurance -- because, keep in mind, we've got millions of Americans all across the country who have health insurance, but are struggling with rising co-payments, deductibles, premiums. Under George Bush, families are paying 78 percent more on health care than they were previously -- let me just finish, because this is an important policy point. We put in a catastrophic re-insurance plan that will help reduce those premiums for families by an average of about $2,500 per year. But the last point that I think is worth making, every expert that's looked at this has said there is not a single person out there who's going to want health care who will not get it under my plan. And it's true that some people could game the system by just waiting until they get sick and then they show up. But keep in mind that my plan also says children will be able to stay on the parents' plan up until the age of 25. And so I don't believe that there are a whole bunch of folks out there that will not get coverage. And, John, both you and Hillary have a hardship exemption, where, if people can't afford to buy health care, you exempt them, so that you sort of don't count them. EDWARDS: But we would cover them. We cover them, Barack. OBAMA: But you don't cover them. EDWARDS: Yes, we do. CLINTON: Yes, we do. EDWARDS: Yes, we do. It's not true, Barack. (CROSSTALK) CLINTON: That is not true. EDWARDS: No, no. Here's the problem. The problem with this argument is you can make exactly the same argument about Social Security. I mean, you think about the analogy. What George Bush says is he wants people to be able to get out of the Social Security system, choose, elect to get out of the Social Security system. Well, that's exactly what this argument is. OBAMA: No. EDWARDS: This argument is you shouldn't have to have health care. If you choose not to have health care, you shouldn't have to have it. And that is a threshold question. It is a judgment. It's a fair policy debate. (CROSSTALK) EDWARDS: There's nothing wrong with us arguing about this, but I believe that there is not a single man, woman, and child in America who's not worthy of health care. Everybody should get health care. (APPLAUSE) BLITZER: I promised Senator Clinton she could respond as well. Try to keep it to 30 seconds. CLINTON: Well, first of all, if you don't start out trying to get universal health care, we know -- and our members of Congress know -- you'll never get there. If a Democrat doesn't stand for universal health care that includes every single American, you can see the consequences of what that will mean. I think it is imperative that we have plans, as both John and I do, that from the very beginning say, "You know what? Everybody has got to be covered." There's only three ways of doing it. You can have a single-payer system, you can require employers, or you can have individual responsibility. My plan combines employers and individual responsibility, while maintaining Medicare and Medicaid. I think that the whole idea of universal health care is such a core Democratic principle that I am willing to go to the mat for it. I've been there before. I will be there again. I am not giving in; I am not giving up; and I'm not going to start out leaving 15 million Americans out of health care. Secondly, we have seen once again a kind of evolution here. When Senator Obama ran for the Senate, he was for single-payer and said he was for single-payer if we could get a Democratic president and Democratic Congress. As time went on, the last four or so years... As time went on, the last four or so years, he said he was for single payer in principle, then he was for universal health care. And then his policy is not, it is not universal. And this is kind of like the present vote thing, because the Chicago Tribune, his hometown paper, said that all of those present votes was taking a pass. It was for political reasons. Well, when you come up with a universal health care plan and you don't have any wiggle room left, you know that you're going to draw a lot of political heat. I am not running for president to put Band-Aids on our problems. I want to get to universal health care for every single American. (APPLAUSE) BLITZER: I have to let Senator Obama respond. But try to be brief, 30 seconds, if possible. (UNKNOWN): Good luck. OBAMA: Right, exactly. Here's the policy question: if, in fact, we are not making it affordable enough, which is what's happening right now, and you mandate on families to buy health insurance that they can't afford and if they don't buy it you fine them or in some other way take money for them -- this is what's happening... EDWARDS: But, Barack, you're ignoring that we subsidize... OBAMA: John, I haven't finished. John, let me finish. EDWARDS: OK, all right, go ahead. OBAMA: Now, what is happening in Massachusetts right now -- there are articles being written about it -- which is that folks are having to pay fines and they don't have health care. They'd rather go ahead and take the fine because they can't afford the coverage. My core belief is that people desperately want coverage. They desperately want it, and my plan provides those same subsidies. And if they are provided those subsidies and they have good, quality care that's available, then they will purchase it. That is my belief. Now, it's fine for us to have a debate about how the best way to get there is, but to suggest somehow that I'm not interested in having anybody covered, or to suggest, as Hillary just did, that I was in favor of single payer -- I never said that we should try to go ahead and get single payer. What I said was that if I were starting from scratch, if we didn't have a system in which employers had typically provided health care, I would probably go with a single-payer system. What's evolved, Hillary, is your presentation of my positions, which is what's happened frequently during the course of this campaign. (APPLAUSE) BLITZER: Thank you, Senator. Let's move on. We have another important subject that, Joe, I want you to start off. JOHNS: Senator Clinton, on the Iraq question, we're here in South Carolina. It's a big military state with a lot of military families. Last week, U.S. military commanders on the ground in Iraq said that Baghdad is now 75 percent secured. There's also important signs of political progress, including de-Baathification, which was basically long awaited. That, of course, was a big benchmark. Last week, you said the next president will, quote, "have a war to end in Iraq." In light of the new military and political progress on the ground there in Iraq, are you looking to end this war or win it? CLINTON: I'm looking to bring our troops home, starting within 60 days of my becoming president, and here's why, Joe. I have the greatest admiration for the American military. I serve on the Senate Armed Services Committee. I've been to Iraq three times. I've met with the leaders of the various factions. But there is no military solution, and our young men and women should not remain as the referees of their conflict. I believe what you're seeing happen is twofold. Of course the surge, the so-called surge, was able to pacify certain parts of Iraq. If we put enough of our men and women and equipment in, we're going to be able to have some tactical military success. But the whole purpose of the surge was to force the Iraqi government to move quickly towards the kind of resolution that only it can bring about. I think what is motivating the Iraqi government is the debate in the political campaign here. They know they will no longer have a blank check from George Bush, that I will with draw troops from Iraq. And I believe that will put even more pressure on the Iraqis to finally make the decisions that they have to make. It is not going to be easy. Withdrawing troops is dangerous. That's why I've been working to make sure that we knew all of the various steps we would have to take, because it's not just bringing our troops and equipment home. We have more than 100,000 civilians there, working for the embassy, working for businesses, working for charities. We have a lot of Iraqis who sided with us, translators and drivers who put their lives on the line for American military forces. So this is complicated, but I'm committed to withdraw our troops and to put the Iraqi government on notice that their time is running out. CLINTON: And they have to make these tough decisions. BLITZER: I'm going to let Senator Obama respond, too. But, Senator Edwards, Senator John McCain, the Republican presidential candidate, he supported the surge from the beginning. I think all three of you opposed the surge from the beginning. He says now the surge is working, there's military progress, the level of violence has gone down, and that the United States must not surrender in Iraq. It must win that war in Iraq. Why do you believe Senator McCain is wrong? EDWARDS: He's wrong because George Bush himself said the entire reason for the surge was to create an environment for political progress. Everyone from the Iraq Study Group, to even Bush recognized -- and if Bush recognizes it, man, it's really got to be out there. (LAUGHTER) EDWARDS: Even President Bush recognizes that unless the Sunni and Shia reach some political reconciliation, there cannot be stability in Iraq. And the problem with this definition and evaluation of where the progress has been made is that there has been no meaningful political progress. There has been a little bit, in fairness. A little bit, but very little. And I don't think it changes anything. The one thing I would say is -- and I would actually like for both of them to have a chance to respond to is this -- what I have said very clearly, all of us has said, we would end the war. And I don't have any doubt that all of us are committed to that, I don't doubt that. But how aggressively and how quickly is an important question. And I have said in the first year that I am president, I will have all combat troops out of Iraq. All combat missions will end in Iraq, and there will be no permanent military bases in Iraq. (APPLAUSE) EDWARDS: I have not heard -- now, admittedly, just to be fair, I don't hear everything they say on the campaign trail, but I have not heard either of them say that definitively. So I would be interested in knowing whether they will commit to having all combat troops out and ending combat missions in the first year. BLITZER: Senator Obama? OBAMA: John, what I have said, and I've said repeatedly, is I want to be as careful getting out as we were careless getting in, but I want to make sure that we get all our combat troops out as quickly as we can safely. Now, the estimates are maybe that's two brigades per month. At that pace it would be some time in 2009 that we had our combat troops out, depending on whether Bush follows through on his commitment to draw down from the surge. We don't know that yet, but understand what's at stake here. John is exactly right that the question is, how do we create a stable Iraqi government where our troops are not required to remain permanent bases in -- and a permanent occupation in Iraq? We are spending $9 billion to $10 billion every month. That's money that could be going right here in South Carolina to lay broadband lines in rural communities, to put kids back to school. And so when John McCain says we'll be there for 50 or 60 or 100 years, it is not just the loss of life, which is obviously the most tragic aspect of it, it's also the fact that financially it is unsustainable. We will have spent $2 trillion at least, it's estimated, by the time this whole thing is over. That's enough to have rebuilt every road, bridge, hospital, school in America, and still have money left over. (APPLAUSE) BLITZER: All right. OBAMA: But just one last point I want to make. We are seeing Al Qaida stronger now than at any time since 2001. That is a significant threat that has to be dealt with. Because we have been distracted, we have ended up seeing a more dangerous situation, and so we are not -- this is not just a matter of who is right and who is wrong about having gone to war or the surge. It's also, how do we deal with the future threats? And as long as we're bogged down in Iraq, we are not going to be able to deal with those future threats. BLITZER: Senator Clinton, do you want to respond to Senator Edwards asking you whether you're ready to commit to all combat troops being out of Iraq within a year? CLINTON: What I have said is that I will move as quickly as possible. I hope to have nearly all out within a year. We don't know what we're going to inherent from President Bush, but there is a big problem looming on the horizon that we had better pay attention to, and that is President Bush is intent upon negotiating a long-term agreement with Iraq which would have permanent bases, permanent troop presence. And he claims he does not need to come to the United States Congress to get permission, he only needs to go to the Iraqi parliament. That is his stated public position. He was recently in the region, and it is clear that he intends to push forward on this to try to bind the United States government and his successor to his failed policy. I have been strongly opposed to that. We should not be planning permanent bases and long-term troop commitments. CLINTON: Obviously, we've got to rein in... (APPLAUSE) ... President Bush. And I've proposed legislation and I know that members of the Congressional Black Caucus are looking at this, as well. We need legislation in a hurry which says, "No, Mr. Bush, you are the president of the United States of America. You cannot bind our country without coming to the United States Congress." This is a treaty... (APPLAUSE) ... that would have to be presented and approved, and it will not be. BLITZER: I just want to tell the presidential candidates and everyone, we're just getting started. We're going to continue. We have to take a quick, quick commercial break. When we come back, you're going to see a different set. We're all going to be seated up here. All the rules are going to go away. We're going to have an important conversation, an important -- whatever rules are left, that is. They're all going to go away and we're going to discuss the issues in this campaign. Much more of our debate here when we come back. (COMMERCIAL BREAK) BLITZER: We're rearranging the furniture here on the stage at Myrtle Beach in South Carolina. The Senators are getting ready for part two of this debate, which will be much more informal. There will really be no rules in this part two. We're going to go through many other substantive issues. The candidates are just getting ready to come out. They're bringing the chairs out right now. Senator Hillary Clinton, Senator Barack Obama, Senator John Edwards will be here. We'll be going through the issues. Much more of our coverage right after this. (COMMERCIAL BREAK) BLITZER: Welcome back to the Democratic presidential debate. We're here in Myrtle Beach, South Carolina with three Democratic presidential candidates. BLITZER: I also want to remind all of our viewers out there in the United States and around the world they can always go to cnnpolitics.com. They can continue to watch what's going on here, get a lot more information on the positions, the substantive positions of all of these candidates. If they need more information -- you need more information, that's the place to go: cnnpolitics.com. I want to begin the second part of this debate with a question for Senator Obama, and I want to refer to Congressman Charlie Rangel, one of the most powerful members, one of the most powerful members of the House of Representatives, and specifically on this Martin Luther King, Jr. Day, a day so important to all of us here in the United States. He's a supporter of Hillary Clinton and he said yesterday, and I'm quoting now, that he likes you, Senator Obama. He's very proud of your accomplishments. But he went on to say that "Black voters should not do what makes us feel good, but what's good for our great nation." And I wonder if you want to respond to that notion that it may make a lot of African-Americans feel good to vote for you, but it might not necessarily be the best thing for the United States. OBAMA: Well, first of all, Charlie's absolutely right that African-Americans should vote for what's best for them, their children, and this country, and the same way that I think Hillary... (APPLAUSE) ... you know, Hillary feels that women should vote for what's best for them, their children, and their country. EDWARDS: Would you mind saying that... OBAMA: And the same way that John... EDWARDS: Say that a little more often. OBAMA: Absolutely. Same way that John, I think, he wants white males to vote for... (LAUGHTER) EDWARDS: And women and African-Americans. OBAMA: So I think Charlie's right in principle. Now, obviously, he and I differ in terms of what would be best for the nation. I wouldn't be running if I didn't think that I could bring the country together most effectively, that I can overcome the special interests in Washington most effectively, that I can inspire the American people to get involved in their government most effectively. So his principle is right. He just has miscalculated in his equation. But I get along great with Charlie, so I'm sure that - as president, I look forward to working with him as chairman of the House Ways and Means Committee to get things done for families of America. (APPLAUSE) BLITZER: I'll move on to the next question from Suzanne unless either of you want to make a comment. Suzanne. MALVEAUX: It's kind of related to Senator Edwards. I've spoken with a lot of African American voters in South Carolina this week, and a lot of them say that electing a black president, that this would change the way whites see African Americans and the way African Americans see themselves. Do you think that this is a valid consideration for voters in determining who's president? EDWARDS: Well, first of all, I don't think it's for me to tell anybody, and particularly not African Americans, what they should consider when they're voting. I think they ought to be able to consider anything that they think is fair and reasonable and important to them. What I would say, though, is on the issue, since we are here on Dr. King's day, on the issues of equality, ending poverty in America, the things that he devoted so much of his life to, no one has been -- and with all respect to the two other candidates, no one has been more aggressive on these issues than I have. I mean, ending poverty is the cause, the single most important cause in my life. I'm not suggesting for a minute the two of them haven't spoken about it, because they obviously have. But I have made it central to what I'm doing, central to my campaign and I have been trying to drive it in this campaign and welcome everything they have to say. I have a comprehensive set of ideas about how we end poverty in this country. I think it is a huge moral issue facing the United States of America, and it is an enormous issue facing the African American community. If you're black, you're much more likely to be poor, you're much less likely to have health care coverage. That community is hurt worse by poverty than any community in America. And it's our responsibility, not just for the African American community, but for America, as a nation, to take on this moral challenge, to try as best we can to walk in the shadow of Dr. King and try to make certain that we take this cause on, and I intend to do it. It will be central to the work that I do as president of the United States, ending poverty in America. BLITZER: Let's let Senator Clinton respond, and then Senator Obama. CLINTON: Well, I respect John's commitment to ending poverty. That's why, 35 years ago, when I graduated from law school, I didn't go to work for a law firm. I went to work for Marian Wright Edelman at the Children's Defense Fund, because ending poverty - particularly ending poverty for children, has been the central core cause of everything that I've been doing for 35 years. I care deeply about what for me is a mission and it does infuse everything that I do and why I'm in public office and why before I was in public service, chairing the Legal Services Corporation so that people got free legal aid when they would otherwise be put out of the courthouse, standing up time and time again for health care and education for abused and neglected kids and kids in the foster care system. But I think that what we want to do is have a little reality check here, because how is it best to end poverty? We know we've got to maintain programs that are there to help people in need, but look at what's happened over the space of the last seven years. The average African American family has lost $2,600 in income. Compare that to the prior eight years, when we had a president who took on the fights of the '90s and stood up against the Republicans, often at great cost. And the typical African American family went up $7,600 during the 1990s. We know we've got to attack poverty by making sure the economy works for everybody. We have to lift up the idea of good jobs with good benefits, and I think that we know what we need to do. And if we have a president who is willing from day one to make it a mission to create shared prosperity again, that's going to be good for every American. And that's what I'm going to offer as president. That's what I've been talking about, that's what I've been working for and that's what I intend to do. And I think we can get results for every American. BLITZER: Senator? OBAMA: Well, I think John has run a terrific campaign and has focused on poverty during the campaign. But, John, I have to say, first of all, I have put forward a comprehensive poverty plan that talks about early childhood education, health care for children, dealing with ex-offenders. And I'll be, you know, happy to share it with you. I know that you don't have time to read all my stuff, just as I don't have time to read yours. But understand this. I haven't just been talking about... EDWARDS: Maybe I can read it when I can't go to sleep at night. OBAMA: Well, there you go. (LAUGHTER) That's when I usually read my stuff, actually. But I think it's important. It's not just talking about it during a campaign. You know, as I said, I started my career after college working in low-income neighborhoods, working in public housing projects, talking to children who would tell me that, when I asked them, "What do you want to be when you grow up?" They say, "I want to be a doctor," or, "I want to be a lawyer," had the same aspirations as every other child, but they were three, four grade levels behind. And nobody had told them that the likelihood of them accomplishing their goals were each year diminished because we weren't putting the money in to make sure that they could actually achieve it. And that's what I did as a civil rights attorney. That's what I did as a state legislator, providing health care for people who didn't have it, making sure that we are providing tax relief to those who need it, as opposed to those who don't. So I want to make clear, John, that I think a lifetime commitment is how people are going to have to measure these issues. One last point I want to make, because I think the media, you know, has really been focused a lot on race as we move down to South Carolina. And I have to say that, as I travel around South Carolina, I am absolutely convinced that white, black, Latino, Asian, people want to move beyond our divisions, and they want to join together... (APPLAUSE) ... in order to create a movement for change in this country. And, I mean, I'm not entirely faulting the media because, look, race is a factor in our society. There's no doubt that in a race where you've got an African-American, and a woman, and John... (LAUGHTER) ... there's no doubt that that has piqued interest, but I guess what I'm saying is I don't want to sell the American people short. They are desperate to move beyond the same, old arguments that we've been having and start actually getting something done in this country. And that's what the Democratic Party has been about. (APPLAUSE) The Republicans may have a different attitude, because they haven't been appearing before forums that are diverse. And the policies, frankly, that they've promoted -- and here I think all three of us agree -- the policies that they have promoted have not been good at providing ladders for upward mobility and opportunity for all people. That is a fight that all of us will fight. But I don't want us to get drawn into this notion that somehow this is going to be a race that splits along racial lines. BLITZER: Senator Edwards? EDWARDS: Well, first of all, before I ever was involved in politics at all, I was involved with Urban Ministries in North Carolina, which is a group that takes care of the poorest of the poor, the homeless, the people who are struggling. There are a lot of Americans -- I've bet some people here won't know this -- but I've been in a fight with Bill O'Reilly -- that's a fight I'd love to be in, by the way -- I've been in a fight with Bill O'Reilly about whether we, in fact, have 200,000 men and women who wore our uniform who are homeless every single night. They are. There's absolutely no question about that. And anybody in this audience who's paying attention knows it. But what I worry about is all the work that I've done at the poverty center that I started at the university, the work I did before I got involved in politics, all the substantive ideas, what I worry about is this starts to sound like a statistic. You know, we talk about 37 million Americans who live in poverty -- that's more than the population of California -- in the richest nation on the planet. I've been to hundreds of places around this country who take care of the poorest of the poor, extraordinary, wonderful places. But I'll never forget, just a year or so ago, I was with a woman in Kansas City who told me the story -- worked full-time, worked full-time. She had several children. Every night in the winter, she could not pay both her heating bill and her rent. She had to choose. Single mom, working full-time, she had to put her kids in all of their winter clothing, in their coats, bundle them up in the bed together, put as many blankets on top of them as she could. And she'd get them out of bed in the morning and send them off to school. And the last thing she would say to them? "Please, for goodness's sakes, don't tell anybody at school what's happening here, because they'll come and take you away from me." EDWARDS: No mother in America should have to live like that. We are a better country than that. (APPLAUSE) BLITZER: Joe Johns. JOHNS: Senator Obama, appreciating what you said about the media's preoccupation with race, there is... OBAMA: Here we go. JOHNS: Right. The Nobel Prize-winning African-American author, Toni Morrison, famously observed about Bill Clinton, "This is our first black president, blacker than any actual black person who could ever be elected in our children's lifetime." Do you think Bill Clinton was our first black president? (LAUGHTER) OBAMA: Well, I think Bill Clinton did have an enormous affinity with the African-American community, and still does. And I think that's well earned. Like John, one of the things that I'm always inspired by -- no, I'm -- this I'm serious about. I'm always inspired by young men and women who grew up in the South when segregation was still taking place, when, you know, the transformations that are still incomplete but at least had begun had not yet begun. And to see that transformation in their own lives I think that is powerful, and it is hopeful, because what it indicates is that people can change. And each successive generation can, you know, create a different vision of how, you know, we have to treat each other. And I think Bill Clinton embodies that. I think he deserves credit for that. Now, I haven't... (APPLAUSE) OBAMA: I have to say that, you know, I would have to, you know, investigate more of Bill's dancing abilities. (LAUGHTER) OBAMA: You know, and some of this other stuff before I accurately judge whether he was in fact a brother. But... (APPLAUSE) BLITZER: Let's let Senator Clinton weigh in on that. CLINTON: Well, I'm sure that can be arranged. (LAUGHTER) CLINTON: You know, I want to echo what Barack has said and what each of us has said repeatedly over the last days. You know, this campaign is obviously an incredible opportunity for so many people to become involved, to be part of making history. You have got a son of the South. You've got an African-American. You have a woman. What better way to celebrate the legacy of Dr. King than to look at this stage right here tonight? (APPLAUSE) CLINTON: And, you know, I'm reminded of one of my heroes, Frederick Douglas, who had on the masthead of his newspaper in upstate New York, "The North Star," that right has no sex and truth has no color. And that is really the profound message of Dr. King. You know, the content of our character, who we are as people. And I think that my pride in being part of this campaign -- now, look, it's a hard-fought campaign. We have differences, but it would be unbecoming of any of us to not share those differences and to make the points we're making because we are competing for the most important job in the world at a time when our country has been disgraced abroad, when we have denied and ignored the problems that are afflicting people in South Carolina and across America, when we know we will inherit a huge amount of damage from President Bush upon taking office on January 20th, 2009, whoever the next president is. So we are passionate about our cause, our candidacy, what we believe, what we want to do for America. And it is a great privilege for me to be part of this. And I think it's important that we stay focused on the future, what we are going to do together to make our country once again what it should be, to deal with this myriad of problems that await, because we can bring our country together and we can set big goals again. We can start acting like Americans and solve those problems together, and that's what I want to do. (APPLAUSE) OBAMA: And I have to say, Wolf, that I especially appreciate the fact that Hillary and John were giving me a tough time, because that shows I'm doing pretty good. (APPLAUSE) I would be upset if there was too much civility in this debate, because it is competitive. One last point I want to make about this, though, and John alluded to it on the poverty issue. The one thing we -- when I say we should not focus on my race or Hillary's gender in terms of choosing a candidate, that is not to say that we should be ignoring the very real problems that still exist in terms of race in America. (APPLAUSE) So for example, if we know that in our criminal justice system, African-Americans and whites, for the same crime, receive - are arrested at very different rates, are convicted at very different rates, receive very different sentences. (APPLAUSE) That is something that we have to talk about. But that's a substantive issue and it has to do with how do we pursue racial justice. If I am president, I will have a civil rights division that is working with local law enforcement so that they are enforcing laws fairly and justly. But I would expect... (APPLAUSE) ... a white president or a woman president should want to do the same thing, because I believe that the pursuit of racial equality, of the perfection of this union, is not just a particular special interest issue of the African-American community. That is how all of us are going to move forward. And to the extent that we don't deal with those issues, those longstanding, deep seeded issues, we will continue to be hampered. We will be competing with the world with one hand tied behind our backs. CLINTON: And, you know, Wolf, the... (APPLAUSE) ... the challenge is for us to address all of these issues. We obviously still have problems of gender equality. You know, equal pay is not yet equal. (APPLAUSE) A woman makes $0.77 on a dollar and women of color make $0.67. So there is a big agenda waiting for the Democratic Party. And we feel so passionately about this because we not only are running for office, but we each, in our own way, have lived it. We have seen it. We have understood the pain and the injustice that has come because of race, because of gender. And it's imperative that, as we move forward with our campaign, we make it very clear that each of us will address these issues. You don't hear the Republicans talking about any of this. You don't hear them talking about the disgrace of a criminal justice system that incarcerates so many more African-Americans proportionately than whites. You don't hear any kind of effort to help historically Black Colleges and Universities, something that I'm committed to doing in order to... (APPLAUSE) ... make it clear that these are important institutions that have led the way for so many great leaders to be where they are today. So we have a specific set of policies and priorities that are really part of who we are, as well as part of what the Democratic Party stands for. BLITZER: I'm going to let the son of the south wrap this subject up and then we'll move on to Suzanne. EDWARDS: Well, I appreciate what both of them said about the transformative effect of having lived with this. I mean, I grew up, I was born here in South Carolina, grew up in South Carolina, Georgia and North Carolina, and, in my early years, I lived in the segregated south. I mean, I saw up close the impact it had on people's lives and I saw up close the blood, sweat and tears and lives of those, including some people who are in this audience tonight, what they went through to bring about this change. And there is a great deal -- Hillary says the Republicans don't talk about it. There's some things we don't talk about, either, and if you look at what's... (APPLAUSE) ... if you look at what's happening, my father, who, I mentioned earlier, is sitting in the audience, he raised me to believe that the men and women who worked in the mill with him were worth every bit as much as the man that owned that mill. (APPLAUSE) And if we really believe that every American is of equal value, no matter who their family is, where the live or what the color of their skin -- when are we going to start living together? Because you look at what's happening -- I announced my campaign from the ninth ward of New Orleans. I think a lot of America was shocked to see those pictures coming out of the ninth ward. And you can't pick on New Orleans. The same thing's true in many communities all over this country. I mean, we have got to -- both in housing policy and economic policy and every other way -- create the kind of opportunity for people to be able to move. It shouldn't just be that rich folks are able to, if they don't like their neighborhood or don't like their school or are worried about crime in their neighborhood, they're the only ones that can go somewhere else. Everybody in America ought to have that chance, at the same time that we're investing in a serious way to improving all of our neighborhoods. BLITZER: Suzanne Malveaux? (APPLAUSE) MALVEAUX: To Senator Clinton. In New Hampshire, you said you found your own voice, but increasingly there are people who believe that it's your husband's voice that has become too loud. MALVEAUX: Congressman Clyburn earlier said today, "I think he can afford to tone it down." Is there a risk that he is overshadowing your message and your voice? CLINTON: Well, I think that he is very much advocating on my behalf, and I appreciate that. He is a tremendous asset. And he feels very strongly about this country and what's at stake and what out future should be. I believe that this campaign is not about our spouses. It is about us. It is about each of us individually. Michelle and Elizabeth are strong and staunch advocates for their husbands, and I respect that. But, at the end of the day, voters are going to have to choose among us, and I think it's fair to say that really the most important decision is who would be the best president on day one, to deal with all the problems that we know are waiting for our next president? And the subsidiary question is, who can best withstand the Republicans and all that we know is coming from them in order to win in November 2008? I believe strongly that I can make the best case for that. Obviously, my colleagues believe just as strongly. So I think that we need to keep our focus on what's at stake in the election, what the future holds, what each of us will bring to this campaign and the presidency, because ultimately it's really not about any of us. It's about the people of South Carolina. It's about the people of America. And my voice is their voice. What I want to do is take not only my 35 years of experience into the White House, but I want to take all those voices of these extraordinary Americans who come up to me and tell me their stories and give me hope and inspiration that I can do something for them. Because that's what it's about for me. Politics is not a game. It is the most serious of business. We have seen that over the last seven years. We have seen what a difference it makes when we have a president who is indifferent to and insensitive about the real-life struggles of Americans, and I want to be the champion that once again gives Americans the feeling that they have a president who cares about them and can produce results for them. And that's what I intend to do. BLITZER: I'm going to let both of the other senators respond. Then we'll take a quick break. Go ahead, Senator Obama. OBAMA: Well, Hillary's right. All of us have extraordinarily smart and effective advocates in our spouses. And, as I've said before, I do not at all begrudge -- I would expect that Bill Clinton would campaign vigorously on your behalf. Obviously, he's the ex-president, so that means that the gets a lot of outsized attention and there's nothing long with that. That's, as you said, an asset to the campaign. I have been troubled, and we already had this discussion, so I don't want to go over it again, the degree to which my record is not accurately portrayed. But that's standard practice in some of our political battles. What I do want to focus on, though, is how important it is, when you talked about taking on the Republicans, how important it is I think to redraw the political map in this country. And the reason I say that is that we have gone through the 2000 election, the 2004 election, both of which were disappointing elections. But the truth is that we as Democrats have not had a working majority in a very long time. And what I mean by that is a working majority that could push through the kinds of bold initiatives that all of us have proposed. And one of the reasons that I am running for president is because I believe that I can inspire new people to get involved in the process, that I can reach out to independents and, yes, some Republicans who have also lost trust in their government and want to see something new. When you look at Bush and Cheney and their record, the one good thing they've done for us is they have given their party a very bad name. (APPLAUSE) That gives us a unique opportunity in this election, and what we can't do, I think, is just to take the playing field as a given. We want to expand the scope of the electorate so that we can start getting a 60 percent majority, more folks in the House, more folks in the Senate, and I think that's something I can do. OBAMA: And that's why we've seen record turnout in every election so far. I'm not taking all the credit for it. I think people are voting against George Bush. But I also think that we've inspired people who had not previously voted before, and that's what the Democratic Party has to do. BLITZER: Senator Edwards? EDWARDS: I would just add on it's just really important for primary voters in South Carolina and all the other subsequent primaries to understand they're not just voting in a primary. They're voting to establish what we're going to be doing next November and who our candidate will be next November. And it's becoming increasingly likely, I think, that John McCain is going to be the Republican candidate. Now, here's what we have to be thinking about. Who will be tough enough and strong enough? And who can compete against John McCain in every place in America? You know, I believe that I won't just be here campaigning in the South Carolina primary. When I'm the Democratic nominee, I'll be back in South Carolina campaigning for the general election. And we can't concede places like South Carolina, North Carolina, Georgia, Missouri, all these places around America where we know, everyone knows, that we always do well -- all three of us have been through this -- we always do well in Chicago, or New York, or Los Angeles, Seattle. We do well in the big urban areas. The question is: Are we competitive in the rural areas, in the tougher places for Democrats to compete? And the only thing I would say -- and I think it has nothing to do with race and gender. Let me be really clear about that. It's amazing now that being the white male... OBAMA: You're feeling all defensive about it, John. It's all right, man. EDWARDS: ... is different. What I was going to say, though, is being able to go everywhere in America and campaign and to compete -- and I grew up in the rural south, in small towns all across the rural south, and I think I can go everywhere and compete head-to-head with John McCain. And, actually, the last time I saw one of your polls that had all three of us against John McCain, I was the one that beat John McCain everywhere in America. (APPLAUSE) And I think we need to be able to have a candidate when people are voting -- it's not the only consideration. Lord knows, if you don't agree with what we stand for, and you don't believe in us, our character and our ability to lead this country, you should not vote for us, no matter what it means for the general election. But if you believe in our passion, our strength, our toughness, our independence from these special interests -- I've never taken money from a Washington lobbyist or a special interest PAC, which is different than these two guys, over our whole career. But what I would say that I think what that means is I can go anywhere in America and compete against John McCain and win. BLITZER: We have to take a quick break, but we have a lot more to talk about, much more of this presidential debate here in Myrtle Beach, South Carolina, when we come back. (COMMERCIAL BREAK) OBAMA: ... where in northern Nevada, in places like Elko, I won by 30 points. And we were attracting Independents and some Republicans. You know, this is the same way that I was able to win the election in Illinois, going to downstate Illinois. So, I think it's important for us not to assume that we can't reach out to people of all -- of all persuasions, and I want to just take one last example on this, and that is on the issue of faith. OBAMA: You know, I am a proud Christian. And the... (APPLAUSE) I think there have been times -- there have been times where our Democratic Party did not reach out as aggressively as we could to evangelicals, for example, because the assumption was, well, they don't agree with us on choice, or they don't agree with us on gay rights, and so we just shouldn't show up. And when you don't show up, if you're not going to church, then you're not talking to church folk. And that means that people have a very right-wing perspective in terms of what faith means and of defining our faith. BLITZER: All right. OBAMA: And as somebody who believes deeply in the precepts of Jesus Christ, particularly treating the least of these in a way that he would, that it is important for us to not concede that ground. Because I think we can go after those folks and get them. (APPLAUSE) BLITZER: All right. Suzanne has a question on faith to all of you. CLINTON: But Wolf... BLITZER: Hold... CLINTON: ... let me just get in here, because there are a lot of polls showing that I'm beating them higher than anybody else. I don't think that has -- I don't think, frankly, that has much to recommend this far from an election. If John is right and Senator McCain is the Republican nominee, we know that once again we will have a general election about national security. That is what will happen. I believe of any one of us, I am better positioned and better able to take on John McCain or any Republican when it comes to issues about protecting and defending our country and promoting our interest in the world. And if it is indeed the classic Republican campaign, I've been there. I've done that. They've been after me for 16 years, and much to their dismay I am still here. And I intend to be still here when that election comes around and we win in November 2008. (APPLAUSE) EDWARDS: I just want to add that I think it's about -- I don't think it's about polls either, Hillary, by the way. But I do think it is about fundamental differences between us and them. And this is a difference that you and I have. You know, I think that John McCain has made central to his time in public life, in his campaign, campaign finance reform and cleaning up the money in politics. And I think it's dangerous for us to send somebody against him who presents a contrast to what he represents. And I'm proud of the fact that I've never taken money from a Washington lobbyist or a special interest PAC. EDWARDS: And I have a question -- I have a question that I'm interested in hearing you respond to. You've talked a lot about day one. I've committed -- I don't know what Barack has said about this -- but I've committed not to have any corporate lobbyists working in my White House on the first day that I'm president. Will you make the same commitment? CLINTON: Well, you know, John, I will make the commitment to have people in the White House who are honest and trustworthy and put the interests of the United States first. But I think... EDWARDS: Is that a no? CLINTON: You know what? I don't know. (LAUGHTER) I don't know, because I'm not in favor of corporate lobbyists, but you keep drawing these artificial distinctions. You take money from people who employ lobbyists, who are married to lobbyists, who are the children of lobbyists. And, you know, at some point this gets really hard to take, because if you are someone like I am, who has withstood the full force of corporate lobbyists, starting with the health insurance companies, and the drug companies, and the oil companies, and everybody that I've taken on for all of these years, you know, I think I'm independent and tough enough to be able to deal with anybody. And that's what I intend to do. (APPLAUSE) EDWARDS: Those people, though -- here's the problem, Hillary. Everybody is listening. They can make their own judgment about this. They don't have to depend on us. When somebody gives you millions and millions of dollars, I think they expect something. I don't think they're doing it for nothing. CLINTON: Well, John, trial lawyers have given you millions and millions of dollars. So... EDWARDS: And what they expect from me is they expect me to stand up for democracy, for the right to jury trial, for the right for little people to be heard in the courtroom. And that is exactly what I stand up for. That is not the same thing. That is not the same thing as corporate lobbyists who are in there every single day lobbying against the interests of middle-class Americans. And I think we need a president who can stand up. We have a difference about this. You're entitled to your view. But we have a real difference about it. CLINTON: No, we don't have a real difference. Where we stand is -- where I stand is for public financing. I'm going to do everything I can to get public financing, to get the money out of American politics. But, you know, Barack has a lot of lobbyists who are leading his campaign here in South Carolina. John has had lobbyists who've been working hard for him all of these years. The point is that you've got to say no. You've got to say no. OBAMA: Let me interject. CLINTON: And, yes, I think that we will say no consistently in order to have a positive agenda that is actually going to make a difference. Do you have to stand up to the lobbyists? Yes. But the lobbyists represent the interests that are paying the lobbyists. So to go and focus on the lobbyists, you know, kind of misses the point. OBAMA: Let me just interject on this. Hillary, you're right. Nobody's hands are perfectly clean in politics. That is true. I mean, there a distinction, though, between not taking PAC and federal lobbyist money and having that as a major way of driving your campaign and having some ancillary involvement. But, you know, I don't want to go down that route. What I want to really focus on is this issue of national security, because I think you've repeated this a number of times. You are the person best prepared on national security issues on day one, and so if you're running against John McCain, that you can go toe-to-toe. I fundamentally disagree with that. And I want to tell you why, because I believe that the way we are going to take on somebody like a John McCain on national security is not that we're sort of -- we've been sort of like John McCain, but not completely, you know, we voted for the war, but we had reservations. I think it's going to be somebody who can serve a strong contrast and say, "We've got to overcome the politics of fear in this country." As commander-in-chief... (APPLAUSE) As commander-in-chief, all of us would have a responsibility to keep the American people safe. That's our first responsibility. And I would not hesitate to strike against anybody who would do Americans or American interests' harm. But what I do believe... BLITZER: All right. OBAMA: Wait, Wolf, let me finish. I was listening to these folks quite some time. What I do believe is that we have to describe a new foreign policy that says, for example, I will meet not just with our friends, but with our enemies, because I remember what John F. Kennedy said, that we should never negotiate out of fear, but we should never fear to negotiate. Having that kind of posture is the way I think we effectively debate the Republicans on this issue. Because if we just play into the same fear-mongering that they have been engaged in since 9/11, then we are playing on their battlefield, but, more importantly, we are not doing what's right in order to rebuild our alliances, repair our relationships around the world, and actually make us more safe in the long term. EDWARDS: And it requires that -- wait, wait. Both of them talked about it. You've got to let me say a word. BLITZER: All right, 30 seconds, please. EDWARDS: What it requires is having something beyond a short- term foreign policy of convenience. I mean, Bush has done extraordinary damage to us. EDWARDS: But if we have a visionary foreign policy, where we re- establish America as a moral leader in the world, where we do the things that we need to do to combat global poverty, to deal with the spread of HIV/AIDS, the spread of disease at large, economic development, what it does is it takes an entire generation of young people who are sitting on the fence as I speak and on one side is Al Qaida and Bin Laden, Islamic jihad, and on the other side is the United States of America, which way do they go? That depends entirely on us. If they continue to see this foreign policy of belligerence, selfishness, only interested in the expansion of American power, we will drive them in the other direction. If, on the other hand, they see America as the light, the source of hope and opportunity, it will pull them to us like a magnet. We need to be that light again. (APPLAUSE) BLITZER: Thank you, Senator. We are completely out of time, but we have time for one final question that I'd like to ask all three of you to respond and, if possible, within one minute or less, and it's an important question on this important day. And, Senator Edwards, let me start with you. If Dr. Martin Luther King were alive today, unfortunately, he's not, but if he were alive today, why do you think he would or why should he endorse you? EDWARDS: For two reasons. One is that -- we've talked about this a great deal already -- I met with Martin III in Atlanta on Saturday and he was very kind about me pushing the single biggest issue -- two biggest issues that Dr. King stood for, which are the issues of equality and ending poverty in America. I've been on at least part of his poor people's campaign. I was in Marks, Mississippi, among other places. I mean, I have been pushing this issue as aggressively and as loudly as I possibly can and I will do it as long as I'm alive, because it is central to what I believe. He also worked very hard for the Voting Rights Act and he would look at an America today where almost half of our people don't vote. They're disenchanted. They -- Barack's spoken about this. They feel disengaged. And what we need is a president of the United States who actually believes to their core in equality, who's willing to fight for that equality, who's willing to do things that may not be politically popular. And fighting to end poverty in America may not get you any votes, but it is the right thing to do. (APPLAUSE) BLITZER: Senator? OBAMA: Well, I don't think Dr. King would endorse any of us. I think what he would call upon the American people to do is to hold us accountable, and this goes to the core differences, I think, in this campaign. I believe change does not happen from the top down. It happens from the bottom up. Dr. King understood that. (APPLAUSE) It was those women who were willing to walk instead of ride the bus, union workers who are willing to take on violence and intimidation to get the right to organize. It was women who decided, "I'm as smart as my husband. I'd better get the right to vote." OBAMA: them arguing, mobilizing, agitating, and ultimately forcing elected officials to be accountable, I think that's the key. So that has been a hallmark of my career, transparency and accountability, getting the American people involved. That's how we're going to bring about change. That's why I want to be president of the United States, to respect the power of the American people to bring about change. (APPLAUSE) BLITZER: Senator Clinton? CLINTON: Well, there is no doubt that change comes from the extraordinary efforts of the American people. I've seen it in my life. I'm sitting here as a result of that change. It is also true -- and Dr. King understood this. He campaigned for political leaders. He lobbied them. He pushed them. He cajoled. He did everything he could to get them over the line so that they would be part of the movement that he gave his life for. There are people sitting in this audience right now, John Lewis, Jim Clyburn, they were part of those kinds of efforts, going so far as they could to make it clear that we had to live up to our values and our ideals. And then there was a meeting of morality and politics. And the political leaders finally responded. The American people should not have to work so hard to get leaders who will actually help them and recognize we are strongest when we lead by our values. Dr. King transformed the lives of so many of us, and I intend to do whatever I can to make his legacy real in the lives of Americans. BLITZER: Senators, that ends our debate. Thank you so very much. Thanks to all of you.
